/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.model.AttachmentsUpdateCommentModel;
import de.viadee.confluence.enterprisecore.rest.AttachmentsResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/attachments")
@AnonymousSiteAccess
public class AttachmentsController {
    private final AttachmentsResource attachmentsResource;
    private final AuthValidator authValidator;

    @Inject
    public AttachmentsController(AttachmentsResource attachmentsResource, AuthValidator authValidator) {
        this.attachmentsResource = attachmentsResource;
        this.authValidator = authValidator;
    }

    @GET
    @Path(value="/versionData/{pageId}/{diagramNameWithType}/{version}/{attachmentId}")
    @Produces(value={"application/json"})
    public Response getAttachmentVersionData(@Context HttpServletRequest request, @PathParam(value="diagramNameWithType") String diagramNameWithType, @PathParam(value="pageId") Long pageId, @PathParam(value="version") int version, @PathParam(value="attachmentId") String attachmentId) {
        this.authValidator.createContext(request).checkAuthentication().checkAttachmentPermission(pageId.longValue(), diagramNameWithType, version, Permission.VIEW);
        return this.attachmentsResource.getAttachmentVersionData(diagramNameWithType, pageId, version, attachmentId);
    }

    @POST
    @Path(value="/comment/update/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateAttachmentComment(@Context HttpServletRequest request, AttachmentsUpdateCommentModel attachmentsUpdateCommentModel) {
        this.authValidator.createContext(request).checkAuthentication().checkAttachmentPermission(attachmentsUpdateCommentModel.getPageId().longValue(), attachmentsUpdateCommentModel.getAttachmentName(), Permission.EDIT);
        return this.attachmentsResource.updateAttachmentComment(attachmentsUpdateCommentModel);
    }
}

