/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.model.ConfigurationModel;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.model.MacroNameEnum;
import de.viadee.confluence.enterprisecore.rest.ConfigurationResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/config")
@AnonymousAllowed
@AnonymousSiteAccess
public class ConfigurationController {
    private final ConfigurationResource configurationResource;
    private final AuthValidator authValidator;
    private final MacroNameEnum macroName;

    @Inject
    public ConfigurationController(ConfigurationResource configurationResource, AuthValidator authValidator, IPluginService pluginService) {
        this.configurationResource = configurationResource;
        this.authValidator = authValidator;
        this.macroName = pluginService.getMacroName();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getGlobalConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkAuthentication();
        return this.configurationResource.getGlobalConfig();
    }

    @GET
    @Path(value="/{pageId}/{vbcpEntId}/")
    @Produces(value={"application/json"})
    public Response getDiagramConfig(@Context HttpServletRequest request, @PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId) {
        this.authValidator.createContext(request).checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        return this.configurationResource.getDiagramConfig(this.macroName, pageId, vbcpEntId);
    }

    @POST
    @Path(value="/{pageId}/{vbcpEntId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setDiagramConfig(@Context HttpServletRequest request, @PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId, ConfigurationModel newConfigs) {
        this.authValidator.createContext(request).checkPagePermission(Long.parseLong(pageId), Permission.EDIT);
        return this.configurationResource.updateAllConfigs(pageId, vbcpEntId, this.macroName, newConfigs);
    }
}

