/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.model.DateAndTimeModel;
import de.viadee.confluence.enterprisecore.model.UserPropertyDto;
import de.viadee.confluence.enterprisecore.model.UserPropertyEnum;
import de.viadee.confluence.enterprisecore.rest.UserPropertiesResource;
import de.viadee.confluence.enterprisecore.service.SerializationService;
import de.viadee.confluence.enterprisecore.service.UserPropertiesService;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/user")
@AnonymousSiteAccess
public class UserPropertiesController {
    private final UserPropertiesResource userPropertiesResource;

    @Inject
    public UserPropertiesController(UserPropertiesService userPropertiesService, SerializationService serializationService) {
        this.userPropertiesResource = new UserPropertiesResource(userPropertiesService, serializationService);
    }

    @PUT
    @Path(value="/setShowWelcomeScreen")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateShowWelcomeScreen(UserPropertyDto<Boolean> showWelcomeScreen) {
        return this.userPropertiesResource.updateShowWelcomeScreen(((Boolean)showWelcomeScreen.getValue()).booleanValue());
    }

    @PUT
    @Path(value="/uxInfoScreen")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateUxInfoScreen(UserPropertyDto<Boolean> showUxInfoScreen) {
        return this.userPropertiesResource.updateUxInfoScreen(((Boolean)showUxInfoScreen.getValue()).booleanValue());
    }

    @PUT
    @Path(value="/lastNewsSeenDate")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateLastNewsSeenDate(UserPropertyDto<DateAndTimeModel> lastNewsSeenDate) {
        return this.userPropertiesResource.updateLastNewsSeenDate((DateAndTimeModel)lastNewsSeenDate.getValue());
    }

    @PUT
    @Path(value="/isMinimapOpen")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateIsMinimapOpenValue(UserPropertyDto<Boolean> isMinimapOpen) {
        return this.userPropertiesResource.updateIsMinimapOpen(((Boolean)isMinimapOpen.getValue()).booleanValue());
    }

    @PUT
    @Path(value="/isAttributePanelOpen")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateIsAttributePanelOpenValue(UserPropertyDto<Boolean> isAttributePanelOpen) {
        return this.userPropertiesResource.updateIsAttributePanelOpen(((Boolean)isAttributePanelOpen.getValue()).booleanValue());
    }

    @DELETE
    @Path(value="/{userId}/{propertyKey}")
    @Produces(value={"application/json"})
    public Response deletePropertyForUser(@PathParam(value="userId") String userId, @PathParam(value="propertyKey") UserPropertyEnum propertyKey) {
        return this.userPropertiesResource.deleteAnyProperty(String.valueOf(propertyKey));
    }

    @DELETE
    @Path(value="/gitlab")
    @Produces(value={"application/json"})
    public Response deleteAllGitlabPropertyForUser() {
        return this.userPropertiesResource.deleteAllGitlabPropertyForUser();
    }

    @GET
    @Path(value="/{userId}/{propertyKey}")
    @Produces(value={"application/json"})
    public Response getPropertyForUser(@PathParam(value="userId") String userId, @PathParam(value="propertyKey") UserPropertyEnum propertyKey) {
        return this.userPropertiesResource.getAnyProperty(String.valueOf(propertyKey));
    }
}

