/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.rest.AttachmentHandlerResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/attachmenthandler")
@AnonymousSiteAccess
public class AttachmentHandlerController {
    private final AttachmentHandlerResource attachmentHandlerResource;
    private final AuthValidator authValidator;

    @Inject
    public AttachmentHandlerController(AttachmentHandlerResource attachmentHandlerResource, AuthValidator authValidator) {
        this.attachmentHandlerResource = attachmentHandlerResource;
        this.authValidator = authValidator;
    }

    @GET
    @Path(value="/rename")
    @Produces(value={"application/json"})
    public Response renameAttachment(@Context HttpServletRequest request, @QueryParam(value="pageId") String pageId, @QueryParam(value="attachmentName") String attachmentName, @QueryParam(value="newAttachmentName") String newAttachmentName) {
        this.authValidator.createContext(request).checkAuthentication().checkAttachmentPermission(Long.parseLong(pageId), attachmentName, Permission.EDIT);
        return this.attachmentHandlerResource.renameAttachment(pageId, attachmentName, newAttachmentName);
    }
}

