/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.ViewAppConfigResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/viewConfig")
@AnonymousAllowed
@AnonymousSiteAccess
public class ViewAppConfigController {
    private final ViewAppConfigResource viewAppConfigResource;
    private final AuthValidator authValidator;

    @Inject
    public ViewAppConfigController(ViewAppConfigResource viewAppConfigResource, AuthValidator authValidator) {
        this.viewAppConfigResource = viewAppConfigResource;
        this.authValidator = authValidator;
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.ViewConfig config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.viewAppConfigResource.putConfig(config);
    }
}

