/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.LinkAppConfigResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/linkConfig")
@AnonymousSiteAccess
public class LinkAppConfigController {
    private final LinkAppConfigResource linkAppConfigResource;
    private final AuthValidator authValidator;

    @Inject
    public LinkAppConfigController(LinkAppConfigResource linkAppConfigResource, AuthValidator authValidator) {
        this.linkAppConfigResource = linkAppConfigResource;
        this.authValidator = authValidator;
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.LinkConfig config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.linkAppConfigResource.putConfig(config);
    }
}

