/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import de.viadee.confluence.enterprisecore.action.PreviewActionService;
import de.viadee.confluence.enterprisecore.model.Nonce;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
public final class DiagramPreviewAction
extends ConfluenceActionSupport {
    private static final String pluginKey = "de.viadee.confluence.dmn-plugin-enterprise";
    private static final String appFlag = "DMN";
    private static final String webResourceKey = "de.viadee.confluence.dmn-plugin-enterprise.preview";
    private final transient PreviewActionService previewActionService;
    private String cspNonce;
    private String pageId;
    private String licenseType;
    private String vbcpEntId;
    private String shownVersion;
    private boolean canEditPage;

    public String execute() {
        HttpServletRequest request = this.getActiveRequest();
        if (request == null) {
            return "error";
        }
        this.previewActionService.execute(request);
        this.cspNonce = new Nonce(request).getValue();
        this.pageId = this.previewActionService.getPageId();
        this.vbcpEntId = this.previewActionService.getVbcpEntId();
        this.canEditPage = this.previewActionService.isCanEdit();
        this.licenseType = this.previewActionService.getLicenseType();
        this.shownVersion = this.previewActionService.getShownAttachmentVersion();
        return "success";
    }

    public String getVendorName() {
        PluginInformation info = this.getPluginInfo();
        if (info == null) {
            return "";
        }
        return StringUtils.defaultString((String)info.getVendorName());
    }

    public String getVendorUrl() {
        PluginInformation info = this.getPluginInfo();
        if (info == null) {
            return "";
        }
        return StringUtils.defaultString((String)info.getVendorUrl());
    }

    public String getPluginVersion() {
        PluginInformation info = this.getPluginInfo();
        if (info == null) {
            return "";
        }
        return StringUtils.defaultString((String)info.getVersion());
    }

    private PluginInformation getPluginInfo() {
        if (this.pluginAccessor == null) {
            return null;
        }
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            return null;
        }
        return plugin.getPluginInformation();
    }

    public String getAppFlag() {
        return appFlag;
    }

    public String getWebResourceKey() {
        return webResourceKey;
    }

    public String getPluginKey() {
        return pluginKey;
    }

    @Generated
    public DiagramPreviewAction(PreviewActionService previewActionService) {
        this.previewActionService = previewActionService;
    }

    @Generated
    public PreviewActionService getPreviewActionService() {
        return this.previewActionService;
    }

    @Generated
    public String getCspNonce() {
        return this.cspNonce;
    }

    @Generated
    public String getPageId() {
        return this.pageId;
    }

    @Generated
    public String getLicenseType() {
        return this.licenseType;
    }

    @Generated
    public String getVbcpEntId() {
        return this.vbcpEntId;
    }

    @Generated
    public String getShownVersion() {
        return this.shownVersion;
    }

    @Generated
    public boolean isCanEditPage() {
        return this.canEditPage;
    }
}

