/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.vcs.GitlabResource;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/gitlab")
@AnonymousAllowed
@AnonymousSiteAccess
public class GitlabController {
    private final GitlabResource gitlabResource;

    @Inject
    public GitlabController(GitlabResource gitlabResource) {
        this.gitlabResource = gitlabResource;
    }

    @GET
    @Path(value="/isConfigured")
    @Produces(value={"application/json"})
    public Response isGitlabConfigured() {
        return this.gitlabResource.isGitlabConfigured();
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) {
        return this.gitlabResource.getConfig(request);
    }

    @GET
    @Path(value="/config/{configKey}")
    @Produces(value={"application/json"})
    public Response getSingleConfig(@Context HttpServletRequest request, @PathParam(value="configKey") String configKey) {
        return this.gitlabResource.getSingleConfig(request, configKey);
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.Config config) {
        return this.gitlabResource.putConfig(request, config);
    }

    @DELETE
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response deleteConfig(@Context HttpServletRequest request) {
        return this.gitlabResource.deleteConfig(request);
    }

    @GET
    @Path(value="/oauth/test")
    @Produces(value={"text/plain"})
    public Response testOAuthLoginUrl() {
        return this.gitlabResource.getOAuthUserLoginUrl(true);
    }

    @GET
    @Path(value="/oauth")
    @Produces(value={"text/plain"})
    public Response getOAuthLoginUrl() {
        return this.gitlabResource.getOAuthUserLoginUrl(false);
    }

    @GET
    @Path(value="/oauth/redirect")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response endOAuthLogin(@QueryParam(value="code") String code, @QueryParam(value="state") String state) {
        return this.gitlabResource.endOAuthLogin(code, state);
    }

    @GET
    @Path(value="/projects")
    @Produces(value={"application/json"})
    public Response getGitLabProjects(@QueryParam(value="repoUrl") String repoUrl) {
        return this.gitlabResource.getGitLabProjects(repoUrl);
    }

    @GET
    @Path(value="/projectName")
    @Produces(value={"text/plain"})
    public Response getGitLabProjectNameByProjectId(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") String projectId) {
        return this.gitlabResource.getGitLabProjectNameByProjectId(repoUrl, projectId);
    }

    @GET
    @Path(value="/projects/search")
    @Produces(value={"application/json"})
    public Response getGitLabProjectsWithSearchString(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="containedString") String containedString) {
        return this.gitlabResource.getGitLabProjectsWithUrl(repoUrl, containedString);
    }

    @GET
    @Path(value="/branches")
    @Produces(value={"application/json"})
    public Response getGitLabBranches(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getGitLabBranches(repoUrl, projectId);
    }

    @GET
    @Path(value="/branch/files")
    @Produces(value={"application/json"})
    public Response getGitLabFilesInBranch(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="ref") String ref, @QueryParam(value="projectId") int projectId, @QueryParam(value="fileEnding") String fileEnding) {
        return this.gitlabResource.getGitLabFilesInBranch(repoUrl, ref, projectId, fileEnding);
    }

    @GET
    @Path(value="/tags")
    @Produces(value={"application/json"})
    public Response getGitLabTags(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getGitLabTags(repoUrl, projectId);
    }

    @GET
    @Path(value="/tag/files")
    @Produces(value={"application/json"})
    public Response getGitLabFilesOnTag(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="ref") String ref, @QueryParam(value="projectId") int projectId, @QueryParam(value="fileEnding") String fileEnding) {
        return this.gitlabResource.getGitLabFilesOnTag(repoUrl, ref, projectId, fileEnding);
    }

    @GET
    @Path(value="/commit")
    @Produces(value={"application/json"})
    public Response getGitLabCommit(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="ref") String ref, @QueryParam(value="filePath") String filePath, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getGitLabCommit(repoUrl, ref, filePath, projectId);
    }

    @GET
    @Path(value="/filename")
    @Produces(value={"text/plain"})
    public Response getGitLabFileName(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="filePath") String filePath, @QueryParam(value="ref") String ref, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getFileContent(repoUrl, filePath, ref, projectId);
    }

    @GET
    @Path(value="/fileContent")
    @Produces(value={"application/json"})
    public Response getGitLabFileContent(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="filePath") String filePath, @QueryParam(value="ref") String ref, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getFileContent(repoUrl, filePath, ref, projectId);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/branch/create")
    public Response createNewGitLabBranch(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId, @QueryParam(value="newBranch") String newBranchName, @QueryParam(value="ref") String refBranch) {
        return this.gitlabResource.createNewGitLabBranch(repoUrl, projectId, newBranchName, refBranch);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/update/file")
    public Response updateFileInBranch(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId, @QueryParam(value="ref") String refBranch, @QueryParam(value="filePath") String filePath, String body) {
        return this.gitlabResource.updateFileInBranch(repoUrl, projectId, refBranch, filePath, body);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/create/file")
    public Response createNewFile(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId, @QueryParam(value="ref") String refBranch, @QueryParam(value="filePath") String filePath, String body) {
        return this.gitlabResource.createNewFile(repoUrl, projectId, refBranch, filePath, body);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/new")
    public Response createNewMRinGitLab(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") String projectId, @QueryParam(value="parentRef") String parentRef, @QueryParam(value="ref") String childBranch, @QueryParam(value="title") String title) {
        return this.gitlabResource.createNewMRinGitLab(repoUrl, projectId, parentRef, childBranch, title);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/accept")
    public Response acceptMergeRequestById(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId, @QueryParam(value="iid") String iid) {
        return this.gitlabResource.acceptMergeRequestById(repoUrl, projectId, iid);
    }
}

