/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.BitbucketResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/bitbucket")
@AnonymousAllowed
@AnonymousSiteAccess
public class BitbucketController {
    private final BitbucketResource bitbucketResource;
    private final AuthValidator authValidator;

    @Inject
    public BitbucketController(BitbucketResource bitbucketResource, AuthValidator authValidator) {
        this.bitbucketResource = bitbucketResource;
        this.authValidator = authValidator;
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkAuthentication();
        return this.bitbucketResource.getConfig();
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.Config config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.bitbucketResource.putConfig(config);
    }

    @DELETE
    @Path(value="/config")
    public Response deleteConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.bitbucketResource.deleteConfig();
    }
}

