/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.BitbucketResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/bitbucket")
@AnonymousSiteAccess
public class BitbucketController {
    private final BitbucketResource bitbucketResource;
    private final AuthValidator authValidator;

    @Inject
    public BitbucketController(BitbucketResource bitbucketResource, AuthValidator authValidator) {
        this.bitbucketResource = bitbucketResource;
        this.authValidator = authValidator;
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkAuthentication();
        return this.bitbucketResource.getConfig();
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.Config config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.bitbucketResource.putConfig(config);
    }

    @DELETE
    @Path(value="/config")
    public Response deleteConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.bitbucketResource.deleteConfig();
    }
}

