/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import de.viadee.confluence.enterprisecore.model.NotificationModel;
import de.viadee.confluence.enterprisecore.rest.NotificationResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/notifications")
public class NotificationController {
    private static final String appType = "DMN";
    private final NotificationResource notificationResource;
    private final AuthValidator authValidator;

    @Inject
    public NotificationController(NotificationResource notificationResource, AuthValidator authValidator) {
        this.notificationResource = notificationResource;
        this.authValidator = authValidator;
    }

    @PUT
    @Path(value="/sendNotification")
    @Consumes(value={"application/json"})
    public Response sendNotification(@Context HttpServletRequest request, NotificationModel newNotification) {
        this.authValidator.createContext(request).checkAuthentication().checkDiagramPermissionByUrlQueryParams(newNotification.getUrlBpmnDiagram(), Permission.EDIT);
        return this.notificationResource.sendNotification(newNotification, appType);
    }
}

