/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.rest.AttachmentHandlerResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/attachmenthandler")
@AnonymousAllowed
@AnonymousSiteAccess
public class AttachmentHandlerController {
    private final AttachmentHandlerResource attachmentHandlerResource;
    private final AuthValidator authValidator;

    @Inject
    public AttachmentHandlerController(AttachmentHandlerResource attachmentHandlerResource, AuthValidator authValidator) {
        this.attachmentHandlerResource = attachmentHandlerResource;
        this.authValidator = authValidator;
    }

    @GET
    @Path(value="/rename")
    @Produces(value={"application/json"})
    public Response renameAttachment(@Context HttpServletRequest request, @QueryParam(value="pageId") String pageId, @QueryParam(value="attachmentName") String attachmentName, @QueryParam(value="newAttachmentName") String newAttachmentName) {
        this.authValidator.createContext(request).checkAuthentication().checkAttachmentPermission(Long.parseLong(pageId), attachmentName, Permission.EDIT);
        return this.attachmentHandlerResource.renameAttachment(pageId, attachmentName, newAttachmentName);
    }
}

