/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise;

import com.atlassian.confluence.index.attachment.AttachmentTextExtractor;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.util.io.InputStreamSource;
import de.viadee.confluence.enterprisecore.service.confluence.ConfluenceAttachmentManagerWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import lombok.Generated;
import org.apache.commons.io.IOUtils;

@Named(value="DmnAttachmentTextExtractor")
public class DmnAttachmentTextExtractor
implements AttachmentTextExtractor {
    private final ConfluenceAttachmentManagerWrapper attachmentManager;

    public List<String> getFileExtensions() {
        return Collections.singletonList("dmn");
    }

    public List<String> getMimeTypes() {
        return Collections.singletonList("text/dmn");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<InputStreamSource> extract(Attachment attachment) {
        try (InputStream is = this.attachmentManager.getAttachmentData(attachment);){
            if (is != null) {
                String text = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                Optional<InputStreamSource> optional2 = Optional.of(() -> IOUtils.toInputStream((String)text, (Charset)StandardCharsets.UTF_8));
                return optional2;
            }
            Optional<InputStreamSource> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public DmnAttachmentTextExtractor(ConfluenceAttachmentManagerWrapper attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

