/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.dmnpluginenterprise.service.DmnPluginService;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.rest.UpgradeResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/upgrade")
public class UpgradeController {
    private final IPluginService pluginService = new DmnPluginService();
    private final UpgradeResource upgradeResource;
    private final AuthValidator authValidator;

    @Inject
    public UpgradeController(UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, UpgradeResource upgradeResource) {
        this.upgradeResource = upgradeResource;
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager);
    }

    @GET
    @Produces(value={"application/json"})
    public Response upgrade(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.upgradeResource.upgrade(this.pluginService);
    }
}

