/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.model.SettingsModel;
import de.viadee.confluence.enterprisecore.rest.SettingsResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.SerializationService;
import de.viadee.confluence.enterprisecore.service.SettingService;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/settings")
@AnonymousAllowed
@AnonymousSiteAccess
public class SettingsController {
    public static final String PATH = "/settings";
    private final SettingsResource settingsResource;
    private final AuthValidator authValidator;

    @Inject
    public SettingsController(SettingService settingService, UserManager userManager, PageManager pageManager, UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, SerializationService serializationService) {
        this.settingsResource = new SettingsResource(settingService, pageManager, serializationService);
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager);
    }

    @GET
    @Produces(value={"application/json"})
    public Response isRestricted() {
        return this.settingsResource.isRestricted();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response update(@Context HttpServletRequest request, SettingsModel settings) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.settingsResource.update(settings);
    }

    @GET
    @Path(value="/canEdit/{pageId}")
    @Produces(value={"application/json"})
    public Response canEdit(@PathParam(value="pageId") String pageId) {
        return this.settingsResource.canEdit(pageId);
    }
}

