/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.vcs.GithubService;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/github")
@AnonymousAllowed
@AnonymousSiteAccess
public class GithubController {
    private final GithubService githubService;
    private final AuthValidator authValidator;

    @Inject
    public GithubController(UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, GithubService githubService) {
        this.githubService = githubService;
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager);
    }

    @GET
    @Path(value="/isConfigured")
    @Produces(value={"application/json"})
    public Response isGitHubConfigured() {
        return this.githubService.isGitHubConfigured();
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkAuthentication();
        return this.githubService.getAdminGitHubConfig();
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.Config config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.githubService.putAdminGitHubConfig(config);
    }

    @DELETE
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response deleteConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.githubService.deleteAdminGitHubConfig();
    }

    @GET
    @Path(value="/oauth/test")
    @Produces(value={"text/plain"})
    public Response testOAuthLoginUrl() {
        return this.githubService.getOAuthUserLoginUrl(Boolean.valueOf(true));
    }

    @GET
    @Path(value="/oauth")
    @Produces(value={"text/plain"})
    public Response getOAuthLoginUrl() {
        return this.githubService.getOAuthUserLoginUrl(Boolean.valueOf(false));
    }

    @GET
    @Path(value="/oauth/redirect")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response endOAuthLogin(@QueryParam(value="code") String code, @QueryParam(value="state") String state) {
        return this.githubService.endOAuthLogin(code, state);
    }

    @GET
    @Path(value="/projects/search")
    @Produces(value={"application/json"})
    public Response getGitHubProjectsWithUrl(@QueryParam(value="containedString") String containedString) {
        return this.githubService.getGitHubProjectsWithUrl(containedString).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build());
    }

    @GET
    @Path(value="/branches")
    @Produces(value={"application/json"})
    public Response getGitHubBranches(@QueryParam(value="repoPath") String repoPath) {
        return this.githubService.getGitHubBranches(repoPath);
    }

    @GET
    @Path(value="/branch/files")
    @Produces(value={"application/json"})
    public Response getGitHubFilesInBranch(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="ref") String ref, @QueryParam(value="fileEnding") String fileEnding) {
        return this.githubService.getFilesInBranchOrTag(repoPath, ref, fileEnding);
    }

    @GET
    @Path(value="/tags")
    @Produces(value={"application/json"})
    public Response getGitHubTags(@QueryParam(value="repoPath") String repoPath) {
        return this.githubService.getGitHubTags(repoPath);
    }

    @GET
    @Path(value="/tag/files")
    @Produces(value={"application/json"})
    public Response getGitHubFilesInTag(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="ref") String ref, @QueryParam(value="fileEnding") String fileEnding) {
        return this.githubService.getFilesInBranchOrTag(repoPath, ref, fileEnding);
    }

    @GET
    @Path(value="/commit")
    @Produces(value={"application/json"})
    public Response getLatestCommitForFile(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="ref") String ref, @QueryParam(value="filePath") String filePath) {
        return this.githubService.getLatestCommitForFile(repoPath, ref, filePath);
    }

    @GET
    @Path(value="/fileContent")
    @Produces(value={"application/xml"})
    public Response getGitHubFileContent(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="filePath") String filePath, @QueryParam(value="ref") String ref) {
        return this.githubService.getFileContent(repoPath, filePath, ref);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/branch/create")
    public Response createNewGitHubBranch(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="newBranch") String newBranchName, @QueryParam(value="sha") String shaToBranchFrom) {
        return this.githubService.createNewBranch(repoPath, newBranchName, shaToBranchFrom);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/branch")
    public Response deleteRef(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="branch") String branchName) {
        return this.githubService.deleteBranch(repoPath, branchName);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/file")
    public Response updateOrCreateFile(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="filePath") String filePath, String encodedFileWithParamsAsJsonBody) {
        return this.githubService.updateOrCreateFile(repoPath, filePath, encodedFileWithParamsAsJsonBody);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/new")
    public Response createNewMRinGitHub(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="base") String baseBranchName, @QueryParam(value="head") String headBranchName, @QueryParam(value="title") String title, @QueryParam(value="modeler") String modeler) {
        return this.githubService.createMergeRequest(repoPath, baseBranchName, headBranchName, title, modeler);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/accept")
    public Response acceptMergeRequestById(@QueryParam(value="repoPath") String repoPath, @QueryParam(value="pullNumber") int pullNumber) {
        return this.githubService.acceptMergeRequestById(repoPath, pullNumber);
    }
}

