/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.model.AttachmentsUpdateCommentModel;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.rest.AttachmentsResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.ConfigurationService;
import de.viadee.confluence.enterprisecore.service.SerializationService;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/attachments")
@AnonymousAllowed
@AnonymousSiteAccess
public class AttachmentsController {
    private final AttachmentsResource attachmentsResource;
    private final AuthValidator authValidator;

    @Inject
    public AttachmentsController(UserAccessor userAccessor, UserManager userManager, SpacePermissionManager spacePermissionManager, PermissionManager permissionManager, IPluginService pluginService, ConfigurationService configurationService, SpaceManager spaceManager, AttachmentManager attachmentManager, PageManager pageManager, SerializationService serializationService) {
        this.attachmentsResource = new AttachmentsResource(attachmentManager, pageManager, serializationService);
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager, spaceManager, pageManager, attachmentManager, pluginService, configurationService);
    }

    @GET
    @Path(value="/versionData/{pageId}/{diagramNameWithType}/{version}/{attachmentId}")
    @Produces(value={"application/json"})
    public Response getAttachmentVersionData(@Context HttpServletRequest request, @PathParam(value="diagramNameWithType") String diagramNameWithType, @PathParam(value="pageId") Long pageId, @PathParam(value="version") int version, @PathParam(value="attachmentId") String attachmentId) {
        this.authValidator.createContext(request).checkAuthentication().checkAttachmentPermission(pageId.longValue(), diagramNameWithType, version, Permission.VIEW);
        return this.attachmentsResource.getAttachmentVersionData(diagramNameWithType, pageId, version, attachmentId);
    }

    @POST
    @Path(value="/comment/update/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateAttachmentComment(@Context HttpServletRequest request, AttachmentsUpdateCommentModel attachmentsUpdateCommentModel) {
        this.authValidator.createContext(request).checkAuthentication().checkAttachmentPermission(attachmentsUpdateCommentModel.getPageId().longValue(), attachmentsUpdateCommentModel.getAttachmentName(), Permission.EDIT);
        return this.attachmentsResource.updateAttachmentComment(attachmentsUpdateCommentModel);
    }
}

