/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import de.viadee.confluence.enterprisecore.rest.LicenseResource;
import de.viadee.confluence.enterprisecore.service.SerializationService;
import de.viadee.confluence.enterprisecore.service.SettingService;
import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/license")
@Named(value="LicenseServlet")
public class LicenseServlet
extends HttpServlet {
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    private final LicenseResource licenseResource;

    @Inject
    public LicenseServlet(PluginLicenseManager pluginLicenseManager, SettingService settingService, SerializationService serializationService) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseResource = new LicenseResource(pluginLicenseManager, settingService, serializationService);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter w = resp.getWriter();
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            w.println(((PluginLicense)this.pluginLicenseManager.getLicense().get()).getRawLicense());
        } else {
            w.println("License missing!");
        }
        w.close();
    }

    @GET
    @Path(value="/expiryDaysLeft")
    @Produces(value={"application/json"})
    public Response getLicenseExpiryDaysLeft() {
        return this.licenseResource.getLicenseExpiryDaysLeft();
    }

    @GET
    @Path(value="/licenseType")
    @AnonymousAllowed
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    public Response getLicenseType() {
        return this.licenseResource.getLicenseType();
    }
}

