/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.rest.AppConfigResource;
import de.viadee.confluence.enterprisecore.rest.GitlabResource;
import de.viadee.confluence.enterprisecore.security.AdminAesKeysManager;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.EnterpriseAppConfigurationService;
import de.viadee.confluence.enterprisecore.service.UserPropertiesService;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousSiteAccess
@Path(value="/gitlab")
public class GitlabController {
    private final GitlabResource gitlabResource;
    private final AuthValidator authValidator;

    @Inject
    public GitlabController(SettingsManager settingsManager, I18nResolver i18nResolver, UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, EnterpriseAppConfigurationService appConfigurationService, IPluginService pluginService, UserPropertiesService userPropertiesService, AdminAesKeysManager adminAesKeysManager) {
        this.gitlabResource = new GitlabResource(settingsManager, i18nResolver, appConfigurationService, pluginService, userPropertiesService, adminAesKeysManager);
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager);
    }

    @GET
    @Path(value="/fileContent")
    @Produces(value={"application/json"})
    public Response getGitLabFileContent(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="filePath") String filePath, @QueryParam(value="ref") String ref, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getFileContent(repoUrl, filePath, ref, projectId);
    }

    @GET
    @Path(value="/branches")
    @Produces(value={"application/json"})
    public Response getGitLabBranches(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getGitLabBranches(repoUrl, projectId);
    }

    @GET
    @Path(value="/tags")
    @Produces(value={"application/json"})
    public Response getGitLabTags(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getGitLabTags(repoUrl, projectId);
    }

    @GET
    @Path(value="/projects")
    @Produces(value={"application/json"})
    public Response getGitLabProjects(@QueryParam(value="repoUrl") String repoUrl) {
        return this.gitlabResource.getGitLabProjects(repoUrl);
    }

    @GET
    @Path(value="/projects/search")
    @Produces(value={"application/json"})
    public Response getGitLabProjectsWithSearchString(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="containedString") String containedString) {
        return this.gitlabResource.getGitLabProjectsWithSearchString(repoUrl, containedString);
    }

    @GET
    @Path(value="/projectName")
    @Produces(value={"application/json"})
    public Response getGitLabProjectNameByProjectId(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") String projectId) {
        return this.gitlabResource.getGitLabProjectNameByProjectId(repoUrl, projectId);
    }

    @GET
    @Path(value="/branch/files")
    @Produces(value={"application/json"})
    public Response getGitLabFilesInBranch(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="ref") String ref, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getGitLabFilesInBranch(repoUrl, ref, projectId, ".dmn");
    }

    @GET
    @Path(value="/tag/files")
    @Produces(value={"application/json"})
    public Response getGitLabFilesOnTag(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="ref") String ref, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getGitLabFilesOnTag(repoUrl, ref, projectId, ".dmn");
    }

    @GET
    @Path(value="/commit")
    @Produces(value={"application/json"})
    public Response getGitLabCommit(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="ref") String ref, @QueryParam(value="filePath") String filePath, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getGitLabCommit(repoUrl, ref, filePath, projectId);
    }

    @GET
    @Path(value="/filename")
    @Produces(value={"text/plain"})
    public Response getGitLabFileName(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="filePath") String filePath, @QueryParam(value="ref") String ref, @QueryParam(value="projectId") int projectId) {
        return this.gitlabResource.getFileContent(repoUrl, filePath, ref, projectId);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/branch/create")
    public Response createNewGitLabBranch(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId, @QueryParam(value="newBranch") String newBranchName, @QueryParam(value="ref") String refBranch) {
        return this.gitlabResource.createNewBranch(repoUrl, projectId, newBranchName, refBranch);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/update/file")
    public Response updateFileInBranch(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId, @QueryParam(value="ref") String refBranch, @QueryParam(value="filePath") String filePath, String body) {
        return this.gitlabResource.updateFile(repoUrl, projectId, refBranch, filePath, body);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/create/file")
    public Response createNewFile(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId, @QueryParam(value="ref") String refBranch, @QueryParam(value="filePath") String filePath, String body) {
        return this.gitlabResource.createNewFile(repoUrl, projectId, refBranch, filePath, body);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/new")
    public Response createNewMRinGitLab(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") String projectId, @QueryParam(value="parentRef") String parentRef, @QueryParam(value="ref") String childBranch, @QueryParam(value="title") String title) {
        return this.gitlabResource.createMergeRequest(repoUrl, projectId, parentRef, childBranch, title);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mergerequest/accept")
    public Response acceptMergeRequestById(@QueryParam(value="repoUrl") String repoUrl, @QueryParam(value="projectId") int projectId, @QueryParam(value="iid") String iid) {
        return this.gitlabResource.acceptMergeRequestById(repoUrl, projectId, iid);
    }

    @GET
    @Path(value="/oauth/test")
    @Produces(value={"text/plain"})
    public Response testOAuthLoginUrl() {
        return this.gitlabResource.getOAuthUserLoginUrl(Boolean.valueOf(true));
    }

    @GET
    @Path(value="/oauth")
    @Produces(value={"text/plain"})
    public Response getOAuthLoginUrl() {
        return this.gitlabResource.getOAuthUserLoginUrl(Boolean.valueOf(false));
    }

    @GET
    @Path(value="/oauth/redirect")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response endOAuthLogin(@QueryParam(value="code") String code, @QueryParam(value="state") String state) {
        return this.gitlabResource.endOAuthLogin(code, state);
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkAuthentication();
        return this.gitlabResource.getConfig();
    }

    @GET
    @Path(value="/config/{configKey}")
    @Produces(value={"application/json"})
    public Response getSingleConfig(@Context HttpServletRequest request, @PathParam(value="configKey") String configKey) {
        this.authValidator.createContext(request).checkAuthentication();
        return this.gitlabResource.getSingleConfig(configKey);
    }

    @PUT
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response putConfig(@Context HttpServletRequest request, AppConfigResource.Config config) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.gitlabResource.putConfig(config);
    }

    @DELETE
    @Path(value="/config")
    @Consumes(value={"application/json"})
    public Response deleteConfig(@Context HttpServletRequest request) {
        this.authValidator.createContext(request).checkConfluenceAdminStatus();
        return this.gitlabResource.deleteAdminGitLabConfig();
    }

    @GET
    @Path(value="/isConfigured")
    @Produces(value={"application/json"})
    public Response isGitlabConfigured() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.gitlabResource.isGitlabConfigured()).build();
    }
}

