/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.rest.AttachmentHandlerResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.ConfigurationService;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/attachmenthandler")
@AnonymousSiteAccess
public class AttachmentHandlerController {
    private final AttachmentHandlerResource attachmentHandlerResource;
    private final AuthValidator authValidator;

    @Inject
    public AttachmentHandlerController(UserAccessor userAccessor, UserManager userManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, AttachmentManager attachmentManager, PageManager pageManager, SpaceManager spaceManager, IPluginService pluginService, ConfigurationService configurationService) {
        this.attachmentHandlerResource = new AttachmentHandlerResource(attachmentManager, pageManager, userAccessor, spacePermissionManager);
        this.authValidator = new AuthValidator(userAccessor, userManager, spacePermissionManager, permissionManager, spaceManager, pageManager, attachmentManager, pluginService, configurationService);
    }

    @GET
    @Path(value="/rename")
    @Produces(value={"application/json"})
    public Response renameAttachment(@Context HttpServletRequest request, @QueryParam(value="pageId") String pageId, @QueryParam(value="attachmentName") String attachmentName, @QueryParam(value="newAttachmentName") String newAttachmentName) {
        this.authValidator.createContext(request).checkAuthentication().checkAttachmentPermission(Long.parseLong(pageId), attachmentName, Permission.EDIT);
        return this.attachmentHandlerResource.renameAttachment(pageId, attachmentName, newAttachmentName);
    }
}

