/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.service;

import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.model.MacroNameEnum;
import org.springframework.stereotype.Component;

@Component
public class DmnPluginService
implements IPluginService {
    private static final String APP_FLAG = "DMN";
    private static final String OTHER_APP_FLAG = "BPMN";
    private static final String PLUGIN_KEY = "de.viadee.confluence.dmn-plugin-enterprise";
    private static final String REST_PATH_COMPONENT = "/rest/dmn-plugin-enterprise/1.0";
    private static final MacroNameEnum macroName = MacroNameEnum.VDCP_MACRO_ENTERPRISE;
    private static final MacroNameEnum otherMacroName = MacroNameEnum.VBCP_MACRO_ENTERPRISE;
    private static final MacroNameEnum freeMacroName = MacroNameEnum.VDCP_MACRO_FREE;
    private static final String SPACE_RESTRICTION_KEY = "de.viadee.confluence.dmn-modeler-enterprise.settings.restricted";
    private static final String WELCOME_SCREEN_PROPERTY_KEY = "de.viadee.confluence.dmn-plugin-enterprise.welcome-screen";
    private static final String MINIMAP_OPEN_PROPERTY_KEY = "de.viadee.confluence.dmn-plugin-enterprise.minimap-open";
    private static final String ATTRIBUTE_PANEL_OPEN_PROPERTY_KEY = "de.viadee.confluence.dmn-plugin-enterprise.attributepanel-open";
    private static final String LAST_NEWS_SEEN_DATE_PROPERTY_KEY = "de.viadee.confluence.dmn-plugin-enterprise.last-news-seen-date";
    private static final String FILE_EXTENSION = ".dmn";
    private static final String OTHER_FILE_EXTENSION = ".bpmn";
    private static final String PLACE_HOLDER_IMAGE_BASE_64_ENCODED = "iVBORw0KGgoAAAANSUhEUgAAAM8AAABoCAYAAABWmKQJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJ0SURBVHhe7dyxahRRGIbhP1rYWQghtaYwWFjZWYig2IkpJKSysrXxAnbWO9BKFCKWuQAr78JCbKy0CXYWglrEGXOKgOJmv0yECc8DPzubcE6aeZkTWHZlv1fA0s60V2BJ4oGQeCAkHgiJB0LigZB4ICQeCIkHUsMnDI6q67rh0wjGnKoZ7uuEJw+Eonj6UocnljGTnuE+Po6lPhg6n89//8Fhrt+f1bO37RcjeHS76taV9gb+g8P382w2az89uvjY9uVruxjJ2PvBSfM/D4TEAyHxQEg8EBolnns3qx7fCaZfd7XtAVMzSjzXLlfd2AimX3ep7QFT49gGIfFAaJx4vlXtPK2628/O56pP7w+uF827fh1MlScPhMQDoXHiOVe19bDqdT9ba1Vr6wfXi2ajXwdTNU4836t2X1Y96Gd3r2rv48H1ovnQr4OpcmyD0Cjx/DhbtdmOYpurVRcu/nlE+9us9+t+tj1gakaJ58mrQ8ex51XbLw69/8ds9+vetD1gahzbICQeCIkHQnE8q+fbxUjG3g9O3PDtOUfVtS89HF5h6o57Pzu2QUg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDyQ2l9C13X7wxJjTtMM93XCkwdCK0NB7RpYgicPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQKTqF/rA7LrkinDpAAAAAElFTkSuQmCC";
    private static final String GITHUB_ACCESS_TOKEN_PROPERTY_KEY = "key.vbcp-gitHub-accessToken";
    private static final String GITHUB_CLIENT_ID_PROPERTY_KEY = "key.vbcp-gitHub-clientId";
    private static final String GITLAB_ACCESS_TOKEN_PROPERTY_KEY = "de.viadee.confluence.dmn-plugin-enterprise.gitLab-accessToken";
    private static final String GITLAB_CLIENT_ID_PROPERTY_KEY = "de.viadee.confluence.dmn-plugin-enterprise.gitLab-clientId";
    private static final String GITLAB_REFRESH_TOKEN_PROPERTY_KEY = "de.viadee.confluence.dmn-plugin-enterprise.gitLab-refreshToken";
    private static final String I18N_KEY_PREFIX = "de.viadee.confluence.dmn-plugin-enterprise";

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String getFileExtension(MacroNameEnum macroName) {
        if (macroName == DmnPluginService.macroName) {
            return FILE_EXTENSION;
        }
        return OTHER_FILE_EXTENSION;
    }

    public MacroNameEnum getMacroName() {
        return macroName;
    }

    public MacroNameEnum getMacroName(String diagramType) {
        return diagramType.equals(this.getAppFlag()) ? macroName : otherMacroName;
    }

    public MacroNameEnum getFreeMacroName() {
        return freeMacroName;
    }

    public String getSpaceRestrictionKey() {
        return SPACE_RESTRICTION_KEY;
    }

    public String getRestPathComponent() {
        return REST_PATH_COMPONENT;
    }

    public String getShowWelcomeScreenPropertyKey() {
        return WELCOME_SCREEN_PROPERTY_KEY;
    }

    public String getMinimapOpenPropertyKey() {
        return MINIMAP_OPEN_PROPERTY_KEY;
    }

    public String getAttributePanelOpenPropertyKey() {
        return ATTRIBUTE_PANEL_OPEN_PROPERTY_KEY;
    }

    public String getAppFlag() {
        return APP_FLAG;
    }

    public String getAppFlag(String fileExtension) {
        if (fileExtension.equals(FILE_EXTENSION)) {
            return APP_FLAG;
        }
        if (fileExtension.equals(OTHER_FILE_EXTENSION)) {
            return OTHER_APP_FLAG;
        }
        return "";
    }

    public String getOtherAppFlag() {
        return OTHER_APP_FLAG;
    }

    public MacroNameEnum getOtherMacroName() {
        return otherMacroName;
    }

    public String getPluginKey() {
        return "de.viadee.confluence.dmn-plugin-enterprise";
    }

    public String getLastNewsSeenDatePropertyKey() {
        return LAST_NEWS_SEEN_DATE_PROPERTY_KEY;
    }

    public String getPlaceHolderImageBase64Encoded() {
        return PLACE_HOLDER_IMAGE_BASE_64_ENCODED;
    }

    public String getGithubAccessTokenPropertyKey() {
        return GITHUB_ACCESS_TOKEN_PROPERTY_KEY;
    }

    public String getGithubClientIdPropertyKey() {
        return GITHUB_CLIENT_ID_PROPERTY_KEY;
    }

    public String getGitlabAccessTokenPropertyKey() {
        return GITLAB_ACCESS_TOKEN_PROPERTY_KEY;
    }

    public String getGitlabClientIdPropertyKey() {
        return GITLAB_CLIENT_ID_PROPERTY_KEY;
    }

    public String getGitlabRefreshTokenPropertyKey() {
        return GITLAB_REFRESH_TOKEN_PROPERTY_KEY;
    }

    public String getI18nKeyPrefix() {
        return "de.viadee.confluence.dmn-plugin-enterprise";
    }
}

