/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import de.viadee.confluence.enterprisecore.model.ConfigurationModel;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.model.MacroNameEnum;
import de.viadee.confluence.enterprisecore.rest.ConfigurationResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.ConfigurationService;
import de.viadee.confluence.enterprisecore.service.EnterpriseAppConfigurationService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/config")
public class ConfigurationController
extends AbstractResource {
    private final ConfigurationResource configurationResource;
    private final AuthValidator authValidator;
    private final MacroNameEnum macroName;

    public ConfigurationController(ConfigurationService configService, UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, IPluginService pluginService, EnterpriseAppConfigurationService appConfigurationService, PageManager pageManager, SpaceManager spaceManager, AttachmentManager attachmentManager, ConfigurationService configurationService) {
        super(userAccessor, spacePermissionManager);
        this.configurationResource = new ConfigurationResource(configService, appConfigurationService);
        this.macroName = pluginService.getMacroName();
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager, pageManager, attachmentManager, pluginService, configurationService);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getGlobalConfig() {
        this.authValidator.createContext(this.authContext).checkAuthentication();
        this.createRequestContext();
        return this.configurationResource.getGlobalConfig();
    }

    @GET
    @Path(value="/{pageId}/{vbcpEntId}/")
    @Produces(value={"application/json"})
    public Response getDiagramConfig(@PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId) {
        this.authValidator.createContext(this.authContext).checkPagePermission(Long.parseLong(pageId), Permission.VIEW);
        this.createRequestContext();
        return this.configurationResource.getDiagramConfig(this.macroName, pageId, vbcpEntId);
    }

    @POST
    @Path(value="/{pageId}/{vbcpEntId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setDiagramConfig(@PathParam(value="pageId") String pageId, @PathParam(value="vbcpEntId") String vbcpEntId, ConfigurationModel newConfigs) {
        this.authValidator.createContext(this.authContext).checkPagePermission(Long.parseLong(pageId), Permission.EDIT);
        this.createRequestContext();
        return this.configurationResource.updateAllConfigs(pageId, vbcpEntId, this.macroName, newConfigs);
    }
}

