/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.service;

import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.model.MacroNameEnum;
import org.springframework.stereotype.Component;

@Component
public class DmnPluginService
implements IPluginService {
    private final String appFlag = "DMN";
    private final String otherAppFlag = "BPMN";
    private final String pluginKey = "de.viadee.confluence.dmn-plugin-enterprise";
    private final String restPathComponent = "/rest/dmn-plugin-enterprise/1.0";
    private final MacroNameEnum macroName = MacroNameEnum.VDCP_MACRO_ENTERPRISE;
    private final MacroNameEnum otherMacroName = MacroNameEnum.VBCP_MACRO_ENTERPRISE;
    private final MacroNameEnum freeMacroName = MacroNameEnum.VDCP_MACRO_FREE;
    private final String spaceRestrictionKey = "de.viadee.confluence.dmn-modeler-enterprise.settings.restricted";
    private final String welcomeScreenPropertyKey = "de.viadee.confluence.dmn-plugin-enterprise.welcome-screen";
    private final String minimapOpenPropertyKey = "de.viadee.confluence.dmn-plugin-enterprise.minimap-open";
    private final String attributePanelOpenPropertyKey = "de.viadee.confluence.dmn-plugin-enterprise.attributepanel-open";
    private final String lastNewsSeenDatePropertyKey = "de.viadee.confluence.dmn-plugin-enterprise.last-news-seen-date";
    private final String fileExtension = ".dmn";
    private final String otherFileExtension = ".bpmn";
    private final String placeHolderImageBase64Encoded = "iVBORw0KGgoAAAANSUhEUgAAAM8AAABoCAYAAABWmKQJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJ0SURBVHhe7dyxahRRGIbhP1rYWQghtaYwWFjZWYig2IkpJKSysrXxAnbWO9BKFCKWuQAr78JCbKy0CXYWglrEGXOKgOJmv0yECc8DPzubcE6aeZkTWHZlv1fA0s60V2BJ4oGQeCAkHgiJB0LigZB4ICQeCIkHUsMnDI6q67rh0wjGnKoZ7uuEJw+Eonj6UocnljGTnuE+Po6lPhg6n89//8Fhrt+f1bO37RcjeHS76taV9gb+g8P382w2az89uvjY9uVruxjJ2PvBSfM/D4TEAyHxQEg8EBolnns3qx7fCaZfd7XtAVMzSjzXLlfd2AimX3ep7QFT49gGIfFAaJx4vlXtPK2628/O56pP7w+uF827fh1MlScPhMQDoXHiOVe19bDqdT9ba1Vr6wfXi2ajXwdTNU4836t2X1Y96Gd3r2rv48H1ovnQr4OpcmyD0Cjx/DhbtdmOYpurVRcu/nlE+9us9+t+tj1gakaJ58mrQ8ex51XbLw69/8ds9+vetD1gahzbICQeCIkHQnE8q+fbxUjG3g9O3PDtOUfVtS89HF5h6o57Pzu2QUg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDyQ2l9C13X7wxJjTtMM93XCkwdCK0NB7RpYgicPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQKTqF/rA7LrkinDpAAAAAElFTkSuQmCC";
    private final String gitlabAccessTokenPropertyKey = "de.viadee.confluence.dmn-plugin-enterprise.gitLab-accessToken";
    private final String gitlabClientIdPropertyKey = "de.viadee.confluence.dmn-plugin-enterprise.gitLab-clientId";
    private final String gitlabRefreshTokenPropertyKey = "de.viadee.confluence.dmn-plugin-enterprise.gitLab-refreshToken";
    private final String i18nKeyPrefix = "de.viadee.confluence.dmn-plugin-enterprise";

    public String getFileExtension() {
        return ".dmn";
    }

    public String getFileExtension(MacroNameEnum macroName) {
        if (macroName == this.macroName) {
            return ".dmn";
        }
        return ".bpmn";
    }

    public MacroNameEnum getMacroName() {
        return this.macroName;
    }

    public MacroNameEnum getMacroName(String diagramType) {
        return diagramType.equals(this.getAppFlag()) ? this.macroName : this.otherMacroName;
    }

    public MacroNameEnum getFreeMacroName() {
        return this.freeMacroName;
    }

    public String getSpaceRestrictionKey() {
        return "de.viadee.confluence.dmn-modeler-enterprise.settings.restricted";
    }

    public String getRestPathComponent() {
        return "/rest/dmn-plugin-enterprise/1.0";
    }

    public String getShowWelcomeScreenPropertyKey() {
        return "de.viadee.confluence.dmn-plugin-enterprise.welcome-screen";
    }

    public String getMinimapOpenPropertyKey() {
        return "de.viadee.confluence.dmn-plugin-enterprise.minimap-open";
    }

    public String getAttributePanelOpenPropertyKey() {
        return "de.viadee.confluence.dmn-plugin-enterprise.attributepanel-open";
    }

    public String getAppFlag() {
        return "DMN";
    }

    public String getAppFlag(String fileExtension) {
        if (fileExtension.equals(".dmn")) {
            return "DMN";
        }
        if (fileExtension.equals(".bpmn")) {
            return "BPMN";
        }
        return "";
    }

    public String getOtherAppFlag() {
        return "BPMN";
    }

    public MacroNameEnum getOtherMacroName() {
        return this.otherMacroName;
    }

    public String getPluginKey() {
        return "de.viadee.confluence.dmn-plugin-enterprise";
    }

    public String getLastNewsSeenDatePropertyKey() {
        return "de.viadee.confluence.dmn-plugin-enterprise.last-news-seen-date";
    }

    public String getPlaceHolderImageBase64Encoded() {
        return "iVBORw0KGgoAAAANSUhEUgAAAM8AAABoCAYAAABWmKQJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJ0SURBVHhe7dyxahRRGIbhP1rYWQghtaYwWFjZWYig2IkpJKSysrXxAnbWO9BKFCKWuQAr78JCbKy0CXYWglrEGXOKgOJmv0yECc8DPzubcE6aeZkTWHZlv1fA0s60V2BJ4oGQeCAkHgiJB0LigZB4ICQeCIkHUsMnDI6q67rh0wjGnKoZ7uuEJw+Eonj6UocnljGTnuE+Po6lPhg6n89//8Fhrt+f1bO37RcjeHS76taV9gb+g8P382w2az89uvjY9uVruxjJ2PvBSfM/D4TEAyHxQEg8EBolnns3qx7fCaZfd7XtAVMzSjzXLlfd2AimX3ep7QFT49gGIfFAaJx4vlXtPK2628/O56pP7w+uF827fh1MlScPhMQDoXHiOVe19bDqdT9ba1Vr6wfXi2ajXwdTNU4836t2X1Y96Gd3r2rv48H1ovnQr4OpcmyD0Cjx/DhbtdmOYpurVRcu/nlE+9us9+t+tj1gakaJ58mrQ8ex51XbLw69/8ds9+vetD1gahzbICQeCIkHQnE8q+fbxUjG3g9O3PDtOUfVtS89HF5h6o57Pzu2QUg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQEg8EBIPhMQDIfFASDyQ2l9C13X7wxJjTtMM93XCkwdCK0NB7RpYgicPhMQDIfFASDwQEg+ExAMh8UBIPBASD4TEAyHxQKTqF/rA7LrkinDpAAAAAElFTkSuQmCC";
    }

    public String getGitlabAccessTokenPropertyKey() {
        return "de.viadee.confluence.dmn-plugin-enterprise.gitLab-accessToken";
    }

    public String getGitlabClientIdPropertyKey() {
        return "de.viadee.confluence.dmn-plugin-enterprise.gitLab-clientId";
    }

    public String getGitlabRefreshTokenPropertyKey() {
        return "de.viadee.confluence.dmn-plugin-enterprise.gitLab-refreshToken";
    }

    public String getI18nKeyPrefix() {
        return "de.viadee.confluence.dmn-plugin-enterprise";
    }
}

