/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserManager;
import de.viadee.confluence.enterprisecore.model.SettingsModel;
import de.viadee.confluence.enterprisecore.rest.SettingsResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.SettingService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="/settings")
public class SettingsController
extends AbstractResource {
    public static final String PATH = "/settings";
    private final SettingsResource settingsResource;
    private final AuthValidator authValidator;

    public SettingsController(SettingService settingService, UserManager userManager, PageManager pageManager, UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager) {
        super(userAccessor, spacePermissionManager);
        this.settingsResource = new SettingsResource(settingService, userManager, pageManager);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager);
    }

    @GET
    @Produces(value={"application/json"})
    public Response isRestricted() {
        this.createRequestContext();
        return this.settingsResource.isRestricted();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response update(SettingsModel settings) {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.settingsResource.update(settings);
    }

    @GET
    @Path(value="/canEdit/{pageId}")
    @Produces(value={"application/json"})
    public Response canEdit(@PathParam(value="pageId") String pageId) {
        this.createRequestContext();
        return this.settingsResource.canEdit(pageId);
    }
}

