/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import de.viadee.confluence.enterprisecore.action.EditorActionService;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.service.EnterpriseAppConfigurationService;
import de.viadee.confluence.enterprisecore.service.SettingService;
import de.viadee.confluence.enterprisecore.service.UserPropertiesService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public final class DiagramEditorAction
extends ConfluenceActionSupport {
    private static final String pluginKey = "de.viadee.confluence.dmn-plugin-enterprise";
    private static final String appFlag = "DMN";
    private static final String webResourceKey = "de.viadee.confluence.dmn-plugin-enterprise.editor";
    private static final String EDIT_REQUEST = "/plugins/dmn-plugin-enterprise/edit-diagram.action";
    private PluginAccessor pluginAccessor;
    private SettingService settingService;
    private PageManager pageManager;
    private ContentPropertyManager contentPropertyManager;
    private PersonalInformationManager personalInformationManager;
    private IPluginService pluginService;
    private EnterpriseAppConfigurationService appConfigurationService;
    private UserPropertiesService userPropertiesService;
    private String spaceKey;
    private String appMode;
    private String fromMode;
    private String pageId;
    private String diagramVersion;
    private String vbcpEntId;
    private String uniqueId;
    private boolean canEdit;
    private String licenseType;
    private String userSettings;

    public String execute() {
        HttpServletRequest request = this.getCurrentRequest();
        if (request == null) {
            return "error";
        }
        EditorActionService editorAction = new EditorActionService();
        String action = editorAction.execute(request, EDIT_REQUEST, this.settingService, this.pageManager, this.userPropertiesService);
        this.appMode = editorAction.getAppMode();
        this.spaceKey = editorAction.getSpaceKey();
        this.fromMode = editorAction.getFromMode();
        this.pageId = editorAction.getPageId();
        this.vbcpEntId = editorAction.getVbcpEntId();
        this.diagramVersion = editorAction.getDiagramVersion();
        this.canEdit = editorAction.isCanEdit();
        this.licenseType = editorAction.getLicenseType();
        this.userSettings = editorAction.getUserSettings();
        this.uniqueId = this.pageId.concat("-").concat(this.vbcpEntId);
        return action;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getUserSettings() {
        return this.userSettings;
    }

    public String getAppMode() {
        return this.appMode;
    }

    public String getWebResourceKey() {
        return webResourceKey;
    }

    public String getFromMode() {
        return this.fromMode;
    }

    public String getPluginKey() {
        return pluginKey;
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getDiagramVersion() {
        return this.diagramVersion;
    }

    public String getVbcpEntId() {
        return this.vbcpEntId;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getAppFlag() {
        return appFlag;
    }

    public boolean isCanEdit() {
        return this.canEdit;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public UserPropertiesService getUserPropertiesService() {
        return this.userPropertiesService;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public SettingService getSettingService() {
        return this.settingService;
    }

    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public ContentPropertyManager getContentPropertyManager() {
        return this.contentPropertyManager;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public PersonalInformationManager getPersonalInformationManager() {
        return this.personalInformationManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public IPluginService getPluginService() {
        return this.pluginService;
    }

    public void setPluginService(IPluginService pluginService) {
        this.pluginService = pluginService;
    }

    public void setUserPropertiesService(UserPropertiesService userPropertiesService) {
        this.userPropertiesService = userPropertiesService;
    }

    public EnterpriseAppConfigurationService getAppConfigurationService() {
        return this.appConfigurationService;
    }

    public void setAppConfigurationService(EnterpriseAppConfigurationService appConfigurationService) {
        this.appConfigurationService = appConfigurationService;
    }

    public String getVendorName() {
        PluginInformation info = this.getPluginInfo();
        if (info == null) {
            return "";
        }
        return StringUtils.defaultString((String)info.getVendorName());
    }

    public String getVendorUrl() {
        PluginInformation info = this.getPluginInfo();
        if (info == null) {
            return "";
        }
        return StringUtils.defaultString((String)info.getVendorUrl());
    }

    public String getPluginVersion() {
        PluginInformation info = this.getPluginInfo();
        if (info == null) {
            return "";
        }
        return StringUtils.defaultString((String)info.getVersion());
    }

    private PluginInformation getPluginInfo() {
        if (this.pluginAccessor == null) {
            return null;
        }
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            return null;
        }
        return plugin.getPluginInformation();
    }
}

