/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import de.viadee.confluence.enterprisecore.model.IPluginService;
import de.viadee.confluence.enterprisecore.model.NotificationModel;
import de.viadee.confluence.enterprisecore.rest.NotificationResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.ConfigurationService;
import de.viadee.confluence.enterprisecore.service.MentionNotificationService;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/notifications")
public class NotificationController
extends AbstractResource {
    private static final String appType = "DMN";
    private final NotificationResource notificationResource;
    private final AuthValidator authValidator;

    public NotificationController(UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, MentionNotificationService mentionNotificationService, PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, AttachmentManager attachmentManager, IPluginService pluginService, ConfigurationService configurationService) {
        super(userAccessor, spacePermissionManager);
        this.notificationResource = new NotificationResource(mentionNotificationService);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager, pageManager, attachmentManager, pluginService, configurationService);
    }

    @PUT
    @Path(value="/sendNotification")
    @Consumes(value={"application/json"})
    public Response sendNotification(NotificationModel newNotification) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkDiagramPermissionByUrlQueryParams(newNotification.getUrlBpmnDiagram(), Permission.EDIT);
        this.createRequestContext();
        return this.notificationResource.sendNotification(newNotification, appType);
    }
}

