"use strict";(self.webpackChunkVDCPENT=self.webpackChunkVDCPENT||[]).push([["dmnEntDmnJs"],{"./node_modules/dmn-js-decision-table/lib/Viewer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "Z": () => (/* binding */ Viewer)\n});\n\n// EXTERNAL MODULE: ./node_modules/table-js/lib/index.js\nvar lib = __webpack_require__("./node_modules/table-js/lib/index.js");\n// EXTERNAL MODULE: ./node_modules/dmn-js-decision-table/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__("./node_modules/dmn-js-decision-table/node_modules/min-dash/dist/index.esm.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/import/Util.js\nfunction elementToString(element) {\n  if (!element) {\n    return \'<null>\';\n  }\n  const id = element.id ? " id=\\"".concat(element.id, "\\"") : \'\';\n  return "<".concat(element.$type).concat(id, " />");\n}\n//# sourceMappingURL=Util.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/import/TableTreeWalker.js\n\n\nfunction TableTreeWalker(handler, options) {\n  function visit(element, ctx, definitions) {\n    var gfx = element.gfx;\n\n    // avoid multiple rendering of elements\n    if (gfx) {\n      throw new Error("already rendered ".concat(elementToString(element)));\n    }\n\n    // call handler\n    return handler.element(element, ctx, definitions);\n  }\n  function visitTable(element) {\n    return handler.table(element);\n  }\n\n  // Semantic handling //////////////////////\n\n  function handleDecision(decision) {\n    if (!decision.id) {\n      decision.id = \'decision\';\n    }\n    const table = decision.decisionLogic;\n    if (table) {\n      if (!table.output) {\n        throw new Error("missing output for ".concat(elementToString(table)));\n      }\n      const ctx = visitTable(table);\n      if (table.input) {\n        handleClauses(table.input, ctx, table);\n      }\n      handleClauses(table.output, ctx, table);\n\n      // if any input or output clauses (columns) were added\n      // make sure that for each rule the according input/output entry is created\n      handleRules(table.rule, ctx, table);\n    } else {\n      throw new Error("no table for ".concat(elementToString(decision)));\n    }\n  }\n  function handleClauses(clauses, context, definitions) {\n    (0,index_esm/* forEach */.Ed)(clauses, function (e) {\n      visit(e, context, definitions);\n    });\n  }\n  function handleRules(rules, context, definitions) {\n    (0,index_esm/* forEach */.Ed)(rules, function (e) {\n      visit(e, context, definitions);\n      handleEntry(e.inputEntry, e);\n      handleEntry(e.outputEntry, e);\n    });\n  }\n  function handleEntry(entry, context, definitions) {\n    (0,index_esm/* forEach */.Ed)(entry, function (e) {\n      visit(e, context, definitions);\n    });\n  }\n\n  // API //////////////////////\n\n  return {\n    handleDecision: handleDecision\n  };\n}\n//# sourceMappingURL=TableTreeWalker.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/import/Importer.js\n\n\n/**\n * Import the decision table into a table.\n *\n * Errors and warnings are reported through the specified callback.\n *\n * @param  {decisionTable} decisionTable instance of DecisionTable\n * @param  {ModdleElement} decision moddle element\n * @param  {Function} done\n *         the callback, invoked with (err, [ warning ]) once the import is done\n */\nfunction importDecision(decisionTable, decision, done) {\n  const importer = decisionTable.get(\'tableImporter\'),\n    eventBus = decisionTable.get(\'eventBus\'),\n    sheet = decisionTable.get(\'sheet\');\n  let hasModeling = decisionTable.get(\'modeling\', false);\n  let error,\n    warnings = [];\n  function render(decision) {\n    const visitor = {\n      create(type, parent, clause, rule) {\n        return importer.create(type, parent, clause, rule);\n      },\n      table(element) {\n        return importer.add(element);\n      },\n      element(element, parentShape, definitions) {\n        return importer.add(element, parentShape, definitions);\n      },\n      error(message, context) {\n        warnings.push({\n          message: message,\n          context: context\n        });\n      }\n    };\n    const walker = new TableTreeWalker(visitor, {\n      canAddMissingEntries: hasModeling\n    });\n\n    // import\n    walker.handleDecision(decision);\n  }\n  eventBus.fire(\'import.render.start\', {\n    decision: decision\n  });\n  try {\n    render(decision);\n  } catch (e) {\n    error = e;\n  }\n  eventBus.fire(\'import.render.complete\', {\n    error: error,\n    warnings: warnings\n  });\n  eventBus.fire(\'elements.changed\', {\n    elements: [sheet.getRoot()]\n  });\n  done(error, warnings);\n}\n//# sourceMappingURL=Importer.js.map\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__("./node_modules/min-dom/dist/index.esm.js");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/i18n/translate/index.js + 1 modules\nvar translate = __webpack_require__("./node_modules/diagram-js/lib/i18n/translate/index.js");\n// EXTERNAL MODULE: ./node_modules/dmn-js-decision-table/lib/features/annotations/components/AnnotationHeader.js\nvar AnnotationHeader = __webpack_require__("./node_modules/dmn-js-decision-table/lib/features/annotations/components/AnnotationHeader.js");\n// EXTERNAL MODULE: ./node_modules/inferno/index.esm.js + 1 modules\nvar inferno_index_esm = __webpack_require__("./node_modules/inferno/index.esm.js");\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/Cell.js\nvar Cell = __webpack_require__("./node_modules/table-js/lib/components/Cell.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/annotations/components/AnnotationCell.js\n\n\nfunction AnnotationCell(props) {\n  const row = props.row;\n  const _row$businessObject = row.businessObject,\n    id = _row$businessObject.id,\n    description = _row$businessObject.description;\n  return (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Cell/* default */.Z, {\n    "className": "annotation",\n    "elementId": id,\n    children: description || \'-\'\n  });\n}\n//# sourceMappingURL=AnnotationCell.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/annotations/AnnotationsProvider.js\n\n\nfunction AnnotationsProvider(components) {\n  components.onGetComponent(\'cell\', _ref => {\n    let cellType = _ref.cellType;\n    if (cellType === \'after-label-cells\') {\n      return AnnotationHeader/* default */.Z;\n    } else if (cellType === \'after-rule-cells\') {\n      return AnnotationCell;\n    }\n  });\n}\nAnnotationsProvider.$inject = [\'components\'];\n//# sourceMappingURL=AnnotationsProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/annotations/index.js\n\n/* harmony default export */ const annotations = ({\n  __init__: [\'annotationsProvider\'],\n  annotationsProvider: [\'type\', AnnotationsProvider]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__("./node_modules/dmn-js-shared/lib/util/ModelUtil.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/import/TableImporter.js\n\n\nfunction elementData(semantic, attrs) {\n  return (0,index_esm/* assign */.f0)({\n    id: semantic.id,\n    type: semantic.$type,\n    businessObject: semantic\n  }, attrs);\n}\nclass TableImporter {\n  constructor(elementFactory, eventBus, sheet) {\n    this._elementFactory = elementFactory;\n    this._eventBus = eventBus;\n    this._sheet = sheet;\n  }\n\n  /**\n   * Add DMN element.\n   */\n  add(semantic) {\n    let element;\n\n    // decision table\n    if ((0,ModelUtil.is)(semantic, \'dmn:DecisionTable\')) {\n      element = this._elementFactory.createRoot(elementData(semantic));\n      this._sheet.setRoot(element);\n    }\n\n    // input clause\n    else if ((0,ModelUtil.is)(semantic, \'dmn:InputClause\')) {\n      element = this._elementFactory.createCol(elementData(semantic));\n      this._sheet.addCol(element);\n    }\n\n    // output clause\n    else if ((0,ModelUtil.is)(semantic, \'dmn:OutputClause\')) {\n      element = this._elementFactory.createCol(elementData(semantic));\n      this._sheet.addCol(element);\n    }\n\n    // rule\n    else if ((0,ModelUtil.is)(semantic, \'dmn:DecisionRule\')) {\n      if (!semantic.inputEntry) {\n        semantic.inputEntry = [];\n      }\n      if (!semantic.outputEntry) {\n        semantic.outputEntry = [];\n      }\n      const cells = [...semantic.inputEntry, ...semantic.outputEntry].map(entry => {\n        return this._elementFactory.createCell(elementData(entry));\n      });\n      element = this._elementFactory.createRow((0,index_esm/* assign */.f0)(elementData(semantic), {\n        cells\n      }));\n      this._sheet.addRow(element);\n    }\n    this._eventBus.fire(\'dmnElement.added\', {\n      element: element\n    });\n    return element;\n  }\n}\nTableImporter.$inject = [\'elementFactory\', \'eventBus\', \'sheet\'];\n//# sourceMappingURL=TableImporter.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/import/index.js\n\n\n/* harmony default export */ const lib_import = ({\n  __depends__: [translate/* default */.Z],\n  tableImporter: [\'type\', TableImporter]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/render/index.js + 4 modules\nvar render = __webpack_require__("./node_modules/table-js/lib/render/index.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/core/index.js\n\n\n/* harmony default export */ const core = ({\n  __depends__: [lib_import, render/* default */.Z]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/utils/mixin.js\nvar mixin = __webpack_require__("./node_modules/table-js/lib/components/utils/mixin.js");\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/components/mixins/index.js + 1 modules\nvar mixins = __webpack_require__("./node_modules/dmn-js-shared/lib/components/mixins/index.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/components/DecisionTableHead.js\n\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\n\n\n\n\nclass DecisionTableHead extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    _defineProperty(this, "onElementsChanged", () => {\n      this.forceUpdate();\n    });\n    (0,mixin/* default */.Z)(this, mixins/* ComponentWithSlots */.t);\n    this._sheet = context.injector.get(\'sheet\');\n    this._changeSupport = context.changeSupport;\n  }\n  componentWillMount() {\n    const root = this._sheet.getRoot();\n    this._changeSupport.onElementsChanged(root.id, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    const root = this._sheet.getRoot();\n    this._changeSupport.offElementsChanged(root.id, this.onElementsChanged);\n  }\n  render() {\n    const root = this._sheet.getRoot();\n    if (!(0,ModelUtil.is)(root, \'dmn:DMNElement\')) {\n      return null;\n    }\n    const businessObject = (0,ModelUtil/* getBusinessObject */.SS)(root);\n    const inputs = businessObject.input,\n      outputs = businessObject.output;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, "thead", null, (0,inferno_index_esm/* createVNode */.Wm)(1, "tr", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, "th", "index-column"), this.slotFills({\n      type: \'cell\',\n      context: {\n        cellType: \'before-label-cells\'\n      }\n    }), inputs && inputs.map((input, index) => {\n      const width = input.width || \'192px\';\n      return this.slotFill({\n        type: \'cell\',\n        context: {\n          cellType: \'input-header\',\n          input,\n          index,\n          inputsLength: inputs.length,\n          width\n        },\n        key: input.id\n      }, DefaultInputHeaderCell);\n    }), outputs.map((output, index) => {\n      return this.slotFill({\n        type: \'cell\',\n        context: {\n          cellType: \'output-header\',\n          output,\n          index,\n          outputsLength: outputs.length\n        },\n        key: output.id\n      }, DefaultOutputHeaderCell);\n    }), this.slotFills({\n      type: \'cell\',\n      context: {\n        cellType: \'after-label-cells\'\n      }\n    })], 0), 2);\n  }\n}\n\n// default components ///////////////////////\n\nfunction DefaultInputHeaderCell(props, context) {\n  const input = props.input,\n    className = props.className,\n    index = props.index;\n  const label = input.label,\n    inputExpression = input.inputExpression,\n    inputValues = input.inputValues;\n  const translate = context.injector.get(\'translate\');\n  const actualClassName = (className || \'\') + \' input-cell\';\n  return (0,inferno_index_esm/* createVNode */.Wm)(1, "th", actualClassName, [(0,inferno_index_esm/* createVNode */.Wm)(1, "div", "clause", index === 0 ? translate(\'When\') : translate(\'And\'), 0), label ? (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "input-label", label, 0, {\n    "title": translate(\'Input Label: \') + label\n  }) : (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "input-expression", inputExpression.text, 0, {\n    "title": translate(\'Input Expression: \') + inputExpression.text\n  }), (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "input-variable", inputValues && inputValues.text || inputExpression.typeRef, 0, {\n    "title": inputValues && inputValues.text ? translate(\'Input Values\') : translate(\'Input Type\')\n  })], 0, {\n    "data-col-id": input.id\n  }, input.id);\n}\nfunction DefaultOutputHeaderCell(props, context) {\n  const output = props.output,\n    className = props.className,\n    index = props.index;\n  const label = output.label,\n    name = output.name,\n    outputValues = output.outputValues,\n    typeRef = output.typeRef;\n  const translate = context.injector.get(\'translate\');\n  const actualClassName = (className || \'\') + \' output-cell\';\n  return (0,inferno_index_esm/* createVNode */.Wm)(1, "th", actualClassName, [(0,inferno_index_esm/* createVNode */.Wm)(1, "div", "clause", index === 0 ? translate(\'Then\') : translate(\'And\'), 0), label ? (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "output-label", label, 0, {\n    "title": translate(\'Output Label\')\n  }) : (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "output-name", name, 0, {\n    "title": translate(\'Output Name\')\n  }), (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "output-variable", outputValues && outputValues.text || typeRef, 0, {\n    "title": outputValues && outputValues.text ? translate(\'Output Values\') : translate(\'Output Type\')\n  })], 0, null, output.id);\n}\n//# sourceMappingURL=DecisionTableHead.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/DecisionTableHeadProvider.js\n\nfunction DecisionTableHeadProvider(components) {\n  components.onGetComponent(\'table.head\', () => DecisionTableHead);\n}\nDecisionTableHeadProvider.$inject = [\'components\'];\n//# sourceMappingURL=DecisionTableHeadProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/index.js\n\n/* harmony default export */ const decision_table_head = ({\n  __init__: [\'decisionTableHeadProvider\'],\n  decisionTableHeadProvider: [\'type\', DecisionTableHeadProvider]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/utils/inject.js\nvar inject = __webpack_require__("./node_modules/table-js/lib/components/utils/inject.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-properties/components/DecisionTablePropertiesComponent.js\n\n\n\n\nclass DecisionTablePropertiesComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get(\'translate\');\n    (0,inject/* inject */.f)(this);\n  }\n  render() {\n    const root = this.sheet.getRoot();\n    if (!(0,ModelUtil.is)(root, \'dmn:DMNElement\')) {\n      return null;\n    }\n    const name = root.businessObject.$parent.name;\n    const HitPolicy = this.components.getComponent(\'hit-policy\') || NullComponent;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "decision-table-properties", [(0,inferno_index_esm/* createVNode */.Wm)(1, "div", "decision-table-name", name, 0, {\n      "title": this._translate(\'Decision Name: \') + name\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "decision-table-header-separator"), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, HitPolicy)], 4);\n  }\n}\nDecisionTablePropertiesComponent.$inject = [\'sheet\', \'components\'];\nfunction NullComponent() {\n  return null;\n}\n//# sourceMappingURL=DecisionTablePropertiesComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-properties/DecisionTableProperties.js\n\nconst LOW_PRIORITY = 500;\nclass DecisionTableProperties {\n  constructor(components) {\n    components.onGetComponent(\'table.before\', LOW_PRIORITY, () => {\n      return DecisionTablePropertiesComponent;\n    });\n  }\n}\nDecisionTableProperties.$inject = [\'components\'];\n//# sourceMappingURL=DecisionTableProperties.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-properties/index.js\n\n/* harmony default export */ const decision_table_properties = ({\n  __init__: [\'decisionTableProperties\'],\n  decisionTableProperties: [\'type\', DecisionTableProperties]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rule-indices/components/DecisionRuleIndexCellComponent.js\n\n\nclass DecisionRulesIndexCellComponent extends inferno_index_esm/* Component */.wA {\n  render() {\n    const _this$props = this.props,\n      row = _this$props.row,\n      rowIndex = _this$props.rowIndex;\n    const components = this.context.components;\n    const innerComponents = components.getComponents(\'cell-inner\', {\n      cellType: \'rule-index\',\n      row,\n      rowIndex\n    });\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, "td", "rule-index", [innerComponents && innerComponents.map(InnerComponent => (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InnerComponent, {\n      "row": row,\n      "rowIndex": rowIndex\n    })), rowIndex + 1], 0, {\n      "data-element-id": row.id,\n      "data-row-id": row.id\n    });\n  }\n}\n//# sourceMappingURL=DecisionRuleIndexCellComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rule-indices/DecisionRuleIndices.js\n\nclass DecisionRuleIndices {\n  constructor(components) {\n    components.onGetComponent(\'cell\', _ref => {\n      let cellType = _ref.cellType;\n      if (cellType === \'before-rule-cells\') {\n        return DecisionRulesIndexCellComponent;\n      }\n    });\n  }\n}\nDecisionRuleIndices.$inject = [\'components\'];\n//# sourceMappingURL=DecisionRuleIndices.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rule-indices/index.js\n\n/* harmony default export */ const decision_rule_indices = ({\n  __init__: [\'decisionRuleIndices\'],\n  decisionRuleIndices: [\'type\', DecisionRuleIndices]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/index.js + 4 modules\nvar decision_rules = __webpack_require__("./node_modules/dmn-js-decision-table/lib/features/decision-rules/index.js");\n// EXTERNAL MODULE: ./node_modules/dmn-js-decision-table/lib/features/hit-policy/HitPolicies.js\nvar HitPolicies = __webpack_require__("./node_modules/dmn-js-decision-table/lib/features/hit-policy/HitPolicies.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/hit-policy/components/HitPolicy.js\n\n\n\n\n\nclass HitPolicy extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get(\'translate\');\n    (0,inject/* inject */.f)(this);\n  }\n  getRoot() {\n    return this.sheet.getRoot();\n  }\n  render() {\n    const root = this.getRoot(),\n      businessObject = root.businessObject;\n    const aggregation = businessObject.aggregation,\n      hitPolicy = businessObject.hitPolicy;\n    const hitPolicyEntry = (0,index_esm/* find */.sE)(HitPolicies/* HIT_POLICIES */.s, entry => {\n      return isEqualHitPolicy(entry.value, {\n        aggregation,\n        hitPolicy\n      });\n    });\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "hit-policy header", [(0,inferno_index_esm/* createVNode */.Wm)(1, "label", "dms-label", this._translate(\'Hit Policy:\'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, "span", "hit-policy-value", this._translate(hitPolicyEntry.label), 0)], 4, {\n      "title": this._translate(hitPolicyEntry.explanation)\n    });\n  }\n}\nHitPolicy.$inject = [\'sheet\'];\n\n// helpers //////////////////////\nfunction isEqualHitPolicy(a, b) {\n  return a.hitPolicy === b.hitPolicy && a.aggregation === b.aggregation;\n}\n//# sourceMappingURL=HitPolicy.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/hit-policy/HitPolicyProvider.js\n\nfunction HitPolicyProvider(components) {\n  components.onGetComponent(\'hit-policy\', () => {\n    return HitPolicy;\n  });\n}\nHitPolicyProvider.$inject = [\'components\'];\n//# sourceMappingURL=HitPolicyProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/hit-policy/index.js\n\n/* harmony default export */ const hit_policy = ({\n  __init__: [\'hitPolicyProvider\'],\n  hitPolicyProvider: [\'type\', HitPolicyProvider]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/view-drd/components/ViewDrdComponent.js\n\nfunction ViewDrdComponent_defineProperty(obj, key, value) { key = ViewDrdComponent_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction ViewDrdComponent_toPropertyKey(arg) { var key = ViewDrdComponent_toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }\nfunction ViewDrdComponent_toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\n\nclass ViewDrdComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    ViewDrdComponent_defineProperty(this, "onClick", () => {\n      this._eventBus.fire(\'showDrd\');\n    });\n    const injector = context.injector;\n    this._translate = injector.get(\'translate\');\n    this._eventBus = injector.get(\'eventBus\');\n  }\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "view-drd", (0,inferno_index_esm/* createVNode */.Wm)(1, "button", "view-drd-button", this._translate(\'View DRD\'), 0, {\n      "type": "button",\n      "onClick": this.onClick\n    }), 2, null, null, node => this.node = node);\n  }\n}\n//# sourceMappingURL=ViewDrdComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/view-drd/ViewDrd.js\n\nclass ViewDrd {\n  constructor(components, eventBus, injector, sheet) {\n    this._injector = injector;\n    this._sheet = sheet;\n    components.onGetComponent(\'table.before\', () => {\n      if (this.canViewDrd()) {\n        return ViewDrdComponent;\n      }\n    });\n    eventBus.on(\'showDrd\', () => {\n      const parent = injector.get(\'_parent\', false);\n      const root = sheet.getRoot();\n      const definitions = getDefinitions(root);\n      if (!definitions) {\n        return;\n      }\n\n      // open definitions\n      const view = parent.getView(definitions);\n      parent.open(view);\n    });\n  }\n  canViewDrd() {\n    const parent = this._injector.get(\'_parent\', false);\n    if (!parent) {\n      return false;\n    }\n    const root = this._sheet.getRoot();\n    const definitions = getDefinitions(root);\n    return !!parent.getView(definitions);\n  }\n}\nViewDrd.$inject = [\'components\', \'eventBus\', \'injector\', \'sheet\'];\n\n// helpers //////////////////////\n\nfunction getDefinitions(root) {\n  const businessObject = root.businessObject;\n\n  // root might not have business object\n  if (!businessObject) {\n    return;\n  }\n  const decision = businessObject.$parent;\n  const definitions = decision.$parent;\n  return definitions;\n}\n//# sourceMappingURL=ViewDrd.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/view-drd/index.js\n\n/* harmony default export */ const view_drd = ({\n  __init__: [\'viewDrd\'],\n  viewDrd: [\'type\', ViewDrd]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/components/Logo.js\nvar Logo = __webpack_require__("./node_modules/dmn-js-shared/lib/components/Logo.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/powered-by/components/PoweredByLogoComponent.js\n\nfunction PoweredByLogoComponent_defineProperty(obj, key, value) { key = PoweredByLogoComponent_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction PoweredByLogoComponent_toPropertyKey(arg) { var key = PoweredByLogoComponent_toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }\nfunction PoweredByLogoComponent_toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\n\n\nclass PoweredByLogoComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    PoweredByLogoComponent_defineProperty(this, "onClick", () => {\n      this._eventBus.fire(\'poweredBy.show\');\n    });\n    const injector = context.injector;\n    this._eventBus = injector.get(\'eventBus\');\n  }\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "powered-by", (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "powered-by__logo", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Logo/* default */.Z), 2, {\n      "title": "Powered by bpmn.io",\n      "onClick": this.onClick\n    }, null, node => this.node = node), 2);\n  }\n}\n//# sourceMappingURL=PoweredByLogoComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/powered-by/components/PoweredByOverlayComponent.js\n\n\n\nclass PoweredByOverlayComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props) {\n    super(props);\n    this.state = {\n      show: false\n    };\n    this.onClick = this.onClick.bind(this);\n    this.onShow = this.onShow.bind(this);\n  }\n  onClick() {\n    this.setState({\n      show: false\n    });\n  }\n  onShow() {\n    this.setState({\n      show: true\n    });\n  }\n  componentWillMount() {\n    const eventBus = this._eventBus = this.context.injector.get(\'eventBus\');\n    eventBus.on(\'poweredBy.show\', this.onShow);\n  }\n  componentWillUnmount() {\n    this._eventBus.off(\'poweredBy.show\', this.onShow);\n  }\n  render() {\n    const show = this.state.show;\n    return show && (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "powered-by-overlay", (0,inferno_index_esm/* createVNode */.Wm)(1, "div", "powered-by-overlay-content", [(0,inferno_index_esm/* createVNode */.Wm)(1, "a", "logo", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Logo/* default */.Z), 2, {\n      "href": "https://bpmn.io",\n      "target": "_blank",\n      "rel": "noopener"\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, "span", null, [(0,inferno_index_esm/* createTextVNode */.Uk)("Web-based tooling for BPMN, DMN and CMMN diagrams powered by "), (0,inferno_index_esm/* createVNode */.Wm)(1, "a", null, (0,inferno_index_esm/* createTextVNode */.Uk)("bpmn.io"), 2, {\n      "href": "http://bpmn.io",\n      "target": "_blank"\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(".")], 4)], 4, {\n      "onClick": e => e.stopPropagation()\n    }), 2, {\n      "onClick": this.onClick\n    });\n  }\n}\n//# sourceMappingURL=PoweredByOverlayComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/powered-by/PoweredBy.js\n\n\nclass PoweredBy {\n  constructor(components, eventBus) {\n    components.onGetComponent(\'table.before\', () => {\n      return PoweredByLogoComponent;\n    });\n    components.onGetComponent(\'table.before\', () => {\n      return PoweredByOverlayComponent;\n    });\n  }\n}\nPoweredBy.$inject = [\'components\', \'eventBus\'];\n//# sourceMappingURL=PoweredBy.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/powered-by/index.js\n\n/* harmony default export */ const powered_by = ({\n  __init__: [\'poweredBy\'],\n  poweredBy: [\'type\', PoweredBy]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/Viewer.js\nconst _excluded = ["modules", "additionalModules"];\nfunction _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }\nfunction _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @typedef {import(\'dmn-js-shared/lib/base/View).OpenResult} OpenResult\n */\n\n/**\n * @typedef {import(\'dmn-js-shared/lib/base/View).OpenError} OpenError\n */\n\nclass Viewer extends lib/* default */.Z {\n  constructor() {\n    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    const container = Viewer._createContainer();\n    super((0,index_esm/* assign */.f0)(options, {\n      renderer: {\n        container\n      }\n    }));\n    this._container = container;\n  }\n\n  /**\n   * Open diagram element.\n   *\n   * @param  {ModdleElement} decision\n   * @returns {Promise} Resolves with {OpenResult} when successful\n   * or rejects with {OpenError}\n   */\n  open(decision) {\n    var self = this;\n    return new Promise((resolve, reject) => {\n      var err;\n\n      // use try/catch to not swallow synchronous exceptions\n      // that may be raised during model parsing\n      try {\n        if (self._decision) {\n          // clear existing rendered diagram\n          self.clear();\n        }\n\n        // update decision\n        self._decision = decision;\n\n        // perform import\n        return importDecision(self, decision, function (err, warnings) {\n          if (err) {\n            err.warnings = warnings || [];\n            reject(err);\n          } else {\n            resolve({\n              warnings: warnings || []\n            });\n          }\n        });\n      } catch (e) {\n        err = e;\n      }\n\n      // handle synchronously thrown exception\n      if (err) {\n        err.warnings = err.warnings || [];\n        reject(err);\n      } else {\n        resolve({\n          warnings: []\n        });\n      }\n    });\n  }\n\n  /**\n   * Initialize the table, returning { modules: [], config }.\n   *\n   * @param  {Object} options\n   *\n   * @return {Object} init config\n   */\n  _init(options) {\n    let modules = options.modules,\n      additionalModules = options.additionalModules,\n      config = _objectWithoutProperties(options, _excluded);\n    let baseModules = modules || this.getModules();\n    let extraModules = additionalModules || [];\n    let staticModules = [{\n      decisionTable: [\'value\', this]\n    }];\n    let allModules = [powered_by, ...baseModules, ...extraModules, ...staticModules];\n    return {\n      modules: allModules,\n      config\n    };\n  }\n\n  /**\n   * Register an event listener\n   *\n   * Remove a previously added listener via {@link #off(event, callback)}.\n   *\n   * @param {string} event\n   * @param {number} [priority]\n   * @param {Function} callback\n   * @param {Object} [that]\n   */\n  on(event, priority, callback, target) {\n    return this.get(\'eventBus\').on(event, priority, callback, target);\n  }\n\n  /**\n   * De-register an event listener\n   *\n   * @param {string} event\n   * @param {Function} callback\n   */\n  off(event, callback) {\n    this.get(\'eventBus\').off(event, callback);\n  }\n\n  /**\n   * Emit an event on the underlying {@link EventBus}\n   *\n   * @param  {string} type\n   * @param  {Object} event\n   *\n   * @return {Object} event processing result (if any)\n   */\n  _emit(type, event) {\n    return this.get(\'eventBus\').fire(type, event);\n  }\n\n  /**\n   * Attach viewer to given parent node.\n   *\n   * @param  {Element} parentNode\n   */\n  attachTo(parentNode) {\n    if (!parentNode) {\n      throw new Error(\'parentNode required\');\n    }\n\n    // ensure we detach from the\n    // previous, old parent\n    this.detach();\n    const container = this._container;\n    parentNode.appendChild(container);\n    this._emit(\'attach\', {});\n  }\n\n  /**\n   * Detach viewer from parent node, if attached.\n   */\n  detach() {\n    const container = this._container,\n      parentNode = container.parentNode;\n    if (!parentNode) {\n      return;\n    }\n    this._emit(\'detach\', {});\n    (0,dist_index_esm/* remove */.Od)(container);\n  }\n  destroy() {\n    super.destroy();\n    this.detach();\n  }\n  getModules() {\n    return Viewer._getModules();\n  }\n  static _getModules() {\n    return [annotations, core, translate/* default */.Z, decision_table_head, decision_table_properties, decision_rule_indices, decision_rules/* default */.Z, hit_policy, view_drd];\n  }\n  static _createContainer() {\n    return (0,dist_index_esm/* domify */.H6)(\'<div class="dmn-decision-table-container"></div>\');\n  }\n}\n//# sourceMappingURL=Viewer.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-decision-table/lib/Viewer.js_+_28_modules?')},"./node_modules/dmn-js-decision-table/lib/features/annotations/components/AnnotationHeader.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ AnnotationHeader)\n/* harmony export */ });\n/* harmony import */ var inferno__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/inferno/index.esm.js");\n/* harmony import */ var table_js_lib_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./node_modules/table-js/lib/components/utils/mixin.js");\n/* harmony import */ var table_js_lib_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./node_modules/table-js/lib/components/utils/inject.js");\n/* harmony import */ var dmn_js_shared_lib_components_mixins__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/dmn-js-shared/lib/components/mixins/index.js");\n\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\n\n\n\nconst MIN_WIDTH = 400;\nclass AnnotationHeader extends inferno__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .wA {\n  constructor(props, context) {\n    super(props, context);\n    _defineProperty(this, "onElementsChanged", () => {\n      this.forceUpdate();\n    });\n    (0,table_js_lib_components__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(this, dmn_js_shared_lib_components_mixins__WEBPACK_IMPORTED_MODULE_1__/* .ComponentWithSlots */ .t);\n    (0,table_js_lib_components__WEBPACK_IMPORTED_MODULE_3__/* .inject */ .f)(this);\n  }\n  componentDidMount() {\n    this.changeSupport.onElementsChanged(this.getRoot(), this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    this.changeSupport.offElementsChanged(this.getRoot(), this.onElementsChanged);\n  }\n  getRoot() {\n    return this.sheet.getRoot();\n  }\n  render() {\n    const decisionTable = this.getRoot();\n    const annotationsWidth = decisionTable.businessObject.get(\'annotationsWidth\');\n    const width = (annotationsWidth || MIN_WIDTH) + \'px\';\n    return (0,inferno__WEBPACK_IMPORTED_MODULE_0__/* .createVNode */ .Wm)(1, "th", "annotation header", [this.slotFills({\n      type: \'cell-inner\',\n      context: {\n        cellType: \'annotations\',\n        col: this.sheet.getRoot(),\n        minWidth: MIN_WIDTH\n      }\n    }), this.translate(\'Annotations\')], 0, {\n      "style": {\n        width\n      }\n    });\n  }\n}\nAnnotationHeader.$inject = [\'changeSupport\', \'sheet\', \'translate\'];\n//# sourceMappingURL=AnnotationHeader.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-decision-table/lib/features/annotations/components/AnnotationHeader.js?')},"./node_modules/dmn-js-decision-table/lib/features/decision-rules/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "Z": () => (/* binding */ decision_rules)\n});\n\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/features/expression-languages/index.js + 1 modules\nvar expression_languages = __webpack_require__("./node_modules/dmn-js-shared/lib/features/expression-languages/index.js");\n// EXTERNAL MODULE: ./node_modules/inferno/index.esm.js + 1 modules\nvar index_esm = __webpack_require__("./node_modules/inferno/index.esm.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/components/DecisionRulesBodyComponent.js\n\n\nclass DecisionRulesBodyComponent extends index_esm/* Component */.wA {\n  render(_ref) {\n    let rows = _ref.rows,\n      cols = _ref.cols;\n    const components = this.context.components;\n    return (0,index_esm/* createVNode */.Wm)(1, "tbody", null, rows.map((row, rowIndex) => {\n      const RowComponent = components.getComponent(\'row\', {\n        rowType: \'rule\'\n      });\n      return RowComponent && (0,index_esm/* createComponentVNode */.Iz)(2, RowComponent, {\n        "row": row,\n        "rowIndex": rowIndex,\n        "cols": cols\n      }, row.id);\n    }), 0);\n  }\n}\n//# sourceMappingURL=DecisionRulesBodyComponent.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/utils/mixin.js\nvar mixin = __webpack_require__("./node_modules/table-js/lib/components/utils/mixin.js");\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/components/mixins/index.js + 1 modules\nvar mixins = __webpack_require__("./node_modules/dmn-js-shared/lib/components/mixins/index.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/components/DecisionRulesRowComponent.js\n\n\n\n\nclass DecisionRulesRowComponent extends index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    (0,mixin/* default */.Z)(this, mixins/* ComponentWithSlots */.t);\n  }\n  render() {\n    const _this$props = this.props,\n      row = _this$props.row,\n      rowIndex = _this$props.rowIndex,\n      cols = _this$props.cols;\n    const cells = row.cells;\n    return (0,index_esm/* createVNode */.Wm)(1, "tr", null, [this.slotFills({\n      type: \'cell\',\n      context: {\n        cellType: \'before-rule-cells\',\n        row,\n        rowIndex\n      }\n    }), cells.map((cell, colIndex) => {\n      return this.slotFill({\n        type: \'cell\',\n        context: {\n          cellType: \'rule\',\n          cell,\n          rowIndex: rowIndex,\n          colIndex: colIndex\n        },\n        key: cell.id,\n        row,\n        col: cols[colIndex]\n      });\n    }), this.slotFills({\n      type: \'cell\',\n      context: {\n        cellType: \'after-rule-cells\',\n        row,\n        rowIndex\n      }\n    })], 0);\n  }\n}\n//# sourceMappingURL=DecisionRulesRowComponent.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/Cell.js\nvar Cell = __webpack_require__("./node_modules/table-js/lib/components/Cell.js");\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__("./node_modules/dmn-js-shared/lib/util/ModelUtil.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/components/DecisionRulesCellComponent.js\n\n\n\n\nclass DecisionRulesCellComponent extends index_esm/* Component */.wA {\n  render() {\n    const _this$props = this.props,\n      cell = _this$props.cell,\n      row = _this$props.row,\n      col = _this$props.col;\n    if ((0,ModelUtil.is)(cell, \'dmn:UnaryTests\')) {\n      return (0,index_esm/* createComponentVNode */.Iz)(2, Cell/* default */.Z, {\n        "className": "input-cell",\n        "elementId": cell.id,\n        "data-row-id": row.id,\n        "data-col-id": col.id,\n        children: cell.businessObject.text\n      });\n    } else {\n      return (0,index_esm/* createComponentVNode */.Iz)(2, Cell/* default */.Z, {\n        "className": "output-cell",\n        "elementId": cell.id,\n        "data-row-id": row.id,\n        "data-col-id": col.id,\n        children: cell.businessObject.text\n      });\n    }\n  }\n}\n//# sourceMappingURL=DecisionRulesCellComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/DecisionRules.js\n\n\n\nclass Rules {\n  constructor(components) {\n    components.onGetComponent(\'table.body\', () => DecisionRulesBodyComponent);\n    components.onGetComponent(\'row\', _ref => {\n      let rowType = _ref.rowType;\n      if (rowType === \'rule\') {\n        return DecisionRulesRowComponent;\n      }\n    });\n    components.onGetComponent(\'cell\', _ref2 => {\n      let cellType = _ref2.cellType;\n      if (cellType === \'rule\') {\n        return DecisionRulesCellComponent;\n      }\n    });\n  }\n}\nRules.$inject = [\'components\'];\n//# sourceMappingURL=DecisionRules.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/index.js\n\n\n/* harmony default export */ const decision_rules = ({\n  __depends__: [expression_languages/* default */.Z],\n  __init__: [\'decisionRules\'],\n  decisionRules: [\'type\', Rules]\n});\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-decision-table/lib/features/decision-rules/index.js_+_4_modules?')},"./node_modules/dmn-js-decision-table/lib/features/hit-policy/HitPolicies.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"s\": () => (/* binding */ HIT_POLICIES)\n/* harmony export */ });\n/* eslint max-len: 0 */\nconst HIT_POLICIES = [{\n  label: 'Unique',\n  value: {\n    hitPolicy: 'UNIQUE',\n    aggregation: undefined\n  },\n  explanation: 'No overlap is possible and all rules are disjoint. Only a single rule can be matched'\n}, {\n  label: 'First',\n  value: {\n    hitPolicy: 'FIRST',\n    aggregation: undefined\n  },\n  explanation: 'Rules may overlap. The first matching rule will be chosen'\n}, {\n  label: 'Priority',\n  value: {\n    hitPolicy: 'PRIORITY',\n    aggregation: undefined\n  },\n  explanation: 'Rules may overlap. The one with the highest priority will be chosen'\n}, {\n  label: 'Any',\n  value: {\n    hitPolicy: 'ANY',\n    aggregation: undefined\n  },\n  explanation: 'Rules may overlap. Their output have to match'\n}, {\n  label: 'Collect',\n  value: {\n    hitPolicy: 'COLLECT',\n    aggregation: undefined\n  },\n  explanation: 'Collects the values of all matching rules'\n}, {\n  label: 'Collect (Sum)',\n  value: {\n    hitPolicy: 'COLLECT',\n    aggregation: 'SUM'\n  },\n  explanation: 'Collects the values of all matching rules and sums up to a single value'\n}, {\n  label: 'Collect (Min)',\n  value: {\n    hitPolicy: 'COLLECT',\n    aggregation: 'MIN'\n  },\n  explanation: 'Collects the values of all matching rules and uses the lowest value'\n}, {\n  label: 'Collect (Max)',\n  value: {\n    hitPolicy: 'COLLECT',\n    aggregation: 'MAX'\n  },\n  explanation: 'Collects the values of all matching rules and uses the highest value'\n}, {\n  label: 'Collect (Count)',\n  value: {\n    hitPolicy: 'COLLECT',\n    aggregation: 'COUNT'\n  },\n  explanation: 'Collects the values of all matching rules and counts the number of them'\n}, {\n  label: 'Rule order',\n  value: {\n    hitPolicy: 'RULE ORDER',\n    aggregation: undefined\n  },\n  explanation: 'Collects the values of all matching rules in rule order'\n}, {\n  label: 'Output order',\n  value: {\n    hitPolicy: 'OUTPUT ORDER',\n    aggregation: undefined\n  },\n  explanation: 'Collects the values of all matching rules in decreasing output priority order'\n}];\n//# sourceMappingURL=HitPolicies.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-decision-table/lib/features/hit-policy/HitPolicies.js?")},"./node_modules/dmn-js-drd/lib/Viewer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ Viewer)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/Diagram.js + 7 modules\nvar Diagram = __webpack_require__(\"./node_modules/diagram-js/lib/Diagram.js\");\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/dmn-js-drd/node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/dmn-js-drd/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/object-refs/index.js\nvar object_refs = __webpack_require__(\"./node_modules/object-refs/index.js\");\nvar object_refs_default = /*#__PURE__*/__webpack_require__.n(object_refs);\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/dmn-js-shared/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/import/DrdTreeWalker.js\n\n\n\nvar diRefs = new (object_refs_default())({\n  name: 'dmnElementRef',\n  enumerable: true\n}, {\n  name: 'di',\n  configurable: true\n});\nfunction DRDTreeWalker(handler, options) {\n  // list of elements to handle deferred to ensure\n  // prerequisites are drawn\n  var deferred = [];\n  function visit(element) {\n    var gfx = element.gfx;\n\n    // avoid multiple rendering of elements\n    if (gfx) {\n      throw new Error('already rendered ' + element.id);\n    }\n\n    // call handler\n    return handler.element(element);\n  }\n  function visitRoot(element) {\n    return handler.root(element);\n  }\n  function visitIfDi(element) {\n    try {\n      var gfx = element.di && visit(element);\n      return gfx;\n    } catch (e) {\n      logError(e.message, {\n        element: element,\n        error: e\n      });\n    }\n  }\n\n  // Semantic handling //////////////////////\n\n  /**\n   * Handle definitions and return the rendered diagram (if any)\n   *\n   * @param {ModdleElement} definitions to walk and import\n   * @param {ModdleElement} [diagram] specific diagram to import and display\n   *\n   * @throws {Error} if no diagram to display could be found\n   */\n  function handleDefinitions(definitions, diagram) {\n    // make sure we walk the correct dmnElement\n    var dmnDI = definitions.dmnDI;\n    if (!dmnDI) {\n      throw new Error('no dmndi:DMNDI');\n    }\n    var diagrams = dmnDI.diagrams || [];\n    if (diagram && diagrams.indexOf(diagram) === -1) {\n      throw new Error('diagram not part of dmndi:DMNDI');\n    }\n    if (!diagram && diagrams && diagrams.length) {\n      diagram = diagrams[0];\n    }\n\n    // no diagram -> nothing to import\n    if (!diagram) {\n      throw new Error('no diagram to display');\n    }\n\n    // assign current diagram to definitions so that it can accessed later\n    definitions.di = diagram;\n\n    // load DI from selected diagram only\n    handleDiagram(diagram);\n    visitRoot(definitions);\n    handleDrgElements(definitions.get('drgElement'));\n    handleArtifacts(definitions.get('artifact'));\n    handleDeferred();\n  }\n  function handleDrgElements(elements) {\n    (0,dist_index_esm/* forEach */.Ed)(elements, function (element) {\n      visitIfDi(element);\n      handleRequirements(element);\n    });\n  }\n  function handleArtifacts(elements) {\n    (0,dist_index_esm/* forEach */.Ed)(elements, function (element) {\n      if ((0,ModelUtil.is)(element, 'dmn:Association')) {\n        handleAssociation(element);\n      } else {\n        visitIfDi(element);\n      }\n    });\n  }\n\n  /**\n   * Defer association visit until all shapes are visited.\n   *\n   * @param {ModdleElement} element\n   */\n  function handleAssociation(element) {\n    defer(function () {\n      visitIfDi(element);\n    });\n  }\n\n  /**\n   * Defer requirements visiting until all shapes are visited.\n   *\n   * @param {ModdleElement} element\n   */\n  function handleRequirements(element) {\n    (0,dist_index_esm/* forEach */.Ed)(['informationRequirement', 'knowledgeRequirement', 'authorityRequirement'], function (requirements) {\n      (0,dist_index_esm/* forEach */.Ed)(element[requirements], function (requirement) {\n        defer(function () {\n          visitIfDi(requirement);\n        });\n      });\n    });\n  }\n\n  // DI handling //////////////////////\n  function handleDiagram(diagram) {\n    (0,dist_index_esm/* forEach */.Ed)(diagram.diagramElements, handleDiagramElement);\n  }\n  function handleDiagramElement(diagramElement) {\n    registerDi(diagramElement);\n  }\n  function registerDi(di) {\n    var dmnElement = di.dmnElementRef;\n    if (dmnElement) {\n      if (dmnElement.di) {\n        logError('multiple DI elements defined for element', {\n          element: dmnElement\n        });\n      } else {\n        diRefs.bind(dmnElement, 'di');\n        dmnElement.di = di;\n      }\n    } else {\n      logError('no DMN element referenced in element', {\n        element: di\n      });\n    }\n  }\n  function defer(fn) {\n    deferred.push(fn);\n  }\n  function handleDeferred() {\n    (0,dist_index_esm/* forEach */.Ed)(deferred, function (d) {\n      d();\n    });\n  }\n  function logError(message, context) {\n    handler.error(message, context);\n  }\n\n  // API //////////////////////\n\n  return {\n    handleDefinitions: handleDefinitions\n  };\n}\n//# sourceMappingURL=DrdTreeWalker.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/import/Importer.js\n\n\n/**\n * Import the definitions into a diagram.\n *\n * Errors and warnings are reported through the specified callback.\n *\n * @param  {Drd} drd\n * @param  {ModdleElement} definitions\n * @param  {Function} done\n *         the callback, invoked with (err, [ warning ]) once the import is done\n */\nfunction importDRD(drd, definitions, done) {\n  var importer = drd.get('drdImporter'),\n    eventBus = drd.get('eventBus');\n  var error,\n    warnings = [];\n  function render(definitions) {\n    var visitor = {\n      root: function root(element) {\n        return importer.root(element);\n      },\n      element: function element(_element, di) {\n        return importer.add(_element, di);\n      },\n      error: function error(message, context) {\n        warnings.push({\n          message: message,\n          context: context\n        });\n      }\n    };\n    var walker = new DRDTreeWalker(visitor);\n\n    // import\n    walker.handleDefinitions(definitions);\n  }\n  eventBus.fire('import.start', {\n    definitions: definitions\n  });\n  try {\n    render(definitions);\n  } catch (e) {\n    error = e;\n  }\n  eventBus.fire('import.done', {\n    error: error,\n    warnings: warnings\n  });\n  done(error, warnings);\n}\n//# sourceMappingURL=Importer.js.map\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/util/CompatibilityUtils.js\nvar CompatibilityUtils = __webpack_require__(\"./node_modules/dmn-js-shared/lib/util/CompatibilityUtils.js\");\n// EXTERNAL MODULE: ./node_modules/ids/dist/index.esm.js\nvar ids_dist_index_esm = __webpack_require__(\"./node_modules/ids/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/draw/BaseRenderer.js\nvar BaseRenderer = __webpack_require__(\"./node_modules/diagram-js/lib/draw/BaseRenderer.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/RenderUtil.js\nvar RenderUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/RenderUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/draw/DrdRenderer.js\n\n\n\n\n\n\n\n\nvar RENDERER_IDS = new ids_dist_index_esm/* default */.Z();\nvar black = 'hsl(225, 10%, 15%)';\n\n/**\n * Renderer for the DRD view. The default colors are configurable.\n * When default label color is not provided, it will take the default\n * stroke color.\n *\n * @example\n * ```javascript\n * // for simple DRD viewer\n * const viewer = new DrdViewer({\n *   drdRenderer: {\n *     defaultFillColor: '#ffd700',\n *     defaultStrokeColor: '#0057b8',\n *     defaultLabelColor: '#0057b8'\n *   }\n * });\n *\n * // in dmn-js\n * const modeler = new DmnModeler({\n *   drd: {\n *     drdRenderer: {\n *       defaultFillColor: '#ffd700',\n *       defaultStrokeColor: '#0057b8',\n *       defaultLabelColor: '#0057b8'\n *     }\n *   }\n * });\n * ```\n */\nfunction DrdRenderer(config, eventBus, pathMap, styles, textRenderer, canvas) {\n  BaseRenderer/* default.call */.Z.call(this, eventBus);\n  var rendererId = RENDERER_IDS.next();\n  var computeStyle = styles.computeStyle;\n  var markers = {};\n  var defaultFillColor = config && config.defaultFillColor || 'white',\n    defaultStrokeColor = config && config.defaultStrokeColor || black,\n    defaultLabelColor = config && config.defaultLabelColor;\n  function marker(type, fill, stroke) {\n    var id = type + '-' + colorEscape(fill) + '-' + colorEscape(stroke) + '-' + rendererId;\n    if (!markers[id]) {\n      createMarker(id, type, fill, stroke);\n    }\n    return 'url(#' + id + ')';\n  }\n  function addMarker(id, options) {\n    var attrs = (0,dist_index_esm/* assign */.f0)({\n      strokeWidth: 1,\n      strokeLinecap: 'round',\n      strokeDasharray: 'none'\n    }, options.attrs);\n    var ref = options.ref || {\n      x: 0,\n      y: 0\n    };\n    var scale = options.scale || 1;\n\n    // fix for safari / chrome / firefox bug not correctly\n    // resetting stroke dash array\n    if (attrs.strokeDasharray === 'none') {\n      attrs.strokeDasharray = [10000, 1];\n    }\n    var marker = (0,tiny_svg_dist_index_esm/* create */.Ue)('marker');\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(options.element, attrs);\n    (0,tiny_svg_dist_index_esm/* append */.R3)(marker, options.element);\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(marker, {\n      id: id,\n      viewBox: '0 0 20 20',\n      refX: ref.x,\n      refY: ref.y,\n      markerWidth: 20 * scale,\n      markerHeight: 20 * scale,\n      orient: 'auto'\n    });\n    var defs = (0,index_esm/* query */.IO)('defs', canvas._svg);\n    if (!defs) {\n      defs = (0,tiny_svg_dist_index_esm/* create */.Ue)('defs');\n      (0,tiny_svg_dist_index_esm/* append */.R3)(canvas._svg, defs);\n    }\n    (0,tiny_svg_dist_index_esm/* append */.R3)(defs, marker);\n    markers[id] = marker;\n  }\n  function createMarker(id, type, fill, stroke) {\n    if (type === 'association-start') {\n      var associationStart = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(associationStart, {\n        d: 'M 11 5 L 1 10 L 11 15'\n      });\n      addMarker(id, {\n        element: associationStart,\n        attrs: {\n          fill: 'none',\n          stroke: stroke,\n          strokeWidth: 1.5\n        },\n        ref: {\n          x: 1,\n          y: 10\n        },\n        scale: 0.5\n      });\n    } else if (type === 'association-end') {\n      var associationEnd = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(associationEnd, {\n        d: 'M 1 5 L 11 10 L 1 15'\n      });\n      addMarker(id, {\n        element: associationEnd,\n        attrs: {\n          fill: 'none',\n          stroke: stroke,\n          strokeWidth: 1.5\n        },\n        ref: {\n          x: 12,\n          y: 10\n        },\n        scale: 0.5\n      });\n    } else if (type === 'information-requirement-end') {\n      var informationRequirementEnd = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(informationRequirementEnd, {\n        d: 'M 1 5 L 11 10 L 1 15 Z'\n      });\n      addMarker(id, {\n        element: informationRequirementEnd,\n        attrs: {\n          fill: stroke,\n          stroke: 'none'\n        },\n        ref: {\n          x: 11,\n          y: 10\n        },\n        scale: 1\n      });\n    } else if (type === 'knowledge-requirement-end') {\n      var knowledgeRequirementEnd = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(knowledgeRequirementEnd, {\n        d: 'M 1 3 L 11 10 L 1 17'\n      });\n      addMarker(id, {\n        element: knowledgeRequirementEnd,\n        attrs: {\n          fill: 'none',\n          stroke: stroke,\n          strokeWidth: 2\n        },\n        ref: {\n          x: 11,\n          y: 10\n        },\n        scale: 0.8\n      });\n    } else if (type === 'authority-requirement-end') {\n      var authorityRequirementEnd = (0,tiny_svg_dist_index_esm/* create */.Ue)('circle');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(authorityRequirementEnd, {\n        cx: 3,\n        cy: 3,\n        r: 3\n      });\n      addMarker(id, {\n        element: authorityRequirementEnd,\n        attrs: {\n          fill: stroke,\n          stroke: 'none'\n        },\n        ref: {\n          x: 3,\n          y: 3\n        },\n        scale: 0.9\n      });\n    }\n  }\n  function drawRect(p, width, height, r, offset, attrs) {\n    if ((0,dist_index_esm/* isObject */.Kn)(offset)) {\n      attrs = offset;\n      offset = 0;\n    }\n    offset = offset || 0;\n    attrs = computeStyle(attrs, {\n      stroke: black,\n      strokeWidth: 2,\n      fill: 'white'\n    });\n    var rect = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(rect, {\n      x: offset,\n      y: offset,\n      width: width - offset * 2,\n      height: height - offset * 2,\n      rx: r,\n      ry: r\n    });\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(rect, attrs);\n    (0,tiny_svg_dist_index_esm/* append */.R3)(p, rect);\n    return rect;\n  }\n  function renderLabel(p, label, options) {\n    var text = textRenderer.createText(label || '', options);\n    (0,index_esm/* attr */.Lj)(text, 'class', 'djs-label');\n    (0,tiny_svg_dist_index_esm/* append */.R3)(p, text);\n    return text;\n  }\n  function renderEmbeddedLabel(p, element, align, options) {\n    var name = (0,ModelUtil/* getName */.oY)(element);\n    options = (0,dist_index_esm/* assign */.f0)({\n      box: element,\n      align: align,\n      padding: 5,\n      style: {\n        fill: getLabelColor(element, defaultLabelColor, defaultStrokeColor)\n      }\n    }, options);\n    return renderLabel(p, name, options);\n  }\n  function drawPath(p, d, attrs) {\n    attrs = computeStyle(attrs, ['no-fill'], {\n      strokeWidth: 2,\n      stroke: black\n    });\n    var path = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(path, {\n      d: d\n    });\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(path, attrs);\n    (0,tiny_svg_dist_index_esm/* append */.R3)(p, path);\n    return path;\n  }\n  var handlers = {\n    'dmn:Decision': function dmnDecision(p, element) {\n      var rect = drawRect(p, element.width, element.height, 0, {\n        stroke: getStrokeColor(element, defaultStrokeColor),\n        fill: getFillColor(element, defaultFillColor)\n      });\n      renderEmbeddedLabel(p, element, 'center-middle');\n      return rect;\n    },\n    'dmn:KnowledgeSource': function dmnKnowledgeSource(p, element) {\n      var pathData = pathMap.getScaledPath('KNOWLEDGE_SOURCE', {\n        xScaleFactor: 1.021,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.0,\n          my: 0.075\n        }\n      });\n      var knowledgeSource = drawPath(p, pathData, {\n        strokeWidth: 2,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n      renderEmbeddedLabel(p, element, 'center-middle');\n      return knowledgeSource;\n    },\n    'dmn:BusinessKnowledgeModel': function dmnBusinessKnowledgeModel(p, element) {\n      var pathData = pathMap.getScaledPath('BUSINESS_KNOWLEDGE_MODEL', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.0,\n          my: 0.3\n        }\n      });\n      var businessKnowledge = drawPath(p, pathData, {\n        strokeWidth: 2,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n      renderEmbeddedLabel(p, element, 'center-middle');\n      return businessKnowledge;\n    },\n    'dmn:InputData': function dmnInputData(p, element) {\n      var rect = drawRect(p, element.width, element.height, 22, {\n        stroke: getStrokeColor(element, defaultStrokeColor),\n        fill: getFillColor(element, defaultFillColor)\n      });\n      renderEmbeddedLabel(p, element, 'center-middle');\n      return rect;\n    },\n    'dmn:TextAnnotation': function dmnTextAnnotation(p, element) {\n      var style = {\n        'fill': 'none',\n        'stroke': 'none'\n      };\n      var textElement = drawRect(p, element.width, element.height, 0, 0, style);\n      var textPathData = pathMap.getScaledPath('TEXT_ANNOTATION', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.0,\n          my: 0.0\n        }\n      });\n      drawPath(p, textPathData, {\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n      var text = getSemantic(element).text || '';\n      renderLabel(p, text, {\n        style: {\n          fill: getLabelColor(element, defaultLabelColor, defaultStrokeColor)\n        },\n        box: element,\n        align: 'left-top',\n        padding: 5\n      });\n      return textElement;\n    },\n    'dmn:Association': function dmnAssociation(p, element) {\n      var semantic = getSemantic(element);\n      var fill = getFillColor(element, defaultFillColor),\n        stroke = getStrokeColor(element, defaultStrokeColor),\n        attrs = {\n          stroke: stroke,\n          strokeDasharray: '0.5, 5',\n          strokeLinecap: 'round',\n          strokeLinejoin: 'round',\n          fill: 'none'\n        };\n      if (semantic.associationDirection === 'One' || semantic.associationDirection === 'Both') {\n        attrs.markerEnd = marker('association-end', fill, stroke);\n      }\n      if (semantic.associationDirection === 'Both') {\n        attrs.markerStart = marker('association-start', fill, stroke);\n      }\n      return drawLine(p, element.waypoints, attrs);\n    },\n    'dmn:InformationRequirement': function dmnInformationRequirement(p, element) {\n      var fill = getFillColor(element, defaultFillColor),\n        stroke = getStrokeColor(element, defaultStrokeColor),\n        attrs = {\n          stroke: stroke,\n          strokeWidth: 1,\n          strokeLinecap: 'round',\n          strokeLinejoin: 'round',\n          markerEnd: marker('information-requirement-end', fill, stroke)\n        };\n      return drawLine(p, element.waypoints, attrs);\n    },\n    'dmn:KnowledgeRequirement': function dmnKnowledgeRequirement(p, element) {\n      var fill = getFillColor(element, defaultFillColor),\n        stroke = getStrokeColor(element, defaultStrokeColor);\n      var attrs = {\n        stroke: stroke,\n        strokeWidth: 1,\n        strokeDasharray: 5,\n        strokeLinecap: 'round',\n        strokeLinejoin: 'round',\n        markerEnd: marker('knowledge-requirement-end', fill, stroke)\n      };\n      return drawLine(p, element.waypoints, attrs);\n    },\n    'dmn:AuthorityRequirement': function dmnAuthorityRequirement(p, element) {\n      var fill = getFillColor(element, defaultFillColor),\n        stroke = getStrokeColor(element, defaultStrokeColor),\n        attrs = {\n          stroke: stroke,\n          strokeWidth: 1.5,\n          strokeDasharray: 5,\n          strokeLinecap: 'round',\n          strokeLinejoin: 'round',\n          markerEnd: marker('authority-requirement-end', fill, stroke)\n        };\n      return drawLine(p, element.waypoints, attrs);\n    }\n  };\n\n  // draw shape and connection //////////////////\n\n  function drawShape(parent, element) {\n    var h = handlers[element.type];\n    if (!h) {\n      return BaseRenderer/* default.prototype.drawShape.apply */.Z.prototype.drawShape.apply(this, [parent, element]);\n    } else {\n      return h(parent, element);\n    }\n  }\n  function drawConnection(parent, element) {\n    var type = element.type;\n    var h = handlers[type];\n    if (!h) {\n      return BaseRenderer/* default.prototype.drawConnection.apply */.Z.prototype.drawConnection.apply(this, [parent, element]);\n    } else {\n      return h(parent, element);\n    }\n  }\n  function drawLine(p, waypoints, attrs) {\n    attrs = computeStyle(attrs, ['no-fill'], {\n      stroke: black,\n      strokeWidth: 2,\n      fill: 'none'\n    });\n    var line = (0,RenderUtil/* createLine */.W5)(waypoints, attrs);\n    (0,tiny_svg_dist_index_esm/* append */.R3)(p, line);\n    return line;\n  }\n  this.canRender = function (element) {\n    return (0,ModelUtil.is)(element, 'dmn:DMNElement') || (0,ModelUtil.is)(element, 'dmn:InformationRequirement') || (0,ModelUtil.is)(element, 'dmn:KnowledgeRequirement') || (0,ModelUtil.is)(element, 'dmn:AuthorityRequirement');\n  };\n  this.drawShape = drawShape;\n  this.drawConnection = drawConnection;\n}\n(0,index_es/* default */.Z)(DrdRenderer, BaseRenderer/* default */.Z);\nDrdRenderer.$inject = ['config.drdRenderer', 'eventBus', 'pathMap', 'styles', 'textRenderer', 'canvas'];\n\n// helper functions //////////////////////\n\nfunction getSemantic(element) {\n  return element.businessObject;\n}\nfunction colorEscape(str) {\n  // only allow characters and numbers\n  return str.replace(/[^0-9a-zA-z]+/g, '_');\n}\nfunction getStrokeColor(element, defaultColor) {\n  return defaultColor;\n}\nfunction getFillColor(element, defaultColor) {\n  return defaultColor;\n}\nfunction getLabelColor(element, defaultColor, defaultStrokeColor) {\n  return defaultColor || getStrokeColor(element, defaultStrokeColor);\n}\n//# sourceMappingURL=DrdRenderer.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Text.js\nvar Text = __webpack_require__(\"./node_modules/diagram-js/lib/util/Text.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/draw/TextRenderer.js\n\n\nvar DEFAULT_FONT_SIZE = 12;\nvar LINE_HEIGHT_RATIO = 1.2;\nvar MIN_TEXT_ANNOTATION_HEIGHT = 30;\nfunction TextRenderer(config) {\n  var defaultStyle = (0,dist_index_esm/* assign */.f0)({\n    fontFamily: 'Arial, sans-serif',\n    fontSize: DEFAULT_FONT_SIZE,\n    fontWeight: 'normal',\n    lineHeight: LINE_HEIGHT_RATIO\n  }, config && config.defaultStyle || {});\n  var fontSize = parseInt(defaultStyle.fontSize, 10) - 1;\n  var externalStyle = (0,dist_index_esm/* assign */.f0)({}, defaultStyle, {\n    fontSize: fontSize\n  }, config && config.externalStyle || {});\n  var textUtil = new Text/* default */.Z({\n    style: defaultStyle\n  });\n\n  /**\n   * Get the new bounds of an externally rendered,\n   * layouted label.\n   *\n   * @param  {Bounds} bounds\n   * @param  {string} text\n   *\n   * @return {Bounds}\n   */\n  this.getExternalLabelBounds = function (bounds, text) {\n    var layoutedDimensions = textUtil.getDimensions(text, {\n      box: {\n        width: 90,\n        height: 30,\n        x: bounds.width / 2 + bounds.x,\n        y: bounds.height / 2 + bounds.y\n      },\n      style: externalStyle\n    });\n\n    // resize label shape to fit label text\n    return {\n      x: Math.round(bounds.x + bounds.width / 2 - layoutedDimensions.width / 2),\n      y: Math.round(bounds.y),\n      width: Math.ceil(layoutedDimensions.width),\n      height: Math.ceil(layoutedDimensions.height)\n    };\n  };\n\n  /**\n   * Get the new bounds of text annotation.\n   *\n   * @param  {Bounds} bounds\n   * @param  {string} text\n   *\n   * @return {Bounds}\n   */\n  this.getTextAnnotationBounds = function (bounds, text) {\n    var layoutedDimensions = textUtil.getDimensions(text, {\n      box: bounds,\n      style: defaultStyle,\n      align: 'left-top',\n      padding: 5\n    });\n    return {\n      x: bounds.x,\n      y: bounds.y,\n      width: bounds.width,\n      height: Math.max(MIN_TEXT_ANNOTATION_HEIGHT, Math.round(layoutedDimensions.height))\n    };\n  };\n\n  /**\n   * Create a layouted text element.\n   *\n   * @param {string} text\n   * @param {Object} [options]\n   *\n   * @return {SVGElement} rendered text\n   */\n  this.createText = function (text, options) {\n    return textUtil.createText(text, options || {});\n  };\n\n  /**\n   * Get default text style.\n   */\n  this.getDefaultStyle = function () {\n    return defaultStyle;\n  };\n\n  /**\n   * Get the external text style.\n   */\n  this.getExternalStyle = function () {\n    return externalStyle;\n  };\n}\nTextRenderer.$inject = ['config.textRenderer'];\n//# sourceMappingURL=TextRenderer.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/draw/PathMap.js\n/* eslint-disable max-len */\n\n/**\n * Map containing SVG paths needed by BpmnRenderer.\n */\n\nfunction PathMap() {\n  /**\n   * Contains a map of path elements\n   *\n   * <h1>Path definition</h1>\n   * A parameterized path is defined like this:\n   * <pre>\n   * 'GATEWAY_PARALLEL': {\n   *   d: 'm {mx},{my} {e.x0},0 0,{e.x1} {e.x1},0 0,{e.y0} -{e.x1},0 0,{e.y1} ' +\n          '-{e.x0},0 0,-{e.y1} -{e.x1},0 0,-{e.y0} {e.x1},0 z',\n   *   height: 17.5,\n   *   width:  17.5,\n   *   heightElements: [2.5, 7.5],\n   *   widthElements: [2.5, 7.5]\n   * }\n   * </pre>\n   * <p>It's important to specify a correct <b>height and width</b> for the path as the scaling\n   * is based on the ratio between the specified height and width in this object and the\n   * height and width that is set as scale target (Note x,y coordinates will be scaled with\n   * individual ratios).</p>\n   * <p>The '<b>heightElements</b>' and '<b>widthElements</b>' array must contain the values that will be scaled.\n   * The scaling is based on the computed ratios.\n   * Coordinates on the y axis should be in the <b>heightElement</b>'s array, they will be scaled using\n   * the computed ratio coefficient.\n   * In the parameterized path the scaled values can be accessed through the 'e' object in {} brackets.\n   *   <ul>\n   *    <li>The values for the y axis can be accessed in the path string using {e.y0}, {e.y1}, ....</li>\n   *    <li>The values for the x axis can be accessed in the path string using {e.x0}, {e.x1}, ....</li>\n   *   </ul>\n   *   The numbers x0, x1 respectively y0, y1, ... map to the corresponding array index.\n   * </p>\n    m1,1\n    l 0,55.3\n    c 29.8,19.7 48.4,-4.2 67.2,-6.7\n    c 12.2,-2.3 19.8,1.6 30.8,6.2\n    l 0,-54.6\n    z\n    */\n  this.pathMap = {\n    'KNOWLEDGE_SOURCE': {\n      d: 'm {mx},{my} ' + 'l 0,{e.y0} ' + 'c {e.x0},{e.y1} {e.x1},-{e.y2} {e.x2},-{e.y3} ' + 'c {e.x3},-{e.y4} {e.x4},{e.y5} {e.x5},{e.y6} ' + 'l 0,-{e.y7}z',\n      width: 100,\n      height: 65,\n      widthElements: [29.8, 48.4, 67.2, 12.2, 19.8, 30.8],\n      heightElements: [55.3, 19.7, 4.2, 6.7, 2.3, 1.6, 6.2, 54.6]\n    },\n    'BUSINESS_KNOWLEDGE_MODEL': {\n      d: 'm {mx},{my} l {e.x0},-{e.y0} l {e.x1},0 l 0,{e.y1} l -{e.x2},{e.y2} l -{e.x3},0z',\n      width: 125,\n      height: 45,\n      widthElements: [13.8, 109.2, 13.8, 109.1],\n      heightElements: [13.2, 29.8, 13.2]\n    },\n    'TEXT_ANNOTATION': {\n      d: 'm {mx}, {my} m 10,0 l -10,0 l 0,{e.y0} l 10,0',\n      width: 10,\n      height: 30,\n      widthElements: [10],\n      heightElements: [30]\n    }\n  };\n  this.getRawPath = function getRawPath(pathId) {\n    return this.pathMap[pathId].d;\n  };\n\n  /**\n   * Scales the path to the given height and width.\n   * <h1>Use case</h1>\n   * <p>Use case is to scale the content of elements (event, gateways) based\n   * on the element bounding box's size.\n   * </p>\n   * <h1>Why not transform</h1>\n   * <p>Scaling a path with transform() will also scale the stroke and IE does not support\n   * the option 'non-scaling-stroke' to prevent this.\n   * Also there are use cases where only some parts of a path should be\n   * scaled.</p>\n   *\n   * @param {string} pathId The ID of the path.\n   * @param {Object} param <p>\n   *   Example param object scales the path to 60% size of the container (data.width, data.height).\n   *   <pre>\n   *   {\n   *     xScaleFactor: 0.6,\n   *     yScaleFactor:0.6,\n   *     containerWidth: data.width,\n   *     containerHeight: data.height,\n   *     position: {\n   *       mx: 0.46,\n   *       my: 0.2,\n   *     }\n   *   }\n   *   </pre>\n   *   <ul>\n   *    <li>targetpathwidth = xScaleFactor * containerWidth</li>\n   *    <li>targetpathheight = yScaleFactor * containerHeight</li>\n   *    <li>Position is used to set the starting coordinate of the path. M is computed:\n    *    <ul>\n    *      <li>position.x * containerWidth</li>\n    *      <li>position.y * containerHeight</li>\n    *    </ul>\n    *    Center of the container <pre> position: {\n   *       mx: 0.5,\n   *       my: 0.5,\n   *     }</pre>\n   *     Upper left corner of the container\n   *     <pre> position: {\n   *       mx: 0.0,\n   *       my: 0.0,\n   *     }</pre>\n   *    </li>\n   *   </ul>\n   * </p>\n   *\n   */\n  this.getScaledPath = function getScaledPath(pathId, param) {\n    var rawPath = this.pathMap[pathId];\n\n    // positioning\n    // compute the start point of the path\n    var mx, my;\n    if (param.abspos) {\n      mx = param.abspos.x;\n      my = param.abspos.y;\n    } else {\n      mx = param.containerWidth * param.position.mx;\n      my = param.containerHeight * param.position.my;\n    }\n    var coordinates = {}; // map for the scaled coordinates\n    if (param.position) {\n      // path\n      var heightRatio = param.containerHeight / rawPath.height * param.yScaleFactor;\n      var widthRatio = param.containerWidth / rawPath.width * param.xScaleFactor;\n\n      // Apply height ratio\n      for (var heightIndex = 0; heightIndex < rawPath.heightElements.length; heightIndex++) {\n        coordinates['y' + heightIndex] = rawPath.heightElements[heightIndex] * heightRatio;\n      }\n\n      // Apply width ratio\n      for (var widthIndex = 0; widthIndex < rawPath.widthElements.length; widthIndex++) {\n        coordinates['x' + widthIndex] = rawPath.widthElements[widthIndex] * widthRatio;\n      }\n    }\n\n    // Apply value to raw path\n    var path = format(rawPath.d, {\n      mx: mx,\n      my: my,\n      e: coordinates\n    });\n    return path;\n  };\n}\n\n// helpers //////////////////////\n\n// copied and adjusted from https://github.com/adobe-webplatform/Snap.svg/blob/master/src/svg.js\nvar tokenRegex = /\\{([^{}]+)\\}/g,\n  objNotationRegex = /(?:(?:^|\\.)(.+?)(?=\\[|\\.|$|\\()|\\[('|\")(.+?)\\2\\])(\\(\\))?/g; // matches .xxxxx or [\"xxxxx\"] to run over object properties\n\nfunction replacer(all, key, obj) {\n  var res = obj;\n  key.replace(objNotationRegex, function (all, name, quote, quotedName, isFunc) {\n    name = name || quotedName;\n    if (res) {\n      if (name in res) {\n        res = res[name];\n      }\n      typeof res == 'function' && isFunc && (res = res());\n    }\n  });\n  res = (res == null || res == obj ? all : res) + '';\n  return res;\n}\nfunction format(str, obj) {\n  return String(str).replace(tokenRegex, function (all, key) {\n    return replacer(all, key, obj);\n  });\n}\n//# sourceMappingURL=PathMap.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/draw/index.js\n\n\n\n/* harmony default export */ const draw = ({\n  __init__: ['drdRenderer'],\n  drdRenderer: ['type', DrdRenderer],\n  textRenderer: ['type', TextRenderer],\n  pathMap: ['type', PathMap]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/import/DrdImporter.js\n\n\nfunction DrdImporter(eventBus, canvas, elementFactory, elementRegistry) {\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n  this._elementRegistry = elementRegistry;\n  this._elementFactory = elementFactory;\n}\nDrdImporter.$inject = ['eventBus', 'canvas', 'elementFactory', 'elementRegistry'];\nDrdImporter.prototype.root = function (semantic) {\n  var element = this._elementFactory.createRoot(elementData(semantic));\n  this._canvas.setRootElement(element);\n  return element;\n};\n\n/**\n * Add drd element (semantic) to the canvas.\n */\nDrdImporter.prototype.add = function (semantic) {\n  var elementFactory = this._elementFactory,\n    canvas = this._canvas,\n    eventBus = this._eventBus,\n    di = semantic.di;\n  var element, waypoints, source, target, elementDefinition, bounds;\n  if (di.$instanceOf('dmndi:DMNShape')) {\n    bounds = di.bounds;\n    elementDefinition = elementData(semantic, {\n      x: Math.round(bounds.x),\n      y: Math.round(bounds.y),\n      width: Math.round(bounds.width),\n      height: Math.round(bounds.height)\n    });\n    element = elementFactory.createShape(elementDefinition);\n    canvas.addShape(element);\n    eventBus.fire('drdElement.added', {\n      element: element,\n      di: di\n    });\n  } else if (di.$instanceOf('dmndi:DMNEdge')) {\n    waypoints = collectWaypoints(di);\n    source = this._getSource(semantic);\n    target = this._getTarget(semantic);\n    if (source && target) {\n      elementDefinition = elementData(semantic, {\n        hidden: false,\n        source: source,\n        target: target,\n        waypoints: waypoints\n      });\n      element = elementFactory.createConnection(elementDefinition);\n      canvas.addConnection(element);\n      eventBus.fire('drdElement.added', {\n        element: element,\n        di: di\n      });\n    }\n  } else {\n    throw new Error('unknown di for element ' + semantic.id);\n  }\n  return element;\n};\nDrdImporter.prototype._getSource = function (semantic) {\n  var href, elementReference;\n  if ((0,ModelUtil.is)(semantic, 'dmn:Association')) {\n    elementReference = semantic.sourceRef;\n  } else if ((0,ModelUtil.is)(semantic, 'dmn:InformationRequirement')) {\n    elementReference = semantic.requiredDecision || semantic.requiredInput;\n  } else if ((0,ModelUtil.is)(semantic, 'dmn:KnowledgeRequirement')) {\n    elementReference = semantic.requiredKnowledge;\n  } else if ((0,ModelUtil.is)(semantic, 'dmn:AuthorityRequirement')) {\n    elementReference = semantic.requiredDecision || semantic.requiredInput || semantic.requiredAuthority;\n  }\n  if (elementReference) {\n    href = elementReference.href;\n  }\n  if (href) {\n    return this._getShape(getIdFromHref(href));\n  }\n};\nDrdImporter.prototype._getTarget = function (semantic) {\n  if ((0,ModelUtil.is)(semantic, 'dmn:Association')) {\n    return semantic.targetRef && this._getShape(getIdFromHref(semantic.targetRef.href));\n  }\n  return this._getShape(semantic.$parent.id);\n};\nDrdImporter.prototype._getShape = function (id) {\n  return this._elementRegistry.get(id);\n};\n\n// helper /////\nfunction elementData(semantic, attrs) {\n  return (0,dist_index_esm/* assign */.f0)({\n    id: semantic.id,\n    type: semantic.$type,\n    businessObject: semantic\n  }, attrs);\n}\nfunction collectWaypoints(edge) {\n  var waypoints = edge.waypoint;\n  if (waypoints) {\n    return (0,dist_index_esm/* map */.UI)(waypoints, function (waypoint) {\n      var position = {\n        x: waypoint.x,\n        y: waypoint.y\n      };\n      return (0,dist_index_esm/* assign */.f0)({\n        original: position\n      }, position);\n    });\n  }\n}\nfunction getIdFromHref(href) {\n  return href.split('#').pop();\n}\n//# sourceMappingURL=DrdImporter.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/import/index.js\n\n/* harmony default export */ const lib_import = ({\n  drdImporter: ['type', DrdImporter]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/core/index.js\n\n\n/* harmony default export */ const core = ({\n  __depends__: [draw, lib_import]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/i18n/translate/index.js + 1 modules\nvar translate = __webpack_require__(\"./node_modules/diagram-js/lib/i18n/translate/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/overlays/index.js + 2 modules\nvar overlays = __webpack_require__(\"./node_modules/diagram-js/lib/features/overlays/index.js\");\n// EXTERNAL MODULE: ./node_modules/dmn-js-drd/lib/features/definition-properties/viewer.js + 1 modules\nvar viewer = __webpack_require__(\"./node_modules/dmn-js-drd/lib/features/definition-properties/viewer.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/drill-down/DrillDown.js\n\n\nvar PROVIDERS = [{\n  className: 'dmn-icon-decision-table',\n  matches: function matches(el) {\n    var businessObject = el.businessObject;\n    return (0,ModelUtil.is)(businessObject, 'dmn:Decision') && (0,ModelUtil.is)(businessObject.decisionLogic, 'dmn:DecisionTable');\n  }\n}, {\n  className: 'dmn-icon-literal-expression',\n  matches: function matches(el) {\n    var businessObject = el.businessObject;\n    return (0,ModelUtil.is)(businessObject, 'dmn:Decision') && (0,ModelUtil.is)(businessObject.decisionLogic, 'dmn:LiteralExpression');\n  }\n}];\n\n/**\n * Displays overlays that can be clicked in order to drill\n * down into a DMN element.\n */\nclass DrillDown {\n  constructor(injector, eventBus, overlays, config) {\n    this._injector = injector;\n    this._eventBus = eventBus;\n    this._overlays = overlays;\n    this._config = config || {\n      enabled: true\n    };\n    eventBus.on(['shape.added'], _ref => {\n      let element = _ref.element;\n      for (let i = 0; i < PROVIDERS.length; i++) {\n        const _PROVIDERS$i = PROVIDERS[i],\n          matches = _PROVIDERS$i.matches,\n          className = _PROVIDERS$i.className;\n        var editable = matches && matches(element);\n        if (editable) {\n          this.addOverlay(element, className);\n        }\n      }\n    });\n  }\n\n  /**\n   * Add overlay to an element that enables drill down.\n   *\n   * @param {Object} element Element to add overlay to.\n   * @param {string} className\n   *        CSS class that will be added to overlay in order to display icon.\n   */\n  addOverlay(element, className) {\n    const html = (0,index_esm/* domify */.H6)(\"\\n      <div class=\\\"drill-down-overlay\\\">\\n        <span class=\\\"\".concat(className, \"\\\"></span>\\n      </div>\\n    \"));\n    const overlayId = this._overlays.add(element, {\n      position: {\n        top: 2,\n        left: 2\n      },\n      html\n    });\n\n    // TODO(nikku): can we remove renamed to drillDown.enabled\n    if (this._config.enabled !== false) {\n      (0,index_esm/* classes */.Sh)(html).add('interactive');\n      this.bindEventListener(element, html, overlayId);\n    }\n  }\n\n  /**\n   * @param {Object} element\n   * @param {Object} overlay\n   * @param {string} id\n   */\n  bindEventListener(element, overlay, id) {\n    const overlays = this._overlays,\n      eventBus = this._eventBus;\n    const overlaysRoot = overlays._overlayRoot;\n    index_esm/* delegate.bind */.cl.bind(overlaysRoot, '[data-overlay-id=\"' + id + '\"]', 'click', () => {\n      const triggerDefault = eventBus.fire('drillDown.click', {\n        element\n      });\n      if (triggerDefault === false) {\n        return;\n      }\n      this.drillDown(element);\n    });\n  }\n\n  /**\n   * Drill down into the specific element.\n   *\n   * @param  {djs.model.Base} element\n   *\n   * @return {boolean} whether drill down was executed\n   */\n  drillDown(element) {\n    const parent = this._injector.get('_parent', false);\n\n    // no parent; skip drill down\n    if (!parent) {\n      return false;\n    }\n    const view = parent.getView(element.businessObject);\n\n    // no view to drill down to\n    if (!view) {\n      return false;\n    }\n    parent.open(view);\n    return true;\n  }\n}\nDrillDown.$inject = ['injector', 'eventBus', 'overlays', 'config.drillDown'];\n//# sourceMappingURL=DrillDown.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/drill-down/index.js\n\n\n/* harmony default export */ const drill_down = ({\n  __depends__: [overlays/* default */.Z],\n  __init__: ['drillDown'],\n  drillDown: ['type', DrillDown]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/util/PoweredByUtil.js\n/**\n * This file must not be changed or exchanged.\n *\n * @see http://bpmn.io/license for more information.\n */\n\n\n\n// inlined ../../../../resources/logo.svg\n// eslint-disable-next-line\nvar BPMNIO_LOGO_SVG = '<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 14.02 5.57\" width=\"53\" height=\"21\" style=\"vertical-align:middle\"><path fill=\"#000000\" d=\"M1.88.92v.14c0 .41-.13.68-.4.8.33.14.46.44.46.86v.33c0 .61-.33.95-.95.95H0V0h.95c.65 0 .93.3.93.92zM.63.57v1.06h.24c.24 0 .38-.1.38-.43V.98c0-.28-.1-.4-.32-.4zm0 1.63v1.22h.36c.2 0 .32-.1.32-.39v-.35c0-.37-.12-.48-.4-.48H.63zM4.18.99v.52c0 .64-.31.98-.94.98h-.3V4h-.62V0h.92c.63 0 .94.35.94.99zM2.94.57v1.35h.3c.2 0 .3-.09.3-.37v-.6c0-.29-.1-.38-.3-.38h-.3zm2.89 2.27L6.25 0h.88v4h-.6V1.12L6.1 3.99h-.6l-.46-2.82v2.82h-.55V0h.87zM8.14 1.1V4h-.56V0h.79L9 2.4V0h.56v4h-.64zm2.49 2.29v.6h-.6v-.6zM12.12 1c0-.63.33-1 .95-1 .61 0 .95.37.95 1v2.04c0 .64-.34 1-.95 1-.62 0-.95-.37-.95-1zm.62 2.08c0 .28.13.39.33.39s.32-.1.32-.4V.98c0-.29-.12-.4-.32-.4s-.33.11-.33.4z\"/><path fill=\"#000000\" d=\"M0 4.53h14.02v1.04H0zM11.08 0h.63v.62h-.63zm.63 4V1h-.63v2.98z\"/></svg>';\nvar BPMNIO_IMG = BPMNIO_LOGO_SVG;\nfunction css(attrs) {\n  return attrs.join(';');\n}\nvar LIGHTBOX_STYLES = css(['z-index: 1001', 'position: fixed', 'top: 0', 'left: 0', 'right: 0', 'bottom: 0']);\nvar BACKDROP_STYLES = css(['width: 100%', 'height: 100%', 'background: rgba(40,40,40,0.2)']);\nvar NOTICE_STYLES = css(['position: absolute', 'left: 50%', 'top: 40%', 'transform: translate(-50%)', 'width: 260px', 'padding: 10px', 'background: white', 'box-shadow: 0 1px 4px rgba(0,0,0,0.3)', 'font-family: Helvetica, Arial, sans-serif', 'font-size: 14px', 'display: flex', 'line-height: 1.3']);\n\n/* eslint-disable max-len */\nvar LIGHTBOX_MARKUP = '<div class=\"bjs-powered-by-lightbox\" style=\"' + LIGHTBOX_STYLES + '\">' + '<div class=\"backdrop\" style=\"' + BACKDROP_STYLES + '\"></div>' + '<div class=\"notice\" style=\"' + NOTICE_STYLES + '\">' + '<a href=\"https://bpmn.io\" target=\"_blank\" rel=\"noopener\" style=\"margin: 15px 20px 15px 10px; align-self: center;' + '\">' + BPMNIO_IMG + '</a>' + '<span>' + 'Web-based tooling for BPMN, DMN and CMMN diagrams ' + 'powered by <a href=\"https://bpmn.io\" target=\"_blank\" rel=\"noopener\">bpmn.io</a>.' + '</span>' + '</div>' + '</div>';\n/* eslint-enable */\n\nvar lightbox;\nfunction PoweredByUtil_open() {\n  if (!lightbox) {\n    lightbox = (0,index_esm/* domify */.H6)(LIGHTBOX_MARKUP);\n    index_esm/* delegate.bind */.cl.bind(lightbox, '.backdrop', 'click', function (event) {\n      document.body.removeChild(lightbox);\n    });\n  }\n  document.body.appendChild(lightbox);\n}\n//# sourceMappingURL=PoweredByUtil.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/Viewer.js\nconst _excluded = [\"additionalModules\", \"canvas\"];\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nfunction _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }\nfunction _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\n/**\n * The code in the <project-logo></project-logo> area\n * must not be changed.\n *\n * @see http://bpmn.io/license for more information.\n */\n\n\n\n\n\n\n\n\n/**\n * @typedef {import('dmn-js-shared/lib/base/View).OpenResult} OpenResult\n */\n\n/**\n * @typedef {import('dmn-js-shared/lib/base/View).OpenError} OpenError\n */\n\n/**\n * A viewer for DMN diagrams.\n *\n * Have a look at {@link NavigatedViewer} or {@link Modeler} for bundles that include\n * additional features.\n *\n *\n * ## Extending the Viewer\n *\n * In order to extend the viewer pass extension modules to bootstrap via the\n * `additionalModules` option. An extension module is an object that exposes\n * named services.\n *\n * The following example depicts the integration of a simple\n * logging component that integrates with interaction events:\n *\n *\n * ```javascript\n *\n * // logging component\n * function InteractionLogger(eventBus) {\n *   eventBus.on('element.hover', function(event) {\n *     console.log()\n *   })\n * }\n *\n * InteractionLogger.$inject = [ 'eventBus' ]; // minification save\n *\n * // extension module\n * var extensionModule = {\n *   __init__: [ 'interactionLogger' ],\n *   interactionLogger: [ 'type', InteractionLogger ]\n * };\n *\n * // extend the viewer\n * var drdViewer = new Viewer({ additionalModules: [ extensionModule ] });\n * drdViewer.importXML(...);\n * ```\n *\n * @param {Object} options configuration options to pass to the viewer\n * @param {DOMElement} [options.container]\n *        the container to render the viewer in, defaults to body\n * @param {Array<didi.Module>} [options.modules]\n *        a list of modules to override the default modules\n * @param {Array<didi.Module>} [options.additionalModules]\n *        a list of modules to use with the default modules\n */\nfunction Viewer(options) {\n  this._container = this._createContainer();\n\n  /* <project-logo> */\n\n  addProjectLogo(this._container);\n\n  /* </project-logo> */\n\n  this._init(this._container, options);\n}\n(0,index_es/* default */.Z)(Viewer, Diagram/* default */.Z);\n\n/**\n * The saveSVG result.\n *\n * @typedef {Object} SaveSVGResult\n *\n * @property {string} svg\n */\n\n/**\n * Export the currently displayed DMN diagram as\n * an SVG image.\n *\n * @param {Object} [options]\n *\n * @return {Promise<SaveSVGResult>}\n */\nViewer.prototype.saveSVG = (0,CompatibilityUtils/* wrapForCompatibility */.$)(function (options) {\n  var self = this;\n  return new Promise(function (resolve) {\n    var canvas = self.get('canvas');\n    var contentNode = canvas.getActiveLayer(),\n      defsNode = (0,index_esm/* query */.IO)('defs', canvas._svg);\n    var contents = (0,tiny_svg_dist_index_esm/* innerSVG */.db)(contentNode),\n      defs = defsNode && defsNode.outerHTML || '';\n    var bbox = contentNode.getBBox();\n\n    /* eslint-disable max-len */\n    var svg = '<?xml version=\"1.0\" encoding=\"utf-8\"?>\\n' + '\x3c!-- created with dmn-js / http://bpmn.io --\x3e\\n' + '<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\\n' + '<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ' + 'width=\"' + bbox.width + '\" height=\"' + bbox.height + '\" ' + 'viewBox=\"' + bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height + '\" version=\"1.1\">' + defs + contents + '</svg>';\n    /* eslint-enable */\n\n    resolve({\n      svg\n    });\n  });\n});\nViewer.prototype.getModules = function () {\n  return this._modules;\n};\n\n/**\n * Destroy the viewer instance and remove all its\n * remainders from the document tree.\n */\nViewer.prototype.destroy = function () {\n  // diagram destroy\n  Diagram/* default.prototype.destroy.call */.Z.prototype.destroy.call(this);\n\n  // dom detach\n  (0,index_esm/* remove */.Od)(this._container);\n};\n\n/**\n * Register an event listener\n *\n * Remove a previously added listener via {@link #off(event, callback)}.\n *\n * @param {string} event\n * @param {number} [priority]\n * @param {Function} callback\n * @param {Object} [that]\n */\nViewer.prototype.on = function (event, priority, callback, target) {\n  return this.get('eventBus').on(event, priority, callback, target);\n};\n\n/**\n * De-register an event listener\n *\n * @param {string} event\n * @param {Function} callback\n */\nViewer.prototype.off = function (event, callback) {\n  this.get('eventBus').off(event, callback);\n};\nViewer.prototype._init = function (container, options) {\n  var additionalModules = options.additionalModules,\n    canvas = options.canvas,\n    additionalOptions = _objectWithoutProperties(options, _excluded);\n  var baseModules = options.modules || this.getModules(),\n    staticModules = [{\n      drd: ['value', this]\n    }];\n  var modules = [...staticModules, ...baseModules, ...(additionalModules || [])];\n  var diagramOptions = _objectSpread(_objectSpread({}, additionalOptions), {}, {\n    canvas: _objectSpread(_objectSpread({}, canvas), {}, {\n      container\n    }),\n    modules\n  });\n\n  // invoke diagram constructor\n  Diagram/* default.call */.Z.call(this, diagramOptions);\n  if (options && options.container) {\n    this.attachTo(options.container);\n  }\n};\n\n/**\n * Emit an event on the underlying {@link EventBus}\n *\n * @param  {string} type\n * @param  {Object} event\n *\n * @return {Object} event processing result (if any)\n */\nViewer.prototype._emit = function (type, event) {\n  return this.get('eventBus').fire(type, event);\n};\nViewer.prototype._createContainer = function () {\n  return (0,index_esm/* domify */.H6)('<div class=\"dmn-drd-container\"></div>');\n};\n\n/**\n * Open diagram element.\n *\n * @param  {ModdleElement} definitions\n * @returns {Promise} Resolves with {OpenResult} when successful\n * or rejects with {OpenError}\n */\nViewer.prototype.open = function (definitions) {\n  var self = this;\n  return new Promise((resolve, reject) => {\n    var err;\n\n    // use try/catch to not swallow synchronous exceptions\n    // that may be raised during model parsing\n    try {\n      if (self._definitions) {\n        // clear existing rendered diagram\n        self.clear();\n      }\n\n      // update definitions\n      self._definitions = definitions;\n\n      // perform graphical import\n      return importDRD(self, definitions, function (err, warnings) {\n        if (err) {\n          err.warnings = warnings || [];\n          reject(err);\n        } else {\n          resolve({\n            warnings: warnings || []\n          });\n        }\n      });\n    } catch (e) {\n      err = e;\n    }\n    if (err) {\n      err.warnings = err.warnings || [];\n      reject(err);\n    } else {\n      resolve({\n        warnings: []\n      });\n    }\n  });\n};\n\n/**\n * Attach viewer to given parent node.\n *\n * @param  {Element} parentNode\n */\nViewer.prototype.attachTo = function (parentNode) {\n  if (!parentNode) {\n    throw new Error('parentNode required');\n  }\n\n  // ensure we detach from the\n  // previous, old parent\n  this.detach();\n  var container = this._container;\n  parentNode.appendChild(container);\n  this._emit('attach', {});\n  this.get('canvas').resized();\n};\n\n/**\n * Detach viewer from parent node, if attached.\n */\nViewer.prototype.detach = function () {\n  var container = this._container,\n    parentNode = container.parentNode;\n  if (!parentNode) {\n    return;\n  }\n  this._emit('detach', {});\n  parentNode.removeChild(container);\n};\n\n\n\n\n\n\nViewer.prototype._modules = [core, translate/* default */.Z, selection/* default */.Z, overlays/* default */.Z, viewer/* default */.Z, drill_down];\n\n/* <project-logo> */\n\n\n\n\n/**\n * Adds the project logo to the diagram container as\n * required by the bpmn.io license.\n *\n * @see http://bpmn.io/license\n *\n * @param {Element} container\n */\nfunction addProjectLogo(container) {\n  var linkMarkup = '<a href=\"http://bpmn.io\" ' + 'target=\"_blank\" ' + 'class=\"bjs-powered-by\" ' + 'title=\"Powered by bpmn.io\" ' + 'style=\"position: absolute; bottom: 15px; right: 15px; z-index: 100;\">' + BPMNIO_IMG + '</a>';\n  var linkElement = (0,index_esm/* domify */.H6)(linkMarkup);\n  container.appendChild(linkElement);\n  index_esm/* event.bind */.B.bind(linkElement, 'click', function (event) {\n    PoweredByUtil_open();\n    event.preventDefault();\n  });\n}\n\n/* </project-logo> */\n//# sourceMappingURL=Viewer.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-drd/lib/Viewer.js_+_12_modules?")},"./node_modules/dmn-js-drd/lib/features/definition-properties/PaletteAdapter.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ PaletteAdapter)\n/* harmony export */ });\n/* harmony import */ var min_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n\nfunction PaletteAdapter(eventBus, canvas) {\n  function toggleMarker(cls, on) {\n    var container = canvas.getContainer();\n    (0,min_dom__WEBPACK_IMPORTED_MODULE_0__/* .classes */ .Sh)(container).toggle(cls, on);\n  }\n  eventBus.on('palette.create', function () {\n    toggleMarker('with-palette', true);\n  });\n  eventBus.on('palette.changed', function (event) {\n    toggleMarker('with-palette-two-column', event.twoColumn);\n  });\n}\nPaletteAdapter.$inject = ['eventBus', 'canvas'];\n//# sourceMappingURL=PaletteAdapter.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-drd/lib/features/definition-properties/PaletteAdapter.js?")},"./node_modules/dmn-js-drd/lib/features/definition-properties/viewer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ viewer)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/definition-properties/DefinitionPropertiesView.js\n\nfunction DefinitionPropertiesView(eventBus, canvas, translate) {\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n  this._translate = translate;\n  eventBus.on('diagram.init', function () {\n    this._init();\n  }, this);\n  eventBus.on('import.done', function (event) {\n    if (!event.error) {\n      this.update();\n    }\n  }, this);\n\n  /* markup definition */\n\n  this.HTML_MARKUP = '<div class=\"dmn-definitions\">' + '<div class=\"dmn-definitions-name\" title=\"' + this._translate('Definition Name') + '\" spellcheck=\"false\">' + '</div>' + '<div class=\"dmn-definitions-id\" title=\"' + this._translate('Definition ID') + '\" spellcheck=\"false\">' + '</div>' + '</div>';\n}\nDefinitionPropertiesView.$inject = ['eventBus', 'canvas', 'translate'];\n\n/**\n * Initialize\n */\nDefinitionPropertiesView.prototype._init = function () {\n  var canvas = this._canvas,\n    eventBus = this._eventBus;\n  var parent = canvas.getContainer(),\n    container = this._container = (0,index_esm/* domify */.H6)(this.HTML_MARKUP);\n  parent.appendChild(container);\n  this.nameElement = (0,index_esm/* query */.IO)('.dmn-definitions-name', this._container);\n  this.idElement = (0,index_esm/* query */.IO)('.dmn-definitions-id', this._container);\n  index_esm/* delegate.bind */.cl.bind(container, '.dmn-definitions-name, .dmn-definitions-id', 'mousedown', function (event) {\n    event.stopPropagation();\n  });\n  eventBus.fire('definitionIdView.create', {\n    html: container\n  });\n};\nDefinitionPropertiesView.prototype.update = function () {\n  var businessObject = this._canvas.getRootElement().businessObject;\n  this.nameElement.textContent = businessObject.name;\n  this.idElement.textContent = businessObject.id;\n};\n//# sourceMappingURL=DefinitionPropertiesView.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-drd/lib/features/definition-properties/PaletteAdapter.js\nvar PaletteAdapter = __webpack_require__(\"./node_modules/dmn-js-drd/lib/features/definition-properties/PaletteAdapter.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/i18n/translate/index.js + 1 modules\nvar translate = __webpack_require__(\"./node_modules/diagram-js/lib/i18n/translate/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/definition-properties/viewer.js\n\n\n\n/* harmony default export */ const viewer = ({\n  __depends__: [translate/* default */.Z],\n  __init__: ['definitionPropertiesView', 'definitionPropertiesPaletteAdapter'],\n  definitionPropertiesView: ['type', DefinitionPropertiesView],\n  definitionPropertiesPaletteAdapter: ['type', PaletteAdapter/* default */.Z]\n});\n//# sourceMappingURL=viewer.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-drd/lib/features/definition-properties/viewer.js_+_1_modules?")},"./node_modules/dmn-js-literal-expression/lib/Viewer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ Viewer)\n});\n\n// EXTERNAL MODULE: ./node_modules/didi/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/didi/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/base/viewer/core/ChangeSupport.js\nclass ChangeSupport {\n  constructor(eventBus) {\n    this._listeners = {};\n    eventBus.on('elements.changed', _ref => {\n      let elements = _ref.elements;\n      this.elementsChanged(elements);\n    });\n    eventBus.on('element.updateId', _ref2 => {\n      let element = _ref2.element,\n        newId = _ref2.newId;\n      this.updateId(element.id, newId);\n    });\n  }\n  elementsChanged(elements) {\n    const invoked = {};\n    const elementsLength = elements.length;\n    for (let i = 0; i < elementsLength; i++) {\n      const id = elements[i].id;\n      if (invoked[id]) {\n        return;\n      }\n      invoked[id] = true;\n      const listenersLength = this._listeners[id] && this._listeners[id].length;\n      if (listenersLength) {\n        for (let j = 0; j < listenersLength; j++) {\n          // listeners might remove themselves before they get called\n          this._listeners[id][j] && this._listeners[id][j]();\n        }\n      }\n    }\n  }\n  onElementsChanged(id, listener) {\n    if (!this._listeners[id]) {\n      this._listeners[id] = [];\n    }\n\n    // avoid push for better performance\n    this._listeners[id][this._listeners[id].length] = listener;\n  }\n  offElementsChanged(id, listener) {\n    if (!this._listeners[id]) {\n      return;\n    }\n    if (listener) {\n      const idx = this._listeners[id].indexOf(listener);\n      if (idx !== -1) {\n        this._listeners[id].splice(idx, 1);\n      }\n    } else {\n      this._listeners[id].length = 0;\n    }\n  }\n  updateId(oldId, newId) {\n    if (this._listeners[oldId]) {\n      this._listeners[newId] = this._listeners[oldId];\n      delete this._listeners[oldId];\n    }\n  }\n}\nChangeSupport.$inject = ['eventBus'];\n//# sourceMappingURL=ChangeSupport.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/dmn-js-shared/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/base/viewer/core/Components.js\n\nconst DEFAULT_PRIORITY = 1000;\nclass Components {\n  constructor() {\n    this._listeners = {};\n  }\n  getComponent(type, context) {\n    const listeners = this._listeners[type];\n    if (!listeners) {\n      return;\n    }\n    let component;\n    for (let i = 0; i < listeners.length; i++) {\n      component = listeners[i].callback(context);\n      if (component) {\n        break;\n      }\n    }\n    return component;\n  }\n  getComponents(type, context) {\n    const listeners = this._listeners[type];\n    if (!listeners) {\n      return;\n    }\n    const components = [];\n    for (let i = 0; i < listeners.length; i++) {\n      const component = listeners[i].callback(context);\n      if (component) {\n        components.push(component);\n      }\n    }\n    if (!components.length) {\n      return;\n    }\n    return components;\n  }\n  onGetComponent(type, priority, callback) {\n    if ((0,dist_index_esm/* isFunction */.mf)(priority)) {\n      callback = priority;\n      priority = DEFAULT_PRIORITY;\n    }\n    if (!(0,dist_index_esm/* isNumber */.hj)(priority)) {\n      throw new Error('priority must be a number');\n    }\n    const listeners = this._getListeners(type);\n    let existingListener, idx;\n    const newListener = {\n      priority,\n      callback\n    };\n    for (idx = 0; existingListener = listeners[idx]; idx++) {\n      if (existingListener.priority < priority) {\n        // prepend newListener at before existingListener\n        listeners.splice(idx, 0, newListener);\n        return;\n      }\n    }\n    listeners.push(newListener);\n  }\n  offGetComponent(type, callback) {\n    const listeners = this._getListeners(type);\n    let listener, listenerCallback, idx;\n    if (callback) {\n      // move through listeners from back to front\n      // and remove matching listeners\n      for (idx = listeners.length - 1; listener = listeners[idx]; idx--) {\n        listenerCallback = listener.callback;\n        if (listenerCallback === callback) {\n          listeners.splice(idx, 1);\n        }\n      }\n    } else {\n      // clear listeners\n      listeners.length = 0;\n    }\n  }\n  _getListeners(type) {\n    let listeners = this._listeners[type];\n    if (!listeners) {\n      this._listeners[type] = listeners = [];\n    }\n    return listeners;\n  }\n}\n//# sourceMappingURL=Components.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/core/EventBus.js\nvar EventBus = __webpack_require__(\"./node_modules/diagram-js/lib/core/EventBus.js\");\n// EXTERNAL MODULE: ./node_modules/inferno/index.esm.js + 1 modules\nvar inferno_index_esm = __webpack_require__(\"./node_modules/inferno/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/base/viewer/core/components/ViewerComponent.js\n\n\nclass ViewerComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props) {\n    super(props);\n    const injector = this._injector = props.injector;\n    this._changeSupport = injector.get('changeSupport');\n    this._components = injector.get('components');\n    this._renderer = injector.get('renderer');\n  }\n  getChildContext() {\n    return {\n      changeSupport: this._changeSupport,\n      components: this._components,\n      renderer: this._renderer,\n      injector: this._injector\n    };\n  }\n  render() {\n    const components = this._components.getComponents('viewer');\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"viewer-container\", components && components.map((Component, index) => (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Component, null, index)), 0);\n  }\n}\n//# sourceMappingURL=ViewerComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/base/viewer/core/Renderer.js\n\n\n\nclass Renderer {\n  constructor(changeSupport, components, config, eventBus, injector) {\n    const container = config.container;\n    this._container = container;\n    eventBus.on('renderer.mount', () => {\n      (0,inferno_index_esm/* render */.sY)((0,inferno_index_esm/* createComponentVNode */.Iz)(2, ViewerComponent, {\n        \"injector\": injector\n      }), container);\n    });\n    eventBus.on('renderer.unmount', () => {\n      (0,inferno_index_esm/* render */.sY)(null, container);\n    });\n  }\n  getContainer() {\n    return this._container;\n  }\n}\nRenderer.$inject = ['changeSupport', 'components', 'config.renderer', 'eventBus', 'injector'];\n//# sourceMappingURL=Renderer.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/base/viewer/core/index.js\n\n\n\n\n/* harmony default export */ const core = ({\n  __init__: ['changeSupport', 'components', 'renderer'],\n  changeSupport: ['type', ChangeSupport],\n  components: ['type', Components],\n  eventBus: ['type', EventBus/* default */.Z],\n  renderer: ['type', Renderer]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/base/viewer/Viewer.js\nconst _excluded = [\"modules\"];\nfunction _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }\nfunction _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\n\n\n\n/**\r\n * A base for React-style viewers.\r\n */\nclass Viewer_Viewer {\n  constructor() {\n    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    let injector = options.injector;\n    if (!injector) {\n      let _this$_init = this._init(options),\n        modules = _this$_init.modules,\n        config = _this$_init.config;\n      injector = createInjector(config, modules);\n    }\n    this.get = injector.get;\n    this.invoke = injector.invoke;\n    this.get('eventBus').fire('viewer.init');\n  }\n\n  /**\r\n   * Intialize and return modules and config used for creation.\r\n   *\r\n   * @param  {Object} options\r\n   *\r\n   * @return {Object} { modules=[], config }\r\n   */\n  _init(options) {\n    let modules = options.modules,\n      config = _objectWithoutProperties(options, _excluded);\n    return {\n      modules,\n      config\n    };\n  }\n\n  /**\r\n   * Destroy. This results in removing the attachment from the container.\r\n   */\n  destroy() {\n    const eventBus = this.get('eventBus');\n    eventBus.fire('viewer.destroy');\n  }\n\n  /**\r\n   * Clear. Should be used to reset the state of any stateful services.\r\n   */\n  clear() {\n    const eventBus = this.get('eventBus');\n    eventBus.fire('viewer.clear');\n  }\n}\n\n// helpers //////////////////////\n\nfunction createInjector(config, modules) {\n  const bootstrapModules = [{\n    config: ['value', config]\n  }, core].concat(modules || []);\n  const injector = new index_esm/* Injector */.zs(bootstrapModules);\n  injector.init();\n  return injector;\n}\n//# sourceMappingURL=Viewer.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-literal-expression/node_modules/min-dash/dist/index.esm.js\nvar min_dash_dist_index_esm = __webpack_require__(\"./node_modules/dmn-js-literal-expression/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/i18n/translate/index.js + 1 modules\nvar translate = __webpack_require__(\"./node_modules/diagram-js/lib/i18n/translate/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/core/ElementRegistry.js\n/**\n * A single decision element registry.\n *\n * The sole purpose of this service is to provide the necessary API\n * to serve shared components, i.e. the UpdatePropertiesHandler.\n */\nclass ElementRegistry {\n  constructor(viewer, eventBus) {\n    this._eventBus = eventBus;\n    this._viewer = viewer;\n  }\n  getDecision() {\n    return this._viewer.getDecision();\n  }\n  updateId(element, newId) {\n    var decision = this.getDecision();\n    if (element !== decision) {\n      throw new Error('element !== decision');\n    }\n    this._eventBus.fire('element.updateId', {\n      element: element,\n      newId: newId\n    });\n    element.id = newId;\n  }\n}\nElementRegistry.$inject = ['viewer', 'eventBus'];\n//# sourceMappingURL=ElementRegistry.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/core/index.js\n\n/* harmony default export */ const lib_core = ({\n  __init__: ['elementRegistry'],\n  elementRegistry: ['type', ElementRegistry]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/decision-properties/components/DecisionPropertiesComponent.js\n\n\nclass DecisionPropertiesComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._viewer = context.injector.get('viewer');\n  }\n  render() {\n    // there is only one single element\n    const _this$_viewer$getDeci = this._viewer.getDecision(),\n      name = _this$_viewer$getDeci.name;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"decision-properties\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"decision-name\", name, 0), 2);\n  }\n}\n//# sourceMappingURL=DecisionPropertiesComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/decision-properties/DecisionProperties.js\n\nconst HIGH_PRIORITY = 1500;\nclass DecisionProperties {\n  constructor(components) {\n    components.onGetComponent('viewer', HIGH_PRIORITY, () => DecisionPropertiesComponent);\n  }\n}\nDecisionProperties.$inject = ['components'];\n//# sourceMappingURL=DecisionProperties.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/decision-properties/index.js\n\n/* harmony default export */ const decision_properties = ({\n  __init__: ['decisionProperties'],\n  decisionProperties: ['type', DecisionProperties]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/literal-expression-properties/components/LiteralExpressionPropertiesComponent.js\n\n\nclass LiteralExpressionPropertiesComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._viewer = context.injector.get('viewer');\n  }\n  render() {\n    const _this$_viewer$getDeci = this._viewer.getDecision(),\n      literalExpression = _this$_viewer$getDeci.decisionLogic,\n      variable = _this$_viewer$getDeci.variable;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"literal-expression-properties\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"table\", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"tr\", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, this._translate('Variable Name:'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", null, variable.name || '-', 0), 2)], 4), (0,inferno_index_esm/* createVNode */.Wm)(1, \"tr\", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, this._translate('Variable Type:'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", null, this._translate(variable.typeRef || '') || '-', 0), 2)], 4), (0,inferno_index_esm/* createVNode */.Wm)(1, \"tr\", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, this._translate('Expression Language:'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", null, literalExpression.expressionLanguage || '-', 0), 2)], 4)], 4), 2);\n  }\n}\n//# sourceMappingURL=LiteralExpressionPropertiesComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/literal-expression-properties/LiteralExpressionProperties.js\n\nconst LOW_PRIORITY = 500;\nclass LiteralExpressionProperties_DecisionProperties {\n  constructor(components) {\n    components.onGetComponent('viewer', LOW_PRIORITY, () => {\n      return LiteralExpressionPropertiesComponent;\n    });\n  }\n}\nLiteralExpressionProperties_DecisionProperties.$inject = ['components'];\n//# sourceMappingURL=LiteralExpressionProperties.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/literal-expression-properties/index.js\n\n/* harmony default export */ const literal_expression_properties = ({\n  __depends__: [],\n  __init__: ['literalExpressionProperties'],\n  literalExpressionProperties: ['type', LiteralExpressionProperties_DecisionProperties]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/components/Logo.js\nvar Logo = __webpack_require__(\"./node_modules/dmn-js-shared/lib/components/Logo.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/powered-by/components/PoweredByLogoComponent.js\n\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nclass PoweredByLogoComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    _defineProperty(this, \"onClick\", () => {\n      this._eventBus.fire('poweredBy.show');\n    });\n    const injector = context.injector;\n    this._eventBus = injector.get('eventBus');\n  }\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"powered-by\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"powered-by__logo\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Logo/* default */.Z), 2), 2, {\n      \"onClick\": this.onClick,\n      \"title\": \"Powered by bpmn.io\"\n    }, null, node => this.node = node);\n  }\n}\n//# sourceMappingURL=PoweredByLogoComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/powered-by/components/PoweredByOverlayComponent.js\n\n\n\nclass PoweredByOverlayComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props) {\n    super(props);\n    this.state = {\n      show: false\n    };\n    this.onClick = this.onClick.bind(this);\n    this.onShow = this.onShow.bind(this);\n  }\n  onClick() {\n    this.setState({\n      show: false\n    });\n  }\n  onShow() {\n    this.setState({\n      show: true\n    });\n  }\n  componentWillMount() {\n    const eventBus = this._eventBus = this.context.injector.get('eventBus');\n    eventBus.on('poweredBy.show', this.onShow);\n  }\n  componentWillUnmount() {\n    this._eventBus.off('poweredBy.show', this.onShow);\n  }\n  render() {\n    const show = this.state.show;\n    return show && (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"powered-by-overlay\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"powered-by-overlay-content\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"a\", \"logo\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Logo/* default */.Z), 2, {\n      \"href\": \"https://bpmn.io\",\n      \"target\": \"_blank\",\n      \"rel\": \"noopener\"\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", null, [(0,inferno_index_esm/* createTextVNode */.Uk)(\"Web-based tooling for BPMN, DMN and CMMN diagrams powered by \"), (0,inferno_index_esm/* createVNode */.Wm)(1, \"a\", null, (0,inferno_index_esm/* createTextVNode */.Uk)(\"bpmn.io\"), 2, {\n      \"href\": \"http://bpmn.io\",\n      \"target\": \"_blank\"\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 4)], 4, {\n      \"onClick\": e => e.stopPropagation()\n    }), 2, {\n      \"onClick\": this.onClick\n    });\n  }\n}\n//# sourceMappingURL=PoweredByOverlayComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/powered-by/PoweredBy.js\n\n\nconst HIGHER_PRIORITY = 2000;\nclass PoweredBy {\n  constructor(components, eventBus) {\n    components.onGetComponent('viewer', HIGHER_PRIORITY, () => {\n      return PoweredByLogoComponent;\n    });\n    components.onGetComponent('viewer', () => {\n      return PoweredByOverlayComponent;\n    });\n  }\n}\nPoweredBy.$inject = ['components', 'eventBus'];\n//# sourceMappingURL=PoweredBy.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/powered-by/index.js\n\n/* harmony default export */ const powered_by = ({\n  __init__: ['poweredBy'],\n  poweredBy: ['type', PoweredBy]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/textarea/components/TextareaComponent.js\n\n\nclass TextareaComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._viewer = context.injector.get('viewer');\n  }\n  render() {\n    const text = this._viewer.getDecision().decisionLogic.text;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"textarea\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"content\", text, 0), 2);\n  }\n}\n//# sourceMappingURL=TextareaComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/textarea/Textarea.js\n\nclass Textarea {\n  constructor(components) {\n    components.onGetComponent('viewer', () => TextareaComponent);\n  }\n}\nTextarea.$inject = ['components'];\n//# sourceMappingURL=Textarea.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/textarea/index.js\n\n/* harmony default export */ const features_textarea = ({\n  __init__: ['textarea'],\n  textarea: ['type', Textarea]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/view-drd/components/ViewDrdComponent.js\n\nfunction ViewDrdComponent_defineProperty(obj, key, value) { key = ViewDrdComponent_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction ViewDrdComponent_toPropertyKey(arg) { var key = ViewDrdComponent_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction ViewDrdComponent_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nclass ViewDrdComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    ViewDrdComponent_defineProperty(this, \"onClick\", () => {\n      this._eventBus.fire('showDrd');\n    });\n    const injector = context.injector;\n    this._translate = injector.get('translate');\n    this._eventBus = injector.get('eventBus');\n  }\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"view-drd\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"view-drd-button\", this._translate('View DRD'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onClick\n    }), 2, null, null, node => this.node = node);\n  }\n}\nViewDrdComponent.$inject = ['translate'];\n//# sourceMappingURL=ViewDrdComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/view-drd/ViewDrd.js\n\nconst VERY_HIGH_PRIORITY = 2000;\nclass ViewDrd {\n  constructor(components, viewer, eventBus, injector) {\n    this._injector = injector;\n    this._viewer = viewer;\n    components.onGetComponent('viewer', VERY_HIGH_PRIORITY, () => {\n      if (this.canViewDrd()) {\n        return ViewDrdComponent;\n      }\n    });\n    eventBus.on('showDrd', () => {\n      const parent = injector.get('_parent', false);\n\n      // there is only one single element\n      const definitions = this.getDefinitions();\n\n      // open definitions\n      const view = parent.getView(definitions);\n      parent.open(view);\n    });\n  }\n  canViewDrd() {\n    const parent = this._injector.get('_parent', false);\n    if (!parent) {\n      return;\n    }\n\n    // there is only one single element\n    const definitions = this.getDefinitions();\n    return !!parent.getView(definitions);\n  }\n  getDefinitions() {\n    return getDefinitions(this._viewer.getDecision());\n  }\n}\nViewDrd.$inject = ['components', 'viewer', 'eventBus', 'injector'];\n\n// helpers //////////////////////\n\nfunction getDefinitions(decision) {\n  const definitions = decision.$parent;\n  return definitions;\n}\n//# sourceMappingURL=ViewDrd.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/view-drd/index.js\n\n/* harmony default export */ const view_drd = ({\n  __init__: ['viewDrd'],\n  viewDrd: ['type', ViewDrd]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/Viewer.js\nconst Viewer_excluded = [\"modules\", \"additionalModules\"];\nfunction Viewer_objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = Viewer_objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }\nfunction Viewer_objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\n\n\n\n\n\n\n\n\n\n\n\n/**\r\n * @typedef {import('dmn-js-shared/lib/base/View).OpenResult} OpenResult\r\n */\n\n/**\r\n * @typedef {import('dmn-js-shared/lib/base/View).OpenError} OpenError\r\n */\n\nclass Viewer extends Viewer_Viewer {\n  constructor() {\n    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    const container = Viewer._createContainer();\n    super((0,min_dash_dist_index_esm/* assign */.f0)(options, {\n      renderer: {\n        container\n      }\n    }));\n    this._container = container;\n  }\n\n  /**\r\n   * Open diagram element.\r\n   *\r\n   * @param  {ModdleElement} decision\r\n   * @returns {Promise} Resolves with {OpenResult} when successful\r\n   * or rejects with {OpenError}\r\n   */\n  open(decision) {\n    var self = this;\n    return new Promise(function (resolve, reject) {\n      var err;\n\n      // use try/catch to not swallow synchronous exceptions\n      // that may be raised during model parsing\n      try {\n        if (self._decision) {\n          // clear existing literal expression\n          self.clear();\n\n          // unmount first\n          self.get('eventBus').fire('renderer.unmount');\n        }\n\n        // update literal expression\n        self._decision = decision;\n\n        // let others know about import\n        self.get('eventBus').fire('import', decision);\n        self.get('eventBus').fire('renderer.mount');\n      } catch (e) {\n        err = e;\n      }\n\n      // handle synchronously thrown exception\n      if (err) {\n        err.warnings = err.warnings || [];\n        reject(err);\n      } else {\n        resolve({\n          warnings: []\n        });\n      }\n    });\n  }\n\n  /**\r\n   * Initialize the literal expression, returning { modules: [], config }.\r\n   *\r\n   * @param  {Object} options\r\n   *\r\n   * @return {Object} init config\r\n   */\n  _init(options) {\n    let modules = options.modules,\n      additionalModules = options.additionalModules,\n      config = Viewer_objectWithoutProperties(options, Viewer_excluded);\n    let baseModules = modules || this.getModules();\n    let extraModules = additionalModules || [];\n    let staticModules = [{\n      viewer: ['value', this]\n    }];\n    let allModules = [...baseModules, ...extraModules, ...staticModules];\n    return {\n      modules: allModules,\n      config\n    };\n  }\n\n  /**\r\n   * Register an event listener\r\n   *\r\n   * Remove a previously added listener via {@link #off(event, callback)}.\r\n   *\r\n   * @param {string} event\r\n   * @param {number} [priority]\r\n   * @param {Function} callback\r\n   * @param {Object} [that]\r\n   */\n  on(event, priority, callback, target) {\n    return this.get('eventBus').on(event, priority, callback, target);\n  }\n\n  /**\r\n   * De-register an event listener\r\n   *\r\n   * @param {string} event\r\n   * @param {Function} callback\r\n   */\n  off(event, callback) {\n    this.get('eventBus').off(event, callback);\n  }\n\n  /**\r\n   * Emit an event on the underlying {@link EventBus}\r\n   *\r\n   * @param  {string} type\r\n   * @param  {Object} event\r\n   *\r\n   * @return {Object} event processing result (if any)\r\n   */\n  _emit(type, event) {\n    return this.get('eventBus').fire(type, event);\n  }\n\n  /**\r\n   * Returns the currently displayed decision.\r\n   *\r\n   * @return {ModdleElement}\r\n   */\n  getDecision() {\n    return this._decision;\n  }\n\n  /**\r\n   * Attach viewer to given parent node.\r\n   *\r\n   * @param  {Element} parentNode\r\n   */\n  attachTo(parentNode) {\n    if (!parentNode) {\n      throw new Error('parentNode required');\n    }\n\n    // ensure we detach from the\n    // previous, old parent\n    this.detach();\n    parentNode.appendChild(this._container);\n    this._emit('attach', {});\n  }\n\n  /**\r\n   * Detach viewer from parent node, if attached.\r\n   */\n  detach() {\n    const container = this._container,\n      parentNode = container.parentNode;\n    if (!parentNode) {\n      return;\n    }\n    this._emit('detach', {});\n    (0,min_dom_dist_index_esm/* remove */.Od)(container);\n  }\n  destroy() {\n    super.destroy();\n    this.detach();\n  }\n  getModules() {\n    return Viewer._getModules();\n  }\n  static _getModules() {\n    return [lib_core, translate/* default */.Z, decision_properties, literal_expression_properties, powered_by, features_textarea, view_drd];\n  }\n  static _createContainer() {\n    return (0,min_dom_dist_index_esm/* domify */.H6)('<div class=\"dmn-literal-expression-container\"></div>');\n  }\n}\n//# sourceMappingURL=Viewer.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-literal-expression/lib/Viewer.js_+_24_modules?")},"./node_modules/dmn-js-properties-panel/dist/index.esm.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"R1\": () => (/* binding */ index$2),\n/* harmony export */   \"Ws\": () => (/* binding */ index),\n/* harmony export */   \"Xc\": () => (/* binding */ index$1)\n/* harmony export */ });\n/* unused harmony export useService */\n/* harmony import */ var _bpmn_io_properties_panel_preact_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/preact/hooks/dist/hooks.module.js\");\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(\"./node_modules/dmn-js-properties-panel/node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var _bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/dist/index.esm.js\");\n/* harmony import */ var _bpmn_io_properties_panel_preact__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/preact/dist/preact.module.js\");\n/* harmony import */ var _bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/preact/compat/dist/compat.module.js\");\n/* harmony import */ var _bpmn_io_properties_panel_preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(\"./node_modules/@bpmn-io/properties-panel/preact/jsx-runtime/dist/jsxRuntime.module.js\");\n/* harmony import */ var diagram_js_lib_features_keyboard_KeyboardUtil__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n/* harmony import */ var min_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n\n\n\n\n\n\n\n\n\nconst DmnPropertiesPanelContext = (0,_bpmn_io_properties_panel_preact__WEBPACK_IMPORTED_MODULE_2__/* .createContext */ .kr)({\n  selectedElement: null,\n  injector: null,\n  getService: () => null\n});\n\n/**\n * Is an element of the given DMN type?\n *\n * @param  {tjs.model.Base|ModdleElement} element\n * @param  {string} type\n *\n * @return {boolean}\n */\nfunction is(element, type) {\n  var bo = getBusinessObject(element);\n  return bo && typeof bo.$instanceOf === 'function' && bo.$instanceOf(type);\n}\n\n/**\n * Return the business object for a given element.\n *\n * @param  {tjs.model.Base|ModdleElement} element\n *\n * @return {ModdleElement}\n */\nfunction getBusinessObject(element) {\n  return element && element.businessObject || element;\n}\n\n/**\n * Return true if element has any of the given types.\n *\n * @param {djs.model.Base} element\n * @param {Array<string>} types\n *\n * @return {boolean}\n */\nfunction isAny(element, types) {\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_5__/* .some */ .G)(types, function (t) {\n    return is(element, t);\n  });\n}\n\nfunction getLabelAttr(semantic) {\n  if (is(semantic, 'dmn:Decision') || is(semantic, 'dmn:BusinessKnowledgeModel') || is(semantic, 'dmn:InputData') || is(semantic, 'dmn:KnowledgeSource')) {\n    return 'name';\n  }\n  if (is(semantic, 'dmn:TextAnnotation')) {\n    return 'text';\n  }\n}\nfunction getLabel(element) {\n  var semantic = element.businessObject,\n    attr = getLabelAttr(semantic);\n  if (attr) {\n    return semantic[attr] || '';\n  }\n}\n\nfunction _extends$9() { _extends$9 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$9.apply(this, arguments); }\nvar AssociationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends$9({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  stroke: \"#000\",\n  strokeWidth: \"2\",\n  fill: \"none\",\n  strokeDasharray: \"3.3,6\",\n  strokeLinecap: \"square\",\n  d: \"M1.5 30.5l29-29\"\n})));\n\nfunction _extends$8() { _extends$8 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$8.apply(this, arguments); }\nvar AuthorityRequirementIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends$8({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  d: \"M6.364 24.235l1.414 1.414-6.364 6.364L0 30.598l6.364-6.363zm8-8l1.414 1.414-6.364 6.364L8 22.598l6.364-6.363zm8-8l1.414 1.414-6.364 6.364L16 14.598l6.364-6.363zM28 0a4 4 0 110 8 4 4 0 010-8z\",\n  fillRule: \"evenodd\"\n})));\n\nfunction _extends$7() { _extends$7 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$7.apply(this, arguments); }\nvar BusinessKnowledgeIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends$7({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  d: \"M6.258 8L0 15.358l.001.325.028 8.259h25.977L32 16.518V8H6.258zm.812 1.756h23.174v6.142l-5.077 6.288H1.779L1.759 16l5.31-6.245z\"\n})));\n\nfunction _extends$6() { _extends$6 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$6.apply(this, arguments); }\nvar DecisionIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends$6({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  d: \"M0 6v20.711h32V6H0zm1.697 1.697h28.606v17.317H1.697V7.697z\",\n  fillRule: \"evenodd\"\n})));\n\nfunction _extends$5() { _extends$5 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$5.apply(this, arguments); }\nvar DRDIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends$5({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  d: \"M3.563 0A3.554 3.554 0 00.01 3.552L0 28.446A3.554 3.554 0 003.555 32h24.882a3.554 3.554 0 003.554-3.552L32 3.554A3.554 3.554 0 0028.445 0H3.563zM14 14l15 .016V20l-15-.016V14zm0-11l15 .022V11l-15-.022V3zm-3 16.992L3 20v-5.992L11 14v5.992zm0-9.003L3 11V3.01L11 3v7.99zM3 23.008L11 23v5.992L3 29v-5.992zm11 5.984V23l15 .016V29l-15-.008z\"\n})));\n\nfunction _extends$4() { _extends$4 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$4.apply(this, arguments); }\nvar InformationRequirementIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends$4({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  d: \"M32 .06S20.33 6.015 14.403 8.8c1.27 1.16 2.451 2.41 3.676 3.615L0 30.734 1.325 32l18.08-18.32c1.227 1.223 2.448 2.453 3.676 3.676C26.247 11.121 32 .06 32 .06z\"\n})));\n\nfunction _extends$3() { _extends$3 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$3.apply(this, arguments); }\nvar InputDataIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends$3({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  d: \"M6.384 8c-1.825 0-3.458.945-4.587 2.382C.667 11.82 0 13.756 0 15.88c0 2.125.667 4.062 1.797 5.499 1.13 1.437 2.762 2.382 4.587 2.382h19.232c1.825 0 3.458-.945 4.587-2.382C31.333 19.942 32 18.005 32 15.88c0-2.124-.667-4.06-1.797-5.498C29.073 8.945 27.441 8 25.616 8H6.384zm0 1.763h19.232c1.223 0 2.342.616 3.201 1.709.86 1.093 1.42 2.656 1.42 4.408 0 1.753-.56 3.316-1.42 4.409-.86 1.093-1.978 1.708-3.2 1.708H6.383c-1.223 0-2.342-.615-3.201-1.708-.86-1.093-1.42-2.656-1.42-4.409 0-1.752.56-3.315 1.42-4.408.86-1.093 1.978-1.709 3.2-1.709z\"\n})));\n\nfunction _extends$2() { _extends$2 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2.apply(this, arguments); }\nvar KnowledgeRequirementIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends$2({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  d: \"M6.364 24.235l1.414 1.414-6.364 6.364L0 30.598l6.364-6.363zm8-8l1.414 1.414-6.364 6.364L8 22.598l6.364-6.363zm8-8l1.414 1.414-6.364 6.364L16 14.598l6.364-6.363zM32 12.06h-2V3.426l-4.586 4.587L24 6.598l4.537-4.538H20v-2h12v12z\",\n  fillRule: \"evenodd\"\n})));\n\nfunction _extends$1() { _extends$1 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1.apply(this, arguments); }\nvar KnowledgeSourceIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends$1({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  d: \"M0 5V23.376l.348.23c4.812 3.182 8.946 2.865 12.41 1.63 3.464-1.235 6.366-3.239 8.999-3.589l.02-.003.021-.003c3.576-.675 5.681.439 9.126 1.88l1.076.45V5.064L0 5zm1.553 1.557l28.894.059v15.016c-2.89-1.22-5.358-2.187-8.918-1.521-3.199.433-6.1 2.523-9.293 3.662C9.12 24.884 5.83 25.23 1.553 22.535V6.557z\"\n})));\n\nfunction _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\nvar TextAnnotationIcon = (({\n  styles = {},\n  ...props\n}) => /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"svg\", _extends({\n  width: \"32\",\n  height: \"32\",\n  xmlns: \"http://www.w3.org/2000/svg\"\n}, props), /*#__PURE__*/_bpmn_io_properties_panel_preact_compat__WEBPACK_IMPORTED_MODULE_3__/* [\"default\"].createElement */ .ZP.createElement(\"path\", {\n  d: \"M22.087 0v31.647H32v-1.788h-8.125V1.788H32V0h-9.913zm-2.924 13.999l-2.737 2.167 2.167 2.738 2.738-2.167-2.168-2.738zm-5.475 4.335L10.95 20.5l2.168 2.738 2.737-2.168-2.167-2.737zm-5.475 4.335l-2.738 2.167 2.168 2.738 2.737-2.168-2.167-2.737zm-5.476 4.335L0 29.17l2.167 2.738 2.738-2.168-2.168-2.737z\"\n})));\n\nvar iconsByType = {\n  'Association': AssociationIcon,\n  'AuthorityRequirement': AuthorityRequirementIcon,\n  'BusinessKnowledgeModel': BusinessKnowledgeIcon,\n  'Decision': DecisionIcon,\n  'DecisionTable': DRDIcon,\n  'Definitions': DRDIcon,\n  'DRD': DRDIcon,\n  'InformationRequirement': InformationRequirementIcon,\n  'InputData': InputDataIcon,\n  'KnowledgeRequirement': KnowledgeRequirementIcon,\n  'KnowledgeSource': KnowledgeSourceIcon,\n  'TextAnnotation': TextAnnotationIcon\n};\n\nfunction getConcreteType(element) {\n  const {\n    type: elementType\n  } = element;\n  return getRawType(elementType);\n}\nconst PanelHeaderProvider = {\n  getElementLabel: element => {\n    if (is(element, 'dmn:Definitions')) return getBusinessObject(element).get('name');\n    return getLabel(element);\n  },\n  getElementIcon: element => {\n    const concreteType = getConcreteType(element);\n    return iconsByType[concreteType];\n  },\n  getTypeLabel: element => {\n    const concreteType = getConcreteType(element);\n    return concreteType.replace(/(\\B[A-Z])/g, ' $1').replace(/(\\bNon Interrupting)/g, '($1)');\n  }\n};\n\n// helpers ///////////////////////\n\nfunction getRawType(type) {\n  return type.split(':')[1];\n}\n\nconst PanelPlaceholderProvider = {\n  getEmpty: () => {\n    return {\n      text: 'Select an element to edit its properties.',\n      // todo(pinussilvestrus): add icon\n      icon: null\n    };\n  },\n  getMultiple: () => {\n    return {\n      text: 'Multiple elements are selected. Select a single element to edit its properties.',\n      // todo(pinussilvestrus): add icon\n      icon: null\n    };\n  }\n};\n\nfunction DmnPropertiesPanel(props) {\n  const {\n    element,\n    injector,\n    getProviders,\n    layoutConfig,\n    descriptionConfig\n  } = props;\n  const canvas = injector.get('canvas');\n  const elementRegistry = injector.get('elementRegistry');\n  const eventBus = injector.get('eventBus');\n  const [state, setState] = (0,_bpmn_io_properties_panel_preact_hooks__WEBPACK_IMPORTED_MODULE_0__/* .useState */ .eJ)({\n    selectedElement: element\n  });\n  const selectedElement = state.selectedElement;\n\n  /**\n   * @param {djs.model.Base | Array<djs.model.Base>} element\n   */\n  const _update = element => {\n    if (!element) {\n      return;\n    }\n    let newSelectedElement = element;\n\n    // handle labels\n    if (newSelectedElement && newSelectedElement.type === 'label') {\n      newSelectedElement = newSelectedElement.labelTarget;\n    }\n    setState({\n      ...state,\n      selectedElement: newSelectedElement\n    });\n\n    // notify interested parties on property panel updates\n    eventBus.fire('propertiesPanel.updated', {\n      element: newSelectedElement\n    });\n  };\n\n  // (2) react on element changes\n\n  // (2a) selection changed\n  (0,_bpmn_io_properties_panel_preact_hooks__WEBPACK_IMPORTED_MODULE_0__/* .useEffect */ .d4)(() => {\n    const onSelectionChanged = e => {\n      const {\n        newSelection = []\n      } = e;\n      if (newSelection.length > 1) {\n        return _update(newSelection);\n      }\n      const newElement = newSelection[0];\n      const rootElement = canvas.getRootElement();\n      if (isImplicitRoot$1(rootElement)) {\n        return;\n      }\n      _update(newElement || rootElement);\n    };\n    eventBus.on('selection.changed', onSelectionChanged);\n    return () => {\n      eventBus.off('selection.changed', onSelectionChanged);\n    };\n  }, []);\n\n  // (2b) selected element changed\n  (0,_bpmn_io_properties_panel_preact_hooks__WEBPACK_IMPORTED_MODULE_0__/* .useEffect */ .d4)(() => {\n    const onElementsChanged = e => {\n      const elements = e.elements;\n      const updatedElement = findElement(elements, selectedElement);\n      if (updatedElement && elementExists(updatedElement, elementRegistry)) {\n        _update(updatedElement);\n      }\n    };\n    eventBus.on('elements.changed', onElementsChanged);\n    return () => {\n      eventBus.off('elements.changed', onElementsChanged);\n    };\n  }, [selectedElement]);\n\n  // (2c) root element changed\n  (0,_bpmn_io_properties_panel_preact_hooks__WEBPACK_IMPORTED_MODULE_0__/* .useEffect */ .d4)(() => {\n    const onRootAdded = e => {\n      const element = e.element;\n      if (isImplicitRoot$1(element)) {\n        return;\n      }\n      _update(element);\n    };\n    eventBus.on('root.added', onRootAdded);\n    return () => {\n      eventBus.off('root.added', onRootAdded);\n    };\n  }, [selectedElement]);\n\n  // (2d) provided entries changed\n  (0,_bpmn_io_properties_panel_preact_hooks__WEBPACK_IMPORTED_MODULE_0__/* .useEffect */ .d4)(() => {\n    const onProvidersChanged = () => {\n      _update(selectedElement);\n    };\n    eventBus.on('propertiesPanel.providersChanged', onProvidersChanged);\n    return () => {\n      eventBus.off('propertiesPanel.providersChanged', onProvidersChanged);\n    };\n  }, [selectedElement]);\n\n  // (3) create properties panel context\n  const dmnPropertiesPanelContext = {\n    selectedElement,\n    injector,\n    getService(type, strict) {\n      return injector.get(type, strict);\n    }\n  };\n\n  // (4) retrieve groups for selected element\n  const providers = getProviders(selectedElement);\n  const groups = (0,_bpmn_io_properties_panel_preact_hooks__WEBPACK_IMPORTED_MODULE_0__/* .useMemo */ .Ye)(() => {\n    return (0,min_dash__WEBPACK_IMPORTED_MODULE_5__/* .reduce */ .u4)(providers, function (groups, provider) {\n      // do not collect groups for multi element state\n      if ((0,min_dash__WEBPACK_IMPORTED_MODULE_5__/* .isArray */ .kJ)(selectedElement)) {\n        return [];\n      }\n      const updater = provider.getGroups(selectedElement);\n      return updater(groups);\n    }, []);\n  }, [providers, selectedElement]);\n\n  // (5) notify layout changes\n  const onLayoutChanged = layout => {\n    eventBus.fire('propertiesPanel.layoutChanged', {\n      layout\n    });\n  };\n\n  // (6) notify description changes\n  const onDescriptionLoaded = description => {\n    eventBus.fire('propertiesPanel.descriptionLoaded', {\n      description\n    });\n  };\n  return (0,_bpmn_io_properties_panel_preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__/* .jsx */ .tZ)(DmnPropertiesPanelContext.Provider, {\n    value: dmnPropertiesPanelContext,\n    children: (0,_bpmn_io_properties_panel_preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__/* .jsx */ .tZ)(_bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .PropertiesPanel */ .gr, {\n      element: selectedElement,\n      headerProvider: PanelHeaderProvider,\n      placeholderProvider: PanelPlaceholderProvider,\n      groups: groups,\n      layoutConfig: layoutConfig,\n      layoutChanged: onLayoutChanged,\n      descriptionConfig: descriptionConfig,\n      descriptionLoaded: onDescriptionLoaded\n    })\n  });\n}\n\n// helpers //////////////////////////\n\nfunction isImplicitRoot$1(element) {\n  // Backwards compatibility for diagram-js<7.4.0, see https://github.com/bpmn-io/bpmn-properties-panel/pull/102\n  return element && (element.isImplicit || element.id === '__implicitroot');\n}\nfunction findElement(elements, element) {\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_5__/* .find */ .sE)(elements, e => e === element);\n}\nfunction elementExists(element, elementRegistry) {\n  return element && elementRegistry.get(element.id);\n}\n\nconst DEFAULT_PRIORITY = 1000;\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').GroupDefinition } GroupDefinition\n * @typedef { import('@bpmn-io/properties-panel').ListGroupDefinition } ListGroupDefinition\n * @typedef { { getGroups: (ModdleElement) => (Array{GroupDefinition|ListGroupDefinition}) => Array{GroupDefinition|ListGroupDefinition}) } PropertiesProvider\n */\n\nclass DmnPropertiesPanelRenderer {\n  constructor(config, injector, eventBus, dmnjs) {\n    const {\n      parent,\n      layout: layoutConfig,\n      description: descriptionConfig\n    } = config || {};\n    this._eventBus = eventBus;\n    this._injector = injector;\n    this._layoutConfig = layoutConfig;\n    this._descriptionConfig = descriptionConfig;\n    this._container = (0,min_dom__WEBPACK_IMPORTED_MODULE_6__/* .domify */ .H6)('<div style=\"height: 100%\" class=\"bio-properties-panel-container\"></div>');\n    var commandStack = injector.get('commandStack', false);\n    commandStack && setupKeyboard(this._container, eventBus, commandStack);\n    eventBus.on('diagram.destroy', () => {\n      this.detach();\n    });\n    eventBus.on('import.done', event => {\n      const {\n        element\n      } = event;\n      if (parent) {\n        this.attachTo(parent);\n      }\n      this._render(element);\n    });\n    eventBus.on('detach', event => {\n      this.detach();\n    });\n    dmnjs.on('detach', () => {\n      this.detach();\n    });\n  }\n\n  /**\n   * Attach the properties panel to a parent node.\n   *\n   * @param {HTMLElement} container\n   */\n  attachTo(container) {\n    if (!container) {\n      throw new Error('container required');\n    }\n\n    // unwrap jQuery if provided\n    if (container.get && container.constructor.prototype.jquery) {\n      container = container.get(0);\n    }\n    if (typeof container === 'string') {\n      container = (0,min_dom__WEBPACK_IMPORTED_MODULE_6__/* .query */ .IO)(container);\n    }\n\n    // (1) detach from old parent\n    this.detach();\n\n    // (2) append to parent container\n    container.appendChild(this._container);\n\n    // (3) notify interested parties\n    this._eventBus.fire('propertiesPanel.attach');\n  }\n\n  /**\n   * Detach the properties panel from its parent node.\n   */\n  detach() {\n    const parentNode = this._container.parentNode;\n    if (parentNode) {\n      parentNode.removeChild(this._container);\n      this._eventBus.fire('propertiesPanel.detach');\n    }\n  }\n\n  /**\n   * Register a new properties provider to the properties panel.\n   *\n   * @param {Number} [priority]\n   * @param {PropertiesProvider} provider\n   */\n  registerProvider(priority, provider) {\n    if (!provider) {\n      provider = priority;\n      priority = DEFAULT_PRIORITY;\n    }\n    if (typeof provider.getGroups !== 'function') {\n      console.error('Properties provider does not implement #getGroups(element) API');\n      return;\n    }\n    this._eventBus.on('propertiesPanel.getProviders', priority, function (event) {\n      event.providers.push(provider);\n    });\n    this._eventBus.fire('propertiesPanel.providersChanged');\n  }\n  _getProviders() {\n    const event = this._eventBus.createEvent({\n      type: 'propertiesPanel.getProviders',\n      providers: []\n    });\n    this._eventBus.fire(event);\n    return event.providers;\n  }\n  _render(element) {\n    const canvas = this._injector.get('canvas');\n    if (!element) {\n      element = canvas.getRootElement();\n    }\n    if (isImplicitRoot(element)) {\n      return;\n    }\n    (0,_bpmn_io_properties_panel_preact__WEBPACK_IMPORTED_MODULE_2__/* .render */ .sY)((0,_bpmn_io_properties_panel_preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__/* .jsx */ .tZ)(DmnPropertiesPanel, {\n      element: element,\n      injector: this._injector,\n      getProviders: this._getProviders.bind(this),\n      layoutConfig: this._layoutConfig,\n      descriptionConfig: this._descriptionConfig\n    }), this._container);\n    this._eventBus.fire('propertiesPanel.rendered');\n  }\n  _destroy() {\n    if (this._container) {\n      (0,_bpmn_io_properties_panel_preact__WEBPACK_IMPORTED_MODULE_2__/* .render */ .sY)(null, this._container);\n      this._eventBus.fire('propertiesPanel.destroyed');\n    }\n  }\n}\nDmnPropertiesPanelRenderer.$inject = ['config.propertiesPanel', 'injector', 'eventBus', '_parent'];\n\n// helpers ///////////////////////\n\nfunction isImplicitRoot(element) {\n  // Backwards compatibility for diagram-js<7.4.0, see https://github.com/bpmn-io/bpmn-properties-panel/pull/102\n  return element && (element.isImplicit || element.id === '__implicitroot');\n}\n\n/**\n * Setup keyboard bindings (undo, redo) on the given container.\n *\n * @param {Element} container\n * @param {EventBus} eventBus\n * @param {CommandStack} commandStack\n */\nfunction setupKeyboard(container, eventBus, commandStack) {\n  function cancel(event) {\n    event.preventDefault();\n    event.stopPropagation();\n  }\n  function handleKeys(event) {\n    if ((0,diagram_js_lib_features_keyboard_KeyboardUtil__WEBPACK_IMPORTED_MODULE_7__/* .isUndo */ .YW)(event)) {\n      commandStack.undo();\n      return cancel(event);\n    }\n    if ((0,diagram_js_lib_features_keyboard_KeyboardUtil__WEBPACK_IMPORTED_MODULE_7__/* .isRedo */ .LO)(event)) {\n      commandStack.redo();\n      return cancel(event);\n    }\n  }\n  eventBus.on('keyboard.bind', function () {\n    min_dom__WEBPACK_IMPORTED_MODULE_6__/* .event.bind */ .B.bind(container, 'keydown', handleKeys);\n  });\n  eventBus.on('keyboard.unbind', function () {\n    min_dom__WEBPACK_IMPORTED_MODULE_6__/* .event.unbind */ .B.unbind(container, 'keydown', handleKeys);\n  });\n}\n\nvar index$2 = {\n  __depends__: [_bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .DebounceInputModule */ .kK],\n  __init__: ['propertiesPanel'],\n  propertiesPanel: ['type', DmnPropertiesPanelRenderer]\n};\n\nfunction useService (type, strict) {\n  const {\n    getService\n  } = (0,_bpmn_io_properties_panel_preact_hooks__WEBPACK_IMPORTED_MODULE_0__/* .useContext */ .qp)(DmnPropertiesPanelContext);\n  return getService(type, strict);\n}\n\nconst SPACE_REGEX = /\\s/;\n\n// for QName validation as per http://www.w3.org/TR/REC-xml/#NT-NameChar\nconst QNAME_REGEX = /^([a-z][\\w-.]*:)?[a-z_][\\w-.]*$/i;\n\n// for ID validation as per BPMN Schema (QName - Namespace)\nconst ID_REGEX = /^[a-z_][\\w-.]*$/i;\n\n/**\n * checks whether the id value is valid\n *\n * @param {ModdleElement} element\n * @param {String} idValue\n * @param {Function} translate\n *\n * @return {String} error message\n */\nfunction isIdValid(element, idValue, translate) {\n  const assigned = element.$model.ids.assigned(idValue);\n  const idAlreadyExists = assigned && assigned !== element;\n  if (!idValue) {\n    return translate('ID must not be empty.');\n  }\n  if (idAlreadyExists) {\n    return translate('ID must be unique.');\n  }\n  return validateId(idValue, translate);\n}\nfunction validateId(idValue, translate) {\n  if (containsSpace(idValue)) {\n    return translate('ID must not contain spaces.');\n  }\n  if (!ID_REGEX.test(idValue)) {\n    if (QNAME_REGEX.test(idValue)) {\n      return translate('ID must not contain prefix.');\n    }\n    return translate('ID must be a valid QName.');\n  }\n}\nfunction containsSpace(value) {\n  return SPACE_REGEX.test(value);\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction IdProps$1(props) {\n  const {\n    element\n  } = props;\n  return [{\n    id: 'id',\n    component: Id$1,\n    element,\n    isEdited: _bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .isTextFieldEntryEdited */ .V$\n  }];\n}\nfunction Id$1(props) {\n  const {\n    element,\n    id\n  } = props;\n  const modeling = useService('modeling');\n  const debounce = useService('debounceInput');\n  const translate = useService('translate');\n  const getValue = element => {\n    return getBusinessObject(element).get('id');\n  };\n  const setValue = (value, error) => {\n    if (error) {\n      return;\n    }\n    modeling.updateProperties(element, {\n      id: value\n    });\n  };\n  const validate = value => {\n    const businessObject = getBusinessObject(element);\n    return isIdValid(businessObject, value, translate);\n  };\n  return (0,_bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .TextFieldEntry */ .Tq)({\n    element,\n    id,\n    label: translate('ID'),\n    getValue,\n    setValue,\n    debounce,\n    validate\n  });\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction NameProps(props) {\n  const {\n    element\n  } = props;\n  if (!isAny(element, ['dmn:DRGElement', 'dmn:Definitions', 'dmn:TextAnnotation'])) {\n    return [];\n  }\n  return [{\n    id: 'name',\n    component: Name,\n    element,\n    isEdited: _bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .isTextFieldEntryEdited */ .V$\n  }];\n}\nfunction Name(props) {\n  const {\n    element,\n    id\n  } = props;\n  const modeling = useService('modeling');\n  const debounce = useService('debounceInput');\n  const translate = useService('translate');\n\n  // (1) default: name\n  let options = {\n    element,\n    id,\n    label: translate('Name'),\n    debounce,\n    getValue: element => {\n      return getBusinessObject(element).get('name');\n    },\n    setValue: value => {\n      modeling.updateProperties(element, {\n        name: value\n      });\n    }\n  };\n\n  // (2) text annotation\n  if (is(element, 'dmn:TextAnnotation')) {\n    options = {\n      ...options,\n      getValue: element => {\n        return getBusinessObject(element).get('text');\n      },\n      setValue: value => {\n        modeling.updateProperties(element, {\n          text: value\n        });\n      }\n    };\n  }\n  return (0,_bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .TextFieldEntry */ .Tq)(options);\n}\n\nfunction GeneralGroup(element) {\n  const entries = [...NameProps({\n    element\n  }), ...IdProps$1({\n    element\n  })];\n  return {\n    id: 'general',\n    label: 'General',\n    entries,\n    component: _bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .Group */ .ZA\n  };\n}\nfunction getGroups(element) {\n  const groups = [GeneralGroup(element)];\n\n  // contract: if a group returns null, it should not be displayed at all\n  return groups.filter(group => group !== null);\n}\nclass DmnPropertiesProvider {\n  constructor(propertiesPanel) {\n    propertiesPanel.registerProvider(this);\n  }\n  getGroups(element) {\n    return groups => {\n      return [...groups, ...getGroups(element)];\n    };\n  }\n}\nDmnPropertiesProvider.$inject = ['propertiesPanel'];\n\nvar index$1 = {\n  __init__: ['dmnPropertiesProvider'],\n  dmnPropertiesProvider: ['type', DmnPropertiesProvider]\n};\n\nfunction VersionTagProps(props) {\n  const {\n    element\n  } = props;\n  if (!is(element, 'dmn:Decision')) {\n    return [];\n  }\n  return [{\n    id: 'versionTag',\n    component: VersionTag,\n    element,\n    isEdited: _bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .isTextFieldEntryEdited */ .V$\n  }];\n}\nfunction VersionTag(props) {\n  const {\n    element,\n    id\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getBusinessObject(element).get('camunda:versionTag');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      'camunda:versionTag': value\n    });\n  };\n  return (0,_bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .TextFieldEntry */ .Tq)({\n    element,\n    id,\n    label: translate('Version tag'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\nfunction HistoryCleanupProps(props) {\n  const {\n    element\n  } = props;\n  if (!is(element, 'dmn:Decision')) {\n    return [];\n  }\n  return [{\n    id: 'historyTimeToLive',\n    component: HistoryTimeToLive,\n    element,\n    isEdited: _bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .isTextFieldEntryEdited */ .V$\n  }];\n}\nfunction HistoryTimeToLive(props) {\n  const {\n    element,\n    id\n  } = props;\n  const modeling = useService('modeling');\n  const translate = useService('translate');\n  const debounce = useService('debounceInput');\n  const getValue = () => {\n    return getBusinessObject(element).get('camunda:historyTimeToLive');\n  };\n  const setValue = value => {\n    modeling.updateProperties(element, {\n      'camunda:historyTimeToLive': value\n    });\n  };\n  return (0,_bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .TextFieldEntry */ .Tq)({\n    element,\n    id,\n    label: translate('Time to live'),\n    getValue,\n    setValue,\n    debounce\n  });\n}\n\n/**\n * @typedef { import('@bpmn-io/properties-panel').EntryDefinition } Entry\n */\n\n/**\n * @returns {Array<Entry>} entries\n */\nfunction IdProps(props) {\n  const {\n    element\n  } = props;\n  return [{\n    id: 'id',\n    component: Id,\n    element,\n    isEdited: _bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .isTextFieldEntryEdited */ .V$\n  }];\n}\nfunction Id(props) {\n  const {\n    element,\n    id\n  } = props;\n  const modeling = useService('modeling');\n  const debounce = useService('debounceInput');\n  const translate = useService('translate');\n  const getValue = element => {\n    return getBusinessObject(element).get('id');\n  };\n  const setValue = (value, error) => {\n    if (error) {\n      return;\n    }\n    modeling.updateProperties(element, {\n      id: value\n    });\n  };\n  const validate = value => {\n    const businessObject = getBusinessObject(element);\n    return isIdValid(businessObject, value, translate);\n  };\n  const description = is(element, 'dmn:Decision') ? translate('This maps to the decision definition key.') : null;\n  return (0,_bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .TextFieldEntry */ .Tq)({\n    element,\n    id,\n    label: translate('ID'),\n    getValue,\n    setValue,\n    debounce,\n    validate,\n    description\n  });\n}\n\nconst LOW_PRIORITY = 500;\nconst CAMUNDA_PLATFORM_GROUPS = [HistoryCleanupGroup];\n\n/**\n * Provides `camunda` namespace properties.\n *\n * @example\n * ```javascript\n * import DmnModeler from 'dmn-js/lib/Modeler';\n * import {\n *   DmnPropertiesPanelModule,\n *   DmnPropertiesProviderModule,\n *   CamundaPlatformPropertiesProviderModule\n * } from 'dmn-js-properties-panel';\n *\n * const modeler = new DmnModeler({\n *   container: '#canvas',\n *   propertiesPanel: {\n *     parent: '#properties'\n *   },\n *   additionalModules: [\n *     DmnPropertiesPanelModule,\n *     DmnPropertiesProviderModule,\n *     CamundaPlatformPropertiesProviderModule\n *   ]\n * });\n * ```\n */\nclass CamundaPropertiesProvider {\n  constructor(propertiesPanel, injector) {\n    propertiesPanel.registerProvider(LOW_PRIORITY, this);\n    this._injector = injector;\n  }\n  getGroups(element) {\n    return groups => {\n      // (1) add Camunda Platform specific groups\n      groups = groups.concat(this._getGroups(element));\n\n      // (2) update existing groups with Camunda Platform specific properties\n      updateGeneralGroup(groups, element);\n      return groups;\n    };\n  }\n  _getGroups(element) {\n    const groups = CAMUNDA_PLATFORM_GROUPS.map(createGroup => createGroup(element, this._injector));\n\n    // contract: if a group returns null, it should not be displayed at all\n    return groups.filter(group => group !== null);\n  }\n}\nCamundaPropertiesProvider.$inject = ['propertiesPanel', 'injector'];\n\n/**\n * This ensures the <Implementation> group always locates after <Documentation>\n */\n\nfunction updateGeneralGroup(groups, element) {\n  const generalGroup = findGroup(groups, 'general');\n  if (!generalGroup) {\n    return;\n  }\n  const {\n    entries\n  } = generalGroup;\n\n  // (1) replace id with camunda id\n  const idIndex = (0,min_dash__WEBPACK_IMPORTED_MODULE_5__/* .findIndex */ .cx)(entries, entry => entry.id === 'id');\n  entries.splice(idIndex, 1, ...IdProps({\n    element\n  }));\n\n  // (2) add version tag after id\n  entries.splice(idIndex + 1, 0, ...VersionTagProps({\n    element\n  }));\n}\nfunction HistoryCleanupGroup(element) {\n  const group = {\n    label: 'History cleanup',\n    id: 'Camunda__HistoryCleanup',\n    component: _bpmn_io_properties_panel__WEBPACK_IMPORTED_MODULE_1__/* .Group */ .ZA,\n    entries: [...HistoryCleanupProps({\n      element\n    })]\n  };\n  if (group.entries.length) {\n    return group;\n  }\n  return null;\n}\n\n// helper /////////////////////\n\nfunction findGroup(groups, id) {\n  return groups.find(g => g.id === id);\n}\n\nvar index = {\n  __init__: ['CamundaPropertiesProvider'],\n  CamundaPropertiesProvider: ['type', CamundaPropertiesProvider]\n};\n\n\n//# sourceMappingURL=index.esm.js.map\n\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-properties-panel/dist/index.esm.js?")},"./node_modules/dmn-js-shared/lib/base/Manager.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ Manager)\n/* harmony export */ });\n/* harmony import */ var diagram_js_lib_core_EventBus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/diagram-js/lib/core/EventBus.js\");\n/* harmony import */ var dmn_moddle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/dmn-js-shared/node_modules/dmn-moddle/dist/index.esm.js\");\n/* harmony import */ var min_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/dmn-js-shared/node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var _util_CompatibilityUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(\"./node_modules/dmn-js-shared/lib/util/CompatibilityUtils.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\n\n\n/**\n * @typedef {import('./View').OpenResult} OpenResult\n */\n\n/**\n * @typedef {import('./View').OpenError} OpenError\n */\n\nconst DEFAULT_CONTAINER_OPTIONS = {\n  width: '100%',\n  height: '100%',\n  position: 'relative'\n};\n\n/**\n * The base class for DMN viewers and editors.\n *\n * @abstract\n */\nclass Manager {\n  /**\n   * Create a new instance with the given options.\n   *\n   * @param  {Object} options\n   *\n   * @return {Manager}\n   */\n  constructor() {\n    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    _defineProperty(this, \"_viewsChanged\", () => {\n      this._emit('views.changed', {\n        views: this._views,\n        activeView: this._activeView\n      });\n    });\n    this._eventBus = new diagram_js_lib_core_EventBus__WEBPACK_IMPORTED_MODULE_1__/* [\"default\"] */ .Z();\n    this._viewsChanged = (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .debounce */ .Ds)(this._viewsChanged, 0);\n    this._views = [];\n    this._viewers = {};\n\n    // keep support for callbacks\n    this.open = (0,_util_CompatibilityUtils__WEBPACK_IMPORTED_MODULE_3__/* .wrapForCompatibility */ .$)(this.open.bind(this));\n    this.importXML = (0,_util_CompatibilityUtils__WEBPACK_IMPORTED_MODULE_3__/* .wrapForCompatibility */ .$)(this.importXML.bind(this));\n    this.saveXML = (0,_util_CompatibilityUtils__WEBPACK_IMPORTED_MODULE_3__/* .wrapForCompatibility */ .$)(this.saveXML.bind(this));\n    this._init(options);\n  }\n\n  /**\n  * The importXML result.\n  *\n  * @typedef {Object} ImportXMLResult\n  *\n  * @property {Array<string>} warnings\n  */\n\n  /**\n  * The importXML error.\n  *\n  * @typedef {Error} ImportXMLError\n  *\n  * @property {Array<string>} warnings\n  */\n\n  /**\n   * Parse and render a DMN diagram.\n   *\n   * Once finished the viewer reports back the result to the\n   * provided callback function with (err, warnings).\n   *\n   * ## Life-Cycle Events\n   *\n   * During import the viewer will fire life-cycle events:\n   *\n   *   * import.parse.start (about to read model from xml)\n   *   * import.parse.complete (model read; may have worked or not)\n   *   * import.render.start (graphical import start)\n   *   * import.render.complete (graphical import finished)\n   *   * import.done (everything done)\n   *\n   * You can use these events to hook into the life-cycle.\n   *\n   * @param {string} xml the DMN xml\n   * @param {Object} [options]\n   * @param {boolean} [options.open=true]\n   *\n   * @return {Promise<ImportXMLResult, ImportXMLError>}\n   */\n  importXML(xml, options) {\n    var self = this;\n    options = options || {\n      open: true\n    };\n    return new Promise(function (resolve, reject) {\n      var previousActiveView = self._activeView;\n\n      // clean up previously rendered diagram before new import\n      self._clear().then(() => {\n        // hook in pre-parse listeners +\n        // allow xml manipulation\n        xml = self._emit('import.parse.start', {\n          xml: xml\n        }) || xml;\n        var parseWarnings;\n        self._moddle.fromXML(xml, 'dmn:Definitions').then(parseResult => {\n          var definitions = parseResult.rootElement;\n          var references = parseResult.references;\n          var elementsById = parseResult.elementsById;\n          parseWarnings = parseResult.warnings;\n\n          // hook in post parse listeners +\n          // allow definitions manipulation\n          definitions = self._emit('import.parse.complete', ParseCompleteEvent({\n            error: null,\n            definitions: definitions,\n            elementsById: elementsById,\n            references: references,\n            warnings: parseWarnings\n          })) || definitions;\n          self._setDefinitions(definitions);\n          if (!options.open) {\n            self._emit('import.done', {\n              error: null,\n              warnings: parseWarnings\n            });\n            resolve({\n              warnings: parseWarnings\n            });\n            return;\n          }\n\n          // open either previously active view or view of the same type if available\n          var view = self._getInitialView(self._views, previousActiveView);\n          if (!view) {\n            var noDisplayableContentsErr = new Error('no displayable contents');\n            self._emit('import.done', {\n              error: noDisplayableContentsErr,\n              warnings: parseWarnings\n            });\n            noDisplayableContentsErr.warnings = parseWarnings;\n            return reject(noDisplayableContentsErr);\n          }\n          self.open(view).then(result => ({\n            warnings: result.warnings\n          })).catch(error => ({\n            error: error,\n            warnings: error.warnings\n          })).then(result => {\n            var allWarnings = [].concat(parseWarnings, result.warnings);\n            self._emit('import.done', {\n              error: result.error,\n              warnings: allWarnings\n            });\n            if (result.error) {\n              result.error.warnings = allWarnings;\n              reject(result.error);\n            } else {\n              resolve({\n                warnings: allWarnings\n              });\n            }\n          });\n        }).catch(parseError => {\n          parseWarnings = parseError.warnings;\n          parseError = checkDMNCompatibilityError(parseError, xml) || checkValidationError(parseError) || parseError;\n          self._emit('import.parse.complete', ParseCompleteEvent({\n            error: parseError,\n            warnings: parseWarnings\n          }));\n          self._emit('import.done', {\n            error: parseError,\n            warnings: parseWarnings\n          });\n          parseError.warnings = parseWarnings;\n          return reject(parseError);\n        });\n      }).catch(clearError => {\n        self._emit('import.done', {\n          error: clearError,\n          warnings: []\n        });\n        clearError.warnings = [];\n        return reject(clearError);\n      });\n    });\n\n    // TODO: remove with future dmn-js version\n    function ParseCompleteEvent(data) {\n      var event = self._eventBus.createEvent(data);\n      Object.defineProperty(event, 'context', {\n        enumerable: true,\n        get: function get() {\n          console.warn(new Error('import.parse.complete <context> is deprecated ' + 'and will be removed in future library versions'));\n          return {\n            warnings: data.warnings,\n            references: data.references,\n            elementsById: data.elementsById\n          };\n        }\n      });\n      return event;\n    }\n  }\n  getDefinitions() {\n    return this._definitions;\n  }\n\n  /**\n   * Return active view.\n   *\n   * @return {View}\n   */\n  getActiveView() {\n    return this._activeView;\n  }\n\n  /**\n   * Get the currently active viewer instance.\n   *\n   * @return {View}\n   */\n  getActiveViewer() {\n    var activeView = this.getActiveView();\n    return activeView && this._getViewer(activeView);\n  }\n  getView(element) {\n    return this._views.filter(function (v) {\n      return v.element === element;\n    })[0];\n  }\n  getViews() {\n    return this._views;\n  }\n\n  /**\n   * The saveXML result.\n   *\n   * @typedef {Object} SaveXMLResult\n   *\n   * @property {string} xml\n   */\n\n  /**\n   * Export the currently displayed DMN diagram as\n   * a DMN XML document.\n   *\n   * ## Life-Cycle Events\n   *\n   * During XML saving the viewer will fire life-cycle events:\n   *\n   *   * saveXML.start (before serialization)\n   *   * saveXML.serialized (after xml generation)\n   *   * saveXML.done (everything done)\n   *\n   * You can use these events to hook into the life-cycle.\n   *\n   * @param {Object} [options] export options\n   * @param {boolean} [options.format=false] output formated XML\n   * @param {boolean} [options.preamble=true] output preamble\n   *\n   * @return {Promise<SaveXMLResult, Error>}\n   */\n  saveXML(options) {\n    var self = this;\n    options = options || {};\n    var definitions = this._definitions;\n    return new Promise(function (resolve, reject) {\n      if (!definitions) {\n        reject(new Error('no definitions loaded'));\n        return;\n      }\n\n      // allow to fiddle around with definitions\n      definitions = self._emit('saveXML.start', {\n        definitions: definitions\n      }) || definitions;\n      self._moddle.toXML(definitions, options).then(function (result) {\n        var xml = result.xml;\n        xml = self._emit('saveXML.serialized', {\n          xml: xml\n        }) || xml;\n        return {\n          xml\n        };\n      }).catch(error => ({\n        error\n      })).then(result => {\n        self._emit('saveXML.done', result);\n        if (result.error) {\n          reject(result.error);\n        } else {\n          resolve({\n            xml: result.xml\n          });\n        }\n      });\n    });\n  }\n\n  /**\n   * Register an event listener\n   *\n   * Remove a previously added listener via {@link #off(event, callback)}.\n   *\n   * @param {string} event\n   * @param {number} [priority]\n   * @param {Function} callback\n   * @param {Object} [that]\n   */\n  on() {\n    this._eventBus.on(...arguments);\n  }\n\n  /**\n   * De-register an event listener\n   *\n   * @param {string} event\n   * @param {Function} callback\n   */\n  off() {\n    this._eventBus.off(...arguments);\n  }\n\n  /**\n   * Register a listener to be invoked once only.\n   *\n   * @param {string} event\n   * @param {number} [priority]\n   * @param {Function} callback\n   * @param {Object} [that]\n   */\n  once() {\n    this._eventBus.once(...arguments);\n  }\n  attachTo(parentNode) {\n    // unwrap jQuery if provided\n    if (parentNode.get && parentNode.constructor.prototype.jquery) {\n      parentNode = parentNode.get(0);\n    }\n    if (typeof parentNode === 'string') {\n      parentNode = (0,min_dom__WEBPACK_IMPORTED_MODULE_4__/* .query */ .IO)(parentNode);\n    }\n    parentNode.appendChild(this._container);\n    this._emit('attach', {});\n  }\n  detach() {\n    this._emit('detach', {});\n    (0,min_dom__WEBPACK_IMPORTED_MODULE_4__/* .remove */ .Od)(this._container);\n  }\n  destroy() {\n    Object.keys(this._viewers).forEach(viewerId => {\n      var viewer = this._viewers[viewerId];\n      safeExecute(viewer, 'destroy');\n    });\n    (0,min_dom__WEBPACK_IMPORTED_MODULE_4__/* .remove */ .Od)(this._container);\n  }\n  _init(options) {\n    this._options = options;\n    this._moddle = this._createModdle(options);\n    this._viewers = {};\n    this._views = [];\n    const container = (0,min_dom__WEBPACK_IMPORTED_MODULE_4__/* .domify */ .H6)('<div class=\"dmn-js-parent\"></div>');\n    const containerOptions = (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .assign */ .f0)({}, DEFAULT_CONTAINER_OPTIONS, options);\n    (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .assign */ .f0)(container.style, {\n      width: ensureUnit(containerOptions.width),\n      height: ensureUnit(containerOptions.height),\n      position: containerOptions.position\n    });\n    this._container = container;\n    if (options.container) {\n      this.attachTo(options.container);\n    }\n  }\n  _clear() {\n    return this._switchView(null);\n  }\n\n  /**\n   * Open diagram view.\n   *\n   * @param  {View} view\n   * @returns {Promise} Resolves with {OpenResult} when successful\n   * or rejects with {OpenError}\n   */\n  open(view) {\n    return this._switchView(view);\n  }\n  _setDefinitions(definitions) {\n    this._definitions = definitions;\n    this._updateViews();\n  }\n  /**\n   * Recompute changed views after elements in\n   * the DMN diagram have changed.\n   */\n  _updateViews() {\n    var definitions = this._definitions;\n    if (!definitions) {\n      this._views = [];\n      this._switchView(null);\n      return;\n    }\n    var viewProviders = this._getViewProviders();\n    var displayableElements = [definitions, ...(definitions.drgElement || [])];\n\n    // compute list of available views\n    var views = this._views,\n      newViews = [];\n    for (var _i = 0, _displayableElements = displayableElements; _i < _displayableElements.length; _i++) {\n      var element = _displayableElements[_i];\n      var provider = (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .find */ .sE)(viewProviders, function (provider) {\n        if (typeof provider.opens === 'string') {\n          return provider.opens === element.$type;\n        } else {\n          return provider.opens(element);\n        }\n      });\n      if (!provider) {\n        continue;\n      }\n      var view = {\n        element,\n        id: element.id,\n        name: element.name,\n        type: provider.id\n      };\n      newViews.push(view);\n    }\n    var activeView = this._activeView,\n      newActiveView;\n    if (activeView) {\n      // check the new active view\n      newActiveView = (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .find */ .sE)(newViews, function (view) {\n        return viewsEqual(activeView, view);\n      }) || this._getInitialView(newViews);\n      if (!newActiveView) {\n        this._switchView(null);\n        return;\n      }\n    }\n\n    // Views have changed if\n    // active view has changed OR\n    // number of views has changed OR\n    // not all views equal\n    var activeViewChanged = !viewsEqual(activeView, newActiveView) || viewNameChanged(activeView, newActiveView);\n    var viewsChanged = views.length !== newViews.length || !(0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .every */ .yW)(newViews, function (newView) {\n      return (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .find */ .sE)(views, function (view) {\n        return viewsEqual(view, newView) && !viewNameChanged(view, newView);\n      });\n    });\n    this._activeView = newActiveView;\n    this._views = newViews;\n    if (activeViewChanged || viewsChanged) {\n      this._viewsChanged();\n    }\n  }\n  _getInitialView(views, preferredView) {\n    var initialView;\n    if (preferredView) {\n      initialView = (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .find */ .sE)(views, function (view) {\n        return viewsEqual(view, preferredView);\n      }) || (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .find */ .sE)(views, function (view) {\n        return view.type === preferredView;\n      });\n    }\n    return initialView || views[0];\n  }\n\n  /**\n   * Switch to another view.\n   *\n   * @param  {View} newView\n   * @returns {Promise} Resolves with {OpenResult} when successful\n   * or rejects with {OpenError}\n   */\n  _switchView(newView) {\n    var self = this;\n    return new Promise(function (resolve, reject) {\n      var complete = (openError, openResult) => {\n        self._viewsChanged();\n        if (openError) {\n          reject(openError);\n        } else {\n          resolve(openResult);\n        }\n      };\n      var activeView = self.getActiveView(),\n        activeViewer;\n      var newViewer = newView && self._getViewer(newView),\n        element = newView && newView.element;\n      if (activeView) {\n        activeViewer = self._getViewer(activeView);\n        if (activeViewer !== newViewer) {\n          safeExecute(activeViewer, 'clear');\n          activeViewer.detach();\n        }\n      }\n      self._activeView = newView;\n      if (newViewer) {\n        if (activeViewer !== newViewer) {\n          newViewer.attachTo(self._container);\n        }\n        self._emit('import.render.start', {\n          view: newView,\n          element: element\n        });\n        newViewer.open(element).then(result => {\n          self._emit('import.render.complete', {\n            view: newView,\n            error: null,\n            warnings: result.warnings\n          });\n          complete(null, result);\n        }).catch(error => {\n          self._emit('import.render.complete', {\n            view: newView,\n            error: error,\n            warnings: error.warnings\n          });\n          complete(error, null);\n        });\n        return;\n      }\n\n      // no active view\n      complete();\n    });\n  }\n  _getViewer(view) {\n    var type = view.type;\n    var viewer = this._viewers[type];\n    if (!viewer) {\n      viewer = this._viewers[type] = this._createViewer(view.type);\n      this._emit('viewer.created', {\n        type: type,\n        viewer: viewer\n      });\n    }\n    return viewer;\n  }\n  _createViewer(id) {\n    var provider = (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .find */ .sE)(this._getViewProviders(), function (provider) {\n      return provider.id === id;\n    });\n    if (!provider) {\n      throw new Error('no provider for view type <' + id + '>');\n    }\n    var Viewer = provider.constructor;\n    var providerOptions = this._options[id] || {};\n    var commonOptions = this._options.common || {};\n    return new Viewer(_objectSpread(_objectSpread(_objectSpread({}, commonOptions), providerOptions), {}, {\n      additionalModules: [...(providerOptions.additionalModules || []), {\n        _parent: ['value', this],\n        moddle: ['value', this._moddle]\n      }]\n    }));\n  }\n\n  /**\n   * Emit an event.\n   */\n  _emit() {\n    return this._eventBus.fire(...arguments);\n  }\n  _createModdle(options) {\n    return new dmn_moddle__WEBPACK_IMPORTED_MODULE_0__/* [\"default\"] */ .Z(options.moddleExtensions);\n  }\n\n  /**\n   * Return the list of available view providers.\n   *\n   * @abstract\n   *\n   * @return {Array<ViewProvider>}\n   */\n  _getViewProviders() {\n    return [];\n  }\n}\n\n// helpers //////////////////////\n\n/**\n * Ensure the passed argument is a proper unit (defaulting to px)\n */\nfunction ensureUnit(val) {\n  return val + ((0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .isNumber */ .hj)(val) ? 'px' : '');\n}\nfunction checkDMNCompatibilityError(err, xml) {\n  // check if we can indicate opening of old DMN 1.1 or DMN 1.2 diagrams\n\n  if (err.message !== 'failed to parse document as <dmn:Definitions>') {\n    return null;\n  }\n  var olderDMNVersion = xml.indexOf('\"http://www.omg.org/spec/DMN/20151101/dmn.xsd\"') !== -1 && '1.1' || xml.indexOf('\"http://www.omg.org/spec/DMN/20180521/MODEL/\"') !== -1 && '1.2';\n  if (!olderDMNVersion) {\n    return null;\n  }\n  err = new Error('unsupported DMN ' + olderDMNVersion + ' file detected; ' + 'only DMN 1.3 files can be opened');\n  console.error('Cannot open what looks like a DMN ' + olderDMNVersion + ' diagram. ' + 'Please refer to https://bpmn.io/l/dmn-compatibility.html ' + 'to learn how to make the toolkit compatible with older DMN files', err);\n  return err;\n}\nfunction checkValidationError(err) {\n  // check if we can help the user by indicating wrong DMN 1.3 xml\n  // (in case he or the exporting tool did not get that right)\n\n  var pattern = /unparsable content <([^>]+)> detected([\\s\\S]*)$/,\n    match = pattern.exec(err.message);\n  if (!match) {\n    return null;\n  }\n  err.message = 'unparsable content <' + match[1] + '> detected; ' + 'this may indicate an invalid DMN 1.3 diagram file' + match[2];\n  return err;\n}\nfunction viewsEqual(a, b) {\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .isDefined */ .$K)(a)) {\n    if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .isDefined */ .$K)(b)) {\n      return true;\n    } else {\n      return false;\n    }\n  }\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .isDefined */ .$K)(b)) {\n    return false;\n  }\n\n  // compare by element OR element ID equality\n  return a.element === b.element || a.id === b.id;\n}\nfunction viewNameChanged(a, b) {\n  return !a || !b || a.name !== b.name;\n}\nfunction safeExecute(viewer, method) {\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .mf)(viewer[method])) {\n    viewer[method]();\n  }\n}\n//# sourceMappingURL=Manager.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-shared/lib/base/Manager.js?")},"./node_modules/dmn-js-shared/lib/components/Logo.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ Logo)\n/* harmony export */ });\n/* harmony import */ var inferno__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/inferno/index.esm.js");\n\nfunction Logo() {\n  return (0,inferno__WEBPACK_IMPORTED_MODULE_0__/* .createVNode */ .Wm)(32, "svg", null, [(0,inferno__WEBPACK_IMPORTED_MODULE_0__/* .createVNode */ .Wm)(1, "path", null, null, 1, {\n    "fill": "#000000",\n    "d": \'M1.88.92v.14c0 .41-.13.68-.4.8.33.14.46.44.46.86v.33c0 .61-.33.95-.95.95H0V0h.95c.65 0 .93.3.93.92zM.63.57v1.06h.24c.24 0 .38-.1.38-.43V.98c0-.28-.1-.4-.32-.4zm0 1.63v1.22h.36c.2 0 .32-.1.32-.39v-.35c0-.37-.12-.48-.4-.48H.63zM4.18.99v.52c0 .64-.31.98-.94.98h-.3V4h-.62V0h.92c.63 0 .94.35.94.99zM2.94.57v1.35h.3c.2 0 .3-.09.3-.37v-.6c0-.29-.1-.38-.3-.38h-.3zm2.89 2.27L6.25 0h.88v4h-.6V1.12L6.1 3.99h-.6l-.46-2.82v2.82h-.55V0h.87zM8.14 1.1V4h-.56V0h.79L9 2.4V0h.56v4h-.64zm2.49 2.29v.6h-.6v-.6zM12.12 1c0-.63.33-1 .95-1 .61 0 .95.37.95 1v2.04c0 .64-.34 1-.95 1-.62 0-.95-.37-.95-1zm.62 2.08c0 .28.13.39.33.39s.32-.1.32-.4V.98c0-.29-.12-.4-.32-.4s-.33.11-.33.4z\'\n  }), (0,inferno__WEBPACK_IMPORTED_MODULE_0__/* .createVNode */ .Wm)(1, "path", null, null, 1, {\n    "fill": "#000000",\n    "d": "M0 4.53h14.02v1.04H0zM11.08 0h.63v.62h-.63zm.63 4V1h-.63v2.98z"\n  })], 4, {\n    "xmlns": "http://www.w3.org/2000/svg",\n    "viewBox": "0 0 14.02 5.57",\n    "width": "53",\n    "height": "21",\n    "style": "vertical-align:middle"\n  });\n}\n//# sourceMappingURL=Logo.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-shared/lib/components/Logo.js?')},"./node_modules/dmn-js-shared/lib/components/mixins/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "t": () => (/* reexport */ mixins_ComponentWithSlots)\n});\n\n// EXTERNAL MODULE: ./node_modules/inferno/index.esm.js + 1 modules\nvar index_esm = __webpack_require__("./node_modules/inferno/index.esm.js");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/components/mixins/ComponentWithSlots.js\nconst _excluded = ["type", "context"],\n  _excluded2 = ["type", "context"];\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nfunction _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }\nfunction _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\n/**\n * A simple slot extension, built upon the components service.\n *\n * @type {Object}\n */\nconst ComponentWithSlots = {\n  slotFill(slotProps, DefaultFill) {\n    const type = slotProps.type,\n      context = slotProps.context,\n      props = _objectWithoutProperties(slotProps, _excluded);\n    const Fill = this.components.getComponent(type, context) || DefaultFill;\n    if (Fill) {\n      return (0,index_esm/* normalizeProps */.vs)((0,index_esm/* createComponentVNode */.Iz)(2, Fill, _objectSpread(_objectSpread({}, context), props)));\n    }\n    return null;\n  },\n  slotFills(slotProps) {\n    const type = slotProps.type,\n      context = slotProps.context,\n      props = _objectWithoutProperties(slotProps, _excluded2);\n    const fills = this.components.getComponents(type, context);\n    return fills.map(Fill => (0,index_esm/* normalizeProps */.vs)((0,index_esm/* createComponentVNode */.Iz)(2, Fill, _objectSpread(_objectSpread({}, context), props))));\n  }\n};\n/* harmony default export */ const mixins_ComponentWithSlots = (ComponentWithSlots);\nComponentWithSlots.$inject = [\'components\'];\n//# sourceMappingURL=ComponentWithSlots.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/components/mixins/index.js\n\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-shared/lib/components/mixins/index.js_+_1_modules?')},"./node_modules/dmn-js-shared/lib/features/expression-languages/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ expression_languages)\n});\n\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/dmn-js-shared/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/features/expression-languages/ExpressionLanguages.js\n\nconst EXPRESSION_LANGUAGE_OPTIONS = [{\n  label: 'FEEL',\n  value: 'feel'\n}];\n\n/**\n * @typedef ExpressionLanguageDescriptor\n * @property {string} value - value inserted into XML\n * @property {string} label - human-readable label\n */\n\n/**\n * Provide options and defaults of expression languages via config.\n *\n * @example\n *\n * // there will be two languages available with FEEL as default\n * const editor = new DmnJS({\n *   common: {\n *     expressionLanguages: {\n *       options: [{\n *         value: 'feel',\n *         label: 'FEEL'\n *       }, {\n *         value: 'juel',\n *         label: 'JUEL'\n *       }],\n *       defaults: {\n *         editor: 'feel'\n *       }\n *     }\n *   }\n * })\n */\nclass ExpressionLanguages {\n  constructor(injector) {\n    this._injector = injector;\n    const config = injector.get('config.expressionLanguages') || {};\n    this._config = {\n      options: EXPRESSION_LANGUAGE_OPTIONS,\n      defaults: {\n        editor: 'feel'\n      }\n    };\n\n    // first assign the list of languages as it might be required for the legacy defaults\n    if (config.options) {\n      this._config.options = config.options;\n    }\n    const legacyDefaults = this._getLegacyDefaults();\n    (0,index_esm/* assign */.f0)(this._config.defaults, legacyDefaults, config.defaults);\n  }\n\n  /**\n   * Get default expression language for a component or the editor if `componentName`\n   * is not provided.\n   *\n   * @param {string} [componentName]\n   * @returns {ExpressionLanguageDescriptor}\n   */\n  getDefault(componentName) {\n    const defaults = this._config.defaults;\n    const defaultFromConfig = defaults[componentName] || defaults.editor;\n    return this._getLanguageByValue(defaultFromConfig) || this.getAll()[0];\n  }\n\n  /**\n   * Get label for provided expression language.\n   *\n   * @param {string} expressionLanguageValue - value from XML\n   * @returns {string}\n   */\n  getLabel(expressionLanguageValue) {\n    const langauge = this._getLanguageByValue(expressionLanguageValue);\n    return langauge ? langauge.label : expressionLanguageValue;\n  }\n\n  /**\n   * Get list of configured expression languages.\n   *\n   * @returns {ExpressionLanguageDescriptor[]}\n   */\n  getAll() {\n    return this._config.options;\n  }\n  _getLegacyDefaults() {\n    const defaults = {},\n      injector = this._injector;\n    const inputCellValue = injector.get('config.defaultInputExpressionLanguage');\n    const outputCellValue = injector.get('config.defaultOutputExpressionLanguage');\n    if (inputCellValue) {\n      defaults.inputCell = inputCellValue;\n    }\n    if (outputCellValue) {\n      defaults.outputCell = outputCellValue;\n    }\n    return defaults;\n  }\n  _getLanguageByValue(value) {\n    return (0,index_esm/* find */.sE)(this.getAll(), language => value === language.value);\n  }\n}\nExpressionLanguages.$inject = ['injector'];\n//# sourceMappingURL=ExpressionLanguages.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/features/expression-languages/index.js\n\n/* harmony default export */ const expression_languages = ({\n  __init__: ['expressionLanguages'],\n  expressionLanguages: ['type', ExpressionLanguages]\n});\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-shared/lib/features/expression-languages/index.js_+_1_modules?")},"./node_modules/dmn-js-shared/lib/util/CompatibilityUtils.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"$\": () => (/* binding */ wrapForCompatibility)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/dmn-js-shared/node_modules/min-dash/dist/index.esm.js\");\n\n\n// TODO: remove with future dmn-js version\n\n/**\n * Wraps APIs to check:\n *\n * 1) If a callback is passed -> Warn users about callback deprecation.\n * 2) If Promise class is implemented in current environment.\n *\n * @private\n */\nfunction wrapForCompatibility(api) {\n  return function () {\n    if (!window.Promise) {\n      throw new Error('Promises is not supported in this environment.' + ' Please polyfill Promise.');\n    }\n    var argLen = arguments.length;\n    if (argLen >= 1 && (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(arguments[argLen - 1])) {\n      var callback = arguments[argLen - 1];\n      console.warn(new Error('Passing callbacks to ' + replaceBoundPrefix(api.name) + ' is deprecated and will be removed in a future major release. ' + 'Please switch to promises: https://bpmn.io/l/moving-to-promises.html'));\n      var argsWithoutCallback = Array.prototype.slice.call(arguments, 0, -1);\n      api.apply(this, argsWithoutCallback).then(function (result) {\n        var firstKey = Object.keys(result)[0];\n\n        // The APIs we are wrapping all resolve a single item depending on the API.\n        // For instance, importXML resolves { warnings } and saveXML returns { xml }.\n        // That's why we can call the callback with the first item of result.\n        return callback(null, result[firstKey]);\n\n        // Passing a second paramter instead of catch because we don't want to\n        // catch errors thrown by callback().\n      }, function (err) {\n        return callback(err, err.warnings);\n      });\n    } else {\n      return api.apply(this, arguments);\n    }\n  };\n}\n\n// helper ////////\n\n/**\n * replaceBoundPrefix - replace the <bound > prefix from a string. Can be used\n * when logging the name of an API, not being sure whether is was bound or not.\n *\n * @param  {string} string\n * @return {string} the string without the <bound > prefix. If no <bound > prefix\n * was present, the same string will be returned.\n */\nfunction replaceBoundPrefix(string) {\n  return string.replace('bound ', '');\n}\n//# sourceMappingURL=CompatibilityUtils.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-shared/lib/util/CompatibilityUtils.js?")},"./node_modules/dmn-js-shared/lib/util/DiUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "w": () => (/* binding */ containsDi)\n/* harmony export */ });\n/* unused harmony export hasDi */\n/**\n * Does the definitions element contain graphical information?\n *\n * @param  {ModdleElement} definitions\n *\n * @return {boolean} true, if the definitions contains graphical information\n */\nfunction containsDi(definitions) {\n  return definitions.dmnDI && definitions.dmnDI.diagrams && definitions.dmnDI.diagrams[0];\n}\nfunction hasDi(element) {\n  return !!element.di;\n}\n//# sourceMappingURL=DiUtil.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-shared/lib/util/DiUtil.js?')},"./node_modules/dmn-js-shared/lib/util/ModelUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "JZ": () => (/* binding */ isAny),\n/* harmony export */   "RW": () => (/* binding */ isOutput),\n/* harmony export */   "SS": () => (/* binding */ getBusinessObject),\n/* harmony export */   "is": () => (/* binding */ is),\n/* harmony export */   "oY": () => (/* binding */ getName),\n/* harmony export */   "u7": () => (/* binding */ isInput)\n/* harmony export */ });\n/* unused harmony export isRule */\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/dmn-js-shared/node_modules/min-dash/dist/index.esm.js");\n\n\n/**\n * Is an element of the given DMN type?\n *\n * @param  {tjs.model.Base|ModdleElement} element\n * @param  {string} type\n *\n * @return {boolean}\n */\nfunction is(element, type) {\n  var bo = getBusinessObject(element);\n  return bo && typeof bo.$instanceOf === \'function\' && bo.$instanceOf(type);\n}\nfunction isInput(element) {\n  return is(element, \'dmn:InputClause\');\n}\nfunction isOutput(element) {\n  return is(element, \'dmn:OutputClause\');\n}\nfunction isRule(element) {\n  return is(element, \'dmn:DecisionRule\');\n}\n\n/**\n * Return the business object for a given element.\n *\n * @param  {tjs.model.Base|ModdleElement} element\n *\n * @return {ModdleElement}\n */\nfunction getBusinessObject(element) {\n  return element && element.businessObject || element;\n}\nfunction getName(element) {\n  return getBusinessObject(element).name;\n}\n\n/**\n * Return true if element has any of the given types.\n *\n * @param {djs.model.Base} element\n * @param {Array<string>} types\n *\n * @return {boolean}\n */\nfunction isAny(element, types) {\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .some */ .G)(types, function (t) {\n    return is(element, t);\n  });\n}\n//# sourceMappingURL=ModelUtil.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js-shared/lib/util/ModelUtil.js?')},"./node_modules/dmn-js/lib/Modeler.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ Modeler)\n});\n\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/base/Manager.js\nvar Manager = __webpack_require__(\"./node_modules/dmn-js-shared/lib/base/Manager.js\");\n// EXTERNAL MODULE: ./node_modules/ids/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/ids/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/dmn-js-shared/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/base/EditingManager.js\n\n\n\nclass EditingManager extends Manager/* default */.Z {\n  _init(options) {\n    super._init(options);\n\n    // hook ID collection into the modeler\n    this.on('import.parse.complete', event => {\n      if (!event.error) {\n        this._collectIds(event.definitions, event.elementsById);\n      }\n    });\n    this.on('destroy', () => {\n      this._moddle.ids.clear();\n    });\n    this.on('viewer.created', _ref => {\n      let viewer = _ref.viewer;\n      viewer.on('elements.changed', _ref2 => {\n        let elements = _ref2.elements;\n        var viewsChanged = elements.some(function (e) {\n          return (0,ModelUtil/* isAny */.JZ)(e, ['dmn:Decision', 'dmn:Definitions']);\n        });\n        if (viewsChanged) {\n          this._updateViews();\n        }\n      });\n    });\n  }\n\n  /**\n   * Collect ids processed during parsing of the\n   * definitions object.\n   *\n   * @param {ModdleElement} definitions\n   * @param {Array<ModdleElement>} elementsById\n   */\n  _collectIds(definitions, elementsById) {\n    var moddle = definitions.$model,\n      ids = moddle.ids,\n      id;\n\n    // remove references from previous import\n    ids.clear();\n    for (id in elementsById) {\n      ids.claim(id, elementsById[id]);\n    }\n  }\n  _createModdle(options) {\n    var moddle = super._createModdle(options);\n\n    // attach ids to moddle to be able to track\n    // and validated ids in the DMN XML document\n    // tree\n    moddle.ids = new index_esm/* default */.Z([32, 36, 1]);\n    return moddle;\n  }\n}\n//# sourceMappingURL=EditingManager.js.map\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/dmn-js-drd/lib/Viewer.js + 12 modules\nvar Viewer = __webpack_require__(\"./node_modules/dmn-js-drd/lib/Viewer.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/navigation/zoomscroll/index.js + 3 modules\nvar zoomscroll = __webpack_require__(\"./node_modules/diagram-js/lib/navigation/zoomscroll/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/navigation/movecanvas/index.js + 1 modules\nvar movecanvas = __webpack_require__(\"./node_modules/diagram-js/lib/navigation/movecanvas/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/navigation/touch/index.js + 3 modules\nvar touch = __webpack_require__(\"./node_modules/diagram-js/lib/navigation/touch/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/NavigatedViewer.js\n\n\n\n/**\n * A viewer that includes mouse navigation facilities\n *\n * @param {Object} options\n */\nfunction NavigatedViewer(options) {\n  Viewer/* default.call */.Z.call(this, options);\n}\n(0,index_es/* default */.Z)(NavigatedViewer, Viewer/* default */.Z);\n\n\n\nNavigatedViewer.prototype._navigationModules = [zoomscroll/* default */.Z, movecanvas/* default */.Z, touch/* default */.Z];\nNavigatedViewer.prototype._modules = [].concat(NavigatedViewer.prototype._modules, NavigatedViewer.prototype._navigationModules);\n//# sourceMappingURL=NavigatedViewer.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/align-elements/index.js + 1 modules\nvar align_elements = __webpack_require__(\"./node_modules/diagram-js/lib/features/align-elements/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/auto-place/index.js + 2 modules\nvar auto_place = __webpack_require__(\"./node_modules/diagram-js/lib/features/auto-place/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/auto-place/AutoPlaceUtil.js\nvar AutoPlaceUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/auto-place/AutoPlaceUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n// EXTERNAL MODULE: ./node_modules/dmn-js-drd/node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/dmn-js-drd/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/core/ElementFactory.js\nvar ElementFactory = __webpack_require__(\"./node_modules/diagram-js/lib/core/ElementFactory.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/ElementFactory.js\n\n\n\n\nvar BUSINESS_KNOWLEDGE_MODEL_SIZE = {\n  width: 135,\n  height: 46\n};\nvar DECISION_SIZE = {\n  width: 180,\n  height: 80\n};\nvar INPUT_DATA_SIZE = {\n  width: 125,\n  height: 45\n};\nvar KNOWLEDGE_SOURCE_SIZE = {\n  width: 100,\n  height: 63\n};\n\n/**\n * A drd-aware factory for diagram-js shapes\n */\nfunction ElementFactory_ElementFactory(drdFactory) {\n  ElementFactory/* default.call */.Z.call(this);\n  this._drdFactory = drdFactory;\n}\n(0,index_es/* default */.Z)(ElementFactory_ElementFactory, ElementFactory/* default */.Z);\nElementFactory_ElementFactory.$inject = ['drdFactory'];\nElementFactory_ElementFactory.prototype.baseCreate = ElementFactory/* default.prototype.create */.Z.prototype.create;\nElementFactory_ElementFactory.prototype.create = function (elementType, attrs) {\n  return this.createDrdElement(elementType, attrs);\n};\nElementFactory_ElementFactory.prototype.createDrdElement = function (elementType, attrs) {\n  var drdFactory = this._drdFactory;\n  var size;\n  attrs = attrs || {};\n  var businessObject = attrs.businessObject;\n  if (!businessObject) {\n    if (!attrs.type) {\n      throw new Error('no shape type specified');\n    }\n    businessObject = drdFactory.create(attrs.type);\n  }\n  if (!businessObject.di) {\n    if (elementType === 'connection') {\n      businessObject.di = drdFactory.createDiEdge(businessObject, []);\n    } else if (elementType === 'shape') {\n      businessObject.di = drdFactory.createDiShape(businessObject, {});\n    }\n  }\n  size = this._getDefaultSize(businessObject);\n  attrs = (0,dist_index_esm/* assign */.f0)({\n    businessObject: businessObject,\n    id: businessObject.id\n  }, size, attrs);\n  return this.baseCreate(elementType, attrs);\n};\nElementFactory_ElementFactory.prototype._getDefaultSize = function (semantic) {\n  if ((0,ModelUtil.is)(semantic, 'dmn:BusinessKnowledgeModel')) {\n    return BUSINESS_KNOWLEDGE_MODEL_SIZE;\n  }\n  if ((0,ModelUtil.is)(semantic, 'dmn:Decision')) {\n    return DECISION_SIZE;\n  }\n  if ((0,ModelUtil.is)(semantic, 'dmn:InputData')) {\n    return INPUT_DATA_SIZE;\n  }\n  if ((0,ModelUtil.is)(semantic, 'dmn:KnowledgeSource')) {\n    return KNOWLEDGE_SOURCE_SIZE;\n  }\n  return {\n    width: 100,\n    height: 80\n  };\n};\n//# sourceMappingURL=ElementFactory.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/auto-place/DmnAutoPlaceUtil.js\n\n\n\n\nvar DIRECTION_LEFT = 'left',\n  DIRECTION_RIGHT = 'right';\nvar DRG_ELEMENT_MARGIN = 60,\n  DRG_ELEMENT_ROW_SIZE = DECISION_SIZE.width;\nfunction getNewShapePosition(source, element) {\n  if ((0,ModelUtil.is)(element, 'dmn:TextAnnotation')) {\n    return getTextAnnotationPosition(source, element);\n  }\n  if ((0,ModelUtil.is)(element, 'dmn:DRGElement')) {\n    return getDRGElementPosition(source, element);\n  }\n}\n\n/**\r\n * Always try to place text annotations top right of source.\r\n */\nfunction getTextAnnotationPosition(source, element) {\n  var sourceTrbl = (0,LayoutUtil/* asTRBL */.JA)(source);\n  var position = {\n    x: sourceTrbl.right + element.width / 2,\n    y: sourceTrbl.top - 50 - element.height / 2\n  };\n  var nextPositionDirection = {\n    y: {\n      margin: -30,\n      minDistance: 20\n    }\n  };\n  return (0,AutoPlaceUtil/* findFreePosition */.QA)(source, element, position, (0,AutoPlaceUtil/* generateGetNextPosition */.n5)(nextPositionDirection));\n}\n\n/**\r\n * Get position for DRG elements.\r\n *\r\n * @param {djs.model.Shape} source\r\n * @param {djs.model.Shape} element\r\n *\r\n * @returns {Point}\r\n */\nfunction getDRGElementPosition(source, element) {\n  var sourceTrbl = (0,LayoutUtil/* asTRBL */.JA)(source),\n    sourceMid = (0,LayoutUtil/* getMid */.wS)(source);\n  function getWeight(connection) {\n    return connection.target === source ? 1 : -1;\n  }\n  var verticalDistance = (0,AutoPlaceUtil/* getConnectedDistance */.KW)(source, {\n    defaultDistance: 180,\n    direction: 's',\n    getWeight: getWeight,\n    filter: filter,\n    reference: 'center'\n  });\n  var position = {\n    x: sourceMid.x,\n    y: sourceTrbl.bottom + verticalDistance\n  };\n  return (0,AutoPlaceUtil/* findFreePosition */.QA)(source, element, position, generateGetNextDRGElementPosition(source));\n}\n\n// helpers //////////\n\nfunction filter(connection) {\n  return !(0,ModelUtil.is)(connection, 'dmn:Association');\n}\nfunction getHorizontalDistance(a, b) {\n  return Math.abs(b.x - a.x);\n}\nfunction generateGetNextDRGElementPosition(source) {\n  var sourceMid = (0,LayoutUtil/* getMid */.wS)(source);\n  var connectedAtPositionLeft, connectedAtPositionRight;\n  return function (element, previousPosition, connectedAtPreviousPosition) {\n    var direction;\n\n    // (1) get direction\n    if (!connectedAtPositionLeft) {\n      connectedAtPositionLeft = connectedAtPreviousPosition;\n      connectedAtPositionRight = connectedAtPreviousPosition;\n      if ((0,LayoutUtil/* getMid */.wS)(connectedAtPreviousPosition).x - sourceMid.x > 0) {\n        direction = DIRECTION_LEFT;\n      } else {\n        direction = DIRECTION_RIGHT;\n      }\n    } else {\n      if (previousPosition.x < sourceMid.x) {\n        connectedAtPositionLeft = connectedAtPreviousPosition;\n      } else {\n        connectedAtPositionRight = connectedAtPreviousPosition;\n      }\n      if (getHorizontalDistance(sourceMid, (0,LayoutUtil/* getMid */.wS)(connectedAtPositionLeft)) < getHorizontalDistance(sourceMid, (0,LayoutUtil/* getMid */.wS)(connectedAtPositionRight))) {\n        direction = DIRECTION_LEFT;\n      } else {\n        direction = DIRECTION_RIGHT;\n      }\n    }\n\n    // (2) get next position\n    if (direction === DIRECTION_LEFT) {\n      return {\n        x: Math.min((0,LayoutUtil/* getMid */.wS)(connectedAtPositionLeft).x - DRG_ELEMENT_ROW_SIZE - DRG_ELEMENT_MARGIN, (0,LayoutUtil/* asTRBL */.JA)(connectedAtPositionLeft).left - DRG_ELEMENT_MARGIN - element.width / 2),\n        y: previousPosition.y\n      };\n    } else {\n      return {\n        x: Math.max((0,LayoutUtil/* getMid */.wS)(connectedAtPositionRight).x + DRG_ELEMENT_ROW_SIZE + DRG_ELEMENT_MARGIN, (0,LayoutUtil/* asTRBL */.JA)(connectedAtPositionRight).right + DRG_ELEMENT_MARGIN + element.width / 2),\n        y: previousPosition.y\n      };\n    }\n  };\n}\n//# sourceMappingURL=DmnAutoPlaceUtil.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/auto-place/DmnAutoPlace.js\n\n\n/**\r\n * DMN auto-place behavior.\r\n *\r\n * @param {EventBus} eventBus\r\n */\nfunction AutoPlace(eventBus) {\n  eventBus.on('autoPlace', function (context) {\n    var shape = context.shape,\n      source = context.source;\n    return getNewShapePosition(source, shape);\n  });\n}\nAutoPlace.$inject = ['eventBus'];\n//# sourceMappingURL=DmnAutoPlace.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/auto-place/index.js\n\n\n/* harmony default export */ const features_auto_place = ({\n  __depends__: [auto_place/* default */.Z],\n  __init__: ['dmnAutoPlace'],\n  dmnAutoPlace: ['type', AutoPlace]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/auto-scroll/index.js + 1 modules\nvar auto_scroll = __webpack_require__(\"./node_modules/diagram-js/lib/features/auto-scroll/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/bendpoints/index.js + 8 modules\nvar bendpoints = __webpack_require__(\"./node_modules/diagram-js/lib/features/bendpoints/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/i18n/translate/index.js + 1 modules\nvar translate = __webpack_require__(\"./node_modules/diagram-js/lib/i18n/translate/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/context-pad/index.js + 1 modules\nvar context_pad = __webpack_require__(\"./node_modules/diagram-js/lib/features/context-pad/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/connect/index.js + 2 modules\nvar connect = __webpack_require__(\"./node_modules/diagram-js/lib/features/connect/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/create/index.js + 2 modules\nvar create = __webpack_require__(\"./node_modules/diagram-js/lib/features/create/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/popup-menu/index.js + 4 modules\nvar popup_menu = __webpack_require__(\"./node_modules/diagram-js/lib/features/popup-menu/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/replace/index.js + 2 modules\nvar replace = __webpack_require__(\"./node_modules/diagram-js/lib/features/replace/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/replace/DrdReplace.js\n/**\n * This module takes care of replacing DRD elements\n */\nfunction DrdReplace(drdFactory, replace, selection, modeling) {\n  /**\n   * Prepares a new business object for the replacement element\n   * and triggers the replace operation.\n   *\n   * @param  {djs.model.Base} element\n   * @param  {Object} target\n   * @param  {Object} [hints]\n   *\n   * @return {djs.model.Base} the newly created element\n   */\n  function replaceElement(element, target, hints) {\n    hints = hints || {};\n    var type = target.type,\n      oldBusinessObject = element.businessObject;\n    var newBusinessObject = drdFactory.create(type);\n    var newElement = {\n      type: type,\n      businessObject: newBusinessObject\n    };\n    newElement.width = element.width;\n    newElement.height = element.height;\n    newBusinessObject.name = oldBusinessObject.name;\n    if (target.table) {\n      var table = drdFactory.create('dmn:DecisionTable');\n      newBusinessObject.decisionLogic = table;\n      table.$parent = newBusinessObject;\n      var output = drdFactory.create('dmn:OutputClause');\n      output.typeRef = 'string';\n      output.$parent = table;\n      table.output = [output];\n      var input = drdFactory.create('dmn:InputClause');\n      input.$parent = table;\n      var inputExpression = drdFactory.create('dmn:LiteralExpression', {\n        typeRef: 'string'\n      });\n      input.inputExpression = inputExpression;\n      inputExpression.$parent = input;\n      table.input = [input];\n    }\n    if (target.expression) {\n      newBusinessObject.decisionLogic = drdFactory.create('dmn:LiteralExpression');\n      newBusinessObject.variable = drdFactory.create('dmn:InformationItem');\n    }\n    return replace.replaceElement(element, newElement, hints);\n  }\n  this.replaceElement = replaceElement;\n}\nDrdReplace.$inject = ['drdFactory', 'replace', 'selection', 'modeling'];\n//# sourceMappingURL=DrdReplace.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/replace/index.js\n\n\n\n/* harmony default export */ const features_replace = ({\n  __depends__: [replace/* default */.Z, selection/* default */.Z],\n  drdReplace: ['type', DrdReplace]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/replace/ReplaceOptions.js\n/* harmony default export */ const ReplaceOptions = ({\n  DECISION: [{\n    label: 'Empty',\n    actionName: 'replace-with-empty-decision',\n    className: 'dmn-icon-clear',\n    target: {\n      type: 'dmn:Decision',\n      table: false,\n      expression: false\n    }\n  }, {\n    label: 'Decision Table',\n    actionName: 'replace-with-decision-table',\n    className: 'dmn-icon-decision-table',\n    target: {\n      type: 'dmn:Decision',\n      table: true,\n      expression: false\n    }\n  }, {\n    label: 'Literal Expression',\n    actionName: 'replace-with-literal-expression',\n    className: 'dmn-icon-literal-expression',\n    target: {\n      type: 'dmn:Decision',\n      table: false,\n      expression: true\n    }\n  }]\n});\n//# sourceMappingURL=ReplaceOptions.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/popup-menu/ReplaceMenuProvider.js\n\n\n\n\n/**\n * This module is an element agnostic replace menu provider for the popup menu.\n */\nfunction ReplaceMenuProvider(popupMenu, modeling, moddle, drdReplace, rules, translate) {\n  this._popupMenu = popupMenu;\n  this._modeling = modeling;\n  this._moddle = moddle;\n  this._drdReplace = drdReplace;\n  this._rules = rules;\n  this._translate = translate;\n  this.register();\n}\nReplaceMenuProvider.$inject = ['popupMenu', 'modeling', 'moddle', 'drdReplace', 'rules', 'translate'];\n\n/**\n * Register replace menu provider in the popup menu\n */\nReplaceMenuProvider.prototype.register = function () {\n  this._popupMenu.registerProvider('dmn-replace', this);\n};\n\n/**\n * Get all entries from replaceOptions for the given element.\n *\n * @param {djs.model.Base} element\n *\n * @return {Array<Object>} a list of menu entry items\n */\nReplaceMenuProvider.prototype.getEntries = function (element) {\n  var businessObject = element.businessObject;\n  var rules = this._rules;\n  if (!rules.allowed('shape.replace', {\n    element: element\n  })) {\n    return [];\n  }\n  if ((0,ModelUtil.is)(businessObject, 'dmn:Decision')) {\n    var options = (0,dist_index_esm/* filter */.hX)(ReplaceOptions.DECISION, function (option) {\n      var notEmpty = option.actionName === 'replace-with-empty-decision' && businessObject.decisionLogic;\n      var notTable = option.actionName === 'replace-with-decision-table' && !(0,ModelUtil.is)(businessObject.decisionLogic, 'dmn:DecisionTable');\n      var notExp = option.actionName === 'replace-with-literal-expression' && !(0,ModelUtil.is)(businessObject.decisionLogic, 'dmn:LiteralExpression');\n      return notEmpty || notTable || notExp;\n    });\n    return this._createEntries(element, options);\n  }\n  return [];\n};\n\n/**\n * Creates an array of menu entry objects for a given element.\n *\n * @param  {djs.model.Base} element\n * @param  {Object} replaceOptions\n *\n * @return {Array<Object>} a list of menu items\n */\nReplaceMenuProvider.prototype._createEntries = function (element, replaceOptions) {\n  var menuEntries = [];\n  var self = this;\n  (0,dist_index_esm/* forEach */.Ed)(replaceOptions, function (definition) {\n    var entry = self._createMenuEntry(definition, element);\n    menuEntries.push(entry);\n  });\n  return menuEntries;\n};\n\n/**\n * Creates and returns a single menu entry item.\n *\n * @param  {Object} definition a single replace options definition object\n * @param  {djs.model.Base} element\n * @param  {Function} [action] an action callback function which gets called when\n *                             the menu entry is being triggered.\n *\n * @return {Object} menu entry item\n */\nReplaceMenuProvider.prototype._createMenuEntry = function (definition, element, action) {\n  var replaceElement = this._drdReplace.replaceElement;\n  var translate = this._translate;\n  var replaceAction = function replaceAction() {\n    return replaceElement(element, definition.target);\n  };\n  action = action || replaceAction;\n  var menuEntry = {\n    label: translate(definition.label),\n    className: definition.className,\n    id: definition.actionName,\n    action: action\n  };\n  return menuEntry;\n};\nReplaceMenuProvider.prototype.getHeaderEntries = function (element) {\n  return [];\n};\n//# sourceMappingURL=ReplaceMenuProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/popup-menu/index.js\n\n\n\n\n/* harmony default export */ const features_popup_menu = ({\n  __depends__: [translate/* default */.Z, popup_menu/* default */.Z, features_replace],\n  __init__: ['replaceMenuProvider'],\n  replaceMenuProvider: ['type', ReplaceMenuProvider]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Mouse.js + 1 modules\nvar Mouse = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/context-pad/ContextPadProvider.js\n\n\n\n\n/**\n* A provider for DMN elements context pad\n*/\nfunction ContextPadProvider(eventBus, contextPad, modeling, elementFactory, connect, create, rules, popupMenu, canvas, translate, config, injector) {\n  config = config || {};\n  contextPad.registerProvider(this);\n  this._contextPad = contextPad;\n  this._modeling = modeling;\n  this._elementFactory = elementFactory;\n  this._connect = connect;\n  this._create = create;\n  this._rules = rules;\n  this._popupMenu = popupMenu;\n  this._canvas = canvas;\n  this._translate = translate;\n  if (config.autoPlace !== false) {\n    this._autoPlace = injector.get('autoPlace', false);\n  }\n  eventBus.on('create.end', 250, function (event) {\n    var shape = event.context.shape;\n    if (!(0,Mouse/* hasPrimaryModifier */.RJ)(event)) {\n      return;\n    }\n    var entries = contextPad.getEntries(shape);\n    if (entries.replace) {\n      entries.replace.action.click(event, shape);\n    }\n  });\n}\nContextPadProvider.$inject = ['eventBus', 'contextPad', 'modeling', 'elementFactory', 'connect', 'create', 'rules', 'popupMenu', 'canvas', 'translate', 'config.contextPad', 'injector'];\nContextPadProvider.prototype.getContextPadEntries = function (element) {\n  var modeling = this._modeling,\n    elementFactory = this._elementFactory,\n    connect = this._connect,\n    create = this._create,\n    popupMenu = this._popupMenu,\n    canvas = this._canvas,\n    contextPad = this._contextPad,\n    rules = this._rules,\n    translate = this._translate,\n    autoPlace = this._autoPlace;\n  var actions = {};\n  if (element.type === 'label') {\n    return actions;\n  }\n  var businessObject = element.businessObject;\n  function startConnect(event, element, autoActivate) {\n    connect.start(event, element, autoActivate);\n  }\n  function removeElement(e) {\n    modeling.removeElements([element]);\n  }\n  function getReplaceMenuPosition(element) {\n    var Y_OFFSET = 5;\n    var diagramContainer = canvas.getContainer(),\n      pad = contextPad.getPad(element).html;\n    var diagramRect = diagramContainer.getBoundingClientRect(),\n      padRect = pad.getBoundingClientRect();\n    var top = padRect.top - diagramRect.top;\n    var left = padRect.left - diagramRect.left;\n    var pos = {\n      x: left,\n      y: top + padRect.height + Y_OFFSET\n    };\n    return pos;\n  }\n\n  /**\n  * Create an append action\n  *\n  * @param {string} type\n  * @param {string} className\n  * @param {string} [title]\n  * @param {Object} [options]\n  *\n  * @return {Object} descriptor\n  */\n  function appendAction(type, className, title, options) {\n    if (typeof title !== 'string') {\n      options = title;\n      title = translate('Append {type}', {\n        type: type.replace(/^dmn:/, '')\n      });\n    }\n    function appendStart(event, element) {\n      var shape = elementFactory.createShape((0,dist_index_esm/* assign */.f0)({\n        type: type\n      }, options));\n      create.start(event, shape, {\n        source: element,\n        hints: {\n          connectionTarget: element\n        }\n      });\n    }\n    var append = autoPlace ? function (event, element) {\n      var shape = elementFactory.createShape((0,dist_index_esm/* assign */.f0)({\n        type: type\n      }, options));\n      autoPlace.append(element, shape, {\n        connectionTarget: element\n      });\n    } : appendStart;\n    return {\n      group: 'model',\n      className: className,\n      title: title,\n      action: {\n        dragstart: appendStart,\n        click: append\n      }\n    };\n  }\n  if ((0,ModelUtil.is)(businessObject, 'dmn:Decision')) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'append.decision': appendAction('dmn:Decision', 'dmn-icon-decision')\n    });\n  }\n  if ((0,ModelUtil/* isAny */.JZ)(businessObject, ['dmn:BusinessKnowledgeModel', 'dmn:Decision', 'dmn:KnowledgeSource'])) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'append.knowledge-source': appendAction('dmn:KnowledgeSource', 'dmn-icon-knowledge-source')\n    });\n  }\n  if ((0,ModelUtil/* isAny */.JZ)(businessObject, ['dmn:BusinessKnowledgeModel', 'dmn:Decision'])) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'append.business-knowledge-model': appendAction('dmn:BusinessKnowledgeModel', 'dmn-icon-business-knowledge')\n    });\n  }\n  if ((0,ModelUtil/* isAny */.JZ)(businessObject, ['dmn:Decision', 'dmn:KnowledgeSource'])) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'append.input-data': appendAction('dmn:InputData', 'dmn-icon-input-data')\n    });\n  }\n  if ((0,ModelUtil.is)(businessObject, 'dmn:DRGElement')) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'append.text-annotation': appendAction('dmn:TextAnnotation', 'dmn-icon-text-annotation'),\n      'connect': {\n        group: 'connect',\n        className: 'dmn-icon-connection-multi',\n        title: translate('Connect using Information/Knowledge' + '/Authority Requirement or Association'),\n        action: {\n          click: startConnect,\n          dragstart: startConnect\n        }\n      }\n    });\n  }\n  if ((0,ModelUtil.is)(businessObject, 'dmn:TextAnnotation')) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'connect': {\n        group: 'connect',\n        className: 'dmn-icon-connection-multi',\n        title: translate('Connect using association'),\n        action: {\n          click: startConnect,\n          dragstart: startConnect\n        }\n      }\n    });\n  }\n  if (!popupMenu.isEmpty(element, 'dmn-replace')) {\n    // Replace menu entry\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'replace': {\n        group: 'edit',\n        className: 'dmn-icon-screw-wrench',\n        title: translate('Change type'),\n        action: {\n          click: function click(event, element) {\n            var position = (0,dist_index_esm/* assign */.f0)(getReplaceMenuPosition(element), {\n              cursor: {\n                x: event.x,\n                y: event.y\n              }\n            });\n            popupMenu.open(element, 'dmn-replace', position);\n          }\n        }\n      }\n    });\n  }\n\n  // delete element entry, only show if allowed by rules\n  var deleteAllowed = rules.allowed('elements.delete', {\n    elements: [element]\n  });\n  if ((0,dist_index_esm/* isArray */.kJ)(deleteAllowed)) {\n    // was the element returned as a deletion candidate?\n    deleteAllowed = deleteAllowed[0] === element;\n  }\n  if (deleteAllowed) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'delete': {\n        group: 'edit',\n        className: 'dmn-icon-trash',\n        title: translate('Remove'),\n        action: {\n          click: removeElement\n        }\n      }\n    });\n  }\n  return actions;\n};\n//# sourceMappingURL=ContextPadProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/context-pad/index.js\n\n\n\n\n\n\n\n/* harmony default export */ const features_context_pad = ({\n  __depends__: [translate/* default */.Z, context_pad/* default */.Z, selection/* default */.Z, connect/* default */.Z, create/* default */.Z, features_popup_menu],\n  __init__: ['contextPadProvider'],\n  contextPadProvider: ['type', ContextPadProvider]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/connection-preview/index.js + 1 modules\nvar connection_preview = __webpack_require__(\"./node_modules/diagram-js/lib/features/connection-preview/index.js\");\n// EXTERNAL MODULE: ./node_modules/dmn-js-drd/lib/features/definition-properties/viewer.js + 1 modules\nvar viewer = __webpack_require__(\"./node_modules/dmn-js-drd/lib/features/definition-properties/viewer.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/util/IdsUtil.js\nconst SPACE_REGEX = /\\s/;\n\n// for QName validation as per http://www.w3.org/TR/REC-xml/#NT-NameChar\nconst QNAME_REGEX = /^([a-z][\\w-.]*:)?[a-z_][\\w-.]*$/i;\n\n// for ID validation as per BPMN Schema (QName - Namespace)\nconst ID_REGEX = /^[a-z_][\\w-.]*$/i;\nconst PLACEHOLDER_REGEX = /\\$\\{([^}]*)\\}/g;\n\n/**\n * Validates an ID.\n *\n * @param {ModdleElement} businessObject\n * @param {string} id\n *\n * @return {string} error message\n */\nfunction validateId(businessObject, id) {\n  const assigned = businessObject.$model.ids.assigned(id);\n  const idExists = assigned && assigned !== businessObject;\n  if (!id) {\n    return 'Element must have ID.';\n  }\n  if (idExists) {\n    return 'Element must have unique ID.';\n  }\n  return validateIdFormat(id);\n}\nfunction validateIdFormat(id) {\n  id = stripPlaceholders(id);\n  if (containsSpace(id)) {\n    return 'Id must not contain spaces.';\n  }\n  if (!ID_REGEX.test(id)) {\n    if (QNAME_REGEX.test(id)) {\n      return 'Id must not contain prefix.';\n    }\n    return 'Id must be a valid QName.';\n  }\n}\nfunction containsSpace(value) {\n  return SPACE_REGEX.test(value);\n}\nfunction stripPlaceholders(id) {\n  // replace expression e.g. ${VERSION_TAG}\n  // use only the content between ${}\n  // for the REGEX check\n  return id.replace(PLACEHOLDER_REGEX, '$1');\n}\n//# sourceMappingURL=IdsUtil.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/definition-properties/DefinitionPropertiesEdit.js\n\nvar DEBOUNCE_DELAY = 300;\n\n\n\nfunction DefinitionIdEdit(eventBus, modeling, canvas, definitionPropertiesView, translate) {\n  this._eventBus = eventBus;\n  this._modeling = modeling;\n  this._canvas = canvas;\n  this._definitionPropertiesView = definitionPropertiesView;\n  this._translate = translate;\n  eventBus.on('definitionIdView.create', function (event) {\n    this._container = event.html;\n    var nameElement = (0,min_dom_dist_index_esm/* query */.IO)('.dmn-definitions-name', this._container),\n      idElement = (0,min_dom_dist_index_esm/* query */.IO)('.dmn-definitions-id', this._container);\n    this._setup(nameElement, 'name');\n    this._setup(idElement, 'id');\n  }, this);\n}\nDefinitionIdEdit.$inject = ['eventBus', 'modeling', 'canvas', 'definitionPropertiesView', 'translate'];\nDefinitionIdEdit.prototype.update = function (type, newValue) {\n  var element = this._canvas.getRootElement();\n  var newProperties = {};\n  newProperties[type] = newValue;\n  if (type === 'id') {\n    var errorMessage = validateId((0,ModelUtil/* getBusinessObject */.SS)(element), newValue);\n    if (errorMessage) {\n      this._addErrorMessage(errorMessage);\n      return;\n    }\n    this._clearErrorMessage();\n  }\n  this._modeling.updateProperties(element, newProperties);\n};\nDefinitionIdEdit.prototype._setup = function (node, type) {\n  var self = this;\n  node.setAttribute('contenteditable', true);\n  node.addEventListener('input', (0,dist_index_esm/* debounce */.Ds)(function (evt) {\n    var value = evt.target.value || evt.target.textContent;\n    self.update(type, value.trim());\n  }, DEBOUNCE_DELAY));\n  node.addEventListener('keydown', function (evt) {\n    if (evt.keyCode === 13) {\n      node.blur();\n      window.getSelection().removeAllRanges();\n    }\n  });\n  node.addEventListener('blur', function () {\n    self._clearErrorMessage();\n    self._definitionPropertiesView.update();\n  });\n};\nDefinitionIdEdit.prototype._addErrorMessage = function (errorMessage) {\n  const errorHTML = '<span class=\"dmn-definitions-error-message\">' + this._translate(errorMessage) + '</span>';\n  var idElement = (0,min_dom_dist_index_esm/* query */.IO)('.dmn-definitions-id', this._container);\n\n  // clear previous error message\n  this._clearErrorMessage();\n\n  // add current error message\n  (0,min_dom_dist_index_esm/* classes */.Sh)(idElement).add('dmn-definitions-error');\n  idElement.parentElement.appendChild((0,min_dom_dist_index_esm/* domify */.H6)(errorHTML));\n};\nDefinitionIdEdit.prototype._clearErrorMessage = function () {\n  var idElement = (0,min_dom_dist_index_esm/* query */.IO)('.dmn-definitions-id', this._container);\n  if ((0,min_dom_dist_index_esm/* classes */.Sh)(idElement).has('dmn-definitions-error')) {\n    (0,min_dom_dist_index_esm/* classes */.Sh)(idElement).remove('dmn-definitions-error');\n    const errorLabel = (0,min_dom_dist_index_esm/* query */.IO)('.dmn-definitions-error-message', this._container);\n    idElement.parentNode.removeChild(errorLabel);\n  }\n};\n//# sourceMappingURL=DefinitionPropertiesEdit.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-drd/lib/features/definition-properties/PaletteAdapter.js\nvar PaletteAdapter = __webpack_require__(\"./node_modules/dmn-js-drd/lib/features/definition-properties/PaletteAdapter.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/definition-properties/modeler.js\n\n\n\n/* harmony default export */ const modeler = ({\n  __depends__: [viewer/* default */.Z],\n  __init__: ['definitionPropertiesEdit', 'definitionPropertiesPaletteAdapter'],\n  definitionPropertiesEdit: ['type', DefinitionIdEdit],\n  definitionPropertiesPaletteAdapter: ['type', PaletteAdapter/* default */.Z]\n});\n//# sourceMappingURL=modeler.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/distribute-elements/index.js + 1 modules\nvar distribute_elements = __webpack_require__(\"./node_modules/diagram-js/lib/features/distribute-elements/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/distribute-elements/DrdDistributeElements.js\n\n\n\n/**\n * Registers element exclude filters for elements that\n * currently do not support distribution.\n */\nfunction DrdDistributeElements(distributeElements) {\n  distributeElements.registerFilter(function (elements) {\n    return (0,dist_index_esm/* filter */.hX)(elements, function (element) {\n      var cannotDistribute = (0,ModelUtil/* isAny */.JZ)(element, ['dmn:AuthorityRequirement', 'dmn:InformationRequirement', 'dmn:KnowledgeRequirement', 'dmn:Association', 'dmn:TextAnnotation']);\n      return !(element.labelTarget || cannotDistribute);\n    });\n  });\n}\nDrdDistributeElements.$inject = ['distributeElements'];\n//# sourceMappingURL=DrdDistributeElements.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/distribute-elements/index.js\n\n\n/* harmony default export */ const features_distribute_elements = ({\n  __depends__: [distribute_elements/* default */.Z],\n  __init__: ['drdDistributeElements'],\n  drdDistributeElements: ['type', DrdDistributeElements]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/editor-actions/index.js\nvar editor_actions = __webpack_require__(\"./node_modules/diagram-js/lib/features/editor-actions/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/editor-actions/EditorActions.js\nvar EditorActions = __webpack_require__(\"./node_modules/diagram-js/lib/features/editor-actions/EditorActions.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/editor-actions/DrdEditorActions.js\n\n\nfunction DrdEditorActions(injector) {\n  injector.invoke(EditorActions/* default */.Z, this);\n}\n(0,index_es/* default */.Z)(DrdEditorActions, EditorActions/* default */.Z);\nDrdEditorActions.$inject = ['injector'];\n\n/**\n * Register default actions.\n *\n * @param {Injector} injector\n */\nDrdEditorActions.prototype._registerDefaultActions = function (injector) {\n  // (0) invoke super method\n\n  EditorActions/* default.prototype._registerDefaultActions.call */.Z.prototype._registerDefaultActions.call(this, injector);\n\n  // (1) retrieve optional components to integrate with\n\n  var canvas = injector.get('canvas', false);\n  var elementRegistry = injector.get('elementRegistry', false);\n  var selection = injector.get('selection', false);\n  var lassoTool = injector.get('lassoTool', false);\n  var handTool = injector.get('handTool', false);\n  var directEditing = injector.get('directEditing', false);\n  var distributeElements = injector.get('distributeElements', false);\n  var alignElements = injector.get('alignElements', false);\n\n  // (2) check components and register actions\n\n  if (canvas && elementRegistry && selection) {\n    this._registerAction('selectElements', function () {\n      // select all elements except for the invisible\n      // root element\n      var rootElement = canvas.getRootElement();\n      var elements = elementRegistry.filter(function (element) {\n        return element !== rootElement;\n      });\n      selection.select(elements);\n      return elements;\n    });\n  }\n  if (selection && distributeElements) {\n    this._registerAction('distributeElements', function (opts) {\n      var currentSelection = selection.get(),\n        type = opts.type;\n      if (currentSelection.length > 2) {\n        distributeElements.trigger(currentSelection, type);\n      }\n    });\n  }\n  if (selection && alignElements) {\n    this._registerAction('alignElements', function (opts) {\n      var currentSelection = selection.get(),\n        type = opts.type;\n      if (currentSelection.length > 1) {\n        alignElements.trigger(currentSelection, type);\n      }\n    });\n  }\n  if (lassoTool) {\n    this._registerAction('lassoTool', function () {\n      lassoTool.toggle();\n    });\n  }\n  if (handTool) {\n    this._registerAction('handTool', function () {\n      handTool.toggle();\n    });\n  }\n  if (selection && directEditing) {\n    this._registerAction('directEditing', function () {\n      var currentSelection = selection.get();\n      if (currentSelection.length) {\n        directEditing.activate(currentSelection[0]);\n      }\n    });\n  }\n};\n//# sourceMappingURL=DrdEditorActions.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/editor-actions/index.js\n\n\n/* harmony default export */ const features_editor_actions = ({\n  __depends__: [editor_actions/* default */.Z],\n  editorActions: ['type', DrdEditorActions]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/util/DiUtil.js\nvar DiUtil = __webpack_require__(\"./node_modules/dmn-js-shared/lib/util/DiUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/generate-di/DiGenerator.js\n\n\n\n\n/**\n * Generates missing DI on import.\n *\n * @param {DrdFactory} drdFactory\n * @param {ElementFactory} elementFactory\n * @param {EventBus} eventBus\n */\nfunction DiGenerator(drdFactory, elementFactory, eventBus, drdUpdater) {\n  function createDi(definitions) {\n    // retrieve or create dmnDI\n    var dmnDI = definitions.dmnDI;\n    if (!dmnDI) {\n      dmnDI = drdFactory.create('dmndi:DMNDI');\n      definitions.set('dmnDI', dmnDI);\n    }\n    var diagram = drdFactory.create('dmndi:DMNDiagram');\n    dmnDI.set('diagrams', [diagram]);\n    var index = 0;\n    (0,dist_index_esm/* forEach */.Ed)(definitions.get('drgElement'), function (drgElement) {\n      // generate DI for decisions only\n      if (!(0,ModelUtil.is)(drgElement, 'dmn:Decision')) {\n        return;\n      }\n      var dimensions = elementFactory._getDefaultSize(drgElement);\n      var di = drdFactory.createDiShape(drgElement, {\n        x: 150 + index * 30,\n        y: 150 + index * 30,\n        width: dimensions.width,\n        height: dimensions.height\n      });\n      drdUpdater.updateDiParent(di, diagram);\n      index++;\n    });\n  }\n  eventBus.on('import.start', _ref => {\n    let definitions = _ref.definitions;\n    if (!(0,DiUtil/* containsDi */.w)(definitions)) {\n      createDi(definitions);\n    }\n  });\n}\nDiGenerator.$inject = ['drdFactory', 'elementFactory', 'eventBus', 'drdUpdater'];\n//# sourceMappingURL=DiGenerator.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/generate-di/index.js\n\n/* harmony default export */ const generate_di = ({\n  __init__: ['diGenerator'],\n  diGenerator: ['type', DiGenerator]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/grid-snapping/index.js + 5 modules\nvar grid_snapping = __webpack_require__(\"./node_modules/diagram-js/lib/features/grid-snapping/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/index.js + 1 modules\nvar keyboard = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js\nvar KeyboardBindings = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/keyboard/DrdKeyboardBindings.js\n\n\n\n/**\n * DRD specific key bindings.\n *\n * @param {Keyboard} keyboard\n * @param {EditorActions} editorActions\n */\nfunction DrdKeyboardBindings(injector) {\n  injector.invoke(KeyboardBindings/* default */.ZP, this);\n}\n(0,index_es/* default */.Z)(DrdKeyboardBindings, KeyboardBindings/* default */.ZP);\nDrdKeyboardBindings.$inject = ['injector'];\n\n/**\n * Register available keyboard bindings.\n *\n * @param {Keyboard} keyboard\n * @param {EditorActions} editorActions\n */\nDrdKeyboardBindings.prototype.registerBindings = function (keyboard, editorActions) {\n  // inherit default bindings\n  KeyboardBindings/* default.prototype.registerBindings.call */.ZP.prototype.registerBindings.call(this, keyboard, editorActions);\n\n  /**\n   * Add keyboard binding if respective editor action\n   * is registered.\n   *\n   * @param {string} action name\n   * @param {Function} fn that implements the key binding\n   */\n  function addListener(action, fn) {\n    if (editorActions.isRegistered(action)) {\n      keyboard.addListener(fn);\n    }\n  }\n\n  // select all elements\n  // CTRL + A\n  addListener('selectElements', function (context) {\n    var event = context.keyEvent;\n    if (keyboard.isKey(['a', 'A'], event) && keyboard.isCmd(event)) {\n      editorActions.trigger('selectElements');\n      return true;\n    }\n  });\n\n  // activate lasso tool\n  // L\n  addListener('lassoTool', function (context) {\n    var event = context.keyEvent;\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n    if (keyboard.isKey(['l', 'L'], event)) {\n      editorActions.trigger('lassoTool');\n      return true;\n    }\n  });\n\n  // activate hand tool\n  // H\n  addListener('handTool', function (context) {\n    var event = context.keyEvent;\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n    if (keyboard.isKey(['h', 'H'], event)) {\n      editorActions.trigger('handTool');\n      return true;\n    }\n  });\n\n  // activate direct editing\n  // E\n  addListener('directEditing', function (context) {\n    var event = context.keyEvent;\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n    if (keyboard.isKey(['e', 'E'], event)) {\n      editorActions.trigger('directEditing');\n      return true;\n    }\n  });\n};\n//# sourceMappingURL=DrdKeyboardBindings.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/keyboard/index.js\n\n\n/* harmony default export */ const features_keyboard = ({\n  __depends__: [keyboard/* default */.Z],\n  __init__: ['keyboardBindings'],\n  keyboardBindings: ['type', DrdKeyboardBindings]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/navigation/keyboard-move/index.js + 1 modules\nvar keyboard_move = __webpack_require__(\"./node_modules/diagram-js/lib/navigation/keyboard-move/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard-move-selection/index.js + 1 modules\nvar keyboard_move_selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard-move-selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/index.js\nvar command = __webpack_require__(\"./node_modules/diagram-js/lib/command/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/change-support/index.js + 1 modules\nvar change_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/change-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js-direct-editing/index.js + 2 modules\nvar diagram_js_direct_editing = __webpack_require__(\"./node_modules/diagram-js-direct-editing/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/label-editing/LabelUtil.js\n\nfunction getLabelAttr(semantic) {\n  if ((0,ModelUtil.is)(semantic, 'dmn:Decision') || (0,ModelUtil.is)(semantic, 'dmn:BusinessKnowledgeModel') || (0,ModelUtil.is)(semantic, 'dmn:InputData') || (0,ModelUtil.is)(semantic, 'dmn:KnowledgeSource')) {\n    return 'name';\n  }\n  if ((0,ModelUtil.is)(semantic, 'dmn:TextAnnotation')) {\n    return 'text';\n  }\n}\nfunction getLabel(element) {\n  var semantic = element.businessObject,\n    attr = getLabelAttr(semantic);\n  if (attr) {\n    return semantic[attr] || '';\n  }\n}\nfunction setLabel(element, text, isExternal) {\n  var semantic = element.businessObject,\n    attr = getLabelAttr(semantic);\n  if (attr) {\n    semantic[attr] = text;\n  }\n\n  // show external label if not empty\n  if (isExternal) {\n    element.hidden = !text;\n  }\n  return element;\n}\n//# sourceMappingURL=LabelUtil.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/label-editing/LabelEditingProvider.js\n\n\n\nfunction LabelEditingProvider(canvas, directEditing, eventBus, modeling, textRenderer) {\n  this._canvas = canvas;\n  this._modeling = modeling;\n  this._textRenderer = textRenderer;\n  directEditing.registerProvider(this);\n\n  // listen to dblclick on non-root elements\n  eventBus.on('element.dblclick', function (event) {\n    directEditing.activate(event.element);\n  });\n\n  // complete on followup canvas operation\n  eventBus.on(['autoPlace.start', 'canvas.viewbox.changing', 'drag.init', 'drillDown.click', 'element.mousedown', 'popupMenu.open', 'selection.changed'], function () {\n    directEditing.complete();\n  });\n\n  // cancel on command stack changes\n  eventBus.on(['commandStack.changed'], function () {\n    directEditing.cancel();\n  });\n  eventBus.on('create.end', 500, function (e) {\n    var element = e.shape;\n    if ((0,ModelUtil.is)(element, 'dmn:Decision') || (0,ModelUtil.is)(element, 'dmn:InputData') || (0,ModelUtil.is)(element, 'dmn:BusinessKnowledgeModel') || (0,ModelUtil.is)(element, 'dmn:KnowledgeSource') || (0,ModelUtil.is)(element, 'dmn:TextAnnotation')) {\n      directEditing.activate(element);\n    }\n  });\n  eventBus.on('autoPlace.end', 500, function (event) {\n    directEditing.activate(event.shape);\n  });\n}\nLabelEditingProvider.$inject = ['canvas', 'directEditing', 'eventBus', 'modeling', 'textRenderer'];\n\n/**\n * Activate direct editing for drgs and text annotations.\n *\n * @param  {djs.model.Base} element\n *\n * @return {Object} an object with properties bounds (position and size) and text\n */\nLabelEditingProvider.prototype.activate = function (element) {\n  var text = getLabel(element);\n  if (!(0,dist_index_esm/* isDefined */.$K)(text)) {\n    return;\n  }\n  var context = {\n    text: text\n  };\n  var editingBBox = this.getEditingBBox(element);\n  (0,dist_index_esm/* assign */.f0)(context, editingBBox);\n  var options = {};\n\n  // DRG elements\n  if ((0,ModelUtil.is)(element, 'dmn:DRGElement')) {\n    (0,dist_index_esm/* assign */.f0)(options, {\n      centerVertically: true\n    });\n  }\n\n  // text annotations\n  if ((0,ModelUtil.is)(element, 'dmn:TextAnnotation')) {\n    (0,dist_index_esm/* assign */.f0)(options, {\n      resizable: true\n    });\n  }\n  (0,dist_index_esm/* assign */.f0)(context, {\n    options: options\n  });\n  return context;\n};\n\n/**\n * Get the editing bounding box based on the element's size and position\n *\n * @param  {djs.model.Base} element\n *\n * @return {Object}\n *         an object containing information about position and\n *         size (fixed or minimum and/or maximum)\n */\nLabelEditingProvider.prototype.getEditingBBox = function (element) {\n  var canvas = this._canvas;\n  var target = element.label || element;\n  var bbox = canvas.getAbsoluteBBox(target);\n\n  // default position\n  var bounds = {\n    x: bbox.x,\n    y: bbox.y\n  };\n  var zoom = canvas.zoom();\n  var defaultStyle = this._textRenderer.getDefaultStyle();\n\n  // take zoom into account\n  var defaultFontSize = defaultStyle.fontSize * zoom,\n    defaultLineHeight = defaultStyle.lineHeight;\n  var style = {\n    fontFamily: this._textRenderer.getDefaultStyle().fontFamily,\n    fontWeight: this._textRenderer.getDefaultStyle().fontWeight\n  };\n\n  // DRG elements\n  if ((0,ModelUtil.is)(element, 'dmn:DRGElement')) {\n    (0,dist_index_esm/* assign */.f0)(bounds, {\n      width: bbox.width,\n      height: bbox.height\n    });\n    (0,dist_index_esm/* assign */.f0)(style, {\n      fontSize: defaultFontSize + 'px',\n      lineHeight: defaultLineHeight,\n      paddingTop: 7 * zoom + 'px',\n      paddingBottom: 7 * zoom + 'px',\n      paddingLeft: 5 * zoom + 'px',\n      paddingRight: 5 * zoom + 'px'\n    });\n  }\n\n  // text annotations\n  if ((0,ModelUtil.is)(element, 'dmn:TextAnnotation')) {\n    (0,dist_index_esm/* assign */.f0)(bounds, {\n      width: bbox.width,\n      height: bbox.height,\n      minWidth: 30 * zoom,\n      minHeight: 10 * zoom\n    });\n    (0,dist_index_esm/* assign */.f0)(style, {\n      textAlign: 'left',\n      paddingTop: 5 * zoom + 'px',\n      paddingBottom: 7 * zoom + 'px',\n      paddingLeft: 7 * zoom + 'px',\n      paddingRight: 5 * zoom + 'px',\n      fontSize: defaultFontSize + 'px',\n      lineHeight: defaultLineHeight\n    });\n  }\n  return {\n    bounds: bounds,\n    style: style\n  };\n};\nLabelEditingProvider.prototype.update = function (element, newLabel, activeContextText, bounds) {\n  var newBounds, bbox;\n  if ((0,ModelUtil.is)(element, 'dmn:TextAnnotation')) {\n    bbox = this._canvas.getAbsoluteBBox(element);\n    newBounds = {\n      x: element.x,\n      y: element.y,\n      width: element.width / bbox.width * bounds.width,\n      height: element.height / bbox.height * bounds.height\n    };\n  }\n  if (isEmptyText(newLabel)) {\n    newLabel = null;\n  }\n  this._modeling.updateLabel(element, newLabel, newBounds);\n};\n\n// helpers //////////\n\nfunction isEmptyText(label) {\n  return !label || !label.trim();\n}\n//# sourceMappingURL=LabelEditingProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/label-editing/index.js\n\n\n\n\n/* harmony default export */ const label_editing = ({\n  __depends__: [command/* default */.Z, change_support/* default */.Z, diagram_js_direct_editing/* default */.Z],\n  __init__: ['labelEditingProvider'],\n  labelEditingProvider: ['type', LabelEditingProvider]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/behavior/CreateConnectionBehavior.js\n\n\n\n\n/**\n * Creates DMN-specific refs for new connection.\n *\n * @param {DrdFactory} drdFactory\n * @param {Injector} injector\n */\nfunction CreateConnectionBehavior(drdFactory, injector) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n  this.preExecute('connection.create', function (context) {\n    var connection = context.connection,\n      connectionBo = connection.businessObject,\n      source = context.source,\n      target = context.target,\n      elementRef,\n      sourceRef,\n      targetRef;\n    if ((0,ModelUtil.is)(connection, 'dmn:Association')) {\n      sourceRef = connectionBo.sourceRef = drdFactory.create('dmn:DMNElementReference', {\n        href: '#' + source.id\n      });\n      sourceRef.$parent = connectionBo;\n      targetRef = connectionBo.targetRef = drdFactory.create('dmn:DMNElementReference', {\n        href: '#' + target.id\n      });\n      targetRef.$parent = connectionBo;\n    } else {\n      elementRef = connectionBo['required' + getRequirementType(source)] = drdFactory.create('dmn:DMNElementReference', {\n        href: '#' + source.id\n      });\n      elementRef.$parent = connectionBo;\n    }\n  }, true);\n}\nCreateConnectionBehavior.$inject = ['drdFactory', 'injector'];\n(0,index_es/* default */.Z)(CreateConnectionBehavior, CommandInterceptor/* default */.Z);\n\n// helpers //////////\n\nfunction getRequirementType(source) {\n  if ((0,ModelUtil.is)(source, 'dmn:BusinessKnowledgeModel')) {\n    return 'Knowledge';\n  } else if ((0,ModelUtil.is)(source, 'dmn:Decision')) {\n    return 'Decision';\n  } else if ((0,ModelUtil.is)(source, 'dmn:InputData')) {\n    return 'Input';\n  } else if ((0,ModelUtil.is)(source, 'dmn:KnowledgeSource')) {\n    return 'Authority';\n  }\n}\n//# sourceMappingURL=CreateConnectionBehavior.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/behavior/LayoutConnectionBehavior.js\n\n\n\n\n\nvar LOW_PRIORITY = 500;\nfunction LayoutConnectionBehavior(injector, layouter, modeling, rules) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n\n  // specify connection start and end on connection create\n  this.preExecute(['connection.create', 'connection.reconnect'], function (context) {\n    var connection = context.connection,\n      source = context.newSource || context.source,\n      target = context.newTarget || context.target;\n    if ((0,ModelUtil.is)(connection, 'dmn:InformationRequirement') && !rules.allowed('connection.connect', {\n      connection: connection,\n      source: source,\n      target: target\n    })) {\n      return;\n    }\n    if (!(0,ModelUtil.is)(connection, 'dmn:InformationRequirement')) {\n      return;\n    }\n    var orientation = (0,LayoutUtil/* getOrientation */.T8)(source, target);\n    if (!context.hints) {\n      context.hints = {};\n    }\n    (0,dist_index_esm/* assign */.f0)(context.hints, getConnectionHints(source, target, orientation));\n  }, true);\n\n  /**\r\n   * Update incoming information requirements.\r\n   *\r\n   * @param {djs.model.Shape} target\r\n   * @param {Array<djs.model.Connection>} [informationRequirements]\r\n   * @param {string} [orientation]\r\n   */\n  function updateInformationRequirements(target, informationRequirements, orientation) {\n    // (1) get information requirements\n    if (!informationRequirements) {\n      informationRequirements = target.incoming.filter(function (incoming) {\n        return (0,ModelUtil.is)(incoming, 'dmn:InformationRequirement');\n      });\n    }\n    var incomingInformationRequirementsByOrientation = {};\n\n    // (2) get information requirements per orientation\n    if (orientation) {\n      incomingInformationRequirementsByOrientation[orientation] = informationRequirements;\n    } else {\n      incomingInformationRequirementsByOrientation = getInformationRequirementsByOrientation(target, informationRequirements);\n    }\n\n    // (3) update information requirements per orientation\n    (0,dist_index_esm/* forEach */.Ed)(incomingInformationRequirementsByOrientation, function (informationRequirements, orientation) {\n      // (3.1) sort information requirements\n      informationRequirements = sortInformationRequirements(informationRequirements, orientation);\n\n      // (3.2) get new connection start and end\n      var connectionStartEnd = getConnectionsStartEnd(informationRequirements, target, orientation);\n\n      // (3.3) update information requirements\n      informationRequirements.forEach((informationRequirement, index) => {\n        var connectionStart = connectionStartEnd[index].start,\n          connectionEnd = connectionStartEnd[index].end;\n        var waypoints = layouter.layoutConnection(informationRequirement, {\n          connectionStart: connectionStart,\n          connectionEnd: connectionEnd\n        });\n        modeling.updateWaypoints(informationRequirement, waypoints);\n      });\n    });\n  }\n\n  // update information requirements on connection create and delete\n  // update information requirements of new target on connection reconnect\n  this.postExecuted(['connection.create', 'connection.delete', 'connection.reconnect'], function (context) {\n    var connection = context.connection,\n      source = connection.source || context.source,\n      target = connection.target || context.target;\n    if (!(0,ModelUtil.is)(connection, 'dmn:InformationRequirement')) {\n      return;\n    }\n    var orientation = (0,LayoutUtil/* getOrientation */.T8)(source, target);\n\n    // update all information requirements with same orientation\n    var informationRequirements = target.incoming.filter(incoming => {\n      var incomingOrientation = (0,LayoutUtil/* getOrientation */.T8)(incoming.source, incoming.target);\n      return (0,ModelUtil.is)(incoming, 'dmn:InformationRequirement') && isSameOrientation(incomingOrientation, orientation);\n    });\n    if (!informationRequirements.length) {\n      return;\n    }\n    updateInformationRequirements(target, informationRequirements, orientation);\n  }, true);\n\n  // update information requirements of old target on connection reconnect\n  this.preExecute('connection.reconnect', function (context) {\n    var connection = context.connection,\n      source = connection.source,\n      target = connection.target;\n    if (!(0,ModelUtil.is)(connection, 'dmn:InformationRequirement')) {\n      return;\n    }\n    var orientation = (0,LayoutUtil/* getOrientation */.T8)(source, target);\n\n    // update all information requirements with same orientation except reconnected\n    var informationRequirements = target.incoming.filter(incoming => {\n      var incomingOrientation = (0,LayoutUtil/* getOrientation */.T8)(incoming.source, incoming.target);\n      return incoming !== connection && (0,ModelUtil.is)(incoming, 'dmn:InformationRequirement') && isSameOrientation(incomingOrientation, orientation);\n    });\n    if (!informationRequirements.length) {\n      return;\n    }\n    updateInformationRequirements(target, informationRequirements, orientation);\n  }, true);\n\n  // update information requirements on elements move\n  this.postExecuted('elements.move', LOW_PRIORITY, function (context) {\n    var shapes = context.shapes,\n      closure = context.closure,\n      enclosedConnections = closure.enclosedConnections;\n    shapes.forEach(function (shape) {\n      if (!(0,ModelUtil/* isAny */.JZ)(shape, ['dmn:Decision', 'dmn:InputData'])) {\n        return;\n      }\n\n      // (1) update incoming information requirements\n      var incomingInformationRequirements = shape.incoming.filter(function (incoming) {\n        return (0,ModelUtil.is)(incoming, 'dmn:InformationRequirement') && !enclosedConnections[incoming.id];\n      });\n      if (incomingInformationRequirements.length) {\n        updateInformationRequirements(shape, incomingInformationRequirements);\n      }\n\n      // (2) update outgoing information requirements\n      shape.outgoing.forEach(function (outgoing) {\n        if (!(0,ModelUtil.is)(outgoing, 'dmn:InformationRequirement') || enclosedConnections[outgoing.id]) {\n          return;\n        }\n        updateInformationRequirements(outgoing.target);\n      });\n    });\n  }, true);\n}\nLayoutConnectionBehavior.$inject = ['injector', 'layouter', 'modeling', 'rules'];\n(0,index_es/* default */.Z)(LayoutConnectionBehavior, CommandInterceptor/* default */.Z);\n\n// helpers //////////\n\nfunction getConnectionHints(source, target, orientation) {\n  var connectionStart = (0,LayoutUtil/* getMid */.wS)(source),\n    connectionEnd = (0,LayoutUtil/* getMid */.wS)(target);\n  if (orientation.includes('bottom')) {\n    connectionStart.y = source.y;\n    connectionEnd.y = target.y + target.height;\n  } else if (orientation.includes('top')) {\n    connectionStart.y = source.y + source.height;\n    connectionEnd.y = target.y;\n  } else if (orientation.includes('right')) {\n    connectionStart.x = source.x;\n    connectionEnd.x = target.x + target.width;\n  } else {\n    connectionStart.x = source.x + source.width;\n    connectionEnd.x = target.x;\n  }\n  return {\n    connectionStart: connectionStart,\n    connectionEnd: connectionEnd\n  };\n}\n\n/**\r\n * Get connections start and end based on number of information requirements and\r\n * orientation.\r\n *\r\n * @param {Array<djs.model.Connection>} informationRequirements\r\n * @param {djs.model.Shape} target\r\n * @param {string} orientation\r\n *\r\n * @returns {Array<Object>}\r\n */\nfunction getConnectionsStartEnd(informationRequirements, target, orientation) {\n  return informationRequirements.map(function (informationRequirement, index) {\n    var source = informationRequirement.source,\n      sourceMid = (0,LayoutUtil/* getMid */.wS)(source),\n      sourceTrbl = (0,LayoutUtil/* asTRBL */.JA)(source),\n      targetTrbl = (0,LayoutUtil/* asTRBL */.JA)(target);\n    var length = informationRequirements.length;\n    if (orientation.includes('bottom')) {\n      return {\n        start: {\n          x: sourceMid.x,\n          y: sourceTrbl.top\n        },\n        end: {\n          x: targetTrbl.left + target.width / (length + 1) * (index + 1),\n          y: targetTrbl.bottom\n        }\n      };\n    } else if (orientation.includes('top')) {\n      return {\n        start: {\n          x: sourceMid.x,\n          y: sourceTrbl.bottom\n        },\n        end: {\n          x: targetTrbl.left + target.width / (length + 1) * (index + 1),\n          y: targetTrbl.top\n        }\n      };\n    } else if (orientation.includes('right')) {\n      return {\n        start: {\n          x: sourceTrbl.left,\n          y: sourceMid.y\n        },\n        end: {\n          x: targetTrbl.right,\n          y: targetTrbl.top + target.height / (length + 1) * (index + 1)\n        }\n      };\n    } else {\n      return {\n        start: {\n          x: sourceTrbl.right,\n          y: sourceMid.y\n        },\n        end: {\n          x: targetTrbl.left,\n          y: targetTrbl.top + target.height / (length + 1) * (index + 1)\n        }\n      };\n    }\n  });\n}\n\n/**\r\n * Get information requirements by orientation.\r\n *\r\n * @param {djs.model.shape} target\r\n * @param {Array<djs.model.Connection>} informationRequirements\r\n *\r\n * @returns {Object}\r\n */\nfunction getInformationRequirementsByOrientation(target, informationRequirements) {\n  var incomingInformationRequirementsByOrientation = {};\n  informationRequirements.forEach(function (incoming) {\n    var orientation = (0,LayoutUtil/* getOrientation */.T8)(incoming.source, target).split('-').shift();\n    if (!incomingInformationRequirementsByOrientation[orientation]) {\n      incomingInformationRequirementsByOrientation[orientation] = [];\n    }\n    incomingInformationRequirementsByOrientation[orientation].push(incoming);\n  });\n  return incomingInformationRequirementsByOrientation;\n}\nfunction isSameOrientation(orientationA, orientationB) {\n  return orientationA && orientationB && orientationA.split('-').shift() === orientationB.split('-').shift();\n}\nfunction sortInformationRequirements(informationRequirements, orientation) {\n  var axis;\n  if (orientation.includes('top') || orientation.includes('bottom')) {\n    axis = 'x';\n  } else {\n    axis = 'y';\n  }\n  return informationRequirements.sort(function (a, b) {\n    return (0,LayoutUtil/* getMid */.wS)(a.source)[axis] - (0,LayoutUtil/* getMid */.wS)(b.source)[axis];\n  });\n}\n//# sourceMappingURL=LayoutConnectionBehavior.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/behavior/ReplaceConnectionBehavior.js\n\n\nfunction ReplaceConnectionBehavior(injector, modeling, rules) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n  this.preExecute('connection.reconnect', function (context) {\n    var connection = context.connection,\n      source = context.newSource || connection.source,\n      target = context.newTarget || connection.target,\n      waypoints = connection.waypoints.slice();\n    var allowed = rules.allowed('connection.reconnect', {\n      connection: connection,\n      source: source,\n      target: target\n    });\n    if (!allowed || allowed.type === connection.type) {\n      return;\n    }\n    context.connection = modeling.connect(source, target, {\n      type: allowed.type,\n      waypoints: waypoints\n    });\n    modeling.removeConnection(connection);\n  }, true);\n}\n(0,index_es/* default */.Z)(ReplaceConnectionBehavior, CommandInterceptor/* default */.Z);\nReplaceConnectionBehavior.$inject = ['injector', 'modeling', 'rules'];\n//# sourceMappingURL=ReplaceConnectionBehavior.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/behavior/ReplaceElementBehavior.js\n\n\n\n/**\n * Defines the behaviour of what happens to the elements inside a container\n * that morphs into another DRD element\n */\nfunction ReplaceElementBehaviour(eventBus, modeling, selection) {\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n  this._modeling = modeling;\n  this.postExecuted(['shape.replace'], 1500, function (e) {\n    var context = e.context,\n      oldShape = context.oldShape,\n      newShape = context.newShape;\n    modeling.unclaimId(oldShape.businessObject.id, oldShape.businessObject);\n    modeling.updateProperties(newShape, {\n      id: oldShape.id\n    });\n    selection.select(newShape);\n  });\n}\n(0,index_es/* default */.Z)(ReplaceElementBehaviour, CommandInterceptor/* default */.Z);\nReplaceElementBehaviour.$inject = ['eventBus', 'modeling', 'selection'];\n//# sourceMappingURL=ReplaceElementBehavior.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/node_modules/min-dash/dist/index.esm.js\nvar min_dash_dist_index_esm = __webpack_require__(\"./node_modules/dmn-js-shared/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/features/modeling/behavior/IdChangeBehavior.js\n\n\n\nconst ID = 'id';\nclass IdChangeBehavior extends CommandInterceptor/* default */.Z {\n  constructor(eventBus) {\n    super(eventBus);\n    this.executed('element.updateProperties', this.updateIds.bind(this));\n  }\n  updateIds(_ref) {\n    let context = _ref.context;\n    const element = context.element,\n      oldProperties = context.oldProperties,\n      properties = context.properties;\n    const bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    if (this.shouldSkipUpdate(bo, oldProperties, properties)) {\n      return;\n    }\n    const definitions = getDefinitions(bo);\n    const drgElements = definitions.get('drgElement');\n    drgElements.forEach(drgElement => {\n      updateElementReferences(drgElement, oldProperties.id, properties.id);\n    });\n    const artifacts = definitions.get('artifact');\n    artifacts.forEach(artifact => {\n      updateAssociationReferences(artifact, oldProperties.id, properties.id);\n    });\n  }\n  shouldSkipUpdate(bo, oldProperties, newProperties) {\n    return !isIdChange(oldProperties, newProperties) || !(0,ModelUtil.is)(bo, 'dmn:DRGElement') && !(0,ModelUtil.is)(bo, 'dmn:TextAnnotation');\n  }\n}\nIdChangeBehavior.$inject = ['eventBus'];\n\n// helpers //////////////////////\n\nfunction isIdChange(oldProperties, properties) {\n  return ID in oldProperties && ID in properties;\n}\n\n/**\r\n * Walk up the tree until at the root to get to dmn:Definitions.\r\n *\r\n * @param {ModdleElement} element\r\n */\nfunction getDefinitions(element) {\n  let definitions = element;\n  while (!(0,ModelUtil.is)(definitions, 'dmn:Definitions')) {\n    definitions = definitions.$parent;\n  }\n  return definitions;\n}\nfunction updateElementReferences(element, oldId, id) {\n  const handlers = {\n    authorityRequirement: () => {\n      element.authorityRequirement.forEach(authorityRequirement => {\n        const requiredAuthority = authorityRequirement.requiredAuthority,\n          requiredDecision = authorityRequirement.requiredDecision,\n          requiredInput = authorityRequirement.requiredInput;\n        if (requiredAuthority && requiredAuthority.href === \"#\".concat(oldId)) {\n          requiredAuthority.href = \"#\".concat(id);\n        }\n        if (requiredDecision && requiredDecision.href === \"#\".concat(oldId)) {\n          requiredDecision.href = \"#\".concat(id);\n        }\n        if (requiredInput && requiredInput.href === \"#\".concat(oldId)) {\n          requiredInput.href = \"#\".concat(id);\n        }\n      });\n    },\n    informationRequirement: () => {\n      element.informationRequirement.forEach(informationRequirement => {\n        const requiredDecision = informationRequirement.requiredDecision,\n          requiredInput = informationRequirement.requiredInput;\n        if (requiredDecision && requiredDecision.href === \"#\".concat(oldId)) {\n          requiredDecision.href = \"#\".concat(id);\n        }\n        if (requiredInput && requiredInput.href === \"#\".concat(oldId)) {\n          requiredInput.href = \"#\".concat(id);\n        }\n      });\n    },\n    knowledgeRequirement: () => {\n      element.knowledgeRequirement.forEach(knowledgeRequirement => {\n        const requiredKnowledge = knowledgeRequirement.requiredKnowledge;\n        if (requiredKnowledge && requiredKnowledge.href === \"#\".concat(oldId)) {\n          requiredKnowledge.href = \"#\".concat(id);\n        }\n      });\n    }\n  };\n  (0,min_dash_dist_index_esm/* forEach */.Ed)(handlers, (handler, key) => {\n    if (element[key]) {\n      handler();\n    }\n  });\n}\nfunction updateAssociationReferences(element, oldId, id) {\n  const handlers = {\n    sourceRef: () => {\n      const sourceRef = element.sourceRef;\n      if (sourceRef.href === \"#\".concat(oldId)) {\n        sourceRef.href = \"#\".concat(id);\n      }\n    },\n    targetRef: () => {\n      const targetRef = element.targetRef;\n      if (targetRef.href === \"#\".concat(oldId)) {\n        targetRef.href = \"#\".concat(id);\n      }\n    }\n  };\n  (0,min_dash_dist_index_esm/* forEach */.Ed)(handlers, (handler, key) => {\n    if (element[key]) {\n      handler();\n    }\n  });\n}\n//# sourceMappingURL=IdChangeBehavior.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/behavior/index.js\n\n\n\n\n\n/* harmony default export */ const behavior = ({\n  __init__: ['createConnectionBehavior', 'idChangeBehavior', 'layoutConnectionBehavior', 'replaceConnectionBehavior', 'replaceElementBehavior'],\n  createConnectionBehavior: ['type', CreateConnectionBehavior],\n  idChangeBehavior: ['type', IdChangeBehavior],\n  layoutConnectionBehavior: ['type', LayoutConnectionBehavior],\n  replaceConnectionBehavior: ['type', ReplaceConnectionBehavior],\n  replaceElementBehavior: ['type', ReplaceElementBehaviour]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/RuleProvider.js\nvar RuleProvider = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/RuleProvider.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/rules/DrdRules.js\n\n\n\n\n\n/**\n * DRD modeling rules.\n */\nfunction DrdRules(injector) {\n  injector.invoke(RuleProvider/* default */.Z, this);\n}\n(0,index_es/* default */.Z)(DrdRules, RuleProvider/* default */.Z);\nDrdRules.$inject = ['injector'];\nDrdRules.prototype.init = function () {\n  this.addRule('connection.create', function (context) {\n    var source = context.source,\n      target = context.target;\n    return canConnect(source, target);\n  });\n  this.addRule('connection.reconnect', function (context) {\n    var connection = context.connection,\n      source = context.source,\n      target = context.target;\n    return canConnect(source, target, connection);\n  });\n  this.addRule('connection.updateWaypoints', function (context) {\n    const connection = context.connection;\n    return {\n      type: connection.type,\n      businessObject: connection.businessObject\n    };\n  });\n  this.addRule('elements.move', function (context) {\n    var target = context.target,\n      shapes = context.shapes,\n      position = context.position;\n    return canMove(shapes, target, position);\n  });\n  this.addRule('shape.create', function (context) {\n    var shape = context.shape,\n      target = context.target;\n    return canCreate(shape, target);\n  });\n  this.addRule('shape.resize', function (context) {\n    var shape = context.shape;\n    return (0,ModelUtil.is)(shape, 'dmn:TextAnnotation');\n  });\n};\nDrdRules.prototype.canConnect = canConnect;\nDrdRules.prototype.canCreate = canCreate;\nDrdRules.prototype.canMove = canMove;\nfunction canConnect(source, target) {\n  if (!source || isLabel(source) || !target || isLabel(target)) {\n    return null;\n  }\n  if (source === target) {\n    return false;\n  }\n  if ((0,ModelUtil.is)(source, 'dmn:BusinessKnowledgeModel') && (0,ModelUtil/* isAny */.JZ)(target, ['dmn:BusinessKnowledgeModel', 'dmn:Decision'])) {\n    return {\n      type: 'dmn:KnowledgeRequirement'\n    };\n  }\n  if ((0,ModelUtil.is)(source, 'dmn:Decision')) {\n    if ((0,ModelUtil.is)(target, 'dmn:Decision')) {\n      return {\n        type: 'dmn:InformationRequirement'\n      };\n    }\n    if ((0,ModelUtil.is)(target, 'dmn:KnowledgeSource')) {\n      return {\n        type: 'dmn:AuthorityRequirement'\n      };\n    }\n  }\n  if ((0,ModelUtil.is)(source, 'dmn:Definitions') || (0,ModelUtil.is)(target, 'dmn:Definitions')) {\n    return false;\n  }\n  if ((0,ModelUtil.is)(source, 'dmn:InputData')) {\n    if ((0,ModelUtil.is)(target, 'dmn:Decision')) {\n      return {\n        type: 'dmn:InformationRequirement'\n      };\n    }\n    if ((0,ModelUtil.is)(target, 'dmn:KnowledgeSource')) {\n      return {\n        type: 'dmn:AuthorityRequirement'\n      };\n    }\n  }\n  if ((0,ModelUtil.is)(source, 'dmn:KnowledgeSource') && (0,ModelUtil/* isAny */.JZ)(target, ['dmn:BusinessKnowledgeModel', 'dmn:Decision', 'dmn:KnowledgeSource'])) {\n    return {\n      type: 'dmn:AuthorityRequirement'\n    };\n  }\n  if ((0,ModelUtil.is)(source, 'dmn:TextAnnotation') && !(0,ModelUtil.is)(target, 'dmn:TextAnnotation') || !(0,ModelUtil.is)(source, 'dmn:TextAnnotation') && (0,ModelUtil.is)(target, 'dmn:TextAnnotation')) {\n    return {\n      type: 'dmn:Association'\n    };\n  }\n  return false;\n}\nfunction canCreate(shape, target) {\n  return (0,ModelUtil/* isAny */.JZ)(shape, ['dmn:BusinessKnowledgeModel', 'dmn:Decision', 'dmn:InputData', 'dmn:KnowledgeSource', 'dmn:TextAnnotation']) && (0,ModelUtil.is)(target, 'dmn:Definitions');\n}\nfunction canMove(elements, target) {\n  if (!(0,dist_index_esm/* isArray */.kJ)(elements)) {\n    elements = [elements];\n  }\n\n  // allow default move check to start move operation\n  if (!target) {\n    return true;\n  }\n  if ((0,dist_index_esm/* every */.yW)(elements, function (element) {\n    return (0,ModelUtil/* isAny */.JZ)(element, ['dmn:BusinessKnowledgeModel', 'dmn:Decision', 'dmn:InputData', 'dmn:KnowledgeSource', 'dmn:TextAnnotation', 'dmn:InformationRequirement', 'dmn:AuthorityRequirement', 'dmn:KnowledgeRequirement', 'dmn:Association']);\n  }) && (0,ModelUtil.is)(target, 'dmn:Definitions')) {\n    return true;\n  }\n  return false;\n}\nfunction isLabel(element) {\n  return !!element.labelTarget;\n}\n//# sourceMappingURL=DrdRules.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/rules/index.js\n\n\n/* harmony default export */ const features_rules = ({\n  __depends__: [rules/* default */.Z],\n  __init__: ['drdRules'],\n  drdRules: ['type', DrdRules]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/DrdFactory.js\n\n\nfunction DrdFactory(moddle) {\n  this._model = moddle;\n}\nDrdFactory.$inject = ['moddle'];\nDrdFactory.prototype._needsId = function (element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, ['dmn:Artifact', 'dmn:DMNElement', 'dmn:DRGElement', 'dmndi:DMNDiagram', 'dmndi:DMNDiagramElement']);\n};\nDrdFactory.prototype._ensureId = function (element) {\n  var prefix = (element.$type || '').replace(/^[^:]*:/g, '') + '_';\n  if (!element.id && this._needsId(element)) {\n    element.id = this._model.ids.nextPrefixed(prefix, element);\n  }\n};\nDrdFactory.prototype.create = function (type, attrs) {\n  var element = this._model.create(type, attrs || {});\n  this._ensureId(element);\n  return element;\n};\nDrdFactory.prototype.createDiShape = function (semantic, bounds, attrs) {\n  return this.create('dmndi:DMNShape', (0,dist_index_esm/* assign */.f0)({\n    dmnElementRef: semantic,\n    bounds: this.createDiBounds(bounds)\n  }, attrs));\n};\nDrdFactory.prototype.createDiBounds = function (bounds) {\n  return this.create('dc:Bounds', bounds);\n};\nDrdFactory.prototype.createDiEdge = function (semantic, waypoints, attrs) {\n  return this.create('dmndi:DMNEdge', {\n    dmnElementRef: semantic,\n    waypoint: this.createDiWaypoints(waypoints)\n  }, attrs);\n};\nDrdFactory.prototype.createDiWaypoints = function (waypoints) {\n  var self = this;\n  return waypoints.map(function (waypoint) {\n    return self.createDiWaypoint(waypoint);\n  });\n};\nDrdFactory.prototype.createDiWaypoint = function (waypoint) {\n  return this.create('dc:Point', (0,dist_index_esm/* pick */.ei)(waypoint, ['x', 'y']));\n};\nDrdFactory.prototype.createExtensionElements = function () {\n  return this.create('dmn:ExtensionElements', {\n    values: []\n  });\n};\n//# sourceMappingURL=DrdFactory.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/diagram-js/lib/util/Collections.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/DrdUpdater.js\n\n\n\n\n\n\n/**\n * Update DMN 1.3 information.\n */\nfunction DrdUpdater(connectionDocking, definitionPropertiesView, drdFactory, drdRules, injector) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n  this._definitionPropertiesView = definitionPropertiesView;\n  this._drdFactory = drdFactory;\n  this._drdRules = drdRules;\n  var self = this;\n  function cropConnection(context) {\n    var connection = context.connection,\n      cropped = context.cropped;\n    if (!cropped) {\n      connection.waypoints = connectionDocking.getCroppedWaypoints(connection);\n      context.cropped = true;\n    }\n  }\n  this.executed(['connection.create', 'connection.layout'], cropConnection, true);\n  this.reverted(['connection.layout'], function (context) {\n    delete context.cropped;\n  }, true);\n  function updateParent(context) {\n    var connection = context.connection,\n      parent = context.parent,\n      shape = context.shape;\n    if (connection && !(0,ModelUtil.is)(connection, 'dmn:Association')) {\n      parent = connection.target;\n    }\n    self.updateParent(shape || connection, parent);\n  }\n  function reverseUpdateParent(context) {\n    var connection = context.connection,\n      shape = context.shape;\n    var oldParent = context.parent || context.newParent;\n    if (connection && !(0,ModelUtil.is)(connection, 'dmn:Association')) {\n      oldParent = connection.target;\n    }\n    self.updateParent(shape || connection, oldParent);\n  }\n  this.executed(['connection.create', 'connection.delete', 'connection.move', 'shape.create', 'shape.delete'], updateParent, true);\n  this.reverted(['connection.create', 'connection.delete', 'connection.move', 'shape.create', 'shape.delete'], reverseUpdateParent, true);\n  function updateBounds(context) {\n    var shape = context.shape;\n    if (!((0,ModelUtil.is)(shape, 'dmn:DRGElement') || (0,ModelUtil.is)(shape, 'dmn:TextAnnotation'))) {\n      return;\n    }\n    self.updateBounds(shape);\n  }\n  this.executed(['shape.create', 'shape.move', 'shape.resize'], updateBounds, true);\n  this.reverted(['shape.create', 'shape.move', 'shape.resize'], updateBounds, true);\n  function updateConnectionWaypoints(context) {\n    self.updateConnectionWaypoints(context);\n  }\n  this.executed(['connection.create', 'connection.layout', 'connection.move', 'connection.updateWaypoints'], updateConnectionWaypoints, true);\n  this.reverted(['connection.create', 'connection.layout', 'connection.move', 'connection.updateWaypoints'], updateConnectionWaypoints, true);\n  this.executed('connection.create', function (context) {\n    var connection = context.connection,\n      connectionBo = connection.businessObject,\n      target = context.target,\n      targetBo = target.businessObject;\n    if ((0,ModelUtil.is)(connection, 'dmn:Association')) {\n      updateParent(context);\n    } else {\n      // parent is target\n      self.updateSemanticParent(connectionBo, targetBo);\n    }\n  }, true);\n  this.reverted('connection.create', function (context) {\n    reverseUpdateParent(context);\n  }, true);\n  this.executed('connection.reconnect', function (context) {\n    var connection = context.connection,\n      connectionBo = connection.businessObject,\n      newTarget = context.newTarget,\n      newTargetBo = newTarget.businessObject;\n    if ((0,ModelUtil.is)(connectionBo, 'dmn:Association')) {\n      return;\n    }\n    self.updateSemanticParent(connectionBo, newTargetBo);\n  }, true);\n  this.reverted('connection.reconnect', function (context) {\n    var connection = context.connection,\n      connectionBo = connection.businessObject,\n      oldTarget = context.oldTarget,\n      oldTargetBo = oldTarget.businessObject;\n    if ((0,ModelUtil.is)(connectionBo, 'dmn:Association')) {\n      return;\n    }\n    self.updateSemanticParent(connectionBo, oldTargetBo);\n  }, true);\n  this.executed('element.updateProperties', function (context) {\n    definitionPropertiesView.update();\n  }, true);\n  this.reverted('element.updateProperties', function (context) {\n    definitionPropertiesView.update();\n  }, true);\n}\n(0,index_es/* default */.Z)(DrdUpdater, CommandInterceptor/* default */.Z);\nDrdUpdater.$inject = ['connectionDocking', 'definitionPropertiesView', 'drdFactory', 'drdRules', 'injector'];\nDrdUpdater.prototype.updateBounds = function (shape) {\n  var businessObject = shape.businessObject,\n    bounds = businessObject.di.bounds;\n\n  // update bounds\n  (0,dist_index_esm/* assign */.f0)(bounds, {\n    x: shape.x,\n    y: shape.y,\n    width: shape.width,\n    height: shape.height\n  });\n};\nDrdUpdater.prototype.updateConnectionWaypoints = function (context) {\n  var drdFactory = this._drdFactory;\n  var connection = context.connection,\n    businessObject = connection.businessObject,\n    edge = businessObject.di;\n  edge.waypoint = drdFactory.createDiWaypoints(connection.waypoints).map(function (waypoint) {\n    waypoint.$parent = edge;\n    return waypoint;\n  });\n};\nDrdUpdater.prototype.updateParent = function (element, oldParent) {\n  var parent = element.parent;\n  if (!(0,ModelUtil.is)(element, 'dmn:DRGElement') && !(0,ModelUtil.is)(element, 'dmn:Artifact')) {\n    parent = oldParent;\n  }\n  var businessObject = element.businessObject,\n    parentBo = parent && parent.businessObject;\n  this.updateSemanticParent(businessObject, parentBo);\n  this.updateDiParent(businessObject.di, parentBo && parentBo.di);\n};\nDrdUpdater.prototype.updateSemanticParent = function (businessObject, parent) {\n  var children, containment;\n  if (businessObject.$parent === parent) {\n    return;\n  }\n  if ((0,ModelUtil.is)(businessObject, 'dmn:DRGElement')) {\n    containment = 'drgElement';\n  } else if ((0,ModelUtil.is)(businessObject, 'dmn:Artifact')) {\n    containment = 'artifact';\n  } else if ((0,ModelUtil.is)(businessObject, 'dmn:InformationRequirement')) {\n    containment = 'informationRequirement';\n  } else if ((0,ModelUtil.is)(businessObject, 'dmn:AuthorityRequirement')) {\n    containment = 'authorityRequirement';\n  } else if ((0,ModelUtil.is)(businessObject, 'dmn:KnowledgeRequirement')) {\n    containment = 'knowledgeRequirement';\n  }\n  if (businessObject.$parent) {\n    // remove from old parent\n    children = businessObject.$parent.get(containment);\n    (0,Collections/* remove */.Od)(children, businessObject);\n  }\n  if (parent) {\n    // add to new parent\n    children = parent.get(containment);\n    if (children) {\n      children.push(businessObject);\n      businessObject.$parent = parent;\n    }\n  } else {\n    businessObject.$parent = null;\n  }\n};\nDrdUpdater.prototype.updateDiParent = function (di, parentDi) {\n  if (di.$parent === parentDi) {\n    return;\n  }\n  if ((0,ModelUtil/* isAny */.JZ)(di, ['dmndi:DMNEdge', 'dmndi:DMNShape'])) {\n    var diagram = parentDi || di;\n    while (!(0,ModelUtil.is)(diagram, 'dmndi:DMNDiagram')) {\n      diagram = diagram.$parent;\n    }\n    var diagramElements = diagram.get('diagramElements');\n    if (parentDi) {\n      di.$parent = diagram;\n      (0,Collections/* add */.IH)(diagramElements, di);\n    } else {\n      di.$parent = null;\n      (0,Collections/* remove */.Od)(diagramElements, di);\n    }\n  } else {\n    throw new Error('unsupported');\n  }\n};\n//# sourceMappingURL=DrdUpdater.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/modeling/Modeling.js + 27 modules\nvar Modeling = __webpack_require__(\"./node_modules/diagram-js/lib/features/modeling/Modeling.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/cmd/IdClaimHandler.js\nfunction IdClaimHandler(moddle) {\n  this._moddle = moddle;\n}\nIdClaimHandler.$inject = ['moddle'];\nIdClaimHandler.prototype.execute = function (context) {\n  var ids = this._moddle.ids,\n    id = context.id,\n    element = context.element,\n    claiming = context.claiming;\n  if (claiming) {\n    ids.claim(id, element);\n  } else {\n    ids.unclaim(id);\n  }\n};\n\n/**\n * Command revert implementation.\n */\nIdClaimHandler.prototype.revert = function (context) {\n  var ids = this._moddle.ids,\n    id = context.id,\n    element = context.element,\n    claiming = context.claiming;\n  if (claiming) {\n    ids.unclaim(id);\n  } else {\n    ids.claim(id, element);\n  }\n};\n//# sourceMappingURL=IdClaimHandler.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/label-editing/cmd/UpdateLabelHandler.js\n\n\n/**\n * A handler that updates the name of a DMN element.\n */\nfunction UpdateLabelHandler() {\n  /**\n   * Set the label and return the changed elements.\n   *\n   * Element parameter can be label itself or connection (i.e. sequence flow).\n   *\n   * @param {djs.model.Base} element\n   * @param {string} text\n   */\n  function setText(element, text) {\n    // external label if present\n    var label = element.label || element;\n    var labelTarget = element.labelTarget || element;\n    setLabel(label, text, labelTarget !== label);\n    return [label, labelTarget];\n  }\n  function execute(ctx) {\n    ctx.oldLabel = getLabel(ctx.element);\n    return setText(ctx.element, ctx.newLabel);\n  }\n  function revert(ctx) {\n    return setText(ctx.element, ctx.oldLabel);\n  }\n\n  // API\n\n  this.execute = execute;\n  this.revert = revert;\n}\n//# sourceMappingURL=UpdateLabelHandler.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/cmd/UpdatePropertiesHandler.js\n\nvar NAME = 'name',\n  UpdatePropertiesHandler_ID = 'id';\n\n/**\n * A handler that implements a DMN property update.\n *\n * This should be used to set simple properties on elements with\n * an underlying DMN business object.\n *\n * Use respective diagram-js provided handlers if you would\n * like to perform automated modeling.\n */\nfunction UpdatePropertiesHandler(elementRegistry, moddle) {\n  this._elementRegistry = elementRegistry;\n  this._moddle = moddle;\n}\nUpdatePropertiesHandler.$inject = ['elementRegistry', 'moddle'];\n\n/**\n * Updates a DMN element with a list of new properties\n *\n * @param {Object} context\n * @param {djs.model.Base} context.element the element to update\n * @param {Object} context.properties a list of properties to set on the element's\n *                                    businessObject (the DMN model element)\n *\n * @return {Array<djs.model.Base>} the updated element\n */\nUpdatePropertiesHandler.prototype.execute = function (context) {\n  var element = context.element,\n    changed = [element];\n  if (!element) {\n    throw new Error('element required');\n  }\n  var elementRegistry = this._elementRegistry,\n    ids = this._moddle.ids;\n  var businessObject = element.businessObject,\n    properties = context.properties,\n    oldProperties = context.oldProperties || getProperties(businessObject, (0,dist_index_esm/* keys */.XP)(properties));\n  if (UpdatePropertiesHandler_isIdChange(properties, businessObject)) {\n    ids.unclaim(businessObject[UpdatePropertiesHandler_ID]);\n    elementRegistry.updateId(element, properties[UpdatePropertiesHandler_ID]);\n    ids.claim(properties[UpdatePropertiesHandler_ID], businessObject);\n  }\n  if (NAME in properties && element.label) {\n    changed.push(element.label);\n  }\n\n  // update properties\n  setProperties(businessObject, properties);\n\n  // store old values\n  context.oldProperties = oldProperties;\n  context.changed = changed;\n\n  // indicate changed on objects affected by the update\n  return changed;\n};\n\n/**\n * Reverts the update on a DMN elements properties.\n *\n * @param  {Object} context\n *\n * @return {djs.model.Base} the updated element\n */\nUpdatePropertiesHandler.prototype.revert = function (context) {\n  var element = context.element,\n    properties = context.properties,\n    oldProperties = context.oldProperties,\n    businessObject = element.businessObject,\n    elementRegistry = this._elementRegistry,\n    ids = this._moddle.ids;\n\n  // update properties\n  setProperties(businessObject, oldProperties);\n  if (UpdatePropertiesHandler_isIdChange(properties, businessObject)) {\n    ids.unclaim(properties[UpdatePropertiesHandler_ID]);\n    elementRegistry.updateId(element, oldProperties[UpdatePropertiesHandler_ID]);\n    ids.claim(oldProperties[UpdatePropertiesHandler_ID], businessObject);\n  }\n  return context.changed;\n};\nfunction UpdatePropertiesHandler_isIdChange(properties, businessObject) {\n  return UpdatePropertiesHandler_ID in properties && properties[UpdatePropertiesHandler_ID] !== businessObject[UpdatePropertiesHandler_ID];\n}\nfunction getProperties(businessObject, propertyNames) {\n  return (0,dist_index_esm/* reduce */.u4)(propertyNames, function (result, key) {\n    result[key] = businessObject.get(key);\n    return result;\n  }, {});\n}\nfunction setProperties(businessObject, properties) {\n  (0,dist_index_esm/* forEach */.Ed)(properties, function (value, key) {\n    businessObject.set(key, value);\n  });\n}\n//# sourceMappingURL=UpdatePropertiesHandler.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/Modeling.js\n\n\n\n\n\n\n/**\n * DMN modeling.\n *\n * @param {Canvas} canvas\n * @param {CommandStack} commandStack\n * @param {DrdRules} drdRules\n * @param {ElementFactory} elementFactory\n * @param {EventBus} eventBus\n */\nfunction Modeling_Modeling(canvas, drdRules, injector) {\n  this._canvas = canvas;\n  this._drdRules = drdRules;\n  injector.invoke(Modeling/* default */.Z, this);\n}\n(0,index_es/* default */.Z)(Modeling_Modeling, Modeling/* default */.Z);\nModeling_Modeling.$inject = ['canvas', 'drdRules', 'injector'];\nModeling_Modeling.prototype.claimId = function (id, moddleElement) {\n  this._commandStack.execute('id.updateClaim', {\n    id: id,\n    element: moddleElement,\n    claiming: true\n  });\n};\nModeling_Modeling.prototype.connect = function (source, target, attrs, hints) {\n  var drdRules = this._drdRules,\n    rootElement = this._canvas.getRootElement();\n  if (!attrs) {\n    attrs = drdRules.canConnect(source, target) || {\n      type: 'dmn:Association'\n    };\n  }\n  return this.createConnection(source, target, attrs, rootElement, hints);\n};\nModeling_Modeling.prototype.getHandlers = function () {\n  var handlers = Modeling/* default.prototype.getHandlers.call */.Z.prototype.getHandlers.call(this);\n  handlers['id.updateClaim'] = IdClaimHandler;\n  handlers['element.updateLabel'] = UpdateLabelHandler;\n  handlers['element.updateProperties'] = UpdatePropertiesHandler;\n  return handlers;\n};\nModeling_Modeling.prototype.unclaimId = function (id, moddleElement) {\n  this._commandStack.execute('id.updateClaim', {\n    id: id,\n    element: moddleElement\n  });\n};\nModeling_Modeling.prototype.updateProperties = function (element, properties) {\n  this._commandStack.execute('element.updateProperties', {\n    element: element,\n    properties: properties\n  });\n};\nModeling_Modeling.prototype.updateLabel = function (element, newLabel, newBounds, hints) {\n  this._commandStack.execute('element.updateLabel', {\n    element: element,\n    newLabel: newLabel,\n    newBounds: newBounds,\n    hints: hints || {}\n  });\n};\n//# sourceMappingURL=Modeling.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/BaseLayouter.js\nvar BaseLayouter = __webpack_require__(\"./node_modules/diagram-js/lib/layout/BaseLayouter.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/DrdLayouter.js\n\n\n\n\n\nvar ADDITIONAL_WAYPOINT_DISTANCE = 20;\nfunction DrdLayouter(connectionDocking) {\n  this._connectionDocking = connectionDocking;\n}\n(0,index_es/* default */.Z)(DrdLayouter, BaseLayouter/* default */.Z);\nDrdLayouter.$inject = ['connectionDocking'];\nDrdLayouter.prototype.layoutConnection = function (connection, hints) {\n  var connectionDocking = this._connectionDocking;\n  if (!hints) {\n    hints = {};\n  }\n  var source = hints.source || connection.source,\n    target = hints.target || connection.target,\n    waypoints = hints.waypoints || connection.waypoints || [],\n    connectionStart = hints.connectionStart,\n    connectionEnd = hints.connectionEnd,\n    orientation = (0,LayoutUtil/* getOrientation */.T8)(source, target);\n  if (!connectionStart) {\n    connectionStart = getConnectionDocking(waypoints[0], source);\n  }\n  if (!connectionEnd) {\n    connectionEnd = getConnectionDocking(waypoints[waypoints.length - 1], target);\n  }\n  if ((0,ModelUtil.is)(connection, 'dmn:InformationRequirement')) {\n    waypoints = [connectionStart, connectionEnd];\n    var croppedWaypoints = connectionDocking.getCroppedWaypoints((0,dist_index_esm/* assign */.f0)({}, connection, {\n      waypoints: waypoints\n    }), source, target);\n    connectionEnd = croppedWaypoints.pop();\n    var additionalWaypoint = {\n      x: connectionEnd.x,\n      y: connectionEnd.y\n    };\n    if (orientation.includes('bottom')) {\n      additionalWaypoint.y += ADDITIONAL_WAYPOINT_DISTANCE;\n    } else if (orientation.includes('top')) {\n      additionalWaypoint.y -= ADDITIONAL_WAYPOINT_DISTANCE;\n    } else if (orientation.includes('right')) {\n      additionalWaypoint.x += ADDITIONAL_WAYPOINT_DISTANCE;\n    } else {\n      additionalWaypoint.x -= ADDITIONAL_WAYPOINT_DISTANCE;\n    }\n    waypoints = croppedWaypoints.concat([additionalWaypoint, connectionEnd]);\n    return waypoints;\n  }\n  return [connectionStart, connectionEnd];\n};\nfunction getConnectionDocking(point, shape) {\n  return point ? point.original || point : (0,LayoutUtil/* getMid */.wS)(shape);\n}\n//# sourceMappingURL=DrdLayouter.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/CroppingConnectionDocking.js\nvar CroppingConnectionDocking = __webpack_require__(\"./node_modules/diagram-js/lib/layout/CroppingConnectionDocking.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/modeling/index.js\n\n\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const modeling = ({\n  __init__: ['modeling', 'drdUpdater'],\n  __depends__: [behavior, features_rules, viewer/* default */.Z, command/* default */.Z, selection/* default */.Z, change_support/* default */.Z],\n  drdFactory: ['type', DrdFactory],\n  drdUpdater: ['type', DrdUpdater],\n  elementFactory: ['type', ElementFactory_ElementFactory],\n  modeling: ['type', Modeling_Modeling],\n  layouter: ['type', DrdLayouter],\n  connectionDocking: ['type', CroppingConnectionDocking/* default */.Z]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/move/index.js + 2 modules\nvar move = __webpack_require__(\"./node_modules/diagram-js/lib/features/move/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/palette/index.js + 1 modules\nvar palette = __webpack_require__(\"./node_modules/diagram-js/lib/features/palette/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/lasso-tool/index.js + 1 modules\nvar lasso_tool = __webpack_require__(\"./node_modules/diagram-js/lib/features/lasso-tool/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/hand-tool/index.js + 1 modules\nvar hand_tool = __webpack_require__(\"./node_modules/diagram-js/lib/features/hand-tool/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/palette/PaletteProvider.js\n\n\n/**\n * A palette provider for DMN elements.\n */\nfunction PaletteProvider(palette, create, elementFactory, handTool, lassoTool, translate) {\n  this._palette = palette;\n  this._create = create;\n  this._elementFactory = elementFactory;\n  this._handTool = handTool;\n  this._lassoTool = lassoTool;\n  this._translate = translate;\n  palette.registerProvider(this);\n}\nPaletteProvider.$inject = ['palette', 'create', 'elementFactory', 'handTool', 'lassoTool', 'translate'];\nPaletteProvider.prototype.getPaletteEntries = function (element) {\n  var actions = {},\n    create = this._create,\n    elementFactory = this._elementFactory,\n    handTool = this._handTool,\n    lassoTool = this._lassoTool,\n    translate = this._translate;\n  function createAction(type, group, className, title, options) {\n    function createListener(event) {\n      var shape = elementFactory.createShape((0,dist_index_esm/* assign */.f0)({\n        type: type\n      }, options));\n      create.start(event, shape);\n    }\n    return {\n      group: group,\n      className: className,\n      title: title,\n      action: {\n        dragstart: createListener,\n        click: createListener\n      }\n    };\n  }\n  (0,dist_index_esm/* assign */.f0)(actions, {\n    'hand-tool': {\n      group: 'tools',\n      className: 'dmn-icon-hand-tool',\n      title: translate('Activate the hand tool'),\n      action: {\n        click: function click(event) {\n          handTool.activateHand(event);\n        }\n      }\n    },\n    'lasso-tool': {\n      group: 'tools',\n      className: 'dmn-icon-lasso-tool',\n      title: translate('Activate the lasso tool'),\n      action: {\n        click: function click(event) {\n          lassoTool.activateSelection(event);\n        }\n      }\n    },\n    'tool-separator': {\n      group: 'tools',\n      separator: true\n    },\n    'create.decision': createAction('dmn:Decision', 'drd', 'dmn-icon-decision', translate('Create Decision')),\n    'create.input-data': createAction('dmn:InputData', 'drd', 'dmn-icon-input-data', translate('Create Input Data')),\n    'create.knowledge-source': createAction('dmn:KnowledgeSource', 'drd', 'dmn-icon-knowledge-source', translate('Create Knowledge Source')),\n    'create.business-knowledge-model': createAction('dmn:BusinessKnowledgeModel', 'drd', 'dmn-icon-business-knowledge', translate('Create Knowledge Model'))\n  });\n  return actions;\n};\n//# sourceMappingURL=PaletteProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/palette/index.js\n\n\n\n\n\n\n/* harmony default export */ const features_palette = ({\n  __depends__: [translate/* default */.Z, palette/* default */.Z, create/* default */.Z, lasso_tool/* default */.Z, hand_tool/* default */.Z],\n  __init__: ['paletteProvider'],\n  paletteProvider: ['type', PaletteProvider]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/resize/index.js + 4 modules\nvar resize = __webpack_require__(\"./node_modules/diagram-js/lib/features/resize/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/snapping/DrdBendpointSnapping.js\n\n\nvar RECONNECT_START = 'reconnectStart',\n  RECONNECT_END = 'reconnectEnd';\nvar HIGH_PRIORITY = 2000;\nfunction DrdBendpointSnapping(eventBus) {\n  eventBus.on(['bendpoint.move.move', 'bendpoint.move.end'], HIGH_PRIORITY, function (event) {\n    var context = event.context,\n      allowed = context.allowed,\n      hover = context.hover,\n      source = context.source,\n      target = context.target,\n      type = context.type;\n    if (!context.hints) {\n      context.hints = {};\n    }\n    delete context.hints.connectionStart;\n    delete context.hints.connectionEnd;\n    if (allowed && allowed.type !== 'dmn:InformationRequirement') {\n      return;\n    }\n    if (!hover || !(0,ModelUtil/* isAny */.JZ)(hover, ['dmn:Decision', 'dmn:InputData'])) {\n      return;\n    }\n    if (source === target) {\n      return;\n    }\n    var reconnect = type === RECONNECT_START || type === RECONNECT_END;\n    var orientation = (0,LayoutUtil/* getOrientation */.T8)(source, target);\n    if (reconnect && hover === source) {\n      // (1) snap event to source\n      snapToSource(event, orientation);\n\n      // (2) set connection end to target\n      context.hints.connectionEnd = getConnectionEnd(target, orientation);\n    } else if (reconnect && hover === target) {\n      // (1) set connection start to source\n      context.hints.connectionStart = getConnectionStart(source, orientation);\n\n      // (2) snap event to target\n      snapToTarget(event, orientation);\n    }\n  });\n}\nDrdBendpointSnapping.$inject = ['eventBus'];\n\n// helpers //////////\n\nfunction getConnectionStart(source, orientation) {\n  var sourceTrbl = (0,LayoutUtil/* asTRBL */.JA)(source);\n  var connectionStart = (0,LayoutUtil/* getMid */.wS)(source);\n  if (orientation.includes('bottom')) {\n    connectionStart.y = sourceTrbl.top;\n  } else if (orientation.includes('top')) {\n    connectionStart.y = sourceTrbl.bottom;\n  } else if (orientation.includes('right')) {\n    connectionStart.x = sourceTrbl.left;\n  } else {\n    connectionStart.x = sourceTrbl.right;\n  }\n  return connectionStart;\n}\nfunction getConnectionEnd(target, orientation) {\n  var targetTrbl = (0,LayoutUtil/* asTRBL */.JA)(target);\n  var connectionEnd = (0,LayoutUtil/* getMid */.wS)(target);\n  if (orientation.includes('bottom')) {\n    connectionEnd.y = targetTrbl.bottom;\n  } else if (orientation.includes('top')) {\n    connectionEnd.y = targetTrbl.top;\n  } else if (orientation.includes('right')) {\n    connectionEnd.x = targetTrbl.right;\n  } else {\n    connectionEnd.x = targetTrbl.left;\n  }\n  return connectionEnd;\n}\nfunction snapToSource(event, orientation) {\n  var context = event.context,\n    source = context.source;\n  var connectionStart = getConnectionStart(source, orientation);\n  var dx = event.x - connectionStart.x,\n    dy = event.y - connectionStart.y;\n  event.x -= dx;\n  event.y -= dy;\n  event.dx -= dx;\n  event.dy -= dy;\n}\nfunction snapToTarget(event, orientation) {\n  var context = event.context,\n    target = context.target;\n  var connectionEnd = getConnectionEnd(target, orientation);\n  var dx = 0,\n    dy = 0;\n  if (orientation.includes('top') || orientation.includes('bottom')) {\n    dy = event.y - connectionEnd.y;\n  } else {\n    dx = event.x - connectionEnd.x;\n  }\n  event.x -= dx;\n  event.y -= dy;\n  event.dx -= dx;\n  event.dy -= dy;\n}\n//# sourceMappingURL=DrdBendpointSnapping.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/snapping/DrdConnectSnapping.js\n\nvar DrdConnectSnapping_LOW_PRIORITY = 250;\nfunction DrdConnectSnapping(eventBus) {\n  eventBus.on(['connect.hover', 'connect.move', 'connect.end'], DrdConnectSnapping_LOW_PRIORITY, function (event) {\n    var context = event.context,\n      canExecute = context.canExecute,\n      hover = context.hover,\n      source = context.source,\n      target = context.target;\n    if (canExecute && canExecute.type === 'dmn:InformationRequirement') {\n      var orientation = (0,LayoutUtil/* getOrientation */.T8)(source, target);\n\n      // snap source\n      context.connectionStart = (0,LayoutUtil/* getMid */.wS)(source);\n\n      // snap target\n      if (hover === source) {\n        context.connectionEnd = (0,LayoutUtil/* getMid */.wS)(target);\n      } else {\n        context.connectionEnd = {\n          x: event.x,\n          y: event.y\n        };\n      }\n      if (orientation.includes('bottom')) {\n        context.connectionStart.y = (0,LayoutUtil/* asTRBL */.JA)(source).top;\n        context.connectionEnd.y = (0,LayoutUtil/* asTRBL */.JA)(target).bottom;\n      } else if (orientation.includes('top')) {\n        context.connectionStart.y = (0,LayoutUtil/* asTRBL */.JA)(source).bottom;\n        context.connectionEnd.y = (0,LayoutUtil/* asTRBL */.JA)(target).top;\n      } else if (orientation.includes('right')) {\n        context.connectionStart.x = (0,LayoutUtil/* asTRBL */.JA)(source).left;\n        context.connectionEnd.x = (0,LayoutUtil/* asTRBL */.JA)(target).right;\n      } else {\n        context.connectionStart.x = (0,LayoutUtil/* asTRBL */.JA)(source).right;\n        context.connectionEnd.x = (0,LayoutUtil/* asTRBL */.JA)(target).left;\n      }\n    } else {\n      delete context.connectionStart;\n      delete context.connectionEnd;\n    }\n  });\n}\nDrdConnectSnapping.$inject = ['eventBus'];\n//# sourceMappingURL=DrdConnectSnapping.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/snapping/index.js + 4 modules\nvar snapping = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/features/snapping/index.js\n\n\n\n/* harmony default export */ const features_snapping = ({\n  __depends__: [snapping/* default */.Z],\n  __init__: ['bendpointSnapping', 'connectSnapping'],\n  bendpointSnapping: ['type', DrdBendpointSnapping],\n  connectSnapping: ['type', DrdConnectSnapping]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-drd/lib/Modeler.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A modeler for DMN tables.\n *\n *\n * ## Extending the Modeler\n *\n * In order to extend the viewer pass extension modules to bootstrap via the\n * `additionalModules` option. An extension module is an object that exposes\n * named services.\n *\n * The following example depicts the integration of a simple\n * logging component that integrates with interaction events:\n *\n *\n * ```javascript\n *\n * // logging component\n * function InteractionLogger(eventBus) {\n *   eventBus.on('element.hover', function(event) {\n *     console.log()\n *   })\n * }\n *\n * InteractionLogger.$inject = [ 'eventBus' ]; // minification save\n *\n * // extension module\n * var extensionModule = {\n *   __init__: [ 'interactionLogger' ],\n *   interactionLogger: [ 'type', InteractionLogger ]\n * };\n *\n * // extend the viewer\n * var dmnModeler = new Modeler({ additionalModules: [ extensionModule ] });\n * dmnModeler.importXML(...);\n * ```\n *\n *\n * ## Customizing / Replacing Components\n *\n * You can replace individual table components by redefining them in override modules.\n * This works for all components, including those defined in the core.\n *\n * Pass in override modules via the `options.additionalModules` flag like this:\n *\n * ```javascript\n * function CustomContextPadProvider(contextPad) {\n *\n *   contextPad.registerProvider(this);\n *\n *   this.getContextPadEntries = function(element) {\n *     // no entries, effectively disable the context pad\n *     return {};\n *   };\n * }\n *\n * CustomContextPadProvider.$inject = [ 'contextPad' ];\n *\n * var overrideModule = {\n *   contextPadProvider: [ 'type', CustomContextPadProvider ]\n * };\n *\n * var dmnModeler = new Modeler({ additionalModules: [ overrideModule ]});\n * ```\n *\n * @param {Object} [options] configuration options to pass to the viewer\n * @param {DOMElement} [options.container]\n *        the container to render the viewer in, defaults to body.\n * @param {string|number} [options.width] the width of the viewer\n * @param {string|number} [options.height] the height of the viewer\n * @param {Object} [options.moddleExtensions]\n *        extension packages to provide\n * @param {Array<didi.Module>} [options.modules]\n *        a list of modules to override the default modules\n * @param {Array<didi.Module>} [options.additionalModules]\n *        a list of modules to use with the default modules\n */\nfunction Modeler_Modeler(options) {\n  NavigatedViewer.call(this, options);\n}\n(0,index_es/* default */.Z)(Modeler_Modeler, NavigatedViewer);\n\n// modules the modeler is composed of\n//\n// - viewer + navigation modules\n// - modeling modules\n\nModeler_Modeler.prototype._modelingModules = [\n// modeling components\nalign_elements/* default */.Z, features_auto_place, auto_scroll/* default */.Z, bendpoints/* default */.Z, features_context_pad, connection_preview/* default */.Z, modeler, features_distribute_elements, features_editor_actions, generate_di, grid_snapping/* default */.Z, features_keyboard, keyboard_move/* default */.Z, keyboard_move_selection/* default */.Z, label_editing, modeling, move/* default */.Z, features_palette, resize/* default */.Z, features_snapping];\nModeler_Modeler.prototype._modules = [].concat(Modeler_Modeler.prototype._modules, Modeler_Modeler.prototype._modelingModules);\n//# sourceMappingURL=Modeler.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-decision-table/lib/Viewer.js + 28 modules\nvar lib_Viewer = __webpack_require__(\"./node_modules/dmn-js-decision-table/lib/Viewer.js\");\n// EXTERNAL MODULE: ./node_modules/inferno/index.esm.js + 1 modules\nvar inferno_index_esm = __webpack_require__(\"./node_modules/inferno/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/utils/inject.js\nvar inject = __webpack_require__(\"./node_modules/table-js/lib/components/utils/inject.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/add-rule/components/AddRuleFootComponent.js\n\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nclass AddRuleFootComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    _defineProperty(this, \"handleClick\", e => {\n      e.stopPropagation();\n      this.addRule(e.target.dataset.colIndex);\n    });\n    (0,inject/* inject */.f)(this);\n    this.addRule = this.addRule.bind(this);\n  }\n  componentWillMount() {\n    this._eventBus = this.context.injector.get('eventBus');\n  }\n  addRule(colIndex) {\n    this._eventBus.fire('addRule', {\n      colIndex\n    });\n  }\n  render() {\n    const cols = this.props.cols;\n    const cells = [(0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", \"add-rule-add\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"dmn-icon-plus action-icon\", null, 1, {\n      \"title\": \"Add Rule\"\n    }), 2)];\n    const _this$sheet$getRoot = this.sheet.getRoot(),\n      businessObject = _this$sheet$getRoot.businessObject;\n    if (!businessObject.input || !businessObject.input.length) {\n      cells.push((0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", \"input-cell\", (0,inferno_index_esm/* createTextVNode */.Uk)(\"-\"), 2));\n    }\n    for (let i = 0; i < cols.length + 1; i++) {\n      let className = 'add-rule';\n      const businessObject = cols[i] && cols[i].businessObject;\n      let placeholder = '';\n      if (businessObject) {\n        if (businessObject.$instanceOf('dmn:InputClause')) {\n          className += ' input-cell';\n          placeholder = '-';\n        }\n        if (businessObject.$instanceOf('dmn:OutputClause')) {\n          className += ' output-cell';\n        }\n      } else {\n        className += ' annotation';\n      }\n      cells.push((0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", className, placeholder, 0, {\n        \"data-col-index\": i\n      }));\n    }\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"tfoot\", \"actionable add-rule\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"tr\", null, cells, 0), 2, {\n      \"onClick\": this.handleClick\n    });\n  }\n}\nAddRuleFootComponent.$inject = ['sheet'];\n//# sourceMappingURL=AddRuleFootComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/add-rule/AddRule.js\n\nclass AddRule {\n  constructor(components, editorActions, eventBus, selection) {\n    components.onGetComponent('table.foot', () => AddRuleFootComponent);\n    eventBus.on('addRule', (e, context) => {\n      const rule = editorActions.trigger('addRule');\n      const colIndex = context.colIndex;\n      if (rule.cells[colIndex]) {\n        selection.select(rule.cells[colIndex]);\n      } else {\n        selection.select(rule.cells[0]);\n      }\n    });\n  }\n}\nAddRule.$inject = ['components', 'editorActions', 'eventBus', 'selection'];\n//# sourceMappingURL=AddRule.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/features/selection/index.js + 2 modules\nvar features_selection = __webpack_require__(\"./node_modules/table-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/table-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/table-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/css.escape/css.escape.js\nvar css_escape = __webpack_require__(\"./node_modules/css.escape/css.escape.js\");\nvar css_escape_default = /*#__PURE__*/__webpack_require__.n(css_escape);\n// EXTERNAL MODULE: ./node_modules/selection-ranges/dist/index.esm.js\nvar selection_ranges_dist_index_esm = __webpack_require__(\"./node_modules/selection-ranges/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/cell-selection/CellSelectionUtil.js\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }\nfunction _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : \"undefined\" != typeof Symbol && arr[Symbol.iterator] || arr[\"@@iterator\"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\nconst SELECTABLE_SELECTOR = '[contenteditable]';\nconst ELEMENT_SELECTOR = '[data-element-id]';\nfunction getElementId(node) {\n  return node.getAttribute('data-element-id');\n}\nfunction getElementCoords(node) {\n  const coordsAttr = node.getAttribute('data-coords');\n  if (!coordsAttr) {\n    return null;\n  }\n  const _coordsAttr$split = coordsAttr.split(':'),\n    _coordsAttr$split2 = _slicedToArray(_coordsAttr$split, 2),\n    row = _coordsAttr$split2[0],\n    col = _coordsAttr$split2[1];\n  return {\n    row,\n    col\n  };\n}\nfunction getNodeByCoords(elementCoords, container) {\n  const coordsAttr = \"\".concat(elementCoords.row, \":\").concat(elementCoords.col);\n  return (0,min_dom_dist_index_esm/* query */.IO)(\"[data-coords=\\\"\".concat(css_escape_default()(coordsAttr), \"\\\"]\"), container);\n}\nfunction getNodeById(elementId, container) {\n  return (0,min_dom_dist_index_esm/* query */.IO)(\"[data-element-id=\\\"\".concat(css_escape_default()(elementId), \"\\\"]\"), container);\n}\nfunction isUnselectableNode(node) {\n  return (0,min_dom_dist_index_esm/* closest */.oq)(node, '.no-deselect', true);\n}\n\n/**\n * Find semantically _selectable_ element in the nodes ancestors.\n *\n * @param {Element} node\n *\n * @return {Element} node\n */\nfunction findSelectableAncestor(node) {\n  return (0,min_dom_dist_index_esm/* closest */.oq)(node, ELEMENT_SELECTOR, true);\n}\n\n/**\n * Return focusable node in selectable el.\n *\n * @param  {Element} el\n *\n * @return {Element}\n */\nfunction getFocusableNode(el) {\n  const selector = SELECTABLE_SELECTOR;\n  return (0,min_dom_dist_index_esm/* matches */.wB)(el, selector) ? el : (0,min_dom_dist_index_esm/* query */.IO)(selector, el);\n}\n\n/**\n * Ensure element or element childNode has the proper focus.\n *\n * @param {Element} el\n */\nfunction ensureFocus(el) {\n  const focusEl = getFocusableNode(el);\n  if (!focusEl) {\n    return;\n  }\n\n  // QUIRK: otherwise range and focus related actions may\n  // yield errors in older browsers (PhantomJS / IE)\n  if (!document.body.contains(focusEl)) {\n    return;\n  }\n\n  // nothing to do, if element already has focus\n  if (document.activeElement === focusEl) {\n    return;\n  }\n\n  // (1) focus\n  focusEl.focus();\n\n  // (2) set cursor to element end\n  const range = (0,selection_ranges_dist_index_esm/* getRange */.rx)(focusEl);\n  if (!range || range.end === 0) {\n    (0,selection_ranges_dist_index_esm/* setRange */.n$)(focusEl, {\n      start: 5000,\n      end: 5000\n    });\n  }\n}\n//# sourceMappingURL=CellSelectionUtil.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/cell-selection/CellSelection.js\n\nconst CellSelection_LOW_PRIORITY = 500;\nconst VALID_DIRECTIONS = {\n  above: true,\n  below: true,\n  right: true,\n  left: true\n};\n\n/**\n * A cell selection utlity; allows selection of elements, independent from\n * whether they are backed by a business object or not.\n *\n * Works together with the {@link SelectionAware} trait.\n *\n * @param {RenderConfig} config\n * @param {EventBus} eventBus\n * @param {Sheet} sheet\n * @param {Selection} selection\n * @param {ElementRegistry} elementRegistry\n */\nfunction CellSelection(config, eventBus, sheet, selection, elementRegistry) {\n  const container = config.container;\n  let lastSelection = null;\n  function emit(elementId, newSelection) {\n    eventBus.fire('selection.' + elementId + '.changed', newSelection);\n    eventBus.fire('cellSelection.changed', {\n      elementId: elementId,\n      selection: newSelection\n    });\n  }\n  function click(event) {\n    const target = event.target;\n    if (isUnselectableNode(target)) {\n      return;\n    }\n    const selectableNode = findSelectableAncestor(target);\n    const elementId = selectableNode && getElementId(selectableNode);\n    const focussed = !event.defaultPrevented;\n    realSelect(elementId, focussed);\n  }\n  function focus(event) {\n    const elementId = getElementId(event.target);\n    const focussed = !event.defaultPrevented;\n    event.stopPropagation();\n    return realSelect(elementId, focussed);\n  }\n  function unfocus(event) {\n    const elementId = getElementId(event.target);\n    emit(elementId, {\n      focussed: false\n    });\n  }\n  function realSelect(elementId) {\n    let focussed = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;\n    if (lastSelection !== elementId) {\n      emit(lastSelection, {\n        selected: false,\n        focussed: false\n      });\n    }\n    lastSelection = elementId;\n    if (elementId) {\n      emit(elementId, {\n        selected: true,\n        focussed\n      });\n    }\n    if (elementId) {\n      selection.select(elementId);\n    } else {\n      selection.deselect();\n    }\n  }\n  eventBus.on('cell.click', CellSelection_LOW_PRIORITY, click);\n  eventBus.on('cell.focusin', CellSelection_LOW_PRIORITY, focus);\n  eventBus.on('cell.focusout', CellSelection_LOW_PRIORITY, unfocus);\n  eventBus.on('cellSelection.changed', function (event) {\n    const elementId = event.elementId,\n      selection = event.selection;\n    const actualElement = getNodeById(elementId, container);\n    if (selection.focussed && actualElement) {\n      ensureFocus(actualElement);\n    }\n  });\n  eventBus.on('selection.changed', function (event) {\n    const selection = event.selection,\n      oldSelection = event.oldSelection;\n    var elementId = selection && selection.id;\n    var oldElementId = oldSelection && oldSelection.id;\n\n    // select new element\n    if (elementId && elementId !== lastSelection) {\n      realSelect(selection.id);\n    } else\n      // deselect old element\n      if (oldElementId && oldElementId === lastSelection) {\n        realSelect();\n      }\n  });\n\n  // API //////////////////////\n\n  /**\n   * Return true if a cell is currently selected.\n   *\n   * @return {boolean}\n   */\n  this.isCellSelected = function () {\n    return !!lastSelection;\n  };\n\n  /**\n   * Get the currently active cellSelection.\n   *\n   * @return {string} selection\n   */\n  this.getCellSelection = function () {\n    return lastSelection;\n  };\n\n  /**\n   * Select next cell in given direction.\n   *\n   * Returns true on success; false on fail (i.e. if no next selection\n   * in direction could be found).\n   *\n   * @param {string} direction\n   *\n   * @return {boolean}\n   */\n  this.selectCell = function (direction) {\n    if (!lastSelection) {\n      return;\n    }\n    if (!(direction in VALID_DIRECTIONS)) {\n      throw new Error('direction must be any of { above, below, left, right }');\n    }\n    var selectionEl = getNodeById(lastSelection, container);\n    const coords = getElementCoords(selectionEl);\n    if (!coords) {\n      return false;\n    }\n    const nextCoords = getNextCoords(coords, direction);\n    const nextNode = getNodeByCoords(nextCoords, container);\n    if (!nextNode) {\n      return false;\n    }\n    const nextElId = getElementId(nextNode);\n    if (nextElId) {\n      realSelect(nextElId, {\n        focussed: true,\n        selected: true\n      });\n    }\n    return true;\n  };\n  eventBus.on('contextMenu.close', function () {\n    if (lastSelection) {\n      return realSelect(lastSelection);\n    }\n  });\n}\nCellSelection.$inject = ['config.renderer', 'eventBus', 'sheet', 'selection', 'elementRegistry'];\n\n// helpers ////////////////\n\nfunction getNextCoords(coords, direction) {\n  const row = coords.row,\n    col = coords.col;\n  if (direction === 'above' || direction === 'below') {\n    const rowIndex = parseInt(row, 10);\n    if (isNaN(rowIndex)) {\n      return coords;\n    }\n    const nextRowIndex = direction === 'above' ? rowIndex - 1 : rowIndex + 1;\n    return {\n      col,\n      row: nextRowIndex\n    };\n  }\n  if (direction === 'left' || direction === 'right') {\n    const colIndex = parseInt(col, 10);\n    if (isNaN(colIndex)) {\n      return coords;\n    }\n    const nextColIndex = direction === 'left' ? colIndex - 1 : colIndex + 1;\n    return {\n      row,\n      col: nextColIndex\n    };\n  }\n  throw new Error('invalid direction <' + direction + '>');\n}\n//# sourceMappingURL=CellSelection.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/cell-selection/index.js\n\n\n\n/* harmony default export */ const cell_selection = ({\n  __depends__: [interaction_events/* default */.Z, features_selection/* default */.Z],\n  __init__: ['cellSelection'],\n  cellSelection: ['type', CellSelection]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/clipboard/index.js + 1 modules\nvar clipboard = __webpack_require__(\"./node_modules/diagram-js/lib/features/clipboard/index.js\");\n// EXTERNAL MODULE: ./node_modules/dmn-js-decision-table/node_modules/min-dash/dist/index.esm.js\nvar node_modules_min_dash_dist_index_esm = __webpack_require__(\"./node_modules/dmn-js-decision-table/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/table-js/lib/model/index.js\nvar model = __webpack_require__(\"./node_modules/table-js/lib/model/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/rules/DecisionTableModelingRules.js\n\n\n\n\nconst DecisionTableModelingRules_HIGH_PRIORITY = 2000;\nclass DecisionTableModelingRules extends RuleProvider/* default */.Z {\n  constructor(eventBus, sheet) {\n    super(eventBus);\n    this._sheet = sheet;\n  }\n  init() {\n    this.addRule('col.move', DecisionTableModelingRules_HIGH_PRIORITY, _ref => {\n      let col = _ref.col,\n        index = _ref.index;\n      const _this$_sheet$getRoot = this._sheet.getRoot(),\n        businessObject = _this$_sheet$getRoot.businessObject,\n        input = businessObject.input;\n      if ((0,ModelUtil/* isInput */.u7)(col)) {\n        return index < input.length;\n      } else {\n        return index >= input.length;\n      }\n    });\n    this.addRule('col.remove', DecisionTableModelingRules_HIGH_PRIORITY, _ref2 => {\n      let col = _ref2.col;\n      const _this$_sheet$getRoot2 = this._sheet.getRoot(),\n        cols = _this$_sheet$getRoot2.cols;\n      if ((0,ModelUtil/* isOutput */.RW)(col)) {\n        return cols.filter(c => (0,ModelUtil/* isOutput */.RW)(c)).length > 1;\n      }\n      return true;\n    });\n\n    // a rule that is aware of the data structure coming from copy and paste\n    this.addRule('paste', DecisionTableModelingRules_HIGH_PRIORITY, _ref3 => {\n      let data = _ref3.data,\n        target = _ref3.target;\n      if (!data || !target) {\n        return false;\n      }\n      const root = data.root;\n      if (target instanceof model/* Row */.X2) {\n        return this.canPasteRows(root);\n      }\n      if (target instanceof model/* Col */.JX) {\n        return this.canPasteCols(root, target);\n      }\n      return false;\n    });\n  }\n  canPasteRows(root) {\n    const _this$_sheet$getRoot3 = this._sheet.getRoot(),\n      cols = _this$_sheet$getRoot3.cols;\n    return (0,node_modules_min_dash_dist_index_esm/* every */.yW)(root, descriptor => {\n      if (descriptor.type !== 'row') {\n        return false;\n      }\n      if (descriptor.cells.length !== cols.length) {\n        return false;\n      }\n      return (0,node_modules_min_dash_dist_index_esm/* every */.yW)(descriptor.cells, (cellDescriptor, index) => {\n        if ((0,ModelUtil/* isInput */.u7)(cols[index])) {\n          return cellDescriptor.businessObject.$type === 'dmn:UnaryTests';\n        } else {\n          return cellDescriptor.businessObject.$type === 'dmn:LiteralExpression';\n        }\n      });\n    });\n  }\n  canPasteCols(root, targetCol) {\n    const _this$_sheet$getRoot4 = this._sheet.getRoot(),\n      rows = _this$_sheet$getRoot4.rows;\n    return (0,node_modules_min_dash_dist_index_esm/* every */.yW)(root, descriptor => {\n      if (descriptor.type !== 'col') {\n        return false;\n      }\n      if (descriptor.cells.length !== rows.length) {\n        return false;\n      }\n      if ((0,ModelUtil/* isInput */.u7)(targetCol)) {\n        return descriptor.businessObject.$type === 'dmn:InputClause';\n      } else {\n        return descriptor.businessObject.$type === 'dmn:OutputClause';\n      }\n    });\n  }\n}\nDecisionTableModelingRules.$inject = ['eventBus', 'sheet'];\n//# sourceMappingURL=DecisionTableModelingRules.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/features/rules/index.js\nvar lib_features_rules = __webpack_require__(\"./node_modules/table-js/lib/features/rules/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/rules/index.js\n\n\n/* harmony default export */ const dmn_js_decision_table_lib_features_rules = ({\n  __depends__: [lib_features_rules/* default */.Z],\n  __init__: ['decisionTableModelingRules'],\n  decisionTableModelingRules: ['type', DecisionTableModelingRules]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/copy-cut-paste/cmd/CutHandler.js\n\n\n/**\r\n * A handler that implements cutting a row or col.\r\n * Cutting of cells doesn't make sense.\r\n */\nclass CutHandler {\n  constructor(clipboard, modeling, sheet) {\n    this._clipboard = clipboard;\n    this._modeling = modeling;\n    this._sheet = sheet;\n  }\n\n  /**\r\n   * <do>\r\n   */\n  execute(context) {\n    let data = context.data;\n    context.oldData = this._clipboard.get();\n    this._clipboard.set(data);\n    return this._sheet.getRoot();\n  }\n  postExecute(context) {\n    let elements = context.elements;\n    elements.forEach(element => {\n      if (element instanceof model/* Row */.X2) {\n        this._modeling.removeRow(element);\n      } else if (element instanceof model/* Col */.JX) {\n        this._modeling.removeCol(element);\n      }\n    });\n  }\n\n  /**\r\n   * <undo>\r\n   */\n  revert(context) {\n    const oldData = context.oldData;\n    this._clipboard.set(oldData);\n    return this._sheet.getRoot();\n  }\n}\nCutHandler.$inject = ['clipboard', 'modeling', 'sheet'];\n//# sourceMappingURL=CutHandler.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/copy-cut-paste/DescriptorUtil.js\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { DescriptorUtil_defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction DescriptorUtil_defineProperty(obj, key, value) { key = DescriptorUtil_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction DescriptorUtil_toPropertyKey(arg) { var key = DescriptorUtil_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction DescriptorUtil_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n// creating descriptors //////////\n\nconst createHooks = [copyTableProperties, copyBusinessObjectProperties];\nconst reviveHooks = [reviveBusinessObject, reviveTableElement];\n\n/**\n * Return a serializable snapshot of the given elements.\n *\n * @param {Array<Base>} elements list of table elements\n *\n * @return {Tree} descriptor tree\n */\nfunction createDescriptor(element, cache, hooks) {\n  hooks = hooks || createHooks;\n  cache = cache || {};\n  if ((0,node_modules_min_dash_dist_index_esm/* isArray */.kJ)(element)) {\n    return createDescriptors0(element, cache, hooks);\n  } else {\n    return createDescriptor0(element, cache, hooks);\n  }\n}\n\n/**\n * Create descriptors of elements, returning { descriptors: [], descriptorCache }.\n *\n * @param {Array<Base>} elements list of table elements\n * @param {Object} cache the create cache\n *\n * @return {Object} new descriptors + updated cache\n */\nfunction createDescriptors0(elements, cache, hooks) {\n  return (0,node_modules_min_dash_dist_index_esm/* reduce */.u4)(elements, (result, element) => {\n    var currentCache = result.descriptorCache,\n      currentDescriptors = result.root;\n    let _createDescriptor = createDescriptor0(element, currentCache, hooks),\n      root = _createDescriptor.root,\n      descriptorCache = _createDescriptor.descriptorCache;\n    return {\n      root: [...currentDescriptors, root],\n      descriptorCache: _objectSpread(_objectSpread({}, currentCache), descriptorCache)\n    };\n  }, {\n    root: [],\n    descriptorCache: cache\n  });\n}\nfunction createDescriptor0(element, cache, hooks) {\n  var id = element.id;\n  var descriptor = {\n    id: id\n  };\n  var elements = cache.elements || {};\n  var existingDescriptor = elements[id];\n\n  // element already created; nothing to do\n  if (existingDescriptor) {\n    return {\n      root: existingDescriptor,\n      descriptorCache: cache\n    };\n  }\n\n  // we're new; need to initialize element via hooks\n  // we assume we're not handling recursive data structures\n  // here. Otherwise we'd need to pre-populate the cache\n  // with the given element\n  let element0 = evaluateHooks(element, descriptor, hooks, _objectSpread(_objectSpread({}, cache), {}, {\n    elements\n  }));\n  return {\n    root: element0.root,\n    descriptorCache: _objectSpread(_objectSpread({}, element0.descriptorCache), {}, {\n      elements: _objectSpread(_objectSpread({}, element0.descriptorCache.elements), {}, {\n        [id]: element0.root\n      })\n    })\n  };\n}\nfunction evaluateHooks(element, descriptor, hooks, cache) {\n  function create(element, descriptorCache) {\n    return createDescriptor(element, descriptorCache, hooks);\n  }\n  return (0,node_modules_min_dash_dist_index_esm/* reduce */.u4)(hooks, function (result, hook) {\n    return hook(element, result.root, result.descriptorCache, create);\n  }, {\n    root: descriptor,\n    descriptorCache: cache\n  });\n}\n\nfunction copyTableProperties(element, descriptor, cache, create) {\n  var descriptorCache = cache;\n  var newDesc = _objectSpread(_objectSpread({}, descriptor), {}, {\n    type: getType(element)\n  });\n  if (element instanceof model/* Row */.X2 || element instanceof model/* Col */.JX) {\n    let cells0 = create(element.cells, descriptorCache);\n    newDesc.cells = cells0.root;\n    descriptorCache = cells0.descriptorCache;\n  }\n  return {\n    root: newDesc,\n    descriptorCache\n  };\n}\nfunction copyBusinessObjectProperties(element, descriptor, cache) {\n  var businessObject = element.businessObject;\n  if (!businessObject) {\n    return {\n      root: descriptor,\n      descriptorCache: cache\n    };\n  }\n\n  // need to clone businessObject\n  var bo0 = createBoDescriptor(businessObject, cache);\n  return {\n    root: _objectSpread(_objectSpread({}, descriptor), {}, {\n      businessObject: bo0.root\n    }),\n    descriptorCache: bo0.descriptorCache\n  };\n}\nfunction getType(element) {\n  if (element instanceof model/* Row */.X2) {\n    return 'row';\n  }\n  if (element instanceof model/* Col */.JX) {\n    return 'col';\n  }\n  if (element instanceof model/* Cell */.bL) {\n    return 'cell';\n  }\n  throw new Error('cannot deduce element type: #' + element.id);\n}\nfunction createBoDescriptor(bo, cache) {\n  var boCache, existingBoDesc;\n  var id = bo.id;\n  if (id) {\n    boCache = cache.boCache || {};\n    existingBoDesc = boCache[id];\n\n    // businessObject already created; nothing to do\n    if (existingBoDesc) {\n      return {\n        root: existingBoDesc,\n        descriptorCache: cache\n      };\n    }\n  }\n  var descriptor = {\n    $type: bo.$type\n  };\n  if (id) {\n    descriptor.id = id;\n    boCache = _objectSpread(_objectSpread({}, boCache), {}, {\n      [id]: descriptor\n    });\n    cache = _objectSpread(_objectSpread({}, cache), {}, {\n      boCache\n    });\n  }\n\n  // TODO(nikku): distinguish relations and containment\n  // Need to build up the whole tree and revive relations afterwards\n\n  // ITERATE OVER ALL SET PROPERTIES\n  // (Object.keys(bo) or via bo.$descriptor....)\n\n  bo.$descriptor.properties.forEach(function (property) {\n    var value = bo[property.name];\n\n    // const propertyDescriptor = bo.$model.getPropertyDescriptor(bo, property.name),\n    //       isId = propertyDescriptor.isId,\n    //       isReference = propertyDescriptor.isReference;\n\n    // not set\n    if (!value) {\n      return;\n    }\n\n    // arrays of moddle elements\n    if ((0,node_modules_min_dash_dist_index_esm/* isArray */.kJ)(value)) {\n      value = value.map(b => {\n        var value0 = createBoDescriptor(b, cache);\n        cache = value0.descriptorCache;\n        return value0.root;\n      });\n    }\n\n    // moddle elements\n    if (value.$type) {\n      let value0 = createBoDescriptor(value, cache);\n      cache = value0.descriptorCache;\n      value = value0.root;\n    }\n\n    // other values\n    descriptor[property.name] = value;\n  });\n  return {\n    root: descriptor,\n    descriptorCache: cache\n  };\n}\n\n// reviving //////////\n\nfunction reviveDescriptor(entry, reviveCache, hooks) {\n  hooks = hooks || reviveHooks;\n  reviveCache = reviveCache || {};\n  if ((0,node_modules_min_dash_dist_index_esm/* isArray */.kJ)(entry.root)) {\n    return reviveDescriptors0(entry, reviveCache, hooks);\n  } else {\n    return reviveDescriptor0(entry, reviveCache, hooks);\n  }\n}\n\n/**\n * TBD: document this!\n *\n * @param  {[type]} entry       [description]\n * @param  {[type]} reviveCache [description]\n * @param  {[type]} hooks       [description]\n * @return {[type]}             [description]\n */\nfunction reviveDescriptors0(entry, reviveCache, hooks) {\n  let descriptors = entry.root;\n  let descriptorCache = entry.descriptorCache;\n  return (0,node_modules_min_dash_dist_index_esm/* reduce */.u4)(descriptors, (result, element) => {\n    var currentCache = result.reviveCache,\n      currentDescriptors = result.root;\n    let _reviveDescriptor = reviveDescriptor0({\n        root: element,\n        descriptorCache\n      }, currentCache, hooks),\n      root = _reviveDescriptor.root,\n      reviveCache = _reviveDescriptor.reviveCache;\n    return {\n      root: [...currentDescriptors, root],\n      reviveCache\n    };\n  }, {\n    root: [],\n    reviveCache\n  });\n}\n\n/**\n * TBD: document this!\n *\n * @param  {[type]} entry [description]\n * @param  {[type]} cache [description]\n * @param  {[type]} hooks [description]\n * @return {[type]}       [description]\n */\nfunction reviveDescriptor0(entry, reviveCache, hooks) {\n  var descriptor = entry.root;\n  var id = descriptor.id;\n  var elements = reviveCache.elements || {};\n  var existingElement = elements[id];\n\n  // element already created; nothing to do\n  if (existingElement) {\n    return {\n      root: existingElement,\n      reviveCache: reviveCache\n    };\n  }\n\n  // start with a fake element; haha <3\n  var element = {\n    id: id\n  };\n\n  // we're new; need to initialize element via hooks\n  let element0 = evaluateReviveHooks(entry, element, hooks, _objectSpread(_objectSpread({}, reviveCache), {}, {\n    elements\n  }));\n  return {\n    root: element0.root,\n    reviveCache: _objectSpread(_objectSpread({}, element0.reviveCache), {}, {\n      elements: _objectSpread(_objectSpread({}, element0.reviveCache.elements), {}, {\n        [id]: element0.root\n      })\n    })\n  };\n}\n\n// entry = { root, descriptorCache }\n// element = { id: foo }\n// hooks = [ ... ]\n// reviveCache = { ... }\nfunction evaluateReviveHooks(entry, element, hooks, reviveCache) {\n  function revive(entry, reviveCache) {\n    return reviveDescriptor(entry, reviveCache, hooks);\n  }\n  return (0,node_modules_min_dash_dist_index_esm/* reduce */.u4)(hooks, function (result, hook) {\n    return hook(entry, result.root, result.reviveCache, revive);\n  }, {\n    root: element,\n    reviveCache: reviveCache\n  });\n}\nfunction reviveTableElement(entry, element, reviveCache, revive) {\n  var descriptor = entry.root;\n  var createCache = entry.descriptorCache;\n  var elementAttrs = _objectSpread({}, element);\n\n  // make sure table element ID is same as moddle element ID\n  if (element.businessObject && element.businessObject.id) {\n    elementAttrs.id = element.businessObject.id;\n  }\n  if (descriptor.type === 'row' || descriptor.type === 'col') {\n    let cells0 = revive({\n      root: descriptor.cells,\n      descriptorCache: createCache\n    }, reviveCache);\n    elementAttrs.cells = cells0.root;\n    reviveCache = cells0.reviveCache;\n  }\n  var Constructor = getConstructor(descriptor);\n  var newElement = new Constructor(elementAttrs);\n\n  // set parent row or col\n  if (newElement instanceof model/* Row */.X2) {\n    newElement.cells.forEach(cell => {\n      cell.row = newElement;\n    });\n  } else if (newElement instanceof model/* Col */.JX) {\n    newElement.cells.forEach(cell => {\n      cell.col = newElement;\n    });\n  }\n  return {\n    root: newElement,\n    reviveCache\n  };\n}\nfunction reviveBusinessObject(entry, element, reviveCache) {\n  var businessObject = entry.root.businessObject;\n  if (!businessObject) {\n    return {\n      root: element,\n      reviveCache\n    };\n  }\n\n  // need to clone businessObject\n  var bo0 = createBo({\n    root: businessObject,\n    descriptorCache: entry.descriptorCache\n  }, reviveCache);\n  return {\n    root: _objectSpread(_objectSpread({}, element), {}, {\n      businessObject: bo0.root\n    }),\n    reviveCache: bo0.reviveCache\n  };\n}\nfunction getConstructor(descriptor) {\n  switch (descriptor.type) {\n    case 'row':\n      return model/* Row */.X2;\n    case 'cell':\n      return model/* Cell */.bL;\n    case 'col':\n      return model/* Col */.JX;\n    default:\n      throw new Error('unknown element type: #' + descriptor.type);\n  }\n}\nfunction createBo(entry, reviveCache) {\n  var boDescriptor = entry.root;\n  var id = boDescriptor.id;\n  let boCache, existingBo;\n  if (id) {\n    boCache = reviveCache.boCache || {};\n    existingBo = boCache[id];\n\n    // businessObject already created; nothing to do\n    if (existingBo) {\n      return {\n        root: existingBo,\n        reviveCache\n      };\n    }\n  }\n  var newBoAttrs = {};\n\n  // set attrs for new business object (might include creating other business objects)\n  (0,node_modules_min_dash_dist_index_esm/* keys */.XP)(boDescriptor).forEach(key => {\n    let val, val0;\n    if (boDescriptor[key].$type) {\n      val0 = createBo({\n        root: boDescriptor[key]\n      }, reviveCache);\n      val = val0.root;\n      reviveCache = val0.reviveCache;\n      boCache = reviveCache.boCache || {};\n    } else if ((0,node_modules_min_dash_dist_index_esm/* isArray */.kJ)(boDescriptor[key])) {\n      val = boDescriptor[key].map(b => {\n        val0 = createBo({\n          root: b\n        }, reviveCache);\n        reviveCache = val0.reviveCache;\n        boCache = reviveCache.boCache || {};\n        return val0.root;\n      });\n    } else {\n      val = boDescriptor[key];\n    }\n    newBoAttrs[key] = val;\n  });\n  const type = newBoAttrs.$type;\n  delete newBoAttrs.$type;\n\n  // generate new ID if not supposed to be kept or already assigned\n  if (!reviveCache._keepIds || reviveCache._model.ids.assigned(newBoAttrs.id)) {\n    delete newBoAttrs.id;\n  }\n  var newBo = reviveCache._dmnFactory.create(type, newBoAttrs);\n\n  // set up $parent relationships for moddle elements\n  (0,node_modules_min_dash_dist_index_esm/* forEach */.Ed)(newBoAttrs, newBoAttr => {\n    if (newBoAttr.$type) {\n      newBoAttr.$parent = newBo;\n    }\n    if ((0,node_modules_min_dash_dist_index_esm/* isArray */.kJ)(newBoAttr)) {\n      newBoAttr.forEach(a => a.$parent = newBo);\n    }\n  });\n  if (id) {\n    boCache = _objectSpread(_objectSpread({}, boCache), {}, {\n      [id]: newBo\n    });\n    reviveCache = _objectSpread(_objectSpread({}, reviveCache), {}, {\n      boCache\n    });\n  }\n  return {\n    root: newBo,\n    reviveCache\n  };\n}\n//# sourceMappingURL=DescriptorUtil.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/copy-cut-paste/cmd/PasteHandler.js\n\n\n\n/**\r\n * A handler that implements pasting elements.\r\n */\nclass PasteHandler {\n  constructor(clipboard, dmnFactory, elementFactory, elementRegistry, eventBus, moddle, modeling, sheet) {\n    this._clipboard = clipboard;\n    this._dmnFactory = dmnFactory;\n    this._elementFactory = elementFactory;\n    this._elementRegistry = elementRegistry;\n    this._eventBus = eventBus;\n    this._model = moddle;\n    this._modeling = modeling;\n    this._sheet = sheet;\n  }\n\n  /**\r\n   * <do>\r\n   */\n  postExecute(context) {\n    let element = context.element,\n      after = context.after;\n    const data = this._clipboard.get();\n    if (!data) {\n      throw new Error('missing clipboard data');\n    }\n    const root = this._sheet.getRoot();\n\n    // (1) create elements from descriptors\n    const elements = reviveDescriptor(data.elements, {\n      _dmnFactory: this._dmnFactory,\n      _keepIds: data.keepIds,\n      _model: this._model\n    }).root;\n\n    // (2) add elements to sheet\n    if (element instanceof model/* Row */.X2) {\n      let index = root.rows.indexOf(element);\n      if (index === -1) {\n        return;\n      }\n      elements.forEach(element => {\n        if (after) {\n          index++;\n        }\n        this._modeling.addRow(element, index);\n      });\n    } else if (element instanceof model/* Col */.JX) {\n      let index = root.cols.indexOf(element);\n      if (index === -1) {\n        return;\n      }\n      elements.forEach(element => {\n        if (after) {\n          index++;\n        }\n        this._modeling.addCol(element, index);\n      });\n    }\n    context.oldElements = this._clipboard.get();\n    return this._sheet.getRoot();\n  }\n\n  /**\r\n   * <undo>\r\n   */\n  revert(context) {}\n}\nPasteHandler.$inject = ['clipboard', 'dmnFactory', 'elementFactory', 'elementRegistry', 'eventBus', 'moddle', 'modeling', 'sheet'];\n//# sourceMappingURL=PasteHandler.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/copy-cut-paste/CopyCutPaste.js\nfunction CopyCutPaste_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction CopyCutPaste_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? CopyCutPaste_ownKeys(Object(source), !0).forEach(function (key) { CopyCutPaste_defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : CopyCutPaste_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction CopyCutPaste_defineProperty(obj, key, value) { key = CopyCutPaste_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction CopyCutPaste_toPropertyKey(arg) { var key = CopyCutPaste_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction CopyCutPaste_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\nclass CutPaste {\n  constructor(clipboard, commandStack, eventBus, modeling, sheet, rules) {\n    this._clipboard = clipboard;\n    this._commandStack = commandStack;\n    this._eventBus = eventBus;\n    this._modeling = modeling;\n    this._sheet = sheet;\n    this._rules = rules;\n    commandStack.registerHandler('cut', CutHandler);\n    commandStack.registerHandler('paste', PasteHandler);\n  }\n\n  /**\r\n   * Copy elements.\r\n   *\r\n   * @param {Array} elements - Elements to be copied.\r\n   */\n  copy(elements) {\n    if (!(0,node_modules_min_dash_dist_index_esm/* isArray */.kJ)(elements)) {\n      elements = [elements];\n    }\n    const data = {\n      elements: createDescriptor(elements)\n    };\n    this._eventBus.fire('copyCutPaste.copy', {\n      data\n    });\n    this._clipboard.set(data);\n  }\n\n  /**\r\n   * Cut elements thereby removing them temporarily.\r\n   *\r\n   * @param {Array} elements - Elements to be cut.\r\n   */\n  cut(elements) {\n    if (!(0,node_modules_min_dash_dist_index_esm/* isArray */.kJ)(elements)) {\n      elements = [elements];\n    }\n    const data = {\n      elements: createDescriptor(elements),\n      keepIds: true\n    };\n    const context = {\n      elements,\n      data\n    };\n    this._eventBus.fire('copyCutPaste.cut', {\n      data\n    });\n    this._commandStack.execute('cut', context);\n  }\n\n  /**\r\n   * Paste rows or cols before row or col.\r\n   *\r\n   * @param {Row|Col} element - Row or col to paste elements before.\r\n   */\n  pasteBefore(element) {\n    return this._paste(element, {\n      before: true\n    });\n  }\n\n  /**\r\n   * Paste rows or cols after row or col.\r\n   *\r\n   * @param {Row|Col} element - Row or col to paste elements after.\r\n   */\n  pasteAfter(element) {\n    return this._paste(element, {\n      after: true\n    });\n  }\n\n  /**\r\n   * Basic paste onto given target element.\r\n   */\n  _paste(target, position) {\n    const clipboardData = this._clipboard.get();\n    if (!clipboardData) {\n      return undefined;\n    }\n    const allowed = this._rules.allowed('paste', {\n      data: clipboardData.elements,\n      target\n    });\n    if (!allowed) {\n      return false;\n    }\n    this._commandStack.execute('paste', CopyCutPaste_objectSpread({\n      element: target\n    }, position));\n\n    // @bpmn-io: Clear clipboard to work around\n    // https://github.com/camunda/camunda-modeler/issues/1246 which breaks native copy &\n    // paste when row or column is copied or cut\n    this._clipboard.clear();\n\n    // Return true to stop propagation and prevent native paste\n    return true;\n  }\n\n  /**\r\n   * Paste elements at.\r\n   */\n  pasteAt(element) {\n\n    // TODO: implement for pasting cells\n  }\n}\nCutPaste.$inject = ['clipboard', 'commandStack', 'eventBus', 'modeling', 'sheet', 'rules'];\n//# sourceMappingURL=CopyCutPaste.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/copy-cut-paste/index.js\n\n\n\n/* harmony default export */ const copy_cut_paste = ({\n  __depends__: [clipboard/* default */.Z, dmn_js_decision_table_lib_features_rules],\n  __init__: ['copyCutPaste'],\n  copyCutPaste: ['type', CutPaste]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/editor-actions/DecisionTableEditorActions.js\n\nclass DecisionTableEditorActions {\n  constructor(copyCutPaste, editorActions, modeling, selection, cellSelection, sheet) {\n    const actions = {\n      addRule() {\n        return modeling.addRow({\n          type: 'dmn:DecisionRule'\n        });\n      },\n      addRuleAbove(context) {\n        let rule = context && context.rule;\n        if (!rule && !selection.hasSelection()) {\n          return;\n        }\n        rule = rule || selection.get().row;\n        const root = sheet.getRoot(),\n          index = root.rows.indexOf(rule);\n        if (index === -1) {\n          return;\n        }\n        return modeling.addRow({\n          type: 'dmn:DecisionRule'\n        }, index);\n      },\n      addRuleBelow(context) {\n        let rule = context && context.rule;\n        if (!rule && !selection.hasSelection()) {\n          return;\n        }\n        rule = rule || selection.get().row;\n        const root = sheet.getRoot(),\n          index = root.rows.indexOf(rule);\n        if (index === -1) {\n          return;\n        }\n        return modeling.addRow({\n          type: 'dmn:DecisionRule'\n        }, index + 1);\n      },\n      removeRule(context) {\n        let rule = context && context.rule;\n        if (!rule && !selection.hasSelection()) {\n          return;\n        }\n        rule = rule || selection.get().row;\n        modeling.removeRow(rule);\n      },\n      addInput() {\n        const root = sheet.getRoot(),\n          businessObject = root.businessObject;\n        const input = businessObject.input;\n        return modeling.addCol({\n          type: 'dmn:InputClause'\n        }, input ? input.length : 0);\n      },\n      addInputLeft(context) {\n        let input = context && context.input;\n        if (!input && !selection.hasSelection()) {\n          return;\n        }\n        input = input || selection.get().col;\n        const root = sheet.getRoot(),\n          index = root.cols.indexOf(input);\n        if (index === -1) {\n          return;\n        }\n        return modeling.addCol({\n          type: 'dmn:InputClause'\n        }, index);\n      },\n      addInputRight(context) {\n        let input = context && context.input;\n        if (!input && !selection.hasSelection()) {\n          return;\n        }\n        input = input || selection.get().col;\n        const root = sheet.getRoot(),\n          index = root.cols.indexOf(input);\n        if (index === -1) {\n          return;\n        }\n        return modeling.addCol({\n          type: 'dmn:InputClause'\n        }, index + 1);\n      },\n      removeInput(context) {\n        let input = context && context.input;\n        if (!input && !selection.hasSelection()) {\n          return;\n        }\n        input = input || selection.get().col;\n        modeling.removeCol(input);\n      },\n      addOutput() {\n        const root = sheet.getRoot(),\n          businessObject = root.businessObject;\n        const input = businessObject.get('input'),\n          output = businessObject.get('output');\n        return modeling.addCol({\n          type: 'dmn:OutputClause'\n        }, input.length + output.length);\n      },\n      addOutputLeft(context) {\n        let output = context && context.output;\n        if (!output && !selection.hasSelection()) {\n          return;\n        }\n        output = output || selection.get().col;\n        const root = sheet.getRoot(),\n          index = root.cols.indexOf(output);\n        if (index === -1) {\n          return;\n        }\n        return modeling.addCol({\n          type: 'dmn:OutputClause'\n        }, index);\n      },\n      addOutputRight(context) {\n        let output = context && context.output;\n        if (!output && !selection.hasSelection()) {\n          return;\n        }\n        output = output || selection.get().col;\n        const root = sheet.getRoot(),\n          index = root.cols.indexOf(output);\n        if (index === -1) {\n          return;\n        }\n        return modeling.addCol({\n          type: 'dmn:OutputClause'\n        }, index + 1);\n      },\n      removeOutput(context) {\n        let output = context && context.output;\n        if (!output && !selection.hasSelection()) {\n          return;\n        }\n        output = output || selection.get().col;\n        modeling.removeCol(output);\n      },\n      addClause() {\n        if (!selection.hasSelection()) {\n          return;\n        }\n        const clause = selection.get().col;\n        if ((0,ModelUtil.is)(clause, 'dmn:InputClause')) {\n          return actions.addInput({\n            input: clause\n          });\n        } else if ((0,ModelUtil.is)(clause, 'dmn:OutputClause')) {\n          return actions.addOutput({\n            output: clause\n          });\n        }\n      },\n      addClauseLeft() {\n        if (!selection.hasSelection()) {\n          return;\n        }\n        const clause = selection.get().col;\n        if ((0,ModelUtil.is)(clause, 'dmn:InputClause')) {\n          return actions.addInputLeft({\n            input: clause\n          });\n        } else if ((0,ModelUtil.is)(clause, 'dmn:OutputClause')) {\n          return actions.addOutputLeft({\n            output: clause\n          });\n        }\n      },\n      addClauseRight() {\n        if (!selection.hasSelection()) {\n          return;\n        }\n        const clause = selection.get().col;\n        if ((0,ModelUtil.is)(clause, 'dmn:InputClause')) {\n          return actions.addInputRight({\n            input: clause\n          });\n        } else if ((0,ModelUtil.is)(clause, 'dmn:OutputClause')) {\n          return actions.addOutputRight({\n            output: clause\n          });\n        }\n      },\n      removeClause() {\n        if (!selection.hasSelection()) {\n          return;\n        }\n        const clause = selection.get().col;\n        if ((0,ModelUtil.is)(clause, 'dmn:InputClause')) {\n          return actions.removeInput({\n            input: clause\n          });\n        } else if ((0,ModelUtil.is)(clause, 'dmn:OutputClause')) {\n          return actions.removeOutput({\n            output: clause\n          });\n        }\n      },\n      selectCellAbove() {\n        return cellSelection.selectCell('above');\n      },\n      selectCellBelow() {\n        return cellSelection.selectCell('below');\n      },\n      copy(_ref) {\n        let element = _ref.element;\n        copyCutPaste.copy(element);\n      },\n      cut(_ref2) {\n        let element = _ref2.element;\n        copyCutPaste.cut(element);\n      },\n      pasteBefore(_ref3) {\n        let element = _ref3.element;\n        return copyCutPaste.pasteBefore(element);\n      },\n      pasteAfter(_ref4) {\n        let element = _ref4.element;\n        return copyCutPaste.pasteAfter(element);\n      }\n    };\n    editorActions.register(actions);\n  }\n}\nDecisionTableEditorActions.$inject = ['copyCutPaste', 'editorActions', 'modeling', 'selection', 'cellSelection', 'sheet'];\n//# sourceMappingURL=DecisionTableEditorActions.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/features/editor-actions/index.js + 1 modules\nvar lib_features_editor_actions = __webpack_require__(\"./node_modules/table-js/lib/features/editor-actions/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/editor-actions/index.js\n\n\n\n\n\n/* harmony default export */ const dmn_js_decision_table_lib_features_editor_actions = ({\n  __depends__: [cell_selection, copy_cut_paste, lib_features_editor_actions/* default */.Z, features_selection/* default */.Z],\n  __init__: ['decisionTableEditorActions'],\n  decisionTableEditorActions: ['type', DecisionTableEditorActions]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/add-rule/index.js\n\n\n/* harmony default export */ const add_rule = ({\n  __depends__: [dmn_js_decision_table_lib_features_editor_actions],\n  __init__: ['addRule'],\n  addRule: ['type', AddRule]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-decision-table/lib/features/annotations/components/AnnotationHeader.js\nvar AnnotationHeader = __webpack_require__(\"./node_modules/dmn-js-decision-table/lib/features/annotations/components/AnnotationHeader.js\");\n// EXTERNAL MODULE: ./node_modules/escape-html/index.js\nvar escape_html = __webpack_require__(\"./node_modules/escape-html/index.js\");\nvar escape_html_default = /*#__PURE__*/__webpack_require__.n(escape_html);\n// EXTERNAL MODULE: ./node_modules/selection-update/index.js\nvar selection_update = __webpack_require__(\"./node_modules/selection-update/index.js\");\nvar selection_update_default = /*#__PURE__*/__webpack_require__.n(selection_update);\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/components/ContentEditable.js\n\nfunction ContentEditable_defineProperty(obj, key, value) { key = ContentEditable_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction ContentEditable_toPropertyKey(arg) { var key = ContentEditable_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction ContentEditable_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\n\n/**\n * A content ediable that performs proper selection updates on\n * editable changes. It normalizes editor operations by allowing\n * only <br/> and plain text to be inserted.\n *\n * The callback `onInput(text)` recieves text (including line breaks)\n * only. Updating the value via props will update the selection\n * if needed, too.\n *\n * @example\n *\n * class SomeComponent extends Component {\n *\n *   render() {\n *     return (\n *       <ContentEditable\n *         className=\"some classes\"\n *         value={ this.state.text }\n *         onInput={ this.handleInput }\n *         onFocus={ ... }\n *         onBlur={ ... } />\n *     );\n *   }\n *\n * }\n *\n */\nclass ContentEditable extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    ContentEditable_defineProperty(this, \"onFocus\", event => {\n      var propsFocus = this.props.onFocus;\n      this.setState({\n        focussed: true\n      });\n      if (typeof propsFocus === 'function') {\n        propsFocus(event);\n      }\n    });\n    ContentEditable_defineProperty(this, \"onBlur\", event => {\n      var propsBlur = this.props.onBlur;\n      this.setState({\n        focussed: false\n      });\n      if (typeof propsBlur === 'function') {\n        propsBlur(event);\n      }\n    });\n    ContentEditable_defineProperty(this, \"onKeydown\", event => {\n      // enter\n      if (event.which === 13) {\n        // prevent default action (<br/> insert)\n        event.preventDefault();\n        if (this.props.ctrlForNewline && !isCmd(event)) {\n          return;\n        }\n        if (this.props.singleLine) {\n          return;\n        }\n        event.stopPropagation();\n        insertLineBreak();\n        this.onInput(event);\n      }\n    });\n    ContentEditable_defineProperty(this, \"onInput\", event => {\n      var propsInput = this.props.onInput;\n      if (typeof propsInput !== 'function') {\n        return;\n      }\n      var text = innerText(this.node);\n      propsInput(text);\n    });\n    ContentEditable_defineProperty(this, \"onKeyPress\", event => {\n      if (this.onInputIEPolyfill) {\n        this.onInputIEPolyfill(event);\n      }\n    });\n    ContentEditable_defineProperty(this, \"onPaste\", event => {\n      // TODO(barmac): remove once we drop IE 11 support\n      if (this.onInputIEPolyfill) {\n        this.onInputIEPolyfill(event);\n      }\n      if (this.props.singleLine) {\n        const text = (event.clipboardData || window.clipboardData).getData('text');\n\n        // replace newline with space\n        document.execCommand('insertText', false, text.replace(/\\n/g, ' '));\n        event.preventDefault();\n      }\n    });\n    this.state = {};\n\n    // TODO(nikku): remove once we drop IE 11 support\n    if (isIE()) {\n      // onInput shim for IE <= 11\n      this.onInputIEPolyfill = event => {\n        var oldText = this.node.innerHTML;\n        setTimeout(() => {\n          var text = this.node.innerHTML;\n          if (oldText !== text) {\n            this.onInput(event);\n          }\n        }, 0);\n      };\n    }\n  }\n  componentWillUpdate(newProps, newState) {\n    // save old selection + text for later\n    var node = this.node;\n    var range = newState.focussed && (0,selection_ranges_dist_index_esm/* getRange */.rx)(node);\n    this.selected = range && {\n      range: range,\n      text: innerText(node)\n    };\n  }\n  componentDidUpdate() {\n    var selected = this.selected;\n    if (!selected) {\n      return;\n    }\n\n    // compute and restore selection based on\n    // (possibly new) text\n\n    const range = selected.range;\n    const text = selected.text;\n    const node = this.node;\n    const newText = innerText(node);\n    const newRange = newText !== text ? selection_update_default()(range, text, newText) : range;\n    (0,selection_ranges_dist_index_esm/* setRange */.n$)(node, newRange);\n  }\n  getClassName() {\n    const _this$props = this.props,\n      className = _this$props.className,\n      placeholder = _this$props.placeholder,\n      value = _this$props.value;\n    return [className || '', 'content-editable', !value && placeholder ? 'content-editable--with-placeholder' : ''].join(' ');\n  }\n  render(props) {\n    var value = props.value,\n      placeholder = props.placeholder;\n\n    // QUIRK: must add trailing <br/> for line\n    // breaks to properly work\n    value = escape_html_default()(value).replace(/\\r?\\n/g, '<br/>') + '<br/>';\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", this.getClassName(), null, 1, {\n      \"contentEditable\": \"true\",\n      \"spellcheck\": \"false\",\n      \"data-placeholder\": placeholder || '',\n      \"onInput\": this.onInput,\n      \"onKeypress\": this.onKeypress,\n      \"onPaste\": this.onPaste,\n      \"onFocus\": this.onFocus,\n      \"onBlur\": this.onBlur,\n      \"onKeydown\": this.onKeydown,\n      \"dangerouslySetInnerHTML\": {\n        __html: value\n      }\n    }, null, node => this.node = node);\n  }\n}\nfunction brTag() {\n  return document.createElement('br');\n}\nfunction innerText(node) {\n  // QUIRK: we must remove the last trailing <br/>, if any\n  return node.innerText.replace(/\\n$/, '');\n}\nfunction insertLineBreak() {\n  // insert line break at current insertation\n  // point; this assumes that the correct element, i.e.\n  // a <ContentEditable /> is currently focussed\n  var selection = (0,selection_ranges_dist_index_esm/* getWindowSelection */.sD)();\n  var range = selection.getRangeAt(0);\n  if (!range) {\n    return;\n  }\n  var newRange = range.cloneRange();\n  var br = brTag();\n  newRange.deleteContents();\n  newRange.insertNode(br);\n  newRange.setStartAfter(br);\n  newRange.setEndAfter(br);\n  (0,selection_ranges_dist_index_esm/* applyRange */.Q5)(newRange);\n}\nfunction isIE() {\n  var ua = window.navigator.userAgent;\n  return (\n    // IE 10 or older\n    ua.indexOf('MSIE ') > 0 ||\n    // IE 11\n    ua.indexOf('Trident/') > 0\n  );\n}\nfunction isCmd(event) {\n  return event.metaKey || event.ctrlKey;\n}\n//# sourceMappingURL=ContentEditable.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/components/EditableComponent.js\n\nfunction EditableComponent_defineProperty(obj, key, value) { key = EditableComponent_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction EditableComponent_toPropertyKey(arg) { var key = EditableComponent_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction EditableComponent_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n/**\n * A base component for interactivity.\n *\n * @example\n *\n * class Foo extends EditableComponent {\n *\n *   render() {\n *     return (\n *       <div>{ this.getEditor() }</div>\n *     );\n *   }\n * }\n *\n * And in use:\n *\n * <Foo value={ blub }\n *      onChange={ (newValue) => { ... }\n *      onFocus={ () => { ... } }\n *      onBlur={ () => { ... } }\n *      validate={ (newValue) => { return 'some-error'; } }\n *      className=\"...\" } />\n *\n * Special classes added:\n *\n * * focused\n * * invalid\n *\n */\nclass EditableComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    EditableComponent_defineProperty(this, \"onFocus\", event => {\n      this.setState({\n        focussed: true\n      });\n      var onFocus = this.props.onFocus;\n      if (typeof onFocus === 'function') {\n        onFocus(event);\n      }\n    });\n    EditableComponent_defineProperty(this, \"onBlur\", event => {\n      this.setState({\n        focussed: false\n      });\n      const invalid = this.state.invalid;\n      if (invalid) {\n        this.setState({\n          changing: false,\n          invalid: false\n        });\n      }\n      const onBlur = this.props.onBlur;\n      if (typeof onBlur === 'function') {\n        onBlur(event);\n      }\n    });\n    this.state = {\n      changing: false,\n      focussed: false\n    };\n    const injector = context.injector;\n    const debounceInput = injector.get('debounceInput');\n    this.inputChanged = debounceInput(value => {\n      const onChange = this.props.onChange;\n      if (typeof onChange === 'function') {\n        onChange(value);\n      }\n\n      // only unset changed if user input and\n      // committed changed value equal. This prevents the\n      // input jumping back to the saved, good value.\n      const currentValue = this.state.changing;\n      this.setState({\n        changing: currentValue === value ? false : currentValue\n      });\n    });\n    this.onInput = value => {\n      var validate = this.props.validate || function () {};\n      var invalid = validate(value);\n      this.setState({\n        changing: value,\n        invalid: invalid\n      });\n      if (!invalid) {\n        this.inputChanged(value);\n      }\n    };\n  }\n  getClassName() {\n    var _this$props = this.props,\n      className = _this$props.className,\n      value = _this$props.value;\n    var _this$state = this.state,\n      changing = _this$state.changing,\n      focussed = _this$state.focussed,\n      invalid = _this$state.invalid;\n    className += ' editable';\n    if (focussed) {\n      className += ' focussed';\n    }\n    if (invalid) {\n      className += ' invalid';\n    }\n    if (!value && !changing) {\n      className += ' empty';\n    }\n    return className;\n  }\n  getDisplayValue() {\n    var _this$props2 = this.props,\n      value = _this$props2.value,\n      placeholder = _this$props2.placeholder;\n    var _this$state2 = this.state,\n      focussed = _this$state2.focussed,\n      changing = _this$state2.changing;\n    if (typeof changing === 'string') {\n      value = changing;\n    }\n    if (!value) {\n      value = focussed ? '' : placeholder || '';\n    }\n    return value;\n  }\n  getEditor() {\n    let props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    return (0,inferno_index_esm/* createComponentVNode */.Iz)(2, ContentEditable, {\n      \"className\": props.className,\n      \"ctrlForNewline\": props.ctrlForNewline,\n      \"onFocus\": this.onFocus,\n      \"onBlur\": this.onBlur,\n      \"onInput\": this.onInput,\n      \"value\": this.getDisplayValue()\n    });\n  }\n}\n//# sourceMappingURL=EditableComponent.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/Cell.js\nvar Cell = __webpack_require__(\"./node_modules/table-js/lib/components/Cell.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/annotations/editor/components/AnnotationCell.js\n\nfunction AnnotationCell_defineProperty(obj, key, value) { key = AnnotationCell_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction AnnotationCell_toPropertyKey(arg) { var key = AnnotationCell_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction AnnotationCell_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nclass EditableAnnotationCell extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    AnnotationCell_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    AnnotationCell_defineProperty(this, \"setAnnotationValue\", text => {\n      const row = this.props.row;\n      this.modeling.editAnnotation(row.businessObject, text);\n    });\n    (0,inject/* inject */.f)(this);\n  }\n  componentWillMount() {\n    const row = this.props.row;\n    this.changeSupport.onElementsChanged(row.id, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    const row = this.props.row;\n    this.changeSupport.offElementsChanged(row.id, this.onElementsChanged);\n  }\n  render() {\n    const _this$props = this.props,\n      row = _this$props.row,\n      rowIndex = _this$props.rowIndex;\n    const _row$businessObject = row.businessObject,\n      description = _row$businessObject.description,\n      id = _row$businessObject.id;\n    return (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Cell/* default */.Z, {\n      \"className\": \"annotation\",\n      \"onChange\": this.setAnnotationValue,\n      \"coords\": \"\".concat(rowIndex, \":annotation\"),\n      \"value\": description,\n      \"elementId\": id,\n      \"data-row-id\": row.id,\n      children: (0,inferno_index_esm/* createComponentVNode */.Iz)(2, AnnotationEditor, {\n        \"ctrlForNewline\": true,\n        \"className\": \"annotation-editor\",\n        \"onChange\": this.setAnnotationValue,\n        \"value\": description\n      })\n    });\n  }\n}\nEditableAnnotationCell.$inject = ['changeSupport', 'modeling'];\nclass AnnotationEditor extends EditableComponent {\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", this.getClassName(), this.getEditor(), 0);\n  }\n}\n//# sourceMappingURL=AnnotationCell.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/annotations/editor/AnnotationsEditingProvider.js\n\n\nfunction AnnotationsEditingProvider(components) {\n  components.onGetComponent('cell', _ref => {\n    let cellType = _ref.cellType;\n    if (cellType === 'after-label-cells') {\n      return AnnotationHeader/* default */.Z;\n    } else if (cellType === 'after-rule-cells') {\n      return EditableAnnotationCell;\n    }\n  });\n}\nAnnotationsEditingProvider.$inject = ['components'];\n//# sourceMappingURL=AnnotationsEditingProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/features/debounce-input/debounceInput.js\n\nconst DEFAULT_DEBOUNCE_TIME = 300;\nfunction debounceInput(shouldDebounce) {\n  return function _debounceInput(fn) {\n    if (shouldDebounce !== false) {\n      var debounceTime = (0,min_dash_dist_index_esm/* isNumber */.hj)(shouldDebounce) ? shouldDebounce : DEFAULT_DEBOUNCE_TIME;\n      return (0,min_dash_dist_index_esm/* debounce */.Ds)(fn, debounceTime);\n    } else {\n      return fn;\n    }\n  };\n}\ndebounceInput.$inject = ['config.debounceInput'];\n//# sourceMappingURL=debounceInput.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/features/debounce-input/index.js\n\n/* harmony default export */ const debounce_input = ({\n  debounceInput: ['factory', debounceInput]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/annotations/editor/index.js\n\n\n/* harmony default export */ const editor = ({\n  __depends__: [debounce_input],\n  __init__: ['annotationsProvider'],\n  annotationsProvider: ['type', AnnotationsEditingProvider]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/features/context-menu/index.js + 2 modules\nvar context_menu = __webpack_require__(\"./node_modules/table-js/lib/features/context-menu/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/keyboard/KeyboardUtil.js\nfunction hasModifier(modifiers) {\n  return modifiers.ctrlKey || modifiers.metaKey || modifiers.shiftKey || modifiers.altKey;\n}\nfunction KeyboardUtil_isCmd(modifiers) {\n  // ensure we don't react to AltGr\n  // (mapped to CTRL + ALT)\n  if (modifiers.altKey) {\n    return false;\n  }\n  return modifiers.ctrlKey || modifiers.metaKey;\n}\nfunction isShift(modifiers) {\n  return modifiers.shiftKey;\n}\n//# sourceMappingURL=KeyboardUtil.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/copy-cut-paste/key-bindings/CopyCutPasteKeyBindings.js\nfunction CopyCutPasteKeyBindings_defineProperty(obj, key, value) { key = CopyCutPasteKeyBindings_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction CopyCutPasteKeyBindings_toPropertyKey(arg) { var key = CopyCutPasteKeyBindings_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction CopyCutPasteKeyBindings_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\n\n/**\n * Keybindings for Copy + Paste\n */\nclass CopyPasteKeyBindings {\n  constructor(injector, eventBus, clipboard, cellSelection, elementRegistry, editorActions, renderer) {\n    CopyCutPasteKeyBindings_defineProperty(this, \"_clearClipboard\", () => {\n      this._clipboard.clear();\n    });\n    CopyCutPasteKeyBindings_defineProperty(this, \"_registerBindings\", () => {\n      // copy\n      // CTRL/CMD + C\n      const copy = (key, modifiers) => {\n        if (KeyboardUtil_isCmd(modifiers) && key === 67) {\n          const cell = this._getSelectedCell();\n          if (!cell) {\n            return;\n          }\n          if (isShift(modifiers)) {\n            this._editorActions.trigger('copy', {\n              element: cell.col\n            });\n          } else {\n            this._editorActions.trigger('copy', {\n              element: cell.row\n            });\n          }\n          return true;\n        }\n      };\n\n      // cut\n      // CTRL/CMD + X\n      const cut = (key, modifiers) => {\n        if (KeyboardUtil_isCmd(modifiers) && key === 88) {\n          const cell = this._getSelectedCell();\n          if (!cell) {\n            return;\n          }\n          if (isShift(modifiers)) {\n            this._editorActions.trigger('cut', {\n              element: cell.col\n            });\n          } else {\n            this._editorActions.trigger('cut', {\n              element: cell.row\n            });\n          }\n          return true;\n        }\n      };\n\n      // paste\n      // CTRL/CMD + V\n      const paste = (key, modifiers) => {\n        let pasted;\n        if (KeyboardUtil_isCmd(modifiers) && key === 86) {\n          const cell = this._getSelectedCell();\n          if (!cell) {\n            return;\n          }\n          if (isShift(modifiers)) {\n            pasted = this._editorActions.trigger('pasteAfter', {\n              element: cell.col\n            });\n            if (pasted) {\n              this._cellSelection.selectCell('right');\n            }\n          } else {\n            pasted = this._editorActions.trigger('pasteAfter', {\n              element: cell.row\n            });\n            if (pasted) {\n              this._cellSelection.selectCell('below');\n            }\n          }\n        }\n\n        // indicate, whether we could paste\n        return typeof pasted !== 'undefined';\n      };\n\n      // register listeners\n      [copy, cut, paste].forEach(l => {\n        this._keyboard.addListener(l);\n      });\n    });\n    this._clipboard = clipboard;\n    this._cellSelection = cellSelection;\n    this._elementRegistry = elementRegistry;\n    this._editorActions = editorActions;\n    this._keyboard = injector.get('keyboard', false);\n    this._renderer = renderer;\n    if (!this._keyboard) {\n      return;\n    }\n    eventBus.on('keyboard.init', this._registerBindings);\n    eventBus.on('keyboard.bind', () => {\n      min_dom_dist_index_esm/* event.bind */.B.bind(document, 'copy', this._clearClipboard, true);\n      min_dom_dist_index_esm/* event.bind */.B.bind(document, 'cut', this._clearClipboard, true);\n    });\n    eventBus.on('keyboard.unbind', () => {\n      min_dom_dist_index_esm/* event.unbind */.B.unbind(document, 'copy', this._clearClipboard, true);\n      min_dom_dist_index_esm/* event.unbind */.B.unbind(document, 'cut', this._clearClipboard, true);\n    });\n  }\n  /**\n   * Return the selected cell within the decision table.\n   *\n   * This verifies that a cell ready for copy-or-paste is\n   * actual selected by the user, in the Browser UI.\n   *\n   * @return {Cell}\n   */\n  _getSelectedCell() {\n    const elementId = this._cellSelection.getCellSelection();\n\n    // we may have no selection\n    if (!elementId) {\n      return;\n    }\n    const cell = this._elementRegistry.get(elementId);\n\n    // selection may not be a cell\n    if (!cell) {\n      return;\n    }\n    const container = this._renderer.getContainer();\n    const node = getNodeById(elementId, container);\n    const focusableNode = getFocusableNode(node);\n\n    // focusable element in selection may not be actual\n    // browser focus, i.e. when a menu is open\n    if (document.activeElement !== focusableNode) {\n      return;\n    }\n    const range = (0,selection_ranges_dist_index_esm/* getRange */.rx)(node);\n\n    // user may attempt native copy-paste operation right now\n    // don't interfere with normal text copying\n    if (range && range.start !== range.end) {\n      return;\n    }\n    return cell;\n  }\n}\nCopyPasteKeyBindings.$inject = ['injector', 'eventBus', 'clipboard', 'cellSelection', 'elementRegistry', 'editorActions', 'renderer'];\n//# sourceMappingURL=CopyCutPasteKeyBindings.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/copy-cut-paste/key-bindings/index.js\n\n\n\n/* harmony default export */ const key_bindings = ({\n  __depends__: [clipboard/* default */.Z, cell_selection],\n  __init__: ['copyCutPasteKeyBindings'],\n  copyCutPasteKeyBindings: ['type', CopyPasteKeyBindings]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/create-inputs/components/CreateInputHeaderCell.js\n\nfunction CreateInputHeaderCell_defineProperty(obj, key, value) { key = CreateInputHeaderCell_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction CreateInputHeaderCell_toPropertyKey(arg) { var key = CreateInputHeaderCell_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction CreateInputHeaderCell_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nclass CreateInputsHeaderCell extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    CreateInputHeaderCell_defineProperty(this, \"onClick\", event => {\n      this.editorActions.trigger('addInput');\n    });\n    (0,inject/* inject */.f)(this);\n  }\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"th\", \"input-cell create-inputs header actionable\", [this.translate('Input'), (0,inferno_index_esm/* createTextVNode */.Uk)(\" \"), (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"add-input dmn-icon-plus action-icon\", null, 1, {\n      \"title\": this.translate('Add Input')\n    })], 0, {\n      \"onClick\": this.onClick,\n      \"title\": this.translate('Add Input')\n    });\n  }\n}\nCreateInputsHeaderCell.$inject = ['editorActions', 'translate'];\n//# sourceMappingURL=CreateInputHeaderCell.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/create-inputs/components/CreateInputCell.js\n\nfunction CreateInputCell_defineProperty(obj, key, value) { key = CreateInputCell_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction CreateInputCell_toPropertyKey(arg) { var key = CreateInputCell_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction CreateInputCell_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nclass CreateInputsCell extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    CreateInputCell_defineProperty(this, \"onClick\", event => {\n      this.editorActions.trigger('addInput');\n    });\n    (0,inject/* inject */.f)(this);\n  }\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", \"input-cell create-inputs\", (0,inferno_index_esm/* createTextVNode */.Uk)(\"-\"), 2, {\n      \"onClick\": this.onClick,\n      \"title\": this.translate('Add Input')\n    });\n  }\n}\nCreateInputsCell.$inject = ['editorActions', 'translate'];\n//# sourceMappingURL=CreateInputCell.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/create-inputs/CreateInputsProvider.js\n\n\nconst CreateInputsProvider_LOW_PRIORITY = 500;\nclass CreateInputsProvider {\n  constructor(components, sheet) {\n    components.onGetComponent('cell', CreateInputsProvider_LOW_PRIORITY, _ref => {\n      let cellType = _ref.cellType;\n      const _sheet$getRoot = sheet.getRoot(),\n        businessObject = _sheet$getRoot.businessObject;\n      if (businessObject.input && businessObject.input.length) {\n        return;\n      }\n      if (cellType === 'before-label-cells') {\n        return CreateInputsHeaderCell;\n      } else if (cellType === 'before-rule-cells') {\n        return CreateInputsCell;\n      }\n    });\n  }\n}\nCreateInputsProvider.$inject = ['components', 'sheet'];\n//# sourceMappingURL=CreateInputsProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/create-inputs/index.js\n\n\n/* harmony default export */ const create_inputs = ({\n  __depends__: [dmn_js_decision_table_lib_features_editor_actions],\n  __init__: ['createInputsProvider'],\n  createInputsProvider: ['type', CreateInputsProvider]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/features/data-types/DataTypes.js\nconst DEFAULT_DATA_TYPES = ['string', 'boolean', 'number', 'date', 'time', 'dateTime', 'dayTimeDuration', 'yearMonthDuration', 'Any'];\n\n/**\n * Provide data types via config.\n *\n * @example\n *\n * // The data types will include multiple number types: integer, long, and double.\n * const editor = new DmnJS({\n *   common: {\n *     dataTypes: [\n *       'string',\n *       'boolean',\n *       'integer',\n *       'long',\n *       'double',\n *       'date'\n *     ]\n *   }\n * })\n */\nclass DataTypes {\n  /**\n   * @param {string[]} configuredDataTypes\n   */\n  constructor(configuredDataTypes) {\n    this._dataTypes = configuredDataTypes || DEFAULT_DATA_TYPES;\n  }\n\n  /**\n   * Get list of configured data types.\n   *\n   * @returns {string[]}\n   */\n  getAll() {\n    return this._dataTypes;\n  }\n}\nDataTypes.$inject = ['config.dataTypes'];\n//# sourceMappingURL=DataTypes.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/features/data-types/index.js\n\n/* harmony default export */ const data_types = ({\n  __init__: ['dataTypes'],\n  dataTypes: ['type', DataTypes]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/context-menu/ContextMenu.js\n\n/* eslint-disable max-len */\n\n\n\nclass ContextMenu {\n  constructor(components, contextMenu, clipboard, editorActions, eventBus, elementRegistry, modeling, selection, sheet, rules, translate) {\n    var _this = this;\n    this._contextMenu = contextMenu;\n    this._clipboard = clipboard;\n    this._editorActions = editorActions;\n    this._elementRegistry = elementRegistry;\n    this._eventBus = eventBus;\n    this._modeling = modeling;\n    this._selection = selection;\n    this._sheet = sheet;\n    this._rules = rules;\n    this._translate = translate;\n    this._getEntries = this._getEntries.bind(this);\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'context-menu') {\n        const entries = _this._getEntries(context);\n        const element = _this._elementRegistry.get(context.id);\n        const additionalCellEntries = isCell(element) && components.getComponents('context-menu-cell-additional', context);\n        if (additionalCellEntries && additionalCellEntries.length) {\n          const cellEntriesGroup = (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group context-menu-group-cell\", additionalCellEntries, 0);\n          return () => (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-flex\", (entries || []).concat(cellEntriesGroup), 0);\n        } else {\n          return () => (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-flex\", entries || [], 0);\n        }\n      }\n    });\n    eventBus.on('cell.contextmenu', _ref => {\n      let event = _ref.event,\n        id = _ref.id,\n        node = _ref.node;\n      event.preventDefault();\n      contextMenu.open({\n        x: event.pageX,\n        y: event.pageY\n      }, {\n        contextMenuType: 'context-menu',\n        event,\n        id\n      });\n    });\n  }\n  _getEntries(context) {\n    const handlers = {\n      addRuleAbove: rule => {\n        const selectedIndex = rule.cells.map(cell => cell.id).indexOf(context.id);\n        const newRule = this._editorActions.trigger('addRuleAbove', {\n          rule\n        });\n        if (newRule.cells[selectedIndex]) {\n          this._selection.select(newRule.cells[selectedIndex]);\n        } else {\n          this._selection.select(newRule.cells[0]);\n        }\n        this._contextMenu.close();\n      },\n      addRuleBelow: rule => {\n        const selectedIndex = rule.cells.map(cell => cell.id).indexOf(context.id);\n        const newRule = this._editorActions.trigger('addRuleBelow', {\n          rule\n        });\n        if (newRule.cells[selectedIndex]) {\n          this._selection.select(newRule.cells[selectedIndex]);\n        } else {\n          this._selection.select(newRule.cells[0]);\n        }\n        this._contextMenu.close();\n      },\n      removeRule: rule => {\n        this._editorActions.trigger('removeRule', {\n          rule\n        });\n        this._contextMenu.close();\n      },\n      addInputLeft: input => {\n        this._editorActions.trigger('addInputLeft', {\n          input\n        });\n        this._contextMenu.close();\n      },\n      addInputRight: input => {\n        this._editorActions.trigger('addInputRight', {\n          input\n        });\n        this._contextMenu.close();\n      },\n      removeInput: input => {\n        this._editorActions.trigger('removeInput', {\n          input\n        });\n        this._contextMenu.close();\n      },\n      addOutputLeft: output => {\n        this._editorActions.trigger('addOutputLeft', {\n          output\n        });\n        this._contextMenu.close();\n      },\n      addOutputRight: output => {\n        this._editorActions.trigger('addOutputRight', {\n          output\n        });\n        this._contextMenu.close();\n      },\n      removeOutput: output => {\n        this._editorActions.trigger('removeOutput', {\n          output\n        });\n        this._contextMenu.close();\n      },\n      copy: element => {\n        this._editorActions.trigger('copy', {\n          element\n        });\n        this._contextMenu.close();\n      },\n      cut: element => {\n        this._editorActions.trigger('cut', {\n          element\n        });\n        this._contextMenu.close();\n      },\n      pasteBefore: element => {\n        this._editorActions.trigger('pasteBefore', {\n          element\n        });\n        this._contextMenu.close();\n      },\n      pasteAfter: element => {\n        this._editorActions.trigger('pasteAfter', {\n          element\n        });\n        this._contextMenu.close();\n      }\n    };\n    const id = context && context.id;\n    if (!id) {\n      return null;\n    }\n    const element = this._elementRegistry.get(id);\n    if (!element) {\n      return null;\n    }\n    const clipboardData = this._clipboard.get() || {};\n    const entries = [];\n    const row = element.row || element;\n    if ((0,ModelUtil.is)(row, 'dmn:DecisionRule')) {\n      const canPaste = this._rules.allowed('paste', {\n        data: clipboardData.elements,\n        target: row\n      });\n      entries.push((0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-copy-rule\", this._translate('Copy Rule'), 0, {\n        \"onClick\": () => handlers.copy(row)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-cut-rule\", this._translate('Cut Rule'), 0, {\n        \"onClick\": () => handlers.cut(row)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canPaste ? '' : 'disabled', \" context-menu-entry-paste-rule-above\"), this._translate('Paste Rule Above'), 0, {\n        \"onClick\": () => handlers.pasteBefore(row)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canPaste ? '' : 'disabled', \" context-menu-entry-paste-rule-below\"), this._translate('Paste Rule Below'), 0, {\n        \"onClick\": () => handlers.pasteAfter(row)\n      })], 4), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-add-rule-above\", this._translate('Add Rule Above'), 0, {\n        \"onClick\": () => handlers.addRuleAbove(row)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-add-rule-below\", this._translate('Add Rule Below'), 0, {\n        \"onClick\": () => handlers.addRuleBelow(row)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-remove-rule\", this._translate('Remove Rule'), 0, {\n        \"onClick\": () => handlers.removeRule(row)\n      })], 4));\n    } else if ((0,ModelUtil.is)(element, 'dmn:InputClause')) {\n      const actualElement = (0,ModelUtil.is)(element, 'dmn:InputClause') ? element : element.col;\n      const canRemove = this._rules.allowed('col.remove', {\n        col: element.col || element\n      });\n      const canPaste = this._rules.allowed('paste', {\n        data: clipboardData.elements,\n        target: element.col || element\n      });\n      entries.push((0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-copy-input\", this._translate('Copy Input Column'), 0, {\n        \"onClick\": () => handlers.copy(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canRemove ? '' : 'disabled', \" context-menu-entry-cut-input\"), this._translate('Cut Input Column'), 0, {\n        \"onClick\": () => handlers.cut(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canPaste ? '' : 'disabled', \" context-menu-entry-paste-input-left\"), this._translate('Paste Input Column Left'), 0, {\n        \"onClick\": () => handlers.pasteBefore(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canPaste ? '' : 'disabled', \" context-menu-entry-paste-input-right\"), this._translate('Paste Input Column Right'), 0, {\n        \"onClick\": () => handlers.pasteAfter(actualElement)\n      })], 4), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-add-input-left\", this._translate('Add Input Column Left'), 0, {\n        \"onClick\": () => handlers.addInputLeft(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-add-input-right\", this._translate('Add Input Column Right'), 0, {\n        \"onClick\": () => handlers.addInputRight(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canRemove ? '' : 'disabled', \" context-menu-entry-remove-input\"), this._translate('Remove Input Column'), 0, {\n        \"onClick\": () => handlers.removeInput(actualElement)\n      })], 4));\n    } else if ((0,ModelUtil.is)(element, 'dmn:OutputClause') || (0,ModelUtil.is)(element.col, 'dmn:OutputClause')) {\n      const actualElement = (0,ModelUtil.is)(element, 'dmn:OutputClause') ? element : element.col;\n      const canRemove = this._rules.allowed('col.remove', {\n        col: element.col || element\n      });\n      const canPaste = this._rules.allowed('paste', {\n        data: clipboardData.elements,\n        target: element.col || element\n      });\n      entries.push((0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-copy-output\", this._translate('Copy Output Column'), 0, {\n        \"onClick\": () => handlers.copy(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canRemove ? '' : 'disabled', \" context-menu-entry-cut-output\"), this._translate('Cut Output Column'), 0, {\n        \"onClick\": () => handlers.cut(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canPaste ? '' : 'disabled', \" context-menu-entry-paste-output-left\"), this._translate('Paste Output Column Left'), 0, {\n        \"onClick\": () => handlers.pasteBefore(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canPaste ? '' : 'disabled', \" context-menu-entry-paste-output-right\"), this._translate('Paste Output Column Right'), 0, {\n        \"onClick\": () => handlers.pasteAfter(actualElement)\n      })], 4), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-add-output-left\", this._translate('Add Output Column Left'), 0, {\n        \"onClick\": () => handlers.addOutputLeft(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry context-menu-entry-add-output-right\", this._translate('Add Output Column Right'), 0, {\n        \"onClick\": () => handlers.addOutputRight(actualElement)\n      }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(canRemove ? '' : 'disabled', \" context-menu-entry-remove-output\"), this._translate('Remove Output Column'), 0, {\n        \"onClick\": () => handlers.removeOutput(actualElement)\n      })], 4));\n    }\n    return entries;\n  }\n}\nContextMenu.$inject = ['components', 'contextMenu', 'clipboard', 'editorActions', 'eventBus', 'elementRegistry', 'modeling', 'selection', 'sheet', 'rules', 'translate'];\n\n// helpers ///////////\n\nfunction isCell(element) {\n  return element instanceof model/* Cell */.bL;\n}\n//# sourceMappingURL=ContextMenu.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/context-menu/ContextMenuCloseBehavior.js\nconst COMMANDS = ['row.add', 'row.remove', 'col.add', 'col.remove'];\nclass ContextMenuCloseBehavior {\n  constructor(contextMenu, eventBus) {\n    eventBus.on('commandStack.executed', _ref => {\n      let command = _ref.command;\n      // close on certain modeling operations\n      if (COMMANDS.indexOf(command) !== -1) {\n        contextMenu.close();\n      }\n    });\n\n    // always close on undo\n    eventBus.on('commandStack.reverted', () => {\n      contextMenu.close();\n    });\n  }\n}\nContextMenuCloseBehavior.$inject = ['contextMenu', 'eventBus'];\n//# sourceMappingURL=ContextMenuCloseBehavior.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/context-menu/index.js\n\n\n\n\n\n/* harmony default export */ const features_context_menu = ({\n  __depends__: [dmn_js_decision_table_lib_features_editor_actions, context_menu/* default */.Z, dmn_js_decision_table_lib_features_rules],\n  __init__: ['decisionTableContextMenu', 'contextMenuCloseBehavior'],\n  decisionTableContextMenu: ['type', ContextMenu],\n  contextMenuCloseBehavior: ['type', ContextMenuCloseBehavior]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/features/expression-languages/index.js + 1 modules\nvar expression_languages = __webpack_require__(\"./node_modules/dmn-js-shared/lib/features/expression-languages/index.js\");\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/utils/mixin.js\nvar mixin = __webpack_require__(\"./node_modules/table-js/lib/components/utils/mixin.js\");\n// EXTERNAL MODULE: ./node_modules/dmn-js-shared/lib/components/mixins/index.js + 1 modules\nvar mixins = __webpack_require__(\"./node_modules/dmn-js-shared/lib/components/mixins/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/editor/components/OutputCell.js\n\nfunction OutputCell_defineProperty(obj, key, value) { key = OutputCell_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction OutputCell_toPropertyKey(arg) { var key = OutputCell_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction OutputCell_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nclass OutputCell extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    OutputCell_defineProperty(this, \"onClick\", event => {\n      const output = this.props.output;\n      this._eventBus.fire('output.edit', {\n        event,\n        output\n      });\n    });\n    OutputCell_defineProperty(this, \"onContextmenu\", event => {\n      const id = this.props.output.id;\n      this._eventBus.fire('cell.contextmenu', {\n        event,\n        id\n      });\n    });\n    OutputCell_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    (0,mixin/* default */.Z)(this, mixins/* ComponentWithSlots */.t);\n    this._translate = context.injector.get('translate');\n  }\n  componentWillMount() {\n    const injector = this.context.injector;\n    this._changeSupport = this.context.changeSupport;\n    this._eventBus = injector.get('eventBus');\n    this._elementRegistry = injector.get('elementRegistry');\n    const output = this.props.output;\n    this._changeSupport.onElementsChanged(output.id, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    const output = this.props.output;\n    this._changeSupport.offElementsChanged(output.id, this.onElementsChanged);\n  }\n  render() {\n    const _this$props = this.props,\n      output = _this$props.output,\n      index = _this$props.index,\n      outputsLength = _this$props.outputsLength;\n    const label = output.label,\n      name = output.name,\n      outputValues = output.outputValues,\n      typeRef = output.typeRef;\n    const width = output.width ? output.width + 'px' : '192px';\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"th\", \"output-cell output-editor\", [this.slotFills({\n      type: 'cell-inner',\n      context: {\n        cellType: 'output-cell',\n        col: this._elementRegistry.get(output.id),\n        index,\n        outputsLength\n      },\n      col: output\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"clause\", index === 0 ? this._translate('Then') : this._translate('And'), 0), label ? (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"output-label\", label, 0, {\n      \"title\": this._translate('Output Label: ') + label\n    }) : (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"output-name\", name, 0, {\n      \"title\": this._translate('Output Name: ') + name\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"output-variable\", outputValues && outputValues.text || this._translate(typeRef || ''), 0, {\n      \"title\": outputValues && outputValues.text ? this._translate('Output Values') : this._translate('Output Type')\n    })], 0, {\n      \"data-col-id\": output.id,\n      \"onDblClick\": this.onClick,\n      \"onContextmenu\": this.onContextmenu,\n      \"style\": {\n        width\n      }\n    });\n  }\n}\n//# sourceMappingURL=OutputCell.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/components/Input.js\n\nfunction Input_defineProperty(obj, key, value) { key = Input_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction Input_toPropertyKey(arg) { var key = Input_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction Input_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nclass Input extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    Input_defineProperty(this, \"onInput\", event => {\n      const onInput = this.props.onInput;\n      if (typeof onInput !== 'function') {\n        return;\n      }\n      onInput(event.target.value);\n    });\n    Input_defineProperty(this, \"onKeyDown\", event => {\n      const onKeyDown = this.props.onKeyDown;\n      if (typeof onKeyDown !== 'function') {\n        return;\n      }\n      onKeyDown(event);\n    });\n    Input_defineProperty(this, \"onKeyUp\", event => {\n      const onKeyUp = this.props.onKeyUp;\n      if (typeof onKeyUp !== 'function') {\n        return;\n      }\n      onKeyUp(event);\n    });\n  }\n  render() {\n    const _this$props = this.props,\n      className = _this$props.className,\n      placeholder = _this$props.placeholder,\n      type = _this$props.type,\n      value = _this$props.value;\n    return (0,inferno_index_esm/* createVNode */.Wm)(64, \"input\", [className || '', 'dms-input'].join(' '), null, 1, {\n      \"placeholder\": placeholder || '',\n      \"onInput\": this.onInput,\n      \"onKeyDown\": this.onKeyDown,\n      \"onKeyUp\": this.onKeyUp,\n      \"spellcheck\": \"false\",\n      \"type\": type || 'text',\n      \"value\": value\n    });\n  }\n}\n//# sourceMappingURL=Input.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/editor/components/OutputEditor.js\n\n\n\n\nclass OutputEditor extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this.translate = context.injector ? context.injector.get('translate') : noopTranslate;\n    this.setName = name => {\n      name = name || undefined;\n      this.handleChange({\n        name\n      });\n    };\n    this.setLabel = label => {\n      label = label || undefined;\n      this.handleChange({\n        label\n      });\n    };\n  }\n  handleChange(changes) {\n    var onChange = this.props.onChange;\n    if (typeof onChange === 'function') {\n      onChange(changes);\n    }\n  }\n  render() {\n    const _this$props = this.props,\n      name = _this$props.name,\n      label = _this$props.label;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container ref-output-editor output-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-form-control\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, ContentEditable, {\n      \"className\": \"dms-output-label\",\n      \"value\": label || '',\n      \"placeholder\": this.translate('Output'),\n      \"singleLine\": true,\n      \"onInput\": this.setLabel\n    }), 2), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-form-control\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"label\", \"dms-label\", this.translate('Output Name'), 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Input, {\n      \"className\": \"ref-output-name\",\n      \"value\": name || '',\n      \"onInput\": this.setName\n    })], 4)], 4);\n  }\n}\nfunction noopTranslate(str) {\n  return str;\n}\n//# sourceMappingURL=OutputEditor.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/editor/components/OutputCellContextMenu.js\n\nfunction OutputCellContextMenu_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction OutputCellContextMenu_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? OutputCellContextMenu_ownKeys(Object(source), !0).forEach(function (key) { OutputCellContextMenu_defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : OutputCellContextMenu_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction OutputCellContextMenu_defineProperty(obj, key, value) { key = OutputCellContextMenu_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction OutputCellContextMenu_toPropertyKey(arg) { var key = OutputCellContextMenu_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction OutputCellContextMenu_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nclass OutputCellContextMenu extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    OutputCellContextMenu_defineProperty(this, \"persistChanges\", () => {\n      const output = this.props.context.output;\n      const unsaved = this.state.unsaved;\n      if (!unsaved) {\n        return;\n      }\n      this.modeling.updateProperties(output, unsaved);\n      this.setState({\n        unsaved: false\n      });\n    });\n    OutputCellContextMenu_defineProperty(this, \"handleChange\", changes => {\n      this.setState({\n        unsaved: OutputCellContextMenu_objectSpread(OutputCellContextMenu_objectSpread({}, this.state.unsaved), changes)\n      }, this.persistChanges);\n    });\n    this.state = {};\n    (0,inject/* inject */.f)(this);\n    this.persistChanges = this.debounceInput(this.persistChanges);\n  }\n  getValue(attr) {\n    const output = this.props.context.output;\n    const unsaved = this.state.unsaved;\n    return unsaved && attr in unsaved ? unsaved[attr] : output.get(attr);\n  }\n  render() {\n    return (0,inferno_index_esm/* createComponentVNode */.Iz)(2, OutputEditor, {\n      \"name\": this.getValue('name'),\n      \"label\": this.getValue('label'),\n      \"onChange\": this.handleChange\n    });\n  }\n}\nOutputCellContextMenu.$inject = ['debounceInput', 'modeling'];\n//# sourceMappingURL=OutputCellContextMenu.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/editor/OutputEditingProvider.js\n\n\n\nclass OutputEditingProvider {\n  constructor(components, contextMenu, eventBus, renderer) {\n    components.onGetComponent('cell', _ref => {\n      let cellType = _ref.cellType;\n      if (cellType === 'output-header') {\n        return OutputCell;\n      }\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType === 'output-edit') {\n        return OutputCellContextMenu;\n      }\n    });\n    eventBus.on('output.edit', _ref2 => {\n      let event = _ref2.event,\n        output = _ref2.output;\n      const target = event.target;\n      const node = (0,min_dom_dist_index_esm/* closest */.oq)(target, 'th', true);\n      const _node$getBoundingClie = node.getBoundingClientRect(),\n        left = _node$getBoundingClie.left,\n        top = _node$getBoundingClie.top;\n      const offset = getOffset(node);\n      contextMenu.open({\n        x: left,\n        y: top,\n        align: 'bottom-right'\n      }, {\n        contextMenuType: 'output-edit',\n        output,\n        offset\n      });\n    });\n  }\n}\nOutputEditingProvider.$inject = ['components', 'contextMenu', 'eventBus', 'renderer'];\nfunction getOffset(element) {\n  if (!(0,min_dom_dist_index_esm/* matches */.wB)(element, '.output-cell + .output-cell')) {\n    return {\n      x: -1,\n      y: 0\n    };\n  }\n}\n//# sourceMappingURL=OutputEditingProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/editor/components/InputCell.js\n\nfunction InputCell_defineProperty(obj, key, value) { key = InputCell_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction InputCell_toPropertyKey(arg) { var key = InputCell_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction InputCell_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nclass InputCell extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    InputCell_defineProperty(this, \"onClick\", event => {\n      const input = this.props.input;\n      this._eventBus.fire('input.edit', {\n        event,\n        input\n      });\n    });\n    InputCell_defineProperty(this, \"onContextmenu\", event => {\n      const id = this.props.input.id;\n      this._eventBus.fire('cell.contextmenu', {\n        event,\n        id\n      });\n    });\n    InputCell_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    (0,mixin/* default */.Z)(this, mixins/* ComponentWithSlots */.t);\n    this._translate = context.injector.get('translate');\n  }\n  componentWillMount() {\n    const injector = this.context.injector;\n    this._changeSupport = this.context.changeSupport;\n    this._sheet = injector.get('sheet');\n    this._eventBus = injector.get('eventBus');\n    this._elementRegistry = injector.get('elementRegistry');\n    const root = this._sheet.getRoot();\n    const input = this.props.input;\n    this._changeSupport.onElementsChanged(root.id, this.onElementsChanged);\n    this._changeSupport.onElementsChanged(input.id, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    const root = this._sheet.getRoot();\n    const input = this.props.input;\n    this._changeSupport.offElementsChanged(root.id, this.onElementsChanged);\n    this._changeSupport.offElementsChanged(input.id, this.onElementsChanged);\n  }\n  render() {\n    const _this$props = this.props,\n      input = _this$props.input,\n      index = _this$props.index,\n      inputsLength = _this$props.inputsLength;\n    const inputExpression = input.inputExpression,\n      inputValues = input.inputValues;\n    const label = input.get('label');\n    const width = input.width ? input.width + 'px' : '192px';\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"th\", \"input-cell input-editor\", [this.slotFills({\n      type: 'cell-inner',\n      context: {\n        cellType: 'input-cell',\n        col: this._elementRegistry.get(input.id),\n        index,\n        inputsLength\n      },\n      col: input\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"clause\", index === 0 ? this._translate('When') : this._translate('And'), 0), label ? (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"input-label\", label, 0, {\n      \"title\": this._translate('Input Label: ') + label\n    }) : (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"input-expression\", inputExpression.text, 0, {\n      \"title\": this._translate('Input Expression: ') + inputExpression.text\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"input-variable\", inputValues && inputValues.text || this._translate(inputExpression.typeRef || ''), 0, {\n      \"title\": inputValues && inputValues.text ? this._translate('Input Values') : this._translate('Input Type')\n    })], 0, {\n      \"data-col-id\": input.id,\n      \"onDblClick\": this.onClick,\n      \"onContextmenu\": this.onContextmenu,\n      \"style\": {\n        width\n      }\n    });\n  }\n}\n//# sourceMappingURL=InputCell.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/editor/components/InputEditor.js\n\n\n\nclass InputEditor extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this.translate = context.injector ? context.injector.get('translate') : InputEditor_noopTranslate;\n    this.handleValue = text => {\n      let change = {\n        text\n      };\n      this.handleChange(change);\n    };\n    this.handleLabelChange = value => {\n      // default to <undefined> for empty string\n      var label = value || undefined;\n      this.handleChange({\n        label\n      });\n    };\n  }\n  handleChange(changes) {\n    var onChange = this.props.onChange;\n    if (typeof onChange === 'function') {\n      onChange(changes);\n    }\n  }\n  render() {\n    const _this$props = this.props,\n      label = _this$props.label,\n      text = _this$props.text;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container ref-input-editor input-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-form-control\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, ContentEditable, {\n      \"className\": \"dms-input-label\",\n      \"value\": label || '',\n      \"placeholder\": this.translate('Input'),\n      \"singleLine\": true,\n      \"onInput\": this.handleLabelChange\n    }), 2), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-form-control\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"label\", \"dms-label\", this.translate('Expression'), 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, ContentEditable, {\n      \"placeholder\": this.translate('enter expression'),\n      \"className\": ['ref-text', 'dms-input'].join(' '),\n      \"onInput\": this.handleValue,\n      \"value\": text || ''\n    })], 4)], 4);\n  }\n}\nfunction InputEditor_noopTranslate(str) {\n  return str;\n}\n//# sourceMappingURL=InputEditor.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/editor/components/InputCellContextMenu.js\nconst _excluded = [\"label\"];\n\nfunction InputCellContextMenu_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction InputCellContextMenu_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? InputCellContextMenu_ownKeys(Object(source), !0).forEach(function (key) { InputCellContextMenu_defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : InputCellContextMenu_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }\nfunction _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\nfunction InputCellContextMenu_defineProperty(obj, key, value) { key = InputCellContextMenu_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction InputCellContextMenu_toPropertyKey(arg) { var key = InputCellContextMenu_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction InputCellContextMenu_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nclass InputCellContextMenu extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    InputCellContextMenu_defineProperty(this, \"persistChanges\", () => {\n      const input = this.props.context.input;\n      const unsaved = this.state.unsaved;\n      if (!unsaved) {\n        return;\n      }\n      const label = unsaved.label,\n        inputExpressionProperties = _objectWithoutProperties(unsaved, _excluded);\n      var changes = {};\n      if ('label' in unsaved) {\n        changes.label = label;\n      }\n      if (hasKeys(inputExpressionProperties)) {\n        changes.inputExpression = inputExpressionProperties;\n      }\n      this.modeling.updateProperties(input, changes);\n      this.setState({\n        unsaved: false\n      });\n    });\n    InputCellContextMenu_defineProperty(this, \"handleChange\", changes => {\n      this.setState({\n        unsaved: InputCellContextMenu_objectSpread(InputCellContextMenu_objectSpread({}, this.state.unsaved), changes)\n      }, this.persistChanges);\n    });\n    this.state = {};\n    (0,inject/* inject */.f)(this);\n    this.persistChanges = this.debounceInput(this.persistChanges);\n  }\n  getValue(attr) {\n    let input = this.props.context.input;\n    const unsaved = this.state.unsaved;\n    let target = input;\n\n    // input variable stored in parent\n    if (attr === 'text') {\n      target = target.inputExpression;\n    }\n    return unsaved && attr in unsaved ? unsaved[attr] : target.get(attr);\n  }\n  render() {\n    return (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputEditor, {\n      \"label\": this.getValue('label'),\n      \"text\": this.getValue('text'),\n      \"onChange\": this.handleChange\n    });\n  }\n}\nInputCellContextMenu.$inject = ['debounceInput', 'modeling', 'injector'];\n\n// helpers //////////////////////\n\nfunction hasKeys(obj) {\n  return Object.keys(obj).length;\n}\n//# sourceMappingURL=InputCellContextMenu.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/editor/InputEditingProvider.js\n\n\n\nclass InputCellProvider {\n  constructor(components, contextMenu, eventBus, renderer) {\n    components.onGetComponent('cell', _ref => {\n      let cellType = _ref.cellType;\n      if (cellType === 'input-header') {\n        return InputCell;\n      }\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType === 'input-edit') {\n        return InputCellContextMenu;\n      }\n    });\n    eventBus.on('input.edit', _ref2 => {\n      let event = _ref2.event,\n        input = _ref2.input;\n      const target = event.target;\n      const node = (0,min_dom_dist_index_esm/* closest */.oq)(target, 'th', true);\n      const _node$getBoundingClie = node.getBoundingClientRect(),\n        left = _node$getBoundingClie.left,\n        top = _node$getBoundingClie.top;\n      contextMenu.open({\n        x: left,\n        y: top,\n        align: 'bottom-right'\n      }, {\n        contextMenuType: 'input-edit',\n        input\n      });\n    });\n  }\n}\nInputCellProvider.$inject = ['components', 'contextMenu', 'eventBus', 'renderer'];\n//# sourceMappingURL=InputEditingProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/components/InputSelect.js\n\nfunction InputSelect_defineProperty(obj, key, value) { key = InputSelect_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction InputSelect_toPropertyKey(arg) { var key = InputSelect_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction InputSelect_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\nclass InputSelect extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    InputSelect_defineProperty(this, \"onChange\", value => {\n      this.setState({\n        value\n      });\n      const onChange = this.props.onChange;\n      if (typeof onChange !== 'function') {\n        return;\n      }\n      onChange(value);\n    });\n    InputSelect_defineProperty(this, \"onInputClick\", event => {\n      event.preventDefault();\n      event.stopPropagation();\n      this.setOptionsVisible(!this.state.optionsVisible);\n      this.focusInput();\n    });\n    InputSelect_defineProperty(this, \"onInput\", event => {\n      const value = event.target.value;\n      this.onChange(value);\n    });\n    InputSelect_defineProperty(this, \"onOptionClick\", (value, event) => {\n      event.preventDefault();\n      event.stopPropagation();\n      this.setOptionsVisible(false);\n      this.onChange(value);\n      this.focusInput();\n    });\n    InputSelect_defineProperty(this, \"onFocusChanged\", evt => {\n      this.checkClose(evt.target);\n    });\n    InputSelect_defineProperty(this, \"onGlobalClick\", evt => {\n      this.checkClose(evt.target);\n    });\n    InputSelect_defineProperty(this, \"onKeyDown\", evt => {\n      const optionsVisible = this.state.optionsVisible;\n      var code = evt.which;\n\n      // DOWN or UP\n      if (code === 40 || code === 38) {\n        evt.stopPropagation();\n        evt.preventDefault();\n        if (!optionsVisible) {\n          this.setOptionsVisible(true);\n        } else {\n          this.select(code === 40 ? 1 : -1);\n        }\n      }\n      if (optionsVisible) {\n        // ENTER\n        // ESC\n        if (code === 13 || code === 27) {\n          evt.stopPropagation();\n          evt.preventDefault();\n          this.setOptionsVisible(false);\n        }\n      }\n    });\n    InputSelect_defineProperty(this, \"onKeyboard\", keycode => {\n      const optionsVisible = this.state.optionsVisible;\n      if (!optionsVisible) {\n        return;\n      }\n\n      // close on ESC\n      if (keycode === 27) {\n        this.setOptionsVisible(false);\n        return true;\n      }\n    });\n    (0,inject/* inject */.f)(this);\n    const _value = props.value;\n    this.state = {\n      value: _value,\n      optionsVisible: false\n    };\n    this._portalEl = null;\n  }\n  componentDidMount() {\n    document.addEventListener('mousedown', this.onGlobalClick);\n    document.addEventListener('focusin', this.onFocusChanged);\n    this.keyboard.addListener(this.onKeyboard);\n  }\n  componentWillUnmount() {\n    document.removeEventListener('focusin', this.onFocusChanged);\n    document.removeEventListener('mousedown', this.onGlobalClick);\n    this.keyboard.removeListener(this.onKeyboard);\n    this.removePortalEl();\n  }\n  componentWillReceiveProps(props) {\n    const value = props.value;\n    this.setState({\n      value\n    });\n  }\n  componentWillUpdate(nextProps, nextState) {\n    const optionsVisible = nextState.optionsVisible;\n    if (optionsVisible) {\n      if (!this._portalEl) {\n        this.addPortalEl();\n      }\n    } else {\n      if (this._portalEl) {\n        this.removePortalEl();\n      }\n    }\n  }\n  componentDidUpdate() {\n    const optionsVisible = this.state.optionsVisible;\n    if (!optionsVisible || !this.inputNode) {\n      return;\n    }\n    const optionsBounds = this.getOptionsBounds();\n    (0,min_dash_dist_index_esm/* assign */.f0)(this._portalEl.style, optionsBounds);\n  }\n  getOptionsBounds() {\n    const container = this.renderer.getContainer();\n    const _container$getBoundin = container.getBoundingClientRect(),\n      containerTop = _container$getBoundin.top,\n      containerLeft = _container$getBoundin.left,\n      containerBottom = _container$getBoundin.bottom;\n    const _this$inputNode$getBo = this.inputNode.getBoundingClientRect(),\n      inputTop = _this$inputNode$getBo.top,\n      inputLeft = _this$inputNode$getBo.left,\n      width = _this$inputNode$getBo.width,\n      height = _this$inputNode$getBo.height,\n      inputBottom = _this$inputNode$getBo.bottom;\n    const top = inputTop + height - containerTop + container.scrollTop;\n    const left = inputLeft - containerLeft + container.scrollLeft;\n    const bounds = {\n      top: \"\".concat(top, \"px\"),\n      left: \"\".concat(left, \"px\"),\n      width: \"\".concat(width, \"px\"),\n      'max-height': \"calc(100% - \".concat(top, \"px)\")\n    };\n\n    // open the options upwards when not even one option (=input height) fits\n    if (containerBottom - inputBottom < height) {\n      const bottom = containerBottom - inputTop;\n      bounds.bottom = \"\".concat(bottom, \"px\");\n      bounds['max-height'] = \"calc(100% - \".concat(bottom, \")\");\n      delete bounds.top;\n    }\n    return bounds;\n  }\n  addPortalEl() {\n    this._portalEl = (0,min_dom_dist_index_esm/* domify */.H6)('<div class=\"dms-select-options\"></div>');\n    const container = this.renderer.getContainer();\n    container.appendChild(this._portalEl);\n\n    // suppress mousedown event propagation to handle click events inside the component\n    this._portalEl.addEventListener('mousedown', stopPropagation);\n  }\n  removePortalEl() {\n    if (this._portalEl) {\n      this._portalEl.removeEventListener('mousedown', stopPropagation);\n      (0,min_dom_dist_index_esm/* remove */.Od)(this._portalEl);\n      this._portalEl = null;\n    }\n  }\n  /**\r\n   * Focus input node\r\n   */\n  focusInput() {\n    const node = this.inputNode;\n    node.focus();\n\n    // move cursor to end of input\n    if ('selectionStart' in node) {\n      node.selectionStart = 100000;\n    }\n  }\n  checkClose(focusTarget) {\n    if (this._portalEl && !this._portalEl.contains(focusTarget) && !this.parentNode.contains(focusTarget)) {\n      this.setOptionsVisible(false);\n    }\n  }\n  select(direction) {\n    const options = this.props.options;\n    const value = this.state.value;\n    if (!options) {\n      return;\n    }\n    const option = options.filter(o => o.value === value)[0];\n    const idx = option ? options.indexOf(option) : -1;\n    const nextIdx = idx === -1 ? direction === 1 ? 0 : options.length - 1 : (idx + direction) % options.length;\n    const nextOption = options[nextIdx < 0 ? options.length + nextIdx : nextIdx];\n    this.onChange(nextOption.value);\n  }\n  setOptionsVisible(optionsVisible) {\n    this.setState({\n      optionsVisible\n    });\n  }\n  renderOptions(options, activeOption) {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"options\", options.map(option => {\n      return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", ['option', activeOption === option ? 'active' : ''].join(' '), option.label, 0, {\n        \"data-value\": option.value,\n        \"onClick\": e => this.onOptionClick(option.value, e)\n      });\n    }), 0);\n  }\n  render() {\n    const _this$props = this.props,\n      className = _this$props.className,\n      options = _this$props.options,\n      noInput = _this$props.noInput,\n      title = _this$props.title;\n    const _this$state = this.state,\n      optionsVisible = _this$state.optionsVisible,\n      value = _this$state.value;\n    const option = options ? options.filter(o => o.value === value)[0] : false;\n    const label = option ? option.label : value;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", [className || '', 'dms-input-select'].join(' '), [noInput ? (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-input\", label, 0, {\n      \"tabindex\": \"0\",\n      \"onKeyDown\": this.onKeyDown\n    }, null, node => this.inputNode = node) : (0,inferno_index_esm/* createVNode */.Wm)(64, \"input\", \"dms-input\", null, 1, {\n      \"onInput\": this.onInput,\n      \"onKeyDown\": this.onKeyDown,\n      \"spellcheck\": \"false\",\n      \"type\": \"text\",\n      \"value\": value\n    }, null, node => this.inputNode = node), (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", ['dms-input-select-icon', optionsVisible ? 'dmn-icon-up' : 'dmn-icon-down'].join(' ')), optionsVisible && (0,inferno_index_esm/* createPortal */.jz)(this.renderOptions(options, option), this._portalEl)], 0, {\n      \"title\": title,\n      \"onClick\": this.onInputClick\n    }, null, node => this.parentNode = node);\n  }\n}\nInputSelect.$inject = ['keyboard', 'renderer'];\n\n// helper ////\nfunction stopPropagation(event) {\n  event.stopPropagation();\n}\n//# sourceMappingURL=InputSelect.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/type-ref/components/TypeRefCellContextMenu.js\n\nfunction TypeRefCellContextMenu_defineProperty(obj, key, value) { key = TypeRefCellContextMenu_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction TypeRefCellContextMenu_toPropertyKey(arg) { var key = TypeRefCellContextMenu_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction TypeRefCellContextMenu_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nclass TypeRefCellContextMenu extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props);\n    TypeRefCellContextMenu_defineProperty(this, \"onTypeChange\", value => {\n      const element = this.getElement();\n      const actualElement = (0,ModelUtil.is)(element, 'dmn:LiteralExpression') ? element.$parent : element;\n      let newProperties;\n      if ((0,ModelUtil/* isInput */.u7)(actualElement)) {\n        newProperties = {\n          inputExpression: {\n            typeRef: value\n          }\n        };\n      } else if ((0,ModelUtil/* isOutput */.RW)(actualElement)) {\n        newProperties = {\n          typeRef: value\n        };\n      }\n      this._modeling.updateProperties(actualElement, newProperties);\n    });\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    this._dataTypes = context.injector.get('dataTypes');\n  }\n  getElement() {\n    return this.props.context.input || this.props.context.output;\n  }\n  render() {\n    const element = this.getElement();\n    const typeRef = ((0,ModelUtil.is)(element, 'dmn:InputClause') ? element.inputExpression : element).typeRef;\n    const typeRefOptions = this._dataTypes.getAll().map(t => {\n      return {\n        label: this._translate(t),\n        value: t\n      };\n    });\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"type-ref-edit context-menu-container\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-form-control\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"label\", \"dms-label\", [this._translate('Type'), (0,inferno_index_esm/* createTextVNode */.Uk)(\":\")], 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"className\": \"type-ref-edit-select\",\n      \"onChange\": this.onTypeChange,\n      \"options\": typeRefOptions,\n      \"value\": typeRef\n    })], 4), 2);\n  }\n}\n//# sourceMappingURL=TypeRefCellContextMenu.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/type-ref/TypeRefEditingProvider.js\n\nconst TypeRefEditingProvider_LOW_PRIORITY = 750;\nclass TypeRef {\n  constructor(components) {\n    components.onGetComponent('context-menu', TypeRefEditingProvider_LOW_PRIORITY, function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      const contextMenuType = context.contextMenuType;\n      if (contextMenuType === 'input-edit' || contextMenuType === 'output-edit') {\n        return TypeRefCellContextMenu;\n      }\n    });\n  }\n}\nTypeRef.$inject = ['components'];\n//# sourceMappingURL=TypeRefEditingProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/type-ref/index.js\n\n\n\n/* harmony default export */ const type_ref = ({\n  __depends__: [context_menu/* default */.Z, data_types],\n  __init__: ['typeRefEditingProvider'],\n  typeRefEditingProvider: ['type', TypeRef]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/allowed-values/behavior/AllowedValuesUpdateBehavior.js\n\n\n\n/**\n * Makes sure allowed values are removed if type is set to\n * something other than string.\n */\nclass AllowedValuesUpdateBehavior extends CommandInterceptor/* default */.Z {\n  constructor(eventBus, modeling) {\n    super(eventBus);\n    this.postExecuted('element.updateProperties', event => {\n      const _event$context = event.context,\n        element = _event$context.element,\n        properties = _event$context.properties;\n      const actualProperties = (0,ModelUtil/* isInput */.u7)(element) ? properties.inputExpression : properties;\n      if (actualProperties && actualProperties.typeRef && actualProperties.typeRef !== 'string') {\n        const target = (0,ModelUtil.is)(element, 'dmn:LiteralExpression') ? element.$parent : element;\n\n        // delete allowed values\n        modeling.editAllowedValues(target, null);\n      }\n    });\n  }\n}\nAllowedValuesUpdateBehavior.$inject = ['eventBus', 'modeling'];\n//# sourceMappingURL=AllowedValuesUpdateBehavior.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/components/List.js\n\nfunction List_defineProperty(obj, key, value) { key = List_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction List_toPropertyKey(arg) { var key = List_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction List_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nconst RADIO = 'radio';\nconst REMOVE_BTN_CLS = 'remove dmn-icon-clear';\n\n/**\n * Shows a list of grouped items that can be checked\n * (checkboxes or radio buttons), removed.\n *\n * Example list of items:\n *\n * [\n *   { value: 'foo', isChecked: true, isRemovable: false, group: 'foo' },\n *   { value: 'bar', isChecked: false, isRemovable: true, group: 'bar' },\n *   { value: 'baz', isCheckable: false, group: 'baz' }\n * ]\n */\nclass List extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    List_defineProperty(this, \"getRemoveClickHandler\", item => {\n      return e => {\n        e.stopPropagation();\n        this.removeItem(item);\n      };\n    });\n    List_defineProperty(this, \"getToggleClickHandler\", item => {\n      return e => {\n        e.stopPropagation();\n        this.toggleItem(item);\n      };\n    });\n    List_defineProperty(this, \"removeItem\", item => {\n      const onChange = this.props.onChange;\n\n      // remove item\n      const newItems = this.state.items.filter(i => i !== item);\n      this.setState({\n        items: newItems\n      });\n      onChange && onChange(newItems);\n    });\n    List_defineProperty(this, \"toggleItem\", item => {\n      const _this$props = this.props,\n        onChange = _this$props.onChange,\n        type = _this$props.type;\n\n      // toggle item\n      const newItems = this.state.items.map(i => {\n        if (i === item) {\n          i.isChecked = !i.isChecked;\n        } else {\n          if (type === RADIO) {\n            i.isChecked = false;\n          }\n        }\n        return i;\n      });\n      this.setState({\n        items: newItems\n      });\n      onChange && onChange(newItems);\n    });\n    const items = props.items;\n    this.state = {\n      items\n    };\n  }\n  componentWillReceiveProps(props) {\n    const items = props.items;\n    this.setState({\n      items\n    });\n  }\n  render() {\n    const _this$props2 = this.props,\n      className = _this$props2.className,\n      items = _this$props2.items,\n      type = _this$props2.type,\n      labelComponent = _this$props2.labelComponent;\n    const classes = ['dms-list-component'];\n    if (className) {\n      classes.push(className);\n    }\n\n    // group items by group title\n    const groupedItems = (0,min_dash_dist_index_esm/* groupBy */.vM)(items, 'group');\n    const asPairs = toPairs(groupedItems);\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", classes.join(' '), asPairs.map(pair => {\n      const groupTitle = pair[0],\n        groupItems = pair[1];\n      return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"group\", [labelComponent && labelComponent(groupTitle) || (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", groupTitle, 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"ul\", \"items no-wrap\", groupItems.map(item => {\n        return (0,inferno_index_esm/* createVNode */.Wm)(1, \"li\", \"item\", [type && (0,inferno_index_esm/* createVNode */.Wm)(64, \"input\", \"item-toggle\", null, 1, {\n          \"type\": type,\n          \"checked\": item.isChecked,\n          \"onClick\": this.getToggleClickHandler(item)\n        }), (0,inferno_index_esm/* createTextVNode */.Uk)(\"\\xA0\"), item.value, item.isRemovable && (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", REMOVE_BTN_CLS, null, 1, {\n          \"title\": \"Remove item\",\n          \"onClick\": this.getRemoveClickHandler(item)\n        })], 0);\n      }), 0)], 0);\n    }), 0);\n  }\n}\n\n// helpers ////////////\n\nfunction toPairs(object) {\n  const entrys = [];\n  for (let key in object) {\n    entrys.push([key, object[key]]);\n  }\n  return entrys;\n}\n//# sourceMappingURL=List.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/components/ValidatedInput.js\n\n\n\n// eslint-disable-next-line\n\n\n/**\r\n * Input with optional validation.\r\n */\nclass ValidatedInput extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    const validate = props.validate,\n      value = props.value;\n    const validationWarning = validate ? validate(value || '') : undefined;\n    this.state = {\n      validationWarning,\n      value\n    };\n    this.onInput = this.onInput.bind(this);\n    this.onKeyDown = this.onKeyDown.bind(this);\n    this.onKeyUp = this.onKeyUp.bind(this);\n  }\n  componentWillReceiveProps(props) {\n    const validate = props.validate,\n      value = props.value;\n    const validationWarning = validate ? validate(value || '') : undefined;\n    this.setState({\n      validationWarning,\n      value\n    });\n  }\n  onInput(value) {\n    const _this$props = this.props,\n      onInput = _this$props.onInput,\n      validate = _this$props.validate;\n    const validationWarning = validate ? validate(value) : undefined;\n    this.setState({\n      validationWarning,\n      value\n    });\n    if (typeof onInput !== 'function') {\n      return;\n    }\n    onInput && onInput({\n      isValid: !validationWarning,\n      value\n    });\n  }\n  onKeyDown(event) {\n    const target = event.target,\n      value = target.value;\n    const _this$props2 = this.props,\n      onKeyDown = _this$props2.onKeyDown,\n      validate = _this$props2.validate;\n    const validationWarning = validate ? validate(value) : undefined;\n    if (typeof onKeyDown !== 'function') {\n      return;\n    }\n    onKeyDown({\n      isValid: !validationWarning,\n      value,\n      event\n    });\n  }\n  onKeyUp(event) {\n    const target = event.target,\n      value = target.value;\n    const _this$props3 = this.props,\n      onKeyUp = _this$props3.onKeyUp,\n      validate = _this$props3.validate;\n    const validationWarning = validate ? validate(value) : undefined;\n    if (typeof onKeyUp !== 'function') {\n      return;\n    }\n    onKeyUp({\n      isValid: !validationWarning,\n      value,\n      event\n    });\n  }\n  render() {\n    const _this$props4 = this.props,\n      placeholder = _this$props4.placeholder,\n      type = _this$props4.type,\n      className = _this$props4.className;\n    const _this$state = this.state,\n      validationWarning = _this$state.validationWarning,\n      value = _this$state.value;\n    const parentClasses = ['dms-validated-input', className].join(' ');\n    const inputClasses = [];\n    if (validationWarning) {\n      inputClasses.push('invalid');\n    }\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", parentClasses, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, Input, {\n      \"className\": inputClasses,\n      \"onInput\": this.onInput,\n      \"onKeyDown\": this.onKeyDown,\n      \"onKeyUp\": this.onKeyUp,\n      \"placeholder\": placeholder || '',\n      \"type\": type,\n      \"value\": value || ''\n    }), validationWarning && (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint dms-validation-warning\", validationWarning, 0)], 0);\n  }\n}\n//# sourceMappingURL=ValidatedInput.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/allowed-values/Utils.js\nfunction parseString(string) {\n  // empty string or no string at all\n  if (!string || isEmptyString(string.trim())) {\n    return {\n      values: []\n    };\n  }\n\n  // disjunction\n  let values = string.split(',');\n  const result = {\n    values: []\n  };\n  let openString = '';\n  values.forEach(value => {\n    openString += value;\n    if (/^\"[^\"]*\"$/.test(openString.trim())) {\n      result.values.push(openString.trim());\n      openString = '';\n    } else {\n      openString += ',';\n    }\n  });\n  if (!openString) {\n    return result;\n  }\n}\nfunction isEmptyString(string) {\n  return string === '';\n}\nfunction getValuesArray(values) {\n  return values.map(value => value.value);\n}\n//# sourceMappingURL=Utils.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/allowed-values/components/AllowedValuesEditing.js\n\nfunction AllowedValuesEditing_defineProperty(obj, key, value) { key = AllowedValuesEditing_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction AllowedValuesEditing_toPropertyKey(arg) { var key = AllowedValuesEditing_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction AllowedValuesEditing_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\n\nclass AllowedValuesEditing extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    AllowedValuesEditing_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    AllowedValuesEditing_defineProperty(this, \"setPredefinedValues\", values => {\n      // inputClause or outputClause\n      const target = this.getAllowedValuesTarget();\n      this.setState({\n        values\n      });\n      this._modeling.editAllowedValues(target, values && getValuesArray(values));\n    });\n    AllowedValuesEditing_defineProperty(this, \"onListChange\", values => {\n      this.setPredefinedValues(values);\n    });\n    AllowedValuesEditing_defineProperty(this, \"onInput\", _ref => {\n      let isValid = _ref.isValid,\n        value = _ref.value;\n      this.setState({\n        inputValue: value\n      });\n    });\n    AllowedValuesEditing_defineProperty(this, \"onKeyDown\", _ref2 => {\n      let isValid = _ref2.isValid,\n        event = _ref2.event;\n      if (!isEnter(event.keyCode)) {\n        return;\n      }\n      event.stopPropagation();\n      event.preventDefault();\n      if (isValid) {\n        const _this$state = this.state,\n          inputValue = _this$state.inputValue,\n          values = _this$state.values;\n        const parsedString = parseString(inputValue);\n        this.onListChange((values || []).concat(parsedString.values.map(value => {\n          return {\n            value,\n            isCheckable: false,\n            isRemovable: true,\n            group: this._translate('Predefined Values')\n          };\n        })));\n        this.setState({\n          inputValue: ''\n        });\n      }\n    });\n    AllowedValuesEditing_defineProperty(this, \"handleRemovePredifinedValuesClick\", e => {\n      e.stopPropagation();\n      this.removePredefinedValues();\n    });\n    AllowedValuesEditing_defineProperty(this, \"removePredefinedValues\", () => {\n      this.setPredefinedValues(null);\n    });\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    this._changeSupport = context.changeSupport;\n    const _target = this.getAllowedValuesTarget();\n    const _parsedString = parseString(_target.inputValues && _target.inputValues.text || _target.outputValues && _target.outputValues.text || '');\n    if (_parsedString) {\n      this.state = {\n        values: _parsedString.values.map(value => {\n          return {\n            value,\n            isCheckable: false,\n            isRemovable: true,\n            group: this._translate('Predefined Values')\n          };\n        }),\n        inputValue: ''\n      };\n    } else {\n      this.state = {\n        values: null,\n        inputValue: ''\n      };\n    }\n  }\n  componentWillMount() {\n    const target = this.getAllowedValuesTarget();\n    this._changeSupport.onElementsChanged(target.id, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    const target = this.getAllowedValuesTarget();\n    this._changeSupport.offElementsChanged(target.id, this.onElementsChanged);\n  }\n  getAllowedValuesTarget() {\n    const element = this.getElement();\n    if ((0,ModelUtil.is)(element, 'dmn:LiteralExpression')) {\n      return element.$parent;\n    } else {\n      return element;\n    }\n  }\n  getElement() {\n    return this.props.context.output || this.props.context.input.inputExpression;\n  }\n  render() {\n    const element = this.getElement();\n    const _this$state2 = this.state,\n      inputValue = _this$state2.inputValue,\n      values = _this$state2.values;\n    return element.typeRef === 'string' ? (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container allowed-values-edit\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-form-control\", [!isNull(values) && values.length > 0 && (0,inferno_index_esm/* createComponentVNode */.Iz)(2, List, {\n      \"labelComponent\": Label,\n      \"items\": values,\n      \"onChange\": this.onListChange\n    }), !isNull(values) && !values.length && (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"label\", \"dms-label\", this._translate('Predefined Values'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"placeholder\", this._translate('No values'), 0)], 4), !isNull(values) && (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"del-values\", this._translate('Clear predefined values.'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.handleRemovePredifinedValuesClick\n    }), 2), (0,inferno_index_esm/* createVNode */.Wm)(1, \"label\", \"dms-label\", this._translate('Add Predefined Values'), 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"onInput\": this.onInput,\n      \"onKeyDown\": this.onKeyDown,\n      \"placeholder\": this._translate('\"value\", \"value\", ...'),\n      \"type\": \"text\",\n      \"validate\": value => {\n        if (!parseString(value)) {\n          return this._translate('Strings must be in double quotes.');\n        }\n      },\n      \"value\": inputValue\n    })], 0), 2) : null;\n  }\n}\nfunction Label(label) {\n  return (0,inferno_index_esm/* createVNode */.Wm)(1, \"label\", \"dms-label\", label, 0);\n}\n\n// helpers //////////////////////\n\nfunction isEnter(keyCode) {\n  return keyCode === 13;\n}\nfunction isNull(value) {\n  return value === null;\n}\n//# sourceMappingURL=AllowedValuesEditing.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/allowed-values/AllowedValuesEditingProvider.js\n\nconst AllowedValuesEditingProvider_LOW_PRIORITY = 500;\nclass InputOutputValues {\n  constructor(components) {\n    components.onGetComponent('context-menu', AllowedValuesEditingProvider_LOW_PRIORITY, function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      const contextMenuType = context.contextMenuType;\n      if (contextMenuType === 'input-edit' || contextMenuType === 'output-edit') {\n        return AllowedValuesEditing;\n      }\n    });\n  }\n}\nInputOutputValues.$inject = ['components'];\n//# sourceMappingURL=AllowedValuesEditingProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/allowed-values/index.js\n\n\n/* harmony default export */ const allowed_values = ({\n  __init__: ['allowedValuesUpdateBehavior', 'allowedValuesEditingProvider'],\n  allowedValuesUpdateBehavior: ['type', AllowedValuesUpdateBehavior],\n  allowedValuesEditingProvider: ['type', InputOutputValues]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/add-input-output/components/AddInput.js\n\nfunction AddInput_defineProperty(obj, key, value) { key = AddInput_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction AddInput_toPropertyKey(arg) { var key = AddInput_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction AddInput_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nclass AddInput extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    AddInput_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    AddInput_defineProperty(this, \"handleClick\", e => {\n      e.stopPropagation();\n      this.add();\n    });\n    AddInput_defineProperty(this, \"add\", () => {\n      this._eventBus.fire('addInput');\n    });\n    this._sheet = context.injector.get('sheet');\n    this._eventBus = context.injector.get('eventBus');\n    this._changeSupport = context.changeSupport;\n    this._translate = context.injector.get('translate');\n  }\n  componentWillMount() {\n    const root = this.getRoot();\n    this._changeSupport.onElementsChanged(root.id, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    const root = this.getRoot();\n    this._changeSupport.offElementsChanged(root.id, this.onElementsChanged);\n  }\n  getRoot() {\n    return this._sheet.getRoot();\n  }\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"add-input actionable\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"dmn-icon-plus action-icon\"), 2, {\n      \"onClick\": this.handleClick,\n      \"title\": this._translate('Add Input')\n    });\n  }\n}\n//# sourceMappingURL=AddInput.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/add-input-output/components/AddOutput.js\n\nfunction AddOutput_defineProperty(obj, key, value) { key = AddOutput_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction AddOutput_toPropertyKey(arg) { var key = AddOutput_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction AddOutput_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nclass AddOutput extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    AddOutput_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    AddOutput_defineProperty(this, \"handleClick\", e => {\n      e.stopPropagation();\n      this.add();\n    });\n    AddOutput_defineProperty(this, \"add\", () => {\n      this._eventBus.fire('addOutput');\n    });\n    this._sheet = context.injector.get('sheet');\n    this._eventBus = context.injector.get('eventBus');\n    this._changeSupport = context.changeSupport;\n    this._translate = context.injector.get('translate');\n  }\n  componentWillMount() {\n    const root = this.getRoot();\n    this._changeSupport.onElementsChanged(root.id, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    const root = this.getRoot();\n    this._changeSupport.offElementsChanged(root.id, this.onElementsChanged);\n  }\n  getRoot() {\n    return this._sheet.getRoot();\n  }\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"add-output actionable\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"dmn-icon-plus action-icon\"), 2, {\n      \"onClick\": this.handleClick,\n      \"title\": this._translate('Add Output')\n    });\n  }\n}\n//# sourceMappingURL=AddOutput.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/add-input-output/AddInputOutputProvider.js\n\n\nfunction AddInputOutputProvider(components, editorActions, eventBus) {\n  components.onGetComponent('cell-inner', function () {\n    let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    const cellType = context.cellType,\n      index = context.index,\n      inputsLength = context.inputsLength,\n      outputsLength = context.outputsLength;\n    if (cellType === 'input-cell' && index === inputsLength - 1) {\n      return AddInput;\n    }\n    if (cellType === 'output-cell' && index === outputsLength - 1) {\n      return AddOutput;\n    }\n  });\n  eventBus.on('addInput', () => {\n    editorActions.trigger('addInput');\n  });\n  eventBus.on('addOutput', () => {\n    editorActions.trigger('addOutput');\n  });\n}\nAddInputOutputProvider.$inject = ['components', 'editorActions', 'eventBus'];\n//# sourceMappingURL=AddInputOutputProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/add-input-output/index.js\n\n\n/* harmony default export */ const add_input_output = ({\n  __depends__: [dmn_js_decision_table_lib_features_editor_actions],\n  __init__: ['addInputOutputProvider'],\n  addInputOutputProvider: ['type', AddInputOutputProvider]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/keyboard/Keyboard.js\nfunction Keyboard_defineProperty(obj, key, value) { key = Keyboard_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction Keyboard_toPropertyKey(arg) { var key = Keyboard_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction Keyboard_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\n/**\n * A keyboard abstraction that may be activated and\n * deactivated by users at will, consuming key events\n * and triggering diagram actions.\n *\n * The implementation fires the following key events that allow\n * other components to hook into key handling:\n *\n *  - keyboard.bind\n *  - keyboard.unbind\n *  - keyboard.init\n *  - keyboard.destroy\n *\n * All events contain the fields (node, listeners).\n *\n * A default binding for the keyboard may be specified via the\n * `keyboard.bindTo` configuration option.\n *\n * @param {Config} config\n * @param {EventBus} eventBus\n * @param {EditorActions} editorActions\n * @param {CellSelection} cellSelection\n */\nclass Keyboard {\n  constructor(config, eventBus, editorActions, cellSelection) {\n    Keyboard_defineProperty(this, \"_init\", () => {\n      this._registerDefaultBindings();\n      this._fire('init');\n    });\n    Keyboard_defineProperty(this, \"_destroy\", () => {\n      this._fire('destroy');\n      this.unbind();\n      this._listeners = null;\n    });\n    Keyboard_defineProperty(this, \"_keyHandler\", event => {\n      var i,\n        l,\n        listeners = this._listeners,\n        code = event.keyCode || event.charCode || -1;\n      for (i = 0; l = listeners[i]; i++) {\n        if (l(code, event)) {\n          event.preventDefault();\n          event.stopPropagation();\n          return;\n        }\n      }\n    });\n    Keyboard_defineProperty(this, \"unbind\", () => {\n      var node = this._node;\n      if (node) {\n        this._fire('unbind');\n\n        // unbind key events\n        min_dom_dist_index_esm/* event.unbind */.B.unbind(node, 'keydown', this._keyHandler, true);\n      }\n      this._node = null;\n    });\n    this._config = config || {};\n    this._editorActions = editorActions;\n    this._eventBus = eventBus;\n    this._cellSelection = cellSelection;\n    this._listeners = [];\n    eventBus.on('table.destroy', this._destroy);\n    eventBus.on('table.init', this._init);\n    eventBus.on('attach', () => {\n      if (this._config.bindTo) {\n        this.bind(config.bindTo);\n      }\n    });\n    eventBus.on('detach', this.unbind);\n  }\n  bind(node) {\n    // make sure that the keyboard is only bound once to the DOM\n    this.unbind();\n    this._node = node;\n\n    // bind key events\n    min_dom_dist_index_esm/* event.bind */.B.bind(node, 'keydown', this._keyHandler, true);\n    this._fire('bind');\n  }\n  getBinding() {\n    return this._node;\n  }\n  _fire(event) {\n    this._eventBus.fire('keyboard.' + event, {\n      node: this._node,\n      listeners: this._listeners\n    });\n  }\n  _registerDefaultBindings() {\n    var listeners = this._listeners;\n    var editorActions = this._editorActions;\n    var cellSelection = this._cellSelection;\n\n    // init default listeners\n\n    // undo\n    // (CTRL|CMD) + Z\n    function undo(key, modifiers) {\n      if (KeyboardUtil_isCmd(modifiers) && !isShift(modifiers) && key === 90) {\n        editorActions.trigger('undo');\n        return true;\n      }\n    }\n\n    // redo\n    // CTRL + Y\n    // CMD + SHIFT + Z\n    function redo(key, modifiers) {\n      if (KeyboardUtil_isCmd(modifiers) && (key === 89 || key === 90 && isShift(modifiers))) {\n        editorActions.trigger('redo');\n        return true;\n      }\n    }\n    listeners.push(undo);\n    listeners.push(redo);\n    function selectCellAbove(key, event) {\n      if (key !== 13 || KeyboardUtil_isCmd(event) || !isShift(event)) {\n        return;\n      }\n      if (!findSelectableAncestor(event.target)) {\n        return;\n      }\n      editorActions.trigger('selectCellAbove');\n      return true;\n    }\n    listeners.push(selectCellAbove);\n    function selectCellBelow(key, event) {\n      if (key !== 13 || KeyboardUtil_isCmd(event) || isShift(event)) {\n        return;\n      }\n      if (!findSelectableAncestor(event.target)) {\n        return;\n      }\n      const changed = editorActions.trigger('selectCellBelow');\n      const selectedCell = cellSelection.getCellSelection();\n\n      // add new rule if no next rule\n      if (!changed && selectedCell && !isDecisionNameCell(selectedCell)) {\n        const rule = editorActions.trigger('addRule');\n        editorActions.trigger('selectCellBelow');\n        return rule;\n      }\n      return true;\n    }\n    listeners.push(selectCellBelow);\n  }\n\n  /**\n   * Add a listener function that is notified with (key, modifiers) whenever\n   * the keyboard is bound and the user presses a key.\n   *\n   * @param {Function} listenerFn\n   */\n  addListener(listenerFn) {\n    this._listeners.unshift(listenerFn);\n  }\n  removeListener(listenerFn) {\n    this._listeners = this._listeners.filter(l => l !== listenerFn);\n  }\n}\nKeyboard.$inject = ['config.keyboard', 'eventBus', 'editorActions', 'cellSelection'];\n\n// helper /////\nfunction isDecisionNameCell(cell) {\n  return cell === '__decisionProperties_name';\n}\n//# sourceMappingURL=Keyboard.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/keyboard/index.js\n\n\n/* harmony default export */ const lib_features_keyboard = ({\n  __depends__: [dmn_js_decision_table_lib_features_editor_actions],\n  __init__: ['keyboard'],\n  keyboard: ['type', Keyboard]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-head/editor/index.js\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const decision_table_head_editor = ({\n  __depends__: [add_input_output, allowed_values, context_menu/* default */.Z, debounce_input, expression_languages/* default */.Z, lib_features_keyboard, type_ref],\n  __init__: ['inputEditingProvider', 'outputEditingProvider'],\n  inputEditingProvider: ['type', InputCellProvider],\n  outputEditingProvider: ['type', OutputEditingProvider]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/features/drag-and-drop/index.js + 1 modules\nvar drag_and_drop = __webpack_require__(\"./node_modules/table-js/lib/features/drag-and-drop/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/drag-and-drop/DragAndDrop.js\n\nfunction DragAndDrop_defineProperty(obj, key, value) { key = DragAndDrop_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction DragAndDrop_toPropertyKey(arg) { var key = DragAndDrop_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction DragAndDrop_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\nconst TOP = 'top',\n  RIGHT = 'right',\n  BOTTOM = 'bottom',\n  LEFT = 'left';\nclass DragAndDrop {\n  constructor(components, elementRegistry, eventBus, dragAndDrop, renderer, rules, sheet) {\n    DragAndDrop_defineProperty(this, \"_cleanup\", () => {\n      const container = this._renderer.getContainer();\n      removeHighlight(container);\n      removeFadeOut(container);\n      if (this._dragImage) {\n        (0,min_dom_dist_index_esm/* remove */.Od)(this._dragImage);\n        this._dragImage = null;\n      }\n    });\n    this._elementRegistry = elementRegistry;\n    this._dragAndDrop = dragAndDrop;\n    this._renderer = renderer;\n    this._rules = rules;\n    this._sheet = sheet;\n\n    // provide drag handle for drag and drop\n    components.onGetComponent('cell-inner', _ref => {\n      let cellType = _ref.cellType,\n        col = _ref.col,\n        row = _ref.row;\n      if (cellType === 'rule-index') {\n        return () => (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"dmn-icon-drag vertical\", (0,inferno_index_esm/* createTextVNode */.Uk)(\"\\xA0\"), 2, {\n          \"draggable\": \"true\",\n          \"onDragStart\": e => this.startDrag(row, e),\n          \"title\": \"Move rule\"\n        });\n      } else if (cellType === 'input-cell' || cellType === 'output-cell') {\n        let title = \"Move \".concat((0,ModelUtil/* isInput */.u7)(col) ? 'Input' : 'Output');\n        return () => (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"dmn-icon-drag horizontal\", null, 1, {\n          \"draggable\": \"true\",\n          \"onDragStart\": e => this.startDrag(col, e),\n          \"title\": title\n        });\n      }\n    });\n\n    // validate allowed rules\n    eventBus.on('dragAndDrop.dragEnter', event => {\n      const dragContext = event.dragContext;\n      const draggedElement = dragContext.draggedElement,\n        hoverEl = dragContext.hoverEl;\n\n      // can always drag rows\n      if (draggedElement instanceof model/* Row */.X2) {\n        return true;\n      }\n      if (draggedElement instanceof model/* Col */.JX) {\n        const dropIndex = getTargetColIndex(hoverEl, this._elementRegistry, this._sheet);\n\n        // cannot drop as we cannot compute the drop index\n        if (dropIndex === -1) {\n          return false;\n        }\n        const allowed = this._rules.allowed('col.move', {\n          col: draggedElement,\n          index: dropIndex\n        });\n        return allowed;\n      }\n      return false;\n    });\n\n    // clear previous UI\n    eventBus.on('dragAndDrop.dragLeave', event => {\n      const dragContext = event.dragContext;\n      const targetEl = dragContext.targetEl;\n      if (!targetEl) {\n        return;\n      }\n      const container = this._renderer.getContainer();\n      removeHighlight(container);\n    });\n\n    // update UI\n    eventBus.on('dragAndDrop.dragOver', event => {\n      const dragContext = event.dragContext,\n        originalEvent = event.originalEvent;\n      const draggedElement = dragContext.draggedElement,\n        lastPosition = dragContext.lastPosition,\n        targetEl = dragContext.targetEl;\n      const container = this._renderer.getContainer();\n      if (!targetEl) {\n        return false;\n      }\n      let newPosition;\n      if (draggedElement instanceof model/* Row */.X2) {\n        newPosition = getVerticalPosition(originalEvent, targetEl);\n      }\n      if (draggedElement instanceof model/* Col */.JX) {\n        newPosition = getHorizontalPosition(originalEvent, targetEl);\n      }\n\n      // nothing to do\n      if (lastPosition === newPosition) {\n        return true;\n      }\n\n      // remove old highlight\n      removeHighlight(container);\n      if (draggedElement instanceof model/* Row */.X2) {\n        if (newPosition === TOP) {\n          // drop above\n          highlightRow(targetEl, container, 'top');\n        } else {\n          // drop below\n          highlightRow(targetEl, container, 'bottom');\n        }\n      }\n      if (draggedElement instanceof model/* Col */.JX) {\n        if (newPosition === LEFT) {\n          // drop left\n          highlightCol(targetEl, container, 'left');\n        } else {\n          // drop right\n          highlightCol(targetEl, container, 'right');\n        }\n      }\n\n      // remember position\n      dragContext.lastPosition = newPosition;\n\n      // allowed\n      return true;\n    });\n\n    // perform drop operation\n    eventBus.on('dragAndDrop.drop', event => {\n      const dragContext = event.dragContext,\n        originalEvent = event.originalEvent;\n      const draggedElement = dragContext.draggedElement,\n        targetEl = dragContext.targetEl;\n      if (!targetEl) {\n        return false;\n      }\n      if (draggedElement instanceof model/* Row */.X2) {\n        const verticalPosition = getVerticalPosition(originalEvent, targetEl);\n        const rowId = targetEl.dataset.rowId,\n          row = this._elementRegistry.get(rowId);\n        if (!row || row === draggedElement) {\n          return;\n        }\n        const targetRow = getTargetRow(draggedElement, row, verticalPosition, this._sheet.getRoot().rows);\n        if (targetRow === draggedElement) {\n          return;\n        }\n        return targetRow;\n      }\n      if (draggedElement instanceof model/* Col */.JX) {\n        const horizontalPosition = getHorizontalPosition(originalEvent, targetEl);\n\n        // no need to check rules; we verified on\n        // dragEnter that dropping is O.K.\n        const colId = targetEl.dataset.colId,\n          col = this._elementRegistry.get(colId);\n        if (!col || col === draggedElement) {\n          return;\n        }\n        const targetCol = getTargetCol(draggedElement, col, horizontalPosition, this._sheet.getRoot().cols);\n        if (targetCol === draggedElement) {\n          return;\n        }\n        return targetCol;\n      }\n    });\n    eventBus.on('dragAndDrop.dragEnd', this._cleanup);\n  }\n  startDrag(element, event) {\n    const container = this._renderer.getContainer();\n    this._dragImage = (0,min_dom_dist_index_esm/* domify */.H6)(\"<span style=\\\"\\n          visibility: hidden;\\n          position: fixed;\\n          top: -10000px\\n      \\\"></span>\");\n\n    // needs to be present in DOM\n    document.body.appendChild(this._dragImage);\n\n    // QUIRK: not supported by Edge and Internet Explorer\n    if (event.dataTransfer.setDragImage) {\n      event.dataTransfer.setDragImage(this._dragImage, 0, 0);\n    }\n    if (element instanceof model/* Row */.X2) {\n      fadeOutRow(element, container);\n    } else if (element instanceof model/* Col */.JX) {\n      fadeOutCol(element, container);\n    }\n    this._dragAndDrop.startDrag(element, event);\n  }\n}\nDragAndDrop.$inject = ['components', 'elementRegistry', 'eventBus', 'dragAndDrop', 'renderer', 'rules', 'sheet'];\n\n// helpers //////////\n\nfunction getTargetColIndex(cellEl, elementRegistry, sheet) {\n  const targetCol = elementRegistry.get(cellEl.dataset.colId);\n  if (!targetCol) {\n    return -1;\n  }\n  const _sheet$getRoot = sheet.getRoot(),\n    cols = _sheet$getRoot.cols;\n  return cols.indexOf(targetCol);\n}\nfunction highlightRow(dragOverCell, container, position) {\n  const rowId = dragOverCell.dataset.rowId;\n  if (!rowId) {\n    return;\n  }\n  const cells = (0,min_dom_dist_index_esm/* queryAll */.Kt)(\"[data-row-id=\".concat(rowId, \"]\"), container);\n  (0,node_modules_min_dash_dist_index_esm/* forEach */.Ed)(cells, cell => {\n    // QUIRK: PhantomJS might return object instead of NodeList\n    if (isNode(cell)) {\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).add('dragover');\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).add(position);\n    }\n  });\n}\nfunction highlightCol(dragOverCell, container, position) {\n  const colId = dragOverCell.dataset.colId;\n  if (!colId) {\n    return;\n  }\n  const cells = (0,min_dom_dist_index_esm/* queryAll */.Kt)(\"[data-col-id=\".concat(colId, \"]\"), container);\n  (0,node_modules_min_dash_dist_index_esm/* forEach */.Ed)(cells, cell => {\n    // QUIRK: PhantomJS might return object instead of NodeList\n    if (isNode(cell)) {\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).add('dragover');\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).add(position);\n    }\n  });\n}\nfunction removeHighlight(container) {\n  const cells = (0,min_dom_dist_index_esm/* queryAll */.Kt)('.dragover', container);\n  (0,node_modules_min_dash_dist_index_esm/* forEach */.Ed)(cells, cell => {\n    // QUIRK: PhantomJS might return object instead of NodeList\n    if (isNode(cell)) {\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).remove('dragover');\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).remove('top');\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).remove('right');\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).remove('bottom');\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).remove('left');\n    }\n  });\n}\nfunction fadeOutRow(row, container) {\n  const cells = (0,min_dom_dist_index_esm/* queryAll */.Kt)(\"[data-row-id=\".concat(row.id, \"]\"), container);\n  (0,node_modules_min_dash_dist_index_esm/* forEach */.Ed)(cells, cell => {\n    // QUIRK: PhantomJS might return object instead of NodeList\n    if (isNode(cell)) {\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).add('dragged');\n    }\n  });\n}\nfunction fadeOutCol(col, container) {\n  const cells = (0,min_dom_dist_index_esm/* queryAll */.Kt)(\"[data-col-id=\".concat(col.id, \"]\"), container);\n  (0,node_modules_min_dash_dist_index_esm/* forEach */.Ed)(cells, cell => {\n    // QUIRK: PhantomJS might return object instead of NodeList\n    if (isNode(cell)) {\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).add('dragged');\n    }\n  });\n}\nfunction removeFadeOut(container) {\n  const cells = (0,min_dom_dist_index_esm/* queryAll */.Kt)('.dragged', container);\n  (0,node_modules_min_dash_dist_index_esm/* forEach */.Ed)(cells, cell => {\n    // QUIRK: PhantomJS might return object instead of NodeList\n    if (isNode(cell)) {\n      (0,min_dom_dist_index_esm/* classes */.Sh)(cell).remove('dragged');\n    }\n  });\n}\nfunction getHorizontalPosition(event, dragOverElement) {\n  const bounds = dragOverElement.getBoundingClientRect();\n  return event.clientX < bounds.left + bounds.width / 2 ? LEFT : RIGHT;\n}\nfunction getVerticalPosition(event, dragOverElement) {\n  const bounds = dragOverElement.getBoundingClientRect();\n  return event.clientY < bounds.top + bounds.height / 2 ? TOP : BOTTOM;\n}\nfunction getTargetRow(draggedRow, targetRow, verticalPosition, rows) {\n  if (rows.indexOf(draggedRow) > rows.indexOf(targetRow)) {\n    targetRow = getRowBelow(targetRow, rows);\n  }\n  if (verticalPosition === TOP) {\n    // return row above or row\n    return getRowAbove(targetRow, rows);\n  } else {\n    // return row\n    return targetRow;\n  }\n}\nfunction getTargetCol(draggedCol, targetCol, horizontalPosition, cols) {\n  if (cols.indexOf(draggedCol) > cols.indexOf(targetCol)) {\n    targetCol = getColRight(targetCol, cols);\n  }\n  if (horizontalPosition === LEFT) {\n    // return col left or col\n    return getColLeft(targetCol, cols);\n  } else {\n    // return col\n    return targetCol;\n  }\n}\nfunction getRowAbove(row, rows) {\n  const index = rows.indexOf(row);\n  return rows[Math.max(0, index - 1)];\n}\nfunction getRowBelow(row, rows) {\n  const index = rows.indexOf(row);\n  return rows[Math.min(rows.length - 1, index + 1)];\n}\nfunction getColLeft(col, cols) {\n  const index = cols.indexOf(col);\n  if ((0,ModelUtil/* isOutput */.RW)(col)) {\n    const firstOutput = cols.filter(col => (0,ModelUtil/* isOutput */.RW)(col))[0];\n    const firstOutputIndex = cols.indexOf(firstOutput);\n    return cols[Math.max(firstOutputIndex, index - 1)];\n  }\n  return cols[Math.max(0, index - 1)];\n}\nfunction getColRight(col, cols) {\n  const index = cols.indexOf(col);\n  if ((0,ModelUtil/* isInput */.u7)(col)) {\n    const inputs = cols.filter(col => (0,ModelUtil/* isInput */.u7)(col));\n    const lastInput = inputs[inputs.length - 1];\n    const lastInputIndex = cols.indexOf(lastInput);\n    return cols[Math.min(lastInputIndex, index + 1)];\n  }\n  return cols[Math.min(cols.length - 1, index + 1)];\n}\n\n// QUIRK: PhantomJS requires check if actual DOM node\nfunction isNode(node) {\n  return node && (node.nodeType === 1 || node.nodeType == 11);\n}\n//# sourceMappingURL=DragAndDrop.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/drag-and-drop/index.js\n\n\n\n/* harmony default export */ const features_drag_and_drop = ({\n  __depends__: [drag_and_drop/* default */.Z, dmn_js_decision_table_lib_features_rules],\n  __init__: ['dmnDragAndDrop'],\n  dmnDragAndDrop: ['type', DragAndDrop]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/description/components/DescriptionEditor.js\n\nfunction DescriptionEditor_defineProperty(obj, key, value) { key = DescriptionEditor_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction DescriptionEditor_toPropertyKey(arg) { var key = DescriptionEditor_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction DescriptionEditor_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\nclass DescriptionEditor extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    DescriptionEditor_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    DescriptionEditor_defineProperty(this, \"changeDescription\", value => {\n      this._modeling.updateProperties(this._element, {\n        description: value\n      });\n    });\n    this._elementRegistry = context.injector.get('elementRegistry');\n    this._modeling = context.injector.get('modeling');\n    this._changeSupport = this.context.changeSupport;\n    const id = this.props.context.id;\n    this._element = this._elementRegistry.get(id);\n  }\n  componentWillMount() {\n    if (this._element) {\n      this._changeSupport.onElementsChanged(this._element.id, this.onElementsChanged);\n    }\n  }\n  componentDidMount() {\n    const autoFocus = this.props.context.autoFocus;\n    if (autoFocus && this.node) {\n      const editor = getEditor(this.node);\n      editor.focus();\n    }\n  }\n  componentWillUnmount() {\n    if (this._element) {\n      this._changeSupport.offElementsChanged(this._element.id, this.onElementsChanged);\n      const businessObject = this._element.businessObject;\n      const description = businessObject.description;\n\n      // if empty description remove description\n      if ((0,node_modules_min_dash_dist_index_esm/* isString */.HD)(description) && !description.length) {\n        this.changeDescription(null);\n      }\n    }\n  }\n  render() {\n    if (!this._element) {\n      return;\n    }\n    const businessObject = this._element.businessObject;\n    const description = businessObject.description;\n    if (!(0,node_modules_min_dash_dist_index_esm/* isString */.HD)(description)) {\n      return;\n    }\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container description-editor\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Editor, {\n      \"className\": \"dms-input\",\n      \"onChange\": this.changeDescription,\n      \"value\": description\n    }), 2, null, null, node => this.node = node);\n  }\n}\nclass Editor extends EditableComponent {\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", this.getClassName(), this.getEditor(), 0);\n  }\n}\n\n// helpers //////////\n\nfunction getEditor(container) {\n  return (0,min_dom_dist_index_esm/* query */.IO)('.content-editable', container);\n}\n//# sourceMappingURL=DescriptionEditor.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/description/Description.js\n\nfunction Description_defineProperty(obj, key, value) { key = Description_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction Description_toPropertyKey(arg) { var key = Description_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction Description_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\nconst Description_LOW_PRIORITY = 500;\nconst LOWER_PRIORITY = 750;\nconst OFFSET_X = 26;\nclass Description {\n  constructor(components, contextMenu, elementRegistry, eventBus, modeling, renderer, translate) {\n    var _this = this;\n    Description_defineProperty(this, \"addDescription\", cell => {\n      this._modeling.updateProperties(cell, {\n        description: ''\n      });\n      const container = this._renderer.getContainer();\n      const node = getNodeById(cell.id, container);\n      const bounds = node.getBoundingClientRect();\n      const position = getPosition(container, bounds);\n      this._contextMenu.open(position, {\n        contextMenuType: 'cell-description',\n        id: cell.id,\n        autoFocus: true,\n        offset: {\n          x: 4,\n          y: 4\n        }\n      });\n    });\n    Description_defineProperty(this, \"removeDescription\", cell => {\n      this._modeling.updateProperties(cell, {\n        description: null\n      });\n      this._contextMenu.close();\n    });\n    this._contextMenu = contextMenu;\n    this._modeling = modeling;\n    this._renderer = renderer;\n    this._translate = translate;\n    eventBus.on('cell.click', LOWER_PRIORITY, event => {\n      if (event.defaultPrevented) {\n        return;\n      }\n      const target = event.target,\n        id = event.id;\n      const element = elementRegistry.get(id);\n      if (!(0,ModelUtil/* isAny */.JZ)(element, ['dmn:UnaryTests', 'dmn:LiteralExpression'])) {\n        return;\n      }\n      const description = getDescription(element);\n      if (!description) {\n        // prevent focus\n        event.preventDefault();\n      }\n      const container = renderer.getContainer(),\n        bounds = target.getBoundingClientRect();\n      const position = getPosition(container, bounds);\n      contextMenu.open(position, {\n        contextMenuType: 'cell-description',\n        autoFocus: false,\n        id,\n        offset: {\n          x: 4,\n          y: 4\n        }\n      });\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'cell-description') {\n        const element = elementRegistry.get(context.id);\n        const description = getDescription(element);\n        if ((0,node_modules_min_dash_dist_index_esm/* isString */.HD)(description)) {\n          return DescriptionEditor;\n        }\n      }\n    });\n    components.onGetComponent('context-menu-cell-additional', Description_LOW_PRIORITY, function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'context-menu') {\n        const id = context.id;\n        if (!id) {\n          return;\n        }\n        const element = elementRegistry.get(id);\n\n        // element might not be in element registry (e.g. cut)\n        if (!element) {\n          return;\n        }\n        const businessObject = element.businessObject;\n        const description = businessObject.description;\n        const existingDescription = (0,node_modules_min_dash_dist_index_esm/* isString */.HD)(description);\n        const className = existingDescription ? 'remove-description' : 'add-description';\n        const onClick = existingDescription ? () => _this.removeDescription(element) : () => _this.addDescription(element);\n        return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry \".concat(className), (0,node_modules_min_dash_dist_index_esm/* isString */.HD)(description) ? _this._translate('Remove Cell Description') : _this._translate('Add Cell Description'), 0, {\n          \"onClick\": onClick\n        });\n      }\n    });\n  }\n}\nDescription.$inject = ['components', 'contextMenu', 'elementRegistry', 'eventBus', 'modeling', 'renderer', 'translate'];\n\n// helpers //////////\n\nfunction getPosition(container, bounds) {\n  const top = bounds.top,\n    left = bounds.left,\n    width = bounds.width,\n    height = bounds.height;\n  return {\n    x: left + container.parentNode.scrollLeft - OFFSET_X,\n    y: top + container.parentNode.scrollTop,\n    width: width + 2 * OFFSET_X,\n    height\n  };\n}\nfunction getDescription(element) {\n  return element && element.businessObject && element.businessObject.description;\n}\n//# sourceMappingURL=Description.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/description/index.js\n\n\n\n/* harmony default export */ const description = ({\n  __depends__: [context_menu/* default */.Z, interaction_events/* default */.Z],\n  __init__: ['description'],\n  description: ['type', Description]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/expression-language/ExpressionLanguage.js\n\n\n\nclass ExpressionLanguage {\n  constructor(components, elementRegistry, modeling, expressionLanguages, translate, contextMenu) {\n    var _this = this;\n    this._modeling = modeling;\n    this._translate = translate;\n    this._expressionLanguages = expressionLanguages;\n    components.onGetComponent('context-menu-cell-additional', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'context-menu') {\n        const event = context.event,\n          id = context.id;\n        if (!id) {\n          return;\n        }\n        const element = elementRegistry.get(id);\n\n        // element might not be in element registry (e.g. cut)\n        if (!element) {\n          return;\n        }\n        if (!_this._shouldDisplayContextMenuEntry(element)) {\n          return;\n        }\n        const openMenu = clickEvent => {\n          contextMenu.open({\n            x: (event || clickEvent).pageX,\n            y: (event || clickEvent).pageY\n          }, {\n            contextMenuType: 'expression-language',\n            id\n          });\n        };\n        return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group-entry\", _this._translate('Change Cell Expression Language'), 0, {\n          \"onClick\": openMenu\n        });\n      }\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'expression-language') {\n        const id = context.id;\n        if (!id) {\n          return;\n        }\n        const element = elementRegistry.get(id);\n\n        // element might not be in element registry (e.g. cut)\n        if (!element) {\n          return;\n        }\n        const expressionLanguage = _this._getElementExpressionLanguage(element);\n        const options = expressionLanguages.getAll();\n        const className = 'context-menu-group-entry ' + 'context-menu-entry-set-expression-language';\n        return () => (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-flex\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-group\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", className, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, _this._translate('Expression Language'), 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n          \"className\": \"expression-language\",\n          \"onChange\": value => _this.onChange(element, value),\n          \"options\": options,\n          \"value\": expressionLanguage\n        })], 4), 2), 2);\n      }\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType === 'input-edit') {\n        return () => {\n          const inputExpression = context.input.inputExpression;\n          if (!_this._shouldDisplayContextMenuEntry(inputExpression)) {\n            return;\n          }\n          const expressionLanguage = _this._getElementExpressionLanguage(inputExpression);\n          const options = expressionLanguages.getAll();\n          return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container ref-language\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-form-control\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"label\", \"dms-label\", _this._translate('Expression Language'), 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n            \"className\": \"ref-language\",\n            \"value\": expressionLanguage || '',\n            \"onChange\": value => _this.onChange(inputExpression, value),\n            \"options\": options\n          })], 4), 2);\n        };\n      }\n    });\n  }\n  onChange(element, expressionLanguage) {\n    this._modeling.editExpressionLanguage(element, expressionLanguage);\n  }\n  _shouldDisplayContextMenuEntry(element) {\n    const expressionLanguages = this._expressionLanguages.getAll();\n    if (expressionLanguages.length > 1) {\n      return true;\n    }\n    const expressionLanguage = this._getElementExpressionLanguage(element);\n    return expressionLanguage !== this._getDefaultElementExpressionLanguage(element);\n  }\n  _getElementExpressionLanguage(element) {\n    return (0,ModelUtil/* getBusinessObject */.SS)(element).expressionLanguage || this._getDefaultElementExpressionLanguage(element);\n  }\n  _getDefaultElementExpressionLanguage(element) {\n    return this._expressionLanguages.getDefault((0,ModelUtil/* isInput */.u7)(element.col) ? 'inputCell' : 'outputCell').value;\n  }\n}\nExpressionLanguage.$inject = ['components', 'elementRegistry', 'modeling', 'expressionLanguages', 'translate', 'contextMenu'];\n//# sourceMappingURL=ExpressionLanguage.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/expression-language/index.js\n\n\n/* harmony default export */ const expression_language = ({\n  __depends__: [expression_languages/* default */.Z],\n  __init__: ['expressionLanguage'],\n  expressionLanguage: ['type', ExpressionLanguage]\n});\n//# sourceMappingURL=index.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/mixins/SelectionAware.js\nvar SelectionAware = __webpack_require__(\"./node_modules/table-js/lib/components/mixins/SelectionAware.js\");\n// EXTERNAL MODULE: ./node_modules/table-js/lib/components/utils/classNames.js\nvar classNames = __webpack_require__(\"./node_modules/table-js/lib/components/utils/classNames.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-properties/components/DecisionTablePropertiesEditorComponent.js\n\nfunction DecisionTablePropertiesEditorComponent_defineProperty(obj, key, value) { key = DecisionTablePropertiesEditorComponent_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction DecisionTablePropertiesEditorComponent_toPropertyKey(arg) { var key = DecisionTablePropertiesEditorComponent_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction DecisionTablePropertiesEditorComponent_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nclass DecisionTablePropertiesComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    DecisionTablePropertiesEditorComponent_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    DecisionTablePropertiesEditorComponent_defineProperty(this, \"setDecisionTableName\", name => {\n      this.modeling.editDecisionTableName(name);\n    });\n    (0,inject/* inject */.f)(this);\n  }\n  componentWillMount() {\n    this.setupChangeListeners({\n      bind: this.getBusinessObject().id\n    });\n  }\n  componentWillUnmount() {\n    this.setupChangeListeners({\n      unbind: this.getBusinessObject().id\n    });\n  }\n  setupChangeListeners(_ref) {\n    let bind = _ref.bind,\n      unbind = _ref.unbind;\n    if (typeof unbind === 'string') {\n      this.changeSupport.offElementsChanged(unbind, this.onElementsChanged);\n    }\n    if (typeof bind === 'string') {\n      this.changeSupport.onElementsChanged(bind, this.onElementsChanged);\n    }\n  }\n  getBusinessObject() {\n    return this.sheet.getRoot().businessObject.$parent;\n  }\n  render() {\n    const bo = this.getBusinessObject();\n    const name = bo.name;\n    const HitPolicy = this.components.getComponent('hit-policy') || NullComponent;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"decision-table-properties\", [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, DecisionTableName, {\n      \"className\": \"decision-table-name\",\n      \"value\": name,\n      \"ctrlForNewline\": true,\n      \"onBlur\": resetScroll,\n      \"onChange\": this.setDecisionTableName,\n      \"elementId\": '__decisionProperties_name',\n      \"coords\": '0:__decisionProperties'\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"decision-table-header-separator\"), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, HitPolicy)], 4);\n  }\n}\nDecisionTablePropertiesComponent.$inject = ['sheet', 'modeling', 'changeSupport', 'components'];\nclass DecisionTableName extends EditableComponent {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    (0,mixin/* default */.Z)(this, SelectionAware/* default */.Z);\n  }\n  render() {\n    const name = this.props.value;\n    const className = (0,classNames/* default */.Z)(this.getSelectionClasses(), this.getClassName());\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", className, this.getEditor(), 0, {\n      \"data-element-id\": this.props.elementId,\n      \"data-coords\": this.props.coords,\n      \"title\": this._translate('Decision Name: ') + name\n    });\n  }\n}\nfunction NullComponent() {\n  return null;\n}\nfunction resetScroll(event) {\n  event.target.scroll(0, 0);\n}\n//# sourceMappingURL=DecisionTablePropertiesEditorComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-properties/DecisionTablePropertiesEditor.js\n\nconst DecisionTablePropertiesEditor_LOW_PRIORITY = 500;\nclass DecisionTableProperties {\n  constructor(components) {\n    components.onGetComponent('table.before', DecisionTablePropertiesEditor_LOW_PRIORITY, () => {\n      return DecisionTablePropertiesComponent;\n    });\n  }\n}\nDecisionTableProperties.$inject = ['components'];\n//# sourceMappingURL=DecisionTablePropertiesEditor.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-table-properties/editor.js\n\n\n/* harmony default export */ const decision_table_properties_editor = ({\n  __depends__: [debounce_input],\n  __init__: ['decisionTableProperties'],\n  decisionTableProperties: ['type', DecisionTableProperties]\n});\n//# sourceMappingURL=editor.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-decision-table/lib/features/hit-policy/HitPolicies.js\nvar HitPolicies = __webpack_require__(\"./node_modules/dmn-js-decision-table/lib/features/hit-policy/HitPolicies.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/hit-policy/editor/components/EditableHitPolicy.js\n\nfunction EditableHitPolicy_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction EditableHitPolicy_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? EditableHitPolicy_ownKeys(Object(source), !0).forEach(function (key) { EditableHitPolicy_defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : EditableHitPolicy_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction EditableHitPolicy_defineProperty(obj, key, value) { key = EditableHitPolicy_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction EditableHitPolicy_toPropertyKey(arg) { var key = EditableHitPolicy_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction EditableHitPolicy_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\n\nclass EditableHitPolicy extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    EditableHitPolicy_defineProperty(this, \"onChange\", _ref => {\n      let aggregation = _ref.aggregation,\n        hitPolicy = _ref.hitPolicy;\n      this.modeling.editHitPolicy(hitPolicy, aggregation);\n    });\n    EditableHitPolicy_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    this._translate = context.injector.get('translate');\n    (0,inject/* inject */.f)(this);\n  }\n  componentDidMount() {\n    this.changeSupport.onElementsChanged(this.getRoot().id, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    this.changeSupport.offElementsChanged(this.getRoot().id, this.onElementsChanged);\n  }\n  getRoot() {\n    return this.sheet.getRoot();\n  }\n  render() {\n    const root = this.getRoot(),\n      businessObject = root.businessObject;\n    const aggregation = businessObject.aggregation,\n      hitPolicy = businessObject.hitPolicy;\n    const hitPolicyEntry = (0,node_modules_min_dash_dist_index_esm/* find */.sE)(HitPolicies/* HIT_POLICIES */.s, entry => {\n      return isEqualHitPolicy(entry.value, {\n        aggregation,\n        hitPolicy\n      });\n    });\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"hit-policy\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"label\", \"dms-label\", this._translate('Hit Policy:'), 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"className\": \"hit-policy-edit-policy-select\",\n      \"onChange\": this.onChange,\n      \"options\": HitPolicies/* HIT_POLICIES.map */.s.map(entry => EditableHitPolicy_objectSpread(EditableHitPolicy_objectSpread({}, entry), {}, {\n        label: this._translate(entry.label)\n      })),\n      \"value\": hitPolicyEntry.value,\n      \"data-hit-policy\": \"true\",\n      \"noInput\": true\n    })], 4, {\n      \"title\": this._translate(hitPolicyEntry.explanation)\n    });\n  }\n}\nEditableHitPolicy.$inject = ['changeSupport', 'sheet', 'modeling'];\n\n// helpers //////////////////////\nfunction isEqualHitPolicy(a, b) {\n  return a.hitPolicy === b.hitPolicy && a.aggregation === b.aggregation;\n}\n//# sourceMappingURL=EditableHitPolicy.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/hit-policy/editor/HitPolicyEditingProvider.js\n\nfunction HitPolicyEditingProvider(components) {\n  components.onGetComponent('hit-policy', () => {\n    return EditableHitPolicy;\n  });\n}\nHitPolicyEditingProvider.$inject = ['components'];\n//# sourceMappingURL=HitPolicyEditingProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/hit-policy/editor/index.js\n\n\n/* harmony default export */ const hit_policy_editor = ({\n  __depends__: [context_menu/* default */.Z],\n  __init__: ['hitPolicyProvider'],\n  hitPolicyProvider: ['type', HitPolicyEditingProvider]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/DmnUpdater.js\n\n\n\n/**\n * A handler responsible for updating the underlying DMN\n * once changes on the table happen.\n */\nclass DmnUpdater extends CommandInterceptor/* default */.Z {\n  constructor(eventBus, sheet) {\n    super(eventBus);\n    this.executed(['row.add', 'row.remove', 'col.add', 'col.remove'], ifDmn(e => {\n      var context = e.context;\n      var element = context.row || context.col;\n      this.updateRoot(element, context.oldRoot);\n    }));\n    this.reverted(['row.add', 'row.remove', 'col.add', 'col.remove'], ifDmn(e => {\n      var context = e.context;\n      var element = context.row || context.col;\n      this.updateRoot(element, context.newRoot);\n    }));\n  }\n  updateRoot(element, oldRoot) {\n    var newRoot = element.root;\n    var businessObject = element.businessObject;\n    if ((0,ModelUtil.is)(element, 'dmn:DecisionRule')) {\n      // we're removing\n      if (oldRoot) {\n        let oldTable = oldRoot.businessObject;\n        let oldRules = oldTable.get('rule');\n        let oldIdx = oldRules.indexOf(businessObject);\n\n        // unwire Row <-> Table\n        oldRules.splice(oldIdx, 1);\n        businessObject.$parent = null;\n      }\n\n      // we're adding\n      if (newRoot) {\n        let newTable = newRoot.businessObject;\n        let newIdx = newRoot.rows.indexOf(element);\n\n        // wire Row <-> Table\n        newTable.get('rule').splice(newIdx, 0, businessObject);\n        businessObject.$parent = newTable;\n        element.cells.forEach((cell, idx) => {\n          // wire Cell <-> Row\n          this.wireCell(cell, element, idx);\n        });\n      }\n    }\n    if ((0,ModelUtil.is)(element, 'dmn:InputClause') || (0,ModelUtil.is)(element, 'dmn:OutputClause')) {\n      let collection, collectionIdx;\n\n      // we're removing\n      if (oldRoot) {\n        let oldTable = oldRoot.businessObject;\n        let inputs = oldTable.get('input');\n        let outputs = oldTable.get('output');\n        if ((0,ModelUtil.is)(element, 'dmn:InputClause')) {\n          collection = inputs;\n          collectionIdx = inputs.indexOf(businessObject);\n        }\n        if ((0,ModelUtil.is)(element, 'dmn:OutputClause')) {\n          collection = outputs;\n          collectionIdx = outputs.indexOf(businessObject);\n        }\n        if (collectionIdx === -1) {\n          throw new Error('inconsistent model: clause not in table');\n        }\n\n        // unwire Col <-> Table\n        collection.splice(collectionIdx, 1);\n        businessObject.$parent = null;\n        element.cells.forEach((cel, rowIdx) => {\n          // unwire Cell <-> Row\n          this.unwireCell(cel, oldRoot.rows[rowIdx]);\n        });\n      }\n      if (newRoot) {\n        let newTable = newRoot.businessObject;\n        let inputs = newTable.get('input');\n        let outputs = newTable.get('output');\n        let colIdx = newRoot.cols.indexOf(element);\n        let collectionIdx, collection;\n        if ((0,ModelUtil.is)(element, 'dmn:InputClause')) {\n          collection = inputs;\n          collectionIdx = colIdx;\n        }\n        if ((0,ModelUtil.is)(element, 'dmn:OutputClause')) {\n          collection = outputs;\n          collectionIdx = colIdx - inputs.length;\n        }\n\n        // wire Col <-> Table\n        collection.splice(collectionIdx, 0, businessObject);\n        businessObject.$parent = newTable;\n        element.cells.forEach((cell, rowIdx) => {\n          // wire Cell <-> Row\n          this.wireCell(cell, newRoot.rows[rowIdx], colIdx);\n        });\n      }\n    }\n  }\n  unwireCell(cell, oldRow) {\n    var cellBo = cell.businessObject;\n    let oldRowBo = oldRow.businessObject;\n    let inputEntries = oldRowBo.get('inputEntry');\n    let outputEntries = oldRowBo.get('outputEntry');\n    let collection, collectionIdx;\n\n    // remove from inputEntries\n    if ((0,ModelUtil.is)(cell, 'dmn:UnaryTests')) {\n      collection = inputEntries;\n    }\n\n    // remove from outputEntries\n    if ((0,ModelUtil.is)(cell, 'dmn:LiteralExpression')) {\n      collection = outputEntries;\n    }\n    collectionIdx = collection.indexOf(cellBo);\n    if (collectionIdx === -1) {\n      throw new Error('cell not in row');\n    }\n\n    // unwire Cell <-> Row relationship\n    collection.splice(collectionIdx, 1);\n    cellBo.$parent = null;\n  }\n  wireCell(cell, row, colIdx) {\n    var cellBo = cell.businessObject;\n    let rowBo = row.businessObject;\n    let inputEntries = rowBo.get('inputEntry');\n    let outputEntries = rowBo.get('outputEntry');\n    let collection, collectionIdx;\n\n    // ensure we handle already wired cells\n    if (cellBo.$parent === rowBo) {\n      return;\n    }\n\n    // add to inputEntries\n    if ((0,ModelUtil.is)(cell, 'dmn:UnaryTests')) {\n      collection = inputEntries;\n      collectionIdx = colIdx;\n    }\n\n    // add to outputEntries\n    if ((0,ModelUtil.is)(cell, 'dmn:LiteralExpression')) {\n      collection = outputEntries;\n      collectionIdx = colIdx - inputEntries.length;\n    }\n\n    // wire Cell <-> Row relationship\n    collection.splice(collectionIdx, 0, cellBo);\n    cellBo.$parent = rowBo;\n  }\n}\nDmnUpdater.$inject = ['eventBus', 'sheet'];\n\n// helpers //////////////////////\n\n/**\n * Make sure the event listener is only called\n * if the touched element is a DMN element.\n *\n * @param  {Function} fn\n * @return {Function} guarded function\n */\nfunction ifDmn(fn) {\n  return function (event) {\n    var context = event.context,\n      element = context.row || context.col;\n    if ((0,ModelUtil.is)(element, 'dmn:DMNElement')) {\n      fn(event);\n    }\n  };\n}\n//# sourceMappingURL=DmnUpdater.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/DmnFactory.js\n\nclass DmnFactory {\n  constructor(moddle) {\n    this._model = moddle;\n  }\n  create(type) {\n    let attrs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    var element = this._model.create(type, attrs || {});\n    if ((0,ModelUtil.is)(element, 'dmn:InputClause')) {\n      if (attrs.inputExpression) {\n        element.inputExpression = attrs.inputExpression;\n      } else {\n        element.inputExpression = this.create('dmn:LiteralExpression', {\n          typeRef: 'string'\n        });\n        element.inputExpression.$parent = element;\n      }\n    }\n    if ((0,ModelUtil.is)(element, 'dmn:OutputClause')) {\n      element.typeRef = attrs.typeRef || 'string';\n    }\n    if ((0,ModelUtil.is)(element, 'dmn:UnaryTests') || (0,ModelUtil.is)(element, 'dmn:LiteralExpression')) {\n      element.text = attrs.text || '';\n    }\n    this._ensureId(element);\n    return element;\n  }\n  _needsId(element) {\n    return (0,ModelUtil.is)(element, 'dmn:DMNElement');\n  }\n  _ensureId(element) {\n    // generate semantic ids for elements\n    // dmn:UnaryTests -> UnaryTests_ID\n    var prefix = (element.$type || '').replace(/^[^:]*:/g, '') + '_';\n    if (!element.id && this._needsId(element)) {\n      element.id = this._model.ids.nextPrefixed(prefix, element);\n    }\n  }\n}\nDmnFactory.$inject = ['moddle'];\n//# sourceMappingURL=DmnFactory.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/core/ElementFactory.js\nvar core_ElementFactory = __webpack_require__(\"./node_modules/table-js/lib/core/ElementFactory.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/ElementFactory.js\nconst ElementFactory_excluded = [\"businessObject\", \"type\"];\nfunction ElementFactory_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction ElementFactory_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ElementFactory_ownKeys(Object(source), !0).forEach(function (key) { ElementFactory_defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ElementFactory_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction ElementFactory_defineProperty(obj, key, value) { key = ElementFactory_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction ElementFactory_toPropertyKey(arg) { var key = ElementFactory_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction ElementFactory_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nfunction ElementFactory_objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = ElementFactory_objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }\nfunction ElementFactory_objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\n\n\nclass modeling_ElementFactory_ElementFactory extends core_ElementFactory/* default */.Z {\n  constructor(dmnFactory) {\n    super();\n    this._dmnFactory = dmnFactory;\n  }\n  create(tType, attrs) {\n    const dmnFactory = this._dmnFactory;\n    let businessObject = attrs.businessObject,\n      type = attrs.type,\n      additionalAttrs = ElementFactory_objectWithoutProperties(attrs, ElementFactory_excluded);\n    if (!businessObject) {\n      if (!type) {\n        if (tType === 'root') {\n          type = 'dmn:DecisionTable';\n        } else if (tType === 'cell') {\n          let col = additionalAttrs.col;\n          if ((0,ModelUtil.is)(col, 'dmn:OutputClause')) {\n            type = 'dmn:LiteralExpression';\n          }\n          if ((0,ModelUtil.is)(col, 'dmn:InputClause')) {\n            type = 'dmn:UnaryTests';\n          }\n        }\n        if (!type) {\n          throw new Error('cannot guess <type>');\n        }\n      }\n      businessObject = dmnFactory.create(type);\n    }\n    return super.create(tType, ElementFactory_objectSpread({\n      businessObject,\n      id: businessObject.id\n    }, additionalAttrs));\n  }\n}\nmodeling_ElementFactory_ElementFactory.$inject = ['dmnFactory'];\n//# sourceMappingURL=ElementFactory.js.map\n// EXTERNAL MODULE: ./node_modules/table-js/lib/features/modeling/Modeling.js + 7 modules\nvar modeling_Modeling = __webpack_require__(\"./node_modules/table-js/lib/features/modeling/Modeling.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/cmd/UpdateAllowedValuesHandler.js\n\n\n/**\n * A handler that implements adding/removing allowed values.\n */\nclass UpdateAllowedValuesHandler {\n  constructor(dmnFactory, moddle, modeling) {\n    this._dmnFactory = dmnFactory;\n    this._moddle = moddle;\n    this._modeling = modeling;\n  }\n\n  /**\n   * <do>\n   */\n  execute(context) {\n    const element = context.element,\n      allowedValues = context.allowedValues;\n    const isInput = (0,ModelUtil.is)(element, 'dmn:InputClause');\n    if (isInput) {\n      if (element.inputValues) {\n        context.oldAllowedValues = element.inputValues.text;\n      } else {\n        if (!UpdateAllowedValuesHandler_isNull(allowedValues)) {\n          element.inputValues = this._dmnFactory.create('dmn:UnaryTests', {\n            text: ''\n          });\n        }\n      }\n      if (UpdateAllowedValuesHandler_isNull(allowedValues)) {\n        if (element.inputValues) {\n          delete element.inputValues;\n        }\n      } else {\n        element.inputValues.text = allowedValues.join(',');\n      }\n    } else {\n      if (element.outputValues && element) {\n        context.oldAllowedValues = element.outputValues.text;\n      } else {\n        if (!UpdateAllowedValuesHandler_isNull(allowedValues)) {\n          element.outputValues = this._dmnFactory.create('dmn:UnaryTests', {\n            text: ''\n          });\n        }\n      }\n      if (UpdateAllowedValuesHandler_isNull(allowedValues)) {\n        if (element.outputValues) {\n          delete element.outputValues;\n        }\n      } else {\n        element.outputValues.text = allowedValues.join(',');\n      }\n    }\n    return element;\n  }\n\n  /**\n   * <undo>\n   */\n  revert(context) {\n    const element = context.element,\n      oldAllowedValues = context.oldAllowedValues;\n    const isInput = (0,ModelUtil.is)(element, 'dmn:InputClause');\n    if (isInput) {\n      if (oldAllowedValues) {\n        if (!element.inputValues) {\n          element.inputValues = this._dmnFactory.create('dmn:UnaryTests', {\n            text: ''\n          });\n        }\n        element.inputValues.text = oldAllowedValues;\n      } else {\n        delete element.inputValues;\n      }\n    } else {\n      if (oldAllowedValues) {\n        if (!element.outputValues) {\n          element.outputValues = this._dmnFactory.create('dmn:UnaryTests', {\n            text: ''\n          });\n        }\n        element.outputValues.text = oldAllowedValues;\n      } else {\n        delete element.outputValues;\n      }\n    }\n    return element;\n  }\n}\nUpdateAllowedValuesHandler.$inject = ['dmnFactory', 'moddle', 'modeling'];\n\n// helpers //////////////////////\n\nfunction UpdateAllowedValuesHandler_isNull(value) {\n  return value === null;\n}\n//# sourceMappingURL=UpdateAllowedValuesHandler.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-shared/lib/features/modeling/cmd/UpdatePropertiesHandler.js\nfunction UpdatePropertiesHandler_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction UpdatePropertiesHandler_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? UpdatePropertiesHandler_ownKeys(Object(source), !0).forEach(function (key) { UpdatePropertiesHandler_defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : UpdatePropertiesHandler_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction UpdatePropertiesHandler_defineProperty(obj, key, value) { key = UpdatePropertiesHandler_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction UpdatePropertiesHandler_toPropertyKey(arg) { var key = UpdatePropertiesHandler_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction UpdatePropertiesHandler_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nconst cmd_UpdatePropertiesHandler_ID = 'id';\n\n/**\n * A generic handler that implements property editing.\n */\nclass EditPropertiesHandler {\n  constructor(elementRegistry, moddle) {\n    this._elementRegistry = elementRegistry;\n    this._moddle = moddle;\n  }\n\n  /**\n   * <do>\n   */\n  execute(context) {\n    const element = context.element,\n      properties = context.properties;\n    const bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    const _this$updatePropertie = this.updateProperties(bo, properties),\n      changed = _this$updatePropertie.changed,\n      oldProperties = _this$updatePropertie.oldProperties;\n    context.oldProperties = oldProperties;\n    return [...changed, element];\n  }\n\n  /**\n   * <undo>\n   */\n  revert(context) {\n    const element = context.element,\n      oldProperties = context.oldProperties;\n    var bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n    var _this$updatePropertie2 = this.updateProperties(bo, oldProperties),\n      changed = _this$updatePropertie2.changed;\n    return [...changed, element];\n  }\n\n  /**\n   * Update properties of the given business object\n   * and return { changed, oldProperties }.\n   */\n  updateProperties(bo, newProps) {\n    const ids = this._moddle.ids;\n\n    // Reduce over all new properties and return\n    //\n    // {\n    //  changed,\n    //  oldProperties\n    // }\n    return (0,min_dash_dist_index_esm/* reduce */.u4)(newProps, (result, value, key) => {\n      const propertyValue = bo.get(key);\n\n      // handle nested update\n      if (isContainer(value)) {\n        if (!isContainer(propertyValue)) {\n          throw new Error(\"non-existing property <\".concat(key, \">: cannot update values\"));\n        }\n        let _this$updatePropertie3 = this.updateProperties(propertyValue, value),\n          changed = _this$updatePropertie3.changed,\n          oldProperties = _this$updatePropertie3.oldProperties;\n        return {\n          changed: [...result.changed, ...changed, propertyValue],\n          oldProperties: UpdatePropertiesHandler_objectSpread(UpdatePropertiesHandler_objectSpread({}, result.oldProperties), {}, {\n            [key]: oldProperties\n          })\n        };\n      }\n\n      // handle ID change\n      if (key === cmd_UpdatePropertiesHandler_ID && cmd_UpdatePropertiesHandler_isIdChange(bo, value)) {\n        ids.unclaim(bo[cmd_UpdatePropertiesHandler_ID]);\n        this._elementRegistry.updateId(bo, value);\n        ids.claim(value, bo);\n      }\n\n      // handle plain update\n      bo.set(key, value);\n      return {\n        changed: result.changed,\n        oldProperties: UpdatePropertiesHandler_objectSpread(UpdatePropertiesHandler_objectSpread({}, result.oldProperties), {}, {\n          [key]: propertyValue\n        })\n      };\n    }, {\n      changed: [],\n      oldProperties: {}\n    });\n  }\n}\nEditPropertiesHandler.$inject = ['elementRegistry', 'moddle'];\n\n// helpers //////////////////////\n\nfunction cmd_UpdatePropertiesHandler_isIdChange(element, newId) {\n  return element[cmd_UpdatePropertiesHandler_ID] !== newId;\n}\nfunction isContainer(o) {\n  return (0,min_dash_dist_index_esm/* isDefined */.$K)(o) && (0,min_dash_dist_index_esm/* isObject */.Kn)(o);\n}\n//# sourceMappingURL=UpdatePropertiesHandler.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/cmd/IdClaimHandler.js\nclass IdClaimHandler_IdClaimHandler {\n  constructor(moddle) {\n    this._moddle = moddle;\n  }\n\n  /**\r\n   * <do>\r\n   */\n  execute(context) {\n    const ids = this._moddle.ids,\n      id = context.id,\n      element = context.element,\n      claiming = context.claiming;\n    if (claiming) {\n      ids.claim(id, element);\n    } else {\n      ids.unclaim(id);\n    }\n  }\n\n  /**\r\n   * <undo>\r\n   */\n  revert(context) {\n    const ids = this._moddle.ids,\n      id = context.id,\n      element = context.element,\n      claiming = context.claiming;\n    if (claiming) {\n      ids.unclaim(id);\n    } else {\n      ids.claim(id, element);\n    }\n  }\n}\nIdClaimHandler_IdClaimHandler.$inject = ['moddle'];\n//# sourceMappingURL=IdClaimHandler.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/Modeling.js\n\n\n\n\n\nclass modeling_Modeling_Modeling extends modeling_Modeling/* default */.Z {\n  constructor(eventBus, elementFactory, commandStack, sheet) {\n    super(eventBus, elementFactory, commandStack);\n    this._eventBus = eventBus;\n    this._elementFactory = elementFactory;\n    this._commandStack = commandStack;\n    this._sheet = sheet;\n  }\n  getHandlers() {\n    return modeling_Modeling_Modeling._getHandlers();\n  }\n  static _getHandlers() {\n    return (0,node_modules_min_dash_dist_index_esm/* assign */.f0)({}, super._getHandlers(), {\n      'editAllowedValues': UpdateAllowedValuesHandler,\n      'element.updateProperties': EditPropertiesHandler,\n      'id.updateClaim': IdClaimHandler_IdClaimHandler\n    });\n  }\n  editDecisionTableName(name) {\n    const root = this._sheet.getRoot(),\n      businessObject = root.businessObject,\n      parentBusinessObject = businessObject.$parent;\n    const context = {\n      element: parentBusinessObject,\n      properties: {\n        name\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editDecisionTableId(id) {\n    const root = this._sheet.getRoot(),\n      businessObject = root.businessObject,\n      parentBusinessObject = businessObject.$parent;\n    const context = {\n      element: parentBusinessObject,\n      properties: {\n        id\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editHitPolicy(hitPolicy, aggregation) {\n    const root = this._sheet.getRoot(),\n      businessObject = root.businessObject;\n    const context = {\n      element: businessObject,\n      properties: {\n        hitPolicy,\n        aggregation\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  updateProperties(el, props) {\n    const context = {\n      element: el,\n      properties: props\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editInputExpression(inputExpression, props) {\n    const context = {\n      element: inputExpression,\n      properties: props\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editOutputName(output, name) {\n    const context = {\n      element: output,\n      properties: {\n        name\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editInputExpressionTypeRef(inputExpression, typeRef) {\n    const context = {\n      element: inputExpression,\n      properties: {\n        typeRef\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editOutputTypeRef(output, typeRef) {\n    const context = {\n      element: output,\n      properties: {\n        typeRef\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editCell(cell, text) {\n    const context = {\n      element: cell,\n      properties: {\n        text\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editAnnotation(rule, description) {\n    const context = {\n      element: rule,\n      properties: {\n        description\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editAllowedValues(element, allowedValues) {\n    const context = {\n      element,\n      allowedValues\n    };\n    this._commandStack.execute('editAllowedValues', context);\n  }\n  editExpressionLanguage(element, expressionLanguage) {\n    const context = {\n      element,\n      properties: {\n        expressionLanguage\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  claimId(id, moddleElement) {\n    const context = {\n      id: id,\n      element: moddleElement,\n      claiming: true\n    };\n    this._commandStack.execute('id.updateClaim', context);\n  }\n  unclaimId(id, moddleElement) {\n    const context = {\n      id: id,\n      element: moddleElement\n    };\n    this._commandStack.execute('id.updateClaim', context);\n  }\n}\nmodeling_Modeling_Modeling.$inject = ['eventBus', 'elementFactory', 'commandStack', 'sheet'];\n//# sourceMappingURL=Modeling.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/behavior/IdClaimBehavior.js\n\n\nclass IdClaimBehavior extends CommandInterceptor/* default */.Z {\n  constructor(eventBus, moddle, modeling) {\n    super(eventBus);\n    this._ids = moddle.ids;\n    this._modeling = modeling;\n    this.preExecute(['row.add', 'col.add'], event => {\n      const context = event.context,\n        element = context.row || context.col;\n      this.claimId(element.businessObject);\n      if (element.cells) {\n        element.cells.forEach(cell => this.claimId(cell.businessObject));\n      }\n    });\n  }\n  claimId(businessObject) {\n    if (businessObject.id && !this._ids.assigned(businessObject.id)) {\n      this._modeling.claimId(businessObject.id, businessObject);\n    }\n    businessObject.$descriptor.properties.forEach(property => {\n      const value = businessObject[property.name];\n\n      // not set\n      if (!value) {\n        return;\n      }\n\n      // array of moddle elements\n      if ((0,node_modules_min_dash_dist_index_esm/* isArray */.kJ)(value)) {\n        value.forEach(v => this.claimId(v));\n      }\n\n      // moddle element\n      if (value.$type) {\n        this.claimId(value);\n      }\n    });\n  }\n}\nIdClaimBehavior.$inject = ['eventBus', 'moddle', 'modeling'];\n//# sourceMappingURL=IdClaimBehavior.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/behavior/IdUnclaimBehavior.js\n\n\nclass IdUnclaimBehavior extends CommandInterceptor/* default */.Z {\n  constructor(eventBus, modeling) {\n    super(eventBus);\n    this._modeling = modeling;\n    this.preExecute(['row.remove', 'col.remove'], event => {\n      const context = event.context,\n        element = context.row || context.col;\n      this.unclaimId(element.businessObject);\n      if (element.cells) {\n        element.cells.forEach(cell => this.unclaimId(cell.businessObject));\n      }\n    });\n  }\n  unclaimId(businessObject) {\n    if (businessObject.id) {\n      this._modeling.unclaimId(businessObject.id, businessObject);\n    }\n    businessObject.$descriptor.properties.forEach(property => {\n      const value = businessObject[property.name];\n\n      // not set\n      if (!value) {\n        return;\n      }\n\n      // array of moddle elements\n      if ((0,node_modules_min_dash_dist_index_esm/* isArray */.kJ)(value)) {\n        value.forEach(v => this.unclaimId(v));\n      }\n\n      // moddle element\n      if (value.$type) {\n        this.unclaimId(value);\n      }\n    });\n  }\n}\nIdUnclaimBehavior.$inject = ['eventBus', 'modeling'];\n//# sourceMappingURL=IdUnclaimBehavior.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/behavior/index.js\n\n\n/* harmony default export */ const modeling_behavior = ({\n  __init__: ['idClaimBehavior', 'idUnclaimBehavior'],\n  idClaimBehavior: ['type', IdClaimBehavior],\n  idUnclaimBehavior: ['type', IdUnclaimBehavior]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/modeling/index.js\n\n\n\n\n\n\n\n/* harmony default export */ const features_modeling = ({\n  __init__: ['dmnUpdater', 'idChangeBehavior', 'modeling'],\n  __depends__: [modeling_behavior, command/* default */.Z],\n  dmnUpdater: ['type', DmnUpdater],\n  dmnFactory: ['type', DmnFactory],\n  elementFactory: ['type', modeling_ElementFactory_ElementFactory],\n  idChangeBehavior: ['type', IdChangeBehavior],\n  modeling: ['type', modeling_Modeling_Modeling]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/components/DecisionRulesCellEditorComponent.js\n\n\n\n\n\n\nclass DecisionRulesCellEditorComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this.state = {\n      isFocussed: false\n    };\n    this.changeCellValue = this.changeCellValue.bind(this);\n    this.onFocus = this.onFocus.bind(this);\n    this.onBlur = this.onBlur.bind(this);\n    this.onElementsChanged = this.onElementsChanged.bind(this);\n  }\n  onElementsChanged() {\n    this.forceUpdate();\n  }\n  componentWillMount() {\n    const injector = this.context.injector;\n    const cell = this.props.cell;\n    const changeSupport = this._changeSupport = this.context.changeSupport;\n    this._modeling = injector.get('modeling');\n    changeSupport.onElementsChanged(cell.id, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    const cell = this.props.cell;\n    this._changeSupport.offElementsChanged(cell.id, this.onElementsChanged);\n  }\n  changeCellValue(value) {\n    const cell = this.props.cell;\n    this._modeling.editCell(cell.businessObject, value);\n  }\n  onFocus() {\n    this.setState({\n      isFocussed: true\n    });\n  }\n  onBlur() {\n    this.setState({\n      isFocussed: false\n    });\n  }\n  render() {\n    const _this$props = this.props,\n      cell = _this$props.cell,\n      rowIndex = _this$props.rowIndex,\n      row = _this$props.row,\n      col = _this$props.col,\n      colIndex = _this$props.colIndex;\n    const isFocussed = this.state.isFocussed;\n    const isUnaryTest = (0,ModelUtil.is)(cell, 'dmn:UnaryTests');\n    const businessObject = cell.businessObject;\n    return (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Cell/* default */.Z, {\n      \"className\": isUnaryTest ? 'input-cell' : 'output-cell',\n      \"elementId\": cell.id,\n      \"coords\": \"\".concat(rowIndex, \":\").concat(colIndex),\n      \"data-row-id\": row.id,\n      \"data-col-id\": col.id,\n      children: (0,inferno_index_esm/* createComponentVNode */.Iz)(2, TableCellEditor, {\n        \"className\": \"cell-editor\",\n        \"placeholder\": isUnaryTest ? '-' : '',\n        \"ctrlForNewline\": true,\n        \"onFocus\": this.onFocus,\n        \"onBlur\": this.onBlur,\n        \"isFocussed\": isFocussed,\n        \"onChange\": this.changeCellValue,\n        \"value\": businessObject.text,\n        \"businessObject\": businessObject\n      })\n    });\n  }\n}\nclass TableCellEditor extends EditableComponent {\n  constructor(props, context) {\n    super(props, context);\n    this._expressionLanguages = context.injector.get('expressionLanguages');\n    this._translate = context.injector.get('translate');\n  }\n  isDefaultExpressionLanguage(businessObject) {\n    const expressionLanguage = businessObject.expressionLanguage;\n    const defaultExpressionLanguage = this.getDefaultExpressionLanguage(businessObject).value;\n    return !expressionLanguage || expressionLanguage === defaultExpressionLanguage;\n  }\n  getDescription(businessObject) {\n    return businessObject.description;\n  }\n  getExpressionLanguageLabel(businessObject) {\n    const expressionLanguage = businessObject.expressionLanguage;\n    const defaultExpressionLanguage = this.getDefaultExpressionLanguage(businessObject);\n    return this._expressionLanguages.getLabel(expressionLanguage) || defaultExpressionLanguage.label;\n  }\n  isScript(businessObject) {\n    const defaultExpressionLanguage = this.getDefaultExpressionLanguage(businessObject);\n    const isInputCell = (0,ModelUtil.is)(businessObject, 'dmn:UnaryTests');\n    if (!isInputCell) {\n      return false;\n    }\n    if (businessObject.text.indexOf('\\n') !== -1) {\n      return true;\n    }\n    return businessObject.expressionLanguage && businessObject.expressionLanguage !== defaultExpressionLanguage;\n  }\n  getDefaultExpressionLanguage(businessObject) {\n    const elementType = (0,ModelUtil.is)(businessObject, 'dmn:UnaryTests') ? 'inputCell' : 'outputCell';\n    return this._expressionLanguages.getDefault(elementType);\n  }\n  render() {\n    const _this$props2 = this.props,\n      businessObject = _this$props2.businessObject,\n      isFocussed = _this$props2.isFocussed;\n    const description = this.getDescription(businessObject);\n    const isDefaultExpressionLanguage = this.isDefaultExpressionLanguage(businessObject);\n    const expressionLanguageLabel = this.getExpressionLanguageLabel(businessObject);\n    const isScript = this.isScript(businessObject);\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", this.getClassName(), [(0,node_modules_min_dash_dist_index_esm/* isString */.HD)(description) && !isFocussed && (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"description-indicator\"), this.getEditor({\n      className: isScript ? 'script-editor' : null\n    }), !isDefaultExpressionLanguage && !isFocussed && (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"dms-badge dmn-expression-language\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"dms-badge-icon dmn-icon-file-code\"), (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"dms-badge-label\", expressionLanguageLabel, 0)], 4, {\n      \"title\": this._translate('Expression Language = {expressionLanguageLabel}', {\n        expressionLanguageLabel\n      })\n    })], 0);\n  }\n}\n//# sourceMappingURL=DecisionRulesCellEditorComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/DecisionRulesEditor.js\n\nconst DecisionRulesEditor_HIGH_PRIORITY = 1500;\nclass RulesEditor {\n  constructor(components) {\n    components.onGetComponent('cell', DecisionRulesEditor_HIGH_PRIORITY, _ref => {\n      let cellType = _ref.cellType;\n      if (cellType === 'rule') {\n        return DecisionRulesCellEditorComponent;\n      }\n    });\n  }\n}\nRulesEditor.$inject = ['components'];\n//# sourceMappingURL=DecisionRulesEditor.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/index.js + 4 modules\nvar decision_rules = __webpack_require__(\"./node_modules/dmn-js-decision-table/lib/features/decision-rules/index.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/decision-rules/editor.js\n\n\n\n/* harmony default export */ const decision_rules_editor = ({\n  __depends__: [debounce_input, decision_rules/* default */.Z],\n  __init__: ['decisionRulesEditor'],\n  decisionRulesEditor: ['type', RulesEditor]\n});\n//# sourceMappingURL=editor.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-mode/components/SimpleModeButtonComponent.js\n\nfunction SimpleModeButtonComponent_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction SimpleModeButtonComponent_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? SimpleModeButtonComponent_ownKeys(Object(source), !0).forEach(function (key) { SimpleModeButtonComponent_defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : SimpleModeButtonComponent_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction SimpleModeButtonComponent_defineProperty(obj, key, value) { key = SimpleModeButtonComponent_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction SimpleModeButtonComponent_toPropertyKey(arg) { var key = SimpleModeButtonComponent_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction SimpleModeButtonComponent_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\n\n\nconst OFFSET = 4;\nclass SimpleModeButtonComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this.state = {\n      top: 0,\n      left: 0,\n      isVisible: false,\n      isDisabled: false,\n      selection: null\n    };\n    (0,inject/* inject */.f)(this);\n    const debounceInput = this.debounceInput;\n    this.onClick = this.onClick.bind(this);\n    this.handleSelectionChanged = this.handleSelectionChanged.bind(this);\n    this.hideAndShowDebounced = this.hideAndShowDebounced.bind(this);\n    this.showDebounced = debounceInput(this.showDebounced.bind(this));\n    this.updatePosition = this.updatePosition.bind(this);\n  }\n  componentDidMount() {\n    const eventBus = this.eventBus;\n    eventBus.on('cellSelection.changed', this.handleSelectionChanged);\n    eventBus.on('commandStack.changed', this.updatePosition);\n    eventBus.on('sheet.scroll', this.hideAndShowDebounced);\n  }\n  componentWillUnmount() {\n    const eventBus = this.eventBus;\n    eventBus.off('cellSelection.changed', this.handleSelectionChanged);\n    eventBus.off('commandStack.changed', this.updatePosition);\n    eventBus.off('sheet.scroll', this.hideAndShowDebounced);\n  }\n  hideAndShowDebounced() {\n    if (this.state.isVisible) {\n      this.hide();\n      this.showDebounced();\n    }\n  }\n  showDebounced() {\n    this.show();\n  }\n  hide() {\n    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    this.setState(SimpleModeButtonComponent_objectSpread(SimpleModeButtonComponent_objectSpread({}, state), {}, {\n      isVisible: false\n    }));\n  }\n  show() {\n    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    this.setState(SimpleModeButtonComponent_objectSpread(SimpleModeButtonComponent_objectSpread({}, state), {}, {\n      isVisible: true\n    }));\n    this.updatePosition();\n  }\n  handleSelectionChanged(_ref) {\n    let elementId = _ref.elementId;\n    const elementRegistry = this.elementRegistry,\n      expressionLanguages = this.expressionLanguages,\n      simpleMode = this.simpleMode;\n    const selection = elementRegistry.get(elementId);\n    if (!selection || !simpleMode.canSimpleEdit(selection)) {\n      this.hide({\n        isDisabled: false,\n        selection: null\n      });\n      return;\n    }\n    const expressionLanguage = getExpressionLanguage(selection);\n    const isDisabled = !isDefaultExpressionLanguage(selection, expressionLanguage, expressionLanguages);\n    this.show({\n      isDisabled,\n      selection\n    });\n  }\n\n  // position button always on opposite site of context menu\n  updatePosition() {\n    const selection = this.state.selection;\n    const node = this.node;\n    if (!selection || !node) {\n      return;\n    }\n    const renderer = this.renderer;\n    const container = renderer.getContainer(),\n      containerBounds = container.getBoundingClientRect();\n    const cellNode = getNodeById(selection.id, container);\n    const cellBounds = cellNode.getBoundingClientRect();\n    const nodeBounds = this.node.getBoundingClientRect();\n    const _getTableContainerScr = getTableContainerScroll(node),\n      scrollLeft = _getTableContainerScr.scrollLeft,\n      scrollTop = _getTableContainerScr.scrollTop;\n    const nodePosition = {};\n    if (cellBounds.left + cellBounds.width / 2 > containerBounds.width / 2) {\n      // left\n      nodePosition.left = -containerBounds.left + cellBounds.left - nodeBounds.width + OFFSET + scrollLeft + 'px';\n      node.classList.remove('right');\n      node.classList.add('left');\n    } else {\n      // right\n      nodePosition.left = -containerBounds.left + cellBounds.left + cellBounds.width - OFFSET + scrollLeft + 'px';\n      node.classList.remove('left');\n      node.classList.add('right');\n    }\n    if (cellBounds.top + cellBounds.height / 2 > containerBounds.height / 2) {\n      // bottom\n      nodePosition.top = -containerBounds.top + cellBounds.top - nodeBounds.height + OFFSET + scrollTop + 'px';\n      node.classList.remove('top');\n      node.classList.add('bottom');\n    } else {\n      // top\n      nodePosition.top = -containerBounds.top + cellBounds.top - OFFSET + scrollTop + 'px';\n      node.classList.remove('bottom');\n      node.classList.add('top');\n    }\n    (0,node_modules_min_dash_dist_index_esm/* assign */.f0)(this.node.style, nodePosition);\n  }\n  onClick() {\n    const eventBus = this.eventBus;\n    const isDisabled = this.state.isDisabled;\n    if (isDisabled) {\n      return;\n    }\n    const selection = this.selection;\n    const element = selection.get();\n    if (!element) {\n      return;\n    }\n    eventBus.fire('simpleMode.open', {\n      element,\n      node: getNodeById(element.id, this._container)\n    });\n    this.hide();\n  }\n  render() {\n    const _this$state = this.state,\n      isDisabled = _this$state.isDisabled,\n      isVisible = _this$state.isVisible,\n      top = _this$state.top,\n      left = _this$state.left;\n    const classes = ['simple-mode-button', 'no-deselect'];\n    if (isDisabled) {\n      classes.push('disabled');\n    }\n    return isVisible ? (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", classes.join(' '), (0,inferno_index_esm/* createVNode */.Wm)(1, \"span\", \"dmn-icon-edit\"), 2, {\n      \"onClick\": this.onClick,\n      \"style\": {\n        top,\n        left\n      },\n      \"title\": isDisabled ? this._translate('Editing not supported for set expression language') : this._translate('Edit')\n    }, null, node => this.node = node) : null;\n  }\n}\nSimpleModeButtonComponent.$inject = ['debounceInput', 'elementRegistry', 'eventBus', 'expressionLanguages', 'renderer', 'selection', 'simpleMode'];\n\n// helpers //////////////////////\n\n/**\r\n * Return set expression language if found.\r\n *\r\n * @param {Cell} cell - Cell.\r\n */\nfunction getExpressionLanguage(cell) {\n  return cell.businessObject.expressionLanguage;\n}\nfunction isDefaultExpressionLanguage(cell, expressionLanguage, expressionLanguages) {\n  return !expressionLanguage || expressionLanguage === getDefaultExpressionLanguage(cell, expressionLanguages);\n}\nfunction getDefaultExpressionLanguage(cell, expressionLanguages) {\n  if ((0,ModelUtil/* isInput */.u7)(cell.col)) {\n    return expressionLanguages.getDefault('inputCell').value;\n  } else if ((0,ModelUtil/* isOutput */.RW)(cell.col)) {\n    return expressionLanguages.getDefault('outputCell').value;\n  }\n}\nfunction getTableContainerScroll(node) {\n  const tableContainer = (0,min_dom_dist_index_esm/* closest */.oq)(node, '.tjs-table-container');\n  if (!tableContainer) {\n    return {\n      scrollTop: 0,\n      scrollLeft: 0\n    };\n  }\n  const scrollLeft = tableContainer.scrollLeft,\n    scrollTop = tableContainer.scrollTop;\n  return {\n    scrollTop,\n    scrollLeft\n  };\n}\n//# sourceMappingURL=SimpleModeButtonComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-mode/SimpleMode.js\n\nclass SimpleMode {\n  constructor(components, contextMenu, elementRegistry, eventBus, renderer) {\n    this._providers = [];\n    components.onGetComponent('table.before', () => {\n      return SimpleModeButtonComponent;\n    });\n    eventBus.on('simpleMode.open', _ref => {\n      let element = _ref.element,\n        node = _ref.node;\n      const _node$getBoundingClie = node.getBoundingClientRect(),\n        left = _node$getBoundingClie.left,\n        top = _node$getBoundingClie.top,\n        width = _node$getBoundingClie.width,\n        height = _node$getBoundingClie.height;\n      const container = renderer.getContainer();\n      contextMenu.open({\n        x: left + container.parentNode.scrollLeft,\n        y: top + container.parentNode.scrollTop,\n        width,\n        height\n      }, {\n        contextMenuType: 'simple-mode-edit',\n        element,\n        offset: {\n          x: 4,\n          y: 4\n        }\n      });\n    });\n    eventBus.on('cell.click', e => {\n      const event = e.event,\n        node = e.node,\n        id = e.id;\n      if (SimpleMode_isCmd(event)) {\n        const element = elementRegistry.get(id);\n        if (element) {\n          eventBus.fire('simpleMode.open', {\n            node,\n            element\n          });\n        }\n\n        // prevent focus\n        e.preventDefault();\n      }\n    });\n  }\n  registerProvider(provider) {\n    this._providers.push(provider);\n  }\n  canSimpleEdit(element) {\n    return this._providers.reduce((canSimpleEdit, provider) => {\n      return canSimpleEdit || provider(element);\n    }, false);\n  }\n}\nSimpleMode.$inject = ['components', 'contextMenu', 'elementRegistry', 'eventBus', 'renderer'];\n\n// helpers //////////\n\nfunction SimpleMode_isCmd(event) {\n  // ensure we don't react to AltGr\n  // (mapped to CTRL + ALT)\n  if (event.altKey) {\n    return false;\n  }\n  return event.ctrlKey || event.metaKey;\n}\n//# sourceMappingURL=SimpleMode.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-mode/index.js\n\n\n\n\n/* harmony default export */ const simple_mode = ({\n  __depends__: [context_menu/* default */.Z, cell_selection, expression_languages/* default */.Z],\n  __init__: ['simpleMode'],\n  simpleMode: ['type', SimpleMode]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-boolean-edit/Utils.js\nfunction Utils_parseString(string) {\n  if (!string || Utils_isEmptyString(string)) {\n    return 'none';\n  } else if (string.trim() === 'true') {\n    return 'true';\n  } else if (string.trim() === 'false') {\n    return 'false';\n  }\n}\nfunction Utils_isEmptyString(string) {\n  return string === '';\n}\n//# sourceMappingURL=Utils.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-boolean-edit/components/BooleanEdit.js\n\n\n\n\nconst TRUE = 'true',\n  FALSE = 'false',\n  NONE = 'none';\nclass BooleanEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    const parsedString = Utils_parseString(element.businessObject.text);\n    this.state = {\n      value: parsedString || NONE\n    };\n    this.editCell = this.editCell.bind(this);\n    this.onChange = this.onChange.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onChange(value) {\n    const element = this.props.context.element;\n    this.editCell(element.businessObject, value === NONE ? '' : value);\n    this.setState({\n      value\n    });\n  }\n  render() {\n    const value = this.state.value;\n    const options = [{\n      label: '-',\n      value: NONE\n    }, {\n      label: this._translate('Yes'),\n      value: TRUE\n    }, {\n      label: this._translate('No'),\n      value: FALSE\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"simple-boolean-edit context-menu-container\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit Boolean'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Set Value'), 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"className\": \"dms-block\",\n      \"onChange\": this.onChange,\n      \"options\": options,\n      \"value\": value\n    })], 4);\n  }\n}\n//# sourceMappingURL=BooleanEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-boolean-edit/SimpleBooleanEdit.js\n\n\nclass SimpleBooleanEdit {\n  constructor(components, simpleMode) {\n    simpleMode.registerProvider(element => {\n      return ((0,ModelUtil/* isInput */.u7)(element.col) || (0,ModelUtil/* isOutput */.RW)(element.col)) && getTypeRef(element) === 'boolean';\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {\n        if (!context.element) {\n          return;\n        }\n        const typeRef = getTypeRef(context.element);\n        if (typeRef === 'boolean') {\n          return BooleanEdit;\n        }\n      }\n    });\n  }\n}\nSimpleBooleanEdit.$inject = ['components', 'simpleMode'];\n\n// helpers //////////////////////\n\nfunction getTypeRef(element) {\n  if ((0,ModelUtil/* isInput */.u7)(element.col)) {\n    return element.col && element.col.businessObject.inputExpression.typeRef;\n  } else {\n    return element.col && element.col.businessObject.typeRef;\n  }\n}\n//# sourceMappingURL=SimpleBooleanEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-boolean-edit/index.js\n\n\n\n/* harmony default export */ const simple_boolean_edit = ({\n  __depends__: [lib_features_keyboard, simple_mode],\n  __init__: ['simpleBooleanEdit'],\n  simpleBooleanEdit: ['type', SimpleBooleanEdit]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-edit/Utils.js\nconst ISO_DATE_REGEX = /^\\d{4}(?:-\\d\\d){2}$/;\n\n// eslint-disable-next-line\nconst BETWEEN_DATE_REGEX = /^\\[date\\(\"([^\"]*)\"\\)..date\\(\"([^\"]*)\"\\)\\]$/;\n\n// eslint-disable-next-line\nconst BEFORE_AFTER_DATE_REGEX = /^(<|>)\\s*date\\(\"([^\"]*)\"\\)$/;\nconst EXACT_DATE_REGEX = /^date\\(\"([^\"]*)\"\\)$/;\nconst EXACT = 'exact',\n  BEFORE = 'before',\n  AFTER = 'after',\n  BETWEEN = 'between';\nfunction validateISOString(string) {\n  if (!ISO_DATE_REGEX.test(string.trim())) {\n    return 'Date must match pattern yyyy-MM-dd.';\n  }\n}\nfunction getDateString(type, dates) {\n  if (type === EXACT) {\n    return \"date(\\\"\".concat(dates[0], \"\\\")\");\n  } else if (type === BEFORE) {\n    return \"< date(\\\"\".concat(dates[0], \"\\\")\");\n  } else if (type === AFTER) {\n    return \"> date(\\\"\".concat(dates[0], \"\\\")\");\n  } else if (type === BETWEEN) {\n    return \"[date(\\\"\".concat(dates[0], \"\\\")..date(\\\"\").concat(dates[1], \"\\\")]\");\n  }\n}\nfunction getSampleDate() {\n  const date = new Date();\n  date.setUTCHours(0, 0, 0, 0);\n  return date.toISOString().slice(0, 10);\n}\nfunction simple_date_edit_Utils_parseString(string) {\n  // emtpy\n  if (!string || string.trim() === '') {\n    return {\n      type: 'exact',\n      date: ''\n    };\n  }\n\n  // between\n  let matches = string.match(BETWEEN_DATE_REGEX);\n  if (matches) {\n    return {\n      type: 'between',\n      dates: [matches[1], matches[2]]\n    };\n  }\n\n  // before or after\n  matches = string.match(BEFORE_AFTER_DATE_REGEX);\n  if (matches) {\n    return {\n      type: matches[1] === '<' ? 'before' : 'after',\n      date: matches[2]\n    };\n  }\n\n  // exact\n  matches = string.match(EXACT_DATE_REGEX);\n  if (matches) {\n    return {\n      type: 'exact',\n      date: matches[1]\n    };\n  }\n}\n//# sourceMappingURL=Utils.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-edit/components/InputDateEdit.js\n\n\n\n\n\nconst InputDateEdit_EXACT = 'exact',\n  InputDateEdit_BEFORE = 'before',\n  InputDateEdit_AFTER = 'after',\n  InputDateEdit_BETWEEN = 'between';\nclass InputDateEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    const parsedString = simple_date_edit_Utils_parseString(element.businessObject.text);\n    if (parsedString) {\n      let dates;\n      if (parsedString.date) {\n        dates = [parsedString.date, ''];\n      } else if (parsedString.dates) {\n        dates = parsedString.dates;\n      } else {\n        dates = ['', ''];\n      }\n      this.state = {\n        type: parsedString.type,\n        dates\n      };\n    } else {\n      this.state = {\n        type: InputDateEdit_EXACT,\n        dates: ['', '']\n      };\n    }\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onTypeChange = this.onTypeChange.bind(this);\n    this.onSetStartDateTodayClick = this.onSetStartDateTodayClick.bind(this);\n    this.onSetEndDateTodayClick = this.onSetEndDateTodayClick.bind(this);\n    this.onStartDateInput = this.onStartDateInput.bind(this);\n    this.onEndDateInput = this.onEndDateInput.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onTypeChange(value) {\n    const element = this.props.context.element;\n    const dates = this.state.dates;\n    this.setState({\n      type: value\n    });\n    if (simple_date_edit_Utils_parseString(getDateString(value, dates))) {\n      this.editCell(element.businessObject, getDateString(value, dates));\n    }\n  }\n  onSetStartDateTodayClick() {\n    const element = this.props.context.element;\n    const _this$state = this.state,\n      dates = _this$state.dates,\n      type = _this$state.type;\n    const date = getSampleDate();\n    this.setState({\n      dates: [date, dates[1]]\n    });\n    if (simple_date_edit_Utils_parseString(getDateString(type, [date, dates[1]]))) {\n      this.editCell(element.businessObject, getDateString(type, [date, dates[1]]));\n    }\n  }\n  onSetEndDateTodayClick() {\n    const element = this.props.context.element;\n    const _this$state2 = this.state,\n      dates = _this$state2.dates,\n      type = _this$state2.type;\n    const date = getSampleDate();\n    this.setState({\n      dates: [dates[0], date]\n    });\n    if (simple_date_edit_Utils_parseString(getDateString(type, [dates[0], date]))) {\n      this.editCell(element.businessObject, getDateString(type, [dates[0], date]));\n    }\n  }\n  onStartDateInput(_ref) {\n    let value = _ref.value;\n    const element = this.props.context.element;\n    const _this$state3 = this.state,\n      dates = _this$state3.dates,\n      type = _this$state3.type;\n    this.setState({\n      dates: [value, dates[1]]\n    });\n    this.debouncedEditCell(element.businessObject, getDateString(type, [value, dates[1]]));\n  }\n  onEndDateInput(_ref2) {\n    let value = _ref2.value;\n    const element = this.props.context.element;\n    const _this$state4 = this.state,\n      dates = _this$state4.dates,\n      type = _this$state4.type;\n    this.setState({\n      dates: [dates[0], value]\n    });\n    this.debouncedEditCell(element.businessObject, getDateString(type, [dates[0], value]));\n  }\n  render() {\n    const _this$state5 = this.state,\n      dates = _this$state5.dates,\n      type = _this$state5.type;\n    const options = [{\n      label: this._translate('Exactly'),\n      value: InputDateEdit_EXACT\n    }, {\n      label: this._translate('Before'),\n      value: InputDateEdit_BEFORE\n    }, {\n      label: this._translate('After'),\n      value: InputDateEdit_AFTER\n    }, {\n      label: this._translate('Between'),\n      value: InputDateEdit_BETWEEN\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-date-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit date'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onTypeChange,\n      \"options\": options,\n      \"value\": type\n    }), 2), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", type === InputDateEdit_BETWEEN ? this._translate('Edit start date') : this._translate('Set date'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"className\": \"start-date-input dms-block\",\n      \"onInput\": this.onStartDateInput,\n      \"placeholder\": this._translate('e.g. { sample }', {\n        sample: getSampleDate()\n      }),\n      \"validate\": string => validateISOString(string) && this._translate(validateISOString(string)),\n      \"value\": dates[0]\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"use-today\", this._translate('Use today'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onSetStartDateTodayClick\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 4)], 4), type === InputDateEdit_BETWEEN && (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Edit end date'), 0), type === InputDateEdit_BETWEEN && (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"className\": \"end-date-input dms-block\",\n      \"onInput\": this.onEndDateInput,\n      \"placeholder\": this._translate('e.g. { sample }', {\n        sample: getSampleDate()\n      }),\n      \"validate\": string => validateISOString(string) && this._translate(validateISOString(string)),\n      \"value\": dates[1]\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"use-today\", this._translate('Use today'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onSetEndDateTodayClick\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 4)], 4)], 0);\n  }\n}\n//# sourceMappingURL=InputDateEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-edit/components/OutputDateEdit.js\n\n\n\n\nclass OutputDateEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    const parsedString = simple_date_edit_Utils_parseString(element.businessObject.text);\n    this.state = {\n      date: parsedString ? parsedString.date : ''\n    };\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onClick = this.onClick.bind(this);\n    this.onInput = this.onInput.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onClick() {\n    const element = this.props.context.element;\n    const date = getSampleDate();\n    this.setState({\n      date\n    });\n    this.editCell(element.businessObject, \"date(\\\"\".concat(date, \"\\\")\"));\n  }\n  onInput(_ref) {\n    let value = _ref.value;\n    const element = this.props.context.element;\n    this.setState({\n      date: value\n    });\n    this.debouncedEditCell(element.businessObject, \"date(\\\"\".concat(value, \"\\\")\"));\n  }\n  render() {\n    const date = this.state.date;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-date-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit date'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Set date'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"onInput\": this.onInput,\n      \"placeholder\": this._translate('e.g. { example } ', {\n        example: getSampleDate()\n      }),\n      \"validate\": string => validateISOString(string) && this._translate(validateISOString(string)),\n      \"value\": date,\n      \"className\": \"dms-block\"\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", [this._translate('Set date'), (0,inferno_index_esm/* createTextVNode */.Uk)(\" \"), (0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"use-today\", this._translate('to today'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onClick\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 0)], 4)], 4);\n  }\n}\n//# sourceMappingURL=OutputDateEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-edit/SimpleDateEdit.js\n\n\n\nclass SimpleDateEdit {\n  constructor(components, simpleMode) {\n    simpleMode.registerProvider(element => {\n      const typeRef = SimpleDateEdit_getTypeRef(element);\n      return ((0,ModelUtil/* isInput */.u7)(element.col) || (0,ModelUtil/* isOutput */.RW)(element.col)) && isDate(typeRef);\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {\n        if (!context.element) {\n          return;\n        }\n        const typeRef = SimpleDateEdit_getTypeRef(context.element);\n        if (isDate(typeRef)) {\n          if ((0,ModelUtil/* isInput */.u7)(context.element.col)) {\n            return InputDateEdit;\n          } else if ((0,ModelUtil/* isOutput */.RW)(context.element.col)) {\n            return OutputDateEdit;\n          }\n        }\n      }\n    });\n  }\n}\nSimpleDateEdit.$inject = ['components', 'simpleMode'];\n\n// helpers //////////////////////\n\nfunction SimpleDateEdit_getTypeRef(element) {\n  if ((0,ModelUtil/* isInput */.u7)(element.col)) {\n    return element.col && element.col.businessObject.inputExpression.typeRef;\n  } else {\n    return element.col && element.col.businessObject.typeRef;\n  }\n}\nfunction isDate(typeRef) {\n  return typeRef === 'date';\n}\n//# sourceMappingURL=SimpleDateEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-edit/index.js\n\n\n\n/* harmony default export */ const simple_date_edit = ({\n  __depends__: [lib_features_keyboard, simple_mode],\n  __init__: ['simpleDateEdit'],\n  simpleDateEdit: ['type', SimpleDateEdit]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-time-edit/Utils.js\nconst Utils_ISO_DATE_REGEX = /^\\d{4}(?:-\\d\\d){2}T(?:\\d\\d:){2}\\d\\d(?:Z|(?:[@+-][^\")]+))?$/;\n\n// eslint-disable-next-line\nconst Utils_BETWEEN_DATE_REGEX = /^\\[date and time\\(\"([^\"]*)\"\\)..date and time\\(\"([^\"]*)\"\\)\\]$/;\n\n// eslint-disable-next-line\nconst Utils_BEFORE_AFTER_DATE_REGEX = /^(<|>)\\s*date and time\\(\"([^\"]*)\"\\)$/;\n\n// eslint-disable-next-line\nconst Utils_EXACT_DATE_REGEX = /^date and time\\(\"([^\"]*)\"\\)$/;\nconst Utils_EXACT = 'exact',\n  Utils_BEFORE = 'before',\n  Utils_AFTER = 'after',\n  Utils_BETWEEN = 'between';\nfunction Utils_validateISOString(string) {\n  if (!Utils_ISO_DATE_REGEX.test(string.trim())) {\n    return 'Date and time must match pattern yyyy-MM-ddTHH:mm:ss[time zone].';\n  }\n}\nfunction Utils_getDateString(type, dates) {\n  if (type === Utils_EXACT) {\n    return \"date and time(\\\"\".concat(dates[0], \"\\\")\");\n  } else if (type === Utils_BEFORE) {\n    return \"< date and time(\\\"\".concat(dates[0], \"\\\")\");\n  } else if (type === Utils_AFTER) {\n    return \"> date and time(\\\"\".concat(dates[0], \"\\\")\");\n  } else if (type === Utils_BETWEEN) {\n    return \"[date and time(\\\"\".concat(dates[0], \"\\\")..date and time(\\\"\").concat(dates[1], \"\\\")]\");\n  }\n}\nfunction Utils_getSampleDate() {\n  const date = new Date();\n  date.setUTCHours(0, 0, 0, 0);\n  return date.toISOString().replace('.000Z', 'Z');\n}\nfunction simple_date_time_edit_Utils_parseString(string) {\n  // emtpy\n  if (!string || string.trim() === '') {\n    return {\n      type: 'exact',\n      date: ''\n    };\n  }\n\n  // between\n  let matches = string.match(Utils_BETWEEN_DATE_REGEX);\n  if (matches) {\n    return {\n      type: 'between',\n      dates: [matches[1], matches[2]]\n    };\n  }\n\n  // before or after\n  matches = string.match(Utils_BEFORE_AFTER_DATE_REGEX);\n  if (matches) {\n    return {\n      type: matches[1] === '<' ? 'before' : 'after',\n      date: matches[2]\n    };\n  }\n\n  // exact\n  matches = string.match(Utils_EXACT_DATE_REGEX);\n  if (matches) {\n    return {\n      type: 'exact',\n      date: matches[1]\n    };\n  }\n}\n//# sourceMappingURL=Utils.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-time-edit/components/InputDateTimeEdit.js\n\n\n\n\n\nconst InputDateTimeEdit_EXACT = 'exact',\n  InputDateTimeEdit_BEFORE = 'before',\n  InputDateTimeEdit_AFTER = 'after',\n  InputDateTimeEdit_BETWEEN = 'between';\nclass InputDateTimeEdit_InputDateEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    const parsedString = simple_date_time_edit_Utils_parseString(element.businessObject.text);\n    if (parsedString) {\n      let dates;\n      if (parsedString.date) {\n        dates = [parsedString.date, ''];\n      } else if (parsedString.dates) {\n        dates = parsedString.dates;\n      } else {\n        dates = ['', ''];\n      }\n      this.state = {\n        type: parsedString.type,\n        dates\n      };\n    } else {\n      this.state = {\n        type: InputDateTimeEdit_EXACT,\n        dates: ['', '']\n      };\n    }\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onTypeChange = this.onTypeChange.bind(this);\n    this.onSetStartDateTodayClick = this.onSetStartDateTodayClick.bind(this);\n    this.onSetEndDateTodayClick = this.onSetEndDateTodayClick.bind(this);\n    this.onStartDateInput = this.onStartDateInput.bind(this);\n    this.onEndDateInput = this.onEndDateInput.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onTypeChange(value) {\n    const element = this.props.context.element;\n    const dates = this.state.dates;\n    this.setState({\n      type: value\n    });\n    if (simple_date_time_edit_Utils_parseString(Utils_getDateString(value, dates))) {\n      this.editCell(element.businessObject, Utils_getDateString(value, dates));\n    }\n  }\n  onSetStartDateTodayClick() {\n    const element = this.props.context.element;\n    const _this$state = this.state,\n      dates = _this$state.dates,\n      type = _this$state.type;\n    const date = Utils_getSampleDate();\n    this.setState({\n      dates: [date, dates[1]]\n    });\n    if (simple_date_time_edit_Utils_parseString(Utils_getDateString(type, [date, dates[1]]))) {\n      this.editCell(element.businessObject, Utils_getDateString(type, [date, dates[1]]));\n    }\n  }\n  onSetEndDateTodayClick() {\n    const element = this.props.context.element;\n    const _this$state2 = this.state,\n      dates = _this$state2.dates,\n      type = _this$state2.type;\n    const date = Utils_getSampleDate();\n    this.setState({\n      dates: [dates[0], date]\n    });\n    if (simple_date_time_edit_Utils_parseString(Utils_getDateString(type, [dates[0], date]))) {\n      this.editCell(element.businessObject, Utils_getDateString(type, [dates[0], date]));\n    }\n  }\n  onStartDateInput(_ref) {\n    let value = _ref.value;\n    const element = this.props.context.element;\n    const _this$state3 = this.state,\n      dates = _this$state3.dates,\n      type = _this$state3.type;\n    this.setState({\n      dates: [value, dates[1]]\n    });\n    this.debouncedEditCell(element.businessObject, Utils_getDateString(type, [value, dates[1]]));\n  }\n  onEndDateInput(_ref2) {\n    let value = _ref2.value;\n    const element = this.props.context.element;\n    const _this$state4 = this.state,\n      dates = _this$state4.dates,\n      type = _this$state4.type;\n    this.setState({\n      dates: [dates[0], value]\n    });\n    this.debouncedEditCell(element.businessObject, Utils_getDateString(type, [dates[0], value]));\n  }\n  render() {\n    const _this$state5 = this.state,\n      dates = _this$state5.dates,\n      type = _this$state5.type;\n    const options = [{\n      label: this._translate('Exactly'),\n      value: InputDateTimeEdit_EXACT\n    }, {\n      label: this._translate('Before'),\n      value: InputDateTimeEdit_BEFORE\n    }, {\n      label: this._translate('After'),\n      value: InputDateTimeEdit_AFTER\n    }, {\n      label: this._translate('Between'),\n      value: InputDateTimeEdit_BETWEEN\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-date-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit date and time'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onTypeChange,\n      \"options\": options,\n      \"value\": type\n    }), 2), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", type === InputDateTimeEdit_BETWEEN ? this._translate('Edit start date') : this._translate('Set date'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"className\": \"start-date-input dms-block\",\n      \"onInput\": this.onStartDateInput,\n      \"placeholder\": this._translate('e.g. { sample }', {\n        sample: Utils_getSampleDate()\n      }),\n      \"validate\": string => Utils_validateISOString(string) && this._translate(Utils_validateISOString(string)),\n      \"value\": dates[0]\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"use-today\", this._translate('Use today'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onSetStartDateTodayClick\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 4)], 4), type === InputDateTimeEdit_BETWEEN && (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Edit end date'), 0), type === InputDateTimeEdit_BETWEEN && (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"className\": \"end-date-input dms-block\",\n      \"onInput\": this.onEndDateInput,\n      \"placeholder\": this._translate('e.g. { sample }', {\n        sample: Utils_getSampleDate()\n      }),\n      \"validate\": string => Utils_validateISOString(string) && this._translate(Utils_validateISOString(string)),\n      \"value\": dates[1]\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"use-today\", this._translate('Use today'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onSetEndDateTodayClick\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 4)], 4)], 0);\n  }\n}\n//# sourceMappingURL=InputDateTimeEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-time-edit/components/OutputDateTimeEdit.js\n\n\n\n\nclass OutputDateTimeEdit_OutputDateEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    const parsedString = simple_date_time_edit_Utils_parseString(element.businessObject.text);\n    this.state = {\n      date: parsedString ? parsedString.date : ''\n    };\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onClick = this.onClick.bind(this);\n    this.onInput = this.onInput.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onClick() {\n    const element = this.props.context.element;\n    const date = Utils_getSampleDate();\n    this.setState({\n      date\n    });\n    this.editCell(element.businessObject, \"date and time(\\\"\".concat(date, \"\\\")\"));\n  }\n  onInput(_ref) {\n    let value = _ref.value;\n    const element = this.props.context.element;\n    this.setState({\n      date: value\n    });\n    this.debouncedEditCell(element.businessObject, \"date and time(\\\"\".concat(value, \"\\\")\"));\n  }\n  render() {\n    const date = this.state.date;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-date-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit date and time'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Set date and time'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"onInput\": this.onInput,\n      \"placeholder\": this._translate('e.g. { sample }', {\n        sample: Utils_getSampleDate()\n      }),\n      \"validate\": string => Utils_validateISOString(string) && this._translate(Utils_validateISOString(string)),\n      \"value\": date,\n      \"className\": \"dms-block\"\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", [this._translate('Use'), (0,inferno_index_esm/* createTextVNode */.Uk)(\" \"), (0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"use-today\", this._translate('today'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onClick\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 0)], 4)], 4);\n  }\n}\n//# sourceMappingURL=OutputDateTimeEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-time-edit/SimpleDateTimeEdit.js\n\n\n\nclass SimpleDateTimeEdit_SimpleDateEdit {\n  constructor(components, simpleMode) {\n    simpleMode.registerProvider(element => {\n      const typeRef = SimpleDateTimeEdit_getTypeRef(element);\n      return ((0,ModelUtil/* isInput */.u7)(element.col) || (0,ModelUtil/* isOutput */.RW)(element.col)) && isDateTime(typeRef);\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {\n        if (!context.element) {\n          return;\n        }\n        const typeRef = SimpleDateTimeEdit_getTypeRef(context.element);\n        if (isDateTime(typeRef)) {\n          if ((0,ModelUtil/* isInput */.u7)(context.element.col)) {\n            return InputDateTimeEdit_InputDateEdit;\n          } else if ((0,ModelUtil/* isOutput */.RW)(context.element.col)) {\n            return OutputDateTimeEdit_OutputDateEdit;\n          }\n        }\n      }\n    });\n  }\n}\nSimpleDateTimeEdit_SimpleDateEdit.$inject = ['components', 'simpleMode'];\n\n// helpers //////////////////////\n\nfunction SimpleDateTimeEdit_getTypeRef(element) {\n  if ((0,ModelUtil/* isInput */.u7)(element.col)) {\n    return element.col && element.col.businessObject.inputExpression.typeRef;\n  } else {\n    return element.col && element.col.businessObject.typeRef;\n  }\n}\nfunction isDateTime(typeRef) {\n  return typeRef === 'dateTime';\n}\n//# sourceMappingURL=SimpleDateTimeEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-date-time-edit/index.js\n\n\n\n/* harmony default export */ const simple_date_time_edit = ({\n  __depends__: [lib_features_keyboard, simple_mode],\n  __init__: ['simpleDateTimeEdit'],\n  simpleDateTimeEdit: ['type', SimpleDateTimeEdit_SimpleDateEdit]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-duration-edit/Utils.js\nfunction _wrapRegExp() { _wrapRegExp = function _wrapRegExp(re, groups) { return new BabelRegExp(re, void 0, groups); }; var _super = RegExp.prototype, _groups = new WeakMap(); function BabelRegExp(re, flags, groups) { var _this = new RegExp(re, flags); return _groups.set(_this, groups || _groups.get(re)), _setPrototypeOf(_this, BabelRegExp.prototype); } function buildGroups(result, re) { var g = _groups.get(re); return Object.keys(g).reduce(function (groups, name) { var i = g[name]; if (\"number\" == typeof i) groups[name] = result[i];else { for (var k = 0; void 0 === result[i[k]] && k + 1 < i.length;) k++; groups[name] = result[i[k]]; } return groups; }, Object.create(null)); } return _inherits(BabelRegExp, RegExp), BabelRegExp.prototype.exec = function (str) { var result = _super.exec.call(this, str); if (result) { result.groups = buildGroups(result, this); var indices = result.indices; indices && (indices.groups = buildGroups(indices, this)); } return result; }, BabelRegExp.prototype[Symbol.replace] = function (str, substitution) { if (\"string\" == typeof substitution) { var groups = _groups.get(this); return _super[Symbol.replace].call(this, str, substitution.replace(/\\$<([^>]+)>/g, function (_, name) { var group = groups[name]; return \"$\" + (Array.isArray(group) ? group.join(\"$\") : group); })); } if (\"function\" == typeof substitution) { var _this = this; return _super[Symbol.replace].call(this, str, function () { var args = arguments; return \"object\" != typeof args[args.length - 1] && (args = [].slice.call(args)).push(buildGroups(args, _this)), substitution.apply(this, args); }); } return _super[Symbol.replace].call(this, str, substitution); }, _wrapRegExp.apply(this, arguments); }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nconst operators = {\n  equals: '=',\n  less: '<',\n  lessEquals: '<=',\n  greater: '>',\n  greaterEquals: '>='\n};\nfunction getOperatorName(string) {\n  return (0,node_modules_min_dash_dist_index_esm/* keys */.XP)(operators).filter(key => {\n    return string === operators[key];\n  })[0];\n}\nfunction parseDuration(text) {\n  if (!text || simple_duration_edit_Utils_isEmptyString(text.trim())) {\n    return {\n      type: 'comparison',\n      values: []\n    };\n  }\n  const parsedComparison = parseComparison(text);\n  if (parsedComparison) {\n    return parsedComparison;\n  }\n  const parsedRange = parseRange(text);\n  if (parsedRange) {\n    return parsedRange;\n  }\n}\nfunction simple_duration_edit_Utils_isEmptyString(string) {\n  return string === '';\n}\nfunction getComparisonString(comparisonOperator, comparisonValue) {\n  if (comparisonOperator === 'equals') {\n    return \"duration(\\\"\".concat(comparisonValue, \"\\\")\");\n  } else {\n    return \"\".concat(operators[comparisonOperator], \" duration(\\\"\").concat(comparisonValue, \"\\\")\");\n  }\n}\nfunction getRangeString(rangeStartValue, rangeEndValue, rangeStartType, rangeEndType) {\n  const rangeStartChar = rangeStartType === 'exclude' ? ']' : '[',\n    rangeEndChar = rangeEndType === 'exclude' ? '[' : ']';\n  return \"\".concat(rangeStartChar, \"duration(\\\"\").concat(rangeStartValue, \"\\\")\") + \"..duration(\\\"\".concat(rangeEndValue, \"\\\")\").concat(rangeEndChar);\n}\nfunction validateDuration(type, value) {\n  if (type === 'yearMonthDuration') {\n    return validateYearMonthDuration(value);\n  } else if (type === 'dayTimeDuration') {\n    return validateDayTimeDuration(value);\n  }\n}\nfunction validateYearMonthDuration(value) {\n  return /^P(\\d+Y\\d+M|\\d+Y|\\d+M)$/.test(value);\n}\nfunction validateDayTimeDuration(value) {\n  return /^P(\\d+DT\\d+H|\\d+D|T\\d+H)$/.test(value);\n}\nfunction withoutDurationCall(text) {\n  const result = /^duration\\(\"([^\"]*)\"\\)$/.exec(text);\n  return result && result[1];\n}\nfunction parseComparison(text) {\n  const exactValue = withoutDurationCall(text);\n  if (exactValue) {\n    return {\n      type: 'comparison',\n      operator: 'equals',\n      values: [exactValue]\n    };\n  }\n  const _match = match( /*#__PURE__*/_wrapRegExp(/^(=|(:?<|>)=?)\\s*duration\\(\"([^\"]*)\"\\)$/, {\n      operator: 1,\n      value: 3\n    }), text),\n    operator = _match.operator,\n    value = _match.value;\n  if (operator && value) {\n    return {\n      type: 'comparison',\n      values: [value],\n      operator: getOperatorName(operator)\n    };\n  }\n}\nfunction parseRange(text) {\n  const _match2 = match( /*#__PURE__*/_wrapRegExp(/^([[\\]])duration\\(\"([^\"]*)\"\\)\\.\\.duration\\(\"([^\"]*)\"\\)([[\\]])$/, {\n      start: 1,\n      firstValue: 2,\n      secondValue: 3,\n      end: 4\n    }), text),\n    start = _match2.start,\n    end = _match2.end,\n    firstValue = _match2.firstValue,\n    secondValue = _match2.secondValue;\n  if (start && end) {\n    return {\n      type: 'range',\n      values: [firstValue, secondValue],\n      start: start === ']' ? 'exclude' : 'include',\n      end: end === '[' ? 'exclude' : 'include'\n    };\n  }\n}\nfunction match(regex, input) {\n  const _ref = regex.exec(input) || {\n      groups: {}\n    },\n    groups = _ref.groups;\n  return groups;\n}\n//# sourceMappingURL=Utils.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-duration-edit/components/DurationInput.js\n\n\n\n\nconst ERROR_MESSAGE = {\n  yearMonthDuration: 'Must match PnYnM.',\n  dayTimeDuration: 'Must match PnDTnH.'\n};\nclass DurationInput extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._type = props.type;\n    this.onInput = this.onInput.bind(this);\n    this.validate = this.validate.bind(this);\n    this.state = {\n      value: props.value\n    };\n  }\n  onInput(_ref) {\n    let value = _ref.value;\n    this.setState({\n      value\n    });\n    this.props.onInput(value);\n  }\n  validate(value) {\n    if (!validateDuration(this._type, value)) {\n      return this._translate(ERROR_MESSAGE[this._type]);\n    }\n  }\n  _getPlaceholder() {\n    if (this._type === 'yearMonthDuration') {\n      return this._translate('e.g. { sample }', {\n        sample: 'P1Y2M'\n      });\n    } else if (this._type === 'dayTimeDuration') {\n      this._translate('e.g. { sample }', {\n        sample: 'P1DT2H'\n      });\n    }\n  }\n  render() {\n    return (0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"type\": \"text\",\n      \"onInput\": this.onInput,\n      \"placeholder\": this._getPlaceholder(),\n      \"validate\": this.validate,\n      \"value\": this.state.value,\n      \"className\": this.props.className\n    });\n  }\n}\n//# sourceMappingURL=DurationInput.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-duration-edit/components/InputDurationEdit.js\n\n\n\n\n\nconst COMPARISON = 'comparison',\n  RANGE = 'range';\n\n// adapted from InputNumberEdit\nclass InputDurationEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    this._type = InputDurationEdit_getTypeRef(element);\n    const parsedString = parseDuration(element.businessObject.text, this._type);\n    if (parsedString) {\n      this.state = {\n        type: parsedString.type,\n        comparisonOperator: parsedString.operator || 'equals',\n        startValue: parsedString.values[0] || '',\n        endValue: parsedString.values[1] || '',\n        rangeStartType: parsedString.start || 'include',\n        rangeEndType: parsedString.end || 'include'\n      };\n    } else {\n      this.state = {\n        type: COMPARISON,\n        comparisonOperator: 'equals',\n        startValue: '',\n        endValue: '',\n        rangeStartType: 'include',\n        rangeEndType: 'include'\n      };\n    }\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onComparisonOperatorChange = this.onComparisonOperatorChange.bind(this);\n    this.onComparisonValueChange = this.onComparisonValueChange.bind(this);\n    this.onTypeChange = this.onTypeChange.bind(this);\n    this.onRangeStartTypeChange = this.onRangeStartTypeChange.bind(this);\n    this.onRangeStartValueChange = this.onRangeStartValueChange.bind(this);\n    this.onRangeEndTypeChange = this.onRangeEndTypeChange.bind(this);\n    this.onRangeEndValueChange = this.onRangeEndValueChange.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onTypeChange(value) {\n    const element = this.props.context.element;\n    const _this$state = this.state,\n      comparisonOperator = _this$state.comparisonOperator,\n      startValue = _this$state.startValue,\n      endValue = _this$state.endValue,\n      rangeStartType = _this$state.rangeStartType,\n      rangeEndType = _this$state.rangeEndType;\n    if (value === COMPARISON) {\n      this.editCell(element.businessObject, getComparisonString(comparisonOperator, startValue));\n    } else {\n      this.editCell(element.businessObject, getRangeString(startValue, endValue, rangeStartType, rangeEndType));\n    }\n    this.setState({\n      type: value\n    });\n  }\n  onComparisonOperatorChange(value) {\n    const element = this.props.context.element;\n    const _this$state2 = this.state,\n      type = _this$state2.type,\n      startValue = _this$state2.startValue;\n    if (type === COMPARISON) {\n      this.editCell(element.businessObject, getComparisonString(value, startValue));\n      this.setState({\n        comparisonOperator: value\n      });\n    }\n  }\n  onComparisonValueChange(comparisonValue) {\n    const element = this.props.context.element;\n    const _this$state3 = this.state,\n      type = _this$state3.type,\n      comparisonOperator = _this$state3.comparisonOperator;\n    if (type === COMPARISON) {\n      this.debouncedEditCell(element.businessObject, getComparisonString(comparisonOperator, comparisonValue));\n      this.setState({\n        startValue: comparisonValue\n      });\n    }\n  }\n  onRangeStartTypeChange(value) {\n    const element = this.props.context.element;\n    const _this$state4 = this.state,\n      type = _this$state4.type,\n      startValue = _this$state4.startValue,\n      endValue = _this$state4.endValue,\n      rangeEndType = _this$state4.rangeEndType;\n    if (type === RANGE) {\n      this.editCell(element.businessObject, getRangeString(startValue, endValue, value, rangeEndType));\n      this.setState({\n        rangeStartType: value\n      });\n    }\n  }\n  onRangeStartValueChange(value) {\n    const element = this.props.context.element;\n    const _this$state5 = this.state,\n      type = _this$state5.type,\n      endValue = _this$state5.endValue,\n      rangeStartType = _this$state5.rangeStartType,\n      rangeEndType = _this$state5.rangeEndType;\n    if (type === RANGE) {\n      this.editCell(element.businessObject, getRangeString(value, endValue, rangeStartType, rangeEndType));\n      this.setState({\n        startValue: value\n      });\n    }\n  }\n  onRangeEndTypeChange(value) {\n    const element = this.props.context.element;\n    const _this$state6 = this.state,\n      type = _this$state6.type,\n      startValue = _this$state6.startValue,\n      endValue = _this$state6.endValue,\n      rangeStartType = _this$state6.rangeStartType;\n    if (type === RANGE) {\n      this.editCell(element.businessObject, getRangeString(startValue, endValue, rangeStartType, value));\n      this.setState({\n        rangeEndType: value\n      });\n    }\n  }\n  onRangeEndValueChange(value) {\n    const element = this.props.context.element;\n    const _this$state7 = this.state,\n      type = _this$state7.type,\n      startValue = _this$state7.startValue,\n      rangeStartType = _this$state7.rangeStartType,\n      rangeEndType = _this$state7.rangeEndType;\n    if (type === RANGE) {\n      this.editCell(element.businessObject, getRangeString(startValue, value, rangeStartType, rangeEndType));\n      this.setState({\n        endValue: value\n      });\n    }\n  }\n  renderComparison(comparisonOperator, comparisonValue) {\n    const comparisonOperatorOptions = [{\n      label: this._translate('Equals'),\n      value: 'equals'\n    }, {\n      label: this._translate('Less'),\n      value: 'less'\n    }, {\n      label: this._translate('Less or equals'),\n      value: 'lessEquals'\n    }, {\n      label: this._translate('Greater'),\n      value: 'greater'\n    }, {\n      label: this._translate('Greater or equals'),\n      value: 'greaterEquals'\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"comparison\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", (0,inferno_index_esm/* createTextVNode */.Uk)(\"Value\"), 2), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row dms-input-duration-edit-row\", [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onComparisonOperatorChange,\n      \"options\": comparisonOperatorOptions,\n      \"value\": comparisonOperator\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\"\\xA0\"), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, DurationInput, {\n      \"type\": this._type,\n      \"className\": \"comparison-duration-input\",\n      \"onInput\": this.onComparisonValueChange,\n      \"value\": comparisonValue\n    })], 4)], 4);\n  }\n  renderRange(rangeStartValue, rangeEndValue, rangeStartType, rangeEndType) {\n    const rangeTypeOptions = [{\n      label: this._translate('Include'),\n      value: 'include'\n    }, {\n      label: this._translate('Exclude'),\n      value: 'exclude'\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"range\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Start value'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row dms-input-duration-edit-row\", [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onRangeStartTypeChange,\n      \"options\": rangeTypeOptions,\n      \"value\": rangeStartType\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\"\\xA0\"), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, DurationInput, {\n      \"type\": this._type,\n      \"className\": \"range-start-duration-input\",\n      \"onInput\": this.onRangeStartValueChange,\n      \"value\": rangeStartValue\n    })], 4), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('End value'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row dms-input-duration-edit-row\", [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onRangeEndTypeChange,\n      \"options\": rangeTypeOptions,\n      \"value\": rangeEndType\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\"\\xA0\"), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, DurationInput, {\n      \"type\": this._type,\n      \"className\": \"range-end-duration-input\",\n      \"onInput\": this.onRangeEndValueChange,\n      \"value\": rangeEndValue\n    })], 4)], 4);\n  }\n  render() {\n    const _this$state8 = this.state,\n      type = _this$state8.type,\n      comparisonOperator = _this$state8.comparisonOperator,\n      startValue = _this$state8.startValue,\n      endValue = _this$state8.endValue,\n      rangeStartType = _this$state8.rangeStartType,\n      rangeEndType = _this$state8.rangeEndType;\n    const typeOptions = [{\n      label: this._translate('Comparison'),\n      value: COMPARISON\n    }, {\n      label: this._translate('Range'),\n      value: RANGE\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-duration-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit duration'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onTypeChange,\n      \"options\": typeOptions,\n      \"value\": type\n    }), 2), type === COMPARISON && this.renderComparison(comparisonOperator, startValue), type === RANGE && this.renderRange(startValue, endValue, rangeStartType, rangeEndType)], 0);\n  }\n}\nfunction InputDurationEdit_getTypeRef(element) {\n  return element.col.businessObject.inputExpression.typeRef;\n}\n//# sourceMappingURL=InputDurationEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-duration-edit/components/OutputDurationEdit.js\n\n\n\n\nclass OutputDurationEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    this._type = OutputDurationEdit_getTypeRef(element);\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onInput = this.onInput.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onInput(value) {\n    const element = this.props.context.element;\n    this.debouncedEditCell(element.businessObject, \"duration(\\\"\".concat(value, \"\\\")\"));\n  }\n  render() {\n    const value = withoutDurationCall(this.props.context.element.businessObject.text, this._type);\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-duration-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit duration'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Set duration'), 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, DurationInput, {\n      \"onInput\": this.onInput,\n      \"value\": value,\n      \"type\": this._type,\n      \"className\": \"dms-block\"\n    })], 4);\n  }\n}\nfunction OutputDurationEdit_getTypeRef(element) {\n  return element.col.businessObject.typeRef;\n}\n//# sourceMappingURL=OutputDurationEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-duration-edit/SimpleDurationEdit.js\n\n\n\nclass SimpleDurationEdit {\n  constructor(components, simpleMode) {\n    simpleMode.registerProvider(element => {\n      const typeRef = SimpleDurationEdit_getTypeRef(element);\n      return ((0,ModelUtil/* isInput */.u7)(element.col) || (0,ModelUtil/* isOutput */.RW)(element.col)) && isDuration(typeRef);\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {\n        if (!context.element) {\n          return;\n        }\n        const typeRef = SimpleDurationEdit_getTypeRef(context.element);\n        if (isDuration(typeRef)) {\n          if ((0,ModelUtil/* isInput */.u7)(context.element.col)) {\n            return InputDurationEdit;\n          } else if ((0,ModelUtil/* isOutput */.RW)(context.element.col)) {\n            return OutputDurationEdit;\n          }\n        }\n      }\n    });\n  }\n}\nSimpleDurationEdit.$inject = ['components', 'simpleMode'];\n\n// helpers //////////////////////\n\nfunction SimpleDurationEdit_getTypeRef(element) {\n  if ((0,ModelUtil/* isInput */.u7)(element.col)) {\n    return element.col && element.col.businessObject.inputExpression.typeRef;\n  } else {\n    return element.col && element.col.businessObject.typeRef;\n  }\n}\nconst durations = ['yearMonthDuration', 'dayTimeDuration'];\nfunction isDuration(typeRef) {\n  return durations.includes(typeRef);\n}\n//# sourceMappingURL=SimpleDurationEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-duration-edit/index.js\n\n\n\n/* harmony default export */ const simple_duration_edit = ({\n  __depends__: [lib_features_keyboard, simple_mode],\n  __init__: ['simpleDurationEdit'],\n  simpleDurationEdit: ['type', SimpleDurationEdit]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-number-edit/Utils.js\n\n\n// eslint-disable-next-line\nconst COMPARISON_REGULAR_EXPRESSION = /^(-?(?:[0-9]|\\.[0-9])+)$|^((?:<|>|=){0,2})\\s*(-?(?:[0-9]|\\.[0-9])+)$/;\n\n// eslint-disable-next-line\nconst RANGE_REGULAR_EXPRESSION = /^(\\[|\\]){1}(-?(?:[0-9]|\\.[0-9])+){1,}\\.\\.(-?(?:[0-9]|\\.[0-9])+){1,}(\\[|\\]){1}$/;\nconst Utils_operators = {\n  equals: '=',\n  less: '<',\n  lessEquals: '<=',\n  greater: '>',\n  greaterEquals: '>='\n};\nfunction Utils_getOperatorName(string) {\n  return (0,node_modules_min_dash_dist_index_esm/* keys */.XP)(Utils_operators).filter(key => {\n    return string === Utils_operators[key];\n  })[0];\n}\nfunction simple_number_edit_Utils_parseString(string) {\n  if (!string || simple_number_edit_Utils_isEmptyString(string.trim())) {\n    return {\n      type: 'comparison'\n    };\n  }\n  const comparisonMatches = string.match(COMPARISON_REGULAR_EXPRESSION),\n    rangeMatches = string.match(RANGE_REGULAR_EXPRESSION);\n  if (comparisonMatches) {\n    if (isNumber(comparisonMatches)) {\n      return {\n        type: 'comparison',\n        value: parseFloat(comparisonMatches[1]),\n        operator: 'equals'\n      };\n    } else if (isComparison(comparisonMatches)) {\n      return {\n        type: 'comparison',\n        value: parseFloat(comparisonMatches[3]),\n        operator: Utils_getOperatorName(comparisonMatches[2])\n      };\n    }\n  } else if (rangeMatches) {\n    return {\n      type: 'range',\n      values: [rangeMatches[2], rangeMatches[3]].map(value => parseFloat(value)),\n      start: rangeMatches[1] === ']' ? 'exclude' : 'include',\n      end: rangeMatches[4] === '[' ? 'exclude' : 'include'\n    };\n  }\n}\nfunction simple_number_edit_Utils_isEmptyString(string) {\n  return string === '';\n}\nfunction isNumber(matches) {\n  return matches[0] && matches[1] && !matches[2] && !matches[3];\n}\nfunction isComparison(matches) {\n  return matches[0] && !matches[1] && matches[2] && matches[3];\n}\nfunction Utils_getComparisonString(comparisonOperator, comparisonValue) {\n  if (comparisonOperator === 'equals') {\n    return \"\".concat(comparisonValue);\n  } else {\n    return \"\".concat(Utils_operators[comparisonOperator], \" \").concat(comparisonValue);\n  }\n}\nfunction Utils_getRangeString(rangeStartValue, rangeEndValue, rangeStartType, rangeEndType) {\n  const rangeStartChar = rangeStartType === 'exclude' ? ']' : '[',\n    rangeEndChar = rangeEndType === 'exclude' ? '[' : ']';\n  return \"\".concat(rangeStartChar).concat(rangeStartValue, \"..\").concat(rangeEndValue).concat(rangeEndChar);\n}\n//# sourceMappingURL=Utils.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-number-edit/components/InputNumberEdit.js\n\n\n\n\n\nconst InputNumberEdit_COMPARISON = 'comparison',\n  InputNumberEdit_RANGE = 'range';\nclass InputNumberEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    const parsedString = simple_number_edit_Utils_parseString(element.businessObject.text);\n    if (parsedString) {\n      this.state = {\n        type: parsedString.type,\n        comparisonOperator: parsedString.operator || 'equals',\n        comparisonValue: parsedString.value || 0,\n        rangeStartValue: parsedString.values ? parsedString.values[0] : 0,\n        rangeEndValue: parsedString.values ? parsedString.values[1] : 0,\n        rangeStartType: parsedString.start || 'include',\n        rangeEndType: parsedString.end || 'include'\n      };\n    } else {\n      this.state = {\n        type: InputNumberEdit_COMPARISON,\n        comparisonOperator: 'equals',\n        comparisonValue: 0,\n        rangeStartValue: 0,\n        rangeEndValue: 0,\n        rangeStartType: 'include',\n        rangeEndType: 'include'\n      };\n    }\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onComparisonOperatorChange = this.onComparisonOperatorChange.bind(this);\n    this.onComparisonValueChange = this.onComparisonValueChange.bind(this);\n    this.onTypeChange = this.onTypeChange.bind(this);\n    this.onRangeStartTypeChange = this.onRangeStartTypeChange.bind(this);\n    this.onRangeStartValueChange = this.onRangeStartValueChange.bind(this);\n    this.onRangeEndTypeChange = this.onRangeEndTypeChange.bind(this);\n    this.onRangeEndValueChange = this.onRangeEndValueChange.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onTypeChange(value) {\n    const element = this.props.context.element;\n    const _this$state = this.state,\n      comparisonOperator = _this$state.comparisonOperator,\n      comparisonValue = _this$state.comparisonValue,\n      rangeStartValue = _this$state.rangeStartValue,\n      rangeEndValue = _this$state.rangeEndValue,\n      rangeStartType = _this$state.rangeStartType,\n      rangeEndType = _this$state.rangeEndType;\n    if (value === InputNumberEdit_COMPARISON) {\n      this.editCell(element.businessObject, Utils_getComparisonString(comparisonOperator, comparisonValue));\n    } else {\n      this.editCell(element.businessObject, Utils_getRangeString(rangeStartValue, rangeEndValue, rangeStartType, rangeEndType));\n    }\n    this.setState({\n      type: value\n    });\n  }\n  onComparisonOperatorChange(value) {\n    const element = this.props.context.element;\n    const _this$state2 = this.state,\n      type = _this$state2.type,\n      comparisonValue = _this$state2.comparisonValue;\n    if (type === InputNumberEdit_COMPARISON) {\n      this.editCell(element.businessObject, Utils_getComparisonString(value, comparisonValue));\n      this.setState({\n        comparisonOperator: value\n      });\n    }\n  }\n  onComparisonValueChange(comparisonValue) {\n    const element = this.props.context.element;\n    const _this$state3 = this.state,\n      type = _this$state3.type,\n      comparisonOperator = _this$state3.comparisonOperator;\n    if (type === InputNumberEdit_COMPARISON) {\n      this.debouncedEditCell(element.businessObject, Utils_getComparisonString(comparisonOperator, comparisonValue));\n      this.setState({\n        comparisonValue\n      });\n    }\n  }\n  onRangeStartTypeChange(value) {\n    const element = this.props.context.element;\n    const _this$state4 = this.state,\n      type = _this$state4.type,\n      rangeStartValue = _this$state4.rangeStartValue,\n      rangeEndValue = _this$state4.rangeEndValue,\n      rangeEndType = _this$state4.rangeEndType;\n    if (type === InputNumberEdit_RANGE) {\n      this.editCell(element.businessObject, Utils_getRangeString(rangeStartValue, rangeEndValue, value, rangeEndType));\n      this.setState({\n        rangeStartType: value\n      });\n    }\n  }\n  onRangeStartValueChange(value) {\n    const element = this.props.context.element;\n    const _this$state5 = this.state,\n      type = _this$state5.type,\n      rangeEndValue = _this$state5.rangeEndValue,\n      rangeStartType = _this$state5.rangeStartType,\n      rangeEndType = _this$state5.rangeEndType;\n    if (type === InputNumberEdit_RANGE) {\n      this.editCell(element.businessObject, Utils_getRangeString(value, rangeEndValue, rangeStartType, rangeEndType));\n      this.setState({\n        rangeStartValue: value\n      });\n    }\n  }\n  onRangeEndTypeChange(value) {\n    const element = this.props.context.element;\n    const _this$state6 = this.state,\n      type = _this$state6.type,\n      rangeStartValue = _this$state6.rangeStartValue,\n      rangeEndValue = _this$state6.rangeEndValue,\n      rangeStartType = _this$state6.rangeStartType;\n    if (type === InputNumberEdit_RANGE) {\n      this.editCell(element.businessObject, Utils_getRangeString(rangeStartValue, rangeEndValue, rangeStartType, value));\n      this.setState({\n        rangeEndType: value\n      });\n    }\n  }\n  onRangeEndValueChange(value) {\n    const element = this.props.context.element;\n    const _this$state7 = this.state,\n      type = _this$state7.type,\n      rangeStartValue = _this$state7.rangeStartValue,\n      rangeStartType = _this$state7.rangeStartType,\n      rangeEndType = _this$state7.rangeEndType;\n    if (type === InputNumberEdit_RANGE) {\n      this.editCell(element.businessObject, Utils_getRangeString(rangeStartValue, value, rangeStartType, rangeEndType));\n      this.setState({\n        rangeEndValue: value\n      });\n    }\n  }\n  renderComparison(comparisonOperator, comparisonValue) {\n    const comparisonOperatorOptions = [{\n      label: this._translate('Equals'),\n      value: 'equals'\n    }, {\n      label: this._translate('Less'),\n      value: 'less'\n    }, {\n      label: this._translate('Less or equals'),\n      value: 'lessEquals'\n    }, {\n      label: this._translate('Greater'),\n      value: 'greater'\n    }, {\n      label: this._translate('Greater or equals'),\n      value: 'greaterEquals'\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"comparison\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Value'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onComparisonOperatorChange,\n      \"options\": comparisonOperatorOptions,\n      \"value\": comparisonOperator\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\"\\xA0\"), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Input, {\n      \"className\": \"comparison-number-input\",\n      \"onInput\": this.onComparisonValueChange,\n      \"type\": \"number\",\n      \"value\": comparisonValue\n    })], 4)], 4);\n  }\n  renderRange(rangeStartValue, rangeEndValue, rangeStartType, rangeEndType) {\n    const rangeTypeOptions = [{\n      label: this._translate('Include'),\n      value: 'include'\n    }, {\n      label: this._translate('Exclude'),\n      value: 'exclude'\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"range\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Start value'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onRangeStartTypeChange,\n      \"options\": rangeTypeOptions,\n      \"value\": rangeStartType\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\"\\xA0\"), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Input, {\n      \"className\": \"range-start-number-input\",\n      \"onInput\": this.onRangeStartValueChange,\n      \"type\": \"number\",\n      \"value\": rangeStartValue\n    })], 4), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('End value'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onRangeEndTypeChange,\n      \"options\": rangeTypeOptions,\n      \"value\": rangeEndType\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\"\\xA0\"), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Input, {\n      \"className\": \"range-end-number-input\",\n      \"onInput\": this.onRangeEndValueChange,\n      \"type\": \"number\",\n      \"value\": rangeEndValue\n    })], 4)], 4);\n  }\n  render() {\n    const _this$state8 = this.state,\n      type = _this$state8.type,\n      comparisonOperator = _this$state8.comparisonOperator,\n      comparisonValue = _this$state8.comparisonValue,\n      rangeStartValue = _this$state8.rangeStartValue,\n      rangeEndValue = _this$state8.rangeEndValue,\n      rangeStartType = _this$state8.rangeStartType,\n      rangeEndType = _this$state8.rangeEndType;\n    const typeOptions = [{\n      label: this._translate('Comparison'),\n      value: InputNumberEdit_COMPARISON\n    }, {\n      label: this._translate('Range'),\n      value: InputNumberEdit_RANGE\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-number-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit Number'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onTypeChange,\n      \"options\": typeOptions,\n      \"value\": type\n    }), 2), type === InputNumberEdit_COMPARISON && this.renderComparison(comparisonOperator, comparisonValue), type === InputNumberEdit_RANGE && this.renderRange(rangeStartValue, rangeEndValue, rangeStartType, rangeEndType)], 0);\n  }\n}\n//# sourceMappingURL=InputNumberEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-number-edit/components/OutputNumberEdit.js\n\n\n\n\nclass OutputNumberEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    const parsedString = simple_number_edit_Utils_parseString(element.businessObject.text);\n    if (parsedString) {\n      this.state = {\n        value: parsedString.value\n      };\n    } else {\n      this.state = {\n        value: ''\n      };\n    }\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onInput = this.onInput.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onInput(value) {\n    const element = this.props.context.element;\n    this.debouncedEditCell(element.businessObject, value);\n    this.setState({\n      value\n    });\n  }\n  render() {\n    const value = this.state.value;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-number-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit Number'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Set Value'), 0), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Input, {\n      \"onInput\": this.onInput,\n      \"type\": \"number\",\n      \"value\": value\n    })], 4);\n  }\n}\n//# sourceMappingURL=OutputNumberEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-number-edit/SimpleNumberEdit.js\n\n\n\nclass SimpleNumberEdit {\n  constructor(components, simpleMode) {\n    simpleMode.registerProvider(element => {\n      const typeRef = SimpleNumberEdit_getTypeRef(element);\n      return ((0,ModelUtil/* isInput */.u7)(element.col) || (0,ModelUtil/* isOutput */.RW)(element.col)) && SimpleNumberEdit_isNumber(typeRef);\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {\n        if (!context.element) {\n          return;\n        }\n        const typeRef = SimpleNumberEdit_getTypeRef(context.element);\n        if (SimpleNumberEdit_isNumber(typeRef)) {\n          if ((0,ModelUtil/* isInput */.u7)(context.element.col)) {\n            return InputNumberEdit;\n          } else if ((0,ModelUtil/* isOutput */.RW)(context.element.col)) {\n            return OutputNumberEdit;\n          }\n        }\n      }\n    });\n  }\n}\nSimpleNumberEdit.$inject = ['components', 'simpleMode'];\n\n// helpers //////////////////////\n\nfunction SimpleNumberEdit_getTypeRef(element) {\n  if ((0,ModelUtil/* isInput */.u7)(element.col)) {\n    return element.col && element.col.businessObject.inputExpression.typeRef;\n  } else {\n    return element.col && element.col.businessObject.typeRef;\n  }\n}\nconst numberTypes = ['number', 'integer', 'long', 'double'];\nfunction SimpleNumberEdit_isNumber(typeRef) {\n  return numberTypes.includes(typeRef);\n}\n//# sourceMappingURL=SimpleNumberEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-number-edit/index.js\n\n\n\n/* harmony default export */ const simple_number_edit = ({\n  __depends__: [lib_features_keyboard, simple_mode],\n  __init__: ['simpleNumberEdit'],\n  simpleNumberEdit: ['type', SimpleNumberEdit]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-string-edit/Utils.js\n\n\n/**\r\n * Parse input/output entry string to unary tests and type of unary tests.\r\n *\r\n * Example:\r\n *\r\n * not(\"foo\", \"bar\")\r\n *\r\n * returns\r\n *\r\n * {\r\n *   type: 'negation',\r\n *   values: [ \"foo\", \"bar, baz\" ]\r\n * }\r\n *\r\n * @param {string} string - Input/Output entry as string e.g. \"foo\", \"bar\".\r\n */\nfunction simple_string_edit_Utils_parseString(string) {\n  // empty string or no string at all\n  if (!string || simple_string_edit_Utils_isEmptyString(string.trim())) {\n    return {\n      type: 'disjunction',\n      values: []\n    };\n  }\n\n  // disjunction\n  let values = string.split(',');\n  const result = {\n    type: 'disjunction',\n    values: []\n  };\n  let openString = '';\n  values.forEach(value => {\n    openString += value;\n    if (/^\"[^\"]*\"$/.test(openString.trim())) {\n      result.values.push(openString.trim());\n      openString = '';\n    } else {\n      openString += ',';\n    }\n  });\n  if (!openString) {\n    return result;\n  }\n\n  // negation\n  result.type = 'negation';\n  result.values = [];\n  openString = '';\n  const matches = string.match(/^\\s*not\\((.*)\\)\\s*$/);\n  if (matches) {\n    values = matches[1].split(',');\n    values.forEach(value => {\n      openString += value;\n      if (/^\"[^\"]*\"$/.test(openString.trim())) {\n        result.values.push(openString.trim());\n        openString = '';\n      } else {\n        openString += ',';\n      }\n    });\n    if (!openString) {\n      return result;\n    }\n  }\n}\n\n// TODO(philippfromme): seperate when refactoring component\nfunction getInputOrOutputValues(inputOrOutput) {\n  const inputOrOutputValues = (0,ModelUtil/* isInput */.u7)(inputOrOutput) ? inputOrOutput.inputValues : inputOrOutput.outputValues;\n  if (!inputOrOutputValues || simple_string_edit_Utils_isEmptyString(inputOrOutputValues.text)) {\n    return [];\n  } else {\n    return inputOrOutputValues.text.split(',').map(value => value.trim());\n  }\n}\nfunction simple_string_edit_Utils_isEmptyString(string) {\n  return string === '';\n}\n//# sourceMappingURL=Utils.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-string-edit/components/SimpleStringEditContextMenuComponent.js\n\n\n\n\n\n\n\nconst DISJUNCTION = 'disjunction',\n  NEGATION = 'negation';\nconst INPUT_VALUES_LABEL = 'Predefined Values',\n  OUTPUT_VALUES_LABEL = 'Predefined Values',\n  INPUT_ENTRY_VALUES_LABEL = 'Custom Values';\nclass SimpleStringEditContextMenuComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    let parsedString = simple_string_edit_Utils_parseString(props.context.element.businessObject.text);\n\n    // could not parse\n    if (!parsedString) {\n      parsedString = {\n        values: [],\n        type: DISJUNCTION\n      };\n    }\n    const inputOrOutputValues = getInputOrOutputValues(props.context.element.col.businessObject);\n    const filteredValues = parsedString.values.filter(value => {\n      return !includes(inputOrOutputValues, value);\n    });\n    const isInputClause = (0,ModelUtil/* isInput */.u7)(props.context.element.col);\n    let items = inputOrOutputValues.map(value => {\n      return {\n        value,\n        isChecked: includes(parsedString.values, value),\n        isRemovable: false,\n        group: isInputClause ? this._translate(INPUT_VALUES_LABEL) : this._translate(OUTPUT_VALUES_LABEL)\n      };\n    });\n    if (isInputClause) {\n      items = items.concat(filteredValues.map(value => {\n        return {\n          value,\n          isChecked: true,\n          isRemovable: true,\n          group: this._translate(INPUT_ENTRY_VALUES_LABEL)\n        };\n      }));\n    }\n    let inputValue = '';\n    if (!isInputClause && parsedString.values.length && !includes(inputOrOutputValues, parsedString.values[0])) {\n      inputValue = parsedString.values[0];\n    }\n    this.state = {\n      items,\n      unaryTestsType: parsedString.type,\n      inputValue,\n      isOutputValueInputChecked: inputValue !== ''\n    };\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.addUnaryTestsListItem = this.addUnaryTestsListItem.bind(this);\n    this.onInput = this.onInput.bind(this);\n    this.onKeyDown = this.onKeyDown.bind(this);\n    this.onOutputValueInputClick = this.onOutputValueInputClick.bind(this);\n    this.onUnaryTestsListChanged = this.onUnaryTestsListChanged.bind(this);\n    this.onUnaryTestsTypeChange = this.onUnaryTestsTypeChange.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n\n  /**\r\n   * Change type of unary tests.\r\n   */\n  onUnaryTestsTypeChange(value) {\n    const items = this.state.items;\n    const values = getValues(items);\n    const element = this.props.context.element;\n    if (value === DISJUNCTION) {\n      this.editCell(element.businessObject, values.join(','));\n      this.setState({\n        unaryTestsType: DISJUNCTION\n      });\n    } else {\n      this.editCell(element.businessObject, \"not(\".concat(values.join(','), \")\"));\n      this.setState({\n        unaryTestsType: NEGATION\n      });\n    }\n  }\n\n  /**\r\n   * Change list of unary tests.\r\n   */\n  onUnaryTestsListChanged(items) {\n    // get checked items\n    const values = getValues(items);\n    const element = this.props.context.element;\n    const unaryTestsType = this.state.unaryTestsType;\n    if (unaryTestsType === DISJUNCTION) {\n      this.editCell(element.businessObject, values.join(','));\n    } else {\n      this.editCell(element.businessObject, \"not(\".concat(values.join(','), \")\"));\n    }\n    this.setState({\n      items,\n      isOutputValueInputChecked: false\n    });\n  }\n\n  /**\r\n   * Set output value to input value.\r\n   */\n  onOutputValueInputClick() {\n    const element = this.props.context.element;\n    const _this$state = this.state,\n      inputValue = _this$state.inputValue,\n      items = _this$state.items;\n    const parsedString = simple_string_edit_Utils_parseString(inputValue);\n    if (!parsedString || parsedString.values.length > 1) {\n      return;\n    }\n    this.editCell(element.businessObject, \"\".concat(parsedString.values.join('')));\n\n    // uncheck all other values\n    this.setState({\n      items: items.map(item => {\n        item.isChecked = false;\n        return item;\n      }),\n      isOutputValueInputChecked: true\n    });\n  }\n\n  /**\r\n   * Set output value if valid.\r\n   */\n  onInput(_ref) {\n    let isValid = _ref.isValid,\n      value = _ref.value;\n    const isOutputValueInputChecked = this.state.isOutputValueInputChecked;\n    this.setState({\n      inputValue: value\n    });\n    const element = this.props.context.element;\n    if (!(0,ModelUtil/* isInput */.u7)(element) && isValid && isOutputValueInputChecked) {\n      this.debouncedEditCell(element.businessObject, value);\n    }\n  }\n\n  /**\r\n   * Add new value on ENTER.\r\n   */\n  onKeyDown(_ref2) {\n    let isValid = _ref2.isValid,\n      event = _ref2.event;\n    if (!SimpleStringEditContextMenuComponent_isEnter(event.keyCode)) {\n      return;\n    }\n    const element = this.props.context.element;\n    const isInputClause = (0,ModelUtil/* isInput */.u7)(element.col);\n\n    // stop ENTER propagation (and ContextMenu close)\n    if (isInputClause || !isValid) {\n      event.stopPropagation();\n      event.preventDefault();\n    }\n    if (isValid) {\n      if (isInputClause) {\n        this.addUnaryTestsListItem();\n      } else {\n        this.onOutputValueInputClick();\n      }\n    }\n  }\n\n  /**\r\n   * Add unary tests to list.\r\n   */\n  addUnaryTestsListItem() {\n    const _this$state2 = this.state,\n      inputValue = _this$state2.inputValue,\n      items = _this$state2.items,\n      unaryTestsType = _this$state2.unaryTestsType;\n    const parsedInput = simple_string_edit_Utils_parseString(inputValue);\n    if (!parsedInput) {\n      return;\n    }\n    const element = this.props.context.element;\n    const values = getValues(items);\n    const newValues = [].concat(values, parsedInput.values);\n    if (unaryTestsType === DISJUNCTION) {\n      this.editCell(element.businessObject, newValues.join(','));\n    } else {\n      this.editCell(element.businessObject, \"not(\".concat(newValues.join(','), \")\"));\n    }\n    const newItems = items.concat(parsedInput.values.map(value => {\n      return {\n        value,\n        isChecked: true,\n        isRemovable: true,\n        group: this._translate('Custom Values')\n      };\n    }));\n    this.setState({\n      items: newItems,\n      inputValue: ''\n    });\n  }\n  render() {\n    const element = this.props.context.element;\n    const _this$state3 = this.state,\n      inputValue = _this$state3.inputValue,\n      isOutputValueInputChecked = _this$state3.isOutputValueInputChecked,\n      items = _this$state3.items,\n      unaryTestsType = _this$state3.unaryTestsType;\n    const options = [{\n      label: this._translate('Match one'),\n      value: DISJUNCTION\n    }, {\n      label: this._translate('Match none'),\n      value: NEGATION\n    }];\n    const isInputClause = (0,ModelUtil/* isInput */.u7)(element.col);\n    const isNegation = unaryTestsType === NEGATION;\n    const showRadio = !isInputClause && items.length > 0;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"simple-string-edit context-menu-container\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit String'), 0), isInputClause && (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", null, (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onUnaryTestsTypeChange,\n      \"options\": options,\n      \"value\": isNegation ? NEGATION : DISJUNCTION\n    }, null, node => this.selectNode = node), 2), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, List, {\n      \"onChange\": this.onUnaryTestsListChanged,\n      \"items\": items,\n      \"type\": isInputClause ? 'checkbox' : 'radio'\n    }), isInputClause ? (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Add Values'), 0) : (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Set Value'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", [showRadio && (0,inferno_index_esm/* createVNode */.Wm)(64, \"input\", \"cursor-pointer\", null, 1, {\n      \"checked\": isOutputValueInputChecked,\n      \"onClick\": this.onOutputValueInputClick,\n      \"type\": \"radio\",\n      \"style\": {\n        marginRight: '8px'\n      }\n    }), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"className\": \"dms-block\",\n      \"onKeyDown\": this.onKeyDown,\n      \"onInput\": this.onInput,\n      \"placeholder\": isInputClause ? this._translate('\"value\", \"value\", ...') : this._translate('\"value\"'),\n      \"type\": \"text\",\n      \"validate\": value => {\n        if (!simple_string_edit_Utils_parseString(value)) {\n          return this._translate('Strings must be in double quotes.');\n        }\n      },\n      \"value\": inputValue\n    })], 0)], 0);\n  }\n}\n\n// helpers //////////////////////\n\nfunction SimpleStringEditContextMenuComponent_isEnter(keyCode) {\n  return keyCode === 13;\n}\n\n/**\r\n * Get array of actual values from array of items.\r\n *\r\n * @param {Array} items - Array of items.\r\n */\nfunction getValues(items) {\n  return items.filter(item => item.isChecked).map(item => item.value);\n}\nfunction includes(array, value) {\n  return array.indexOf(value) !== -1;\n}\n//# sourceMappingURL=SimpleStringEditContextMenuComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-string-edit/SimpleStringEdit.js\n\n\nclass SimpleStringEdit {\n  constructor(components, simpleMode) {\n    simpleMode.registerProvider(element => {\n      return ((0,ModelUtil/* isInput */.u7)(element.col) || (0,ModelUtil/* isOutput */.RW)(element.col)) && SimpleStringEdit_getTypeRef(element) === 'string';\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {\n        if (!context.element) {\n          return;\n        }\n        const typeRef = SimpleStringEdit_getTypeRef(context.element);\n        if (typeRef === 'string') {\n          return SimpleStringEditContextMenuComponent;\n        }\n      }\n    });\n  }\n}\nSimpleStringEdit.$inject = ['components', 'simpleMode'];\n\n// helpers //////////////////////\n\nfunction SimpleStringEdit_getTypeRef(element) {\n  if ((0,ModelUtil/* isInput */.u7)(element.col)) {\n    return element.col && element.col.businessObject.inputExpression.typeRef;\n  } else {\n    return element.col && element.col.businessObject.typeRef;\n  }\n}\n//# sourceMappingURL=SimpleStringEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-string-edit/index.js\n\n\n\n/* harmony default export */ const simple_string_edit = ({\n  __depends__: [lib_features_keyboard, simple_mode],\n  __init__: ['simpleStringEdit'],\n  simpleStringEdit: ['type', SimpleStringEdit]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-time-edit/Utils.js\nconst ISO_TIME_REGEX = /^(?:\\d\\d:){2}\\d\\d(?:Z|(?:[@+-][^\")]+))?$/;\nconst BETWEEN_TIME_REGEX = /^\\[time\\(\"([^\"]*)\"\\)..time\\(\"([^\"]*)\"\\)\\]$/;\nconst BEFORE_AFTER_TIME_REGEX = /^(<|>)\\s*time\\(\"([^\"]*)\"\\)$/;\nconst EXACT_TIME_REGEX = /^time\\(\"([^\"]*)\"\\)$/;\nconst simple_time_edit_Utils_EXACT = 'exact',\n  simple_time_edit_Utils_BEFORE = 'before',\n  simple_time_edit_Utils_AFTER = 'after',\n  simple_time_edit_Utils_BETWEEN = 'between';\nfunction simple_time_edit_Utils_validateISOString(string) {\n  if (!ISO_TIME_REGEX.test(string.trim())) {\n    return 'Time must match pattern hh:mm:ss[time zone].';\n  }\n}\nfunction getTimeString(type, times) {\n  if (type === simple_time_edit_Utils_EXACT) {\n    return \"time(\\\"\".concat(times[0], \"\\\")\");\n  } else if (type === simple_time_edit_Utils_BEFORE) {\n    return \"< time(\\\"\".concat(times[0], \"\\\")\");\n  } else if (type === simple_time_edit_Utils_AFTER) {\n    return \"> time(\\\"\".concat(times[0], \"\\\")\");\n  } else if (type === simple_time_edit_Utils_BETWEEN) {\n    return \"[time(\\\"\".concat(times[0], \"\\\")..time(\\\"\").concat(times[1], \"\\\")]\");\n  }\n}\nfunction getSampleTime() {\n  const time = new Date();\n  return time.toISOString().slice(11, -5) + 'Z';\n}\nfunction simple_time_edit_Utils_parseString(string) {\n  // emtpy\n  if (!string || string.trim() === '') {\n    return {\n      type: 'exact',\n      time: ''\n    };\n  }\n\n  // between\n  let matches = string.match(BETWEEN_TIME_REGEX);\n  if (matches) {\n    return {\n      type: 'between',\n      times: [matches[1], matches[2]]\n    };\n  }\n\n  // before or after\n  matches = string.match(BEFORE_AFTER_TIME_REGEX);\n  if (matches) {\n    return {\n      type: matches[1] === '<' ? 'before' : 'after',\n      time: matches[2]\n    };\n  }\n\n  // exact\n  matches = string.match(EXACT_TIME_REGEX);\n  if (matches) {\n    return {\n      type: 'exact',\n      time: matches[1]\n    };\n  }\n}\n//# sourceMappingURL=Utils.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-time-edit/components/InputTimeEdit.js\n\n\n\n\n\n\nconst InputTimeEdit_EXACT = 'exact',\n  InputTimeEdit_BEFORE = 'before',\n  InputTimeEdit_AFTER = 'after',\n  InputTimeEdit_BETWEEN = 'between';\nclass InputTimeEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    const parsedString = simple_time_edit_Utils_parseString(element.businessObject.text);\n    if (parsedString) {\n      let times;\n      if (parsedString.time) {\n        times = [parsedString.time, ''];\n      } else if (parsedString.times) {\n        times = parsedString.times;\n      } else {\n        times = ['', ''];\n      }\n      this.state = {\n        type: parsedString.type,\n        times: times\n      };\n    } else {\n      this.state = {\n        type: InputTimeEdit_EXACT,\n        times: ['', '']\n      };\n    }\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onTypeChange = this.onTypeChange.bind(this);\n    this.onSetStartTimeNowClick = this.onSetStartTimeNowClick.bind(this);\n    this.onSetEndTimeNowClick = this.onSetEndTimeNowClick.bind(this);\n    this.onStartTimeInput = this.onStartTimeInput.bind(this);\n    this.onEndTimeInput = this.onEndTimeInput.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onTypeChange(value) {\n    const element = this.props.context.element;\n    const times = this.state.times;\n    this.setState({\n      type: value\n    });\n    if (simple_time_edit_Utils_parseString(getTimeString(value, times))) {\n      this.editCell(element.businessObject, getTimeString(value, times));\n    }\n  }\n  onSetStartTimeNowClick() {\n    const element = this.props.context.element;\n    const _this$state = this.state,\n      times = _this$state.times,\n      type = _this$state.type;\n    const time = getSampleTime();\n    this.setState({\n      times: [time, times[1]]\n    });\n    if (simple_time_edit_Utils_parseString(getTimeString(type, [time, times[1]]))) {\n      this.editCell(element.businessObject, getTimeString(type, [time, times[1]]));\n    }\n  }\n  onSetEndTimeNowClick() {\n    const element = this.props.context.element;\n    const _this$state2 = this.state,\n      times = _this$state2.times,\n      type = _this$state2.type;\n    const time = getSampleTime();\n    this.setState({\n      times: [times[0], time]\n    });\n    if (simple_time_edit_Utils_parseString(getTimeString(type, [times[0], time]))) {\n      this.editCell(element.businessObject, getTimeString(type, [times[0], time]));\n    }\n  }\n  onStartTimeInput(_ref) {\n    let value = _ref.value;\n    const element = this.props.context.element;\n    const _this$state3 = this.state,\n      times = _this$state3.times,\n      type = _this$state3.type;\n    this.setState({\n      times: [value, times[1]]\n    });\n    this.debouncedEditCell(element.businessObject, getTimeString(type, [value, times[1]]));\n  }\n  onEndTimeInput(_ref2) {\n    let value = _ref2.value;\n    const element = this.props.context.element;\n    const _this$state4 = this.state,\n      times = _this$state4.times,\n      type = _this$state4.type;\n    this.setState({\n      times: [times[0], value]\n    });\n    this.debouncedEditCell(element.businessObject, getTimeString(type, [times[0], value]));\n  }\n  render() {\n    const _this$state5 = this.state,\n      times = _this$state5.times,\n      type = _this$state5.type;\n    const options = [{\n      label: this._translate('Exactly'),\n      value: InputTimeEdit_EXACT\n    }, {\n      label: this._translate('Before'),\n      value: InputTimeEdit_BEFORE\n    }, {\n      label: this._translate('After'),\n      value: InputTimeEdit_AFTER\n    }, {\n      label: this._translate('Between'),\n      value: InputTimeEdit_BETWEEN\n    }];\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-time-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit time'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"noInput\": true,\n      \"onChange\": this.onTypeChange,\n      \"options\": options,\n      \"value\": type\n    }), 2), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", type === InputTimeEdit_BETWEEN ? this._translate('Edit start time') : this._translate('Set time'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"className\": \"start-time-input dms-block\",\n      \"onInput\": this.onStartTimeInput,\n      \"placeholder\": this._translate('e.g. { example } ', {\n        example: getSampleDate()\n      }),\n      \"validate\": string => simple_time_edit_Utils_validateISOString(string) && this._translate(simple_time_edit_Utils_validateISOString(string)),\n      \"value\": times[0]\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"use-now\", this._translate('Use now'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onSetStartTimeNowClick\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 4)], 4), type === InputTimeEdit_BETWEEN && (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Edit end time'), 0), type === InputTimeEdit_BETWEEN && (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"className\": \"end-time-input dms-block\",\n      \"onInput\": this.onEndTimeInput,\n      \"placeholder\": this._translate('e.g. { example } ', {\n        example: getSampleDate()\n      }),\n      \"validate\": string => simple_time_edit_Utils_validateISOString(string) && this._translate(simple_time_edit_Utils_validateISOString(string)),\n      \"value\": times[1]\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"use-now\", this._translate('Use now'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onSetEndTimeNowClick\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 4)], 4)], 0);\n  }\n}\n//# sourceMappingURL=InputTimeEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-time-edit/components/OutputTimeEdit.js\n\n\n\n\n\nclass OutputTimeEdit extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._modeling = context.injector.get('modeling');\n    const element = this.props.context.element;\n    const parsedString = simple_time_edit_Utils_parseString(element.businessObject.text);\n    this.state = {\n      date: parsedString ? parsedString.date : ''\n    };\n    const debounceInput = context.injector.get('debounceInput');\n    this.debouncedEditCell = debounceInput(this.editCell.bind(this));\n    this.editCell = this.editCell.bind(this);\n    this.onClick = this.onClick.bind(this);\n    this.onInput = this.onInput.bind(this);\n  }\n  editCell(cell, text) {\n    this._modeling.editCell(cell, text);\n  }\n  onClick() {\n    const element = this.props.context.element;\n    const date = getSampleTime();\n    this.setState({\n      date\n    });\n    this.editCell(element.businessObject, \"time(\\\"\".concat(date, \"\\\")\"));\n  }\n  onInput(_ref) {\n    let value = _ref.value;\n    const element = this.props.context.element;\n    this.setState({\n      date: value\n    });\n    this.debouncedEditCell(element.businessObject, \"time(\\\"\".concat(value, \"\\\")\"));\n  }\n  render() {\n    const date = this.state.date;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"context-menu-container simple-time-edit\", [(0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", \"dms-heading\", this._translate('Edit Date'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"h4\", \"dms-heading\", this._translate('Set Date'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", null, [(0,inferno_index_esm/* createComponentVNode */.Iz)(2, ValidatedInput, {\n      \"onInput\": this.onInput,\n      \"placeholder\": this._translate('e.g. { example } ', {\n        example: getSampleDate()\n      }),\n      \"validate\": string => simple_time_edit_Utils_validateISOString(string) && this._translate(simple_time_edit_Utils_validateISOString(string)),\n      \"value\": date,\n      \"className\": \"dms-block\"\n    }), (0,inferno_index_esm/* createVNode */.Wm)(1, \"p\", \"dms-hint\", [this._translate('Set date'), (0,inferno_index_esm/* createTextVNode */.Uk)(\" \"), (0,inferno_index_esm/* createVNode */.Wm)(1, \"button\", \"use-now\", this._translate('to now'), 0, {\n      \"type\": \"button\",\n      \"onClick\": this.onClick\n    }), (0,inferno_index_esm/* createTextVNode */.Uk)(\".\")], 0)], 4)], 4);\n  }\n}\n//# sourceMappingURL=OutputTimeEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-time-edit/SimpleTimeEdit.js\n\n\n\nclass SimpleTimeEdit_SimpleDateEdit {\n  constructor(components, simpleMode) {\n    simpleMode.registerProvider(element => {\n      const typeRef = SimpleTimeEdit_getTypeRef(element);\n      return ((0,ModelUtil/* isInput */.u7)(element.col) || (0,ModelUtil/* isOutput */.RW)(element.col)) && isTime(typeRef);\n    });\n    components.onGetComponent('context-menu', function () {\n      let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      if (context.contextMenuType && context.contextMenuType === 'simple-mode-edit') {\n        if (!context.element) {\n          return;\n        }\n        const typeRef = SimpleTimeEdit_getTypeRef(context.element);\n        if (isTime(typeRef)) {\n          if ((0,ModelUtil/* isInput */.u7)(context.element.col)) {\n            return InputTimeEdit;\n          } else if ((0,ModelUtil/* isOutput */.RW)(context.element.col)) {\n            return OutputTimeEdit;\n          }\n        }\n      }\n    });\n  }\n}\nSimpleTimeEdit_SimpleDateEdit.$inject = ['components', 'simpleMode'];\n\n// helpers //////////////////////\n\nfunction SimpleTimeEdit_getTypeRef(element) {\n  if ((0,ModelUtil/* isInput */.u7)(element.col)) {\n    return element.col && element.col.businessObject.inputExpression.typeRef;\n  } else {\n    return element.col && element.col.businessObject.typeRef;\n  }\n}\nfunction isTime(typeRef) {\n  return typeRef === 'time';\n}\n//# sourceMappingURL=SimpleTimeEdit.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/simple-time-edit/index.js\n\n\n\n/* harmony default export */ const simple_time_edit = ({\n  __depends__: [lib_features_keyboard, simple_mode],\n  __init__: ['simpleTimeEdit'],\n  simpleTimeEdit: ['type', SimpleTimeEdit_SimpleDateEdit]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/column-resize/components/ResizeColumn.js\n\nfunction ResizeColumn_defineProperty(obj, key, value) { key = ResizeColumn_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction ResizeColumn_toPropertyKey(arg) { var key = ResizeColumn_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction ResizeColumn_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\nclass ResizeColumn extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    ResizeColumn_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    ResizeColumn_defineProperty(this, \"handleMouseDown\", event => {\n      const cell = (0,min_dom_dist_index_esm/* closest */.oq)(event.target, 'th', false);\n      startResize({\n        node: cell,\n        event,\n        minWidth: this.props.minWidth || 150,\n        onEnd: this.saveWidth\n      });\n    });\n    ResizeColumn_defineProperty(this, \"saveWidth\", newWidth => {\n      const col = this.props.col;\n      const update = {};\n      if ((0,ModelUtil.is)(col, 'dmn:DecisionTable')) {\n        update.annotationsWidth = newWidth;\n      } else {\n        update.width = newWidth;\n      }\n      this.modeling.updateProperties(col, update);\n    });\n    (0,inject/* inject */.f)(this);\n  }\n  componentDidMount() {\n    const root = this.getRoot();\n    this.changeSupport.onElementsChanged(root, this.onElementsChanged);\n  }\n  componentWillUnmount() {\n    const root = this.getRoot();\n    this.changeSupport.offElementsChanged(root, this.onElementsChanged);\n  }\n  getRoot() {\n    return this.sheet.getRoot();\n  }\n  isLastInputOrOutput() {\n    const col = this.props.col,\n      root = this.getRoot(),\n      bo = (0,ModelUtil/* getBusinessObject */.SS)(root);\n    if ((0,ModelUtil.is)(col, 'dmn:InputClause')) {\n      const inputs = bo.get('input');\n      return inputs.indexOf(col) === inputs.length - 1;\n    } else if ((0,ModelUtil.is)(col, 'dmn:OutputClause')) {\n      const outputs = bo.get('output');\n      return outputs.indexOf(col) === outputs.length - 1;\n    }\n  }\n  render() {\n    const style = this.isLastInputOrOutput() ? {\n      right: '-7px',\n      width: '27px'\n    } : null;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"resize-column-handle\", null, 1, {\n      \"onMouseDown\": this.handleMouseDown,\n      \"title\": this.translate('Resize'),\n      \"style\": style\n    });\n  }\n}\nResizeColumn.$inject = ['sheet', 'changeSupport', 'translate', 'modeling'];\n\n// helper\nfunction startResize(_ref) {\n  let node = _ref.node,\n    event = _ref.event,\n    minWidth = _ref.minWidth,\n    _ref$onEnd = _ref.onEnd,\n    onEnd = _ref$onEnd === void 0 ? noop : _ref$onEnd;\n  event.preventDefault();\n  const initialWidth = node.getBoundingClientRect().width;\n  const initialX = event.clientX;\n  let currentUpdate;\n  document.addEventListener('mousemove', handleMouseMove);\n  document.addEventListener('mouseup', handleMouseUp);\n  function handleMouseMove(event) {\n    event.preventDefault();\n    const currentWidth = getResizedWidth(event.clientX);\n    if (currentUpdate) {\n      cancelAnimationFrame(currentUpdate);\n    }\n    currentUpdate = requestAnimationFrame(() => {\n      node.style.width = currentWidth + 'px';\n    });\n  }\n  function handleMouseUp(event) {\n    event.preventDefault();\n    document.removeEventListener('mousemove', handleMouseMove);\n    document.removeEventListener('mouseup', handleMouseUp);\n    const currentWidth = getResizedWidth(event.clientX);\n    onEnd(currentWidth);\n  }\n  function getResizedWidth(currentX) {\n    const delta = currentX - initialX;\n    return Math.max(initialWidth + delta, minWidth);\n  }\n}\nfunction noop() {}\n//# sourceMappingURL=ResizeColumn.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/column-resize/ColumnResizeProvider.js\n\nfunction ColumnResizeProvider(components) {\n  components.onGetComponent('cell-inner', function () {\n    let context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    const cellType = context.cellType;\n    if (cellType === 'input-cell' || cellType === 'output-cell' || cellType === 'annotations') {\n      return ResizeColumn;\n    }\n  });\n}\nColumnResizeProvider.$inject = ['components'];\n//# sourceMappingURL=ColumnResizeProvider.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/features/column-resize/index.js\n\n/* harmony default export */ const column_resize = ({\n  __init__: ['columnResizeProvider'],\n  columnResizeProvider: ['type', ColumnResizeProvider]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-decision-table/lib/Editor.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass Editor_Editor extends lib_Viewer/* default */.Z {\n  getModules() {\n    return [...lib_Viewer/* default._getModules */.Z._getModules(), ...Editor_Editor._getModules()];\n  }\n  static _getModules() {\n    return [add_rule, editor, cell_selection, context_menu/* default */.Z, copy_cut_paste, key_bindings, create_inputs, data_types, features_context_menu, dmn_js_decision_table_lib_features_editor_actions, decision_table_head_editor, column_resize, features_drag_and_drop, description, expression_language, expression_languages/* default */.Z, lib_features_keyboard, decision_table_properties_editor, lib_features_editor_actions/* default */.Z, hit_policy_editor, interaction_events/* default */.Z, features_modeling, decision_rules_editor, features_selection/* default */.Z, simple_mode, simple_boolean_edit, simple_date_edit, simple_date_time_edit, simple_duration_edit, simple_number_edit, simple_string_edit, simple_time_edit];\n  }\n}\n//# sourceMappingURL=Editor.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-literal-expression/lib/Viewer.js + 24 modules\nvar dmn_js_literal_expression_lib_Viewer = __webpack_require__(\"./node_modules/dmn-js-literal-expression/lib/Viewer.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/decision-properties/components/DecisionPropertiesEditorComponent.js\n\nfunction DecisionPropertiesEditorComponent_defineProperty(obj, key, value) { key = DecisionPropertiesEditorComponent_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction DecisionPropertiesEditorComponent_toPropertyKey(arg) { var key = DecisionPropertiesEditorComponent_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction DecisionPropertiesEditorComponent_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nclass DecisionPropertiesEditorComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    DecisionPropertiesEditorComponent_defineProperty(this, \"onElementsChanged\", () => {\n      this.forceUpdate();\n    });\n    DecisionPropertiesEditorComponent_defineProperty(this, \"setDecisionName\", name => {\n      this._modeling.editDecisionName(name);\n    });\n    this._viewer = context.injector.get('viewer');\n    this._modeling = context.injector.get('modeling');\n    this.setupChangeListeners({\n      bind: this.getDecision().id\n    });\n  }\n  componentWillUnmount() {\n    this.setupChangeListeners({\n      unbind: this.getDecision().id\n    });\n  }\n  getDecision() {\n    return this._viewer.getDecision();\n  }\n  setupChangeListeners(_ref) {\n    let bind = _ref.bind,\n      unbind = _ref.unbind;\n    const changeSupport = this.context.changeSupport;\n    if (typeof unbind === 'string') {\n      changeSupport.offElementsChanged(unbind, this.onElementsChanged);\n    }\n    if (typeof bind === 'string') {\n      changeSupport.onElementsChanged(bind, this.onElementsChanged);\n    }\n  }\n  render() {\n    const _this$getDecision = this.getDecision(),\n      name = _this$getDecision.name;\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"header\", \"decision-properties\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, DecisionName, {\n      \"className\": \"decision-name editor\",\n      \"value\": name,\n      \"onBlur\": DecisionPropertiesEditorComponent_resetScroll,\n      \"onChange\": this.setDecisionName\n    }), 2);\n  }\n}\nclass DecisionName extends EditableComponent {\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"h3\", this.getClassName(), this.getEditor(), 0);\n  }\n}\nfunction DecisionPropertiesEditorComponent_resetScroll(event) {\n  event.target.scroll(0, 0);\n}\n//# sourceMappingURL=DecisionPropertiesEditorComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/decision-properties/DecisionPropertiesEditor.js\n\nconst DecisionPropertiesEditor_HIGH_PRIORITY = 1500;\nclass DecisionPropertiesEditor {\n  constructor(components) {\n    components.onGetComponent('viewer', DecisionPropertiesEditor_HIGH_PRIORITY, () => {\n      return DecisionPropertiesEditorComponent;\n    });\n  }\n}\nDecisionPropertiesEditor.$inject = ['components'];\n//# sourceMappingURL=DecisionPropertiesEditor.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/decision-properties/editor.js\n\n\n/* harmony default export */ const decision_properties_editor = ({\n  __depends__: [debounce_input],\n  __init__: ['decisionProperties'],\n  decisionProperties: ['type', DecisionPropertiesEditor]\n});\n//# sourceMappingURL=editor.js.map\n// EXTERNAL MODULE: ./node_modules/dmn-js-literal-expression/node_modules/min-dash/dist/index.esm.js\nvar dmn_js_literal_expression_node_modules_min_dash_dist_index_esm = __webpack_require__(\"./node_modules/dmn-js-literal-expression/node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/editor-actions/EditorActions.js\n\nconst NOT_REGISTERED_ERROR = 'is not a registered action',\n  IS_REGISTERED_ERROR = 'is already registered';\n\n/**\n * An interface that provides access to modeling actions by decoupling\n * the one who requests the action to be triggered and the trigger itself.\n *\n * It's possible to add new actions by registering them with ´registerAction´ and likewise\n * unregister existing ones with ´unregisterAction´.\n *\n */\nclass EditorActions_EditorActions {\n  constructor(commandStack, eventBus) {\n    this._actions = {\n      undo() {\n        commandStack.undo();\n      },\n      redo() {\n        commandStack.redo();\n      }\n    };\n  }\n\n  /**\n   * Triggers a registered action\n   *\n   * @param  {string} action\n   * @param  {Object} opts\n   *\n   * @return {Unknown} Returns what the registered listener returns\n   */\n  trigger(action, opts) {\n    if (!this._actions[action]) {\n      throw error(action, NOT_REGISTERED_ERROR);\n    }\n    return this._actions[action](opts);\n  }\n\n  /**\n   * Registers a collections of actions.\n   * The key of the object will be the name of the action.\n   *\n   * @param  {Object} actions\n   */\n  register(actions, listener) {\n    if (typeof actions === 'string') {\n      return this._registerAction(actions, listener);\n    }\n    (0,dmn_js_literal_expression_node_modules_min_dash_dist_index_esm/* forEach */.Ed)(actions, (listener, action) => {\n      this._registerAction(action, listener);\n    }, this);\n  }\n\n  /**\n   * Registers a listener to an action key\n   *\n   * @param  {string} action\n   * @param  {Function} listener\n   */\n  _registerAction(action, listener) {\n    if (this.isRegistered(action)) {\n      throw error(action, IS_REGISTERED_ERROR);\n    }\n    this._actions[action] = listener;\n  }\n\n  /**\n   * Unregister an existing action\n   *\n   * @param {string} action\n   */\n  unregister(action) {\n    if (!this.isRegistered(action)) {\n      throw error(action, NOT_REGISTERED_ERROR);\n    }\n    this._actions[action] = undefined;\n  }\n\n  /**\n   * Checks wether the given action is registered\n   *\n   * @param {string} action\n   *\n   * @return {boolean}\n   */\n  isRegistered(action) {\n    return !!this._actions[action];\n  }\n}\nEditorActions_EditorActions.$inject = ['commandStack', 'eventBus'];\n\n// helpers /////////////\n\nfunction error(action, message) {\n  return new Error(action + ' ' + message);\n}\n//# sourceMappingURL=EditorActions.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/editor-actions/index.js\n\n/* harmony default export */ const dmn_js_literal_expression_lib_features_editor_actions = ({\n  __init__: ['editorActions'],\n  editorActions: ['type', EditorActions_EditorActions]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/keyboard/KeyboardUtil.js\nfunction KeyboardUtil_hasModifier(modifiers) {\n  return modifiers.ctrlKey || modifiers.metaKey || modifiers.shiftKey || modifiers.altKey;\n}\nfunction keyboard_KeyboardUtil_isCmd(modifiers) {\n  // ensure we don't react to AltGr\n  // (mapped to CTRL + ALT)\n  if (modifiers.altKey) {\n    return false;\n  }\n  return modifiers.ctrlKey || modifiers.metaKey;\n}\nfunction KeyboardUtil_isShift(modifiers) {\n  return modifiers.shiftKey;\n}\n//# sourceMappingURL=KeyboardUtil.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/keyboard/Keyboard.js\nfunction keyboard_Keyboard_defineProperty(obj, key, value) { key = keyboard_Keyboard_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction keyboard_Keyboard_toPropertyKey(arg) { var key = keyboard_Keyboard_toPrimitive(arg, \"string\"); return typeof key === \"symbol\" ? key : String(key); }\nfunction keyboard_Keyboard_toPrimitive(input, hint) { if (typeof input !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (typeof res !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n/**\n * A keyboard abstraction that may be activated and\n * deactivated by users at will, consuming key events\n * and triggering diagram actions.\n *\n * The implementation fires the following key events that allow\n * other components to hook into key handling:\n *\n *  - keyboard.bind\n *  - keyboard.unbind\n *  - keyboard.init\n *  - keyboard.destroy\n *\n * All events contain the fields (node, listeners).\n *\n * A default binding for the keyboard may be specified via the\n * `keyboard.bindTo` configuration option.\n *\n * @param {Config} config\n * @param {EventBus} eventBus\n * @param {EditorActions} editorActions\n */\nclass Keyboard_Keyboard {\n  constructor(config, eventBus, editorActions) {\n    keyboard_Keyboard_defineProperty(this, \"_init\", () => {\n      this._registerDefaultBindings();\n      this._fire('init');\n    });\n    keyboard_Keyboard_defineProperty(this, \"_destroy\", () => {\n      this._fire('destroy');\n      this.unbind();\n      this._listeners = null;\n    });\n    keyboard_Keyboard_defineProperty(this, \"_keyHandler\", event => {\n      var i,\n        l,\n        listeners = this._listeners,\n        code = event.keyCode || event.charCode || -1;\n      for (i = 0; l = listeners[i]; i++) {\n        if (l(code, event)) {\n          event.preventDefault();\n          event.stopPropagation();\n          return;\n        }\n      }\n    });\n    keyboard_Keyboard_defineProperty(this, \"unbind\", () => {\n      var node = this._node;\n      if (node) {\n        this._fire('unbind');\n\n        // unbind key events\n        min_dom_dist_index_esm/* event.unbind */.B.unbind(node, 'keydown', this._keyHandler, true);\n      }\n      this._node = null;\n    });\n    this._config = config || {};\n    this._eventBus = eventBus;\n    this._editorActions = editorActions;\n    this._listeners = [];\n    eventBus.on('viewer.destroy', this._destroy);\n    eventBus.on('viewer.init', this._init);\n    eventBus.on('attach', () => {\n      if (this._config.bindTo) {\n        this.bind(config.bindTo);\n      }\n    });\n    eventBus.on('detach', this.unbind);\n  }\n  bind(node) {\n    // make sure that the keyboard is only bound once to the DOM\n    this.unbind();\n    this._node = node;\n\n    // bind key events\n    min_dom_dist_index_esm/* event.bind */.B.bind(node, 'keydown', this._keyHandler, true);\n    this._fire('bind');\n  }\n  getBinding() {\n    return this._node;\n  }\n  _fire(event) {\n    this._eventBus.fire('keyboard.' + event, {\n      node: this._node,\n      listeners: this._listeners\n    });\n  }\n  _registerDefaultBindings() {\n    var listeners = this._listeners;\n    var editorActions = this._editorActions;\n\n    // init default listeners\n\n    // undo\n    // (CTRL|CMD) + Z\n    function undo(key, modifiers) {\n      if (keyboard_KeyboardUtil_isCmd(modifiers) && !KeyboardUtil_isShift(modifiers) && key === 90) {\n        editorActions.trigger('undo');\n        return true;\n      }\n    }\n\n    // redo\n    // CTRL + Y\n    // CMD + SHIFT + Z\n    function redo(key, modifiers) {\n      if (keyboard_KeyboardUtil_isCmd(modifiers) && (key === 89 || key === 90 && KeyboardUtil_isShift(modifiers))) {\n        editorActions.trigger('redo');\n        return true;\n      }\n    }\n    listeners.push(undo);\n    listeners.push(redo);\n  }\n\n  /**\n   * Add a listener function that is notified with (key, modifiers) whenever\n   * the keyboard is bound and the user presses a key.\n   *\n   * @param {Function} listenerFn\n   */\n  addListener(listenerFn) {\n    this._listeners.unshift(listenerFn);\n  }\n  removeListener(listenerFn) {\n    this._listeners = this._listeners.filter(l => l !== listenerFn);\n  }\n}\nKeyboard_Keyboard.$inject = ['config.keyboard', 'eventBus', 'editorActions'];\n//# sourceMappingURL=Keyboard.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/keyboard/index.js\n\n\n/* harmony default export */ const dmn_js_literal_expression_lib_features_keyboard = ({\n  __depends__: [dmn_js_literal_expression_lib_features_editor_actions],\n  __init__: ['keyboard'],\n  keyboard: ['type', Keyboard_Keyboard]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/literal-expression-properties/components/LiteralExpressionPropertiesEditorComponent.js\n\n\n\n\nclass LiteralExpressionPropertiesComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._viewer = context.injector.get('viewer');\n    this._modeling = context.injector.get('modeling');\n    this._dataTypes = context.injector.get('dataTypes');\n    const decision = this._viewer.getDecision();\n    this.state = {\n      name: decision.variable.name,\n      typeRef: decision.variable.typeRef\n    };\n    this.setVariableName = this.setVariableName.bind(this);\n    this.setVariableType = this.setVariableType.bind(this);\n  }\n  setVariableName(name) {\n    this._modeling.editVariableName(name);\n    this.setState({\n      name\n    });\n  }\n  setVariableType(typeRef) {\n    if (typeRef === '') {\n      this._modeling.editVariableType(undefined);\n      this.setState({\n        typeRef: undefined\n      });\n    } else {\n      this._modeling.editVariableType(typeRef);\n      this.setState({\n        typeRef\n      });\n    }\n  }\n  render() {\n    const _this$state = this.state,\n      name = _this$state.name,\n      typeRef = _this$state.typeRef;\n    const typeRefOptions = this._dataTypes.getAll().map(t => {\n      return {\n        label: this._translate(t),\n        value: t\n      };\n    });\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"literal-expression-properties\", (0,inferno_index_esm/* createVNode */.Wm)(1, \"table\", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"tr\", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, this._translate('Variable Name:'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, (0,inferno_index_esm/* createComponentVNode */.Iz)(2, Input, {\n      \"className\": \"variable-name-input\",\n      \"onInput\": this.setVariableName,\n      \"placeholder\": 'name',\n      \"value\": name || ''\n    }), 2)], 4), (0,inferno_index_esm/* createVNode */.Wm)(1, \"tr\", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, this._translate('Variable Type:'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"onChange\": this.setVariableType,\n      \"options\": typeRefOptions,\n      \"value\": typeRef,\n      \"className\": \"variable-type-select dms-block\"\n    }), 2), 2)], 4), (0,inferno_index_esm/* createComponentVNode */.Iz)(2, LiteralExpressionPropertiesEditorComponent_ExpressionLanguage)], 4), 2);\n  }\n}\nclass LiteralExpressionPropertiesEditorComponent_ExpressionLanguage extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._translate = context.injector.get('translate');\n    this._viewer = context.injector.get('viewer');\n    this._modeling = context.injector.get('modeling');\n    this._expressionLanguages = context.injector.get('expressionLanguages');\n    this.setExpressionLanguage = this.setExpressionLanguage.bind(this);\n  }\n  setExpressionLanguage(expressionLanguage) {\n    if (expressionLanguage === '') {\n      this._modeling.editExpressionLanguage(undefined);\n    } else {\n      this._modeling.editExpressionLanguage(expressionLanguage);\n    }\n  }\n  _getExpressionLanguage() {\n    const decision = this._viewer.getDecision();\n    const literalExpression = decision.decisionLogic;\n    return literalExpression && literalExpression.expressionLanguage ? literalExpression.expressionLanguage.toLowerCase() : this._getDefaultExpressionLanguage();\n  }\n  _getDefaultExpressionLanguage() {\n    return this._expressionLanguages.getDefault().value;\n  }\n  _shouldRender() {\n    const expressionLanguages = this._expressionLanguages.getAll();\n    if (expressionLanguages.length > 1) {\n      return true;\n    }\n    const expressionLanguage = this._getExpressionLanguage();\n    return expressionLanguage !== this._getDefaultExpressionLanguage();\n  }\n  render() {\n    if (!this._shouldRender()) {\n      return null;\n    }\n    const expressionLanguage = this._getExpressionLanguage();\n    const languageOptions = this._expressionLanguages.getAll();\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"tr\", null, [(0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, this._translate('Expression Language:'), 0), (0,inferno_index_esm/* createVNode */.Wm)(1, \"td\", null, (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", \"dms-fill-row\", (0,inferno_index_esm/* createComponentVNode */.Iz)(2, InputSelect, {\n      \"onChange\": this.setExpressionLanguage,\n      \"options\": languageOptions,\n      \"value\": expressionLanguage,\n      \"className\": \"expression-language-select dms-block\"\n    }), 2), 2)], 4);\n  }\n}\n//# sourceMappingURL=LiteralExpressionPropertiesEditorComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/literal-expression-properties/LiteralExpressionPropertiesEditor.js\n\nconst LiteralExpressionPropertiesEditor_LOW_PRIORITY = 500;\nclass LiteralExpressionPropertiesEditor {\n  constructor(components) {\n    components.onGetComponent('viewer', LiteralExpressionPropertiesEditor_LOW_PRIORITY, () => {\n      return LiteralExpressionPropertiesComponent;\n    });\n  }\n}\nLiteralExpressionPropertiesEditor.$inject = ['components'];\n//# sourceMappingURL=LiteralExpressionPropertiesEditor.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/literal-expression-properties/editor.js\n\n\n\n\n\n/* harmony default export */ const literal_expression_properties_editor = ({\n  __depends__: [debounce_input, dmn_js_literal_expression_lib_features_keyboard, expression_languages/* default */.Z, DataTypes],\n  __init__: ['literalExpressionProperties'],\n  literalExpressionProperties: ['type', LiteralExpressionPropertiesEditor]\n});\n//# sourceMappingURL=editor.js.map\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/CommandStack.js\nvar CommandStack = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandStack.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/modeling/Modeling.js\n\n\nclass features_modeling_Modeling_Modeling {\n  constructor(commandStack, viewer, eventBus) {\n    this._commandStack = commandStack;\n    this._viewer = viewer;\n    this._eventBus = eventBus;\n    eventBus.on('viewer.init', () => {\n      // register modeling handlers\n      registerHandlers(this.getHandlers(), commandStack);\n    });\n  }\n  getHandlers() {\n    return features_modeling_Modeling_Modeling._getHandlers();\n  }\n  static _getHandlers() {\n    return {\n      'element.updateProperties': EditPropertiesHandler\n    };\n  }\n  getDecision() {\n    return this._viewer.getDecision();\n  }\n  editDecisionName(name) {\n    const decision = this.getDecision();\n    const context = {\n      element: decision,\n      properties: {\n        name\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editDecisionId(id) {\n    const decision = this.getDecision();\n    const context = {\n      element: decision,\n      properties: {\n        id\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editLiteralExpressionText(text) {\n    const decision = this.getDecision(),\n      literalExpression = decision.decisionLogic;\n    const context = {\n      element: literalExpression,\n      properties: {\n        text\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editExpressionLanguage(expressionLanguage) {\n    const decision = this.getDecision(),\n      literalExpression = decision.decisionLogic;\n    const context = {\n      element: literalExpression,\n      properties: {\n        expressionLanguage\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editVariableName(name) {\n    const decision = this.getDecision(),\n      variable = decision.variable;\n    const context = {\n      element: variable,\n      properties: {\n        name\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n  editVariableType(typeRef) {\n    const decision = this.getDecision(),\n      variable = decision.variable;\n    const context = {\n      element: variable,\n      properties: {\n        typeRef\n      }\n    };\n    this._commandStack.execute('element.updateProperties', context);\n  }\n}\nfeatures_modeling_Modeling_Modeling.$inject = ['commandStack', 'viewer', 'eventBus'];\n\n// helpers //////////////////////\n\n/**\r\n * Register handlers with the command stack\r\n *\r\n * @param {Object} handlers { id -> Handler } map\r\n * @param {CommandStack} commandStack\r\n */\nfunction registerHandlers(handlers, commandStack) {\n  (0,dmn_js_literal_expression_node_modules_min_dash_dist_index_esm/* forEach */.Ed)(handlers, function (handler, id) {\n    commandStack.registerHandler(id, handler);\n  });\n}\n//# sourceMappingURL=Modeling.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/modeling/index.js\n\n\n\n/* harmony default export */ const lib_features_modeling = ({\n  __init__: ['idChangeBehavior', 'modeling'],\n  commandStack: ['type', CommandStack/* default */.Z],\n  idChangeBehavior: ['type', IdChangeBehavior],\n  modeling: ['type', features_modeling_Modeling_Modeling]\n});\n//# sourceMappingURL=index.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/textarea/components/TextareaEditorComponent.js\n\n\n\nclass TextareaEditorComponent extends inferno_index_esm/* Component */.wA {\n  constructor(props, context) {\n    super(props, context);\n    this._modeling = context.injector.get('modeling');\n    this._viewer = context.injector.get('viewer');\n    this.editLiteralExpressionText = this.editLiteralExpressionText.bind(this);\n    this.onElementsChanged = this.onElementsChanged.bind(this);\n\n    // there is only one single element\n    const _this$getLiteralExpre = this.getLiteralExpression(),\n      id = _this$getLiteralExpre.id;\n    context.changeSupport.onElementsChanged(id, this.onElementsChanged);\n  }\n  getLiteralExpression() {\n    return this._viewer.getDecision().decisionLogic;\n  }\n  onElementsChanged() {\n    this.forceUpdate();\n  }\n  editLiteralExpressionText(text) {\n    this._modeling.editLiteralExpressionText(text);\n  }\n  render() {\n    // there is only one single element\n    const _this$getLiteralExpre2 = this.getLiteralExpression(),\n      text = _this$getLiteralExpre2.text;\n    return (0,inferno_index_esm/* createComponentVNode */.Iz)(2, TextareaEditorComponent_Editor, {\n      \"className\": \"textarea editor\",\n      \"value\": text,\n      \"onChange\": this.editLiteralExpressionText\n    });\n  }\n}\nclass TextareaEditorComponent_Editor extends EditableComponent {\n  render() {\n    return (0,inferno_index_esm/* createVNode */.Wm)(1, \"div\", this.getClassName(), this.getEditor(), 0);\n  }\n}\n//# sourceMappingURL=TextareaEditorComponent.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/textarea/TextareaEditor.js\n\nclass Textarea {\n  constructor(components) {\n    components.onGetComponent('viewer', () => TextareaEditorComponent);\n  }\n}\nTextarea.$inject = ['components'];\n//# sourceMappingURL=TextareaEditor.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/features/textarea/editor.js\n\n\n/* harmony default export */ const textarea_editor = ({\n  __depends__: [debounce_input],\n  __init__: ['textarea'],\n  textarea: ['type', Textarea]\n});\n//# sourceMappingURL=editor.js.map\n;// CONCATENATED MODULE: ./node_modules/dmn-js-literal-expression/lib/Editor.js\n\n\n\n\n\n\n\n\nclass lib_Editor_Editor extends dmn_js_literal_expression_lib_Viewer/* default */.Z {\n  getModules() {\n    return [...dmn_js_literal_expression_lib_Viewer/* default._getModules */.Z._getModules(), ...lib_Editor_Editor._getModules()];\n  }\n  static _getModules() {\n    return [decision_properties_editor, dmn_js_literal_expression_lib_features_keyboard, literal_expression_properties_editor, lib_features_modeling, expression_languages/* default */.Z, data_types, textarea_editor];\n  }\n}\n//# sourceMappingURL=Editor.js.map\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar node_modules_min_dash_dist_index_esm_0 = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/dmn-js/lib/Modeler.js\n\n\n\n\n\n\n\n\n/**\n * The dmn editor.\n */\nclass Modeler extends EditingManager {\n  _getViewProviders() {\n    return [{\n      id: 'drd',\n      constructor: Modeler_Modeler,\n      opens: 'dmn:Definitions'\n    }, {\n      id: 'decisionTable',\n      constructor: Editor_Editor,\n      opens(element) {\n        return (0,ModelUtil.is)(element, 'dmn:Decision') && (0,ModelUtil.is)(element.decisionLogic, 'dmn:DecisionTable');\n      }\n    }, {\n      id: 'literalExpression',\n      constructor: lib_Editor_Editor,\n      opens(element) {\n        return (0,ModelUtil.is)(element, 'dmn:Decision') && (0,ModelUtil.is)(element.decisionLogic, 'dmn:LiteralExpression');\n      }\n    }];\n  }\n  _getInitialView(views) {\n    for (var _len = arguments.length, rest = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n      rest[_key - 1] = arguments[_key];\n    }\n    let initialView = super._getInitialView(views, ...rest);\n    if (!initialView) {\n      return;\n    }\n    const element = initialView.element;\n\n    // if initial view is definitions without DI, try to open another view\n    if ((0,ModelUtil.is)(element, 'dmn:Definitions') && !(0,DiUtil/* containsDi */.w)(element)) {\n      initialView = (0,node_modules_min_dash_dist_index_esm_0/* find */.sE)(views, view => !(0,ModelUtil.is)(view.element, 'dmn:Definitions')) || initialView;\n    }\n    return initialView;\n  }\n}\n//# sourceMappingURL=Modeler.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js/lib/Modeler.js_+_195_modules?")},"./node_modules/dmn-js/lib/Viewer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ Viewer)\n/* harmony export */ });\n/* harmony import */ var dmn_js_shared_lib_base_Manager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/dmn-js-shared/lib/base/Manager.js");\n/* harmony import */ var dmn_js_drd_lib_Viewer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/dmn-js-drd/lib/Viewer.js");\n/* harmony import */ var dmn_js_decision_table_lib_Viewer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./node_modules/dmn-js-decision-table/lib/Viewer.js");\n/* harmony import */ var dmn_js_literal_expression_lib_Viewer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./node_modules/dmn-js-literal-expression/lib/Viewer.js");\n/* harmony import */ var dmn_js_shared_lib_util_ModelUtil__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./node_modules/dmn-js-shared/lib/util/ModelUtil.js");\n/* harmony import */ var dmn_js_shared_lib_util_DiUtil__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("./node_modules/dmn-js-shared/lib/util/DiUtil.js");\n\n\n\n\n\n\n\n/**\n * The dmn viewer.\n */\nclass Viewer extends dmn_js_shared_lib_base_Manager__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z {\n  _getViewProviders() {\n    return [{\n      id: \'drd\',\n      constructor: dmn_js_drd_lib_Viewer__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z,\n      opens(element) {\n        return (0,dmn_js_shared_lib_util_ModelUtil__WEBPACK_IMPORTED_MODULE_4__.is)(element, \'dmn:Definitions\') && (0,dmn_js_shared_lib_util_DiUtil__WEBPACK_IMPORTED_MODULE_5__/* .containsDi */ .w)(element);\n      }\n    }, {\n      id: \'decisionTable\',\n      constructor: dmn_js_decision_table_lib_Viewer__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z,\n      opens(element) {\n        return (0,dmn_js_shared_lib_util_ModelUtil__WEBPACK_IMPORTED_MODULE_4__.is)(element, \'dmn:Decision\') && (0,dmn_js_shared_lib_util_ModelUtil__WEBPACK_IMPORTED_MODULE_4__.is)(element.decisionLogic, \'dmn:DecisionTable\');\n      }\n    }, {\n      id: \'literalExpression\',\n      constructor: dmn_js_literal_expression_lib_Viewer__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,\n      opens(element) {\n        return (0,dmn_js_shared_lib_util_ModelUtil__WEBPACK_IMPORTED_MODULE_4__.is)(element, \'dmn:Decision\') && (0,dmn_js_shared_lib_util_ModelUtil__WEBPACK_IMPORTED_MODULE_4__.is)(element.decisionLogic, \'dmn:LiteralExpression\');\n      }\n    }];\n  }\n}\n//# sourceMappingURL=Viewer.js.map\n\n//# sourceURL=webpack://VDCPENT/./node_modules/dmn-js/lib/Viewer.js?')}}]);