/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.dmnpluginenterprise.rest;

import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import de.viadee.confluence.enterprisecore.rest.SpaceAccessModel;
import de.viadee.confluence.enterprisecore.rest.SpaceAccessResource;
import de.viadee.confluence.enterprisecore.security.AuthValidator;
import de.viadee.confluence.enterprisecore.service.EnabledSpaceService;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/spaces")
public class SpaceAccessController
extends AbstractResource {
    public static final String PATH = "/spaces";
    private final SpaceAccessResource spaceAccessResource;
    private final AuthValidator authValidator;

    public SpaceAccessController(UserAccessor userAccessor, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, EnabledSpaceService spaceService, SpaceManager spaceManager) {
        super(userAccessor, spacePermissionManager);
        this.spaceAccessResource = new SpaceAccessResource(spaceService, spaceManager);
        this.authValidator = new AuthValidator(userAccessor, spacePermissionManager, permissionManager, spaceManager);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllSpaces() {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.spaceAccessResource.getAllSpaces();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    public Response getSpaceByKey(@PathParam(value="key") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkAuthentication().checkSpacePermission(spaceKey, Permission.VIEW);
        this.createRequestContext();
        return this.spaceAccessResource.getSpaceByKey(spaceKey);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addSpaceToWhiteListByKey(List<SpaceAccessModel> spaces) {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.spaceAccessResource.addSpaceToWhiteListByKey(spaces);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{key}")
    public Response removeSpaceFromWhitelistByKey(@PathParam(value="key") String spaceKey) {
        this.authValidator.createContext(this.authContext).checkConfluenceAdminStatus();
        this.createRequestContext();
        return this.spaceAccessResource.removeSpaceFromWhitelistByKey(spaceKey);
    }
}

