(()=>{var __webpack_modules__={"./common/resources/newCmmnDiagram.cmmn":module=>{eval('module.exports = "<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?>\\n<cmmn:definitions xmlns:dc=\\"http://www.omg.org/spec/CMMN/20151109/DC\\" xmlns:di=\\"http://www.omg.org/spec/CMMN/20151109/DI\\" xmlns:cmmndi=\\"http://www.omg.org/spec/CMMN/20151109/CMMNDI\\" xmlns:cmmn=\\"http://www.omg.org/spec/CMMN/20151109/MODEL\\" xmlns:xsi=\\"http://www.w3.org/2001/XMLSchema-instance\\" id=\\"sample-diagram\\" targetNamespace=\\"http://bpmn.io/schema/cmmn\\">\\n  <cmmn:case id=\\"Case_1\\">\\n    <cmmn:casePlanModel id=\\"CasePlanModel_1\\" name=\\"A CasePlanModel\\">\\n      <cmmn:planItem id=\\"PlanItem_1\\" definitionRef=\\"Task_1\\" />\\n      <cmmn:task id=\\"Task_1\\" />\\n    </cmmn:casePlanModel>\\n  </cmmn:case>\\n  <cmmndi:CMMNDI>\\n    <cmmndi:CMMNDiagram id=\\"CMMNDiagram_1\\">\\n      <cmmndi:Size xsi:type=\\"dc:Dimension\\" width=\\"500\\" height=\\"500\\" />\\n      <cmmndi:CMMNShape id=\\"DI_CasePlanModel_1\\" cmmnElementRef=\\"CasePlanModel_1\\">\\n        <dc:Bounds x=\\"114\\" y=\\"63\\" width=\\"534\\" height=\\"389\\" />\\n        <cmmndi:CMMNLabel />\\n      </cmmndi:CMMNShape>\\n      <cmmndi:CMMNShape id=\\"PlanItem_1_di\\" cmmnElementRef=\\"PlanItem_1\\">\\n        <dc:Bounds x=\\"150\\" y=\\"96\\" width=\\"100\\" height=\\"80\\" />\\n        <cmmndi:CMMNLabel />\\n      </cmmndi:CMMNShape>\\n    </cmmndi:CMMNDiagram>\\n  </cmmndi:CMMNDI>\\n</cmmn:definitions>";\n\n//# sourceURL=webpack://VCCPFREE/./common/resources/newCmmnDiagram.cmmn?')},"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\nexports["default"] = VxcpLogger;\n\n\n//# sourceURL=webpack://VCCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./common/cmmnAttachment-manager.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getAttachmentVersion = exports.loadAttachment = exports.uploadAttachment = void 0;\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name.service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "CmmnAttachmentManager");\nfunction makeRequest(opts) {\n    return new Promise((resolve, reject) => {\n        const xhr = new XMLHttpRequest();\n        xhr.open(opts.method, opts.url, true);\n        const maxWaitTime = 10000;\n        const noResponseTimer = setTimeout(() => {\n            xhr.abort();\n            reject({\n                status: 503,\n                message: "Service unreachable",\n            });\n        }, maxWaitTime);\n        xhr.onload = () => {\n            clearTimeout(noResponseTimer);\n            if (xhr.status >= 200 && xhr.status < 300) {\n                resolve(xhr.response);\n            }\n            else {\n                reject(xhr);\n            }\n        };\n        xhr.onerror = () => {\n            clearTimeout(noResponseTimer);\n            reject(xhr);\n        };\n        if (opts.headers) {\n            Object.keys(opts.headers).forEach((key) => {\n                xhr.setRequestHeader(key, opts.headers[key]);\n            });\n        }\n        xhr.send(opts.formData);\n    });\n}\nfunction buildRestUrl(restCall, pageId) {\n    const baseUrl = window.location.protocol + "//" + window.location.host;\n    const contextPath = (0, utils_1.getParams)().contextPath;\n    const restPath = "/rest/api/content/";\n    return baseUrl + contextPath + restPath + pageId + restCall;\n}\nfunction getAttachmentListRequest(pageId) {\n    return makeRequest({\n        url: buildRestUrl("/child/attachment?start=0", pageId),\n        method: "GET",\n    });\n}\nfunction updateAttachmentRequest(attachmentId, file, fileName, pageId) {\n    const url = buildRestUrl("/child/attachment/" + attachmentId + "/data", pageId);\n    const formData = new FormData();\n    formData.append("file", file, fileName);\n    const headers = { "X-Atlassian-Token": "no-check" };\n    return makeRequest({\n        url,\n        method: "POST",\n        headers,\n        formData,\n    });\n}\nfunction uploadAttachmentRequest(file, fileName, pageId) {\n    const url = buildRestUrl("/child/attachment", pageId);\n    const formData = new FormData();\n    formData.append("file", file, fileName);\n    const headers = { "X-Atlassian-Token": "no-check" };\n    return makeRequest({\n        url,\n        method: "POST",\n        headers,\n        formData,\n    });\n}\nfunction getFileRequest(url) {\n    return makeRequest({\n        method: "GET",\n        url,\n    });\n}\nfunction getAttachmentData(attachmentList, name) {\n    return JSON.parse(attachmentList).results.filter((attachment) => {\n        return attachment.title === name;\n    });\n}\nfunction buildDownloadUrl(downloadPath) {\n    const baseUrl = window.location.protocol + "//" + window.location.host;\n    const contextPath = (0, utils_1.getParams)().contextPath;\n    return baseUrl + contextPath + downloadPath;\n}\nfunction getIdByName(attachmentList, name) {\n    const result = JSON.parse(attachmentList).results.filter((attachment) => {\n        return attachment.title === name;\n    });\n    return result.length > 0 ? result[0].id : undefined;\n}\nfunction getAttachmentHistoryRequest(attachmentId) {\n    return makeRequest({\n        url: buildRestUrl(attachmentId + "/history", ""),\n        method: "GET",\n    });\n}\nfunction uploadAttachment(file, fileName, pageId) {\n    return getAttachmentListRequest(pageId)\n        .then((attachmentList) => {\n        const attachmentId = getIdByName(attachmentList, fileName);\n        if (attachmentId) {\n            return updateAttachmentRequest(attachmentId, file, fileName, pageId);\n        }\n        else {\n            return uploadAttachmentRequest(file, fileName, pageId);\n        }\n    })\n        .catch((err) => {\n        return Promise.reject(err);\n    });\n}\nexports.uploadAttachment = uploadAttachment;\nfunction loadAttachment(name, pageId) {\n    return getAttachmentListRequest(pageId)\n        .then((attachmentList) => {\n        const attachmentData = getAttachmentData(attachmentList, name);\n        if (!attachmentData[0]) {\n            return Promise.reject({\n                status: 404,\n                responseText: "Attachment not Found",\n            });\n        }\n        else if (attachmentData.length !== 1) {\n            vxcpLogger.logWarning("loadAttachment", "Multiple corresponding CMMN attachments were found. The latest attachment will be loaded.");\n        }\n        const downloadLink = buildDownloadUrl(attachmentData[0]._links.download);\n        const attachmentId = attachmentData[0].id;\n        return getAttachmentHistoryRequest(attachmentId)\n            .then((history) => {\n            return JSON.parse(history).lastUpdated.number;\n        })\n            .then((version) => {\n            return getFileRequest(downloadLink).then((fileData) => {\n                return {\n                    data: fileData,\n                    id: attachmentId,\n                    version,\n                };\n            });\n        });\n    })\n        .catch((error) => {\n        return Promise.reject(error);\n    });\n}\nexports.loadAttachment = loadAttachment;\nfunction getAttachmentVersion(name, pageId) {\n    return getAttachmentListRequest(pageId).then((list) => {\n        const attachmentId = getIdByName(list, name);\n        if (attachmentId) {\n            return getAttachmentHistoryRequest(attachmentId).then((history) => {\n                return {\n                    id: attachmentId,\n                    version: JSON.parse(history).lastUpdated.number,\n                };\n            });\n        }\n        else {\n            return Promise.reject({\n                status: 404,\n                responseText: "Attachment not Found",\n            });\n        }\n    });\n}\nexports.getAttachmentVersion = getAttachmentVersion;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/cmmnAttachment-manager.ts?')},"./common/newCmmnDiagramXml.ts":(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getNewCmmnDiagramXml = void 0;\nconst newCmmnDiagram = __webpack_require__("./common/resources/newCmmnDiagram.cmmn");\nconst getNewCmmnDiagramXml = () => newCmmnDiagram;\nexports.getNewCmmnDiagramXml = getNewCmmnDiagramXml;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/newCmmnDiagramXml.ts?')},"./common/plugin-name.service.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.pluginName = void 0;\nexports.pluginName = "CMMN-PLUGIN";\n\n\n//# sourceURL=webpack://VCCPFREE/./common/plugin-name.service.ts?')},"./common/utils.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getRemoteUserKey = exports.getCurrentUserFullName = exports.getConfluenceVersion = exports.getSpaceName = exports.getSpaceKey = exports.getBaseUrl = exports.isNewPage = exports.getContextPath = exports.getUserLocale = exports.getLatestPageId = exports.getContentType = exports.getPageId = exports.getAccessMode = exports.getContentId = exports.getParams = exports.initViadeeLogo = exports.showWarningDialog = exports.getQueryParam = void 0;\nfunction getQueryParam(param) {\n    const result = window.location.search.match(new RegExp("(\\\\?|&)" + param + "(\\\\[\\\\])?=([^&]*)"));\n    return result ? result[3] : 0;\n}\nexports.getQueryParam = getQueryParam;\nfunction showWarningDialog(AJS, dialogId, template, callbackContinue, callbackAbort, params) {\n    const dialog = template(params);\n    AJS.$("body").append(dialog);\n    AJS.dialog2(dialogId).show();\n    AJS.$(dialogId).show();\n    AJS.dialog2(dialogId).on("hide", () => {\n        AJS.$(dialogId).remove();\n    });\n    AJS.$(dialogId + "-abort").click((e) => {\n        AJS.dialog2(dialogId).hide();\n        if (typeof callbackAbort === "function") {\n            callbackAbort();\n        }\n    });\n    AJS.$(dialogId + "-continue").click((e) => {\n        AJS.dialog2(dialogId).hide();\n        if (typeof callbackContinue === "function") {\n            callbackContinue();\n        }\n    });\n}\nexports.showWarningDialog = showWarningDialog;\nfunction initViadeeLogo(cmmnDiagramName) {\n    cmmnDiagramName = cmmnDiagramName.replace(" ", "_");\n    const viadeeLogoId = "viadee-logo-viewer-" + cmmnDiagramName;\n    const viadeeLogoName = AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.icon.title.name.viadee.logo");\n    const modelerLink = AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.icon.title.name.viadee.logo-link");\n    const viadeeLogo = createViadeeLogo(viadeeLogoId, viadeeLogoName, "22", "30");\n    $("#vccp-viewer-" + cmmnDiagramName + " .cjs-container").append(viadeeLogo);\n    $(`#${viadeeLogoId}`).on("click", (event) => {\n        window.open(modelerLink, "_blank");\n        event.preventDefault();\n    });\n    function createViadeeLogo(btnId, titleName, positionBottom, positionLeft) {\n        const title = `title="${titleName}"`;\n        const htmlCode = `<div id="${btnId}"\n            class="viadee-logo-viewer"\n            position="absolute"\n            style="bottom: ${positionBottom}px; left: ${positionLeft}px;" ${title}>\n            </div>`;\n        return htmlCode;\n    }\n}\nexports.initViadeeLogo = initViadeeLogo;\nfunction getParams() {\n    return {\n        accessMode: getAccessMode(),\n        baseUrl: getBaseUrl(),\n        currentUserFullname: getCurrentUserFullName(),\n        versionNumber: getConfluenceVersion(),\n        newPage: isNewPage(),\n        spaceKey: getSpaceKey(),\n        spaceName: getSpaceName(),\n        pageId: getPageId(),\n        contentType: getContentType(),\n        latestPageId: getLatestPageId(),\n        userLocale: getUserLocale(),\n        contextPath: getContextPath(),\n        remoteUserKey: getRemoteUserKey(),\n        contentId: getContentId(),\n    };\n}\nexports.getParams = getParams;\nfunction getContentId() {\n    return Confluence.getContentId() ? Confluence.getContentId() : AJS.Meta.get("content-id");\n}\nexports.getContentId = getContentId;\nfunction getAccessMode() {\n    return AJS.Meta.get("access-mode");\n}\nexports.getAccessMode = getAccessMode;\nfunction getPageId() {\n    return AJS.Meta.get("page-id");\n}\nexports.getPageId = getPageId;\nfunction getContentType() {\n    return AJS.Meta.get("content-type");\n}\nexports.getContentType = getContentType;\nfunction getLatestPageId() {\n    return AJS.Meta.get("latest-page-id");\n}\nexports.getLatestPageId = getLatestPageId;\nfunction getUserLocale() {\n    return AJS.Meta.get("user-locale");\n}\nexports.getUserLocale = getUserLocale;\nfunction getContextPath() {\n    return AJS.Meta.get("context-path") || Confluence.getContextPath();\n}\nexports.getContextPath = getContextPath;\nfunction isNewPage() {\n    return AJS.Meta.get("new-page");\n}\nexports.isNewPage = isNewPage;\nfunction getBaseUrl() {\n    return AJS.Meta.get("base-url");\n}\nexports.getBaseUrl = getBaseUrl;\nfunction getSpaceKey() {\n    return AJS.Meta.get("space-key");\n}\nexports.getSpaceKey = getSpaceKey;\nfunction getSpaceName() {\n    return AJS.Meta.get("space-name");\n}\nexports.getSpaceName = getSpaceName;\nfunction getConfluenceVersion() {\n    return AJS.Meta.get("version-number");\n}\nexports.getConfluenceVersion = getConfluenceVersion;\nfunction getCurrentUserFullName() {\n    return AJS.Meta.get("current-user-fullname");\n}\nexports.getCurrentUserFullName = getCurrentUserFullName;\nfunction getRemoteUserKey() {\n    return AJS.Meta.get("remote-user-key");\n}\nexports.getRemoteUserKey = getRemoteUserKey;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/utils.ts?')},"./viewer/cmmnViewerApp.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.CmmnViewerApp = void 0;\nconst AttachmentManager = __importStar(__webpack_require__("./common/cmmnAttachment-manager.ts"));\nconst confUtils = __importStar(__webpack_require__("./common/utils.ts"));\nconst newCmmnDiagramXml = __importStar(__webpack_require__("./common/newCmmnDiagramXml.ts"));\nconst NavigatedViewer_1 = __importDefault(__webpack_require__("./node_modules/cmmn-js/lib/NavigatedViewer.js"));\nconst cmmn_js_1 = __importDefault(__webpack_require__("./node_modules/cmmn-js/index.js"));\nconst diagram_js_origin_1 = __importDefault(__webpack_require__("./node_modules/diagram-js-origin/index.js"));\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name.service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nclass CmmnViewerApp {\n    constructor() {\n        this.pageId = "";\n        this.cmmnDiagramName = "";\n        this.fullscreen = false;\n        this.vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "CmmnViewerApp");\n    }\n    init(pageId, cmmnDiagramId, cmmnDiagramName, fullscreen) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.pageId = pageId;\n            this.cmmnDiagramName = cmmnDiagramName;\n            this.fullscreen = fullscreen;\n            const $title = $("#vccp-diagram-title-" + cmmnDiagramId);\n            this.$editLink = $title.find("#vccp-viewer-edit");\n            this.$fullscreenLink = $title.find("#vccp-viewer-fullscreen");\n            this.$cmmnDiagramVersion = $title.find("#vccp-diagram-version");\n            const $closeFullscreenLink = $title.find("#vccp-fullscreen-close");\n            this.$viewer = fullscreen ? $("#vccp-viewer") : $("#vccp-viewer-" + cmmnDiagramId);\n            const canvasId = fullscreen ? ".canvas-fullscreen-viewer" : ".vccp-canvas";\n            this.$canvas = this.$viewer.find(canvasId);\n            this.$loadingText = this.$viewer.find("#cmmndiagram-loading");\n            this.viewer = fullscreen ? this.initCmmnFullscreenViewer() : this.initCmmnViewer();\n            const hideFullscreenLinkCreate = /\\/(create|edit)page\\.action/i.test(window.location.href);\n            const hideFullscreenLinkDraftShare = /\\/.*draftShareId.*/i.test(window.location.href);\n            this.hideFullscreenLink = hideFullscreenLinkCreate || hideFullscreenLinkDraftShare;\n            if (!this.viewer) {\n                return;\n            }\n            if (pageId === undefined) {\n                pageId = confUtils.getQueryParam("pageId");\n            }\n            if (fullscreen) {\n                $closeFullscreenLink.click((e) => {\n                    e.stopPropagation();\n                    e.preventDefault();\n                    window.open(Confluence.getContextPath() + "/pages/viewpage.action?pageId=" + pageId, "_self");\n                });\n            }\n            else {\n                this.$editLink.click((e) => {\n                    e.stopPropagation();\n                    e.preventDefault();\n                    $("body").append(this.createIFrame(pageId, cmmnDiagramId, cmmnDiagramName));\n                });\n                this.$fullscreenLink.click((e) => {\n                    e.stopPropagation();\n                    e.preventDefault();\n                    window.open(Confluence.getContextPath() + "/plugins/cmmn-plugin/view-cmmndiagram.action?pageId=" + pageId + "&cmmnDiagramId=" + cmmnDiagramId + "&cmmnDiagramName=" + cmmnDiagramName, "_self");\n                });\n                confUtils.initViadeeLogo(this.cmmnDiagramName);\n            }\n            const $expander = this.$viewer.closest(".expand-container");\n            $expander.children(".expand-control").on("click", (e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                const canvas = this.viewer.get("canvas");\n                canvas.resized();\n                canvas.zoom("fit-viewport");\n            });\n            this.displayViewer();\n            yield this.loadCmmnDiagram();\n        });\n    }\n    createIFrame(pageId, cmmnDiagramId, cmmnDiagramName) {\n        const iframe = document.createElement("iframe");\n        iframe.setAttribute("id", "cmmn-editor");\n        iframe.setAttribute("style", "position: fixed; width: 100%; height: 100%; top: 0px; left: 0px; border: 0px none; z-index: 3000;");\n        iframe.setAttribute("src", Confluence.getContextPath() +\n            "/plugins/cmmn-plugin/edit-cmmndiagram.action?pageId=" +\n            pageId +\n            "&cmmnDiagramId=" +\n            cmmnDiagramId +\n            "&cmmnDiagramName=" +\n            cmmnDiagramName +\n            "&reloadPage=true");\n        iframe.onload = () => {\n            $("body").css("overflow", "hidden");\n        };\n        return iframe;\n    }\n    displayViewer() {\n        this.$viewer.show();\n        this.$editLink.show();\n        this.hideFullscreenLink ? this.$fullscreenLink.hide() : this.$fullscreenLink.show();\n    }\n    displayVersion(version) {\n        this.$cmmnDiagramVersion.html("(v." + version + ")");\n    }\n    loadCmmnDiagram() {\n        this.$loadingText.show();\n        return AttachmentManager.loadAttachment(this.cmmnDiagramName + ".cmmn", this.pageId)\n            .then((attachment) => {\n            this.displayVersion(attachment.version || 0);\n            this.openCmmnDiagram(attachment.data);\n        })\n            .catch((error) => {\n            this.openCmmnDiagram(newCmmnDiagramXml.getNewCmmnDiagramXml());\n            this.displayViewer();\n        });\n    }\n    openCmmnDiagram(xml) {\n        this.viewer.importXML(xml, (err, warnings) => {\n            this.$loadingText.hide();\n            if (err) {\n                this.vxcpLogger.logError("openCmmnDiagram", "An error occurred while opening the CMMN diagram. The CMMN file, which you try to open is probably broken or has no valid CMMN 1.1 format.", err);\n                return;\n            }\n            else if (warnings.length) {\n                this.vxcpLogger.logWarning("openCmmnDiagram", "An error occurred while opening the CMMN diagram. The CMMN file, which you tried to open has no valid CMMN 1.1 format.", warnings);\n            }\n            const vccpCanvas = this.viewer.get("canvas");\n            vccpCanvas.resized();\n            vccpCanvas.zoom("fit-viewport");\n        });\n    }\n    initCmmnViewer() {\n        try {\n            const cmmnViewer = new cmmn_js_1.default({\n                container: this.$canvas,\n            });\n            return cmmnViewer;\n        }\n        catch (e) {\n            this.vxcpLogger.logError("initCmmnViewer", "Error occurred while trying to initialize the CMMN viewer.", e);\n            return;\n        }\n    }\n    initCmmnFullscreenViewer() {\n        return new NavigatedViewer_1.default({\n            container: this.$canvas,\n            additionalModules: [diagram_js_origin_1.default],\n        });\n    }\n}\nexports.CmmnViewerApp = CmmnViewerApp;\n\n\n//# sourceURL=webpack://VCCPFREE/./viewer/cmmnViewerApp.ts?')},"./node_modules/diagram-js-origin/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"default\": () => (/* binding */ diagram_js_origin)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js-origin/node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js-origin/node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/lib/configure-origin.js\n\n\nvar CROSS_COLOR = '#CCC',\n    BORDER_COLOR = 'rgba(0,0,0,0.1)';\n\n\n/**\n * A diagram-js extension that shows a (0, 0) origin indicator\n * on the canvas as well as (optionally) the canvas borders.\n *\n * @param {Object} [config]\n * @param {Canvas} canvas\n */\nfunction ConfigureOrigin(config, canvas) {\n\n  config = config || {};\n\n  var borderColor = config.borderColor || BORDER_COLOR,\n      crossColor = config.crossColor || CROSS_COLOR ;\n\n  var w = 30, h = 2,\n      w_half = w / 2,\n      s = -h / 2,\n      lineStart = w_half + 7;\n\n  var parent = canvas.getLayer('djs-origin', -1);\n\n  var g,\n      line,\n      cross,\n      label;\n\n  g = createEl('g', {\n    'pointer-events': 'none'\n  });\n\n  (0,index_esm/* append */.R3)(parent, g);\n\n  if (config.showBorder !== false) {\n\n    // the dashed lines, marking positive document coordinates\n    line = createEl('path', {\n      'class': cls('border'),\n      'd': path([\n        'M', -lineStart, s,\n        'H', -1000,\n        'M', lineStart, s,\n        'H', 6000,\n        'M', s, -lineStart,\n        'V', -1000,\n        'M', s, lineStart,\n        'V', 3000\n      ]),\n      'fill': 'none',\n      'stroke': borderColor,\n      'stroke-width': h + 'px',\n      'stroke-dasharray': '6, 6',\n      'shape-rendering': 'crispedges'\n    });\n\n    (0,index_esm/* append */.R3)(g, line);\n  }\n\n  // the cross that marks the diagram origin\n  cross = createEl('path', {\n    d: path([\n      'M', -w_half, s,\n      'H', w_half,\n      'M', s, -w_half,\n      'V', w_half\n    ]),\n    'class': cls('cross'),\n    'fill': 'none',\n    'stroke': crossColor,\n    'stroke-width': h + 'px',\n    'stroke-linecap': 'round'\n  });\n\n  (0,index_esm/* append */.R3)(g, cross);\n\n  label = createEl('text', {\n    x: -40,\n    y: -10,\n    fill: crossColor,\n    'class': cls('label'),\n  });\n\n  label.textContent = '(0, 0)';\n\n  (0,index_esm/* append */.R3)(g, label);\n}\n\nConfigureOrigin.$inject = [\n  'config.origin',\n  'canvas'\n];\n\n\n// helpers ///////////////////////////////////\n\nfunction path(parts) {\n  return parts.join(' ');\n}\n\nfunction cls(name) {\n  return 'djs-origin-' + name;\n}\n\nfunction createEl(type, attrs) {\n\n  var el = (0,index_esm/* create */.Ue)(type);\n\n  (0,index_esm/* attr */.Lj)(el, attrs);\n\n  return el;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/index.js\n\n\n/* harmony default export */ const diagram_js_origin = ({\n  __init__: [\n    ConfigureOrigin\n  ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/diagram-js-origin/index.js_+_1_modules?")}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(t.exports,t,t.exports,__webpack_require__),t.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,t,r)=>{if(!n){var a=1/0;for(c=0;c<deferred.length;c++){for(var[n,t,r]=deferred[c],o=!0,i=0;i<n.length;i++)(!1&r||a>=r)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[i])))?n.splice(i--,1):(o=!1,r<a&&(a=r));if(o){deferred.splice(c--,1);var s=t();void 0!==s&&(e=s)}}return e}r=r||0;for(var c=deferred.length;c>0&&deferred[c-1][2]>r;c--)deferred[c]=deferred[c-1];deferred[c]=[n,t,r]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.j="cmmnFreeViewer",(()=>{var e={cmmnFreeViewer:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,t)=>{var r,a,[o,i,s]=t,c=0;if(o.some((n=>0!==e[n]))){for(r in i)__webpack_require__.o(i,r)&&(__webpack_require__.m[r]=i[r]);if(s)var m=s(__webpack_require__)}for(n&&n(t);c<o.length;c++)a=o[c],__webpack_require__.o(e,a)&&e[a]&&e[a][0](),e[a]=0;return __webpack_require__.O(m)},t=self.webpackChunkVCCPFREE=self.webpackChunkVCCPFREE||[];t.forEach(n.bind(null,0)),t.push=n.bind(null,t.push.bind(t))})();var __webpack_exports__=__webpack_require__.O(void 0,["cmmnFreeCmmnJs","cmmnFreeVendors"],(()=>__webpack_require__("./viewer/cmmnViewerApp.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VCCPFREE=window.VCCPFREE||{}).cmmnFreeViewer=__webpack_exports__})();