(self.webpackChunkVCCPFREE=self.webpackChunkVCCPFREE||[]).push([["cmmnFreeVendors"],{"./node_modules/cmmn-moddle/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "Z": () => (/* reexport */ simple)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__("./node_modules/min-dash/dist/index.esm.js");\n;// CONCATENATED MODULE: ./node_modules/moddle/lib/base.js\n/**\n * Moddle base element.\n */\nfunction Base() { }\n\nBase.prototype.get = function(name) {\n  return this.$model.properties.get(this, name);\n};\n\nBase.prototype.set = function(name, value) {\n  this.$model.properties.set(this, name, value);\n};\n;// CONCATENATED MODULE: ./node_modules/moddle/lib/factory.js\n\n\n\n\n/**\n * A model element factory.\n *\n * @param {Moddle} model\n * @param {Properties} properties\n */\nfunction Factory(model, properties) {\n  this.model = model;\n  this.properties = properties;\n}\n\n\nFactory.prototype.createType = function(descriptor) {\n\n  var model = this.model;\n\n  var props = this.properties,\n      prototype = Object.create(Base.prototype);\n\n  // initialize default values\n  (0,index_esm/* forEach */.Ed)(descriptor.properties, function(p) {\n    if (!p.isMany && p.default !== undefined) {\n      prototype[p.name] = p.default;\n    }\n  });\n\n  props.defineModel(prototype, model);\n  props.defineDescriptor(prototype, descriptor);\n\n  var name = descriptor.ns.name;\n\n  /**\n   * The new type constructor\n   */\n  function ModdleElement(attrs) {\n    props.define(this, \'$type\', { value: name, enumerable: true });\n    props.define(this, \'$attrs\', { value: {} });\n    props.define(this, \'$parent\', { writable: true });\n\n    (0,index_esm/* forEach */.Ed)(attrs, (0,index_esm/* bind */.ak)(function(val, key) {\n      this.set(key, val);\n    }, this));\n  }\n\n  ModdleElement.prototype = prototype;\n\n  ModdleElement.hasType = prototype.$instanceOf = this.model.hasType;\n\n  // static links\n  props.defineModel(ModdleElement, model);\n  props.defineDescriptor(ModdleElement, descriptor);\n\n  return ModdleElement;\n};\n;// CONCATENATED MODULE: ./node_modules/moddle/lib/types.js\n/**\n * Built-in moddle types\n */\nvar BUILTINS = {\n  String: true,\n  Boolean: true,\n  Integer: true,\n  Real: true,\n  Element: true\n};\n\n/**\n * Converters for built in types from string representations\n */\nvar TYPE_CONVERTERS = {\n  String: function(s) { return s; },\n  Boolean: function(s) { return s === \'true\'; },\n  Integer: function(s) { return parseInt(s, 10); },\n  Real: function(s) { return parseFloat(s, 10); }\n};\n\n/**\n * Convert a type to its real representation\n */\nfunction coerceType(type, value) {\n\n  var converter = TYPE_CONVERTERS[type];\n\n  if (converter) {\n    return converter(value);\n  } else {\n    return value;\n  }\n}\n\n/**\n * Return whether the given type is built-in\n */\nfunction isBuiltIn(type) {\n  return !!BUILTINS[type];\n}\n\n/**\n * Return whether the given type is simple\n */\nfunction isSimple(type) {\n  return !!TYPE_CONVERTERS[type];\n}\n;// CONCATENATED MODULE: ./node_modules/moddle/lib/ns.js\n/**\n * Parses a namespaced attribute name of the form (ns:)localName to an object,\n * given a default prefix to assume in case no explicit namespace is given.\n *\n * @param {String} name\n * @param {String} [defaultPrefix] the default prefix to take, if none is present.\n *\n * @return {Object} the parsed name\n */\nfunction parseName(name, defaultPrefix) {\n  var parts = name.split(/:/),\n      localName, prefix;\n\n  // no prefix (i.e. only local name)\n  if (parts.length === 1) {\n    localName = name;\n    prefix = defaultPrefix;\n  } else\n  // prefix + local name\n  if (parts.length === 2) {\n    localName = parts[1];\n    prefix = parts[0];\n  } else {\n    throw new Error(\'expected <prefix:localName> or <localName>, got \' + name);\n  }\n\n  name = (prefix ? prefix + \':\' : \'\') + localName;\n\n  return {\n    name: name,\n    prefix: prefix,\n    localName: localName\n  };\n}\n;// CONCATENATED MODULE: ./node_modules/moddle/lib/descriptor-builder.js\n\n\n\n\n\n/**\n * A utility to build element descriptors.\n */\nfunction DescriptorBuilder(nameNs) {\n  this.ns = nameNs;\n  this.name = nameNs.name;\n  this.allTypes = [];\n  this.allTypesByName = {};\n  this.properties = [];\n  this.propertiesByName = {};\n}\n\n\nDescriptorBuilder.prototype.build = function() {\n  return (0,index_esm/* pick */.ei)(this, [\n    \'ns\',\n    \'name\',\n    \'allTypes\',\n    \'allTypesByName\',\n    \'properties\',\n    \'propertiesByName\',\n    \'bodyProperty\',\n    \'idProperty\'\n  ]);\n};\n\n/**\n * Add property at given index.\n *\n * @param {Object} p\n * @param {Number} [idx]\n * @param {Boolean} [validate=true]\n */\nDescriptorBuilder.prototype.addProperty = function(p, idx, validate) {\n\n  if (typeof idx === \'boolean\') {\n    validate = idx;\n    idx = undefined;\n  }\n\n  this.addNamedProperty(p, validate !== false);\n\n  var properties = this.properties;\n\n  if (idx !== undefined) {\n    properties.splice(idx, 0, p);\n  } else {\n    properties.push(p);\n  }\n};\n\n\nDescriptorBuilder.prototype.replaceProperty = function(oldProperty, newProperty, replace) {\n  var oldNameNs = oldProperty.ns;\n\n  var props = this.properties,\n      propertiesByName = this.propertiesByName,\n      rename = oldProperty.name !== newProperty.name;\n\n  if (oldProperty.isId) {\n    if (!newProperty.isId) {\n      throw new Error(\n        \'property <\' + newProperty.ns.name + \'> must be id property \' +\n        \'to refine <\' + oldProperty.ns.name + \'>\');\n    }\n\n    this.setIdProperty(newProperty, false);\n  }\n\n  if (oldProperty.isBody) {\n\n    if (!newProperty.isBody) {\n      throw new Error(\n        \'property <\' + newProperty.ns.name + \'> must be body property \' +\n        \'to refine <\' + oldProperty.ns.name + \'>\');\n    }\n\n    // TODO: Check compatibility\n    this.setBodyProperty(newProperty, false);\n  }\n\n  // validate existence and get location of old property\n  var idx = props.indexOf(oldProperty);\n  if (idx === -1) {\n    throw new Error(\'property <\' + oldNameNs.name + \'> not found in property list\');\n  }\n\n  // remove old property\n  props.splice(idx, 1);\n\n  // replacing the named property is intentional\n  //\n  //  * validate only if this is a "rename" operation\n  //  * add at specific index unless we "replace"\n  //\n  this.addProperty(newProperty, replace ? undefined : idx, rename);\n\n  // make new property available under old name\n  propertiesByName[oldNameNs.name] = propertiesByName[oldNameNs.localName] = newProperty;\n};\n\n\nDescriptorBuilder.prototype.redefineProperty = function(p, targetPropertyName, replace) {\n\n  var nsPrefix = p.ns.prefix;\n  var parts = targetPropertyName.split(\'#\');\n\n  var name = parseName(parts[0], nsPrefix);\n  var attrName = parseName(parts[1], name.prefix).name;\n\n  var redefinedProperty = this.propertiesByName[attrName];\n  if (!redefinedProperty) {\n    throw new Error(\'refined property <\' + attrName + \'> not found\');\n  } else {\n    this.replaceProperty(redefinedProperty, p, replace);\n  }\n\n  delete p.redefines;\n};\n\nDescriptorBuilder.prototype.addNamedProperty = function(p, validate) {\n  var ns = p.ns,\n      propsByName = this.propertiesByName;\n\n  if (validate) {\n    this.assertNotDefined(p, ns.name);\n    this.assertNotDefined(p, ns.localName);\n  }\n\n  propsByName[ns.name] = propsByName[ns.localName] = p;\n};\n\nDescriptorBuilder.prototype.removeNamedProperty = function(p) {\n  var ns = p.ns,\n      propsByName = this.propertiesByName;\n\n  delete propsByName[ns.name];\n  delete propsByName[ns.localName];\n};\n\nDescriptorBuilder.prototype.setBodyProperty = function(p, validate) {\n\n  if (validate && this.bodyProperty) {\n    throw new Error(\n      \'body property defined multiple times \' +\n      \'(<\' + this.bodyProperty.ns.name + \'>, <\' + p.ns.name + \'>)\');\n  }\n\n  this.bodyProperty = p;\n};\n\nDescriptorBuilder.prototype.setIdProperty = function(p, validate) {\n\n  if (validate && this.idProperty) {\n    throw new Error(\n      \'id property defined multiple times \' +\n      \'(<\' + this.idProperty.ns.name + \'>, <\' + p.ns.name + \'>)\');\n  }\n\n  this.idProperty = p;\n};\n\nDescriptorBuilder.prototype.assertNotDefined = function(p, name) {\n  var propertyName = p.name,\n      definedProperty = this.propertiesByName[propertyName];\n\n  if (definedProperty) {\n    throw new Error(\n      \'property <\' + propertyName + \'> already defined; \' +\n      \'override of <\' + definedProperty.definedBy.ns.name + \'#\' + definedProperty.ns.name + \'> by \' +\n      \'<\' + p.definedBy.ns.name + \'#\' + p.ns.name + \'> not allowed without redefines\');\n  }\n};\n\nDescriptorBuilder.prototype.hasProperty = function(name) {\n  return this.propertiesByName[name];\n};\n\nDescriptorBuilder.prototype.addTrait = function(t, inherited) {\n\n  var typesByName = this.allTypesByName,\n      types = this.allTypes;\n\n  var typeName = t.name;\n\n  if (typeName in typesByName) {\n    return;\n  }\n\n  (0,index_esm/* forEach */.Ed)(t.properties, (0,index_esm/* bind */.ak)(function(p) {\n\n    // clone property to allow extensions\n    p = (0,index_esm/* assign */.f0)({}, p, {\n      name: p.ns.localName,\n      inherited: inherited\n    });\n\n    Object.defineProperty(p, \'definedBy\', {\n      value: t\n    });\n\n    var replaces = p.replaces,\n        redefines = p.redefines;\n\n    // add replace/redefine support\n    if (replaces || redefines) {\n      this.redefineProperty(p, replaces || redefines, replaces);\n    } else {\n      if (p.isBody) {\n        this.setBodyProperty(p);\n      }\n      if (p.isId) {\n        this.setIdProperty(p);\n      }\n      this.addProperty(p);\n    }\n  }, this));\n\n  types.push(t);\n  typesByName[typeName] = t;\n};\n;// CONCATENATED MODULE: ./node_modules/moddle/lib/registry.js\n\n\n\n\n\n\n\n\n\n/**\n * A registry of Moddle packages.\n *\n * @param {Array<Package>} packages\n * @param {Properties} properties\n */\nfunction Registry(packages, properties) {\n  this.packageMap = {};\n  this.typeMap = {};\n\n  this.packages = [];\n\n  this.properties = properties;\n\n  (0,index_esm/* forEach */.Ed)(packages, (0,index_esm/* bind */.ak)(this.registerPackage, this));\n}\n\n\nRegistry.prototype.getPackage = function(uriOrPrefix) {\n  return this.packageMap[uriOrPrefix];\n};\n\nRegistry.prototype.getPackages = function() {\n  return this.packages;\n};\n\n\nRegistry.prototype.registerPackage = function(pkg) {\n\n  // copy package\n  pkg = (0,index_esm/* assign */.f0)({}, pkg);\n\n  var pkgMap = this.packageMap;\n\n  ensureAvailable(pkgMap, pkg, \'prefix\');\n  ensureAvailable(pkgMap, pkg, \'uri\');\n\n  // register types\n  (0,index_esm/* forEach */.Ed)(pkg.types, (0,index_esm/* bind */.ak)(function(descriptor) {\n    this.registerType(descriptor, pkg);\n  }, this));\n\n  pkgMap[pkg.uri] = pkgMap[pkg.prefix] = pkg;\n  this.packages.push(pkg);\n};\n\n\n/**\n * Register a type from a specific package with us\n */\nRegistry.prototype.registerType = function(type, pkg) {\n\n  type = (0,index_esm/* assign */.f0)({}, type, {\n    superClass: (type.superClass || []).slice(),\n    extends: (type.extends || []).slice(),\n    properties: (type.properties || []).slice(),\n    meta: (0,index_esm/* assign */.f0)(({}, type.meta || {}))\n  });\n\n  var ns = parseName(type.name, pkg.prefix),\n      name = ns.name,\n      propertiesByName = {};\n\n  // parse properties\n  (0,index_esm/* forEach */.Ed)(type.properties, (0,index_esm/* bind */.ak)(function(p) {\n\n    // namespace property names\n    var propertyNs = parseName(p.name, ns.prefix),\n        propertyName = propertyNs.name;\n\n    // namespace property types\n    if (!isBuiltIn(p.type)) {\n      p.type = parseName(p.type, propertyNs.prefix).name;\n    }\n\n    (0,index_esm/* assign */.f0)(p, {\n      ns: propertyNs,\n      name: propertyName\n    });\n\n    propertiesByName[propertyName] = p;\n  }, this));\n\n  // update ns + name\n  (0,index_esm/* assign */.f0)(type, {\n    ns: ns,\n    name: name,\n    propertiesByName: propertiesByName\n  });\n\n  (0,index_esm/* forEach */.Ed)(type.extends, (0,index_esm/* bind */.ak)(function(extendsName) {\n    var extended = this.typeMap[extendsName];\n\n    extended.traits = extended.traits || [];\n    extended.traits.push(name);\n  }, this));\n\n  // link to package\n  this.definePackage(type, pkg);\n\n  // register\n  this.typeMap[name] = type;\n};\n\n\n/**\n * Traverse the type hierarchy from bottom to top,\n * calling iterator with (type, inherited) for all elements in\n * the inheritance chain.\n *\n * @param {Object} nsName\n * @param {Function} iterator\n * @param {Boolean} [trait=false]\n */\nRegistry.prototype.mapTypes = function(nsName, iterator, trait) {\n\n  var type = isBuiltIn(nsName.name) ? { name: nsName.name } : this.typeMap[nsName.name];\n\n  var self = this;\n\n  /**\n   * Traverse the selected trait.\n   *\n   * @param {String} cls\n   */\n  function traverseTrait(cls) {\n    return traverseSuper(cls, true);\n  }\n\n  /**\n   * Traverse the selected super type or trait\n   *\n   * @param {String} cls\n   * @param {Boolean} [trait=false]\n   */\n  function traverseSuper(cls, trait) {\n    var parentNs = parseName(cls, isBuiltIn(cls) ? \'\' : nsName.prefix);\n    self.mapTypes(parentNs, iterator, trait);\n  }\n\n  if (!type) {\n    throw new Error(\'unknown type <\' + nsName.name + \'>\');\n  }\n\n  (0,index_esm/* forEach */.Ed)(type.superClass, trait ? traverseTrait : traverseSuper);\n\n  // call iterator with (type, inherited=!trait)\n  iterator(type, !trait);\n\n  (0,index_esm/* forEach */.Ed)(type.traits, traverseTrait);\n};\n\n\n/**\n * Returns the effective descriptor for a type.\n *\n * @param  {String} type the namespaced name (ns:localName) of the type\n *\n * @return {Descriptor} the resulting effective descriptor\n */\nRegistry.prototype.getEffectiveDescriptor = function(name) {\n\n  var nsName = parseName(name);\n\n  var builder = new DescriptorBuilder(nsName);\n\n  this.mapTypes(nsName, function(type, inherited) {\n    builder.addTrait(type, inherited);\n  });\n\n  var descriptor = builder.build();\n\n  // define package link\n  this.definePackage(descriptor, descriptor.allTypes[descriptor.allTypes.length - 1].$pkg);\n\n  return descriptor;\n};\n\n\nRegistry.prototype.definePackage = function(target, pkg) {\n  this.properties.define(target, \'$pkg\', { value: pkg });\n};\n\n\n\n///////// helpers ////////////////////////////\n\nfunction ensureAvailable(packageMap, pkg, identifierKey) {\n\n  var value = pkg[identifierKey];\n\n  if (value in packageMap) {\n    throw new Error(\'package with \' + identifierKey + \' <\' + value + \'> already defined\');\n  }\n}\n\n;// CONCATENATED MODULE: ./node_modules/moddle/lib/properties.js\n/**\n * A utility that gets and sets properties of model elements.\n *\n * @param {Model} model\n */\nfunction Properties(model) {\n  this.model = model;\n}\n\n\n/**\n * Sets a named property on the target element.\n * If the value is undefined, the property gets deleted.\n *\n * @param {Object} target\n * @param {String} name\n * @param {Object} value\n */\nProperties.prototype.set = function(target, name, value) {\n\n  var property = this.model.getPropertyDescriptor(target, name);\n\n  var propertyName = property && property.name;\n\n  if (isUndefined(value)) {\n    // unset the property, if the specified value is undefined;\n    // delete from $attrs (for extensions) or the target itself\n    if (property) {\n      delete target[propertyName];\n    } else {\n      delete target.$attrs[name];\n    }\n  } else {\n    // set the property, defining well defined properties on the fly\n    // or simply updating them in target.$attrs (for extensions)\n    if (property) {\n      if (propertyName in target) {\n        target[propertyName] = value;\n      } else {\n        defineProperty(target, property, value);\n      }\n    } else {\n      target.$attrs[name] = value;\n    }\n  }\n};\n\n/**\n * Returns the named property of the given element\n *\n * @param  {Object} target\n * @param  {String} name\n *\n * @return {Object}\n */\nProperties.prototype.get = function(target, name) {\n\n  var property = this.model.getPropertyDescriptor(target, name);\n\n  if (!property) {\n    return target.$attrs[name];\n  }\n\n  var propertyName = property.name;\n\n  // check if access to collection property and lazily initialize it\n  if (!target[propertyName] && property.isMany) {\n    defineProperty(target, property, []);\n  }\n\n  return target[propertyName];\n};\n\n\n/**\n * Define a property on the target element\n *\n * @param  {Object} target\n * @param  {String} name\n * @param  {Object} options\n */\nProperties.prototype.define = function(target, name, options) {\n  Object.defineProperty(target, name, options);\n};\n\n\n/**\n * Define the descriptor for an element\n */\nProperties.prototype.defineDescriptor = function(target, descriptor) {\n  this.define(target, \'$descriptor\', { value: descriptor });\n};\n\n/**\n * Define the model for an element\n */\nProperties.prototype.defineModel = function(target, model) {\n  this.define(target, \'$model\', { value: model });\n};\n\n\nfunction isUndefined(val) {\n  return typeof val === \'undefined\';\n}\n\nfunction defineProperty(target, property, value) {\n  Object.defineProperty(target, property.name, {\n    enumerable: !property.isReference,\n    writable: true,\n    value: value,\n    configurable: true\n  });\n}\n;// CONCATENATED MODULE: ./node_modules/moddle/lib/moddle.js\n\n\n\n\n\n\n\n\n\n//// Moddle implementation /////////////////////////////////////////////////\n\n/**\n * @class Moddle\n *\n * A model that can be used to create elements of a specific type.\n *\n * @example\n *\n * var Moddle = require(\'moddle\');\n *\n * var pkg = {\n *   name: \'mypackage\',\n *   prefix: \'my\',\n *   types: [\n *     { name: \'Root\' }\n *   ]\n * };\n *\n * var moddle = new Moddle([pkg]);\n *\n * @param {Array<Package>} packages the packages to contain\n */\nfunction Moddle(packages) {\n\n  this.properties = new Properties(this);\n\n  this.factory = new Factory(this, this.properties);\n  this.registry = new Registry(packages, this.properties);\n\n  this.typeCache = {};\n}\n\n\n/**\n * Create an instance of the specified type.\n *\n * @method Moddle#create\n *\n * @example\n *\n * var foo = moddle.create(\'my:Foo\');\n * var bar = moddle.create(\'my:Bar\', { id: \'BAR_1\' });\n *\n * @param  {String|Object} descriptor the type descriptor or name know to the model\n * @param  {Object} attrs   a number of attributes to initialize the model instance with\n * @return {Object}         model instance\n */\nModdle.prototype.create = function(descriptor, attrs) {\n  var Type = this.getType(descriptor);\n\n  if (!Type) {\n    throw new Error(\'unknown type <\' + descriptor + \'>\');\n  }\n\n  return new Type(attrs);\n};\n\n\n/**\n * Returns the type representing a given descriptor\n *\n * @method Moddle#getType\n *\n * @example\n *\n * var Foo = moddle.getType(\'my:Foo\');\n * var foo = new Foo({ \'id\' : \'FOO_1\' });\n *\n * @param  {String|Object} descriptor the type descriptor or name know to the model\n * @return {Object}         the type representing the descriptor\n */\nModdle.prototype.getType = function(descriptor) {\n\n  var cache = this.typeCache;\n\n  var name = (0,index_esm/* isString */.HD)(descriptor) ? descriptor : descriptor.ns.name;\n\n  var type = cache[name];\n\n  if (!type) {\n    descriptor = this.registry.getEffectiveDescriptor(name);\n    type = cache[name] = this.factory.createType(descriptor);\n  }\n\n  return type;\n};\n\n\n/**\n * Creates an any-element type to be used within model instances.\n *\n * This can be used to create custom elements that lie outside the meta-model.\n * The created element contains all the meta-data required to serialize it\n * as part of meta-model elements.\n *\n * @method Moddle#createAny\n *\n * @example\n *\n * var foo = moddle.createAny(\'vendor:Foo\', \'http://vendor\', {\n *   value: \'bar\'\n * });\n *\n * var container = moddle.create(\'my:Container\', \'http://my\', {\n *   any: [ foo ]\n * });\n *\n * // go ahead and serialize the stuff\n *\n *\n * @param  {String} name  the name of the element\n * @param  {String} nsUri the namespace uri of the element\n * @param  {Object} [properties] a map of properties to initialize the instance with\n * @return {Object} the any type instance\n */\nModdle.prototype.createAny = function(name, nsUri, properties) {\n\n  var nameNs = parseName(name);\n\n  var element = {\n    $type: name,\n    $instanceOf: function(type) {\n      return type === this.$type;\n    }\n  };\n\n  var descriptor = {\n    name: name,\n    isGeneric: true,\n    ns: {\n      prefix: nameNs.prefix,\n      localName: nameNs.localName,\n      uri: nsUri\n    }\n  };\n\n  this.properties.defineDescriptor(element, descriptor);\n  this.properties.defineModel(element, this);\n  this.properties.define(element, \'$parent\', { enumerable: false, writable: true });\n\n  (0,index_esm/* forEach */.Ed)(properties, function(a, key) {\n    if ((0,index_esm/* isObject */.Kn)(a) && a.value !== undefined) {\n      element[a.name] = a.value;\n    } else {\n      element[key] = a;\n    }\n  });\n\n  return element;\n};\n\n/**\n * Returns a registered package by uri or prefix\n *\n * @return {Object} the package\n */\nModdle.prototype.getPackage = function(uriOrPrefix) {\n  return this.registry.getPackage(uriOrPrefix);\n};\n\n/**\n * Returns a snapshot of all known packages\n *\n * @return {Object} the package\n */\nModdle.prototype.getPackages = function() {\n  return this.registry.getPackages();\n};\n\n/**\n * Returns the descriptor for an element\n */\nModdle.prototype.getElementDescriptor = function(element) {\n  return element.$descriptor;\n};\n\n/**\n * Returns true if the given descriptor or instance\n * represents the given type.\n *\n * May be applied to this, if element is omitted.\n */\nModdle.prototype.hasType = function(element, type) {\n  if (type === undefined) {\n    type = element;\n    element = this;\n  }\n\n  var descriptor = element.$model.getElementDescriptor(element);\n\n  return (type in descriptor.allTypesByName);\n};\n\n/**\n * Returns the descriptor of an elements named property\n */\nModdle.prototype.getPropertyDescriptor = function(element, property) {\n  return this.getElementDescriptor(element).propertiesByName[property];\n};\n\n/**\n * Returns a mapped type\'s descriptor\n */\nModdle.prototype.getTypeDescriptor = function(type) {\n  return this.registry.typeMap[type];\n};\n;// CONCATENATED MODULE: ./node_modules/saxen/dist/index.esm.js\nvar fromCharCode = String.fromCharCode;\n\nvar index_esm_hasOwnProperty = Object.prototype.hasOwnProperty;\n\nvar ENTITY_PATTERN = /&#(\\d+);|&#x([0-9a-f]+);|&(\\w+);/ig;\n\nvar ENTITY_MAPPING = {\n  \'amp\': \'&\',\n  \'apos\': \'\\\'\',\n  \'gt\': \'>\',\n  \'lt\': \'<\',\n  \'quot\': \'"\'\n};\n\n// map UPPERCASE variants of supported special chars\nObject.keys(ENTITY_MAPPING).forEach(function(k) {\n  ENTITY_MAPPING[k.toUpperCase()] = ENTITY_MAPPING[k];\n});\n\n\nfunction replaceEntities(_, d, x, z) {\n\n  // reserved names, i.e. &nbsp;\n  if (z) {\n    if (index_esm_hasOwnProperty.call(ENTITY_MAPPING, z)) {\n      return ENTITY_MAPPING[z];\n    } else {\n\n      // fall back to original value\n      return \'&\' + z + \';\';\n    }\n  }\n\n  // decimal encoded char\n  if (d) {\n    return fromCharCode(d);\n  }\n\n  // hex encoded char\n  return fromCharCode(parseInt(x, 16));\n}\n\n\n/**\n * A basic entity decoder that can decode a minimal\n * sub-set of reserved names (&amp;) as well as\n * hex (&#xaaf;) and decimal (&#1231;) encoded characters.\n *\n * @param {string} str\n *\n * @return {string} decoded string\n */\nfunction decodeEntities(s) {\n  if (s.length > 3 && s.indexOf(\'&\') !== -1) {\n    return s.replace(ENTITY_PATTERN, replaceEntities);\n  }\n\n  return s;\n}\n\nvar XSI_URI = \'http://www.w3.org/2001/XMLSchema-instance\';\nvar XSI_PREFIX = \'xsi\';\nvar XSI_TYPE = \'xsi:type\';\n\nvar NON_WHITESPACE_OUTSIDE_ROOT_NODE = \'non-whitespace outside of root node\';\n\nfunction error(msg) {\n  return new Error(msg);\n}\n\nfunction missingNamespaceForPrefix(prefix) {\n  return \'missing namespace for prefix <\' + prefix + \'>\';\n}\n\nfunction getter(getFn) {\n  return {\n    \'get\': getFn,\n    \'enumerable\': true\n  };\n}\n\nfunction cloneNsMatrix(nsMatrix) {\n  var clone = {}, key;\n  for (key in nsMatrix) {\n    clone[key] = nsMatrix[key];\n  }\n  return clone;\n}\n\nfunction uriPrefix(prefix) {\n  return prefix + \'$uri\';\n}\n\nfunction buildNsMatrix(nsUriToPrefix) {\n  var nsMatrix = {},\n      uri,\n      prefix;\n\n  for (uri in nsUriToPrefix) {\n    prefix = nsUriToPrefix[uri];\n    nsMatrix[prefix] = prefix;\n    nsMatrix[uriPrefix(prefix)] = uri;\n  }\n\n  return nsMatrix;\n}\n\nfunction noopGetContext() {\n  return { \'line\': 0, \'column\': 0 };\n}\n\nfunction throwFunc(err) {\n  throw err;\n}\n\n/**\n * Creates a new parser with the given options.\n *\n * @constructor\n *\n * @param  {!Object<string, ?>=} options\n */\nfunction Parser(options) {\n\n  if (!this) {\n    return new Parser(options);\n  }\n\n  var proxy = options && options[\'proxy\'];\n\n  var onText,\n      onOpenTag,\n      onCloseTag,\n      onCDATA,\n      onError = throwFunc,\n      onWarning,\n      onComment,\n      onQuestion,\n      onAttention;\n\n  var getContext = noopGetContext;\n\n  /**\n   * Do we need to parse the current elements attributes for namespaces?\n   *\n   * @type {boolean}\n   */\n  var maybeNS = false;\n\n  /**\n   * Do we process namespaces at all?\n   *\n   * @type {boolean}\n   */\n  var isNamespace = false;\n\n  /**\n   * The caught error returned on parse end\n   *\n   * @type {Error}\n   */\n  var returnError = null;\n\n  /**\n   * Should we stop parsing?\n   *\n   * @type {boolean}\n   */\n  var parseStop = false;\n\n  /**\n   * A map of { uri: prefix } used by the parser.\n   *\n   * This map will ensure we can normalize prefixes during processing;\n   * for each uri, only one prefix will be exposed to the handlers.\n   *\n   * @type {!Object<string, string>}}\n   */\n  var nsUriToPrefix;\n\n  /**\n   * Handle parse error.\n   *\n   * @param  {string|Error} err\n   */\n  function handleError(err) {\n    if (!(err instanceof Error)) {\n      err = error(err);\n    }\n\n    returnError = err;\n\n    onError(err, getContext);\n  }\n\n  /**\n   * Handle parse error.\n   *\n   * @param  {string|Error} err\n   */\n  function handleWarning(err) {\n\n    if (!onWarning) {\n      return;\n    }\n\n    if (!(err instanceof Error)) {\n      err = error(err);\n    }\n\n    onWarning(err, getContext);\n  }\n\n  /**\n   * Register parse listener.\n   *\n   * @param  {string}   name\n   * @param  {Function} cb\n   *\n   * @return {Parser}\n   */\n  this[\'on\'] = function(name, cb) {\n\n    if (typeof cb !== \'function\') {\n      throw error(\'required args <name, cb>\');\n    }\n\n    switch (name) {\n    case \'openTag\': onOpenTag = cb; break;\n    case \'text\': onText = cb; break;\n    case \'closeTag\': onCloseTag = cb; break;\n    case \'error\': onError = cb; break;\n    case \'warn\': onWarning = cb; break;\n    case \'cdata\': onCDATA = cb; break;\n    case \'attention\': onAttention = cb; break; // <!XXXXX zzzz="eeee">\n    case \'question\': onQuestion = cb; break; // <? ....  ?>\n    case \'comment\': onComment = cb; break;\n    default:\n      throw error(\'unsupported event: \' + name);\n    }\n\n    return this;\n  };\n\n  /**\n   * Set the namespace to prefix mapping.\n   *\n   * @example\n   *\n   * parser.ns({\n   *   \'http://foo\': \'foo\',\n   *   \'http://bar\': \'bar\'\n   * });\n   *\n   * @param  {!Object<string, string>} nsMap\n   *\n   * @return {Parser}\n   */\n  this[\'ns\'] = function(nsMap) {\n\n    if (typeof nsMap === \'undefined\') {\n      nsMap = {};\n    }\n\n    if (typeof nsMap !== \'object\') {\n      throw error(\'required args <nsMap={}>\');\n    }\n\n    var _nsUriToPrefix = {}, k;\n\n    for (k in nsMap) {\n      _nsUriToPrefix[k] = nsMap[k];\n    }\n\n    // FORCE default mapping for schema instance\n    _nsUriToPrefix[XSI_URI] = XSI_PREFIX;\n\n    isNamespace = true;\n    nsUriToPrefix = _nsUriToPrefix;\n\n    return this;\n  };\n\n  /**\n   * Parse xml string.\n   *\n   * @param  {string} xml\n   *\n   * @return {Error} returnError, if not thrown\n   */\n  this[\'parse\'] = function(xml) {\n    if (typeof xml !== \'string\') {\n      throw error(\'required args <xml=string>\');\n    }\n\n    returnError = null;\n\n    parse(xml);\n\n    getContext = noopGetContext;\n    parseStop = false;\n\n    return returnError;\n  };\n\n  /**\n   * Stop parsing.\n   */\n  this[\'stop\'] = function() {\n    parseStop = true;\n  };\n\n  /**\n   * Parse string, invoking configured listeners on element.\n   *\n   * @param  {string} xml\n   */\n  function parse(xml) {\n    var nsMatrixStack = isNamespace ? [] : null,\n        nsMatrix = isNamespace ? buildNsMatrix(nsUriToPrefix) : null,\n        _nsMatrix,\n        nodeStack = [],\n        anonymousNsCount = 0,\n        tagStart = false,\n        tagEnd = false,\n        i = 0, j = 0,\n        x, y, q, w, v,\n        xmlns,\n        elementName,\n        _elementName,\n        elementProxy\n        ;\n\n    var attrsString = \'\',\n        attrsStart = 0,\n        cachedAttrs // false = parsed with errors, null = needs parsing\n        ;\n\n    /**\n     * Parse attributes on demand and returns the parsed attributes.\n     *\n     * Return semantics: (1) `false` on attribute parse error,\n     * (2) object hash on extracted attrs.\n     *\n     * @return {boolean|Object}\n     */\n    function getAttrs() {\n      if (cachedAttrs !== null) {\n        return cachedAttrs;\n      }\n\n      var nsUri,\n          nsUriPrefix,\n          nsName,\n          defaultAlias = isNamespace && nsMatrix[\'xmlns\'],\n          attrList = isNamespace && maybeNS ? [] : null,\n          i = attrsStart,\n          s = attrsString,\n          l = s.length,\n          hasNewMatrix,\n          newalias,\n          value,\n          alias,\n          name,\n          attrs = {},\n          seenAttrs = {},\n          skipAttr,\n          w,\n          j;\n\n      parseAttr:\n      for (; i < l; i++) {\n        skipAttr = false;\n        w = s.charCodeAt(i);\n\n        if (w === 32 || (w < 14 && w > 8)) { // WHITESPACE={ \\f\\n\\r\\t\\v}\n          continue;\n        }\n\n        // wait for non whitespace character\n        if (w < 65 || w > 122 || (w > 90 && w < 97)) {\n          if (w !== 95 && w !== 58) { // char 95"_" 58":"\n            handleWarning(\'illegal first char attribute name\');\n            skipAttr = true;\n          }\n        }\n\n        // parse attribute name\n        for (j = i + 1; j < l; j++) {\n          w = s.charCodeAt(j);\n\n          if (\n            w > 96 && w < 123 ||\n            w > 64 && w < 91 ||\n            w > 47 && w < 59 ||\n            w === 46 || // \'.\'\n            w === 45 || // \'-\'\n            w === 95 // \'_\'\n          ) {\n            continue;\n          }\n\n          // unexpected whitespace\n          if (w === 32 || (w < 14 && w > 8)) { // WHITESPACE\n            handleWarning(\'missing attribute value\');\n            i = j;\n\n            continue parseAttr;\n          }\n\n          // expected "="\n          if (w === 61) { // "=" == 61\n            break;\n          }\n\n          handleWarning(\'illegal attribute name char\');\n          skipAttr = true;\n        }\n\n        name = s.substring(i, j);\n\n        if (name === \'xmlns:xmlns\') {\n          handleWarning(\'illegal declaration of xmlns\');\n          skipAttr = true;\n        }\n\n        w = s.charCodeAt(j + 1);\n\n        if (w === 34) { // \'"\'\n          j = s.indexOf(\'"\', i = j + 2);\n\n          if (j === -1) {\n            j = s.indexOf(\'\\\'\', i);\n\n            if (j !== -1) {\n              handleWarning(\'attribute value quote missmatch\');\n              skipAttr = true;\n            }\n          }\n\n        } else if (w === 39) { // "\'"\n          j = s.indexOf(\'\\\'\', i = j + 2);\n\n          if (j === -1) {\n            j = s.indexOf(\'"\', i);\n\n            if (j !== -1) {\n              handleWarning(\'attribute value quote missmatch\');\n              skipAttr = true;\n            }\n          }\n\n        } else {\n          handleWarning(\'missing attribute value quotes\');\n          skipAttr = true;\n\n          // skip to next space\n          for (j = j + 1; j < l; j++) {\n            w = s.charCodeAt(j + 1);\n\n            if (w === 32 || (w < 14 && w > 8)) { // WHITESPACE\n              break;\n            }\n          }\n\n        }\n\n        if (j === -1) {\n          handleWarning(\'missing closing quotes\');\n\n          j = l;\n          skipAttr = true;\n        }\n\n        if (!skipAttr) {\n          value = s.substring(i, j);\n        }\n\n        i = j;\n\n        // ensure SPACE follows attribute\n        // skip illegal content otherwise\n        // example a="b"c\n        for (; j + 1 < l; j++) {\n          w = s.charCodeAt(j + 1);\n\n          if (w === 32 || (w < 14 && w > 8)) { // WHITESPACE\n            break;\n          }\n\n          // FIRST ILLEGAL CHAR\n          if (i === j) {\n            handleWarning(\'illegal character after attribute end\');\n            skipAttr = true;\n          }\n        }\n\n        // advance cursor to next attribute\n        i = j + 1;\n\n        if (skipAttr) {\n          continue parseAttr;\n        }\n\n        // check attribute re-declaration\n        if (name in seenAttrs) {\n          handleWarning(\'attribute <\' + name + \'> already defined\');\n          continue;\n        }\n\n        seenAttrs[name] = true;\n\n        if (!isNamespace) {\n          attrs[name] = value;\n          continue;\n        }\n\n        // try to extract namespace information\n        if (maybeNS) {\n          newalias = (\n            name === \'xmlns\'\n              ? \'xmlns\'\n              : (name.charCodeAt(0) === 120 && name.substr(0, 6) === \'xmlns:\')\n                ? name.substr(6)\n                : null\n          );\n\n          // handle xmlns(:alias) assignment\n          if (newalias !== null) {\n            nsUri = decodeEntities(value);\n            nsUriPrefix = uriPrefix(newalias);\n\n            alias = nsUriToPrefix[nsUri];\n\n            if (!alias) {\n\n              // no prefix defined or prefix collision\n              if (\n                (newalias === \'xmlns\') ||\n                (nsUriPrefix in nsMatrix && nsMatrix[nsUriPrefix] !== nsUri)\n              ) {\n\n                // alocate free ns prefix\n                do {\n                  alias = \'ns\' + (anonymousNsCount++);\n                } while (typeof nsMatrix[alias] !== \'undefined\');\n              } else {\n                alias = newalias;\n              }\n\n              nsUriToPrefix[nsUri] = alias;\n            }\n\n            if (nsMatrix[newalias] !== alias) {\n              if (!hasNewMatrix) {\n                nsMatrix = cloneNsMatrix(nsMatrix);\n                hasNewMatrix = true;\n              }\n\n              nsMatrix[newalias] = alias;\n              if (newalias === \'xmlns\') {\n                nsMatrix[uriPrefix(alias)] = nsUri;\n                defaultAlias = alias;\n              }\n\n              nsMatrix[nsUriPrefix] = nsUri;\n            }\n\n            // expose xmlns(:asd)="..." in attributes\n            attrs[name] = value;\n            continue;\n          }\n\n          // collect attributes until all namespace\n          // declarations are processed\n          attrList.push(name, value);\n          continue;\n\n        } /** end if (maybeNs) */\n\n        // handle attributes on element without\n        // namespace declarations\n        w = name.indexOf(\':\');\n        if (w === -1) {\n          attrs[name] = value;\n          continue;\n        }\n\n        // normalize ns attribute name\n        if (!(nsName = nsMatrix[name.substring(0, w)])) {\n          handleWarning(missingNamespaceForPrefix(name.substring(0, w)));\n          continue;\n        }\n\n        name = defaultAlias === nsName\n          ? name.substr(w + 1)\n          : nsName + name.substr(w);\n\n        // end: normalize ns attribute name\n\n        // normalize xsi:type ns attribute value\n        if (name === XSI_TYPE) {\n          w = value.indexOf(\':\');\n\n          if (w !== -1) {\n            nsName = value.substring(0, w);\n\n            // handle default prefixes, i.e. xs:String gracefully\n            nsName = nsMatrix[nsName] || nsName;\n            value = nsName + value.substring(w);\n          } else {\n            value = defaultAlias + \':\' + value;\n          }\n        }\n\n        // end: normalize xsi:type ns attribute value\n\n        attrs[name] = value;\n      }\n\n\n      // handle deferred, possibly namespaced attributes\n      if (maybeNS) {\n\n        // normalize captured attributes\n        for (i = 0, l = attrList.length; i < l; i++) {\n\n          name = attrList[i++];\n          value = attrList[i];\n\n          w = name.indexOf(\':\');\n\n          if (w !== -1) {\n\n            // normalize ns attribute name\n            if (!(nsName = nsMatrix[name.substring(0, w)])) {\n              handleWarning(missingNamespaceForPrefix(name.substring(0, w)));\n              continue;\n            }\n\n            name = defaultAlias === nsName\n              ? name.substr(w + 1)\n              : nsName + name.substr(w);\n\n            // end: normalize ns attribute name\n\n            // normalize xsi:type ns attribute value\n            if (name === XSI_TYPE) {\n              w = value.indexOf(\':\');\n\n              if (w !== -1) {\n                nsName = value.substring(0, w);\n\n                // handle default prefixes, i.e. xs:String gracefully\n                nsName = nsMatrix[nsName] || nsName;\n                value = nsName + value.substring(w);\n              } else {\n                value = defaultAlias + \':\' + value;\n              }\n            }\n\n            // end: normalize xsi:type ns attribute value\n          }\n\n          attrs[name] = value;\n        }\n\n        // end: normalize captured attributes\n      }\n\n      return cachedAttrs = attrs;\n    }\n\n    /**\n     * Extract the parse context { line, column, part }\n     * from the current parser position.\n     *\n     * @return {Object} parse context\n     */\n    function getParseContext() {\n      var splitsRe = /(\\r\\n|\\r|\\n)/g;\n\n      var line = 0;\n      var column = 0;\n      var startOfLine = 0;\n      var endOfLine = j;\n      var match;\n      var data;\n\n      while (i >= startOfLine) {\n\n        match = splitsRe.exec(xml);\n\n        if (!match) {\n          break;\n        }\n\n        // end of line = (break idx + break chars)\n        endOfLine = match[0].length + match.index;\n\n        if (endOfLine > i) {\n          break;\n        }\n\n        // advance to next line\n        line += 1;\n\n        startOfLine = endOfLine;\n      }\n\n      // EOF errors\n      if (i == -1) {\n        column = endOfLine;\n        data = xml.substring(j);\n      } else\n\n      // start errors\n      if (j === 0) {\n        data = xml.substring(j, i);\n      }\n\n      // other errors\n      else {\n        column = i - startOfLine;\n        data = (j == -1 ? xml.substring(i) : xml.substring(i, j + 1));\n      }\n\n      return {\n        \'data\': data,\n        \'line\': line,\n        \'column\': column\n      };\n    }\n\n    getContext = getParseContext;\n\n\n    if (proxy) {\n      elementProxy = Object.create({}, {\n        \'name\': getter(function() {\n          return elementName;\n        }),\n        \'originalName\': getter(function() {\n          return _elementName;\n        }),\n        \'attrs\': getter(getAttrs),\n        \'ns\': getter(function() {\n          return nsMatrix;\n        })\n      });\n    }\n\n    // actual parse logic\n    while (j !== -1) {\n\n      if (xml.charCodeAt(j) === 60) { // "<"\n        i = j;\n      } else {\n        i = xml.indexOf(\'<\', j);\n      }\n\n      // parse end\n      if (i === -1) {\n        if (nodeStack.length) {\n          return handleError(\'unexpected end of file\');\n        }\n\n        if (j === 0) {\n          return handleError(\'missing start tag\');\n        }\n\n        if (j < xml.length) {\n          if (xml.substring(j).trim()) {\n            handleWarning(NON_WHITESPACE_OUTSIDE_ROOT_NODE);\n          }\n        }\n\n        return;\n      }\n\n      // parse text\n      if (j !== i) {\n\n        if (nodeStack.length) {\n          if (onText) {\n            onText(xml.substring(j, i), decodeEntities, getContext);\n\n            if (parseStop) {\n              return;\n            }\n          }\n        } else {\n          if (xml.substring(j, i).trim()) {\n            handleWarning(NON_WHITESPACE_OUTSIDE_ROOT_NODE);\n\n            if (parseStop) {\n              return;\n            }\n          }\n        }\n      }\n\n      w = xml.charCodeAt(i+1);\n\n      // parse comments + CDATA\n      if (w === 33) { // "!"\n        q = xml.charCodeAt(i+2);\n\n        // CDATA section\n        if (q === 91 && xml.substr(i + 3, 6) === \'CDATA[\') { // 91 == "["\n          j = xml.indexOf(\']]>\', i);\n          if (j === -1) {\n            return handleError(\'unclosed cdata\');\n          }\n\n          if (onCDATA) {\n            onCDATA(xml.substring(i + 9, j), getContext);\n            if (parseStop) {\n              return;\n            }\n          }\n\n          j += 3;\n          continue;\n        }\n\n        // comment\n        if (q === 45 && xml.charCodeAt(i + 3) === 45) { // 45 == "-"\n          j = xml.indexOf(\'--\x3e\', i);\n          if (j === -1) {\n            return handleError(\'unclosed comment\');\n          }\n\n\n          if (onComment) {\n            onComment(xml.substring(i + 4, j), decodeEntities, getContext);\n            if (parseStop) {\n              return;\n            }\n          }\n\n          j += 3;\n          continue;\n        }\n      }\n\n      // parse question <? ... ?>\n      if (w === 63) { // "?"\n        j = xml.indexOf(\'?>\', i);\n        if (j === -1) {\n          return handleError(\'unclosed question\');\n        }\n\n        if (onQuestion) {\n          onQuestion(xml.substring(i, j + 2), getContext);\n          if (parseStop) {\n            return;\n          }\n        }\n\n        j += 2;\n        continue;\n      }\n\n      // find matching closing tag for attention or standard tags\n      // for that we must skip through attribute values\n      // (enclosed in single or double quotes)\n      for (x = i + 1; ; x++) {\n        v = xml.charCodeAt(x);\n        if (isNaN(v)) {\n          j = -1;\n          return handleError(\'unclosed tag\');\n        }\n\n        // [10] AttValue ::= \'"\' ([^<&"] | Reference)* \'"\' | "\'" ([^<&\'] | Reference)* "\'"\n        // skips the quoted string\n        // (double quotes) does not appear in a literal enclosed by (double quotes)\n        // (single quote) does not appear in a literal enclosed by (single quote)\n        if (v === 34) { //  \'"\'\n          q = xml.indexOf(\'"\', x + 1);\n          x = q !== -1 ? q : x;\n        } else if (v === 39) { // "\'"\n          q = xml.indexOf("\'", x + 1);\n          x = q !== -1 ? q : x;\n        } else if (v === 62) { // \'>\'\n          j = x;\n          break;\n        }\n      }\n\n\n      // parse attention <! ...>\n      // previously comment and CDATA have already been parsed\n      if (w === 33) { // "!"\n\n        if (onAttention) {\n          onAttention(xml.substring(i, j + 1), decodeEntities, getContext);\n          if (parseStop) {\n            return;\n          }\n        }\n\n        j += 1;\n        continue;\n      }\n\n      // don\'t process attributes;\n      // there are none\n      cachedAttrs = {};\n\n      // if (xml.charCodeAt(i+1) === 47) { // </...\n      if (w === 47) { // </...\n        tagStart = false;\n        tagEnd = true;\n\n        if (!nodeStack.length) {\n          return handleError(\'missing open tag\');\n        }\n\n        // verify open <-> close tag match\n        x = elementName = nodeStack.pop();\n        q = i + 2 + x.length;\n\n        if (xml.substring(i + 2, q) !== x) {\n          return handleError(\'closing tag mismatch\');\n        }\n\n        // verify chars in close tag\n        for (; q < j; q++) {\n          w = xml.charCodeAt(q);\n\n          if (w === 32 || (w > 8 && w < 14)) { // \\f\\n\\r\\t\\v space\n            continue;\n          }\n\n          return handleError(\'close tag\');\n        }\n\n      } else {\n        if (xml.charCodeAt(j - 1) === 47) { // .../>\n          x = elementName = xml.substring(i + 1, j - 1);\n\n          tagStart = true;\n          tagEnd = true;\n\n        } else {\n          x = elementName = xml.substring(i + 1, j);\n\n          tagStart = true;\n          tagEnd = false;\n        }\n\n        if (!(w > 96 && w < 123 || w > 64 && w < 91 || w === 95 || w === 58)) { // char 95"_" 58":"\n          return handleError(\'illegal first char nodeName\');\n        }\n\n        for (q = 1, y = x.length; q < y; q++) {\n          w = x.charCodeAt(q);\n\n          if (w > 96 && w < 123 || w > 64 && w < 91 || w > 47 && w < 59 || w === 45 || w === 95 || w == 46) {\n            continue;\n          }\n\n          if (w === 32 || (w < 14 && w > 8)) { // \\f\\n\\r\\t\\v space\n            elementName = x.substring(0, q);\n\n            // maybe there are attributes\n            cachedAttrs = null;\n            break;\n          }\n\n          return handleError(\'invalid nodeName\');\n        }\n\n        if (!tagEnd) {\n          nodeStack.push(elementName);\n        }\n      }\n\n      if (isNamespace) {\n\n        _nsMatrix = nsMatrix;\n\n        if (tagStart) {\n\n          // remember old namespace\n          // unless we\'re self-closing\n          if (!tagEnd) {\n            nsMatrixStack.push(_nsMatrix);\n          }\n\n          if (cachedAttrs === null) {\n\n            // quick check, whether there may be namespace\n            // declarations on the node; if that is the case\n            // we need to eagerly parse the node attributes\n            if ((maybeNS = x.indexOf(\'xmlns\', q) !== -1)) {\n              attrsStart = q;\n              attrsString = x;\n\n              getAttrs();\n\n              maybeNS = false;\n            }\n          }\n        }\n\n        _elementName = elementName;\n\n        w = elementName.indexOf(\':\');\n        if (w !== -1) {\n          xmlns = nsMatrix[elementName.substring(0, w)];\n\n          // prefix given; namespace must exist\n          if (!xmlns) {\n            return handleError(\'missing namespace on <\' + _elementName + \'>\');\n          }\n\n          elementName = elementName.substr(w + 1);\n        } else {\n          xmlns = nsMatrix[\'xmlns\'];\n\n          // if no default namespace is defined,\n          // we\'ll import the element as anonymous.\n          //\n          // it is up to users to correct that to the document defined\n          // targetNamespace, or whatever their undersanding of the\n          // XML spec mandates.\n        }\n\n        // adjust namespace prefixs as configured\n        if (xmlns) {\n          elementName = xmlns + \':\' + elementName;\n        }\n\n      }\n\n      if (tagStart) {\n        attrsStart = q;\n        attrsString = x;\n\n        if (onOpenTag) {\n          if (proxy) {\n            onOpenTag(elementProxy, decodeEntities, tagEnd, getContext);\n          } else {\n            onOpenTag(elementName, getAttrs, decodeEntities, tagEnd, getContext);\n          }\n\n          if (parseStop) {\n            return;\n          }\n        }\n\n      }\n\n      if (tagEnd) {\n\n        if (onCloseTag) {\n          onCloseTag(proxy ? elementProxy : elementName, decodeEntities, tagStart, getContext);\n\n          if (parseStop) {\n            return;\n          }\n        }\n\n        // restore old namespace\n        if (isNamespace) {\n          if (!tagStart) {\n            nsMatrix = nsMatrixStack.pop();\n          } else {\n            nsMatrix = _nsMatrix;\n          }\n        }\n      }\n\n      j += 1;\n    }\n  } /** end parse */\n\n}\n\n\n\n;// CONCATENATED MODULE: ./node_modules/moddle-xml/lib/common.js\nfunction hasLowerCaseAlias(pkg) {\n  return pkg.xml && pkg.xml.tagAlias === \'lowerCase\';\n}\n\nvar DEFAULT_NS_MAP = {\n  \'xsi\': \'http://www.w3.org/2001/XMLSchema-instance\'\n};\n\nvar common_XSI_TYPE = \'xsi:type\';\n\nfunction serializeFormat(element) {\n  return element.xml && element.xml.serialize;\n}\n\nfunction serializeAsType(element) {\n  return serializeFormat(element) === common_XSI_TYPE;\n}\n\nfunction serializeAsProperty(element) {\n  return serializeFormat(element) === \'property\';\n}\n;// CONCATENATED MODULE: ./node_modules/moddle-xml/lib/read.js\n\n\n\n\n\n\n\n\n\n\n\nfunction capitalize(str) {\n  return str.charAt(0).toUpperCase() + str.slice(1);\n}\n\nfunction aliasToName(aliasNs, pkg) {\n\n  if (!hasLowerCaseAlias(pkg)) {\n    return aliasNs.name;\n  }\n\n  return aliasNs.prefix + \':\' + capitalize(aliasNs.localName);\n}\n\nfunction prefixedToName(nameNs, pkg) {\n\n  var name = nameNs.name,\n      localName = nameNs.localName;\n\n  var typePrefix = pkg.xml && pkg.xml.typePrefix;\n\n  if (typePrefix && localName.indexOf(typePrefix) === 0) {\n    return nameNs.prefix + \':\' + localName.slice(typePrefix.length);\n  } else {\n    return name;\n  }\n}\n\nfunction normalizeXsiTypeName(name, model) {\n\n  var nameNs = parseName(name);\n  var pkg = model.getPackage(nameNs.prefix);\n\n  return prefixedToName(nameNs, pkg);\n}\n\nfunction read_error(message) {\n  return new Error(message);\n}\n\n/**\n * Get the moddle descriptor for a given instance or type.\n *\n * @param  {ModdleElement|Function} element\n *\n * @return {Object} the moddle descriptor\n */\nfunction getModdleDescriptor(element) {\n  return element.$descriptor;\n}\n\nfunction defer(fn) {\n  setTimeout(fn, 0);\n}\n\n/**\n * A parse context.\n *\n * @class\n *\n * @param {Object} options\n * @param {ElementHandler} options.rootHandler the root handler for parsing a document\n * @param {boolean} [options.lax=false] whether or not to ignore invalid elements\n */\nfunction Context(options) {\n\n  /**\n   * @property {ElementHandler} rootHandler\n   */\n\n  /**\n   * @property {Boolean} lax\n   */\n\n  (0,index_esm/* assign */.f0)(this, options);\n\n  this.elementsById = {};\n  this.references = [];\n  this.warnings = [];\n\n  /**\n   * Add an unresolved reference.\n   *\n   * @param {Object} reference\n   */\n  this.addReference = function(reference) {\n    this.references.push(reference);\n  };\n\n  /**\n   * Add a processed element.\n   *\n   * @param {ModdleElement} element\n   */\n  this.addElement = function(element) {\n\n    if (!element) {\n      throw read_error(\'expected element\');\n    }\n\n    var elementsById = this.elementsById;\n\n    var descriptor = getModdleDescriptor(element);\n\n    var idProperty = descriptor.idProperty,\n        id;\n\n    if (idProperty) {\n      id = element.get(idProperty.name);\n\n      if (id) {\n        // for QName validation as per http://www.w3.org/TR/REC-xml/#NT-NameChar\n        if (!/^([a-z][\\w-.]*:)?[a-z_][\\w-.]*$/i.test(id)) {\n          throw new Error(\'illegal ID <\' + id + \'>\');\n        }\n\n        if (elementsById[id]) {\n          throw read_error(\'duplicate ID <\' + id + \'>\');\n        }\n\n        elementsById[id] = element;\n      }\n    }\n  };\n\n  /**\n   * Add an import warning.\n   *\n   * @param {Object} warning\n   * @param {String} warning.message\n   * @param {Error} [warning.error]\n   */\n  this.addWarning = function(warning) {\n    this.warnings.push(warning);\n  };\n}\n\nfunction BaseHandler() {}\n\nBaseHandler.prototype.handleEnd = function() {};\nBaseHandler.prototype.handleText = function() {};\nBaseHandler.prototype.handleNode = function() {};\n\n\n/**\n * A simple pass through handler that does nothing except for\n * ignoring all input it receives.\n *\n * This is used to ignore unknown elements and\n * attributes.\n */\nfunction NoopHandler() { }\n\nNoopHandler.prototype = Object.create(BaseHandler.prototype);\n\nNoopHandler.prototype.handleNode = function() {\n  return this;\n};\n\nfunction BodyHandler() {}\n\nBodyHandler.prototype = Object.create(BaseHandler.prototype);\n\nBodyHandler.prototype.handleText = function(text) {\n  this.body = (this.body || \'\') + text;\n};\n\nfunction ReferenceHandler(property, context) {\n  this.property = property;\n  this.context = context;\n}\n\nReferenceHandler.prototype = Object.create(BodyHandler.prototype);\n\nReferenceHandler.prototype.handleNode = function(node) {\n\n  if (this.element) {\n    throw read_error(\'expected no sub nodes\');\n  } else {\n    this.element = this.createReference(node);\n  }\n\n  return this;\n};\n\nReferenceHandler.prototype.handleEnd = function() {\n  this.element.id = this.body;\n};\n\nReferenceHandler.prototype.createReference = function(node) {\n  return {\n    property: this.property.ns.name,\n    id: \'\'\n  };\n};\n\nfunction ValueHandler(propertyDesc, element) {\n  this.element = element;\n  this.propertyDesc = propertyDesc;\n}\n\nValueHandler.prototype = Object.create(BodyHandler.prototype);\n\nValueHandler.prototype.handleEnd = function() {\n\n  var value = this.body || \'\',\n      element = this.element,\n      propertyDesc = this.propertyDesc;\n\n  value = coerceType(propertyDesc.type, value);\n\n  if (propertyDesc.isMany) {\n    element.get(propertyDesc.name).push(value);\n  } else {\n    element.set(propertyDesc.name, value);\n  }\n};\n\n\nfunction BaseElementHandler() {}\n\nBaseElementHandler.prototype = Object.create(BodyHandler.prototype);\n\nBaseElementHandler.prototype.handleNode = function(node) {\n  var parser = this,\n      element = this.element;\n\n  if (!element) {\n    element = this.element = this.createElement(node);\n\n    this.context.addElement(element);\n  } else {\n    parser = this.handleChild(node);\n  }\n\n  return parser;\n};\n\n/**\n * @class Reader.ElementHandler\n *\n */\nfunction ElementHandler(model, typeName, context) {\n  this.model = model;\n  this.type = model.getType(typeName);\n  this.context = context;\n}\n\nElementHandler.prototype = Object.create(BaseElementHandler.prototype);\n\nElementHandler.prototype.addReference = function(reference) {\n  this.context.addReference(reference);\n};\n\nElementHandler.prototype.handleText = function(text) {\n\n  var element = this.element,\n      descriptor = getModdleDescriptor(element),\n      bodyProperty = descriptor.bodyProperty;\n\n  if (!bodyProperty) {\n    throw read_error(\'unexpected body text <\' + text + \'>\');\n  }\n\n  BodyHandler.prototype.handleText.call(this, text);\n};\n\nElementHandler.prototype.handleEnd = function() {\n\n  var value = this.body,\n      element = this.element,\n      descriptor = getModdleDescriptor(element),\n      bodyProperty = descriptor.bodyProperty;\n\n  if (bodyProperty && value !== undefined) {\n    value = coerceType(bodyProperty.type, value);\n    element.set(bodyProperty.name, value);\n  }\n};\n\n/**\n * Create an instance of the model from the given node.\n *\n * @param  {Element} node the xml node\n */\nElementHandler.prototype.createElement = function(node) {\n  var attributes = node.attributes,\n      Type = this.type,\n      descriptor = getModdleDescriptor(Type),\n      context = this.context,\n      instance = new Type({}),\n      model = this.model,\n      propNameNs;\n\n  (0,index_esm/* forEach */.Ed)(attributes, function(value, name) {\n\n    var prop = descriptor.propertiesByName[name],\n        values;\n\n    if (prop && prop.isReference) {\n\n      if (!prop.isMany) {\n        context.addReference({\n          element: instance,\n          property: prop.ns.name,\n          id: value\n        });\n      } else {\n        // IDREFS: parse references as whitespace-separated list\n        values = value.split(\' \');\n\n        (0,index_esm/* forEach */.Ed)(values, function(v) {\n          context.addReference({\n            element: instance,\n            property: prop.ns.name,\n            id: v\n          });\n        });\n      }\n\n    } else {\n      if (prop) {\n        value = coerceType(prop.type, value);\n      } else\n      if (name !== \'xmlns\') {\n        propNameNs = parseName(name, descriptor.ns.prefix);\n\n        // check whether attribute is defined in a well-known namespace\n        // if that is the case we emit a warning to indicate potential misuse\n        if (model.getPackage(propNameNs.prefix)) {\n\n          context.addWarning({\n            message: \'unknown attribute <\' + name + \'>\',\n            element: instance,\n            property: name,\n            value: value\n          });\n        }\n      }\n\n      instance.set(name, value);\n    }\n  });\n\n  return instance;\n};\n\nElementHandler.prototype.getPropertyForNode = function(node) {\n\n  var name = node.name;\n  var nameNs = parseName(name);\n\n  var type = this.type,\n      model = this.model,\n      descriptor = getModdleDescriptor(type);\n\n  var propertyName = nameNs.name,\n      property = descriptor.propertiesByName[propertyName],\n      elementTypeName,\n      elementType;\n\n  // search for properties by name first\n\n  if (property) {\n\n    if (serializeAsType(property)) {\n      elementTypeName = node.attributes[common_XSI_TYPE];\n\n      // xsi type is optional, if it does not exists the\n      // default type is assumed\n      if (elementTypeName) {\n\n        // take possible type prefixes from XML\n        // into account, i.e.: xsi:type="t{ActualType}"\n        elementTypeName = normalizeXsiTypeName(elementTypeName, model);\n\n        elementType = model.getType(elementTypeName);\n\n        return (0,index_esm/* assign */.f0)({}, property, {\n          effectiveType: getModdleDescriptor(elementType).name\n        });\n      }\n    }\n\n    // search for properties by name first\n    return property;\n  }\n\n  var pkg = model.getPackage(nameNs.prefix);\n\n  if (pkg) {\n    elementTypeName = aliasToName(nameNs, pkg);\n    elementType = model.getType(elementTypeName);\n\n    // search for collection members later\n    property = (0,index_esm/* find */.sE)(descriptor.properties, function(p) {\n      return !p.isVirtual && !p.isReference && !p.isAttribute && elementType.hasType(p.type);\n    });\n\n    if (property) {\n      return (0,index_esm/* assign */.f0)({}, property, {\n        effectiveType: getModdleDescriptor(elementType).name\n      });\n    }\n  } else {\n    // parse unknown element (maybe extension)\n    property = (0,index_esm/* find */.sE)(descriptor.properties, function(p) {\n      return !p.isReference && !p.isAttribute && p.type === \'Element\';\n    });\n\n    if (property) {\n      return property;\n    }\n  }\n\n  throw read_error(\'unrecognized element <\' + nameNs.name + \'>\');\n};\n\nElementHandler.prototype.toString = function() {\n  return \'ElementDescriptor[\' + getModdleDescriptor(this.type).name + \']\';\n};\n\nElementHandler.prototype.valueHandler = function(propertyDesc, element) {\n  return new ValueHandler(propertyDesc, element);\n};\n\nElementHandler.prototype.referenceHandler = function(propertyDesc) {\n  return new ReferenceHandler(propertyDesc, this.context);\n};\n\nElementHandler.prototype.handler = function(type) {\n  if (type === \'Element\') {\n    return new GenericElementHandler(this.model, type, this.context);\n  } else {\n    return new ElementHandler(this.model, type, this.context);\n  }\n};\n\n/**\n * Handle the child element parsing\n *\n * @param  {Element} node the xml node\n */\nElementHandler.prototype.handleChild = function(node) {\n  var propertyDesc, type, element, childHandler;\n\n  propertyDesc = this.getPropertyForNode(node);\n  element = this.element;\n\n  type = propertyDesc.effectiveType || propertyDesc.type;\n\n  if (isSimple(type)) {\n    return this.valueHandler(propertyDesc, element);\n  }\n\n  if (propertyDesc.isReference) {\n    childHandler = this.referenceHandler(propertyDesc).handleNode(node);\n  } else {\n    childHandler = this.handler(type).handleNode(node);\n  }\n\n  var newElement = childHandler.element;\n\n  // child handles may decide to skip elements\n  // by not returning anything\n  if (newElement !== undefined) {\n\n    if (propertyDesc.isMany) {\n      element.get(propertyDesc.name).push(newElement);\n    } else {\n      element.set(propertyDesc.name, newElement);\n    }\n\n    if (propertyDesc.isReference) {\n      (0,index_esm/* assign */.f0)(newElement, {\n        element: element\n      });\n\n      this.context.addReference(newElement);\n    } else {\n      // establish child -> parent relationship\n      newElement.$parent = element;\n    }\n  }\n\n  return childHandler;\n};\n\n/**\n * An element handler that performs special validation\n * to ensure the node it gets initialized with matches\n * the handlers type (namespace wise).\n *\n * @param {Moddle} model\n * @param {String} typeName\n * @param {Context} context\n */\nfunction RootElementHandler(model, typeName, context) {\n  ElementHandler.call(this, model, typeName, context);\n}\n\nRootElementHandler.prototype = Object.create(ElementHandler.prototype);\n\nRootElementHandler.prototype.createElement = function(node) {\n\n  var name = node.name,\n      nameNs = parseName(name),\n      model = this.model,\n      type = this.type,\n      pkg = model.getPackage(nameNs.prefix),\n      typeName = pkg && aliasToName(nameNs, pkg) || name;\n\n  // verify the correct namespace if we parse\n  // the first element in the handler tree\n  //\n  // this ensures we don\'t mistakenly import wrong namespace elements\n  if (!type.hasType(typeName)) {\n    throw read_error(\'unexpected element <\' + node.originalName + \'>\');\n  }\n\n  return ElementHandler.prototype.createElement.call(this, node);\n};\n\n\nfunction GenericElementHandler(model, typeName, context) {\n  this.model = model;\n  this.context = context;\n}\n\nGenericElementHandler.prototype = Object.create(BaseElementHandler.prototype);\n\nGenericElementHandler.prototype.createElement = function(node) {\n\n  var name = node.name,\n      ns = parseName(name),\n      prefix = ns.prefix,\n      uri = node.ns[prefix + \'$uri\'],\n      attributes = node.attributes;\n\n  return this.model.createAny(name, uri, attributes);\n};\n\nGenericElementHandler.prototype.handleChild = function(node) {\n\n  var handler = new GenericElementHandler(this.model, \'Element\', this.context).handleNode(node),\n      element = this.element;\n\n  var newElement = handler.element,\n      children;\n\n  if (newElement !== undefined) {\n    children = element.$children = element.$children || [];\n    children.push(newElement);\n\n    // establish child -> parent relationship\n    newElement.$parent = element;\n  }\n\n  return handler;\n};\n\nGenericElementHandler.prototype.handleEnd = function() {\n  if (this.body) {\n    this.element.$body = this.body;\n  }\n};\n\n/**\n * A reader for a meta-model\n *\n * @param {Object} options\n * @param {Model} options.model used to read xml files\n * @param {Boolean} options.lax whether to make parse errors warnings\n */\nfunction Reader(options) {\n\n  if (options instanceof Moddle) {\n    options = {\n      model: options\n    };\n  }\n\n  (0,index_esm/* assign */.f0)(this, { lax: false }, options);\n}\n\n\n/**\n * Parse the given XML into a moddle document tree.\n *\n * @param {String} xml\n * @param {ElementHandler|Object} options or rootHandler\n * @param  {Function} done\n */\nReader.prototype.fromXML = function(xml, options, done) {\n\n  var rootHandler = options.rootHandler;\n\n  if (options instanceof ElementHandler) {\n    // root handler passed via (xml, { rootHandler: ElementHandler }, ...)\n    rootHandler = options;\n    options = {};\n  } else {\n    if (typeof options === \'string\') {\n      // rootHandler passed via (xml, \'someString\', ...)\n      rootHandler = this.handler(options);\n      options = {};\n    } else if (typeof rootHandler === \'string\') {\n      // rootHandler passed via (xml, { rootHandler: \'someString\' }, ...)\n      rootHandler = this.handler(rootHandler);\n    }\n  }\n\n  var model = this.model,\n      lax = this.lax;\n\n  var context = new Context((0,index_esm/* assign */.f0)({}, options, { rootHandler: rootHandler })),\n      parser = new Parser({ proxy: true }),\n      stack = createStack();\n\n  rootHandler.context = context;\n\n  // push root handler\n  stack.push(rootHandler);\n\n\n  /**\n   * Handle error.\n   *\n   * @param  {Error} err\n   * @param  {Function} getContext\n   * @param  {boolean} lax\n   *\n   * @return {boolean} true if handled\n   */\n  function handleError(err, getContext, lax) {\n\n    var ctx = getContext();\n\n    var line = ctx.line,\n        column = ctx.column,\n        data = ctx.data;\n\n    // we receive the full context data here,\n    // for elements trim down the information\n    // to the tag name, only\n    if (data.charAt(0) === \'<\' && data.indexOf(\' \') !== -1) {\n      data = data.slice(0, data.indexOf(\' \')) + \'>\';\n    }\n\n    var message =\n      \'unparsable content \' + (data ? data + \' \' : \'\') + \'detected\\n\\t\' +\n        \'line: \' + line + \'\\n\\t\' +\n        \'column: \' + column + \'\\n\\t\' +\n        \'nested error: \' + err.message;\n\n    if (lax) {\n      context.addWarning({\n        message: message,\n        error: err\n      });\n\n      return true;\n    } else {\n      throw read_error(message);\n    }\n  }\n\n  function handleWarning(err, getContext) {\n    // just like handling errors in <lax=true> mode\n    return handleError(err, getContext, true);\n  }\n\n  /**\n   * Resolve collected references on parse end.\n   */\n  function resolveReferences() {\n\n    var elementsById = context.elementsById;\n    var references = context.references;\n\n    var i, r;\n\n    for (i = 0; (r = references[i]); i++) {\n      var element = r.element;\n      var reference = elementsById[r.id];\n      var property = getModdleDescriptor(element).propertiesByName[r.property];\n\n      if (!reference) {\n        context.addWarning({\n          message: \'unresolved reference <\' + r.id + \'>\',\n          element: r.element,\n          property: r.property,\n          value: r.id\n        });\n      }\n\n      if (property.isMany) {\n        var collection = element.get(property.name),\n            idx = collection.indexOf(r);\n\n        // we replace an existing place holder (idx != -1) or\n        // append to the collection instead\n        if (idx === -1) {\n          idx = collection.length;\n        }\n\n        if (!reference) {\n          // remove unresolvable reference\n          collection.splice(idx, 1);\n        } else {\n          // add or update reference in collection\n          collection[idx] = reference;\n        }\n      } else {\n        element.set(property.name, reference);\n      }\n    }\n  }\n\n  function handleClose() {\n    stack.pop().handleEnd();\n  }\n\n  var PREAMBLE_START_PATTERN = /^<\\?xml /i;\n\n  var ENCODING_PATTERN = / encoding="([^"]+)"/i;\n\n  var UTF_8_PATTERN = /^utf-8$/i;\n\n  function handleQuestion(question) {\n\n    if (!PREAMBLE_START_PATTERN.test(question)) {\n      return;\n    }\n\n    var match = ENCODING_PATTERN.exec(question);\n    var encoding = match && match[1];\n\n    if (!encoding || UTF_8_PATTERN.test(encoding)) {\n      return;\n    }\n\n    context.addWarning({\n      message:\n        \'unsupported document encoding <\' + encoding + \'>, \' +\n        \'falling back to UTF-8\'\n    });\n  }\n\n  function handleOpen(node, getContext) {\n    var handler = stack.peek();\n\n    try {\n      stack.push(handler.handleNode(node));\n    } catch (err) {\n\n      if (handleError(err, getContext, lax)) {\n        stack.push(new NoopHandler());\n      }\n    }\n  }\n\n  function handleCData(text, getContext) {\n\n    try {\n      stack.peek().handleText(text);\n    } catch (err) {\n      handleWarning(err, getContext);\n    }\n  }\n\n  function handleText(text, getContext) {\n    // strip whitespace only nodes, i.e. before\n    // <!CDATA[ ... ]> sections and in between tags\n    text = text.trim();\n\n    if (!text) {\n      return;\n    }\n\n    handleCData(text, getContext);\n  }\n\n  var uriMap = model.getPackages().reduce(function(uriMap, p) {\n    uriMap[p.uri] = p.prefix;\n\n    return uriMap;\n  }, {});\n\n  parser\n    .ns(uriMap)\n    .on(\'openTag\', function(obj, decodeStr, selfClosing, getContext) {\n\n      // gracefully handle unparsable attributes (attrs=false)\n      var attrs = obj.attrs || {};\n\n      var decodedAttrs = Object.keys(attrs).reduce(function(d, key) {\n        var value = decodeStr(attrs[key]);\n\n        d[key] = value;\n\n        return d;\n      }, {});\n\n      var node = {\n        name: obj.name,\n        originalName: obj.originalName,\n        attributes: decodedAttrs,\n        ns: obj.ns\n      };\n\n      handleOpen(node, getContext);\n    })\n    .on(\'question\', handleQuestion)\n    .on(\'closeTag\', handleClose)\n    .on(\'cdata\', handleCData)\n    .on(\'text\', function(text, decodeEntities, getContext) {\n      handleText(decodeEntities(text), getContext);\n    })\n    .on(\'error\', handleError)\n    .on(\'warn\', handleWarning);\n\n  // deferred parse XML to make loading really ascnchronous\n  // this ensures the execution environment (node or browser)\n  // is kept responsive and that certain optimization strategies\n  // can kick in\n  defer(function() {\n    var err;\n\n    try {\n      parser.parse(xml);\n\n      resolveReferences();\n    } catch (e) {\n      err = e;\n    }\n\n    var element = rootHandler.element;\n\n    // handle the situation that we could not extract\n    // the desired root element from the document\n    if (!err && !element) {\n      err = read_error(\'failed to parse document as <\' + rootHandler.type.$descriptor.name + \'>\');\n    }\n\n    done(err, err ? undefined : element, context);\n  });\n};\n\nReader.prototype.handler = function(name) {\n  return new RootElementHandler(this.model, name);\n};\n\n\n// helpers //////////////////////////\n\nfunction createStack() {\n  var stack = [];\n\n  Object.defineProperty(stack, \'peek\', {\n    value: function() {\n      return this[this.length - 1];\n    }\n  });\n\n  return stack;\n}\n;// CONCATENATED MODULE: ./node_modules/moddle-xml/lib/write.js\n\n\n\n\n\n\n\n\nvar XML_PREAMBLE = \'<?xml version="1.0" encoding="UTF-8"?>\\n\';\n\nvar ESCAPE_ATTR_CHARS = /<|>|\'|"|&|\\n\\r|\\n/g;\nvar ESCAPE_CHARS =  /<|>|&/g;\n\n\nfunction Namespaces(parent) {\n\n  var prefixMap = {};\n  var uriMap = {};\n  var used = {};\n\n  var wellknown = [];\n  var custom = [];\n\n  // API\n\n  this.byUri = function(uri) {\n    return uriMap[uri] || (\n      parent && parent.byUri(uri)\n    );\n  };\n\n  this.add = function(ns, isWellknown) {\n\n    uriMap[ns.uri] = ns;\n\n    if (isWellknown) {\n      wellknown.push(ns);\n    } else {\n      custom.push(ns);\n    }\n\n    this.mapPrefix(ns.prefix, ns.uri);\n  };\n\n  this.uriByPrefix = function(prefix) {\n    return prefixMap[prefix || \'xmlns\'];\n  };\n\n  this.mapPrefix = function(prefix, uri) {\n    prefixMap[prefix || \'xmlns\'] = uri;\n  };\n\n  this.logUsed = function(ns) {\n    var uri = ns.uri;\n\n    used[uri] = this.byUri(uri);\n  };\n\n  this.getUsed = function(ns) {\n\n    function isUsed(ns) {\n      return used[ns.uri];\n    }\n\n    var allNs = [].concat(wellknown, custom);\n\n    return allNs.filter(isUsed);\n  };\n\n}\n\nfunction lower(string) {\n  return string.charAt(0).toLowerCase() + string.slice(1);\n}\n\nfunction nameToAlias(name, pkg) {\n  if (hasLowerCaseAlias(pkg)) {\n    return lower(name);\n  } else {\n    return name;\n  }\n}\n\nfunction inherits(ctor, superCtor) {\n  ctor.super_ = superCtor;\n  ctor.prototype = Object.create(superCtor.prototype, {\n    constructor: {\n      value: ctor,\n      enumerable: false,\n      writable: true,\n      configurable: true\n    }\n  });\n}\n\nfunction nsName(ns) {\n  if ((0,index_esm/* isString */.HD)(ns)) {\n    return ns;\n  } else {\n    return (ns.prefix ? ns.prefix + \':\' : \'\') + ns.localName;\n  }\n}\n\nfunction getNsAttrs(namespaces) {\n\n  return (0,index_esm/* map */.UI)(namespaces.getUsed(), function(ns) {\n    var name = \'xmlns\' + (ns.prefix ? \':\' + ns.prefix : \'\');\n    return { name: name, value: ns.uri };\n  });\n\n}\n\nfunction getElementNs(ns, descriptor) {\n  if (descriptor.isGeneric) {\n    return (0,index_esm/* assign */.f0)({ localName: descriptor.ns.localName }, ns);\n  } else {\n    return (0,index_esm/* assign */.f0)({ localName: nameToAlias(descriptor.ns.localName, descriptor.$pkg) }, ns);\n  }\n}\n\nfunction getPropertyNs(ns, descriptor) {\n  return (0,index_esm/* assign */.f0)({ localName: descriptor.ns.localName }, ns);\n}\n\nfunction getSerializableProperties(element) {\n  var descriptor = element.$descriptor;\n\n  return (0,index_esm/* filter */.hX)(descriptor.properties, function(p) {\n    var name = p.name;\n\n    if (p.isVirtual) {\n      return false;\n    }\n\n    // do not serialize defaults\n    if (!element.hasOwnProperty(name)) {\n      return false;\n    }\n\n    var value = element[name];\n\n    // do not serialize default equals\n    if (value === p.default) {\n      return false;\n    }\n\n    // do not serialize null properties\n    if (value === null) {\n      return false;\n    }\n\n    return p.isMany ? value.length : true;\n  });\n}\n\nvar ESCAPE_ATTR_MAP = {\n  \'\\n\': \'#10\',\n  \'\\n\\r\': \'#10\',\n  \'"\': \'#34\',\n  \'\\\'\': \'#39\',\n  \'<\': \'#60\',\n  \'>\': \'#62\',\n  \'&\': \'#38\'\n};\n\nvar ESCAPE_MAP = {\n  \'<\': \'lt\',\n  \'>\': \'gt\',\n  \'&\': \'amp\'\n};\n\nfunction write_escape(str, charPattern, replaceMap) {\n\n  // ensure we are handling strings here\n  str = (0,index_esm/* isString */.HD)(str) ? str : \'\' + str;\n\n  return str.replace(charPattern, function(s) {\n    return \'&\' + replaceMap[s] + \';\';\n  });\n}\n\n/**\n * Escape a string attribute to not contain any bad values (line breaks, \'"\', ...)\n *\n * @param {String} str the string to escape\n * @return {String} the escaped string\n */\nfunction escapeAttr(str) {\n  return write_escape(str, ESCAPE_ATTR_CHARS, ESCAPE_ATTR_MAP);\n}\n\nfunction escapeBody(str) {\n  return write_escape(str, ESCAPE_CHARS, ESCAPE_MAP);\n}\n\nfunction filterAttributes(props) {\n  return (0,index_esm/* filter */.hX)(props, function(p) { return p.isAttr; });\n}\n\nfunction filterContained(props) {\n  return (0,index_esm/* filter */.hX)(props, function(p) { return !p.isAttr; });\n}\n\n\nfunction ReferenceSerializer(tagName) {\n  this.tagName = tagName;\n}\n\nReferenceSerializer.prototype.build = function(element) {\n  this.element = element;\n  return this;\n};\n\nReferenceSerializer.prototype.serializeTo = function(writer) {\n  writer\n    .appendIndent()\n    .append(\'<\' + this.tagName + \'>\' + this.element.id + \'</\' + this.tagName + \'>\')\n    .appendNewLine();\n};\n\nfunction BodySerializer() {}\n\nBodySerializer.prototype.serializeValue =\nBodySerializer.prototype.serializeTo = function(writer) {\n  writer.append(\n    this.escape\n      ? escapeBody(this.value)\n      : this.value\n  );\n};\n\nBodySerializer.prototype.build = function(prop, value) {\n  this.value = value;\n\n  if (prop.type === \'String\' && value.search(ESCAPE_CHARS) !== -1) {\n    this.escape = true;\n  }\n\n  return this;\n};\n\nfunction ValueSerializer(tagName) {\n  this.tagName = tagName;\n}\n\ninherits(ValueSerializer, BodySerializer);\n\nValueSerializer.prototype.serializeTo = function(writer) {\n\n  writer\n    .appendIndent()\n    .append(\'<\' + this.tagName + \'>\');\n\n  this.serializeValue(writer);\n\n  writer\n    .append(\'</\' + this.tagName + \'>\')\n    .appendNewLine();\n};\n\nfunction ElementSerializer(parent, propertyDescriptor) {\n  this.body = [];\n  this.attrs = [];\n\n  this.parent = parent;\n  this.propertyDescriptor = propertyDescriptor;\n}\n\nElementSerializer.prototype.build = function(element) {\n  this.element = element;\n\n  var elementDescriptor = element.$descriptor,\n      propertyDescriptor = this.propertyDescriptor;\n\n  var otherAttrs,\n      properties;\n\n  var isGeneric = elementDescriptor.isGeneric;\n\n  if (isGeneric) {\n    otherAttrs = this.parseGeneric(element);\n  } else {\n    otherAttrs = this.parseNsAttributes(element);\n  }\n\n  if (propertyDescriptor) {\n    this.ns = this.nsPropertyTagName(propertyDescriptor);\n  } else {\n    this.ns = this.nsTagName(elementDescriptor);\n  }\n\n  // compute tag name\n  this.tagName = this.addTagName(this.ns);\n\n  if (!isGeneric) {\n    properties = getSerializableProperties(element);\n\n    this.parseAttributes(filterAttributes(properties));\n    this.parseContainments(filterContained(properties));\n  }\n\n  this.parseGenericAttributes(element, otherAttrs);\n\n  return this;\n};\n\nElementSerializer.prototype.nsTagName = function(descriptor) {\n  var effectiveNs = this.logNamespaceUsed(descriptor.ns);\n  return getElementNs(effectiveNs, descriptor);\n};\n\nElementSerializer.prototype.nsPropertyTagName = function(descriptor) {\n  var effectiveNs = this.logNamespaceUsed(descriptor.ns);\n  return getPropertyNs(effectiveNs, descriptor);\n};\n\nElementSerializer.prototype.isLocalNs = function(ns) {\n  return ns.uri === this.ns.uri;\n};\n\n/**\n * Get the actual ns attribute name for the given element.\n *\n * @param {Object} element\n * @param {Boolean} [element.inherited=false]\n *\n * @return {Object} nsName\n */\nElementSerializer.prototype.nsAttributeName = function(element) {\n\n  var ns;\n\n  if ((0,index_esm/* isString */.HD)(element)) {\n    ns = parseName(element);\n  } else {\n    ns = element.ns;\n  }\n\n  // return just local name for inherited attributes\n  if (element.inherited) {\n    return { localName: ns.localName };\n  }\n\n  // parse + log effective ns\n  var effectiveNs = this.logNamespaceUsed(ns);\n\n  // LOG ACTUAL namespace use\n  this.getNamespaces().logUsed(effectiveNs);\n\n  // strip prefix if same namespace like parent\n  if (this.isLocalNs(effectiveNs)) {\n    return { localName: ns.localName };\n  } else {\n    return (0,index_esm/* assign */.f0)({ localName: ns.localName }, effectiveNs);\n  }\n};\n\nElementSerializer.prototype.parseGeneric = function(element) {\n\n  var self = this,\n      body = this.body;\n\n  var attributes = [];\n\n  (0,index_esm/* forEach */.Ed)(element, function(val, key) {\n\n    var nonNsAttr;\n\n    if (key === \'$body\') {\n      body.push(new BodySerializer().build({ type: \'String\' }, val));\n    } else\n    if (key === \'$children\') {\n      (0,index_esm/* forEach */.Ed)(val, function(child) {\n        body.push(new ElementSerializer(self).build(child));\n      });\n    } else\n    if (key.indexOf(\'$\') !== 0) {\n      nonNsAttr = self.parseNsAttribute(element, key, val);\n\n      if (nonNsAttr) {\n        attributes.push({ name: key, value: val });\n      }\n    }\n  });\n\n  return attributes;\n};\n\nElementSerializer.prototype.parseNsAttribute = function(element, name, value) {\n  var model = element.$model;\n\n  var nameNs = parseName(name);\n\n  var ns;\n\n  // parse xmlns:foo="http://foo.bar"\n  if (nameNs.prefix === \'xmlns\') {\n    ns = { prefix: nameNs.localName, uri: value };\n  }\n\n  // parse xmlns="http://foo.bar"\n  if (!nameNs.prefix && nameNs.localName === \'xmlns\') {\n    ns = { uri: value };\n  }\n\n  if (!ns) {\n    return {\n      name: name,\n      value: value\n    };\n  }\n\n  if (model && model.getPackage(value)) {\n    // register well known namespace\n    this.logNamespace(ns, true, true);\n  } else {\n    // log custom namespace directly as used\n    var actualNs = this.logNamespaceUsed(ns, true);\n\n    this.getNamespaces().logUsed(actualNs);\n  }\n};\n\n\n/**\n * Parse namespaces and return a list of left over generic attributes\n *\n * @param  {Object} element\n * @return {Array<Object>}\n */\nElementSerializer.prototype.parseNsAttributes = function(element, attrs) {\n  var self = this;\n\n  var genericAttrs = element.$attrs;\n\n  var attributes = [];\n\n  // parse namespace attributes first\n  // and log them. push non namespace attributes to a list\n  // and process them later\n  (0,index_esm/* forEach */.Ed)(genericAttrs, function(value, name) {\n\n    var nonNsAttr = self.parseNsAttribute(element, name, value);\n\n    if (nonNsAttr) {\n      attributes.push(nonNsAttr);\n    }\n  });\n\n  return attributes;\n};\n\nElementSerializer.prototype.parseGenericAttributes = function(element, attributes) {\n\n  var self = this;\n\n  (0,index_esm/* forEach */.Ed)(attributes, function(attr) {\n\n    // do not serialize xsi:type attribute\n    // it is set manually based on the actual implementation type\n    if (attr.name === common_XSI_TYPE) {\n      return;\n    }\n\n    try {\n      self.addAttribute(self.nsAttributeName(attr.name), attr.value);\n    } catch (e) {\n      console.warn(\n        \'missing namespace information for \',\n        attr.name, \'=\', attr.value, \'on\', element,\n        e);\n    }\n  });\n};\n\nElementSerializer.prototype.parseContainments = function(properties) {\n\n  var self = this,\n      body = this.body,\n      element = this.element;\n\n  (0,index_esm/* forEach */.Ed)(properties, function(p) {\n    var value = element.get(p.name),\n        isReference = p.isReference,\n        isMany = p.isMany;\n\n    if (!isMany) {\n      value = [ value ];\n    }\n\n    if (p.isBody) {\n      body.push(new BodySerializer().build(p, value[0]));\n    } else\n    if (isSimple(p.type)) {\n      (0,index_esm/* forEach */.Ed)(value, function(v) {\n        body.push(new ValueSerializer(self.addTagName(self.nsPropertyTagName(p))).build(p, v));\n      });\n    } else\n    if (isReference) {\n      (0,index_esm/* forEach */.Ed)(value, function(v) {\n        body.push(new ReferenceSerializer(self.addTagName(self.nsPropertyTagName(p))).build(v));\n      });\n    } else {\n      // allow serialization via type\n      // rather than element name\n      var asType = serializeAsType(p),\n          asProperty = serializeAsProperty(p);\n\n      (0,index_esm/* forEach */.Ed)(value, function(v) {\n        var serializer;\n\n        if (asType) {\n          serializer = new TypeSerializer(self, p);\n        } else\n        if (asProperty) {\n          serializer = new ElementSerializer(self, p);\n        } else {\n          serializer = new ElementSerializer(self);\n        }\n\n        body.push(serializer.build(v));\n      });\n    }\n  });\n};\n\nElementSerializer.prototype.getNamespaces = function(local) {\n\n  var namespaces = this.namespaces,\n      parent = this.parent,\n      parentNamespaces;\n\n  if (!namespaces) {\n    parentNamespaces = parent && parent.getNamespaces();\n\n    if (local || !parentNamespaces) {\n      this.namespaces = namespaces = new Namespaces(parentNamespaces);\n    } else {\n      namespaces = parentNamespaces;\n    }\n  }\n\n  return namespaces;\n};\n\nElementSerializer.prototype.logNamespace = function(ns, wellknown, local) {\n  var namespaces = this.getNamespaces(local);\n\n  var nsUri = ns.uri,\n      nsPrefix = ns.prefix;\n\n  var existing = namespaces.byUri(nsUri);\n\n  if (!existing) {\n    namespaces.add(ns, wellknown);\n  }\n\n  namespaces.mapPrefix(nsPrefix, nsUri);\n\n  return ns;\n};\n\nElementSerializer.prototype.logNamespaceUsed = function(ns, local) {\n  var element = this.element,\n      model = element.$model,\n      namespaces = this.getNamespaces(local);\n\n  // ns may be\n  //\n  //   * prefix only\n  //   * prefix:uri\n  //   * localName only\n\n  var prefix = ns.prefix,\n      uri = ns.uri,\n      newPrefix, idx,\n      wellknownUri;\n\n  // handle anonymous namespaces (elementForm=unqualified), cf. #23\n  if (!prefix && !uri) {\n    return { localName: ns.localName };\n  }\n\n  wellknownUri = DEFAULT_NS_MAP[prefix] || model && (model.getPackage(prefix) || {}).uri;\n\n  uri = uri || wellknownUri || namespaces.uriByPrefix(prefix);\n\n  if (!uri) {\n    throw new Error(\'no namespace uri given for prefix <\' + prefix + \'>\');\n  }\n\n  ns = namespaces.byUri(uri);\n\n  if (!ns) {\n    newPrefix = prefix;\n    idx = 1;\n\n    // find a prefix that is not mapped yet\n    while (namespaces.uriByPrefix(newPrefix)) {\n      newPrefix = prefix + \'_\' + idx++;\n    }\n\n    ns = this.logNamespace({ prefix: newPrefix, uri: uri }, wellknownUri === uri);\n  }\n\n  if (prefix) {\n    namespaces.mapPrefix(prefix, uri);\n  }\n\n  return ns;\n};\n\nElementSerializer.prototype.parseAttributes = function(properties) {\n  var self = this,\n      element = this.element;\n\n  (0,index_esm/* forEach */.Ed)(properties, function(p) {\n\n    var value = element.get(p.name);\n\n    if (p.isReference) {\n\n      if (!p.isMany) {\n        value = value.id;\n      }\n      else {\n        var values = [];\n        (0,index_esm/* forEach */.Ed)(value, function(v) {\n          values.push(v.id);\n        });\n        // IDREFS is a whitespace-separated list of references.\n        value = values.join(\' \');\n      }\n\n    }\n\n    self.addAttribute(self.nsAttributeName(p), value);\n  });\n};\n\nElementSerializer.prototype.addTagName = function(nsTagName) {\n  var actualNs = this.logNamespaceUsed(nsTagName);\n\n  this.getNamespaces().logUsed(actualNs);\n\n  return nsName(nsTagName);\n};\n\nElementSerializer.prototype.addAttribute = function(name, value) {\n  var attrs = this.attrs;\n\n  if ((0,index_esm/* isString */.HD)(value)) {\n    value = escapeAttr(value);\n  }\n\n  attrs.push({ name: name, value: value });\n};\n\nElementSerializer.prototype.serializeAttributes = function(writer) {\n  var attrs = this.attrs,\n      namespaces = this.namespaces;\n\n  if (namespaces) {\n    attrs = getNsAttrs(namespaces).concat(attrs);\n  }\n\n  (0,index_esm/* forEach */.Ed)(attrs, function(a) {\n    writer\n      .append(\' \')\n      .append(nsName(a.name)).append(\'="\').append(a.value).append(\'"\');\n  });\n};\n\nElementSerializer.prototype.serializeTo = function(writer) {\n  var firstBody = this.body[0],\n      indent = firstBody && firstBody.constructor !== BodySerializer;\n\n  writer\n    .appendIndent()\n    .append(\'<\' + this.tagName);\n\n  this.serializeAttributes(writer);\n\n  writer.append(firstBody ? \'>\' : \' />\');\n\n  if (firstBody) {\n\n    if (indent) {\n      writer\n        .appendNewLine()\n        .indent();\n    }\n\n    (0,index_esm/* forEach */.Ed)(this.body, function(b) {\n      b.serializeTo(writer);\n    });\n\n    if (indent) {\n      writer\n        .unindent()\n        .appendIndent();\n    }\n\n    writer.append(\'</\' + this.tagName + \'>\');\n  }\n\n  writer.appendNewLine();\n};\n\n/**\n * A serializer for types that handles serialization of data types\n */\nfunction TypeSerializer(parent, propertyDescriptor) {\n  ElementSerializer.call(this, parent, propertyDescriptor);\n}\n\ninherits(TypeSerializer, ElementSerializer);\n\nTypeSerializer.prototype.parseNsAttributes = function(element) {\n\n  // extracted attributes\n  var attributes = ElementSerializer.prototype.parseNsAttributes.call(this, element);\n\n  var descriptor = element.$descriptor;\n\n  // only serialize xsi:type if necessary\n  if (descriptor.name === this.propertyDescriptor.type) {\n    return attributes;\n  }\n\n  var typeNs = this.typeNs = this.nsTagName(descriptor);\n  this.getNamespaces().logUsed(this.typeNs);\n\n  // add xsi:type attribute to represent the elements\n  // actual type\n\n  var pkg = element.$model.getPackage(typeNs.uri),\n      typePrefix = (pkg.xml && pkg.xml.typePrefix) || \'\';\n\n  this.addAttribute(\n    this.nsAttributeName(common_XSI_TYPE),\n    (typeNs.prefix ? typeNs.prefix + \':\' : \'\') + typePrefix + descriptor.ns.localName\n  );\n\n  return attributes;\n};\n\nTypeSerializer.prototype.isLocalNs = function(ns) {\n  return ns.uri === (this.typeNs || this.ns).uri;\n};\n\nfunction SavingWriter() {\n  this.value = \'\';\n\n  this.write = function(str) {\n    this.value += str;\n  };\n}\n\nfunction FormatingWriter(out, format) {\n\n  var indent = [\'\'];\n\n  this.append = function(str) {\n    out.write(str);\n\n    return this;\n  };\n\n  this.appendNewLine = function() {\n    if (format) {\n      out.write(\'\\n\');\n    }\n\n    return this;\n  };\n\n  this.appendIndent = function() {\n    if (format) {\n      out.write(indent.join(\'  \'));\n    }\n\n    return this;\n  };\n\n  this.indent = function() {\n    indent.push(\'\');\n    return this;\n  };\n\n  this.unindent = function() {\n    indent.pop();\n    return this;\n  };\n}\n\n/**\n * A writer for meta-model backed document trees\n *\n * @param {Object} options output options to pass into the writer\n */\nfunction Writer(options) {\n\n  options = (0,index_esm/* assign */.f0)({ format: false, preamble: true }, options || {});\n\n  function toXML(tree, writer) {\n    var internalWriter = writer || new SavingWriter();\n    var formatingWriter = new FormatingWriter(internalWriter, options.format);\n\n    if (options.preamble) {\n      formatingWriter.append(XML_PREAMBLE);\n    }\n\n    new ElementSerializer().build(tree).serializeTo(formatingWriter);\n\n    if (!writer) {\n      return internalWriter.value;\n    }\n  }\n\n  return {\n    toXML: toXML\n  };\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-moddle/lib/cmmn-moddle.js\n\n\n\n\n\n\n\n/**\n * A sub class of {@link Moddle} with support for import and export of CMMN 1.1 xml files.\n *\n * @class CmmnModdle\n * @extends Moddle\n *\n * @param {Object|Array} packages to use for instantiating the model\n * @param {Object} [options] additional options to pass over\n */\nfunction CmmnModdle(packages, options) {\n  Moddle.call(this, packages, options);\n}\n\nCmmnModdle.prototype = Object.create(Moddle.prototype);\n\n\n/**\n * Instantiates a CMMN model tree from a given xml string.\n *\n * @param {String}   xmlStr\n * @param {String}   [typeName=\'cmmn:Definitions\'] name of the root element\n * @param {Object}   [options]  options to pass to the underlying reader\n * @param {Function} done       callback that is invoked with (err, result, parseContext)\n *                              once the import completes\n */\nCmmnModdle.prototype.fromXML = function(xmlStr, typeName, options, done) {\n\n  if (!(0,index_esm/* isString */.HD)(typeName)) {\n    done = options;\n    options = typeName;\n    typeName = \'cmmn:Definitions\';\n  }\n\n  if ((0,index_esm/* isFunction */.mf)(options)) {\n    done = options;\n    options = {};\n  }\n\n  var reader = new Reader((0,index_esm/* assign */.f0)({ model: this, lax: true }, options));\n  var rootHandler = reader.handler(typeName);\n\n  reader.fromXML(xmlStr, rootHandler, done);\n};\n\n\n/**\n * Serializes a CMMN 1.1 object tree to XML.\n *\n * @param {String}   element    the root element, typically an instance of `cmmn:Definitions`\n * @param {Object}   [options]  to pass to the underlying writer\n * @param {Function} done       callback invoked with (err, xmlStr) once the import completes\n */\nCmmnModdle.prototype.toXML = function(element, options, done) {\n\n  if ((0,index_esm/* isFunction */.mf)(options)) {\n    done = options;\n    options = {};\n  }\n\n  var writer = new Writer(options);\n\n  var result;\n  var err;\n\n  try {\n    result = writer.toXML(element);\n  } catch (e) {\n    err = e;\n  }\n\n  return done(err, result);\n};\n;// CONCATENATED MODULE: ./node_modules/cmmn-moddle/resources/cmmn/json/cmmn.json\nconst cmmn_namespaceObject = JSON.parse(\'{"name":"CMMN","uri":"http://www.omg.org/spec/CMMN/20151109/MODEL","types":[{"name":"ApplicabilityRule","superClass":["CMMNElement"],"properties":[{"name":"condition","type":"Expression","xml":{"serialize":"property"}},{"name":"contextRef","type":"CaseFileItem","isAttr":true,"isReference":true},{"name":"name","isAttr":true,"type":"String"}]},{"name":"Artifact","isAbstract":true,"superClass":["CMMNElement"]},{"name":"Association","superClass":["Artifact"],"properties":[{"name":"associationDirection","type":"AssociationDirection","isAttr":true},{"name":"sourceRef","type":"CMMNElement","isAttr":true,"isReference":true},{"name":"targetRef","type":"CMMNElement","isAttr":true,"isReference":true}]},{"name":"TextAnnotation","superClass":["Artifact"],"properties":[{"name":"text","type":"String"},{"name":"textFormat","default":"text/plain","isAttr":true,"type":"String"}]},{"name":"ManualActivationRule","superClass":["CMMNElement"],"properties":[{"name":"condition","type":"Expression","xml":{"serialize":"property"}},{"name":"name","isAttr":true,"type":"String"},{"name":"contextRef","type":"CaseFileItem","isAttr":true,"isReference":true}]},{"name":"Case","superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"caseFileModel","type":"CaseFile","xml":{"serialize":"property"}},{"name":"casePlanModel","type":"Stage","xml":{"serialize":"property"}},{"name":"caseRoles","type":"CaseRoles"},{"name":"input","type":"CaseParameter","isMany":true,"xml":{"serialize":"property"}},{"name":"output","type":"CaseParameter","isMany":true,"xml":{"serialize":"property"}}]},{"name":"CaseFile","superClass":["CMMNElement"],"properties":[{"name":"caseFileItems","type":"CaseFileItem","isMany":true}]},{"name":"CaseFileItem","superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"multiplicity","type":"String","isAttr":true,"default":"Unspecified"},{"name":"definitionRef","type":"CaseFileItemDefinition","isAttr":true,"isReference":true},{"name":"sourceRef","type":"CaseFileItem","isAttr":true,"isReference":true},{"name":"targetRefs","type":"CaseFileItem","isAttr":true,"isReference":true,"isMany":true},{"name":"children","type":"Children","xml":{"serialize":"property"}}]},{"name":"CaseFileItemDefinition","superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"definitionType","type":"String","default":"http://www.omg.org/spec/CMMN/DefinitionType/Unspecified","isAttr":true},{"name":"properties","type":"Property","isMany":true},{"name":"structureRef","type":"String","isAttr":true},{"name":"importRef","type":"Import","isAttr":true,"isReference":true}]},{"name":"CaseFileItemOnPart","superClass":["OnPart"],"properties":[{"name":"standardEvent","type":"String"},{"name":"sourceRef","type":"CaseFileItem","isAttr":true,"isReference":true}]},{"name":"CaseParameter","superClass":["Parameter"],"properties":[{"name":"bindingRef","type":"CaseFileItem","isAttr":true,"isReference":true},{"name":"bindingRefinement","type":"Expression","xml":{"serialize":"property"}}]},{"name":"CaseRoles","superClass":["Parameter"],"properties":[{"name":"role","type":"Role","isMany":true}]},{"name":"CaseTask","superClass":["Task"],"properties":[{"name":"parameterMapping","type":"ParameterMapping","isMany":true},{"name":"caseRefExpression","type":"Expression","xml":{"serialize":"property"}},{"name":"caseRef","type":"String","isAttr":true}]},{"name":"Children","superClass":["CMMNElement"],"properties":[{"name":"caseFileItems","type":"CaseFileItem","isMany":true}]},{"name":"CMMNElement","isAbstract":true,"properties":[{"name":"id","isAttr":true,"type":"String","isId":true},{"name":"documentation","type":"Documentation","isMany":true},{"name":"extensionElements","type":"ExtensionElements"},{"name":"extensionDefinitions","type":"ExtensionDefinition","isReference":true,"isMany":true}]},{"name":"Definitions","superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"targetNamespace","type":"String","isAttr":true},{"name":"expressionLanguage","type":"String","isAttr":true,"default":"http://www.w3.org/1999/XPath"},{"name":"exporter","isAttr":true,"type":"String"},{"name":"exporterVersion","isAttr":true,"type":"String"},{"name":"author","isAttr":true,"type":"String"},{"name":"creationDate","type":"DateTime","isAttr":true},{"name":"imports","type":"Import","isMany":true},{"name":"caseFileItemDefinitions","type":"CaseFileItemDefinition","isMany":true},{"name":"cases","type":"Case","isMany":true},{"name":"processes","type":"Process","isMany":true},{"name":"decisions","type":"Decision","isMany":true},{"name":"extensions","type":"Extension","isMany":true},{"name":"relationships","type":"Relationship","isMany":true},{"name":"artifacts","type":"Artifact","isMany":true},{"name":"CMMNDI","type":"cmmndi:CMMNDI"}]},{"name":"DiscretionaryItem","superClass":["TableItem"],"properties":[{"name":"itemControl","type":"PlanItemControl","xml":{"serialize":"property"}},{"name":"definitionRef","type":"PlanItemDefinition","isAttr":true,"isReference":true},{"name":"name","isAttr":true,"type":"String"},{"name":"entryCriteria","type":"EntryCriterion","isMany":true},{"name":"exitCriteria","type":"ExitCriterion","isMany":true}]},{"name":"EventListener","superClass":["PlanItemDefinition"]},{"name":"Expression","superClass":["CMMNElement"],"properties":[{"name":"language","type":"String","isAttr":true},{"name":"body","isBody":true,"type":"String"}]},{"name":"HumanTask","superClass":["Task"],"properties":[{"name":"planningTable","type":"PlanningTable"},{"name":"performerRef","type":"Role","isAttr":true,"isReference":true}]},{"name":"IfPart","superClass":["CMMNElement"],"properties":[{"name":"contextRef","type":"CaseFileItem","isAttr":true,"isReference":true},{"name":"condition","type":"Expression","xml":{"serialize":"property"}}]},{"name":"Import","properties":[{"name":"location","isAttr":true,"type":"String"},{"name":"namespace","type":"String","isAttr":true},{"name":"importType","isAttr":true,"type":"String"}]},{"name":"Milestone","superClass":["PlanItemDefinition"]},{"name":"On","isAbstract":true,"superClass":["CMMNElement"]},{"name":"OnPart","isAbstract":true,"superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"}]},{"name":"Parameter","isAbstract":true,"superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"}]},{"name":"ParameterMapping","properties":[{"name":"sourceRef","type":"Parameter","isAttr":true,"isReference":true},{"name":"targetRef","type":"Parameter","isAttr":true,"isReference":true},{"name":"transformation","type":"Expression","xml":{"serialize":"property"}}]},{"name":"PlanFragment","superClass":["PlanItemDefinition"],"properties":[{"name":"planItems","type":"PlanItem","isMany":true},{"name":"sentries","type":"Sentry","isMany":true}]},{"name":"PlanItem","superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"definitionRef","type":"PlanItemDefinition","isAttr":true,"isReference":true},{"name":"itemControl","type":"PlanItemControl","xml":{"serialize":"property"}},{"name":"entryCriteria","type":"EntryCriterion","isMany":true},{"name":"exitCriteria","type":"ExitCriterion","isMany":true}]},{"name":"PlanItemControl","superClass":["CMMNElement"],"properties":[{"name":"repetitionRule","type":"RepetitionRule"},{"name":"requiredRule","type":"RequiredRule"},{"name":"manualActivationRule","type":"ManualActivationRule"}]},{"name":"PlanItemDefinition","isAbstract":true,"superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"defaultControl","type":"PlanItemControl","xml":{"serialize":"property"}}]},{"name":"PlanItemOnPart","superClass":["OnPart"],"properties":[{"name":"standardEvent","type":"String"},{"name":"sourceRef","type":"PlanItem","isAttr":true,"isReference":true},{"name":"exitCriterionRef","type":"ExitCriterion","isAttr":true,"isReference":true}]},{"name":"PlanningTable","superClass":["TableItem"],"properties":[{"name":"tableItems","type":"TableItem","isMany":true},{"name":"applicabilityRules","type":"ApplicabilityRule","isMany":true}]},{"name":"Process","superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"implementationType","type":"String","isAttr":true,"default":"http://www.omg.org/spec/CMMN/ProcessType/Unspecified"},{"name":"externalRef","type":"String","isAttr":true},{"name":"input","type":"ProcessParameter","isMany":true,"xml":{"serialize":"property"}},{"name":"output","type":"ProcessParameter","isMany":true,"xml":{"serialize":"property"}}]},{"name":"ProcessParameter","superClass":["Parameter"]},{"name":"ProcessTask","superClass":["Task"],"properties":[{"name":"parameterMapping","type":"ParameterMapping","isMany":true},{"name":"processRefExpression","type":"Expression","xml":{"serialize":"property"}},{"name":"processRef","type":"String","isAttr":true}]},{"name":"Property","superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"type","type":"String","isAttr":true,"default":"http://www.omg.org/spec/CMMN/PropertyType/Unspecified"}]},{"name":"RepetitionRule","superClass":["CMMNElement"],"properties":[{"name":"condition","type":"Expression","xml":{"serialize":"property"}},{"name":"name","isAttr":true,"type":"String"},{"name":"contextRef","type":"CaseFileItem","isAttr":true,"isReference":true}]},{"name":"RequiredRule","superClass":["CMMNElement"],"properties":[{"name":"condition","type":"Expression","xml":{"serialize":"property"}},{"name":"name","isAttr":true,"type":"String"},{"name":"contextRef","type":"CaseFileItem","isAttr":true,"isReference":true}]},{"name":"Role","superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"}]},{"name":"Sentry","superClass":["CMMNElement"],"properties":[{"name":"onParts","type":"OnPart","isMany":true},{"name":"ifPart","type":"IfPart"},{"name":"name","isAttr":true,"type":"String"}]},{"name":"Stage","superClass":["PlanFragment"],"properties":[{"name":"planningTable","type":"PlanningTable"},{"name":"planItemDefinitions","type":"PlanItemDefinition","isMany":true},{"name":"autoComplete","isAttr":true,"type":"Boolean"},{"name":"exitCriteria","type":"ExitCriterion","isMany":true}]},{"name":"TableItem","isAbstract":true,"superClass":["CMMNElement"],"properties":[{"name":"authorizedRoleRefs","type":"Role","isAttr":true,"isReference":true,"isMany":true},{"name":"applicabilityRuleRefs","type":"ApplicabilityRule","isAttr":true,"isReference":true,"isMany":true}]},{"name":"Task","superClass":["PlanItemDefinition"],"properties":[{"name":"input","type":"CaseParameter","isMany":true,"xml":{"serialize":"property"}},{"name":"output","type":"CaseParameter","isMany":true,"xml":{"serialize":"property"}},{"name":"isBlocking","isAttr":true,"default":true,"type":"Boolean"}]},{"name":"TimerEventListener","superClass":["EventListener"],"properties":[{"name":"timerExpression","type":"Expression","xml":{"serialize":"property"}},{"name":"timerStart","type":"StartTrigger"}]},{"name":"UserEventListener","superClass":["EventListener"],"properties":[{"name":"authorizedRoleRefs","type":"Role","isMany":true,"isAttr":true}]},{"name":"DateTime","superClass":[]},{"name":"StartTrigger","isAbstract":true,"superClass":["CMMNElement"]},{"name":"PlanItemStartTrigger","superClass":["StartTrigger"],"properties":[{"name":"standardEvent","type":"String","isAttr":true},{"name":"sourceRef","type":"PlanItem","isAttr":true,"isReference":true}]},{"name":"CaseFileItemStartTrigger","superClass":["StartTrigger"],"properties":[{"name":"standardEvent","type":"String","isAttr":true},{"name":"sourceRef","type":"CaseFileItem","isAttr":true,"isReference":true}]},{"name":"Extension","properties":[{"name":"mustUnderstand","default":false,"isAttr":true,"type":"Boolean"},{"name":"definition","type":"ExtensionDefinition"}]},{"name":"ExtensionDefinition","properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"extensionAttributeDefinitions","type":"ExtensionAttributeDefinition","isMany":true}]},{"name":"ExtensionAttributeDefinition","properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"type","isAttr":true,"type":"String"},{"name":"isReference","isAttr":true,"default":false,"type":"Boolean"}]},{"name":"ExtensionElements","properties":[{"name":"valueRef","isAttr":true,"isReference":true,"type":"Element"},{"name":"values","type":"Element","isMany":true},{"name":"extensionAttributeDefinition","type":"ExtensionAttributeDefinition","isAttr":true,"isReference":true}]},{"name":"Relationship","properties":[{"name":"type","isAttr":true,"type":"String"},{"name":"direction","type":"RelationshipDirection","isAttr":true},{"name":"source","isMany":true,"type":"Element"},{"name":"target","isMany":true,"type":"Element"}]},{"name":"Documentation","superClass":["CMMNElement"],"properties":[{"name":"text","type":"String","isBody":true},{"name":"textFormat","default":"text/plain","isAttr":true,"type":"String"}]},{"name":"DecisionTask","superClass":["Task"],"properties":[{"name":"mappings","type":"ParameterMapping","isMany":true},{"name":"decisionRef","type":"String","isAttr":true},{"name":"decisionRefExpression","type":"Expression","xml":{"serialize":"property"}}]},{"name":"Decision","superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"implementationType","type":"String","isAttr":true,"default":"http://www.omg.org/spec/CMMN/DecisionType/Unspecified"},{"name":"input","type":"DecisionParameter","isMany":true,"xml":{"serialize":"property"}},{"name":"output","type":"DecisionParameter","isMany":true,"xml":{"serialize":"property"}},{"name":"externalRef","type":"String","isAttr":true}]},{"name":"DecisionParameter","superClass":["Parameter"]},{"name":"Criterion","isAbstract":true,"superClass":["CMMNElement"],"properties":[{"name":"name","isAttr":true,"type":"String"},{"name":"sentryRef","type":"Sentry","isAttr":true,"isReference":true}]},{"name":"EntryCriterion","superClass":["Criterion"]},{"name":"ExitCriterion","superClass":["Criterion"]}],"emumerations":[{"name":"AssociationDirection","literalValues":[{"name":"None"},{"name":"One"},{"name":"Both"}]},{"name":"CaseFileItemTransition","literalValues":[{"name":"addChild"},{"name":"addReference"},{"name":"create"},{"name":"delete"},{"name":"removeChild"},{"name":"removeReference"},{"name":"replace"},{"name":"update"}]},{"name":"MultiplicityEnum","literalValues":[{"name":"ZeroOrOne"},{"name":"ZeroOrMore"},{"name":"ExactlyOne"},{"name":"OneOrMore"},{"name":"Unspecified"},{"name":"Unknown"}]},{"name":"PlanItemTransition","literalValues":[{"name":"close"},{"name":"complete"},{"name":"create"},{"name":"disable"},{"name":"enable"},{"name":"exit"},{"name":"fault"},{"name":"manualStart"},{"name":"occur"},{"name":"parentResume"},{"name":"parentSuspend"},{"name":"reactivate"},{"name":"reenable"},{"name":"resume"},{"name":"start"},{"name":"suspend"},{"name":"terminate"}]},{"name":"RelationshipDirection","literalValues":[{"name":"None"},{"name":"Forward"},{"name":"Backward"},{"name":"Both"}]}],"associations":[],"xml":{"tagAlias":"lowerCase","typePrefix":"t"},"prefix":"cmmn"}\');\n;// CONCATENATED MODULE: ./node_modules/cmmn-moddle/resources/cmmn/json/cmmndi.json\nconst cmmndi_namespaceObject = JSON.parse(\'{"name":"CMMNDI","uri":"http://www.omg.org/spec/CMMN/20151109/CMMNDI","types":[{"name":"CMMNDI","properties":[{"name":"diagrams","type":"CMMNDiagram","isMany":true},{"name":"styles","type":"CMMNStyle","isMany":true}]},{"name":"CMMNDiagram","properties":[{"name":"cmmnElementRef","isAttr":true,"type":"cmmn:CMMNElement","isReference":true},{"name":"Size","type":"dc:Dimension","xml":{"serialize":"xsi:type"}},{"name":"diagramElements","type":"CMMNDiagramElement","isMany":true}],"superClass":["di:Diagram"]},{"name":"CMMNDiagramElement","superClass":["di:DiagramElement"]},{"name":"CMMNShape","properties":[{"name":"cmmnElementRef","isAttr":true,"isReference":true,"type":"cmmn:CMMNElement"},{"name":"label","type":"CMMNLabel"},{"name":"isCollapsed","isAttr":true,"type":"Boolean"},{"name":"isPlanningTableCollapsed","isAttr":true,"type":"Boolean"}],"superClass":["CMMNDiagramElement","di:Shape"]},{"name":"CMMNEdge","properties":[{"name":"label","type":"CMMNLabel"},{"name":"cmmnElementRef","isAttr":true,"isReference":true,"type":"cmmn:CMMNElement"},{"name":"sourceCMMNElementRef","isAttr":true,"isReference":true,"type":"cmmn:CMMNElement"},{"name":"targetCMMNElementRef","isAttr":true,"isReference":true,"type":"cmmn:CMMNElement"},{"name":"isStandardEventVisible","type":"Boolean","isAttr":true}],"superClass":["CMMNDiagramElement","di:Edge"]},{"name":"CMMNLabel","superClass":["di:Shape"]},{"name":"CMMNStyle","properties":[{"name":"FillColor","type":"dc:Color","xml":{"serialize":"xsi:type"}},{"name":"StrokeColor","type":"dc:Color","xml":{"serialize":"xsi:type"}},{"name":"FontColor","type":"dc:Color","xml":{"serialize":"xsi:type"}},{"name":"fontFamily","type":"String","isAttr":true},{"name":"fontSize","type":"Real","isAttr":true},{"name":"fontItalic","type":"Boolean","isAttr":true},{"name":"fontBold","type":"Boolean","isAttr":true},{"name":"fontUnderline","type":"Boolean","isAttr":true},{"name":"fontStrikeThrough","type":"Boolean","isAttr":true}],"superClass":["di:Style"]}],"associations":[],"prefix":"cmmndi"}\');\n;// CONCATENATED MODULE: ./node_modules/cmmn-moddle/resources/cmmn/json/dc.json\nconst dc_namespaceObject = JSON.parse(\'{"name":"DC","uri":"http://www.omg.org/spec/CMMN/20151109/DC","types":[{"name":"rgb"},{"name":"Real"},{"name":"Color","properties":[{"name":"red","type":"rgb","isAttr":true},{"name":"green","type":"rgb","isAttr":true},{"name":"blue","type":"rgb","isAttr":true}]},{"name":"Point","properties":[{"name":"x","type":"Real","isAttr":true},{"name":"y","type":"Real","isAttr":true}]},{"name":"Dimension","properties":[{"name":"width","type":"Real","isAttr":true},{"name":"height","type":"Real","isAttr":true}]},{"name":"Bounds","properties":[{"name":"x","type":"Real","isAttr":true},{"name":"y","type":"Real","isAttr":true},{"name":"width","type":"Real","isAttr":true},{"name":"height","type":"Real","isAttr":true}]}],"prefix":"dc","associations":[]}\');\n;// CONCATENATED MODULE: ./node_modules/cmmn-moddle/resources/cmmn/json/di.json\nconst di_namespaceObject = JSON.parse(\'{"name":"DI","uri":"http://www.omg.org/spec/CMMN/20151109/DI","types":[{"name":"DiagramElement","isAbstract":true,"properties":[{"name":"extension","type":"Extension"},{"name":"style","type":"Style"},{"name":"sharedStyle","type":"Style","isReference":true,"isAttr":true},{"name":"id","type":"String","isAttr":true,"isId":true}]},{"name":"Edge","isAbstract":true,"superClass":["DiagramElement"],"properties":[{"name":"waypoint","isMany":true,"type":"dc:Point","xml":{"serialize":"xsi:type"}}]},{"name":"Diagram","isAbstract":true,"superClass":["DiagramElement"],"properties":[{"name":"name","type":"String","isAttr":true},{"name":"documentation","isAttr":true,"type":"String"},{"name":"resolution","isAttr":true,"default":300,"type":"double"}]},{"name":"Shape","isAbstract":true,"superClass":["DiagramElement"],"properties":[{"name":"bounds","type":"dc:Bounds"}]},{"name":"Style","isAbstract":true,"properties":[{"name":"extension","type":"Extension"},{"name":"id","type":"String","isAttr":true,"isId":true}]},{"name":"Extension","properties":[{"name":"values","type":"Element","isMany":true}]}],"associations":[],"prefix":"di","xml":{"tagAlias":"lowerCase"}}\');\n;// CONCATENATED MODULE: ./node_modules/cmmn-moddle/lib/simple.js\n\n\n\n\n\n\n\n\n\nvar simple_packages = {\n  cmmn: cmmn_namespaceObject,\n  cmmndi: cmmndi_namespaceObject,\n  dc: dc_namespaceObject,\n  di: di_namespaceObject\n};\n\n/* harmony default export */ function simple(additionalPackages, options) {\n  var pks = (0,index_esm/* assign */.f0)({}, simple_packages, additionalPackages);\n\n  return new CmmnModdle(pks, options);\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-moddle/index.js\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-moddle/index.js_+_18_modules?')},"./node_modules/css.escape/css.escape.js":function(module,__unused_webpack_exports,__webpack_require__){eval("/*! https://mths.be/cssescape v1.5.1 by @mathias | MIT license */\n;(function(root, factory) {\n\t// https://github.com/umdjs/umd/blob/master/returnExports.js\n\tif (true) {\n\t\t// For Node.js.\n\t\tmodule.exports = factory(root);\n\t} else {}\n}(typeof __webpack_require__.g != 'undefined' ? __webpack_require__.g : this, function(root) {\n\n\tif (root.CSS && root.CSS.escape) {\n\t\treturn root.CSS.escape;\n\t}\n\n\t// https://drafts.csswg.org/cssom/#serialize-an-identifier\n\tvar cssEscape = function(value) {\n\t\tif (arguments.length == 0) {\n\t\t\tthrow new TypeError('`CSS.escape` requires an argument.');\n\t\t}\n\t\tvar string = String(value);\n\t\tvar length = string.length;\n\t\tvar index = -1;\n\t\tvar codeUnit;\n\t\tvar result = '';\n\t\tvar firstCodeUnit = string.charCodeAt(0);\n\t\twhile (++index < length) {\n\t\t\tcodeUnit = string.charCodeAt(index);\n\t\t\t// Note: there’s no need to special-case astral symbols, surrogate\n\t\t\t// pairs, or lone surrogates.\n\n\t\t\t// If the character is NULL (U+0000), then the REPLACEMENT CHARACTER\n\t\t\t// (U+FFFD).\n\t\t\tif (codeUnit == 0x0000) {\n\t\t\t\tresult += '\\uFFFD';\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tif (\n\t\t\t\t// If the character is in the range [\\1-\\1F] (U+0001 to U+001F) or is\n\t\t\t\t// U+007F, […]\n\t\t\t\t(codeUnit >= 0x0001 && codeUnit <= 0x001F) || codeUnit == 0x007F ||\n\t\t\t\t// If the character is the first character and is in the range [0-9]\n\t\t\t\t// (U+0030 to U+0039), […]\n\t\t\t\t(index == 0 && codeUnit >= 0x0030 && codeUnit <= 0x0039) ||\n\t\t\t\t// If the character is the second character and is in the range [0-9]\n\t\t\t\t// (U+0030 to U+0039) and the first character is a `-` (U+002D), […]\n\t\t\t\t(\n\t\t\t\t\tindex == 1 &&\n\t\t\t\t\tcodeUnit >= 0x0030 && codeUnit <= 0x0039 &&\n\t\t\t\t\tfirstCodeUnit == 0x002D\n\t\t\t\t)\n\t\t\t) {\n\t\t\t\t// https://drafts.csswg.org/cssom/#escape-a-character-as-code-point\n\t\t\t\tresult += '\\\\' + codeUnit.toString(16) + ' ';\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\tif (\n\t\t\t\t// If the character is the first character and is a `-` (U+002D), and\n\t\t\t\t// there is no second character, […]\n\t\t\t\tindex == 0 &&\n\t\t\t\tlength == 1 &&\n\t\t\t\tcodeUnit == 0x002D\n\t\t\t) {\n\t\t\t\tresult += '\\\\' + string.charAt(index);\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\t// If the character is not handled by one of the above rules and is\n\t\t\t// greater than or equal to U+0080, is `-` (U+002D) or `_` (U+005F), or\n\t\t\t// is in one of the ranges [0-9] (U+0030 to U+0039), [A-Z] (U+0041 to\n\t\t\t// U+005A), or [a-z] (U+0061 to U+007A), […]\n\t\t\tif (\n\t\t\t\tcodeUnit >= 0x0080 ||\n\t\t\t\tcodeUnit == 0x002D ||\n\t\t\t\tcodeUnit == 0x005F ||\n\t\t\t\tcodeUnit >= 0x0030 && codeUnit <= 0x0039 ||\n\t\t\t\tcodeUnit >= 0x0041 && codeUnit <= 0x005A ||\n\t\t\t\tcodeUnit >= 0x0061 && codeUnit <= 0x007A\n\t\t\t) {\n\t\t\t\t// the character itself\n\t\t\t\tresult += string.charAt(index);\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\t// Otherwise, the escaped character.\n\t\t\t// https://drafts.csswg.org/cssom/#escape-a-character\n\t\t\tresult += '\\\\' + string.charAt(index);\n\n\t\t}\n\t\treturn result;\n\t};\n\n\tif (!root.CSS) {\n\t\troot.CSS = {};\n\t}\n\n\troot.CSS.escape = cssEscape;\n\treturn cssEscape;\n\n}));\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/css.escape/css.escape.js?")},"./node_modules/diagram-js-origin/node_modules/tiny-svg/dist/index.esm.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Lj\": () => (/* binding */ attr),\n/* harmony export */   \"R3\": () => (/* binding */ append),\n/* harmony export */   \"Ue\": () => (/* binding */ create)\n/* harmony export */ });\n/* unused harmony exports appendTo, classes, clear, clone, createMatrix, createPoint, createTransform, innerSVG, off, on, prepend, prependTo, remove, replace, select, selectAll, transform */\nfunction ensureImported(element, target) {\n\n  if (element.ownerDocument !== target.ownerDocument) {\n    try {\n\n      // may fail on webkit\n      return target.ownerDocument.importNode(element, true);\n    } catch (e) {\n\n      // ignore\n    }\n  }\n\n  return element;\n}\n\n/**\n * appendTo utility\n */\n\n/**\n * Append a node to a target element and return the appended node.\n *\n * @param  {SVGElement} element\n * @param  {SVGElement} target\n *\n * @return {SVGElement} the appended node\n */\nfunction appendTo(element, target) {\n  return target.appendChild(ensureImported(element, target));\n}\n\n/**\n * append utility\n */\n\n/**\n * Append a node to an element\n *\n * @param  {SVGElement} element\n * @param  {SVGElement} node\n *\n * @return {SVGElement} the element\n */\nfunction append(target, node) {\n  appendTo(node, target);\n  return target;\n}\n\n/**\n * attribute accessor utility\n */\n\nvar LENGTH_ATTR = 2;\n\nvar CSS_PROPERTIES = {\n  'alignment-baseline': 1,\n  'baseline-shift': 1,\n  'clip': 1,\n  'clip-path': 1,\n  'clip-rule': 1,\n  'color': 1,\n  'color-interpolation': 1,\n  'color-interpolation-filters': 1,\n  'color-profile': 1,\n  'color-rendering': 1,\n  'cursor': 1,\n  'direction': 1,\n  'display': 1,\n  'dominant-baseline': 1,\n  'enable-background': 1,\n  'fill': 1,\n  'fill-opacity': 1,\n  'fill-rule': 1,\n  'filter': 1,\n  'flood-color': 1,\n  'flood-opacity': 1,\n  'font': 1,\n  'font-family': 1,\n  'font-size': LENGTH_ATTR,\n  'font-size-adjust': 1,\n  'font-stretch': 1,\n  'font-style': 1,\n  'font-variant': 1,\n  'font-weight': 1,\n  'glyph-orientation-horizontal': 1,\n  'glyph-orientation-vertical': 1,\n  'image-rendering': 1,\n  'kerning': 1,\n  'letter-spacing': 1,\n  'lighting-color': 1,\n  'marker': 1,\n  'marker-end': 1,\n  'marker-mid': 1,\n  'marker-start': 1,\n  'mask': 1,\n  'opacity': 1,\n  'overflow': 1,\n  'pointer-events': 1,\n  'shape-rendering': 1,\n  'stop-color': 1,\n  'stop-opacity': 1,\n  'stroke': 1,\n  'stroke-dasharray': 1,\n  'stroke-dashoffset': 1,\n  'stroke-linecap': 1,\n  'stroke-linejoin': 1,\n  'stroke-miterlimit': 1,\n  'stroke-opacity': 1,\n  'stroke-width': LENGTH_ATTR,\n  'text-anchor': 1,\n  'text-decoration': 1,\n  'text-rendering': 1,\n  'unicode-bidi': 1,\n  'visibility': 1,\n  'word-spacing': 1,\n  'writing-mode': 1\n};\n\n\nfunction getAttribute(node, name) {\n  if (CSS_PROPERTIES[name]) {\n    return node.style[name];\n  } else {\n    return node.getAttributeNS(null, name);\n  }\n}\n\nfunction setAttribute(node, name, value) {\n  var hyphenated = name.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();\n\n  var type = CSS_PROPERTIES[hyphenated];\n\n  if (type) {\n\n    // append pixel unit, unless present\n    if (type === LENGTH_ATTR && typeof value === 'number') {\n      value = String(value) + 'px';\n    }\n\n    node.style[hyphenated] = value;\n  } else {\n    node.setAttributeNS(null, name, value);\n  }\n}\n\nfunction setAttributes(node, attrs) {\n\n  var names = Object.keys(attrs), i, name;\n\n  for (i = 0, name; (name = names[i]); i++) {\n    setAttribute(node, name, attrs[name]);\n  }\n}\n\n/**\n * Gets or sets raw attributes on a node.\n *\n * @param  {SVGElement} node\n * @param  {Object} [attrs]\n * @param  {String} [name]\n * @param  {String} [value]\n *\n * @return {String}\n */\nfunction attr(node, name, value) {\n  if (typeof name === 'string') {\n    if (value !== undefined) {\n      setAttribute(node, name, value);\n    } else {\n      return getAttribute(node, name);\n    }\n  } else {\n    setAttributes(node, name);\n  }\n\n  return node;\n}\n\n/**\r\n * Taken from https://github.com/component/classes\r\n *\r\n * Without the component bits.\r\n */\r\n\r\n/**\r\n * toString reference.\r\n */\r\n\r\nconst toString = Object.prototype.toString;\r\n\r\n/**\r\n  * Wrap `el` in a `ClassList`.\r\n  *\r\n  * @param {Element} el\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nfunction classes(el) {\r\n  return new ClassList(el);\r\n}\r\n\r\nfunction ClassList(el) {\r\n  if (!el || !el.nodeType) {\r\n    throw new Error('A DOM element reference is required');\r\n  }\r\n  this.el = el;\r\n  this.list = el.classList;\r\n}\r\n\r\n/**\r\n  * Add class `name` if not already present.\r\n  *\r\n  * @param {String} name\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.add = function(name) {\r\n  this.list.add(name);\r\n  return this;\r\n};\r\n\r\n/**\r\n  * Remove class `name` when present, or\r\n  * pass a regular expression to remove\r\n  * any which match.\r\n  *\r\n  * @param {String|RegExp} name\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.remove = function(name) {\r\n  if ('[object RegExp]' == toString.call(name)) {\r\n    return this.removeMatching(name);\r\n  }\r\n\r\n  this.list.remove(name);\r\n  return this;\r\n};\r\n\r\n/**\r\n  * Remove all classes matching `re`.\r\n  *\r\n  * @param {RegExp} re\r\n  * @return {ClassList}\r\n  * @api private\r\n  */\r\n\r\nClassList.prototype.removeMatching = function(re) {\r\n  const arr = this.array();\r\n  for (let i = 0; i < arr.length; i++) {\r\n    if (re.test(arr[i])) {\r\n      this.remove(arr[i]);\r\n    }\r\n  }\r\n  return this;\r\n};\r\n\r\n/**\r\n  * Toggle class `name`, can force state via `force`.\r\n  *\r\n  * For browsers that support classList, but do not support `force` yet,\r\n  * the mistake will be detected and corrected.\r\n  *\r\n  * @param {String} name\r\n  * @param {Boolean} force\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.toggle = function(name, force) {\r\n  if ('undefined' !== typeof force) {\r\n    if (force !== this.list.toggle(name, force)) {\r\n      this.list.toggle(name); // toggle again to correct\r\n    }\r\n  } else {\r\n    this.list.toggle(name);\r\n  }\r\n  return this;\r\n};\r\n\r\n/**\r\n  * Return an array of classes.\r\n  *\r\n  * @return {Array}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.array = function() {\r\n  return Array.from(this.list);\r\n};\r\n\r\n/**\r\n  * Check if class `name` is present.\r\n  *\r\n  * @param {String} name\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.has =\r\n ClassList.prototype.contains = function(name) {\r\n   return this.list.contains(name);\r\n };\n\nfunction remove(element) {\n  var parent = element.parentNode;\n\n  if (parent) {\n    parent.removeChild(element);\n  }\n\n  return element;\n}\n\n/**\n * Clear utility\n */\n\n/**\n * Removes all children from the given element\n *\n * @param  {DOMElement} element\n * @return {DOMElement} the element (for chaining)\n */\nfunction clear(element) {\n  var child;\n\n  while ((child = element.firstChild)) {\n    remove(child);\n  }\n\n  return element;\n}\n\nfunction clone(element) {\n  return element.cloneNode(true);\n}\n\nvar ns = {\n  svg: 'http://www.w3.org/2000/svg'\n};\n\n/**\n * DOM parsing utility\n */\n\nvar SVG_START = '<svg xmlns=\"' + ns.svg + '\"';\n\nfunction parse(svg) {\n\n  var unwrap = false;\n\n  // ensure we import a valid svg document\n  if (svg.substring(0, 4) === '<svg') {\n    if (svg.indexOf(ns.svg) === -1) {\n      svg = SVG_START + svg.substring(4);\n    }\n  } else {\n\n    // namespace svg\n    svg = SVG_START + '>' + svg + '</svg>';\n    unwrap = true;\n  }\n\n  var parsed = parseDocument(svg);\n\n  if (!unwrap) {\n    return parsed;\n  }\n\n  var fragment = document.createDocumentFragment();\n\n  var parent = parsed.firstChild;\n\n  while (parent.firstChild) {\n    fragment.appendChild(parent.firstChild);\n  }\n\n  return fragment;\n}\n\nfunction parseDocument(svg) {\n\n  var parser;\n\n  // parse\n  parser = new DOMParser();\n  parser.async = false;\n\n  return parser.parseFromString(svg, 'text/xml');\n}\n\n/**\n * Create utility for SVG elements\n */\n\n\n/**\n * Create a specific type from name or SVG markup.\n *\n * @param {String} name the name or markup of the element\n * @param {Object} [attrs] attributes to set on the element\n *\n * @returns {SVGElement}\n */\nfunction create(name, attrs) {\n  var element;\n\n  if (name.charAt(0) === '<') {\n    element = parse(name).firstChild;\n    element = document.importNode(element, true);\n  } else {\n    element = document.createElementNS(ns.svg, name);\n  }\n\n  if (attrs) {\n    attr(element, attrs);\n  }\n\n  return element;\n}\n\n/**\n * Events handling utility\n */\n\nfunction on(node, event, listener, useCapture) {\n  node.addEventListener(event, listener, useCapture);\n}\n\nfunction off(node, event, listener, useCapture) {\n  node.removeEventListener(event, listener, useCapture);\n}\n\n/**\n * Geometry helpers\n */\n\n// fake node used to instantiate svg geometry elements\nvar node = null;\n\nfunction getNode() {\n  if (node === null) {\n    node = create('svg');\n  }\n\n  return node;\n}\n\nfunction extend(object, props) {\n  var i, k, keys = Object.keys(props);\n\n  for (i = 0; (k = keys[i]); i++) {\n    object[k] = props[k];\n  }\n\n  return object;\n}\n\n\nfunction createPoint(x, y) {\n  var point = getNode().createSVGPoint();\n\n  switch (arguments.length) {\n  case 0:\n    return point;\n  case 2:\n    x = {\n      x: x,\n      y: y\n    };\n    break;\n  }\n\n  return extend(point, x);\n}\n\n/**\n * Create matrix via args.\n *\n * @example\n *\n * createMatrix({ a: 1, b: 1 });\n * createMatrix();\n * createMatrix(1, 2, 0, 0, 30, 20);\n *\n * @return {SVGMatrix}\n */\nfunction createMatrix(a, b, c, d, e, f) {\n  var matrix = getNode().createSVGMatrix();\n\n  switch (arguments.length) {\n  case 0:\n    return matrix;\n  case 1:\n    return extend(matrix, a);\n  case 6:\n    return extend(matrix, {\n      a: a,\n      b: b,\n      c: c,\n      d: d,\n      e: e,\n      f: f\n    });\n  }\n}\n\nfunction createTransform(matrix) {\n  if (matrix) {\n    return getNode().createSVGTransformFromMatrix(matrix);\n  } else {\n    return getNode().createSVGTransform();\n  }\n}\n\n/**\n * Serialization util\n */\n\nvar TEXT_ENTITIES = /([&<>]{1})/g;\nvar ATTR_ENTITIES = /([\\n\\r\"]{1})/g;\n\nvar ENTITY_REPLACEMENT = {\n  '&': '&amp;',\n  '<': '&lt;',\n  '>': '&gt;',\n  '\"': '\\''\n};\n\nfunction escape(str, pattern) {\n\n  function replaceFn(match, entity) {\n    return ENTITY_REPLACEMENT[entity] || entity;\n  }\n\n  return str.replace(pattern, replaceFn);\n}\n\nfunction serialize(node, output) {\n\n  var i, len, attrMap, attrNode, childNodes;\n\n  switch (node.nodeType) {\n\n  // TEXT\n  case 3:\n\n    // replace special XML characters\n    output.push(escape(node.textContent, TEXT_ENTITIES));\n    break;\n\n  // ELEMENT\n  case 1:\n    output.push('<', node.tagName);\n\n    if (node.hasAttributes()) {\n      attrMap = node.attributes;\n      for (i = 0, len = attrMap.length; i < len; ++i) {\n        attrNode = attrMap.item(i);\n        output.push(' ', attrNode.name, '=\"', escape(attrNode.value, ATTR_ENTITIES), '\"');\n      }\n    }\n\n    if (node.hasChildNodes()) {\n      output.push('>');\n      childNodes = node.childNodes;\n      for (i = 0, len = childNodes.length; i < len; ++i) {\n        serialize(childNodes.item(i), output);\n      }\n      output.push('</', node.tagName, '>');\n    } else {\n      output.push('/>');\n    }\n    break;\n\n  // COMMENT\n  case 8:\n    output.push('\x3c!--', escape(node.nodeValue, TEXT_ENTITIES), '--\x3e');\n    break;\n\n  // CDATA\n  case 4:\n    output.push('<![CDATA[', node.nodeValue, ']]>');\n    break;\n\n  default:\n    throw new Error('unable to handle node ' + node.nodeType);\n  }\n\n  return output;\n}\n\n/**\n * innerHTML like functionality for SVG elements.\n * based on innerSVG (https://code.google.com/p/innersvg)\n */\n\n\nfunction set(element, svg) {\n\n  var parsed = parse(svg);\n\n  // clear element contents\n  clear(element);\n\n  if (!svg) {\n    return;\n  }\n\n  if (!isFragment(parsed)) {\n\n    // extract <svg> from parsed document\n    parsed = parsed.documentElement;\n  }\n\n  var nodes = slice(parsed.childNodes);\n\n  // import + append each node\n  for (var i = 0; i < nodes.length; i++) {\n    appendTo(nodes[i], element);\n  }\n\n}\n\nfunction get(element) {\n  var child = element.firstChild,\n      output = [];\n\n  while (child) {\n    serialize(child, output);\n    child = child.nextSibling;\n  }\n\n  return output.join('');\n}\n\nfunction isFragment(node) {\n  return node.nodeName === '#document-fragment';\n}\n\nfunction innerSVG(element, svg) {\n\n  if (svg !== undefined) {\n\n    try {\n      set(element, svg);\n    } catch (e) {\n      throw new Error('error parsing SVG: ' + e.message);\n    }\n\n    return element;\n  } else {\n    return get(element);\n  }\n}\n\n\nfunction slice(arr) {\n  return Array.prototype.slice.call(arr);\n}\n\n/**\n * Selection utilities\n */\n\nfunction select(node, selector) {\n  return node.querySelector(selector);\n}\n\nfunction selectAll(node, selector) {\n  var nodes = node.querySelectorAll(selector);\n\n  return [].map.call(nodes, function(element) {\n    return element;\n  });\n}\n\n/**\n * prependTo utility\n */\n\n/**\n * Prepend a node to a target element and return the prepended node.\n *\n * @param  {SVGElement} node\n * @param  {SVGElement} target\n *\n * @return {SVGElement} the prepended node\n */\nfunction prependTo(node, target) {\n  return target.insertBefore(ensureImported(node, target), target.firstChild || null);\n}\n\n/**\n * prepend utility\n */\n\n/**\n * Prepend a node to a target element\n *\n * @param  {SVGElement} target\n * @param  {SVGElement} node\n *\n * @return {SVGElement} the target element\n */\nfunction prepend(target, node) {\n  prependTo(node, target);\n  return target;\n}\n\n/**\n * Replace utility\n */\n\nfunction replace(element, replacement) {\n  element.parentNode.replaceChild(ensureImported(replacement, element), element);\n  return replacement;\n}\n\n/**\n * transform accessor utility\n */\n\nfunction wrapMatrix(transformList, transform) {\n  if (transform instanceof SVGMatrix) {\n    return transformList.createSVGTransformFromMatrix(transform);\n  }\n\n  return transform;\n}\n\n\nfunction setTransforms(transformList, transforms) {\n  var i, t;\n\n  transformList.clear();\n\n  for (i = 0; (t = transforms[i]); i++) {\n    transformList.appendItem(wrapMatrix(transformList, t));\n  }\n}\n\n/**\n * Get or set the transforms on the given node.\n *\n * @param {SVGElement} node\n * @param  {SVGTransform|SVGMatrix|Array<SVGTransform|SVGMatrix>} [transforms]\n *\n * @return {SVGTransform} the consolidated transform\n */\nfunction transform(node, transforms) {\n  var transformList = node.transform.baseVal;\n\n  if (transforms) {\n\n    if (!Array.isArray(transforms)) {\n      transforms = [ transforms ];\n    }\n\n    setTransforms(transformList, transforms);\n  }\n\n  return transformList.consolidate();\n}\n\n\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/diagram-js-origin/node_modules/tiny-svg/dist/index.esm.js?")},"./node_modules/diagram-js/node_modules/min-dom/dist/index.esm.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"IO\": () => (/* binding */ query),\n/* harmony export */   \"Kt\": () => (/* binding */ all),\n/* harmony export */   \"cl\": () => (/* binding */ delegate)\n/* harmony export */ });\n/* unused harmony exports assignStyle, attr, classes, clear, closest, domify, event, matches, remove */\nfunction _mergeNamespaces(n, m) {\n  m.forEach(function (e) {\n    e && typeof e !== 'string' && !Array.isArray(e) && Object.keys(e).forEach(function (k) {\n      if (k !== 'default' && !(k in n)) {\n        var d = Object.getOwnPropertyDescriptor(e, k);\n        Object.defineProperty(n, k, d.get ? d : {\n          enumerable: true,\n          get: function () { return e[k]; }\n        });\n      }\n    });\n  });\n  return Object.freeze(n);\n}\n\n/**\n * Flatten array, one level deep.\n *\n * @param {Array<?>} arr\n *\n * @return {Array<?>}\n */\n\nconst nativeToString = Object.prototype.toString;\nconst nativeHasOwnProperty = Object.prototype.hasOwnProperty;\n\nfunction isUndefined(obj) {\n  return obj === undefined;\n}\n\nfunction isArray(obj) {\n  return nativeToString.call(obj) === '[object Array]';\n}\n\n/**\n * Return true, if target owns a property with the given key.\n *\n * @param {Object} target\n * @param {String} key\n *\n * @return {Boolean}\n */\nfunction has(target, key) {\n  return nativeHasOwnProperty.call(target, key);\n}\n\n\n/**\n * Iterate over collection; returning something\n * (non-undefined) will stop iteration.\n *\n * @param  {Array|Object} collection\n * @param  {Function} iterator\n *\n * @return {Object} return result that stopped the iteration\n */\nfunction forEach(collection, iterator) {\n\n  let val,\n      result;\n\n  if (isUndefined(collection)) {\n    return;\n  }\n\n  const convertKey = isArray(collection) ? toNum : identity;\n\n  for (let key in collection) {\n\n    if (has(collection, key)) {\n      val = collection[key];\n\n      result = iterator(val, convertKey(key));\n\n      if (result === false) {\n        return val;\n      }\n    }\n  }\n}\n\n\nfunction identity(arg) {\n  return arg;\n}\n\nfunction toNum(arg) {\n  return Number(arg);\n}\n\n/**\n * Assigns style attributes in a style-src compliant way.\n *\n * @param {Element} element\n * @param {...Object} styleSources\n *\n * @return {Element} the element\n */\nfunction assign(element, ...styleSources) {\n  const target = element.style;\n\n  forEach(styleSources, function(style) {\n    if (!style) {\n      return;\n    }\n\n    forEach(style, function(value, key) {\n      target[key] = value;\n    });\n  });\n\n  return element;\n}\n\n/**\n * Set attribute `name` to `val`, or get attr `name`.\n *\n * @param {Element} el\n * @param {String} name\n * @param {String} [val]\n * @api public\n */\nfunction attr(el, name, val) {\n\n  // get\n  if (arguments.length == 2) {\n    return el.getAttribute(name);\n  }\n\n  // remove\n  if (val === null) {\n    return el.removeAttribute(name);\n  }\n\n  // set\n  el.setAttribute(name, val);\n\n  return el;\n}\n\n/**\n * Taken from https://github.com/component/classes\n *\n * Without the component bits.\n */\n\n/**\n * toString reference.\n */\n\nconst toString = Object.prototype.toString;\n\n/**\n * Wrap `el` in a `ClassList`.\n *\n * @param {Element} el\n * @return {ClassList}\n * @api public\n */\n\nfunction classes(el) {\n  return new ClassList(el);\n}\n\n/**\n * Initialize a new ClassList for `el`.\n *\n * @param {Element} el\n * @api private\n */\n\nfunction ClassList(el) {\n  if (!el || !el.nodeType) {\n    throw new Error('A DOM element reference is required');\n  }\n  this.el = el;\n  this.list = el.classList;\n}\n\n/**\n * Add class `name` if not already present.\n *\n * @param {String} name\n * @return {ClassList}\n * @api public\n */\n\nClassList.prototype.add = function(name) {\n  this.list.add(name);\n  return this;\n};\n\n/**\n * Remove class `name` when present, or\n * pass a regular expression to remove\n * any which match.\n *\n * @param {String|RegExp} name\n * @return {ClassList}\n * @api public\n */\n\nClassList.prototype.remove = function(name) {\n  if ('[object RegExp]' == toString.call(name)) {\n    return this.removeMatching(name);\n  }\n\n  this.list.remove(name);\n  return this;\n};\n\n/**\n * Remove all classes matching `re`.\n *\n * @param {RegExp} re\n * @return {ClassList}\n * @api private\n */\n\nClassList.prototype.removeMatching = function(re) {\n  const arr = this.array();\n  for (let i = 0; i < arr.length; i++) {\n    if (re.test(arr[i])) {\n      this.remove(arr[i]);\n    }\n  }\n  return this;\n};\n\n/**\n * Toggle class `name`, can force state via `force`.\n *\n * For browsers that support classList, but do not support `force` yet,\n * the mistake will be detected and corrected.\n *\n * @param {String} name\n * @param {Boolean} force\n * @return {ClassList}\n * @api public\n */\n\nClassList.prototype.toggle = function(name, force) {\n  if ('undefined' !== typeof force) {\n    if (force !== this.list.toggle(name, force)) {\n      this.list.toggle(name); // toggle again to correct\n    }\n  } else {\n    this.list.toggle(name);\n  }\n  return this;\n};\n\n/**\n * Return an array of classes.\n *\n * @return {Array}\n * @api public\n */\n\nClassList.prototype.array = function() {\n  return Array.from(this.list);\n};\n\n/**\n * Check if class `name` is present.\n *\n * @param {String} name\n * @return {ClassList}\n * @api public\n */\n\nClassList.prototype.has =\nClassList.prototype.contains = function(name) {\n  return this.list.contains(name);\n};\n\n/**\n * Remove all children from the given element.\n */\nfunction clear(el) {\n\n  var c;\n\n  while (el.childNodes.length) {\n    c = el.childNodes[0];\n    el.removeChild(c);\n  }\n\n  return el;\n}\n\n/**\n * @param { HTMLElement } element\n * @param { String } selector\n *\n * @return { boolean }\n */\nfunction matches(element, selector) {\n  return element && typeof element.matches === 'function' && element.matches(selector);\n}\n\n/**\n * Closest\n *\n * @param {Element} el\n * @param {String} selector\n * @param {Boolean} checkYourSelf (optional)\n */\nfunction closest(element, selector, checkYourSelf) {\n  var currentElem = checkYourSelf ? element : element.parentNode;\n\n  while (currentElem && currentElem.nodeType !== document.DOCUMENT_NODE &&\n      currentElem.nodeType !== document.DOCUMENT_FRAGMENT_NODE) {\n\n    if (matches(currentElem, selector)) {\n      return currentElem;\n    }\n\n    currentElem = currentElem.parentNode;\n  }\n\n  return matches(currentElem, selector) ? currentElem : null;\n}\n\nvar componentEvent = {};\n\nvar bind$1 = window.addEventListener ? 'addEventListener' : 'attachEvent',\n    unbind$1 = window.removeEventListener ? 'removeEventListener' : 'detachEvent',\n    prefix = bind$1 !== 'addEventListener' ? 'on' : '';\n\n/**\n * Bind `el` event `type` to `fn`.\n *\n * @param {Element} el\n * @param {String} type\n * @param {Function} fn\n * @param {Boolean} capture\n * @return {Function}\n * @api public\n */\n\nvar bind_1 = componentEvent.bind = function(el, type, fn, capture){\n  el[bind$1](prefix + type, fn, capture || false);\n  return fn;\n};\n\n/**\n * Unbind `el` event `type`'s callback `fn`.\n *\n * @param {Element} el\n * @param {String} type\n * @param {Function} fn\n * @param {Boolean} capture\n * @return {Function}\n * @api public\n */\n\nvar unbind_1 = componentEvent.unbind = function(el, type, fn, capture){\n  el[unbind$1](prefix + type, fn, capture || false);\n  return fn;\n};\n\nvar event = /*#__PURE__*/_mergeNamespaces({\n  __proto__: null,\n  bind: bind_1,\n  unbind: unbind_1,\n  'default': componentEvent\n}, [componentEvent]);\n\n/**\n * Module dependencies.\n */\n\n/**\n * Delegate event `type` to `selector`\n * and invoke `fn(e)`. A callback function\n * is returned which may be passed to `.unbind()`.\n *\n * @param {Element} el\n * @param {String} selector\n * @param {String} type\n * @param {Function} fn\n * @param {Boolean} capture\n * @return {Function}\n * @api public\n */\n\n// Some events don't bubble, so we want to bind to the capture phase instead\n// when delegating.\nvar forceCaptureEvents = [ 'focus', 'blur' ];\n\nfunction bind(el, selector, type, fn, capture) {\n  if (forceCaptureEvents.indexOf(type) !== -1) {\n    capture = true;\n  }\n\n  return event.bind(el, type, function(e) {\n    var target = e.target || e.srcElement;\n    e.delegateTarget = closest(target, selector, true);\n    if (e.delegateTarget) {\n      fn.call(el, e);\n    }\n  }, capture);\n}\n\n/**\n * Unbind event `type`'s callback `fn`.\n *\n * @param {Element} el\n * @param {String} type\n * @param {Function} fn\n * @param {Boolean} capture\n * @api public\n */\nfunction unbind(el, type, fn, capture) {\n  if (forceCaptureEvents.indexOf(type) !== -1) {\n    capture = true;\n  }\n\n  return event.unbind(el, type, fn, capture);\n}\n\nvar delegate = {\n  bind,\n  unbind\n};\n\n/**\n * Expose `parse`.\n */\n\nvar domify = parse;\n\n/**\n * Tests for browser support.\n */\n\nvar innerHTMLBug = false;\nvar bugTestDiv;\nif (typeof document !== 'undefined') {\n  bugTestDiv = document.createElement('div');\n  // Setup\n  bugTestDiv.innerHTML = '  <link/><table></table><a href=\"/a\">a</a><input type=\"checkbox\"/>';\n  // Make sure that link elements get serialized correctly by innerHTML\n  // This requires a wrapper element in IE\n  innerHTMLBug = !bugTestDiv.getElementsByTagName('link').length;\n  bugTestDiv = undefined;\n}\n\n/**\n * Wrap map from jquery.\n */\n\nvar map = {\n  legend: [1, '<fieldset>', '</fieldset>'],\n  tr: [2, '<table><tbody>', '</tbody></table>'],\n  col: [2, '<table><tbody></tbody><colgroup>', '</colgroup></table>'],\n  // for script/link/style tags to work in IE6-8, you have to wrap\n  // in a div with a non-whitespace character in front, ha!\n  _default: innerHTMLBug ? [1, 'X<div>', '</div>'] : [0, '', '']\n};\n\nmap.td =\nmap.th = [3, '<table><tbody><tr>', '</tr></tbody></table>'];\n\nmap.option =\nmap.optgroup = [1, '<select multiple=\"multiple\">', '</select>'];\n\nmap.thead =\nmap.tbody =\nmap.colgroup =\nmap.caption =\nmap.tfoot = [1, '<table>', '</table>'];\n\nmap.polyline =\nmap.ellipse =\nmap.polygon =\nmap.circle =\nmap.text =\nmap.line =\nmap.path =\nmap.rect =\nmap.g = [1, '<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\">','</svg>'];\n\n/**\n * Parse `html` and return a DOM Node instance, which could be a TextNode,\n * HTML DOM Node of some kind (<div> for example), or a DocumentFragment\n * instance, depending on the contents of the `html` string.\n *\n * @param {String} html - HTML string to \"domify\"\n * @param {Document} doc - The `document` instance to create the Node for\n * @return {DOMNode} the TextNode, DOM Node, or DocumentFragment instance\n * @api private\n */\n\nfunction parse(html, doc) {\n  if ('string' != typeof html) throw new TypeError('String expected');\n\n  // default to the global `document` object\n  if (!doc) doc = document;\n\n  // tag name\n  var m = /<([\\w:]+)/.exec(html);\n  if (!m) return doc.createTextNode(html);\n\n  html = html.replace(/^\\s+|\\s+$/g, ''); // Remove leading/trailing whitespace\n\n  var tag = m[1];\n\n  // body support\n  if (tag == 'body') {\n    var el = doc.createElement('html');\n    el.innerHTML = html;\n    return el.removeChild(el.lastChild);\n  }\n\n  // wrap map\n  var wrap = Object.prototype.hasOwnProperty.call(map, tag) ? map[tag] : map._default;\n  var depth = wrap[0];\n  var prefix = wrap[1];\n  var suffix = wrap[2];\n  var el = doc.createElement('div');\n  el.innerHTML = prefix + html + suffix;\n  while (depth--) el = el.lastChild;\n\n  // one element\n  if (el.firstChild == el.lastChild) {\n    return el.removeChild(el.firstChild);\n  }\n\n  // several elements\n  var fragment = doc.createDocumentFragment();\n  while (el.firstChild) {\n    fragment.appendChild(el.removeChild(el.firstChild));\n  }\n\n  return fragment;\n}\n\nvar domify$1 = (/* unused pure expression or super */ null && (domify));\n\nfunction query(selector, el) {\n  el = el || document;\n\n  return el.querySelector(selector);\n}\n\nfunction all(selector, el) {\n  el = el || document;\n\n  return el.querySelectorAll(selector);\n}\n\nfunction remove(el) {\n  el.parentNode && el.parentNode.removeChild(el);\n}\n\n\n//# sourceMappingURL=index.esm.js.map\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/diagram-js/node_modules/min-dom/dist/index.esm.js?")},"./node_modules/diagram-js/node_modules/tiny-svg/dist/index.esm.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Lj\": () => (/* binding */ attr),\n/* harmony export */   \"Od\": () => (/* binding */ remove),\n/* harmony export */   \"R3\": () => (/* binding */ append),\n/* harmony export */   \"Ue\": () => (/* binding */ create)\n/* harmony export */ });\n/* unused harmony exports appendTo, classes, clear, clone, createMatrix, createPoint, createTransform, innerSVG, off, on, prepend, prependTo, replace, select, selectAll, transform */\nfunction ensureImported(element, target) {\n\n  if (element.ownerDocument !== target.ownerDocument) {\n    try {\n\n      // may fail on webkit\n      return target.ownerDocument.importNode(element, true);\n    } catch (e) {\n\n      // ignore\n    }\n  }\n\n  return element;\n}\n\n/**\n * appendTo utility\n */\n\n/**\n * Append a node to a target element and return the appended node.\n *\n * @param  {SVGElement} element\n * @param  {SVGElement} target\n *\n * @return {SVGElement} the appended node\n */\nfunction appendTo(element, target) {\n  return target.appendChild(ensureImported(element, target));\n}\n\n/**\n * append utility\n */\n\n/**\n * Append a node to an element\n *\n * @param  {SVGElement} element\n * @param  {SVGElement} node\n *\n * @return {SVGElement} the element\n */\nfunction append(target, node) {\n  appendTo(node, target);\n  return target;\n}\n\n/**\n * attribute accessor utility\n */\n\nvar LENGTH_ATTR = 2;\n\nvar CSS_PROPERTIES = {\n  'alignment-baseline': 1,\n  'baseline-shift': 1,\n  'clip': 1,\n  'clip-path': 1,\n  'clip-rule': 1,\n  'color': 1,\n  'color-interpolation': 1,\n  'color-interpolation-filters': 1,\n  'color-profile': 1,\n  'color-rendering': 1,\n  'cursor': 1,\n  'direction': 1,\n  'display': 1,\n  'dominant-baseline': 1,\n  'enable-background': 1,\n  'fill': 1,\n  'fill-opacity': 1,\n  'fill-rule': 1,\n  'filter': 1,\n  'flood-color': 1,\n  'flood-opacity': 1,\n  'font': 1,\n  'font-family': 1,\n  'font-size': LENGTH_ATTR,\n  'font-size-adjust': 1,\n  'font-stretch': 1,\n  'font-style': 1,\n  'font-variant': 1,\n  'font-weight': 1,\n  'glyph-orientation-horizontal': 1,\n  'glyph-orientation-vertical': 1,\n  'image-rendering': 1,\n  'kerning': 1,\n  'letter-spacing': 1,\n  'lighting-color': 1,\n  'marker': 1,\n  'marker-end': 1,\n  'marker-mid': 1,\n  'marker-start': 1,\n  'mask': 1,\n  'opacity': 1,\n  'overflow': 1,\n  'pointer-events': 1,\n  'shape-rendering': 1,\n  'stop-color': 1,\n  'stop-opacity': 1,\n  'stroke': 1,\n  'stroke-dasharray': 1,\n  'stroke-dashoffset': 1,\n  'stroke-linecap': 1,\n  'stroke-linejoin': 1,\n  'stroke-miterlimit': 1,\n  'stroke-opacity': 1,\n  'stroke-width': LENGTH_ATTR,\n  'text-anchor': 1,\n  'text-decoration': 1,\n  'text-rendering': 1,\n  'unicode-bidi': 1,\n  'visibility': 1,\n  'word-spacing': 1,\n  'writing-mode': 1\n};\n\n\nfunction getAttribute(node, name) {\n  if (CSS_PROPERTIES[name]) {\n    return node.style[name];\n  } else {\n    return node.getAttributeNS(null, name);\n  }\n}\n\nfunction setAttribute(node, name, value) {\n  var hyphenated = name.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();\n\n  var type = CSS_PROPERTIES[hyphenated];\n\n  if (type) {\n\n    // append pixel unit, unless present\n    if (type === LENGTH_ATTR && typeof value === 'number') {\n      value = String(value) + 'px';\n    }\n\n    node.style[hyphenated] = value;\n  } else {\n    node.setAttributeNS(null, name, value);\n  }\n}\n\nfunction setAttributes(node, attrs) {\n\n  var names = Object.keys(attrs), i, name;\n\n  for (i = 0, name; (name = names[i]); i++) {\n    setAttribute(node, name, attrs[name]);\n  }\n}\n\n/**\n * Gets or sets raw attributes on a node.\n *\n * @param  {SVGElement} node\n * @param  {Object} [attrs]\n * @param  {String} [name]\n * @param  {String} [value]\n *\n * @return {String}\n */\nfunction attr(node, name, value) {\n  if (typeof name === 'string') {\n    if (value !== undefined) {\n      setAttribute(node, name, value);\n    } else {\n      return getAttribute(node, name);\n    }\n  } else {\n    setAttributes(node, name);\n  }\n\n  return node;\n}\n\n/**\r\n * Taken from https://github.com/component/classes\r\n *\r\n * Without the component bits.\r\n */\r\n\r\n/**\r\n * toString reference.\r\n */\r\n\r\nconst toString = Object.prototype.toString;\r\n\r\n/**\r\n  * Wrap `el` in a `ClassList`.\r\n  *\r\n  * @param {Element} el\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nfunction classes(el) {\r\n  return new ClassList(el);\r\n}\r\n\r\nfunction ClassList(el) {\r\n  if (!el || !el.nodeType) {\r\n    throw new Error('A DOM element reference is required');\r\n  }\r\n  this.el = el;\r\n  this.list = el.classList;\r\n}\r\n\r\n/**\r\n  * Add class `name` if not already present.\r\n  *\r\n  * @param {String} name\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.add = function(name) {\r\n  this.list.add(name);\r\n  return this;\r\n};\r\n\r\n/**\r\n  * Remove class `name` when present, or\r\n  * pass a regular expression to remove\r\n  * any which match.\r\n  *\r\n  * @param {String|RegExp} name\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.remove = function(name) {\r\n  if ('[object RegExp]' == toString.call(name)) {\r\n    return this.removeMatching(name);\r\n  }\r\n\r\n  this.list.remove(name);\r\n  return this;\r\n};\r\n\r\n/**\r\n  * Remove all classes matching `re`.\r\n  *\r\n  * @param {RegExp} re\r\n  * @return {ClassList}\r\n  * @api private\r\n  */\r\n\r\nClassList.prototype.removeMatching = function(re) {\r\n  const arr = this.array();\r\n  for (let i = 0; i < arr.length; i++) {\r\n    if (re.test(arr[i])) {\r\n      this.remove(arr[i]);\r\n    }\r\n  }\r\n  return this;\r\n};\r\n\r\n/**\r\n  * Toggle class `name`, can force state via `force`.\r\n  *\r\n  * For browsers that support classList, but do not support `force` yet,\r\n  * the mistake will be detected and corrected.\r\n  *\r\n  * @param {String} name\r\n  * @param {Boolean} force\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.toggle = function(name, force) {\r\n  if ('undefined' !== typeof force) {\r\n    if (force !== this.list.toggle(name, force)) {\r\n      this.list.toggle(name); // toggle again to correct\r\n    }\r\n  } else {\r\n    this.list.toggle(name);\r\n  }\r\n  return this;\r\n};\r\n\r\n/**\r\n  * Return an array of classes.\r\n  *\r\n  * @return {Array}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.array = function() {\r\n  return Array.from(this.list);\r\n};\r\n\r\n/**\r\n  * Check if class `name` is present.\r\n  *\r\n  * @param {String} name\r\n  * @return {ClassList}\r\n  * @api public\r\n  */\r\n\r\nClassList.prototype.has =\r\n ClassList.prototype.contains = function(name) {\r\n   return this.list.contains(name);\r\n };\n\nfunction remove(element) {\n  var parent = element.parentNode;\n\n  if (parent) {\n    parent.removeChild(element);\n  }\n\n  return element;\n}\n\n/**\n * Clear utility\n */\n\n/**\n * Removes all children from the given element\n *\n * @param  {DOMElement} element\n * @return {DOMElement} the element (for chaining)\n */\nfunction clear(element) {\n  var child;\n\n  while ((child = element.firstChild)) {\n    remove(child);\n  }\n\n  return element;\n}\n\nfunction clone(element) {\n  return element.cloneNode(true);\n}\n\nvar ns = {\n  svg: 'http://www.w3.org/2000/svg'\n};\n\n/**\n * DOM parsing utility\n */\n\nvar SVG_START = '<svg xmlns=\"' + ns.svg + '\"';\n\nfunction parse(svg) {\n\n  var unwrap = false;\n\n  // ensure we import a valid svg document\n  if (svg.substring(0, 4) === '<svg') {\n    if (svg.indexOf(ns.svg) === -1) {\n      svg = SVG_START + svg.substring(4);\n    }\n  } else {\n\n    // namespace svg\n    svg = SVG_START + '>' + svg + '</svg>';\n    unwrap = true;\n  }\n\n  var parsed = parseDocument(svg);\n\n  if (!unwrap) {\n    return parsed;\n  }\n\n  var fragment = document.createDocumentFragment();\n\n  var parent = parsed.firstChild;\n\n  while (parent.firstChild) {\n    fragment.appendChild(parent.firstChild);\n  }\n\n  return fragment;\n}\n\nfunction parseDocument(svg) {\n\n  var parser;\n\n  // parse\n  parser = new DOMParser();\n  parser.async = false;\n\n  return parser.parseFromString(svg, 'text/xml');\n}\n\n/**\n * Create utility for SVG elements\n */\n\n\n/**\n * Create a specific type from name or SVG markup.\n *\n * @param {String} name the name or markup of the element\n * @param {Object} [attrs] attributes to set on the element\n *\n * @returns {SVGElement}\n */\nfunction create(name, attrs) {\n  var element;\n\n  if (name.charAt(0) === '<') {\n    element = parse(name).firstChild;\n    element = document.importNode(element, true);\n  } else {\n    element = document.createElementNS(ns.svg, name);\n  }\n\n  if (attrs) {\n    attr(element, attrs);\n  }\n\n  return element;\n}\n\n/**\n * Events handling utility\n */\n\nfunction on(node, event, listener, useCapture) {\n  node.addEventListener(event, listener, useCapture);\n}\n\nfunction off(node, event, listener, useCapture) {\n  node.removeEventListener(event, listener, useCapture);\n}\n\n/**\n * Geometry helpers\n */\n\n// fake node used to instantiate svg geometry elements\nvar node = null;\n\nfunction getNode() {\n  if (node === null) {\n    node = create('svg');\n  }\n\n  return node;\n}\n\nfunction extend(object, props) {\n  var i, k, keys = Object.keys(props);\n\n  for (i = 0; (k = keys[i]); i++) {\n    object[k] = props[k];\n  }\n\n  return object;\n}\n\n\nfunction createPoint(x, y) {\n  var point = getNode().createSVGPoint();\n\n  switch (arguments.length) {\n  case 0:\n    return point;\n  case 2:\n    x = {\n      x: x,\n      y: y\n    };\n    break;\n  }\n\n  return extend(point, x);\n}\n\n/**\n * Create matrix via args.\n *\n * @example\n *\n * createMatrix({ a: 1, b: 1 });\n * createMatrix();\n * createMatrix(1, 2, 0, 0, 30, 20);\n *\n * @return {SVGMatrix}\n */\nfunction createMatrix(a, b, c, d, e, f) {\n  var matrix = getNode().createSVGMatrix();\n\n  switch (arguments.length) {\n  case 0:\n    return matrix;\n  case 1:\n    return extend(matrix, a);\n  case 6:\n    return extend(matrix, {\n      a: a,\n      b: b,\n      c: c,\n      d: d,\n      e: e,\n      f: f\n    });\n  }\n}\n\nfunction createTransform(matrix) {\n  if (matrix) {\n    return getNode().createSVGTransformFromMatrix(matrix);\n  } else {\n    return getNode().createSVGTransform();\n  }\n}\n\n/**\n * Serialization util\n */\n\nvar TEXT_ENTITIES = /([&<>]{1})/g;\nvar ATTR_ENTITIES = /([\\n\\r\"]{1})/g;\n\nvar ENTITY_REPLACEMENT = {\n  '&': '&amp;',\n  '<': '&lt;',\n  '>': '&gt;',\n  '\"': '\\''\n};\n\nfunction escape(str, pattern) {\n\n  function replaceFn(match, entity) {\n    return ENTITY_REPLACEMENT[entity] || entity;\n  }\n\n  return str.replace(pattern, replaceFn);\n}\n\nfunction serialize(node, output) {\n\n  var i, len, attrMap, attrNode, childNodes;\n\n  switch (node.nodeType) {\n\n  // TEXT\n  case 3:\n\n    // replace special XML characters\n    output.push(escape(node.textContent, TEXT_ENTITIES));\n    break;\n\n  // ELEMENT\n  case 1:\n    output.push('<', node.tagName);\n\n    if (node.hasAttributes()) {\n      attrMap = node.attributes;\n      for (i = 0, len = attrMap.length; i < len; ++i) {\n        attrNode = attrMap.item(i);\n        output.push(' ', attrNode.name, '=\"', escape(attrNode.value, ATTR_ENTITIES), '\"');\n      }\n    }\n\n    if (node.hasChildNodes()) {\n      output.push('>');\n      childNodes = node.childNodes;\n      for (i = 0, len = childNodes.length; i < len; ++i) {\n        serialize(childNodes.item(i), output);\n      }\n      output.push('</', node.tagName, '>');\n    } else {\n      output.push('/>');\n    }\n    break;\n\n  // COMMENT\n  case 8:\n    output.push('\x3c!--', escape(node.nodeValue, TEXT_ENTITIES), '--\x3e');\n    break;\n\n  // CDATA\n  case 4:\n    output.push('<![CDATA[', node.nodeValue, ']]>');\n    break;\n\n  default:\n    throw new Error('unable to handle node ' + node.nodeType);\n  }\n\n  return output;\n}\n\n/**\n * innerHTML like functionality for SVG elements.\n * based on innerSVG (https://code.google.com/p/innersvg)\n */\n\n\nfunction set(element, svg) {\n\n  var parsed = parse(svg);\n\n  // clear element contents\n  clear(element);\n\n  if (!svg) {\n    return;\n  }\n\n  if (!isFragment(parsed)) {\n\n    // extract <svg> from parsed document\n    parsed = parsed.documentElement;\n  }\n\n  var nodes = slice(parsed.childNodes);\n\n  // import + append each node\n  for (var i = 0; i < nodes.length; i++) {\n    appendTo(nodes[i], element);\n  }\n\n}\n\nfunction get(element) {\n  var child = element.firstChild,\n      output = [];\n\n  while (child) {\n    serialize(child, output);\n    child = child.nextSibling;\n  }\n\n  return output.join('');\n}\n\nfunction isFragment(node) {\n  return node.nodeName === '#document-fragment';\n}\n\nfunction innerSVG(element, svg) {\n\n  if (svg !== undefined) {\n\n    try {\n      set(element, svg);\n    } catch (e) {\n      throw new Error('error parsing SVG: ' + e.message);\n    }\n\n    return element;\n  } else {\n    return get(element);\n  }\n}\n\n\nfunction slice(arr) {\n  return Array.prototype.slice.call(arr);\n}\n\n/**\n * Selection utilities\n */\n\nfunction select(node, selector) {\n  return node.querySelector(selector);\n}\n\nfunction selectAll(node, selector) {\n  var nodes = node.querySelectorAll(selector);\n\n  return [].map.call(nodes, function(element) {\n    return element;\n  });\n}\n\n/**\n * prependTo utility\n */\n\n/**\n * Prepend a node to a target element and return the prepended node.\n *\n * @param  {SVGElement} node\n * @param  {SVGElement} target\n *\n * @return {SVGElement} the prepended node\n */\nfunction prependTo(node, target) {\n  return target.insertBefore(ensureImported(node, target), target.firstChild || null);\n}\n\n/**\n * prepend utility\n */\n\n/**\n * Prepend a node to a target element\n *\n * @param  {SVGElement} target\n * @param  {SVGElement} node\n *\n * @return {SVGElement} the target element\n */\nfunction prepend(target, node) {\n  prependTo(node, target);\n  return target;\n}\n\n/**\n * Replace utility\n */\n\nfunction replace(element, replacement) {\n  element.parentNode.replaceChild(ensureImported(replacement, element), element);\n  return replacement;\n}\n\n/**\n * transform accessor utility\n */\n\nfunction wrapMatrix(transformList, transform) {\n  if (transform instanceof SVGMatrix) {\n    return transformList.createSVGTransformFromMatrix(transform);\n  }\n\n  return transform;\n}\n\n\nfunction setTransforms(transformList, transforms) {\n  var i, t;\n\n  transformList.clear();\n\n  for (i = 0; (t = transforms[i]); i++) {\n    transformList.appendItem(wrapMatrix(transformList, t));\n  }\n}\n\n/**\n * Get or set the transforms on the given node.\n *\n * @param {SVGElement} node\n * @param  {SVGTransform|SVGMatrix|Array<SVGTransform|SVGMatrix>} [transforms]\n *\n * @return {SVGTransform} the consolidated transform\n */\nfunction transform(node, transforms) {\n  var transformList = node.transform.baseVal;\n\n  if (transforms) {\n\n    if (!Array.isArray(transforms)) {\n      transforms = [ transforms ];\n    }\n\n    setTransforms(transformList, transforms);\n  }\n\n  return transformList.consolidate();\n}\n\n\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/diagram-js/node_modules/tiny-svg/dist/index.esm.js?")},"./node_modules/didi/dist/index.esm.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"zs\": () => (/* binding */ Injector)\n/* harmony export */ });\n/* unused harmony exports annotate, Module */\nvar CLASS_PATTERN = /^class /;\n\nfunction isClass(fn) {\n  return CLASS_PATTERN.test(fn.toString());\n}\n\nfunction isArray(obj) {\n  return Object.prototype.toString.call(obj) === '[object Array]';\n}\n\nfunction annotate() {\n  var args = Array.prototype.slice.call(arguments);\n\n  if (args.length === 1 && isArray(args[0])) {\n    args = args[0];\n  }\n\n  var fn = args.pop();\n\n  fn.$inject = args;\n\n  return fn;\n}\n\n// Current limitations:\n// - can't put into \"function arg\" comments\n// function /* (no parenthesis like this) */ (){}\n// function abc( /* xx (no parenthesis like this) */ a, b) {}\n//\n// Just put the comment before function or inside:\n// /* (((this is fine))) */ function(a, b) {}\n// function abc(a) { /* (((this is fine))) */}\n//\n// - can't reliably auto-annotate constructor; we'll match the\n// first constructor(...) pattern found which may be the one\n// of a nested class, too.\n\nvar CONSTRUCTOR_ARGS = /constructor\\s*[^(]*\\(\\s*([^)]*)\\)/m;\nvar FN_ARGS = /^function\\s*[^(]*\\(\\s*([^)]*)\\)/m;\nvar FN_ARG = /\\/\\*([^*]*)\\*\\//m;\n\nfunction parse(fn) {\n\n  if (typeof fn !== 'function') {\n    throw new Error('Cannot annotate \"' + fn + '\". Expected a function!');\n  }\n\n  var match = fn.toString().match(isClass(fn) ? CONSTRUCTOR_ARGS : FN_ARGS);\n\n  // may parse class without constructor\n  if (!match) {\n    return [];\n  }\n\n  return match[1] && match[1].split(',').map(function (arg) {\n    match = arg.match(FN_ARG);\n    return match ? match[1].trim() : arg.trim();\n  }) || [];\n}\n\nfunction Module() {\n  var providers = [];\n\n  this.factory = function (name, factory) {\n    providers.push([name, 'factory', factory]);\n    return this;\n  };\n\n  this.value = function (name, value) {\n    providers.push([name, 'value', value]);\n    return this;\n  };\n\n  this.type = function (name, type) {\n    providers.push([name, 'type', type]);\n    return this;\n  };\n\n  this.forEach = function (iterator) {\n    providers.forEach(iterator);\n  };\n}\n\nvar _typeof = typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; };\n\nfunction _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }\n\nfunction Injector(modules, parent) {\n  parent = parent || {\n    get: function get(name, strict) {\n      currentlyResolving.push(name);\n\n      if (strict === false) {\n        return null;\n      } else {\n        throw error('No provider for \"' + name + '\"!');\n      }\n    }\n  };\n\n  var currentlyResolving = [];\n  var providers = this._providers = Object.create(parent._providers || null);\n  var instances = this._instances = Object.create(null);\n\n  var self = instances.injector = this;\n\n  var error = function error(msg) {\n    var stack = currentlyResolving.join(' -> ');\n    currentlyResolving.length = 0;\n    return new Error(stack ? msg + ' (Resolving: ' + stack + ')' : msg);\n  };\n\n  /**\n   * Return a named service.\n   *\n   * @param {String} name\n   * @param {Boolean} [strict=true] if false, resolve missing services to null\n   *\n   * @return {Object}\n   */\n  var get = function get(name, strict) {\n    if (!providers[name] && name.indexOf('.') !== -1) {\n      var parts = name.split('.');\n      var pivot = get(parts.shift());\n\n      while (parts.length) {\n        pivot = pivot[parts.shift()];\n      }\n\n      return pivot;\n    }\n\n    if (hasProp(instances, name)) {\n      return instances[name];\n    }\n\n    if (hasProp(providers, name)) {\n      if (currentlyResolving.indexOf(name) !== -1) {\n        currentlyResolving.push(name);\n        throw error('Cannot resolve circular dependency!');\n      }\n\n      currentlyResolving.push(name);\n      instances[name] = providers[name][0](providers[name][1]);\n      currentlyResolving.pop();\n\n      return instances[name];\n    }\n\n    return parent.get(name, strict);\n  };\n\n  var fnDef = function fnDef(fn) {\n    var locals = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n\n    if (typeof fn !== 'function') {\n      if (isArray(fn)) {\n        fn = annotate(fn.slice());\n      } else {\n        throw new Error('Cannot invoke \"' + fn + '\". Expected a function!');\n      }\n    }\n\n    var inject = fn.$inject || parse(fn);\n    var dependencies = inject.map(function (dep) {\n      if (hasProp(locals, dep)) {\n        return locals[dep];\n      } else {\n        return get(dep);\n      }\n    });\n\n    return {\n      fn: fn,\n      dependencies: dependencies\n    };\n  };\n\n  var instantiate = function instantiate(Type) {\n    var _fnDef = fnDef(Type),\n        dependencies = _fnDef.dependencies,\n        fn = _fnDef.fn;\n\n    return new (Function.prototype.bind.apply(fn, [null].concat(_toConsumableArray(dependencies))))();\n  };\n\n  var invoke = function invoke(func, context, locals) {\n    var _fnDef2 = fnDef(func, locals),\n        dependencies = _fnDef2.dependencies,\n        fn = _fnDef2.fn;\n\n    return fn.call.apply(fn, [context].concat(_toConsumableArray(dependencies)));\n  };\n\n  var createPrivateInjectorFactory = function createPrivateInjectorFactory(privateChildInjector) {\n    return annotate(function (key) {\n      return privateChildInjector.get(key);\n    });\n  };\n\n  var createChild = function createChild(modules, forceNewInstances) {\n    if (forceNewInstances && forceNewInstances.length) {\n      var fromParentModule = Object.create(null);\n      var matchedScopes = Object.create(null);\n\n      var privateInjectorsCache = [];\n      var privateChildInjectors = [];\n      var privateChildFactories = [];\n\n      var provider;\n      var cacheIdx;\n      var privateChildInjector;\n      var privateChildInjectorFactory;\n      for (var name in providers) {\n        provider = providers[name];\n\n        if (forceNewInstances.indexOf(name) !== -1) {\n          if (provider[2] === 'private') {\n            cacheIdx = privateInjectorsCache.indexOf(provider[3]);\n            if (cacheIdx === -1) {\n              privateChildInjector = provider[3].createChild([], forceNewInstances);\n              privateChildInjectorFactory = createPrivateInjectorFactory(privateChildInjector);\n              privateInjectorsCache.push(provider[3]);\n              privateChildInjectors.push(privateChildInjector);\n              privateChildFactories.push(privateChildInjectorFactory);\n              fromParentModule[name] = [privateChildInjectorFactory, name, 'private', privateChildInjector];\n            } else {\n              fromParentModule[name] = [privateChildFactories[cacheIdx], name, 'private', privateChildInjectors[cacheIdx]];\n            }\n          } else {\n            fromParentModule[name] = [provider[2], provider[1]];\n          }\n          matchedScopes[name] = true;\n        }\n\n        if ((provider[2] === 'factory' || provider[2] === 'type') && provider[1].$scope) {\n          /* jshint -W083 */\n          forceNewInstances.forEach(function (scope) {\n            if (provider[1].$scope.indexOf(scope) !== -1) {\n              fromParentModule[name] = [provider[2], provider[1]];\n              matchedScopes[scope] = true;\n            }\n          });\n        }\n      }\n\n      forceNewInstances.forEach(function (scope) {\n        if (!matchedScopes[scope]) {\n          throw new Error('No provider for \"' + scope + '\". Cannot use provider from the parent!');\n        }\n      });\n\n      modules.unshift(fromParentModule);\n    }\n\n    return new Injector(modules, self);\n  };\n\n  var factoryMap = {\n    factory: invoke,\n    type: instantiate,\n    value: function value(_value) {\n      return _value;\n    }\n  };\n\n  modules.forEach(function (module) {\n\n    function arrayUnwrap(type, value) {\n      if (type !== 'value' && isArray(value)) {\n        value = annotate(value.slice());\n      }\n\n      return value;\n    }\n\n    // TODO(vojta): handle wrong inputs (modules)\n    if (module instanceof Module) {\n      module.forEach(function (provider) {\n        var name = provider[0];\n        var type = provider[1];\n        var value = provider[2];\n\n        providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];\n      });\n    } else if ((typeof module === 'undefined' ? 'undefined' : _typeof(module)) === 'object') {\n      if (module.__exports__) {\n        var clonedModule = Object.keys(module).reduce(function (m, key) {\n          if (key.substring(0, 2) !== '__') {\n            m[key] = module[key];\n          }\n          return m;\n        }, Object.create(null));\n\n        var privateInjector = new Injector((module.__modules__ || []).concat([clonedModule]), self);\n        var getFromPrivateInjector = annotate(function (key) {\n          return privateInjector.get(key);\n        });\n        module.__exports__.forEach(function (key) {\n          providers[key] = [getFromPrivateInjector, key, 'private', privateInjector];\n        });\n      } else {\n        Object.keys(module).forEach(function (name) {\n          if (module[name][2] === 'private') {\n            providers[name] = module[name];\n            return;\n          }\n\n          var type = module[name][0];\n          var value = module[name][1];\n\n          providers[name] = [factoryMap[type], arrayUnwrap(type, value), type];\n        });\n      }\n    }\n  });\n\n  // public API\n  this.get = get;\n  this.invoke = invoke;\n  this.instantiate = instantiate;\n  this.createChild = createChild;\n}\n\n// helpers /////////////////\n\nfunction hasProp(obj, prop) {\n  return Object.hasOwnProperty.call(obj, prop);\n}\n\n\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/didi/dist/index.esm.js?")},"./node_modules/file-saver/dist/FileSaver.min.js":function(module,exports,__webpack_require__){eval('var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function(a,b){if(true)!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (b),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === \'function\' ?\n\t\t(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));else {}})(this,function(){"use strict";function b(a,b){return"undefined"==typeof b?b={autoBom:!1}:"object"!=typeof b&&(console.warn("Deprecated: Expected third argument to be a object"),b={autoBom:!b}),b.autoBom&&/^\\s*(?:text\\/\\S*|application\\/xml|\\S*\\/\\S*\\+xml)\\s*;.*charset\\s*=\\s*utf-8/i.test(a.type)?new Blob(["\\uFEFF",a],{type:a.type}):a}function c(a,b,c){var d=new XMLHttpRequest;d.open("GET",a),d.responseType="blob",d.onload=function(){g(d.response,b,c)},d.onerror=function(){console.error("could not download file")},d.send()}function d(a){var b=new XMLHttpRequest;b.open("HEAD",a,!1);try{b.send()}catch(a){}return 200<=b.status&&299>=b.status}function e(a){try{a.dispatchEvent(new MouseEvent("click"))}catch(c){var b=document.createEvent("MouseEvents");b.initMouseEvent("click",!0,!0,window,0,0,0,80,20,!1,!1,!1,!1,0,null),a.dispatchEvent(b)}}var f="object"==typeof window&&window.window===window?window:"object"==typeof self&&self.self===self?self:"object"==typeof __webpack_require__.g&&__webpack_require__.g.global===__webpack_require__.g?__webpack_require__.g:void 0,a=f.navigator&&/Macintosh/.test(navigator.userAgent)&&/AppleWebKit/.test(navigator.userAgent)&&!/Safari/.test(navigator.userAgent),g=f.saveAs||("object"!=typeof window||window!==f?function(){}:"download"in HTMLAnchorElement.prototype&&!a?function(b,g,h){var i=f.URL||f.webkitURL,j=document.createElement("a");g=g||b.name||"download",j.download=g,j.rel="noopener","string"==typeof b?(j.href=b,j.origin===location.origin?e(j):d(j.href)?c(b,g,h):e(j,j.target="_blank")):(j.href=i.createObjectURL(b),setTimeout(function(){i.revokeObjectURL(j.href)},4E4),setTimeout(function(){e(j)},0))}:"msSaveOrOpenBlob"in navigator?function(f,g,h){if(g=g||f.name||"download","string"!=typeof f)navigator.msSaveOrOpenBlob(b(f,h),g);else if(d(f))c(f,g,h);else{var i=document.createElement("a");i.href=f,i.target="_blank",setTimeout(function(){e(i)})}}:function(b,d,e,g){if(g=g||open("","_blank"),g&&(g.document.title=g.document.body.innerText="downloading..."),"string"==typeof b)return c(b,d,e);var h="application/octet-stream"===b.type,i=/constructor/i.test(f.HTMLElement)||f.safari,j=/CriOS\\/[\\d]+/.test(navigator.userAgent);if((j||h&&i||a)&&"undefined"!=typeof FileReader){var k=new FileReader;k.onloadend=function(){var a=k.result;a=j?a:a.replace(/^data:[^;]*;/,"data:attachment/file;"),g?g.location.href=a:location=a,g=null},k.readAsDataURL(b)}else{var l=f.URL||f.webkitURL,m=l.createObjectURL(b);g?g.location=m:location.href=m,g=null,setTimeout(function(){l.revokeObjectURL(m)},4E4)}});f.saveAs=g.saveAs=g, true&&(module.exports=g)});\n\n//# sourceMappingURL=FileSaver.min.js.map\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/file-saver/dist/FileSaver.min.js?')},"./node_modules/hat/index.js":module=>{eval("var hat = module.exports = function (bits, base) {\n    if (!base) base = 16;\n    if (bits === undefined) bits = 128;\n    if (bits <= 0) return '0';\n    \n    var digits = Math.log(Math.pow(2, bits)) / Math.log(base);\n    for (var i = 2; digits === Infinity; i *= 2) {\n        digits = Math.log(Math.pow(2, bits / i)) / Math.log(base) * i;\n    }\n    \n    var rem = digits - Math.floor(digits);\n    \n    var res = '';\n    \n    for (var i = 0; i < Math.floor(digits); i++) {\n        var x = Math.floor(Math.random() * base).toString(base);\n        res = x + res;\n    }\n    \n    if (rem) {\n        var b = Math.pow(base, rem);\n        var x = Math.floor(Math.random() * b).toString(base);\n        res = x + res;\n    }\n    \n    var parsed = parseInt(res, base);\n    if (parsed !== Infinity && parsed >= Math.pow(2, bits)) {\n        return hat(bits, base)\n    }\n    else return res;\n};\n\nhat.rack = function (bits, base, expandBy) {\n    var fn = function (data) {\n        var iters = 0;\n        do {\n            if (iters ++ > 10) {\n                if (expandBy) bits += expandBy;\n                else throw new Error('too many ID collisions, use more bits')\n            }\n            \n            var id = hat(bits, base);\n        } while (Object.hasOwnProperty.call(hats, id));\n        \n        hats[id] = data;\n        return id;\n    };\n    var hats = fn.hats = {};\n    \n    fn.get = function (id) {\n        return fn.hats[id];\n    };\n    \n    fn.set = function (id, value) {\n        fn.hats[id] = value;\n        return fn;\n    };\n    \n    fn.bits = bits || 128;\n    fn.base = base || 16;\n    return fn;\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/hat/index.js?")},"./node_modules/ids/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar hat = __webpack_require__("./node_modules/hat/index.js");\n\n\n/**\n * Create a new id generator / cache instance.\n *\n * You may optionally provide a seed that is used internally.\n *\n * @param {Seed} seed\n */\nfunction Ids(seed) {\n\n  if (!(this instanceof Ids)) {\n    return new Ids(seed);\n  }\n\n  seed = seed || [ 128, 36, 1 ];\n  this._seed = seed.length ? hat.rack(seed[0], seed[1], seed[2]) : seed;\n}\n\nmodule.exports = Ids;\n\n/**\n * Generate a next id.\n *\n * @param {Object} [element] element to bind the id to\n *\n * @return {String} id\n */\nIds.prototype.next = function(element) {\n  return this._seed(element || true);\n};\n\n/**\n * Generate a next id with a given prefix.\n *\n * @param {Object} [element] element to bind the id to\n *\n * @return {String} id\n */\nIds.prototype.nextPrefixed = function(prefix, element) {\n  var id;\n\n  do {\n    id = prefix + this.next(true);\n  } while (this.assigned(id));\n\n  // claim {prefix}{random}\n  this.claim(id, element);\n\n  // return\n  return id;\n};\n\n/**\n * Manually claim an existing id.\n *\n * @param {String} id\n * @param {String} [element] element the id is claimed by\n */\nIds.prototype.claim = function(id, element) {\n  this._seed.set(id, element || true);\n};\n\n/**\n * Returns true if the given id has already been assigned.\n *\n * @param  {String} id\n * @return {Boolean}\n */\nIds.prototype.assigned = function(id) {\n  return this._seed.get(id) || false;\n};\n\n/**\n * Unclaim an id.\n *\n * @param  {String} id the id to unclaim\n */\nIds.prototype.unclaim = function(id) {\n  delete this._seed.hats[id];\n};\n\n\n/**\n * Clear all claimed ids.\n */\nIds.prototype.clear = function() {\n\n  var hats = this._seed.hats,\n      id;\n\n  for (id in hats) {\n    this.unclaim(id);\n  }\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/ids/index.js?')},"./node_modules/inherits/inherits_browser.js":module=>{eval("if (typeof Object.create === 'function') {\n  // implementation from standard node.js 'util' module\n  module.exports = function inherits(ctor, superCtor) {\n    if (superCtor) {\n      ctor.super_ = superCtor\n      ctor.prototype = Object.create(superCtor.prototype, {\n        constructor: {\n          value: ctor,\n          enumerable: false,\n          writable: true,\n          configurable: true\n        }\n      })\n    }\n  };\n} else {\n  // old school shim for old browsers\n  module.exports = function inherits(ctor, superCtor) {\n    if (superCtor) {\n      ctor.super_ = superCtor\n      var TempCtor = function () {}\n      TempCtor.prototype = superCtor.prototype\n      ctor.prototype = new TempCtor()\n      ctor.prototype.constructor = ctor\n    }\n  }\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/inherits/inherits_browser.js?")},"./node_modules/min-dash/dist/index.esm.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "$K": () => (/* binding */ isDefined),\n/* harmony export */   "CE": () => (/* binding */ omit),\n/* harmony export */   "Ds": () => (/* binding */ debounce),\n/* harmony export */   "Ed": () => (/* binding */ forEach),\n/* harmony export */   "G": () => (/* binding */ some),\n/* harmony export */   "HD": () => (/* binding */ isString),\n/* harmony export */   "KQ": () => (/* binding */ matchPattern),\n/* harmony export */   "Kn": () => (/* binding */ isObject),\n/* harmony export */   "MR": () => (/* binding */ sortBy),\n/* harmony export */   "UI": () => (/* binding */ map),\n/* harmony export */   "VO": () => (/* binding */ values),\n/* harmony export */   "XP": () => (/* binding */ keys),\n/* harmony export */   "ak": () => (/* binding */ bind),\n/* harmony export */   "cx": () => (/* binding */ findIndex),\n/* harmony export */   "dp": () => (/* binding */ size),\n/* harmony export */   "ei": () => (/* binding */ pick),\n/* harmony export */   "f0": () => (/* binding */ assign),\n/* harmony export */   "hX": () => (/* binding */ filter),\n/* harmony export */   "hj": () => (/* binding */ isNumber),\n/* harmony export */   "kJ": () => (/* binding */ isArray),\n/* harmony export */   "mf": () => (/* binding */ isFunction),\n/* harmony export */   "o8": () => (/* binding */ isUndefined),\n/* harmony export */   "qZ": () => (/* binding */ unionBy),\n/* harmony export */   "sE": () => (/* binding */ find),\n/* harmony export */   "u4": () => (/* binding */ reduce),\n/* harmony export */   "uw": () => (/* binding */ uniqueBy),\n/* harmony export */   "vM": () => (/* binding */ groupBy),\n/* harmony export */   "xH": () => (/* binding */ flatten),\n/* harmony export */   "yW": () => (/* binding */ every),\n/* harmony export */   "zu": () => (/* binding */ without)\n/* harmony export */ });\n/* unused harmony exports ensureArray, get, has, isNil, merge, set, throttle */\n/**\n * Flatten array, one level deep.\n *\n * @param {Array<?>} arr\n *\n * @return {Array<?>}\n */\nfunction flatten(arr) {\n  return Array.prototype.concat.apply([], arr);\n}\n\nvar nativeToString = Object.prototype.toString;\nvar nativeHasOwnProperty = Object.prototype.hasOwnProperty;\nfunction isUndefined(obj) {\n  return obj === undefined;\n}\nfunction isDefined(obj) {\n  return obj !== undefined;\n}\nfunction isNil(obj) {\n  return obj == null;\n}\nfunction isArray(obj) {\n  return nativeToString.call(obj) === \'[object Array]\';\n}\nfunction isObject(obj) {\n  return nativeToString.call(obj) === \'[object Object]\';\n}\nfunction isNumber(obj) {\n  return nativeToString.call(obj) === \'[object Number]\';\n}\nfunction isFunction(obj) {\n  var tag = nativeToString.call(obj);\n  return tag === \'[object Function]\' || tag === \'[object AsyncFunction]\' || tag === \'[object GeneratorFunction]\' || tag === \'[object AsyncGeneratorFunction]\' || tag === \'[object Proxy]\';\n}\nfunction isString(obj) {\n  return nativeToString.call(obj) === \'[object String]\';\n}\n/**\n * Ensure collection is an array.\n *\n * @param {Object} obj\n */\n\nfunction ensureArray(obj) {\n  if (isArray(obj)) {\n    return;\n  }\n\n  throw new Error(\'must supply array\');\n}\n/**\n * Return true, if target owns a property with the given key.\n *\n * @param {Object} target\n * @param {String} key\n *\n * @return {Boolean}\n */\n\nfunction has(target, key) {\n  return nativeHasOwnProperty.call(target, key);\n}\n\n/**\n * Find element in collection.\n *\n * @param  {Array|Object} collection\n * @param  {Function|Object} matcher\n *\n * @return {Object}\n */\n\nfunction find(collection, matcher) {\n  matcher = toMatcher(matcher);\n  var match;\n  forEach(collection, function (val, key) {\n    if (matcher(val, key)) {\n      match = val;\n      return false;\n    }\n  });\n  return match;\n}\n/**\n * Find element index in collection.\n *\n * @param  {Array|Object} collection\n * @param  {Function} matcher\n *\n * @return {Object}\n */\n\nfunction findIndex(collection, matcher) {\n  matcher = toMatcher(matcher);\n  var idx = isArray(collection) ? -1 : undefined;\n  forEach(collection, function (val, key) {\n    if (matcher(val, key)) {\n      idx = key;\n      return false;\n    }\n  });\n  return idx;\n}\n/**\n * Find element in collection.\n *\n * @param  {Array|Object} collection\n * @param  {Function} matcher\n *\n * @return {Array} result\n */\n\nfunction filter(collection, matcher) {\n  var result = [];\n  forEach(collection, function (val, key) {\n    if (matcher(val, key)) {\n      result.push(val);\n    }\n  });\n  return result;\n}\n/**\n * Iterate over collection; returning something\n * (non-undefined) will stop iteration.\n *\n * @param  {Array|Object} collection\n * @param  {Function} iterator\n *\n * @return {Object} return result that stopped the iteration\n */\n\nfunction forEach(collection, iterator) {\n  var val, result;\n\n  if (isUndefined(collection)) {\n    return;\n  }\n\n  var convertKey = isArray(collection) ? toNum : identity;\n\n  for (var key in collection) {\n    if (has(collection, key)) {\n      val = collection[key];\n      result = iterator(val, convertKey(key));\n\n      if (result === false) {\n        return val;\n      }\n    }\n  }\n}\n/**\n * Return collection without element.\n *\n * @param  {Array} arr\n * @param  {Function} matcher\n *\n * @return {Array}\n */\n\nfunction without(arr, matcher) {\n  if (isUndefined(arr)) {\n    return [];\n  }\n\n  ensureArray(arr);\n  matcher = toMatcher(matcher);\n  return arr.filter(function (el, idx) {\n    return !matcher(el, idx);\n  });\n}\n/**\n * Reduce collection, returning a single result.\n *\n * @param  {Object|Array} collection\n * @param  {Function} iterator\n * @param  {Any} result\n *\n * @return {Any} result returned from last iterator\n */\n\nfunction reduce(collection, iterator, result) {\n  forEach(collection, function (value, idx) {\n    result = iterator(result, value, idx);\n  });\n  return result;\n}\n/**\n * Return true if every element in the collection\n * matches the criteria.\n *\n * @param  {Object|Array} collection\n * @param  {Function} matcher\n *\n * @return {Boolean}\n */\n\nfunction every(collection, matcher) {\n  return !!reduce(collection, function (matches, val, key) {\n    return matches && matcher(val, key);\n  }, true);\n}\n/**\n * Return true if some elements in the collection\n * match the criteria.\n *\n * @param  {Object|Array} collection\n * @param  {Function} matcher\n *\n * @return {Boolean}\n */\n\nfunction some(collection, matcher) {\n  return !!find(collection, matcher);\n}\n/**\n * Transform a collection into another collection\n * by piping each member through the given fn.\n *\n * @param  {Object|Array}   collection\n * @param  {Function} fn\n *\n * @return {Array} transformed collection\n */\n\nfunction map(collection, fn) {\n  var result = [];\n  forEach(collection, function (val, key) {\n    result.push(fn(val, key));\n  });\n  return result;\n}\n/**\n * Get the collections keys.\n *\n * @param  {Object|Array} collection\n *\n * @return {Array}\n */\n\nfunction keys(collection) {\n  return collection && Object.keys(collection) || [];\n}\n/**\n * Shorthand for `keys(o).length`.\n *\n * @param  {Object|Array} collection\n *\n * @return {Number}\n */\n\nfunction size(collection) {\n  return keys(collection).length;\n}\n/**\n * Get the values in the collection.\n *\n * @param  {Object|Array} collection\n *\n * @return {Array}\n */\n\nfunction values(collection) {\n  return map(collection, function (val) {\n    return val;\n  });\n}\n/**\n * Group collection members by attribute.\n *\n * @param  {Object|Array} collection\n * @param  {Function} extractor\n *\n * @return {Object} map with { attrValue => [ a, b, c ] }\n */\n\nfunction groupBy(collection, extractor) {\n  var grouped = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};\n  extractor = toExtractor(extractor);\n  forEach(collection, function (val) {\n    var discriminator = extractor(val) || \'_\';\n    var group = grouped[discriminator];\n\n    if (!group) {\n      group = grouped[discriminator] = [];\n    }\n\n    group.push(val);\n  });\n  return grouped;\n}\nfunction uniqueBy(extractor) {\n  extractor = toExtractor(extractor);\n  var grouped = {};\n\n  for (var _len = arguments.length, collections = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n    collections[_key - 1] = arguments[_key];\n  }\n\n  forEach(collections, function (c) {\n    return groupBy(c, extractor, grouped);\n  });\n  var result = map(grouped, function (val, key) {\n    return val[0];\n  });\n  return result;\n}\nvar unionBy = (/* runtime-dependent pure expression or super */ "cmmnFreeEditor" == __webpack_require__.j ? (uniqueBy) : null);\n/**\n * Sort collection by criteria.\n *\n * @param  {Object|Array} collection\n * @param  {String|Function} extractor\n *\n * @return {Array}\n */\n\nfunction sortBy(collection, extractor) {\n  extractor = toExtractor(extractor);\n  var sorted = [];\n  forEach(collection, function (value, key) {\n    var disc = extractor(value, key);\n    var entry = {\n      d: disc,\n      v: value\n    };\n\n    for (var idx = 0; idx < sorted.length; idx++) {\n      var d = sorted[idx].d;\n\n      if (disc < d) {\n        sorted.splice(idx, 0, entry);\n        return;\n      }\n    } // not inserted, append (!)\n\n\n    sorted.push(entry);\n  });\n  return map(sorted, function (e) {\n    return e.v;\n  });\n}\n/**\n * Create an object pattern matcher.\n *\n * @example\n *\n * const matcher = matchPattern({ id: 1 });\n *\n * let element = find(elements, matcher);\n *\n * @param  {Object} pattern\n *\n * @return {Function} matcherFn\n */\n\nfunction matchPattern(pattern) {\n  return function (el) {\n    return every(pattern, function (val, key) {\n      return el[key] === val;\n    });\n  };\n}\n\nfunction toExtractor(extractor) {\n  return isFunction(extractor) ? extractor : function (e) {\n    return e[extractor];\n  };\n}\n\nfunction toMatcher(matcher) {\n  return isFunction(matcher) ? matcher : function (e) {\n    return e === matcher;\n  };\n}\n\nfunction identity(arg) {\n  return arg;\n}\n\nfunction toNum(arg) {\n  return Number(arg);\n}\n\n/**\n * Debounce fn, calling it only once if the given time\n * elapsed between calls.\n *\n * Lodash-style the function exposes methods to `#clear`\n * and `#flush` to control internal behavior.\n *\n * @param  {Function} fn\n * @param  {Number} timeout\n *\n * @return {Function} debounced function\n */\nfunction debounce(fn, timeout) {\n  var timer;\n  var lastArgs;\n  var lastThis;\n  var lastNow;\n\n  function fire(force) {\n    var now = Date.now();\n    var scheduledDiff = force ? 0 : lastNow + timeout - now;\n\n    if (scheduledDiff > 0) {\n      return schedule(scheduledDiff);\n    }\n\n    fn.apply(lastThis, lastArgs);\n    clear();\n  }\n\n  function schedule(timeout) {\n    timer = setTimeout(fire, timeout);\n  }\n\n  function clear() {\n    if (timer) {\n      clearTimeout(timer);\n    }\n\n    timer = lastNow = lastArgs = lastThis = undefined;\n  }\n\n  function flush() {\n    if (timer) {\n      fire(true);\n    }\n\n    clear();\n  }\n\n  function callback() {\n    lastNow = Date.now();\n\n    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n      args[_key] = arguments[_key];\n    }\n\n    lastArgs = args;\n    lastThis = this; // ensure an execution is scheduled\n\n    if (!timer) {\n      schedule(timeout);\n    }\n  }\n\n  callback.flush = flush;\n  callback.cancel = clear;\n  return callback;\n}\n/**\n * Throttle fn, calling at most once\n * in the given interval.\n *\n * @param  {Function} fn\n * @param  {Number} interval\n *\n * @return {Function} throttled function\n */\n\nfunction throttle(fn, interval) {\n  var throttling = false;\n  return function () {\n    if (throttling) {\n      return;\n    }\n\n    fn.apply(void 0, arguments);\n    throttling = true;\n    setTimeout(function () {\n      throttling = false;\n    }, interval);\n  };\n}\n/**\n * Bind function against target <this>.\n *\n * @param  {Function} fn\n * @param  {Object}   target\n *\n * @return {Function} bound function\n */\n\nfunction bind(fn, target) {\n  return fn.bind(target);\n}\n\nfunction _typeof(obj) {\n  "@babel/helpers - typeof";\n\n  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {\n    _typeof = function (obj) {\n      return typeof obj;\n    };\n  } else {\n    _typeof = function (obj) {\n      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;\n    };\n  }\n\n  return _typeof(obj);\n}\n\nfunction _extends() {\n  _extends = Object.assign || function (target) {\n    for (var i = 1; i < arguments.length; i++) {\n      var source = arguments[i];\n\n      for (var key in source) {\n        if (Object.prototype.hasOwnProperty.call(source, key)) {\n          target[key] = source[key];\n        }\n      }\n    }\n\n    return target;\n  };\n\n  return _extends.apply(this, arguments);\n}\n\n/**\n * Convenience wrapper for `Object.assign`.\n *\n * @param {Object} target\n * @param {...Object} others\n *\n * @return {Object} the target\n */\n\nfunction assign(target) {\n  for (var _len = arguments.length, others = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n    others[_key - 1] = arguments[_key];\n  }\n\n  return _extends.apply(void 0, [target].concat(others));\n}\n/**\n * Sets a nested property of a given object to the specified value.\n *\n * This mutates the object and returns it.\n *\n * @param {Object} target The target of the set operation.\n * @param {(string|number)[]} path The path to the nested value.\n * @param {any} value The value to set.\n */\n\nfunction set(target, path, value) {\n  var currentTarget = target;\n  forEach(path, function (key, idx) {\n    if (typeof key !== \'number\' && typeof key !== \'string\') {\n      throw new Error(\'illegal key type: \' + _typeof(key) + \'. Key should be of type number or string.\');\n    }\n\n    if (key === \'constructor\') {\n      throw new Error(\'illegal key: constructor\');\n    }\n\n    if (key === \'__proto__\') {\n      throw new Error(\'illegal key: __proto__\');\n    }\n\n    var nextKey = path[idx + 1];\n    var nextTarget = currentTarget[key];\n\n    if (isDefined(nextKey) && isNil(nextTarget)) {\n      nextTarget = currentTarget[key] = isNaN(+nextKey) ? {} : [];\n    }\n\n    if (isUndefined(nextKey)) {\n      if (isUndefined(value)) {\n        delete currentTarget[key];\n      } else {\n        currentTarget[key] = value;\n      }\n    } else {\n      currentTarget = nextTarget;\n    }\n  });\n  return target;\n}\n/**\n * Gets a nested property of a given object.\n *\n * @param {Object} target The target of the get operation.\n * @param {(string|number)[]} path The path to the nested value.\n * @param {any} [defaultValue] The value to return if no value exists.\n */\n\nfunction get(target, path, defaultValue) {\n  var currentTarget = target;\n  forEach(path, function (key) {\n    // accessing nil property yields <undefined>\n    if (isNil(currentTarget)) {\n      currentTarget = undefined;\n      return false;\n    }\n\n    currentTarget = currentTarget[key];\n  });\n  return isUndefined(currentTarget) ? defaultValue : currentTarget;\n}\n/**\n * Pick given properties from the target object.\n *\n * @param {Object} target\n * @param {Array} properties\n *\n * @return {Object} target\n */\n\nfunction pick(target, properties) {\n  var result = {};\n  var obj = Object(target);\n  forEach(properties, function (prop) {\n    if (prop in obj) {\n      result[prop] = target[prop];\n    }\n  });\n  return result;\n}\n/**\n * Pick all target properties, excluding the given ones.\n *\n * @param {Object} target\n * @param {Array} properties\n *\n * @return {Object} target\n */\n\nfunction omit(target, properties) {\n  var result = {};\n  var obj = Object(target);\n  forEach(obj, function (prop, key) {\n    if (properties.indexOf(key) === -1) {\n      result[key] = prop;\n    }\n  });\n  return result;\n}\n/**\n * Recursively merge `...sources` into given target.\n *\n * Does support merging objects; does not support merging arrays.\n *\n * @param {Object} target\n * @param {...Object} sources\n *\n * @return {Object} the target\n */\n\nfunction merge(target) {\n  for (var _len2 = arguments.length, sources = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {\n    sources[_key2 - 1] = arguments[_key2];\n  }\n\n  if (!sources.length) {\n    return target;\n  }\n\n  forEach(sources, function (source) {\n    // skip non-obj sources, i.e. null\n    if (!source || !isObject(source)) {\n      return;\n    }\n\n    forEach(source, function (sourceVal, key) {\n      if (key === \'__proto__\') {\n        return;\n      }\n\n      var targetVal = target[key];\n\n      if (isObject(sourceVal)) {\n        if (!isObject(targetVal)) {\n          // override target[key] with object\n          targetVal = {};\n        }\n\n        target[key] = merge(targetVal, sourceVal);\n      } else {\n        target[key] = sourceVal;\n      }\n    });\n  });\n  return target;\n}\n\n\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/min-dash/dist/index.esm.js?')},"./node_modules/min-dom/dist/index.esm.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"B\": () => (/* binding */ componentEvent),\n/* harmony export */   \"H6\": () => (/* binding */ domify),\n/* harmony export */   \"IO\": () => (/* binding */ query),\n/* harmony export */   \"Kt\": () => (/* binding */ all),\n/* harmony export */   \"Lj\": () => (/* binding */ attr),\n/* harmony export */   \"Od\": () => (/* binding */ remove),\n/* harmony export */   \"Sh\": () => (/* binding */ classes),\n/* harmony export */   \"ZH\": () => (/* binding */ clear),\n/* harmony export */   \"cl\": () => (/* binding */ delegate),\n/* harmony export */   \"oq\": () => (/* binding */ closest),\n/* harmony export */   \"wB\": () => (/* binding */ matchesSelector)\n/* harmony export */ });\n/**\n * Set attribute `name` to `val`, or get attr `name`.\n *\n * @param {Element} el\n * @param {String} name\n * @param {String} [val]\n * @api public\n */\nfunction attr(el, name, val) {\n  // get\n  if (arguments.length == 2) {\n    return el.getAttribute(name);\n  }\n\n  // remove\n  if (val === null) {\n    return el.removeAttribute(name);\n  }\n\n  // set\n  el.setAttribute(name, val);\n\n  return el;\n}\n\nvar indexOf = [].indexOf;\n\nvar indexof = function(arr, obj){\n  if (indexOf) return arr.indexOf(obj);\n  for (var i = 0; i < arr.length; ++i) {\n    if (arr[i] === obj) return i;\n  }\n  return -1;\n};\n\n/**\n * Taken from https://github.com/component/classes\n *\n * Without the component bits.\n */\n\n/**\n * Whitespace regexp.\n */\n\nvar re = /\\s+/;\n\n/**\n * toString reference.\n */\n\nvar toString = Object.prototype.toString;\n\n/**\n * Wrap `el` in a `ClassList`.\n *\n * @param {Element} el\n * @return {ClassList}\n * @api public\n */\n\nfunction classes(el) {\n  return new ClassList(el);\n}\n\n/**\n * Initialize a new ClassList for `el`.\n *\n * @param {Element} el\n * @api private\n */\n\nfunction ClassList(el) {\n  if (!el || !el.nodeType) {\n    throw new Error('A DOM element reference is required');\n  }\n  this.el = el;\n  this.list = el.classList;\n}\n\n/**\n * Add class `name` if not already present.\n *\n * @param {String} name\n * @return {ClassList}\n * @api public\n */\n\nClassList.prototype.add = function (name) {\n  // classList\n  if (this.list) {\n    this.list.add(name);\n    return this;\n  }\n\n  // fallback\n  var arr = this.array();\n  var i = indexof(arr, name);\n  if (!~i) arr.push(name);\n  this.el.className = arr.join(' ');\n  return this;\n};\n\n/**\n * Remove class `name` when present, or\n * pass a regular expression to remove\n * any which match.\n *\n * @param {String|RegExp} name\n * @return {ClassList}\n * @api public\n */\n\nClassList.prototype.remove = function (name) {\n  if ('[object RegExp]' == toString.call(name)) {\n    return this.removeMatching(name);\n  }\n\n  // classList\n  if (this.list) {\n    this.list.remove(name);\n    return this;\n  }\n\n  // fallback\n  var arr = this.array();\n  var i = indexof(arr, name);\n  if (~i) arr.splice(i, 1);\n  this.el.className = arr.join(' ');\n  return this;\n};\n\n/**\n * Remove all classes matching `re`.\n *\n * @param {RegExp} re\n * @return {ClassList}\n * @api private\n */\n\nClassList.prototype.removeMatching = function (re) {\n  var arr = this.array();\n  for (var i = 0; i < arr.length; i++) {\n    if (re.test(arr[i])) {\n      this.remove(arr[i]);\n    }\n  }\n  return this;\n};\n\n/**\n * Toggle class `name`, can force state via `force`.\n *\n * For browsers that support classList, but do not support `force` yet,\n * the mistake will be detected and corrected.\n *\n * @param {String} name\n * @param {Boolean} force\n * @return {ClassList}\n * @api public\n */\n\nClassList.prototype.toggle = function (name, force) {\n  // classList\n  if (this.list) {\n    if ('undefined' !== typeof force) {\n      if (force !== this.list.toggle(name, force)) {\n        this.list.toggle(name); // toggle again to correct\n      }\n    } else {\n      this.list.toggle(name);\n    }\n    return this;\n  }\n\n  // fallback\n  if ('undefined' !== typeof force) {\n    if (!force) {\n      this.remove(name);\n    } else {\n      this.add(name);\n    }\n  } else {\n    if (this.has(name)) {\n      this.remove(name);\n    } else {\n      this.add(name);\n    }\n  }\n\n  return this;\n};\n\n/**\n * Return an array of classes.\n *\n * @return {Array}\n * @api public\n */\n\nClassList.prototype.array = function () {\n  var className = this.el.getAttribute('class') || '';\n  var str = className.replace(/^\\s+|\\s+$/g, '');\n  var arr = str.split(re);\n  if ('' === arr[0]) arr.shift();\n  return arr;\n};\n\n/**\n * Check if class `name` is present.\n *\n * @param {String} name\n * @return {ClassList}\n * @api public\n */\n\nClassList.prototype.has = ClassList.prototype.contains = function (name) {\n  return this.list ? this.list.contains(name) : !!~indexof(this.array(), name);\n};\n\n/**\n * Remove all children from the given element.\n */\nfunction clear(el) {\n\n  var c;\n\n  while (el.childNodes.length) {\n    c = el.childNodes[0];\n    el.removeChild(c);\n  }\n\n  return el;\n}\n\nvar proto = typeof Element !== 'undefined' ? Element.prototype : {};\nvar vendor = proto.matches\n  || proto.matchesSelector\n  || proto.webkitMatchesSelector\n  || proto.mozMatchesSelector\n  || proto.msMatchesSelector\n  || proto.oMatchesSelector;\n\nvar matchesSelector = match;\n\n/**\n * Match `el` to `selector`.\n *\n * @param {Element} el\n * @param {String} selector\n * @return {Boolean}\n * @api public\n */\n\nfunction match(el, selector) {\n  if (!el || el.nodeType !== 1) return false;\n  if (vendor) return vendor.call(el, selector);\n  var nodes = el.parentNode.querySelectorAll(selector);\n  for (var i = 0; i < nodes.length; i++) {\n    if (nodes[i] == el) return true;\n  }\n  return false;\n}\n\n/**\n * Closest\n *\n * @param {Element} el\n * @param {String} selector\n * @param {Boolean} checkYourSelf (optional)\n */\nfunction closest (element, selector, checkYourSelf) {\n  var currentElem = checkYourSelf ? element : element.parentNode;\n\n  while (currentElem && currentElem.nodeType !== document.DOCUMENT_NODE && currentElem.nodeType !== document.DOCUMENT_FRAGMENT_NODE) {\n\n    if (matchesSelector(currentElem, selector)) {\n      return currentElem;\n    }\n\n    currentElem = currentElem.parentNode;\n  }\n\n  return matchesSelector(currentElem, selector) ? currentElem : null;\n}\n\nvar bind = window.addEventListener ? 'addEventListener' : 'attachEvent',\n    unbind = window.removeEventListener ? 'removeEventListener' : 'detachEvent',\n    prefix = bind !== 'addEventListener' ? 'on' : '';\n\n/**\n * Bind `el` event `type` to `fn`.\n *\n * @param {Element} el\n * @param {String} type\n * @param {Function} fn\n * @param {Boolean} capture\n * @return {Function}\n * @api public\n */\n\nvar bind_1 = function(el, type, fn, capture){\n  el[bind](prefix + type, fn, capture || false);\n  return fn;\n};\n\n/**\n * Unbind `el` event `type`'s callback `fn`.\n *\n * @param {Element} el\n * @param {String} type\n * @param {Function} fn\n * @param {Boolean} capture\n * @return {Function}\n * @api public\n */\n\nvar unbind_1 = function(el, type, fn, capture){\n  el[unbind](prefix + type, fn, capture || false);\n  return fn;\n};\n\nvar componentEvent = {\n\tbind: bind_1,\n\tunbind: unbind_1\n};\n\n/**\n * Module dependencies.\n */\n\n/**\n * Delegate event `type` to `selector`\n * and invoke `fn(e)`. A callback function\n * is returned which may be passed to `.unbind()`.\n *\n * @param {Element} el\n * @param {String} selector\n * @param {String} type\n * @param {Function} fn\n * @param {Boolean} capture\n * @return {Function}\n * @api public\n */\n\n// Some events don't bubble, so we want to bind to the capture phase instead\n// when delegating.\nvar forceCaptureEvents = ['focus', 'blur'];\n\nfunction bind$1(el, selector, type, fn, capture) {\n  if (forceCaptureEvents.indexOf(type) !== -1) {\n    capture = true;\n  }\n\n  return componentEvent.bind(el, type, function (e) {\n    var target = e.target || e.srcElement;\n    e.delegateTarget = closest(target, selector, true, el);\n    if (e.delegateTarget) {\n      fn.call(el, e);\n    }\n  }, capture);\n}\n\n/**\n * Unbind event `type`'s callback `fn`.\n *\n * @param {Element} el\n * @param {String} type\n * @param {Function} fn\n * @param {Boolean} capture\n * @api public\n */\nfunction unbind$1(el, type, fn, capture) {\n  if (forceCaptureEvents.indexOf(type) !== -1) {\n    capture = true;\n  }\n\n  return componentEvent.unbind(el, type, fn, capture);\n}\n\nvar delegate = {\n  bind: bind$1,\n  unbind: unbind$1\n};\n\n/**\n * Expose `parse`.\n */\n\nvar domify = parse;\n\n/**\n * Tests for browser support.\n */\n\nvar innerHTMLBug = false;\nvar bugTestDiv;\nif (typeof document !== 'undefined') {\n  bugTestDiv = document.createElement('div');\n  // Setup\n  bugTestDiv.innerHTML = '  <link/><table></table><a href=\"/a\">a</a><input type=\"checkbox\"/>';\n  // Make sure that link elements get serialized correctly by innerHTML\n  // This requires a wrapper element in IE\n  innerHTMLBug = !bugTestDiv.getElementsByTagName('link').length;\n  bugTestDiv = undefined;\n}\n\n/**\n * Wrap map from jquery.\n */\n\nvar map = {\n  legend: [1, '<fieldset>', '</fieldset>'],\n  tr: [2, '<table><tbody>', '</tbody></table>'],\n  col: [2, '<table><tbody></tbody><colgroup>', '</colgroup></table>'],\n  // for script/link/style tags to work in IE6-8, you have to wrap\n  // in a div with a non-whitespace character in front, ha!\n  _default: innerHTMLBug ? [1, 'X<div>', '</div>'] : [0, '', '']\n};\n\nmap.td =\nmap.th = [3, '<table><tbody><tr>', '</tr></tbody></table>'];\n\nmap.option =\nmap.optgroup = [1, '<select multiple=\"multiple\">', '</select>'];\n\nmap.thead =\nmap.tbody =\nmap.colgroup =\nmap.caption =\nmap.tfoot = [1, '<table>', '</table>'];\n\nmap.polyline =\nmap.ellipse =\nmap.polygon =\nmap.circle =\nmap.text =\nmap.line =\nmap.path =\nmap.rect =\nmap.g = [1, '<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\">','</svg>'];\n\n/**\n * Parse `html` and return a DOM Node instance, which could be a TextNode,\n * HTML DOM Node of some kind (<div> for example), or a DocumentFragment\n * instance, depending on the contents of the `html` string.\n *\n * @param {String} html - HTML string to \"domify\"\n * @param {Document} doc - The `document` instance to create the Node for\n * @return {DOMNode} the TextNode, DOM Node, or DocumentFragment instance\n * @api private\n */\n\nfunction parse(html, doc) {\n  if ('string' != typeof html) throw new TypeError('String expected');\n\n  // default to the global `document` object\n  if (!doc) doc = document;\n\n  // tag name\n  var m = /<([\\w:]+)/.exec(html);\n  if (!m) return doc.createTextNode(html);\n\n  html = html.replace(/^\\s+|\\s+$/g, ''); // Remove leading/trailing whitespace\n\n  var tag = m[1];\n\n  // body support\n  if (tag == 'body') {\n    var el = doc.createElement('html');\n    el.innerHTML = html;\n    return el.removeChild(el.lastChild);\n  }\n\n  // wrap map\n  var wrap = map[tag] || map._default;\n  var depth = wrap[0];\n  var prefix = wrap[1];\n  var suffix = wrap[2];\n  var el = doc.createElement('div');\n  el.innerHTML = prefix + html + suffix;\n  while (depth--) el = el.lastChild;\n\n  // one element\n  if (el.firstChild == el.lastChild) {\n    return el.removeChild(el.firstChild);\n  }\n\n  // several elements\n  var fragment = doc.createDocumentFragment();\n  while (el.firstChild) {\n    fragment.appendChild(el.removeChild(el.firstChild));\n  }\n\n  return fragment;\n}\n\nfunction query(selector, el) {\n  el = el || document;\n\n  return el.querySelector(selector);\n}\n\nfunction all(selector, el) {\n  el = el || document;\n\n  return el.querySelectorAll(selector);\n}\n\nfunction remove(el) {\n  el.parentNode && el.parentNode.removeChild(el);\n}\n\n\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/min-dom/dist/index.esm.js?")},"./node_modules/object-refs/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = __webpack_require__("./node_modules/object-refs/lib/refs.js");\n\nmodule.exports.Collection = __webpack_require__("./node_modules/object-refs/lib/collection.js");\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/object-refs/index.js?')},"./node_modules/object-refs/lib/collection.js":module=>{"use strict";eval("\n\n/**\n * An empty collection stub. Use {@link RefsCollection.extend} to extend a\n * collection with ref semantics.\n *\n * @class RefsCollection\n */\n\n/**\n * Extends a collection with {@link Refs} aware methods\n *\n * @memberof RefsCollection\n * @static\n *\n * @param  {Array<Object>} collection\n * @param  {Refs} refs instance\n * @param  {Object} property represented by the collection\n * @param  {Object} target object the collection is attached to\n *\n * @return {RefsCollection<Object>} the extended array\n */\nfunction extend(collection, refs, property, target) {\n\n  var inverseProperty = property.inverse;\n\n  /**\n   * Removes the given element from the array and returns it.\n   *\n   * @method RefsCollection#remove\n   *\n   * @param {Object} element the element to remove\n   */\n  Object.defineProperty(collection, 'remove', {\n    value: function(element) {\n      var idx = this.indexOf(element);\n      if (idx !== -1) {\n        this.splice(idx, 1);\n\n        // unset inverse\n        refs.unset(element, inverseProperty, target);\n      }\n\n      return element;\n    }\n  });\n\n  /**\n   * Returns true if the collection contains the given element\n   *\n   * @method RefsCollection#contains\n   *\n   * @param {Object} element the element to check for\n   */\n  Object.defineProperty(collection, 'contains', {\n    value: function(element) {\n      return this.indexOf(element) !== -1;\n    }\n  });\n\n  /**\n   * Adds an element to the array, unless it exists already (set semantics).\n   *\n   * @method RefsCollection#add\n   *\n   * @param {Object} element the element to add\n   * @param {Number} optional index to add element to\n   *                 (possibly moving other elements around)\n   */\n  Object.defineProperty(collection, 'add', {\n    value: function(element, idx) {\n\n      var currentIdx = this.indexOf(element);\n\n      if (typeof idx === 'undefined') {\n\n        if (currentIdx !== -1) {\n          // element already in collection (!)\n          return;\n        }\n\n        // add to end of array, as no idx is specified\n        idx = this.length;\n      }\n\n      // handle already in collection\n      if (currentIdx !== -1) {\n\n        // remove element from currentIdx\n        this.splice(currentIdx, 1);\n      }\n\n      // add element at idx\n      this.splice(idx, 0, element);\n\n      if (currentIdx === -1) {\n        // set inverse, unless element was\n        // in collection already\n        refs.set(element, inverseProperty, target);\n      }\n    }\n  });\n\n  // a simple marker, identifying this element\n  // as being a refs collection\n  Object.defineProperty(collection, '__refs_collection', {\n    value: true\n  });\n\n  return collection;\n}\n\n\nfunction isExtended(collection) {\n  return collection.__refs_collection === true;\n}\n\nmodule.exports.extend = extend;\n\nmodule.exports.isExtended = isExtended;\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/object-refs/lib/collection.js?")},"./node_modules/object-refs/lib/refs.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar Collection = __webpack_require__(\"./node_modules/object-refs/lib/collection.js\");\n\nfunction hasOwnProperty(e, property) {\n  return Object.prototype.hasOwnProperty.call(e, property.name || property);\n}\n\nfunction defineCollectionProperty(ref, property, target) {\n\n  var collection = Collection.extend(target[property.name] || [], ref, property, target);\n\n  Object.defineProperty(target, property.name, {\n    enumerable: property.enumerable,\n    value: collection\n  });\n\n  if (collection.length) {\n\n    collection.forEach(function(o) {\n      ref.set(o, property.inverse, target);\n    });\n  }\n}\n\n\nfunction defineProperty(ref, property, target) {\n\n  var inverseProperty = property.inverse;\n\n  var _value = target[property.name];\n\n  Object.defineProperty(target, property.name, {\n    configurable: property.configurable,\n    enumerable: property.enumerable,\n\n    get: function() {\n      return _value;\n    },\n\n    set: function(value) {\n\n      // return if we already performed all changes\n      if (value === _value) {\n        return;\n      }\n\n      var old = _value;\n\n      // temporary set null\n      _value = null;\n\n      if (old) {\n        ref.unset(old, inverseProperty, target);\n      }\n\n      // set new value\n      _value = value;\n\n      // set inverse value\n      ref.set(_value, inverseProperty, target);\n    }\n  });\n\n}\n\n/**\n * Creates a new references object defining two inversly related\n * attribute descriptors a and b.\n *\n * <p>\n *   When bound to an object using {@link Refs#bind} the references\n *   get activated and ensure that add and remove operations are applied\n *   reversely, too.\n * </p>\n *\n * <p>\n *   For attributes represented as collections {@link Refs} provides the\n *   {@link RefsCollection#add}, {@link RefsCollection#remove} and {@link RefsCollection#contains} extensions\n *   that must be used to properly hook into the inverse change mechanism.\n * </p>\n *\n * @class Refs\n *\n * @classdesc A bi-directional reference between two attributes.\n *\n * @param {Refs.AttributeDescriptor} a property descriptor\n * @param {Refs.AttributeDescriptor} b property descriptor\n *\n * @example\n *\n * var refs = Refs({ name: 'wheels', collection: true, enumerable: true }, { name: 'car' });\n *\n * var car = { name: 'toyota' };\n * var wheels = [{ pos: 'front-left' }, { pos: 'front-right' }];\n *\n * refs.bind(car, 'wheels');\n *\n * car.wheels // []\n * car.wheels.add(wheels[0]);\n * car.wheels.add(wheels[1]);\n *\n * car.wheels // [{ pos: 'front-left' }, { pos: 'front-right' }]\n *\n * wheels[0].car // { name: 'toyota' };\n * car.wheels.remove(wheels[0]);\n *\n * wheels[0].car // undefined\n */\nfunction Refs(a, b) {\n\n  if (!(this instanceof Refs)) {\n    return new Refs(a, b);\n  }\n\n  // link\n  a.inverse = b;\n  b.inverse = a;\n\n  this.props = {};\n  this.props[a.name] = a;\n  this.props[b.name] = b;\n}\n\n/**\n * Binds one side of a bi-directional reference to a\n * target object.\n *\n * @memberOf Refs\n *\n * @param  {Object} target\n * @param  {String} property\n */\nRefs.prototype.bind = function(target, property) {\n  if (typeof property === 'string') {\n    if (!this.props[property]) {\n      throw new Error('no property <' + property + '> in ref');\n    }\n    property = this.props[property];\n  }\n\n  if (property.collection) {\n    defineCollectionProperty(this, property, target);\n  } else {\n    defineProperty(this, property, target);\n  }\n};\n\nRefs.prototype.ensureRefsCollection = function(target, property) {\n\n  var collection = target[property.name];\n\n  if (!Collection.isExtended(collection)) {\n    defineCollectionProperty(this, property, target);\n  }\n\n  return collection;\n};\n\nRefs.prototype.ensureBound = function(target, property) {\n  if (!hasOwnProperty(target, property)) {\n    this.bind(target, property);\n  }\n};\n\nRefs.prototype.unset = function(target, property, value) {\n\n  if (target) {\n    this.ensureBound(target, property);\n\n    if (property.collection) {\n      this.ensureRefsCollection(target, property).remove(value);\n    } else {\n      target[property.name] = undefined;\n    }\n  }\n};\n\nRefs.prototype.set = function(target, property, value) {\n\n  if (target) {\n    this.ensureBound(target, property);\n\n    if (property.collection) {\n      this.ensureRefsCollection(target, property).add(value);\n    } else {\n      target[property.name] = value;\n    }\n  }\n};\n\nmodule.exports = Refs;\n\n\n/**\n * An attribute descriptor to be used specify an attribute in a {@link Refs} instance\n *\n * @typedef {Object} Refs.AttributeDescriptor\n * @property {String} name\n * @property {boolean} [collection=false]\n * @property {boolean} [enumerable=false]\n */\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/object-refs/lib/refs.js?")},"./node_modules/path-intersection/intersect.js":module=>{"use strict";eval("\n\n/**\n * This file contains portions that got extraced from Snap.svg (licensed Apache-2.0).\n *\n * @see https://github.com/adobe-webplatform/Snap.svg/blob/master/src/path.js\n */\n\n/* eslint no-fallthrough: \"off\" */\n\nvar has = 'hasOwnProperty',\n    p2s = /,?([a-z]),?/gi,\n    toFloat = parseFloat,\n    math = Math,\n    PI = math.PI,\n    mmin = math.min,\n    mmax = math.max,\n    pow = math.pow,\n    abs = math.abs,\n    pathCommand = /([a-z])[\\s,]*((-?\\d*\\.?\\d*(?:e[-+]?\\d+)?[\\s]*,?[\\s]*)+)/ig,\n    pathValues = /(-?\\d*\\.?\\d*(?:e[-+]?\\\\d+)?)[\\s]*,?[\\s]*/ig;\n\nfunction is(o, type) {\n  type = String.prototype.toLowerCase.call(type);\n\n  if (type == 'finite') {\n    return isFinite(o);\n  }\n\n  if (type == 'array' && (o instanceof Array || Array.isArray && Array.isArray(o))) {\n    return true;\n  }\n\n  return (type == 'null' && o === null) ||\n         (type == typeof o && o !== null) ||\n         (type == 'object' && o === Object(o)) ||\n         Object.prototype.toString.call(o).slice(8, -1).toLowerCase() == type;\n}\n\nfunction clone(obj) {\n\n  if (typeof obj == 'function' || Object(obj) !== obj) {\n    return obj;\n  }\n\n  var res = new obj.constructor;\n\n  for (var key in obj) if (obj[has](key)) {\n    res[key] = clone(obj[key]);\n  }\n\n  return res;\n}\n\nfunction repush(array, item) {\n  for (var i = 0, ii = array.length; i < ii; i++) if (array[i] === item) {\n    return array.push(array.splice(i, 1)[0]);\n  }\n}\n\nfunction cacher(f, scope, postprocessor) {\n\n  function newf() {\n\n    var arg = Array.prototype.slice.call(arguments, 0),\n        args = arg.join('\\u2400'),\n        cache = newf.cache = newf.cache || {},\n        count = newf.count = newf.count || [];\n\n    if (cache[has](args)) {\n      repush(count, args);\n      return postprocessor ? postprocessor(cache[args]) : cache[args];\n    }\n\n    count.length >= 1e3 && delete cache[count.shift()];\n    count.push(args);\n    cache[args] = f.apply(scope, arg);\n\n    return postprocessor ? postprocessor(cache[args]) : cache[args];\n  }\n  return newf;\n}\n\nfunction parsePathString(pathString) {\n\n  if (!pathString) {\n    return null;\n  }\n\n  var pth = paths(pathString);\n\n  if (pth.arr) {\n    return clone(pth.arr);\n  }\n\n  var paramCounts = { a: 7, c: 6, o: 2, h: 1, l: 2, m: 2, r: 4, q: 4, s: 4, t: 2, v: 1, u: 3, z: 0 },\n      data = [];\n\n  if (is(pathString, 'array') && is(pathString[0], 'array')) { // rough assumption\n    data = clone(pathString);\n  }\n\n  if (!data.length) {\n\n    String(pathString).replace(pathCommand, function(a, b, c) {\n      var params = [],\n          name = b.toLowerCase();\n\n      c.replace(pathValues, function(a, b) {\n        b && params.push(+b);\n      });\n\n      if (name == 'm' && params.length > 2) {\n        data.push([b].concat(params.splice(0, 2)));\n        name = 'l';\n        b = b == 'm' ? 'l' : 'L';\n      }\n\n      if (name == 'o' && params.length == 1) {\n        data.push([b, params[0]]);\n      }\n\n      if (name == 'r') {\n        data.push([b].concat(params));\n      } else while (params.length >= paramCounts[name]) {\n        data.push([b].concat(params.splice(0, paramCounts[name])));\n        if (!paramCounts[name]) {\n          break;\n        }\n      }\n    });\n  }\n\n  data.toString = paths.toString;\n  pth.arr = clone(data);\n\n  return data;\n}\n\nfunction paths(ps) {\n  var p = paths.ps = paths.ps || {};\n\n  if (p[ps]) {\n    p[ps].sleep = 100;\n  } else {\n    p[ps] = {\n      sleep: 100\n    };\n  }\n\n  setTimeout(function() {\n    for (var key in p) if (p[has](key) && key != ps) {\n      p[key].sleep--;\n      !p[key].sleep && delete p[key];\n    }\n  });\n\n  return p[ps];\n}\n\nfunction box(x, y, width, height) {\n  if (x == null) {\n    x = y = width = height = 0;\n  }\n\n  if (y == null) {\n    y = x.y;\n    width = x.width;\n    height = x.height;\n    x = x.x;\n  }\n\n  return {\n    x: x,\n    y: y,\n    width: width,\n    w: width,\n    height: height,\n    h: height,\n    x2: x + width,\n    y2: y + height,\n    cx: x + width / 2,\n    cy: y + height / 2,\n    r1: math.min(width, height) / 2,\n    r2: math.max(width, height) / 2,\n    r0: math.sqrt(width * width + height * height) / 2,\n    path: rectPath(x, y, width, height),\n    vb: [x, y, width, height].join(' ')\n  };\n}\n\nfunction pathToString() {\n  return this.join(',').replace(p2s, '$1');\n}\n\nfunction pathClone(pathArray) {\n  var res = clone(pathArray);\n  res.toString = pathToString;\n  return res;\n}\n\nfunction findDotsAtSegment(p1x, p1y, c1x, c1y, c2x, c2y, p2x, p2y, t) {\n  var t1 = 1 - t,\n      t13 = pow(t1, 3),\n      t12 = pow(t1, 2),\n      t2 = t * t,\n      t3 = t2 * t,\n      x = t13 * p1x + t12 * 3 * t * c1x + t1 * 3 * t * t * c2x + t3 * p2x,\n      y = t13 * p1y + t12 * 3 * t * c1y + t1 * 3 * t * t * c2y + t3 * p2y,\n      mx = p1x + 2 * t * (c1x - p1x) + t2 * (c2x - 2 * c1x + p1x),\n      my = p1y + 2 * t * (c1y - p1y) + t2 * (c2y - 2 * c1y + p1y),\n      nx = c1x + 2 * t * (c2x - c1x) + t2 * (p2x - 2 * c2x + c1x),\n      ny = c1y + 2 * t * (c2y - c1y) + t2 * (p2y - 2 * c2y + c1y),\n      ax = t1 * p1x + t * c1x,\n      ay = t1 * p1y + t * c1y,\n      cx = t1 * c2x + t * p2x,\n      cy = t1 * c2y + t * p2y,\n      alpha = (90 - math.atan2(mx - nx, my - ny) * 180 / PI);\n\n  return {\n    x: x,\n    y: y,\n    m: { x: mx, y: my },\n    n: { x: nx, y: ny },\n    start: { x: ax, y: ay },\n    end: { x: cx, y: cy },\n    alpha: alpha\n  };\n}\n\nfunction bezierBBox(p1x, p1y, c1x, c1y, c2x, c2y, p2x, p2y) {\n\n  if (!is(p1x, 'array')) {\n    p1x = [p1x, p1y, c1x, c1y, c2x, c2y, p2x, p2y];\n  }\n\n  var bbox = curveBBox.apply(null, p1x);\n\n  return box(\n    bbox.min.x,\n    bbox.min.y,\n    bbox.max.x - bbox.min.x,\n    bbox.max.y - bbox.min.y\n  );\n}\n\nfunction isPointInsideBBox(bbox, x, y) {\n  return x >= bbox.x &&\n    x <= bbox.x + bbox.width &&\n    y >= bbox.y &&\n    y <= bbox.y + bbox.height;\n}\n\nfunction isBBoxIntersect(bbox1, bbox2) {\n  bbox1 = box(bbox1);\n  bbox2 = box(bbox2);\n  return isPointInsideBBox(bbox2, bbox1.x, bbox1.y)\n    || isPointInsideBBox(bbox2, bbox1.x2, bbox1.y)\n    || isPointInsideBBox(bbox2, bbox1.x, bbox1.y2)\n    || isPointInsideBBox(bbox2, bbox1.x2, bbox1.y2)\n    || isPointInsideBBox(bbox1, bbox2.x, bbox2.y)\n    || isPointInsideBBox(bbox1, bbox2.x2, bbox2.y)\n    || isPointInsideBBox(bbox1, bbox2.x, bbox2.y2)\n    || isPointInsideBBox(bbox1, bbox2.x2, bbox2.y2)\n    || (bbox1.x < bbox2.x2 && bbox1.x > bbox2.x\n        || bbox2.x < bbox1.x2 && bbox2.x > bbox1.x)\n    && (bbox1.y < bbox2.y2 && bbox1.y > bbox2.y\n        || bbox2.y < bbox1.y2 && bbox2.y > bbox1.y);\n}\n\nfunction base3(t, p1, p2, p3, p4) {\n  var t1 = -3 * p1 + 9 * p2 - 9 * p3 + 3 * p4,\n      t2 = t * t1 + 6 * p1 - 12 * p2 + 6 * p3;\n  return t * t2 - 3 * p1 + 3 * p2;\n}\n\nfunction bezlen(x1, y1, x2, y2, x3, y3, x4, y4, z) {\n\n  if (z == null) {\n    z = 1;\n  }\n\n  z = z > 1 ? 1 : z < 0 ? 0 : z;\n\n  var z2 = z / 2,\n      n = 12,\n      Tvalues = [-.1252,.1252,-.3678,.3678,-.5873,.5873,-.7699,.7699,-.9041,.9041,-.9816,.9816],\n      Cvalues = [0.2491,0.2491,0.2335,0.2335,0.2032,0.2032,0.1601,0.1601,0.1069,0.1069,0.0472,0.0472],\n      sum = 0;\n\n  for (var i = 0; i < n; i++) {\n    var ct = z2 * Tvalues[i] + z2,\n        xbase = base3(ct, x1, x2, x3, x4),\n        ybase = base3(ct, y1, y2, y3, y4),\n        comb = xbase * xbase + ybase * ybase;\n\n    sum += Cvalues[i] * math.sqrt(comb);\n  }\n\n  return z2 * sum;\n}\n\n\nfunction intersectLines(x1, y1, x2, y2, x3, y3, x4, y4) {\n\n  if (\n    mmax(x1, x2) < mmin(x3, x4) ||\n      mmin(x1, x2) > mmax(x3, x4) ||\n      mmax(y1, y2) < mmin(y3, y4) ||\n      mmin(y1, y2) > mmax(y3, y4)\n  ) {\n    return;\n  }\n\n  var nx = (x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4),\n      ny = (x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4),\n      denominator = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);\n\n  if (!denominator) {\n    return;\n  }\n\n  var px = nx / denominator,\n      py = ny / denominator,\n      px2 = +px.toFixed(2),\n      py2 = +py.toFixed(2);\n\n  if (\n    px2 < +mmin(x1, x2).toFixed(2) ||\n      px2 > +mmax(x1, x2).toFixed(2) ||\n      px2 < +mmin(x3, x4).toFixed(2) ||\n      px2 > +mmax(x3, x4).toFixed(2) ||\n      py2 < +mmin(y1, y2).toFixed(2) ||\n      py2 > +mmax(y1, y2).toFixed(2) ||\n      py2 < +mmin(y3, y4).toFixed(2) ||\n      py2 > +mmax(y3, y4).toFixed(2)\n  ) {\n    return;\n  }\n\n  return { x: px, y: py };\n}\n\nfunction findBezierIntersections(bez1, bez2, justCount) {\n  var bbox1 = bezierBBox(bez1),\n      bbox2 = bezierBBox(bez2);\n\n  if (!isBBoxIntersect(bbox1, bbox2)) {\n    return justCount ? 0 : [];\n  }\n\n  var l1 = bezlen.apply(0, bez1),\n      l2 = bezlen.apply(0, bez2),\n      n1 = ~~(l1 / 5),\n      n2 = ~~(l2 / 5),\n      dots1 = [],\n      dots2 = [],\n      xy = {},\n      res = justCount ? 0 : [];\n\n  for (var i = 0; i < n1 + 1; i++) {\n    var p = findDotsAtSegment.apply(0, bez1.concat(i / n1));\n    dots1.push({ x: p.x, y: p.y, t: i / n1 });\n  }\n\n  for (i = 0; i < n2 + 1; i++) {\n    p = findDotsAtSegment.apply(0, bez2.concat(i / n2));\n    dots2.push({ x: p.x, y: p.y, t: i / n2 });\n  }\n\n  for (i = 0; i < n1; i++) {\n\n    for (var j = 0; j < n2; j++) {\n      var di = dots1[i],\n          di1 = dots1[i + 1],\n          dj = dots2[j],\n          dj1 = dots2[j + 1],\n          ci = abs(di1.x - di.x) < .01 ? 'y' : 'x',\n          cj = abs(dj1.x - dj.x) < .01 ? 'y' : 'x',\n          is = intersectLines(di.x, di.y, di1.x, di1.y, dj.x, dj.y, dj1.x, dj1.y);\n\n      if (is) {\n\n        if (xy[is.x.toFixed(0)] == is.y.toFixed(0)) {\n          continue;\n        }\n\n        xy[is.x.toFixed(0)] = is.y.toFixed(0);\n\n        var t1 = di.t + abs((is[ci] - di[ci]) / (di1[ci] - di[ci])) * (di1.t - di.t),\n            t2 = dj.t + abs((is[cj] - dj[cj]) / (dj1[cj] - dj[cj])) * (dj1.t - dj.t);\n\n        if (t1 >= 0 && t1 <= 1 && t2 >= 0 && t2 <= 1) {\n\n          if (justCount) {\n            res++;\n          } else {\n            res.push({\n              x: is.x,\n              y: is.y,\n              t1: t1,\n              t2: t2\n            });\n          }\n        }\n      }\n    }\n  }\n\n  return res;\n}\n\n\n/**\n * Find or counts the intersections between two SVG paths.\n *\n * Returns a number in counting mode and a list of intersections otherwise.\n *\n * A single intersection entry contains the intersection coordinates (x, y)\n * as well as additional information regarding the intersecting segments\n * on each path (segment1, segment2) and the relative location of the\n * intersection on these segments (t1, t2).\n *\n * The path may be an SVG path string or a list of path components\n * such as `[ [ 'M', 0, 10 ], [ 'L', 20, 0 ] ]`.\n *\n * @example\n *\n * var intersections = findPathIntersections(\n *   'M0,0L100,100',\n *   [ [ 'M', 0, 100 ], [ 'L', 100, 0 ] ]\n * );\n *\n * // intersections = [\n * //   { x: 50, y: 50, segment1: 1, segment2: 1, t1: 0.5, t2: 0.5 }\n * //\n *\n * @param {String|Array<PathDef>} path1\n * @param {String|Array<PathDef>} path2\n * @param {Boolean} [justCount=false]\n *\n * @return {Array<Intersection>|Number}\n */\nfunction findPathIntersections(path1, path2, justCount) {\n  path1 = pathToCurve(path1);\n  path2 = pathToCurve(path2);\n\n  var x1, y1, x2, y2, x1m, y1m, x2m, y2m, bez1, bez2,\n      res = justCount ? 0 : [];\n\n  for (var i = 0, ii = path1.length; i < ii; i++) {\n    var pi = path1[i];\n\n    if (pi[0] == 'M') {\n      x1 = x1m = pi[1];\n      y1 = y1m = pi[2];\n    } else {\n\n      if (pi[0] == 'C') {\n        bez1 = [x1, y1].concat(pi.slice(1));\n        x1 = bez1[6];\n        y1 = bez1[7];\n      } else {\n        bez1 = [x1, y1, x1, y1, x1m, y1m, x1m, y1m];\n        x1 = x1m;\n        y1 = y1m;\n      }\n\n      for (var j = 0, jj = path2.length; j < jj; j++) {\n        var pj = path2[j];\n\n        if (pj[0] == 'M') {\n          x2 = x2m = pj[1];\n          y2 = y2m = pj[2];\n        } else {\n\n          if (pj[0] == 'C') {\n            bez2 = [x2, y2].concat(pj.slice(1));\n            x2 = bez2[6];\n            y2 = bez2[7];\n          } else {\n            bez2 = [x2, y2, x2, y2, x2m, y2m, x2m, y2m];\n            x2 = x2m;\n            y2 = y2m;\n          }\n\n          var intr = findBezierIntersections(bez1, bez2, justCount);\n\n          if (justCount) {\n            res += intr;\n          } else {\n\n            for (var k = 0, kk = intr.length; k < kk; k++) {\n              intr[k].segment1 = i;\n              intr[k].segment2 = j;\n              intr[k].bez1 = bez1;\n              intr[k].bez2 = bez2;\n            }\n\n            res = res.concat(intr);\n          }\n        }\n      }\n    }\n  }\n\n  return res;\n}\n\n\nfunction rectPath(x, y, w, h, r) {\n  if (r) {\n    return [\n      ['M', +x + (+r), y],\n      ['l', w - r * 2, 0],\n      ['a', r, r, 0, 0, 1, r, r],\n      ['l', 0, h - r * 2],\n      ['a', r, r, 0, 0, 1, -r, r],\n      ['l', r * 2 - w, 0],\n      ['a', r, r, 0, 0, 1, -r, -r],\n      ['l', 0, r * 2 - h],\n      ['a', r, r, 0, 0, 1, r, -r],\n      ['z']\n    ];\n  }\n\n  var res = [['M', x, y], ['l', w, 0], ['l', 0, h], ['l', -w, 0], ['z']];\n  res.toString = pathToString;\n\n  return res;\n}\n\nfunction ellipsePath(x, y, rx, ry, a) {\n  if (a == null && ry == null) {\n    ry = rx;\n  }\n\n  x = +x;\n  y = +y;\n  rx = +rx;\n  ry = +ry;\n\n  if (a != null) {\n    var rad = Math.PI / 180,\n        x1 = x + rx * Math.cos(-ry * rad),\n        x2 = x + rx * Math.cos(-a * rad),\n        y1 = y + rx * Math.sin(-ry * rad),\n        y2 = y + rx * Math.sin(-a * rad),\n        res = [['M', x1, y1], ['A', rx, rx, 0, +(a - ry > 180), 0, x2, y2]];\n  } else {\n    res = [\n      ['M', x, y],\n      ['m', 0, -ry],\n      ['a', rx, ry, 0, 1, 1, 0, 2 * ry],\n      ['a', rx, ry, 0, 1, 1, 0, -2 * ry],\n      ['z']\n    ];\n  }\n\n  res.toString = pathToString;\n\n  return res;\n}\n\n\nfunction pathToAbsolute(pathArray) {\n  var pth = paths(pathArray);\n\n  if (pth.abs) {\n    return pathClone(pth.abs);\n  }\n\n  if (!is(pathArray, 'array') || !is(pathArray && pathArray[0], 'array')) { // rough assumption\n    pathArray = parsePathString(pathArray);\n  }\n\n  if (!pathArray || !pathArray.length) {\n    return [['M', 0, 0]];\n  }\n\n  var res = [],\n      x = 0,\n      y = 0,\n      mx = 0,\n      my = 0,\n      start = 0,\n      pa0;\n\n  if (pathArray[0][0] == 'M') {\n    x = +pathArray[0][1];\n    y = +pathArray[0][2];\n    mx = x;\n    my = y;\n    start++;\n    res[0] = ['M', x, y];\n  }\n\n  var crz = pathArray.length == 3 &&\n      pathArray[0][0] == 'M' &&\n      pathArray[1][0].toUpperCase() == 'R' &&\n      pathArray[2][0].toUpperCase() == 'Z';\n\n  for (var r, pa, i = start, ii = pathArray.length; i < ii; i++) {\n    res.push(r = []);\n    pa = pathArray[i];\n    pa0 = pa[0];\n\n    if (pa0 != pa0.toUpperCase()) {\n      r[0] = pa0.toUpperCase();\n\n      switch (r[0]) {\n      case 'A':\n        r[1] = pa[1];\n        r[2] = pa[2];\n        r[3] = pa[3];\n        r[4] = pa[4];\n        r[5] = pa[5];\n        r[6] = +pa[6] + x;\n        r[7] = +pa[7] + y;\n        break;\n      case 'V':\n        r[1] = +pa[1] + y;\n        break;\n      case 'H':\n        r[1] = +pa[1] + x;\n        break;\n      case 'R':\n        var dots = [x, y].concat(pa.slice(1));\n\n        for (var j = 2, jj = dots.length; j < jj; j++) {\n          dots[j] = +dots[j] + x;\n          dots[++j] = +dots[j] + y;\n        }\n\n        res.pop();\n        res = res.concat(catmulRomToBezier(dots, crz));\n        break;\n      case 'O':\n        res.pop();\n        dots = ellipsePath(x, y, pa[1], pa[2]);\n        dots.push(dots[0]);\n        res = res.concat(dots);\n        break;\n      case 'U':\n        res.pop();\n        res = res.concat(ellipsePath(x, y, pa[1], pa[2], pa[3]));\n        r = ['U'].concat(res[res.length - 1].slice(-2));\n        break;\n      case 'M':\n        mx = +pa[1] + x;\n        my = +pa[2] + y;\n      default:\n\n        for (j = 1, jj = pa.length; j < jj; j++) {\n          r[j] = +pa[j] + ((j % 2) ? x : y);\n        }\n      }\n    } else if (pa0 == 'R') {\n      dots = [x, y].concat(pa.slice(1));\n      res.pop();\n      res = res.concat(catmulRomToBezier(dots, crz));\n      r = ['R'].concat(pa.slice(-2));\n    } else if (pa0 == 'O') {\n      res.pop();\n      dots = ellipsePath(x, y, pa[1], pa[2]);\n      dots.push(dots[0]);\n      res = res.concat(dots);\n    } else if (pa0 == 'U') {\n      res.pop();\n      res = res.concat(ellipsePath(x, y, pa[1], pa[2], pa[3]));\n      r = ['U'].concat(res[res.length - 1].slice(-2));\n    } else {\n\n      for (var k = 0, kk = pa.length; k < kk; k++) {\n        r[k] = pa[k];\n      }\n    }\n    pa0 = pa0.toUpperCase();\n\n    if (pa0 != 'O') {\n      switch (r[0]) {\n      case 'Z':\n        x = +mx;\n        y = +my;\n        break;\n      case 'H':\n        x = r[1];\n        break;\n      case 'V':\n        y = r[1];\n        break;\n      case 'M':\n        mx = r[r.length - 2];\n        my = r[r.length - 1];\n      default:\n        x = r[r.length - 2];\n        y = r[r.length - 1];\n      }\n    }\n  }\n\n  res.toString = pathToString;\n  pth.abs = pathClone(res);\n\n  return res;\n}\n\nfunction lineToCurve(x1, y1, x2, y2) {\n  return [\n    x1, y1, x2,\n    y2, x2, y2\n  ];\n}\n\nfunction qubicToCurve(x1, y1, ax, ay, x2, y2) {\n  var _13 = 1 / 3,\n      _23 = 2 / 3;\n\n  return [\n    _13 * x1 + _23 * ax,\n    _13 * y1 + _23 * ay,\n    _13 * x2 + _23 * ax,\n    _13 * y2 + _23 * ay,\n    x2,\n    y2\n  ];\n}\n\nfunction arcToCurve(x1, y1, rx, ry, angle, large_arc_flag, sweep_flag, x2, y2, recursive) {\n\n  // for more information of where this math came from visit:\n  // http://www.w3.org/TR/SVG11/implnote.html#ArcImplementationNotes\n  var _120 = PI * 120 / 180,\n      rad = PI / 180 * (+angle || 0),\n      res = [],\n      xy,\n      rotate = cacher(function(x, y, rad) {\n        var X = x * math.cos(rad) - y * math.sin(rad),\n            Y = x * math.sin(rad) + y * math.cos(rad);\n\n        return { x: X, y: Y };\n      });\n\n  if (!recursive) {\n    xy = rotate(x1, y1, -rad);\n    x1 = xy.x;\n    y1 = xy.y;\n    xy = rotate(x2, y2, -rad);\n    x2 = xy.x;\n    y2 = xy.y;\n\n    var x = (x1 - x2) / 2,\n        y = (y1 - y2) / 2;\n\n    var h = (x * x) / (rx * rx) + (y * y) / (ry * ry);\n\n    if (h > 1) {\n      h = math.sqrt(h);\n      rx = h * rx;\n      ry = h * ry;\n    }\n\n    var rx2 = rx * rx,\n        ry2 = ry * ry,\n        k = (large_arc_flag == sweep_flag ? -1 : 1) *\n            math.sqrt(abs((rx2 * ry2 - rx2 * y * y - ry2 * x * x) / (rx2 * y * y + ry2 * x * x))),\n        cx = k * rx * y / ry + (x1 + x2) / 2,\n        cy = k * -ry * x / rx + (y1 + y2) / 2,\n        f1 = math.asin(((y1 - cy) / ry).toFixed(9)),\n        f2 = math.asin(((y2 - cy) / ry).toFixed(9));\n\n    f1 = x1 < cx ? PI - f1 : f1;\n    f2 = x2 < cx ? PI - f2 : f2;\n    f1 < 0 && (f1 = PI * 2 + f1);\n    f2 < 0 && (f2 = PI * 2 + f2);\n\n    if (sweep_flag && f1 > f2) {\n      f1 = f1 - PI * 2;\n    }\n    if (!sweep_flag && f2 > f1) {\n      f2 = f2 - PI * 2;\n    }\n  } else {\n    f1 = recursive[0];\n    f2 = recursive[1];\n    cx = recursive[2];\n    cy = recursive[3];\n  }\n\n  var df = f2 - f1;\n\n  if (abs(df) > _120) {\n    var f2old = f2,\n        x2old = x2,\n        y2old = y2;\n\n    f2 = f1 + _120 * (sweep_flag && f2 > f1 ? 1 : -1);\n    x2 = cx + rx * math.cos(f2);\n    y2 = cy + ry * math.sin(f2);\n    res = arcToCurve(x2, y2, rx, ry, angle, 0, sweep_flag, x2old, y2old, [f2, f2old, cx, cy]);\n  }\n\n  df = f2 - f1;\n\n  var c1 = math.cos(f1),\n      s1 = math.sin(f1),\n      c2 = math.cos(f2),\n      s2 = math.sin(f2),\n      t = math.tan(df / 4),\n      hx = 4 / 3 * rx * t,\n      hy = 4 / 3 * ry * t,\n      m1 = [x1, y1],\n      m2 = [x1 + hx * s1, y1 - hy * c1],\n      m3 = [x2 + hx * s2, y2 - hy * c2],\n      m4 = [x2, y2];\n\n  m2[0] = 2 * m1[0] - m2[0];\n  m2[1] = 2 * m1[1] - m2[1];\n\n  if (recursive) {\n    return [m2, m3, m4].concat(res);\n  } else {\n    res = [m2, m3, m4].concat(res).join().split(',');\n    var newres = [];\n\n    for (var i = 0, ii = res.length; i < ii; i++) {\n      newres[i] = i % 2 ? rotate(res[i - 1], res[i], rad).y : rotate(res[i], res[i + 1], rad).x;\n    }\n\n    return newres;\n  }\n}\n\n// http://schepers.cc/getting-to-the-point\nfunction catmulRomToBezier(crp, z) {\n  var d = [];\n\n  for (var i = 0, iLen = crp.length; iLen - 2 * !z > i; i += 2) {\n    var p = [\n      { x: +crp[i - 2], y: +crp[i - 1] },\n      { x: +crp[i], y: +crp[i + 1] },\n      { x: +crp[i + 2], y: +crp[i + 3] },\n      { x: +crp[i + 4], y: +crp[i + 5] }\n    ];\n\n    if (z) {\n\n      if (!i) {\n        p[0] = { x: +crp[iLen - 2], y: +crp[iLen - 1] };\n      } else if (iLen - 4 == i) {\n        p[3] = { x: +crp[0], y: +crp[1] };\n      } else if (iLen - 2 == i) {\n        p[2] = { x: +crp[0], y: +crp[1] };\n        p[3] = { x: +crp[2], y: +crp[3] };\n      }\n\n    } else {\n\n      if (iLen - 4 == i) {\n        p[3] = p[2];\n      } else if (!i) {\n        p[0] = { x: +crp[i], y: +crp[i + 1] };\n      }\n\n    }\n\n    d.push(['C',\n      (-p[0].x + 6 * p[1].x + p[2].x) / 6,\n      (-p[0].y + 6 * p[1].y + p[2].y) / 6,\n      (p[1].x + 6 * p[2].x - p[3].x) / 6,\n      (p[1].y + 6*p[2].y - p[3].y) / 6,\n      p[2].x,\n      p[2].y\n    ]);\n  }\n\n  return d;\n}\n\n// Returns bounding box of cubic bezier curve.\n// Source: http://blog.hackers-cafe.net/2009/06/how-to-calculate-bezier-curves-bounding.html\n// Original version: NISHIO Hirokazu\n// Modifications: https://github.com/timo22345\nfunction curveBBox(x0, y0, x1, y1, x2, y2, x3, y3) {\n  var tvalues = [],\n      bounds = [[], []],\n      a, b, c, t, t1, t2, b2ac, sqrtb2ac;\n\n  for (var i = 0; i < 2; ++i) {\n\n    if (i == 0) {\n      b = 6 * x0 - 12 * x1 + 6 * x2;\n      a = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;\n      c = 3 * x1 - 3 * x0;\n    } else {\n      b = 6 * y0 - 12 * y1 + 6 * y2;\n      a = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;\n      c = 3 * y1 - 3 * y0;\n    }\n\n    if (abs(a) < 1e-12) {\n\n      if (abs(b) < 1e-12) {\n        continue;\n      }\n\n      t = -c / b;\n\n      if (0 < t && t < 1) {\n        tvalues.push(t);\n      }\n\n      continue;\n    }\n\n    b2ac = b * b - 4 * c * a;\n    sqrtb2ac = math.sqrt(b2ac);\n\n    if (b2ac < 0) {\n      continue;\n    }\n\n    t1 = (-b + sqrtb2ac) / (2 * a);\n\n    if (0 < t1 && t1 < 1) {\n      tvalues.push(t1);\n    }\n\n    t2 = (-b - sqrtb2ac) / (2 * a);\n\n    if (0 < t2 && t2 < 1) {\n      tvalues.push(t2);\n    }\n  }\n\n  var j = tvalues.length,\n      jlen = j,\n      mt;\n\n  while (j--) {\n    t = tvalues[j];\n    mt = 1 - t;\n    bounds[0][j] = (mt * mt * mt * x0) + (3 * mt * mt * t * x1) + (3 * mt * t * t * x2) + (t * t * t * x3);\n    bounds[1][j] = (mt * mt * mt * y0) + (3 * mt * mt * t * y1) + (3 * mt * t * t * y2) + (t * t * t * y3);\n  }\n\n  bounds[0][jlen] = x0;\n  bounds[1][jlen] = y0;\n  bounds[0][jlen + 1] = x3;\n  bounds[1][jlen + 1] = y3;\n  bounds[0].length = bounds[1].length = jlen + 2;\n\n  return {\n    min: { x: mmin.apply(0, bounds[0]), y: mmin.apply(0, bounds[1]) },\n    max: { x: mmax.apply(0, bounds[0]), y: mmax.apply(0, bounds[1]) }\n  };\n}\n\nfunction pathToCurve(path, path2) {\n  var pth = !path2 && paths(path);\n\n  if (!path2 && pth.curve) {\n    return pathClone(pth.curve);\n  }\n\n  var p = pathToAbsolute(path),\n      p2 = path2 && pathToAbsolute(path2),\n      attrs = { x: 0, y: 0, bx: 0, by: 0, X: 0, Y: 0, qx: null, qy: null },\n      attrs2 = { x: 0, y: 0, bx: 0, by: 0, X: 0, Y: 0, qx: null, qy: null },\n      processPath = function(path, d, pcom) {\n        var nx, ny;\n\n        if (!path) {\n          return ['C', d.x, d.y, d.x, d.y, d.x, d.y];\n        }\n\n        !(path[0] in { T: 1, Q: 1 }) && (d.qx = d.qy = null);\n\n        switch (path[0]) {\n        case 'M':\n          d.X = path[1];\n          d.Y = path[2];\n          break;\n        case 'A':\n          path = ['C'].concat(arcToCurve.apply(0, [d.x, d.y].concat(path.slice(1))));\n          break;\n        case 'S':\n          if (pcom == 'C' || pcom == 'S') {\n            // In 'S' case we have to take into account, if the previous command is C/S.\n            nx = d.x * 2 - d.bx;\n            // And reflect the previous\n            ny = d.y * 2 - d.by;\n            // command's control point relative to the current point.\n          }\n          else {\n            // or some else or nothing\n            nx = d.x;\n            ny = d.y;\n          }\n          path = ['C', nx, ny].concat(path.slice(1));\n          break;\n        case 'T':\n          if (pcom == 'Q' || pcom == 'T') {\n            // In 'T' case we have to take into account, if the previous command is Q/T.\n            d.qx = d.x * 2 - d.qx;\n            // And make a reflection similar\n            d.qy = d.y * 2 - d.qy;\n            // to case 'S'.\n          }\n          else {\n            // or something else or nothing\n            d.qx = d.x;\n            d.qy = d.y;\n          }\n          path = ['C'].concat(qubicToCurve(d.x, d.y, d.qx, d.qy, path[1], path[2]));\n          break;\n        case 'Q':\n          d.qx = path[1];\n          d.qy = path[2];\n          path = ['C'].concat(qubicToCurve(d.x, d.y, path[1], path[2], path[3], path[4]));\n          break;\n        case 'L':\n          path = ['C'].concat(lineToCurve(d.x, d.y, path[1], path[2]));\n          break;\n        case 'H':\n          path = ['C'].concat(lineToCurve(d.x, d.y, path[1], d.y));\n          break;\n        case 'V':\n          path = ['C'].concat(lineToCurve(d.x, d.y, d.x, path[1]));\n          break;\n        case 'Z':\n          path = ['C'].concat(lineToCurve(d.x, d.y, d.X, d.Y));\n          break;\n        }\n\n        return path;\n      },\n\n      fixArc = function(pp, i) {\n\n        if (pp[i].length > 7) {\n          pp[i].shift();\n          var pi = pp[i];\n\n          while (pi.length) {\n            pcoms1[i] = 'A'; // if created multiple C:s, their original seg is saved\n            p2 && (pcoms2[i] = 'A'); // the same as above\n            pp.splice(i++, 0, ['C'].concat(pi.splice(0, 6)));\n          }\n\n          pp.splice(i, 1);\n          ii = mmax(p.length, p2 && p2.length || 0);\n        }\n      },\n\n      fixM = function(path1, path2, a1, a2, i) {\n\n        if (path1 && path2 && path1[i][0] == 'M' && path2[i][0] != 'M') {\n          path2.splice(i, 0, ['M', a2.x, a2.y]);\n          a1.bx = 0;\n          a1.by = 0;\n          a1.x = path1[i][1];\n          a1.y = path1[i][2];\n          ii = mmax(p.length, p2 && p2.length || 0);\n        }\n      },\n\n      pcoms1 = [], // path commands of original path p\n      pcoms2 = [], // path commands of original path p2\n      pfirst = '', // temporary holder for original path command\n      pcom = ''; // holder for previous path command of original path\n\n  for (var i = 0, ii = mmax(p.length, p2 && p2.length || 0); i < ii; i++) {\n    p[i] && (pfirst = p[i][0]); // save current path command\n\n    if (pfirst != 'C') // C is not saved yet, because it may be result of conversion\n    {\n      pcoms1[i] = pfirst; // Save current path command\n      i && (pcom = pcoms1[i - 1]); // Get previous path command pcom\n    }\n    p[i] = processPath(p[i], attrs, pcom); // Previous path command is inputted to processPath\n\n    if (pcoms1[i] != 'A' && pfirst == 'C') pcoms1[i] = 'C'; // A is the only command\n    // which may produce multiple C:s\n    // so we have to make sure that C is also C in original path\n\n    fixArc(p, i); // fixArc adds also the right amount of A:s to pcoms1\n\n    if (p2) { // the same procedures is done to p2\n      p2[i] && (pfirst = p2[i][0]);\n\n      if (pfirst != 'C') {\n        pcoms2[i] = pfirst;\n        i && (pcom = pcoms2[i - 1]);\n      }\n\n      p2[i] = processPath(p2[i], attrs2, pcom);\n\n      if (pcoms2[i] != 'A' && pfirst == 'C') {\n        pcoms2[i] = 'C';\n      }\n\n      fixArc(p2, i);\n    }\n\n    fixM(p, p2, attrs, attrs2, i);\n    fixM(p2, p, attrs2, attrs, i);\n\n    var seg = p[i],\n        seg2 = p2 && p2[i],\n        seglen = seg.length,\n        seg2len = p2 && seg2.length;\n\n    attrs.x = seg[seglen - 2];\n    attrs.y = seg[seglen - 1];\n    attrs.bx = toFloat(seg[seglen - 4]) || attrs.x;\n    attrs.by = toFloat(seg[seglen - 3]) || attrs.y;\n    attrs2.bx = p2 && (toFloat(seg2[seg2len - 4]) || attrs2.x);\n    attrs2.by = p2 && (toFloat(seg2[seg2len - 3]) || attrs2.y);\n    attrs2.x = p2 && seg2[seg2len - 2];\n    attrs2.y = p2 && seg2[seg2len - 1];\n  }\n\n  if (!p2) {\n    pth.curve = pathClone(p);\n  }\n\n  return p2 ? [p, p2] : p;\n}\n\nmodule.exports = findPathIntersections;\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/path-intersection/intersect.js?")},"./node_modules/tiny-svg/dist/index.esm.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Lj\": () => (/* binding */ attr),\n/* harmony export */   \"Od\": () => (/* binding */ remove),\n/* harmony export */   \"R3\": () => (/* binding */ append),\n/* harmony export */   \"Sh\": () => (/* binding */ classes),\n/* harmony export */   \"Ue\": () => (/* binding */ create),\n/* harmony export */   \"ZH\": () => (/* binding */ clear),\n/* harmony export */   \"d9\": () => (/* binding */ clone),\n/* harmony export */   \"db\": () => (/* binding */ innerSVG),\n/* harmony export */   \"pH\": () => (/* binding */ createTransform),\n/* harmony export */   \"vs\": () => (/* binding */ transform),\n/* harmony export */   \"wz\": () => (/* binding */ createMatrix)\n/* harmony export */ });\n/* unused harmony exports appendTo, prepend, prependTo, replace, on, off, createPoint, select, selectAll */\nfunction ensureImported(element, target) {\n\n  if (element.ownerDocument !== target.ownerDocument) {\n    try {\n      // may fail on webkit\n      return target.ownerDocument.importNode(element, true);\n    } catch (e) {\n      // ignore\n    }\n  }\n\n  return element;\n}\n\n/**\n * appendTo utility\n */\n\n/**\n * Append a node to a target element and return the appended node.\n *\n * @param  {SVGElement} element\n * @param  {SVGElement} target\n *\n * @return {SVGElement} the appended node\n */\nfunction appendTo(element, target) {\n  return target.appendChild(ensureImported(element, target));\n}\n\n/**\n * append utility\n */\n\n/**\n * Append a node to an element\n *\n * @param  {SVGElement} element\n * @param  {SVGElement} node\n *\n * @return {SVGElement} the element\n */\nfunction append(target, node) {\n  appendTo(node, target);\n  return target;\n}\n\n/**\n * attribute accessor utility\n */\n\nvar LENGTH_ATTR = 2;\n\nvar CSS_PROPERTIES = {\n  'alignment-baseline': 1,\n  'baseline-shift': 1,\n  'clip': 1,\n  'clip-path': 1,\n  'clip-rule': 1,\n  'color': 1,\n  'color-interpolation': 1,\n  'color-interpolation-filters': 1,\n  'color-profile': 1,\n  'color-rendering': 1,\n  'cursor': 1,\n  'direction': 1,\n  'display': 1,\n  'dominant-baseline': 1,\n  'enable-background': 1,\n  'fill': 1,\n  'fill-opacity': 1,\n  'fill-rule': 1,\n  'filter': 1,\n  'flood-color': 1,\n  'flood-opacity': 1,\n  'font': 1,\n  'font-family': 1,\n  'font-size': LENGTH_ATTR,\n  'font-size-adjust': 1,\n  'font-stretch': 1,\n  'font-style': 1,\n  'font-variant': 1,\n  'font-weight': 1,\n  'glyph-orientation-horizontal': 1,\n  'glyph-orientation-vertical': 1,\n  'image-rendering': 1,\n  'kerning': 1,\n  'letter-spacing': 1,\n  'lighting-color': 1,\n  'marker': 1,\n  'marker-end': 1,\n  'marker-mid': 1,\n  'marker-start': 1,\n  'mask': 1,\n  'opacity': 1,\n  'overflow': 1,\n  'pointer-events': 1,\n  'shape-rendering': 1,\n  'stop-color': 1,\n  'stop-opacity': 1,\n  'stroke': 1,\n  'stroke-dasharray': 1,\n  'stroke-dashoffset': 1,\n  'stroke-linecap': 1,\n  'stroke-linejoin': 1,\n  'stroke-miterlimit': 1,\n  'stroke-opacity': 1,\n  'stroke-width': LENGTH_ATTR,\n  'text-anchor': 1,\n  'text-decoration': 1,\n  'text-rendering': 1,\n  'unicode-bidi': 1,\n  'visibility': 1,\n  'word-spacing': 1,\n  'writing-mode': 1\n};\n\n\nfunction getAttribute(node, name) {\n  if (CSS_PROPERTIES[name]) {\n    return node.style[name];\n  } else {\n    return node.getAttributeNS(null, name);\n  }\n}\n\nfunction setAttribute(node, name, value) {\n  var hyphenated = name.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();\n\n  var type = CSS_PROPERTIES[hyphenated];\n\n  if (type) {\n    // append pixel unit, unless present\n    if (type === LENGTH_ATTR && typeof value === 'number') {\n      value = String(value) + 'px';\n    }\n\n    node.style[hyphenated] = value;\n  } else {\n    node.setAttributeNS(null, name, value);\n  }\n}\n\nfunction setAttributes(node, attrs) {\n\n  var names = Object.keys(attrs), i, name;\n\n  for (i = 0, name; (name = names[i]); i++) {\n    setAttribute(node, name, attrs[name]);\n  }\n}\n\n/**\n * Gets or sets raw attributes on a node.\n *\n * @param  {SVGElement} node\n * @param  {Object} [attrs]\n * @param  {String} [name]\n * @param  {String} [value]\n *\n * @return {String}\n */\nfunction attr(node, name, value) {\n  if (typeof name === 'string') {\n    if (value !== undefined) {\n      setAttribute(node, name, value);\n    } else {\n      return getAttribute(node, name);\n    }\n  } else {\n    setAttributes(node, name);\n  }\n\n  return node;\n}\n\n/**\r\n * Clear utility\r\n */\r\nfunction index(arr, obj) {\r\n  if (arr.indexOf) {\r\n    return arr.indexOf(obj);\r\n  }\r\n\r\n\r\n  for (var i = 0; i < arr.length; ++i) {\r\n    if (arr[i] === obj) {\r\n      return i;\r\n    }\r\n  }\r\n\r\n  return -1;\r\n}\r\n\r\nvar re = /\\s+/;\r\n\r\nvar toString = Object.prototype.toString;\r\n\r\nfunction defined(o) {\r\n  return typeof o !== 'undefined';\r\n}\r\n\r\n/**\r\n * Wrap `el` in a `ClassList`.\r\n *\r\n * @param {Element} el\r\n * @return {ClassList}\r\n * @api public\r\n */\r\n\r\nfunction classes(el) {\r\n  return new ClassList(el);\r\n}\r\n\r\nfunction ClassList(el) {\r\n  if (!el || !el.nodeType) {\r\n    throw new Error('A DOM element reference is required');\r\n  }\r\n  this.el = el;\r\n  this.list = el.classList;\r\n}\r\n\r\n/**\r\n * Add class `name` if not already present.\r\n *\r\n * @param {String} name\r\n * @return {ClassList}\r\n * @api public\r\n */\r\n\r\nClassList.prototype.add = function(name) {\r\n\r\n  // classList\r\n  if (this.list) {\r\n    this.list.add(name);\r\n    return this;\r\n  }\r\n\r\n  // fallback\r\n  var arr = this.array();\r\n  var i = index(arr, name);\r\n  if (!~i) {\r\n    arr.push(name);\r\n  }\r\n\r\n  if (defined(this.el.className.baseVal)) {\r\n    this.el.className.baseVal = arr.join(' ');\r\n  } else {\r\n    this.el.className = arr.join(' ');\r\n  }\r\n\r\n  return this;\r\n};\r\n\r\n/**\r\n * Remove class `name` when present, or\r\n * pass a regular expression to remove\r\n * any which match.\r\n *\r\n * @param {String|RegExp} name\r\n * @return {ClassList}\r\n * @api public\r\n */\r\n\r\nClassList.prototype.remove = function(name) {\r\n  if ('[object RegExp]' === toString.call(name)) {\r\n    return this.removeMatching(name);\r\n  }\r\n\r\n  // classList\r\n  if (this.list) {\r\n    this.list.remove(name);\r\n    return this;\r\n  }\r\n\r\n  // fallback\r\n  var arr = this.array();\r\n  var i = index(arr, name);\r\n  if (~i) {\r\n    arr.splice(i, 1);\r\n  }\r\n  this.el.className.baseVal = arr.join(' ');\r\n  return this;\r\n};\r\n\r\n/**\r\n * Remove all classes matching `re`.\r\n *\r\n * @param {RegExp} re\r\n * @return {ClassList}\r\n * @api private\r\n */\r\n\r\nClassList.prototype.removeMatching = function(re) {\r\n  var arr = this.array();\r\n  for (var i = 0; i < arr.length; i++) {\r\n    if (re.test(arr[i])) {\r\n      this.remove(arr[i]);\r\n    }\r\n  }\r\n  return this;\r\n};\r\n\r\n/**\r\n * Toggle class `name`, can force state via `force`.\r\n *\r\n * For browsers that support classList, but do not support `force` yet,\r\n * the mistake will be detected and corrected.\r\n *\r\n * @param {String} name\r\n * @param {Boolean} force\r\n * @return {ClassList}\r\n * @api public\r\n */\r\n\r\nClassList.prototype.toggle = function(name, force) {\r\n  // classList\r\n  if (this.list) {\r\n    if (defined(force)) {\r\n      if (force !== this.list.toggle(name, force)) {\r\n        this.list.toggle(name); // toggle again to correct\r\n      }\r\n    } else {\r\n      this.list.toggle(name);\r\n    }\r\n    return this;\r\n  }\r\n\r\n  // fallback\r\n  if (defined(force)) {\r\n    if (!force) {\r\n      this.remove(name);\r\n    } else {\r\n      this.add(name);\r\n    }\r\n  } else {\r\n    if (this.has(name)) {\r\n      this.remove(name);\r\n    } else {\r\n      this.add(name);\r\n    }\r\n  }\r\n\r\n  return this;\r\n};\r\n\r\n/**\r\n * Return an array of classes.\r\n *\r\n * @return {Array}\r\n * @api public\r\n */\r\n\r\nClassList.prototype.array = function() {\r\n  var className = this.el.getAttribute('class') || '';\r\n  var str = className.replace(/^\\s+|\\s+$/g, '');\r\n  var arr = str.split(re);\r\n  if ('' === arr[0]) {\r\n    arr.shift();\r\n  }\r\n  return arr;\r\n};\r\n\r\n/**\r\n * Check if class `name` is present.\r\n *\r\n * @param {String} name\r\n * @return {ClassList}\r\n * @api public\r\n */\r\n\r\nClassList.prototype.has =\r\nClassList.prototype.contains = function(name) {\r\n  return (\r\n    this.list ?\r\n      this.list.contains(name) :\r\n      !! ~index(this.array(), name)\r\n  );\r\n};\n\nfunction remove(element) {\n  var parent = element.parentNode;\n\n  if (parent) {\n    parent.removeChild(element);\n  }\n\n  return element;\n}\n\n/**\n * Clear utility\n */\n\n/**\n * Removes all children from the given element\n *\n * @param  {DOMElement} element\n * @return {DOMElement} the element (for chaining)\n */\nfunction clear(element) {\n  var child;\n\n  while ((child = element.firstChild)) {\n    remove(child);\n  }\n\n  return element;\n}\n\nfunction clone(element) {\n  return element.cloneNode(true);\n}\n\nvar ns = {\n  svg: 'http://www.w3.org/2000/svg'\n};\n\n/**\n * DOM parsing utility\n */\n\nvar SVG_START = '<svg xmlns=\"' + ns.svg + '\"';\n\nfunction parse(svg) {\n\n  var unwrap = false;\n\n  // ensure we import a valid svg document\n  if (svg.substring(0, 4) === '<svg') {\n    if (svg.indexOf(ns.svg) === -1) {\n      svg = SVG_START + svg.substring(4);\n    }\n  } else {\n    // namespace svg\n    svg = SVG_START + '>' + svg + '</svg>';\n    unwrap = true;\n  }\n\n  var parsed = parseDocument(svg);\n\n  if (!unwrap) {\n    return parsed;\n  }\n\n  var fragment = document.createDocumentFragment();\n\n  var parent = parsed.firstChild;\n\n  while (parent.firstChild) {\n    fragment.appendChild(parent.firstChild);\n  }\n\n  return fragment;\n}\n\nfunction parseDocument(svg) {\n\n  var parser;\n\n  // parse\n  parser = new DOMParser();\n  parser.async = false;\n\n  return parser.parseFromString(svg, 'text/xml');\n}\n\n/**\n * Create utility for SVG elements\n */\n\n\n/**\n * Create a specific type from name or SVG markup.\n *\n * @param {String} name the name or markup of the element\n * @param {Object} [attrs] attributes to set on the element\n *\n * @returns {SVGElement}\n */\nfunction create(name, attrs) {\n  var element;\n\n  if (name.charAt(0) === '<') {\n    element = parse(name).firstChild;\n    element = document.importNode(element, true);\n  } else {\n    element = document.createElementNS(ns.svg, name);\n  }\n\n  if (attrs) {\n    attr(element, attrs);\n  }\n\n  return element;\n}\n\n/**\n * Events handling utility\n */\n\nfunction on(node, event, listener, useCapture) {\n  node.addEventListener(event, listener, useCapture);\n}\n\nfunction off(node, event, listener, useCapture) {\n  node.removeEventListener(event, listener, useCapture);\n}\n\n/**\n * Geometry helpers\n */\n\n// fake node used to instantiate svg geometry elements\nvar node = create('svg');\n\nfunction extend(object, props) {\n  var i, k, keys = Object.keys(props);\n\n  for (i = 0; (k = keys[i]); i++) {\n    object[k] = props[k];\n  }\n\n  return object;\n}\n\n\nfunction createPoint(x, y) {\n  var point = node.createSVGPoint();\n\n  switch (arguments.length) {\n  case 0:\n    return point;\n  case 2:\n    x = {\n      x: x,\n      y: y\n    };\n    break;\n  }\n\n  return extend(point, x);\n}\n\n/**\n * Create matrix via args.\n *\n * @example\n *\n * createMatrix({ a: 1, b: 1 });\n * createMatrix();\n * createMatrix(1, 2, 0, 0, 30, 20);\n *\n * @return {SVGMatrix}\n */\nfunction createMatrix(a, b, c, d, e, f) {\n  var matrix = node.createSVGMatrix();\n\n  switch (arguments.length) {\n  case 0:\n    return matrix;\n  case 1:\n    return extend(matrix, a);\n  case 6:\n    return extend(matrix, {\n      a: a,\n      b: b,\n      c: c,\n      d: d,\n      e: e,\n      f: f\n    });\n  }\n}\n\nfunction createTransform(matrix) {\n  if (matrix) {\n    return node.createSVGTransformFromMatrix(matrix);\n  } else {\n    return node.createSVGTransform();\n  }\n}\n\n/**\n * Serialization util\n */\n\nvar TEXT_ENTITIES = /([&<>]{1})/g;\nvar ATTR_ENTITIES = /([\\n\\r\"]{1})/g;\n\nvar ENTITY_REPLACEMENT = {\n  '&': '&amp;',\n  '<': '&lt;',\n  '>': '&gt;',\n  '\"': '\\''\n};\n\nfunction escape(str, pattern) {\n\n  function replaceFn(match, entity) {\n    return ENTITY_REPLACEMENT[entity] || entity;\n  }\n\n  return str.replace(pattern, replaceFn);\n}\n\nfunction serialize(node, output) {\n\n  var i, len, attrMap, attrNode, childNodes;\n\n  switch (node.nodeType) {\n  // TEXT\n  case 3:\n    // replace special XML characters\n    output.push(escape(node.textContent, TEXT_ENTITIES));\n    break;\n\n  // ELEMENT\n  case 1:\n    output.push('<', node.tagName);\n\n    if (node.hasAttributes()) {\n      attrMap = node.attributes;\n      for (i = 0, len = attrMap.length; i < len; ++i) {\n        attrNode = attrMap.item(i);\n        output.push(' ', attrNode.name, '=\"', escape(attrNode.value, ATTR_ENTITIES), '\"');\n      }\n    }\n\n    if (node.hasChildNodes()) {\n      output.push('>');\n      childNodes = node.childNodes;\n      for (i = 0, len = childNodes.length; i < len; ++i) {\n        serialize(childNodes.item(i), output);\n      }\n      output.push('</', node.tagName, '>');\n    } else {\n      output.push('/>');\n    }\n    break;\n\n  // COMMENT\n  case 8:\n    output.push('\x3c!--', escape(node.nodeValue, TEXT_ENTITIES), '--\x3e');\n    break;\n\n  // CDATA\n  case 4:\n    output.push('<![CDATA[', node.nodeValue, ']]>');\n    break;\n\n  default:\n    throw new Error('unable to handle node ' + node.nodeType);\n  }\n\n  return output;\n}\n\n/**\n * innerHTML like functionality for SVG elements.\n * based on innerSVG (https://code.google.com/p/innersvg)\n */\n\n\nfunction set(element, svg) {\n\n  var parsed = parse(svg);\n\n  // clear element contents\n  clear(element);\n\n  if (!svg) {\n    return;\n  }\n\n  if (!isFragment(parsed)) {\n    // extract <svg> from parsed document\n    parsed = parsed.documentElement;\n  }\n\n  var nodes = slice(parsed.childNodes);\n\n  // import + append each node\n  for (var i = 0; i < nodes.length; i++) {\n    appendTo(nodes[i], element);\n  }\n\n}\n\nfunction get(element) {\n  var child = element.firstChild,\n      output = [];\n\n  while (child) {\n    serialize(child, output);\n    child = child.nextSibling;\n  }\n\n  return output.join('');\n}\n\nfunction isFragment(node) {\n  return node.nodeName === '#document-fragment';\n}\n\nfunction innerSVG(element, svg) {\n\n  if (svg !== undefined) {\n\n    try {\n      set(element, svg);\n    } catch (e) {\n      throw new Error('error parsing SVG: ' + e.message);\n    }\n\n    return element;\n  } else {\n    return get(element);\n  }\n}\n\n\nfunction slice(arr) {\n  return Array.prototype.slice.call(arr);\n}\n\n/**\n * Selection utilities\n */\n\nfunction select(node, selector) {\n  return node.querySelector(selector);\n}\n\nfunction selectAll(node, selector) {\n  var nodes = node.querySelectorAll(selector);\n\n  return [].map.call(nodes, function(element) {\n    return element;\n  });\n}\n\n/**\n * prependTo utility\n */\n\n/**\n * Prepend a node to a target element and return the prepended node.\n *\n * @param  {SVGElement} node\n * @param  {SVGElement} target\n *\n * @return {SVGElement} the prepended node\n */\nfunction prependTo(node, target) {\n  return target.insertBefore(ensureImported(node, target), target.firstChild || null);\n}\n\n/**\n * prepend utility\n */\n\n/**\n * Prepend a node to a target element\n *\n * @param  {SVGElement} target\n * @param  {SVGElement} node\n *\n * @return {SVGElement} the target element\n */\nfunction prepend(target, node) {\n  prependTo(node, target);\n  return target;\n}\n\n/**\n * Replace utility\n */\n\nfunction replace(element, replacement) {\n  element.parentNode.replaceChild(ensureImported(replacement, element), element);\n  return replacement;\n}\n\n/**\n * transform accessor utility\n */\n\nfunction wrapMatrix(transformList, transform) {\n  if (transform instanceof SVGMatrix) {\n    return transformList.createSVGTransformFromMatrix(transform);\n  }\n\n  return transform;\n}\n\n\nfunction setTransforms(transformList, transforms) {\n  var i, t;\n\n  transformList.clear();\n\n  for (i = 0; (t = transforms[i]); i++) {\n    transformList.appendItem(wrapMatrix(transformList, t));\n  }\n}\n\n/**\n * Get or set the transforms on the given node.\n *\n * @param {SVGElement} node\n * @param  {SVGTransform|SVGMatrix|Array<SVGTransform|SVGMatrix>} [transforms]\n *\n * @return {SVGTransform} the consolidated transform\n */\nfunction transform(node, transforms) {\n  var transformList = node.transform.baseVal;\n\n  if (transforms) {\n\n    if (!Array.isArray(transforms)) {\n      transforms = [ transforms ];\n    }\n\n    setTransforms(transformList, transforms);\n  }\n\n  return transformList.consolidate();\n}\n\n\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/tiny-svg/dist/index.esm.js?")},"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js":(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Ed\": () => (/* binding */ forEach),\n/* harmony export */   \"f0\": () => (/* binding */ assign)\n/* harmony export */ });\n/* unused harmony exports bind, debounce, ensureArray, every, filter, find, findIndex, flatten, get, groupBy, has, isArray, isDefined, isFunction, isNil, isNumber, isObject, isString, isUndefined, keys, map, matchPattern, merge, omit, pick, reduce, set, size, some, sortBy, throttle, unionBy, uniqueBy, values, without */\n/**\n * Flatten array, one level deep.\n *\n * @param {Array<?>} arr\n *\n * @return {Array<?>}\n */\nfunction flatten(arr) {\n  return Array.prototype.concat.apply([], arr);\n}\n\nconst nativeToString = Object.prototype.toString;\nconst nativeHasOwnProperty = Object.prototype.hasOwnProperty;\n\nfunction isUndefined(obj) {\n  return obj === undefined;\n}\n\nfunction isDefined(obj) {\n  return obj !== undefined;\n}\n\nfunction isNil(obj) {\n  return obj == null;\n}\n\nfunction isArray(obj) {\n  return nativeToString.call(obj) === '[object Array]';\n}\n\nfunction isObject(obj) {\n  return nativeToString.call(obj) === '[object Object]';\n}\n\nfunction isNumber(obj) {\n  return nativeToString.call(obj) === '[object Number]';\n}\n\nfunction isFunction(obj) {\n  const tag = nativeToString.call(obj);\n\n  return (\n    tag === '[object Function]' ||\n    tag === '[object AsyncFunction]' ||\n    tag === '[object GeneratorFunction]' ||\n    tag === '[object AsyncGeneratorFunction]' ||\n    tag === '[object Proxy]'\n  );\n}\n\nfunction isString(obj) {\n  return nativeToString.call(obj) === '[object String]';\n}\n\n\n/**\n * Ensure collection is an array.\n *\n * @param {Object} obj\n */\nfunction ensureArray(obj) {\n\n  if (isArray(obj)) {\n    return;\n  }\n\n  throw new Error('must supply array');\n}\n\n/**\n * Return true, if target owns a property with the given key.\n *\n * @param {Object} target\n * @param {String} key\n *\n * @return {Boolean}\n */\nfunction has(target, key) {\n  return nativeHasOwnProperty.call(target, key);\n}\n\n/**\n * Find element in collection.\n *\n * @param  {Array|Object} collection\n * @param  {Function|Object} matcher\n *\n * @return {Object}\n */\nfunction find(collection, matcher) {\n\n  matcher = toMatcher(matcher);\n\n  let match;\n\n  forEach(collection, function(val, key) {\n    if (matcher(val, key)) {\n      match = val;\n\n      return false;\n    }\n  });\n\n  return match;\n\n}\n\n\n/**\n * Find element index in collection.\n *\n * @param  {Array|Object} collection\n * @param  {Function} matcher\n *\n * @return {Object}\n */\nfunction findIndex(collection, matcher) {\n\n  matcher = toMatcher(matcher);\n\n  let idx = isArray(collection) ? -1 : undefined;\n\n  forEach(collection, function(val, key) {\n    if (matcher(val, key)) {\n      idx = key;\n\n      return false;\n    }\n  });\n\n  return idx;\n}\n\n\n/**\n * Find element in collection.\n *\n * @param  {Array|Object} collection\n * @param  {Function} matcher\n *\n * @return {Array} result\n */\nfunction filter(collection, matcher) {\n\n  let result = [];\n\n  forEach(collection, function(val, key) {\n    if (matcher(val, key)) {\n      result.push(val);\n    }\n  });\n\n  return result;\n}\n\n\n/**\n * Iterate over collection; returning something\n * (non-undefined) will stop iteration.\n *\n * @param  {Array|Object} collection\n * @param  {Function} iterator\n *\n * @return {Object} return result that stopped the iteration\n */\nfunction forEach(collection, iterator) {\n\n  let val,\n      result;\n\n  if (isUndefined(collection)) {\n    return;\n  }\n\n  const convertKey = isArray(collection) ? toNum : identity;\n\n  for (let key in collection) {\n\n    if (has(collection, key)) {\n      val = collection[key];\n\n      result = iterator(val, convertKey(key));\n\n      if (result === false) {\n        return val;\n      }\n    }\n  }\n}\n\n/**\n * Return collection without element.\n *\n * @param  {Array} arr\n * @param  {Function} matcher\n *\n * @return {Array}\n */\nfunction without(arr, matcher) {\n\n  if (isUndefined(arr)) {\n    return [];\n  }\n\n  ensureArray(arr);\n\n  matcher = toMatcher(matcher);\n\n  return arr.filter(function(el, idx) {\n    return !matcher(el, idx);\n  });\n\n}\n\n\n/**\n * Reduce collection, returning a single result.\n *\n * @param  {Object|Array} collection\n * @param  {Function} iterator\n * @param  {Any} result\n *\n * @return {Any} result returned from last iterator\n */\nfunction reduce(collection, iterator, result) {\n\n  forEach(collection, function(value, idx) {\n    result = iterator(result, value, idx);\n  });\n\n  return result;\n}\n\n\n/**\n * Return true if every element in the collection\n * matches the criteria.\n *\n * @param  {Object|Array} collection\n * @param  {Function} matcher\n *\n * @return {Boolean}\n */\nfunction every(collection, matcher) {\n\n  return !!reduce(collection, function(matches, val, key) {\n    return matches && matcher(val, key);\n  }, true);\n}\n\n\n/**\n * Return true if some elements in the collection\n * match the criteria.\n *\n * @param  {Object|Array} collection\n * @param  {Function} matcher\n *\n * @return {Boolean}\n */\nfunction some(collection, matcher) {\n\n  return !!find(collection, matcher);\n}\n\n\n/**\n * Transform a collection into another collection\n * by piping each member through the given fn.\n *\n * @param  {Object|Array}   collection\n * @param  {Function} fn\n *\n * @return {Array} transformed collection\n */\nfunction map(collection, fn) {\n\n  let result = [];\n\n  forEach(collection, function(val, key) {\n    result.push(fn(val, key));\n  });\n\n  return result;\n}\n\n\n/**\n * Get the collections keys.\n *\n * @param  {Object|Array} collection\n *\n * @return {Array}\n */\nfunction keys(collection) {\n  return collection && Object.keys(collection) || [];\n}\n\n\n/**\n * Shorthand for `keys(o).length`.\n *\n * @param  {Object|Array} collection\n *\n * @return {Number}\n */\nfunction size(collection) {\n  return keys(collection).length;\n}\n\n\n/**\n * Get the values in the collection.\n *\n * @param  {Object|Array} collection\n *\n * @return {Array}\n */\nfunction values(collection) {\n  return map(collection, (val) => val);\n}\n\n\n/**\n * Group collection members by attribute.\n *\n * @param  {Object|Array} collection\n * @param  {Function} extractor\n *\n * @return {Object} map with { attrValue => [ a, b, c ] }\n */\nfunction groupBy(collection, extractor, grouped = {}) {\n\n  extractor = toExtractor(extractor);\n\n  forEach(collection, function(val) {\n    let discriminator = extractor(val) || '_';\n\n    let group = grouped[discriminator];\n\n    if (!group) {\n      group = grouped[discriminator] = [];\n    }\n\n    group.push(val);\n  });\n\n  return grouped;\n}\n\n\nfunction uniqueBy(extractor, ...collections) {\n\n  extractor = toExtractor(extractor);\n\n  let grouped = {};\n\n  forEach(collections, (c) => groupBy(c, extractor, grouped));\n\n  let result = map(grouped, function(val, key) {\n    return val[0];\n  });\n\n  return result;\n}\n\n\nconst unionBy = (/* unused pure expression or super */ null && (uniqueBy));\n\n\n\n/**\n * Sort collection by criteria.\n *\n * @param  {Object|Array} collection\n * @param  {String|Function} extractor\n *\n * @return {Array}\n */\nfunction sortBy(collection, extractor) {\n\n  extractor = toExtractor(extractor);\n\n  let sorted = [];\n\n  forEach(collection, function(value, key) {\n    let disc = extractor(value, key);\n\n    let entry = {\n      d: disc,\n      v: value\n    };\n\n    for (var idx = 0; idx < sorted.length; idx++) {\n      let { d } = sorted[idx];\n\n      if (disc < d) {\n        sorted.splice(idx, 0, entry);\n        return;\n      }\n    }\n\n    // not inserted, append (!)\n    sorted.push(entry);\n  });\n\n  return map(sorted, (e) => e.v);\n}\n\n\n/**\n * Create an object pattern matcher.\n *\n * @example\n *\n * const matcher = matchPattern({ id: 1 });\n *\n * let element = find(elements, matcher);\n *\n * @param  {Object} pattern\n *\n * @return {Function} matcherFn\n */\nfunction matchPattern(pattern) {\n\n  return function(el) {\n\n    return every(pattern, function(val, key) {\n      return el[key] === val;\n    });\n\n  };\n}\n\n\nfunction toExtractor(extractor) {\n  return isFunction(extractor) ? extractor : (e) => {\n    return e[extractor];\n  };\n}\n\n\nfunction toMatcher(matcher) {\n  return isFunction(matcher) ? matcher : (e) => {\n    return e === matcher;\n  };\n}\n\n\nfunction identity(arg) {\n  return arg;\n}\n\nfunction toNum(arg) {\n  return Number(arg);\n}\n\n/**\n * Debounce fn, calling it only once if the given time\n * elapsed between calls.\n *\n * Lodash-style the function exposes methods to `#clear`\n * and `#flush` to control internal behavior.\n *\n * @param  {Function} fn\n * @param  {Number} timeout\n *\n * @return {Function} debounced function\n */\nfunction debounce(fn, timeout) {\n\n  let timer;\n\n  let lastArgs;\n  let lastThis;\n\n  let lastNow;\n\n  function fire(force) {\n\n    let now = Date.now();\n\n    let scheduledDiff = force ? 0 : (lastNow + timeout) - now;\n\n    if (scheduledDiff > 0) {\n      return schedule(scheduledDiff);\n    }\n\n    fn.apply(lastThis, lastArgs);\n\n    clear();\n  }\n\n  function schedule(timeout) {\n    timer = setTimeout(fire, timeout);\n  }\n\n  function clear() {\n    if (timer) {\n      clearTimeout(timer);\n    }\n\n    timer = lastNow = lastArgs = lastThis = undefined;\n  }\n\n  function flush() {\n    if (timer) {\n      fire(true);\n    }\n\n    clear();\n  }\n\n  function callback(...args) {\n    lastNow = Date.now();\n\n    lastArgs = args;\n    lastThis = this;\n\n    // ensure an execution is scheduled\n    if (!timer) {\n      schedule(timeout);\n    }\n  }\n\n  callback.flush = flush;\n  callback.cancel = clear;\n\n  return callback;\n}\n\n/**\n * Throttle fn, calling at most once\n * in the given interval.\n *\n * @param  {Function} fn\n * @param  {Number} interval\n *\n * @return {Function} throttled function\n */\nfunction throttle(fn, interval) {\n  let throttling = false;\n\n  return function(...args) {\n\n    if (throttling) {\n      return;\n    }\n\n    fn(...args);\n    throttling = true;\n\n    setTimeout(() => {\n      throttling = false;\n    }, interval);\n  };\n}\n\n/**\n * Bind function against target <this>.\n *\n * @param  {Function} fn\n * @param  {Object}   target\n *\n * @return {Function} bound function\n */\nfunction bind(fn, target) {\n  return fn.bind(target);\n}\n\n/**\n * Convenience wrapper for `Object.assign`.\n *\n * @param {Object} target\n * @param {...Object} others\n *\n * @return {Object} the target\n */\nfunction assign(target, ...others) {\n  return Object.assign(target, ...others);\n}\n\n/**\n * Sets a nested property of a given object to the specified value.\n *\n * This mutates the object and returns it.\n *\n * @param {Object} target The target of the set operation.\n * @param {(string|number)[]} path The path to the nested value.\n * @param {any} value The value to set.\n */\nfunction set(target, path, value) {\n\n  let currentTarget = target;\n\n  forEach(path, function(key, idx) {\n\n    if (typeof key !== 'number' && typeof key !== 'string') {\n      throw new Error('illegal key type: ' + typeof key + '. Key should be of type number or string.');\n    }\n\n    if (key === 'constructor') {\n      throw new Error('illegal key: constructor');\n    }\n\n    if (key === '__proto__') {\n      throw new Error('illegal key: __proto__');\n    }\n\n    let nextKey = path[idx + 1];\n    let nextTarget = currentTarget[key];\n\n    if (isDefined(nextKey) && isNil(nextTarget)) {\n      nextTarget = currentTarget[key] = isNaN(+nextKey) ? {} : [];\n    }\n\n    if (isUndefined(nextKey)) {\n      if (isUndefined(value)) {\n        delete currentTarget[key];\n      } else {\n        currentTarget[key] = value;\n      }\n    } else {\n      currentTarget = nextTarget;\n    }\n  });\n\n  return target;\n}\n\n\n/**\n * Gets a nested property of a given object.\n *\n * @param {Object} target The target of the get operation.\n * @param {(string|number)[]} path The path to the nested value.\n * @param {any} [defaultValue] The value to return if no value exists.\n */\nfunction get(target, path, defaultValue) {\n\n  let currentTarget = target;\n\n  forEach(path, function(key) {\n\n    // accessing nil property yields <undefined>\n    if (isNil(currentTarget)) {\n      currentTarget = undefined;\n\n      return false;\n    }\n\n    currentTarget = currentTarget[key];\n  });\n\n  return isUndefined(currentTarget) ? defaultValue : currentTarget;\n}\n\n/**\n * Pick given properties from the target object.\n *\n * @param {Object} target\n * @param {Array} properties\n *\n * @return {Object} target\n */\nfunction pick(target, properties) {\n\n  let result = {};\n\n  let obj = Object(target);\n\n  forEach(properties, function(prop) {\n\n    if (prop in obj) {\n      result[prop] = target[prop];\n    }\n  });\n\n  return result;\n}\n\n/**\n * Pick all target properties, excluding the given ones.\n *\n * @param {Object} target\n * @param {Array} properties\n *\n * @return {Object} target\n */\nfunction omit(target, properties) {\n\n  let result = {};\n\n  let obj = Object(target);\n\n  forEach(obj, function(prop, key) {\n\n    if (properties.indexOf(key) === -1) {\n      result[key] = prop;\n    }\n  });\n\n  return result;\n}\n\n/**\n * Recursively merge `...sources` into given target.\n *\n * Does support merging objects; does not support merging arrays.\n *\n * @param {Object} target\n * @param {...Object} sources\n *\n * @return {Object} the target\n */\nfunction merge(target, ...sources) {\n\n  if (!sources.length) {\n    return target;\n  }\n\n  forEach(sources, function(source) {\n\n    // skip non-obj sources, i.e. null\n    if (!source || !isObject(source)) {\n      return;\n    }\n\n    forEach(source, function(sourceVal, key) {\n\n      if (key === '__proto__') {\n        return;\n      }\n\n      let targetVal = target[key];\n\n      if (isObject(sourceVal)) {\n\n        if (!isObject(targetVal)) {\n\n          // override target[key] with object\n          targetVal = {};\n        }\n\n        target[key] = merge(targetVal, sourceVal);\n      } else {\n        target[key] = sourceVal;\n      }\n\n    });\n  });\n\n  return target;\n}\n\n\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js?")}}]);