(()=>{"use strict";var __webpack_modules__={"./common/utils.ts":(__unused_webpack_module,exports)=>{eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getRemoteUserKey = exports.getCurrentUserFullName = exports.getConfluenceVersion = exports.getSpaceName = exports.getSpaceKey = exports.getBaseUrl = exports.isNewPage = exports.getContextPath = exports.getUserLocale = exports.getLatestPageId = exports.getContentType = exports.getPageId = exports.getAccessMode = exports.getContentId = exports.getParams = exports.initViadeeLogo = exports.showWarningDialog = exports.getQueryParam = void 0;\nfunction getQueryParam(param) {\n    const result = window.location.search.match(new RegExp("(\\\\?|&)" + param + "(\\\\[\\\\])?=([^&]*)"));\n    return result ? result[3] : 0;\n}\nexports.getQueryParam = getQueryParam;\nfunction showWarningDialog(AJS, dialogId, template, callbackContinue, callbackAbort, params) {\n    const dialog = template(params);\n    AJS.$("body").append(dialog);\n    AJS.dialog2(dialogId).show();\n    AJS.$(dialogId).show();\n    AJS.dialog2(dialogId).on("hide", () => {\n        AJS.$(dialogId).remove();\n    });\n    AJS.$(dialogId + "-abort").click((e) => {\n        AJS.dialog2(dialogId).hide();\n        if (typeof callbackAbort === "function") {\n            callbackAbort();\n        }\n    });\n    AJS.$(dialogId + "-continue").click((e) => {\n        AJS.dialog2(dialogId).hide();\n        if (typeof callbackContinue === "function") {\n            callbackContinue();\n        }\n    });\n}\nexports.showWarningDialog = showWarningDialog;\nfunction initViadeeLogo(cmmnDiagramName) {\n    cmmnDiagramName = cmmnDiagramName.replace(" ", "_");\n    const viadeeLogoId = "viadee-logo-viewer-" + cmmnDiagramName;\n    const viadeeLogoName = AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.icon.title.name.viadee.logo");\n    const modelerLink = AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.icon.title.name.viadee.logo-link");\n    const viadeeLogo = createViadeeLogo(viadeeLogoId, viadeeLogoName, "22", "30");\n    $("#vccp-viewer-" + cmmnDiagramName + " .cjs-container").append(viadeeLogo);\n    $(`#${viadeeLogoId}`).on("click", (event) => {\n        window.open(modelerLink, "_blank");\n        event.preventDefault();\n    });\n    function createViadeeLogo(btnId, titleName, positionBottom, positionLeft) {\n        const title = `title="${titleName}"`;\n        const htmlCode = `<div id="${btnId}"\n            class="viadee-logo-viewer"\n            position="absolute"\n            style="bottom: ${positionBottom}px; left: ${positionLeft}px;" ${title}>\n            </div>`;\n        return htmlCode;\n    }\n}\nexports.initViadeeLogo = initViadeeLogo;\nfunction getParams() {\n    return {\n        accessMode: getAccessMode(),\n        baseUrl: getBaseUrl(),\n        currentUserFullname: getCurrentUserFullName(),\n        versionNumber: getConfluenceVersion(),\n        newPage: isNewPage(),\n        spaceKey: getSpaceKey(),\n        spaceName: getSpaceName(),\n        pageId: getPageId(),\n        contentType: getContentType(),\n        latestPageId: getLatestPageId(),\n        userLocale: getUserLocale(),\n        contextPath: getContextPath(),\n        remoteUserKey: getRemoteUserKey(),\n        contentId: getContentId(),\n    };\n}\nexports.getParams = getParams;\nfunction getContentId() {\n    return Confluence.getContentId() ? Confluence.getContentId() : AJS.Meta.get("content-id");\n}\nexports.getContentId = getContentId;\nfunction getAccessMode() {\n    return AJS.Meta.get("access-mode");\n}\nexports.getAccessMode = getAccessMode;\nfunction getPageId() {\n    return AJS.Meta.get("page-id");\n}\nexports.getPageId = getPageId;\nfunction getContentType() {\n    return AJS.Meta.get("content-type");\n}\nexports.getContentType = getContentType;\nfunction getLatestPageId() {\n    return AJS.Meta.get("latest-page-id");\n}\nexports.getLatestPageId = getLatestPageId;\nfunction getUserLocale() {\n    return AJS.Meta.get("user-locale");\n}\nexports.getUserLocale = getUserLocale;\nfunction getContextPath() {\n    return AJS.Meta.get("context-path") || Confluence.getContextPath();\n}\nexports.getContextPath = getContextPath;\nfunction isNewPage() {\n    return AJS.Meta.get("new-page");\n}\nexports.isNewPage = isNewPage;\nfunction getBaseUrl() {\n    return AJS.Meta.get("base-url");\n}\nexports.getBaseUrl = getBaseUrl;\nfunction getSpaceKey() {\n    return AJS.Meta.get("space-key");\n}\nexports.getSpaceKey = getSpaceKey;\nfunction getSpaceName() {\n    return AJS.Meta.get("space-name");\n}\nexports.getSpaceName = getSpaceName;\nfunction getConfluenceVersion() {\n    return AJS.Meta.get("version-number");\n}\nexports.getConfluenceVersion = getConfluenceVersion;\nfunction getCurrentUserFullName() {\n    return AJS.Meta.get("current-user-fullname");\n}\nexports.getCurrentUserFullName = getCurrentUserFullName;\nfunction getRemoteUserKey() {\n    return AJS.Meta.get("remote-user-key");\n}\nexports.getRemoteUserKey = getRemoteUserKey;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/utils.ts?')},"./common/validator.ts":(__unused_webpack_module,exports)=>{eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.isValidInput = exports.decodeFromHtmlEntities = exports.isValidMacroName = void 0;\nfunction isValidMacroName(name) {\n    const editorHtml = $("#wysiwygTextarea_ifr")\n        .contents()\n        .find("#tinymce")\n        .prop("outerHTML");\n    const regex = /<img class="editor-inline-macro".*?data-macro-name="vccp-macro".*?cmmnDiagramName=([^"]*?)"[^>]*?>/g;\n    let regexArray = regex.exec(editorHtml);\n    const results = [];\n    while (regexArray !== null) {\n        const txt = decodeFromHtmlEntities(regexArray[1].toLowerCase());\n        results.push(txt);\n        regexArray = regex.exec(editorHtml);\n    }\n    return results.indexOf(name.toLowerCase()) === -1;\n}\nexports.isValidMacroName = isValidMacroName;\nfunction decodeFromHtmlEntities(str) {\n    let replacedStr = str;\n    replacedStr = replacedStr.replace(/&Auml;/g, "Ä");\n    replacedStr = replacedStr.replace(/&auml;/g, "ä");\n    replacedStr = replacedStr.replace(/&Ouml;/g, "Ö");\n    replacedStr = replacedStr.replace(/&ouml;/g, "ö");\n    replacedStr = replacedStr.replace(/&Uuml;/g, "Ü");\n    replacedStr = replacedStr.replace(/&uuml;/g, "ü");\n    replacedStr = replacedStr.replace(/&szlig;/g, "ß");\n    return replacedStr;\n}\nexports.decodeFromHtmlEntities = decodeFromHtmlEntities;\nfunction isValidInput(input) {\n    if (!input) {\n        return false;\n    }\n    else {\n        return /^[A-Za-z0-9 \\u00c4\\u00e4\\u00d6\\u00f6\\u00dc\\u00fc\\u00df\\-]+$/g.test(input);\n    }\n}\nexports.isValidInput = isValidInput;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/validator.ts?')},"./dialogs/vccp-macro-dialog.ts":function(__unused_webpack_module,exports,__webpack_require__){eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nconst Validator = __importStar(__webpack_require__("./common/validator.ts"));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nAJS.bind("init.rte", () => __awaiter(void 0, void 0, void 0, function* () {\n    const macroName = "vccp-macro";\n    const dialogId = "#vccp-macro-dialog";\n    const customDialog = Confluence.Templates.viadee.cmmnplugin.macroDialog();\n    $("body").append(customDialog);\n    const $dialog = $(dialogId);\n    const $cancel = $(dialogId + "-close");\n    const $submit = $(dialogId + "-submit");\n    const $input = $(dialogId + "-name-input");\n    const $error = $(dialogId + "-error");\n    $cancel.off();\n    $cancel.click((e) => {\n        e.stopPropagation();\n        e.preventDefault();\n        AJS.dialog2(dialogId).hide();\n    });\n    $input.keydown((e) => {\n        if (e.which === 27) {\n            e.stopPropagation();\n            e.preventDefault();\n            $cancel.click();\n        }\n    });\n    $input.keypress((e) => {\n        if (e.which === 13) {\n            e.stopPropagation();\n            e.preventDefault();\n            $submit.click();\n        }\n    });\n    $submit.click((e) => {\n        e.stopPropagation();\n        e.preventDefault();\n        const value = $input.val();\n        const name = value ? value.trim() : "";\n        if (name.length === 0) {\n            showErrorMessage(AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.insert-dialog.minimumLengthWarning"));\n        }\n        else if (!Validator.isValidInput(name)) {\n            showErrorMessage(AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.insert-dialog.notValidWarning"));\n        }\n        else if (name.length > 50) {\n            showErrorMessage(AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.insert-dialog.nameLengthWarning"));\n        }\n        else if (!Validator.isValidMacroName(name)) {\n            showErrorMessage(AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.insert-dialog.sameNameWarning"));\n        }\n        else {\n            submitMacro(name);\n        }\n    });\n    function showErrorMessage(message) {\n        $error.text(message);\n    }\n    function clearFields() {\n        $input.val("");\n        $error.text("");\n    }\n    function submitMacro(name) {\n        const currentParams = {\n            cmmnDiagramName: name,\n        };\n        const macro = {\n            name: macroName,\n            params: currentParams,\n            defaultParameterValue: "",\n            body: "",\n        };\n        tinymce.confluence.macrobrowser.macroBrowserComplete(macro);\n        AJS.dialog2(dialogId).hide();\n    }\n    function showWarningDialog(warningDialogId, template, callbackContinue, callbackAbort, params) {\n        const dialog = template(params);\n        AJS.$("body").append(dialog);\n        AJS.dialog2(warningDialogId).show();\n        AJS.dialog2(warningDialogId).on("hide", () => {\n            AJS.$(warningDialogId).remove();\n        });\n        AJS.$(warningDialogId + "-abort").click((e) => {\n            AJS.dialog2(warningDialogId).hide();\n            if (typeof callbackAbort === "function") {\n                callbackAbort();\n            }\n        });\n        AJS.$(warningDialogId + "-continue").click((e) => {\n            AJS.dialog2(warningDialogId).hide();\n            if (typeof callbackContinue === "function") {\n                callbackContinue();\n            }\n        });\n    }\n    function createIFrame(pageId, cmmnDiagramId, cmmnDiagramName) {\n        const iframe = document.createElement("iframe");\n        iframe.setAttribute("id", "cmmn-editor");\n        iframe.setAttribute("style", "position: fixed; width: 100%; height: 100%; top: 0px; left: 0px; border: 0px none; z-index: 3000;");\n        iframe.setAttribute("src", Confluence.getContextPath() +\n            "/plugins/cmmn-plugin/edit-cmmndiagram.action?pageId=" +\n            pageId +\n            "&cmmnDiagramId=" +\n            cmmnDiagramId +\n            "&cmmnDiagramName=" +\n            cmmnDiagramName +\n            "&reloadPage=false");\n        iframe.onload = () => {\n            $("body").css("overflow", "hidden");\n        };\n        return iframe;\n    }\n    function insertEditVCCP(macro) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield lazyLoadI18nTexts();\n            if ((0, utils_1.getParams)().contentType === "comment") {\n                showWarningDialog("#vccp-no-diagrams-in-comments-dialog", Confluence.Templates.viadee.cmmnplugin.noDiagramsInCommentsDialog);\n                return;\n            }\n            if (macro.params) {\n                if ((0, utils_1.getParams)().newPage) {\n                    showWarningDialog("#vccp-save-first-dialog", Confluence.Templates.viadee.cmmnplugin.saveFirstDialog);\n                    return;\n                }\n                const cmmnDiagramName = macro.params.cmmnDiagramName;\n                const cmmnDiagramId = cmmnDiagramName.replace(/\\s/g, "_");\n                tinymce.confluence.macrobrowser.macroBrowserComplete({\n                    name: macroName,\n                    bodyHtml: undefined,\n                    params: macro.params,\n                });\n                $("body").append(createIFrame((0, utils_1.getParams)().pageId, cmmnDiagramId, cmmnDiagramName));\n            }\n            else {\n                clearFields();\n                AJS.dialog2(dialogId).show();\n                $input.focus();\n            }\n        });\n    }\n    function lazyLoadI18nTexts() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield new Promise((resolve) => {\n                AJS.I18n.get("de.viadee.confluence.cmmn-plugin", resolve);\n            });\n        });\n    }\n    AJS.MacroBrowser.setMacroJsOverride(macroName, {\n        opener: insertEditVCCP,\n    });\n}));\n\n\n//# sourceURL=webpack://VCCPFREE/./dialogs/vccp-macro-dialog.ts?')}},__webpack_module_cache__={};function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(t.exports,t,t.exports,__webpack_require__),t.exports}var __webpack_exports__=__webpack_require__("./dialogs/vccp-macro-dialog.ts");(window.VCCPFREE=window.VCCPFREE||{}).cmmnFreeMacroDialog=__webpack_exports__})();