(()=>{var __webpack_modules__={"./common/resources/newCmmnDiagram.cmmn":module=>{eval('module.exports = "<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?>\\n<cmmn:definitions xmlns:dc=\\"http://www.omg.org/spec/CMMN/20151109/DC\\" xmlns:di=\\"http://www.omg.org/spec/CMMN/20151109/DI\\" xmlns:cmmndi=\\"http://www.omg.org/spec/CMMN/20151109/CMMNDI\\" xmlns:cmmn=\\"http://www.omg.org/spec/CMMN/20151109/MODEL\\" xmlns:xsi=\\"http://www.w3.org/2001/XMLSchema-instance\\" id=\\"sample-diagram\\" targetNamespace=\\"http://bpmn.io/schema/cmmn\\">\\n  <cmmn:case id=\\"Case_1\\">\\n    <cmmn:casePlanModel id=\\"CasePlanModel_1\\" name=\\"A CasePlanModel\\">\\n      <cmmn:planItem id=\\"PlanItem_1\\" definitionRef=\\"Task_1\\" />\\n      <cmmn:task id=\\"Task_1\\" />\\n    </cmmn:casePlanModel>\\n  </cmmn:case>\\n  <cmmndi:CMMNDI>\\n    <cmmndi:CMMNDiagram id=\\"CMMNDiagram_1\\">\\n      <cmmndi:Size xsi:type=\\"dc:Dimension\\" width=\\"500\\" height=\\"500\\" />\\n      <cmmndi:CMMNShape id=\\"DI_CasePlanModel_1\\" cmmnElementRef=\\"CasePlanModel_1\\">\\n        <dc:Bounds x=\\"114\\" y=\\"63\\" width=\\"534\\" height=\\"389\\" />\\n        <cmmndi:CMMNLabel />\\n      </cmmndi:CMMNShape>\\n      <cmmndi:CMMNShape id=\\"PlanItem_1_di\\" cmmnElementRef=\\"PlanItem_1\\">\\n        <dc:Bounds x=\\"150\\" y=\\"96\\" width=\\"100\\" height=\\"80\\" />\\n        <cmmndi:CMMNLabel />\\n      </cmmndi:CMMNShape>\\n    </cmmndi:CMMNDiagram>\\n  </cmmndi:CMMNDI>\\n</cmmn:definitions>";\n\n//# sourceURL=webpack://VCCPFREE/./common/resources/newCmmnDiagram.cmmn?')},"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\nexports["default"] = VxcpLogger;\n\n\n//# sourceURL=webpack://VCCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./common/cmmnAttachment-manager.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getAttachmentVersion = exports.loadAttachment = exports.uploadAttachment = void 0;\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name.service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "CmmnAttachmentManager");\nfunction makeRequest(opts) {\n    return new Promise((resolve, reject) => {\n        const xhr = new XMLHttpRequest();\n        xhr.open(opts.method, opts.url, true);\n        const maxWaitTime = 10000;\n        const noResponseTimer = setTimeout(() => {\n            xhr.abort();\n            reject({\n                status: 503,\n                message: "Service unreachable",\n            });\n        }, maxWaitTime);\n        xhr.onload = () => {\n            clearTimeout(noResponseTimer);\n            if (xhr.status >= 200 && xhr.status < 300) {\n                resolve(xhr.response);\n            }\n            else {\n                reject(xhr);\n            }\n        };\n        xhr.onerror = () => {\n            clearTimeout(noResponseTimer);\n            reject(xhr);\n        };\n        if (opts.headers) {\n            Object.keys(opts.headers).forEach((key) => {\n                xhr.setRequestHeader(key, opts.headers[key]);\n            });\n        }\n        xhr.send(opts.formData);\n    });\n}\nfunction buildRestUrl(restCall, pageId) {\n    const baseUrl = window.location.protocol + "//" + window.location.host;\n    const contextPath = (0, utils_1.getParams)().contextPath;\n    const restPath = "/rest/api/content/";\n    return baseUrl + contextPath + restPath + pageId + restCall;\n}\nfunction getAttachmentListRequest(pageId) {\n    return makeRequest({\n        url: buildRestUrl("/child/attachment?start=0", pageId),\n        method: "GET",\n    });\n}\nfunction updateAttachmentRequest(attachmentId, file, fileName, pageId) {\n    const url = buildRestUrl("/child/attachment/" + attachmentId + "/data", pageId);\n    const formData = new FormData();\n    formData.append("file", file, fileName);\n    const headers = { "X-Atlassian-Token": "no-check" };\n    return makeRequest({\n        url,\n        method: "POST",\n        headers,\n        formData,\n    });\n}\nfunction uploadAttachmentRequest(file, fileName, pageId) {\n    const url = buildRestUrl("/child/attachment", pageId);\n    const formData = new FormData();\n    formData.append("file", file, fileName);\n    const headers = { "X-Atlassian-Token": "no-check" };\n    return makeRequest({\n        url,\n        method: "POST",\n        headers,\n        formData,\n    });\n}\nfunction getFileRequest(url) {\n    return makeRequest({\n        method: "GET",\n        url,\n    });\n}\nfunction getAttachmentData(attachmentList, name) {\n    return JSON.parse(attachmentList).results.filter((attachment) => {\n        return attachment.title === name;\n    });\n}\nfunction buildDownloadUrl(downloadPath) {\n    const baseUrl = window.location.protocol + "//" + window.location.host;\n    const contextPath = (0, utils_1.getParams)().contextPath;\n    return baseUrl + contextPath + downloadPath;\n}\nfunction getIdByName(attachmentList, name) {\n    const result = JSON.parse(attachmentList).results.filter((attachment) => {\n        return attachment.title === name;\n    });\n    return result.length > 0 ? result[0].id : undefined;\n}\nfunction getAttachmentHistoryRequest(attachmentId) {\n    return makeRequest({\n        url: buildRestUrl(attachmentId + "/history", ""),\n        method: "GET",\n    });\n}\nfunction uploadAttachment(file, fileName, pageId) {\n    return getAttachmentListRequest(pageId)\n        .then((attachmentList) => {\n        const attachmentId = getIdByName(attachmentList, fileName);\n        if (attachmentId) {\n            return updateAttachmentRequest(attachmentId, file, fileName, pageId);\n        }\n        else {\n            return uploadAttachmentRequest(file, fileName, pageId);\n        }\n    })\n        .catch((err) => {\n        return Promise.reject(err);\n    });\n}\nexports.uploadAttachment = uploadAttachment;\nfunction loadAttachment(name, pageId) {\n    return getAttachmentListRequest(pageId)\n        .then((attachmentList) => {\n        const attachmentData = getAttachmentData(attachmentList, name);\n        if (!attachmentData[0]) {\n            return Promise.reject({\n                status: 404,\n                responseText: "Attachment not Found",\n            });\n        }\n        else if (attachmentData.length !== 1) {\n            vxcpLogger.logWarning("loadAttachment", "Multiple corresponding CMMN attachments were found. The latest attachment will be loaded.");\n        }\n        const downloadLink = buildDownloadUrl(attachmentData[0]._links.download);\n        const attachmentId = attachmentData[0].id;\n        return getAttachmentHistoryRequest(attachmentId)\n            .then((history) => {\n            return JSON.parse(history).lastUpdated.number;\n        })\n            .then((version) => {\n            return getFileRequest(downloadLink).then((fileData) => {\n                return {\n                    data: fileData,\n                    id: attachmentId,\n                    version,\n                };\n            });\n        });\n    })\n        .catch((error) => {\n        return Promise.reject(error);\n    });\n}\nexports.loadAttachment = loadAttachment;\nfunction getAttachmentVersion(name, pageId) {\n    return getAttachmentListRequest(pageId).then((list) => {\n        const attachmentId = getIdByName(list, name);\n        if (attachmentId) {\n            return getAttachmentHistoryRequest(attachmentId).then((history) => {\n                return {\n                    id: attachmentId,\n                    version: JSON.parse(history).lastUpdated.number,\n                };\n            });\n        }\n        else {\n            return Promise.reject({\n                status: 404,\n                responseText: "Attachment not Found",\n            });\n        }\n    });\n}\nexports.getAttachmentVersion = getAttachmentVersion;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/cmmnAttachment-manager.ts?')},"./common/cmmnDiagram-manager.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.saveCmmnDiagram = exports.loadCmmnDiagram = exports.getCmmnDiagramSVG = exports.getCmmnDiagramXML = exports.showCmmnDiagram = exports.createNewCmmnDiagram = exports.openCmmnDiagram = exports.uploadCmmnDiagramToConfluence = void 0;\nconst AttachmentManager = __importStar(__webpack_require__("./common/cmmnAttachment-manager.ts"));\nconst ConfUtils = __importStar(__webpack_require__("./common/utils.ts"));\nconst CmmnDiagramState = __importStar(__webpack_require__("./common/cmmnDiagram-state.ts"));\nconst Notification = __importStar(__webpack_require__("./common/notification.ts"));\nconst newCmmnDiagramXml = __importStar(__webpack_require__("./common/newCmmnDiagramXml.ts"));\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name.service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "CmmnDiagramManager");\nfunction handleError(error, pageId) {\n    switch (error.status) {\n        case 403:\n            const confluenceLink = {\n                link: Confluence.getContextPath() + "/pages/viewpage.action?pageId=" + pageId,\n            };\n            ConfUtils.showWarningDialog(AJS, "#vccp-session-warning-dialog", Confluence.Templates.viadee.cmmnplugin.sessionWarningDialog, undefined, undefined, confluenceLink);\n            break;\n        case 0:\n            if (!CmmnDiagramState.isCmmnDiagramSaved()) {\n                ConfUtils.showWarningDialog(AJS, "#vccp-connection-warning-dialog", Confluence.Templates.viadee.cmmnplugin.connectionWarningDialog);\n            }\n            break;\n        case 503:\n            ConfUtils.showWarningDialog(AJS, "#vccp-connection-warning-dialog", Confluence.Templates.viadee.cmmnplugin.connectionWarningDialog);\n            break;\n        default:\n            vxcpLogger.logError("handleError", "Error occurred. Either the resource you tried to get is forbidden or there is no connection or the server is not available right now.", error);\n    }\n}\nfunction setVersion(version) {\n    CmmnDiagramState.setCmmnDiagramVersion(version);\n    CmmnDiagramState.saveCmmnDiagram(true);\n    const $cmmnDiagramVersionLabel = AJS.$("#vccp-diagram-version");\n    $cmmnDiagramVersionLabel.html("(v." + CmmnDiagramState.getDiagramVersion() + ")");\n}\nfunction hideCmmnDiagramChange() {\n    const $saveLink = AJS.$("#content > div.toolbar > ul > li:nth-child(1) > a");\n    const $resetLink = AJS.$("#content > div.toolbar > ul > li:nth-child(2) > a");\n    const $cmmnDiagramNameLabel = AJS.$("#vccp-diagram-name");\n    $saveLink.removeClass("active");\n    $resetLink.removeClass("active");\n    $cmmnDiagramNameLabel.text($cmmnDiagramNameLabel.text().replace(/\\*/g, ""));\n    $cmmnDiagramNameLabel.css("font-style", "");\n    CmmnDiagramState.saveCmmnDiagram(true);\n    deactivateButton($saveLink);\n    deactivateButton($resetLink);\n}\nfunction deactivateButton($link) {\n    $link.css({ cursor: "default" });\n    $link.off();\n    $link.click((e) => {\n        e.preventDefault();\n        e.stopPropagation();\n    });\n}\nfunction updateVersion(cmmnDiagramName, pageId) {\n    AttachmentManager.getAttachmentVersion(cmmnDiagramName + ".cmmn", pageId).then((attachment) => {\n        setVersion(attachment.version);\n    });\n}\nfunction uploadCmmnDiagramToConfluence(modeler, cmmnDiagramName, pageId) {\n    getCmmnDiagramXML(modeler, (err, xml) => {\n        const attachment = new Blob([xml]);\n        AttachmentManager.uploadAttachment(attachment, cmmnDiagramName + ".cmmn", pageId)\n            .then((req) => {\n            updateVersion(cmmnDiagramName, pageId);\n            hideCmmnDiagramChange();\n        })\n            .catch((e) => {\n            vxcpLogger.logError("uploadCmmnDiagramToConfluence", "Error occurred while uploading the CMMN diagram to Confluence.", e);\n        });\n    });\n}\nexports.uploadCmmnDiagramToConfluence = uploadCmmnDiagramToConfluence;\nfunction openCmmnDiagram(modeler, xml, cmmnDiagramName, callbackFn) {\n    const $loadingText = AJS.$("#cmmndiagram-loading");\n    modeler.importXML(xml, (err, warnings) => {\n        $loadingText.hide();\n        if (err || warnings.length) {\n            vxcpLogger.logError("openCmmnDiagram", "An error occurred while opening CMMN diagram. The CMMN file, which you try to open, is probably broken or has an invalid format.", err || warnings.length);\n            callbackFn = undefined;\n            ConfUtils.showWarningDialog(AJS, "#vccp-diagram-warning-dialog", Confluence.Templates.viadee.cmmnplugin.diagramWarningDialog);\n        }\n        if (typeof callbackFn === "function") {\n            callbackFn();\n        }\n        const vccpEditCanvas = modeler.get("canvas");\n        vccpEditCanvas.zoom("fit-viewport");\n    });\n}\nexports.openCmmnDiagram = openCmmnDiagram;\nfunction createNewCmmnDiagram(modeler, cmmnDiagramName) {\n    openCmmnDiagram(modeler, newCmmnDiagramXml.getNewCmmnDiagramXml(), cmmnDiagramName);\n}\nexports.createNewCmmnDiagram = createNewCmmnDiagram;\nfunction showCmmnDiagram(modeler, attachment, cmmnDiagramName, callbackFn) {\n    setVersion(attachment.version);\n    openCmmnDiagram(modeler, attachment.data, cmmnDiagramName, callbackFn);\n}\nexports.showCmmnDiagram = showCmmnDiagram;\nfunction getCmmnDiagramXML(modeler, doneCallback) {\n    modeler.saveXML({ format: true }, (err, xml) => {\n        doneCallback(err, xml);\n    });\n}\nexports.getCmmnDiagramXML = getCmmnDiagramXML;\nfunction getCmmnDiagramSVG(modeler, doneCallback) {\n    modeler.saveSVG((err, xml) => {\n        doneCallback(err, xml);\n    });\n}\nexports.getCmmnDiagramSVG = getCmmnDiagramSVG;\nfunction loadCmmnDiagram(modeler, cmmnDiagramName, pageId, reset) {\n    const $loadingText = AJS.$("#cmmndiagram-loading");\n    $loadingText.show();\n    AttachmentManager.loadAttachment(cmmnDiagramName + ".cmmn", pageId)\n        .then((attachment) => {\n        if (reset) {\n            if (attachment.version !== CmmnDiagramState.getDiagramVersion()) {\n                $loadingText.hide();\n                Notification.show(AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.editor.notification.diagramUpdated"));\n            }\n            else {\n                ConfUtils.showWarningDialog(AJS, "#vccp-reload-warning-dialog", Confluence.Templates.viadee.cmmnplugin.reloadWarningDialog, () => {\n                    showCmmnDiagram(modeler, attachment, cmmnDiagramName, hideCmmnDiagramChange());\n                }, () => {\n                    $loadingText.hide();\n                });\n            }\n        }\n        else {\n            showCmmnDiagram(modeler, attachment, cmmnDiagramName, hideCmmnDiagramChange());\n        }\n    })\n        .catch((err) => {\n        if (err.status === 404) {\n            if (reset) {\n                ConfUtils.showWarningDialog(AJS, "#vccp-reload-warning-dialog", Confluence.Templates.viadee.cmmnplugin.reloadWarningDialog, () => {\n                    createNewCmmnDiagram(modeler, cmmnDiagramName);\n                    hideCmmnDiagramChange();\n                }, () => {\n                    $loadingText.hide();\n                });\n            }\n            else {\n                createNewCmmnDiagram(modeler, cmmnDiagramName);\n            }\n        }\n        else {\n            handleError(err, pageId);\n        }\n    });\n}\nexports.loadCmmnDiagram = loadCmmnDiagram;\nfunction saveCmmnDiagram(modeler, cmmnDiagramName, pageId) {\n    AttachmentManager.getAttachmentVersion(cmmnDiagramName + ".cmmn", pageId)\n        .then((attachment) => {\n        if (attachment.version !== CmmnDiagramState.getDiagramVersion()) {\n            ConfUtils.showWarningDialog(AJS, "#vccp-save-warning-dialog", Confluence.Templates.viadee.cmmnplugin.saveWarningDialog, () => {\n                uploadCmmnDiagramToConfluence(modeler, cmmnDiagramName, pageId);\n            });\n        }\n        else {\n            uploadCmmnDiagramToConfluence(modeler, cmmnDiagramName, pageId);\n        }\n    })\n        .catch((err) => {\n        if (err.status === 404) {\n            uploadCmmnDiagramToConfluence(modeler, cmmnDiagramName, pageId);\n        }\n        else {\n            handleError(err, pageId);\n        }\n    });\n}\nexports.saveCmmnDiagram = saveCmmnDiagram;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/cmmnDiagram-manager.ts?')},"./common/cmmnDiagram-state.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getDiagramVersion = exports.setCmmnDiagramVersion = exports.isCmmnDiagramSaved = exports.saveCmmnDiagram = void 0;\nlet cmmnDiagramSaved = true;\nlet cmmnDiagramVersion = "";\nfunction saveCmmnDiagram(predicate) {\n    cmmnDiagramSaved = predicate;\n}\nexports.saveCmmnDiagram = saveCmmnDiagram;\nfunction isCmmnDiagramSaved() {\n    return cmmnDiagramSaved;\n}\nexports.isCmmnDiagramSaved = isCmmnDiagramSaved;\nfunction setCmmnDiagramVersion(version) {\n    cmmnDiagramVersion = version;\n}\nexports.setCmmnDiagramVersion = setCmmnDiagramVersion;\nfunction getDiagramVersion() {\n    return cmmnDiagramVersion;\n}\nexports.getDiagramVersion = getDiagramVersion;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/cmmnDiagram-state.ts?')},"./common/newCmmnDiagramXml.ts":(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getNewCmmnDiagramXml = void 0;\nconst newCmmnDiagram = __webpack_require__("./common/resources/newCmmnDiagram.cmmn");\nconst getNewCmmnDiagramXml = () => newCmmnDiagram;\nexports.getNewCmmnDiagramXml = getNewCmmnDiagramXml;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/newCmmnDiagramXml.ts?')},"./common/notification.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.show = void 0;\nfunction show(message) {\n    if (!("Notification" in window)) {\n        alert(message);\n    }\n    else if (Notification.permission === "granted") {\n        const notification = new Notification(message);\n    }\n    else if (Notification.permission !== "denied") {\n        Notification.requestPermission((permission) => {\n            if (permission === "granted") {\n                const notification = new Notification(message);\n            }\n        });\n    }\n}\nexports.show = show;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/notification.ts?')},"./common/plugin-name.service.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.pluginName = void 0;\nexports.pluginName = "CMMN-PLUGIN";\n\n\n//# sourceURL=webpack://VCCPFREE/./common/plugin-name.service.ts?')},"./common/utils.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getRemoteUserKey = exports.getCurrentUserFullName = exports.getConfluenceVersion = exports.getSpaceName = exports.getSpaceKey = exports.getBaseUrl = exports.isNewPage = exports.getContextPath = exports.getUserLocale = exports.getLatestPageId = exports.getContentType = exports.getPageId = exports.getAccessMode = exports.getContentId = exports.getParams = exports.initViadeeLogo = exports.showWarningDialog = exports.getQueryParam = void 0;\nfunction getQueryParam(param) {\n    const result = window.location.search.match(new RegExp("(\\\\?|&)" + param + "(\\\\[\\\\])?=([^&]*)"));\n    return result ? result[3] : 0;\n}\nexports.getQueryParam = getQueryParam;\nfunction showWarningDialog(AJS, dialogId, template, callbackContinue, callbackAbort, params) {\n    const dialog = template(params);\n    AJS.$("body").append(dialog);\n    AJS.dialog2(dialogId).show();\n    AJS.$(dialogId).show();\n    AJS.dialog2(dialogId).on("hide", () => {\n        AJS.$(dialogId).remove();\n    });\n    AJS.$(dialogId + "-abort").click((e) => {\n        AJS.dialog2(dialogId).hide();\n        if (typeof callbackAbort === "function") {\n            callbackAbort();\n        }\n    });\n    AJS.$(dialogId + "-continue").click((e) => {\n        AJS.dialog2(dialogId).hide();\n        if (typeof callbackContinue === "function") {\n            callbackContinue();\n        }\n    });\n}\nexports.showWarningDialog = showWarningDialog;\nfunction initViadeeLogo(cmmnDiagramName) {\n    cmmnDiagramName = cmmnDiagramName.replace(" ", "_");\n    const viadeeLogoId = "viadee-logo-viewer-" + cmmnDiagramName;\n    const viadeeLogoName = AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.icon.title.name.viadee.logo");\n    const modelerLink = AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.icon.title.name.viadee.logo-link");\n    const viadeeLogo = createViadeeLogo(viadeeLogoId, viadeeLogoName, "22", "30");\n    $("#vccp-viewer-" + cmmnDiagramName + " .cjs-container").append(viadeeLogo);\n    $(`#${viadeeLogoId}`).on("click", (event) => {\n        window.open(modelerLink, "_blank");\n        event.preventDefault();\n    });\n    function createViadeeLogo(btnId, titleName, positionBottom, positionLeft) {\n        const title = `title="${titleName}"`;\n        const htmlCode = `<div id="${btnId}"\n            class="viadee-logo-viewer"\n            position="absolute"\n            style="bottom: ${positionBottom}px; left: ${positionLeft}px;" ${title}>\n            </div>`;\n        return htmlCode;\n    }\n}\nexports.initViadeeLogo = initViadeeLogo;\nfunction getParams() {\n    return {\n        accessMode: getAccessMode(),\n        baseUrl: getBaseUrl(),\n        currentUserFullname: getCurrentUserFullName(),\n        versionNumber: getConfluenceVersion(),\n        newPage: isNewPage(),\n        spaceKey: getSpaceKey(),\n        spaceName: getSpaceName(),\n        pageId: getPageId(),\n        contentType: getContentType(),\n        latestPageId: getLatestPageId(),\n        userLocale: getUserLocale(),\n        contextPath: getContextPath(),\n        remoteUserKey: getRemoteUserKey(),\n        contentId: getContentId(),\n    };\n}\nexports.getParams = getParams;\nfunction getContentId() {\n    return Confluence.getContentId() ? Confluence.getContentId() : AJS.Meta.get("content-id");\n}\nexports.getContentId = getContentId;\nfunction getAccessMode() {\n    return AJS.Meta.get("access-mode");\n}\nexports.getAccessMode = getAccessMode;\nfunction getPageId() {\n    return AJS.Meta.get("page-id");\n}\nexports.getPageId = getPageId;\nfunction getContentType() {\n    return AJS.Meta.get("content-type");\n}\nexports.getContentType = getContentType;\nfunction getLatestPageId() {\n    return AJS.Meta.get("latest-page-id");\n}\nexports.getLatestPageId = getLatestPageId;\nfunction getUserLocale() {\n    return AJS.Meta.get("user-locale");\n}\nexports.getUserLocale = getUserLocale;\nfunction getContextPath() {\n    return AJS.Meta.get("context-path") || Confluence.getContextPath();\n}\nexports.getContextPath = getContextPath;\nfunction isNewPage() {\n    return AJS.Meta.get("new-page");\n}\nexports.isNewPage = isNewPage;\nfunction getBaseUrl() {\n    return AJS.Meta.get("base-url");\n}\nexports.getBaseUrl = getBaseUrl;\nfunction getSpaceKey() {\n    return AJS.Meta.get("space-key");\n}\nexports.getSpaceKey = getSpaceKey;\nfunction getSpaceName() {\n    return AJS.Meta.get("space-name");\n}\nexports.getSpaceName = getSpaceName;\nfunction getConfluenceVersion() {\n    return AJS.Meta.get("version-number");\n}\nexports.getConfluenceVersion = getConfluenceVersion;\nfunction getCurrentUserFullName() {\n    return AJS.Meta.get("current-user-fullname");\n}\nexports.getCurrentUserFullName = getCurrentUserFullName;\nfunction getRemoteUserKey() {\n    return AJS.Meta.get("remote-user-key");\n}\nexports.getRemoteUserKey = getRemoteUserKey;\n\n\n//# sourceURL=webpack://VCCPFREE/./common/utils.ts?')},"./editor/cmmnEditorApp.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.CmmnEditorApp = void 0;\nconst Modeler_1 = __importDefault(__webpack_require__("./node_modules/cmmn-js/lib/Modeler.js"));\nconst diagram_js_origin_1 = __importDefault(__webpack_require__("./node_modules/diagram-js-origin/index.js"));\nconst confUtils = __importStar(__webpack_require__("./common/utils.ts"));\nconst CmmnDiagramManager = __importStar(__webpack_require__("./common/cmmnDiagram-manager.ts"));\nconst CmmnDiagramState = __importStar(__webpack_require__("./common/cmmnDiagram-state.ts"));\nconst file_saver_1 = __importDefault(__webpack_require__("./node_modules/file-saver/dist/FileSaver.min.js"));\nclass CmmnEditorApp {\n    constructor() {\n        this.pageId = "";\n        this.cmmnDiagramId = "";\n        this.cmmnDiagramName = "";\n    }\n    init(pageId, cmmnDiagramId, cmmnDiagramName) {\n        this.pageId = pageId;\n        this.cmmnDiagramId = cmmnDiagramId;\n        this.cmmnDiagramName = cmmnDiagramName;\n        this.initJqueryIdentifiers();\n        this.cmmnModeler = this.initModeler();\n        this.initButtonActions();\n        this.initShortcuts();\n        this.initLeavePageAction();\n        this.initDragAndDrop();\n        this.initFileUpload();\n        CmmnDiagramManager.loadCmmnDiagram(this.cmmnModeler, cmmnDiagramName, pageId, false);\n        this.cmmnModeler.on("commandStack.changed", () => {\n            this.onCmmnDiagramChange(this.cmmnModeler, cmmnDiagramName, pageId);\n        });\n    }\n    initJqueryIdentifiers() {\n        this.$modeler = $("#modeler");\n        this.$container = this.$modeler.find(".content");\n        this.$canvas = this.$modeler.find(".canvas-editor");\n        this.$loadingText = this.$modeler.find("#cmmndiagram-loading");\n        const $toolbar = $(".toolbar");\n        this.$downloadLink = $toolbar.find("a.js-download");\n        this.$downloadSvgLink = $toolbar.find("a.js-download-svg");\n        this.$saveLink = $toolbar.find("a.js-save");\n        this.$resetLink = $toolbar.find("a.js-reset");\n        this.$createLink = $toolbar.find("a.js-create");\n        this.$exitLink = $toolbar.find("a.js-exit");\n        this.$importLink = $toolbar.find("a.js-import");\n        this.$importInput = $toolbar.find("#vccp-diagram-import");\n        const $title = $("#vccp-diagram-title");\n        this.$cmmnDiagramNameLabel = $title.find("#vccp-diagram-name");\n        this.$cmmnDiagramVersionLabel = $title.find("#vccp-diagram-version");\n    }\n    initModeler() {\n        return new Modeler_1.default({\n            container: this.$canvas,\n            additionalModules: [diagram_js_origin_1.default],\n            keyboard: { bindTo: document },\n        });\n    }\n    initFileUpload() {\n        const input = document.getElementById("vccp-diagram-import");\n        const keyFile = "File";\n        const keyFileReader = "FileReader";\n        const keyFileList = "FileList";\n        if (!window[keyFile] || !window[keyFileReader] || !window[keyFileList] || !window.Blob) {\n            alert("The File APIs are not fully supported in this browser.");\n            return;\n        }\n        if (!input) {\n            alert("Could not find the file input element.");\n        }\n        else if (!input.files) {\n            alert("This browser does not seem to support the `files` property of file inputs.");\n        }\n        else {\n            input.addEventListener("change", () => {\n                const file = input.files[0];\n                if (file.name.match(/\\.(cmmn|xml)$/)) {\n                    const reader = new FileReader();\n                    reader.onload = () => {\n                        CmmnDiagramManager.openCmmnDiagram(this.cmmnModeler, reader.result, this.cmmnDiagramName, () => {\n                            this.onCmmnDiagramChange(this.cmmnModeler, this.cmmnDiagramName, this.pageId);\n                        });\n                    };\n                    reader.readAsText(file);\n                }\n                else {\n                    confUtils.showWarningDialog(AJS, "#vccp-file-warning-dialog", Confluence.Templates.viadee.cmmnplugin.fileWarningDialog);\n                }\n            });\n            input.onclick = (e) => {\n                e.target.value = null;\n            };\n        }\n    }\n    initButtonActions() {\n        this.$createLink.click((e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            CmmnDiagramManager.createNewCmmnDiagram(this.cmmnModeler, this.cmmnDiagramName);\n        });\n        this.$exitLink.click((e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            if (!CmmnDiagramState.isCmmnDiagramSaved()) {\n                confUtils.showWarningDialog(AJS, "#vccp-exit-warning-dialog", Confluence.Templates.viadee.cmmnplugin.exitWarningDialog, this.exitModeler);\n            }\n            else {\n                this.exitModeler();\n            }\n        });\n        this.$importLink.click((e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            if (!CmmnDiagramState.isCmmnDiagramSaved()) {\n                confUtils.showWarningDialog(AJS, "#vccp-import-warning-dialog", Confluence.Templates.viadee.cmmnplugin.importWarningDialog, () => {\n                    this.$importInput.click();\n                });\n            }\n            else {\n                this.$importInput.click();\n            }\n        });\n        $(".buttons a").click((e) => {\n            if (!$(e.target).is(".active")) {\n                e.preventDefault();\n                e.stopPropagation();\n            }\n        });\n        this.$downloadLink.click((e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            CmmnDiagramManager.getCmmnDiagramXML(this.cmmnModeler, (err, xml) => {\n                const blobObject = new Blob([xml]);\n                this.downloadBlob(blobObject, this.cmmnDiagramName, ".cmmn");\n            });\n        });\n        this.$downloadSvgLink.click((e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            CmmnDiagramManager.getCmmnDiagramSVG(this.cmmnModeler, (err, svg) => {\n                const blobObject = new Blob([svg]);\n                this.downloadBlob(blobObject, this.cmmnDiagramName, ".svg");\n            });\n        });\n    }\n    downloadBlob(fileBlob, fileName, fileType) {\n        if (!(fileBlob instanceof Blob)) {\n            fileBlob = new Blob([fileBlob]);\n        }\n        try {\n            file_saver_1.default.saveAs(fileBlob, fileName + fileType);\n        }\n        catch (e) {\n            alert("The file could not be downloaded. Please try a different browser.");\n        }\n    }\n    initShortcuts() {\n        $(window).bind("keypress", (event) => {\n            this.checkKeyCodes(event);\n        });\n        $(window).bind("keydown", (event) => {\n            this.checkKeyCodes(event);\n        });\n    }\n    checkKeyCodes(event) {\n        if (event.ctrlKey || event.metaKey) {\n            switch (String.fromCharCode(event.which).toLowerCase()) {\n                case "s":\n                    event.preventDefault();\n                    this.$saveLink.click();\n                    break;\n            }\n        }\n    }\n    initLeavePageAction() {\n        window.onbeforeunload = () => {\n            if (CmmnDiagramState.isCmmnDiagramSaved()) {\n                return;\n            }\n            return AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.exit-warning-dialog.desc");\n        };\n    }\n    initDragAndDrop() {\n        function registerFileDrop($container, callback) {\n            function handleFileSelect(e) {\n                e.stopPropagation();\n                e.preventDefault();\n                const files = e.dataTransfer.files;\n                const file = files[0];\n                const reader = new FileReader();\n                reader.onload = (event) => {\n                    const currentElement = event.target;\n                    const xml = currentElement.result;\n                    callback(xml);\n                };\n                reader.readAsText(file);\n            }\n            function handleDragOver(e) {\n                e.stopPropagation();\n                e.preventDefault();\n                e.dataTransfer.dropEffect = "copy";\n            }\n            $container.get(0).addEventListener("dragover", handleDragOver, false);\n            $container.get(0).addEventListener("drop", handleFileSelect, false);\n        }\n        $(document).on("keypress", (e) => {\n            const body = e.target;\n            if (body && body.contentEditable && body.classList) {\n                e.stopImmediatePropagation();\n            }\n        });\n        const keyFileList = "FileList";\n        const keyFileReader = "FileReader";\n        if (!window[keyFileList] || !window[keyFileReader]) {\n            window.alert(AJS.I18n.getText("de.viadee.confluence.cmmn-plugin.editor.notification.diagramUpdated"));\n        }\n        else {\n            registerFileDrop(this.$container, (xml) => {\n                CmmnDiagramManager.openCmmnDiagram(this.cmmnModeler, xml, this.cmmnDiagramName, () => {\n                    this.onCmmnDiagramChange(this.cmmnModeler, this.cmmnDiagramName, this.pageId);\n                });\n            });\n        }\n    }\n    onCmmnDiagramChange(modeler, cmmnDiagramName, pageId) {\n        this.$saveLink.addClass("active");\n        this.$resetLink.addClass("active");\n        this.$cmmnDiagramNameLabel.html(cmmnDiagramName + "*").css("font-style", "italic");\n        CmmnDiagramState.saveCmmnDiagram(false);\n        activateButton(this.$saveLink, () => {\n            CmmnDiagramManager.saveCmmnDiagram(modeler, cmmnDiagramName, pageId);\n        });\n        activateButton(this.$resetLink, () => {\n            CmmnDiagramManager.loadCmmnDiagram(modeler, cmmnDiagramName, pageId, true);\n        });\n        function activateButton($link, action) {\n            $link.css({ cursor: "pointer" });\n            $link.off();\n            $link.click((e) => {\n                e.preventDefault();\n                e.stopPropagation();\n                action();\n            });\n        }\n    }\n    exitModeler() {\n        CmmnDiagramState.saveCmmnDiagram(true);\n        const reloadPage = confUtils.getQueryParam("reloadPage");\n        if (reloadPage === "true") {\n            window.parent.location.reload();\n        }\n        else {\n            $("body", window.parent.document).css("overflow", "");\n            $("#cmmn-editor", window.parent.document).remove();\n        }\n    }\n}\nexports.CmmnEditorApp = CmmnEditorApp;\n\n\n//# sourceURL=webpack://VCCPFREE/./editor/cmmnEditorApp.ts?')},"./node_modules/diagram-js-direct-editing/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ diagram_js_direct_editing)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/interaction-events/index.js + 4 modules\nvar interaction_events = __webpack_require__(\"./node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-direct-editing/lib/TextBox.js\n\n\n\n\nvar min = Math.min,\n    max = Math.max;\n\nfunction preventDefault(e) {\n  e.preventDefault();\n}\n\nfunction stopPropagation(e) {\n  e.stopPropagation();\n}\n\nfunction isTextNode(node) {\n  return node.nodeType === Node.TEXT_NODE;\n}\n\nfunction toArray(nodeList) {\n  return [].slice.call(nodeList);\n}\n\n/**\n * Initializes a container for a content editable div.\n *\n * Structure:\n *\n * container\n *   parent\n *     content\n *     resize-handle\n *\n * @param {object} options\n * @param {DOMElement} options.container The DOM element to append the contentContainer to\n * @param {Function} options.keyHandler Handler for key events\n * @param {Function} options.resizeHandler Handler for resize events\n */\nfunction TextBox(options) {\n  this.container = options.container;\n\n  this.parent = (0,dist_index_esm/* domify */.H6)(\n    '<div class=\"djs-direct-editing-parent\">' +\n      '<div class=\"djs-direct-editing-content\" contenteditable=\"true\"></div>' +\n    '</div>'\n  );\n\n  this.content = (0,dist_index_esm/* query */.IO)('[contenteditable]', this.parent);\n\n  this.keyHandler = options.keyHandler || function() {};\n  this.resizeHandler = options.resizeHandler || function() {};\n\n  this.autoResize = (0,index_esm/* bind */.ak)(this.autoResize, this);\n  this.handlePaste = (0,index_esm/* bind */.ak)(this.handlePaste, this);\n}\n\n\n/**\n * Create a text box with the given position, size, style and text content\n *\n * @param {Object} bounds\n * @param {Number} bounds.x absolute x position\n * @param {Number} bounds.y absolute y position\n * @param {Number} [bounds.width] fixed width value\n * @param {Number} [bounds.height] fixed height value\n * @param {Number} [bounds.maxWidth] maximum width value\n * @param {Number} [bounds.maxHeight] maximum height value\n * @param {Number} [bounds.minWidth] minimum width value\n * @param {Number} [bounds.minHeight] minimum height value\n * @param {Object} [style]\n * @param {String} value text content\n *\n * @return {DOMElement} The created content DOM element\n */\nTextBox.prototype.create = function(bounds, style, value, options) {\n  var self = this;\n\n  var parent = this.parent,\n      content = this.content,\n      container = this.container;\n\n  options = this.options = options || {};\n\n  style = this.style = style || {};\n\n  var parentStyle = (0,index_esm/* pick */.ei)(style, [\n    'width',\n    'height',\n    'maxWidth',\n    'maxHeight',\n    'minWidth',\n    'minHeight',\n    'left',\n    'top',\n    'backgroundColor',\n    'position',\n    'overflow',\n    'border',\n    'wordWrap',\n    'textAlign',\n    'outline',\n    'transform'\n  ]);\n\n  (0,index_esm/* assign */.f0)(parent.style, {\n    width: bounds.width + 'px',\n    height: bounds.height + 'px',\n    maxWidth: bounds.maxWidth + 'px',\n    maxHeight: bounds.maxHeight + 'px',\n    minWidth: bounds.minWidth + 'px',\n    minHeight: bounds.minHeight + 'px',\n    left: bounds.x + 'px',\n    top: bounds.y + 'px',\n    backgroundColor: '#ffffff',\n    position: 'absolute',\n    overflow: 'visible',\n    border: '1px solid #ccc',\n    boxSizing: 'border-box',\n    wordWrap: 'normal',\n    textAlign: 'center',\n    outline: 'none'\n  }, parentStyle);\n\n  var contentStyle = (0,index_esm/* pick */.ei)(style, [\n    'fontFamily',\n    'fontSize',\n    'fontWeight',\n    'lineHeight',\n    'padding',\n    'paddingTop',\n    'paddingRight',\n    'paddingBottom',\n    'paddingLeft'\n  ]);\n\n  (0,index_esm/* assign */.f0)(content.style, {\n    boxSizing: 'border-box',\n    width: '100%',\n    outline: 'none',\n    wordWrap: 'break-word'\n  }, contentStyle);\n\n  if (options.centerVertically) {\n    (0,index_esm/* assign */.f0)(content.style, {\n      position: 'absolute',\n      top: '50%',\n      transform: 'translate(0, -50%)'\n    }, contentStyle);\n  }\n\n  content.innerText = value;\n\n  dist_index_esm/* event.bind */.B.bind(content, 'keydown', this.keyHandler);\n  dist_index_esm/* event.bind */.B.bind(content, 'mousedown', stopPropagation);\n  dist_index_esm/* event.bind */.B.bind(content, 'paste', self.handlePaste);\n\n  if (options.autoResize) {\n    dist_index_esm/* event.bind */.B.bind(content, 'input', this.autoResize);\n  }\n\n  if (options.resizable) {\n    this.resizable(style);\n  }\n\n  container.appendChild(parent);\n\n  // set selection to end of text\n  this.setSelection(content.lastChild, content.lastChild && content.lastChild.length);\n\n  return parent;\n};\n\n/**\n * Intercept paste events to remove formatting from pasted text.\n */\nTextBox.prototype.handlePaste = function(e) {\n  var options = this.options,\n      style = this.style;\n\n  e.preventDefault();\n\n  var text;\n\n  if (e.clipboardData) {\n\n    // Chrome, Firefox, Safari\n    text = e.clipboardData.getData('text/plain');\n  } else {\n\n    // Internet Explorer\n    text = window.clipboardData.getData('Text');\n  }\n\n  this.insertText(text);\n\n  if (options.autoResize) {\n    var hasResized = this.autoResize(style);\n\n    if (hasResized) {\n      this.resizeHandler(hasResized);\n    }\n  }\n};\n\nTextBox.prototype.insertText = function(text) {\n  text = normalizeEndOfLineSequences(text);\n\n  // insertText command not supported by Internet Explorer\n  var success = document.execCommand('insertText', false, text);\n\n  if (success) {\n    return;\n  }\n\n  this._insertTextIE(text);\n};\n\nTextBox.prototype._insertTextIE = function(text) {\n\n  // Internet Explorer\n  var range = this.getSelection(),\n      startContainer = range.startContainer,\n      endContainer = range.endContainer,\n      startOffset = range.startOffset,\n      endOffset = range.endOffset,\n      commonAncestorContainer = range.commonAncestorContainer;\n\n  var childNodesArray = toArray(commonAncestorContainer.childNodes);\n\n  var container,\n      offset;\n\n  if (isTextNode(commonAncestorContainer)) {\n    var containerTextContent = startContainer.textContent;\n\n    startContainer.textContent =\n      containerTextContent.substring(0, startOffset)\n      + text\n      + containerTextContent.substring(endOffset);\n\n    container = startContainer;\n    offset = startOffset + text.length;\n\n  } else if (startContainer === this.content && endContainer === this.content) {\n    var textNode = document.createTextNode(text);\n\n    this.content.insertBefore(textNode, childNodesArray[startOffset]);\n\n    container = textNode;\n    offset = textNode.textContent.length;\n  } else {\n    var startContainerChildIndex = childNodesArray.indexOf(startContainer),\n        endContainerChildIndex = childNodesArray.indexOf(endContainer);\n\n    childNodesArray.forEach(function(childNode, index) {\n\n      if (index === startContainerChildIndex) {\n        childNode.textContent =\n          startContainer.textContent.substring(0, startOffset) +\n          text +\n          endContainer.textContent.substring(endOffset);\n      } else if (index > startContainerChildIndex && index <= endContainerChildIndex) {\n        (0,dist_index_esm/* remove */.Od)(childNode);\n      }\n    });\n\n    container = startContainer;\n    offset = startOffset + text.length;\n  }\n\n  if (container && offset !== undefined) {\n\n    // is necessary in Internet Explorer\n    setTimeout(function() {\n      self.setSelection(container, offset);\n    });\n  }\n};\n\n/**\n * Automatically resize element vertically to fit its content.\n */\nTextBox.prototype.autoResize = function() {\n  var parent = this.parent,\n      content = this.content;\n\n  var fontSize = parseInt(this.style.fontSize) || 12;\n\n  if (content.scrollHeight > parent.offsetHeight ||\n      content.scrollHeight < parent.offsetHeight - fontSize) {\n    var bounds = parent.getBoundingClientRect();\n\n    var height = content.scrollHeight;\n    parent.style.height = height + 'px';\n\n    this.resizeHandler({\n      width: bounds.width,\n      height: bounds.height,\n      dx: 0,\n      dy: height - bounds.height\n    });\n  }\n};\n\n/**\n * Make an element resizable by adding a resize handle.\n */\nTextBox.prototype.resizable = function() {\n  var self = this;\n\n  var parent = this.parent,\n      resizeHandle = this.resizeHandle;\n\n  var minWidth = parseInt(this.style.minWidth) || 0,\n      minHeight = parseInt(this.style.minHeight) || 0,\n      maxWidth = parseInt(this.style.maxWidth) || Infinity,\n      maxHeight = parseInt(this.style.maxHeight) || Infinity;\n\n  if (!resizeHandle) {\n    resizeHandle = this.resizeHandle = (0,dist_index_esm/* domify */.H6)(\n      '<div class=\"djs-direct-editing-resize-handle\"></div>'\n    );\n\n    var startX, startY, startWidth, startHeight;\n\n    var onMouseDown = function(e) {\n      preventDefault(e);\n      stopPropagation(e);\n\n      startX = e.clientX;\n      startY = e.clientY;\n\n      var bounds = parent.getBoundingClientRect();\n\n      startWidth = bounds.width;\n      startHeight = bounds.height;\n\n      dist_index_esm/* event.bind */.B.bind(document, 'mousemove', onMouseMove);\n      dist_index_esm/* event.bind */.B.bind(document, 'mouseup', onMouseUp);\n    };\n\n    var onMouseMove = function(e) {\n      preventDefault(e);\n      stopPropagation(e);\n\n      var newWidth = min(max(startWidth + e.clientX - startX, minWidth), maxWidth);\n      var newHeight = min(max(startHeight + e.clientY - startY, minHeight), maxHeight);\n\n      parent.style.width = newWidth + 'px';\n      parent.style.height = newHeight + 'px';\n\n      self.resizeHandler({\n        width: startWidth,\n        height: startHeight,\n        dx: e.clientX - startX,\n        dy: e.clientY - startY\n      });\n    };\n\n    var onMouseUp = function(e) {\n      preventDefault(e);\n      stopPropagation(e);\n\n      dist_index_esm/* event.unbind */.B.unbind(document,'mousemove', onMouseMove, false);\n      dist_index_esm/* event.unbind */.B.unbind(document, 'mouseup', onMouseUp, false);\n    };\n\n    dist_index_esm/* event.bind */.B.bind(resizeHandle, 'mousedown', onMouseDown);\n  }\n\n  (0,index_esm/* assign */.f0)(resizeHandle.style, {\n    position: 'absolute',\n    bottom: '0px',\n    right: '0px',\n    cursor: 'nwse-resize',\n    width: '0',\n    height: '0',\n    borderTop: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent',\n    borderRight: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',\n    borderBottom: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',\n    borderLeft: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent'\n  });\n\n  parent.appendChild(resizeHandle);\n};\n\n\n/**\n * Clear content and style of the textbox, unbind listeners and\n * reset CSS style.\n */\nTextBox.prototype.destroy = function() {\n  var parent = this.parent,\n      content = this.content,\n      resizeHandle = this.resizeHandle;\n\n  // clear content\n  content.innerText = '';\n\n  // clear styles\n  parent.removeAttribute('style');\n  content.removeAttribute('style');\n\n  dist_index_esm/* event.unbind */.B.unbind(content, 'keydown', this.keyHandler);\n  dist_index_esm/* event.unbind */.B.unbind(content, 'mousedown', stopPropagation);\n  dist_index_esm/* event.unbind */.B.unbind(content, 'input', this.autoResize);\n  dist_index_esm/* event.unbind */.B.unbind(content, 'paste', this.handlePaste);\n\n  if (resizeHandle) {\n    resizeHandle.removeAttribute('style');\n\n    (0,dist_index_esm/* remove */.Od)(resizeHandle);\n  }\n\n  (0,dist_index_esm/* remove */.Od)(parent);\n};\n\n\nTextBox.prototype.getValue = function() {\n  return this.content.innerText.trim();\n};\n\n\nTextBox.prototype.getSelection = function() {\n  var selection = window.getSelection(),\n      range = selection.getRangeAt(0);\n\n  return range;\n};\n\n\nTextBox.prototype.setSelection = function(container, offset) {\n  var range = document.createRange();\n\n  if (container === null) {\n    range.selectNodeContents(this.content);\n  } else {\n    range.setStart(container, offset);\n    range.setEnd(container, offset);\n  }\n\n  var selection = window.getSelection();\n\n  selection.removeAllRanges();\n  selection.addRange(range);\n};\n\n// helpers //////////\n\nfunction normalizeEndOfLineSequences(string) {\n  return string.replace(/\\r\\n|\\r|\\n/g, '\\n');\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-direct-editing/lib/DirectEditing.js\n\n\n\n\n\n/**\n * A direct editing component that allows users\n * to edit an elements text directly in the diagram\n *\n * @param {EventBus} eventBus the event bus\n */\nfunction DirectEditing(eventBus, canvas) {\n\n  this._eventBus = eventBus;\n\n  this._providers = [];\n  this._textbox = new TextBox({\n    container: canvas.getContainer(),\n    keyHandler: (0,index_esm/* bind */.ak)(this._handleKey, this),\n    resizeHandler: (0,index_esm/* bind */.ak)(this._handleResize, this)\n  });\n}\n\nDirectEditing.$inject = [ 'eventBus', 'canvas' ];\n\n\n/**\n * Register a direct editing provider\n\n * @param {Object} provider the provider, must expose an #activate(element) method that returns\n *                          an activation context ({ bounds: {x, y, width, height }, text }) if\n *                          direct editing is available for the given element.\n *                          Additionally the provider must expose a #update(element, value) method\n *                          to receive direct editing updates.\n */\nDirectEditing.prototype.registerProvider = function(provider) {\n  this._providers.push(provider);\n};\n\n\n/**\n * Returns true if direct editing is currently active\n *\n * @param {djs.model.Base} [element]\n *\n * @return {boolean}\n */\nDirectEditing.prototype.isActive = function(element) {\n  return !!(this._active && (!element || this._active.element === element));\n};\n\n\n/**\n * Cancel direct editing, if it is currently active\n */\nDirectEditing.prototype.cancel = function() {\n  if (!this._active) {\n    return;\n  }\n\n  this._fire('cancel');\n  this.close();\n};\n\n\nDirectEditing.prototype._fire = function(event, context) {\n  this._eventBus.fire('directEditing.' + event, context || { active: this._active });\n};\n\nDirectEditing.prototype.close = function() {\n  this._textbox.destroy();\n\n  this._fire('deactivate');\n\n  this._active = null;\n\n  this.resizable = undefined;\n};\n\n\nDirectEditing.prototype.complete = function() {\n\n  var active = this._active;\n\n  if (!active) {\n    return;\n  }\n\n  var containerBounds,\n      previousBounds = active.context.bounds,\n      newBounds = this.$textbox.getBoundingClientRect(),\n      newText = this.getValue(),\n      previousText = active.context.text;\n\n  if (\n    newText !== previousText ||\n    newBounds.height !== previousBounds.height ||\n    newBounds.width !== previousBounds.width\n  ) {\n    containerBounds = this._textbox.container.getBoundingClientRect();\n\n    active.provider.update(active.element, newText, active.context.text, {\n      x: newBounds.left - containerBounds.left,\n      y: newBounds.top - containerBounds.top,\n      width: newBounds.width,\n      height: newBounds.height\n    });\n  }\n\n  this._fire('complete');\n\n  this.close();\n};\n\n\nDirectEditing.prototype.getValue = function() {\n  return this._textbox.getValue();\n};\n\n\nDirectEditing.prototype._handleKey = function(e) {\n\n  // stop bubble\n  e.stopPropagation();\n\n  var key = e.keyCode || e.charCode;\n\n  // ESC\n  if (key === 27) {\n    e.preventDefault();\n    return this.cancel();\n  }\n\n  // Enter\n  if (key === 13 && !e.shiftKey) {\n    e.preventDefault();\n    return this.complete();\n  }\n};\n\n\nDirectEditing.prototype._handleResize = function(event) {\n  this._fire('resize', event);\n};\n\n\n/**\n * Activate direct editing on the given element\n *\n * @param {Object} ElementDescriptor the descriptor for a shape or connection\n * @return {Boolean} true if the activation was possible\n */\nDirectEditing.prototype.activate = function(element) {\n  if (this.isActive()) {\n    this.cancel();\n  }\n\n  // the direct editing context\n  var context;\n\n  var provider = (0,index_esm/* find */.sE)(this._providers, function(p) {\n    return ((context = p.activate(element))) ? p : null;\n  });\n\n  // check if activation took place\n  if (context) {\n    this.$textbox = this._textbox.create(\n      context.bounds,\n      context.style,\n      context.text,\n      context.options\n    );\n\n    this._active = {\n      element: element,\n      context: context,\n      provider: provider\n    };\n\n    if (context.options && context.options.resizable) {\n      this.resizable = true;\n    }\n\n    this._fire('activate');\n  }\n\n  return !!context;\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js-direct-editing/index.js\n\n\n\n\n/* harmony default export */ const diagram_js_direct_editing = ({\n  __depends__: [\n    interaction_events/* default */.Z\n  ],\n  __init__: [ 'directEditing' ],\n  directEditing: [ 'type', DirectEditing ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/diagram-js-direct-editing/index.js_+_2_modules?")},"./node_modules/diagram-js-origin/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"default\": () => (/* binding */ diagram_js_origin)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js-origin/node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js-origin/node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/lib/configure-origin.js\n\n\nvar CROSS_COLOR = '#CCC',\n    BORDER_COLOR = 'rgba(0,0,0,0.1)';\n\n\n/**\n * A diagram-js extension that shows a (0, 0) origin indicator\n * on the canvas as well as (optionally) the canvas borders.\n *\n * @param {Object} [config]\n * @param {Canvas} canvas\n */\nfunction ConfigureOrigin(config, canvas) {\n\n  config = config || {};\n\n  var borderColor = config.borderColor || BORDER_COLOR,\n      crossColor = config.crossColor || CROSS_COLOR ;\n\n  var w = 30, h = 2,\n      w_half = w / 2,\n      s = -h / 2,\n      lineStart = w_half + 7;\n\n  var parent = canvas.getLayer('djs-origin', -1);\n\n  var g,\n      line,\n      cross,\n      label;\n\n  g = createEl('g', {\n    'pointer-events': 'none'\n  });\n\n  (0,index_esm/* append */.R3)(parent, g);\n\n  if (config.showBorder !== false) {\n\n    // the dashed lines, marking positive document coordinates\n    line = createEl('path', {\n      'class': cls('border'),\n      'd': path([\n        'M', -lineStart, s,\n        'H', -1000,\n        'M', lineStart, s,\n        'H', 6000,\n        'M', s, -lineStart,\n        'V', -1000,\n        'M', s, lineStart,\n        'V', 3000\n      ]),\n      'fill': 'none',\n      'stroke': borderColor,\n      'stroke-width': h + 'px',\n      'stroke-dasharray': '6, 6',\n      'shape-rendering': 'crispedges'\n    });\n\n    (0,index_esm/* append */.R3)(g, line);\n  }\n\n  // the cross that marks the diagram origin\n  cross = createEl('path', {\n    d: path([\n      'M', -w_half, s,\n      'H', w_half,\n      'M', s, -w_half,\n      'V', w_half\n    ]),\n    'class': cls('cross'),\n    'fill': 'none',\n    'stroke': crossColor,\n    'stroke-width': h + 'px',\n    'stroke-linecap': 'round'\n  });\n\n  (0,index_esm/* append */.R3)(g, cross);\n\n  label = createEl('text', {\n    x: -40,\n    y: -10,\n    fill: crossColor,\n    'class': cls('label'),\n  });\n\n  label.textContent = '(0, 0)';\n\n  (0,index_esm/* append */.R3)(g, label);\n}\n\nConfigureOrigin.$inject = [\n  'config.origin',\n  'canvas'\n];\n\n\n// helpers ///////////////////////////////////\n\nfunction path(parts) {\n  return parts.join(' ');\n}\n\nfunction cls(name) {\n  return 'djs-origin-' + name;\n}\n\nfunction createEl(type, attrs) {\n\n  var el = (0,index_esm/* create */.Ue)(type);\n\n  (0,index_esm/* attr */.Lj)(el, attrs);\n\n  return el;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/index.js\n\n\n/* harmony default export */ const diagram_js_origin = ({\n  __init__: [\n    ConfigureOrigin\n  ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/diagram-js-origin/index.js_+_1_modules?")}},__webpack_module_cache__={},deferred;function __webpack_require__(n){var e=__webpack_module_cache__[n];if(void 0!==e)return e.exports;var t=__webpack_module_cache__[n]={exports:{}};return __webpack_modules__[n].call(t.exports,t,t.exports,__webpack_require__),t.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(n,e,t,a)=>{if(!e){var i=1/0;for(m=0;m<deferred.length;m++){for(var[e,t,a]=deferred[m],r=!0,o=0;o<e.length;o++)(!1&a||i>=a)&&Object.keys(__webpack_require__.O).every((n=>__webpack_require__.O[n](e[o])))?e.splice(o--,1):(r=!1,a<i&&(i=a));if(r){deferred.splice(m--,1);var s=t();void 0!==s&&(n=s)}}return n}a=a||0;for(var m=deferred.length;m>0&&deferred[m-1][2]>a;m--)deferred[m]=deferred[m-1];deferred[m]=[e,t,a]},__webpack_require__.n=n=>{var e=n&&n.__esModule?()=>n.default:()=>n;return __webpack_require__.d(e,{a:e}),e},__webpack_require__.d=(n,e)=>{for(var t in e)__webpack_require__.o(e,t)&&!__webpack_require__.o(n,t)&&Object.defineProperty(n,t,{enumerable:!0,get:e[t]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(n){if("object"==typeof window)return window}}(),__webpack_require__.o=(n,e)=>Object.prototype.hasOwnProperty.call(n,e),__webpack_require__.r=n=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(n,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(n,"__esModule",{value:!0})},__webpack_require__.j="cmmnFreeEditor",(()=>{var n={cmmnFreeEditor:0};__webpack_require__.O.j=e=>0===n[e];var e=(e,t)=>{var a,i,[r,o,s]=t,m=0;if(r.some((e=>0!==n[e]))){for(a in o)__webpack_require__.o(o,a)&&(__webpack_require__.m[a]=o[a]);if(s)var c=s(__webpack_require__)}for(e&&e(t);m<r.length;m++)i=r[m],__webpack_require__.o(n,i)&&n[i]&&n[i][0](),n[i]=0;return __webpack_require__.O(c)},t=self.webpackChunkVCCPFREE=self.webpackChunkVCCPFREE||[];t.forEach(e.bind(null,0)),t.push=e.bind(null,t.push.bind(t))})();var __webpack_exports__=__webpack_require__.O(void 0,["cmmnFreeCmmnJs","cmmnFreeVendors","cmmnFreeDiagramJs"],(()=>__webpack_require__("./editor/cmmnEditorApp.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VCCPFREE=window.VCCPFREE||{}).cmmnFreeEditor=__webpack_exports__})();