"use strict";(self.webpackChunkVCCPFREE=self.webpackChunkVCCPFREE||[]).push([["cmmnFreeDiagramJs"],{"./node_modules/diagram-js/lib/features/interaction-events/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ interaction_events)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/util/Event.js\nfunction __stopPropagation(event) {\n  if (!event || typeof event.stopPropagation !== 'function') {\n    return;\n  }\n\n  event.stopPropagation();\n}\n\n\nfunction getOriginal(event) {\n  return event.originalEvent || event.srcEvent;\n}\n\n\nfunction stopPropagation(event, immediate) {\n  __stopPropagation(event, immediate);\n  __stopPropagation(getOriginal(event), immediate);\n}\n\n\nfunction toPoint(event) {\n\n  if (event.pointers && event.pointers.length) {\n    event = event.pointers[0];\n  }\n\n  if (event.touches && event.touches.length) {\n    event = event.touches[0];\n  }\n\n  return event ? {\n    x: event.clientX,\n    y: event.clientY\n  } : null;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/util/Mouse.js\n\n\n\n\n\n\nfunction isButton(event, button) {\n  return (getOriginal(event) || event).button === button;\n}\n\nfunction isPrimaryButton(event) {\n\n  // button === 0 -> left áka primary mouse button\n  return isButton(event, 0);\n}\n\nfunction isAuxiliaryButton(event) {\n\n  // button === 1 -> auxiliary áka wheel button\n  return isButton(event, 1);\n}\n\nfunction isSecondaryButton(event) {\n\n  // button === 2 -> right áka secondary button\n  return isButton(event, 2);\n}\n\nfunction hasPrimaryModifier(event) {\n  var originalEvent = getOriginalEvent(event) || event;\n\n  if (!isPrimaryButton(event)) {\n    return false;\n  }\n\n  // Use cmd as primary modifier key for mac OS\n  if (isMac()) {\n    return originalEvent.metaKey;\n  } else {\n    return originalEvent.ctrlKey;\n  }\n}\n\n\nfunction hasSecondaryModifier(event) {\n  var originalEvent = getOriginalEvent(event) || event;\n\n  return isPrimaryButton(event) && originalEvent.shiftKey;\n}\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/diagram-js/node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/util/RenderUtil.js\n\n\n\nfunction componentsToPath(elements) {\n  return elements.join(',').replace(/,?([A-z]),?/g, '$1');\n}\n\nfunction toSVGPoints(points) {\n  var result = '';\n\n  for (var i = 0, p; (p = points[i]); i++) {\n    result += p.x + ',' + p.y + ' ';\n  }\n\n  return result;\n}\n\nfunction createLine(points, attrs) {\n\n  var line = (0,tiny_svg_dist_index_esm/* create */.Ue)('polyline');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(line, { points: toSVGPoints(points) });\n\n  if (attrs) {\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(line, attrs);\n  }\n\n  return line;\n}\n\nfunction updateLine(gfx, points) {\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(gfx, { points: toSVGPoints(points) });\n\n  return gfx;\n}\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/interaction-events/InteractionEvents.js\n\n\n\n\n\n\n\n\n\n\nfunction allowAll(event) { return true; }\n\nfunction allowPrimaryAndAuxiliary(event) {\n  return isPrimaryButton(event) || isAuxiliaryButton(event);\n}\n\nvar LOW_PRIORITY = 500;\n\n\n/**\n * A plugin that provides interaction events for diagram elements.\n *\n * It emits the following events:\n *\n *   * element.click\n *   * element.contextmenu\n *   * element.dblclick\n *   * element.hover\n *   * element.mousedown\n *   * element.mousemove\n *   * element.mouseup\n *   * element.out\n *\n * Each event is a tuple { element, gfx, originalEvent }.\n *\n * Canceling the event via Event#preventDefault()\n * prevents the original DOM operation.\n *\n * @param {EventBus} eventBus\n */\nfunction InteractionEvents(eventBus, elementRegistry, styles) {\n\n  var self = this;\n\n  /**\n   * Fire an interaction event.\n   *\n   * @param {string} type local event name, e.g. element.click.\n   * @param {DOMEvent} event native event\n   * @param {djs.model.Base} [element] the diagram element to emit the event on;\n   *                                   defaults to the event target\n   */\n  function fire(type, event, element) {\n\n    if (isIgnored(type, event)) {\n      return;\n    }\n\n    var target, gfx, returnValue;\n\n    if (!element) {\n      target = event.delegateTarget || event.target;\n\n      if (target) {\n        gfx = target;\n        element = elementRegistry.get(gfx);\n      }\n    } else {\n      gfx = elementRegistry.getGraphics(element);\n    }\n\n    if (!gfx || !element) {\n      return;\n    }\n\n    returnValue = eventBus.fire(type, {\n      element: element,\n      gfx: gfx,\n      originalEvent: event\n    });\n\n    if (returnValue === false) {\n      event.stopPropagation();\n      event.preventDefault();\n    }\n  }\n\n  // TODO(nikku): document this\n  var handlers = {};\n\n  function mouseHandler(localEventName) {\n    return handlers[localEventName];\n  }\n\n  function isIgnored(localEventName, event) {\n\n    var filter = ignoredFilters[localEventName] || isPrimaryButton;\n\n    // only react on left mouse button interactions\n    // except for interaction events that are enabled\n    // for secundary mouse button\n    return !filter(event);\n  }\n\n  var bindings = {\n    click: 'element.click',\n    contextmenu: 'element.contextmenu',\n    dblclick: 'element.dblclick',\n    mousedown: 'element.mousedown',\n    mousemove: 'element.mousemove',\n    mouseover: 'element.hover',\n    mouseout: 'element.out',\n    mouseup: 'element.mouseup',\n  };\n\n  var ignoredFilters = {\n    'element.contextmenu': allowAll,\n    'element.mousedown': allowPrimaryAndAuxiliary,\n    'element.mouseup': allowPrimaryAndAuxiliary,\n    'element.click': allowPrimaryAndAuxiliary,\n    'element.dblclick': allowPrimaryAndAuxiliary\n  };\n\n\n  // manual event trigger //////////\n\n  /**\n   * Trigger an interaction event (based on a native dom event)\n   * on the target shape or connection.\n   *\n   * @param {string} eventName the name of the triggered DOM event\n   * @param {MouseEvent} event\n   * @param {djs.model.Base} targetElement\n   */\n  function triggerMouseEvent(eventName, event, targetElement) {\n\n    // i.e. element.mousedown...\n    var localEventName = bindings[eventName];\n\n    if (!localEventName) {\n      throw new Error('unmapped DOM event name <' + eventName + '>');\n    }\n\n    return fire(localEventName, event, targetElement);\n  }\n\n\n  var ELEMENT_SELECTOR = 'svg, .djs-element';\n\n  // event handling ///////\n\n  function registerEvent(node, event, localEvent, ignoredFilter) {\n\n    var handler = handlers[localEvent] = function(event) {\n      fire(localEvent, event);\n    };\n\n    if (ignoredFilter) {\n      ignoredFilters[localEvent] = ignoredFilter;\n    }\n\n    handler.$delegate = dist_index_esm/* delegate.bind */.cl.bind(node, ELEMENT_SELECTOR, event, handler);\n  }\n\n  function unregisterEvent(node, event, localEvent) {\n\n    var handler = mouseHandler(localEvent);\n\n    if (!handler) {\n      return;\n    }\n\n    dist_index_esm/* delegate.unbind */.cl.unbind(node, event, handler.$delegate);\n  }\n\n  function registerEvents(svg) {\n    (0,index_esm/* forEach */.Ed)(bindings, function(val, key) {\n      registerEvent(svg, key, val);\n    });\n  }\n\n  function unregisterEvents(svg) {\n    (0,index_esm/* forEach */.Ed)(bindings, function(val, key) {\n      unregisterEvent(svg, key, val);\n    });\n  }\n\n  eventBus.on('canvas.destroy', function(event) {\n    unregisterEvents(event.svg);\n  });\n\n  eventBus.on('canvas.init', function(event) {\n    registerEvents(event.svg);\n  });\n\n\n  // hit box updating ////////////////\n\n  eventBus.on([ 'shape.added', 'connection.added' ], function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    eventBus.fire('interactionEvents.createHit', { element: element, gfx: gfx });\n  });\n\n  // Update djs-hit on change.\n  // A low priortity is necessary, because djs-hit of labels has to be updated\n  // after the label bounds have been updated in the renderer.\n  eventBus.on([\n    'shape.changed',\n    'connection.changed'\n  ], LOW_PRIORITY, function(event) {\n\n    var element = event.element,\n        gfx = event.gfx;\n\n    eventBus.fire('interactionEvents.updateHit', { element: element, gfx: gfx });\n  });\n\n  eventBus.on('interactionEvents.createHit', LOW_PRIORITY, function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    self.createDefaultHit(element, gfx);\n  });\n\n  eventBus.on('interactionEvents.updateHit', function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    self.updateDefaultHit(element, gfx);\n  });\n\n\n  // hit styles ////////////\n\n  var STROKE_HIT_STYLE = createHitStyle('djs-hit djs-hit-stroke');\n\n  var CLICK_STROKE_HIT_STYLE = createHitStyle('djs-hit djs-hit-click-stroke');\n\n  var ALL_HIT_STYLE = createHitStyle('djs-hit djs-hit-all');\n\n  var NO_MOVE_HIT_STYLE = createHitStyle('djs-hit djs-hit-no-move');\n\n  var HIT_TYPES = {\n    'all': ALL_HIT_STYLE,\n    'click-stroke': CLICK_STROKE_HIT_STYLE,\n    'stroke': STROKE_HIT_STYLE,\n    'no-move': NO_MOVE_HIT_STYLE\n  };\n\n  function createHitStyle(classNames, attrs) {\n\n    attrs = (0,index_esm/* assign */.f0)({\n      stroke: 'white',\n      strokeWidth: 15\n    }, attrs || {});\n\n    return styles.cls(classNames, [ 'no-fill', 'no-border' ], attrs);\n  }\n\n\n  // style helpers ///////////////\n\n  function applyStyle(hit, type) {\n\n    var attrs = HIT_TYPES[type];\n\n    if (!attrs) {\n      throw new Error('invalid hit type <' + type + '>');\n    }\n\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, attrs);\n\n    return hit;\n  }\n\n  function appendHit(gfx, hit) {\n    (0,tiny_svg_dist_index_esm/* append */.R3)(gfx, hit);\n  }\n\n\n  // API\n\n  /**\n   * Remove hints on the given graphics.\n   *\n   * @param {SVGElement} gfx\n   */\n  this.removeHits = function(gfx) {\n    var hits = (0,dist_index_esm/* queryAll */.Kt)('.djs-hit', gfx);\n\n    (0,index_esm/* forEach */.Ed)(hits, tiny_svg_dist_index_esm/* remove */.Od);\n  };\n\n  /**\n   * Create default hit for the given element.\n   *\n   * @param {djs.model.Base} element\n   * @param {SVGElement} gfx\n   *\n   * @return {SVGElement} created hit\n   */\n  this.createDefaultHit = function(element, gfx) {\n    var waypoints = element.waypoints,\n        isFrame = element.isFrame,\n        boxType;\n\n    if (waypoints) {\n      return this.createWaypointsHit(gfx, waypoints);\n    } else {\n\n      boxType = isFrame ? 'stroke' : 'all';\n\n      return this.createBoxHit(gfx, boxType, {\n        width: element.width,\n        height: element.height\n      });\n    }\n  };\n\n  /**\n   * Create hits for the given waypoints.\n   *\n   * @param {SVGElement} gfx\n   * @param {Array<Point>} waypoints\n   *\n   * @return {SVGElement}\n   */\n  this.createWaypointsHit = function(gfx, waypoints) {\n\n    var hit = createLine(waypoints);\n\n    applyStyle(hit, 'stroke');\n\n    appendHit(gfx, hit);\n\n    return hit;\n  };\n\n  /**\n   * Create hits for a box.\n   *\n   * @param {SVGElement} gfx\n   * @param {string} hitType\n   * @param {Object} attrs\n   *\n   * @return {SVGElement}\n   */\n  this.createBoxHit = function(gfx, type, attrs) {\n\n    attrs = (0,index_esm/* assign */.f0)({\n      x: 0,\n      y: 0\n    }, attrs);\n\n    var hit = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n\n    applyStyle(hit, type);\n\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, attrs);\n\n    appendHit(gfx, hit);\n\n    return hit;\n  };\n\n  /**\n   * Update default hit of the element.\n   *\n   * @param  {djs.model.Base} element\n   * @param  {SVGElement} gfx\n   *\n   * @return {SVGElement} updated hit\n   */\n  this.updateDefaultHit = function(element, gfx) {\n\n    var hit = (0,dist_index_esm/* query */.IO)('.djs-hit', gfx);\n\n    if (!hit) {\n      return;\n    }\n\n    if (element.waypoints) {\n      updateLine(hit, element.waypoints);\n    } else {\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, {\n        width: element.width,\n        height: element.height\n      });\n    }\n\n    return hit;\n  };\n\n  this.fire = fire;\n\n  this.triggerMouseEvent = triggerMouseEvent;\n\n  this.mouseHandler = mouseHandler;\n\n  this.registerEvent = registerEvent;\n  this.unregisterEvent = unregisterEvent;\n}\n\n\nInteractionEvents.$inject = [\n  'eventBus',\n  'elementRegistry',\n  'styles'\n];\n\n\n/**\n * An event indicating that the mouse hovered over an element\n *\n * @event element.hover\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has left an element\n *\n * @event element.out\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has clicked an element\n *\n * @event element.click\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has double clicked an element\n *\n * @event element.dblclick\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has gone down on an element.\n *\n * @event element.mousedown\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has gone up on an element.\n *\n * @event element.mouseup\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the context menu action is triggered\n * via mouse or touch controls.\n *\n * @event element.contextmenu\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n;// CONCATENATED MODULE: ./node_modules/diagram-js/lib/features/interaction-events/index.js\n\n\n/* harmony default export */ const interaction_events = ({\n  __init__: [ 'interactionEvents' ],\n  interactionEvents: [ 'type', InteractionEvents ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/diagram-js/lib/features/interaction-events/index.js_+_4_modules?")}}]);