(self.webpackChunkVCCPFREE=self.webpackChunkVCCPFREE||[]).push([["cmmnFreeCmmnJs"],{"./node_modules/cmmn-js/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = __webpack_require__("./node_modules/cmmn-js/lib/Viewer.js");\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/index.js?')},"./node_modules/cmmn-js/lib/Modeler.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar inherits = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n\nvar Ids = __webpack_require__("./node_modules/ids/index.js");\n\nvar Viewer = __webpack_require__("./node_modules/cmmn-js/lib/Viewer.js");\n\nvar NavigatedViewer = __webpack_require__("./node_modules/cmmn-js/lib/NavigatedViewer.js");\n\nvar initialDiagram = \'<?xml version="1.0" encoding="UTF-8"?>\' +\n  \'<cmmn:definitions xmlns:dc="http://www.omg.org/spec/CMMN/20151109/DC" \' +\n                    \'xmlns:di="http://www.omg.org/spec/CMMN/20151109/DI" \' +\n                    \'xmlns:cmmndi="http://www.omg.org/spec/CMMN/20151109/CMMNDI" \' +\n                    \'xmlns:cmmn="http://www.omg.org/spec/CMMN/20151109/MODEL" \' +\n                    \'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" id="Test" \' +\n                    \'targetNamespace="http://bpmn.io/schema/cmmn">\' +\n    \'<cmmn:case id="Case_1">\' +\n      \'<cmmn:casePlanModel id="CasePlanModel_1" name="A CasePlanModel">\' +\n        \'<cmmn:planItem id="PlanItem_1" definitionRef="Task_1" />\' +\n        \'<cmmn:task id="Task_1" />\' +\n      \'</cmmn:casePlanModel>\' +\n    \'</cmmn:case>\' +\n    \'<cmmndi:CMMNDI>\' +\n      \'<cmmndi:CMMNDiagram id="CMMNDiagram_1">\' +\n        \'<cmmndi:Size width="500" height="500" />\' +\n        \'<cmmndi:CMMNShape id="DI_CasePlanModel_1" cmmnElementRef="CasePlanModel_1">\' +\n          \'<dc:Bounds x="114" y="63" width="534" height="389" />\' +\n          \'<cmmndi:CMMNLabel />\' +\n        \'</cmmndi:CMMNShape>\' +\n        \'<cmmndi:CMMNShape id="PlanItem_1_di" cmmnElementRef="PlanItem_1">\' +\n          \'<dc:Bounds x="150" y="96" width="100" height="80" />\' +\n          \'<cmmndi:CMMNLabel />\' +\n        \'</cmmndi:CMMNShape>\' +\n      \'</cmmndi:CMMNDiagram>\' +\n    \'</cmmndi:CMMNDI>\' +\n  \'</cmmn:definitions>\';\n\n/**\n * A modeler for CMMN 1.1 diagrams.\n *\n * Have a look at {@link NavigatedViewer} or {@link Modeler} for bundles that include\n * additional features.\n\n *\n * ## Extending the Modeler\n *\n * In order to extend the viewer pass extension modules to bootstrap via the\n * `additionalModules` option. An extension module is an object that exposes\n * named services.\n *\n * The following example depicts the integration of a simple\n * logging component that integrates with interaction events:\n *\n *\n * ```javascript\n *\n * // logging component\n * function InteractionLogger(eventBus) {\n *   eventBus.on(\'element.hover\', function(event) {\n *     console.log()\n *   })\n * }\n *\n * InteractionLogger.$inject = [ \'eventBus\' ]; // minification save\n *\n * // extension module\n * var extensionModule = {\n *   __init__: [ \'interactionLogger\' ],\n *   interactionLogger: [ \'type\', InteractionLogger ]\n * };\n *\n * // extend the viewer\n * var cmmnModeler = new Modeler({ additionalModules: [ extensionModule ] });\n * cmmnModeler.importXML(...);\n * ```\n *\n *\n * ## Customizing / Replacing Components\n *\n * You can replace individual diagram components by redefining them in override modules.\n * This works for all components, including those defined in the core.\n *\n * Pass in override modules via the `options.additionalModules` flag like this:\n *\n * ```javascript\n * function CustomContextPadProvider(contextPad) {\n *\n *   contextPad.registerProvider(this);\n *\n *   this.getContextPadEntries = function(element) {\n *     // no entries, effectively disable the context pad\n *     return {};\n *   };\n * }\n *\n * CustomContextPadProvider.$inject = [ \'contextPad\' ];\n *\n * var overrideModule = {\n *   contextPadProvider: [ \'type\', CustomContextPadProvider ]\n * };\n *\n * var cmmnModeler = new Modeler({ additionalModules: [ overrideModule ]});\n * ```\n *\n * @param {Object} [options] configuration options to pass to the viewer\n * @param {DOMElement} [options.container] the container to attach to\n * @param {String|Number} [options.width] the width of the viewer\n * @param {String|Number} [options.height] the height of the viewer\n * @param {Object} [options.moddleExtensions] extension packages to provide\n * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules\n * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules\n */\nfunction Modeler(options) {\n  Viewer.call(this, options);\n\n  // hook ID collection into the modeler\n  this.on(\'import.parse.complete\', function(event) {\n    if (!event.error) {\n      this._collectIds(event.definitions, event.context);\n    }\n  }, this);\n\n  this.on(\'diagram.destroy\', function() {\n    this.get(\'moddle\').ids.clear();\n  }, this);\n}\n\ninherits(Modeler, Viewer);\n\nmodule.exports = Modeler;\n\nmodule.exports.Viewer = Viewer;\n\nmodule.exports.NavigatedViewer = NavigatedViewer;\n\n/**\n * Create a new diagram to start modeling.\n *\n * @param {Function} [done]\n */\nModeler.prototype.createDiagram = function(done) {\n  return this.importXML(initialDiagram, done);\n};\n\n/**\n * Create a moddle instance, attaching ids to it.\n *\n * @param {Object} options\n */\nModeler.prototype._createModdle = function(options) {\n  var moddle = Viewer.prototype._createModdle.call(this, options);\n\n  // attach ids to moddle to be able to track\n  // and validated ids in the CMMN 1.1 XML document\n  // tree\n  moddle.ids = new Ids([ 32, 36, 1 ]);\n\n  return moddle;\n};\n\n/**\n * Collect ids processed during parsing of the\n * definitions object.\n *\n * @param {ModdleElement} definitions\n * @param {Context} context\n */\nModeler.prototype._collectIds = function(definitions, context) {\n\n  var moddle = definitions.$model,\n      ids = moddle.ids,\n      id;\n\n  // remove references from previous import\n  ids.clear();\n\n  for (id in context.elementsById) {\n    ids.claim(id, context.elementsById[id]);\n  }\n};\n\n\nModeler.prototype._interactionModules = [\n  // non-modeling components\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-scroll/index.js")/* ["default"] */ .Z),\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/keyboard-move/index.js")/* ["default"] */ .Z),\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/movecanvas/index.js")/* ["default"] */ .Z),\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/zoomscroll/index.js")/* ["default"] */ .Z),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/outline/index.js")\n];\n\nModeler.prototype._modelingModules = [\n  // modeling components\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/index.js")/* ["default"] */ .Z),\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard-move-selection/index.js")/* ["default"] */ .Z),\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/move/index.js")/* ["default"] */ .Z),\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/index.js")/* ["default"] */ .Z),\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connection-preview/index.js")/* ["default"] */ .Z),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/auto-resize/index.js"),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/context-pad/index.js"),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/editor-actions/index.js"),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/keyboard/index.js"),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/label-editing/index.js"),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/modeling/index.js"),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/palette/index.js"),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/snapping/index.js"),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/search/index.js"),\n  __webpack_require__("./node_modules/cmmn-js/lib/features/replace-preview/index.js")\n];\n\n\n// modules the modeler is composed of\n//\n// - viewer modules\n// - interaction modules\n// - modeling modules\n\nModeler.prototype._modules = [].concat(\n  Modeler.prototype._modules,\n  Modeler.prototype._interactionModules,\n  Modeler.prototype._modelingModules);\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/Modeler.js?')},"./node_modules/cmmn-js/lib/NavigatedViewer.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar inherits = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n\nvar Viewer = __webpack_require__("./node_modules/cmmn-js/lib/Viewer.js");\n\n\n/**\n * A viewer that includes mouse navigation facilities\n *\n * @param {Object} options\n */\nfunction NavigatedViewer(options) {\n  Viewer.call(this, options);\n}\n\ninherits(NavigatedViewer, Viewer);\n\nmodule.exports = NavigatedViewer;\n\nNavigatedViewer.prototype._navigationModules = [\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/zoomscroll/index.js")/* ["default"] */ .Z),\n  (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/movecanvas/index.js")/* ["default"] */ .Z)\n];\n\nNavigatedViewer.prototype._modules = [].concat(\n  NavigatedViewer.prototype._modules,\n  NavigatedViewer.prototype._navigationModules);\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/NavigatedViewer.js?')},"./node_modules/cmmn-js/lib/Viewer.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("/**\n * The code in the <project-logo></project-logo> area\n * must not be changed.\n *\n * @see http://bpmn.io/license for more information.\n */\n\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0),\n    omit = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .omit */ .CE),\n    isNumber = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .isNumber */ .hj);\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar domify = (__webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\")/* .domify */ .H6),\n    domQuery = (__webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\")/* .query */ .IO),\n    domRemove = (__webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\")/* .remove */ .Od);\n\nvar innerSVG = (__webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\")/* .innerSVG */ .db);\n\nvar Diagram = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/index.js\")/* [\"default\"] */ .Z),\n    CmmnModdle = (__webpack_require__(\"./node_modules/cmmn-moddle/index.js\")/* [\"default\"] */ .Z);\n\nvar Importer = __webpack_require__(\"./node_modules/cmmn-js/lib/import/Importer.js\");\n\n\nfunction checkValidationError(err) {\n\n  // check if we can help the user by indicating wrong CMMN 1.1 xml\n  // (in case he or the exporting tool did not get that right)\n\n  var pattern = /unparsable content <([^>]+)> detected([\\s\\S]*)$/;\n  var match = pattern.exec(err.message);\n\n  if (match) {\n    err.message =\n      'unparsable content <' + match[1] + '> detected; ' +\n      'this may indicate an invalid CMMN 1.1 diagram file' + match[2];\n  }\n\n  return err;\n}\n\nvar DEFAULT_OPTIONS = {\n  width: '100%',\n  height: '100%',\n  position: 'relative'\n};\n\n\n/**\n * Ensure the passed argument is a proper unit (defaulting to px)\n */\nfunction ensureUnit(val) {\n  return val + (isNumber(val) ? 'px' : '');\n}\n\n/**\n * A viewer for CMMN 1.1 diagrams.\n *\n * Have a look at {@link NavigatedViewer} or {@link Modeler} for bundles that include\n * additional features.\n *\n *\n * ## Extending the Viewer\n *\n * In order to extend the viewer pass extension modules to bootstrap via the\n * `additionalModules` option. An extension module is an object that exposes\n * named services.\n *\n * The following example depicts the integration of a simple\n * logging component that integrates with interaction events:\n *\n *\n * ```javascript\n *\n * // logging component\n * function InteractionLogger(eventBus) {\n *   eventBus.on('element.hover', function(event) {\n *     console.log()\n *   })\n * }\n *\n * InteractionLogger.$inject = [ 'eventBus' ]; // minification save\n *\n * // extension module\n * var extensionModule = {\n *   __init__: [ 'interactionLogger' ],\n *   interactionLogger: [ 'type', InteractionLogger ]\n * };\n *\n * // extend the viewer\n * var cmmnViewer = new Viewer({ additionalModules: [ extensionModule ] });\n * cmmnViewer.importXML(...);\n * ```\n *\n * @param {Object} [options] configuration options to pass to the viewer\n * @param {DOMElement} [options.container] the container to attach to\n * @param {String|Number} [options.width] the width of the viewer\n * @param {String|Number} [options.height] the height of the viewer\n * @param {Object} [options.moddleExtensions] extension packages to provide\n * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules\n * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules\n */\nfunction Viewer(options) {\n\n  options = assign({}, DEFAULT_OPTIONS, options);\n\n  this._moddle = this._createModdle(options);\n\n  this._container = this._createContainer(options);\n\n  /* <project-logo> */\n\n  addProjectLogo(this._container);\n\n  /* </project-logo> */\n\n  this._init(this._container, this._moddle, options);\n}\n\ninherits(Viewer, Diagram);\n\nmodule.exports = Viewer;\n\n\n/**\n * Parse and render a CMMN 1.1 diagram.\n *\n * Once finished the viewer reports back the result to the\n * provided callback function with (err, warnings).\n *\n * ## Life-Cycle Events\n *\n * During import the viewer will fire life-cycle events:\n *\n *   * import.parse.start (about to read model from xml)\n *   * import.parse.complete (model read; may have worked or not)\n *   * import.render.start (graphical import start)\n *   * import.render.complete (graphical import finished)\n *   * import.done (everything done)\n *\n * You can use these events to hook into the life-cycle.\n *\n * @param {String} xml the CMMN 1.1 xml\n * @param {Function} [done] invoked with (err, warnings=[])\n */\nViewer.prototype.importXML = function(xml, done) {\n\n  // done is optional\n  done = done || function() {};\n\n  var self = this;\n\n  // hook in pre-parse listeners +\n  // allow xml manipulation\n  xml = this._emit('import.parse.start', { xml: xml }) || xml;\n\n  this._moddle.fromXML(xml, 'cmmn:Definitions', function(err, definitions, context) {\n\n    // hook in post parse listeners +\n    // allow definitions manipulation\n    definitions = self._emit('import.parse.complete', {\n      error: err,\n      definitions: definitions,\n      context: context\n    }) || definitions;\n\n    var parseWarnings = context.warnings;\n\n    if (err) {\n      err = checkValidationError(err);\n\n      self._emit('import.done', { error: err, warnings: parseWarnings });\n\n      return done(err, parseWarnings);\n    }\n\n    self.importDefinitions(definitions, function(err, importWarnings) {\n      var allWarnings = [].concat(parseWarnings, importWarnings || []);\n\n      self._emit('import.done', { error: err, warnings: allWarnings });\n\n      done(err, allWarnings);\n    });\n  });\n};\n\n/**\n * Export the currently displayed CMMN 1.1 diagram as\n * a CMMN 1.1 XML document.\n *\n * ## Life-Cycle Events\n *\n * During XML saving the viewer will fire life-cycle events:\n *\n *   * saveXML.start (before serialization)\n *   * saveXML.serialized (after xml generation)\n *   * saveXML.done (everything done)\n *\n * You can use these events to hook into the life-cycle.\n *\n * @param {Object} [options] export options\n * @param {Boolean} [options.format=false] output formated XML\n * @param {Boolean} [options.preamble=true] output preamble\n *\n * @param {Function} done invoked with (err, xml)\n */\nViewer.prototype.saveXML = function(options, done) {\n\n  if (!done) {\n    done = options;\n    options = {};\n  }\n\n  var self = this;\n\n  var definitions = this._definitions;\n\n  if (!definitions) {\n    return done(new Error('no definitions loaded'));\n  }\n\n  // allow to fiddle around with definitions\n  definitions = this._emit('saveXML.start', {\n    definitions: definitions\n  }) || definitions;\n\n  this._moddle.toXML(definitions, options, function(err, xml) {\n\n    try {\n      xml = self._emit('saveXML.serialized', {\n        error: err,\n        xml: xml\n      }) || xml;\n\n      self._emit('saveXML.done', {\n        error: err,\n        xml: xml\n      });\n    } catch (e) {\n      console.error('error in saveXML life-cycle listener', e);\n    }\n\n    done(err, xml);\n  });\n};\n\nViewer.prototype.saveSVG = function(options, done) {\n\n  if (!done) {\n    done = options;\n    options = {};\n  }\n\n  var canvas = this.get('canvas');\n\n  var contentNode = canvas.getDefaultLayer(),\n      defsNode = domQuery('defs', canvas._svg);\n\n  var contents = innerSVG(contentNode),\n      defs = (defsNode && defsNode.outerHTML) || '';\n\n  var bbox = contentNode.getBBox();\n\n  var svg =\n    '<?xml version=\"1.0\" encoding=\"utf-8\"?>\\n' +\n    '\x3c!-- created with cmmn-js / http://bpmn.io --\x3e\\n' +\n    '<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\\n' +\n    '<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ' +\n         'width=\"' + bbox.width + '\" height=\"' + bbox.height + '\" ' +\n         'viewBox=\"' + bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height + '\" version=\"1.1\">' +\n      defs + contents +\n    '</svg>';\n\n  done(null, svg);\n};\n\nViewer.prototype.importDefinitions = function(definitions, done) {\n\n  // use try/catch to not swallow synchronous exceptions\n  // that may be raised during model parsing\n  try {\n\n    if (this._definitions) {\n      // clear existing rendered diagram\n      this.clear();\n    }\n\n    // update definitions\n    this._definitions = definitions;\n\n    // perform graphical import\n    Importer.importCmmnDiagram(this, definitions, done);\n  } catch (e) {\n\n    // handle synchronous errors\n    done(e);\n  }\n};\n\nViewer.prototype.attachTo = function(parentNode) {\n\n  if (!parentNode) {\n    throw new Error('parentNode required');\n  }\n\n  // ensure we detach from the\n  // previous, old parent\n  this.detach();\n\n  // unwrap jQuery if provided\n  if (parentNode.get && parentNode.constructor.prototype.jquery) {\n    parentNode = parentNode.get(0);\n  }\n\n  if (typeof parentNode === 'string') {\n    parentNode = domQuery(parentNode);\n  }\n\n  parentNode.appendChild(this._container);\n\n  this._emit('attach', {});\n\n  this.get('canvas').resized();\n};\n\nViewer.prototype.getDefinitions = function() {\n  return this._definitions;\n};\n\nViewer.prototype.detach = function() {\n\n  var container = this._container,\n      parentNode = container.parentNode;\n\n  if (!parentNode) {\n    return;\n  }\n\n  this._emit('detach', {});\n\n  parentNode.removeChild(container);\n};\n\nViewer.prototype.getModules = function() {\n  return this._modules;\n};\n\n/**\n * Destroy the viewer instance and remove all its\n * remainders from the document tree.\n */\nViewer.prototype.destroy = function() {\n\n  // diagram destroy\n  Diagram.prototype.destroy.call(this);\n\n  // dom detach\n  domRemove(this._container);\n};\n\n/**\n * Register an event listener\n *\n * Remove a previously added listener via {@link #off(event, callback)}.\n *\n * @param {String} event\n * @param {Number} [priority]\n * @param {Function} callback\n * @param {Object} [that]\n */\nViewer.prototype.on = function(event, priority, callback, target) {\n  return this.get('eventBus').on(event, priority, callback, target);\n};\n\n/**\n * De-register an event listener\n *\n * @param {String} event\n * @param {Function} callback\n */\nViewer.prototype.off = function(event, callback) {\n  this.get('eventBus').off(event, callback);\n};\n\n\nViewer.prototype._init = function(container, moddle, options) {\n\n  var baseModules = options.modules || this.getModules(),\n      additionalModules = options.additionalModules || [],\n      staticModules = [\n        {\n          cmmnjs: [ 'value', this ],\n          moddle: [ 'value', moddle ]\n        }\n      ];\n\n  var diagramModules = [].concat(staticModules, baseModules, additionalModules);\n\n  var diagramOptions = assign(omit(options, 'additionalModules'), {\n    canvas: assign({}, options.canvas, { container: container }),\n    modules: diagramModules\n  });\n\n  // invoke diagram constructor\n  Diagram.call(this, diagramOptions);\n\n  if (options && options.container) {\n    this.attachTo(options.container);\n  }\n};\n\n/**\n * Emit an event on the underlying {@link EventBus}\n *\n * @param  {String} type\n * @param  {Object} event\n *\n * @return {Object} event processing result (if any)\n */\nViewer.prototype._emit = function(type, event) {\n  return this.get('eventBus').fire(type, event);\n};\n\nViewer.prototype._createContainer = function(options) {\n\n  var container = domify('<div class=\"cjs-container\"></div>');\n\n  assign(container.style, {\n    width: ensureUnit(options.width),\n    height: ensureUnit(options.height),\n    position: options.position\n  });\n\n  return container;\n};\n\nViewer.prototype._createModdle = function(options) {\n  var moddleOptions = assign({}, this._moddleExtensions, options.moddleExtensions);\n\n  return new CmmnModdle(moddleOptions);\n};\n\n\n// modules the viewer is composed of\nViewer.prototype._modules = [\n  __webpack_require__(\"./node_modules/cmmn-js/lib/core/index.js\"),\n  (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js\")/* [\"default\"] */ .Z),\n  (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/overlays/index.js\")/* [\"default\"] */ .Z)\n];\n\n\n/* <project-logo> */\n\nvar PoweredBy = __webpack_require__(\"./node_modules/cmmn-js/lib/util/PoweredByUtil.js\"),\n    domEvent = (__webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\")/* .event */ .B);\n\n/**\n * Adds the project logo to the diagram container as\n * required by the bpmn.io license.\n *\n * @see http://bpmn.io/license\n *\n * @param {Element} container\n */\nfunction addProjectLogo(container) {\n\n  var linkMarkup =\n    '<a href=\"http://bpmn.io\" ' +\n       'target=\"_blank\" ' +\n       'class=\"bjs-powered-by\" ' +\n       'title=\"Powered by bpmn.io\" ' +\n       'style=\"position: absolute; bottom: 15px; right: 15px; z-index: 100; ' + PoweredBy.LINK_STYLES + '\">' +\n      PoweredBy.BPMNIO_IMG +\n    '</a>';\n\n  var linkElement = domify(linkMarkup);\n\n  container.appendChild(linkElement);\n\n  domEvent.bind(linkElement, 'click', function(event) {\n    PoweredBy.open();\n\n    event.preventDefault();\n  });\n}\n\n/* </project-logo> */\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/Viewer.js?")},"./node_modules/cmmn-js/lib/core/ItemRegistry.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    getDefinition = ModelUtil.getDefinition,\n    getSentry = ModelUtil.getSentry;\n\nvar isAny = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isAny);\n\nvar forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed),\n    isArray = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .isArray */ .kJ);\n\n\n/**\n * @class\n *\n * A registry that keeps track of all items in the model.\n */\nfunction ItemRegistry(elementRegistry, eventBus) {\n  this._items = {};\n  this._referencedBy = {};\n\n  this._elementRegistry = elementRegistry;\n  this._eventBus = eventBus;\n\n  this._init();\n}\n\nItemRegistry.$inject = [ 'elementRegistry', 'eventBus' ];\n\nmodule.exports = ItemRegistry;\n\n\nItemRegistry.prototype._init = function(config) {\n\n  var eventBus = this._eventBus;\n\n  eventBus.on('diagram.destroy', 500, this._clear, this);\n  eventBus.on('diagram.clear', 500, this._clear, this);\n};\n\nItemRegistry.prototype._clear = function() {\n  this._items = {};\n  this._referencedBy = {};\n};\n\n/**\n * Register a given item.\n *\n * @param {ModdleElement} item\n */\nItemRegistry.prototype.add = function(item) {\n\n  var items = this._items,\n      id = item.id,\n      definitions = this._referencedBy,\n      definition = getReference(item),\n      definitionId = definition && definition.id;\n\n  items[id] = item;\n\n  if (definition) {\n    definitions[definitionId] = definitions[definitionId] || [];\n\n    if (definitions[definitionId].indexOf(item) === -1) {\n      definitions[definitionId].push(item);\n    }\n\n  }\n\n};\n\n\n/**\n * Removes an item from the registry.\n *\n * @param {ModdleElement} item\n */\nItemRegistry.prototype.remove = function(item) {\n\n  var items = this._items,\n      id = item.id,\n      definitions = this._referencedBy,\n      definition = getReference(item),\n      definitionId = definition && definition.id;\n\n  delete items[id];\n\n  if (definition) {\n\n    var referencingItems = definitions[definitionId] || [],\n        idx = referencingItems.indexOf(item);\n\n    if (idx !== -1) {\n      referencingItems.splice(idx, 1);\n    }\n\n    if (!referencingItems.length) {\n      delete definitions[definitionId];\n    }\n\n  }\n\n};\n\n\n/**\n * Update the registration with the new id.\n *\n * @param {ModdleElement} item\n * @param {String} newId\n */\nItemRegistry.prototype.updateId = function(element, newId) {\n\n  var items,\n      item;\n\n  if (typeof element === 'string') {\n    element = this.get(element);\n  }\n\n  if (isDefinition(element)) {\n    items = this._referencedBy;\n  }\n  else {\n    items = this._items;\n  }\n\n  if (element) {\n\n    item = items[element.id];\n\n    delete items[element.id];\n\n    items[newId] = item;\n\n  }\n\n};\n\n\n/**\n * Update the registration.\n *\n * @param {ModdleElement} item\n * @param {ModdleElement} newReference\n */\nItemRegistry.prototype.updateReference = function(item, newReference) {\n\n  var definitions = this._referencedBy,\n      oldDefinition = getReference(item),\n      oldDefinitionId = oldDefinition && oldDefinition.id;\n\n  if (oldDefinition) {\n\n    var referencingItems = definitions[oldDefinitionId] || [],\n        idx = referencingItems.indexOf(item);\n\n    if (idx !== -1) {\n      referencingItems.splice(idx, 1);\n    }\n\n    if (!referencingItems.length) {\n      delete definitions[oldDefinitionId];\n    }\n\n  }\n\n  if (newReference) {\n\n    var newReferenceId = newReference.id;\n    if (newReferenceId) {\n\n      definitions[newReferenceId] = definitions[newReferenceId] || [];\n\n      if (definitions[newReferenceId].indexOf(item) === -1) {\n        definitions[newReferenceId].push(item);\n      }\n\n    }\n\n  }\n\n};\n\n\n/**\n * Return the item for a given id.\n *\n * @param {String} id for selecting the item\n *\n * @return {ModdleElement}\n */\nItemRegistry.prototype.get = function(id) {\n  return this._items[id];\n};\n\n\n/**\n * Return all items that match a given filter function.\n *\n * @param {Function} fn\n *\n * @return {Array<ModdleElement>}\n */\nItemRegistry.prototype.filter = function(fn) {\n\n  var filtered = [];\n\n  this.forEach(function(element, definition) {\n    if (fn(element, definition)) {\n      filtered.push(element);\n    }\n  });\n\n  return filtered;\n\n};\n\n\n/**\n * Return all items.\n *\n * @return {Array<ModdleElement>}\n */\nItemRegistry.prototype.getAll = function() {\n  return this.filter(function(e) { return e; });\n};\n\n\n/**\n * Iterate over all items.\n *\n * @param {Function} fn\n */\nItemRegistry.prototype.forEach = function(fn) {\n\n  var items = this._items;\n\n  forEach(items, function(item) {\n    return fn(item, getReference(item));\n  });\n\n};\n\n\n/**\n * Return for given definition all referenced items.\n *\n * @param {String|ModdleElement} filter\n */\nItemRegistry.prototype.getReferences = function(filter) {\n  var id = filter.id || filter;\n  return (this._referencedBy[id] || []).slice();\n};\n\n\n/**\n * Return for a given item id the shape element.\n *\n * @param {String|ModdleElement} filter\n */\nItemRegistry.prototype.getShape = function(filter) {\n  var id = filter.id || filter;\n  return this._elementRegistry && this._elementRegistry.get(id);\n};\n\n\n/**\n * Return for a given filter all shapes.\n *\n * @param {Array<String>|String|ModdleElement} filter\n */\nItemRegistry.prototype.getShapes = function(filter) {\n\n  var shapes = [],\n      self = this;\n\n  function add(shape) {\n    shape && shapes.push(shape);\n  }\n\n  if (isArray(filter)) {\n\n    forEach(filter, function(f) {\n      add(self.getShape(f));\n    });\n\n  }\n  else if (isDefinition(filter)) {\n\n    var referencedBy = self.getReferences(filter);\n    forEach(referencedBy, function(reference) {\n      add(self.getShape(reference));\n    });\n\n  }\n  else {\n    add(self.getShape(filter));\n  }\n\n  return shapes;\n\n};\n\n\nfunction getReference(item) {\n  return getDefinition(item) || getSentry(item);\n}\n\nfunction isDefinition(item) {\n  return isAny(item, [\n    'cmmn:PlanItemDefinition',\n    'cmmn:Sentry',\n    'cmmn:CaseFileItemDefinition'\n  ]);\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/core/ItemRegistry.js?")},"./node_modules/cmmn-js/lib/core/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __depends__: [\n    __webpack_require__("./node_modules/cmmn-js/lib/draw/index.js"),\n    __webpack_require__("./node_modules/cmmn-js/lib/import/index.js")\n  ],\n  itemRegistry: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/core/ItemRegistry.js") ]\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/core/index.js?')},"./node_modules/cmmn-js/lib/draw/CmmnRenderer.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\"),\n    isArray = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .isArray */ .kJ),\n    isObject = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .isObject */ .Kn),\n    assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0);\n\nvar BaseRenderer = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/draw/BaseRenderer.js\")/* [\"default\"] */ .Z),\n    TextUtil = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Text.js\")/* [\"default\"] */ .Z),\n    DiUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/DiUtil.js\"),\n    ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\");\n\nvar isStandardEventVisible = DiUtil.isStandardEventVisible;\nvar isPlanningTableCollapsed = DiUtil.isPlanningTableCollapsed;\nvar isCollapsed = DiUtil.isCollapsed;\n\nvar isCasePlanModel = ModelUtil.isCasePlanModel;\nvar getBusinessObject = ModelUtil.getBusinessObject;\nvar getDefinition = ModelUtil.getDefinition;\nvar isRequired = ModelUtil.isRequired;\nvar isRepeatable = ModelUtil.isRepeatable;\nvar isManualActivation = ModelUtil.isManualActivation;\nvar isAutoComplete = ModelUtil.isAutoComplete;\nvar hasPlanningTable = ModelUtil.hasPlanningTable;\nvar getName = ModelUtil.getName;\nvar is = ModelUtil.is;\nvar getStandardEvent = ModelUtil.getStandardEvent;\n\nvar domQuery = (__webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\")/* .query */ .IO);\n\nvar svgAppend = (__webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\")/* .append */ .R3),\n    svgAttr = (__webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\")/* .attr */ .Lj),\n    svgClasses = (__webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\")/* .classes */ .Sh),\n    svgCreate = (__webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\")/* .create */ .Ue);\n\nvar translate = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\")/* .translate */ .Iu);\n\nvar createLine = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/RenderUtil.js\")/* .createLine */ .W5);\n\n\nfunction CmmnRenderer(eventBus, styles, pathMap) {\n\n  BaseRenderer.call(this, eventBus);\n\n  var TASK_BORDER_RADIUS = 10;\n  var MILESTONE_BORDER_RADIUS = 24;\n  var STAGE_EDGE_OFFSET = 20;\n\n  var LABEL_STYLE = {\n    fontFamily: 'Arial, sans-serif',\n    fontSize: '12px'\n  };\n\n  var textUtil = new TextUtil({\n    style: LABEL_STYLE,\n    size: { width: 100 }\n  });\n\n  var markers = {};\n\n  function addMarker(id, element) {\n    markers[id] = element;\n  }\n\n  function marker(id) {\n    return markers[id];\n  }\n\n  function initMarkers(svg) {\n\n    function createMarker(id, options) {\n      var attrs = assign({\n        fill: 'black',\n        strokeWidth: 1,\n        strokeLinecap: 'round',\n        strokeDasharray: 'none'\n      }, options.attrs);\n\n      var ref = options.ref || { x: 0, y: 0 };\n\n      var scale = options.scale || 1;\n\n      // fix for safari / chrome / firefox bug not correctly\n      // resetting stroke dash array\n      if (attrs.strokeDasharray === 'none') {\n        attrs.strokeDasharray = [10000, 1];\n      }\n\n      var marker = svgCreate('marker');\n\n      svgAttr(options.element, attrs);\n\n      svgAppend(marker, options.element);\n\n      svgAttr(marker, {\n        id: id,\n        viewBox: '0 0 20 20',\n        refX: ref.x,\n        refY: ref.y,\n        markerWidth: 20 * scale,\n        markerHeight: 20 * scale,\n        orient: 'auto'\n      });\n\n      var defs = domQuery('defs', svg);\n\n      if (!defs) {\n        defs = svgCreate('defs');\n\n        svgAppend(svg, defs);\n      }\n\n      svgAppend(defs, marker);\n\n      return addMarker(id, marker);\n    }\n\n    var associationStart = svgCreate('path');\n    svgAttr(associationStart, { d: 'M 11 5 L 1 10 L 11 15' });\n\n    createMarker('association-start', {\n      element: associationStart,\n      attrs: {\n        fill: 'none',\n        stroke: 'black',\n        strokeWidth: 1.5\n      },\n      ref: { x: 1, y: 10 },\n      scale: 0.5\n    });\n\n    var associationEnd = svgCreate('path');\n    svgAttr(associationEnd, { d: 'M 1 5 L 11 10 L 1 15' });\n\n    createMarker('association-end', {\n      element: associationEnd,\n      attrs: {\n        fill: 'none',\n        stroke: 'black',\n        strokeWidth: 1.5\n      },\n      ref: { x: 12, y: 10 },\n      scale: 0.5\n    });\n\n  }\n\n  // draw shape //////////////////////////////////////////////////////////////\n\n  function computeStyle(custom, traits, defaultStyles) {\n    if (!isArray(traits)) {\n      defaultStyles = traits;\n      traits = [];\n    }\n\n    return styles.style(traits || [], assign(defaultStyles, custom || {}));\n  }\n\n  function drawCircle(parentGfx, width, height, offset, attrs) {\n\n    if (isObject(offset)) {\n      attrs = offset;\n      offset = 0;\n    }\n\n    offset = offset || 0;\n\n    attrs = computeStyle(attrs, {\n      stroke: 'black',\n      strokeWidth: 2,\n      fill: 'white'\n    });\n\n    var cx = width / 2,\n        cy = height / 2;\n\n    var circle = svgCreate('circle');\n    svgAttr(circle, {\n      cx: cx,\n      cy: cy,\n      r: Math.round((width + height) / 4 - offset)\n    });\n    svgAttr(circle, attrs);\n\n    svgAppend(parentGfx, circle);\n\n    return circle;\n  }\n\n  function drawRect(parentGfx, width, height, r, offset, attrs) {\n\n    if (isObject(offset)) {\n      attrs = offset;\n      offset = 0;\n    }\n\n    offset = offset || 0;\n\n    attrs = computeStyle(attrs, {\n      stroke: 'black',\n      strokeWidth: 2,\n      fill: 'white'\n    });\n\n    var rect = svgCreate('rect');\n    svgAttr(rect, {\n      x: offset,\n      y: offset,\n      width: width - offset * 2,\n      height: height - offset * 2,\n      rx: r,\n      ry: r\n    });\n    svgAttr(rect, attrs);\n\n    svgAppend(parentGfx, rect);\n\n    return rect;\n  }\n\n  function drawDiamond(parentGfx, width, height, attrs) {\n\n    var x_2 = width / 2;\n    var y_2 = height / 2;\n\n    var points = [\n      { x: x_2, y: 0 },\n      { x: width, y: y_2 },\n      { x: x_2, y: height },\n      { x: 0, y: y_2 }\n    ];\n\n    var pointsString = points.map(function(point) {\n      return point.x + ',' + point.y;\n    }).join(' ');\n\n    attrs = computeStyle(attrs, {\n      stroke: 'black',\n      strokeWidth: 2,\n      fill: 'white'\n    });\n\n    var polygon = svgCreate('polygon');\n    svgAttr(polygon, {\n      points: pointsString\n    });\n    svgAttr(polygon, attrs);\n\n    svgAppend(parentGfx, polygon);\n\n    return polygon;\n  }\n\n  function drawPath(parentGfx, d, attrs) {\n\n    attrs = computeStyle(attrs, [ 'no-fill' ], {\n      strokeWidth: 2,\n      stroke: 'black'\n    });\n\n    var path = svgCreate('path');\n    svgAttr(path, { d: d });\n    svgAttr(path, attrs);\n\n    svgAppend(parentGfx, path);\n\n    return path;\n  }\n\n  function drawOctagon(parentGfx, width, height, offset, attrs) {\n    offset = offset || 20;\n\n    var x1 = offset;\n    var y1 = height;\n\n    var x2 = 0;\n    var y2 = height - offset;\n\n    var x3 = 0;\n    var y3 = offset;\n\n    var x4 = offset;\n    var y4 = 0;\n\n    var x5 = width - offset;\n    var y5 = 0;\n\n    var x6 = width;\n    var y6 = offset;\n\n    var x7 = width;\n    var y7 = height - offset;\n\n    var x8 = width - offset;\n    var y8 = height;\n\n    var points = [\n      { x: x1, y: y1 },\n      { x: x2, y: y2 },\n      { x: x3, y: y3 },\n      { x: x4, y: y4 },\n      { x: x5, y: y5 },\n      { x: x6, y: y6 },\n      { x: x7, y: y7 },\n      { x: x8, y: y8 }\n    ];\n\n    attrs = attrs || {};\n    attrs.fill = 'white';\n    attrs.stroke = 'black';\n    attrs.strokeWidth = 2;\n\n    return drawPolygon(parentGfx, points, attrs);\n  }\n\n  function drawPolygon(parentGfx, points, attrs) {\n    var pointsString = points.map(function(point) {\n      return point.x + ',' + point.y;\n    }).join(' ');\n\n    var polygon = svgCreate('polygon');\n\n    svgAttr(polygon, {\n      points: pointsString\n    });\n    svgAttr(polygon, attrs);\n\n    svgAppend(parentGfx, polygon);\n\n    return polygon;\n  }\n\n  // draw connection ////////////////////////////////////////////\n\n  function drawLine(parentGfx, waypoints, attrs) {\n    attrs = computeStyle(attrs, [ 'no-fill' ], {\n      stroke: 'black',\n      strokeWidth: 2,\n      fill: 'none'\n    });\n\n    var line = createLine(waypoints, attrs);\n\n    svgAppend(parentGfx, line);\n\n    return line;\n  }\n\n  function createPathFromConnection(connection) {\n    var waypoints = connection.waypoints;\n\n    var pathData = 'm  ' + waypoints[0].x + ',' + waypoints[0].y;\n    for (var i = 1; i < waypoints.length; i++) {\n      pathData += 'L' + waypoints[i].x + ',' + waypoints[i].y + ' ';\n    }\n    return pathData;\n  }\n\n  // render label //////////////////////////////////////////////\n\n  function renderLabel(parentGfx, label, options) {\n    var text = textUtil.createText(label || '', options);\n    svgClasses(text).add('djs-label');\n    svgAppend(parentGfx, text);\n\n    return text;\n  }\n\n  function renderEmbeddedLabel(p, element, align) {\n    var name = getName(element);\n    return renderLabel(p, name, {\n      box: element,\n      align: align,\n      padding: 5\n    });\n  }\n\n  function renderExpandedStageLabel(p, element, align) {\n    var name = getName(element);\n    var textbox = renderLabel(p, name, { box: element, align: align, padding: 5 });\n\n    // reset the position of the text box\n    translate(textbox, STAGE_EDGE_OFFSET, 0);\n\n    return textbox;\n  }\n\n  function renderCasePlanModelLabel(p, element) {\n    var bo = getBusinessObject(element);\n\n    // default maximum textbox dimensions\n    var height = 18;\n    var width = (element.width / 2) - 60;\n\n    var label = bo.name;\n\n    // create text box\n    var textBox = renderLabel(p, label, {\n      box: { height: height, width: width },\n      align: 'left-top'\n    });\n\n    var minWidth = 60,\n        padding = 40,\n        textBoxWidth = textBox.getBBox().width;\n\n    // set polygon width based on actual textbox size\n    var polygonWidth = textBoxWidth + padding;\n\n    if (textBoxWidth < minWidth) {\n      polygonWidth = minWidth + padding;\n    }\n\n    var polygonPoints = [\n      { x: 10, y: 0 },\n      { x: 20, y: -height },\n      { x: polygonWidth, y: -height },\n      { x: polygonWidth + 10, y: 0 }\n    ];\n\n    // The pointer-events attribute is needed to allow clicks on the polygon\n    // which otherwise would be prevented by the parent node ('djs-visual').\n    var polygon = drawPolygon(p, polygonPoints, {\n      fill: 'white',\n      stroke: 'black',\n      strokeWidth: 2,\n      fillOpacity: 0.95,\n      'pointer-events': 'all'\n    });\n\n    // make sure the textbox is visually on top of the polygon\n    textBox.parentNode.insertBefore(polygon, textBox);\n\n    // reset the position of the text box\n    translate(textBox, 25, -height + 5);\n\n    return textBox;\n  }\n\n  function renderExternalLabel(parentGfx, element) {\n    var name = getName(element),\n        hide = false;\n\n    var standardEvent = getStandardEvent(element);\n\n    if (standardEvent) {\n\n      var standardEventVisible = isStandardEventVisible(element);\n      standardEvent = '[' + standardEvent + ']';\n\n      if (!name) {\n        name = standardEvent;\n        element.hidden = hide = !standardEventVisible;\n      }\n      else {\n        if (standardEventVisible) {\n          name = name + ' ' + standardEvent;\n        }\n      }\n\n    }\n\n    var box = {\n      width: 90,\n      height: 30,\n      x: element.width / 2 + element.x,\n      y: element.height / 2 + element.y\n    };\n\n    element.hidden = element.labelTarget.hidden || hide || !name;\n\n    return renderLabel(parentGfx, name, { box: box, style: { fontSize: '11px' } });\n  }\n\n  // render elements //////////////////////////////////////////\n\n  function renderer(type) {\n    return handlers[type];\n  }\n\n  var handlers = {\n    'cmmn:PlanItem': function(p, element) {\n      var definition = getDefinition(element);\n      return renderer(definition.$type)(p, element);\n    },\n\n    'cmmn:DiscretionaryItem': function(p, element) {\n      var definition = getDefinition(element);\n\n      var attrs = {\n        strokeDasharray: '10, 12'\n      };\n\n      if (is(definition, 'cmmn:Task')) {\n        assign(attrs, {\n          strokeDasharray: '12, 12.4',\n          strokeDashoffset: 13.6\n        });\n      }\n\n      return renderer(definition.$type)(p, element, attrs);\n    },\n\n    // STAGE\n    'cmmn:Stage': function(p, element, attrs) {\n\n      attrs = assign({ fillOpacity: 0.95 }, attrs);\n\n      var rect;\n      if (isCasePlanModel(element)) {\n        return handlers['cmmn:CasePlanModel'](p, element);\n      }\n\n      rect = drawOctagon(p, element.width, element.height, STAGE_EDGE_OFFSET, attrs);\n\n      if (!isCollapsed(element)) {\n        renderExpandedStageLabel(p, element, 'left-top');\n      }\n      else {\n        renderEmbeddedLabel(p, element, 'center-middle');\n      }\n\n      attachPlanningTableMarker(p, element);\n      attachStageMarkers(p, element);\n      return rect;\n    },\n\n    // STAGE\n    'cmmn:PlanFragment': function(p, element, attrs) {\n\n      var rect = drawRect(p, element.width, element.height, TASK_BORDER_RADIUS, {\n        strokeDasharray: '10, 12',\n        fillOpacity: 0.95\n      });\n\n      renderEmbeddedLabel(p, element, isCollapsed(element) ? 'center-middle' : 'left-top');\n\n      attachStageMarkers(p, element);\n      return rect;\n    },\n\n    'cmmn:CasePlanModel': function(p, element) {\n      var rect = drawRect(p, element.width, element.height, 0, {\n        fillOpacity: 0.95\n      });\n      renderCasePlanModelLabel(p, element);\n      attachPlanningTableMarker(p, element);\n      attachCasePlanModelMarkers(p, element);\n      return rect;\n    },\n\n    // MILESTONE\n    'cmmn:Milestone': function(p, element, attrs) {\n      var rect = drawRect(p, element.width, element.height, MILESTONE_BORDER_RADIUS, attrs);\n      renderEmbeddedLabel(p, element, 'center-middle');\n      attachTaskMarkers(p, element);\n      return rect;\n    },\n\n    // EVENT LISTENER\n    'cmmn:EventListener': function(p, element, attrs) {\n      var outerCircle = drawCircle(p, element.width, element.height, attrs);\n\n      attrs = attrs || {};\n      attrs.strokeWidth = 2;\n\n      drawCircle(p, element.width, element.height, 0.1 * element.height, attrs);\n      return outerCircle;\n    },\n\n    'cmmn:TimerEventListener': function(p, element, attrs) {\n      var circle = renderer('cmmn:EventListener')(p, element, attrs);\n\n      var pathData = pathMap.getScaledPath('EVENT_TIMER_WH', {\n        xScaleFactor: 0.75,\n        yScaleFactor: 0.75,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.5,\n          my: 0.5\n        }\n      });\n\n      drawPath(p, pathData, {\n        strokeWidth: 2,\n        strokeLinecap: 'square'\n      });\n\n      for (var i = 0;i < 12;i++) {\n\n        var linePathData = pathMap.getScaledPath('EVENT_TIMER_LINE', {\n          xScaleFactor: 0.75,\n          yScaleFactor: 0.75,\n          containerWidth: element.width,\n          containerHeight: element.height,\n          position: {\n            mx: 0.5,\n            my: 0.5\n          }\n        });\n\n        var width = element.width / 2;\n        var height = element.height / 2;\n\n        drawPath(p, linePathData, {\n          strokeWidth: 1,\n          strokeLinecap: 'square',\n          transform: 'rotate(' + (i * 30) + ',' + height + ',' + width + ')'\n        });\n      }\n\n\n      return circle;\n    },\n\n    'cmmn:UserEventListener': function(p, element, attrs) {\n      var circle = renderer('cmmn:EventListener')(p, element, attrs);\n\n      // TODO: The user event decorator has to be\n      // scaled correctly!\n      var x = 20;\n      var y = 15;\n\n      var pathData = pathMap.getScaledPath('TASK_TYPE_USER_1', {\n        abspos: {\n          x: x,\n          y: y\n        }\n      });\n\n      /* user path */ drawPath(p, pathData, {\n        strokeWidth: 0.5,\n        fill: 'none'\n      });\n\n      var pathData2 = pathMap.getScaledPath('TASK_TYPE_USER_2', {\n        abspos: {\n          x: x,\n          y: y\n        }\n      });\n\n      /* user2 path */ drawPath(p, pathData2, {\n        strokeWidth: 0.5,\n        fill: 'none'\n      });\n\n      var pathData3 = pathMap.getScaledPath('TASK_TYPE_USER_3', {\n        abspos: {\n          x: x,\n          y: y\n        }\n      });\n\n      /* user3 path */ drawPath(p, pathData3, {\n        strokeWidth: 0.5,\n        fill: 'black'\n      });\n\n      return circle;\n    },\n\n    // TASK\n    'cmmn:Task': function(p, element, attrs) {\n      var rect = drawRect(p, element.width, element.height, TASK_BORDER_RADIUS, attrs);\n      renderEmbeddedLabel(p, element, 'center-middle');\n      attachTaskMarkers(p, element);\n      return rect;\n    },\n\n    'cmmn:HumanTask': function(p, element, attrs) {\n      var task = renderer('cmmn:Task')(p, element, attrs);\n\n      var bo = element.businessObject;\n      var definition = bo.definitionRef;\n\n      if (definition.isBlocking) {\n        var x = 15;\n        var y = 12;\n\n        var pathData1 = pathMap.getScaledPath('TASK_TYPE_USER_1', {\n          abspos: {\n            x: x,\n            y: y\n          }\n        });\n\n        /* user path */ drawPath(p, pathData1, {\n          strokeWidth: 0.5,\n          fill: 'none'\n        });\n\n        var pathData2 = pathMap.getScaledPath('TASK_TYPE_USER_2', {\n          abspos: {\n            x: x,\n            y: y\n          }\n        });\n\n        /* user2 path */ drawPath(p, pathData2, {\n          strokeWidth: 0.5,\n          fill: 'none'\n        });\n\n        var pathData3 = pathMap.getScaledPath('TASK_TYPE_USER_3', {\n          abspos: {\n            x: x,\n            y: y\n          }\n        });\n\n        /* user3 path */ drawPath(p, pathData3, {\n          strokeWidth: 0.5,\n          fill: 'black'\n        });\n      }\n\n      else {\n        var pathData = pathMap.getScaledPath('TASK_TYPE_MANUAL', {\n          abspos: {\n            x: 17,\n            y: 15\n          }\n        });\n\n        /* manual path */ drawPath(p, pathData, {\n          strokeWidth: 1.25,\n          fill: 'white',\n          stroke: 'black'\n        });\n      }\n\n      attachPlanningTableMarker(p, element);\n\n      return task;\n    },\n\n    'cmmn:CaseTask': function(p, element, attrs) {\n      var task = renderer('cmmn:Task')(p, element, attrs);\n\n      var pathData = pathMap.getScaledPath('TASK_TYPE_FOLDER', {\n        abspos: {\n          x: 7,\n          y: 7\n        }\n      });\n\n      /* manual path */ drawPath(p, pathData, {\n        strokeWidth: 1.25,\n        fill: 'white',\n        stroke: 'black'\n      });\n\n      return task;\n    },\n\n    'cmmn:ProcessTask': function(p, element, attrs) {\n      var task = renderer('cmmn:Task')(p, element, attrs);\n\n      var pathData = pathMap.getScaledPath('TASK_TYPE_CHEVRON', {\n        abspos: {\n          x: 5,\n          y: 5\n        }\n      });\n\n      /* manual path */ drawPath(p, pathData, {\n        strokeWidth: 1.25,\n        fill: 'white',\n        stroke: 'black'\n      });\n\n      return task;\n    },\n\n    'cmmn:DecisionTask': function(p, element, attrs) {\n      var task = renderer('cmmn:Task')(p, element, attrs);\n\n      var headerPathData = pathMap.getScaledPath('TASK_TYPE_BUSINESS_RULE_HEADER', {\n        abspos: {\n          x: 8,\n          y: 8\n        }\n      });\n\n      drawPath(p, headerPathData, {\n        strokeWidth: 1,\n        fill: '000'\n      });\n\n      var headerData = pathMap.getScaledPath('TASK_TYPE_BUSINESS_RULE_MAIN', {\n        abspos: {\n          x: 8,\n          y: 8\n        }\n      });\n\n      drawPath(p, headerData, {\n        strokeWidth: 1\n      });\n\n      return task;\n    },\n\n    'cmmn:CaseFileItem': function(p, element, attrs) {\n      var pathData = pathMap.getScaledPath('DATA_OBJECT_PATH', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.474,\n          my: 0.296\n        }\n      });\n\n      return drawPath(p, pathData, { fill: 'white' });\n    },\n\n    // ARTIFACTS\n    'cmmn:TextAnnotation': function(p, element) {\n      var style = {\n        'fill': 'none',\n        'stroke': 'none'\n      };\n      var textElement = drawRect(p, element.width, element.height, 0, 0, style);\n      var textPathData = pathMap.getScaledPath('TEXT_ANNOTATION', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.0,\n          my: 0.0\n        }\n      });\n      drawPath(p, textPathData);\n\n      var text = getBusinessObject(element).text || '';\n      renderLabel(p, text, { box: element, align: 'left-middle', padding: 5 });\n\n      return textElement;\n    },\n\n    'cmmn:Association': function(p, element, attrs) {\n\n      var semantic = getBusinessObject(element);\n\n      attrs = assign({\n        strokeDasharray: '0.5, 5',\n        strokeLinecap: 'round',\n        strokeLinejoin: 'round'\n      }, attrs || {});\n\n      if (semantic.associationDirection === 'One' ||\n          semantic.associationDirection === 'Both') {\n        attrs.markerEnd = marker('association-end');\n      }\n\n      if (semantic.associationDirection === 'Both') {\n        attrs.markerStart = marker('association-start');\n      }\n\n      return drawLine(p, element.waypoints, attrs);\n    },\n\n    // MARKERS\n    'StageMarker': function(p, element) {\n      var markerRect = drawRect(p, 14, 14, 0, {\n        strokeWidth: 1,\n        stroke: 'black'\n      });\n\n      translate(markerRect, element.width / 2 - 7, element.height - 17);\n\n      var path = isCollapsed(element) ? 'MARKER_STAGE_COLLAPSED' : 'MARKER_STAGE_EXPANDED';\n\n      var stagePath = pathMap.getScaledPath(path, {\n        xScaleFactor: 1.5,\n        yScaleFactor: 1.5,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: (element.width / 2 - 7) / element.width,\n          my: (element.height - 17) / element.height\n        }\n      });\n\n      drawPath(p, stagePath);\n    },\n\n    'RequiredMarker': function(p, element, position) {\n      var path = pathMap.getScaledPath('MARKER_REQUIRED', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: ((element.width / 2 + position) / element.width),\n          my: (element.height - 17) / element.height\n        }\n      });\n\n      drawPath(p, path, { strokeWidth: 3 });\n    },\n\n    'AutoCompleteMarker': function(p, element, position) {\n      var markerRect = drawRect(p, 11, 14, 0, {\n        strokeWidth: 1,\n        stroke: 'black',\n        fill: 'black'\n      });\n\n      translate(markerRect, element.width / 2 + position + 2, element.height - 17);\n    },\n\n    'ManualActivationMarker': function(p, element, position) {\n      var path = pathMap.getScaledPath('MARKER_MANUAL_ACTIVATION', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: ((element.width / 2 + position) / element.width),\n          my: (element.height - 17) / element.height\n        }\n      });\n\n      drawPath(p, path, { strokeWidth: 1 });\n    },\n\n    'RepetitionMarker': function(p, element, position) {\n      var path = pathMap.getScaledPath('MARKER_REPEATABLE', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: ((element.width / 2 + position) / element.width),\n          my: (element.height - 17) / element.height\n        }\n      });\n\n      drawPath(p, path);\n    },\n\n    'PlanningTableMarker': function(p, element, position) {\n      var planningTableRect = drawRect(p, 30, 24, 0, {\n        strokeWidth: 1.5,\n        stroke: 'black'\n      });\n\n      translate(planningTableRect, element.width / 2 - 15, -17);\n\n      var isCollapsed = isPlanningTableCollapsed(element);\n\n      var marker = isCollapsed ? 'MARKER_PLANNING_TABLE_COLLAPSED' : 'MARKER_PLANNING_TABLE_EXPANDED';\n\n      var stagePath = pathMap.getScaledPath(marker, {\n        xScaleFactor: 1.5,\n        yScaleFactor: 1.5,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: (element.width / 2 - 15) / element.width,\n          my: (-17) / element.height\n        }\n      });\n\n      drawPath(p, stagePath, {\n        strokeWidth: 1.5\n      });\n    },\n\n    'cmmn:OnPart': function(p, element) {\n      var pathData = createPathFromConnection(element);\n\n      var path = drawPath(p, pathData, {\n        strokeDasharray: '10, 5, 2, 5, 2, 5',\n        strokeWidth: 1.5\n      });\n\n      return path;\n    },\n    'cmmn:PlanItemOnPart': function(p, element) {\n      return renderer('cmmn:OnPart')(p, element);\n    },\n    'cmmn:CaseFileItemOnPart': function(p, element) {\n      return renderer('cmmn:OnPart')(p, element);\n    },\n    'cmmn:EntryCriterion': function(p, element) {\n      return drawDiamond(p, element.width, element.height, {\n        fill: 'white'\n      });\n    },\n    'cmmn:ExitCriterion': function(p, element) {\n      return drawDiamond(p, element.width, element.height, {\n        fill: 'black'\n      });\n    },\n\n    'cmmndi:CMMNEdge': function(p, element) {\n\n      var bo = getBusinessObject(element);\n\n      if (bo.cmmnElementRef) {\n        return renderer(bo.cmmnElementRef.$type)(p, element);\n      }\n\n      var pathData = createPathFromConnection(element);\n\n      var path = drawPath(p, pathData, {\n        strokeDasharray: '3, 5',\n        strokeWidth: 1\n      });\n\n      return path;\n    },\n\n    'label': function(parentGfx, element) {\n      // Update external label size and bounds during rendering when\n      // we have the actual rendered bounds anyway.\n\n      var textElement = renderExternalLabel(parentGfx, element);\n\n      var textBBox;\n\n      try {\n        textBBox = textElement.getBBox();\n      } catch (e) {\n        textBBox = { width: 0, height: 0, x: 0 };\n      }\n\n      // update element.x so that the layouted text is still\n      // center alligned (newX = oldMidX - newWidth / 2)\n      element.x = Math.ceil(element.x + element.width / 2) - Math.ceil((textBBox.width / 2));\n\n      // take element width, height from actual bounds\n      element.width = Math.ceil(textBBox.width);\n      element.height = Math.ceil(textBBox.height);\n\n      // compensate bounding box x\n      svgAttr(textElement, {\n        transform: 'translate(' + (-1 * textBBox.x) + ',0)'\n      });\n\n      return textElement;\n    }\n  };\n\n  // attach markers /////////////////////////\n\n  function attachTaskMarkers(p, element) {\n    var obj = getBusinessObject(element);\n    var padding = 6;\n\n    var markers = [];\n\n    if (isRequired(obj)) {\n      markers.push({ marker: 'RequiredMarker', width: 1 });\n    }\n\n    if (isManualActivation(obj)) {\n      markers.push({ marker: 'ManualActivationMarker', width: 14 });\n    }\n\n    if (isRepeatable(obj)) {\n      markers.push({ marker: 'RepetitionMarker', width: 14 });\n    }\n\n    if (markers.length) {\n\n      if (markers.length === 1) {\n        // align marker in the middle of the element\n        drawMarker(markers[0].marker, p, element, (markers[0].width / 2) * (-1));\n      }\n\n      else if (markers.length === 2) {\n        /* align marker:\n         *\n         *      |             |\n         *      +-------------+\n         *             ^\n         *             |\n         *         +-+   +-+\n         *         |0|   |1| <-- markers\n         *         +-+   +-+\n         * (leftMarker)  (rightMarker)\n         */\n        drawMarker(markers[0].marker, p, element, (markers[0].width * (-1)) - (padding /2));\n        drawMarker(markers[1].marker, p, element, padding / 2);\n      }\n\n      else if (markers.length === 3) {\n        /* align marker:\n         *\n         *      |             |\n         *      +-------------+\n         *             ^\n         *             |\n         *      +-+   +-+   +-+\n         *      |0|   |1|   |2| <-- markers\n         *      +-+   +-+   +-+\n         */\n\n        /* 1 */ drawMarker(markers[1].marker, p, element, markers[1].width / 2 * (-1));\n        /* 0 */ drawMarker(markers[0].marker, p, element, (markers[1].width / 2 * (-1)) - padding - markers[0].width);\n        /* 2 */ drawMarker(markers[2].marker, p, element, (markers[1].width / 2) + padding);\n      }\n    }\n  }\n\n  function attachCasePlanModelMarkers(p, element) {\n    var obj = getBusinessObject(element);\n\n    if (isAutoComplete(obj)) {\n      drawMarker('AutoCompleteMarker', p, element, -7);\n    }\n  }\n\n  function attachStageMarkers(p, element, stage) {\n    var obj = getBusinessObject(element);\n    var padding = 6;\n\n    drawMarker('StageMarker', p, element, -7);\n\n    var leftMarkers = [];\n\n    if (isRequired(obj)) {\n      leftMarkers.push({ marker: 'RequiredMarker', width: 1 });\n    }\n\n    if (isAutoComplete(obj)) {\n      leftMarkers.push({ marker: 'AutoCompleteMarker', width: 14 });\n    }\n\n    if (leftMarkers.length) {\n\n      if (leftMarkers.length === 1) {\n        drawMarker(leftMarkers[0].marker, p, element, (leftMarkers[0].width * (-1) - 7 - padding));\n      }\n\n      else if (leftMarkers.length === 2) {\n        drawMarker(\n          leftMarkers[0].marker,\n          p,\n          element,\n          ((leftMarkers[1].width * (-1)) - 7 - padding) - (leftMarkers[0].width * (-1)) - padding\n        );\n\n        drawMarker(leftMarkers[1].marker, p, element, (leftMarkers[1].width * (-1)) - 7 - padding);\n      }\n\n    }\n\n    var rightMarkers = [];\n\n    if (isManualActivation(obj)) {\n      rightMarkers.push({ marker: 'ManualActivationMarker', width: 14 });\n    }\n\n    if (isRepeatable(obj)) {\n      rightMarkers.push({ marker: 'RepetitionMarker', width: 14 });\n    }\n\n    if (rightMarkers.length) {\n\n      if (rightMarkers.length === 1) {\n        drawMarker(rightMarkers[0].marker, p, element, 7 + padding);\n      }\n\n      else if (rightMarkers.length === 2) {\n        drawMarker(rightMarkers[0].marker, p, element, 7 + padding);\n        drawMarker(rightMarkers[1].marker, p, element, 7 + padding + rightMarkers[0].width + padding);\n      }\n\n    }\n  }\n\n  function attachPlanningTableMarker(p, element) {\n    if (hasPlanningTable(element)) {\n      drawMarker('PlanningTableMarker', p, element);\n    }\n  }\n\n  function drawMarker(marker, parent, element, position) {\n    renderer(marker)(parent, element, position);\n  }\n\n  // draw shape and connection ////////////////////////////////////\n\n  function drawShape(parent, element) {\n    var h = handlers[element.type];\n\n    /* jshint -W040 */\n    if (!h) {\n      return BaseRenderer.prototype.drawShape.apply(this, [ parent, element ]);\n    } else {\n      return h(parent, element);\n    }\n  }\n\n  function drawConnection(parent, element) {\n    var type = element.type;\n    var h = handlers[type];\n\n    /* jshint -W040 */\n    if (!h) {\n      return BaseRenderer.prototype.drawConnection.apply(this, [ parent, element ]);\n    } else {\n      return h(parent, element);\n    }\n  }\n\n  this.canRender = function(element) {\n    return is(element, 'cmmn:CMMNElement') || is(element, 'cmmndi:CMMNEdge');\n  };\n\n  this.drawShape = drawShape;\n  this.drawConnection = drawConnection;\n\n  // hook onto canvas init event to initialize\n  // connection start/end markers on svg\n  eventBus.on('canvas.init', function(event) {\n    initMarkers(event.svg);\n  });\n\n}\n\ninherits(CmmnRenderer, BaseRenderer);\n\nCmmnRenderer.$inject = [ 'eventBus', 'styles', 'pathMap' ];\n\nmodule.exports = CmmnRenderer;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/draw/CmmnRenderer.js?")},"./node_modules/cmmn-js/lib/draw/PathMap.js":module=>{"use strict";eval("\n\n/**\n * Map containing SVG paths needed by CmmnRenderer.\n */\n\nfunction PathMap() {\n\n  var PATH_USER_TYPE_1 = 'm {mx},{my} c 0.909,-0.845 1.594,-2.049 1.594,-3.385 0,-2.554 -1.805,-4.62199999 ' +\n                         '-4.357,-4.62199999 -2.55199998,0 -4.28799998,2.06799999 -4.28799998,4.62199999 0,1.348 ' +\n                         '0.974,2.562 1.89599998,3.405 -0.52899998,0.187 -5.669,2.097 -5.794,4.7560005 v 6.718 ' +\n                         'h 17 v -6.718 c 0,-2.2980005 -5.5279996,-4.5950005 -6.0509996,-4.7760005 z' +\n                         'm -8,6 l 0,5.5 m 11,0 l 0,-5';\n\n  var PATH_USER_TYPE_2 = 'm {mx},{my} m 2.162,1.009 c 0,2.4470005 -2.158,4.4310005 -4.821,4.4310005 ' +\n                         '-2.66499998,0 -4.822,-1.981 -4.822,-4.4310005';\n\n  var PATH_USER_TYPE_3 = 'm {mx},{my} m -6.9,-3.80 c 0,0 2.25099998,-2.358 4.27399998,-1.177 2.024,1.181 4.221,1.537 ' +\n                         '4.124,0.965 -0.098,-0.57 -0.117,-3.79099999 -4.191,-4.13599999 -3.57499998,0.001 ' +\n                         '-4.20799998,3.36699999 -4.20699998,4.34799999 z';\n\n  /**\n   * Contains a map of path elements\n   *\n   * <h1>Path definition</h1>\n   * A parameterized path is defined like this:\n   * <pre>\n   * 'EVENT_TIMER_WH': {\n   *   d: 'M {mx},{my} l {e.x0},-{e.y0} m -{e.x0},{e.y0} l {e.x1},{e.y1} ',\n   *   height: 17.5,\n   *   width:  17.5,\n   *   heightElements: [2.5, 7.5],\n   *   widthElements: [2.5, 7.5]\n   * }\n   * </pre>\n   * <p>It's important to specify a correct <b>height and width</b> for the path as the scaling\n   * is based on the ratio between the specified height and width in this object and the\n   * height and width that is set as scale target (Note x,y coordinates will be scaled with\n   * individual ratios).</p>\n   * <p>The '<b>heightElements</b>' and '<b>widthElements</b>' array must contain the values that will be scaled.\n   * The scaling is based on the computed ratios.\n   * Coordinates on the y axis should be in the <b>heightElement</b>'s array, they will be scaled using\n   * the computed ratio coefficient.\n   * In the parameterized path the scaled values can be accessed through the 'e' object in {} brackets.\n   *   <ul>\n   *    <li>The values for the y axis can be accessed in the path string using {e.y0}, {e.y1}, ....</li>\n   *    <li>The values for the x axis can be accessed in the path string using {e.x0}, {e.x1}, ....</li>\n   *   </ul>\n   *   The numbers x0, x1 respectively y0, y1, ... map to the corresponding array index.\n   * </p>\n   */\n  this.pathMap = {\n\n    // TASK DECORATOR\n\n    'TASK_TYPE_FOLDER': {\n      d: 'm {mx},{my} l18,0 l0,12 l-18,0 l0,-12 m 2,0 l3,-4 l5,0 l3,4'\n    },\n    'TASK_TYPE_CHEVRON': {\n      d: 'm {mx},{my} l15,0 l6,6 l-6,6 l-15,0 l6,-6 l-6,-6'\n    },\n    'TASK_TYPE_USER_1': {\n      d: PATH_USER_TYPE_1\n    },\n    'TASK_TYPE_USER_2': {\n      d: PATH_USER_TYPE_2\n    },\n    'TASK_TYPE_USER_3': {\n      d: PATH_USER_TYPE_3\n    },\n    'TASK_TYPE_MANUAL': {\n      d: 'm {mx},{my} c 0.234,-0.01 5.604,0.008 8.029,0.004 0.808,0 1.271,-0.172 1.417,-0.752 0.227,-0.898 ' +\n        '-0.334,-1.314 -1.338,-1.316 -2.467,-0.01 -7.886,-0.004 -8.108,-0.004 -0.014,-0.079 0.016,-0.533 0,-0.61 ' +\n        '0.195,-0.042 8.507,0.006 9.616,0.002 0.877,-0.007 1.35,-0.438 1.353,-1.208 0.003,-0.768 -0.479,-1.09 ' +\n        '-1.35,-1.091 -2.968,-0.002 -9.619,-0.013 -9.619,-0.013 v -0.591 c 0,0 5.052,-0.016 7.225,-0.016 ' +\n        '0.888,-0.002 1.354,-0.416 1.351,-1.193 -0.006,-0.761 -0.492,-1.196 -1.361,-1.196 -3.473,-0.005 ' +\n        '-10.86,-0.003 -11.0829995,-0.003 -0.022,-0.047 -0.045,-0.094 -0.069,-0.139 0.3939995,-0.319 ' +\n        '2.0409995,-1.626 2.4149995,-2.017 0.469,-0.4870005 0.519,-1.1650005 0.162,-1.6040005 -0.414,-0.511 ' +\n        '-0.973,-0.5 -1.48,-0.236 -1.4609995,0.764 -6.5999995,3.6430005 -7.7329995,4.2710005 -0.9,0.499 ' +\n        '-1.516,1.253 -1.882,2.19 -0.37000002,0.95 -0.17,2.01 -0.166,2.979 0.004,0.718 -0.27300002,1.345 ' +\n        '-0.055,2.063 0.629,2.087 2.425,3.312 4.859,3.318 4.6179995,0.014 9.2379995,-0.139 13.8569995,-0.158 ' +\n        '0.755,-0.004 1.171,-0.301 1.182,-1.033 0.012,-0.754 -0.423,-0.969 -1.183,-0.973 -1.778,-0.01 ' +\n        '-5.824,-0.004 -6.04,-0.004 10e-4,-0.084 0.003,-0.586 10e-4,-0.67 z'\n    },\n\n    'TASK_TYPE_BUSINESS_RULE_HEADER': {\n      d: 'm {mx},{my} 0,4 20,0 0,-4 z'\n    },\n    'TASK_TYPE_BUSINESS_RULE_MAIN': {\n      d: 'm {mx},{my} 0,12 20,0 0,-12 z' +\n        'm 0,8 l 20,0 ' +\n        'm -13,-4 l 0,8'\n    },\n\n    // EVENT LISTENER DECORATOR\n\n    'EVENT_TIMER_WH': {\n      d: 'M {mx},{my} l {e.x0},-{e.y0} m -{e.x0},{e.y0} l {e.x1},{e.y1} ',\n      height: 36,\n      width:  36,\n      heightElements: [10, 2],\n      widthElements: [3, 7]\n    },\n    'EVENT_TIMER_LINE': {\n      d:  'M {mx},{my} ' +\n          'm {e.x0},{e.y0} l -{e.x1},{e.y1} ',\n      height: 36,\n      width:  36,\n      heightElements: [10, 3],\n      widthElements: [0, 0]\n    },\n\n    'EVENT_USER_1': {\n      d: PATH_USER_TYPE_1,\n      height: 36,\n      width:  36,\n      heightElements: [],\n      widthElements: []\n\n    },\n    'EVENT_USER_2': {\n      d: PATH_USER_TYPE_2,\n      height: 36,\n      width:  36,\n      heightElements: [],\n      widthElements: []\n    },\n    'EVENT_USER_3': {\n      d: PATH_USER_TYPE_3,\n      height: 36,\n      width:  36,\n      heightElements: [],\n      widthElements: []\n    },\n\n    // MARKERS\n\n    'MARKER_STAGE_EXPANDED': {\n      d: 'm{mx},{my} m 2,7 l 10,0',\n      height: 10,\n      width: 10,\n      heightElements: [],\n      widthElements: []\n    },\n    'MARKER_STAGE_COLLAPSED': {\n      d: 'm{mx},{my} m 2,7 l 10,0 m -5,-5 l 0,10',\n      height: 10,\n      width: 10,\n      heightElements: [],\n      widthElements: []\n    },\n    'MARKER_REQUIRED': {\n      d: 'm{mx},{my} l 0,9 m 0,2 l0,3',\n      height: 14,\n      width: 3,\n      heightElements: [],\n      widthElements: []\n    },\n\n    'MARKER_MANUAL_ACTIVATION': {\n      d: 'm{mx}, {my} l 14,7 l -14,7 l 0,-14 z',\n      height: 14,\n      width: 14,\n      heightElements: [],\n      widthElements: []\n    },\n\n    'MARKER_REPEATABLE': {\n      d: 'm{mx},{my} m 3,0 l 0,14 m 6,-14 l 0,14 m -10,-10 l 14,0 m -14,6 l 14,0',\n      height: 14,\n      width: 14,\n      heightElements: [],\n      widthElements: []\n    },\n\n    'MARKER_PLANNING_TABLE_EXPANDED': {\n      d: 'm{mx},{my} m 0,12 l 30,0 m -20,-12 l 0, 24 m 10, -24 l 0, 24 m -10, -6 l 10,0',\n      height: 24,\n      width: 30,\n      heightElements: [],\n      widthElements: []\n    },\n    'MARKER_PLANNING_TABLE_COLLAPSED': {\n      d: 'm{mx},{my} m 0,12 l 30,0 m -20,-12 l 0, 24 m 10, -24 l 0, 24 m -10, -6 l 10,0 m -5, -6 l 0,12',\n      height: 10,\n      width: 10,\n      heightElements: [],\n      widthElements: []\n    },\n\n    'DATA_OBJECT_PATH': {\n      d:'m 0,0 {e.x1},0 {e.x0},{e.y0} 0,{e.y1} -{e.x2},0 0,-{e.y2} {e.x1},0 0,{e.y0} {e.x0},0',\n      height: 61,\n      width:  51,\n      heightElements: [10, 50, 60],\n      widthElements: [10, 40, 50, 60]\n    },\n\n    'TEXT_ANNOTATION': {\n      d: 'm {mx}, {my} m 10,0 l -10,0 l 0,{e.y0} l 10,0',\n      height: 30,\n      width: 10,\n      heightElements: [30],\n      widthElements: [10]\n    }\n  };\n\n  this.getRawPath = function getRawPath(pathId) {\n    return this.pathMap[pathId].d;\n  };\n\n  /**\n   * Scales the path to the given height and width.\n   * <h1>Use case</h1>\n   * <p>Use case is to scale the content of elements (event) based\n   * on the element bounding box's size.\n   * </p>\n   * <h1>Why not transform</h1>\n   * <p>Scaling a path with transform() will also scale the stroke and IE does not support\n   * the option 'non-scaling-stroke' to prevent this.\n   * Also there are use cases where only some parts of a path should be\n   * scaled.</p>\n   *\n   * @param {String} pathId The ID of the path.\n   * @param {Object} param <p>\n   *   Example param object scales the path to 60% size of the container (data.width, data.height).\n   *   <pre>\n   *   {\n   *     xScaleFactor: 0.6,\n   *     yScaleFactor:0.6,\n   *     containerWidth: data.width,\n   *     containerHeight: data.height,\n   *     position: {\n   *       mx: 0.46,\n   *       my: 0.2,\n   *     }\n   *   }\n   *   </pre>\n   *   <ul>\n   *    <li>targetpathwidth = xScaleFactor * containerWidth</li>\n   *    <li>targetpathheight = yScaleFactor * containerHeight</li>\n   *    <li>Position is used to set the starting coordinate of the path. M is computed:\n    *    <ul>\n    *      <li>position.x * containerWidth</li>\n    *      <li>position.y * containerHeight</li>\n    *    </ul>\n    *    Center of the container <pre> position: {\n   *       mx: 0.5,\n   *       my: 0.5,\n   *     }</pre>\n   *     Upper left corner of the container\n   *     <pre> position: {\n   *       mx: 0.0,\n   *       my: 0.0,\n   *     }</pre>\n   *    </li>\n   *   </ul>\n   * </p>\n   *\n   */\n  this.getScaledPath = function getScaledPath(pathId, param) {\n    var rawPath = this.pathMap[pathId];\n\n    // positioning\n    // compute the start point of the path\n    var mx, my;\n\n    if (param.abspos) {\n      mx = param.abspos.x;\n      my = param.abspos.y;\n    } else {\n      mx = param.containerWidth * param.position.mx;\n      my = param.containerHeight * param.position.my;\n    }\n\n    var coordinates = {}; // map for the scaled coordinates\n    if (param.position) {\n\n      // path\n      var heightRatio = (param.containerHeight / rawPath.height) * param.yScaleFactor;\n      var widthRatio = (param.containerWidth / rawPath.width) * param.xScaleFactor;\n\n\n      // Apply height ratio\n      for (var heightIndex = 0; heightIndex < rawPath.heightElements.length; heightIndex++) {\n        coordinates['y' + heightIndex] = rawPath.heightElements[heightIndex] * heightRatio;\n      }\n\n      // Apply width ratio\n      for (var widthIndex = 0; widthIndex < rawPath.widthElements.length; widthIndex++) {\n        coordinates['x' + widthIndex] = rawPath.widthElements[widthIndex] * widthRatio;\n      }\n    }\n\n    // Apply value to raw path\n    var path = format(\n      rawPath.d, {\n        mx: mx,\n        my: my,\n        e: coordinates\n      }\n    );\n    return path;\n  };\n}\n\nmodule.exports = PathMap;\n\n// helpers /////////////////\n\n// copied from https://github.com/adobe-webplatform/Snap.svg/blob/master/src/svg.js\nvar tokenRegex = /\\{([^}]+)\\}/g,\n    objNotationRegex = /(?:(?:^|\\.)(.+?)(?=\\[|\\.|$|\\()|\\[('|\")(.+?)\\2\\])(\\(\\))?/g; // matches .xxxxx or [\"xxxxx\"] to run over object properties\n\nfunction replacer(all, key, obj) {\n  var res = obj;\n  key.replace(objNotationRegex, function(all, name, quote, quotedName, isFunc) {\n    name = name || quotedName;\n    if (res) {\n      if (name in res) {\n        res = res[name];\n      }\n      typeof res == 'function' && isFunc && (res = res());\n    }\n  });\n  res = (res == null || res == obj ? all : res) + '';\n\n  return res;\n}\n\nfunction format(str, obj) {\n  return String(str).replace(tokenRegex, function(all, key) {\n    return replacer(all, key, obj);\n  });\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/draw/PathMap.js?")},"./node_modules/cmmn-js/lib/draw/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("module.exports = {\n  __init__: [ 'cmmnRenderer' ],\n  cmmnRenderer: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/draw/CmmnRenderer.js\") ],\n  pathMap: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/draw/PathMap.js\") ]\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/draw/index.js?")},"./node_modules/cmmn-js/lib/features/auto-resize/CmmnAutoResizeProvider.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar is = (__webpack_require__("./node_modules/cmmn-js/lib/util/ModelUtil.js").is),\n    getDefinition = (__webpack_require__("./node_modules/cmmn-js/lib/util/ModelUtil.js").getDefinition);\n\nvar inherits = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n\nvar forEach = (__webpack_require__("./node_modules/min-dash/dist/index.esm.js")/* .forEach */ .Ed);\n\nvar AutoResizeProvider = (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-resize/AutoResizeProvider.js")/* ["default"] */ .Z);\n\n/**\n * This module provides a CMMN specific check if an element\n * can be resized.\n */\nfunction CmmnAutoResizeProvider(eventBus) {\n  AutoResizeProvider.call(this, eventBus);\n}\n\ninherits(CmmnAutoResizeProvider, AutoResizeProvider);\n\nCmmnAutoResizeProvider.$inject = [ \'eventBus\' ];\n\nmodule.exports = CmmnAutoResizeProvider;\n\n/**\n * Check if the given shape can be expanded\n *\n * @param  {Array<djs.model.Shape>} elements\n * @param  {djs.model.Shape} target\n *\n * @return {boolean}\n */\nCmmnAutoResizeProvider.prototype.canResize = function(elements, target) {\n\n  if (!is(target, \'cmmn:CMMNElement\')) {\n    return;\n  }\n\n  var criterionsOnly = true;\n\n  forEach(elements, function(element) {\n    if (!is(element, \'cmmn:Criterion\')) {\n      criterionsOnly = false;\n      return;\n    }\n  });\n\n  // prevent auto expand if the selected elements are exclusively criterions\n  if (criterionsOnly) {\n    return;\n  }\n\n  var definition = getDefinition(target);\n\n  return is(definition, \'cmmn:PlanFragment\');\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/auto-resize/CmmnAutoResizeProvider.js?')},"./node_modules/cmmn-js/lib/features/auto-resize/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __init__: [ \'cmmnAutoResizeProvider\' ],\n  __depends__: [\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-resize/index.js")/* ["default"] */ .Z)\n  ],\n  cmmnAutoResizeProvider: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/auto-resize/CmmnAutoResizeProvider.js") ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/auto-resize/index.js?')},"./node_modules/cmmn-js/lib/features/context-pad/ContextPadProvider.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0),\n    isArray = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .isArray */ .kJ);\n\nvar isAny = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isAny);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    getDefinition = ModelUtil.getDefinition;\n\n/**\n * A provider for CMMN 1.1 elements context pad\n */\nfunction ContextPadProvider(\n    contextPad,\n    connect,\n    create,\n    elementFactory,\n    modeling,\n    rules,\n    popupMenu,\n    canvas\n) {\n\n  contextPad.registerProvider(this);\n\n  this._contextPad = contextPad;\n  this._connect = connect;\n  this._create = create;\n  this._elementFactory = elementFactory;\n  this._modeling = modeling;\n  this._rules = rules;\n  this._popupMenu = popupMenu;\n  this._canvas = canvas;\n}\n\nContextPadProvider.$inject = [\n  'contextPad',\n  'connect',\n  'create',\n  'elementFactory',\n  'modeling',\n  'rules',\n  'popupMenu',\n  'canvas'\n];\n\nmodule.exports = ContextPadProvider;\n\n\nContextPadProvider.prototype.getContextPadEntries = function(element) {\n\n  var contextPad = this._contextPad,\n      connect = this._connect,\n      create = this._create,\n      elementFactory = this._elementFactory,\n      modeling = this._modeling,\n      canvas = this._canvas,\n      rules = this._rules,\n      popupMenu = this._popupMenu;\n\n  var actions = {};\n\n  if (element.type === 'label') {\n    return actions;\n  }\n\n\n  function removeElement(e) {\n    modeling.removeElements([ element ]);\n  }\n\n  function getReplaceMenuPosition(element) {\n\n    var Y_OFFSET = 5;\n\n    var diagramContainer = canvas.getContainer(),\n        pad = contextPad.getPad(element).html;\n\n    var diagramRect = diagramContainer.getBoundingClientRect(),\n        padRect = pad.getBoundingClientRect();\n\n    var top = padRect.top - diagramRect.top;\n    var left = padRect.left - diagramRect.left;\n\n    var pos = {\n      x: left,\n      y: top + padRect.height + Y_OFFSET\n    };\n\n    return pos;\n  }\n\n  function startConnect(event, element, autoActivate) {\n    connect.start(event, element, autoActivate);\n  }\n\n\n  function appendCriterionAction(className, title, options) {\n\n    function appendListener(event, element) {\n      var shape = elementFactory.createCriterionShape('cmmn:EntryCriterion');\n      create.start(event, shape, element);\n    }\n\n    return appendAction('cmmn:EntryCriterion', className, title, options, appendListener);\n  }\n\n  function appendDiscretionaryItemAction(className, title, options) {\n\n    function appendListener(event, element) {\n      var shape = elementFactory.createDiscretionaryItemShape('cmmn:Task');\n      create.start(event, shape, element);\n    }\n\n    return appendAction('cmmn:DiscretionaryItem', className, title, options, appendListener);\n  }\n\n  function appendAction(type, className, title, options, listener) {\n\n    if (typeof title !== 'string') {\n      options = title;\n      title = 'Append ' + type.replace(/^cmmn:/, '');\n    }\n\n    function appendListener(event, element) {\n      var shape = elementFactory.createShape(assign({ type: type }, options));\n      create.start(event, shape, element);\n    }\n\n    return {\n      group: 'model',\n      className: className,\n      title: title,\n      action: {\n        dragstart: listener || appendListener,\n        click: listener || appendListener\n      }\n    };\n  }\n\n\n  if (isAny(element, [ 'cmmn:PlanItem', 'cmmn:CaseFileItem' ])) {\n    assign(actions, {\n      'append.entryCriterion': appendCriterionAction('cmmn-icon-entry-criterion', 'Append Criterion')\n    });\n  }\n\n  if (isBlockingHumanTask(element)) {\n    assign(actions, {\n      'append.discretionaryItem': appendDiscretionaryItemAction(\n        'cmmn-icon-task-discretionary',\n        'Append DiscretionaryItem'\n      )\n    });\n  }\n\n\n  if (!popupMenu.isEmpty(element, 'cmmn-replace')) {\n\n    // Replace menu entry\n    assign(actions, {\n      'replace': {\n        group: 'edit',\n        className: 'cmmn-icon-screw-wrench',\n        title: 'Change type',\n        action: {\n          click: function(event, element) {\n\n            var position = assign(getReplaceMenuPosition(element), {\n              cursor: { x: event.x, y: event.y }\n            });\n\n            popupMenu.open(element, 'cmmn-replace', position);\n          }\n        }\n      }\n    });\n  }\n\n\n  if (!isAny(element, [ 'cmmndi:CMMNEdge', 'cmmn:TextAnnotation' ])) {\n    assign(actions, {\n      'append.text-annotation': appendAction('cmmn:TextAnnotation', 'cmmn-icon-text-annotation')\n    });\n  }\n\n\n  if (isAny(element, [\n    'cmmn:PlanItem',\n    'cmmn:DiscretionaryItem',\n    'cmmn:CaseFileItem',\n    'cmmn:Criterion'\n  ])) {\n\n    assign(actions, {\n\n      'connect': {\n        group: 'connect',\n        className: 'cmmn-icon-connection',\n        title: 'Connect using Discretionary/OnPart or Association',\n        action: {\n          click: startConnect,\n          dragstart: startConnect\n        }\n      }\n    });\n  }\n\n\n  // delete element entry, only show if allowed by rules\n  var deleteAllowed = rules.allowed('elements.delete', { elements: [ element ] });\n\n  if (isArray(deleteAllowed)) {\n    // was the element returned as a deletion candidate?\n    deleteAllowed = deleteAllowed[0] === element;\n  }\n\n  if (deleteAllowed) {\n    assign(actions, {\n      'delete': {\n        group: 'edit',\n        className: 'cmmn-icon-trash',\n        title: 'Remove',\n        action: {\n          click: removeElement\n        }\n      }\n    });\n  }\n\n  return actions;\n};\n\n\nfunction isBlockingHumanTask(element) {\n  var definition = getDefinition(element);\n  return is(definition, 'cmmn:HumanTask') && definition.isBlocking;\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/context-pad/ContextPadProvider.js?")},"./node_modules/cmmn-js/lib/features/context-pad/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __depends__: [\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connect/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/context-pad/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/create/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js")/* ["default"] */ .Z),\n    __webpack_require__("./node_modules/cmmn-js/lib/features/popup-menu/index.js")\n  ],\n  __init__: [ \'contextPadProvider\' ],\n  contextPadProvider: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/context-pad/ContextPadProvider.js") ]\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/context-pad/index.js?')},"./node_modules/cmmn-js/lib/features/editor-actions/CmmnEditorActions.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar EditorActions = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/editor-actions/EditorActions.js\")/* [\"default\"] */ .Z);\n\n\n/**\n * Registers and executes CMMN specific editor actions.\n *\n * @param {Injector} injector\n */\nfunction CmmnEditorActions(injector) {\n  injector.invoke(EditorActions, this);\n}\n\ninherits(CmmnEditorActions, EditorActions);\n\nCmmnEditorActions.$inject = [\n  'injector'\n];\n\nmodule.exports = CmmnEditorActions;\n\n\n/**\n * Register default actions.\n *\n * @param {Injector} injector\n */\nCmmnEditorActions.prototype._registerDefaultActions = function(injector) {\n\n  // (0) invoke super method\n\n  EditorActions.prototype._registerDefaultActions.call(this, injector);\n\n  // (1) retrieve optional components to integrate with\n\n  var canvas = injector.get('canvas', false);\n  var elementRegistry = injector.get('elementRegistry', false);\n  var selection = injector.get('selection', false);\n  var spaceTool = injector.get('spaceTool', false);\n  var lassoTool = injector.get('lassoTool', false);\n  var handTool = injector.get('handTool', false);\n  var globalConnect = injector.get('globalConnect', false);\n  var directEditing = injector.get('directEditing', false);\n  var searchPad = injector.get('searchPad', false);\n\n  // (2) check components and register actions\n\n  if (canvas && elementRegistry && selection) {\n    this._registerAction('selectElements', function() {\n      // select all elements except for the invisible\n      // root element\n      var rootElement = canvas.getRootElement();\n\n      var elements = elementRegistry.filter(function(element) {\n        return element !== rootElement;\n      });\n\n      selection.select(elements);\n\n      return elements;\n    });\n  }\n\n  if (spaceTool) {\n    this._registerAction('spaceTool', function() {\n      spaceTool.toggle();\n    });\n  }\n\n  if (lassoTool) {\n    this._registerAction('lassoTool', function() {\n      lassoTool.toggle();\n    });\n  }\n\n  if (handTool) {\n    this._registerAction('handTool', function() {\n      handTool.toggle();\n    });\n  }\n\n  if (globalConnect) {\n    this._registerAction('globalConnectTool', function() {\n      globalConnect.toggle();\n    });\n  }\n\n  if (selection && directEditing) {\n    this._registerAction('directEditing', function() {\n      var currentSelection = selection.get();\n\n      if (currentSelection.length) {\n        directEditing.activate(currentSelection[0]);\n      }\n    });\n  }\n\n  if (searchPad) {\n    this._registerAction('find', function() {\n      searchPad.toggle();\n    });\n  }\n\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/editor-actions/CmmnEditorActions.js?")},"./node_modules/cmmn-js/lib/features/editor-actions/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var EditorActionsModule = (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/editor-actions/index.js")/* ["default"] */ .Z);\n\nvar CmmnEditorActions = __webpack_require__("./node_modules/cmmn-js/lib/features/editor-actions/CmmnEditorActions.js");\n\nmodule.exports = {\n  __depends__: [\n    EditorActionsModule\n  ],\n  editorActions: [ \'type\', CmmnEditorActions ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/editor-actions/index.js?')},"./node_modules/cmmn-js/lib/features/keyboard/CmmnKeyboardBindings.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar KeyboardBindings = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js\")/* [\"default\"] */ .Z);\n\n\n/**\n * CMMN specific keyboard bindings.\n *\n * @param {Injector} injector\n */\nfunction CmmnKeyboardBindings(injector) {\n  injector.invoke(KeyboardBindings, this);\n}\n\ninherits(CmmnKeyboardBindings, KeyboardBindings);\n\nCmmnKeyboardBindings.$inject = [\n  'injector'\n];\n\nmodule.exports = CmmnKeyboardBindings;\n\n/**\n * Register available keyboard bindings.\n *\n * @param {Keyboard} keyboard\n * @param {EditorActions} editorActions\n */\nCmmnKeyboardBindings.prototype.registerBindings = function(keyboard, editorActions) {\n\n  // inherit default bindings\n  KeyboardBindings.prototype.registerBindings.call(this, keyboard, editorActions);\n\n  /**\n   * Add keyboard binding if respective editor action\n   * is registered.\n   *\n   * @param {String} action name\n   * @param {Function} fn that implements the key binding\n   */\n  function addListener(action, fn) {\n\n    if (editorActions.isRegistered(action)) {\n      keyboard.addListener(fn);\n    }\n  }\n\n  // select all elements\n  // CTRL + A\n  addListener('selectElements', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.isKey(['a', 'A'], event) && keyboard.isCmd(event)) {\n      editorActions.trigger('selectElements');\n\n      return true;\n    }\n  });\n\n  // search labels\n  // CTRL + F\n  addListener('find', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.isKey(['f', 'F'], event) && keyboard.isCmd(event)) {\n      editorActions.trigger('find');\n\n      return true;\n    }\n  });\n\n  // activate space tool\n  // S\n  addListener('spaceTool', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey(['s', 'S'], event)) {\n      editorActions.trigger('spaceTool');\n\n      return true;\n    }\n  });\n\n  // activate lasso tool\n  // L\n  addListener('lassoTool', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey(['l', 'L'], event)) {\n      editorActions.trigger('lassoTool');\n\n      return true;\n    }\n  });\n\n  // activate hand tool\n  // H\n  addListener('handTool', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey(['h', 'H'], event)) {\n      editorActions.trigger('handTool');\n\n      return true;\n    }\n  });\n\n  // activate global connect tool\n  // C\n  addListener('globalConnectTool', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey(['c', 'C'], event)) {\n      editorActions.trigger('globalConnectTool');\n\n      return true;\n    }\n  });\n\n  // activate direct editing\n  // E\n  addListener('directEditing', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey(['e', 'E'], event)) {\n      editorActions.trigger('directEditing');\n\n      return true;\n    }\n  });\n\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/keyboard/CmmnKeyboardBindings.js?")},"./node_modules/cmmn-js/lib/features/keyboard/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __depends__: [\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/index.js")/* ["default"] */ .Z)\n  ],\n  __init__: [ \'keyboardBindings\' ],\n  keyboardBindings: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/keyboard/CmmnKeyboardBindings.js") ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/keyboard/index.js?')},"./node_modules/cmmn-js/lib/features/label-editing/LabelEditingProvider.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar UpdateLabelHandler = __webpack_require__(\"./node_modules/cmmn-js/lib/features/label-editing/cmd/UpdateLabelHandler.js\");\n\nvar LabelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/features/label-editing/LabelUtil.js\");\n\nvar isCasePlanModel = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").isCasePlanModel),\n    is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is),\n    getDefinition = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getDefinition);\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0);\n\nvar LINE_HEIGHT = 14,\n    PADDING = 6;\n\nfunction LabelEditingProvider(eventBus, canvas, directEditing, commandStack) {\n\n  this._canvas = canvas;\n  this._commandStack = commandStack;\n\n  directEditing.registerProvider(this);\n\n  commandStack.registerHandler('element.updateLabel', UpdateLabelHandler);\n\n  // listen to dblclick on non-root elements\n  eventBus.on('element.dblclick', function(event) {\n    directEditing.activate(event.element);\n  });\n\n  // complete on followup canvas operation\n  eventBus.on([ 'element.mousedown', 'drag.init', 'canvas.viewbox.changed' ], function(event) {\n    directEditing.complete();\n  });\n\n  // cancel on command stack changes\n  eventBus.on([ 'commandStack.changed' ], function() {\n    directEditing.cancel();\n  });\n\n  eventBus.on('create.end', 500, function(event) {\n\n    var element = event.shape,\n        canExecute = event.context.canExecute,\n        isTouch = event.isTouch;\n\n    // TODO(nikku): we need to find a way to support the\n    // direct editing on mobile devices; right now this will\n    // break for desworkflowediting on mobile devices\n    // as it breaks the user interaction workflow\n\n    // TODO(nre): we should temporarily focus the edited element\n    // here and release the focused viewport after the direct edit\n    // operation is finished\n    if (isTouch) {\n      return;\n    }\n\n    if (!canExecute) {\n      return;\n    }\n\n    directEditing.activate(element);\n  });\n\n}\n\nLabelEditingProvider.$inject = [\n  'eventBus',\n  'canvas',\n  'directEditing',\n  'commandStack'\n];\n\nmodule.exports = LabelEditingProvider;\n\n\n/**\n * Activate direct editing.\n *\n * @param  {djs.model.Base} element\n *\n * @return {Object} an object with properties bounds (position and size) and text\n */\nLabelEditingProvider.prototype.activate = function(element) {\n\n  var text = LabelUtil.getLabel(element);\n\n  if (text === undefined) {\n    return;\n  }\n\n  // don't activate for root element\n  if (!element.parent) {\n    return;\n  }\n\n  var target = element.label || element;\n\n  var props = this.getEditingBBox(element);\n\n  var definition = getDefinition(element);\n\n  var options = {};\n\n  if (is(definition, 'cmmn:Task') || is(definition, 'cmmn:Milestone')) {\n    options.centerVertically = true;\n  }\n\n  if (is(element, 'cmmn:TextAnnotation')) {\n    options.autoResize = true;\n    options.resizable = true;\n  }\n\n  // external labels for event listener, case file items and connections\n  if (target.labelTarget) {\n    options.autoResize = true;\n  }\n\n  return assign({ text: text, options: options }, props);\n};\n\n\n/**\n * Get the editing bounding box based on the element's size and position\n *\n * @param  {djs.model.Base} element\n *\n * @return {Object} an object containing information about position and size (fixed or minimum and/or maximum)\n */\nLabelEditingProvider.prototype.getEditingBBox = function(element, maxBounds) {\n\n  var canvas = this._canvas;\n\n  var definition = getDefinition(element);\n\n  var target = element.label || element;\n\n  var bbox = this._canvas.getAbsoluteBBox(target);\n\n  var mid = {\n    x: bbox.x + bbox.width / 2,\n    y: bbox.y + bbox.height / 2\n  };\n\n  // default position\n  var bounds = { x: bbox.x, y: bbox.y };\n\n  var style = {};\n\n  var zoom = canvas.zoom();\n\n  // internal labels for case plan models\n  if (isCasePlanModel(element)) {\n    bounds.height = 50;\n    bounds.width = 200;\n    bounds.y -= 30;\n\n    style.textAlign = 'left';\n  }\n\n  // internal labels for stages and plan fragments (excluding case plan models)\n  if (is(definition, 'cmmn:PlanFragment') && !isCasePlanModel(element)) {\n    bounds.width = element.width;\n    bounds.maxHeight = 3 * LINE_HEIGHT + PADDING; // maximum 3 lines\n    bounds.y += 5;\n\n    style.textAlign = 'left';\n  }\n\n  // internal labels for tasks\n  if (is(definition, 'cmmn:Task') || is(definition, 'cmmn:Milestone')) {\n\n    // fixed size for internal labels:\n    // on high zoom levels: text box size === bbox size\n    // on low zoom levels: text box size === bbox size at 100% zoom\n    // This ensures minimum bounds at low zoom levels\n    if (zoom > 1) {\n      bounds.width = bbox.width;\n      bounds.height = bbox.height;\n    } else {\n      bounds.width = bbox.width / zoom;\n      bounds.height = bbox.height / zoom;\n    }\n\n    // centering overlapping text box size at low zoom levels\n    if (zoom < 1) {\n      bounds.x = bbox.x - (bounds.width / 2 - bbox.width / 2);\n      bounds.y = bbox.y - (bounds.height / 2 - bbox.height / 2);\n    }\n  }\n\n  if (is(element, 'cmmn:TextAnnotation')) {\n    bounds.width = bbox.width;\n    bounds.height = bbox.height;\n    bounds.minWidth = 30 * zoom;\n    bounds.minHeight = 10 * zoom;\n\n    style.textAlign = 'left';\n  }\n\n  // external labels for event listener, case file items and connections\n  if (target.labelTarget) {\n\n    bounds.width = 150;\n    bounds.minHeight = LINE_HEIGHT + PADDING; // 1 line\n    bounds.x = mid.x - bounds.width / 2;\n  }\n\n  return {\n    bounds: bounds,\n    style: style\n  };\n};\n\n\nLabelEditingProvider.prototype.update = function(element, newLabel) {\n  this._commandStack.execute('element.updateLabel', {\n    element: element,\n    newLabel: newLabel\n  });\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/label-editing/LabelEditingProvider.js?")},"./node_modules/cmmn-js/lib/features/label-editing/LabelUtil.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is);\nvar isAny = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isAny);\n\nvar getBusinessObject = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getBusinessObject);\n\nfunction getLabelAttr(element) {\n  if (is(element, 'cmmn:TextAnnotation')) {\n    return 'text';\n  }\n\n  return 'name';\n}\n\nfunction getSemantic(element) {\n  var bo = getBusinessObject(element);\n\n  if (is(bo, 'cmmndi:CMMNEdge') && bo.cmmnElementRef) {\n    bo = bo.cmmnElementRef;\n  }\n\n  return bo;\n}\n\n/**\n * Check if the given element is of a type which has a reference to a definition.\n * This could be either plan items or discretionary items or case file items.\n *\n * @param {djs.model.Base} element\n *\n * @return {Boolean}\n */\nvar isReferencing = function(element) {\n  return isAny(element, [\n    'cmmn:PlanItem',\n    'cmmn:DiscretionaryItem',\n    'cmmn:CaseFileItem'\n  ]);\n};\n\nfunction hasEditableLabel(element) {\n  return !isAny(element, [\n    'cmmn:Association',\n    'cmmn:Criterion',\n    'cmmndi:CMMNEdge'\n  ]);\n}\n\nvar getLabel = function(element) {\n\n  var semantic = getSemantic(element),\n      attr = getLabelAttr(semantic);\n\n  if (!hasEditableLabel(semantic)) {\n    return;\n  }\n\n  // Get definition as semantic if\n  // * the element has no name property set\n  // * the element type has a reference to a definition\n  if (!semantic[attr] && isReferencing(element)) {\n    semantic = semantic.definitionRef;\n  }\n\n  return semantic[attr] || '';\n};\n\nmodule.exports.getLabel = getLabel;\n\n\nvar setLabel = function(element, text, isExternal, isExclusiveRef) {\n\n  var semantic = getSemantic(element),\n      attr = getLabelAttr(semantic);\n\n  // Get definition as semantic if\n  // * the element has no name property set\n  // * the element type has a reference to a definition\n  // * the element is the only reference to a defition\n  if (!semantic[attr] && isReferencing(element) && isExclusiveRef) {\n    semantic = semantic.definitionRef;\n  }\n\n  semantic[attr] = text;\n\n  // show external label if not empty\n  if (isExternal) {\n    element.hidden = !text;\n  }\n\n  return element;\n};\n\nmodule.exports.setLabel = setLabel;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/label-editing/LabelUtil.js?")},"./node_modules/cmmn-js/lib/features/label-editing/cmd/UpdateLabelHandler.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar LabelUtil = __webpack_require__("./node_modules/cmmn-js/lib/features/label-editing/LabelUtil.js");\n\nvar getDefinition = (__webpack_require__("./node_modules/cmmn-js/lib/util/ModelUtil.js").getDefinition);\n\n/**\n * A handler that updates the text of a CMMN element.\n */\nfunction UpdateLabelHandler(itemRegistry) {\n\n  /**\n   * Set the label and return the changed elements.\n   *\n   * Element parameter can be label itself or connection (i.e. sequence flow).\n   *\n   * @param {djs.model.Base} element\n   * @param {String} text\n   */\n  function setText(element, text) {\n\n    // external label if present\n    var label = element.label || element;\n\n    var labelTarget = element.labelTarget || element;\n\n    LabelUtil.setLabel(label, text, labelTarget !== label, isExclusiveRef(element));\n\n    return [ label, labelTarget ];\n  }\n\n  /**\n   * Return a function which checks if the element is the only reference to a definition\n   *\n   * @param  {djs.model.Base} element\n   *\n   * @return {Function}\n   */\n  function isExclusiveRef(element) {\n    var definition = getDefinition(element);\n    return definition ? itemRegistry.getReferences(definition).length === 1 : true;\n  }\n\n\n  function execute(ctx) {\n    ctx.oldLabel = LabelUtil.getLabel(ctx.element);\n    return setText(ctx.element, ctx.newLabel);\n  }\n\n  function revert(ctx) {\n    return setText(ctx.element, ctx.oldLabel);\n  }\n\n  // API\n\n  this.execute = execute;\n  this.revert = revert;\n}\n\n\nUpdateLabelHandler.$inject = [ \'itemRegistry\' ];\n\nmodule.exports = UpdateLabelHandler;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/label-editing/cmd/UpdateLabelHandler.js?')},"./node_modules/cmmn-js/lib/features/label-editing/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __depends__: [\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/command/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/change-support/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/diagram-js-direct-editing/index.js")/* ["default"] */ .Z)\n  ],\n  __init__: [ \'labelEditingProvider\' ],\n  labelEditingProvider: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/label-editing/LabelEditingProvider.js") ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/label-editing/index.js?')},"./node_modules/cmmn-js/lib/features/modeling/CmmnFactory.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar map = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .map */ .UI),\n    assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0),\n    pick = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .pick */ .ei);\n\nvar isAny = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isAny);\n\nfunction CmmnFactory(moddle) {\n  this._model = moddle;\n}\n\nCmmnFactory.$inject = [ 'moddle' ];\n\n\nCmmnFactory.prototype._needsId = function(element) {\n  return isAny(element, [\n    'cmmn:CMMNElement',\n    'cmmndi:CMMNShape',\n    'cmmndi:CMMNEdge',\n    'cmmndi:CMMNStyle',\n    'cmmndi:CMMNDiagram'\n  ]);\n};\n\nCmmnFactory.prototype._ensureId = function(element) {\n  // generate semantic ids for elements\n  var prefix = (element.$type || '').replace(/^[^:]*:/g, '') + '_';\n\n  if (!element.id && this._needsId(element)) {\n    element.id = this._model.ids.nextPrefixed(prefix, element);\n  }\n};\n\n\nCmmnFactory.prototype.create = function(type, attrs) {\n  var element = this._model.create(type, attrs || {});\n\n  this._ensureId(element);\n\n  return element;\n};\n\n\nCmmnFactory.prototype.createDiLabel = function() {\n  return this.create('cmmndi:CMMNLabel');\n};\n\n\nCmmnFactory.prototype.createDiShape = function(semantic, bounds, attrs) {\n  return this.create('cmmndi:CMMNShape', assign({\n    cmmnElementRef: semantic,\n    bounds: this.createDiBounds(bounds),\n    label: this.createDiLabel()\n  }, attrs));\n};\n\n\nCmmnFactory.prototype.createDiEdge = function(semantic, waypoints, attrs) {\n  return this.create('cmmndi:CMMNEdge', assign({\n    cmmnElementRef: semantic,\n    label: this.createDiLabel()\n  }, attrs));\n};\n\n\nCmmnFactory.prototype.createDiBounds = function(bounds) {\n  return this.create('dc:Bounds', bounds);\n};\n\n\nCmmnFactory.prototype.createDiWaypoints = function(waypoints) {\n\n  var self = this;\n\n  return map(waypoints, function(pos) {\n    return self.createDiWaypoint(pos);\n  });\n};\n\n\nCmmnFactory.prototype.createDiWaypoint = function(point) {\n  return this.create('dc:Point', pick(point, [ 'x', 'y' ]));\n};\n\n\nCmmnFactory.prototype.createItem = function(itemType, definitionType) {\n\n  var definition = this.create(definitionType);\n\n  return this.create(itemType, {\n    definitionRef: definition\n  });\n};\n\n\nCmmnFactory.prototype.createCriterion = function(criterionType, attrs) {\n\n  attrs = attrs || {};\n\n  if (!attrs.sentryRef) {\n    attrs = assign({\n      sentryRef: this.createSentry()\n    }, attrs);\n  }\n\n  return this.create(criterionType, attrs);\n};\n\n\nCmmnFactory.prototype.createSentry = function(attrs) {\n  return this.create('cmmn:Sentry', attrs);\n};\n\n\nCmmnFactory.prototype.createCasePlanModel = function() {\n\n  var casePlanModel = this.create('cmmn:Stage');\n\n  // overwrite generated id to 'CasePlanModel_...'\n  this._model.ids.unclaim(casePlanModel.id);\n  casePlanModel.id = this._model.ids.nextPrefixed('CasePlanModel_', casePlanModel);\n\n  var _case = this.create('cmmn:Case', {\n    casePlanModel: casePlanModel\n  });\n\n  casePlanModel.$parent = _case;\n\n  return casePlanModel;\n\n};\n\n\nCmmnFactory.prototype.createCaseFileModel = function(_case) {\n\n  var caseFileModel = this.create('cmmn:CaseFile');\n\n  // overwrite generated id to 'CaseFileModel_...'\n  this._model.ids.unclaim(caseFileModel.id);\n  caseFileModel.id = this._model.ids.nextPrefixed('CaseFileModel_', caseFileModel);\n\n  caseFileModel.$parent = _case;\n\n  return caseFileModel;\n\n};\n\n\nCmmnFactory.prototype.createCaseFileItem = function(attrs) {\n\n  attrs = attrs || {};\n\n  if (!attrs.definitionRef) {\n\n    attrs = assign({\n      definitionRef: this.create('cmmn:CaseFileItemDefinition')\n    }, attrs);\n\n  }\n\n  return this.create('cmmn:CaseFileItem', attrs);\n\n};\n\nmodule.exports = CmmnFactory;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/CmmnFactory.js?")},"./node_modules/cmmn-js/lib/features/modeling/CmmnLayouter.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar inherits = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n\nvar BaseLayouter = (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/BaseLayouter.js")/* ["default"] */ .Z),\n    ManhattanLayout = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/ManhattanLayout.js");\n\nvar getMid = (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js")/* .getMid */ .wS);\n\n\nfunction CmmnLayouter() {}\n\ninherits(CmmnLayouter, BaseLayouter);\n\nmodule.exports = CmmnLayouter;\n\n\nCmmnLayouter.prototype.layoutConnection = function(connection, hints) {\n\n  hints = hints || {};\n\n  var source = hints.source || connection.source,\n      target = hints.target || connection.target,\n      waypoints = connection.waypoints,\n      start = hints.connectionStart,\n      end = hints.connectionEnd;\n\n\n  if (!start) {\n    start = getConnectionDocking(waypoints && waypoints[0], source);\n  }\n\n  if (!end) {\n    end = getConnectionDocking(waypoints && waypoints[waypoints.length - 1], target);\n  }\n\n  var updatedWaypoints =\n    ManhattanLayout.repairConnection(\n      source, target,\n      start, end,\n      waypoints,\n      hints);\n\n  return updatedWaypoints || [ start, end ];\n};\n\nfunction getConnectionDocking(point, shape) {\n  return point ? (point.original || point) : getMid(shape);\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/CmmnLayouter.js?')},"./node_modules/cmmn-js/lib/features/modeling/CmmnUpdater.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0),\n    inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\nvar Collections = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\");\n\nvar getBusinessObject = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getBusinessObject),\n    is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is),\n    isCasePlanModel = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").isCasePlanModel);\n\nvar getParent = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").getParent),\n    isLabel = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isLabel);\n\nvar isAny = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isAny);\n\n/**\n * A handler responsible for updating the underlying CMMN 1.1 XML + DI\n * once changes on the diagram happen\n */\nfunction CmmnUpdater(eventBus, cmmnFactory, itemRegistry, connectionDocking) {\n\n  CommandInterceptor.call(this, eventBus);\n\n  this._cmmnFactory = cmmnFactory;\n  this._itemRegistry = itemRegistry;\n\n  var self = this;\n\n\n  // connection cropping /////////////////\n\n  // crop connection ends during create/update\n  function cropConnection(e) {\n    var context = e.context,\n        connection;\n\n    if (!context.cropped) {\n      connection = context.connection;\n      connection.waypoints = connectionDocking.getCroppedWaypoints(connection);\n      context.cropped = true;\n    }\n  }\n\n  this.executed([\n    'connection.layout',\n    'connection.create',\n    'connection.reconnectEnd',\n    'connection.reconnectStart'\n  ], cropConnection);\n\n  this.reverted([\n    'connection.layout',\n    'connection.create',\n    'connection.reconnectEnd',\n    'connection.reconnectStart'\n  ], function(e) {\n    delete e.context.cropped;\n  });\n\n  // CMMN + DI update /////////////////\n\n  function updateParent(e) {\n    var context = e.context;\n\n    self.updateParent(context.shape || context.connection, context.oldParent);\n  }\n\n  function reverseUpdateParent(e) {\n\n    var context = e.context;\n\n    var element = context.shape || context.connection,\n        // oldParent is the (old) new parent, because we are undoing\n        oldParent = context.parent || context.newParent;\n\n    self.updateParent(element, oldParent);\n  }\n\n  this.executed([\n    'shape.create',\n    'shape.move',\n    'shape.delete',\n    'connection.delete',\n    'connection.create'\n  ], ifCmmn(updateParent));\n  this.reverted([\n    'shape.create',\n    'shape.move',\n    'shape.delete',\n    'connection.delete',\n    'connection.create'\n  ], ifCmmn(reverseUpdateParent));\n\n\n  // update bounds\n  function updateBounds(e) {\n    var shape = e.context.shape;\n    self.updateBounds(shape);\n  }\n\n  this.executed([\n    'shape.create',\n    'shape.move',\n    'shape.resize'\n  ], ifCmmn(function(event) {\n\n    // exclude labels because they're handled separately during shape.changed\n    if (event.context.shape.type === 'label') {\n      return;\n    }\n\n    updateBounds(event);\n  }));\n\n  this.reverted([\n    'shape.create',\n    'shape.move',\n    'shape.resize'\n  ], ifCmmn(function(event) {\n\n    // exclude labels because they're handled separately during shape.changed\n    if (event.context.shape.type === 'label') {\n      return;\n    }\n\n    updateBounds(event);\n  }));\n\n  // Handle labels separately. This is necessary, because the label bounds have to be updated\n  // every time its shape changes, not only on move, create and resize.\n  eventBus.on('shape.changed', function(event) {\n    if (event.element.type === 'label') {\n      updateBounds({ context: { shape: event.element } });\n    }\n  });\n\n  // attach / detach connection\n  function updateConnection(e) {\n    self.updateConnection(e.context);\n  }\n\n  this.executed([\n    'connection.create',\n    'connection.move',\n    'connection.delete',\n    'connection.reconnectEnd',\n    'connection.reconnectStart'\n  ], ifCmmn(updateConnection));\n\n  this.reverted([\n    'connection.create',\n    'connection.move',\n    'connection.delete',\n    'connection.reconnectEnd',\n    'connection.reconnectStart'\n  ], ifCmmn(updateConnection));\n\n\n  // update waypoints\n  function updateConnectionWaypoints(e) {\n    self.updateConnectionWaypoints(e.context.connection);\n  }\n\n  this.executed([\n    'connection.create',\n    'connection.layout',\n    'connection.move',\n    'connection.reconnectStart',\n    'connection.reconnectEnd',\n    'connection.updateWaypoints'\n  ], ifCmmn(updateConnectionWaypoints));\n\n  this.reverted([\n    'connection.create',\n    'connection.layout',\n    'connection.move',\n    'connection.reconnectStart',\n    'connection.reconnectEnd',\n    'connection.updateWaypoints'\n  ], ifCmmn(updateConnectionWaypoints));\n\n  // update attachments\n  function updateAttachment(e) {\n    self.updateAttachment(e.context);\n  }\n\n  this.executed([ 'element.updateAttachment' ], ifCmmn(updateAttachment));\n  this.reverted([ 'element.updateAttachment' ], ifCmmn(updateAttachment));\n\n\n  // update item registry\n\n  function addItem(e) {\n    var context = e.context,\n        shape = context.shape,\n        bo = getBusinessObject(shape);\n\n    itemRegistry.add(bo);\n  }\n\n  function removeItem(e) {\n\n    var context = e.context,\n        shape = context.shape;\n\n    if (isLabel(shape)) {\n      return;\n    }\n\n    var bo = getBusinessObject(shape);\n    itemRegistry.remove(bo);\n  }\n\n  this.executed('shape.create', ifCmmn(addItem));\n  this.reverted('shape.create', ifCmmn(removeItem));\n\n  this.executed('shape.delete', ifCmmn(removeItem));\n  this.reverted('shape.delete', ifCmmn(addItem));\n\n}\n\ninherits(CmmnUpdater, CommandInterceptor);\n\nmodule.exports = CmmnUpdater;\n\nCmmnUpdater.$inject = [ 'eventBus', 'cmmnFactory', 'itemRegistry', 'connectionDocking' ];\n\n\n// implementation /////////////////\n\n\nCmmnUpdater.prototype.updateAttachment = function(context) {\n  var shape = context.shape,\n      businessObject = getBusinessObject(shape),\n      host = shape.host,\n      businessObjectHost = host && getBusinessObject(host);\n\n  this.updateSemanticParent(businessObject, businessObjectHost);\n};\n\n\nCmmnUpdater.prototype.updateParent = function(element, oldParent) {\n  // do not update CMMN 1.1 label parent\n  if (isLabel(element)) {\n    return;\n  }\n\n  var businessObject = getBusinessObject(element),\n      parentBusinessObject = getBusinessObject(element.parent),\n      businessObjectDi = businessObject.di || businessObject,\n      parentDi = parentBusinessObject && parentBusinessObject.di;\n\n  if (isAssociation(businessObject)) {\n    businessObject = businessObject.cmmnElementRef;\n  }\n\n  if (shouldUpdateSemanticParent(businessObject)) {\n    this.updateSemanticParent(businessObject, parentBusinessObject);\n  }\n\n  if (is(parentBusinessObject, 'cmmndi:CMMNDiagram')) {\n    parentDi = parentBusinessObject;\n  }\n\n  this.updateDiParent(businessObjectDi, parentDi);\n};\n\n\n/**\n * Update the semantic parent\n *\n * - add/remove the business object to/from the parent's containment(s)\n * - set/unset the $parent property of the business object\n *\n * @param  {ModdleElement} businessObject\n * @param  {ModdleElement} newParent\n */\nCmmnUpdater.prototype.updateSemanticParent = function(businessObject, newParent) {\n\n  var containment;\n\n  if (businessObject.$parent === newParent) {\n    return;\n  }\n\n  if (is(businessObject, 'cmmn:PlanItem')) {\n    containment = 'planItems';\n\n    if (newParent && !isCasePlanModel(newParent)) {\n      newParent = newParent.definitionRef;\n    }\n\n  } else\n\n  if (isCasePlanModel(businessObject)) {\n    containment = 'cases';\n    businessObject = businessObject.$parent;\n    newParent = newParent && getDefinitions(newParent);\n  } else\n\n  if (is(businessObject, 'cmmn:EntryCriterion')) {\n\n    if (isCasePlanModel(newParent)) {\n      newParent = null;\n    }\n\n    containment = 'entryCriteria';\n  } else\n\n  if (is(businessObject, 'cmmn:ExitCriterion')) {\n    containment = 'exitCriteria';\n  } else\n\n  if (is(businessObject, 'cmmn:Artifact')) {\n    newParent = newParent && getDefinitions(newParent);\n    containment = 'artifacts';\n  }\n\n  if (!containment) {\n    throw new Error('no parent for ', businessObject, newParent);\n  }\n\n  var children;\n\n  if (businessObject.$parent) {\n    // remove from old parent\n    children = businessObject.$parent.get(containment);\n    Collections.remove(children, businessObject);\n  }\n\n  if (newParent) {\n    // add to new parent\n    children = newParent.get(containment);\n    children.push(businessObject);\n    businessObject.$parent = newParent;\n  } else {\n    businessObject.$parent = null;\n  }\n\n};\n\n\n/**\n * Upate the parent of an DI element\n *\n * - Add/remove DI element to the root element's diagramElements conainment\n * - Set/unset the $parent property of the DI element\n *\n * @param  {ModdleElement} di\n * @param  {ModdleElement} parentDi\n */\nCmmnUpdater.prototype.updateDiParent = function(di, parentDi) {\n  if (parentDi && !is(parentDi, 'cmmndi:CMMNDiagram')) {\n    parentDi = parentDi.$parent;\n  }\n\n  if (di.$parent === parentDi) {\n    return;\n  }\n\n  var diagramElements = (parentDi || di.$parent).get('diagramElements');\n\n  if (parentDi) {\n    diagramElements.push(di);\n    di.$parent = parentDi;\n  }\n  else {\n    Collections.remove(diagramElements, di);\n    di.$parent = null;\n  }\n};\n\n\nCmmnUpdater.prototype.updateBounds = function(shape) {\n  var di = shape.businessObject.di || shape.businessObject;\n\n  var bounds = isLabel(shape) ? this._getLabel(di).bounds : di.bounds;\n\n  assign(bounds, {\n    x: shape.x,\n    y: shape.y,\n    width: shape.width,\n    height: shape.height\n  });\n};\n\n\nCmmnUpdater.prototype.updateConnectionWaypoints = function(connection) {\n  var di = connection.businessObject;\n  di.set('waypoint', this._cmmnFactory.createDiWaypoints(connection.waypoints));\n};\n\n\nCmmnUpdater.prototype.updateConnection = function(context) {\n\n  var connection = context.connection,\n      businessObject = getBusinessObject(connection),\n      newSource = getBusinessObject(connection.source),\n      newTarget = getBusinessObject(connection.target),\n      cmmnElement = businessObject.cmmnElementRef,\n      sourceElem,\n      targetElem,\n      sourceAttr,\n      targetAttr;\n\n\n  if (is(cmmnElement, 'cmmn:Association')) {\n    sourceElem = cmmnElement;\n    targetElem = cmmnElement;\n\n    sourceAttr = 'sourceRef';\n    targetAttr = 'targetRef';\n  }\n  else {\n    targetElem = businessObject;\n    targetAttr = 'targetCMMNElementRef';\n\n    if (is(cmmnElement, 'cmmn:OnPart')) {\n\n      sourceElem = cmmnElement;\n      sourceAttr = 'sourceRef';\n\n      var newExitCriterionRef;\n      if (is(newSource, 'cmmn:ExitCriterion')) {\n        newExitCriterionRef = newSource;\n        newSource = getParent(newExitCriterionRef);\n      }\n\n      if (cmmnElement.exitCriterionRef !== newExitCriterionRef) {\n        cmmnElement.exitCriterionRef = newExitCriterionRef;\n      }\n\n    }\n    else {\n      sourceElem = businessObject;\n      sourceAttr = 'sourceCMMNElementRef';\n    }\n\n  }\n\n  if (sourceAttr && sourceElem[sourceAttr] !== newSource) {\n    sourceElem[sourceAttr] = newSource;\n  }\n\n  if (targetAttr && targetElem[targetAttr] !== newTarget) {\n    targetElem[targetAttr] = newTarget;\n  }\n\n  this.updateConnectionWaypoints(connection);\n};\n\n// helpers /////////////////\n\nCmmnUpdater.prototype._getLabel = function(di) {\n\n  if (!di.label) {\n    di.label = this._cmmnFactory.createDiLabel();\n  }\n\n  if (!di.label.bounds) {\n    di.label.bounds = this._cmmnFactory.createDiBounds();\n  }\n\n  return di.label;\n};\n\n\n/**\n * Make sure the event listener is only called\n * if the touched element is a CMMN element.\n *\n * @param  {Function} fn\n * @return {Function} guarded function\n */\nfunction ifCmmn(fn) {\n\n  return function(event) {\n\n    var context = event.context,\n        element = context.shape || context.connection;\n\n    if (is(element, 'cmmn:CMMNElement') || is(element, 'cmmndi:CMMNDiagramElement')) {\n      fn(event);\n    }\n  };\n}\n\n/**\n * Returns the cmmn:Definitions element for a given element.\n */\nfunction getDefinitions(element) {\n  return getParent(element, 'cmmn:Definitions');\n}\n\nfunction shouldUpdateSemanticParent(element) {\n  return !isAny(element, [\n    'cmmn:CaseFileItem',\n    'cmmn:Criterion',\n    'cmmn:DiscretionaryItem',\n    'cmmn:OnPart',\n    'cmmndi:CMMNEdge'\n  ]);\n}\n\nfunction isAssociation(connection) {\n  connection = connection.businessObject || connection;\n  return !!(connection.cmmnElementRef && is(connection.cmmnElementRef, 'cmmn:Association'));\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/CmmnUpdater.js?")},"./node_modules/cmmn-js/lib/features/modeling/ElementFactory.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0),\n    inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar BaseElementFactory = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/core/ElementFactory.js\")/* [\"default\"] */ .Z),\n    LabelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/LabelUtil.js\");\n\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is),\n    getDefinition = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getDefinition),\n    isCasePlanModel = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").isCasePlanModel);\n\nvar isCollapsed = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/DiUtil.js\").isCollapsed);\n\n/**\n * A cmmn-aware factory for diagram-js shapes\n */\nfunction ElementFactory(cmmnFactory, moddle) {\n  BaseElementFactory.call(this);\n\n  this._cmmnFactory = cmmnFactory;\n  this._moddle = moddle;\n}\n\ninherits(ElementFactory, BaseElementFactory);\n\n\nElementFactory.$inject = [ 'cmmnFactory', 'moddle' ];\n\nmodule.exports = ElementFactory;\n\nElementFactory.prototype.baseCreate = BaseElementFactory.prototype.create;\n\nElementFactory.prototype.create = function(elementType, attrs) {\n  // no special magic for labels,\n  // we assume their businessObjects have already been created\n  // and wired via attrs\n  if (elementType === 'label') {\n    return this.baseCreate(elementType, assign({ type: 'label' }, LabelUtil.DEFAULT_LABEL_SIZE, attrs));\n  }\n\n  if (elementType === 'root') {\n    return this.baseCreate(elementType, attrs);\n  }\n\n  return this.createCmmnElement(elementType, attrs);\n};\n\n\nElementFactory.prototype.createCmmnElement = function(elementType, attrs) {\n\n  attrs = assign({}, attrs || {});\n\n  var size;\n\n  var businessObject = attrs.businessObject;\n\n  if (!businessObject) {\n    if (!attrs.type) {\n      throw new Error('no shape type specified');\n    }\n\n    var props = {};\n\n    if (attrs.name) {\n      assign(props, {\n        name: attrs.name\n      });\n    }\n\n    businessObject = this._cmmnFactory.create(attrs.type, props);\n  }\n\n\n  if (elementType === 'connection') {\n\n    if (!is(businessObject, 'cmmndi:CMMNEdge')) {\n      businessObject = this._cmmnFactory.createDiEdge(businessObject, [], {\n        id: businessObject.id + '_di'\n      });\n    }\n\n    if (!businessObject.label) {\n      businessObject.label = this._cmmnFactory.createDiLabel();\n    }\n\n    attrs.type = 'cmmndi:CMMNEdge';\n  }\n\n  if (attrs.definitionType) {\n    var definition = this._cmmnFactory.create(attrs.definitionType);\n    businessObject.definitionRef = definition;\n  }\n\n  if (attrs.sentryRef) {\n    businessObject.sentryRef = attrs.sentryRef;\n  }\n\n  if (elementType === 'shape' && !businessObject.di) {\n    businessObject.di = this._cmmnFactory.createDiShape(businessObject, {}, {\n      id: businessObject.id + '_di'\n    });\n  }\n\n  if (attrs.isCollapsed) {\n    businessObject.di.isCollapsed = attrs.isCollapsed;\n  }\n\n  if (attrs.isPlanningTableCollapsed) {\n    businessObject.di.isPlanningTableCollapsed = attrs.isPlanningTableCollapsed;\n  }\n\n  if (attrs.isStandardEventVisible) {\n    businessObject.isStandardEventVisible = attrs.isStandardEventVisible;\n  }\n\n  if (attrs.isBlocking !== undefined) {\n    businessObject.definitionRef.isBlocking = attrs.isBlocking;\n  }\n\n  if (attrs.autoComplete) {\n    businessObject.definitionRef.autoComplete = true;\n  }\n\n  size = this._getDefaultSize(businessObject);\n\n  attrs = assign({\n    businessObject: businessObject,\n    id: businessObject.id\n  }, size, attrs);\n\n  return this.baseCreate(elementType, attrs);\n};\n\n\nElementFactory.prototype._getDefaultSize = function(semantic) {\n\n  var definition = getDefinition(semantic);\n\n  // CasePlanModel (type of semantic is 'cmmn:Stage')\n  if (isCasePlanModel(semantic)) {\n    return { width: 400, height: 250 };\n  }\n\n  if (is(definition, 'cmmn:PlanFragment')) {\n    if (isCollapsed(semantic)) {\n      return { width: 100, height: 80 };\n    }\n    else {\n      return { width: 350, height: 200 };\n    }\n  }\n\n  if (is(definition, 'cmmn:Milestone')) {\n    return { width: 100, height: 40 };\n  }\n\n  if (is(definition, 'cmmn:EventListener')) {\n    return { width: 36, height: 36 };\n  }\n\n  if (is(semantic, 'cmmn:Criterion')) {\n    return { width: 20, height: 28 };\n  }\n\n  if (is(semantic, 'cmmn:TextAnnotation')) {\n    return { width: 100, height: 30 };\n  }\n\n  if (is(semantic, 'cmmn:CaseFileItem')) {\n    return { width: 36, height: 50 };\n  }\n\n  return { width: 100, height: 80 };\n};\n\n\nElementFactory.prototype.createPlanItemShape = function(type) {\n  return this.createShape({\n    type: 'cmmn:PlanItem',\n    businessObject: this._cmmnFactory.createItem('cmmn:PlanItem', type)\n  });\n};\n\n\nElementFactory.prototype.createDiscretionaryItemShape = function(type) {\n  return this.createShape({\n    type: 'cmmn:DiscretionaryItem',\n    businessObject: this._cmmnFactory.createItem('cmmn:DiscretionaryItem', type)\n  });\n};\n\n\nElementFactory.prototype.createCasePlanModelShape = function() {\n  return this.createShape({\n    type: 'cmmn:Stage',\n    businessObject: this._cmmnFactory.createCasePlanModel()\n  });\n};\n\n\nElementFactory.prototype.createCriterionShape = function(type) {\n  return this.createShape({\n    type: type,\n    businessObject: this._cmmnFactory.createCriterion(type)\n  });\n};\n\n\nElementFactory.prototype.createCaseFileItemShape = function() {\n  return this.createShape({\n    type: 'cmmn:CaseFileItem',\n    businessObject: this._cmmnFactory.createCaseFileItem()\n  });\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/ElementFactory.js?")},"./node_modules/cmmn-js/lib/features/modeling/Modeling.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0);\n\nvar BaseModeling = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/Modeling.js\")/* [\"default\"] */ .Z);\n\nvar AppendShapeHandler = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/cmd/AppendShapeHandler.js\");\nvar ReconnectConnectionHandler = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/cmd/ReconnectConnectionHandler.js\");\nvar ReplaceShapeHandler = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/cmd/ReplaceShapeHandler.js\");\n\nvar UpdatePropertiesHandler = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/cmd/UpdatePropertiesHandler.js\");\nvar UpdateSemanticParentHandler = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/cmd/UpdateSemanticParentHandler.js\");\nvar UpdateControlsHandler = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/cmd/UpdateControlsHandler.js\");\n\nvar IdClaimHandler = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/cmd/IdClaimHandler.js\");\n\n/**\n * CMMN 1.1 modeling features activator\n *\n * @param {EventBus} eventBus\n * @param {ElementFactory} elementFactory\n * @param {CommandStack} commandStack\n */\nfunction Modeling(eventBus, elementFactory, commandStack, cmmnRules, rules) {\n  BaseModeling.call(this, eventBus, elementFactory, commandStack);\n\n  this._cmmnRules = cmmnRules;\n  this._rules = rules;\n}\n\ninherits(Modeling, BaseModeling);\n\nModeling.$inject = [ 'eventBus', 'elementFactory', 'commandStack', 'cmmnRules', 'rules' ];\n\nmodule.exports = Modeling;\n\n\nModeling.prototype.getHandlers = function() {\n  var handlers = BaseModeling.prototype.getHandlers.call(this);\n\n  handlers['shape.append'] = AppendShapeHandler;\n  handlers['shape.replace'] = ReplaceShapeHandler;\n  handlers['connection.reconnectStart'] = ReconnectConnectionHandler;\n  handlers['connection.reconnectEnd'] = ReconnectConnectionHandler;\n\n  handlers['element.updateProperties'] = UpdatePropertiesHandler;\n  handlers['element.updateSemanticParent'] = UpdateSemanticParentHandler;\n\n  handlers['element.updateControls'] = UpdateControlsHandler;\n\n  handlers['id.updateClaim'] = IdClaimHandler;\n\n  return handlers;\n};\n\n\nModeling.prototype.connect = function(source, target, attrs, hints) {\n\n  var rules = this._rules;\n\n  if (!attrs) {\n    attrs = rules.allowed('connection.create', {\n      source: source,\n      target: target\n    }) || { type: 'cmmn:Association' };\n  }\n\n  if (attrs.reverse) {\n\n    if (hints) {\n      hints = {\n        connectionStart: hints.connectionEnd,\n        connectionEnd: hints.connectionStart\n      };\n    }\n\n    return this.createConnection(target, source, attrs, target.parent, hints);\n  }\n\n  return this.createConnection(source, target, attrs, source.parent, hints);\n};\n\n\nModeling.prototype.createConnection = function(source, target, targetIndex, connection, parent, hints) {\n\n  // Overwrite existing createConnection() method to provide additional\n  // information in the context. This must be done to enable the replacement\n  // of the target element, if necessary.\n\n  if (typeof targetIndex === 'object') {\n    hints = parent;\n    parent = connection;\n    connection = targetIndex;\n    targetIndex = undefined;\n  }\n\n  var context = {\n    source: source,\n    target: target,\n    parent: parent,\n    parentIndex: targetIndex,\n    canExecute: connection,\n    hints: hints\n  };\n\n  connection = this._create('connection', connection);\n\n  assign(context, {\n    connection: connection\n  });\n\n  this._commandStack.execute('connection.create', context);\n\n  return context.connection;\n};\n\n\nModeling.prototype.reconnectStart = function(connection, newSource, dockingOrPoints, hints) {\n  var context = {\n    connection: connection,\n    newSource: newSource,\n    dockingOrPoints: dockingOrPoints,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.reconnectStart', context);\n};\n\n\nModeling.prototype.reconnectEnd = function(connection, newTarget, dockingOrPoints, hints) {\n  var context = {\n    connection: connection,\n    newTarget: newTarget,\n    dockingOrPoints: dockingOrPoints,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.reconnectEnd', context);\n};\n\n\nModeling.prototype.updateProperties = function(element, properties, shape) {\n  this._commandStack.execute('element.updateProperties', {\n    element: element,\n    properties: properties,\n    shape: shape\n  });\n};\n\n\nModeling.prototype.updateSemanticParent = function(element, newParent, containment, shape) {\n  this._commandStack.execute('element.updateSemanticParent', {\n    element: element,\n    newParent: newParent,\n    containment: containment,\n    shape: shape\n  });\n};\n\n\nModeling.prototype.updateControls = function(element, values) {\n  this._commandStack.execute('element.updateControls', {\n    element: element,\n    values: values\n  });\n};\n\n\nModeling.prototype.claimId = function(id, moddleElement) {\n  this._commandStack.execute('id.updateClaim', {\n    id: id,\n    element: moddleElement,\n    claiming: true\n  });\n};\n\n\nModeling.prototype.unclaimId = function(id, moddleElement) {\n  this._commandStack.execute('id.updateClaim', {\n    id: id,\n    element: moddleElement\n  });\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/Modeling.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/AttachCriterionBehavior.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    isCasePlanModel = ModelUtil.isCasePlanModel;\n\n/*\n * If a criterion is (re-)attached to a case plan model,\n * then the (visual) parent must be the case plan model itself,\n * and not the root element.\n */\nfunction AttachCriterionBehavior(eventBus) {\n\n  CommandInterceptor.call(this, eventBus);\n\n  this.preExecute([ 'shape.create', 'elements.move' ], function(context) {\n\n    var shape = context.shape,\n        shapes = context.shapes,\n        parent = context.parent || context.newParent,\n        host = context.host || context.newHost;\n\n    if (!parent) {\n      return;\n    }\n\n    if (!host || !isCasePlanModel(host)) {\n      return;\n    }\n\n    if (shapes && shapes.length > 1) {\n      return;\n    }\n\n    shape = shape || shapes[0];\n\n    if (!is(shape, 'cmmn:Criterion')) {\n      return;\n    }\n\n    context.parent = context.parent && host;\n    context.newParent = context.newParent && host;\n\n  }, true);\n\n\n\n}\n\nAttachCriterionBehavior.$inject = [ 'eventBus' ];\n\ninherits(AttachCriterionBehavior, CommandInterceptor);\n\nmodule.exports = AttachCriterionBehavior;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/AttachCriterionBehavior.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/CaseFileItemUpdater.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\nvar forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed);\nvar filter = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .filter */ .hX);\nvar reduce = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .reduce */ .u4);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    getDefinition = ModelUtil.getDefinition,\n    getBusinessObject = ModelUtil.getBusinessObject,\n    is = ModelUtil.is;\n\nvar ModelingUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\"),\n    getCase = ModelingUtil.getCase,\n    getParent = ModelingUtil.getParent,\n    isSameCase = ModelingUtil.isSameCase,\n    isLabel = ModelingUtil.isLabel;\n\n\nfunction CaseFileItemUpdater(\n    eventBus,\n    itemRegistry,\n    cmmnFactory,\n    modeling\n) {\n\n  this._cmmnFactory = cmmnFactory;\n  this._modeling = modeling;\n\n  CommandInterceptor.call(this, eventBus);\n\n  var containment = 'caseFileItems';\n\n\n  this.preExecuted('shape.create', function(context) {\n\n    var shape = context.shape,\n        parent = context.parent,\n        parentBusinessObject = getBusinessObject(parent),\n        definitions,\n        caseFileItemDefinition,\n        caseFileModel;\n\n\n    if (!isCaseFileItem(shape)) {\n      return;\n    }\n\n    caseFileItemDefinition = getDefinition(shape);\n\n    if (caseFileItemDefinition) {\n      definitions = getDefinitions(parentBusinessObject);\n      modeling.updateSemanticParent(caseFileItemDefinition, definitions, 'caseFileItemDefinitions');\n    }\n\n    caseFileModel = createCaseFileModel(parent);\n\n    modeling.updateSemanticParent(shape, caseFileModel, containment);\n\n  }, true);\n\n\n\n\n  this.preExecuted('elements.move', function(context) {\n\n    var newParent = context.newParent,\n        hints = context.hints,\n        oldParent = hints && hints.primaryShape && hints.primaryShape.parent,\n        closure = context.closure || {},\n        shapes = closure.allShapes,\n        caseFileModel;\n\n\n    if (!newParent || oldParent === newParent) {\n      return;\n    }\n\n\n    shapes = filter(shapes, function(shape) {\n      return isCaseFileItem(shape) && !isLabel(shape) && !isSameCase(shape.parent, newParent);\n    });\n\n    if (shapes && shapes.length) {\n\n      caseFileModel = createCaseFileModel(newParent);\n\n      shapes = toMap(shapes);\n\n      forEach(shapes, function(shape) {\n\n        var caseFileItem = getBusinessObject(shape),\n            oldCaseFileModel = getParentCaseFile(caseFileItem),\n            oldSemanticParent = getParent(caseFileItem);\n\n        if (isCaseFileModel(oldSemanticParent)) {\n\n          modeling.updateSemanticParent(shape, caseFileModel, containment);\n\n        }\n        else {\n\n          var parentCaseFileItem = getParent(caseFileItem, 'cmmn:CaseFileItem');\n          if (!shapes[parentCaseFileItem.id]) {\n            modeling.updateSemanticParent(shape, caseFileModel, containment);\n          }\n\n        }\n\n        var source = caseFileItem.sourceRef;\n        if (source && !shapes[source.id]) {\n          clearSourceRef(caseFileItem);\n        }\n\n        clearTargetRefs(caseFileItem, function(target) {\n          return !shapes[target.id];\n        });\n\n\n        moveChildren(caseFileItem, oldCaseFileModel, function(child) {\n          return !shapes[child.id];\n        });\n\n        clearCaseFileItemContainer(oldSemanticParent);\n\n      });\n\n    }\n\n  }, true);\n\n\n  this.postExecuted('shape.delete', function(context) {\n\n    var shape = context.shape,\n        bo = getBusinessObject(shape),\n        caseFileItemDefinition;\n\n    if (!isCaseFileItem(shape) || isLabel(shape)) {\n      return;\n    }\n\n    var oldSemanticParent = getParent(bo),\n        caseFileModel = getParentCaseFile(bo);\n\n    modeling.updateSemanticParent(shape, null, containment);\n\n    clearSourceRef(shape);\n    clearTargetRefs(shape);\n    moveChildren(bo, caseFileModel);\n\n    clearCaseFileItemContainer(oldSemanticParent);\n\n    if (isExlusiveRef(shape)) {\n      caseFileItemDefinition = getDefinition(shape);\n      modeling.updateSemanticParent(caseFileItemDefinition, null, 'caseFileItemDefinitions');\n    }\n\n  }, true);\n\n\n\n  function createCaseFileModel(element) {\n    var _case = getCase(element),\n        caseFileModel = _case.caseFileModel;\n\n    if (!caseFileModel) {\n      caseFileModel = cmmnFactory.createCaseFileModel(_case);\n      modeling.updateProperties(_case, { caseFileModel: caseFileModel });\n    }\n\n    return caseFileModel;\n  }\n\n\n  function clearCaseFileItemContainer(container) {\n    var items = container && container.get(containment);\n\n    if (items && !items.length) {\n\n      var prop = 'caseFileModel',\n          parent = container.$parent;\n\n      if (!isCaseFileModel(container)) {\n        prop = 'children';\n      }\n\n      var update = {};\n      update[prop] = undefined;\n\n      modeling.updateProperties(parent, update);\n      modeling.updateSemanticParent(container);\n    }\n\n  }\n\n\n  function clearSourceRef(target) {\n    target = getBusinessObject(target);\n\n    var source = target.sourceRef;\n\n    if (source) {\n      clearTargetRefs(source, function(elem) {\n        return target === elem;\n      });\n\n      modeling.updateProperties(target, { sourceRef: undefined });\n    }\n\n  }\n\n\n  function clearTargetRefs(source, canRemoveFilter) {\n    source = getBusinessObject(source);\n\n    var targets = source && source.get('targetRefs'),\n        copy;\n\n    if (targets && targets.length) {\n\n      copy = targets.slice();\n\n      forEach(targets, function(target) {\n\n        var canRemove = !canRemoveFilter || canRemoveFilter(target);\n\n        if (canRemove) {\n\n          if (target.sourceRef === source) {\n            modeling.updateProperties(target, { sourceRef: undefined });\n          }\n\n          var idx = copy.indexOf(target);\n          if (idx !== -1) {\n            copy.splice(idx, 1);\n          }\n\n        }\n\n      });\n\n      if (targets.length !== copy.length) {\n        modeling.updateProperties(source, { targetRefs: copy });\n      }\n\n    }\n\n  }\n\n\n  function moveChildren(caseFileItem, newParent, canMoveFilter) {\n    caseFileItem = getBusinessObject(caseFileItem);\n\n    var childrenElement = caseFileItem.children,\n        children = childrenElement && childrenElement.get(containment);\n\n    if (children && children.length) {\n\n      forEach(children, function(child) {\n\n        var canMove = !canMoveFilter || canMoveFilter(child);\n\n        if (canMove) {\n          modeling.updateSemanticParent(child, newParent, containment);\n        }\n\n      });\n\n      clearCaseFileItemContainer(childrenElement);\n\n    }\n\n  }\n\n\n  function isExlusiveRef(element) {\n    var definition = getDefinition(element);\n    return definition && itemRegistry.getReferences(definition).length === 1;\n  }\n\n}\n\nCaseFileItemUpdater.$inject = [\n  'eventBus',\n  'itemRegistry',\n  'cmmnFactory',\n  'modeling'\n];\n\ninherits(CaseFileItemUpdater, CommandInterceptor);\n\nmodule.exports = CaseFileItemUpdater;\n\n\nfunction getDefinitions(element) {\n  return getParent(element, 'cmmn:Definitions');\n}\n\n\nfunction isCaseFileItem(element) {\n  return is(element, 'cmmn:CaseFileItem');\n}\n\n\nfunction isCaseFileModel(element) {\n  return is(element, 'cmmn:CaseFile');\n}\n\n\nfunction toMap(elements) {\n  return reduce(elements, function(result, value) {\n    result[value.id] = value;\n    return result;\n  }, {});\n}\n\n\nfunction getParentCaseFile(element) {\n  return getParent(getBusinessObject(element), 'cmmn:CaseFile');\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/CaseFileItemUpdater.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/LabelBehavior.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0),\n    inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar LabelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/LabelUtil.js\"),\n    ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    DiUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/DiUtil.js\"),\n    ModelingUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\");\n\nvar getBusinessObject = ModelUtil.getBusinessObject,\n    getName = ModelUtil.getName;\n\nvar hasExternalLabel = LabelUtil.hasExternalLabel,\n    getExternalLabelMid = LabelUtil.getExternalLabelMid;\n\nvar isStandardEventVisible = DiUtil.isStandardEventVisible;\n\nvar isAny = ModelingUtil.isAny;\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\n\n/**\n * A component that makes sure that external labels are added\n * together with respective elements and properly updated (DI wise)\n * during move.\n *\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n * @param {cmmnFactory} cmmnFactory\n */\nfunction LabelBehavior(eventBus, modeling, cmmnFactory) {\n\n  CommandInterceptor.call(this, eventBus);\n\n  // create external labels on shape creation\n\n  this.postExecuted([ 'shape.create', 'connection.create' ], 200, function(e) {\n    var context = e.context;\n\n    var element = context.shape || context.connection,\n        businessObject = element.businessObject;\n\n    var position;\n\n    if (hasExternalLabel(businessObject)) {\n      position = getExternalLabelMid(element);\n\n      modeling.createLabel(element, position, {\n        id: businessObject.id + '_label',\n        hidden: !getName(element) && !isStandardEventVisible(businessObject),\n        businessObject: businessObject\n      });\n    }\n  });\n\n\n  // update label position on waypoints change if still hidden\n  this.postExecute([ 'connection.updateWaypoints' ], function(e) {\n    var context = e.context,\n        connection = context.connection,\n        label = connection.label;\n\n    if (!label) {\n      return;\n    }\n\n    if (label.hidden) {\n      var position = getExternalLabelMid(connection);\n\n      var delta = {\n        x: position.x - label.x - label.width / 2,\n        y: position.y - label.y - label.height / 2\n      };\n\n      modeling.moveShape(label, delta);\n    }\n  });\n\n\n  this.postExecute([ 'shape.replace' ], function(e) {\n    var context = e.context,\n        newShape = context.newShape,\n        oldShape = context.oldShape;\n\n    var businessObject = getBusinessObject(newShape);\n\n    if (businessObject && hasExternalLabel(businessObject)) {\n      newShape.label.x = oldShape.label.x;\n      newShape.label.y = oldShape.label.y;\n    }\n  });\n\n\n  // update di information on label creation\n  this.executed([ 'label.create' ], function(e) {\n\n    var element = e.context.shape,\n        businessObject,\n        di;\n\n    // we want to trigger on real labels only\n    if (!element.labelTarget) {\n      return;\n    }\n\n    // we want to trigger on CMMN elements only\n    if (!isAny(element.labelTarget || element, [ 'cmmn:CMMNElement', 'cmmndi:CMMNDiagramElement' ])) {\n      return;\n    }\n\n    businessObject = element.businessObject,\n    di = businessObject.di || businessObject;\n\n\n    if (!di.label) {\n      di.label = cmmnFactory.createDiLabel();\n    }\n\n    if (!di.label.bounds) {\n      di.label.bounds = cmmnFactory.createDiBounds();\n    }\n\n    assign(di.label.bounds, {\n      x: element.x,\n      y: element.y,\n      width: element.width,\n      height: element.height\n    });\n  });\n\n}\n\ninherits(LabelBehavior, CommandInterceptor);\n\nLabelBehavior.$inject = [ 'eventBus', 'modeling', 'cmmnFactory' ];\n\nmodule.exports = LabelBehavior;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/LabelBehavior.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/PlanItemDefinitionUpdater.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed),\n    unionBy = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .unionBy */ .qZ),\n    filter = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .filter */ .hX);\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    getDefinition = ModelUtil.getDefinition,\n    getBusinessObject = ModelUtil.getBusinessObject;\n\nvar ModelingUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\"),\n    getParents = ModelingUtil.getParents,\n    getParent = ModelingUtil.getParent,\n    getCase = ModelingUtil.getCase,\n    isLabel = ModelingUtil.isLabel;\n\nvar PlanItemDefinitionUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js\"),\n    getAllDiscretionaryItems = PlanItemDefinitionUtil.getAllDiscretionaryItems,\n    getDirectItemCapables = PlanItemDefinitionUtil.getDirectItemCapables,\n    isItemCapable = PlanItemDefinitionUtil.isItemCapable,\n    isHumanTask = PlanItemDefinitionUtil.isHumanTask;\n\nvar LOW_PRIORITY = 400;\n\n/**\n * A handler responsible for updating the parent relation of a plan item definition\n * to the underlying CMMN 1.1 XML once changes on the diagram happen.\n */\nfunction PlanItemDefinitionUpdater(\n    eventBus,\n    modeling,\n    cmmnReplace,\n    itemRegistry\n) {\n\n  this._modeling = modeling;\n  this._cmmnReplace = cmmnReplace;\n  this._itemRegistry = itemRegistry;\n\n  var self = this;\n\n  CommandInterceptor.call(this, eventBus);\n\n  var containment = 'planItemDefinitions';\n\n\n  // CREATION //////////////////////////////////////////////////////////\n\n  this.postExecuted('shape.create', function(context) {\n\n    var shape = context.shape;\n\n    if (!isItemCapable(shape)) {\n      return;\n    }\n\n    var item = getBusinessObject(shape),\n        definition = getDefinition(item),\n        parent = getParentStage(item);\n\n    if (!getParent(definition)) {\n      modeling.updateSemanticParent(definition, parent, containment);\n    }\n\n  }, true);\n\n\n  this.postExecuted('shape.replace', function(context) {\n\n    var newShape = context.newShape;\n\n    if (!isItemCapable(newShape)) {\n      return;\n    }\n\n    self.updatePlanItemDefinitions([ newShape ]);\n\n  }, true);\n\n\n  // DELETION //////////////////////////////////////////////////////////\n\n  this.postExecuted('shape.delete', function(context) {\n\n    var shape = context.shape,\n        definition,\n        update = {};\n\n    if (!isItemCapable(shape) || isLabel(shape)) {\n      return;\n    }\n\n    definition = getDefinition(shape);\n    update[definition.id] = definition;\n    self.deletePlanItemDefinitions(update);\n\n  }, true);\n\n\n  this.preExecuted('shape.delete', function(context) {\n\n    var shape = context.shape,\n        definition = getDefinition(shape);\n\n    if (!isHumanTask(definition) || definition.$parent) {\n      return;\n    }\n\n    // get remaining discretionary items\n    context.discretionaryItems = context.discretionaryItems || getAllDiscretionaryItems(definition);\n\n  }, true);\n\n\n  this.postExecuted('shape.delete', LOW_PRIORITY, function(context) {\n\n    var discretionaryItems = context.discretionaryItems,\n        shapes = [];\n\n    forEach(discretionaryItems, function(item) {\n      var shapeItem = itemRegistry.getShape(item.id);\n\n      if (shapeItem) {\n        shapes.push(shapeItem);\n      }\n\n    });\n\n    if (shapes && shapes.length) {\n      self.updatePlanItemDefinitions(shapes);\n    }\n\n  }, true);\n\n\n  // MOVING //////////////////////////////////////////////////////////////\n\n  this.preExecuted('elements.move', function(context) {\n\n    var allShapes = context.closure.allShapes,\n        newParent = context.newParent,\n        hints = context.hints,\n        oldParent = hints && hints.primaryShape && hints.primaryShape.parent,\n        replacements = {},\n        shapes, // array of moved item capables\n        movedItemCapables = {}, // grouped by definition\n        newTargetCase;\n\n    if (!newParent || oldParent === newParent) {\n      return;\n    }\n\n    newTargetCase = getCase(newParent);\n\n    shapes = filter(allShapes, function(shape) {\n\n      if (isItemCapable(shape) && !isLabel(shape) && getCase(shape) !== newTargetCase) {\n\n        var definition = getDefinition(shape);\n        movedItemCapables[definition.id] = movedItemCapables[definition.id] || [];\n        movedItemCapables[definition.id].push(shape);\n\n        return true;\n      }\n\n      return false;\n    });\n\n\n    forEach(shapes, function(shape) {\n\n      var definition = getDefinition(shape),\n          referencedBy,\n          movedShapes,\n          newDefinition;\n\n      if (replacements[definition.id]) {\n        newDefinition = replacements[definition.id];\n      }\n\n      else {\n\n        referencedBy = itemRegistry.getReferences(definition.id);\n        movedShapes = movedItemCapables[definition.id];\n\n        if (referencedBy.length > movedShapes.length) {\n          newDefinition = replacements[definition.id] = cmmnReplace.replacePlanItemDefinition(definition);\n        }\n\n      }\n\n      if (newDefinition && newDefinition !== definition) {\n        modeling.updateProperties(shape, {\n          definitionRef: newDefinition\n        });\n      }\n\n    });\n\n    // remember replacement of definitions\n    context.definitionReplacements = replacements;\n\n  }, true);\n\n\n  this.postExecuted('elements.move', LOW_PRIORITY, function(context) {\n\n    var shapes = context.shapes,\n        newParent = context.newParent,\n        oldParent = (context.hints && context.hints.oldParent);\n\n    if (!newParent || oldParent === newParent) {\n      return;\n    }\n\n    shapes = filter(shapes, function(shape) {\n      return isItemCapable(shape) && !isLabel(shape);\n    });\n\n    if (shapes && shapes.length) {\n      self.updatePlanItemDefinitions(shapes);\n    }\n\n  }, true);\n\n\n  // CONNECTIONS //////////////////////////////////////////////////////////////\n\n  this.postExecuted([\n    'connection.create',\n    'connection.delete',\n    'connection.reconnectEnd',\n    'connection.reconnectStart'\n  ], LOW_PRIORITY, function(context) {\n\n    var connection = context.connection,\n        source = context.newSource || context.source || connection.source,\n        target = context.newTarget || context.target || connection.target,\n        shapes = [];\n\n    if (!isDiscretionaryConnection(connection, source, target)) {\n      return;\n    }\n\n    if (connection.target) {\n      shapes.push(connection.target);\n    }\n\n    if (!connection.target && context.target) {\n      shapes.push(context.target);\n    }\n\n    if (context.oldTarget) {\n      shapes.push(context.oldTarget);\n    }\n\n    if (shapes && shapes.length) {\n      self.updatePlanItemDefinitions(shapes);\n    }\n\n  }, true);\n\n\n  // API ////////////////////////////////////////////////////////\n\n  /**\n   * Deletes the given plan item definitions.\n   *\n   * A plan item definition is deleted when it is not\n   * referenced by a plan item or a discretionary item.\n   *\n   * @param {Array<ModdleElement>} definitions to delete\n   */\n  this.deletePlanItemDefinitions = function(definitions) {\n    var references;\n\n    forEach(definitions, function(definition) {\n      references = itemRegistry.getReferences(definition);\n      if (!references.length) {\n        modeling.updateSemanticParent(definition, null, containment);\n      }\n    });\n  };\n\n\n\n  /**\n   * Rearrange the plan item definitions of the given shapes.\n   *\n   * @param {Array<djs.model.Base>} shapes\n   */\n  this.updatePlanItemDefinitions = function(shapes) {\n\n    handleEachItemCapable(shapes, function(shape) {\n\n      var item = getBusinessObject(shape),\n          definition = getDefinition(item),\n          references = itemRegistry.getReferences(definition),\n          sharedParent = getSharedParent(references);\n\n      if (!sharedParent) {\n        sharedParent = getCasePlanModel(item);\n      }\n\n      if (sharedParent && sharedParent !== definition.$parent) {\n        modeling.updateSemanticParent(definition, sharedParent, containment);\n      }\n\n      var itemCapables = getDirectItemCapables(definition),\n          children = [];\n\n      if (is(definition, 'cmmn:PlanFragment') && shape.children && shape.children.length) {\n        forEach(shape.children, function(child) {\n          var bo = getBusinessObject(child);\n          if (isItemCapable(bo) && !isLabel(bo) && itemCapables.indexOf(bo) === -1) {\n            children.push(bo);\n          }\n        });\n\n      }\n\n      return unionBy('id', itemCapables, children);\n\n    });\n\n  };\n\n\n  // UTILITIES ///////////////////////////////////////////////////////////////\n\n\n  function handleEachItemCapable(elements, fn) {\n\n    var handledElements = {};\n\n    function handled(element) {\n      handledElements[element.id] = element;\n    }\n\n    function isHandled(element) {\n      return !!handledElements[element.id];\n    }\n\n    function eachElement(elements, isRoot) {\n      forEach(elements, function(element) {\n\n        if (!isHandled(element)) {\n          handled(element);\n\n          element = itemRegistry.getShape(element.id) || element;\n          var children = fn(element);\n\n          if (children && children.length) {\n            eachElement(children);\n          }\n        }\n\n        if (isRoot) {\n          handledElements = {};\n        }\n\n      });\n    }\n\n    eachElement(elements, true);\n  }\n\n}\n\nPlanItemDefinitionUpdater.$inject = [\n  'eventBus',\n  'modeling',\n  'cmmnReplace',\n  'itemRegistry'\n];\n\ninherits(PlanItemDefinitionUpdater, CommandInterceptor);\n\nmodule.exports = PlanItemDefinitionUpdater;\n\n\n/**\n * Utilities\n */\n\nfunction getSharedParent(elements) {\n\n  var sharedParent,\n      first;\n\n  if (elements.length) {\n\n    first = elements.splice(0, 1)[0];\n\n    if (!elements.length) {\n      sharedParent = getParentStage(first);\n    }\n    else {\n      var candidates = getParentStages(first);\n      forEach(elements, function(e) {\n        candidates = intersection(candidates, getParentStages(e));\n      });\n\n      sharedParent = candidates[0];\n    }\n\n  }\n\n  return sharedParent;\n\n}\n\n\nfunction getParentStage(element) {\n  element = getBusinessObject(element);\n  return getParent(element, 'cmmn:Stage');\n}\n\n\nfunction getParentStages(element) {\n  element = getBusinessObject(element);\n  return getParents(element, 'cmmn:Stage');\n}\n\n\nfunction getCasePlanModel(element) {\n  var _case = getParent(element, 'cmmn:Case');\n  return _case && _case.casePlanModel;\n}\n\n\nfunction isDiscretionaryConnection(connection, source, target) {\n  return !connection.businessObject.cmmnElementRef;\n}\n\n\n// helpers /////////////////\n\nfunction intersection(a, b) {\n\n  return filter(a, function(e) {\n    return b.indexOf(e) !== -1;\n  });\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/PlanItemDefinitionUpdater.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/PlanningTableUpdater.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\nvar some = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .some */ .G),\n    forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    isCasePlanModel = ModelUtil.isCasePlanModel,\n    getDefinition = ModelUtil.getDefinition,\n    getBusinessObject = ModelUtil.getBusinessObject;\n\nvar getParent = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").getParent),\n    isLabel = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isLabel),\n    getParents = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").getParents);\n\nvar PlanItemDefinitionUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js\"),\n    isDiscretionaryToHumanTask = PlanItemDefinitionUtil.isDiscretionaryToHumanTask,\n    isDiscretionaryItem = PlanItemDefinitionUtil.isDiscretionaryItem,\n    isPlanFragment = PlanItemDefinitionUtil.isPlanFragment,\n    getAllDiscretionaryItems = PlanItemDefinitionUtil.getAllDiscretionaryItems,\n    isHumanTask = PlanItemDefinitionUtil.isHumanTask;\n\n\n/**\n * A handler responsible for adding, moving and deleting discretionary items\n * and adding them to planning table. These changes are reflected to\n * the underlying CMMN 1.1 XML.\n */\nfunction PlanningTableUpdater(eventBus, cmmnFactory, modeling, itemRegistry) {\n\n  this._cmmnFactory = cmmnFactory;\n  this._modeling = modeling;\n  this._itemRegistry = itemRegistry;\n\n  var self = this;\n\n  CommandInterceptor.call(this, eventBus);\n\n  var containment = 'tableItems';\n\n  // CONNECTION /////////////////////////////////////////////\n\n\n  // delete + reconnectEnd //////////////////////////////////\n\n\n  this.preExecuted([ 'connection.delete', 'connection.reconnectEnd', 'connection.reconnectStart' ], function(event) {\n\n    var context = event.context,\n        isReconnectStart = (event.command === 'connection.reconnectStart'),\n        connection = context.connection,\n        target = connection.target;\n\n    if (!isDiscretionaryConnection(connection)) {\n      return;\n    }\n\n    if (isReconnectStart) {\n\n      if (context.newSource && context.newTarget) {\n        target = context.newSource;\n        context.oldPlanningTable = getParentPlanningTable(target);\n      }\n      else {\n        return;\n      }\n\n    }\n\n    // (1) remember current\n    context.planningTable = getParentPlanningTable(target);\n\n    // (2) if the target did not change, then do nothing (in case of reconnectEnd)\n    if (target === context.newTarget) {\n      return;\n    }\n\n    // (3) is there at least another discretionary connection referencing\n    // this target.\n    // note: there could be multiple plan items (with the same definition -\n    // human task) referencing the same discretionary item. in such case\n    // the deletion/reconnection of a discretionary connection does not trigger\n    // the deletion of the other discretionary connections. As a result, the\n    // the discretionary item remains in its current planning table.\n    if (isReferencedByAnotherDiscretionaryConnection(target, connection)) {\n      return;\n    }\n\n    // (4) get new target definition of discretionary item\n    var definition = getTargetDefinition(target.parent);\n\n    // (5) create a planning table if necessary\n    var planningTable = self.createPlanningTable(definition);\n\n    // (6) move (current target) discretionary item from current planning table\n    // to the new planning table\n    modeling.updateSemanticParent(target, planningTable, containment);\n\n  });\n\n\n  this.postExecuted('connection.delete', function(context) {\n\n    if (!isDiscretionaryConnection(context.connection)) {\n      return;\n    }\n\n    // triggers deletion of planning table if it is empty\n    self.deletePlanningTable(context.planningTable);\n\n  }, true);\n\n\n  this.postExecuted('connection.reconnectEnd', function(context) {\n\n    var connection = context.connection,\n        target = connection.target;\n\n    if (!isDiscretionaryConnection(connection)) {\n      return;\n    }\n\n    // (1) remember old planning table of new target\n    var oldPlanningTable = getParentPlanningTable(target);\n\n    // (2) add new target as discretionary item into the planning table of the source element\n    modeling.updateSemanticParent(target, context.planningTable, containment);\n\n    // (3) remove old planning table if its empty\n    self.deletePlanningTable(oldPlanningTable);\n\n  }, true);\n\n\n  this.postExecuted('connection.reconnectStart', function(context) {\n\n    var connection = context.connection;\n\n    if (!isDiscretionaryConnection(connection)) {\n      return;\n    }\n\n    if (!context.newSource || !context.newTarget) {\n      return;\n    }\n\n    self.deletePlanningTable(context.oldPlanningTable);\n\n  }, true);\n\n  // create + reconnectStart ////////////////////////////////////////\n\n  this.preExecuted([ 'connection.create', 'connection.reconnectStart' ], function(context) {\n\n    var connection = context.connection,\n        source = context.newSource || context.source,\n        target = context.target || context.newTarget || connection.target;\n\n    if (!isDiscretionaryConnection(connection)) {\n      return;\n    }\n\n    // (1) remember planning table of target discretionary item\n    context.planningTable = getParentPlanningTable(target);\n\n    var definition = getDefinition(source);\n\n    if (connection.source) {\n      var oldDefinition = getDefinition(connection.source);\n      if (oldDefinition === definition) {\n        return;\n      }\n    }\n\n    // (2) create a planning table if necessary\n    var planningTable = self.createPlanningTable(definition);\n\n    // (3) add target discretionary item to planning table\n    modeling.updateSemanticParent(target, planningTable, containment);\n\n  }, true);\n\n\n  this.postExecuted([ 'connection.create', 'connection.reconnectStart' ], function(context) {\n\n    var connection = context.connection;\n    if (!isDiscretionaryConnection(connection)) {\n      return;\n    }\n\n    // remove planning table if its empty\n    self.deletePlanningTable(context.planningTable);\n\n  }, true);\n\n\n  // SHAPE /////////////////////////////////////////////////////////////////////////////\n\n  this.preExecuted('elements.move', 500, function(context) {\n\n    var allShapes = context.closure.allShapes,\n        newParent = context.newParent,\n        hints = context.hints,\n        oldParent = hints && hints.primaryShape && hints.primaryShape.parent,\n        replacements = context.definitionReplacements,\n        replacedPlanningTableArray = [],\n        planningTableReplacedBy = {};\n\n\n    function clonePlanningTable(planningTable) {\n      var newPlanningTable = cmmnFactory.create('cmmn:PlanningTable', {\n        applicabilityRules: planningTable.applicabilityRules\n      });\n      var idx = replacedPlanningTableArray.push(planningTable);\n      planningTableReplacedBy[idx-1] = newPlanningTable;\n\n      return newPlanningTable;\n    }\n\n\n    if (!newParent || oldParent === newParent) {\n      return;\n    }\n\n\n    forEach(allShapes, function(shape) {\n\n      var bo = getBusinessObject(shape),\n          newPlanningTables = [],\n          discretionaryTo,\n          replacedBy,\n          items,\n          planningTables,\n          previousPlanningTable;\n\n\n      if (!isDiscretionaryItem(shape) || isLabel(shape)) {\n        return;\n      }\n\n      discretionaryTo = getParent(bo, 'cmmn:PlanItemDefinition');\n      if (!is(discretionaryTo, 'cmmn:HumanTask')) {\n        return;\n      }\n\n      replacedBy = replacements[discretionaryTo.id];\n      if (!replacedBy) {\n        return;\n      }\n\n      // discretionary item is already contained by replacement\n      if ((getAllDiscretionaryItems(replacedBy) || []).indexOf(bo) !== -1) {\n        return;\n      }\n\n      // have been all contained discretionary items moved?\n      items = getAllDiscretionaryItems(discretionaryTo);\n      var allMoved = !some(items, function(item) {\n        return !allShapes[item.id];\n      });\n\n\n      if (allMoved) {\n\n        // if yes, then just move planning table to replacement\n\n        var planningTable = discretionaryTo.planningTable;\n\n        modeling.updateProperties(replacedBy, {\n          planningTable: planningTable\n        }, itemRegistry.getShapes(replacedBy));\n\n        modeling.updateSemanticParent(planningTable, replacedBy);\n\n        modeling.updateProperties(discretionaryTo, {\n          planningTable: undefined\n        }, itemRegistry.getShapes(discretionaryTo));\n\n        return;\n      }\n\n\n      planningTables = getParents(bo, 'cmmn:PlanningTable');\n\n      if (planningTables && planningTables.length) {\n\n        forEach(planningTables, function(planningTable) {\n\n          var idx = replacedPlanningTableArray.indexOf(planningTable),\n              newPlanningTable;\n\n          if (idx === -1) {\n            newPlanningTable = clonePlanningTable(planningTable);\n          }\n          else {\n            newPlanningTable = planningTableReplacedBy[idx];\n          }\n\n          if (previousPlanningTable && !previousPlanningTable.$parent) {\n            modeling.updateSemanticParent(previousPlanningTable, newPlanningTable, 'tableItems');\n          }\n\n          previousPlanningTable = newPlanningTable;\n          newPlanningTables.push(newPlanningTable);\n\n        });\n\n        if (!replacedBy.planningTable) {\n\n          modeling.updateProperties(replacedBy, {\n            planningTable: previousPlanningTable\n          }, itemRegistry.getShapes(replacedBy));\n          modeling.updateSemanticParent(previousPlanningTable, replacedBy);\n\n        }\n\n        var first = newPlanningTables.splice(0, 1)[0],\n            oldPlanningTable = getParentPlanningTable(bo);\n\n        modeling.updateSemanticParent(bo, first, 'tableItems');\n\n        self.deletePlanningTable(oldPlanningTable);\n      }\n\n    });\n\n  }, true);\n\n\n  this.preExecuted([ 'shape.create', 'shape.move' ], function(context) {\n\n    var shape = context.shape;\n\n    if (!isDiscretionaryItem(shape) || isLabel(shape)) {\n      return;\n    }\n\n    // (1) if is discretionary to human task, then there is nothing to do\n    // in case of 'shape.move'\n    if (isDiscretionaryToHumanTask(shape)) {\n      return;\n    }\n\n    // remember old planning table\n    context.planningTable = getParentPlanningTable(shape);\n\n    var newParent = context.parent || context.newParent;\n\n    if (newParent) {\n\n      // (2) parent changed\n\n      var definition = getTargetDefinition(newParent);\n\n      // (3) create new planning table if necessary\n      var planningTable = self.createPlanningTable(definition);\n\n      // (4) add discretionary item to planning table\n      modeling.updateSemanticParent(shape, planningTable, containment);\n    }\n\n  }, true);\n\n\n  this.postExecuted('shape.move', function(context) {\n\n    var shape = context.shape;\n\n    if (!isDiscretionaryItem(shape) || isLabel(shape)) {\n      return;\n    }\n\n    // if an item which is discretionary to a human task is moved,\n    // then no update is necessary\n    if (isDiscretionaryToHumanTask(shape)) {\n      return;\n    }\n\n    self.deletePlanningTable(context.planningTable);\n\n  }, true);\n\n\n  this.preExecuted('shape.delete', function(context) {\n\n    var shape = context.shape;\n\n    if (!isDiscretionaryItem(shape) || isLabel(shape)) {\n      return;\n    }\n\n    // remember old planning table\n    context.planningTable = getParentPlanningTable(shape);\n\n    // remove discretionary item from planning table\n    modeling.updateSemanticParent(shape, null, containment);\n\n  }, true);\n\n\n  this.postExecuted('shape.delete', function(context) {\n\n    var shape = context.shape;\n\n    if (!isDiscretionaryItem(shape) || isLabel(shape)) {\n      return;\n    }\n\n    self.deletePlanningTable(context.planningTable);\n\n  }, true);\n\n\n  this.postExecuted('shape.delete', 500, function(context) {\n\n    var shape = context.shape;\n\n    var definition = getDefinition(shape);\n\n    if (!isHumanTask(definition) || definition.$parent) {\n      return;\n    }\n\n    var discretionaryItems = getAllDiscretionaryItems(definition);\n\n    // repair the model\n    forEach(discretionaryItems, function(item) {\n      var shapeItem = itemRegistry.getShape(item.id);\n\n      if (shapeItem) {\n        // get new target definition of discretionary item\n        var definition = getTargetDefinition(shapeItem.parent);\n\n        // create a planning table if necessary\n        var planningTable = self.createPlanningTable(definition);\n\n        // move (current target) discretionary item from current planning table\n        // to the new planning table\n        modeling.updateSemanticParent(shapeItem, planningTable, containment);\n      }\n\n    });\n\n    if (definition.planningTable) {\n      self.deletePlanningTable(definition.planningTable);\n    }\n\n  }, true);\n\n  // API ////////////////////////////////////////////////////////\n\n  /**\n   * Creates a new planning table for the given definition, if necessary.\n   *\n   * If the given definition already contains a planning table, this\n   * planning table is returned.\n   *\n   * @param {ModdleElement} definition where the planning table is added\n   *\n   * @return {ModdleElement} the create planning table\n   */\n  this.createPlanningTable = function(definition) {\n\n    var planningTable = definition.planningTable;\n\n    if (!planningTable) {\n\n      // (1) create new planning table\n      planningTable = self._cmmnFactory.create('cmmn:PlanningTable');\n\n      // (2) filter all items which are affected by adding a planning\n      // table to its definition\n      var shapes = itemRegistry.getShapes(definition);\n\n      // (3) set planning table\n      modeling.updateProperties(definition, {\n        planningTable: planningTable\n      }, shapes);\n\n      // (4) set parent of planning table to definition\n      modeling.updateSemanticParent(planningTable, definition);\n    }\n\n\n    return planningTable;\n  };\n\n\n  /**\n   * Deletes a given planning table from the definition. If the planning\n   * table is nested inside other planning tables, then the plannings tables\n   * are also deleted, if they do not contain any element.\n   *\n   * @param {ModdleElement} planningTable to delete\n   *\n   */\n  this.deletePlanningTable = function(planningTable) {\n\n    // According to spec: a planning table must contain at least one element.\n    // if it does not contain any element, then the planning table is deleted.\n\n    // (1) cannot delete planning table if contains at least one element\n    if (planningTable.get(containment).length > 0) {\n      return;\n    }\n\n    // (2) if planning table does not contain any element, then remove it\n    var oldParent = planningTable.$parent;\n    while (is(oldParent, 'cmmn:PlanningTable') && !planningTable.get(containment).length) {\n      modeling.updateSemanticParent(planningTable, null, containment);\n      planningTable = oldParent;\n      oldParent = oldParent.$parent;\n    }\n\n    if (is(oldParent, 'cmmn:PlanItemDefinition')) {\n\n      if (planningTable && !planningTable.get(containment).length) {\n\n        // (3) get definition containing this planning table\n        var definition = getParent(planningTable, 'cmmn:PlanItemDefinition');\n\n        // (4) filter all items which are affected by removing this planning\n        // table from its definition\n        var shapes = itemRegistry.getShapes(definition);\n\n        // (5) set planning table attribute to undefined\n        modeling.updateProperties(definition, {\n          planningTable: undefined\n        }, shapes);\n\n        // (6) set planning tables parent to null\n        modeling.updateSemanticParent(planningTable, null, null);\n      }\n    }\n  };\n\n\n  /**\n   * Returns true, if there is another incoming discretionary connection\n   * apart the given connection.\n   *\n   * @param {djs.mode.Base} shape\n   * @param {djs.mode.Base} connection\n   *\n   * @return {boolean} if there is another incoming discretionary connection\n   */\n  function isReferencedByAnotherDiscretionaryConnection(shape, connection) {\n    return some(shape.incoming, function(con) {\n      return con !== connection && isDiscretionaryConnection(con);\n    });\n  }\n\n\n  function isDiscretionaryConnection(connection) {\n    return !connection.businessObject.cmmnElementRef;\n  }\n\n}\n\nPlanningTableUpdater.$inject = [\n  'eventBus',\n  'cmmnFactory',\n  'modeling',\n  'itemRegistry'\n];\n\ninherits(PlanningTableUpdater, CommandInterceptor);\n\nmodule.exports = PlanningTableUpdater;\n\n\nfunction getTargetDefinition(shape) {\n  var target = fixTarget(shape);\n  return getDefinition(target) || getBusinessObject(target);\n}\n\n/**\n * Fixes the target.\n * A discretionary item cannot be added to plan fragment,\n * in that case the discretionary item is added to the visual\n * surrounding stage.\n *\n * @param {djs.model.Base} target\n *\n * @return {djs.model.Base} the fixed target\n */\nfunction fixTarget(target) {\n  if (target && !isCasePlanModel(target)) {\n\n    var definition = getDefinition(target);\n\n    if (isPlanFragment(definition)) {\n      target = getParent(target, [\n        'cmmn:Stage',\n        'cmmn:PlanItem',\n        'cmmn:DiscretionaryItem'\n      ]);\n      target = fixTarget(target);\n    }\n  }\n\n  return target;\n}\n\n\n/**\n * Returns parent planning table of the given element.\n *\n * @param {ModdleElement} element\n *\n * @param {ModdleElement} the parent planning table\n */\nfunction getParentPlanningTable(element) {\n  element = getBusinessObject(element);\n  return getParent(element, 'cmmn:PlanningTable');\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/PlanningTableUpdater.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/ReplaceConnectionBehavior.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed),\n    inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\"),\n    assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0);\n\nvar isArray = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .isArray */ .kJ);\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is);\n\nvar LOW_PRIORITY = 200,\n    HIGH_PRIORITY = 5000;\n\nfunction ReplaceConnectionBehavior(eventBus, modeling, cmmnRules, selection, rules) {\n\n  CommandInterceptor.call(this, eventBus);\n\n\n  function canConnectPlanItemOnPartConnection(source, target) {\n    return cmmnRules.canConnectPlanItemOnPartConnection(source, target);\n  }\n\n\n  function canConnectCaseFileItemOnPartConnection(source, target) {\n    return cmmnRules.canConnectCaseFileItemOnPartConnection(source, target);\n  }\n\n\n  function canConnectDiscretionaryConnection(source, target, connection) {\n    return cmmnRules.canConnectDiscretionaryConnection(source, target, connection);\n  }\n\n\n  function canConnectAssociation(source, target) {\n    return cmmnRules.canConnectAssociation(source, target);\n  }\n\n\n  function canReconnect(type, attrs) {\n    return rules.allowed(type, attrs);\n  }\n\n  function fixConnection(connection, source, target, hints) {\n\n    var parent = connection.parent;\n\n    hints = hints || {};\n    source = source || connection.source;\n    target = target || connection.target;\n\n    if (!parent) {\n      return;\n    }\n\n    var remove,\n        replacement,\n        cmmnElement = getCmmnElement(connection);\n\n    /**\n     * Check if incoming or outgoing connections can stay and/or replaced.\n     */\n\n    if (cmmnElement) {\n\n      if (is(cmmnElement, 'cmmn:PlanItemOnPart')) {\n\n        if (!canConnectPlanItemOnPartConnection(source, target)) {\n          remove = true;\n        }\n\n        if (canConnectCaseFileItemOnPartConnection(source, target)) {\n          replacement = {\n            type: 'cmmn:CaseFileItemOnPart',\n            name: cmmnElement.name,\n            isStandardEventVisible: isStandardEventVisible(connection)\n          };\n        }\n\n        if (canConnectDiscretionaryConnection(source, target, connection)) {\n          replacement = {\n            type: 'cmmndi:CMMNEdge'\n          };\n        }\n\n      }\n\n\n      if (is(cmmnElement, 'cmmn:CaseFileItemOnPart')) {\n\n        if (!canConnectCaseFileItemOnPartConnection(source, target)) {\n          remove = true;\n        }\n\n        if (canConnectPlanItemOnPartConnection(source, target)) {\n          replacement = {\n            type: 'cmmn:PlanItemOnPart',\n            name: cmmnElement.name,\n            isStandardEventVisible: isStandardEventVisible(connection)\n          };\n        }\n\n      }\n\n      if (is(cmmnElement, 'cmmn:Association') && !canConnectAssociation(source, target)) {\n        remove = true;\n      }\n\n    }\n    else {\n\n      if (!canConnectDiscretionaryConnection(source, target, connection)) {\n        remove = true;\n      }\n\n      if (canConnectPlanItemOnPartConnection(source, target)) {\n        replacement = {\n          type: 'cmmn:PlanItemOnPart',\n          isStandardEventVisible: true\n        };\n      }\n\n    }\n\n    if (remove) {\n\n      if (!replacement && (isTextAnnotation(source) || isTextAnnotation(target))) {\n\n        replacement = {\n          type: 'cmmn:Association'\n        };\n      }\n\n      modeling.removeConnection(connection);\n    }\n\n    if (replacement) {\n\n      var attrs = assign({\n        waypoints: connection.waypoints.slice()\n      }, replacement);\n\n      var newConnection = modeling.connect(source, target, attrs);\n\n      if (hints.select !== false) {\n        selection.select(newConnection);\n      }\n\n      return newConnection;\n\n    }\n\n  }\n\n\n  this.postExecuted('elements.move', LOW_PRIORITY, function(context) {\n\n    var closure = context.closure,\n        allConnections = closure.allConnections;\n\n    forEach(allConnections, function(connection) {\n      fixConnection(connection, null, null, {\n        select: false\n      });\n    });\n\n  }, true);\n\n\n  this.preExecute([\n    'connection.reconnectEnd',\n    'connection.reconnectStart'\n  ], HIGH_PRIORITY + LOW_PRIORITY, function(event) {\n\n    var type = event.command,\n        isReconnectStart = (type === 'connection.reconnectStart'),\n        context = event.context,\n        connection = context.connection,\n        source = context.newSource || connection.source,\n        target = context.newTarget || connection.target,\n        dockingOrPoints = context.dockingOrPoints,\n        canExecute = context.canExecute;\n\n    if (context.hints && context.hints.nested) {\n      return;\n    }\n\n    if (canExecute === undefined) {\n\n      var attrs = {\n        connection: connection\n      };\n\n      attrs[ isReconnectStart ? 'hover' : 'source' ] = source;\n      attrs[ !isReconnectStart ? 'hover' : 'target' ] = target;\n\n      canExecute = canReconnect(type, attrs);\n\n    }\n\n    if (canExecute && canExecute.reverse) {\n\n      if (!isArray(dockingOrPoints)) {\n        var waypoints = connection.waypoints.slice();\n        waypoints.splice(isReconnectStart ? 0 : -1, 1, dockingOrPoints);\n        dockingOrPoints = waypoints;\n      }\n\n      context.newSource = target;\n      context.newTarget = source;\n      context.dockingOrPoints = dockingOrPoints.reverse();\n\n    }\n\n  });\n\n\n  this.preExecute([\n    'connection.reconnectStart',\n    'connection.reconnectEnd'\n  ], HIGH_PRIORITY, function(context) {\n\n    var connection = context.connection,\n        source = context.newSource || connection.source,\n        target = context.newTarget || connection.target,\n        hints = context.hints || {};\n\n    context.connection = fixConnection(connection, source, target, {\n      select: !hints.nested\n    }) || connection;\n\n  }, true);\n\n\n  this.postExecuted('shape.replace', function(context) {\n\n    var shape = context.newShape,\n        bo = shape.businessObject,\n        connections = getAttachersOutgoingConnections(shape);\n\n    forEach(connections, function(connection) {\n\n      var source = connection.source,\n          target = connection.target,\n          cmmnElement = getCmmnElement(connection);\n\n      if (is(cmmnElement, 'cmmn:PlanItemOnPart')) {\n\n        if (canConnectPlanItemOnPartConnection(source, target)) {\n          modeling.updateProperties(cmmnElement, { sourceRef: bo }, connection);\n        }\n        else {\n          modeling.removeConnection(connection);\n        }\n\n      }\n\n    });\n\n  }, true);\n\n\n  this.postExecuted('element.updateProperties', function(context) {\n\n    var properties = context.properties,\n        changed = context.changed;\n\n    if (properties && properties.isBlocking === false) {\n\n      forEach(changed, function(shape) {\n\n        var connections = shape.outgoing;\n\n        forEach(connections, function(connection) {\n          fixConnection(connection, null, null, {\n            select: false\n          });\n        });\n\n      });\n\n    }\n\n  }, true);\n\n}\n\ninherits(ReplaceConnectionBehavior, CommandInterceptor);\n\nReplaceConnectionBehavior.$inject = [ 'eventBus', 'modeling', 'cmmnRules', 'selection', 'rules' ];\n\nmodule.exports = ReplaceConnectionBehavior;\n\n\nfunction isStandardEventVisible(connection) {\n  return connection.businessObject.isStandardEventVisible;\n}\n\nfunction getCmmnElement(connection) {\n  return connection.businessObject && connection.businessObject.cmmnElementRef;\n}\n\nfunction getAttachersOutgoingConnections(shape) {\n\n  var attachers = shape.attachers,\n      connections = [];\n\n  forEach(attachers, function(attacher) {\n    forEach(attacher.outgoing, function(connection) {\n      connections.push(connection);\n    });\n  });\n\n  return connections;\n}\n\nfunction isTextAnnotation(element) {\n  return is(element, 'cmmn:TextAnnotation');\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/ReplaceConnectionBehavior.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/ReplaceElementBehavior.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\nvar saveClear = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Removal.js\")/* .saveClear */ .r);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    getDefinition = ModelUtil.getDefinition,\n    getSentry = ModelUtil.getSentry;\n\nvar forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed),\n    filter = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .filter */ .hX),\n    assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0);\n\nvar HIGH_PRIORITY = 6000,\n    LOW_PRIORITY = 500,\n    VERY_LOW_PRIORITY = 100;\n\n\nfunction ReplaceElementBehavior(\n    cmmnReplace,\n    cmmnRules,\n    elementFactory,\n    elementRegistry,\n    eventBus,\n    modeling,\n    selection,\n    rules\n) {\n\n  CommandInterceptor.call(this, eventBus);\n\n  this._cmmnReplace = cmmnReplace;\n  this._cmmnRules = cmmnRules;\n  this._elementFactory = elementFactory;\n  this._elementRegistry = elementRegistry;\n  this._modeling = modeling;\n  this._selection = selection;\n  this._rules = rules;\n\n  var self = this;\n\n\n  function canConnect(source, target) {\n\n    return rules.allowed('connection.create', {\n      source: source,\n      target: target\n    });\n\n  }\n\n  function canReconnect(type, attrs) {\n    return rules.allowed(type, attrs);\n  }\n\n\n  // SHAPES //////////////////////////////////////////////////////////////////\n\n  this.preExecute([ 'shape.create', 'shape.append' ], HIGH_PRIORITY, function(context) {\n\n    var shape = context.shape,\n        source = context.source,\n        target = context.parent || context.target || (source && source.parent),\n        host = context.host,\n        position = context.position,\n        hints = context.hints || {};\n\n    if (hints.nested) {\n      return;\n    }\n\n    if (host && isCriterion(shape)) {\n      target = host;\n    }\n\n    if (!cmmnRules.canCreate(shape, target, source, position)) {\n\n      var canReplace = cmmnRules.canReplace([ shape ], target, position, source);\n\n      if (canReplace && canReplace.replacements) {\n\n        var replacement = canReplace.replacements[0],\n            definition = getDefinition(shape),\n            sentry = getSentry(shape),\n            elementType = replacement.newElementType,\n            definitionType = replacement.newDefinitionType || (definition && definition.$type);\n\n        var attrs = assign({}, {\n          type: elementType\n        });\n\n        if (definitionType) {\n          assign(attrs, {\n            definitionType: definitionType\n          });\n        }\n\n        if (sentry) {\n          assign(attrs, {\n            sentryRef: sentry\n          });\n        }\n\n        context.shape = elementFactory.createShape(attrs);\n\n      }\n\n    }\n\n  }, true);\n\n\n  this.postExecuted('elements.move', LOW_PRIORITY, function(context) {\n\n    var target = context.newParent,\n        newHost = context.newHost,\n        elements = context.shapes.slice();\n\n    if (elements.length === 1 && newHost) {\n      target = newHost;\n    }\n    else {\n      elements = filter(elements, function(elem) {\n        return !isCriterion(elem);\n      });\n    }\n\n    if (target && !cmmnRules.canMove(elements, target)) {\n\n      var canReplace = cmmnRules.canReplace(elements, target);\n\n      if (canReplace && canReplace.replacements) {\n        self.replaceElements(elements, canReplace.replacements);\n      }\n\n    }\n\n  }, true);\n\n\n  this.postExecuted([ 'shape.replace' ], 1500, function(e) {\n    var context = e.context,\n        oldShape = context.oldShape,\n        newShape = context.newShape;\n\n    modeling.unclaimId(oldShape.businessObject.id, oldShape.businessObject);\n    modeling.updateProperties(newShape, { id: oldShape.id });\n  });\n\n\n  // CONNECTIONS /////////////////////////////////////////////////////////////////////\n\n  this.preExecute('connection.create', HIGH_PRIORITY, function(context) {\n\n    var source = context.source,\n        target = context.target,\n        canReplace = context.canExecute || canConnect(source, target);\n\n    if (canReplace && canReplace.replacements) {\n\n      var replacements = self.replaceElements([ source, target ], canReplace.replacements, {\n        select: false\n      });\n\n      context.source = replacements[source.id] || context.source;\n      context.target = replacements[target.id] || context.target;\n\n      // remember replaced by element in canReplace object (see 'connect.end')\n      assign(canReplace, {\n        replacedBy: !canReplace.reverse ? context.target : context.source\n      });\n\n    }\n\n  }, true);\n\n\n  eventBus.on('connect.end', LOW_PRIORITY + VERY_LOW_PRIORITY, function(e) {\n\n    var canExecute = e.context.canExecute,\n        replacedBy = canExecute && canExecute.replacedBy;\n\n    // if target shape has been replaced, then select the\n    // new element and not the old target.\n    if (replacedBy) {\n      e.context.target = replacedBy;\n    }\n\n  });\n\n\n  this.preExecute([\n    'connection.reconnectStart',\n    'connection.reconnectEnd'\n  ], HIGH_PRIORITY, function(event) {\n\n    var type = event.command,\n        isReconnectStart = (type === 'connection.reconnectStart'),\n        context = event.context,\n        connection = context.connection,\n        source = context.newSource || connection.source,\n        target = context.newTarget || connection.target,\n        attrs = { connection: connection },\n        canReplace;\n\n    if (context.hints && context.hints.nested) {\n      return;\n    }\n\n    attrs[ isReconnectStart ? 'hover' : 'source' ] = source;\n    attrs[ !isReconnectStart ? 'hover' : 'target' ] = target;\n\n    canReplace = canReconnect(type, attrs);\n\n    if (canReplace && canReplace.replacements) {\n      var replacements = self.replaceElements([ source, target ], canReplace.replacements, {\n        select: false\n      });\n\n      context.newSource = replacements[source.id] || context.newSource;\n      context.newTarget = replacements[target.id] || context.newTarget;\n    }\n\n    // remember result in context, so that this can be re-used\n    context.canExecute = canReplace;\n\n  });\n\n\n  this.preExecute('shape.delete', HIGH_PRIORITY, function(context) {\n\n    var shape = context.shape,\n        parent = isCriterion(shape) ? shape.host : shape.parent,\n        definition = getDefinition(parent);\n\n    // if the shape to delete is contained by a plan fragment (and not stage)\n    // then remove incoming connections. Thereby an additional hint is provided\n    // to the context, so that shape delete is not replaced when the connection\n    // is deleted.\n\n    if (is(definition, 'cmmn:Stage')) {\n      return;\n    }\n\n    saveClear(shape.incoming, function(connection) {\n      modeling.removeConnection(connection, { nested: true, endChanged: true });\n    });\n\n  }, true);\n\n\n  this.postExecuted([\n    'connection.delete',\n    'connection.reconnectEnd'\n  ], LOW_PRIORITY, function(context) {\n\n    var shape = context.target || context.oldTarget,\n        elements = [ shape ],\n        target = isCriterion(shape) ? shape.host : shape.parent,\n        hints = context.hints || {};\n\n    if (hints.endChanged) {\n      return;\n    }\n\n    if (target && !cmmnRules.canMove(elements, target)) {\n\n      var canReplace = cmmnRules.canReplace(elements, target);\n\n      if (canReplace && canReplace.replacements) {\n        self.replaceElements(elements, canReplace.replacements, { select: false });\n      }\n\n    }\n\n  }, true);\n\n\n  // PROPERTIES /////////////////////////////////////////////////////////////////////\n\n  this.postExecuted('element.updateProperties', function(context) {\n\n    var properties = context.properties,\n        changed = context.changed;\n\n    if (properties && properties.isBlocking === false) {\n\n      forEach(changed, function(shape) {\n\n        var attachers = shape.attachers,\n            canReplace = cmmnRules.canReplace(attachers, shape);\n\n        if (canReplace) {\n          self.replaceElements(attachers, canReplace.replacements, { select: false });\n        }\n      });\n\n    }\n\n  }, true);\n\n\n  // API ///////////////////////////////////////////////////////////////////////////\n\n  this.replaceElements = function(elements, newElements, hints) {\n\n    var self = this;\n\n    var elementRegistry = this._elementRegistry,\n        selection = this._selection;\n\n    var executedReplacements = {};\n\n    hints = hints || {};\n\n    forEach(newElements, function(replacement) {\n\n      var oldElement = elementRegistry.get(replacement.oldElementId),\n          idx = elements.indexOf(oldElement),\n          replacedBy;\n\n      if (!oldElement) {\n        return;\n      }\n\n      replacedBy = self.replaceElement(oldElement, replacement);\n\n      if (idx !== -1) {\n        elements[idx] = replacedBy;\n      }\n\n      executedReplacements[oldElement.id] = replacedBy;\n\n    });\n\n    if (newElements && hints.select !== false) {\n      selection.select(elements);\n    }\n\n    return executedReplacements;\n\n  };\n\n\n  this.replaceElement = function(element, replacement) {\n\n    var cmmnReplace = this._cmmnReplace;\n\n    var definition = getDefinition(element),\n        definitionType = replacement.newDefinitionType || (definition && definition.$type);\n\n    if (!element) {\n      return;\n    }\n\n    var newElement = {\n      type: replacement.newElementType\n    };\n\n    if (definitionType) {\n      assign(newElement, {\n        definitionType: definitionType\n      });\n    }\n\n    return cmmnReplace.replaceElement(element, newElement, { select: false });\n\n  };\n\n}\n\n\nReplaceElementBehavior.$inject = [\n  'cmmnReplace',\n  'cmmnRules',\n  'elementFactory',\n  'elementRegistry',\n  'eventBus',\n  'modeling',\n  'selection',\n  'rules'\n];\n\ninherits(ReplaceElementBehavior, CommandInterceptor);\n\nmodule.exports = ReplaceElementBehavior;\n\n\nfunction isCriterion(element) {\n  return is(element, 'cmmn:Criterion');\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/ReplaceElementBehavior.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/ResizeCasePlanModelBehavior.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\");\n\nvar is = ModelUtil.is,\n    getBusinessObject = ModelUtil.getBusinessObject,\n    isCasePlanModel = ModelUtil.isCasePlanModel;\n\nvar filter = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .filter */ .hX);\nvar ResizeUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/ResizeUtil.js\");\nvar getBBox = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\")/* .getBBox */ .jY);\n\nvar SLIGHTLY_HIGHER_PRIORITY = 1001;\n\nvar DEFAULT_MIN_WIDTH = 10;\n\n/**\n * Computes the minimum resize box.\n *\n * Note: it is slightly different than\n * diagram-js/lib/features/resize/Resize#computeMinResizeBox\n */\nfunction computeMinResizeBox(context) {\n  var shape = context.shape,\n      direction = context.direction,\n      minDimensions,\n      childrenBounds;\n\n  minDimensions = context.minDimensions || {\n    width: DEFAULT_MIN_WIDTH,\n    height: DEFAULT_MIN_WIDTH\n  };\n\n  // get children bounds\n  childrenBounds = computeChildrenBBox(shape, context.childrenBoxPadding);\n\n  // get correct minimum bounds from given resize direction\n  // basically ensures that the minBounds is max(childrenBounds, minDimensions)\n  return ResizeUtil.getMinResizeBounds(direction, shape, minDimensions, childrenBounds);\n}\n\n/**\n * Computes the bbox of the children.\n *\n * It first determine all relevant children,\n * then it computes the size of the bbox.\n */\nfunction computeChildrenBBox(shape, padding) {\n  // grab all the children that are part of the\n  // parents children box\n  var elements = filter(shape.children, function(element) {\n    return isBBoxChild(shape, element);\n  });\n\n  if (elements.length) {\n    return ResizeUtil.addPadding(getBBox(elements), padding);\n  }\n}\n\n/**\n * Returns true, if the given element does\n * have any waypoints, is not a label or an\n * exit criterian attached to the given shape.\n */\nfunction isBBoxChild(shape, element) {\n\n  // exclude connections\n  if (element.waypoints) {\n    return false;\n  }\n\n  // exclude labels\n  if (element.type === 'label') {\n    return false;\n  }\n\n  if (is(element, 'cmmn:ExitCriterion')) {\n    var bo = getBusinessObject(shape);\n    var exitCriteria = bo.get('exitCriteria');\n    var exitCriterion = getBusinessObject(element);\n    if (exitCriteria.indexOf(exitCriterion) >= 0) {\n      return false;\n    }\n  }\n\n  return true;\n}\n\n/**\n * Computes the minimum resize box by excluding\n * attached exit criteria to the case plan model.\n */\nfunction ResizeCasePlanModelBehavior(eventBus, modeling) {\n\n  eventBus.on('resize.start', SLIGHTLY_HIGHER_PRIORITY, function(event) {\n    var context = event.context,\n        shape = context.shape;\n\n    if (isCasePlanModel(shape)) {\n      context.minBounds = computeMinResizeBox(context);\n    }\n  });\n\n}\n\nResizeCasePlanModelBehavior.$inject = [ 'eventBus', 'modeling' ];\n\nmodule.exports = ResizeCasePlanModelBehavior;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/ResizeCasePlanModelBehavior.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/SentryUpdater.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\nvar forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed),\n    flatten = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .flatten */ .xH),\n    groupBy = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .groupBy */ .vM),\n    map = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .map */ .UI),\n    some = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .some */ .G);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    isCasePlanModel = ModelUtil.isCasePlanModel,\n    getSentry = ModelUtil.getSentry,\n    getBusinessObject = ModelUtil.getBusinessObject,\n    getDefinition = ModelUtil.getDefinition,\n    getStandardEvents = ModelUtil.getStandardEvents;\n\nvar getParent = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").getParent);\n\nvar PlanItemDefinitionUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js\"),\n    isItemCapable = PlanItemDefinitionUtil.isItemCapable,\n    getAllDiscretionaryItems = PlanItemDefinitionUtil.getAllDiscretionaryItems,\n    getDirectItemCapables = PlanItemDefinitionUtil.getDirectItemCapables,\n    isHumanTask = PlanItemDefinitionUtil.isHumanTask;\n\nvar VERY_LOW_PRIORITY = 300;\n\n/**\n * A handler responsible for adding, moving and deleting sentries.\n * These changes are reflected to the underlying CMMN 1.1 XML.\n */\nfunction SentryUpdater(eventBus, modeling, itemRegistry, cmmnReplace, cmmnFactory) {\n\n  var self = this;\n\n  CommandInterceptor.call(this, eventBus);\n\n  var containment = 'sentries';\n\n\n  // CONNECTIONS ////////////////////////////////////////////////////////////\n\n  this.postExecuted('connection.create', function(context) {\n\n    var connection = context.connection;\n\n    if (!isOnPartConnection(connection)) {\n      return;\n    }\n\n    var onPart = getOnPart(connection),\n        criterion = connection.target,\n        host = criterion.host,\n        sentry = getSentry(criterion);\n\n    if (!sentry) {\n      sentry = createSentry(criterion);\n      modeling.updateSemanticParent(sentry, getSentryParent(host), 'sentries');\n    }\n\n    modeling.updateSemanticParent(onPart, sentry, 'onParts', connection);\n\n  }, true);\n\n\n  this.preExecuted('connection.delete', function(context) {\n\n    var connection = context.connection;\n\n    if (!isOnPartConnection(connection)) {\n      return;\n    }\n\n    var source = connection.source,\n        onPart = getOnPart(connection);\n\n    if (existsAnotherConnection(source, connection)) {\n      onPart = cloneOnPart(onPart);\n      setCmmnElementRef(connection, onPart);\n    }\n\n    modeling.updateSemanticParent(onPart, null, 'onParts', connection);\n\n  }, true);\n\n\n  this.preExecuted('connection.reconnectStart', function(context) {\n\n    var connection = context.connection,\n        source = connection.source;\n\n    if (!isOnPartConnection(connection)) {\n      return;\n    }\n\n    var onPart = getOnPart(connection),\n        criterion = connection.target,\n        sentry = getSentry(criterion);\n\n    if (existsAnotherConnection(source, connection)) {\n      onPart = cloneOnPart(onPart);\n      setCmmnElementRef(connection, onPart);\n      modeling.updateSemanticParent(onPart, sentry, 'onParts', connection);\n    }\n\n  }, true);\n\n\n  this.preExecuted('connection.reconnectEnd', function(context) {\n\n    var connection = context.connection,\n        source = connection.source;\n\n    if (!isOnPartConnection(connection)) {\n      return;\n    }\n\n    var onPart = getOnPart(connection),\n        oldCriterion = connection.target,\n        oldSentry = getSentry(oldCriterion),\n        newCriterion = context.newTarget,\n        newSentry = getSentry(newCriterion);\n\n    if (oldSentry === newSentry) {\n      return;\n    }\n\n    if (!newSentry) {\n      newSentry = createSentry(newCriterion);\n      modeling.updateSemanticParent(newSentry, getSentryParent(newCriterion.host), 'sentries');\n    }\n\n    if (existsAnotherConnection(source, connection)) {\n      onPart = cloneOnPart(onPart);\n      setCmmnElementRef(connection, onPart);\n    }\n\n    modeling.updateSemanticParent(onPart, newSentry, 'onParts', connection);\n\n  }, true);\n\n\n  this.postExecuted([ 'connection.create', 'connection.reconnectStart'], function(context) {\n\n    var connection = context.connection;\n\n    if (!isOnPartConnection(connection)) {\n      return;\n    }\n\n    var onPart = getOnPart(connection),\n        standardEvent;\n\n    if (!isValidStandardEvent(connection)) {\n      standardEvent = getDefaultStandardEvent(connection);\n      modeling.updateProperties(onPart, {\n        standardEvent: standardEvent\n      }, connection);\n    }\n\n  }, true);\n\n\n  // CREATE //////////////////////////////////////////////////////////////////\n\n  this.postExecuted('element.updateAttachment', function(context) {\n\n    var shape = context.shape;\n\n    if (!isCriterion(shape)) {\n      return;\n    }\n\n    if (shape.host) {\n      self.updateSentriesSemanticParent([ shape ]);\n    }\n    else {\n      self.deleteSentry(shape);\n    }\n\n  }, true);\n\n\n  // DELETE /////////////////////////////////////////////////////////////\n\n  this.preExecuted('shape.delete', function(context) {\n\n    var definition = getDefinition(context.shape);\n\n    if (!isHumanTask(definition)) {\n      return;\n    }\n\n    // get remaining discretionary items\n    context.discretionaryItems = context.discretionaryItems || getAllDiscretionaryItems(definition);\n\n  }, true);\n\n\n  this.postExecuted('shape.delete', VERY_LOW_PRIORITY, function(context) {\n\n    var discretionaryItems = context.discretionaryItems,\n        attachers;\n\n    attachers = getAttachersRecurse(discretionaryItems);\n\n    if (attachers && attachers.length) {\n      self.updateSentriesSemanticParent(attachers);\n    }\n\n  }, true);\n\n\n  // MOVING /////////////////////////////////////////////////////////////\n\n  this.postExecuted([\n    'connection.create',\n    'connection.delete',\n    'connection.reconnectEnd',\n    'connection.reconnectStart'\n  ], VERY_LOW_PRIORITY, function(context) {\n\n    var connection = context.connection,\n        source = context.newSource || context.source || connection.source,\n        target = context.newTarget || context.target || connection.target,\n        shapes = [],\n        attachers;\n\n    if (!isDiscretionaryConnection(connection, source, target)) {\n      return;\n    }\n\n    if (connection.target) {\n      shapes.push(connection.target);\n    }\n\n    if (!connection.target && context.target) {\n      shapes.push(context.target);\n    }\n\n    if (context.oldTarget) {\n      shapes.push(context.oldTarget);\n    }\n\n    attachers = getAttachersRecurse(shapes);\n\n    if (attachers && attachers.length) {\n      self.updateSentriesSemanticParent(attachers);\n    }\n\n  }, true);\n\n\n  this.postExecuted('elements.move', VERY_LOW_PRIORITY, function(context) {\n\n    var shapes = context.shapes,\n        newParent = context.newParent,\n        oldParent = context.hints && context.hints.oldParent,\n        attachers;\n\n    if (oldParent === newParent) {\n      return;\n    }\n\n    attachers = getAttachersRecurse(shapes);\n\n    if (attachers && attachers.length) {\n      self.updateSentriesSemanticParent(attachers);\n    }\n\n  }, true);\n\n\n  // API //////////////////////////////////////////////////////\n\n\n  /**\n   * Deletes by given criteria referenced sentries, if the\n   * the sentry is not referenced by any other criterion.\n   *\n   * @param {Object} criteria deleted criteria\n   */\n  this.deleteSentry = function(criterion) {\n\n    var sentry = getSentry(criterion),\n        references;\n\n    if (sentry) {\n      references = itemRegistry.getReferences(sentry);\n\n      if (references.length <= 1) {\n        modeling.updateSemanticParent(sentry, null, containment);\n      }\n    }\n\n  };\n\n\n  /**\n   * Updates the parent of by given criteria referenced sentries.\n   *\n   * If the sentry is referenced by multiple criteria and only\n   * a part of them has been moved, then the sentry is duplicated.\n   *\n   * @param {Object} criteria updated criteria\n   */\n  this.updateSentriesSemanticParent = function(criteria) {\n\n    var groupedCriteria = groupBySentry(criteria),\n        replacements = {};\n\n    /**\n     * Returns true if the given element is replaced\n     */\n    function isReplaced(elem) {\n      return !!replacements[elem.id];\n    }\n\n    /**\n     * Set the given old element as replaced\n     * with the given new element.\n     */\n    function replace(oldElem, newElem) {\n      replacements[oldElem.id] = newElem;\n    }\n\n    /**\n     * Returns the replacement of the given element.\n     * If no replacement is available the given element\n     * itself is returned.\n     */\n    function getReplacement(elem) {\n      return replacements[elem.id] || elem;\n    }\n\n    /**\n     * Returns true if the sentry should be replaced.\n     */\n    function shouldReplace(sentry, newParent) {\n      var references = itemRegistry.getReferences(sentry),\n          criteria = (groupedCriteria[sentry.id] || []),\n          referencesLength = itemRegistry.getReferences(sentry).length,\n          criteriaLength = criteria.length;\n\n      if (referencesLength > criteriaLength) {\n\n        if (!newParent) {\n          return true;\n        }\n\n        return some(references, function(criterion) {\n          var criterionShape = itemRegistry.getShape(criterion);\n          return criterionShape && newParent !== getSentryParent(criterionShape.host);\n        });\n\n      }\n\n      return false;\n    }\n\n\n    handleEachElement(criteria, function(criterion) {\n\n      var sentry = getSentry(criterion);\n\n      if (sentry) {\n\n        var newParent = getSentryParent(criterion.host);\n\n        if (!newParent) {\n          var parent = getParent(getBusinessObject(criterion));\n          newParent = parent && getSentryParent(parent);\n        }\n\n        if (sentry.$parent === newParent) {\n          return;\n        }\n\n        if (!isReplaced(sentry) && shouldReplace(sentry, newParent)) {\n          var newSentry = cmmnReplace.replaceSentry(sentry);\n          replace(sentry, newSentry);\n\n          forEach(criterion.incoming, function(con) {\n\n            var cmmnElement = con.businessObject.cmmnElementRef;\n            if (cmmnElement && is(cmmnElement, 'cmmn:OnPart')) {\n              replace(cmmnElement, cloneOnPart(cmmnElement));\n            }\n\n          });\n        }\n\n        sentry = getReplacement(sentry);\n\n        if (getSentry(criterion) !== sentry) {\n          setSentryRef(criterion, sentry);\n        }\n\n        forEach(criterion.incoming, function(con) {\n\n          var cmmnElement = con.businessObject.cmmnElementRef;\n          if (cmmnElement && is(cmmnElement, 'cmmn:OnPart')) {\n\n            var replaceBy = getReplacement(cmmnElement);\n\n            if (replaceBy && cmmnElement !== replaceBy) {\n              setCmmnElementRef(con, replaceBy);\n              modeling.updateSemanticParent(replaceBy, sentry, 'onParts');\n            }\n\n          }\n\n        });\n\n        modeling.updateSemanticParent(sentry, newParent, containment);\n\n      }\n\n    });\n\n  };\n\n\n  // UTILITIES /////////////////////////////////////////////////////////////////\n\n\n  function getAttachersRecurse(shapes) {\n\n    var attachers = getAttachers(shapes);\n\n    handleEachElement(shapes, function(shape) {\n\n      var definition = getDefinition(shape);\n\n      if (isHumanTask(definition)) {\n\n        var items = getAllDiscretionaryItems(shape);\n\n        if (items && items.length) {\n          attachers = attachers.concat(getAttachers(items));\n        }\n\n        return items;\n      }\n\n      return getDirectItemCapables(shape);\n\n    });\n\n    return flatten(attachers);\n  }\n\n\n  function handleEachElement(shapes, fn) {\n\n    var handledElements = {};\n\n    function handled(element) {\n      handledElements[element.id] = element;\n    }\n\n    function isHandled(element) {\n      return !!handledElements[element.id];\n    }\n\n    function eachElement(elements, isRoot) {\n      forEach(elements, function(element) {\n\n        if (!isHandled(element)) {\n          handled(element);\n\n          element = itemRegistry.getShape(element.id) || element;\n\n          var children = fn(element);\n\n          if (children && children.length) {\n            eachElement(children);\n          }\n        }\n\n        if (isRoot) {\n          handledElements = {};\n        }\n\n      });\n    }\n\n    eachElement(shapes, true);\n  }\n\n  function createSentry(criterion) {\n    var sentry = cmmnFactory.createSentry();\n    setSentryRef(criterion, sentry);\n    return sentry;\n  }\n\n  function setSentryRef(criterion, sentry) {\n    modeling.updateProperties(criterion, {\n      sentryRef: sentry\n    });\n  }\n\n  function setCmmnElementRef(connection, ref) {\n    modeling.updateProperties(connection, {\n      cmmnElementRef: ref\n    });\n  }\n\n  function cloneOnPart(onPart) {\n    var attrs = {\n      name: onPart.name,\n      sourceRef: onPart.sourceRef,\n      standardEvent: onPart.standardEvent\n    };\n\n    if (is(onPart, 'cmmn:PlanItemOnPart')) {\n      attrs.exitCriterionRef = onPart.exitCriterionRef;\n    }\n\n    return cmmnFactory.create(onPart.$type, attrs);\n  }\n\n\n  function isOnPartConnection(connection) {\n    var cmmnElement = connection.businessObject.cmmnElementRef;\n    return is(cmmnElement, 'cmmn:OnPart');\n  }\n\n  function isDiscretionaryConnection(connection, source, target) {\n    return !connection.businessObject.cmmnElementRef;\n  }\n\n}\n\nSentryUpdater.$inject = [\n  'eventBus',\n  'modeling',\n  'itemRegistry',\n  'cmmnReplace',\n  'cmmnFactory'\n];\n\ninherits(SentryUpdater, CommandInterceptor);\n\nmodule.exports = SentryUpdater;\n\n\n/**\n * Returns based on the given host the parent\n * for a sentry.\n *\n * @param {djs.model.Base} host\n *\n * @result {ModdleElement} parent\n */\nfunction getSentryParent(host) {\n\n  if (isCasePlanModel(host)) {\n    return getBusinessObject(host);\n  }\n\n  if (isItemCapable(host)) {\n    var bo = getBusinessObject(host);\n    return getParent(bo, 'cmmn:PlanFragment');\n  }\n\n}\n\n\n/**\n * Returns all attachers for the given shapes.\n *\n * @param {Array<djs.model.Base>} shapes\n *\n * @result {Array<djs.model.Base>} attachers\n */\nfunction getAttachers(shapes) {\n  return flatten(map(shapes, function(s) {\n    var attachers = [];\n\n    if (s.attachers) {\n      attachers = s.attachers;\n    }\n    else {\n      var bo = getBusinessObject(s);\n\n      var exitCriteria = bo.get('exitCriteria');\n      forEach(exitCriteria, function(criterion) {\n        attachers.push(criterion);\n      });\n\n      var entryCriteria = bo.get('entryCriteria');\n      forEach(entryCriteria, function(criterion) {\n        attachers.push(criterion);\n      });\n    }\n\n    return attachers || [];\n  }));\n}\n\n\n/**\n * Groups given criteria by sentry.\n *\n * @param {Object} criteria group by id\n *\n * @result {Object} criteria grouped by sentry\n */\nfunction groupBySentry(criteria) {\n  return groupBy(criteria, function(criterion) {\n    var sentry = getSentry(criterion);\n    return sentry && sentry.id;\n  });\n}\n\n\n/**\n * Returns true if the given element is a criterion.\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean}\n */\nfunction isCriterion(element) {\n  return is(element, 'cmmn:Criterion');\n}\n\nfunction existsAnotherConnection(source, connection) {\n  var onPart = getOnPart(connection);\n  return some(source.outgoing, function(con) {\n    return connection !== con && onPart === getOnPart(con);\n  });\n}\n\nfunction getOnPart(connection) {\n  connection = getBusinessObject(connection);\n  return connection.cmmnElementRef;\n}\n\nfunction isValidStandardEvent(connection) {\n\n  var onPart = getOnPart(connection),\n      standardEvent = onPart.standardEvent,\n      possibleStandardEvents = getStandardEvents(onPart);\n\n  return standardEvent && possibleStandardEvents.indexOf(standardEvent) !== -1;\n\n}\n\nfunction getDefaultStandardEvent(element) {\n\n  element = getOnPart(element);\n\n  if (is(element.sourceRef, 'cmmn:CaseFileItem')) {\n    return 'update';\n  }\n\n  if (is(element.exitCriterionRef, 'cmmn:ExitCriterion')) {\n    return 'exit';\n  }\n\n  if (is(element.sourceRef, 'cmmn:PlanItem')) {\n\n    var definition = getDefinition(element.sourceRef);\n    if (is(definition, 'cmmn:EventListener') || is(definition, 'cmmn:Milestone')) {\n      return 'occur';\n    }\n    else {\n      return 'complete';\n    }\n\n  }\n\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/SentryUpdater.js?")},"./node_modules/cmmn-js/lib/features/modeling/behavior/UnclaimIdBehavior.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar forEach = (__webpack_require__("./node_modules/min-dash/dist/index.esm.js")/* .forEach */ .Ed);\n\nvar inherits = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n\nvar CommandInterceptor = (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js")/* ["default"] */ .Z);\n\nfunction UnclaimIdBehavior(eventBus, modeling) {\n\n  CommandInterceptor.call(this, eventBus);\n\n  this.preExecute(\'elements.delete\', function(event) {\n    var context = event.context,\n        elements = context.elements;\n\n    forEach(elements, function(element) {\n      modeling.unclaimId(element.businessObject.id, element.businessObject);\n    });\n\n  });\n}\n\ninherits(UnclaimIdBehavior, CommandInterceptor);\n\nUnclaimIdBehavior.$inject = [ \'eventBus\', \'modeling\' ];\n\nmodule.exports = UnclaimIdBehavior;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/UnclaimIdBehavior.js?')},"./node_modules/cmmn-js/lib/features/modeling/behavior/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("module.exports = {\n  __init__: [\n    'attachCriterionBehavior',\n    'caseFileItemUpdater',\n    'labelBehavior',\n    'planItemDefinitionUpdater',\n    'planningTableUpdater',\n    'replaceConnectionBehavior',\n    'replaceElementBehavior',\n    'resizeCasePlanModelBehavior',\n    'sentryUpdater',\n    'unclaimIdBehavior'\n  ],\n  attachCriterionBehavior: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/AttachCriterionBehavior.js\") ],\n  caseFileItemUpdater: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/CaseFileItemUpdater.js\") ],\n  labelBehavior: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/LabelBehavior.js\") ],\n  planItemDefinitionUpdater: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/PlanItemDefinitionUpdater.js\") ],\n  planningTableUpdater: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/PlanningTableUpdater.js\") ],\n  replaceConnectionBehavior: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/ReplaceConnectionBehavior.js\") ],\n  replaceElementBehavior: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/ReplaceElementBehavior.js\") ],\n  resizeCasePlanModelBehavior: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/ResizeCasePlanModelBehavior.js\") ],\n  sentryUpdater: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/SentryUpdater.js\") ],\n  unclaimIdBehavior: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/behavior/UnclaimIdBehavior.js\") ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/behavior/index.js?")},"./node_modules/cmmn-js/lib/features/modeling/cmd/AppendShapeHandler.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is);\n\nvar BaseHandler = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/AppendShapeHandler.js\")/* [\"default\"] */ .Z);\n\n\nfunction AppendShapeHandler(modeling, cmmnRules) {\n  this._modeling = modeling;\n  this._cmmnRules = cmmnRules;\n}\n\ninherits(AppendShapeHandler, BaseHandler);\n\n\nAppendShapeHandler.$inject = [ 'modeling', 'cmmnRules' ];\n\nmodule.exports = AppendShapeHandler;\n\n\n// api /////////////////\n\nAppendShapeHandler.prototype.preExecute = function(context) {\n\n  if (!context.source) {\n    throw new Error('source required');\n  }\n\n  var cmmnRules = this._cmmnRules;\n\n  var shape = context.shape,\n      source = context.source,\n      parent = context.target || context.source.parent,\n      position = context.position,\n      isAttach = context.attach;\n\n  if (isCriterion(shape)) {\n    isAttach = cmmnRules.canAttach(shape, parent, source, position) === 'attach';\n  }\n\n  context.shape = this._modeling.createShape(shape, position, parent, {\n    attach: isAttach,\n    nested: true\n  });\n\n};\n\nfunction isCriterion(element) {\n  return is(element, 'cmmn:Criterion');\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/cmd/AppendShapeHandler.js?")},"./node_modules/cmmn-js/lib/features/modeling/cmd/IdClaimHandler.js":module=>{"use strict";eval("\n\n\nfunction IdClaimHandler(moddle) {\n  this._moddle = moddle;\n}\n\nIdClaimHandler.$inject = [ 'moddle' ];\n\nmodule.exports = IdClaimHandler;\n\n\nIdClaimHandler.prototype.execute = function(context) {\n  var ids = this._moddle.ids,\n      id = context.id,\n      element = context.element,\n      claiming = context.claiming;\n\n  if (claiming) {\n    ids.claim(id, element);\n  } else {\n    ids.unclaim(id);\n  }\n};\n\n\nIdClaimHandler.prototype.revert = function(context) {\n  var ids = this._moddle.ids,\n      id = context.id,\n      element = context.element,\n      claiming = context.claiming;\n\n  if (claiming) {\n    ids.unclaim(id);\n  } else {\n    ids.claim(id, element);\n  }\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/cmd/IdClaimHandler.js?")},"./node_modules/cmmn-js/lib/features/modeling/cmd/ReconnectConnectionHandler.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar inherits = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n\nvar isArray = (__webpack_require__("./node_modules/min-dash/dist/index.esm.js")/* .isArray */ .kJ);\n\nvar BaseHandler = (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReconnectConnectionHandler.js")/* ["default"] */ .Z);\n\n/**\n * Overwrites the behavior of diagram-js/ReconnectConnectionHandler to enable\n * a switch between source and target of a connection on reconnect.\n */\nfunction ReconnectConnectionHandler(injector) {\n  injector.invoke(BaseHandler, this);\n}\n\ninherits(ReconnectConnectionHandler, BaseHandler);\n\nReconnectConnectionHandler.$inject = [ \'injector\' ];\n\nmodule.exports = ReconnectConnectionHandler;\n\n\nReconnectConnectionHandler.prototype.execute = function(context) {\n\n  var newSource = context.newSource,\n      newTarget = context.newTarget,\n      connection = context.connection,\n      dockingOrPoints = context.dockingOrPoints;\n\n  if (!newSource && !newTarget) {\n    throw new Error(\'newSource or newTarget are required\');\n  }\n\n  // removed from corresponding method in diagram-js@3.3.0\n\n  // if (newSource && newTarget) {\n  //   throw new Error(\'must specify either newSource or newTarget\');\n  // }\n\n  if (isArray(dockingOrPoints)) {\n    context.oldWaypoints = connection.waypoints;\n    connection.waypoints = dockingOrPoints;\n  }\n\n  if (newSource) {\n    context.oldSource = connection.source;\n    connection.source = newSource;\n  }\n\n  if (newTarget) {\n    context.oldTarget = connection.target;\n    connection.target = newTarget;\n  }\n\n  return connection;\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/cmd/ReconnectConnectionHandler.js?')},"./node_modules/cmmn-js/lib/features/modeling/cmd/ReplaceShapeHandler.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar inherits = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n\nvar BaseHandler = (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReplaceShapeHandler.js")/* ["default"] */ .Z);\n\n\nfunction ReplaceShapeHandler(modeling, rules) {\n  this._modeling = modeling;\n  this._rules = rules;\n}\n\ninherits(ReplaceShapeHandler, BaseHandler);\n\nReplaceShapeHandler.$inject = [ \'modeling\', \'rules\' ];\n\nmodule.exports = ReplaceShapeHandler;\n\n\n// api /////////////////\n\n\nReplaceShapeHandler.prototype.createShape = function(shape, position, target) {\n  var modeling = this._modeling;\n  return modeling.createShape(shape, position, target, {\n    nested: true\n  });\n};\n\n\nReplaceShapeHandler.prototype.reconnectStart = function(connection, newSource, dockingPoint) {\n  var modeling = this._modeling;\n  modeling.reconnectStart(connection, newSource, dockingPoint, {\n    nested: true,\n    startChanged: true\n  });\n};\n\n\nReplaceShapeHandler.prototype.reconnectEnd = function(connection, newTarget, dockingPoint) {\n  var modeling = this._modeling;\n  modeling.reconnectEnd(connection, newTarget, dockingPoint, {\n    nested: true,\n    endChanged: true\n  });\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/cmd/ReplaceShapeHandler.js?')},"./node_modules/cmmn-js/lib/features/modeling/cmd/UpdateControlsHandler.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar filter = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .filter */ .hX),\n    forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed);\n\nvar getBusinessObject = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getBusinessObject),\n    getItemControl = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getItemControl),\n    getDefaultControl = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getDefaultControl),\n    getDefinition = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getDefinition),\n    hasPlanningTable = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").hasPlanningTable);\n\nvar isPlanningTableCapable = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js\").isPlanningTableCapable);\n\n\nfunction UpdateControlsHandler(itemRegistry, modeling, cmmnReplace, cmmnFactory) {\n  this._itemRegistry = itemRegistry;\n  this._modeling = modeling;\n  this._cmmnReplace = cmmnReplace;\n  this._cmmnFactory = cmmnFactory;\n}\n\nUpdateControlsHandler.$inject = [ 'itemRegistry', 'modeling', 'cmmnReplace', 'cmmnFactory' ];\n\nmodule.exports = UpdateControlsHandler;\n\n\nvar PLAN_ITEM_CONTROL_PROPS = [\n  'requiredRule',\n  'repetitionRule',\n  'manualActivationRule'\n];\n\nfunction getUpdate(key, value) {\n  var update = {};\n  update[key] = value;\n  return update;\n}\n\n\nUpdateControlsHandler.prototype.preExecute = function(context) {\n\n  var self = this;\n\n  var element = context.element,\n      values = context.values;\n\n  if (!element) {\n    throw new Error('element required');\n  }\n\n  forEach(values, function(value, key) {\n\n    if (PLAN_ITEM_CONTROL_PROPS.indexOf(key) !== -1) {\n      self._updateRule(element, key, value);\n    }\n    else {\n      self._updateDecorator(element, key, value);\n    }\n\n  });\n\n};\n\n\nUpdateControlsHandler.prototype.execute = function() {};\n\nUpdateControlsHandler.prototype.revert = function() {};\n\n\n// API ////////////////////////////////////////////////\n\n\nUpdateControlsHandler.prototype._updateDecorator = function(element, key, value) {\n\n  var self = this,\n      modeling = self._modeling;\n\n  var definition = getDefinition(element),\n      update = getUpdate(key, value),\n      changed = [];\n\n  if (definition[key] !== value) {\n\n    changed = self._getReferencingShapes(definition);\n\n    if (changed.length > 1 && canReplaceDefinition(definition)) {\n      definition = self._replaceDefinition(element);\n      changed = element;\n    }\n\n    modeling.updateProperties(definition, update, changed);\n\n  }\n\n};\n\n\nUpdateControlsHandler.prototype._updateRule = function(element, rule, value) {\n\n  var self = this,\n      modeling = self._modeling,\n      cmmnFactory = self._cmmnFactory;\n\n  var itemControl = getItemControl(element),\n      defaultControl = getDefaultControl(element),\n      definition = getDefinition(element),\n      update = getUpdate(rule, value);\n\n\n  !value ? deleteRule() : setRule();\n\n\n  function deleteRule() {\n\n    var oldValue;\n\n    if (isRulePresent(itemControl, rule)) {\n      oldValue = itemControl[rule];\n      modeling.updateProperties(itemControl, update, element);\n      modeling.updateSemanticParent(oldValue);\n\n      if (canDeletePlanItemControl(itemControl)) {\n        modeling.updateProperties(element, { itemControl: undefined });\n        modeling.updateSemanticParent(itemControl);\n      }\n\n    }\n\n    if (isRulePresent(defaultControl, rule)) {\n      oldValue = defaultControl[rule];\n\n      var changed = self._getReferencingShapes(definition);\n\n      if (changed.length > 1 && canReplaceDefinition(definition)) {\n\n        changed = filter(changed, function(elem) {\n          var localItemControl = getItemControl(elem),\n              localDefaultControl = getDefaultControl(elem);\n\n          return !isRulePresent(localItemControl, rule) &&\n                  isRulePresent(localDefaultControl, rule);\n        });\n\n        if (changed.length > 1) {\n          self._replaceDefinition(element);\n          defaultControl = getDefaultControl(element);\n          changed = element;\n        }\n\n      }\n\n      modeling.updateProperties(defaultControl, update, changed);\n      modeling.updateSemanticParent(oldValue);\n\n      if (canDeletePlanItemControl(defaultControl)) {\n        modeling.updateProperties(definition, { defaultControl: undefined }, changed);\n        modeling.updateSemanticParent(defaultControl);\n      }\n\n    }\n\n  }\n\n  function setRule() {\n\n    if (!itemControl) {\n      itemControl = createPlanItemControl();\n      modeling.updateProperties(element, { itemControl: itemControl });\n      modeling.updateSemanticParent(itemControl, getBusinessObject(element));\n    }\n\n    modeling.updateProperties(itemControl, update, element);\n    modeling.updateSemanticParent(value, itemControl);\n  }\n\n  function isRulePresent(control, rule) {\n    return control && control[rule];\n  }\n\n  function createPlanItemControl() {\n    return cmmnFactory.create('cmmn:PlanItemControl');\n  }\n\n  function canDeletePlanItemControl(control) {\n    return !!(control && !control.repetitionRule && !control.requiredRule && !control.manualActivationRule);\n  }\n\n};\n\n\nUpdateControlsHandler.prototype._replaceDefinition = function(element) {\n\n  var self = this,\n      modeling = self._modeling,\n      cmmnReplace = self._cmmnReplace;\n\n  var definition = getDefinition(element);\n\n  var newDefinition = cmmnReplace.replacePlanItemDefinition(definition);\n  modeling.updateProperties(element, { definitionRef: newDefinition });\n\n  modeling.updateSemanticParent(newDefinition, definition.$parent, 'planItemDefinitions');\n\n  return newDefinition;\n\n};\n\n\nUpdateControlsHandler.prototype._getReferencingShapes = function(definition) {\n\n  var self = this,\n      itemRegistry = self._itemRegistry;\n\n  return itemRegistry.getShapes(definition);\n\n};\n\n\nfunction canReplaceDefinition(definition) {\n  return !(isPlanningTableCapable(definition) && hasPlanningTable(definition));\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/cmd/UpdateControlsHandler.js?")},"./node_modules/cmmn-js/lib/features/modeling/cmd/UpdatePropertiesHandler.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar reduce = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .reduce */ .u4),\n    keys = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .keys */ .XP),\n    forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed),\n    assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0);\n\nvar getBusinessObject = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getBusinessObject);\n\nvar NAME = 'name',\n    STANDARD_EVENT = 'standardEvent',\n    ID = 'id',\n    DEFINITION_REF = 'definitionRef',\n    SENTRY_REF = 'sentryRef',\n    IS_STANDARD_EVENT_VISIBLE = 'isStandardEventVisible';\n\nvar flatten = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .flatten */ .xH);\n\n/**\n * A handler that implements a CMMN 1.1 property update.\n *\n * This should be used to set simple properties on elements with\n * an underlying CMMN business object.\n *\n * Use respective diagram-js provided handlers if you would\n * like to perform automated modeling.\n */\nfunction UpdatePropertiesHandler(elementRegistry, itemRegistry, moddle) {\n  this._elementRegistry = elementRegistry;\n  this._itemRegistry = itemRegistry;\n  this._moddle = moddle;\n}\n\nUpdatePropertiesHandler.$inject = [ 'elementRegistry', 'itemRegistry', 'moddle' ];\n\nmodule.exports = UpdatePropertiesHandler;\n\n\n// api /////////////////\n\nUpdatePropertiesHandler.prototype.preExecute = function(context) {\n\n  var element = context.element,\n      shape = context.shape;\n\n  if (!element) {\n    throw new Error('element required');\n  }\n\n  var bo = element.businessObject || element;\n\n  context.businessObject = bo;\n\n  var changed = [];\n\n  if (element.businessObject) {\n    changed.push(element);\n  }\n\n  if (shape) {\n    changed.push(shape);\n  }\n\n  context.changed = flatten(changed);\n};\n\n\n/**\n * Updates a CMMN element with a list of new properties\n *\n * @param {Object} context\n * @param {djs.model.Base} context.element the element to update\n * @param {Object} context.properties a list of properties to set on the element's\n *                                    businessObject (the CMMN model element)\n *\n * @return {Array<djs.mode.Base>} the updated element\n */\nUpdatePropertiesHandler.prototype.execute = function(context) {\n\n  var elementRegistry = this._elementRegistry,\n      itemRegistry = this._itemRegistry,\n      ids = this._moddle.ids;\n\n  var changed = context.changed;\n\n  var element = context.element,\n      businessObject = context.businessObject,\n      properties = unwrapBusinessObjects(context.properties),\n      oldProperties = context.oldProperties || getProperties(businessObject, keys(properties));\n\n  if (isIdChange(properties, businessObject)) {\n    ids.unclaim(businessObject[ID]);\n\n    itemRegistry.updateId(businessObject, properties[ID]);\n\n    var shape = elementRegistry.get(element.id);\n\n    if (shape) {\n      elementRegistry.updateId(shape, properties[ID]);\n    }\n\n    ids.claim(properties[ID], businessObject);\n  }\n\n  if (isDefinitionRefChange(properties, businessObject)) {\n    itemRegistry.updateReference(businessObject, properties[DEFINITION_REF]);\n  }\n\n  if (isSentryRefChange(properties, businessObject)) {\n    itemRegistry.updateReference(businessObject, properties[SENTRY_REF]);\n  }\n\n  if (NAME in properties) {\n\n    forEach(changed, function(changedShape) {\n      if (changedShape.label) {\n        changed.push(changedShape.label);\n      }\n    });\n\n  }\n\n  if (STANDARD_EVENT in properties || IS_STANDARD_EVENT_VISIBLE in properties) {\n\n    forEach(changed, function(changedShape) {\n      if (changedShape.label) {\n        changed.push(changedShape.label);\n      }\n    });\n\n  }\n\n  // update properties\n  setProperties(businessObject, properties);\n\n  // store old values\n  context.oldProperties = oldProperties;\n\n  // indicate changed on objects affected by the update\n  return changed;\n};\n\n/**\n * Reverts the update on a CMMN elements properties.\n *\n * @param  {Object} context\n *\n * @return {djs.mode.Base} the updated element\n */\nUpdatePropertiesHandler.prototype.revert = function(context) {\n\n  var properties = context.properties,\n      oldProperties = context.oldProperties,\n      businessObject = context.businessObject,\n      elementRegistry = this._elementRegistry,\n      itemRegistry = this._itemRegistry,\n      ids = this._moddle.ids;\n\n  if (isIdChange(oldProperties, businessObject)) {\n    itemRegistry.updateId(businessObject, oldProperties[ID]);\n  }\n\n  if (isDefinitionRefChange(oldProperties, businessObject)) {\n    itemRegistry.updateReference(businessObject, oldProperties[DEFINITION_REF]);\n  }\n\n  if (isSentryRefChange(oldProperties, businessObject)) {\n    itemRegistry.updateReference(businessObject, oldProperties[SENTRY_REF]);\n  }\n\n  // update properties\n  setProperties(businessObject, oldProperties);\n\n  if (isIdChange(properties, businessObject)) {\n    ids.unclaim(properties[ID]);\n\n    var shape = elementRegistry.get(properties[ID]);\n\n    if (shape) {\n      elementRegistry.updateId(shape, oldProperties[ID]);\n    }\n\n    ids.claim(oldProperties[ID], businessObject);\n  }\n\n  return context.changed;\n};\n\n\nfunction isIdChange(properties, businessObject) {\n  return ID in properties && properties[ID] !== businessObject[ID];\n}\n\nfunction isDefinitionRefChange(properties, businessObject) {\n  return DEFINITION_REF in properties && properties[DEFINITION_REF] !== businessObject[DEFINITION_REF];\n}\n\nfunction isSentryRefChange(properties, businessObject) {\n  return SENTRY_REF in properties && properties[SENTRY_REF] !== businessObject[SENTRY_REF];\n}\n\n\nfunction getProperties(businessObject, propertyNames) {\n  return reduce(propertyNames, function(result, key) {\n    result[key] = businessObject.get(key);\n    return result;\n  }, {});\n}\n\n\nfunction setProperties(businessObject, properties) {\n  forEach(properties, function(value, key) {\n    businessObject.set(key, value);\n  });\n}\n\n\nvar referencePropertyNames = [ 'default' ];\n\n/**\n * Make sure we unwrap the actual business object\n * behind diagram element that may have been\n * passed as arguments.\n *\n * @param  {Object} properties\n *\n * @return {Object} unwrappedProps\n */\nfunction unwrapBusinessObjects(properties) {\n\n  var unwrappedProps = assign({}, properties);\n\n  referencePropertyNames.forEach(function(name) {\n    if (name in properties) {\n      unwrappedProps[name] = getBusinessObject(unwrappedProps[name]);\n    }\n  });\n\n  return unwrappedProps;\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/cmd/UpdatePropertiesHandler.js?")},"./node_modules/cmmn-js/lib/features/modeling/cmd/UpdateSemanticParentHandler.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar flatten = (__webpack_require__("./node_modules/min-dash/dist/index.esm.js")/* .flatten */ .xH);\n\nvar Collections = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js");\n\n\nfunction UpdateSemanticParentHandler() {\n}\n\nmodule.exports = UpdateSemanticParentHandler;\n\n\n// api /////////////////\n\nUpdateSemanticParentHandler.prototype.preExecute = function(context) {\n  var element = context.element,\n      shape = context.shape;\n\n  if (!element) {\n    throw new Error(\'element required\');\n  }\n\n  var bo = element.businessObject || element;\n\n  context.businessObject = bo;\n  context.oldParent = bo.$parent;\n\n  var changed = [];\n\n  if (element.businessObject) {\n    changed.push(element);\n  }\n\n  if (shape) {\n    changed.push(shape);\n  }\n\n  context.changed = flatten(changed);\n};\n\nUpdateSemanticParentHandler.prototype.execute = function(context) {\n\n  var businessObject = context.businessObject,\n      newParent = context.newParent,\n      containment = context.containment;\n\n  this.updateSemanticParent(businessObject, newParent, containment);\n\n  // indicate changed on objects affected by the update\n  return context.changed;\n};\n\n\nUpdateSemanticParentHandler.prototype.revert = function(context) {\n\n  var businessObject = context.businessObject,\n      newParent = context.oldParent,\n      containment = context.containment;\n\n  this.updateSemanticParent(businessObject, newParent, containment);\n\n  return context.changed;\n};\n\n\nUpdateSemanticParentHandler.prototype.updateSemanticParent = function(element, newParent, containment) {\n\n  if (element.$parent === newParent) {\n    return;\n  }\n\n  var children;\n\n  if (element.$parent && containment) {\n    // remove from old parent\n    children = element.$parent.get(containment);\n    Collections.remove(children, element);\n  }\n\n  element.$parent = null;\n\n  if (newParent) {\n\n    if (containment) {\n      // add to new parent\n      children = newParent.get(containment);\n      children.push(element);\n    }\n\n    element.$parent = newParent;\n  }\n\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/cmd/UpdateSemanticParentHandler.js?')},"./node_modules/cmmn-js/lib/features/modeling/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __init__: [ \'modeling\', \'cmmnUpdater\' ],\n  __depends__: [\n    __webpack_require__("./node_modules/cmmn-js/lib/features/modeling/behavior/index.js"),\n    __webpack_require__("./node_modules/cmmn-js/lib/features/ordering/index.js"),\n    __webpack_require__("./node_modules/cmmn-js/lib/features/replace/index.js"),\n    __webpack_require__("./node_modules/cmmn-js/lib/features/rules/index.js"),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/command/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/label-support/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/attach-support/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/change-support/index.js")/* ["default"] */ .Z)\n  ],\n  cmmnFactory: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/modeling/CmmnFactory.js") ],\n  cmmnUpdater: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/modeling/CmmnUpdater.js") ],\n  elementFactory: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/modeling/ElementFactory.js") ],\n  modeling: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/modeling/Modeling.js") ],\n  layouter: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/modeling/CmmnLayouter.js") ],\n  connectionDocking: [ \'type\', (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/CroppingConnectionDocking.js")/* ["default"] */ .Z) ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/index.js?')},"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar some = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .some */ .G);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    getBusinessObject = ModelUtil.getBusinessObject;\n\nvar Model = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/model/index.js\");\n\n/**\n * Return true if given elements are the same.\n *\n * @param {Object} a\n * @param {Object} b\n *\n * @return {boolean}\n */\nfunction isSame(a, b) {\n  return a === b;\n}\n\nmodule.exports.isSame = isSame;\n\n\n/**\n * Return true if given cases are the same.\n *\n * @param {ModdleElement} a\n * @param {ModdleElement} b\n *\n * @return {boolean}\n */\nfunction isSameCase(a, b) {\n  return isSame(getCase(a), getCase(b));\n}\n\nmodule.exports.isSameCase = isSameCase;\n\nfunction getCase(element) {\n  return getParent(getBusinessObject(element), 'cmmn:Case');\n}\n\nmodule.exports.getCase = getCase;\n\n\n/**\n * Return the parents of the element with any of the given types.\n *\n * @param {ModdleElement} element\n * @param {String|Array<String>} anyType\n *\n * @return {Array<ModdleElement>}\n */\nfunction getParents(element, anyType) {\n\n  var parents = [];\n\n  if (typeof anyType === 'string') {\n    anyType = [ anyType ];\n  }\n\n  while (element) {\n    element = element.$parent || element.parent;\n\n    if (element) {\n\n      if (anyType) {\n        if (isAny(element, anyType)) {\n          parents.push(element);\n        }\n      }\n      else {\n        parents.push(element);\n      }\n\n    }\n\n  }\n\n  return parents;\n}\n\nmodule.exports.getParents = getParents;\n\n/**\n * Return the parent of the element with any of the given types.\n *\n * @param {ModdleElement} element\n * @param {String|Array<String>} anyType\n *\n * @return {ModdleElement}\n */\nfunction getParent(element, anyType) {\n\n  if (typeof anyType === 'string') {\n    anyType = [ anyType ];\n  }\n\n  while ((element = element.$parent || element.parent)) {\n    if (anyType) {\n      if (isAny(element, anyType)) {\n        return element;\n      }\n    }\n    else {\n      return element;\n    }\n  }\n\n  return null;\n}\n\nmodule.exports.getParent = getParent;\n\n\n/**\n * Return true if element has any of the given types.\n *\n * @param {djs.model.Base} element\n * @param {Array<String>} types\n *\n * @return {Boolean}\n */\nfunction isAny(element, types) {\n  return some(types, function(t) {\n    return is(element, t);\n  });\n}\n\nmodule.exports.isAny = isAny;\n\n\nfunction isLabel(element) {\n  return element instanceof Model.Label;\n}\n\nmodule.exports.isLabel = isLabel;\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js?")},"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    getDefinition = ModelUtil.getDefinition,\n    getBusinessObject = ModelUtil.getBusinessObject;\n\nvar isAny = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isAny),\n    getParent = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").getParent);\n\nvar eachElement = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\")/* .eachElement */ .om);\n\n\n/**\n * Returns all contained discretionary items.\n *\n * @param {ModdleElement} element\n *\n * @return {Array<ModdleElement>} all discretionary items\n */\nfunction getAllDiscretionaryItems(element) {\n\n  element = getBusinessObject(element);\n\n  if (isItemCapable(element)) {\n    element = getDefinition(element);\n  }\n\n  var result = [];\n\n  if (isPlanningTableCapable(element)) {\n    element = element.planningTable;\n\n    if (element) {\n\n      var items = element.get('tableItems');\n      eachElement(items, function(item) {\n        if (isDiscretionaryItem(item)) {\n          result.push(item);\n        }\n        else {\n          return item.get('tableItems');\n        }\n      });\n    }\n  }\n\n  return result;\n}\n\nmodule.exports.getAllDiscretionaryItems = getAllDiscretionaryItems;\n\n\n/**\n * Returns all directed item capables elements of the given element.\n *\n * @param {ModdleElement} element\n *\n * @return {Array<ModdleElement>} all direct item capables\n */\nfunction getDirectItemCapables(element) {\n\n  element = getBusinessObject(element);\n\n  if (isItemCapable(element)) {\n    element = getDefinition(element);\n  }\n\n  var result = [];\n\n  function add(item) {\n    result.push(item);\n  }\n\n  if (element) {\n\n    var items;\n\n    if (is(element, 'cmmn:PlanFragment')) {\n      items = element.get('planItems');\n      eachElement(items, add);\n    }\n\n    if (isPlanningTableCapable(element)) {\n      items = getAllDiscretionaryItems(element);\n      eachElement(items, add);\n    }\n\n  }\n\n  return result;\n}\n\nmodule.exports.getDirectItemCapables = getDirectItemCapables;\n\n\n/**\n * Returns true if the given element is either a discretionary item\n * or a plan item\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean} when it is a discretionary item or a plan item\n */\nfunction isItemCapable(element) {\n  return isAny(element, [ 'cmmn:DiscretionaryItem', 'cmmn:PlanItem' ]);\n}\n\nmodule.exports.isItemCapable = isItemCapable;\n\n\n/**\n * Returns true if the given element is either a human task or\n * a stage.\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean} when it is a human task or stage\n */\nfunction isPlanningTableCapable(element) {\n  return isAny(element, [ 'cmmn:HumanTask', 'cmmn:Stage' ]);\n}\n\nmodule.exports.isPlanningTableCapable = isPlanningTableCapable;\n\n\n/**\n * Returns true if the given element is a discretionary item.\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean} when it is a discretionary item\n */\nfunction isDiscretionaryItem(element) {\n  return is(element, 'cmmn:DiscretionaryItem');\n}\n\nmodule.exports.isDiscretionaryItem = isDiscretionaryItem;\n\n\n/**\n * Returns true if the given element is a discretionary to a human task.\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean} when it is discretionary to a human task\n */\nfunction isDiscretionaryToHumanTask(element) {\n  var bo = getBusinessObject(element);\n  var parent = getParent(bo, 'cmmn:PlanItemDefinition');\n  return is(parent, 'cmmn:HumanTask');\n}\n\nmodule.exports.isDiscretionaryToHumanTask = isDiscretionaryToHumanTask;\n\n\n/**\n * Returns true if the given element is a human task.\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean} when it is a human task\n */\nfunction isHumanTask(element) {\n  return is(element, 'cmmn:HumanTask');\n}\n\nmodule.exports.isHumanTask = isHumanTask;\n\n\n/**\n * Returns true if the given element is a plan fragment and not\n * a stage.\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean} when it is a plan fragment\n */\nfunction isPlanFragment(element) {\n  return is(element, 'cmmn:PlanFragment') && !is(element, 'cmmn:Stage');\n}\n\nmodule.exports.isPlanFragment = isPlanFragment;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js?")},"./node_modules/cmmn-js/lib/features/ordering/CmmnOrderingProvider.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar OrderingProvider = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/ordering/OrderingProvider.js\")/* [\"default\"] */ .Z);\nvar findIndex = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .findIndex */ .cx);\nvar find = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .find */ .sE);\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is);\nvar isAny = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isAny);\n\nfunction CmmnOrderingProvider(eventBus) {\n\n  OrderingProvider.call(this, eventBus);\n\n  var orders = [\n    { type: 'label', order: { level: 10 } },\n    { type: 'cmmn:Criterion', order: { level: 6 } },\n    {\n      type: 'cmmn:OnPart',\n      order: {\n        level: 9,\n        containers: [\n          'cmmn:Stage'\n        ]\n      }\n    },\n    {\n      type: 'cmmn:Association',\n      order: {\n        level: 9,\n        containers: [\n          'cmmndi:CMMNDiagram'\n        ]\n      }\n    },\n    {\n      type: 'cmmndi:CMMNEdge',\n      order: {\n        level: 9,\n        containers: [\n          'cmmn:PlanItem',\n          'cmmn:DiscretionaryItem',\n          'cmmn:Stage'\n        ]\n      }\n    }\n  ];\n\n  function computeOrder(element) {\n\n    if (isCMMNEdge(element)) {\n      element = element.businessObject.cmmnElementRef || element;\n    }\n\n    var entry = find(orders, function(o) {\n      return is(element, o.type);\n    });\n\n    return entry && entry.order || { level: 1 };\n  }\n\n  function getOrder(element) {\n\n    var order = element.order;\n\n    if (!order) {\n      element.order = order = computeOrder(element);\n    }\n\n    return order;\n  }\n\n  function findActualParent(element, newParent, containers) {\n\n    var actualParent = newParent;\n\n    if (isCMMNEdge(element) && element.source) {\n      actualParent = element.source.parent;\n    }\n\n    while (actualParent) {\n\n      if (isAny(actualParent, containers)) {\n        break;\n      }\n\n      actualParent = actualParent.parent;\n    }\n\n    if (!actualParent) {\n      throw new Error('no parent for ' + element.id + ' in ' + newParent.id);\n    }\n\n    return actualParent;\n  }\n\n  this.getOrdering = function(element, newParent) {\n\n    var elementOrder = getOrder(element);\n\n    if (elementOrder.containers) {\n      newParent = findActualParent(element, newParent, elementOrder.containers);\n    }\n\n    var currentIndex = newParent.children.indexOf(element);\n\n    var insertIndex = findIndex(newParent.children, function(child) {\n\n      // do not compare with labels, they are created\n      // in the wrong order (right after elements) during import and\n      // mess up the positioning.\n      if (!element.labelTarget && child.labelTarget) {\n        return false;\n      }\n\n      return elementOrder.level < getOrder(child).level;\n    });\n\n\n    // if the element is already in the child list at\n    // a smaller index, we need to adjust the insert index.\n    // this takes into account that the element is being removed\n    // before being re-inserted\n    if (insertIndex !== -1) {\n      if (currentIndex !== -1 && currentIndex < insertIndex) {\n        insertIndex -= 1;\n      }\n    }\n\n    return {\n      index: insertIndex,\n      parent: newParent\n    };\n\n  };\n}\n\nCmmnOrderingProvider.$inject = [ 'eventBus' ];\n\ninherits(CmmnOrderingProvider, OrderingProvider);\n\nmodule.exports = CmmnOrderingProvider;\n\nfunction isCMMNEdge(element) {\n  return is(element, 'cmmndi:CMMNEdge');\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/ordering/CmmnOrderingProvider.js?")},"./node_modules/cmmn-js/lib/features/ordering/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("module.exports = {\n  __init__: [ 'cmmnOrderingProvider' ],\n  cmmnOrderingProvider: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/ordering/CmmnOrderingProvider.js\") ]\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/ordering/index.js?")},"./node_modules/cmmn-js/lib/features/outline/Outline.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar BaseOutline = (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/Outline.js")/* ["default"] */ .Z);\n\nvar inherits = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n\nvar isCasePlanModel = (__webpack_require__("./node_modules/cmmn-js/lib/util/ModelUtil.js").isCasePlanModel);\n\nvar svgAttr = (__webpack_require__("./node_modules/tiny-svg/dist/index.esm.js")/* .attr */ .Lj);\n\n\n/**\n * This is a subclass of the Outline module from diagram-js.\n * It defines outlines which differ from the element size basis.\n *\n * @param {EventBus} eventBus\n * @param {Styles} styles\n * @param {ElementRegistry} elementRegistry\n */\nfunction Outline(eventBus, styles, elementRegistry) {\n  BaseOutline.call(this, eventBus, styles, elementRegistry);\n}\n\ninherits(Outline, BaseOutline);\n\nOutline.$inject = [ \'eventBus\', \'styles\', \'elementRegistry\' ];\n\nOutline.prototype.baseUpdateShapeOutline = BaseOutline.prototype.updateShapeOutline;\n\nOutline.prototype.updateShapeOutline = function(outline, element) {\n\n  if (!isCasePlanModel(element)) {\n\n    this.baseUpdateShapeOutline(outline, element);\n  } else {\n\n    // update outlines for casePlanModels\n    svgAttr(outline, {\n      x: -this.offset,\n      y: -this.offset - 18,\n      width: element.width + this.offset * 2,\n      height: element.height + 18 + this.offset * 2\n    });\n  }\n};\n\nmodule.exports = Outline;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/outline/Outline.js?')},"./node_modules/cmmn-js/lib/features/outline/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nmodule.exports = {\n  __init__: [ 'outline' ],\n  outline: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/outline/Outline.js\") ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/outline/index.js?")},"./node_modules/cmmn-js/lib/features/palette/PaletteProvider.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0);\n\n/**\n * A palette provider for CMMN 1.1 elements.\n */\nfunction PaletteProvider(\n    create,\n    elementFactory,\n    globalConnect,\n    handTool,\n    lassoTool,\n    palette,\n    spaceTool\n) {\n\n  this._create = create;\n  this._elementFactory = elementFactory;\n  this._globalConnect = globalConnect;\n  this._handTool = handTool;\n  this._palette = palette;\n  this._lassoTool = lassoTool;\n  this._spaceTool = spaceTool;\n\n  palette.registerProvider(this);\n}\n\nmodule.exports = PaletteProvider;\n\nPaletteProvider.$inject = [\n  'create',\n  'elementFactory',\n  'globalConnect',\n  'handTool',\n  'lassoTool',\n  'palette',\n  'spaceTool'\n];\n\n\nPaletteProvider.prototype.getPaletteEntries = function(element) {\n\n  var actions = {},\n      create = this._create,\n      elementFactory = this._elementFactory,\n      spaceTool = this._spaceTool,\n      lassoTool = this._lassoTool,\n      globalConnect = this._globalConnect,\n      handTool = this._handTool;\n\n  function createPlanItem(type, group, className, title) {\n\n    function createListener(event) {\n      create.start(event, elementFactory.createPlanItemShape(type));\n    }\n\n    var shortType = type.replace(/^cmmn:/, '');\n\n    return {\n      group: group,\n      className: className,\n      title: title || 'Create ' + shortType,\n      action: {\n        dragstart: createListener,\n        click: createListener\n      }\n    };\n  }\n\n  function createCasePlanModel(event) {\n    create.start(event, elementFactory.createCasePlanModelShape());\n  }\n\n  function createCriterion(event) {\n    create.start(event, elementFactory.createCriterionShape('cmmn:EntryCriterion'));\n  }\n\n  function createCaseFileItem(event) {\n    create.start(event, elementFactory.createCaseFileItemShape());\n  }\n\n  assign(actions, {\n    'hand-tool': {\n      group: 'tools',\n      className: 'cmmn-icon-hand-tool',\n      title: 'Activate the hand tool',\n      action: {\n        click: function(event) {\n          handTool.activateHand(event);\n        }\n      }\n    },\n    'lasso-tool': {\n      group: 'tools',\n      className: 'cmmn-icon-lasso-tool',\n      title: 'Activate the lasso tool',\n      action: {\n        click: function(event) {\n          lassoTool.activateSelection(event);\n        }\n      }\n    },\n    'space-tool': {\n      group: 'tools',\n      className: 'cmmn-icon-space-tool',\n      title: 'Activate the create/remove space tool',\n      action: {\n        click: function(event) {\n          spaceTool.activateSelection(event);\n        }\n      }\n    },\n    'global-connect-tool': {\n      group: 'tools',\n      className: 'cmmn-icon-connection',\n      title: 'Activate the global connect tool',\n      action: {\n        click: function(event) {\n          globalConnect.toggle(event);\n        }\n      }\n    },\n    'tool-separator': {\n      group: 'tools',\n      separator: true\n    },\n    'create.task': createPlanItem(\n      'cmmn:Task', 'planItem', 'cmmn-icon-task'\n    ),\n    'create.stage': createPlanItem(\n      'cmmn:Stage', 'planItem', 'cmmn-icon-stage-expanded', 'Create expanded Stage'\n    ),\n    'create.milestone': createPlanItem(\n      'cmmn:Milestone', 'planItem', 'cmmn-icon-milestone'\n    ),\n    'create.eventListener': createPlanItem(\n      'cmmn:EventListener', 'planItem', 'cmmn-icon-event-listener'\n    ),\n    'create.criterion': {\n      group: 'criterion',\n      className: 'cmmn-icon-entry-criterion',\n      title: 'Create Criterion',\n      action: {\n        dragstart: createCriterion,\n        click: createCriterion\n      }\n    },\n    'create.casePlanModel': {\n      group: 'casePlanModel',\n      className: 'cmmn-icon-case-plan-model',\n      title: 'Create CasePlanModel',\n      action: {\n        dragstart: createCasePlanModel,\n        click: createCasePlanModel\n      }\n    },\n    'create.caseFileItem': {\n      group: 'caseFileItem',\n      className: 'cmmn-icon-case-file-item',\n      title: 'Create Case File Item',\n      action: {\n        dragstart: createCaseFileItem,\n        click: createCaseFileItem\n      }\n    }\n\n  });\n\n  return actions;\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/palette/PaletteProvider.js?")},"./node_modules/cmmn-js/lib/features/palette/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __depends__: [\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/palette/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/create/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/lasso-tool/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/hand-tool/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/global-connect/index.js")/* ["default"] */ .Z)\n  ],\n  __init__: [ \'paletteProvider\' ],\n  paletteProvider: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/palette/PaletteProvider.js") ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/palette/index.js?')},"./node_modules/cmmn-js/lib/features/popup-menu/ReplaceMenuProvider.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed),\n    filter = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .filter */ .hX);\n\nvar replaceOptions = __webpack_require__(\"./node_modules/cmmn-js/lib/features/replace/ReplaceOptions.js\");\n\nvar isItemCapable = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js\").isItemCapable);\n\nvar isAny = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\").isAny);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    getBusinessObject = ModelUtil.getBusinessObject,\n    getDefinition = ModelUtil.getDefinition,\n    isCasePlanModel = ModelUtil.isCasePlanModel,\n    isRequired = ModelUtil.isRequired,\n    isRepeatable = ModelUtil.isRepeatable,\n    isManualActivation = ModelUtil.isManualActivation,\n    is = ModelUtil.is;\n\nvar isCollapsed = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/DiUtil.js\").isCollapsed);\n\n\n/**\n * Returns true, if an element is from a different type.\n * discretionary / non discretionary\n *\n * @param {djs.model.Base} element\n * @param {Object} entry\n *\n * @return {Boolean}\n */\nfunction isDifferentType(element, entry) {\n\n  var businessObject = getBusinessObject(element);\n\n  return businessObject.$type !== entry.target.type;\n}\n\n\n/**\n * Returns true if the definition type is different.\n * e.g. process task / human task\n *\n * @param {djs.model.Base} element\n * @param {Object} entry\n *\n * @return {Boolean}\n */\nfunction isDifferentDefinitionType(element, entry) {\n\n  return getDefinition(element).$type !== entry.target.definitionType;\n}\n\n\nfunction canReplaceElementByTarget(element, target) {\n\n  var type = target.type,\n      definitionType = target.definitionType,\n      parent = element.parent,\n      definition = getDefinition(element);\n\n  if (isPlanItem(element)) {\n    if (type === 'cmmn:DiscretionaryItem' && !isStage(parent)) {\n      return false;\n    }\n  }\n\n  if (definitionType === 'cmmn:HumanTask') {\n\n    if (isPlanFragment(element) && !target.isBlocking) {\n      return false;\n    }\n\n    if (isTask(element) && definition.isBlocking !== target.isBlocking) {\n      return false;\n    }\n\n  }\n\n  return true;\n\n}\n\n\n/**\n * This module is an element agnostic replace menu provider for the popup menu.\n */\nfunction ReplaceMenuProvider(popupMenu, cmmnReplace, cmmnFactory, modeling, rules) {\n\n  this._popupMenu = popupMenu;\n  this._cmmnReplace = cmmnReplace;\n  this._cmmnFactory = cmmnFactory;\n  this._modeling = modeling;\n  this._rules = rules;\n\n  this.register();\n}\n\nReplaceMenuProvider.$inject = [ 'popupMenu', 'cmmnReplace', 'cmmnFactory', 'modeling', 'rules' ];\n\n\n/**\n * Register replace menu provider in the popup menu\n */\nReplaceMenuProvider.prototype.register = function() {\n  this._popupMenu.registerProvider('cmmn-replace', this);\n};\n\n\n/**\n * Get all entries from replaceOptions for the given element and apply filters\n * on them. Get for example only elements, which are different from the current one.\n *\n * @param {djs.model.Base} element\n *\n * @return {Array<Object>} a list of menu entry items\n */\nReplaceMenuProvider.prototype.getEntries = function(element) {\n\n  var rules = this._rules;\n\n  var entries,\n      definition = getDefinition(element);\n\n\n  if (!rules.allowed('shape.replace', { element: element })) {\n    return [];\n  }\n\n\n  if (isItemCapable(element)) {\n\n    if (isTask(element)) {\n\n      entries = filter(replaceOptions.TASK, function(entry) {\n\n        var target = entry.target;\n\n        if (canReplaceElementByTarget(element, target)) {\n\n          // ^ === XOR\n          // returns true if and only of EITHER the type OR the definition type is different\n          return isDifferentType(element, entry) ^ isDifferentDefinitionType(element, entry);\n        }\n      });\n\n      return this._createEntries(element, entries);\n    }\n\n    if (isPlanFragment(element)) {\n\n      if (!isCollapsed(element)) {\n\n        entries = filter(replaceOptions.PLAN_FRAGMENT_EXPANDED, function(entry) {\n\n          var target = entry.target;\n\n          if (canReplaceElementByTarget(element, target)) {\n\n            // returns true if the type or the definition type is different (or both)\n            return isDifferentType(element, entry) || isDifferentDefinitionType(element, entry);\n          }\n        });\n\n        return this._createEntries(element, entries);\n      }\n\n      if (isCollapsed(element)) {\n\n        entries = filter(replaceOptions.TASK, function(entry) {\n\n          var target = entry.target,\n              definitionType = target.definitionType;\n\n          if (!canReplaceElementByTarget(element, target)) {\n            return false;\n          }\n\n          if (definitionType === definition.$type && !target.isCollapsed) {\n            return true;\n          }\n\n          // ^ === XOR\n          // returns true if and only of EITHER the type OR the definition type is different\n          return isDifferentType(element, entry) ^ isDifferentDefinitionType(element, entry);\n\n        });\n\n        return this._createEntries(element, entries);\n\n      }\n\n    }\n\n    if (isEventListener(element)) {\n\n      entries = filter(replaceOptions.EVENT_LISTENER, function(entry) {\n        return isDifferentDefinitionType(element, entry);\n      });\n\n      return this._createEntries(element, entries);\n    }\n\n  }\n\n\n  if (isCriterion(element)) {\n\n    entries = filter(replaceOptions.CRITERION, function(entry) {\n      return isDifferentType(element, entry);\n    });\n\n    return this._createEntries(element, entries);\n  }\n\n  return [];\n\n};\n\n\nReplaceMenuProvider.prototype.getHeaderEntries = function(element) {\n\n  var headerEntries = [];\n\n  if (isTask(element)) {\n    headerEntries = headerEntries.concat(this._getBlockingEntry(element));\n  }\n\n  if (isStage(element)) {\n    headerEntries = headerEntries.concat(this._getAutoCompleteEntry(element));\n  }\n\n  if (ensureSupportRules(element)) {\n    headerEntries = headerEntries.concat(this._getRuleEntries(element));\n  }\n\n  return headerEntries;\n\n};\n\n/**\n * Creates an array of menu entry objects for a given element and filters the replaceOptions\n * according to a filter function.\n *\n * @param  {djs.model.Base} element\n * @param  {Object} replaceOptions\n *\n * @return {Array<Object>} a list of menu items\n */\nReplaceMenuProvider.prototype._createEntries = function(element, replaceOptions) {\n  var menuEntries = [];\n\n  var self = this;\n\n  forEach(replaceOptions, function(definition) {\n    var entry = self._createMenuEntry(definition, element);\n\n    menuEntries.push(entry);\n  });\n\n  return menuEntries;\n};\n\n\n/**\n * Creates and returns a single menu entry item.\n *\n * @param  {Object} definition a single replace options definition object\n * @param  {djs.model.Base} element\n * @param  {Function} [action] an action callback function which gets called when\n *                             the menu entry is being triggered.\n *\n * @return {Object} menu entry item\n */\nReplaceMenuProvider.prototype._createMenuEntry = function(definition, element, action) {\n\n  var replaceElement = this._cmmnReplace.replaceElement;\n\n  var replaceAction = function() {\n    return replaceElement(element, definition.target);\n  };\n\n  action = action || replaceAction;\n\n  var menuEntry = {\n    label: definition.label,\n    className: definition.className,\n    id: definition.actionName,\n    action: action\n  };\n\n  return menuEntry;\n};\n\n\nReplaceMenuProvider.prototype._getBlockingEntry = function(element) {\n\n  var self = this;\n\n  var definition = getDefinition(element);\n\n  function toggleBlockingEntry(event, entry) {\n    var blocking = !entry.active;\n    self._modeling.updateControls(element, { isBlocking: blocking });\n  }\n\n  var isBlocking = definition.isBlocking;\n  var entries = [\n    {\n      id: 'toggle-is-blocking',\n      className: 'cmmn-icon-blocking',\n      title: 'Blocking',\n      active: isBlocking,\n      action: toggleBlockingEntry\n    }\n  ];\n\n  return entries;\n};\n\n\nReplaceMenuProvider.prototype._getAutoCompleteEntry = function(element) {\n\n  var self = this;\n\n  var definition = getDefinition(element);\n\n  function toggleAutoCompleteEntry(event, entry) {\n    var autoComplete = !entry.active;\n    self._modeling.updateControls(element, { autoComplete: autoComplete });\n  }\n\n  var isAutoComplete = definition.autoComplete;\n  var entries = [\n    {\n      id: 'toggle-auto-complete',\n      className: 'cmmn-icon-auto-complete-marker',\n      title: 'Auto Complete',\n      active: isAutoComplete,\n      action: toggleAutoCompleteEntry\n    }\n  ];\n\n  return entries;\n};\n\n\nReplaceMenuProvider.prototype._getRuleEntries = function(element) {\n\n  var self = this;\n\n  function toggleControlEntry(control, type) {\n\n    return function(event, entry) {\n\n      var value = {};\n\n      if (entry.active) {\n        value[control] = undefined;\n      }\n      else {\n        value[control] = self._cmmnFactory.create(type);\n      }\n\n      self._modeling.updateControls(element, value);\n    };\n\n  }\n\n  var repeatable = isRepeatable(element),\n      required = isRequired(element),\n      manualActivation = isManualActivation(element);\n\n  var entries = [\n    {\n      id: 'toggle-required-rule',\n      className: 'cmmn-icon-required-marker',\n      title: 'Required Rule',\n      active: required,\n      action: toggleControlEntry('requiredRule', 'cmmn:RequiredRule')\n    }\n  ];\n\n  if (!isMilestone(element)) {\n\n    entries.push({\n      id: 'toggle-manual-activation-rule',\n      className: 'cmmn-icon-manual-activation-marker',\n      title: 'Manual Activation Rule',\n      active: manualActivation,\n      action: toggleControlEntry('manualActivationRule', 'cmmn:ManualActivationRule')\n    });\n\n  }\n\n  entries.push({\n    id: 'toggle-repetition-rule',\n    className: 'cmmn-icon-repetition-marker',\n    title: 'Repetition Rule',\n    active: repeatable,\n    action: toggleControlEntry('repetitionRule', 'cmmn:RepetitionRule')\n  });\n\n  return entries;\n};\n\nmodule.exports = ReplaceMenuProvider;\n\n\nfunction ensureSupportRules(element) {\n\n  var definition = getDefinition(element);\n\n  return !isCasePlanModel(element) && isAny(definition, [\n    'cmmn:Stage',\n    'cmmn:Milestone',\n    'cmmn:Task'\n  ]);\n}\n\nfunction isPlanFragment(element) {\n  return is(getDefinition(element), 'cmmn:PlanFragment');\n}\n\nfunction isStage(element) {\n  return is(getDefinition(element), 'cmmn:Stage');\n}\n\nfunction isEventListener(element) {\n  return is(getDefinition(element), 'cmmn:EventListener');\n}\n\nfunction isMilestone(element) {\n  return is(getDefinition(element), 'cmmn:Milestone');\n}\n\nfunction isTask(element) {\n  return is(getDefinition(element), 'cmmn:Task');\n}\n\nfunction isCriterion(element) {\n  return is(element, 'cmmn:Criterion');\n}\n\nfunction isPlanItem(element) {\n  return is(element, 'cmmn:PlanItem');\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/popup-menu/ReplaceMenuProvider.js?")},"./node_modules/cmmn-js/lib/features/popup-menu/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("module.exports = {\n  __init__: [ 'replaceMenuProvider' ],\n  replaceMenuProvider: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/features/popup-menu/ReplaceMenuProvider.js\") ]\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/popup-menu/index.js?")},"./node_modules/cmmn-js/lib/features/replace-preview/CmmnReplacePreview.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar CommandInterceptor = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\")/* [\"default\"] */ .Z);\n\nvar cssEscape = __webpack_require__(\"./node_modules/css.escape/css.escape.js\");\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0),\n    forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed);\n\nvar getVisual = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/GraphicsUtil.js\")/* .getVisual */ .s);\n\nvar isItemCapable = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js\").isItemCapable);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    getBusinessObject = ModelUtil.getBusinessObject,\n    getDefinition = ModelUtil.getDefinition;\n\nvar domQuery = (__webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\")/* .query */ .IO);\n\nvar svgAppend = (__webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\")/* .append */ .R3),\n    svgClasses = (__webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\")/* .classes */ .Sh),\n    svgCreate = (__webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\")/* .create */ .Ue),\n    svgRemove = (__webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\")/* .remove */ .Od);\n\nvar LOW_PRIORITY = 250;\n\nfunction CmmnReplacePreview(\n    cmmnReplace,\n    cmmnRules,\n    elementFactory,\n    elementRegistry,\n    eventBus,\n    graphicsFactory\n) {\n\n  CommandInterceptor.call(this, eventBus);\n\n\n  function createShape(element, replacement) {\n\n    var newElement = {\n      type: replacement.newElementType,\n      x: element.x,\n      y: element.y,\n      width: element.width,\n      height: element.height\n    };\n\n    if (isItemCapable(element)) {\n\n      var bo = getBusinessObject(element),\n          definition = getDefinition(element),\n          newElementType = replacement.newElementType,\n          newDefinitionType = replacement.newDefinitionType,\n          replaceCandidate;\n\n      if (newDefinitionType) {\n        definition = cmmnReplace.replacePlanItemDefinition(definition, newDefinitionType);\n      }\n\n      replaceCandidate = cmmnReplace.replaceItemCapable(bo, newElementType, definition);\n\n      assign(newElement, {\n        businessObject: replaceCandidate\n      });\n    }\n\n    return elementFactory.createShape(newElement);\n  }\n\n\n  function initVisualReplacements(context) {\n    if (!context.visualReplacements) {\n      context.visualReplacements = {};\n    }\n    return context.visualReplacements;\n  }\n\n\n  function canReplace(event) {\n    var context = event.context,\n        canExecute = context.canExecute || context.allowed;\n\n    if (canExecute === 'attach') {\n      var position = context.position || { x: event.x, y: event.y },\n          shapes = context.shapes || [ context.shape ],\n          target = context.target;\n\n      canExecute = cmmnRules.canReplace(shapes, target, position, context.source);\n    }\n\n\n    return canExecute;\n  }\n\n\n  /**\n   * Replace the visuals to the given shape\n   */\n  function replaceVisualGraphics(gfx, shape) {\n\n    var visual = gfx && getVisual(gfx);\n\n    if (visual) {\n      svgRemove(visual);\n\n      visual = svgCreate('g');\n      svgClasses(visual).add('djs-visual');\n\n      svgAppend(gfx, visual);\n\n      graphicsFactory.drawShape(visual, shape);\n    }\n\n  }\n\n\n  function replaceVisual(context, replacements, gfxSelector) {\n\n    forEach(replacements, function(replacement) {\n\n      var id = replacement.oldElementId,\n          shape = elementRegistry.get(id) || context.shape;\n\n      // if the visual of the element is already replaced\n      if (context.visualReplacements[id]) {\n        return;\n      }\n\n      // create a temporary shape\n      var tempShape = createShape(shape, replacement);\n\n      // select the original SVG element related to the element and hide it\n      var gfx = gfxSelector(shape);\n\n      replaceVisualGraphics(gfx, tempShape);\n      context.visualReplacements[id] = shape;\n\n    });\n\n  }\n\n  function restoreVisual(context, gfxSelector) {\n\n    var visualReplacements = context.visualReplacements;\n\n    forEach(visualReplacements, function(shape, id) {\n\n      var gfx = gfxSelector(shape);\n      replaceVisualGraphics(gfx, shape);\n\n      delete visualReplacements[id];\n\n    });\n  }\n\n\n  eventBus.on([ 'shape.move.move', 'create.move' ], LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        dragGroup = context.dragGroup,\n        visual = context.visual,\n        canExecute = canReplace(event),\n        replacements = canExecute && canExecute.replacements;\n\n    initVisualReplacements(context);\n\n    var getGfx = function(shape) {\n      var selector,\n          gfx;\n\n      if (dragGroup) {\n        selector = '[data-element-id=\"' + cssEscape(shape.id) + '\"]';\n        gfx = dragGroup;\n      }\n      else if (visual) {\n        selector = '.djs-dragger';\n        gfx = visual;\n      }\n\n      return gfx && domQuery(selector, gfx);\n    };\n\n    if (replacements && replacements.length) {\n      replaceVisual(context, replacements, getGfx);\n    }\n    else {\n      restoreVisual(context, getGfx);\n    }\n\n  });\n\n\n  eventBus.on([\n    'bendpoint.move.move',\n    'connect.move'\n  ], LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        canExecute = canReplace(event),\n        replacements = canExecute && canExecute.replacements;\n\n    initVisualReplacements(context);\n\n    if (replacements && replacements.length) {\n      replaceVisual(context, replacements, function(shape) {\n        return elementRegistry.getGraphics(shape);\n      });\n    }\n\n  });\n\n\n  eventBus.on([\n    'bendpoint.move.cancel',\n    'bendpoint.move.cleanup',\n    'bendpoint.move.end',\n    'bendpoint.move.out',\n    'connect.cleanup',\n    'connect.end',\n    'connect.out'\n  ], LOW_PRIORITY, function(event) {\n\n    var context = event.context;\n\n    restoreVisual(context, function(shape) {\n      return elementRegistry.getGraphics(shape);\n    });\n\n  });\n\n}\n\nCmmnReplacePreview.$inject = [\n  'cmmnReplace',\n  'cmmnRules',\n  'elementFactory',\n  'elementRegistry',\n  'eventBus',\n  'graphicsFactory'\n];\n\ninherits(CmmnReplacePreview, CommandInterceptor);\n\nmodule.exports = CmmnReplacePreview;\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/replace-preview/CmmnReplacePreview.js?")},"./node_modules/cmmn-js/lib/features/replace-preview/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __depends__: [\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/move/index.js")/* ["default"] */ .Z)\n  ],\n  __init__: [\'cmmnReplacePreview\'],\n  cmmnReplacePreview: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/replace-preview/CmmnReplacePreview.js") ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/replace-preview/index.js?')},"./node_modules/cmmn-js/lib/features/replace/CmmnReplace.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    getDefinition = ModelUtil.getDefinition,\n    isAutoComplete = ModelUtil.isAutoComplete;\n\nvar isCollapsed = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/DiUtil.js\").isCollapsed),\n    isPlanningTableCollapsed = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/DiUtil.js\").isPlanningTableCollapsed);\n\nvar isPlanningTableCapable = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js\").isPlanningTableCapable);\nvar isItemCapable = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js\").isItemCapable);\n\n/**\n * This module takes care of replacing CMMN elements\n */\nfunction CmmnReplace(cmmnFactory, replace, selection, cmmnRules) {\n\n  /**\n   * Prepares a new business object for the replacement element\n   * and triggers the replace operation.\n   *\n   * @param  {djs.model.Base} element\n   * @param  {Object} target\n   * @param  {Object} [hints]\n   *\n   * @return {djs.model.Base} the newly created element\n   */\n  function replaceElement(element, target, hints) {\n\n    hints = hints || {};\n\n    var type = target.type,\n        oldBusinessObject = element.businessObject,\n        newBusinessObject;\n\n\n    // TODO: need also to respect min/max Size\n    var newElement = {\n      type: type\n    };\n\n    if (isCriterion(oldBusinessObject)) {\n      newBusinessObject = replaceCriterion(oldBusinessObject, type);\n    }\n\n\n    if (isItemCapable(oldBusinessObject)) {\n\n      var oldDefinition = getDefinition(oldBusinessObject),\n          definitionType = target.definitionType,\n          newDefinition = oldDefinition;\n\n\n      // replace plan item definition if necessary\n      if (oldDefinition.$type !== definitionType) {\n        newDefinition = replacePlanItemDefinition(oldDefinition, definitionType);\n      }\n\n\n      // replace plan/discretionary item\n      newBusinessObject = replaceItemCapable(oldBusinessObject, type, newDefinition);\n\n\n      // handle isCollapsed property\n      if (isPlanFragment(oldDefinition) && isPlanFragment(newDefinition) && target.isCollapsed !== false) {\n        newElement.isCollapsed = isCollapsed(oldBusinessObject);\n      }\n\n\n      // switch collapsed/expanded plan fragment\n      if (isTask(oldDefinition) && target.isCollapsed === true) {\n        newElement.isCollapsed = true;\n      }\n\n      if (isTask(newDefinition) && target.isBlocking === false) {\n        newElement.isBlocking = false;\n      }\n\n\n      // handle isPlanningTableCollapsed property\n      if (isPlanningTableCapable(oldDefinition) && isPlanningTableCapable(newDefinition)) {\n        newElement.isPlanningTableCollapsed = isPlanningTableCollapsed(oldBusinessObject);\n      }\n\n\n      // handle autoComplete property\n      if (isStage(oldDefinition) && isStage(newDefinition)) {\n        newElement.autoComplete = isAutoComplete(oldBusinessObject);\n      }\n\n\n      // TODO: need also to respect min/max Size\n      // copy size, from an expanded plan fragment to an expanded alternative plan fragment\n      // except cmmn:Task, because Task is always expanded\n      if (!isCollapsed(oldBusinessObject) && !target.isCollapsed && !isTask(oldDefinition)) {\n        newElement.width = element.width;\n        newElement.height = element.height;\n      }\n    }\n\n    // create new business object if necessary\n    newElement.businessObject = newBusinessObject || cmmnFactory.create(type);\n\n    // trigger replacement\n    newElement = replace.replaceElement(element, newElement, hints);\n\n\n    if (hints.select !== false) {\n      selection.select(newElement);\n    }\n\n    return newElement;\n  }\n\n  this.replaceElement = replaceElement;\n\n\n  function replaceCriterion(criterion, type) {\n\n    var newCriterion;\n\n    if (criterion) {\n\n      type = type || criterion.$type;\n\n      newCriterion = cmmnFactory.createCriterion(type, {\n        sentryRef: criterion.sentryRef,\n        name: criterion.name\n      });\n\n    }\n\n    return newCriterion;\n\n  }\n\n  this.replaceCriterion = replaceCriterion;\n\n\n  function replaceSentry(sentry) {\n\n    var newSentry;\n\n    if (sentry) {\n\n      newSentry = cmmnFactory.createSentry({\n        name: sentry.name\n      });\n\n      if (sentry.ifPart) {\n\n        var newIfPart = cmmnFactory.create('cmmn:IfPart');\n        setParent(newIfPart, newSentry);\n        newSentry.ifPart = newIfPart;\n\n        var condition = replaceCondition(sentry.ifPart.condition);\n        setParent(condition, newIfPart);\n        newIfPart.condition = condition;\n\n      }\n\n    }\n\n    return newSentry;\n  }\n\n  this.replaceSentry = replaceSentry;\n\n\n  function replacePlanItemDefinition(definition, type) {\n\n    type = type || definition.$type;\n\n    var newDefinition = cmmnFactory.create(type, {\n      name: definition.name\n    });\n\n    if (isPlanItemControlCapable(newDefinition) && definition.defaultControl) {\n\n      var defaultControl = replacePlanItemControl(definition.defaultControl, newDefinition);\n\n      setParent(defaultControl, newDefinition);\n      newDefinition.defaultControl = defaultControl;\n\n    }\n\n    if (isStage(newDefinition) && definition.autoComplete) {\n      newDefinition.autoComplete = definition.autoComplete;\n    }\n\n    if (isTask(definition) && isTask(newDefinition)) {\n      newDefinition.isBlocking = definition.isBlocking;\n    }\n\n    return newDefinition;\n\n  }\n\n  this.replacePlanItemDefinition = replacePlanItemDefinition;\n\n\n  function replaceItemCapable(item, type, definition) {\n\n    type = type || item.$type;\n    definition = definition || getDefinition(item);\n\n    var newItem = cmmnFactory.create(type, {\n      name: item.name,\n      definitionRef: definition\n    });\n\n    if (isPlanItemControlCapable(newItem) && item.itemControl) {\n\n      var itemControl = replacePlanItemControl(item.itemControl, newItem);\n\n      setParent(itemControl, newItem);\n      newItem.itemControl = itemControl;\n\n    }\n\n    return newItem;\n\n  }\n\n  this.replaceItemCapable = replaceItemCapable;\n\n\n  function replacePlanItemControl(control, element) {\n\n    var newControl;\n\n    if (control) {\n\n      newControl = cmmnFactory.create('cmmn:PlanItemControl');\n\n      var repetitionRule = control.repetitionRule;\n      if (repetitionRule && (!element || cmmnRules.canSetRepetitionRule(element))) {\n\n        repetitionRule = replaceRule(repetitionRule);\n\n        setParent(repetitionRule, newControl);\n        newControl.repetitionRule = repetitionRule;\n\n      }\n\n      var requiredRule = control.requiredRule;\n      if (requiredRule && (!element || cmmnRules.canSetRequiredRule(element))) {\n\n        requiredRule = replaceRule(requiredRule);\n\n        setParent(requiredRule, newControl);\n        newControl.requiredRule = requiredRule;\n\n      }\n\n      var manualActivationRule = control.manualActivationRule;\n      if (manualActivationRule && (!element || cmmnRules.canSetManualActivationRule(element))) {\n\n        manualActivationRule = replaceRule(manualActivationRule);\n\n        setParent(manualActivationRule, newControl);\n        newControl.manualActivationRule = manualActivationRule;\n\n      }\n\n    }\n\n    return newControl;\n\n  }\n\n  this.replacePlanItemControl = replacePlanItemControl;\n\n\n  function replaceRule(rule) {\n\n    var newRule;\n\n    if (rule) {\n\n      var type = rule.$type;\n\n      var condition = replaceCondition(rule.condition);\n      newRule = cmmnFactory.create(type, {\n        condition: condition\n      });\n\n      setParent(condition, newRule);\n\n    }\n\n    return newRule;\n\n  }\n\n  this.replaceRule = replaceRule;\n\n\n  function replaceCondition(condition) {\n    var newCondition;\n\n    if (condition) {\n      newCondition = cmmnFactory.create('cmmn:Expression', {\n        language: condition.language,\n        body: condition.body\n      });\n    }\n\n    return newCondition;\n  }\n\n  this.replaceCondition = replaceCondition;\n\n\n  function setParent(element, parent) {\n    if (element) {\n      element.$parent = parent;\n    }\n  }\n\n}\n\nCmmnReplace.$inject = [ 'cmmnFactory', 'replace', 'selection', 'cmmnRules' ];\n\nmodule.exports = CmmnReplace;\n\nfunction isInstanceOf(element, type) {\n  element = getDefinition(element);\n  return is(element, type);\n}\n\nfunction isTask(element) {\n  return isInstanceOf(element, 'cmmn:Task');\n}\n\nfunction isMilestone(element) {\n  return isInstanceOf(element, 'cmmn:Milestone');\n}\n\nfunction isPlanFragment(element) {\n  return isInstanceOf(element, 'cmmn:PlanFragment');\n}\n\nfunction isStage(element) {\n  return isInstanceOf(element, 'cmmn:Stage');\n}\n\nfunction isCriterion(element) {\n  return is(element, 'cmmn:Criterion');\n}\n\nfunction isPlanItemControlCapable(element) {\n  return isTask(element) || isStage(element) || isMilestone(element);\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/replace/CmmnReplace.js?")},"./node_modules/cmmn-js/lib/features/replace/ReplaceOptions.js":module=>{"use strict";eval("\n\n\nmodule.exports.TASK = [\n  {\n    label: 'Task',\n    actionName: 'replace-with-task-plan-item',\n    className: 'cmmn-icon-task-none',\n    target: {\n      definitionType: 'cmmn:Task',\n      type: 'cmmn:PlanItem'\n    }\n  },\n  {\n    label: 'Human Task',\n    actionName: 'replace-with-blocking-human-task-plan-item',\n    className: 'cmmn-icon-human-blocking-task',\n    target: {\n      definitionType: 'cmmn:HumanTask',\n      type: 'cmmn:PlanItem',\n      isBlocking: true\n    }\n  },\n  {\n    label: 'Human Task',\n    actionName: 'replace-with-non-blocking-human-task-plan-item',\n    className: 'cmmn-icon-human-non-blocking-task',\n    target: {\n      definitionType: 'cmmn:HumanTask',\n      type: 'cmmn:PlanItem',\n      isBlocking: false\n    }\n  },\n  {\n    label: 'Decision Task',\n    actionName: 'replace-with-decision-task-plan-item',\n    className: 'cmmn-icon-decision-task',\n    target: {\n      definitionType: 'cmmn:DecisionTask',\n      type: 'cmmn:PlanItem'\n    }\n  },\n  {\n    label: 'Process Task',\n    actionName: 'replace-with-process-task-plan-item',\n    className: 'cmmn-icon-process-task',\n    target: {\n      definitionType: 'cmmn:ProcessTask',\n      type: 'cmmn:PlanItem'\n    }\n  },\n  {\n    label: 'Case Task',\n    actionName: 'replace-with-case-task-plan-item',\n    className: 'cmmn-icon-case-task',\n    target: {\n      definitionType: 'cmmn:CaseTask',\n      type: 'cmmn:PlanItem'\n    }\n  },\n  {\n    label: 'Stage (collapsed)',\n    actionName: 'replace-with-collapsed-stage-plan-item',\n    className: 'cmmn-icon-stage-collapsed',\n    target: {\n      definitionType: 'cmmn:Stage',\n      type: 'cmmn:PlanItem',\n      isCollapsed: true\n    }\n  },\n  {\n    label: 'Stage (expanded)',\n    actionName: 'replace-with-expanded-stage-plan-item',\n    className: 'cmmn-icon-stage-expanded',\n    target: {\n      definitionType: 'cmmn:Stage',\n      type: 'cmmn:PlanItem',\n      isCollapsed: false\n    }\n  },\n  {\n    label: 'Discretionary Task',\n    actionName: 'replace-with-task-discretionary-item',\n    className: 'cmmn-icon-task-discretionary',\n    target: {\n      definitionType: 'cmmn:Task',\n      type: 'cmmn:DiscretionaryItem'\n    }\n  },\n  {\n    label: 'Discretionary Human Task',\n    actionName: 'replace-with-blocking-human-task-discretionary-item',\n    className: 'cmmn-icon-human-blocking-task-discretionary',\n    target: {\n      definitionType: 'cmmn:HumanTask',\n      type: 'cmmn:DiscretionaryItem',\n      isBlocking: true\n    }\n  },\n  {\n    label: 'Discretionary Human Task',\n    actionName: 'replace-with-non-blocking-human-task-discretionary-item',\n    className: 'cmmn-icon-human-non-blocking-task-discretionary',\n    target: {\n      definitionType: 'cmmn:HumanTask',\n      type: 'cmmn:DiscretionaryItem',\n      isBlocking: false\n    }\n  },\n  {\n    label: 'Discretionary Decision Task',\n    actionName: 'replace-with-decision-task-discretionary-item',\n    className: 'cmmn-icon-decision-task-discretionary',\n    target: {\n      definitionType: 'cmmn:DecisionTask',\n      type: 'cmmn:DiscretionaryItem'\n    }\n  },\n  {\n    label: 'Discretionary Process Task',\n    actionName: 'replace-with-process-task-discretionary-item',\n    className: 'cmmn-icon-process-task-discretionary',\n    target: {\n      definitionType: 'cmmn:ProcessTask',\n      type: 'cmmn:DiscretionaryItem'\n    }\n  },\n  {\n    label: 'Discretionary Case Task',\n    actionName: 'replace-with-case-task-discretionary-item',\n    className: 'cmmn-icon-case-task-discretionary',\n    target: {\n      definitionType: 'cmmn:CaseTask',\n      type: 'cmmn:DiscretionaryItem'\n    }\n  },\n  {\n    label: 'Discretionary Stage (collapsed)',\n    actionName: 'replace-with-collapsed-stage-discretionary-item',\n    className: 'cmmn-icon-stage-collapsed-discretionary',\n    target: {\n      definitionType: 'cmmn:Stage',\n      type: 'cmmn:DiscretionaryItem',\n      isCollapsed: true\n    }\n  },\n  {\n    label: 'Discretionary Stage (expanded)',\n    actionName: 'replace-with-expanded-stage-discretionary-item',\n    className: 'cmmn-icon-stage-expanded-discretionary',\n    target: {\n      definitionType: 'cmmn:Stage',\n      type: 'cmmn:DiscretionaryItem',\n      isCollapsed: false\n    }\n  }\n];\n\n\nmodule.exports.PLAN_FRAGMENT_EXPANDED = [\n  {\n    label: 'Stage',\n    actionName: 'replace-with-stage-plan-item',\n    className: 'cmmn-icon-stage-expanded',\n    target: {\n      definitionType: 'cmmn:Stage',\n      type: 'cmmn:PlanItem',\n      isCollapsed: false\n    }\n  },\n  {\n    label: 'Discretionary Stage',\n    actionName: 'replace-with-stage-discretionary-item',\n    className: 'cmmn-icon-stage-expanded-discretionary',\n    target: {\n      definitionType: 'cmmn:Stage',\n      type: 'cmmn:DiscretionaryItem',\n      isCollapsed: false\n    }\n  },\n  {\n    label: 'Discretionary Plan Fragment',\n    actionName: 'replace-with-plan-fragment-discretionary-item',\n    className: 'cmmn-icon-plan-fragment-expanded-discretionary',\n    target: {\n      definitionType: 'cmmn:PlanFragment',\n      type: 'cmmn:DiscretionaryItem',\n      isCollapsed: false\n    }\n  }\n];\n\nmodule.exports.EVENT_LISTENER = [\n  {\n    label: 'Event Listener',\n    actionName: 'replace-with-event-listener-plan-item',\n    className: 'cmmn-icon-event-listener',\n    target: {\n      definitionType: 'cmmn:EventListener',\n      type: 'cmmn:PlanItem'\n    }\n  },\n  {\n    label: 'Timer Event Listener',\n    actionName: 'replace-with-timer-event-listener-plan-item',\n    className: 'cmmn-icon-timer-event-listener',\n    target: {\n      definitionType: 'cmmn:TimerEventListener',\n      type: 'cmmn:PlanItem'\n    }\n  },\n  {\n    label: 'User Event Listener',\n    actionName: 'replace-with-user-event-listener-plan-item',\n    className: 'cmmn-icon-user-event-listener',\n    target: {\n      definitionType: 'cmmn:UserEventListener',\n      type: 'cmmn:PlanItem'\n    }\n  }\n];\n\n\nmodule.exports.CRITERION = [\n  {\n    label: 'Entry Criterion',\n    actionName: 'replace-with-entry-criterion',\n    className: 'cmmn-icon-entry-criterion',\n    target: {\n      type: 'cmmn:EntryCriterion'\n    }\n  },\n  {\n    label: 'Exit Criterion',\n    actionName: 'replace-with-exit-criterion',\n    className: 'cmmn-icon-exit-criterion',\n    target: {\n      type: 'cmmn:ExitCriterion'\n    }\n  }\n];\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/replace/ReplaceOptions.js?")},"./node_modules/cmmn-js/lib/features/replace/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __depends__: [\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/popup-menu/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/replace/index.js")/* ["default"] */ .Z),\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js")/* ["default"] */ .Z)\n  ],\n  cmmnReplace: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/replace/CmmnReplace.js") ]\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/replace/index.js?')},"./node_modules/cmmn-js/lib/features/rules/CmmnRules.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar some = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .some */ .G),\n    forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed),\n    assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0),\n    filter = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .filter */ .hX);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    isCasePlanModel = ModelUtil.isCasePlanModel,\n    getDefinition = ModelUtil.getDefinition,\n    getBusinessObject = ModelUtil.getBusinessObject;\n\nvar isCollapsed = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/DiUtil.js\").isCollapsed);\n\nvar ModelingUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/ModelingUtil.js\"),\n    isAny = ModelingUtil.isAny,\n    isSame = ModelingUtil.isSame,\n    isSameCase = ModelingUtil.isSameCase,\n    getParent = ModelingUtil.getParent,\n    getParents = ModelingUtil.getParents;\n\nvar PlanItemDefinitionUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/features/modeling/util/PlanItemDefinitionUtil.js\"),\n    isDiscretionaryToHumanTask = PlanItemDefinitionUtil.isDiscretionaryToHumanTask,\n    isHumanTask = PlanItemDefinitionUtil.isHumanTask,\n    isDiscretionaryItem = PlanItemDefinitionUtil.isDiscretionaryItem;\n\nvar isCriterionAttachment = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/snapping/CmmnSnappingUtil.js\")/* .getCriterionAttachment */ .M);\n\nvar RuleProvider = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/RuleProvider.js\")/* [\"default\"] */ .Z);\n\n\n/**\n * CMMN specific modeling rule\n */\nfunction CmmnRules(eventBus) {\n  RuleProvider.call(this, eventBus);\n}\n\ninherits(CmmnRules, RuleProvider);\n\nCmmnRules.$inject = [ 'eventBus' ];\n\nmodule.exports = CmmnRules;\n\nCmmnRules.prototype.init = function() {\n\n  var self = this;\n\n  this.addRule('connection.start', function(context) {\n    var source = context.source;\n\n    return canStartConnection(source);\n  });\n\n  this.addRule('connection.create', function(context) {\n\n    var source = context.source,\n        target = context.target,\n        allowed = false,\n        hints = context.hints || {},\n        targetParent = hints.targetParent,\n        targetAttach = hints.targetAttach;\n\n    // don't allow incoming connections on\n    // attach from context-pad\n    if (targetAttach) {\n      return false;\n    }\n\n    // temporarily set target parent for scoping\n    // checks to work\n    if (targetParent) {\n      target.parent = targetParent;\n    }\n\n    try {\n      allowed = self.canConnect(source, target) ||\n                self.canReplaceConnectionEnd(source, target, 'target');\n\n      if (!allowed) {\n\n        allowed = self.canConnect(target, source) ||\n                     self.canReplaceConnectionEnd(target, source, 'source');\n\n        if (allowed) {\n          assign(allowed, {\n            reverse: true\n          });\n        }\n      }\n    } finally {\n      // unset temporary target parent\n      if (targetParent) {\n        target.parent = null;\n      }\n    }\n\n    return allowed;\n  });\n\n  this.addRule('connection.reconnectStart', function(context) {\n\n    var connection = context.connection,\n        hover = context.hover,\n        source = hover || context.source,\n        target = connection.target,\n        allowed = false;\n\n    allowed = self.canConnect(source, target, connection);\n\n    if (!allowed && hover) {\n\n      allowed = self.canReplaceConnectionEnd(hover, target, 'source');\n\n      if (!allowed) {\n\n        allowed = self.canConnect(target, hover, connection) ||\n                  self.canReplaceConnectionEnd(target, hover, 'target');\n\n        if (allowed) {\n          assign(allowed, {\n            reverse: true\n          });\n        }\n\n      }\n\n    }\n\n    return allowed;\n\n  });\n\n  this.addRule('connection.reconnectEnd', function(context) {\n\n    var connection = context.connection,\n        source = connection.source,\n        hover = context.hover,\n        target = hover || context.target,\n        allowed = false;\n\n    allowed = self.canConnect(source, target, connection);\n\n    if (!allowed && hover) {\n\n      allowed = self.canReplaceConnectionEnd(source, hover, 'target');\n\n      if (!allowed) {\n\n        allowed = self.canConnect(hover, source, connection) ||\n                  self.canReplaceConnectionEnd(hover, source, 'source');\n\n        if (allowed) {\n          assign(allowed, {\n            reverse: true\n          });\n        }\n\n      }\n\n    }\n\n    return allowed;\n\n  });\n\n  this.addRule('connection.updateWaypoints', function(context) {\n    var connection = context.connection;\n\n    return {\n      type: connection.type,\n      businessObject: connection.businessObject\n    };\n  });\n\n  this.addRule('shape.attach', function(context) {\n\n    return self.canAttach(\n      context.shape,\n      context.target,\n      null,\n      context.position\n    );\n  });\n\n  this.addRule('shape.create', function(context) {\n\n    var target = context.target,\n        shape = context.shape,\n        source = context.source,\n        position = context.position,\n        shapes = [ shape ];\n\n    return self.canCreate(shape, target, source, position) ||\n           self.canReplace(shapes, target, position, source);\n  });\n\n  this.addRule('shape.resize', function(context) {\n\n    var shape = context.shape,\n        newBounds = context.newBounds;\n\n    return self.canResize(shape, newBounds);\n  });\n\n  this.addRule('elements.move', function(context) {\n    var target = context.target,\n        shapes = context.shapes,\n        position = context.position;\n\n    return self.canAttach(shapes, target, null, position) ||\n           self.canMove(shapes, target, position) ||\n           self.canReplace(shapes, target, position);\n  });\n\n  this.addRule('shape.replace', function(context) {\n\n    var element = context.element,\n        host;\n\n    if (isCriterion(element)) {\n\n      host = element.host;\n\n      if (isCasePlanModel(host)) {\n        return false;\n      }\n\n      if (isTask(host) && !isBlocking(host)) {\n        return false;\n      }\n\n      if (isMilestone(host) || isEventListener(host)) {\n        return false;\n      }\n\n    }\n\n  });\n\n  this.addRule([ 'elements.delete' ], function(context) {\n    return self.canRemove(context.elements);\n  });\n\n};\n\n\nCmmnRules.prototype.canRemove = function(elements) {\n\n  // do not allow deletion of labels\n  return filter(elements, function(e) {\n    return !isLabel(e);\n  });\n\n};\n\n\nCmmnRules.prototype.canMove = function(elements, target) {\n\n  var self = this;\n\n  // allow default move check to start move operation\n  if (!target) {\n    return true;\n  }\n\n  return elements.every(function(element) {\n\n    if (isDiscretionaryItem(element)) {\n      if (!self.canMoveDiscretionaryItem(element, elements, target)) {\n        return false;\n      }\n    }\n\n    return self.canDrop(element, target);\n  });\n\n};\n\n\nCmmnRules.prototype.canMoveDiscretionaryItem = function(element, elements, target) {\n\n  return !isPlanFragment(target) || some(element.incoming, function(connection) {\n    var source = connection.source;\n    if (isDiscretionaryConnection(connection)) {\n      return isParent(target, source) || elements.indexOf(source) !== -1;\n    }\n  });\n\n};\n\nCmmnRules.prototype.canCreate = function(shape, target, source, position) {\n\n  var self = this;\n\n  if (!target) {\n    return false;\n  }\n\n  if (isLabel(target)) {\n    return null;\n  }\n\n  if (isSame(source, target)) {\n    return false;\n  }\n\n  // ensure we do not drop the element\n  // into source\n  if (source && isParent(source, target)) {\n    return false;\n  }\n\n  if (isDiscretionaryItem(shape)) {\n    if (!self.canCreateDiscretionaryItem(shape, target, source)) {\n      return false;\n    }\n  }\n\n  return self.canDrop(shape, target, position);\n\n};\n\nCmmnRules.prototype.canCreateDiscretionaryItem = function(shape, target, source) {\n  return !isPlanFragment(target) || isParent(target, source);\n};\n\n\nCmmnRules.prototype.canDrop = function(element, target) {\n\n  // can move labels everywhere\n  if (isLabel(element) && !isConnection(target)) {\n    return true;\n  }\n\n  if (isArtifact(element)) {\n\n    return is(target, 'cmmndi:CMMNDiagram') ||\n           isPlanFragment(target, true);\n  }\n\n  if (isCriterion(element)) {\n    return false;\n  }\n\n  if (isCasePlanModel(element)) {\n    // allow casePlanModels to drop only on root (CMMNDiagram)\n    return is(target, 'cmmndi:CMMNDiagram');\n  }\n\n  // allow any other element to drop on a case plan model or on an expanded stage\n  if (!isPlanFragment(target, true)) {\n    return false;\n  }\n\n  return !isCollapsed(target);\n\n};\n\n\nCmmnRules.prototype.canResize = function(shape, newBounds) {\n  if (isPlanFragment(shape, true)) {\n    return (!isCollapsed(shape)) && (\n      !newBounds || (newBounds.width >= 100 && newBounds.height >= 80)\n    );\n  }\n\n  if (isTextAnnotation(shape)) {\n    return true;\n  }\n\n  return false;\n};\n\nCmmnRules.prototype.canConnect = function(source, target, connection) {\n\n  if (nonExistingOrLabel(source) || nonExistingOrLabel(target)) {\n    return null;\n  }\n\n  // Disallow connections with same target and source element.\n  if (isSame(source, target)) {\n    return false;\n  }\n\n  if (this.canConnectPlanItemOnPartConnection(source, target)) {\n    return {\n      type: 'cmmn:PlanItemOnPart',\n      isStandardEventVisible: true\n    };\n  }\n\n  if (this.canConnectCaseFileItemOnPartConnection(source, target)) {\n    return {\n      type: 'cmmn:CaseFileItemOnPart',\n      isStandardEventVisible: true\n    };\n  }\n\n  if (this.canConnectDiscretionaryConnection(source, target, connection)) {\n    return {\n      type: 'cmmndi:CMMNEdge'\n    };\n  }\n\n  if (connection &&\n      is(connection.businessObject.cmmnElementRef, 'cmmn:Association') &&\n      this.canConnectAssociation(source, target)) {\n\n    return {\n      type: 'cmmn:Association'\n    };\n  }\n\n  if (isTextAnnotation(source) || isTextAnnotation(target)) {\n\n    return {\n      type: 'cmmn:Association'\n    };\n  }\n\n  return false;\n};\n\n\nCmmnRules.prototype.canConnectDiscretionaryConnection = function(source, target, connection) {\n\n  if (!isHumanTask(getDefinition(source))) {\n    return false;\n  }\n\n  if (!isBlocking(source)) {\n    return false;\n  }\n\n  if (!isDiscretionaryItem(target)) {\n    return false;\n  }\n\n  // A HumanTask MUST NOT be discretionary to itself.\n  var sourceDefinition = getDefinition(source);\n  var targetDefinition = getDefinition(target);\n\n  if (isSame(sourceDefinition, targetDefinition)) {\n    return false;\n  }\n\n  var sourceParent = getParent(source);\n  var targetParent = getParent(target);\n\n  if (!isSame(sourceParent, targetParent)) {\n    return false;\n  }\n\n  // if the target discretionary item is already\n  // part of a human task, then it should not be\n  // possible to create a connection to it in some\n  // cases.\n  if (isDiscretionaryToHumanTask(target)) {\n\n    if (!isUniqueDiscretionaryConnection(source, target, connection)) {\n      return false;\n    }\n\n    var parent = getParent(getBusinessObject(target), 'cmmn:HumanTask');\n\n    if (!isSame(getDefinition(source), parent)) {\n      if (hasIncomingDiscretionaryConnections(target, connection)) {\n        return false;\n      }\n    }\n\n  }\n\n  return true;\n};\n\n\nCmmnRules.prototype.canConnectPlanItemOnPartConnection = function(source, target) {\n\n  if (!isSameCase(source, target)) {\n    return false;\n  }\n\n  if (isExitCriterion(source)) {\n    source = source.host;\n  }\n\n  if (isSame(source, target.host)) {\n    return false;\n  }\n\n  if (isParent(source, target.host)) {\n    return false;\n  }\n\n  if (isEntryCriterion(target) && isParent(target.host, source)) {\n    return false;\n  }\n\n  return isPlanItem(source) && isCriterion(target);\n};\n\n\nCmmnRules.prototype.canConnectCaseFileItemOnPartConnection = function(source, target) {\n  return !!(isSameCase(source, target) &&\n            isCaseFileItem(source) &&\n            isCriterion(target));\n};\n\nCmmnRules.prototype.canConnectAssociation = function(source, target) {\n\n  // do not connect connections\n  if (isConnection(source) || isConnection(target)) {\n    return false;\n  }\n\n  // connect if different parent\n  return !isParent(target, source) &&\n         !isParent(source, target);\n\n};\n\nCmmnRules.prototype.canAttach = function(elements, target, source, position) {\n\n  if (isSame(source, target)) {\n    return false;\n  }\n\n\n  if (!Array.isArray(elements)) {\n    elements = [ elements ];\n  }\n\n  // only (re-)attach one element at a time\n  if (elements.length !== 1) {\n    return false;\n  }\n\n  var element = elements[0];\n\n  // do not attach labels\n  if (isLabel(element)) {\n    return false;\n  }\n\n  // only handle entry/exit criterion\n  if (!isCriterion(element)) {\n    return false;\n  }\n\n  // allow default move operation\n  if (!target) {\n    return true;\n  }\n\n  if (!this.canAttachCriterion(element, target, position, source)) {\n    return false;\n  }\n\n  return 'attach';\n\n};\n\n\nCmmnRules.prototype.canAttachEntryCriterion = function(element, target, position, source) {\n\n  if (!this.canAttachCriterion(element, target, position, source)) {\n    return false;\n  }\n\n  if (source && isParent(target, source)) {\n    return false;\n  }\n\n  // disallow drop entry criterion...\n\n  // ... on case plan model\n  if (isCasePlanModel(target)) {\n    return false;\n  }\n\n  if (isPlanFragment(target, true)) {\n\n    // ... when element has an incoming connection which source\n    // is a child of the target\n    return !some(element.incoming, function(connection) {\n      if (is(connection.businessObject.cmmnElementRef, 'cmmn:PlanItemOnPart')) {\n        return isParent(target, connection.source);\n      }\n    });\n\n  }\n\n  return true;\n};\n\n\nCmmnRules.prototype.canAttachExitCriterion = function(element, target, position, source) {\n\n  if (!this.canAttachCriterion(element, target, position, source)) {\n    return false;\n  }\n\n  // disallow drop exit criterion...\n\n  // ... on milestone\n  if (isMilestone(target)) {\n    return false;\n  }\n\n  // ... on non blocking task\n  if (isTask(target) && !isBlocking(target)) {\n    return false;\n  }\n\n  return true;\n\n};\n\n\nCmmnRules.prototype.canAttachCriterion = function(element, target, position, source) {\n\n  if (source && isParent(source, target)) {\n    return false;\n  }\n\n  // disallow drop criterion...\n\n  // ... on another criterion\n  if (isCriterion(target)) {\n    return false;\n  }\n\n  // ... on event listener\n  if (isEventListener(target)) {\n    return false;\n  }\n\n  // a plan fragment does not have any execution semantic,\n  // that why it should not be possible to attach an criterion\n  if (isPlanFragment(target)) {\n    return false;\n  }\n\n  // ... on a text annotation\n  if (isTextAnnotation(target)) {\n    return false;\n  }\n\n  // ... on a case file item\n  if (isCaseFileItem(target)) {\n    return false;\n  }\n\n  // only attach to border\n  if (position && !isCriterionAttachment(position, target)) {\n    return false;\n  }\n\n  return true;\n\n};\n\n\nCmmnRules.prototype.canReplace = function(elements, target, position, source) {\n\n  if (!target) {\n    return false;\n  }\n\n  if (isSame(source, target)) {\n    return false;\n  }\n\n  var canExecute = {\n    replacements: []\n  };\n\n  var self = this;\n\n  forEach(elements, function(element) {\n\n    if (isEntryCriterion(element) && !self.canAttachEntryCriterion(element, target, position, source)) {\n      if (self.canAttachExitCriterion(element, target, position, source)) {\n        canExecute.replacements.push({\n          oldElementId: element.id,\n          newElementType: 'cmmn:ExitCriterion'\n        });\n      }\n    }\n\n    if (isExitCriterion(element) && !self.canAttachExitCriterion(element, target, position, source)) {\n      if (self.canAttachEntryCriterion(element, target, position, source)) {\n        canExecute.replacements.push({\n          oldElementId: element.id,\n          newElementType: 'cmmn:EntryCriterion'\n        });\n      }\n    }\n\n    if (isPlanFragment(target) &&\n        isDiscretionaryItem(element) &&\n        self.canDrop(element, target) &&\n        !self.canMoveDiscretionaryItem(element, elements, target)) {\n\n      var replacement = {\n        oldElementId: element.id,\n        newElementType: 'cmmn:PlanItem'\n      };\n\n      if (isPlanFragment(element)) {\n        assign(replacement, {\n          newDefinitionType: 'cmmn:Stage'\n        });\n      }\n\n      canExecute.replacements.push(replacement);\n\n    }\n\n  });\n\n  return canExecute.replacements.length ? canExecute : false;\n};\n\n\nCmmnRules.prototype.canReplaceConnectionEnd = function(source, target, side) {\n\n  if (!source || !target) {\n    return false;\n  }\n\n  if (isSame(source, target)) {\n    return false;\n  }\n\n  if (!isSameCase(source, target)) {\n    return false;\n  }\n\n  return side === 'source' ? this.canReplaceSource(source, target) : this.canReplaceTarget(source, target);\n\n};\n\n\nCmmnRules.prototype.canReplaceSource = function(source, target) {\n\n  if (isDiscretionaryItem(source) && isCriterion(target)) {\n\n    if (isSame(source, target.host)) {\n      return false;\n    }\n\n    if (isPlanFragment(source)) {\n      return false;\n    }\n\n    if (isParent(source, target.host)) {\n      return false;\n    }\n\n    if (isEntryCriterion(target) && isParent(target.host, source)) {\n      return false;\n    }\n\n    return {\n      type: 'cmmn:PlanItemOnPart',\n      isStandardEventVisible: true,\n      replacements: [{\n        oldElementId: source.id,\n        newElementType: 'cmmn:PlanItem'\n      }]\n    };\n\n  }\n\n\n  if (isEntryCriterion(source) && isEntryCriterion(target)) {\n\n    if (isSame(source.host, target.host)) {\n      return false;\n    }\n\n    if (isParent(target.host, source.host) ||\n        isParent(source.host, target.host)) {\n      return false;\n    }\n\n    if (hasIncomingOnPartConnections(source)) {\n      return false;\n    }\n\n    if (!this.canAttachExitCriterion(source, source.host)) {\n      return false;\n    }\n\n    return {\n      type: 'cmmn:PlanItemOnPart',\n      isStandardEventVisible: true,\n      replacements: [{\n        oldElementId: source.id,\n        newElementType: 'cmmn:ExitCriterion'\n      }]\n    };\n\n  }\n\n  return false;\n\n};\n\n\nCmmnRules.prototype.canReplaceTarget = function(source, target) {\n\n  if (isHumanTask(getDefinition(source)) && isPlanItem(target)) {\n\n    if (!isBlocking(source)) {\n      return false;\n    }\n\n    if (isEventListener(target) || isMilestone(target)) {\n      return false;\n    }\n\n    if (isSameDefinition(source, target)) {\n      return false;\n    }\n\n    if (!isSameParent(source, target)) {\n      return false;\n    }\n\n    return {\n      type: 'cmmndi:CMMNEdge',\n      replacements: [{\n        oldElementId: target.id,\n        newElementType: 'cmmn:DiscretionaryItem'\n      }]\n    };\n\n  }\n\n  if ((isPlanItem(source) || isExitCriterion(source)) && isEntryCriterion(target)) {\n\n    if (isSame(source.host || source, target.host)) {\n      return false;\n    }\n\n    if (!isParent(target.host, source.host || source)) {\n      return false;\n    }\n\n    if (hasIncomingOnPartConnections(target)) {\n      return false;\n    }\n\n    if (!this.canAttachExitCriterion(target, target.host)) {\n      return false;\n    }\n\n    return {\n      type: 'cmmn:PlanItemOnPart',\n      isStandardEventVisible: true,\n      replacements: [{\n        oldElementId: target.id,\n        newElementType: 'cmmn:ExitCriterion'\n      }]\n    };\n\n  }\n\n  return false;\n\n};\n\n\nCmmnRules.prototype.canSetRepetitionRule = function(element) {\n  return isPlanItemControlCapable(element);\n};\n\n\nCmmnRules.prototype.canSetRequiredRule = function(element) {\n  return isPlanItemControlCapable(element);\n};\n\n\nCmmnRules.prototype.canSetManualActivationRule = function(element) {\n  if (isMilestone(element)) {\n    return false;\n  }\n  return isPlanItemControlCapable(element);\n};\n\n\n/**\n * Utility functions for rule checking\n */\n\n/**\n * Checks if given element can be used for starting connection.\n *\n * @param  {Element} source\n * @return {Boolean}\n */\nfunction canStartConnection(element) {\n  if (nonExistingOrLabel(element)) {\n    return null;\n  }\n\n  return isAny(element, [\n    'cmmn:CaseFileItem',\n    'cmmn:Criterion',\n    'cmmn:DiscretionaryItem',\n    'cmmn:PlanItem'\n  ]);\n}\n\nfunction isParent(possibleParent, element) {\n  var allParents = getParents(element);\n  return allParents.indexOf(possibleParent) !== -1;\n}\n\nfunction isPlanItemControlCapable(element) {\n  return isTask(element) || isMilestone(element) || is(getDefinition(element), 'cmmn:Stage');\n}\n\nfunction nonExistingOrLabel(element) {\n  return !element || isLabel(element);\n}\n\nfunction isLabel(element) {\n  return element.labelTarget;\n}\n\nfunction isConnection(element) {\n  return element.waypoints;\n}\n\nfunction isUniqueDiscretionaryConnection(source, target, connection) {\n  return !some(target.incoming, function(con) {\n    return con !== connection &&\n        isDiscretionaryConnection(con) &&\n        con.source === source &&\n        con.target === target;\n  });\n}\n\nfunction hasIncomingDiscretionaryConnections(target, connection) {\n  return some(target.incoming, function(con) {\n    return con !== connection && isDiscretionaryConnection(con);\n  });\n}\n\nfunction isDiscretionaryConnection(connection) {\n  return !connection.businessObject.cmmnElementRef;\n}\n\nfunction hasIncomingOnPartConnections(target) {\n  return some(target.incoming, function(con) {\n    return isOnPartConnection(con);\n  });\n}\n\nfunction isOnPartConnection(connection) {\n  return is(connection.businessObject.cmmnElementRef, 'cmmn:OnPart');\n}\n\nfunction isPlanFragment(element, isStage) {\n  var definition = getDefinition(element) || element;\n\n  if (!is(definition, 'cmmn:PlanFragment')) {\n    return false;\n  }\n\n  if (!isStage && is(definition, 'cmmn:Stage')) {\n    return false;\n  }\n\n  return true;\n}\n\nfunction isEventListener(element) {\n  return is(getDefinition(element), 'cmmn:EventListener');\n}\n\nfunction isMilestone(element) {\n  return is(getDefinition(element), 'cmmn:Milestone');\n}\n\nfunction isTask(element) {\n  return is(getDefinition(element), 'cmmn:Task');\n}\n\nfunction isBlocking(element) {\n  element = getDefinition(element);\n  return !!(element && element.isBlocking);\n}\n\nfunction isCriterion(element) {\n  return is(element, 'cmmn:Criterion');\n}\n\nfunction isEntryCriterion(element) {\n  return is(element, 'cmmn:EntryCriterion');\n}\n\nfunction isExitCriterion(element) {\n  return is(element, 'cmmn:ExitCriterion');\n}\n\nfunction isArtifact(element) {\n  if (isConnection(element)) {\n    element = element.businessObject.cmmnElementRef;\n  }\n  return is(element, 'cmmn:Artifact');\n}\n\nfunction isTextAnnotation(element) {\n  return is(element, 'cmmn:TextAnnotation');\n}\n\nfunction isCaseFileItem(element) {\n  return is(element, 'cmmn:CaseFileItem');\n}\n\nfunction isPlanItem(element) {\n  return is(element, 'cmmn:PlanItem');\n}\n\nfunction isSameParent(a, b) {\n  return isSame(getParent(a), getParent(b));\n}\n\nfunction isSameDefinition(a, b) {\n  return isSame(getDefinition(a), getDefinition(b));\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/rules/CmmnRules.js?")},"./node_modules/cmmn-js/lib/features/rules/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __depends__: [\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js")/* ["default"] */ .Z)\n  ],\n  __init__: [ \'cmmnRules\' ],\n  cmmnRules: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/rules/CmmnRules.js") ]\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/rules/index.js?')},"./node_modules/cmmn-js/lib/features/search/CmmnSearchProvider.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar map = (__webpack_require__("./node_modules/min-dash/dist/index.esm.js")/* .map */ .UI),\n    filter = (__webpack_require__("./node_modules/min-dash/dist/index.esm.js")/* .filter */ .hX),\n    sortBy = (__webpack_require__("./node_modules/min-dash/dist/index.esm.js")/* .sortBy */ .MR);\n\nvar labelUtil = __webpack_require__("./node_modules/cmmn-js/lib/features/label-editing/LabelUtil.js");\n\n\n/**\n * Provides ability to search through CMMN elements\n */\nfunction CmmnSearchProvider(elementRegistry, searchPad, canvas) {\n\n  this._elementRegistry = elementRegistry;\n  this._canvas = canvas;\n\n  searchPad.registerProvider(this);\n}\n\nmodule.exports = CmmnSearchProvider;\n\nCmmnSearchProvider.$inject = [\n  \'elementRegistry\',\n  \'searchPad\',\n  \'canvas\'\n];\n\n\n/**\n * Finds all elements that match given pattern\n *\n * <Result> :\n *  {\n *    primaryTokens: <Array<Token>>,\n *    secondaryTokens: <Array<Token>>,\n *    element: <Element>\n *  }\n *\n * <Token> :\n *  {\n *    normal|matched: <String>\n *  }\n *\n * @param  {String} pattern\n * @return {Array<Result>}\n */\nCmmnSearchProvider.prototype.find = function(pattern) {\n  var rootElement = this._canvas.getRootElement();\n\n  var elements = this._elementRegistry.filter(function(element) {\n    if (element.labelTarget) {\n      return false;\n    }\n    return true;\n  });\n\n  // do not include root element\n  elements = filter(elements, function(element) {\n    return element !== rootElement;\n  });\n\n  elements = map(elements, function(element) {\n    return {\n      primaryTokens: matchAndSplit(labelUtil.getLabel(element), pattern),\n      secondaryTokens: matchAndSplit(element.id, pattern),\n      element: element\n    };\n  });\n\n  // exclude non-matched elements\n  elements = filter(elements, function(element) {\n    return hasMatched(element.primaryTokens) || hasMatched(element.secondaryTokens);\n  });\n\n  elements = sortBy(elements, function(element) {\n    return labelUtil.getLabel(element.element) + element.element.id;\n  });\n\n  return elements;\n};\n\n\nfunction hasMatched(tokens) {\n  var matched = filter(tokens, function(t) {\n    return !!t.matched;\n  });\n\n  return matched.length > 0;\n}\n\n\nfunction matchAndSplit(text, pattern) {\n  var tokens = [],\n      originalText = text;\n\n  if (!text) {\n    return tokens;\n  }\n\n  text = text.toLowerCase();\n  pattern = pattern.toLowerCase();\n\n  var i = text.indexOf(pattern);\n\n  if (i > -1) {\n    if (i !== 0) {\n      tokens.push({\n        normal: originalText.substr(0, i)\n      });\n    }\n\n    tokens.push({\n      matched: originalText.substr(i, pattern.length)\n    });\n\n    if (pattern.length + i < text.length) {\n      tokens.push({\n        normal: originalText.substr(pattern.length + i, text.length)\n      });\n    }\n  } else {\n    tokens.push({\n      normal: originalText\n    });\n  }\n\n  return tokens;\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/search/CmmnSearchProvider.js?')},"./node_modules/cmmn-js/lib/features/search/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = {\n  __depends__: [\n    (__webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/search-pad/index.js")/* ["default"] */ .Z)\n  ],\n  __init__: [ \'cmmnSearch\'],\n  cmmnSearch: [ \'type\', __webpack_require__("./node_modules/cmmn-js/lib/features/search/CmmnSearchProvider.js") ]\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/search/index.js?')},"./node_modules/cmmn-js/lib/features/snapping/CmmnConnectSnapping.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var SnapUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js\"),\n    mid =SnapUtil.mid,\n    setSnapped = SnapUtil.setSnapped;\n\nvar isCmd = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\")/* .isCmd */ .JS);\n\nvar ModelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\"),\n    is = ModelUtil.is,\n    getDefinition = ModelUtil.getDefinition,\n    getBusinessObject = ModelUtil.getBusinessObject;\n\nvar HIGHER_PRIORITY = 1250;\n\n\n/**\n   * Snap during connect.\n   *\n   * @param {EventBus} eventBus\n   * @param {Rules} rules\n   */\nfunction CmmnConnectSnapping(eventBus, rules) {\n  eventBus.on([\n    'connect.hover',\n    'connect.move',\n    'connect.end',\n  ], HIGHER_PRIORITY, function(event) {\n    var context = event.context,\n        source = context.source,\n        target = context.target,\n        canExecute = context.canExecute;\n\n    if (!canExecute) {\n      return;\n    }\n\n    if (event.originalEvent && isCmd(event.originalEvent)) {\n      return;\n    }\n\n    if (!context.initialSourcePosition) {\n      context.initialSourcePosition = context.sourcePosition;\n    }\n\n    var connectionAttrs = rules.allowed('connection.create', {\n      source: source,\n      target: target\n    });\n\n    if (connectionAttrs && isCenterSnapTarget(source)) {\n      // snap source\n      context.sourcePosition = mid(source);\n    }\n\n    if (connectionAttrs && isCenterSnapTarget(target)) {\n\n      // snap target\n      snapToPosition(event, mid(target));\n    }\n  });\n}\n\nCmmnConnectSnapping.$inject = [\n  'eventBus',\n  'rules'\n];\n\nmodule.exports = CmmnConnectSnapping;\n\n// helpers //////////\n\nfunction snapToPosition(event, position) {\n  setSnapped(event, 'x', position.x);\n  setSnapped(event, 'y', position.y);\n}\n\n/**\n * Returns true if element should be center snapped when\n * creating a connection.\n *\n * This applies to all collapsed and non container elements.\n *\n * @param {djs.model.Base} element\n *\n * @return {Boolean}\n */\nfunction isCenterSnapTarget(element) {\n\n  if (!element) {\n    return false;\n  }\n\n  if (is(element, 'cmmn:Stage')) {\n    return false;\n  }\n\n  var bo = getBusinessObject(element);\n  var definition = getDefinition(element) || element;\n\n  if (!is(definition, 'cmmn:PlanFragment')) {\n    return true;\n  }\n\n  var di = bo.di;\n\n  if (di && di.isCollapsed === true) {\n    return true;\n  }\n\n  return false;\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/snapping/CmmnConnectSnapping.js?")},"./node_modules/cmmn-js/lib/features/snapping/CmmnCreateMoveSnapping.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar inherits = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n\nvar SnapUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n\nvar CreateMoveSnapping = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js\")/* [\"default\"] */ .Z);\n\nvar isSnapped = SnapUtil.isSnapped,\n    setSnapped = SnapUtil.setSnapped;\n\nvar asTRBL = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\")/* .asTRBL */ .JA),\n    getMid = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\")/* .getMid */ .wS);\n\nvar getCriterionAttachment = (__webpack_require__(\"./node_modules/cmmn-js/lib/features/snapping/CmmnSnappingUtil.js\")/* .getCriterionAttachment */ .M);\n\nvar forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed);\n\n\n/**\n * Cmmn specific create move snapping functionality\n *\n * @param {EventBus} eventBus\n * @param {CmmnRules} cmmnRules\n */\nfunction CmmnCreateMoveSnapping(eventBus, cmmnRules, injector) {\n\n  injector.invoke(CreateMoveSnapping, this);\n\n  function canAttach(shape, target, position) {\n    return cmmnRules.canAttach([ shape ], target, null, position) === 'attach';\n  }\n\n  eventBus.on([\n    'create.move',\n    'create.end',\n    'shape.move.move',\n    'shape.move.end'\n  ], 1500, function(event) {\n\n    var context = event.context,\n        target = context.target,\n        shape = context.shape;\n\n    if (target && !isSnapped(event) && canAttach(shape, target, event)) {\n      snapCriterion(event, shape, target);\n    }\n  });\n\n\n  function snapCriterion(event, shape, target) {\n    var targetTRBL = asTRBL(target);\n\n    var direction = getCriterionAttachment(event, target);\n\n    if (/top/.test(direction)) {\n      setSnapped(event, 'y', targetTRBL.top);\n    } else\n    if (/bottom/.test(direction)) {\n      setSnapped(event, 'y', targetTRBL.bottom);\n    }\n\n    if (/left/.test(direction)) {\n      setSnapped(event, 'x', targetTRBL.left);\n    } else\n    if (/right/.test(direction)) {\n      setSnapped(event, 'x', targetTRBL.right);\n    }\n  }\n}\n\ninherits(CmmnCreateMoveSnapping, CreateMoveSnapping);\n\nCmmnCreateMoveSnapping.$inject = [ 'eventBus', 'cmmnRules', 'injector' ];\n\nmodule.exports = CmmnCreateMoveSnapping;\n\n\nCmmnCreateMoveSnapping.prototype.initSnap = function(event) {\n  var snapContext = CreateMoveSnapping.prototype.initSnap.call(this, event);\n\n  var shape = event.shape;\n\n  // snap to docking points\n  forEach(shape.outgoing, function(connection) {\n    var docking = connection.waypoints[0];\n\n    docking = docking.original || docking;\n\n    snapContext.setSnapOrigin(connection.id + '-docking', {\n      x: docking.x - event.x,\n      y: docking.y - event.y\n    });\n  });\n\n  forEach(shape.incoming, function(connection) {\n    var docking = connection.waypoints[connection.waypoints.length - 1];\n\n    docking = docking.original || docking;\n\n    snapContext.setSnapOrigin(connection.id + '-docking', {\n      x: docking.x - event.x,\n      y: docking.y - event.y\n    });\n  });\n\n  return snapContext;\n};\n\n\nCmmnCreateMoveSnapping.prototype.addSnapTargetPoints = function(snapPoints, shape, target) {\n  CreateMoveSnapping.prototype.addSnapTargetPoints.call(this, snapPoints, shape, target);\n\n  var snapTargets = this.getSnapTargets(shape, target);\n\n  // snap to docking points\n  forEach(shape.incoming, function(connection) {\n\n    if (!includes(snapTargets, connection.source)) {\n      snapPoints.add('mid', getMid(connection.source));\n    }\n\n    var docking = connection.waypoints[0];\n\n    snapPoints.add(connection.id + '-docking', docking.original || docking);\n  });\n\n\n  forEach(shape.outgoing, function(connection) {\n\n    if (!includes(snapTargets, connection.target)) {\n      snapPoints.add('mid', getMid(connection.target));\n    }\n\n    var docking = connection.waypoints[ connection.waypoints.length - 1 ];\n\n    snapPoints.add(connection.id + '-docking', docking.original || docking);\n  });\n\n  return snapPoints;\n};\n\n\n// helpers ////////////////////\n\nfunction includes(array, value) {\n  return array.indexOf(value) !== -1;\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/snapping/CmmnCreateMoveSnapping.js?")},"./node_modules/cmmn-js/lib/features/snapping/CmmnResizeSnapping.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is),\n    getDefinition = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getDefinition),\n    isCollapsed = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/DiUtil.js\").isCollapsed);\n\nvar SLIGHTLY_HIGHER_PRIORITY = 1001;\n\n\n/**\n * Cmmn specific resize snapping functionality\n *\n * @param {EventBus} eventBus\n * @param {CmmnRules} cmmnRules\n */\nfunction CmmnResizeSnapping(eventBus) {\n\n  eventBus.on('resize.start', SLIGHTLY_HIGHER_PRIORITY + 500, function(event) {\n    var context = event.context,\n        shape = context.shape;\n\n    if (isStage(shape) && !isCollapsed(shape)) {\n      context.minDimensions = { width: 140, height: 120 };\n    }\n\n    if (is(shape, 'cmmn:TextAnnotation')) {\n      context.minDimensions = { width: 50, height: 30 };\n    }\n\n  });\n\n}\n\nCmmnResizeSnapping.$inject = [ 'eventBus', 'cmmnRules', 'injector' ];\n\nmodule.exports = CmmnResizeSnapping;\n\n// helpers //////////\n\nfunction isStage(element) {\n  return is(getDefinition(element), 'cmmn:PlanFragment');\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/snapping/CmmnResizeSnapping.js?")},"./node_modules/cmmn-js/lib/features/snapping/CmmnSnappingUtil.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar getOrientation = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\")/* .getOrientation */ .T8);\n\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is),\n    getDefinition = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getDefinition);\n\n\n/**\n * Get orientation of the given position rectangle in relation to the\n * given target rectangle. When the position is near a corner (respecting\n * the given offet) the string 'corner' is returned.\n *\n * A padding (positive or negative) may be passed to influence\n * horizontal / vertical orientation and intersection.\n *\n * @param {Bounds} position\n * @param {Bounds} target\n * @param {Point|Number} padding\n * @param {Number} offset\n */\nfunction getCornerlessOrientation(position, target, padding, offset) {\n\n  // don't snap to top left corner\n  if (position.x - offset < target.x &&\n      position.y - offset < target.y) {\n    return 'corner';\n  }\n\n  // don't snap to top right corner\n  if (position.x + offset > target.x + target.width &&\n      position.y - offset < target.y) {\n    return 'corner';\n  }\n\n  // don't snap to bottom left corner\n  if (position.x - offset < target.x &&\n      position.y + offset > target.y + target.height) {\n    return 'corner';\n  }\n\n  // don't snap to bottom right corner\n  if (position.x + offset > target.x + target.width &&\n      position.y + offset > target.y + target.height) {\n    return 'corner';\n  }\n\n  return getOrientation(position, target, padding);\n}\n\n\nfunction getCriterionAttachment(position, target) {\n\n  var orientation;\n\n  var definition = getDefinition(target);\n\n  if (is(target, 'cmmn:PlanItem') && is(definition, 'cmmn:Stage')) {\n    orientation = getCornerlessOrientation(position, target, -15, 20);\n\n  } else\n  if (is(definition, 'cmmn:Milestone')) {\n    orientation = getCornerlessOrientation(position, target, -3, 7);\n\n  } else {\n    orientation = getOrientation(position, target, -15);\n  }\n\n  if (orientation !== 'intersect') {\n    return orientation;\n  } else {\n    return null;\n  }\n}\n\nmodule.exports.M = getCriterionAttachment;\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/snapping/CmmnSnappingUtil.js?")},"./node_modules/cmmn-js/lib/features/snapping/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var CmmnConnectSnapping = __webpack_require__(\"./node_modules/cmmn-js/lib/features/snapping/CmmnConnectSnapping.js\");\nvar CmmnCreateMoveSnapping = __webpack_require__(\"./node_modules/cmmn-js/lib/features/snapping/CmmnCreateMoveSnapping.js\");\nvar CmmnResizeSnapping = __webpack_require__(\"./node_modules/cmmn-js/lib/features/snapping/CmmnResizeSnapping.js\");\nvar SnappingModule = (__webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/index.js\")/* [\"default\"] */ .Z);\n\n\nmodule.exports = {\n  __depends__: [ SnappingModule ],\n  __init__: [\n    'connectSnapping',\n    'createMoveSnapping',\n    'resizeSnapping'\n  ],\n  connectSnapping: [ 'type', CmmnConnectSnapping ],\n  createMoveSnapping: [ 'type', CmmnCreateMoveSnapping],\n  resizeSnapping: [ 'type', CmmnResizeSnapping ]\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/features/snapping/index.js?")},"./node_modules/cmmn-js/lib/import/CmmnImporter.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0),\n    map = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .map */ .UI);\n\nvar LabelUtil = __webpack_require__(\"./node_modules/cmmn-js/lib/util/LabelUtil.js\");\n\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is);\n\nvar hasExternalLabel = LabelUtil.hasExternalLabel,\n    getExternalLabelBounds = LabelUtil.getExternalLabelBounds,\n    isCollapsed = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/DiUtil.js\").isCollapsed),\n    elementToString = (__webpack_require__(\"./node_modules/cmmn-js/lib/import/Util.js\")/* .elementToString */ .x);\n\n\nfunction elementData(semantic, attrs) {\n  return assign({\n    id: semantic.id,\n    type: semantic.$type,\n    businessObject: semantic\n  }, attrs);\n}\n\nfunction collectWaypoints(waypoints) {\n  return map(waypoints, function(p) {\n    return { x: p.x, y: p.y };\n  });\n}\n\nfunction notYetDrawn(semantic, refSemantic, property) {\n  return new Error(\n    'element ' + elementToString(refSemantic) + ' referenced by ' +\n      elementToString(semantic) + '#' + property + ' not yet drawn');\n}\n\n/**\n * An importer that adds cmmn elements to the canvas\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {ElementFactory} elementFactory\n * @param {ElementRegistry} elementRegistry\n */\nfunction CmmnImporter(eventBus, canvas, elementFactory, elementRegistry) {\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n\n  this._elementFactory = elementFactory;\n  this._elementRegistry = elementRegistry;\n}\n\nCmmnImporter.$inject = [ 'eventBus', 'canvas', 'elementFactory', 'elementRegistry' ];\n\nmodule.exports = CmmnImporter;\n\n\n/**\n * Set the diagram as root element\n */\nCmmnImporter.prototype.root = function(diagram) {\n  var element = this._elementFactory.createRoot(elementData(diagram));\n\n  this._canvas.setRootElement(element);\n\n  return element;\n};\n\n\n/**\n * Add cmmn element (semantic) to the canvas onto the\n * specified parent shape.\n */\nCmmnImporter.prototype.add = function(semantic, parentElement) {\n\n  var di = semantic.di,\n      element,\n      hidden;\n\n  // SHAPE\n  if (di && is(di, 'cmmndi:CMMNShape') && !this._getElement(semantic)) {\n\n    var collapsed = isCollapsed(semantic);\n\n    hidden = parentElement && (parentElement.hidden || parentElement.collapsed);\n\n    var bounds = semantic.di.bounds;\n\n    element = this._elementFactory.createShape(elementData(semantic, {\n      collapsed: collapsed,\n      hidden: hidden,\n      x: Math.round(bounds.x),\n      y: Math.round(bounds.y),\n      width: Math.round(bounds.width),\n      height: Math.round(bounds.height)\n    }));\n\n    if (is(semantic, 'cmmn:Criterion')) {\n      this._attachCriterion(semantic, element);\n    }\n\n    this._canvas.addShape(element, parentElement);\n  }\n\n  // CONNECTION\n  else if ((di && is(di, 'cmmndi:CMMNEdge')) || is(semantic, 'cmmndi:CMMNEdge')) {\n\n    var source = this._getSource(semantic),\n        target = this._getTarget(semantic);\n\n    hidden = (parentElement && (parentElement.hidden || parentElement.collapsed)) ||\n                 (source && source.hidden) ||\n                 (target && target.hidden) ;\n\n    var waypoint = (semantic.di || {}).waypoint || semantic.waypoint;\n\n    element = this._elementFactory.createConnection(elementData(semantic, {\n      hidden: hidden,\n      source: source,\n      target: target,\n      waypoints: collectWaypoints(waypoint)\n    }));\n\n    this._canvas.addConnection(element, parentElement);\n  } else {\n    throw new Error('unknown di ' + elementToString(di) + ' for element ' + elementToString(semantic));\n  }\n\n  // (optional) LABEL\n  if (hasExternalLabel(semantic)) {\n    this.addLabel(semantic, element);\n  }\n\n  this._eventBus.fire('cmmnElement.added', { element: element });\n\n  return element;\n};\n\n\n/**\n * Attach the criterion element to the given host\n *\n * @param {ModdleElement} criterionSemantic\n * @param {djs.model.Base} criterionElement\n */\nCmmnImporter.prototype._attachCriterion = function(criterionSemantic, criterionElement) {\n  var hostSemantic = criterionSemantic.$parent;\n\n  if (!hostSemantic) {\n    throw new Error('missing ' + elementToString(criterionSemantic) + '$parent');\n  }\n\n  var host = this._elementRegistry.get(hostSemantic.id),\n      attachers = host && host.attachers;\n\n  if (!host) {\n    throw notYetDrawn(criterionSemantic, hostSemantic, 'criterion');\n  }\n\n  // wire element.host <> host.attachers\n  criterionElement.host = host;\n\n  if (!attachers) {\n    host.attachers = attachers = [];\n  }\n\n  if (attachers.indexOf(criterionElement) === -1) {\n    attachers.push(criterionElement);\n  }\n};\n\n\n/**\n * add label for an element\n */\nCmmnImporter.prototype.addLabel = function(semantic, element) {\n  var bounds = getExternalLabelBounds(semantic, element);\n\n  var label = this._elementFactory.createLabel(elementData(semantic, {\n    id: semantic.id + '_label',\n    labelTarget: element,\n    type: 'label',\n    hidden: element.hidden,\n    x: Math.round(bounds.x),\n    y: Math.round(bounds.y),\n    width: Math.round(bounds.width),\n    height: Math.round(bounds.height)\n  }));\n\n  return this._canvas.addShape(label, element.parent);\n};\n\nCmmnImporter.prototype._getSource = function(semantic) {\n  var cmmnElement = semantic.cmmnElementRef;\n\n  if (cmmnElement) {\n\n    if (is(cmmnElement, 'cmmn:OnPart')) {\n\n      if (cmmnElement.exitCriterionRef) {\n        return this._getEnd(cmmnElement, 'exitCriterionRef');\n      }\n\n      return this._getEnd(cmmnElement, 'sourceRef');\n\n    }\n\n    if (is(cmmnElement, 'cmmn:Association')) {\n      return this._getEnd(cmmnElement, 'sourceRef');\n    }\n\n  }\n\n  if (is(semantic, 'cmmndi:CMMNEdge')) {\n    return this._getEnd(semantic, 'sourceCMMNElementRef');\n  }\n\n};\n\nCmmnImporter.prototype._getTarget = function(semantic) {\n  var cmmnElement = semantic.cmmnElementRef;\n\n  if (cmmnElement) {\n\n    if (is(cmmnElement, 'cmmn:Association')) {\n      return this._getEnd(cmmnElement, 'targetRef');\n    }\n\n  }\n\n  return this._getEnd(semantic, 'targetCMMNElementRef');\n};\n\nCmmnImporter.prototype._getEnd = function(semantic, side) {\n  var refSemantic = semantic[side];\n  var element = refSemantic && this._getElement(refSemantic);\n\n  if (element) {\n    return element;\n  }\n\n  if (refSemantic) {\n    throw notYetDrawn(semantic, refSemantic, side);\n  } else {\n    throw new Error(elementToString(semantic) + '#' + side + 'Ref not specified');\n  }\n\n};\n\nCmmnImporter.prototype._getElement = function(semantic) {\n  return this._elementRegistry.get(semantic.id);\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/import/CmmnImporter.js?")},"./node_modules/cmmn-js/lib/import/CmmnTreeWalker.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar forEach = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .forEach */ .Ed),\n    filter = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .filter */ .hX);\n\nvar Refs = __webpack_require__(\"./node_modules/object-refs/index.js\");\n\nvar elementToString = (__webpack_require__(\"./node_modules/cmmn-js/lib/import/Util.js\")/* .elementToString */ .x);\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is);\n\nvar Collections = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\");\n\nvar diRefs = new Refs({ name: 'cmmnElement', enumerable: true }, { name: 'di' });\n\n\nfunction CmmnTreeWalker(handler) {\n\n  // list of elements to handle deferred to ensure\n  // prerequisites are drawn\n  var deferred = [];\n\n  // list of CMMNEdges which cmmnElementRef is equals null:\n  // - it is a connection which does not have a representation\n  //   in case plan model\n  // - it is a connection between a human (plan item) task and a\n  //   discretionary item\n  var connections = [];\n\n  var discretionaryConnections = {};\n\n  // list of cases to draw\n  var cases = [];\n\n  var handledDiscretionaryItems = {};\n\n  // list of elements (textAnnotations and caseFileItems)\n  var elementsWithoutParent = [];\n\n  var associations = [];\n\n  // Helpers /////////////////\n\n  function isDiscretionaryItemHandled(item) {\n    return !!handledDiscretionaryItems[item.id];\n  }\n\n  function handledDiscretionaryItem(item) {\n    handledDiscretionaryItems[item.id] = item;\n  }\n\n  /**\n   * Returns the surrounding 'cmmn:Case' element\n   *\n   * @param {ModdleElement} element\n   *\n   * @return {ModdleElement} the surrounding case\n   */\n  function getCase(element) {\n    while (element && !is(element, 'cmmn:Case')) {\n      element = element.$parent;\n    }\n    return element;\n  }\n\n  function visit(element, ctx) {\n    // call handler\n    return handler.element(element, ctx);\n  }\n\n  function visitRoot(element, diagram) {\n    return handler.root(element, diagram);\n  }\n\n  function visitIfDi(element, ctx) {\n    try {\n      handler.addItem(element);\n      return element.di && visit(element, ctx);\n    } catch (e) {\n      logError(e.message, { element: element, error: e });\n\n      console.error('failed to import ' + elementToString(element));\n      console.error(e);\n    }\n  }\n\n  function logError(message, context) {\n    handler.error(message, context);\n  }\n\n\n  function contextual(fn, ctx) {\n    return function(e) {\n      fn(e, ctx);\n    };\n  }\n\n  // DI handling /////////////////\n\n  function registerDi(di) {\n\n    var cmmnElement = di.cmmnElementRef;\n\n    if (cmmnElement && !is(di, 'cmmndi:CMMNEdge')) {\n\n      if (cmmnElement.di) {\n        logError('multiple DI elements defined for ' + elementToString(cmmnElement), { element: cmmnElement });\n      }\n      else {\n\n        var _case = getCase(cmmnElement);\n        if (_case && cases.indexOf(_case) === -1) {\n          // add _case to the list of cases\n          // that should be drawn\n          cases.push(_case);\n        }\n\n        if (is(cmmnElement, 'cmmn:TextAnnotation') || is(cmmnElement, 'cmmn:CaseFileItem')) {\n          elementsWithoutParent.push(cmmnElement);\n        }\n\n        diRefs.bind(cmmnElement, 'di');\n        cmmnElement.di = di;\n      }\n\n    }\n    else if (is(di, 'cmmndi:CMMNEdge')) {\n      var shouldHandle = true;\n\n      if (!isReferencingTarget(di)) {\n        shouldHandle = false;\n        logError('no target referenced in ' + elementToString(di), { element: di });\n      }\n\n      if (!isReferencingSource(di)) {\n        shouldHandle = false;\n        logError('no source referenced in ' + elementToString(di), { element: di });\n      }\n\n      if (shouldHandle) {\n\n        if (is(cmmnElement, 'cmmn:Association')) {\n          associations.push(di);\n        }\n        else if (!cmmnElement) {\n          var source = di.sourceCMMNElementRef;\n          discretionaryConnections[source.id] = discretionaryConnections[source.id] || [];\n          discretionaryConnections[source.id].push(di);\n        }\n        else {\n          connections.push(function(ctx) {\n            handleConnection(di, ctx);\n          });\n        }\n      }\n\n    }\n    else {\n      logError('no cmmnElement referenced in ' + elementToString(di), { element: di });\n    }\n  }\n\n  function isReferencingTarget(edge) {\n    if (is(edge.cmmnElementRef, 'cmmn:Association')) {\n      return !!edge.cmmnElementRef.targetRef;\n    }\n\n    return !!edge.targetCMMNElementRef;\n  }\n\n  function isReferencingSource(edge) {\n    if (is(edge.cmmnElementRef, 'cmmn:OnPart')) {\n      return !!(edge.cmmnElementRef.exitCriterionRef || edge.cmmnElementRef.sourceRef);\n    }\n\n    if (is(edge.cmmnElementRef, 'cmmn:Association')) {\n      return !!edge.cmmnElementRef.sourceRef;\n    }\n\n    return !!edge.sourceCMMNElementRef;\n  }\n\n  function handleConnection(connection, context) {\n    visit(connection, context);\n  }\n\n  function handleDiagram(diagram) {\n    handleDiagramElements(diagram.diagramElements);\n  }\n\n  function handleDiagramElements(diagramElements) {\n    forEach(diagramElements, handleDiagramElement);\n  }\n\n  function handleDiagramElement(diagramElement) {\n    registerDi(diagramElement);\n  }\n\n  // Semantic handling /////////////////\n\n  function handleDefinitions(definitions, diagram) {\n    // make sure we walk the correct cmmnElement\n\n    var cmmndi = definitions.CMMNDI;\n\n    // no di -> nothing to import\n    if (!cmmndi) {\n      return;\n    }\n\n    var diagrams = cmmndi.diagrams;\n\n    if (diagram && diagrams.indexOf(diagram) === -1) {\n      throw new Error('diagram not part of cmmn:Definitions');\n    }\n\n    if (!diagram && diagrams && diagrams.length) {\n      diagram = diagrams[0];\n    }\n\n    // handle only the first diagram and ignore others\n    handleDiagram(diagram);\n\n    var context = visitRoot(diagram, diagram);\n\n    handleCases(cases, context);\n\n    forEach(elementsWithoutParent, contextual(handleElementWithoutParent));\n    forEach(associations, contextual(handleAssociation));\n  }\n\n  function handleCases(cases, context) {\n    forEach(cases, function(_case) {\n      handleCase(_case, context);\n\n      // clear collections for the next iteration\n      deferred = [];\n      connections = [];\n    });\n  }\n\n  function handleCase(_case, context) {\n    var casePlanModel = _case.casePlanModel;\n\n    var casePlanModelContext;\n    if (casePlanModel) {\n      casePlanModelContext = handleCasePlanModel(casePlanModel, context);\n    }\n\n    handleDeferred(deferred);\n\n    forEach(connections, function(d) { d(casePlanModelContext); });\n\n  }\n\n  function handleCasePlanModel(casePlanModel, context) {\n    var newCtx = visitIfDi(casePlanModel, context);\n\n    forEach(casePlanModel.exitCriteria, contextual(handleCriterion, newCtx));\n\n    handlePlanFragment(casePlanModel, newCtx);\n    handleElementsWithoutParent(casePlanModel, newCtx);\n\n    return newCtx;\n  }\n\n  function handleDeferred(deferred) {\n    forEach(deferred, function(d) { d(); });\n  }\n\n  function handlePlanFragment(planFragment, context) {\n    handlePlanItems(planFragment.planItems, context);\n\n    if (is(planFragment, 'cmmn:Stage')) {\n      handleStage(planFragment, context);\n    }\n  }\n\n  function handleStage(stage, context) {\n    handlePlanningTable(stage.planningTable, context);\n  }\n\n  function handlePlanningTable(planningTable, context) {\n    if (planningTable) {\n      forEach(planningTable.tableItems, function(tableItem) {\n        if (is(tableItem, 'cmmn:DiscretionaryItem')) {\n          handleDiscretionaryItem(tableItem, context);\n        }\n        else if (is(tableItem, 'cmmn:PlanningTable')) {\n          handlePlanningTable(tableItem, context);\n        }\n      });\n    }\n  }\n\n  function handleDiscretionaryItem(discretionayItem, context) {\n    if (isDiscretionaryItemHandled(discretionayItem)) {\n      return;\n    }\n\n    handledDiscretionaryItem(discretionayItem);\n    handleItem(discretionayItem, context);\n  }\n\n  function handlePlanItems(planItems, context) {\n    forEach(planItems, contextual(handleItem, context));\n  }\n\n  function handleItem(item, context) {\n    var newCtx = visitIfDi(item, context);\n\n    forEach(item.exitCriteria, contextual(handleCriterion, context));\n    forEach(item.entryCriteria, contextual(handleCriterion, context));\n\n    var definitionRef = item.definitionRef;\n    if (is(definitionRef, 'cmmn:PlanFragment')) {\n      handlePlanFragment(definitionRef, newCtx);\n      handleElementsWithoutParent(item, newCtx);\n    }\n    else if (is(definitionRef, 'cmmn:HumanTask')) {\n      handlePlanningTable(definitionRef.planningTable, context);\n\n      var edges = discretionaryConnections[item.id];\n      forEach(edges, contextual(handleDiscretionaryConnection, context));\n      delete discretionaryConnections[item.id];\n\n    }\n  }\n\n  function handleCriterion(criterion, context) {\n    deferred.unshift(function() {\n      visitIfDi(criterion, context);\n    });\n  }\n\n  function handleElementsWithoutParent(container, context) {\n\n    if (container.di && container.di.bounds) {\n      var elements = getEnclosedElements(elementsWithoutParent, container);\n\n      forEach(elements, function(e) {\n        Collections.remove(elementsWithoutParent, e);\n        handleElementWithoutParent(e, context);\n      });\n    }\n\n  }\n\n  function handleElementWithoutParent(element, context) {\n    if (is(element, 'cmmn:TextAnnotation')) {\n      handleTextAnnotation(element, context);\n    }\n    else if (is(element, 'cmmn:CaseFileItem')) {\n      handleCaseFileItem(element, context);\n    }\n  }\n\n  function handleCaseFileItem(caseFileItem, context) {\n    visitIfDi(caseFileItem, context);\n  }\n\n  function handleTextAnnotation(annotation, context) {\n    visitIfDi(annotation, context);\n  }\n\n  function handleAssociation(association, context) {\n    visit(association, context);\n  }\n\n  function handleDiscretionaryConnection(connection, context) {\n    deferred.push(function() {\n      visit(connection, context);\n    });\n  }\n\n  function getEnclosedElements(elements, container) {\n    var bounds = container.di.bounds;\n    return filter(elements, function(e) {\n      return e.di.bounds.x > bounds.x &&\n             e.di.bounds.x < (bounds.x + bounds.width) &&\n             e.di.bounds.y > bounds.y &&\n             e.di.bounds.y < (bounds.y + bounds.height);\n    });\n  }\n\n  // API /////////////////\n\n  return {\n    handleDefinitions: handleDefinitions\n  };\n}\n\nmodule.exports = CmmnTreeWalker;\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/import/CmmnTreeWalker.js?")},"./node_modules/cmmn-js/lib/import/Importer.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar CmmnTreeWalker = __webpack_require__(\"./node_modules/cmmn-js/lib/import/CmmnTreeWalker.js\");\n\n\n/**\n * Import the definitions into a diagram.\n *\n * Errors and warnings are reported through the specified callback.\n *\n * @param  {Diagram} diagram\n * @param  {ModdleElement} definitions\n * @param  {Function} done the callback, invoked with (err, [ warning ]) once the import is done\n */\nfunction importCmmnDiagram(diagram, definitions, done) {\n\n  var importer = diagram.get('cmmnImporter'),\n      eventBus = diagram.get('eventBus'),\n      itemRegistry = diagram.get('itemRegistry');\n\n  var error,\n      warnings = [];\n\n  /**\n   * Walk the diagram semantically, importing (=drawing)\n   * all elements you encounter.\n   *\n   * @param {ModdleElement} definitions\n   */\n  function render(definitions) {\n\n    var visitor = {\n\n      root: function(element) {\n        return importer.root(element);\n      },\n\n      element: function(element, parentShape) {\n        return importer.add(element, parentShape);\n      },\n\n      error: function(message, context) {\n        warnings.push({ message: message, context: context });\n      },\n\n      addItem: function(item) {\n        itemRegistry.add(item);\n      }\n    };\n\n    var walker = new CmmnTreeWalker(visitor);\n\n    // import\n    walker.handleDefinitions(definitions);\n  }\n\n  eventBus.fire('import.render.start', { definitions: definitions });\n\n  try {\n    render(definitions);\n  } catch (e) {\n    error = e;\n  }\n\n  eventBus.fire('import.render.complete', {\n    error: error,\n    warnings: warnings\n  });\n\n  done(error, warnings);\n}\n\nmodule.exports.importCmmnDiagram = importCmmnDiagram;\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/import/Importer.js?")},"./node_modules/cmmn-js/lib/import/Util.js":module=>{"use strict";eval("\n\nmodule.exports.x = function(e) {\n  if (!e) {\n    return '<null>';\n  }\n\n  return '<' + e.$type + (e.id ? ' id=\"' + e.id : '') + '\" />';\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/import/Util.js?")},"./node_modules/cmmn-js/lib/import/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("module.exports = {\n  cmmnImporter: [ 'type', __webpack_require__(\"./node_modules/cmmn-js/lib/import/CmmnImporter.js\") ]\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/import/index.js?")},"./node_modules/cmmn-js/lib/util/DiUtil.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is),\n    getBusinessObject = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").getBusinessObject),\n    isCasePlanModel = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").isCasePlanModel);\n\nmodule.exports.isCollapsed = function(element) {\n\n  if (!isCasePlanModel(element)) {\n\n    element = getBusinessObject(element);\n\n    var definition = element.definitionRef;\n    if (is(definition, 'cmmn:PlanFragment')) {\n      return !!(element && element.di && element.di.isCollapsed);\n    }\n  }\n\n  return false;\n};\n\nmodule.exports.isPlanningTableCollapsed = function(element) {\n\n  element = getBusinessObject(element);\n\n  if (is(element, 'cmmn:Stage') ||\n     (element.definitionRef && (is(element.definitionRef, 'cmmn:Stage') ||\n      is(element.definitionRef, 'cmmn:HumanTask')))) {\n    return element.di && element.di.isPlanningTableCollapsed;\n  }\n\n  return false;\n};\n\nmodule.exports.isStandardEventVisible = function(element) {\n  element = getBusinessObject(element);\n  var cmmnElement = element.cmmnElementRef;\n  return !!(is(cmmnElement, 'cmmn:OnPart') && element.isStandardEventVisible);\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/util/DiUtil.js?")},"./node_modules/cmmn-js/lib/util/LabelUtil.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar is = (__webpack_require__(\"./node_modules/cmmn-js/lib/util/ModelUtil.js\").is);\nvar assign = (__webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\")/* .assign */ .f0);\n\nvar DEFAULT_LABEL_SIZE = module.exports.DEFAULT_LABEL_SIZE = {\n  width: 90,\n  height: 20\n};\n\n\n/**\n * Returns true if the given semantic has an external label\n *\n * @param {CmmnElement} semantic\n * @return {Boolean} true if has label\n */\nmodule.exports.hasExternalLabel = function(semantic) {\n\n  if (is(semantic, 'cmmn:PlanItem') || is(semantic, 'cmmn:DiscretionaryItem')) {\n    semantic = semantic.definitionRef;\n  }\n\n  if (is(semantic, 'cmmndi:CMMNEdge') && semantic.cmmnElementRef) {\n\n    if (is(semantic.cmmnElementRef, 'cmmn:OnPart')) {\n      semantic = semantic.cmmnElementRef;\n    }\n\n  }\n\n  return is(semantic, 'cmmn:EventListener') ||\n         is(semantic, 'cmmn:OnPart') ||\n         is(semantic, 'cmmn:CaseFileItem');\n};\n\n/**\n * Get the middle of a number of waypoints\n *\n * @param  {Array<Point>} waypoints\n * @return {Point} the mid point\n */\nvar getWaypointsMid = module.exports.getWaypointsMid = function(waypoints) {\n\n  var mid = waypoints.length / 2 - 1;\n\n  var first = waypoints[Math.floor(mid)];\n  var second = waypoints[Math.ceil(mid + 0.01)];\n\n  return {\n    x: first.x + (second.x - first.x) / 2,\n    y: first.y + (second.y - first.y) / 2\n  };\n};\n\n\nvar getExternalLabelMid = module.exports.getExternalLabelMid = function(element) {\n\n  var bo = element.businessObject,\n      di = bo.di;\n\n  if (!di && is(bo, 'cmmndi:CMMNEdge') && bo.cmmnElementRef) {\n    di = bo;\n  }\n\n  if (bo && di && di.waypoint) {\n    return getWaypointsMid(di.waypoint);\n  } else {\n    return {\n      x: element.x + element.width / 2,\n      y: element.y + element.height + DEFAULT_LABEL_SIZE.height / 2\n    };\n  }\n};\n\n/**\n * Returns the bounds of an elements label, parsed from the elements DI or\n * generated from its bounds.\n *\n * @param {CmmnElement} semantic\n * @param {djs.model.Base} element\n */\nmodule.exports.getExternalLabelBounds = function(semantic, element) {\n\n  var mid,\n      size,\n      bounds,\n      di = semantic.di || semantic,\n      label = di.label;\n\n  if (label && label.bounds) {\n    bounds = label.bounds;\n\n    size = {\n      width: Math.max(DEFAULT_LABEL_SIZE.width, bounds.width),\n      height: bounds.height\n    };\n\n    mid = {\n      x: bounds.x + bounds.width / 2,\n      y: bounds.y + bounds.height / 2\n    };\n  } else {\n\n    mid = getExternalLabelMid(element);\n\n    size = DEFAULT_LABEL_SIZE;\n  }\n\n  return assign({\n    x: mid.x - size.width / 2,\n    y: mid.y - size.height / 2\n  }, size);\n};\n\nvar hasLabelBounds = module.exports.hasLabelBounds = function(semantic) {\n  return semantic && semantic.di && semantic.di.label && semantic.di.label.bounds;\n};\n\nmodule.exports.getLabelBounds = function(semantic) {\n  if (hasLabelBounds(semantic)) {\n    return semantic.di.label.bounds;\n  }\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/util/LabelUtil.js?")},"./node_modules/cmmn-js/lib/util/ModelUtil.js":module=>{"use strict";eval("\n\nfunction isInstanceOf(bo, type) {\n  return !!(bo && ((typeof bo.$instanceOf === 'function') && bo.$instanceOf(type)));\n}\n\n/**\n * Is an element of the given CMMN type?\n *\n * @param  {djs.model.Base|ModdleElement} element\n * @param  {String} type\n *\n * @return {Boolean}\n */\nfunction is(element, type) {\n  return isInstanceOf(getBusinessObject(element), type);\n}\n\nmodule.exports.is = is;\n\n\n/**\n * Return the business object for a given element.\n *\n * @param  {djs.model.Base|ModdleElement} element\n *\n * @return {ModdleElement}\n */\nfunction getBusinessObject(element) {\n  return element && element.businessObject ? element.businessObject : element;\n}\n\nmodule.exports.getBusinessObject = getBusinessObject;\n\nfunction isCasePlanModel(element) {\n  element = getBusinessObject(element);\n  return is(element, 'cmmn:Stage') && element.$parent && is(element.$parent, 'cmmn:Case');\n}\n\nmodule.exports.isCasePlanModel = isCasePlanModel;\n\nfunction getDefinition(element) {\n  var bo = getBusinessObject(element);\n\n  if (is(element, 'cmmn:PlanItemDefinition') || is(element, 'cmmn:CaseFileItemDefinition')) {\n    return bo;\n  }\n\n  return bo && bo.definitionRef;\n}\n\nmodule.exports.getDefinition = getDefinition;\n\nfunction getDefaultControl(element) {\n  var definition = getDefinition(element);\n  return definition && definition.defaultControl;\n}\n\nmodule.exports.getDefaultControl = getDefaultControl;\n\nfunction getItemControl(element) {\n  element = getBusinessObject(element);\n  return element && element.itemControl;\n}\n\nmodule.exports.getItemControl = getItemControl;\n\n\nfunction getRule(element, rule) {\n  var itemControl = getItemControl(element),\n      defaultControl = getDefaultControl(element);\n\n  if (itemControl && itemControl[rule]) {\n    return itemControl[rule];\n  }\n\n  return defaultControl && defaultControl[rule];\n}\n\nfunction isRequired(element) {\n  return !!getRule(element, 'requiredRule');\n}\n\nmodule.exports.isRequired = isRequired;\n\nfunction isRepeatable(element) {\n  return !!getRule(element, 'repetitionRule');\n}\n\nmodule.exports.isRepeatable = isRepeatable;\n\nfunction isManualActivation(element) {\n  return !!getRule(element, 'manualActivationRule');\n}\n\nmodule.exports.isManualActivation = isManualActivation;\n\nfunction isAutoComplete(element) {\n  element = getBusinessObject(element);\n  var definition = getDefinition(element);\n  return element.autoComplete || (definition && definition.autoComplete);\n}\n\nmodule.exports.isAutoComplete = isAutoComplete;\n\nfunction hasPlanningTable(element) {\n  element = getBusinessObject(element);\n  return element.planningTable || (getDefinition(element) && getDefinition(element).planningTable);\n}\n\nmodule.exports.hasPlanningTable = hasPlanningTable;\n\nfunction getName(element) {\n  element = getBusinessObject(element);\n\n  if (is(element, 'cmmndi:CMMNEdge') && element.cmmnElementRef) {\n    element = element.cmmnElementRef;\n  }\n\n  var name = element.name;\n  if (!name) {\n\n    if (element.definitionRef) {\n      name = element.definitionRef.name;\n    }\n  }\n\n  return name;\n}\n\nmodule.exports.getName = getName;\n\n\n/**\n * Returns the referenced sentry, if present.\n *\n * @param {djs.model.Base} criterion\n *\n * @result {ModdleElement} referenced sentry\n */\nfunction getSentry(element) {\n  var bo = getBusinessObject(element);\n\n  if (is(bo, 'cmmn:Sentry')) {\n    return bo;\n  }\n\n  return bo && bo.sentryRef;\n}\n\nmodule.exports.getSentry = getSentry;\n\n\nfunction getStandardEvent(element) {\n  element = getBusinessObject(element);\n  return element.cmmnElementRef && element.cmmnElementRef.standardEvent;\n}\n\nmodule.exports.getStandardEvent = getStandardEvent;\n\nfunction getStandardEvents(element) {\n\n  if (is(element, 'cmmndi:CMMNEdge')) {\n    element = getBusinessObject(element).cmmnElementRef;\n  }\n\n  if (is(element, 'cmmn:OnPart')) {\n\n    if (is(element.exitCriterionRef, 'cmmn:ExitCriterion')) {\n      return [ 'exit' ];\n    }\n\n    return getTransitions(element.sourceRef);\n\n  }\n\n  return [];\n\n}\n\nmodule.exports.getStandardEvents = getStandardEvents;\n\n\nfunction getTransitions(element) {\n\n  element = getBusinessObject(element);\n\n  if (is(element, 'cmmn:CaseFileItem')) {\n\n    return [\n      'addChild',\n      'addReference',\n      'create',\n      'delete',\n      'removeChild',\n      'removeReference',\n      'replace',\n      'update'\n    ];\n\n  }\n\n  if (is(element, 'cmmn:PlanItem') || is(element, 'cmmn:DiscretionaryItem')) {\n\n    var definition = getDefinition(element);\n\n    if (is(definition, 'cmmn:EventListener') || is(definition, 'cmmn:Milestone')) {\n\n      return [\n        'create',\n        'occur',\n        'resume',\n        'suspend',\n        'terminate'\n      ];\n\n    }\n\n    return [\n      'complete',\n      'create',\n      'disable',\n      'enable',\n      'exit',\n      'fault',\n      'manualStart',\n      'parentResume',\n      'parentSuspend',\n      'reactivate',\n      'reenable',\n      'resume',\n      'start',\n      'suspend',\n      'terminate'\n    ];\n\n  }\n\n  if (isCasePlanModel(element)) {\n\n    return [\n      'close',\n      'complete',\n      'create',\n      'fault',\n      'reactivate',\n      'suspend',\n      'terminate'\n    ];\n\n  }\n\n  return [];\n\n}\n\nmodule.exports.getTransitions = getTransitions;\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/util/ModelUtil.js?")},"./node_modules/cmmn-js/lib/util/PoweredByUtil.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("/**\n * This file must not be changed or exchanged.\n *\n * @see http://bpmn.io/license for more information.\n */\n\n\n\nvar domify = (__webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\")/* .domify */ .H6);\n\nvar domDelegate = (__webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\")/* .delegate */ .cl);\n\n\n// inlined ../../resources/logo.svg\nvar BPMNIO_LOGO_SVG = '<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 14.02 5.57\" width=\"53\" height=\"21\" style=\"vertical-align:middle\"><path fill=\"currentColor\" d=\"M1.88.92v.14c0 .41-.13.68-.4.8.33.14.46.44.46.86v.33c0 .61-.33.95-.95.95H0V0h.95c.65 0 .93.3.93.92zM.63.57v1.06h.24c.24 0 .38-.1.38-.43V.98c0-.28-.1-.4-.32-.4zm0 1.63v1.22h.36c.2 0 .32-.1.32-.39v-.35c0-.37-.12-.48-.4-.48H.63zM4.18.99v.52c0 .64-.31.98-.94.98h-.3V4h-.62V0h.92c.63 0 .94.35.94.99zM2.94.57v1.35h.3c.2 0 .3-.09.3-.37v-.6c0-.29-.1-.38-.3-.38h-.3zm2.89 2.27L6.25 0h.88v4h-.6V1.12L6.1 3.99h-.6l-.46-2.82v2.82h-.55V0h.87zM8.14 1.1V4h-.56V0h.79L9 2.4V0h.56v4h-.64zm2.49 2.29v.6h-.6v-.6zM12.12 1c0-.63.33-1 .95-1 .61 0 .95.37.95 1v2.04c0 .64-.34 1-.95 1-.62 0-.95-.37-.95-1zm.62 2.08c0 .28.13.39.33.39s.32-.1.32-.4V.98c0-.29-.12-.4-.32-.4s-.33.11-.33.4z\"/><path fill=\"currentColor\" d=\"M0 4.53h14.02v1.04H0zM11.08 0h.63v.62h-.63zm.63 4V1h-.63v2.98z\"/></svg>';\n\nvar BPMNIO_IMG = BPMNIO_LOGO_SVG;\n\nfunction css(attrs) {\n  return attrs.join(';');\n}\n\nvar LINK_STYLES = css([\n  'color: #404040'\n]);\n\nvar LIGHTBOX_STYLES = css([\n  'z-index: 1001',\n  'position: fixed',\n  'top: 0',\n  'left: 0',\n  'right: 0',\n  'bottom: 0'\n]);\n\nvar BACKDROP_STYLES = css([\n  'width: 100%',\n  'height: 100%',\n  'background: rgba(40,40,40,0.2)'\n]);\n\nvar NOTICE_STYLES = css([\n  'position: absolute',\n  'left: 50%',\n  'top: 40%',\n  'transform: translate(-50%)',\n  'width: 260px',\n  'padding: 10px',\n  'background: white',\n  'box-shadow: 0 1px 4px rgba(0,0,0,0.3)',\n  'font-family: Helvetica, Arial, sans-serif',\n  'font-size: 14px',\n  'display: flex',\n  'line-height: 1.3'\n]);\n\nvar LIGHTBOX_MARKUP =\n  '<div class=\"bjs-powered-by-lightbox\" style=\"' + LIGHTBOX_STYLES + '\">' +\n    '<div class=\"backdrop\" style=\"' + BACKDROP_STYLES + '\"></div>' +\n    '<div class=\"notice\" style=\"' + NOTICE_STYLES + '\">' +\n      '<a href=\"https://bpmn.io\" target=\"_blank\" rel=\"noopener\" style=\"margin: 15px 20px 15px 10px; align-self: center;' + LINK_STYLES + '\">' +\n        BPMNIO_IMG +\n      '</a>' +\n      '<span>' +\n        'Web-based tooling for BPMN, DMN and CMMN diagrams ' +\n        'powered by <a href=\"https://bpmn.io\" target=\"_blank\" rel=\"noopener\">bpmn.io</a>.' +\n      '</span>' +\n    '</div>' +\n  '</div>';\n\n\nvar lightbox;\n\nfunction open() {\n\n  if (!lightbox) {\n    lightbox = domify(LIGHTBOX_MARKUP);\n\n    domDelegate.bind(lightbox, '.backdrop', 'click', function(event) {\n      document.body.removeChild(lightbox);\n    });\n  }\n\n  document.body.appendChild(lightbox);\n}\n\nmodule.exports.open = open;\n\nmodule.exports.BPMNIO_IMG = BPMNIO_IMG;\n\nmodule.exports.LINK_STYLES = LINK_STYLES;\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/lib/util/PoweredByUtil.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* reexport */ Diagram)\n});\n\n// EXTERNAL MODULE: ./node_modules/didi/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/didi/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/inherits/inherits_browser.js\nvar inherits_browser = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\nvar inherits_browser_default = /*#__PURE__*/__webpack_require__.n(inherits_browser);\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/draw/BaseRenderer.js\nvar BaseRenderer = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/draw/BaseRenderer.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/RenderUtil.js\nvar RenderUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/RenderUtil.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/draw/DefaultRenderer.js\n\n\n\n\n\n\n\n\n\n\n// apply default renderer with lowest possible priority\n// so that it only kicks in if noone else could render\nvar DEFAULT_RENDER_PRIORITY = 1;\n\n/**\n * The default renderer used for shapes and connections.\n *\n * @param {EventBus} eventBus\n * @param {Styles} styles\n */\nfunction DefaultRenderer(eventBus, styles) {\n  //\n  BaseRenderer/* default.call */.Z.call(this, eventBus, DEFAULT_RENDER_PRIORITY);\n\n  this.CONNECTION_STYLE = styles.style([ 'no-fill' ], { strokeWidth: 5, stroke: 'fuchsia' });\n  this.SHAPE_STYLE = styles.style({ fill: 'white', stroke: 'fuchsia', strokeWidth: 2 });\n  this.FRAME_STYLE = styles.style([ 'no-fill' ], { stroke: 'fuchsia', strokeDasharray: 4, strokeWidth: 2 });\n}\n\ninherits_browser_default()(DefaultRenderer, BaseRenderer/* default */.Z);\n\n\nDefaultRenderer.prototype.canRender = function() {\n  return true;\n};\n\nDefaultRenderer.prototype.drawShape = function drawShape(visuals, element) {\n  var rect = (0,dist_index_esm/* create */.Ue)('rect');\n\n  (0,dist_index_esm/* attr */.Lj)(rect, {\n    x: 0,\n    y: 0,\n    width: element.width || 0,\n    height: element.height || 0\n  });\n\n  if ((0,Elements/* isFrameElement */.He)(element)) {\n    (0,dist_index_esm/* attr */.Lj)(rect, this.FRAME_STYLE);\n  } else {\n    (0,dist_index_esm/* attr */.Lj)(rect, this.SHAPE_STYLE);\n  }\n\n  (0,dist_index_esm/* append */.R3)(visuals, rect);\n\n  return rect;\n};\n\nDefaultRenderer.prototype.drawConnection = function drawConnection(visuals, connection) {\n\n  var line = (0,RenderUtil/* createLine */.W5)(connection.waypoints, this.CONNECTION_STYLE);\n  (0,dist_index_esm/* append */.R3)(visuals, line);\n\n  return line;\n};\n\nDefaultRenderer.prototype.getShapePath = function getShapePath(shape) {\n\n  var x = shape.x,\n      y = shape.y,\n      width = shape.width,\n      height = shape.height;\n\n  var shapePath = [\n    ['M', x, y],\n    ['l', width, 0],\n    ['l', 0, height],\n    ['l', -width, 0],\n    ['z']\n  ];\n\n  return (0,RenderUtil/* componentsToPath */.KO)(shapePath);\n};\n\nDefaultRenderer.prototype.getConnectionPath = function getConnectionPath(connection) {\n  var waypoints = connection.waypoints;\n\n  var idx, point, connectionPath = [];\n\n  for (idx = 0; (point = waypoints[idx]); idx++) {\n\n    // take invisible docking into account\n    // when creating the path\n    point = point.original || point;\n\n    connectionPath.push([ idx === 0 ? 'M' : 'L', point.x, point.y ]);\n  }\n\n  return (0,RenderUtil/* componentsToPath */.KO)(connectionPath);\n};\n\n\nDefaultRenderer.$inject = [ 'eventBus', 'styles' ];\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar min_dash_dist_index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/draw/Styles.js\n\n\n\n/**\n * A component that manages shape styles\n */\nfunction Styles() {\n\n  var defaultTraits = {\n\n    'no-fill': {\n      fill: 'none'\n    },\n    'no-border': {\n      strokeOpacity: 0.0\n    },\n    'no-events': {\n      pointerEvents: 'none'\n    }\n  };\n\n  var self = this;\n\n  /**\n   * Builds a style definition from a className, a list of traits and an object of additional attributes.\n   *\n   * @param  {String} className\n   * @param  {Array<String>} traits\n   * @param  {Object} additionalAttrs\n   *\n   * @return {Object} the style defintion\n   */\n  this.cls = function(className, traits, additionalAttrs) {\n    var attrs = this.style(traits, additionalAttrs);\n\n    return (0,min_dash_dist_index_esm/* assign */.f0)(attrs, { 'class': className });\n  };\n\n  /**\n   * Builds a style definition from a list of traits and an object of additional attributes.\n   *\n   * @param  {Array<String>} traits\n   * @param  {Object} additionalAttrs\n   *\n   * @return {Object} the style defintion\n   */\n  this.style = function(traits, additionalAttrs) {\n\n    if (!(0,min_dash_dist_index_esm/* isArray */.kJ)(traits) && !additionalAttrs) {\n      additionalAttrs = traits;\n      traits = [];\n    }\n\n    var attrs = (0,min_dash_dist_index_esm/* reduce */.u4)(traits, function(attrs, t) {\n      return (0,min_dash_dist_index_esm/* assign */.f0)(attrs, defaultTraits[t] || {});\n    }, {});\n\n    return additionalAttrs ? (0,min_dash_dist_index_esm/* assign */.f0)(attrs, additionalAttrs) : attrs;\n  };\n\n  this.computeStyle = function(custom, traits, defaultStyles) {\n    if (!(0,min_dash_dist_index_esm/* isArray */.kJ)(traits)) {\n      defaultStyles = traits;\n      traits = [];\n    }\n\n    return self.style(traits || [], (0,min_dash_dist_index_esm/* assign */.f0)({}, defaultStyles, custom || {}));\n  };\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/draw/index.js\n\n\n\n/* harmony default export */ const draw = ({\n  __init__: [ 'defaultRenderer' ],\n  defaultRenderer: [ 'type', DefaultRenderer ],\n  styles: [ 'type', Styles ]\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/core/Canvas.js\n\n\n\n\n\n\n\n\n\n\n\nfunction round(number, resolution) {\n  return Math.round(number * resolution) / resolution;\n}\n\nfunction ensurePx(number) {\n  return (0,min_dash_dist_index_esm/* isNumber */.hj)(number) ? number + 'px' : number;\n}\n\n/**\n * Creates a HTML container element for a SVG element with\n * the given configuration\n *\n * @param  {Object} options\n * @return {HTMLElement} the container element\n */\nfunction createContainer(options) {\n\n  options = (0,min_dash_dist_index_esm/* assign */.f0)({}, { width: '100%', height: '100%' }, options);\n\n  var container = options.container || document.body;\n\n  // create a <div> around the svg element with the respective size\n  // this way we can always get the correct container size\n  // (this is impossible for <svg> elements at the moment)\n  var parent = document.createElement('div');\n  parent.setAttribute('class', 'djs-container');\n\n  (0,min_dash_dist_index_esm/* assign */.f0)(parent.style, {\n    position: 'relative',\n    overflow: 'hidden',\n    width: ensurePx(options.width),\n    height: ensurePx(options.height)\n  });\n\n  container.appendChild(parent);\n\n  return parent;\n}\n\nfunction createGroup(parent, cls, childIndex) {\n  var group = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* classes */.Sh)(group).add(cls);\n\n  var index = childIndex !== undefined ? childIndex : parent.childNodes.length - 1;\n\n  // must ensure second argument is node or _null_\n  // cf. https://developer.mozilla.org/en-US/docs/Web/API/Node/insertBefore\n  parent.insertBefore(group, parent.childNodes[index] || null);\n\n  return group;\n}\n\nvar BASE_LAYER = 'base';\n\n\nvar REQUIRED_MODEL_ATTRS = {\n  shape: [ 'x', 'y', 'width', 'height' ],\n  connection: [ 'waypoints' ]\n};\n\n/**\n * The main drawing canvas.\n *\n * @class\n * @constructor\n *\n * @emits Canvas#canvas.init\n *\n * @param {Object} config\n * @param {EventBus} eventBus\n * @param {GraphicsFactory} graphicsFactory\n * @param {ElementRegistry} elementRegistry\n */\nfunction Canvas(config, eventBus, graphicsFactory, elementRegistry) {\n\n  this._eventBus = eventBus;\n  this._elementRegistry = elementRegistry;\n  this._graphicsFactory = graphicsFactory;\n\n  this._init(config || {});\n}\n\nCanvas.$inject = [\n  'config.canvas',\n  'eventBus',\n  'graphicsFactory',\n  'elementRegistry'\n];\n\n\nCanvas.prototype._init = function(config) {\n\n  var eventBus = this._eventBus;\n\n  // Creates a <svg> element that is wrapped into a <div>.\n  // This way we are always able to correctly figure out the size of the svg element\n  // by querying the parent node.\n  //\n  // (It is not possible to get the size of a svg element cross browser @ 2014-04-01)\n  //\n  // <div class=\"djs-container\" style=\"width: {desired-width}, height: {desired-height}\">\n  //   <svg width=\"100%\" height=\"100%\">\n  //    ...\n  //   </svg>\n  // </div>\n\n  // html container\n  var container = this._container = createContainer(config);\n\n  var svg = this._svg = (0,dist_index_esm/* create */.Ue)('svg');\n  (0,dist_index_esm/* attr */.Lj)(svg, { width: '100%', height: '100%' });\n\n  (0,dist_index_esm/* append */.R3)(container, svg);\n\n  var viewport = this._viewport = createGroup(svg, 'viewport');\n\n  this._layers = {};\n\n  // debounce canvas.viewbox.changed events\n  // for smoother diagram interaction\n  if (config.deferUpdate !== false) {\n    this._viewboxChanged = (0,min_dash_dist_index_esm/* debounce */.Ds)((0,min_dash_dist_index_esm/* bind */.ak)(this._viewboxChanged, this), 300);\n  }\n\n  eventBus.on('diagram.init', function() {\n\n    /**\n     * An event indicating that the canvas is ready to be drawn on.\n     *\n     * @memberOf Canvas\n     *\n     * @event canvas.init\n     *\n     * @type {Object}\n     * @property {SVGElement} svg the created svg element\n     * @property {SVGElement} viewport the direct parent of diagram elements and shapes\n     */\n    eventBus.fire('canvas.init', {\n      svg: svg,\n      viewport: viewport\n    });\n\n  }, this);\n\n  // reset viewbox on shape changes to\n  // recompute the viewbox\n  eventBus.on([\n    'shape.added',\n    'connection.added',\n    'shape.removed',\n    'connection.removed',\n    'elements.changed'\n  ], function() {\n    delete this._cachedViewbox;\n  }, this);\n\n  eventBus.on('diagram.destroy', 500, this._destroy, this);\n  eventBus.on('diagram.clear', 500, this._clear, this);\n};\n\nCanvas.prototype._destroy = function(emit) {\n  this._eventBus.fire('canvas.destroy', {\n    svg: this._svg,\n    viewport: this._viewport\n  });\n\n  var parent = this._container.parentNode;\n\n  if (parent) {\n    parent.removeChild(this._container);\n  }\n\n  delete this._svg;\n  delete this._container;\n  delete this._layers;\n  delete this._rootElement;\n  delete this._viewport;\n};\n\nCanvas.prototype._clear = function() {\n\n  var self = this;\n\n  var allElements = this._elementRegistry.getAll();\n\n  // remove all elements\n  allElements.forEach(function(element) {\n    var type = (0,Elements/* getType */.oL)(element);\n\n    if (type === 'root') {\n      self.setRootElement(null, true);\n    } else {\n      self._removeElement(element, type);\n    }\n  });\n\n  // force recomputation of view box\n  delete this._cachedViewbox;\n};\n\n/**\n * Returns the default layer on which\n * all elements are drawn.\n *\n * @returns {SVGElement}\n */\nCanvas.prototype.getDefaultLayer = function() {\n  return this.getLayer(BASE_LAYER, 0);\n};\n\n/**\n * Returns a layer that is used to draw elements\n * or annotations on it.\n *\n * Non-existing layers retrieved through this method\n * will be created. During creation, the optional index\n * may be used to create layers below or above existing layers.\n * A layer with a certain index is always created above all\n * existing layers with the same index.\n *\n * @param {String} name\n * @param {Number} index\n *\n * @returns {SVGElement}\n */\nCanvas.prototype.getLayer = function(name, index) {\n\n  if (!name) {\n    throw new Error('must specify a name');\n  }\n\n  var layer = this._layers[name];\n\n  if (!layer) {\n    layer = this._layers[name] = this._createLayer(name, index);\n  }\n\n  // throw an error if layer creation / retrival is\n  // requested on different index\n  if (typeof index !== 'undefined' && layer.index !== index) {\n    throw new Error('layer <' + name + '> already created at index <' + index + '>');\n  }\n\n  return layer.group;\n};\n\n/**\n * Creates a given layer and returns it.\n *\n * @param {String} name\n * @param {Number} [index=0]\n *\n * @return {Object} layer descriptor with { index, group: SVGGroup }\n */\nCanvas.prototype._createLayer = function(name, index) {\n\n  if (!index) {\n    index = 0;\n  }\n\n  var childIndex = (0,min_dash_dist_index_esm/* reduce */.u4)(this._layers, function(childIndex, layer) {\n    if (index >= layer.index) {\n      childIndex++;\n    }\n\n    return childIndex;\n  }, 0);\n\n  return {\n    group: createGroup(this._viewport, 'layer-' + name, childIndex),\n    index: index\n  };\n\n};\n\n/**\n * Returns the html element that encloses the\n * drawing canvas.\n *\n * @return {DOMNode}\n */\nCanvas.prototype.getContainer = function() {\n  return this._container;\n};\n\n\n// markers //////////////////////\n\nCanvas.prototype._updateMarker = function(element, marker, add) {\n  var container;\n\n  if (!element.id) {\n    element = this._elementRegistry.get(element);\n  }\n\n  // we need to access all\n  container = this._elementRegistry._elements[element.id];\n\n  if (!container) {\n    return;\n  }\n\n  (0,min_dash_dist_index_esm/* forEach */.Ed)([ container.gfx, container.secondaryGfx ], function(gfx) {\n    if (gfx) {\n      // invoke either addClass or removeClass based on mode\n      if (add) {\n        (0,dist_index_esm/* classes */.Sh)(gfx).add(marker);\n      } else {\n        (0,dist_index_esm/* classes */.Sh)(gfx).remove(marker);\n      }\n    }\n  });\n\n  /**\n   * An event indicating that a marker has been updated for an element\n   *\n   * @event element.marker.update\n   * @type {Object}\n   * @property {djs.model.Element} element the shape\n   * @property {Object} gfx the graphical representation of the shape\n   * @property {String} marker\n   * @property {Boolean} add true if the marker was added, false if it got removed\n   */\n  this._eventBus.fire('element.marker.update', { element: element, gfx: container.gfx, marker: marker, add: !!add });\n};\n\n\n/**\n * Adds a marker to an element (basically a css class).\n *\n * Fires the element.marker.update event, making it possible to\n * integrate extension into the marker life-cycle, too.\n *\n * @example\n * canvas.addMarker('foo', 'some-marker');\n *\n * var fooGfx = canvas.getGraphics('foo');\n *\n * fooGfx; // <g class=\"... some-marker\"> ... </g>\n *\n * @param {String|djs.model.Base} element\n * @param {String} marker\n */\nCanvas.prototype.addMarker = function(element, marker) {\n  this._updateMarker(element, marker, true);\n};\n\n\n/**\n * Remove a marker from an element.\n *\n * Fires the element.marker.update event, making it possible to\n * integrate extension into the marker life-cycle, too.\n *\n * @param  {String|djs.model.Base} element\n * @param  {String} marker\n */\nCanvas.prototype.removeMarker = function(element, marker) {\n  this._updateMarker(element, marker, false);\n};\n\n/**\n * Check the existence of a marker on element.\n *\n * @param  {String|djs.model.Base} element\n * @param  {String} marker\n */\nCanvas.prototype.hasMarker = function(element, marker) {\n  if (!element.id) {\n    element = this._elementRegistry.get(element);\n  }\n\n  var gfx = this.getGraphics(element);\n\n  return (0,dist_index_esm/* classes */.Sh)(gfx).has(marker);\n};\n\n/**\n * Toggles a marker on an element.\n *\n * Fires the element.marker.update event, making it possible to\n * integrate extension into the marker life-cycle, too.\n *\n * @param  {String|djs.model.Base} element\n * @param  {String} marker\n */\nCanvas.prototype.toggleMarker = function(element, marker) {\n  if (this.hasMarker(element, marker)) {\n    this.removeMarker(element, marker);\n  } else {\n    this.addMarker(element, marker);\n  }\n};\n\nCanvas.prototype.getRootElement = function() {\n  if (!this._rootElement) {\n    this.setRootElement({ id: '__implicitroot', children: [] });\n  }\n\n  return this._rootElement;\n};\n\n\n\n// root element handling //////////////////////\n\n/**\n * Sets a given element as the new root element for the canvas\n * and returns the new root element.\n *\n * @param {Object|djs.model.Root} element\n * @param {Boolean} [override] whether to override the current root element, if any\n *\n * @return {Object|djs.model.Root} new root element\n */\nCanvas.prototype.setRootElement = function(element, override) {\n\n  if (element) {\n    this._ensureValid('root', element);\n  }\n\n  var currentRoot = this._rootElement,\n      elementRegistry = this._elementRegistry,\n      eventBus = this._eventBus;\n\n  if (currentRoot) {\n    if (!override) {\n      throw new Error('rootElement already set, need to specify override');\n    }\n\n    // simulate element remove event sequence\n    eventBus.fire('root.remove', { element: currentRoot });\n    eventBus.fire('root.removed', { element: currentRoot });\n\n    elementRegistry.remove(currentRoot);\n  }\n\n  if (element) {\n    var gfx = this.getDefaultLayer();\n\n    // resemble element add event sequence\n    eventBus.fire('root.add', { element: element });\n\n    elementRegistry.add(element, gfx, this._svg);\n\n    eventBus.fire('root.added', { element: element, gfx: gfx });\n  }\n\n  this._rootElement = element;\n\n  return element;\n};\n\n\n\n// add functionality //////////////////////\n\nCanvas.prototype._ensureValid = function(type, element) {\n  if (!element.id) {\n    throw new Error('element must have an id');\n  }\n\n  if (this._elementRegistry.get(element.id)) {\n    throw new Error('element with id ' + element.id + ' already exists');\n  }\n\n  var requiredAttrs = REQUIRED_MODEL_ATTRS[type];\n\n  var valid = (0,min_dash_dist_index_esm/* every */.yW)(requiredAttrs, function(attr) {\n    return typeof element[attr] !== 'undefined';\n  });\n\n  if (!valid) {\n    throw new Error(\n      'must supply { ' + requiredAttrs.join(', ') + ' } with ' + type);\n  }\n};\n\nCanvas.prototype._setParent = function(element, parent, parentIndex) {\n  (0,Collections.add)(parent.children, element, parentIndex);\n  element.parent = parent;\n};\n\n/**\n * Adds an element to the canvas.\n *\n * This wires the parent <-> child relationship between the element and\n * a explicitly specified parent or an implicit root element.\n *\n * During add it emits the events\n *\n *  * <{type}.add> (element, parent)\n *  * <{type}.added> (element, gfx)\n *\n * Extensions may hook into these events to perform their magic.\n *\n * @param {String} type\n * @param {Object|djs.model.Base} element\n * @param {Object|djs.model.Base} [parent]\n * @param {Number} [parentIndex]\n *\n * @return {Object|djs.model.Base} the added element\n */\nCanvas.prototype._addElement = function(type, element, parent, parentIndex) {\n\n  parent = parent || this.getRootElement();\n\n  var eventBus = this._eventBus,\n      graphicsFactory = this._graphicsFactory;\n\n  this._ensureValid(type, element);\n\n  eventBus.fire(type + '.add', { element: element, parent: parent });\n\n  this._setParent(element, parent, parentIndex);\n\n  // create graphics\n  var gfx = graphicsFactory.create(type, element, parentIndex);\n\n  this._elementRegistry.add(element, gfx);\n\n  // update its visual\n  graphicsFactory.update(type, element, gfx);\n\n  eventBus.fire(type + '.added', { element: element, gfx: gfx });\n\n  return element;\n};\n\n/**\n * Adds a shape to the canvas\n *\n * @param {Object|djs.model.Shape} shape to add to the diagram\n * @param {djs.model.Base} [parent]\n * @param {Number} [parentIndex]\n *\n * @return {djs.model.Shape} the added shape\n */\nCanvas.prototype.addShape = function(shape, parent, parentIndex) {\n  return this._addElement('shape', shape, parent, parentIndex);\n};\n\n/**\n * Adds a connection to the canvas\n *\n * @param {Object|djs.model.Connection} connection to add to the diagram\n * @param {djs.model.Base} [parent]\n * @param {Number} [parentIndex]\n *\n * @return {djs.model.Connection} the added connection\n */\nCanvas.prototype.addConnection = function(connection, parent, parentIndex) {\n  return this._addElement('connection', connection, parent, parentIndex);\n};\n\n\n/**\n * Internal remove element\n */\nCanvas.prototype._removeElement = function(element, type) {\n\n  var elementRegistry = this._elementRegistry,\n      graphicsFactory = this._graphicsFactory,\n      eventBus = this._eventBus;\n\n  element = elementRegistry.get(element.id || element);\n\n  if (!element) {\n    // element was removed already\n    return;\n  }\n\n  eventBus.fire(type + '.remove', { element: element });\n\n  graphicsFactory.remove(element);\n\n  // unset parent <-> child relationship\n  (0,Collections.remove)(element.parent && element.parent.children, element);\n  element.parent = null;\n\n  eventBus.fire(type + '.removed', { element: element });\n\n  elementRegistry.remove(element);\n\n  return element;\n};\n\n\n/**\n * Removes a shape from the canvas\n *\n * @param {String|djs.model.Shape} shape or shape id to be removed\n *\n * @return {djs.model.Shape} the removed shape\n */\nCanvas.prototype.removeShape = function(shape) {\n\n  /**\n   * An event indicating that a shape is about to be removed from the canvas.\n   *\n   * @memberOf Canvas\n   *\n   * @event shape.remove\n   * @type {Object}\n   * @property {djs.model.Shape} element the shape descriptor\n   * @property {Object} gfx the graphical representation of the shape\n   */\n\n  /**\n   * An event indicating that a shape has been removed from the canvas.\n   *\n   * @memberOf Canvas\n   *\n   * @event shape.removed\n   * @type {Object}\n   * @property {djs.model.Shape} element the shape descriptor\n   * @property {Object} gfx the graphical representation of the shape\n   */\n  return this._removeElement(shape, 'shape');\n};\n\n\n/**\n * Removes a connection from the canvas\n *\n * @param {String|djs.model.Connection} connection or connection id to be removed\n *\n * @return {djs.model.Connection} the removed connection\n */\nCanvas.prototype.removeConnection = function(connection) {\n\n  /**\n   * An event indicating that a connection is about to be removed from the canvas.\n   *\n   * @memberOf Canvas\n   *\n   * @event connection.remove\n   * @type {Object}\n   * @property {djs.model.Connection} element the connection descriptor\n   * @property {Object} gfx the graphical representation of the connection\n   */\n\n  /**\n   * An event indicating that a connection has been removed from the canvas.\n   *\n   * @memberOf Canvas\n   *\n   * @event connection.removed\n   * @type {Object}\n   * @property {djs.model.Connection} element the connection descriptor\n   * @property {Object} gfx the graphical representation of the connection\n   */\n  return this._removeElement(connection, 'connection');\n};\n\n\n/**\n * Return the graphical object underlaying a certain diagram element\n *\n * @param {String|djs.model.Base} element descriptor of the element\n * @param {Boolean} [secondary=false] whether to return the secondary connected element\n *\n * @return {SVGElement}\n */\nCanvas.prototype.getGraphics = function(element, secondary) {\n  return this._elementRegistry.getGraphics(element, secondary);\n};\n\n\n/**\n * Perform a viewbox update via a given change function.\n *\n * @param {Function} changeFn\n */\nCanvas.prototype._changeViewbox = function(changeFn) {\n\n  // notify others of the upcoming viewbox change\n  this._eventBus.fire('canvas.viewbox.changing');\n\n  // perform actual change\n  changeFn.apply(this);\n\n  // reset the cached viewbox so that\n  // a new get operation on viewbox or zoom\n  // triggers a viewbox re-computation\n  this._cachedViewbox = null;\n\n  // notify others of the change; this step\n  // may or may not be debounced\n  this._viewboxChanged();\n};\n\nCanvas.prototype._viewboxChanged = function() {\n  this._eventBus.fire('canvas.viewbox.changed', { viewbox: this.viewbox() });\n};\n\n\n/**\n * Gets or sets the view box of the canvas, i.e. the\n * area that is currently displayed.\n *\n * The getter may return a cached viewbox (if it is currently\n * changing). To force a recomputation, pass `false` as the first argument.\n *\n * @example\n *\n * canvas.viewbox({ x: 100, y: 100, width: 500, height: 500 })\n *\n * // sets the visible area of the diagram to (100|100) -> (600|100)\n * // and and scales it according to the diagram width\n *\n * var viewbox = canvas.viewbox(); // pass `false` to force recomputing the box.\n *\n * console.log(viewbox);\n * // {\n * //   inner: Dimensions,\n * //   outer: Dimensions,\n * //   scale,\n * //   x, y,\n * //   width, height\n * // }\n *\n * // if the current diagram is zoomed and scrolled, you may reset it to the\n * // default zoom via this method, too:\n *\n * var zoomedAndScrolledViewbox = canvas.viewbox();\n *\n * canvas.viewbox({\n *   x: 0,\n *   y: 0,\n *   width: zoomedAndScrolledViewbox.outer.width,\n *   height: zoomedAndScrolledViewbox.outer.height\n * });\n *\n * @param  {Object} [box] the new view box to set\n * @param  {Number} box.x the top left X coordinate of the canvas visible in view box\n * @param  {Number} box.y the top left Y coordinate of the canvas visible in view box\n * @param  {Number} box.width the visible width\n * @param  {Number} box.height\n *\n * @return {Object} the current view box\n */\nCanvas.prototype.viewbox = function(box) {\n\n  if (box === undefined && this._cachedViewbox) {\n    return this._cachedViewbox;\n  }\n\n  var viewport = this._viewport,\n      innerBox,\n      outerBox = this.getSize(),\n      matrix,\n      transform,\n      scale,\n      x, y;\n\n  if (!box) {\n    // compute the inner box based on the\n    // diagrams default layer. This allows us to exclude\n    // external components, such as overlays\n    innerBox = this.getDefaultLayer().getBBox();\n\n    transform = (0,dist_index_esm/* transform */.vs)(viewport);\n    matrix = transform ? transform.matrix : (0,dist_index_esm/* createMatrix */.wz)();\n    scale = round(matrix.a, 1000);\n\n    x = round(-matrix.e || 0, 1000);\n    y = round(-matrix.f || 0, 1000);\n\n    box = this._cachedViewbox = {\n      x: x ? x / scale : 0,\n      y: y ? y / scale : 0,\n      width: outerBox.width / scale,\n      height: outerBox.height / scale,\n      scale: scale,\n      inner: {\n        width: innerBox.width,\n        height: innerBox.height,\n        x: innerBox.x,\n        y: innerBox.y\n      },\n      outer: outerBox\n    };\n\n    return box;\n  } else {\n\n    this._changeViewbox(function() {\n      scale = Math.min(outerBox.width / box.width, outerBox.height / box.height);\n\n      var matrix = this._svg.createSVGMatrix()\n        .scale(scale)\n        .translate(-box.x, -box.y);\n\n      (0,dist_index_esm/* transform */.vs)(viewport, matrix);\n    });\n  }\n\n  return box;\n};\n\n\n/**\n * Gets or sets the scroll of the canvas.\n *\n * @param {Object} [delta] the new scroll to apply.\n *\n * @param {Number} [delta.dx]\n * @param {Number} [delta.dy]\n */\nCanvas.prototype.scroll = function(delta) {\n\n  var node = this._viewport;\n  var matrix = node.getCTM();\n\n  if (delta) {\n    this._changeViewbox(function() {\n      delta = (0,min_dash_dist_index_esm/* assign */.f0)({ dx: 0, dy: 0 }, delta || {});\n\n      matrix = this._svg.createSVGMatrix().translate(delta.dx, delta.dy).multiply(matrix);\n\n      setCTM(node, matrix);\n    });\n  }\n\n  return { x: matrix.e, y: matrix.f };\n};\n\n\n/**\n * Gets or sets the current zoom of the canvas, optionally zooming\n * to the specified position.\n *\n * The getter may return a cached zoom level. Call it with `false` as\n * the first argument to force recomputation of the current level.\n *\n * @param {String|Number} [newScale] the new zoom level, either a number, i.e. 0.9,\n *                                   or `fit-viewport` to adjust the size to fit the current viewport\n * @param {String|Point} [center] the reference point { x: .., y: ..} to zoom to, 'auto' to zoom into mid or null\n *\n * @return {Number} the current scale\n */\nCanvas.prototype.zoom = function(newScale, center) {\n\n  if (!newScale) {\n    return this.viewbox(newScale).scale;\n  }\n\n  if (newScale === 'fit-viewport') {\n    return this._fitViewport(center);\n  }\n\n  var outer,\n      matrix;\n\n  this._changeViewbox(function() {\n\n    if (typeof center !== 'object') {\n      outer = this.viewbox().outer;\n\n      center = {\n        x: outer.width / 2,\n        y: outer.height / 2\n      };\n    }\n\n    matrix = this._setZoom(newScale, center);\n  });\n\n  return round(matrix.a, 1000);\n};\n\nfunction setCTM(node, m) {\n  var mstr = 'matrix(' + m.a + ',' + m.b + ',' + m.c + ',' + m.d + ',' + m.e + ',' + m.f + ')';\n  node.setAttribute('transform', mstr);\n}\n\nCanvas.prototype._fitViewport = function(center) {\n\n  var vbox = this.viewbox(),\n      outer = vbox.outer,\n      inner = vbox.inner,\n      newScale,\n      newViewbox;\n\n  // display the complete diagram without zooming in.\n  // instead of relying on internal zoom, we perform a\n  // hard reset on the canvas viewbox to realize this\n  //\n  // if diagram does not need to be zoomed in, we focus it around\n  // the diagram origin instead\n\n  if (inner.x >= 0 &&\n      inner.y >= 0 &&\n      inner.x + inner.width <= outer.width &&\n      inner.y + inner.height <= outer.height &&\n      !center) {\n\n    newViewbox = {\n      x: 0,\n      y: 0,\n      width: Math.max(inner.width + inner.x, outer.width),\n      height: Math.max(inner.height + inner.y, outer.height)\n    };\n  } else {\n\n    newScale = Math.min(1, outer.width / inner.width, outer.height / inner.height);\n    newViewbox = {\n      x: inner.x + (center ? inner.width / 2 - outer.width / newScale / 2 : 0),\n      y: inner.y + (center ? inner.height / 2 - outer.height / newScale / 2 : 0),\n      width: outer.width / newScale,\n      height: outer.height / newScale\n    };\n  }\n\n  this.viewbox(newViewbox);\n\n  return this.viewbox(false).scale;\n};\n\n\nCanvas.prototype._setZoom = function(scale, center) {\n\n  var svg = this._svg,\n      viewport = this._viewport;\n\n  var matrix = svg.createSVGMatrix();\n  var point = svg.createSVGPoint();\n\n  var centerPoint,\n      originalPoint,\n      currentMatrix,\n      scaleMatrix,\n      newMatrix;\n\n  currentMatrix = viewport.getCTM();\n\n  var currentScale = currentMatrix.a;\n\n  if (center) {\n    centerPoint = (0,min_dash_dist_index_esm/* assign */.f0)(point, center);\n\n    // revert applied viewport transformations\n    originalPoint = centerPoint.matrixTransform(currentMatrix.inverse());\n\n    // create scale matrix\n    scaleMatrix = matrix\n      .translate(originalPoint.x, originalPoint.y)\n      .scale(1 / currentScale * scale)\n      .translate(-originalPoint.x, -originalPoint.y);\n\n    newMatrix = currentMatrix.multiply(scaleMatrix);\n  } else {\n    newMatrix = matrix.scale(scale);\n  }\n\n  setCTM(this._viewport, newMatrix);\n\n  return newMatrix;\n};\n\n\n/**\n * Returns the size of the canvas\n *\n * @return {Dimensions}\n */\nCanvas.prototype.getSize = function() {\n  return {\n    width: this._container.clientWidth,\n    height: this._container.clientHeight\n  };\n};\n\n\n/**\n * Return the absolute bounding box for the given element\n *\n * The absolute bounding box may be used to display overlays in the\n * callers (browser) coordinate system rather than the zoomed in/out\n * canvas coordinates.\n *\n * @param  {ElementDescriptor} element\n * @return {Bounds} the absolute bounding box\n */\nCanvas.prototype.getAbsoluteBBox = function(element) {\n  var vbox = this.viewbox();\n  var bbox;\n\n  // connection\n  // use svg bbox\n  if (element.waypoints) {\n    var gfx = this.getGraphics(element);\n\n    bbox = gfx.getBBox();\n  }\n  // shapes\n  // use data\n  else {\n    bbox = element;\n  }\n\n  var x = bbox.x * vbox.scale - vbox.x * vbox.scale;\n  var y = bbox.y * vbox.scale - vbox.y * vbox.scale;\n\n  var width = bbox.width * vbox.scale;\n  var height = bbox.height * vbox.scale;\n\n  return {\n    x: x,\n    y: y,\n    width: width,\n    height: height\n  };\n};\n\n/**\n * Fires an event in order other modules can react to the\n * canvas resizing\n */\nCanvas.prototype.resized = function() {\n\n  // force recomputation of view box\n  delete this._cachedViewbox;\n\n  this._eventBus.fire('canvas.resized');\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/core/ElementRegistry.js\nvar ELEMENT_ID = 'data-element-id';\n\n\n\n\n/**\n * @class\n *\n * A registry that keeps track of all shapes in the diagram.\n */\nfunction ElementRegistry(eventBus) {\n  this._elements = {};\n\n  this._eventBus = eventBus;\n}\n\nElementRegistry.$inject = [ 'eventBus' ];\n\n/**\n * Register a pair of (element, gfx, (secondaryGfx)).\n *\n * @param {djs.model.Base} element\n * @param {SVGElement} gfx\n * @param {SVGElement} [secondaryGfx] optional other element to register, too\n */\nElementRegistry.prototype.add = function(element, gfx, secondaryGfx) {\n\n  var id = element.id;\n\n  this._validateId(id);\n\n  // associate dom node with element\n  (0,dist_index_esm/* attr */.Lj)(gfx, ELEMENT_ID, id);\n\n  if (secondaryGfx) {\n    (0,dist_index_esm/* attr */.Lj)(secondaryGfx, ELEMENT_ID, id);\n  }\n\n  this._elements[id] = { element: element, gfx: gfx, secondaryGfx: secondaryGfx };\n};\n\n/**\n * Removes an element from the registry.\n *\n * @param {djs.model.Base} element\n */\nElementRegistry.prototype.remove = function(element) {\n  var elements = this._elements,\n      id = element.id || element,\n      container = id && elements[id];\n\n  if (container) {\n\n    // unset element id on gfx\n    (0,dist_index_esm/* attr */.Lj)(container.gfx, ELEMENT_ID, '');\n\n    if (container.secondaryGfx) {\n      (0,dist_index_esm/* attr */.Lj)(container.secondaryGfx, ELEMENT_ID, '');\n    }\n\n    delete elements[id];\n  }\n};\n\n/**\n * Update the id of an element\n *\n * @param {djs.model.Base} element\n * @param {String} newId\n */\nElementRegistry.prototype.updateId = function(element, newId) {\n\n  this._validateId(newId);\n\n  if (typeof element === 'string') {\n    element = this.get(element);\n  }\n\n  this._eventBus.fire('element.updateId', {\n    element: element,\n    newId: newId\n  });\n\n  var gfx = this.getGraphics(element),\n      secondaryGfx = this.getGraphics(element, true);\n\n  this.remove(element);\n\n  element.id = newId;\n\n  this.add(element, gfx, secondaryGfx);\n};\n\n/**\n * Return the model element for a given id or graphics.\n *\n * @example\n *\n * elementRegistry.get('SomeElementId_1');\n * elementRegistry.get(gfx);\n *\n *\n * @param {String|SVGElement} filter for selecting the element\n *\n * @return {djs.model.Base}\n */\nElementRegistry.prototype.get = function(filter) {\n  var id;\n\n  if (typeof filter === 'string') {\n    id = filter;\n  } else {\n    id = filter && (0,dist_index_esm/* attr */.Lj)(filter, ELEMENT_ID);\n  }\n\n  var container = this._elements[id];\n  return container && container.element;\n};\n\n/**\n * Return all elements that match a given filter function.\n *\n * @param {Function} fn\n *\n * @return {Array<djs.model.Base>}\n */\nElementRegistry.prototype.filter = function(fn) {\n\n  var filtered = [];\n\n  this.forEach(function(element, gfx) {\n    if (fn(element, gfx)) {\n      filtered.push(element);\n    }\n  });\n\n  return filtered;\n};\n\n/**\n * Return all rendered model elements.\n *\n * @return {Array<djs.model.Base>}\n */\nElementRegistry.prototype.getAll = function() {\n  return this.filter(function(e) { return e; });\n};\n\n/**\n * Iterate over all diagram elements.\n *\n * @param {Function} fn\n */\nElementRegistry.prototype.forEach = function(fn) {\n\n  var map = this._elements;\n\n  Object.keys(map).forEach(function(id) {\n    var container = map[id],\n        element = container.element,\n        gfx = container.gfx;\n\n    return fn(element, gfx);\n  });\n};\n\n/**\n * Return the graphical representation of an element or its id.\n *\n * @example\n * elementRegistry.getGraphics('SomeElementId_1');\n * elementRegistry.getGraphics(rootElement); // <g ...>\n *\n * elementRegistry.getGraphics(rootElement, true); // <svg ...>\n *\n *\n * @param {String|djs.model.Base} filter\n * @param {Boolean} [secondary=false] whether to return the secondary connected element\n *\n * @return {SVGElement}\n */\nElementRegistry.prototype.getGraphics = function(filter, secondary) {\n  var id = filter.id || filter;\n\n  var container = this._elements[id];\n  return container && (secondary ? container.secondaryGfx : container.gfx);\n};\n\n/**\n * Validate the suitability of the given id and signals a problem\n * with an exception.\n *\n * @param {String} id\n *\n * @throws {Error} if id is empty or already assigned\n */\nElementRegistry.prototype._validateId = function(id) {\n  if (!id) {\n    throw new Error('element must have an id');\n  }\n\n  if (this._elements[id]) {\n    throw new Error('element with id ' + id + ' already added');\n  }\n};\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/core/ElementFactory.js\nvar ElementFactory = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/core/ElementFactory.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/core/EventBus.js\n\n\nvar FN_REF = '__fn';\n\nvar DEFAULT_PRIORITY = 1000;\n\nvar slice = Array.prototype.slice;\n\n/**\n * A general purpose event bus.\n *\n * This component is used to communicate across a diagram instance.\n * Other parts of a diagram can use it to listen to and broadcast events.\n *\n *\n * ## Registering for Events\n *\n * The event bus provides the {@link EventBus#on} and {@link EventBus#once}\n * methods to register for events. {@link EventBus#off} can be used to\n * remove event registrations. Listeners receive an instance of {@link Event}\n * as the first argument. It allows them to hook into the event execution.\n *\n * ```javascript\n *\n * // listen for event\n * eventBus.on('foo', function(event) {\n *\n *   // access event type\n *   event.type; // 'foo'\n *\n *   // stop propagation to other listeners\n *   event.stopPropagation();\n *\n *   // prevent event default\n *   event.preventDefault();\n * });\n *\n * // listen for event with custom payload\n * eventBus.on('bar', function(event, payload) {\n *   console.log(payload);\n * });\n *\n * // listen for event returning value\n * eventBus.on('foobar', function(event) {\n *\n *   // stop event propagation + prevent default\n *   return false;\n *\n *   // stop event propagation + return custom result\n *   return {\n *     complex: 'listening result'\n *   };\n * });\n *\n *\n * // listen with custom priority (default=1000, higher is better)\n * eventBus.on('priorityfoo', 1500, function(event) {\n *   console.log('invoked first!');\n * });\n *\n *\n * // listen for event and pass the context (`this`)\n * eventBus.on('foobar', function(event) {\n *   this.foo();\n * }, this);\n * ```\n *\n *\n * ## Emitting Events\n *\n * Events can be emitted via the event bus using {@link EventBus#fire}.\n *\n * ```javascript\n *\n * // false indicates that the default action\n * // was prevented by listeners\n * if (eventBus.fire('foo') === false) {\n *   console.log('default has been prevented!');\n * };\n *\n *\n * // custom args + return value listener\n * eventBus.on('sum', function(event, a, b) {\n *   return a + b;\n * });\n *\n * // you can pass custom arguments + retrieve result values.\n * var sum = eventBus.fire('sum', 1, 2);\n * console.log(sum); // 3\n * ```\n */\nfunction EventBus() {\n  this._listeners = {};\n\n  // cleanup on destroy on lowest priority to allow\n  // message passing until the bitter end\n  this.on('diagram.destroy', 1, this._destroy, this);\n}\n\n\n/**\n * Register an event listener for events with the given name.\n *\n * The callback will be invoked with `event, ...additionalArguments`\n * that have been passed to {@link EventBus#fire}.\n *\n * Returning false from a listener will prevent the events default action\n * (if any is specified). To stop an event from being processed further in\n * other listeners execute {@link Event#stopPropagation}.\n *\n * Returning anything but `undefined` from a listener will stop the listener propagation.\n *\n * @param {String|Array<String>} events\n * @param {Number} [priority=1000] the priority in which this listener is called, larger is higher\n * @param {Function} callback\n * @param {Object} [that] Pass context (`this`) to the callback\n */\nEventBus.prototype.on = function(events, priority, callback, that) {\n\n  events = (0,min_dash_dist_index_esm/* isArray */.kJ)(events) ? events : [ events ];\n\n  if ((0,min_dash_dist_index_esm/* isFunction */.mf)(priority)) {\n    that = callback;\n    callback = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  if (!(0,min_dash_dist_index_esm/* isNumber */.hj)(priority)) {\n    throw new Error('priority must be a number');\n  }\n\n  var actualCallback = callback;\n\n  if (that) {\n    actualCallback = (0,min_dash_dist_index_esm/* bind */.ak)(callback, that);\n\n    // make sure we remember and are able to remove\n    // bound callbacks via {@link #off} using the original\n    // callback\n    actualCallback[FN_REF] = callback[FN_REF] || callback;\n  }\n\n  var self = this;\n\n  events.forEach(function(e) {\n    self._addListener(e, {\n      priority: priority,\n      callback: actualCallback,\n      next: null\n    });\n  });\n};\n\n\n/**\n * Register an event listener that is executed only once.\n *\n * @param {String} event the event name to register for\n * @param {Number} [priority=1000] the priority in which this listener is called, larger is higher\n * @param {Function} callback the callback to execute\n * @param {Object} [that] Pass context (`this`) to the callback\n */\nEventBus.prototype.once = function(event, priority, callback, that) {\n  var self = this;\n\n  if ((0,min_dash_dist_index_esm/* isFunction */.mf)(priority)) {\n    that = callback;\n    callback = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  if (!(0,min_dash_dist_index_esm/* isNumber */.hj)(priority)) {\n    throw new Error('priority must be a number');\n  }\n\n  function wrappedCallback() {\n    var result = callback.apply(that, arguments);\n\n    self.off(event, wrappedCallback);\n\n    return result;\n  }\n\n  // make sure we remember and are able to remove\n  // bound callbacks via {@link #off} using the original\n  // callback\n  wrappedCallback[FN_REF] = callback;\n\n  this.on(event, priority, wrappedCallback);\n};\n\n\n/**\n * Removes event listeners by event and callback.\n *\n * If no callback is given, all listeners for a given event name are being removed.\n *\n * @param {String|Array<String>} events\n * @param {Function} [callback]\n */\nEventBus.prototype.off = function(events, callback) {\n\n  events = (0,min_dash_dist_index_esm/* isArray */.kJ)(events) ? events : [ events ];\n\n  var self = this;\n\n  events.forEach(function(event) {\n    self._removeListener(event, callback);\n  });\n\n};\n\n\n/**\n * Create an EventBus event.\n *\n * @param {Object} data\n *\n * @return {Object} event, recognized by the eventBus\n */\nEventBus.prototype.createEvent = function(data) {\n  var event = new InternalEvent();\n\n  event.init(data);\n\n  return event;\n};\n\n\n/**\n * Fires a named event.\n *\n * @example\n *\n * // fire event by name\n * events.fire('foo');\n *\n * // fire event object with nested type\n * var event = { type: 'foo' };\n * events.fire(event);\n *\n * // fire event with explicit type\n * var event = { x: 10, y: 20 };\n * events.fire('element.moved', event);\n *\n * // pass additional arguments to the event\n * events.on('foo', function(event, bar) {\n *   alert(bar);\n * });\n *\n * events.fire({ type: 'foo' }, 'I am bar!');\n *\n * @param {String} [name] the optional event name\n * @param {Object} [event] the event object\n * @param {...Object} additional arguments to be passed to the callback functions\n *\n * @return {Boolean} the events return value, if specified or false if the\n *                   default action was prevented by listeners\n */\nEventBus.prototype.fire = function(type, data) {\n\n  var event,\n      firstListener,\n      returnValue,\n      args;\n\n  args = slice.call(arguments);\n\n  if (typeof type === 'object') {\n    event = type;\n    type = event.type;\n  }\n\n  if (!type) {\n    throw new Error('no event type specified');\n  }\n\n  firstListener = this._listeners[type];\n\n  if (!firstListener) {\n    return;\n  }\n\n  // we make sure we fire instances of our home made\n  // events here. We wrap them only once, though\n  if (data instanceof InternalEvent) {\n    // we are fine, we alread have an event\n    event = data;\n  } else {\n    event = this.createEvent(data);\n  }\n\n  // ensure we pass the event as the first parameter\n  args[0] = event;\n\n  // original event type (in case we delegate)\n  var originalType = event.type;\n\n  // update event type before delegation\n  if (type !== originalType) {\n    event.type = type;\n  }\n\n  try {\n    returnValue = this._invokeListeners(event, args, firstListener);\n  } finally {\n    // reset event type after delegation\n    if (type !== originalType) {\n      event.type = originalType;\n    }\n  }\n\n  // set the return value to false if the event default\n  // got prevented and no other return value exists\n  if (returnValue === undefined && event.defaultPrevented) {\n    returnValue = false;\n  }\n\n  return returnValue;\n};\n\n\nEventBus.prototype.handleError = function(error) {\n  return this.fire('error', { error: error }) === false;\n};\n\n\nEventBus.prototype._destroy = function() {\n  this._listeners = {};\n};\n\nEventBus.prototype._invokeListeners = function(event, args, listener) {\n\n  var returnValue;\n\n  while (listener) {\n\n    // handle stopped propagation\n    if (event.cancelBubble) {\n      break;\n    }\n\n    returnValue = this._invokeListener(event, args, listener);\n\n    listener = listener.next;\n  }\n\n  return returnValue;\n};\n\nEventBus.prototype._invokeListener = function(event, args, listener) {\n\n  var returnValue;\n\n  try {\n    // returning false prevents the default action\n    returnValue = invokeFunction(listener.callback, args);\n\n    // stop propagation on return value\n    if (returnValue !== undefined) {\n      event.returnValue = returnValue;\n      event.stopPropagation();\n    }\n\n    // prevent default on return false\n    if (returnValue === false) {\n      event.preventDefault();\n    }\n  } catch (e) {\n    if (!this.handleError(e)) {\n      console.error('unhandled error in event listener');\n      console.error(e.stack);\n\n      throw e;\n    }\n  }\n\n  return returnValue;\n};\n\n/*\n * Add new listener with a certain priority to the list\n * of listeners (for the given event).\n *\n * The semantics of listener registration / listener execution are\n * first register, first serve: New listeners will always be inserted\n * after existing listeners with the same priority.\n *\n * Example: Inserting two listeners with priority 1000 and 1300\n *\n *    * before: [ 1500, 1500, 1000, 1000 ]\n *    * after: [ 1500, 1500, (new=1300), 1000, 1000, (new=1000) ]\n *\n * @param {String} event\n * @param {Object} listener { priority, callback }\n */\nEventBus.prototype._addListener = function(event, newListener) {\n\n  var listener = this._getListeners(event),\n      previousListener;\n\n  // no prior listeners\n  if (!listener) {\n    this._setListeners(event, newListener);\n\n    return;\n  }\n\n  // ensure we order listeners by priority from\n  // 0 (high) to n > 0 (low)\n  while (listener) {\n\n    if (listener.priority < newListener.priority) {\n\n      newListener.next = listener;\n\n      if (previousListener) {\n        previousListener.next = newListener;\n      } else {\n        this._setListeners(event, newListener);\n      }\n\n      return;\n    }\n\n    previousListener = listener;\n    listener = listener.next;\n  }\n\n  // add new listener to back\n  previousListener.next = newListener;\n};\n\n\nEventBus.prototype._getListeners = function(name) {\n  return this._listeners[name];\n};\n\nEventBus.prototype._setListeners = function(name, listener) {\n  this._listeners[name] = listener;\n};\n\nEventBus.prototype._removeListener = function(event, callback) {\n\n  var listener = this._getListeners(event),\n      nextListener,\n      previousListener,\n      listenerCallback;\n\n  if (!callback) {\n    // clear listeners\n    this._setListeners(event, null);\n\n    return;\n  }\n\n  while (listener) {\n\n    nextListener = listener.next;\n\n    listenerCallback = listener.callback;\n\n    if (listenerCallback === callback || listenerCallback[FN_REF] === callback) {\n      if (previousListener) {\n        previousListener.next = nextListener;\n      } else {\n        // new first listener\n        this._setListeners(event, nextListener);\n      }\n    }\n\n    previousListener = listener;\n    listener = nextListener;\n  }\n};\n\n/**\n * A event that is emitted via the event bus.\n */\nfunction InternalEvent() { }\n\nInternalEvent.prototype.stopPropagation = function() {\n  this.cancelBubble = true;\n};\n\nInternalEvent.prototype.preventDefault = function() {\n  this.defaultPrevented = true;\n};\n\nInternalEvent.prototype.init = function(data) {\n  (0,min_dash_dist_index_esm/* assign */.f0)(this, data || {});\n};\n\n\n/**\n * Invoke function. Be fast...\n *\n * @param {Function} fn\n * @param {Array<Object>} args\n *\n * @return {Any}\n */\nfunction invokeFunction(fn, args) {\n  return fn.apply(null, args);\n}\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/GraphicsUtil.js\nvar GraphicsUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/GraphicsUtil.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/core/GraphicsFactory.js\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A factory that creates graphical elements\n *\n * @param {EventBus} eventBus\n * @param {ElementRegistry} elementRegistry\n */\nfunction GraphicsFactory(eventBus, elementRegistry) {\n  this._eventBus = eventBus;\n  this._elementRegistry = elementRegistry;\n}\n\nGraphicsFactory.$inject = [ 'eventBus' , 'elementRegistry' ];\n\n\nGraphicsFactory.prototype._getChildren = function(element) {\n\n  var gfx = this._elementRegistry.getGraphics(element);\n\n  var childrenGfx;\n\n  // root element\n  if (!element.parent) {\n    childrenGfx = gfx;\n  } else {\n    childrenGfx = (0,GraphicsUtil/* getChildren */.G)(gfx);\n    if (!childrenGfx) {\n      childrenGfx = (0,dist_index_esm/* create */.Ue)('g');\n      (0,dist_index_esm/* classes */.Sh)(childrenGfx).add('djs-children');\n\n      (0,dist_index_esm/* append */.R3)(gfx.parentNode, childrenGfx);\n    }\n  }\n\n  return childrenGfx;\n};\n\n/**\n * Clears the graphical representation of the element and returns the\n * cleared visual (the <g class=\"djs-visual\" /> element).\n */\nGraphicsFactory.prototype._clear = function(gfx) {\n  var visual = (0,GraphicsUtil/* getVisual */.s)(gfx);\n\n  (0,min_dom_dist_index_esm/* clear */.ZH)(visual);\n\n  return visual;\n};\n\n/**\n * Creates a gfx container for shapes and connections\n *\n * The layout is as follows:\n *\n * <g class=\"djs-group\">\n *\n *   \x3c!-- the gfx --\x3e\n *   <g class=\"djs-element djs-(shape|connection|frame)\">\n *     <g class=\"djs-visual\">\n *       \x3c!-- the renderer draws in here --\x3e\n *     </g>\n *\n *     \x3c!-- extensions (overlays, click box, ...) goes here\n *   </g>\n *\n *   \x3c!-- the gfx child nodes --\x3e\n *   <g class=\"djs-children\"></g>\n * </g>\n *\n * @param {String} type the type of the element, i.e. shape | connection\n * @param {SVGElement} [childrenGfx]\n * @param {Number} [parentIndex] position to create container in parent\n * @param {Boolean} [isFrame] is frame element\n *\n * @return {SVGElement}\n */\nGraphicsFactory.prototype._createContainer = function(\n    type, childrenGfx, parentIndex, isFrame\n) {\n  var outerGfx = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* classes */.Sh)(outerGfx).add('djs-group');\n\n  // insert node at position\n  if (typeof parentIndex !== 'undefined') {\n    prependTo(outerGfx, childrenGfx, childrenGfx.childNodes[parentIndex]);\n  } else {\n    (0,dist_index_esm/* append */.R3)(childrenGfx, outerGfx);\n  }\n\n  var gfx = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* classes */.Sh)(gfx).add('djs-element');\n  (0,dist_index_esm/* classes */.Sh)(gfx).add('djs-' + type);\n\n  if (isFrame) {\n    (0,dist_index_esm/* classes */.Sh)(gfx).add('djs-frame');\n  }\n\n  (0,dist_index_esm/* append */.R3)(outerGfx, gfx);\n\n  // create visual\n  var visual = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* classes */.Sh)(visual).add('djs-visual');\n\n  (0,dist_index_esm/* append */.R3)(gfx, visual);\n\n  return gfx;\n};\n\nGraphicsFactory.prototype.create = function(type, element, parentIndex) {\n  var childrenGfx = this._getChildren(element.parent);\n  return this._createContainer(type, childrenGfx, parentIndex, (0,Elements/* isFrameElement */.He)(element));\n};\n\nGraphicsFactory.prototype.updateContainments = function(elements) {\n\n  var self = this,\n      elementRegistry = this._elementRegistry,\n      parents;\n\n  parents = (0,min_dash_dist_index_esm/* reduce */.u4)(elements, function(map, e) {\n\n    if (e.parent) {\n      map[e.parent.id] = e.parent;\n    }\n\n    return map;\n  }, {});\n\n  // update all parents of changed and reorganized their children\n  // in the correct order (as indicated in our model)\n  (0,min_dash_dist_index_esm/* forEach */.Ed)(parents, function(parent) {\n\n    var children = parent.children;\n\n    if (!children) {\n      return;\n    }\n\n    var childGfx = self._getChildren(parent);\n\n    (0,min_dash_dist_index_esm/* forEach */.Ed)(children.slice().reverse(), function(c) {\n      var gfx = elementRegistry.getGraphics(c);\n\n      prependTo(gfx.parentNode, childGfx);\n    });\n  });\n};\n\nGraphicsFactory.prototype.drawShape = function(visual, element) {\n  var eventBus = this._eventBus;\n\n  return eventBus.fire('render.shape', { gfx: visual, element: element });\n};\n\nGraphicsFactory.prototype.getShapePath = function(element) {\n  var eventBus = this._eventBus;\n\n  return eventBus.fire('render.getShapePath', element);\n};\n\nGraphicsFactory.prototype.drawConnection = function(visual, element) {\n  var eventBus = this._eventBus;\n\n  return eventBus.fire('render.connection', { gfx: visual, element: element });\n};\n\nGraphicsFactory.prototype.getConnectionPath = function(waypoints) {\n  var eventBus = this._eventBus;\n\n  return eventBus.fire('render.getConnectionPath', waypoints);\n};\n\nGraphicsFactory.prototype.update = function(type, element, gfx) {\n\n  // do NOT update root element\n  if (!element.parent) {\n    return;\n  }\n\n  var visual = this._clear(gfx);\n\n  // redraw\n  if (type === 'shape') {\n    this.drawShape(visual, element);\n\n    // update positioning\n    (0,SvgTransformUtil/* translate */.Iu)(gfx, element.x, element.y);\n  } else\n  if (type === 'connection') {\n    this.drawConnection(visual, element);\n  } else {\n    throw new Error('unknown type: ' + type);\n  }\n\n  if (element.hidden) {\n    (0,dist_index_esm/* attr */.Lj)(gfx, 'display', 'none');\n  } else {\n    (0,dist_index_esm/* attr */.Lj)(gfx, 'display', 'block');\n  }\n};\n\nGraphicsFactory.prototype.remove = function(element) {\n  var gfx = this._elementRegistry.getGraphics(element);\n\n  // remove\n  (0,dist_index_esm/* remove */.Od)(gfx.parentNode);\n};\n\n\n// helpers //////////\n\nfunction prependTo(newNode, parentNode, siblingNode) {\n  var node = siblingNode || parentNode.firstChild;\n\n  // do not prepend node to itself to prevent IE from crashing\n  // https://github.com/bpmn-io/bpmn-js/issues/746\n  if (newNode === node) {\n    return;\n  }\n\n  parentNode.insertBefore(newNode, node);\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/core/index.js\n\n\n\n\n\n\n\n\n/* harmony default export */ const core = ({\n  __depends__: [ draw ],\n  __init__: [ 'canvas' ],\n  canvas: [ 'type', Canvas ],\n  elementRegistry: [ 'type', ElementRegistry ],\n  elementFactory: [ 'type', ElementFactory/* default */.Z ],\n  eventBus: [ 'type', EventBus ],\n  graphicsFactory: [ 'type', GraphicsFactory ]\n});\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/Diagram.js\n\n\n\n\n\n/**\n * Bootstrap an injector from a list of modules, instantiating a number of default components\n *\n * @ignore\n * @param {Array<didi.Module>} bootstrapModules\n *\n * @return {didi.Injector} a injector to use to access the components\n */\nfunction bootstrap(bootstrapModules) {\n\n  var modules = [],\n      components = [];\n\n  function hasModule(m) {\n    return modules.indexOf(m) >= 0;\n  }\n\n  function addModule(m) {\n    modules.push(m);\n  }\n\n  function visit(m) {\n    if (hasModule(m)) {\n      return;\n    }\n\n    (m.__depends__ || []).forEach(visit);\n\n    if (hasModule(m)) {\n      return;\n    }\n\n    addModule(m);\n\n    (m.__init__ || []).forEach(function(c) {\n      components.push(c);\n    });\n  }\n\n  bootstrapModules.forEach(visit);\n\n  var injector = new index_esm/* Injector */.zs(modules);\n\n  components.forEach(function(c) {\n\n    try {\n      // eagerly resolve component (fn or string)\n      injector[typeof c === 'string' ? 'get' : 'invoke'](c);\n    } catch (e) {\n      console.error('Failed to instantiate component');\n      console.error(e.stack);\n\n      throw e;\n    }\n  });\n\n  return injector;\n}\n\n/**\n * Creates an injector from passed options.\n *\n * @ignore\n * @param  {Object} options\n * @return {didi.Injector}\n */\nfunction createInjector(options) {\n\n  options = options || {};\n\n  var configModule = {\n    'config': ['value', options]\n  };\n\n  var modules = [ configModule, core ].concat(options.modules || []);\n\n  return bootstrap(modules);\n}\n\n\n/**\n * The main diagram-js entry point that bootstraps the diagram with the given\n * configuration.\n *\n * To register extensions with the diagram, pass them as Array<didi.Module> to the constructor.\n *\n * @class djs.Diagram\n * @memberOf djs\n * @constructor\n *\n * @example\n *\n * <caption>Creating a plug-in that logs whenever a shape is added to the canvas.</caption>\n *\n * // plug-in implemenentation\n * function MyLoggingPlugin(eventBus) {\n *   eventBus.on('shape.added', function(event) {\n *     console.log('shape ', event.shape, ' was added to the diagram');\n *   });\n * }\n *\n * // export as module\n * export default {\n *   __init__: [ 'myLoggingPlugin' ],\n *     myLoggingPlugin: [ 'type', MyLoggingPlugin ]\n * };\n *\n *\n * // instantiate the diagram with the new plug-in\n *\n * import MyLoggingModule from 'path-to-my-logging-plugin';\n *\n * var diagram = new Diagram({\n *   modules: [\n *     MyLoggingModule\n *   ]\n * });\n *\n * diagram.invoke([ 'canvas', function(canvas) {\n *   // add shape to drawing canvas\n *   canvas.addShape({ x: 10, y: 10 });\n * });\n *\n * // 'shape ... was added to the diagram' logged to console\n *\n * @param {Object} options\n * @param {Array<didi.Module>} [options.modules] external modules to instantiate with the diagram\n * @param {didi.Injector} [injector] an (optional) injector to bootstrap the diagram with\n */\nfunction Diagram(options, injector) {\n\n  // create injector unless explicitly specified\n  this.injector = injector = injector || createInjector(options);\n\n  // API\n\n  /**\n   * Resolves a diagram service\n   *\n   * @method Diagram#get\n   *\n   * @param {String} name the name of the diagram service to be retrieved\n   * @param {Boolean} [strict=true] if false, resolve missing services to null\n   */\n  this.get = injector.get;\n\n  /**\n   * Executes a function into which diagram services are injected\n   *\n   * @method Diagram#invoke\n   *\n   * @param {Function|Object[]} fn the function to resolve\n   * @param {Object} locals a number of locals to use to resolve certain dependencies\n   */\n  this.invoke = injector.invoke;\n\n  // init\n\n  // indicate via event\n\n\n  /**\n   * An event indicating that all plug-ins are loaded.\n   *\n   * Use this event to fire other events to interested plug-ins\n   *\n   * @memberOf Diagram\n   *\n   * @event diagram.init\n   *\n   * @example\n   *\n   * eventBus.on('diagram.init', function() {\n   *   eventBus.fire('my-custom-event', { foo: 'BAR' });\n   * });\n   *\n   * @type {Object}\n   */\n  this.get('eventBus').fire('diagram.init');\n}\n\n\n/**\n * Destroys the diagram\n *\n * @method  Diagram#destroy\n */\nDiagram.prototype.destroy = function() {\n  this.get('eventBus').fire('diagram.destroy');\n};\n\n/**\n * Clear the diagram, removing all contents.\n */\nDiagram.prototype.clear = function() {\n  this.get('eventBus').fire('diagram.clear');\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/index.js\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/index.js_+_9_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ CommandInterceptor)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n\n\n\nvar DEFAULT_PRIORITY = 1000;\n\n/**\n * A utility that can be used to plug-in into the command execution for\n * extension and/or validation.\n *\n * @param {EventBus} eventBus\n *\n * @example\n *\n * import inherits from 'inherits';\n *\n * import CommandInterceptor from 'diagram-js/lib/command/CommandInterceptor';\n *\n * function CommandLogger(eventBus) {\n *   CommandInterceptor.call(this, eventBus);\n *\n *   this.preExecute(function(event) {\n *     console.log('command pre-execute', event);\n *   });\n * }\n *\n * inherits(CommandLogger, CommandInterceptor);\n *\n */\nfunction CommandInterceptor(eventBus) {\n  this._eventBus = eventBus;\n}\n\nCommandInterceptor.$inject = [ 'eventBus' ];\n\nfunction unwrapEvent(fn, that) {\n  return function(event) {\n    return fn.call(that || null, event.context, event.command, event);\n  };\n}\n\n/**\n * Register an interceptor for a command execution\n *\n * @param {String|Array<String>} [events] list of commands to register on\n * @param {String} [hook] command hook, i.e. preExecute, executed to listen on\n * @param {Number} [priority] the priority on which to hook into the execution\n * @param {Function} handlerFn interceptor to be invoked with (event)\n * @param {Boolean} unwrap if true, unwrap the event and pass (context, command, event) to the\n *                          listener instead\n * @param {Object} [that] Pass context (`this`) to the handler function\n */\nCommandInterceptor.prototype.on = function(events, hook, priority, handlerFn, unwrap, that) {\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(hook) || (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(hook)) {\n    that = unwrap;\n    unwrap = handlerFn;\n    handlerFn = priority;\n    priority = hook;\n    hook = null;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(priority)) {\n    that = unwrap;\n    unwrap = handlerFn;\n    handlerFn = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isObject */ .Kn)(unwrap)) {\n    that = unwrap;\n    unwrap = false;\n  }\n\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(handlerFn)) {\n    throw new Error('handlerFn must be a function');\n  }\n\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(events)) {\n    events = [ events ];\n  }\n\n  var eventBus = this._eventBus;\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(events, function(event) {\n    // concat commandStack(.event)?(.hook)?\n    var fullEvent = [ 'commandStack', event, hook ].filter(function(e) { return e; }).join('.');\n\n    eventBus.on(fullEvent, priority, unwrap ? unwrapEvent(handlerFn, that) : handlerFn, that);\n  });\n};\n\n\nvar hooks = [\n  'canExecute',\n  'preExecute',\n  'preExecuted',\n  'execute',\n  'executed',\n  'postExecute',\n  'postExecuted',\n  'revert',\n  'reverted'\n];\n\n/*\n * Install hook shortcuts\n *\n * This will generate the CommandInterceptor#(preExecute|...|reverted) methods\n * which will in term forward to CommandInterceptor#on.\n */\n(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(hooks, function(hook) {\n\n  /**\n   * {canExecute|preExecute|preExecuted|execute|executed|postExecute|postExecuted|revert|reverted}\n   *\n   * A named hook for plugging into the command execution\n   *\n   * @param {String|Array<String>} [events] list of commands to register on\n   * @param {Number} [priority] the priority on which to hook into the execution\n   * @param {Function} handlerFn interceptor to be invoked with (event)\n   * @param {Boolean} [unwrap=false] if true, unwrap the event and pass (context, command, event) to the\n   *                          listener instead\n   * @param {Object} [that] Pass context (`this`) to the handler function\n   */\n  CommandInterceptor.prototype[hook] = function(events, priority, handlerFn, unwrap, that) {\n\n    if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(events) || (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(events)) {\n      that = unwrap;\n      unwrap = handlerFn;\n      handlerFn = priority;\n      priority = events;\n      events = null;\n    }\n\n    this.on(events, hook, priority, handlerFn, unwrap, that);\n  };\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ command)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandStack.js\n\n\n\n/**\n * A service that offers un- and redoable execution of commands.\n *\n * The command stack is responsible for executing modeling actions\n * in a un- and redoable manner. To do this it delegates the actual\n * command execution to {@link CommandHandler}s.\n *\n * Command handlers provide {@link CommandHandler#execute(ctx)} and\n * {@link CommandHandler#revert(ctx)} methods to un- and redo a command\n * identified by a command context.\n *\n *\n * ## Life-Cycle events\n *\n * In the process the command stack fires a number of life-cycle events\n * that other components to participate in the command execution.\n *\n *    * preExecute\n *    * preExecuted\n *    * execute\n *    * executed\n *    * postExecute\n *    * postExecuted\n *    * revert\n *    * reverted\n *\n * A special event is used for validating, whether a command can be\n * performed prior to its execution.\n *\n *    * canExecute\n *\n * Each of the events is fired as `commandStack.{eventName}` and\n * `commandStack.{commandName}.{eventName}`, respectively. This gives\n * components fine grained control on where to hook into.\n *\n * The event object fired transports `command`, the name of the\n * command and `context`, the command context.\n *\n *\n * ## Creating Command Handlers\n *\n * Command handlers should provide the {@link CommandHandler#execute(ctx)}\n * and {@link CommandHandler#revert(ctx)} methods to implement\n * redoing and undoing of a command.\n *\n * A command handler _must_ ensure undo is performed properly in order\n * not to break the undo chain. It must also return the shapes that\n * got changed during the `execute` and `revert` operations.\n *\n * Command handlers may execute other modeling operations (and thus\n * commands) in their `preExecute` and `postExecute` phases. The command\n * stack will properly group all commands together into a logical unit\n * that may be re- and undone atomically.\n *\n * Command handlers must not execute other commands from within their\n * core implementation (`execute`, `revert`).\n *\n *\n * ## Change Tracking\n *\n * During the execution of the CommandStack it will keep track of all\n * elements that have been touched during the command's execution.\n *\n * At the end of the CommandStack execution it will notify interested\n * components via an 'elements.changed' event with all the dirty\n * elements.\n *\n * The event can be picked up by components that are interested in the fact\n * that elements have been changed. One use case for this is updating\n * their graphical representation after moving / resizing or deletion.\n *\n * @see CommandHandler\n *\n * @param {EventBus} eventBus\n * @param {Injector} injector\n */\nfunction CommandStack(eventBus, injector) {\n\n  /**\n   * A map of all registered command handlers.\n   *\n   * @type {Object}\n   */\n  this._handlerMap = {};\n\n  /**\n   * A stack containing all re/undoable actions on the diagram\n   *\n   * @type {Array<Object>}\n   */\n  this._stack = [];\n\n  /**\n   * The current index on the stack\n   *\n   * @type {Number}\n   */\n  this._stackIdx = -1;\n\n  /**\n   * Current active commandStack execution\n   *\n   * @type {Object}\n   */\n  this._currentExecution = {\n    actions: [],\n    dirty: []\n  };\n\n\n  this._injector = injector;\n  this._eventBus = eventBus;\n\n  this._uid = 1;\n\n  eventBus.on([\n    'diagram.destroy',\n    'diagram.clear'\n  ], function() {\n    this.clear(false);\n  }, this);\n}\n\nCommandStack.$inject = [ 'eventBus', 'injector' ];\n\n\n/**\n * Execute a command\n *\n * @param {String} command the command to execute\n * @param {Object} context the environment to execute the command in\n */\nCommandStack.prototype.execute = function(command, context) {\n  if (!command) {\n    throw new Error('command required');\n  }\n\n  var action = { command: command, context: context };\n\n  this._pushAction(action);\n  this._internalExecute(action);\n  this._popAction(action);\n};\n\n\n/**\n * Ask whether a given command can be executed.\n *\n * Implementors may hook into the mechanism on two ways:\n *\n *   * in event listeners:\n *\n *     Users may prevent the execution via an event listener.\n *     It must prevent the default action for `commandStack.(<command>.)canExecute` events.\n *\n *   * in command handlers:\n *\n *     If the method {@link CommandHandler#canExecute} is implemented in a handler\n *     it will be called to figure out whether the execution is allowed.\n *\n * @param  {String} command the command to execute\n * @param  {Object} context the environment to execute the command in\n *\n * @return {Boolean} true if the command can be executed\n */\nCommandStack.prototype.canExecute = function(command, context) {\n\n  var action = { command: command, context: context };\n\n  var handler = this._getHandler(command);\n\n  var result = this._fire(command, 'canExecute', action);\n\n  // handler#canExecute will only be called if no listener\n  // decided on a result already\n  if (result === undefined) {\n    if (!handler) {\n      return false;\n    }\n\n    if (handler.canExecute) {\n      result = handler.canExecute(context);\n    }\n  }\n\n  return result;\n};\n\n\n/**\n * Clear the command stack, erasing all undo / redo history\n */\nCommandStack.prototype.clear = function(emit) {\n  this._stack.length = 0;\n  this._stackIdx = -1;\n\n  if (emit !== false) {\n    this._fire('changed');\n  }\n};\n\n\n/**\n * Undo last command(s)\n */\nCommandStack.prototype.undo = function() {\n  var action = this._getUndoAction(),\n      next;\n\n  if (action) {\n    this._pushAction(action);\n\n    while (action) {\n      this._internalUndo(action);\n      next = this._getUndoAction();\n\n      if (!next || next.id !== action.id) {\n        break;\n      }\n\n      action = next;\n    }\n\n    this._popAction();\n  }\n};\n\n\n/**\n * Redo last command(s)\n */\nCommandStack.prototype.redo = function() {\n  var action = this._getRedoAction(),\n      next;\n\n  if (action) {\n    this._pushAction(action);\n\n    while (action) {\n      this._internalExecute(action, true);\n      next = this._getRedoAction();\n\n      if (!next || next.id !== action.id) {\n        break;\n      }\n\n      action = next;\n    }\n\n    this._popAction();\n  }\n};\n\n\n/**\n * Register a handler instance with the command stack\n *\n * @param {String} command\n * @param {CommandHandler} handler\n */\nCommandStack.prototype.register = function(command, handler) {\n  this._setHandler(command, handler);\n};\n\n\n/**\n * Register a handler type with the command stack\n * by instantiating it and injecting its dependencies.\n *\n * @param {String} command\n * @param {Function} a constructor for a {@link CommandHandler}\n */\nCommandStack.prototype.registerHandler = function(command, handlerCls) {\n\n  if (!command || !handlerCls) {\n    throw new Error('command and handlerCls must be defined');\n  }\n\n  var handler = this._injector.instantiate(handlerCls);\n  this.register(command, handler);\n};\n\nCommandStack.prototype.canUndo = function() {\n  return !!this._getUndoAction();\n};\n\nCommandStack.prototype.canRedo = function() {\n  return !!this._getRedoAction();\n};\n\n// stack access  //////////////////////\n\nCommandStack.prototype._getRedoAction = function() {\n  return this._stack[this._stackIdx + 1];\n};\n\n\nCommandStack.prototype._getUndoAction = function() {\n  return this._stack[this._stackIdx];\n};\n\n\n// internal functionality //////////////////////\n\nCommandStack.prototype._internalUndo = function(action) {\n  var self = this;\n\n  var command = action.command,\n      context = action.context;\n\n  var handler = this._getHandler(command);\n\n  // guard against illegal nested command stack invocations\n  this._atomicDo(function() {\n    self._fire(command, 'revert', action);\n\n    if (handler.revert) {\n      self._markDirty(handler.revert(context));\n    }\n\n    self._revertedAction(action);\n\n    self._fire(command, 'reverted', action);\n  });\n};\n\n\nCommandStack.prototype._fire = function(command, qualifier, event) {\n  if (arguments.length < 3) {\n    event = qualifier;\n    qualifier = null;\n  }\n\n  var names = qualifier ? [ command + '.' + qualifier, qualifier ] : [ command ],\n      i, name, result;\n\n  event = this._eventBus.createEvent(event);\n\n  for (i = 0; (name = names[i]); i++) {\n    result = this._eventBus.fire('commandStack.' + name, event);\n\n    if (event.cancelBubble) {\n      break;\n    }\n  }\n\n  return result;\n};\n\nCommandStack.prototype._createId = function() {\n  return this._uid++;\n};\n\nCommandStack.prototype._atomicDo = function(fn) {\n\n  var execution = this._currentExecution;\n\n  execution.atomic = true;\n\n  try {\n    fn();\n  } finally {\n    execution.atomic = false;\n  }\n};\n\nCommandStack.prototype._internalExecute = function(action, redo) {\n  var self = this;\n\n  var command = action.command,\n      context = action.context;\n\n  var handler = this._getHandler(command);\n\n  if (!handler) {\n    throw new Error('no command handler registered for <' + command + '>');\n  }\n\n  this._pushAction(action);\n\n  if (!redo) {\n    this._fire(command, 'preExecute', action);\n\n    if (handler.preExecute) {\n      handler.preExecute(context);\n    }\n\n    this._fire(command, 'preExecuted', action);\n  }\n\n  // guard against illegal nested command stack invocations\n  this._atomicDo(function() {\n\n    self._fire(command, 'execute', action);\n\n    if (handler.execute) {\n      // actual execute + mark return results as dirty\n      self._markDirty(handler.execute(context));\n    }\n\n    // log to stack\n    self._executedAction(action, redo);\n\n    self._fire(command, 'executed', action);\n  });\n\n  if (!redo) {\n    this._fire(command, 'postExecute', action);\n\n    if (handler.postExecute) {\n      handler.postExecute(context);\n    }\n\n    this._fire(command, 'postExecuted', action);\n  }\n\n  this._popAction(action);\n};\n\n\nCommandStack.prototype._pushAction = function(action) {\n\n  var execution = this._currentExecution,\n      actions = execution.actions;\n\n  var baseAction = actions[0];\n\n  if (execution.atomic) {\n    throw new Error('illegal invocation in <execute> or <revert> phase (action: ' + action.command + ')');\n  }\n\n  if (!action.id) {\n    action.id = (baseAction && baseAction.id) || this._createId();\n  }\n\n  actions.push(action);\n};\n\n\nCommandStack.prototype._popAction = function() {\n  var execution = this._currentExecution,\n      actions = execution.actions,\n      dirty = execution.dirty;\n\n  actions.pop();\n\n  if (!actions.length) {\n    this._eventBus.fire('elements.changed', { elements: (0,index_esm/* uniqueBy */.uw)('id', dirty) });\n\n    dirty.length = 0;\n\n    this._fire('changed');\n  }\n};\n\n\nCommandStack.prototype._markDirty = function(elements) {\n  var execution = this._currentExecution;\n\n  if (!elements) {\n    return;\n  }\n\n  elements = (0,index_esm/* isArray */.kJ)(elements) ? elements : [ elements ];\n\n  execution.dirty = execution.dirty.concat(elements);\n};\n\n\nCommandStack.prototype._executedAction = function(action, redo) {\n  var stackIdx = ++this._stackIdx;\n\n  if (!redo) {\n    this._stack.splice(stackIdx, this._stack.length, action);\n  }\n};\n\n\nCommandStack.prototype._revertedAction = function(action) {\n  this._stackIdx--;\n};\n\n\nCommandStack.prototype._getHandler = function(command) {\n  return this._handlerMap[command];\n};\n\nCommandStack.prototype._setHandler = function(command, handler) {\n  if (!command || !handler) {\n    throw new Error('command and handler required');\n  }\n\n  if (this._handlerMap[command]) {\n    throw new Error('overriding handler for command <' + command + '>');\n  }\n\n  this._handlerMap[command] = handler;\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/command/index.js\n\n\n/* harmony default export */ const command = ({\n  commandStack: [ 'type', CommandStack ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/command/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/core/ElementFactory.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ ElementFactory)\n/* harmony export */ });\n/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/model/index.js\");\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n\n\n\n\n/**\n * A factory for diagram-js shapes\n */\nfunction ElementFactory() {\n  this._uid = 12;\n}\n\n\nElementFactory.prototype.createRoot = function(attrs) {\n  return this.create('root', attrs);\n};\n\nElementFactory.prototype.createLabel = function(attrs) {\n  return this.create('label', attrs);\n};\n\nElementFactory.prototype.createShape = function(attrs) {\n  return this.create('shape', attrs);\n};\n\nElementFactory.prototype.createConnection = function(attrs) {\n  return this.create('connection', attrs);\n};\n\n/**\n * Create a model element with the given type and\n * a number of pre-set attributes.\n *\n * @param  {String} type\n * @param  {Object} attrs\n * @return {djs.model.Base} the newly created model instance\n */\nElementFactory.prototype.create = function(type, attrs) {\n\n  attrs = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, attrs || {});\n\n  if (!attrs.id) {\n    attrs.id = type + '_' + (this._uid++);\n  }\n\n  return (0,_model__WEBPACK_IMPORTED_MODULE_1__.create)(type, attrs);\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/core/ElementFactory.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/draw/BaseRenderer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ BaseRenderer)\n/* harmony export */ });\nvar DEFAULT_RENDER_PRIORITY = 1000;\n\n/**\n * The base implementation of shape and connection renderers.\n *\n * @param {EventBus} eventBus\n * @param {Number} [renderPriority=1000]\n */\nfunction BaseRenderer(eventBus, renderPriority) {\n  var self = this;\n\n  renderPriority = renderPriority || DEFAULT_RENDER_PRIORITY;\n\n  eventBus.on([ 'render.shape', 'render.connection' ], renderPriority, function(evt, context) {\n    var type = evt.type,\n        element = context.element,\n        visuals = context.gfx;\n\n    if (self.canRender(element)) {\n      if (type === 'render.shape') {\n        return self.drawShape(visuals, element);\n      } else {\n        return self.drawConnection(visuals, element);\n      }\n    }\n  });\n\n  eventBus.on([ 'render.getShapePath', 'render.getConnectionPath'], renderPriority, function(evt, element) {\n    if (self.canRender(element)) {\n      if (evt.type === 'render.getShapePath') {\n        return self.getShapePath(element);\n      } else {\n        return self.getConnectionPath(element);\n      }\n    }\n  });\n}\n\n/**\n * Should check whether *this* renderer can render\n * the element/connection.\n *\n * @param {element} element\n *\n * @returns {Boolean}\n */\nBaseRenderer.prototype.canRender = function() {};\n\n/**\n * Provides the shape's snap svg element to be drawn on the `canvas`.\n *\n * @param {djs.Graphics} visuals\n * @param {Shape} shape\n *\n * @returns {Snap.svg} [returns a Snap.svg paper element ]\n */\nBaseRenderer.prototype.drawShape = function() {};\n\n/**\n * Provides the shape's snap svg element to be drawn on the `canvas`.\n *\n * @param {djs.Graphics} visuals\n * @param {Connection} connection\n *\n * @returns {Snap.svg} [returns a Snap.svg paper element ]\n */\nBaseRenderer.prototype.drawConnection = function() {};\n\n/**\n * Gets the SVG path of a shape that represents it's visual bounds.\n *\n * @param {Shape} shape\n *\n * @return {string} svg path\n */\nBaseRenderer.prototype.getShapePath = function() {};\n\n/**\n * Gets the SVG path of a connection that represents it's visual bounds.\n *\n * @param {Connection} connection\n *\n * @return {string} svg path\n */\nBaseRenderer.prototype.getConnectionPath = function() {};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/draw/BaseRenderer.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/attach-support/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ attach_support)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Removal.js\nvar Removal = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Removal.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/AttachUtil.js\nvar AttachUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/AttachUtil.js\");\n// EXTERNAL MODULE: ./node_modules/inherits/inherits_browser.js\nvar inherits_browser = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\nvar inherits_browser_default = /*#__PURE__*/__webpack_require__.n(inherits_browser);\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/attach-support/AttachSupport.js\n\n\n\n\n\n\n\n\n\n\n\n\n\nvar LOW_PRIORITY = 251,\n    HIGH_PRIORITY = 1401;\n\nvar MARKER_ATTACH = 'attach-ok';\n\n\n/**\n * Adds the notion of attached elements to the modeler.\n *\n * Optionally depends on `diagram-js/lib/features/move` to render\n * the attached elements during move preview.\n *\n * Optionally depends on `diagram-js/lib/features/label-support`\n * to render attached labels during move preview.\n *\n * @param {didi.Injector} injector\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Rules} rules\n * @param {Modeling} modeling\n */\nfunction AttachSupport(injector, eventBus, canvas, rules, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  var movePreview = injector.get('movePreview', false);\n\n\n  // remove all the attached elements from the shapes to be validated\n  // add all the attached shapes to the overall list of moved shapes\n  eventBus.on('shape.move.start', HIGH_PRIORITY, function(e) {\n\n    var context = e.context,\n        shapes = context.shapes,\n        validatedShapes = context.validatedShapes;\n\n    context.shapes = addAttached(shapes);\n\n    context.validatedShapes = removeAttached(validatedShapes);\n  });\n\n  // add attachers to the visual's group\n  movePreview && eventBus.on('shape.move.start', LOW_PRIORITY, function(e) {\n\n    var context = e.context,\n        shapes = context.shapes,\n        attachers = getAttachers(shapes);\n\n    (0,index_esm/* forEach */.Ed)(attachers, function(attacher) {\n      movePreview.makeDraggable(context, attacher, true);\n\n      (0,index_esm/* forEach */.Ed)(attacher.labels, function(label) {\n        movePreview.makeDraggable(context, label, true);\n      });\n    });\n  });\n\n  // add attach-ok marker to current host\n  movePreview && eventBus.on('shape.move.start', function(event) {\n    var context = event.context,\n        shapes = context.shapes;\n\n    if (shapes.length !== 1) {\n      return;\n    }\n\n    var shape = shapes[0];\n\n    var host = shape.host;\n\n    if (host) {\n      canvas.addMarker(host, MARKER_ATTACH);\n\n      eventBus.once([\n        'shape.move.out',\n        'shape.move.cleanup'\n      ], function() {\n        canvas.removeMarker(host, MARKER_ATTACH);\n      });\n    }\n  });\n\n  // add all attachers to move closure\n  this.preExecuted('elements.move', HIGH_PRIORITY, function(e) {\n    var context = e.context,\n        closure = context.closure,\n        shapes = context.shapes,\n        attachers = getAttachers(shapes);\n\n    (0,index_esm/* forEach */.Ed)(attachers, function(attacher) {\n      closure.add(attacher, closure.topLevel[attacher.host.id]);\n    });\n  });\n\n  // perform the attaching after shapes are done moving\n  this.postExecuted('elements.move', function(e) {\n\n    var context = e.context,\n        shapes = context.shapes,\n        newHost = context.newHost,\n        attachers;\n\n    // we only support attachment / detachment of one element\n    if (shapes.length !== 1) {\n      return;\n    }\n\n    if (newHost) {\n\n      attachers = shapes;\n    } else {\n\n      attachers = (0,index_esm/* filter */.hX)(shapes, function(s) {\n        return !!s.host;\n      });\n    }\n\n    (0,index_esm/* forEach */.Ed)(attachers, function(attacher) {\n      modeling.updateAttachment(attacher, newHost);\n    });\n  });\n\n  // ensure invalid attachment connections are removed\n  this.postExecuted('elements.move', function(e) {\n\n    var shapes = e.context.shapes;\n\n    (0,index_esm/* forEach */.Ed)(shapes, function(shape) {\n\n      (0,index_esm/* forEach */.Ed)(shape.attachers, function(attacher) {\n\n        // remove invalid outgoing connections\n        (0,index_esm/* forEach */.Ed)(attacher.outgoing.slice(), function(connection) {\n          var allowed = rules.allowed('connection.reconnectStart', {\n            connection: connection,\n            source: connection.source,\n            target: connection.target\n          });\n\n          if (!allowed) {\n            modeling.removeConnection(connection);\n          }\n        });\n\n        // remove invalid incoming connections\n        (0,index_esm/* forEach */.Ed)(attacher.incoming.slice(), function(connection) {\n          var allowed = rules.allowed('connection.reconnectEnd', {\n            connection: connection,\n            source: connection.source,\n            target: connection.target\n          });\n\n          if (!allowed) {\n            modeling.removeConnection(connection);\n          }\n        });\n      });\n    });\n  });\n\n  this.postExecute('shape.create', function(e) {\n    var context = e.context,\n        shape = context.shape,\n        host = context.host;\n\n    if (host) {\n      modeling.updateAttachment(shape, host);\n    }\n  });\n\n  // update attachments if the host is replaced\n  this.postExecute('shape.replace', function(e) {\n\n    var context = e.context,\n        oldShape = context.oldShape,\n        newShape = context.newShape;\n\n    // move the attachers to the new host\n    (0,Removal/* saveClear */.r)(oldShape.attachers, function(attacher) {\n      var allowed = rules.allowed('elements.move', {\n        target: newShape,\n        shapes: [attacher]\n      });\n\n      if (allowed === 'attach') {\n        modeling.updateAttachment(attacher, newShape);\n      } else {\n        modeling.removeShape(attacher);\n      }\n    });\n\n    // move attachers if new host has different size\n    if (newShape.attachers.length) {\n\n      (0,index_esm/* forEach */.Ed)(newShape.attachers, function(attacher) {\n        var delta = (0,AttachUtil/* getNewAttachShapeDelta */.s)(attacher, oldShape, newShape);\n        modeling.moveShape(attacher, delta, attacher.parent);\n      });\n    }\n\n  });\n\n  // move shape on host resize\n  this.postExecute('shape.resize', function(event) {\n    var context = event.context,\n        shape = context.shape,\n        oldBounds = context.oldBounds,\n        newBounds = context.newBounds,\n        attachers = shape.attachers;\n\n    (0,index_esm/* forEach */.Ed)(attachers, function(attacher) {\n      var delta = (0,AttachUtil/* getNewAttachShapeDelta */.s)(attacher, oldBounds, newBounds);\n\n      modeling.moveShape(attacher, delta, attacher.parent);\n\n      (0,index_esm/* forEach */.Ed)(attacher.labels, function(label) {\n        modeling.moveShape(label, delta, label.parent);\n      });\n    });\n  });\n\n  // remove attachments\n  this.preExecute('shape.delete', function(event) {\n\n    var shape = event.context.shape;\n\n    (0,Removal/* saveClear */.r)(shape.attachers, function(attacher) {\n      modeling.removeShape(attacher);\n    });\n\n    if (shape.host) {\n      modeling.updateAttachment(shape, null);\n    }\n  });\n\n\n  // Prevent attachers and their labels from moving, when the space tool is performed.\n  // Otherwise the attachers and their labels would be moved twice.\n  eventBus.on('spaceTool.move', function(event) {\n\n    var context = event.context,\n        initialized = context.initialized,\n        attachSupportInitialized = context.attachSupportInitialized;\n\n    if (!initialized || attachSupportInitialized) {\n      return;\n    }\n\n    var movingShapes = context.movingShapes;\n\n    // collect attachers whose host is not being moved using the space tool\n    var staticAttachers = (0,index_esm/* filter */.hX)(movingShapes, function(shape) {\n      var host = shape.host;\n\n      return host && movingShapes.indexOf(host) === -1;\n    });\n\n    // remove attachers that are not going to be moved from moving shapes\n    (0,index_esm/* forEach */.Ed)(staticAttachers, function(shape) {\n      (0,Collections.remove)(movingShapes, shape);\n\n      (0,index_esm/* forEach */.Ed)(shape.labels, function(label) {\n        (0,Collections.remove)(movingShapes, shape.label);\n      });\n    });\n\n    context.attachSupportInitialized = true;\n  });\n}\n\ninherits_browser_default()(AttachSupport, CommandInterceptor/* default */.Z);\n\nAttachSupport.$inject = [\n  'injector',\n  'eventBus',\n  'canvas',\n  'rules',\n  'modeling'\n];\n\n\n/**\n * Return attachers of the given shapes\n *\n * @param {Array<djs.model.Base>} shapes\n * @return {Array<djs.model.Base>}\n */\nfunction getAttachers(shapes) {\n  return (0,index_esm/* flatten */.xH)((0,index_esm/* map */.UI)(shapes, function(s) {\n    return s.attachers || [];\n  }));\n}\n\n/**\n * Return a combined list of elements and\n * attachers.\n *\n * @param {Array<djs.model.Base>} elements\n * @return {Array<djs.model.Base>} filtered\n */\nfunction addAttached(elements) {\n  var attachers = getAttachers(elements);\n\n  return (0,index_esm/* unionBy */.qZ)('id', elements, attachers);\n}\n\n/**\n * Return a filtered list of elements that do not\n * contain attached elements with hosts being part\n * of the selection.\n *\n * @param  {Array<djs.model.Base>} elements\n *\n * @return {Array<djs.model.Base>} filtered\n */\nfunction removeAttached(elements) {\n\n  var ids = (0,index_esm/* groupBy */.vM)(elements, 'id');\n\n  return (0,index_esm/* filter */.hX)(elements, function(element) {\n    while (element) {\n\n      // host in selection\n      if (element.host && ids[element.host.id]) {\n        return false;\n      }\n\n      element = element.parent;\n    }\n\n    return true;\n  });\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/attach-support/index.js\n\n\n\n\n/* harmony default export */ const attach_support = ({\n  __depends__: [\n    rules/* default */.Z\n  ],\n  __init__: [ 'attachSupport' ],\n  attachSupport: [ 'type', AttachSupport ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/attach-support/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-resize/AutoResizeProvider.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ AutoResizeProvider)\n/* harmony export */ });\n/* harmony import */ var _rules_RuleProvider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/RuleProvider.js");\n/* harmony import */ var inherits__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n/* harmony import */ var inherits__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(inherits__WEBPACK_IMPORTED_MODULE_0__);\n\n\n\n\n/**\n * This is a base rule provider for the element.autoResize rule.\n */\nfunction AutoResizeProvider(eventBus) {\n\n  _rules_RuleProvider__WEBPACK_IMPORTED_MODULE_1__/* ["default"].call */ .Z.call(this, eventBus);\n\n  var self = this;\n\n  this.addRule(\'element.autoResize\', function(context) {\n    return self.canResize(context.elements, context.target);\n  });\n}\n\nAutoResizeProvider.$inject = [ \'eventBus\' ];\n\ninherits__WEBPACK_IMPORTED_MODULE_0___default()(AutoResizeProvider, _rules_RuleProvider__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z);\n\n/**\n * Needs to be implemented by sub classes to allow actual auto resize\n *\n * @param  {Array<djs.model.Shape>} elements\n * @param  {djs.model.Shape} target\n *\n * @return {Boolean}\n */\nAutoResizeProvider.prototype.canResize = function(elements, target) {\n  return false;\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-resize/AutoResizeProvider.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-resize/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ auto_resize)\n});\n\n// EXTERNAL MODULE: ./node_modules/inherits/inherits_browser.js\nvar inherits_browser = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\nvar inherits_browser_default = /*#__PURE__*/__webpack_require__.n(inherits_browser);\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-resize/AutoResize.js\n\n\n\n\n\n\n\n\n\n\n\n/**\n * An auto resize component that takes care of expanding a parent element\n * if child elements are created or moved close the parents edge.\n *\n * @param {EventBus} eventBus\n * @param {ElementRegistry} elementRegistry\n * @param {Modeling} modeling\n * @param {Rules} rules\n */\nfunction AutoResize(eventBus, elementRegistry, modeling, rules) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  this._elementRegistry = elementRegistry;\n  this._modeling = modeling;\n  this._rules = rules;\n\n  var self = this;\n\n  this.postExecuted([ 'shape.create' ], function(event) {\n    var context = event.context,\n        hints = context.hints,\n        shape = context.shape,\n        parent = context.parent || context.newParent;\n\n    if (hints && (hints.root === false || hints.autoResize === false)) {\n      return;\n    }\n\n    self._expand([ shape ], parent);\n  });\n\n  this.postExecuted([ 'elements.move' ], function(event) {\n    var context = event.context,\n        elements = (0,index_esm/* flatten */.xH)((0,index_esm/* values */.VO)(context.closure.topLevel)),\n        hints = context.hints;\n\n    var autoResize = hints ? hints.autoResize : true;\n\n    if (autoResize === false) {\n      return;\n    }\n\n    var expandings = (0,index_esm/* groupBy */.vM)(elements, function(element) {\n      return element.parent.id;\n    });\n\n    (0,index_esm/* forEach */.Ed)(expandings, function(elements, parentId) {\n\n      // optionally filter elements to be considered when resizing\n      if ((0,index_esm/* isArray */.kJ)(autoResize)) {\n        elements = elements.filter(function(element) {\n          return autoResize.indexOf(element) !== -1;\n        });\n      }\n\n      self._expand(elements, parentId);\n    });\n  });\n\n  this.postExecuted([ 'shape.toggleCollapse' ], function(event) {\n    var context = event.context,\n        hints = context.hints,\n        shape = context.shape;\n\n    if (hints && (hints.root === false || hints.autoResize === false)) {\n      return;\n    }\n\n    if (shape.collapsed) {\n      return;\n    }\n\n    self._expand(shape.children || [], shape);\n  });\n\n  this.postExecuted([ 'shape.resize' ], function(event) {\n    var context = event.context,\n        hints = context.hints,\n        shape = context.shape,\n        parent = shape.parent;\n\n    if (hints && (hints.root === false || hints.autoResize === false)) {\n      return;\n    }\n\n    if (parent) {\n      self._expand([ shape ], parent);\n    }\n  });\n\n}\n\nAutoResize.$inject = [\n  'eventBus',\n  'elementRegistry',\n  'modeling',\n  'rules'\n];\n\ninherits_browser_default()(AutoResize, CommandInterceptor/* default */.Z);\n\n\n/**\n * Calculate the new bounds of the target shape, given\n * a number of elements have been moved or added into the parent.\n *\n * This method considers the current size, the added elements as well as\n * the provided padding for the new bounds.\n *\n * @param {Array<djs.model.Shape>} elements\n * @param {djs.model.Shape} target\n */\nAutoResize.prototype._getOptimalBounds = function(elements, target) {\n\n  var offset = this.getOffset(target),\n      padding = this.getPadding(target);\n\n  var elementsTrbl = (0,LayoutUtil/* asTRBL */.JA)((0,Elements/* getBBox */.jY)(elements)),\n      targetTrbl = (0,LayoutUtil/* asTRBL */.JA)(target);\n\n  var newTrbl = {};\n\n  if (elementsTrbl.top - targetTrbl.top < padding.top) {\n    newTrbl.top = elementsTrbl.top - offset.top;\n  }\n\n  if (elementsTrbl.left - targetTrbl.left < padding.left) {\n    newTrbl.left = elementsTrbl.left - offset.left;\n  }\n\n  if (targetTrbl.right - elementsTrbl.right < padding.right) {\n    newTrbl.right = elementsTrbl.right + offset.right;\n  }\n\n  if (targetTrbl.bottom - elementsTrbl.bottom < padding.bottom) {\n    newTrbl.bottom = elementsTrbl.bottom + offset.bottom;\n  }\n\n  return (0,LayoutUtil/* asBounds */.z_)((0,index_esm/* assign */.f0)({}, targetTrbl, newTrbl));\n};\n\n\n/**\n * Expand the target shape respecting rules, offset and padding\n *\n * @param {Array<djs.model.Shape>} elements\n * @param {djs.model.Shape|String} target|targetId\n */\nAutoResize.prototype._expand = function(elements, target) {\n\n  if (typeof target === 'string') {\n    target = this._elementRegistry.get(target);\n  }\n\n  var allowed = this._rules.allowed('element.autoResize', {\n    elements: elements,\n    target: target\n  });\n\n  if (!allowed) {\n    return;\n  }\n\n  // calculate the new bounds\n  var newBounds = this._getOptimalBounds(elements, target);\n\n  if (!boundsChanged(newBounds, target)) {\n    return;\n  }\n\n  var resizeDirections = getResizeDirections((0,index_esm/* pick */.ei)(target, [ 'x', 'y', 'width', 'height' ]), newBounds);\n\n  // resize the parent shape\n  this.resize(target, newBounds, {\n    autoResize: resizeDirections\n  });\n\n  var parent = target.parent;\n\n  // recursively expand parent elements\n  if (parent) {\n    this._expand([ target ], parent);\n  }\n};\n\n\n/**\n * Get the amount to expand the given shape in each direction.\n *\n * @param {djs.model.Shape} shape\n *\n * @return {TRBL}\n */\nAutoResize.prototype.getOffset = function(shape) {\n  return { top: 60, bottom: 60, left: 100, right: 100 };\n};\n\n\n/**\n * Get the activation threshold for each side for which\n * resize triggers.\n *\n * @param {djs.model.Shape} shape\n *\n * @return {TRBL}\n */\nAutoResize.prototype.getPadding = function(shape) {\n  return { top: 2, bottom: 2, left: 15, right: 15 };\n};\n\n\n/**\n * Perform the actual resize operation.\n *\n * @param {djs.model.Shape} shape\n * @param {Bounds} newBounds\n * @param {Object} [hints]\n * @param {string} [hints.autoResize]\n */\nAutoResize.prototype.resize = function(shape, newBounds, hints) {\n  this._modeling.resizeShape(shape, newBounds, null, hints);\n};\n\n\nfunction boundsChanged(newBounds, oldBounds) {\n  return (\n    newBounds.x !== oldBounds.x ||\n    newBounds.y !== oldBounds.y ||\n    newBounds.width !== oldBounds.width ||\n    newBounds.height !== oldBounds.height\n  );\n}\n\n/**\n * Get directions of resize as {n|w|s|e} e.g. \"nw\".\n *\n * @param {Bounds} oldBounds\n * @param {Bounds} newBounds\n *\n * @returns {string} Resize directions as {n|w|s|e}.\n */\nfunction getResizeDirections(oldBounds, newBounds) {\n  var directions = '';\n\n  oldBounds = (0,LayoutUtil/* asTRBL */.JA)(oldBounds);\n  newBounds = (0,LayoutUtil/* asTRBL */.JA)(newBounds);\n\n  if (oldBounds.top > newBounds.top) {\n    directions = directions.concat('n');\n  }\n\n  if (oldBounds.right < newBounds.right) {\n    directions = directions.concat('w');\n  }\n\n  if (oldBounds.bottom < newBounds.bottom) {\n    directions = directions.concat('s');\n  }\n\n  if (oldBounds.left > newBounds.left) {\n    directions = directions.concat('e');\n  }\n\n  return directions;\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-resize/index.js\n\n\n/* harmony default export */ const auto_resize = ({\n  __init__: [ 'autoResize' ],\n  autoResize: [ 'type', AutoResize ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-resize/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-scroll/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ auto_scroll)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js + 2 modules\nvar dragging = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/mouse-tracking/MouseTracking.js\n\n\n\nfunction MouseTracking(eventBus, canvas) {\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n\n  this._init();\n}\n\nMouseTracking.$inject = [\n  'eventBus',\n  'canvas'\n];\n\n\nMouseTracking.prototype.getHoverContext = function() {\n  var viewbox = this._canvas.viewbox();\n\n  return {\n    element: this._hoverElement,\n    point: {\n      x: viewbox.x + Math.round(this._mouseX / viewbox.scale),\n      y: viewbox.y + Math.round(this._mouseY / viewbox.scale)\n    }\n  };\n};\n\nMouseTracking.prototype._init = function() {\n  var eventBus = this._eventBus,\n      canvas = this._canvas;\n\n  var container = canvas.getContainer();\n\n  this._setMousePosition = (0,index_esm/* bind */.ak)(this._setMousePosition, this);\n\n  container.addEventListener('mousemove', this._setMousePosition);\n\n  eventBus.on('diagram.destroy', function() {\n    container.removeEventListener('mousemove', this._setMousePosition);\n  }, this);\n\n  eventBus.on('element.hover', this._setHoverElement, this);\n};\n\n\nMouseTracking.prototype._setHoverElement = function(event) {\n  this._hoverElement = event.element;\n};\n\n\nMouseTracking.prototype._setMousePosition = function(event) {\n  this._mouseX = event.layerX;\n  this._mouseY = event.layerY;\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/mouse-tracking/index.js\n\n\n/* harmony default export */ const mouse_tracking = ({\n  __init__: [ 'mouseTracking' ],\n  mouseTracking: [ 'type', MouseTracking ]\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-scroll/AutoScroll.js\n\n\n\n\n\n/**\n * Initiates canvas scrolling if current cursor point is close to a border.\n * Cancelled when current point moves back inside the scrolling borders\n * or cancelled manually.\n *\n * Default options :\n *   scrollThresholdIn: [ 20, 20, 20, 20 ],\n *   scrollThresholdOut: [ 0, 0, 0, 0 ],\n *   scrollRepeatTimeout: 15,\n *   scrollStep: 10\n *\n * Threshold order:\n *   [ left, top, right, bottom ]\n */\nfunction AutoScroll(config, eventBus, canvas, mouseTracking) {\n\n  this._canvas = canvas;\n  this._mouseTracking = mouseTracking;\n\n  this._opts = (0,index_esm/* assign */.f0)({\n    scrollThresholdIn: [ 20, 20, 20, 20 ],\n    scrollThresholdOut: [ 0, 0, 0, 0 ],\n    scrollRepeatTimeout: 15,\n    scrollStep: 10\n  }, config);\n\n  var self = this;\n\n  eventBus.on('drag.move', function(e) {\n    var point = self._toBorderPoint(e);\n\n    self.startScroll(point);\n  });\n\n  eventBus.on([ 'drag.cleanup' ], function() {\n    self.stopScroll();\n  });\n}\n\nAutoScroll.$inject = [\n  'config.autoScroll',\n  'eventBus',\n  'canvas',\n  'mouseTracking'\n];\n\n\n/**\n * Starts scrolling loop.\n * Point is given in global scale in canvas container box plane.\n *\n * @param  {Object} point { x: X, y: Y }\n */\nAutoScroll.prototype.startScroll = function(point) {\n\n  var canvas = this._canvas;\n  var opts = this._opts;\n  var self = this;\n\n  var clientRect = canvas.getContainer().getBoundingClientRect();\n\n  var diff = [\n    point.x,\n    point.y,\n    clientRect.width - point.x,\n    clientRect.height - point.y\n  ];\n\n  this.stopScroll();\n\n  var dx = 0,\n      dy = 0;\n\n  for (var i = 0; i < 4; i++) {\n    if (between(diff[i], opts.scrollThresholdOut[i], opts.scrollThresholdIn[i])) {\n      if (i === 0) {\n        dx = opts.scrollStep;\n      } else if (i == 1) {\n        dy = opts.scrollStep;\n      } else if (i == 2) {\n        dx = -opts.scrollStep;\n      } else if (i == 3) {\n        dy = -opts.scrollStep;\n      }\n    }\n  }\n\n  if (dx !== 0 || dy !== 0) {\n    canvas.scroll({ dx: dx, dy: dy });\n\n    this._scrolling = setTimeout(function() {\n      self.startScroll(point);\n    }, opts.scrollRepeatTimeout);\n  }\n};\n\nfunction between(val, start, end) {\n  if (start < val && val < end) {\n    return true;\n  }\n\n  return false;\n}\n\n\n/**\n * Stops scrolling loop.\n */\nAutoScroll.prototype.stopScroll = function() {\n  clearTimeout(this._scrolling);\n};\n\n\n/**\n * Overrides defaults options.\n *\n * @param  {Object} options\n */\nAutoScroll.prototype.setOptions = function(options) {\n  this._opts = (0,index_esm/* assign */.f0)({}, this._opts, options);\n};\n\n\n/**\n * Converts event to a point in canvas container plane in global scale.\n *\n * @param  {Event} event\n * @return {Point}\n */\nAutoScroll.prototype._toBorderPoint = function(event) {\n  var clientRect = this._canvas._container.getBoundingClientRect();\n\n  var globalPosition = (0,Event/* toPoint */.jt)(event.originalEvent);\n\n  return {\n    x: globalPosition.x - clientRect.left,\n    y: globalPosition.y - clientRect.top\n  };\n};\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-scroll/index.js\n\n\n\n\n\n\n/* harmony default export */ const auto_scroll = ({\n  __depends__: [\n    dragging/* default */.Z,\n    mouse_tracking\n  ],\n  __init__: [ 'autoScroll' ],\n  autoScroll: [ 'type', AutoScroll ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/auto-scroll/index.js_+_3_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ bendpoints)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js + 2 modules\nvar dragging = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Geometry.js\nvar Geometry = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Geometry.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/LineIntersection.js\nvar LineIntersection = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/LineIntersection.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/BendpointUtil.js\n\n\n\n\n\n\n\n\n\n\nvar BENDPOINT_CLS = 'djs-bendpoint';\nvar SEGMENT_DRAGGER_CLS = 'djs-segment-dragger';\n\nfunction toCanvasCoordinates(canvas, event) {\n\n  var position = (0,Event/* toPoint */.jt)(event),\n      clientRect = canvas._container.getBoundingClientRect(),\n      offset;\n\n  // canvas relative position\n\n  offset = {\n    x: clientRect.left,\n    y: clientRect.top\n  };\n\n  // update actual event payload with canvas relative measures\n\n  var viewbox = canvas.viewbox();\n\n  return {\n    x: viewbox.x + (position.x - offset.x) / viewbox.scale,\n    y: viewbox.y + (position.y - offset.y) / viewbox.scale\n  };\n}\n\nfunction getConnectionIntersection(canvas, waypoints, event) {\n  var localPosition = toCanvasCoordinates(canvas, event),\n      intersection = (0,LineIntersection/* getApproxIntersection */.t)(waypoints, localPosition);\n\n  return intersection;\n}\n\nfunction addBendpoint(parentGfx, cls) {\n  var groupGfx = (0,tiny_svg_dist_index_esm/* create */.Ue)('g');\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(groupGfx).add(BENDPOINT_CLS);\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, groupGfx);\n\n  var visual = (0,tiny_svg_dist_index_esm/* create */.Ue)('circle');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(visual, {\n    cx: 0,\n    cy: 0,\n    r: 4\n  });\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(visual).add('djs-visual');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(groupGfx, visual);\n\n  var hit = (0,tiny_svg_dist_index_esm/* create */.Ue)('circle');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, {\n    cx: 0,\n    cy: 0,\n    r: 10\n  });\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(hit).add('djs-hit');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(groupGfx, hit);\n\n  if (cls) {\n    (0,tiny_svg_dist_index_esm/* classes */.Sh)(groupGfx).add(cls);\n  }\n\n  return groupGfx;\n}\n\nfunction createParallelDragger(parentGfx, segmentStart, segmentEnd, alignment) {\n  var draggerGfx = (0,tiny_svg_dist_index_esm/* create */.Ue)('g');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, draggerGfx);\n\n  var width = 14,\n      height = 3,\n      padding = 6,\n      hitWidth = calculateHitWidth(segmentStart, segmentEnd, alignment, padding),\n      hitHeight = height + padding;\n\n  var visual = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(visual, {\n    x: -width / 2,\n    y: -height / 2,\n    width: width,\n    height: height\n  });\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(visual).add('djs-visual');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(draggerGfx, visual);\n\n  var hit = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n  (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, {\n    x: -hitWidth / 2,\n    y: -hitHeight / 2,\n    width: hitWidth,\n    height: hitHeight\n  });\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(hit).add('djs-hit');\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(draggerGfx, hit);\n\n  (0,SvgTransformUtil/* rotate */.U1)(draggerGfx, alignment === 'v' ? 90 : 0, 0, 0);\n\n  return draggerGfx;\n}\n\n\nfunction addSegmentDragger(parentGfx, segmentStart, segmentEnd) {\n\n  var groupGfx = (0,tiny_svg_dist_index_esm/* create */.Ue)('g'),\n      mid = (0,Geometry/* getMidPoint */.SO)(segmentStart, segmentEnd),\n      alignment = (0,Geometry/* pointsAligned */.Or)(segmentStart, segmentEnd);\n\n  (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, groupGfx);\n\n  createParallelDragger(groupGfx, segmentStart, segmentEnd, alignment);\n\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(groupGfx).add(SEGMENT_DRAGGER_CLS);\n  (0,tiny_svg_dist_index_esm/* classes */.Sh)(groupGfx).add(alignment === 'h' ? 'horizontal' : 'vertical');\n\n  (0,SvgTransformUtil/* translate */.Iu)(groupGfx, mid.x, mid.y);\n\n  return groupGfx;\n}\n\n/**\n * Calculates region for segment move which is 2/3 of the full segment length\n * @param {Number} segmentLength\n *\n * @return {Number}\n */\nfunction calculateSegmentMoveRegion(segmentLength) {\n  return Math.abs(Math.round(segmentLength * 2 / 3));\n}\n\n// helper //////////\n\nfunction calculateHitWidth(segmentStart, segmentEnd, alignment) {\n  var segmentLengthXAxis = segmentEnd.x - segmentStart.x,\n      segmentLengthYAxis = segmentEnd.y - segmentStart.y;\n\n  return alignment === 'h' ?\n    calculateSegmentMoveRegion(segmentLengthXAxis) :\n    calculateSegmentMoveRegion(segmentLengthYAxis);\n}\n\n// EXTERNAL MODULE: ./node_modules/css.escape/css.escape.js\nvar css_escape = __webpack_require__(\"./node_modules/css.escape/css.escape.js\");\nvar css_escape_default = /*#__PURE__*/__webpack_require__.n(css_escape);\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/GraphicsUtil.js\nvar GraphicsUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/GraphicsUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/Bendpoints.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A service that adds editable bendpoints to connections.\n */\nfunction Bendpoints(\n    eventBus, canvas, interactionEvents,\n    bendpointMove, connectionSegmentMove) {\n\n  /**\n   * Returns true if intersection point is inside middle region of segment, adjusted by\n   * optional threshold\n   */\n  function isIntersectionMiddle(intersection, waypoints, treshold) {\n    var idx = intersection.index,\n        p = intersection.point,\n        p0, p1, mid, aligned, xDelta, yDelta;\n\n    if (idx <= 0 || intersection.bendpoint) {\n      return false;\n    }\n\n    p0 = waypoints[idx - 1];\n    p1 = waypoints[idx];\n    mid = (0,Geometry/* getMidPoint */.SO)(p0, p1),\n    aligned = (0,Geometry/* pointsAligned */.Or)(p0, p1);\n    xDelta = Math.abs(p.x - mid.x);\n    yDelta = Math.abs(p.y - mid.y);\n\n    return aligned && xDelta <= treshold && yDelta <= treshold;\n  }\n\n  /**\n   * Calculates the threshold from a connection's middle which fits the two-third-region\n   */\n  function calculateIntersectionThreshold(connection, intersection) {\n    var waypoints = connection.waypoints,\n        relevantSegment, alignment, segmentLength, threshold;\n\n    if (intersection.index <= 0 || intersection.bendpoint) {\n      return null;\n    }\n\n    // segment relative to connection intersection\n    relevantSegment = {\n      start: waypoints[intersection.index - 1],\n      end: waypoints[intersection.index]\n    };\n\n    alignment = (0,Geometry/* pointsAligned */.Or)(relevantSegment.start, relevantSegment.end);\n\n    if (!alignment) {\n      return null;\n    }\n\n    if (alignment === 'h') {\n      segmentLength = relevantSegment.end.x - relevantSegment.start.x;\n    } else {\n      segmentLength = relevantSegment.end.y - relevantSegment.start.y;\n    }\n\n    // calculate threshold relative to 2/3 of segment length\n    threshold = calculateSegmentMoveRegion(segmentLength) / 2;\n\n    return threshold;\n  }\n\n  function activateBendpointMove(event, connection) {\n    var waypoints = connection.waypoints,\n        intersection = getConnectionIntersection(canvas, waypoints, event),\n        threshold;\n\n    if (!intersection) {\n      return;\n    }\n\n    threshold = calculateIntersectionThreshold(connection, intersection);\n\n    if (isIntersectionMiddle(intersection, waypoints, threshold)) {\n      connectionSegmentMove.start(event, connection, intersection.index);\n    } else {\n      bendpointMove.start(event, connection, intersection.index, !intersection.bendpoint);\n    }\n\n    // we've handled the event\n    return true;\n  }\n\n  function bindInteractionEvents(node, eventName, element) {\n\n    dist_index_esm/* event.bind */.B.bind(node, eventName, function(event) {\n      interactionEvents.triggerMouseEvent(eventName, event, element);\n      event.stopPropagation();\n    });\n  }\n\n  function getBendpointsContainer(element, create) {\n\n    var layer = canvas.getLayer('overlays'),\n        gfx = (0,dist_index_esm/* query */.IO)('.djs-bendpoints[data-element-id=\"' + css_escape_default()(element.id) + '\"]', layer);\n\n    if (!gfx && create) {\n      gfx = (0,tiny_svg_dist_index_esm/* create */.Ue)('g');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(gfx, { 'data-element-id': element.id });\n      (0,tiny_svg_dist_index_esm/* classes */.Sh)(gfx).add('djs-bendpoints');\n\n      (0,tiny_svg_dist_index_esm/* append */.R3)(layer, gfx);\n\n      bindInteractionEvents(gfx, 'mousedown', element);\n      bindInteractionEvents(gfx, 'click', element);\n      bindInteractionEvents(gfx, 'dblclick', element);\n    }\n\n    return gfx;\n  }\n\n  function getSegmentDragger(idx, parentGfx) {\n    return (0,dist_index_esm/* query */.IO)(\n      '.djs-segment-dragger[data-segment-idx=\"' + idx + '\"]',\n      parentGfx\n    );\n  }\n\n  function createBendpoints(gfx, connection) {\n    connection.waypoints.forEach(function(p, idx) {\n      var bendpoint = addBendpoint(gfx);\n\n      (0,tiny_svg_dist_index_esm/* append */.R3)(gfx, bendpoint);\n\n      (0,SvgTransformUtil/* translate */.Iu)(bendpoint, p.x, p.y);\n    });\n\n    // add floating bendpoint\n    addBendpoint(gfx, 'floating');\n  }\n\n  function createSegmentDraggers(gfx, connection) {\n\n    var waypoints = connection.waypoints;\n\n    var segmentStart,\n        segmentEnd,\n        segmentDraggerGfx;\n\n    for (var i = 1; i < waypoints.length; i++) {\n\n      segmentStart = waypoints[i - 1];\n      segmentEnd = waypoints[i];\n\n      if ((0,Geometry/* pointsAligned */.Or)(segmentStart, segmentEnd)) {\n        segmentDraggerGfx = addSegmentDragger(gfx, segmentStart, segmentEnd);\n\n        (0,tiny_svg_dist_index_esm/* attr */.Lj)(segmentDraggerGfx, { 'data-segment-idx': i });\n\n        bindInteractionEvents(segmentDraggerGfx, 'mousemove', connection);\n      }\n    }\n  }\n\n  function clearBendpoints(gfx) {\n    (0,index_esm/* forEach */.Ed)((0,dist_index_esm/* queryAll */.Kt)('.' + BENDPOINT_CLS, gfx), function(node) {\n      (0,tiny_svg_dist_index_esm/* remove */.Od)(node);\n    });\n  }\n\n  function clearSegmentDraggers(gfx) {\n    (0,index_esm/* forEach */.Ed)((0,dist_index_esm/* queryAll */.Kt)('.' + SEGMENT_DRAGGER_CLS, gfx), function(node) {\n      (0,tiny_svg_dist_index_esm/* remove */.Od)(node);\n    });\n  }\n\n  function addHandles(connection) {\n\n    var gfx = getBendpointsContainer(connection);\n\n    if (!gfx) {\n      gfx = getBendpointsContainer(connection, true);\n\n      createBendpoints(gfx, connection);\n      createSegmentDraggers(gfx, connection);\n    }\n\n    return gfx;\n  }\n\n  function updateHandles(connection) {\n\n    var gfx = getBendpointsContainer(connection);\n\n    if (gfx) {\n      clearSegmentDraggers(gfx);\n      clearBendpoints(gfx);\n      createSegmentDraggers(gfx, connection);\n      createBendpoints(gfx, connection);\n    }\n  }\n\n  function updateFloatingBendpointPosition(parentGfx, intersection) {\n    var floating = (0,dist_index_esm/* query */.IO)('.floating', parentGfx),\n        point = intersection.point;\n\n    if (!floating) {\n      return;\n    }\n\n    (0,SvgTransformUtil/* translate */.Iu)(floating, point.x, point.y);\n\n  }\n\n  function updateSegmentDraggerPosition(parentGfx, intersection, waypoints) {\n\n    var draggerGfx = getSegmentDragger(intersection.index, parentGfx),\n        segmentStart = waypoints[intersection.index - 1],\n        segmentEnd = waypoints[intersection.index],\n        point = intersection.point,\n        mid = (0,Geometry/* getMidPoint */.SO)(segmentStart, segmentEnd),\n        alignment = (0,Geometry/* pointsAligned */.Or)(segmentStart, segmentEnd),\n        draggerVisual, relativePosition;\n\n    if (!draggerGfx) {\n      return;\n    }\n\n    draggerVisual = (0,GraphicsUtil/* getVisual */.s)(draggerGfx);\n\n    relativePosition = {\n      x: point.x - mid.x,\n      y: point.y - mid.y\n    };\n\n    if (alignment === 'v') {\n\n      // rotate position\n      relativePosition = {\n        x: relativePosition.y,\n        y: relativePosition.x\n      };\n    }\n\n    (0,SvgTransformUtil/* translate */.Iu)(draggerVisual, relativePosition.x, relativePosition.y);\n  }\n\n  eventBus.on('connection.changed', function(event) {\n    updateHandles(event.element);\n  });\n\n  eventBus.on('connection.remove', function(event) {\n    var gfx = getBendpointsContainer(event.element);\n\n    if (gfx) {\n      (0,tiny_svg_dist_index_esm/* remove */.Od)(gfx);\n    }\n  });\n\n  eventBus.on('element.marker.update', function(event) {\n\n    var element = event.element,\n        bendpointsGfx;\n\n    if (!element.waypoints) {\n      return;\n    }\n\n    bendpointsGfx = addHandles(element);\n\n    if (event.add) {\n      (0,tiny_svg_dist_index_esm/* classes */.Sh)(bendpointsGfx).add(event.marker);\n    } else {\n      (0,tiny_svg_dist_index_esm/* classes */.Sh)(bendpointsGfx).remove(event.marker);\n    }\n  });\n\n  eventBus.on('element.mousemove', function(event) {\n\n    var element = event.element,\n        waypoints = element.waypoints,\n        bendpointsGfx,\n        intersection;\n\n    if (waypoints) {\n      bendpointsGfx = getBendpointsContainer(element, true);\n\n      intersection = getConnectionIntersection(canvas, waypoints, event.originalEvent);\n\n      if (!intersection) {\n        return;\n      }\n\n      updateFloatingBendpointPosition(bendpointsGfx, intersection);\n\n      if (!intersection.bendpoint) {\n        updateSegmentDraggerPosition(bendpointsGfx, intersection, waypoints);\n      }\n\n    }\n  });\n\n  eventBus.on('element.mousedown', function(event) {\n\n    var originalEvent = event.originalEvent,\n        element = event.element,\n        waypoints = element.waypoints;\n\n    if (!waypoints) {\n      return;\n    }\n\n    return activateBendpointMove(originalEvent, element, waypoints);\n  });\n\n  eventBus.on('selection.changed', function(event) {\n    var newSelection = event.newSelection,\n        primary = newSelection[0];\n\n    if (primary && primary.waypoints) {\n      addHandles(primary);\n    }\n  });\n\n  eventBus.on('element.hover', function(event) {\n    var element = event.element;\n\n    if (element.waypoints) {\n      addHandles(element);\n      interactionEvents.registerEvent(event.gfx, 'mousemove', 'element.mousemove');\n    }\n  });\n\n  eventBus.on('element.out', function(event) {\n    interactionEvents.unregisterEvent(event.gfx, 'mousemove', 'element.mousemove');\n  });\n\n  // update bendpoint container data attribute on element ID change\n  eventBus.on('element.updateId', function(context) {\n    var element = context.element,\n        newId = context.newId;\n\n    if (element.waypoints) {\n      var bendpointContainer = getBendpointsContainer(element);\n\n      if (bendpointContainer) {\n        (0,tiny_svg_dist_index_esm/* attr */.Lj)(bendpointContainer, { 'data-element-id': newId });\n      }\n    }\n  });\n\n  // API\n\n  this.addHandles = addHandles;\n  this.updateHandles = updateHandles;\n  this.getBendpointsContainer = getBendpointsContainer;\n  this.getSegmentDragger = getSegmentDragger;\n}\n\nBendpoints.$inject = [\n  'eventBus',\n  'canvas',\n  'interactionEvents',\n  'bendpointMove',\n  'connectionSegmentMove'\n];\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/BendpointMove.js\n\n\nvar COMMAND_BENDPOINT_UPDATE = 'connection.updateWaypoints',\n    COMMAND_RECONNECT_START = 'connection.reconnectStart',\n    COMMAND_RECONNECT_END = 'connection.reconnectEnd';\n\nvar round = Math.round;\n\n\n/**\n * A component that implements moving of bendpoints\n */\nfunction BendpointMove(injector, eventBus, canvas, dragging, rules, modeling) {\n\n  // optional connection docking integration\n  var connectionDocking = injector.get('connectionDocking', false);\n\n\n  // API\n  this.start = function(event, connection, bendpointIndex, insert) {\n\n    var type,\n        context,\n        waypoints = connection.waypoints,\n        gfx = canvas.getGraphics(connection);\n\n    if (!insert && bendpointIndex === 0) {\n      type = COMMAND_RECONNECT_START;\n    } else\n    if (!insert && bendpointIndex === waypoints.length - 1) {\n      type = COMMAND_RECONNECT_END;\n    } else {\n      type = COMMAND_BENDPOINT_UPDATE;\n    }\n\n    context = {\n      connection: connection,\n      bendpointIndex: bendpointIndex,\n      insert: insert,\n      type: type\n    };\n\n    var allowed = context.allowed = rules.allowed(context.type, context);\n\n    if (allowed === false) {\n      return;\n    }\n\n    dragging.init(event, 'bendpoint.move', {\n      data: {\n        connection: connection,\n        connectionGfx: gfx,\n        context: context\n      }\n    });\n  };\n\n  eventBus.on('bendpoint.move.hover', function(e) {\n    var context = e.context;\n\n    context.hover = e.hover;\n\n    if (e.hover) {\n      // asks whether reconnect / bendpoint move / bendpoint add\n      // is allowed at the given position\n      var allowed = context.allowed = rules.allowed(context.type, context);\n\n      if (allowed) {\n        context.target = context.hover;\n      }\n    }\n  });\n\n  eventBus.on([ 'bendpoint.move.out', 'bendpoint.move.cleanup' ], function(event) {\n    var context = event.context;\n\n    context.target = null;\n    context.allowed = false;\n  });\n\n  eventBus.on('bendpoint.move.end', function(e) {\n\n    var context = e.context,\n        connection = context.connection,\n        originalWaypoints = connection.waypoints,\n        newWaypoints = originalWaypoints.slice(),\n        bendpointIndex = context.bendpointIndex,\n        allowed = context.allowed,\n        insert = context.insert,\n        bendpoint,\n        hints;\n\n    // ensure we have actual pixel values bendpoint\n    // coordinates (important when zoom level was > 1 during move)\n    bendpoint = {\n      x: round(e.x),\n      y: round(e.y)\n    };\n\n    if (allowed && context.type === COMMAND_RECONNECT_START) {\n      modeling.reconnectStart(context.connection, context.target, bendpoint);\n    } else if (allowed && context.type === COMMAND_RECONNECT_END) {\n      modeling.reconnectEnd(context.connection, context.target, bendpoint);\n    } else if (allowed !== false && context.type === COMMAND_BENDPOINT_UPDATE) {\n      if (insert) {\n        // insert new bendpoint\n        newWaypoints.splice(bendpointIndex, 0, bendpoint);\n      } else {\n        // swap previous waypoint with the moved one\n        newWaypoints[bendpointIndex] = bendpoint;\n      }\n\n      // pass hints on the actual moved bendpoint\n      // this is useful for connection and label layouting\n      hints = {\n        bendpointMove: {\n          insert: insert,\n          bendpointIndex: bendpointIndex\n        }\n      };\n\n      if (connectionDocking) {\n        // (0) temporarily assign new waypoints\n        connection.waypoints = newWaypoints;\n\n        // (1) crop connection with new waypoints and save them\n        connection.waypoints = connectionDocking.getCroppedWaypoints(connection);\n        newWaypoints = connection.waypoints;\n\n        // (2) restore original waypoints to not mutate connection directly\n        connection.waypoints = originalWaypoints;\n      }\n\n      modeling.updateWaypoints(context.connection, (0,LayoutUtil/* filterRedundantWaypoints */.Re)(newWaypoints), hints);\n    } else {\n      return false;\n    }\n  });\n}\n\nBendpointMove.$inject = [\n  'injector',\n  'eventBus',\n  'canvas',\n  'dragging',\n  'rules',\n  'modeling'\n];\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/BendpointMovePreview.js\n\n\n\n\n\n\n\n\n\nvar MARKER_OK = 'connect-ok',\n    MARKER_NOT_OK = 'connect-not-ok',\n    MARKER_CONNECT_HOVER = 'connect-hover',\n    MARKER_CONNECT_UPDATING = 'djs-updating',\n    MARKER_ELEMENT_HIDDEN = 'djs-element-hidden';\n\nvar BendpointMovePreview_COMMAND_RECONNECT_START = 'connection.reconnectStart',\n    BendpointMovePreview_COMMAND_RECONNECT_END = 'connection.reconnectEnd';\n\nvar HIGH_PRIORITY = 1100;\n\n/**\n * A component that implements moving of bendpoints\n */\nfunction BendpointMovePreview(injector, eventBus, canvas) {\n\n  var connectionPreview = injector.get('connectionPreview', false),\n      connectionDocking = injector.get('connectionDocking', false);\n\n  // DRAGGING IMPLEMENTATION\n\n  eventBus.on('bendpoint.move.start', function(e) {\n\n    var context = e.context,\n        connection = context.connection,\n        originalWaypoints = connection.waypoints,\n        waypoints = originalWaypoints.slice(),\n        insert = context.insert,\n        idx = context.bendpointIndex;\n\n    // save waypoints to restore at the end\n    context.originalWaypoints = originalWaypoints;\n\n    if (insert) {\n      // insert placeholder for bendpoint to-be-added\n      waypoints.splice(idx, 0, { x: e.x, y: e.y });\n    }\n\n    connection.waypoints = waypoints;\n\n    // add dragger gfx\n    context.draggerGfx = addBendpoint(canvas.getLayer('overlays'));\n    (0,tiny_svg_dist_index_esm/* classes */.Sh)(context.draggerGfx).add('djs-dragging');\n\n    canvas.addMarker(connection, MARKER_CONNECT_UPDATING);\n    canvas.addMarker(connection, MARKER_ELEMENT_HIDDEN);\n  });\n\n  eventBus.on('bendpoint.move.hover', function(e) {\n    var context = e.context,\n        allowed = context.allowed,\n        hover = context.hover,\n        moveType = context.type;\n\n    if (e.hover) {\n      canvas.addMarker(hover, MARKER_CONNECT_HOVER);\n\n      if (\n        moveType !== BendpointMovePreview_COMMAND_RECONNECT_START &&\n        moveType !== BendpointMovePreview_COMMAND_RECONNECT_END\n      ) {\n        return;\n      }\n\n      if (allowed) {\n        canvas.removeMarker(hover, MARKER_NOT_OK);\n        canvas.addMarker(hover, MARKER_OK);\n      } else if (allowed === false) {\n        canvas.removeMarker(hover, MARKER_OK);\n        canvas.addMarker(hover, MARKER_NOT_OK);\n      }\n    }\n  });\n\n  eventBus.on([\n    'bendpoint.move.out',\n    'bendpoint.move.cleanup'\n  ], HIGH_PRIORITY, function(e) {\n\n    // remove connect marker\n    // if it was added\n    var hover = e.context.hover;\n\n    if (hover) {\n      canvas.removeMarker(hover, MARKER_CONNECT_HOVER);\n      canvas.removeMarker(hover, e.context.target ? MARKER_OK : MARKER_NOT_OK);\n    }\n  });\n\n  eventBus.on('bendpoint.move.move', function(e) {\n\n    var context = e.context,\n        moveType = context.type,\n        connection = e.connection,\n        originalWaypoints = connection.waypoints,\n        waypoints = originalWaypoints.slice(),\n        bendpoint = { x: e.x, y: e.y },\n        hints;\n\n    if (connectionPreview) {\n      hints = {\n        source: connection.source,\n        target: connection.target\n      };\n\n      if (moveType === BendpointMovePreview_COMMAND_RECONNECT_START) {\n        hints.source = context.target;\n        hints.connectionStart = bendpoint;\n      } else if (moveType === BendpointMovePreview_COMMAND_RECONNECT_END) {\n        hints.target = context.target;\n        hints.connectionEnd = bendpoint;\n      } else {\n        hints.noCropping = true;\n        hints.noLayout = true;\n        waypoints[context.bendpointIndex] = bendpoint;\n      }\n\n      if (connectionDocking) {\n        // (0) temporarily assign new waypoints\n        connection.waypoints = waypoints;\n\n        // (1) crop connection with new waypoints and save them\n        connection.waypoints = connectionDocking.getCroppedWaypoints(connection);\n        waypoints = connection.waypoints;\n\n        // (2) restore original waypoints to not mutate connection directly\n        connection.waypoints = originalWaypoints;\n      }\n\n      // remove overlapping points\n      hints.waypoints = (0,LayoutUtil/* filterRedundantWaypoints */.Re)(waypoints);\n\n      connectionPreview.drawPreview(context, context.allowed, hints);\n    }\n\n    // add dragger gfx\n    (0,SvgTransformUtil/* translate */.Iu)(context.draggerGfx, e.x, e.y);\n  });\n\n  eventBus.on([\n    'bendpoint.move.end',\n    'bendpoint.move.cancel'\n  ], HIGH_PRIORITY, function(e) {\n\n    var context = e.context,\n        hover = context.hover,\n        connection = context.connection;\n\n    // reassign original waypoints\n    connection.waypoints = context.originalWaypoints;\n\n    // remove dragger gfx\n    (0,tiny_svg_dist_index_esm/* remove */.Od)(context.draggerGfx);\n\n    canvas.removeMarker(connection, MARKER_CONNECT_UPDATING);\n    canvas.removeMarker(connection, MARKER_ELEMENT_HIDDEN);\n\n    if (hover) {\n      canvas.removeMarker(hover, MARKER_OK);\n      canvas.removeMarker(hover, context.target ? MARKER_OK : MARKER_NOT_OK);\n    }\n\n    if (connectionPreview) {\n      connectionPreview.cleanUp(context);\n    }\n  });\n}\n\nBendpointMovePreview.$inject = [\n  'injector',\n  'eventBus',\n  'canvas'\n];\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/ConnectionSegmentMove.js\n\n\n\n\n\n\nvar ConnectionSegmentMove_MARKER_CONNECT_HOVER = 'connect-hover',\n    ConnectionSegmentMove_MARKER_CONNECT_UPDATING = 'djs-updating';\n\n\n\n\n\n\nfunction axisAdd(point, axis, delta) {\n  return axisSet(point, axis, point[axis] + delta);\n}\n\nfunction axisSet(point, axis, value) {\n  return {\n    x: (axis === 'x' ? value : point.x),\n    y: (axis === 'y' ? value : point.y)\n  };\n}\n\nfunction axisFenced(position, segmentStart, segmentEnd, axis) {\n\n  var maxValue = Math.max(segmentStart[axis], segmentEnd[axis]),\n      minValue = Math.min(segmentStart[axis], segmentEnd[axis]);\n\n  var padding = 20;\n\n  var fencedValue = Math.min(Math.max(minValue + padding, position[axis]), maxValue - padding);\n\n  return axisSet(segmentStart, axis, fencedValue);\n}\n\nfunction flipAxis(axis) {\n  return axis === 'x' ? 'y' : 'x';\n}\n\n/**\n * Get the docking point on the given element.\n *\n * Compute a reasonable docking, if non exists.\n *\n * @param  {Point} point\n * @param  {djs.model.Shape} referenceElement\n * @param  {String} moveAxis (x|y)\n *\n * @return {Point}\n */\nfunction getDocking(point, referenceElement, moveAxis) {\n\n  var referenceMid,\n      inverseAxis;\n\n  if (point.original) {\n    return point.original;\n  } else {\n    referenceMid = (0,LayoutUtil/* getMid */.wS)(referenceElement);\n    inverseAxis = flipAxis(moveAxis);\n\n    return axisSet(point, inverseAxis, referenceMid[inverseAxis]);\n  }\n}\n\n/**\n * A component that implements moving of bendpoints\n */\nfunction ConnectionSegmentMove(\n    injector, eventBus, canvas,\n    dragging, graphicsFactory, modeling) {\n\n  // optional connection docking integration\n  var connectionDocking = injector.get('connectionDocking', false);\n\n\n  // API\n\n  this.start = function(event, connection, idx) {\n\n    var context,\n        gfx = canvas.getGraphics(connection),\n        segmentStartIndex = idx - 1,\n        segmentEndIndex = idx,\n        waypoints = connection.waypoints,\n        segmentStart = waypoints[segmentStartIndex],\n        segmentEnd = waypoints[segmentEndIndex],\n        intersection = getConnectionIntersection(canvas, waypoints, event),\n        direction, axis, dragPosition;\n\n    direction = (0,Geometry/* pointsAligned */.Or)(segmentStart, segmentEnd);\n\n    // do not move diagonal connection\n    if (!direction) {\n      return;\n    }\n\n    // the axis where we are going to move things\n    axis = direction === 'v' ? 'x' : 'y';\n\n    if (segmentStartIndex === 0) {\n      segmentStart = getDocking(segmentStart, connection.source, axis);\n    }\n\n    if (segmentEndIndex === waypoints.length - 1) {\n      segmentEnd = getDocking(segmentEnd, connection.target, axis);\n    }\n\n    if (intersection) {\n      dragPosition = intersection.point;\n    } else {\n      // set to segment center as default\n      dragPosition = {\n        x: (segmentStart.x + segmentEnd.x) / 2,\n        y: (segmentStart.y + segmentEnd.y) / 2\n      };\n    }\n\n    context = {\n      connection: connection,\n      segmentStartIndex: segmentStartIndex,\n      segmentEndIndex: segmentEndIndex,\n      segmentStart: segmentStart,\n      segmentEnd: segmentEnd,\n      axis: axis,\n      dragPosition: dragPosition\n    };\n\n    dragging.init(event, dragPosition, 'connectionSegment.move', {\n      cursor: axis === 'x' ? 'resize-ew' : 'resize-ns',\n      data: {\n        connection: connection,\n        connectionGfx: gfx,\n        context: context\n      }\n    });\n  };\n\n  /**\n   * Crop connection if connection cropping is provided.\n   *\n   * @param {Connection} connection\n   * @param {Array<Point>} newWaypoints\n   *\n   * @return {Array<Point>} cropped connection waypoints\n   */\n  function cropConnection(connection, newWaypoints) {\n\n    // crop connection, if docking service is provided only\n    if (!connectionDocking) {\n      return newWaypoints;\n    }\n\n    var oldWaypoints = connection.waypoints,\n        croppedWaypoints;\n\n    // temporary set new waypoints\n    connection.waypoints = newWaypoints;\n\n    croppedWaypoints = connectionDocking.getCroppedWaypoints(connection);\n\n    // restore old waypoints\n    connection.waypoints = oldWaypoints;\n\n    return croppedWaypoints;\n  }\n\n  // DRAGGING IMPLEMENTATION\n\n  function redrawConnection(data) {\n    graphicsFactory.update('connection', data.connection, data.connectionGfx);\n  }\n\n  function updateDragger(context, segmentOffset, event) {\n\n    var newWaypoints = context.newWaypoints,\n        segmentStartIndex = context.segmentStartIndex + segmentOffset,\n        segmentStart = newWaypoints[segmentStartIndex],\n        segmentEndIndex = context.segmentEndIndex + segmentOffset,\n        segmentEnd = newWaypoints[segmentEndIndex],\n        axis = flipAxis(context.axis);\n\n    // make sure the dragger does not move\n    // outside the connection\n    var draggerPosition = axisFenced(event, segmentStart, segmentEnd, axis);\n\n    // update dragger\n    (0,SvgTransformUtil/* translate */.Iu)(context.draggerGfx, draggerPosition.x, draggerPosition.y);\n  }\n\n  /**\n   * Filter waypoints for redundant ones (i.e. on the same axis).\n   * Returns the filtered waypoints and the offset related to the segment move.\n   *\n   * @param {Array<Point>} waypoints\n   * @param {Integer} segmentStartIndex of moved segment start\n   *\n   * @return {Object} { filteredWaypoints, segmentOffset }\n   */\n  function filterRedundantWaypoints(waypoints, segmentStartIndex) {\n\n    var segmentOffset = 0;\n\n    var filteredWaypoints = waypoints.filter(function(r, idx) {\n      if ((0,Geometry/* pointsOnLine */.ZS)(waypoints[idx - 1], waypoints[idx + 1], r)) {\n\n        // remove point and increment offset\n        segmentOffset = idx <= segmentStartIndex ? segmentOffset - 1 : segmentOffset;\n        return false;\n      }\n\n      // dont remove point\n      return true;\n    });\n\n    return {\n      waypoints: filteredWaypoints,\n      segmentOffset: segmentOffset\n    };\n  }\n\n  eventBus.on('connectionSegment.move.start', function(e) {\n\n    var context = e.context,\n        connection = e.connection,\n        layer = canvas.getLayer('overlays');\n\n    context.originalWaypoints = connection.waypoints.slice();\n\n    // add dragger gfx\n    context.draggerGfx = addSegmentDragger(layer, context.segmentStart, context.segmentEnd);\n    (0,tiny_svg_dist_index_esm/* classes */.Sh)(context.draggerGfx).add('djs-dragging');\n\n    canvas.addMarker(connection, ConnectionSegmentMove_MARKER_CONNECT_UPDATING);\n  });\n\n  eventBus.on('connectionSegment.move.move', function(e) {\n\n    var context = e.context,\n        connection = context.connection,\n        segmentStartIndex = context.segmentStartIndex,\n        segmentEndIndex = context.segmentEndIndex,\n        segmentStart = context.segmentStart,\n        segmentEnd = context.segmentEnd,\n        axis = context.axis;\n\n    var newWaypoints = context.originalWaypoints.slice(),\n        newSegmentStart = axisAdd(segmentStart, axis, e['d' + axis]),\n        newSegmentEnd = axisAdd(segmentEnd, axis, e['d' + axis]);\n\n    // original waypoint count and added / removed\n    // from start waypoint delta. We use the later\n    // to retrieve the updated segmentStartIndex / segmentEndIndex\n    var waypointCount = newWaypoints.length,\n        segmentOffset = 0;\n\n    // move segment start / end by axis delta\n    newWaypoints[segmentStartIndex] = newSegmentStart;\n    newWaypoints[segmentEndIndex] = newSegmentEnd;\n\n    var sourceToSegmentOrientation,\n        targetToSegmentOrientation;\n\n    // handle first segment\n    if (segmentStartIndex < 2) {\n      sourceToSegmentOrientation = (0,LayoutUtil/* getOrientation */.T8)(connection.source, newSegmentStart);\n\n      // first bendpoint, remove first segment if intersecting\n      if (segmentStartIndex === 1) {\n\n        if (sourceToSegmentOrientation === 'intersect') {\n          newWaypoints.shift();\n          newWaypoints[0] = newSegmentStart;\n          segmentOffset--;\n        }\n      }\n\n      // docking point, add segment if not intersecting anymore\n      else {\n        if (sourceToSegmentOrientation !== 'intersect') {\n          newWaypoints.unshift(segmentStart);\n          segmentOffset++;\n        }\n      }\n    }\n\n    // handle last segment\n    if (segmentEndIndex > waypointCount - 3) {\n      targetToSegmentOrientation = (0,LayoutUtil/* getOrientation */.T8)(connection.target, newSegmentEnd);\n\n      // last bendpoint, remove last segment if intersecting\n      if (segmentEndIndex === waypointCount - 2) {\n\n        if (targetToSegmentOrientation === 'intersect') {\n          newWaypoints.pop();\n          newWaypoints[newWaypoints.length - 1] = newSegmentEnd;\n        }\n      }\n\n      // last bendpoint, remove last segment if intersecting\n      else {\n        if (targetToSegmentOrientation !== 'intersect') {\n          newWaypoints.push(segmentEnd);\n        }\n      }\n    }\n\n    // update connection waypoints\n    context.newWaypoints = connection.waypoints = cropConnection(connection, newWaypoints);\n\n    // update dragger position\n    updateDragger(context, segmentOffset, e);\n\n    // save segmentOffset in context\n    context.newSegmentStartIndex = segmentStartIndex + segmentOffset;\n\n    // redraw connection\n    redrawConnection(e);\n  });\n\n  eventBus.on('connectionSegment.move.hover', function(e) {\n\n    e.context.hover = e.hover;\n    canvas.addMarker(e.hover, ConnectionSegmentMove_MARKER_CONNECT_HOVER);\n  });\n\n  eventBus.on([\n    'connectionSegment.move.out',\n    'connectionSegment.move.cleanup'\n  ], function(e) {\n\n    // remove connect marker\n    // if it was added\n    var hover = e.context.hover;\n\n    if (hover) {\n      canvas.removeMarker(hover, ConnectionSegmentMove_MARKER_CONNECT_HOVER);\n    }\n  });\n\n  eventBus.on('connectionSegment.move.cleanup', function(e) {\n\n    var context = e.context,\n        connection = context.connection;\n\n    // remove dragger gfx\n    if (context.draggerGfx) {\n      (0,tiny_svg_dist_index_esm/* remove */.Od)(context.draggerGfx);\n    }\n\n    canvas.removeMarker(connection, ConnectionSegmentMove_MARKER_CONNECT_UPDATING);\n  });\n\n  eventBus.on([\n    'connectionSegment.move.cancel',\n    'connectionSegment.move.end'\n  ], function(e) {\n    var context = e.context,\n        connection = context.connection;\n\n    connection.waypoints = context.originalWaypoints;\n\n    redrawConnection(e);\n  });\n\n  eventBus.on('connectionSegment.move.end', function(e) {\n\n    var context = e.context,\n        connection = context.connection,\n        newWaypoints = context.newWaypoints,\n        newSegmentStartIndex = context.newSegmentStartIndex;\n\n    // ensure we have actual pixel values bendpoint\n    // coordinates (important when zoom level was > 1 during move)\n    newWaypoints = newWaypoints.map(function(p) {\n      return {\n        original: p.original,\n        x: Math.round(p.x),\n        y: Math.round(p.y)\n      };\n    });\n\n    // apply filter redunant waypoints\n    var filtered = filterRedundantWaypoints(newWaypoints, newSegmentStartIndex);\n\n    // get filtered waypoints\n    var filteredWaypoints = filtered.waypoints,\n        croppedWaypoints = cropConnection(connection, filteredWaypoints),\n        segmentOffset = filtered.segmentOffset;\n\n    var hints = {\n      segmentMove: {\n        segmentStartIndex: context.segmentStartIndex,\n        newSegmentStartIndex: newSegmentStartIndex + segmentOffset\n      }\n    };\n\n    modeling.updateWaypoints(connection, croppedWaypoints, hints);\n  });\n}\n\nConnectionSegmentMove.$inject = [\n  'injector',\n  'eventBus',\n  'canvas',\n  'dragging',\n  'graphicsFactory',\n  'modeling'\n];\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js\nvar SnapUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/BendpointSnapping.js\n\n\n\n\nvar abs= Math.abs,\n    BendpointSnapping_round = Math.round;\n\nvar TOLERANCE = 10;\n\n\nfunction BendpointSnapping(eventBus) {\n\n  function snapTo(values, value) {\n\n    if ((0,index_esm/* isArray */.kJ)(values)) {\n      var i = values.length;\n\n      while (i--) if (abs(values[i] - value) <= TOLERANCE) {\n        return values[i];\n      }\n    } else {\n      values = +values;\n      var rem = value % values;\n\n      if (rem < TOLERANCE) {\n        return value - rem;\n      }\n\n      if (rem > values - TOLERANCE) {\n        return value - rem + values;\n      }\n    }\n\n    return value;\n  }\n\n  function mid(element) {\n    if (element.width) {\n      return {\n        x: BendpointSnapping_round(element.width / 2 + element.x),\n        y: BendpointSnapping_round(element.height / 2 + element.y)\n      };\n    }\n  }\n\n  // connection segment snapping //////////////////////\n\n  function getConnectionSegmentSnaps(context) {\n\n    var snapPoints = context.snapPoints,\n        connection = context.connection,\n        waypoints = connection.waypoints,\n        segmentStart = context.segmentStart,\n        segmentStartIndex = context.segmentStartIndex,\n        segmentEnd = context.segmentEnd,\n        segmentEndIndex = context.segmentEndIndex,\n        axis = context.axis;\n\n    if (snapPoints) {\n      return snapPoints;\n    }\n\n    var referenceWaypoints = [\n      waypoints[segmentStartIndex - 1],\n      segmentStart,\n      segmentEnd,\n      waypoints[segmentEndIndex + 1]\n    ];\n\n    if (segmentStartIndex < 2) {\n      referenceWaypoints.unshift(mid(connection.source));\n    }\n\n    if (segmentEndIndex > waypoints.length - 3) {\n      referenceWaypoints.unshift(mid(connection.target));\n    }\n\n    context.snapPoints = snapPoints = { horizontal: [] , vertical: [] };\n\n    (0,index_esm/* forEach */.Ed)(referenceWaypoints, function(p) {\n      // we snap on existing bendpoints only,\n      // not placeholders that are inserted during add\n      if (p) {\n        p = p.original || p;\n\n        if (axis === 'y') {\n          snapPoints.horizontal.push(p.y);\n        }\n\n        if (axis === 'x') {\n          snapPoints.vertical.push(p.x);\n        }\n      }\n    });\n\n    return snapPoints;\n  }\n\n  eventBus.on('connectionSegment.move.move', 1500, function(event) {\n    var context = event.context,\n        snapPoints = getConnectionSegmentSnaps(context),\n        x = event.x,\n        y = event.y,\n        sx, sy;\n\n    if (!snapPoints) {\n      return;\n    }\n\n    // snap\n    sx = snapTo(snapPoints.vertical, x);\n    sy = snapTo(snapPoints.horizontal, y);\n\n\n    // correction x/y\n    var cx = (x - sx),\n        cy = (y - sy);\n\n    // update delta\n    (0,index_esm/* assign */.f0)(event, {\n      dx: event.dx - cx,\n      dy: event.dy - cy,\n      x: sx,\n      y: sy\n    });\n\n    // only set snapped if actually snapped\n    if (cx || snapPoints.vertical.indexOf(x) !== -1) {\n      (0,SnapUtil.setSnapped)(event, 'x', sx);\n    }\n\n    if (cy || snapPoints.horizontal.indexOf(y) !== -1) {\n      (0,SnapUtil.setSnapped)(event, 'y', sy);\n    }\n  });\n\n\n  // bendpoint snapping //////////////////////\n\n  function getBendpointSnaps(context) {\n\n    var snapPoints = context.snapPoints,\n        waypoints = context.connection.waypoints,\n        bendpointIndex = context.bendpointIndex;\n\n    if (snapPoints) {\n      return snapPoints;\n    }\n\n    var referenceWaypoints = [ waypoints[bendpointIndex - 1], waypoints[bendpointIndex + 1] ];\n\n    context.snapPoints = snapPoints = { horizontal: [] , vertical: [] };\n\n    (0,index_esm/* forEach */.Ed)(referenceWaypoints, function(p) {\n      // we snap on existing bendpoints only,\n      // not placeholders that are inserted during add\n      if (p) {\n        p = p.original || p;\n\n        snapPoints.horizontal.push(p.y);\n        snapPoints.vertical.push(p.x);\n      }\n    });\n\n    return snapPoints;\n  }\n\n\n  eventBus.on([ 'bendpoint.move.move', 'bendpoint.move.end' ], 1500, function(event) {\n\n    var context = event.context,\n        snapPoints = getBendpointSnaps(context),\n        target = context.target,\n        targetMid = target && mid(target),\n        x = event.x,\n        y = event.y,\n        sx, sy;\n\n    if (!snapPoints) {\n      return;\n    }\n\n    // snap\n    sx = snapTo(targetMid ? snapPoints.vertical.concat([ targetMid.x ]) : snapPoints.vertical, x);\n    sy = snapTo(targetMid ? snapPoints.horizontal.concat([ targetMid.y ]) : snapPoints.horizontal, y);\n\n    // correction x/y\n    var cx = (x - sx),\n        cy = (y - sy);\n\n    // update delta\n    (0,index_esm/* assign */.f0)(event, {\n      dx: event.dx - cx,\n      dy: event.dy - cy,\n      x: event.x - cx,\n      y: event.y - cy\n    });\n\n    // only set snapped if actually snapped\n    if (cx || snapPoints.vertical.indexOf(x) !== -1) {\n      (0,SnapUtil.setSnapped)(event, 'x', sx);\n    }\n\n    if (cy || snapPoints.horizontal.indexOf(y) !== -1) {\n      (0,SnapUtil.setSnapped)(event, 'y', sy);\n    }\n  });\n}\n\n\nBendpointSnapping.$inject = [ 'eventBus' ];\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/index.js\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const bendpoints = ({\n  __depends__: [\n    dragging/* default */.Z,\n    rules/* default */.Z\n  ],\n  __init__: [ 'bendpoints', 'bendpointSnapping', 'bendpointMovePreview' ],\n  bendpoints: [ 'type', Bendpoints ],\n  bendpointMove: [ 'type', BendpointMove ],\n  bendpointMovePreview: [ 'type', BendpointMovePreview ],\n  connectionSegmentMove: [ 'type', ConnectionSegmentMove ],\n  bendpointSnapping: [ 'type', BendpointSnapping ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/bendpoints/index.js_+_6_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/change-support/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ change_support)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/change-support/ChangeSupport.js\n\n\n/**\n * Adds change support to the diagram, including\n *\n * <ul>\n *   <li>redrawing shapes and connections on change</li>\n * </ul>\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {ElementRegistry} elementRegistry\n * @param {GraphicsFactory} graphicsFactory\n */\nfunction ChangeSupport(\n    eventBus, canvas, elementRegistry,\n    graphicsFactory) {\n\n\n  // redraw shapes / connections on change\n\n  eventBus.on('element.changed', function(event) {\n\n    var element = event.element;\n\n    // element might have been deleted and replaced by new element with same ID\n    // thus check for parent of element except for root element\n    if (element.parent || element === canvas.getRootElement()) {\n      event.gfx = elementRegistry.getGraphics(element);\n    }\n\n    // shape + gfx may have been deleted\n    if (!event.gfx) {\n      return;\n    }\n\n    eventBus.fire((0,Elements/* getType */.oL)(element) + '.changed', event);\n  });\n\n  eventBus.on('elements.changed', function(event) {\n\n    var elements = event.elements;\n\n    elements.forEach(function(e) {\n      eventBus.fire('element.changed', { element: e });\n    });\n\n    graphicsFactory.updateContainments(elements);\n  });\n\n  eventBus.on('shape.changed', function(event) {\n    graphicsFactory.update('shape', event.element, event.gfx);\n  });\n\n  eventBus.on('connection.changed', function(event) {\n    graphicsFactory.update('connection', event.element, event.gfx);\n  });\n}\n\nChangeSupport.$inject = [\n  'eventBus',\n  'canvas',\n  'elementRegistry',\n  'graphicsFactory'\n];\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/change-support/index.js\n\n\n/* harmony default export */ const change_support = ({\n  __init__: [ 'changeSupport'],\n  changeSupport: [ 'type', ChangeSupport ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/change-support/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connect/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ connect)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js + 2 modules\nvar dragging = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connect/Connect.js\n\n\n\nfunction Connect(eventBus, dragging, modeling, rules) {\n\n  // rules\n\n  function canConnect(source, target) {\n    return rules.allowed('connection.create', {\n      source: source,\n      target: target\n    });\n  }\n\n\n  // event handlers\n\n  eventBus.on('connect.hover', function(event) {\n    var context = event.context,\n        source = context.source,\n        hover = event.hover,\n        canExecute;\n\n    canExecute = context.canExecute = canConnect(source, hover);\n\n    // simply ignore hover\n    if (canExecute === null) {\n      return;\n    }\n\n    context.target = hover;\n  });\n\n  eventBus.on([ 'connect.out', 'connect.cleanup' ], function(event) {\n    var context = event.context;\n\n    context.target = null;\n    context.canExecute = false;\n  });\n\n  eventBus.on('connect.end', function(event) {\n\n    var context = event.context,\n        source = context.source,\n        sourcePosition = context.sourcePosition,\n        target = context.target,\n        targetPosition = {\n          x: event.x,\n          y: event.y\n        },\n        canExecute = context.canExecute || canConnect(source, target);\n\n    if (!canExecute) {\n      return false;\n    }\n\n    var attrs = null,\n        hints = {\n          connectionStart: sourcePosition,\n          connectionEnd: targetPosition\n        };\n\n    if (typeof canExecute === 'object') {\n      attrs = canExecute;\n    }\n\n    modeling.connect(source, target, attrs, hints);\n  });\n\n\n  // API\n\n  /**\n   * Start connect operation.\n   *\n   * @param {DOMEvent} event\n   * @param {djs.model.Base} source\n   * @param {Point} [sourcePosition]\n   * @param {Boolean} [autoActivate=false]\n   */\n  this.start = function(event, source, sourcePosition, autoActivate) {\n\n    if (typeof sourcePosition !== 'object') {\n      autoActivate = sourcePosition;\n      sourcePosition = (0,LayoutUtil/* getMid */.wS)(source);\n    }\n\n    dragging.init(event, 'connect', {\n      autoActivate: autoActivate,\n      data: {\n        shape: source,\n        context: {\n          source: source,\n          sourcePosition: sourcePosition\n        }\n      }\n    });\n  };\n}\n\nConnect.$inject = [\n  'eventBus',\n  'dragging',\n  'modeling',\n  'rules'\n];\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connect/ConnectPreview.js\nvar HIGH_PRIORITY = 1100,\n    LOW_PRIORITY = 900;\n\nvar MARKER_OK = 'connect-ok',\n    MARKER_NOT_OK = 'connect-not-ok';\n\n/**\n * Shows connection preview during connect.\n *\n * @param {didi.Injector} injector\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction ConnectPreview(injector, eventBus, canvas) {\n  var connectionPreview = injector.get('connectionPreview', false);\n\n  eventBus.on('connect.move', function(event) {\n    var context = event.context,\n        source = context.source,\n        target = context.target,\n        canConnect = context.canExecute;\n\n    var endPosition = {\n      x: event.x,\n      y: event.y\n    };\n\n\n    if (connectionPreview) {\n      connectionPreview.drawPreview(context, canConnect, {\n        source: source,\n        target: target,\n        connectionEnd: endPosition\n      });\n    }\n  });\n\n  eventBus.on('connect.hover', LOW_PRIORITY, function(event) {\n    var context = event.context,\n        hover = event.hover,\n        canExecute = context.canExecute;\n\n    // ignore hover\n    if (canExecute === null) {\n      return;\n    }\n\n    canvas.addMarker(hover, canExecute ? MARKER_OK : MARKER_NOT_OK);\n  });\n\n  eventBus.on([ 'connect.out', 'connect.cleanup' ], HIGH_PRIORITY, function(event) {\n    var context = event.context;\n\n    // remove marker before target is removed from context\n    if (context.target) {\n      canvas.removeMarker(context.target, context.canExecute ? MARKER_OK : MARKER_NOT_OK);\n    }\n  });\n\n  eventBus.on('connect.cleanup', function(event) {\n    if (connectionPreview) {\n      connectionPreview.cleanUp(event.context);\n    }\n  });\n}\n\nConnectPreview.$inject = [\n  'injector',\n  'eventBus',\n  'canvas'\n];\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connect/index.js\n\n\n\n\n\n\n\n/* harmony default export */ const connect = ({\n  __depends__: [\n    selection/* default */.Z,\n    rules/* default */.Z,\n    dragging/* default */.Z\n  ],\n  __init__: [\n    'connectPreview'\n  ],\n  connect: [ 'type', Connect ],\n  connectPreview: [ 'type', ConnectPreview ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connect/index.js_+_2_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connection-preview/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ connection_preview)\n});\n\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connection-preview/ConnectionPreview.js\n\n\n\n\n\n\n\nvar MARKER_CONNECTION_PREVIEW = 'djs-connection-preview';\n\n/**\n * Draws connection preview. Optionally, this can use layouter and connection docking to draw\n * better looking previews.\n *\n * @param {didi.Injector} injector\n * @param {Canvas} canvas\n * @param {GraphicsFactory} graphicsFactory\n * @param {ElementFactory} elementFactory\n */\nfunction ConnectionPreview(\n    injector,\n    canvas,\n    graphicsFactory,\n    elementFactory\n) {\n  this._canvas = canvas;\n  this._graphicsFactory = graphicsFactory;\n  this._elementFactory = elementFactory;\n\n  // optional components\n  this._connectionDocking = injector.get('connectionDocking', false);\n  this._layouter = injector.get('layouter', false);\n}\n\nConnectionPreview.$inject = [\n  'injector',\n  'canvas',\n  'graphicsFactory',\n  'elementFactory'\n];\n\n/**\n * Draw connection preview.\n *\n * Provide at least one of <source, connectionStart> and <target, connectionEnd> to create a preview.\n * In the clean up stage, call `connectionPreview#cleanUp` with the context to remove preview.\n *\n * @param {Object} context\n * @param {Object|boolean} canConnect\n * @param {Object} hints\n * @param {djs.model.shape} [hints.source] source element\n * @param {djs.model.shape} [hints.target] target element\n * @param {Point} [hints.connectionStart] connection preview start\n * @param {Point} [hints.connectionEnd] connection preview end\n * @param {Array<Point>} [hints.waypoints] provided waypoints for preview\n * @param {boolean} [hints.noLayout] true if preview should not be laid out\n * @param {boolean} [hints.noCropping] true if preview should not be cropped\n * @param {boolean} [hints.noNoop] true if simple connection should not be drawn\n */\nConnectionPreview.prototype.drawPreview = function(context, canConnect, hints) {\n\n  hints = hints || {};\n\n  var connectionPreviewGfx = context.connectionPreviewGfx,\n      getConnection = context.getConnection,\n      source = hints.source,\n      target = hints.target,\n      waypoints = hints.waypoints,\n      connectionStart = hints.connectionStart,\n      connectionEnd = hints.connectionEnd,\n      noLayout = hints.noLayout,\n      noCropping = hints.noCropping,\n      noNoop = hints.noNoop,\n      connection;\n\n  var self = this;\n\n  if (!connectionPreviewGfx) {\n    connectionPreviewGfx = context.connectionPreviewGfx = this.createConnectionPreviewGfx();\n  }\n\n  (0,index_esm/* clear */.ZH)(connectionPreviewGfx);\n\n  if (!getConnection) {\n    getConnection = context.getConnection = cacheReturnValues(function(canConnect, source, target) {\n      return self.getConnection(canConnect, source, target);\n    });\n  }\n\n  if (canConnect) {\n    connection = getConnection(canConnect, source, target);\n  }\n\n  if (!connection) {\n    !noNoop && this.drawNoopPreview(connectionPreviewGfx, hints);\n    return;\n  }\n\n  connection.waypoints = waypoints || [];\n\n  // optional layout\n  if (this._layouter && !noLayout) {\n    connection.waypoints = this._layouter.layoutConnection(connection, {\n      source: source,\n      target: target,\n      connectionStart: connectionStart,\n      connectionEnd: connectionEnd\n    });\n  }\n\n  // fallback if no waypoints were provided nor created with layouter\n  if (!connection.waypoints || !connection.waypoints.length) {\n    connection.waypoints = [\n      source ? (0,LayoutUtil/* getMid */.wS)(source) : connectionStart,\n      target ? (0,LayoutUtil/* getMid */.wS)(target) : connectionEnd\n    ];\n  }\n\n  // optional cropping\n  if (this._connectionDocking && (source || target) && !noCropping) {\n    connection.waypoints = this._connectionDocking.getCroppedWaypoints(connection, source, target);\n  }\n\n  this._graphicsFactory.drawConnection(connectionPreviewGfx, connection);\n};\n\n/**\n * Draw simple connection between source and target or provided points.\n *\n * @param {SVGElement} connectionPreviewGfx container for the connection\n * @param {Object} hints\n * @param {djs.model.shape} [hints.source] source element\n * @param {djs.model.shape} [hints.target] target element\n * @param {Point} [hints.connectionStart] required if source is not provided\n * @param {Point} [hints.connectionEnd] required if target is not provided\n */\nConnectionPreview.prototype.drawNoopPreview = function(connectionPreviewGfx, hints) {\n  var source = hints.source,\n      target = hints.target,\n      start = hints.connectionStart || (0,LayoutUtil/* getMid */.wS)(source),\n      end = hints.connectionEnd || (0,LayoutUtil/* getMid */.wS)(target);\n\n  var waypoints = this.cropWaypoints(start, end, source, target);\n\n  var connection = this.createNoopConnection(waypoints[0], waypoints[1]);\n\n  (0,index_esm/* append */.R3)(connectionPreviewGfx, connection);\n};\n\n/**\n * Return cropped waypoints.\n *\n * @param {Point} start\n * @param {Point} end\n * @param {djs.model.shape} source\n * @param {djs.model.shape} target\n *\n * @returns {Array}\n */\nConnectionPreview.prototype.cropWaypoints = function(start, end, source, target) {\n  var graphicsFactory = this._graphicsFactory,\n      sourcePath = source && graphicsFactory.getShapePath(source),\n      targetPath = target && graphicsFactory.getShapePath(target),\n      connectionPath = graphicsFactory.getConnectionPath({ waypoints: [ start, end ] });\n\n  start = (source && (0,LayoutUtil/* getElementLineIntersection */.Hz)(sourcePath, connectionPath, true)) || start;\n  end = (target && (0,LayoutUtil/* getElementLineIntersection */.Hz)(targetPath, connectionPath, false)) || end;\n\n  return [ start, end ];\n};\n\n/**\n * Remove connection preview container if it exists.\n *\n * @param {Object} [context]\n * @param {SVGElement} [context.connectionPreviewGfx] preview container\n */\nConnectionPreview.prototype.cleanUp = function(context) {\n  if (context && context.connectionPreviewGfx) {\n    (0,index_esm/* remove */.Od)(context.connectionPreviewGfx);\n  }\n};\n\n/**\n * Get connection that connects source and target.\n *\n * @param {Object|boolean} canConnect\n *\n * @returns {djs.model.connection}\n */\nConnectionPreview.prototype.getConnection = function(canConnect) {\n  var attrs = ensureConnectionAttrs(canConnect);\n\n  return this._elementFactory.createConnection(attrs);\n};\n\n\n/**\n * Add and return preview graphics.\n *\n * @returns {SVGElement}\n */\nConnectionPreview.prototype.createConnectionPreviewGfx = function() {\n  var gfx = (0,index_esm/* create */.Ue)('g');\n\n  (0,index_esm/* attr */.Lj)(gfx, {\n    pointerEvents: 'none'\n  });\n\n  (0,index_esm/* classes */.Sh)(gfx).add(MARKER_CONNECTION_PREVIEW);\n\n  (0,index_esm/* append */.R3)(this._canvas.getDefaultLayer(), gfx);\n\n  return gfx;\n};\n\n/**\n * Create and return simple connection.\n *\n * @param {Point} start\n * @param {Point} end\n *\n * @returns {SVGElement}\n */\nConnectionPreview.prototype.createNoopConnection = function(start, end) {\n  var connection = (0,index_esm/* create */.Ue)('polyline');\n\n  (0,index_esm/* attr */.Lj)(connection, {\n    'stroke': '#333',\n    'strokeDasharray': [ 1 ],\n    'strokeWidth': 2,\n    'pointer-events': 'none'\n  });\n\n  (0,index_esm/* attr */.Lj)(connection, { 'points': [ start.x, start.y, end.x, end.y ] });\n\n  return connection;\n};\n\n// helpers //////////\n\n/**\n * Returns function that returns cached return values referenced by stringified first argument.\n *\n * @param {Function} fn\n *\n * @return {Function}\n */\nfunction cacheReturnValues(fn) {\n  var returnValues = {};\n\n  /**\n   * Return cached return value referenced by stringified first argument.\n   *\n   * @returns {*}\n   */\n  return function(firstArgument) {\n    var key = JSON.stringify(firstArgument);\n\n    var returnValue = returnValues[key];\n\n    if (!returnValue) {\n      returnValue = returnValues[key] = fn.apply(null, arguments);\n    }\n\n    return returnValue;\n  };\n}\n\n/**\n * Ensure connection attributes is object.\n *\n * @param {Object|boolean} canConnect\n *\n * @returns {Object}\n */\nfunction ensureConnectionAttrs(canConnect) {\n  if ((0,dist_index_esm/* isObject */.Kn)(canConnect)) {\n    return canConnect;\n  } else {\n    return {};\n  }\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connection-preview/index.js\n\n\n/* harmony default export */ const connection_preview = ({\n  __init__: [ 'connectionPreview' ],\n  connectionPreview: [ 'type', ConnectionPreview ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connection-preview/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/context-pad/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ context_pad)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/overlays/index.js + 2 modules\nvar overlays = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/overlays/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/context-pad/ContextPad.js\n\n\n\n\nvar entrySelector = '.entry';\n\n\n/**\n * A context pad that displays element specific, contextual actions next\n * to a diagram element.\n *\n * @param {Object} config\n * @param {Boolean|Object} [config.scale={ min: 1.0, max: 1.5 }]\n * @param {Number} [config.scale.min]\n * @param {Number} [config.scale.max]\n * @param {EventBus} eventBus\n * @param {Overlays} overlays\n */\nfunction ContextPad(config, eventBus, overlays) {\n\n  this._providers = [];\n\n  this._eventBus = eventBus;\n  this._overlays = overlays;\n\n  var scale = (0,index_esm/* isDefined */.$K)(config && config.scale) ? config.scale : {\n    min: 1,\n    max: 1.5\n  };\n\n  this._overlaysConfig = {\n    position: {\n      right: -9,\n      top: -6\n    },\n    scale: scale\n  };\n\n  this._current = null;\n\n  this._init();\n}\n\nContextPad.$inject = [\n  'config.contextPad',\n  'eventBus',\n  'overlays'\n];\n\n\n/**\n * Registers events needed for interaction with other components\n */\nContextPad.prototype._init = function() {\n\n  var eventBus = this._eventBus;\n\n  var self = this;\n\n  eventBus.on('selection.changed', function(e) {\n\n    var selection = e.newSelection;\n\n    if (selection.length === 1) {\n      self.open(selection[0]);\n    } else {\n      self.close();\n    }\n  });\n\n  eventBus.on('elements.delete', function(event) {\n    var elements = event.elements;\n\n    (0,index_esm/* forEach */.Ed)(elements, function(e) {\n      if (self.isOpen(e)) {\n        self.close();\n      }\n    });\n  });\n\n  eventBus.on('element.changed', function(event) {\n    var element = event.element,\n        current = self._current;\n\n    // force reopen if element for which we are currently opened changed\n    if (current && current.element === element) {\n      self.open(element, true);\n    }\n  });\n};\n\n\n/**\n * Register a provider with the context pad\n *\n * @param  {ContextPadProvider} provider\n */\nContextPad.prototype.registerProvider = function(provider) {\n  this._providers.push(provider);\n};\n\n\n/**\n * Returns the context pad entries for a given element\n *\n * @param {djs.element.Base} element\n *\n * @return {Array<ContextPadEntryDescriptor>} list of entries\n */\nContextPad.prototype.getEntries = function(element) {\n  var entries = {};\n\n  // loop through all providers and their entries.\n  // group entries by id so that overriding an entry is possible\n  (0,index_esm/* forEach */.Ed)(this._providers, function(provider) {\n    var e = provider.getContextPadEntries(element);\n\n    (0,index_esm/* forEach */.Ed)(e, function(entry, id) {\n      entries[id] = entry;\n    });\n  });\n\n  return entries;\n};\n\n\n/**\n * Trigger an action available on the opened context pad\n *\n * @param  {String} action\n * @param  {Event} event\n * @param  {Boolean} [autoActivate=false]\n */\nContextPad.prototype.trigger = function(action, event, autoActivate) {\n\n  var element = this._current.element,\n      entries = this._current.entries,\n      entry,\n      handler,\n      originalEvent,\n      button = event.delegateTarget || event.target;\n\n  if (!button) {\n    return event.preventDefault();\n  }\n\n  entry = entries[(0,dist_index_esm/* attr */.Lj)(button, 'data-action')];\n  handler = entry.action;\n\n  originalEvent = event.originalEvent || event;\n\n  // simple action (via callback function)\n  if ((0,index_esm/* isFunction */.mf)(handler)) {\n    if (action === 'click') {\n      return handler(originalEvent, element, autoActivate);\n    }\n  } else {\n    if (handler[action]) {\n      return handler[action](originalEvent, element, autoActivate);\n    }\n  }\n\n  // silence other actions\n  event.preventDefault();\n};\n\n\n/**\n * Open the context pad for the given element\n *\n * @param {djs.model.Base} element\n * @param {Boolean} force if true, force reopening the context pad\n */\nContextPad.prototype.open = function(element, force) {\n  if (!force && this.isOpen(element)) {\n    return;\n  }\n\n  this.close();\n  this._updateAndOpen(element);\n};\n\n\nContextPad.prototype._updateAndOpen = function(element) {\n\n  var entries = this.getEntries(element),\n      pad = this.getPad(element),\n      html = pad.html;\n\n  (0,index_esm/* forEach */.Ed)(entries, function(entry, id) {\n    var grouping = entry.group || 'default',\n        control = (0,dist_index_esm/* domify */.H6)(entry.html || '<div class=\"entry\" draggable=\"true\"></div>'),\n        container;\n\n    (0,dist_index_esm/* attr */.Lj)(control, 'data-action', id);\n\n    container = (0,dist_index_esm/* query */.IO)('[data-group=' + grouping + ']', html);\n    if (!container) {\n      container = (0,dist_index_esm/* domify */.H6)('<div class=\"group\" data-group=\"' + grouping + '\"></div>');\n      html.appendChild(container);\n    }\n\n    container.appendChild(control);\n\n    if (entry.className) {\n      addClasses(control, entry.className);\n    }\n\n    if (entry.title) {\n      (0,dist_index_esm/* attr */.Lj)(control, 'title', entry.title);\n    }\n\n    if (entry.imageUrl) {\n      control.appendChild((0,dist_index_esm/* domify */.H6)('<img src=\"' + entry.imageUrl + '\">'));\n    }\n  });\n\n  (0,dist_index_esm/* classes */.Sh)(html).add('open');\n\n  this._current = {\n    element: element,\n    pad: pad,\n    entries: entries\n  };\n\n  this._eventBus.fire('contextPad.open', { current: this._current });\n};\n\n\nContextPad.prototype.getPad = function(element) {\n  if (this.isOpen()) {\n    return this._current.pad;\n  }\n\n  var self = this;\n\n  var overlays = this._overlays;\n\n  var html = (0,dist_index_esm/* domify */.H6)('<div class=\"djs-context-pad\"></div>');\n\n  var overlaysConfig = (0,index_esm/* assign */.f0)({\n    html: html\n  }, this._overlaysConfig);\n\n  dist_index_esm/* delegate.bind */.cl.bind(html, entrySelector, 'click', function(event) {\n    self.trigger('click', event);\n  });\n\n  dist_index_esm/* delegate.bind */.cl.bind(html, entrySelector, 'dragstart', function(event) {\n    self.trigger('dragstart', event);\n  });\n\n  // stop propagation of mouse events\n  dist_index_esm/* event.bind */.B.bind(html, 'mousedown', function(event) {\n    event.stopPropagation();\n  });\n\n  this._overlayId = overlays.add(element, 'context-pad', overlaysConfig);\n\n  var pad = overlays.get(this._overlayId);\n\n  this._eventBus.fire('contextPad.create', { element: element, pad: pad });\n\n  return pad;\n};\n\n\n/**\n * Close the context pad\n */\nContextPad.prototype.close = function() {\n  if (!this.isOpen()) {\n    return;\n  }\n\n  this._overlays.remove(this._overlayId);\n\n  this._overlayId = null;\n\n  this._eventBus.fire('contextPad.close', { current: this._current });\n\n  this._current = null;\n};\n\n/**\n * Check if pad is open. If element is given, will check\n * if pad is opened with given element.\n *\n * @param {Element} element\n * @return {Boolean}\n */\nContextPad.prototype.isOpen = function(element) {\n  return !!this._current && (!element ? true : this._current.element === element);\n};\n\n\n\n\n// helpers //////////////////////\n\nfunction addClasses(element, classNames) {\n\n  var classes = (0,dist_index_esm/* classes */.Sh)(element);\n\n  var actualClassNames = (0,index_esm/* isArray */.kJ)(classNames) ? classNames : classNames.split(/\\s+/g);\n  actualClassNames.forEach(function(cls) {\n    classes.add(cls);\n  });\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/context-pad/index.js\n\n\n\n\n\n\n/* harmony default export */ const context_pad = ({\n  __depends__: [\n    interaction_events/* default */.Z,\n    overlays/* default */.Z\n  ],\n  contextPad: [ 'type', ContextPad ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/context-pad/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/create/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ create)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js + 2 modules\nvar dragging = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/model/index.js\nvar model = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/model/index.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/create/Create.js\nvar LOW_PRIORITY = 750;\n\nvar MARKER_OK = 'drop-ok',\n    MARKER_NOT_OK = 'drop-not-ok',\n    MARKER_ATTACH = 'attach-ok',\n    MARKER_NEW_PARENT = 'new-parent';\n\n\n\n\n\n\n\n\n\n\n/**\n * Adds the ability to create new shapes via drag and drop.\n *\n * Create must be activated via {@link Create#start}. From that\n * point on, create will invoke `shape.create` and `shape.attach`\n * rules to query whether or not creation or attachment on a certain\n * position is allowed.\n *\n * If create or attach is allowed and a source is given, Create it\n * will invoke `connection.create` rules to query whether a connection\n * can be drawn between source and new shape. During rule evaluation\n * the target is not attached yet, however\n *\n *   hints = { targetParent, targetAttach }\n *\n * are passed to the evaluating rules.\n *\n *\n * ## Rule Return Values\n *\n * Return values interpreted from  `shape.create`:\n *\n *   * `true`: create is allowed\n *   * `false`: create is disallowed\n *   * `null`: create is not allowed but should be ignored visually\n *\n * Return values interpreted from `shape.attach`:\n *\n *   * `true`: attach is allowed\n *   * `Any`: attach is allowed with the constraints\n *   * `false`: attach is disallowed\n *\n * Return values interpreted from `connection.create`:\n *\n *   * `true`: connection can be created\n *   * `Any`: connection with the given attributes can be created\n *   * `false`: connection can't be created\n *\n *\n * @param {EventBus} eventBus\n * @param {Dragging} dragging\n * @param {Rules} rules\n * @param {Modeling} modeling\n * @param {Canvas} canvas\n * @param {Styles} styles\n * @param {GraphicsFactory} graphicsFactory\n */\nfunction Create(\n    eventBus, dragging, rules, modeling,\n    canvas, styles, graphicsFactory) {\n\n  // rules\n\n  function canCreate(shape, target, source, position) {\n\n    if (!target) {\n      return false;\n    }\n\n    var ctx = {\n      source: source,\n      shape: shape,\n      target: target,\n      position: position\n    };\n\n    var create,\n        attach,\n        connect;\n\n    attach = rules.allowed('shape.attach', ctx);\n\n    if (!attach) {\n      create = rules.allowed('shape.create', ctx);\n    }\n\n    if (create || attach) {\n\n      connect = source && rules.allowed('connection.create', {\n        source: source,\n        target: shape,\n        hints: {\n          targetParent: target,\n          targetAttach: attach\n        }\n      });\n\n      return {\n        attach: attach,\n        connect: connect\n      };\n    }\n\n    // allow to ignore visually\n    if (create === null || attach === null) {\n      return null;\n    }\n\n    return false;\n  }\n\n\n  /** set drop marker on an element */\n  function setMarker(element, marker) {\n\n    [ MARKER_ATTACH, MARKER_OK, MARKER_NOT_OK, MARKER_NEW_PARENT ].forEach(function(m) {\n\n      if (m === marker) {\n        canvas.addMarker(element, m);\n      } else {\n        canvas.removeMarker(element, m);\n      }\n    });\n  }\n\n\n  // visual helpers\n\n  function createVisual(shape) {\n    var group, preview, visual;\n\n    group = (0,index_esm/* create */.Ue)('g');\n    (0,index_esm/* attr */.Lj)(group, styles.cls('djs-drag-group', [ 'no-events' ]));\n\n    (0,index_esm/* append */.R3)(canvas.getDefaultLayer(), group);\n\n    preview = (0,index_esm/* create */.Ue)('g');\n    (0,index_esm/* classes */.Sh)(preview).add('djs-dragger');\n\n    (0,index_esm/* append */.R3)(group, preview);\n\n    (0,SvgTransformUtil/* translate */.Iu)(preview, shape.width / -2, shape.height / -2);\n\n    var visualGroup = (0,index_esm/* create */.Ue)('g');\n    (0,index_esm/* classes */.Sh)(visualGroup).add('djs-visual');\n\n    (0,index_esm/* append */.R3)(preview, visualGroup);\n\n    visual = visualGroup;\n\n    // hijack renderer to draw preview\n    graphicsFactory.drawShape(visual, shape);\n\n    return group;\n  }\n\n\n  // event handlers\n\n  eventBus.on('create.move', function(event) {\n    var context = event.context,\n        hover = event.hover,\n        shape = context.shape,\n        source = context.source,\n        canExecute;\n\n    ensureConstraints(event);\n\n    var position = {\n      x: event.x,\n      y: event.y\n    };\n\n    canExecute = context.canExecute = hover && canCreate(shape, hover, source, position);\n\n    // ignore hover visually if canExecute is null\n    if (hover && canExecute !== null) {\n      context.target = hover;\n\n      if (canExecute && canExecute.attach) {\n        setMarker(hover, MARKER_ATTACH);\n      } else {\n        setMarker(hover, canExecute ? MARKER_NEW_PARENT : MARKER_NOT_OK);\n      }\n    }\n  });\n\n  eventBus.on('create.move', LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        shape = context.shape,\n        visual = context.visual;\n\n    // lazy init drag visual once we received the first real\n    // drag move event (this allows us to get the proper canvas local coordinates)\n    if (!visual) {\n      visual = context.visual = createVisual(shape);\n    }\n\n    (0,SvgTransformUtil/* translate */.Iu)(visual, event.x, event.y);\n  });\n\n\n  eventBus.on([ 'create.end', 'create.out', 'create.cleanup' ], function(event) {\n    var context = event.context,\n        target = context.target;\n\n    if (target) {\n      setMarker(target, null);\n    }\n  });\n\n  eventBus.on('create.end', function(event) {\n    var context = event.context,\n        source = context.source,\n        hints = context.hints,\n        shape = context.shape,\n        target = context.target,\n        canExecute = context.canExecute,\n        attach = canExecute && canExecute.attach,\n        connect = canExecute && canExecute.connect;\n\n    if (canExecute === false || !target) {\n      return false;\n    }\n\n    ensureConstraints(event);\n\n    var position = {\n      x: event.x,\n      y: event.y\n    };\n\n    if (connect) {\n      // invoke append if connect is set via rules\n      shape = modeling.appendShape(source, shape, position, target, {\n        attach: attach,\n        connection: connect === true ? {} : connect\n      });\n    } else {\n      // invoke create, if connect is not set\n      shape = modeling.createShape(shape, position, target, (0,dist_index_esm/* assign */.f0)(\n        {},\n        hints, {\n          attach: attach\n        }\n      ));\n    }\n\n    // make sure we provide the actual attached\n    // shape with the context so that selection and\n    // other components can use it right after the create\n    // operation ends\n    context.shape = shape;\n  });\n\n\n  eventBus.on('create.cleanup', function(event) {\n    var context = event.context;\n\n    if (context.visual) {\n      (0,index_esm/* remove */.Od)(context.visual);\n    }\n  });\n\n  // API\n\n  this.start = function(event, shape, sourceOrContext) {\n    var context;\n\n    if (!sourceOrContext || sourceOrContext instanceof model.Shape) {\n      context = {\n        hints: {},\n        shape: shape,\n        source: sourceOrContext\n      };\n    } else {\n      context = (0,dist_index_esm/* assign */.f0)({\n        hints: {},\n        shape: shape\n      }, sourceOrContext);\n    }\n\n    dragging.init(event, 'create', {\n      cursor: 'grabbing',\n      autoActivate: true,\n      data: {\n        shape: shape,\n        context: context\n      }\n    });\n  };\n}\n\nCreate.$inject = [\n  'eventBus',\n  'dragging',\n  'rules',\n  'modeling',\n  'canvas',\n  'styles',\n  'graphicsFactory'\n];\n\n// helpers //////////\n\nfunction ensureConstraints(event) {\n  var context = event.context,\n      createConstraints = context.createConstraints;\n\n  if (!createConstraints) {\n    return;\n  }\n\n  if (createConstraints.left) {\n    event.x = Math.max(event.x, createConstraints.left);\n  }\n\n  if (createConstraints.right) {\n    event.x = Math.min(event.x, createConstraints.right);\n  }\n\n  if (createConstraints.top) {\n    event.y = Math.max(event.y, createConstraints.top);\n  }\n\n  if (createConstraints.bottom) {\n    event.y = Math.min(event.y, createConstraints.bottom);\n  }\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/create/index.js\n\n\n\n\n\n\n\n/* harmony default export */ const create = ({\n  __depends__: [\n    dragging/* default */.Z,\n    selection/* default */.Z,\n    rules/* default */.Z\n  ],\n  create: [ 'type', Create ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/create/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ dragging)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Cursor.js\nvar Cursor = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Cursor.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/ClickTrap.js\nvar ClickTrap = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/ClickTrap.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/PositionUtil.js\nvar PositionUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/PositionUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/Dragging.js\n/* global TouchEvent */\n\nvar round = Math.round;\n\n\n\n\n\n\n\n\n\n\n\n\n\nvar DRAG_ACTIVE_CLS = 'djs-drag-active';\n\n\nfunction preventDefault(event) {\n  event.preventDefault();\n}\n\nfunction isTouchEvent(event) {\n  // check for TouchEvent being available first\n  // (i.e. not available on desktop Firefox)\n  return typeof TouchEvent !== 'undefined' && event instanceof TouchEvent;\n}\n\nfunction getLength(point) {\n  return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));\n}\n\n/**\n * A helper that fires canvas localized drag events and realizes\n * the general \"drag-and-drop\" look and feel.\n *\n * Calling {@link Dragging#activate} activates dragging on a canvas.\n *\n * It provides the following:\n *\n *   * emits life cycle events, namespaced with a prefix assigned\n *     during dragging activation\n *   * sets and restores the cursor\n *   * sets and restores the selection\n *   * ensures there can be only one drag operation active at a time\n *\n * Dragging may be canceled manually by calling {@link Dragging#cancel}\n * or by pressing ESC.\n *\n *\n * ## Life-cycle events\n *\n * Dragging can be in three different states, off, initialized\n * and active.\n *\n * (1) off: no dragging operation is in progress\n * (2) initialized: a new drag operation got initialized but not yet\n *                  started (i.e. because of no initial move)\n * (3) started: dragging is in progress\n *\n * Eventually dragging will be off again after a drag operation has\n * been ended or canceled via user click or ESC key press.\n *\n * To indicate transitions between these states dragging emits generic\n * life-cycle events with the `drag.` prefix _and_ events namespaced\n * to a prefix choosen by a user during drag initialization.\n *\n * The following events are emitted (appropriately prefixed) via\n * the {@link EventBus}.\n *\n * * `init`\n * * `start`\n * * `move`\n * * `end`\n * * `ended` (dragging already in off state)\n * * `cancel` (only if previously started)\n * * `canceled` (dragging already in off state, only if previously started)\n * * `cleanup`\n *\n *\n * @example\n *\n * function MyDragComponent(eventBus, dragging) {\n *\n *   eventBus.on('mydrag.start', function(event) {\n *     console.log('yes, we start dragging');\n *   });\n *\n *   eventBus.on('mydrag.move', function(event) {\n *     console.log('canvas local coordinates', event.x, event.y, event.dx, event.dy);\n *\n *     // local drag data is passed with the event\n *     event.context.foo; // \"BAR\"\n *\n *     // the original mouse event, too\n *     event.originalEvent; // MouseEvent(...)\n *   });\n *\n *   eventBus.on('element.click', function(event) {\n *     dragging.init(event, 'mydrag', {\n *       cursor: 'grabbing',\n *       data: {\n *         context: {\n *           foo: \"BAR\"\n *         }\n *       }\n *     });\n *   });\n * }\n */\nfunction Dragging(eventBus, canvas, selection) {\n\n  var defaultOptions = {\n    threshold: 5,\n    trapClick: true\n  };\n\n  // the currently active drag operation\n  // dragging is active as soon as this context exists.\n  //\n  // it is visually _active_ only when a context.active flag is set to true.\n  var context;\n\n  /* convert a global event into local coordinates */\n  function toLocalPoint(globalPosition) {\n\n    var viewbox = canvas.viewbox();\n\n    var clientRect = canvas._container.getBoundingClientRect();\n\n    return {\n      x: viewbox.x + (globalPosition.x - clientRect.left) / viewbox.scale,\n      y: viewbox.y + (globalPosition.y - clientRect.top) / viewbox.scale\n    };\n  }\n\n  // helpers\n\n  function fire(type, dragContext) {\n    dragContext = dragContext || context;\n\n    var event = eventBus.createEvent(\n      (0,index_esm/* assign */.f0)(\n        {},\n        dragContext.payload,\n        dragContext.data,\n        { isTouch: dragContext.isTouch }\n      )\n    );\n\n    // default integration\n    if (eventBus.fire('drag.' + type, event) === false) {\n      return false;\n    }\n\n    return eventBus.fire(dragContext.prefix + '.' + type, event);\n  }\n\n  // event listeners\n\n  function move(event, activate) {\n    var payload = context.payload,\n        displacement = context.displacement;\n\n    var globalStart = context.globalStart,\n        globalCurrent = (0,Event/* toPoint */.jt)(event),\n        globalDelta = (0,PositionUtil/* delta */.p)(globalCurrent, globalStart);\n\n    var localStart = context.localStart,\n        localCurrent = toLocalPoint(globalCurrent),\n        localDelta = (0,PositionUtil/* delta */.p)(localCurrent, localStart);\n\n\n    // activate context explicitly or once threshold is reached\n    if (!context.active && (activate || getLength(globalDelta) > context.threshold)) {\n\n      // fire start event with original\n      // starting coordinates\n\n      (0,index_esm/* assign */.f0)(payload, {\n        x: round(localStart.x + displacement.x),\n        y: round(localStart.y + displacement.y),\n        dx: 0,\n        dy: 0\n      }, { originalEvent: event });\n\n      if (false === fire('start')) {\n        return cancel();\n      }\n\n      context.active = true;\n\n      // unset selection and remember old selection\n      // the previous (old) selection will always passed\n      // with the event via the event.previousSelection property\n      if (!context.keepSelection) {\n        payload.previousSelection = selection.get();\n        selection.select(null);\n      }\n\n      // allow custom cursor\n      if (context.cursor) {\n        (0,Cursor/* set */.t8)(context.cursor);\n      }\n\n      // indicate dragging via marker on root element\n      canvas.addMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS);\n    }\n\n    (0,Event/* stopPropagation */.UW)(event);\n\n    if (context.active) {\n\n      // update payload with actual coordinates\n      (0,index_esm/* assign */.f0)(payload, {\n        x: round(localCurrent.x + displacement.x),\n        y: round(localCurrent.y + displacement.y),\n        dx: round(localDelta.x),\n        dy: round(localDelta.y)\n      }, { originalEvent: event });\n\n      // emit move event\n      fire('move');\n    }\n  }\n\n  function end(event) {\n    var previousContext,\n        returnValue = true;\n\n    if (context.active) {\n\n      if (event) {\n        context.payload.originalEvent = event;\n\n        // suppress original event (click, ...)\n        // because we just ended a drag operation\n        (0,Event/* stopPropagation */.UW)(event);\n      }\n\n      // implementations may stop restoring the\n      // original state (selections, ...) by preventing the\n      // end events default action\n      returnValue = fire('end');\n    }\n\n    if (returnValue === false) {\n      fire('rejected');\n    }\n\n    previousContext = cleanup(returnValue !== true);\n\n    // last event to be fired when all drag operations are done\n    // at this point in time no drag operation is in progress anymore\n    fire('ended', previousContext);\n  }\n\n\n  // cancel active drag operation if the user presses\n  // the ESC key on the keyboard\n\n  function checkCancel(event) {\n\n    if (event.which === 27) {\n      preventDefault(event);\n\n      cancel();\n    }\n  }\n\n\n  // prevent ghost click that might occur after a finished\n  // drag and drop session\n\n  function trapClickAndEnd(event) {\n\n    var untrap;\n\n    // trap the click in case we are part of an active\n    // drag operation. This will effectively prevent\n    // the ghost click that cannot be canceled otherwise.\n    if (context.active) {\n\n      untrap = (0,ClickTrap/* install */.N)(eventBus);\n\n      // remove trap after minimal delay\n      setTimeout(untrap, 400);\n\n      // prevent default action (click)\n      preventDefault(event);\n    }\n\n    end(event);\n  }\n\n  function trapTouch(event) {\n    move(event);\n  }\n\n  // update the drag events hover (djs.model.Base) and hoverGfx (Snap<SVGElement>)\n  // properties during hover and out and fire {prefix}.hover and {prefix}.out properties\n  // respectively\n\n  function hover(event) {\n    var payload = context.payload;\n\n    payload.hoverGfx = event.gfx;\n    payload.hover = event.element;\n\n    fire('hover');\n  }\n\n  function out(event) {\n    fire('out');\n\n    var payload = context.payload;\n\n    payload.hoverGfx = null;\n    payload.hover = null;\n  }\n\n\n  // life-cycle methods\n\n  function cancel(restore) {\n    var previousContext;\n\n    if (!context) {\n      return;\n    }\n\n    var wasActive = context.active;\n\n    if (wasActive) {\n      fire('cancel');\n    }\n\n    previousContext = cleanup(restore);\n\n    if (wasActive) {\n      // last event to be fired when all drag operations are done\n      // at this point in time no drag operation is in progress anymore\n      fire('canceled', previousContext);\n    }\n  }\n\n  function cleanup(restore) {\n    var previousContext,\n        endDrag;\n\n    fire('cleanup');\n\n    // reset cursor\n    (0,Cursor/* unset */.zN)();\n\n    if (context.trapClick) {\n      endDrag = trapClickAndEnd;\n    } else {\n      endDrag = end;\n    }\n\n    // reset dom listeners\n    dist_index_esm/* event.unbind */.B.unbind(document, 'mousemove', move);\n\n    dist_index_esm/* event.unbind */.B.unbind(document, 'dragstart', preventDefault);\n    dist_index_esm/* event.unbind */.B.unbind(document, 'selectstart', preventDefault);\n\n    dist_index_esm/* event.unbind */.B.unbind(document, 'mousedown', endDrag, true);\n    dist_index_esm/* event.unbind */.B.unbind(document, 'mouseup', endDrag, true);\n\n    dist_index_esm/* event.unbind */.B.unbind(document, 'keyup', checkCancel);\n\n    dist_index_esm/* event.unbind */.B.unbind(document, 'touchstart', trapTouch, true);\n    dist_index_esm/* event.unbind */.B.unbind(document, 'touchcancel', cancel, true);\n    dist_index_esm/* event.unbind */.B.unbind(document, 'touchmove', move, true);\n    dist_index_esm/* event.unbind */.B.unbind(document, 'touchend', end, true);\n\n    eventBus.off('element.hover', hover);\n    eventBus.off('element.out', out);\n\n    // remove drag marker on root element\n    canvas.removeMarker(canvas.getRootElement(), DRAG_ACTIVE_CLS);\n\n    // restore selection, unless it has changed\n    var previousSelection = context.payload.previousSelection;\n\n    if (restore !== false && previousSelection && !selection.get().length) {\n      selection.select(previousSelection);\n    }\n\n    previousContext = context;\n\n    context = null;\n\n    return previousContext;\n  }\n\n  /**\n   * Initialize a drag operation.\n   *\n   * If `localPosition` is given, drag events will be emitted\n   * relative to it.\n   *\n   * @param {MouseEvent|TouchEvent} [event]\n   * @param {Point} [localPosition] actual diagram local position this drag operation should start at\n   * @param {String} prefix\n   * @param {Object} [options]\n   */\n  function init(event, relativeTo, prefix, options) {\n\n    // only one drag operation may be active, at a time\n    if (context) {\n      cancel(false);\n    }\n\n    if (typeof relativeTo === 'string') {\n      options = prefix;\n      prefix = relativeTo;\n      relativeTo = null;\n    }\n\n    options = (0,index_esm/* assign */.f0)({}, defaultOptions, options || {});\n\n    var data = options.data || {},\n        originalEvent,\n        globalStart,\n        localStart,\n        endDrag,\n        isTouch;\n\n    if (options.trapClick) {\n      endDrag = trapClickAndEnd;\n    } else {\n      endDrag = end;\n    }\n\n    if (event) {\n      originalEvent = (0,Event/* getOriginal */.Ku)(event) || event;\n      globalStart = (0,Event/* toPoint */.jt)(event);\n\n      (0,Event/* stopPropagation */.UW)(event);\n\n      // prevent default browser dragging behavior\n      if (originalEvent.type === 'dragstart') {\n        preventDefault(originalEvent);\n      }\n    } else {\n      originalEvent = null;\n      globalStart = { x: 0, y: 0 };\n    }\n\n    localStart = toLocalPoint(globalStart);\n\n    if (!relativeTo) {\n      relativeTo = localStart;\n    }\n\n    isTouch = isTouchEvent(originalEvent);\n\n    context = (0,index_esm/* assign */.f0)({\n      prefix: prefix,\n      data: data,\n      payload: {},\n      globalStart: globalStart,\n      displacement: (0,PositionUtil/* delta */.p)(relativeTo, localStart),\n      localStart: localStart,\n      isTouch: isTouch\n    }, options);\n\n    // skip dom registration if trigger\n    // is set to manual (during testing)\n    if (!options.manual) {\n\n      // add dom listeners\n\n      if (isTouch) {\n        dist_index_esm/* event.bind */.B.bind(document, 'touchstart', trapTouch, true);\n        dist_index_esm/* event.bind */.B.bind(document, 'touchcancel', cancel, true);\n        dist_index_esm/* event.bind */.B.bind(document, 'touchmove', move, true);\n        dist_index_esm/* event.bind */.B.bind(document, 'touchend', end, true);\n      } else {\n        // assume we use the mouse to interact per default\n        dist_index_esm/* event.bind */.B.bind(document, 'mousemove', move);\n\n        // prevent default browser drag and text selection behavior\n        dist_index_esm/* event.bind */.B.bind(document, 'dragstart', preventDefault);\n        dist_index_esm/* event.bind */.B.bind(document, 'selectstart', preventDefault);\n\n        dist_index_esm/* event.bind */.B.bind(document, 'mousedown', endDrag, true);\n        dist_index_esm/* event.bind */.B.bind(document, 'mouseup', endDrag, true);\n      }\n\n      dist_index_esm/* event.bind */.B.bind(document, 'keyup', checkCancel);\n\n      eventBus.on('element.hover', hover);\n      eventBus.on('element.out', out);\n    }\n\n    fire('init');\n\n    if (options.autoActivate) {\n      move(event, true);\n    }\n  }\n\n  // cancel on diagram destruction\n  eventBus.on('diagram.destroy', cancel);\n\n\n  // API\n\n  this.init = init;\n  this.move = move;\n  this.hover = hover;\n  this.out = out;\n  this.end = end;\n\n  this.cancel = cancel;\n\n  // for introspection\n\n  this.context = function() {\n    return context;\n  };\n\n  this.setOptions = function(options) {\n    (0,index_esm/* assign */.f0)(defaultOptions, options);\n  };\n}\n\nDragging.$inject = [\n  'eventBus',\n  'canvas',\n  'selection'\n];\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/HoverFix.js\n\n\n\n\nvar HIGH_PRIORITY = 1500;\n\n\n/**\n * Browsers may swallow certain events (hover, out ...) if users are to\n * fast with the mouse.\n *\n * @see http://stackoverflow.com/questions/7448468/why-cant-i-reliably-capture-a-mouseout-event\n *\n * The fix implemented in this component ensure that we\n *\n * 1) have a hover state after a successive drag.move event\n * 2) have an out event when dragging leaves an element\n *\n * @param {EventBus} eventBus\n * @param {Dragging} dragging\n * @param {ElementRegistry} elementRegistry\n */\nfunction HoverFix(eventBus, dragging, elementRegistry) {\n\n  var self = this;\n\n  /**\n   * We wait for a specific sequence of events before\n   * emitting a fake drag.hover event.\n   *\n   * Event Sequence:\n   *\n   * drag.start\n   * drag.move\n   * drag.move >> ensure we are hovering\n   */\n  eventBus.on('drag.start', function(event) {\n\n    eventBus.once('drag.move', function() {\n\n      eventBus.once('drag.move', function(event) {\n\n        self.ensureHover(event);\n      });\n    });\n\n  });\n\n\n  /**\n   * We make sure that drag.out is always fired, even if the\n   * browser swallows an element.out event.\n   *\n   * Event sequence:\n   *\n   * drag.hover\n   * (element.out >> sometimes swallowed)\n   * element.hover >> ensure we fired drag.out\n   */\n  eventBus.on('drag.init', function() {\n\n    var hover, hoverGfx;\n\n    function setDragHover(event) {\n      hover = event.hover;\n      hoverGfx = event.hoverGfx;\n    }\n\n    function unsetHover() {\n      hover = null;\n      hoverGfx = null;\n    }\n\n    function ensureOut() {\n\n      if (!hover) {\n        return;\n      }\n\n      var element = hover,\n          gfx = hoverGfx;\n\n      hover = null;\n      hoverGfx = null;\n\n      // emit synthetic out event\n      dragging.out({\n        element: element,\n        gfx: gfx\n      });\n    }\n\n    eventBus.on('drag.hover', setDragHover);\n    eventBus.on('element.out', unsetHover);\n    eventBus.on('element.hover', HIGH_PRIORITY, ensureOut);\n\n    eventBus.once('drag.cleanup', function() {\n      eventBus.off('drag.hover', setDragHover);\n      eventBus.off('element.out', unsetHover);\n      eventBus.off('element.hover', ensureOut);\n    });\n\n  });\n\n\n  /**\n   * Make sure we are god damn hovering!\n   *\n   * @param {Event} dragging event\n   */\n  this.ensureHover = function(event) {\n\n    if (event.hover) {\n      return;\n    }\n\n    var originalEvent = event.originalEvent,\n        position,\n        target,\n        element,\n        gfx;\n\n    if (!(originalEvent instanceof MouseEvent)) {\n      return;\n    }\n\n    position = (0,Event/* toPoint */.jt)(originalEvent);\n\n    // damn expensive operation, ouch!\n    target = document.elementFromPoint(position.x, position.y);\n\n    gfx = getGfx(target);\n\n    if (gfx) {\n      element = elementRegistry.get(gfx);\n\n      dragging.hover({ element: element, gfx: gfx });\n    }\n  };\n\n}\n\nHoverFix.$inject = [\n  'eventBus',\n  'dragging',\n  'elementRegistry'\n];\n\n\n// helpers /////////////////////\n\nfunction getGfx(target) {\n  return (0,dist_index_esm/* closest */.oq)(target, 'svg, .djs-element', true);\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\n\n\n\n\n\n/* harmony default export */ const dragging = ({\n  __init__: [\n    'hoverFix'\n  ],\n  __depends__: [\n    selection/* default */.Z\n  ],\n  dragging: [ 'type', Dragging ],\n  hoverFix: [ 'type', HoverFix ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js_+_2_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/editor-actions/EditorActions.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ EditorActions)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n\n\nvar NOT_REGISTERED_ERROR = 'is not a registered action',\n    IS_REGISTERED_ERROR = 'is already registered';\n\n\n/**\n * An interface that provides access to modeling actions by decoupling\n * the one who requests the action to be triggered and the trigger itself.\n *\n * It's possible to add new actions by registering them with ´registerAction´\n * and likewise unregister existing ones with ´unregisterAction´.\n *\n *\n * ## Life-Cycle and configuration\n *\n * The editor actions will wait for diagram initialization before\n * registering default actions _and_ firing an `editorActions.init` event.\n *\n * Interested parties may listen to the `editorActions.init` event with\n * low priority to check, which actions got registered. Other components\n * may use the event to register their own actions via `registerAction`.\n *\n * @param {EventBus} eventBus\n * @param {Injector} injector\n */\nfunction EditorActions(eventBus, injector) {\n\n  // initialize actions\n  this._actions = {};\n\n  var self = this;\n\n  eventBus.on('diagram.init', function() {\n\n    // all diagram modules got loaded; check which ones\n    // are available and register the respective default actions\n    self._registerDefaultActions(injector);\n\n    // ask interested parties to register available editor\n    // actions on diagram initialization\n    eventBus.fire('editorActions.init', {\n      editorActions: self\n    });\n  });\n\n}\n\nEditorActions.$inject = [\n  'eventBus',\n  'injector'\n];\n\n/**\n * Register default actions.\n *\n * @param {Injector} injector\n */\nEditorActions.prototype._registerDefaultActions = function(injector) {\n\n  // (1) retrieve optional components to integrate with\n\n  var commandStack = injector.get('commandStack', false);\n  var modeling = injector.get('modeling', false);\n  var selection = injector.get('selection', false);\n  var zoomScroll = injector.get('zoomScroll', false);\n  var copyPaste = injector.get('copyPaste', false);\n  var canvas = injector.get('canvas', false);\n  var rules = injector.get('rules', false);\n  var mouseTracking = injector.get('mouseTracking', false);\n  var keyboardMove = injector.get('keyboardMove', false);\n  var keyboardMoveSelection = injector.get('keyboardMoveSelection', false);\n\n  // (2) check components and register actions\n\n  if (commandStack) {\n    this.register('undo', function() {\n      commandStack.undo();\n    });\n\n    this.register('redo', function() {\n      commandStack.redo();\n    });\n  }\n\n  if (copyPaste && selection) {\n    this.register('copy', function() {\n      var selectedElements = selection.get();\n\n      copyPaste.copy(selectedElements);\n    });\n  }\n\n  if (mouseTracking && copyPaste) {\n    this.register('paste', function() {\n      var context = mouseTracking.getHoverContext();\n\n      copyPaste.paste(context);\n    });\n  }\n\n  if (zoomScroll) {\n    this.register('stepZoom', function(opts) {\n      zoomScroll.stepZoom(opts.value);\n    });\n  }\n\n  if (canvas) {\n    this.register('zoom', function(opts) {\n      canvas.zoom(opts.value);\n    });\n  }\n\n  if (modeling && selection && rules) {\n    this.register('removeSelection', function() {\n\n      var selectedElements = selection.get();\n\n      if (!selectedElements.length) {\n        return;\n      }\n\n      var allowed = rules.allowed('elements.delete', { elements: selectedElements }),\n          removableElements;\n\n      if (allowed === false) {\n        return;\n      }\n      else if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(allowed)) {\n        removableElements = allowed;\n      }\n      else {\n        removableElements = selectedElements;\n      }\n\n      if (removableElements.length) {\n        modeling.removeElements(removableElements.slice());\n      }\n    });\n  }\n\n  if (keyboardMove) {\n    this.register('moveCanvas', function(opts) {\n      keyboardMove.moveCanvas(opts);\n    });\n  }\n\n  if (keyboardMoveSelection) {\n    this.register('moveSelection', function(opts) {\n      keyboardMoveSelection.moveSelection(opts.direction, opts.accelerated);\n    });\n  }\n\n};\n\n\n/**\n * Triggers a registered action\n *\n * @param  {String} action\n * @param  {Object} opts\n *\n * @return {Unknown} Returns what the registered listener returns\n */\nEditorActions.prototype.trigger = function(action, opts) {\n  if (!this._actions[action]) {\n    throw error(action, NOT_REGISTERED_ERROR);\n  }\n\n  return this._actions[action](opts);\n};\n\n\n/**\n * Registers a collections of actions.\n * The key of the object will be the name of the action.\n *\n * @example\n * ´´´\n * var actions = {\n *   spaceTool: function() {\n *     spaceTool.activateSelection();\n *   },\n *   lassoTool: function() {\n *     lassoTool.activateSelection();\n *   }\n * ];\n *\n * editorActions.register(actions);\n *\n * editorActions.isRegistered('spaceTool'); // true\n * ´´´\n *\n * @param  {Object} actions\n */\nEditorActions.prototype.register = function(actions, listener) {\n  var self = this;\n\n  if (typeof actions === 'string') {\n    return this._registerAction(actions, listener);\n  }\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(actions, function(listener, action) {\n    self._registerAction(action, listener);\n  });\n};\n\n/**\n * Registers a listener to an action key\n *\n * @param  {String} action\n * @param  {Function} listener\n */\nEditorActions.prototype._registerAction = function(action, listener) {\n  if (this.isRegistered(action)) {\n    throw error(action, IS_REGISTERED_ERROR);\n  }\n\n  this._actions[action] = listener;\n};\n\n/**\n * Unregister an existing action\n *\n * @param {String} action\n */\nEditorActions.prototype.unregister = function(action) {\n  if (!this.isRegistered(action)) {\n    throw error(action, NOT_REGISTERED_ERROR);\n  }\n\n  this._actions[action] = undefined;\n};\n\n/**\n * Returns the number of actions that are currently registered\n *\n * @return {Number}\n */\nEditorActions.prototype.getActions = function() {\n  return Object.keys(this._actions);\n};\n\n/**\n * Checks wether the given action is registered\n *\n * @param {String} action\n *\n * @return {Boolean}\n */\nEditorActions.prototype.isRegistered = function(action) {\n  return !!this._actions[action];\n};\n\n\nfunction error(action, message) {\n  return new Error(action + ' ' + message);\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/editor-actions/EditorActions.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/editor-actions/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _EditorActions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/editor-actions/EditorActions.js");\n\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  __init__: [ \'editorActions\' ],\n  editorActions: [ \'type\', _EditorActions__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/editor-actions/index.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/global-connect/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ global_connect)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connect/index.js + 2 modules\nvar connect = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/connect/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js + 2 modules\nvar dragging = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js + 1 modules\nvar tool_manager = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/global-connect/GlobalConnect.js\nvar MARKER_OK = 'connect-ok',\n    MARKER_NOT_OK = 'connect-not-ok';\n\n/**\n * @class\n * @constructor\n *\n * @param {EventBus} eventBus\n * @param {Dragging} dragging\n * @param {Connect} connect\n * @param {Canvas} canvas\n * @param {ToolManager} toolManager\n * @param {Rules} rules\n */\nfunction GlobalConnect(\n    eventBus, dragging, connect,\n    canvas, toolManager, rules) {\n\n  var self = this;\n\n  this._dragging = dragging;\n  this._rules = rules;\n\n  toolManager.registerTool('global-connect', {\n    tool: 'global-connect',\n    dragging: 'global-connect.drag'\n  });\n\n  eventBus.on('global-connect.hover', function(event) {\n    var context = event.context,\n        startTarget = event.hover;\n\n    var canStartConnect = context.canStartConnect = self.canStartConnect(startTarget);\n\n    // simply ignore hover\n    if (canStartConnect === null) {\n      return;\n    }\n\n    context.startTarget = startTarget;\n\n    canvas.addMarker(startTarget, canStartConnect ? MARKER_OK : MARKER_NOT_OK);\n  });\n\n\n  eventBus.on([ 'global-connect.out', 'global-connect.cleanup' ], function(event) {\n    var startTarget = event.context.startTarget,\n        canStartConnect = event.context.canStartConnect;\n\n    if (startTarget) {\n      canvas.removeMarker(startTarget, canStartConnect ? MARKER_OK : MARKER_NOT_OK);\n    }\n  });\n\n\n  eventBus.on([ 'global-connect.ended' ], function(event) {\n    var context = event.context,\n        startTarget = context.startTarget,\n        startPosition = {\n          x: event.x,\n          y: event.y\n        };\n\n    var canStartConnect = self.canStartConnect(startTarget);\n\n    if (!canStartConnect) {\n      return;\n    }\n\n    eventBus.once('element.out', function() {\n      eventBus.once([ 'connect.ended', 'connect.canceled' ], function() {\n        eventBus.fire('global-connect.drag.ended');\n      });\n\n      connect.start(null, startTarget, startPosition);\n    });\n\n    return false;\n  });\n}\n\nGlobalConnect.$inject = [\n  'eventBus',\n  'dragging',\n  'connect',\n  'canvas',\n  'toolManager',\n  'rules'\n];\n\n/**\n * Initiates tool activity.\n */\nGlobalConnect.prototype.start = function(event) {\n  this._dragging.init(event, 'global-connect', {\n    trapClick: false,\n    data: {\n      context: {}\n    }\n  });\n};\n\nGlobalConnect.prototype.toggle = function() {\n  if (this.isActive()) {\n    this._dragging.cancel();\n  } else {\n    this.start();\n  }\n};\n\nGlobalConnect.prototype.isActive = function() {\n  var context = this._dragging.context();\n\n  return context && /^global-connect/.test(context.prefix);\n};\n\n/**\n * Check if source shape can initiate connection.\n *\n * @param  {Shape} startTarget\n * @return {Boolean}\n */\nGlobalConnect.prototype.canStartConnect = function(startTarget) {\n  return this._rules.allowed('connection.start', { source: startTarget });\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/global-connect/index.js\n\n\n\n\n\n\n\n/* harmony default export */ const global_connect = ({\n  __depends__: [\n    connect/* default */.Z,\n    rules/* default */.Z,\n    dragging/* default */.Z,\n    tool_manager/* default */.Z\n  ],\n  globalConnect: [ 'type', GlobalConnect ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/global-connect/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/hand-tool/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ hand_tool)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js + 1 modules\nvar tool_manager = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js + 1 modules\nvar Mouse = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/hand-tool/HandTool.js\n\n\n\n\nvar HIGH_PRIORITY = 1500;\nvar HAND_CURSOR = 'grab';\n\n\nfunction HandTool(eventBus, canvas, dragging, injector, toolManager) {\n  this._dragging = dragging;\n\n  var self = this,\n      keyboard = injector.get('keyboard', false);\n\n  toolManager.registerTool('hand', {\n    tool: 'hand',\n    dragging: 'hand.move'\n  });\n\n  eventBus.on('element.mousedown', HIGH_PRIORITY, function(event) {\n    if ((0,Mouse/* hasPrimaryModifier */.RJ)(event)) {\n      this.activateMove(event.originalEvent);\n\n      return false;\n    }\n  }, this);\n\n  keyboard && keyboard.addListener(HIGH_PRIORITY, function(e) {\n    if (!isSpace(e.keyEvent)) {\n      return;\n    }\n\n    if (self.isActive()) {\n      return;\n    }\n\n    function activateMove(event) {\n      self.activateMove(event);\n\n      window.removeEventListener('mousemove', activateMove);\n    }\n\n    window.addEventListener('mousemove', activateMove);\n\n    function deactivateMove(e) {\n      if (!isSpace(e.keyEvent)) {\n        return;\n      }\n\n      window.removeEventListener('mousemove', activateMove);\n\n      keyboard.removeListener(deactivateMove, 'keyboard.keyup');\n\n      dragging.cancel();\n    }\n\n    keyboard.addListener(HIGH_PRIORITY, deactivateMove, 'keyboard.keyup');\n  }, 'keyboard.keydown');\n\n  eventBus.on('hand.end', function(event) {\n    var target = event.originalEvent.target;\n\n    // only reactive on diagram click\n    // on some occasions, event.hover is not set and we have to check if the target is an svg\n    if (!event.hover && !(target instanceof SVGElement)) {\n      return false;\n    }\n\n    eventBus.once('hand.ended', function() {\n      this.activateMove(event.originalEvent, { reactivate: true });\n    }, this);\n\n  }, this);\n\n\n  eventBus.on('hand.move.move', function(event) {\n    var scale = canvas.viewbox().scale;\n\n    canvas.scroll({\n      dx: event.dx * scale,\n      dy: event.dy * scale\n    });\n  });\n\n  eventBus.on('hand.move.end', function(event) {\n    var context = event.context,\n        reactivate = context.reactivate;\n\n    // Don't reactivate if the user is using the keyboard keybinding\n    if (!(0,Mouse/* hasPrimaryModifier */.RJ)(event) && reactivate) {\n\n      eventBus.once('hand.move.ended', function(event) {\n        this.activateHand(event.originalEvent, true, true);\n      }, this);\n\n    }\n\n    return false;\n  }, this);\n\n}\n\nHandTool.$inject = [\n  'eventBus',\n  'canvas',\n  'dragging',\n  'injector',\n  'toolManager'\n];\n\n\nHandTool.prototype.activateMove = function(event, autoActivate, context) {\n  if (typeof autoActivate === 'object') {\n    context = autoActivate;\n    autoActivate = false;\n  }\n\n  this._dragging.init(event, 'hand.move', {\n    autoActivate: autoActivate,\n    cursor: HAND_CURSOR,\n    data: {\n      context: context || {}\n    }\n  });\n};\n\nHandTool.prototype.activateHand = function(event, autoActivate, reactivate) {\n  this._dragging.init(event, 'hand', {\n    trapClick: false,\n    autoActivate: autoActivate,\n    cursor: HAND_CURSOR,\n    data: {\n      context: {\n        reactivate: reactivate\n      }\n    }\n  });\n};\n\nHandTool.prototype.toggle = function() {\n  if (this.isActive()) {\n    this._dragging.cancel();\n  } else {\n    this.activateHand();\n  }\n};\n\nHandTool.prototype.isActive = function() {\n  var context = this._dragging.context();\n\n  if (context) {\n    return /^(hand|hand\\.move)$/.test(context.prefix);\n  }\n\n  return false;\n};\n\n// helpers //////////\n\nfunction isSpace(keyEvent) {\n  return (0,KeyboardUtil/* isKey */.ot)(' ', keyEvent);\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/hand-tool/index.js\n\n\n\n\n/* harmony default export */ const hand_tool = ({\n  __depends__: [\n    tool_manager/* default */.Z\n  ],\n  __init__: [ 'handTool' ],\n  handTool: [ 'type', HandTool ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/hand-tool/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ interaction_events)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js + 1 modules\nvar Mouse = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/RenderUtil.js\nvar RenderUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/RenderUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/InteractionEvents.js\n\n\n\n\n\n\n\n\n\n\nfunction allowAll(e) { return true; }\n\nvar LOW_PRIORITY = 500;\n\n/**\n * A plugin that provides interaction events for diagram elements.\n *\n * It emits the following events:\n *\n *   * element.hover\n *   * element.out\n *   * element.click\n *   * element.dblclick\n *   * element.mousedown\n *   * element.contextmenu\n *\n * Each event is a tuple { element, gfx, originalEvent }.\n *\n * Canceling the event via Event#preventDefault()\n * prevents the original DOM operation.\n *\n * @param {EventBus} eventBus\n */\nfunction InteractionEvents(eventBus, elementRegistry, styles) {\n\n  var HIT_STYLE = styles.cls('djs-hit', [ 'no-fill', 'no-border' ], {\n    stroke: 'white',\n    strokeWidth: 15\n  });\n\n  /**\n   * Fire an interaction event.\n   *\n   * @param {String} type local event name, e.g. element.click.\n   * @param {DOMEvent} event native event\n   * @param {djs.model.Base} [element] the diagram element to emit the event on;\n   *                                   defaults to the event target\n   */\n  function fire(type, event, element) {\n\n    if (isIgnored(type, event)) {\n      return;\n    }\n\n    var target, gfx, returnValue;\n\n    if (!element) {\n      target = event.delegateTarget || event.target;\n\n      if (target) {\n        gfx = target;\n        element = elementRegistry.get(gfx);\n      }\n    } else {\n      gfx = elementRegistry.getGraphics(element);\n    }\n\n    if (!gfx || !element) {\n      return;\n    }\n\n    returnValue = eventBus.fire(type, {\n      element: element,\n      gfx: gfx,\n      originalEvent: event\n    });\n\n    if (returnValue === false) {\n      event.stopPropagation();\n      event.preventDefault();\n    }\n  }\n\n  // TODO(nikku): document this\n  var handlers = {};\n\n  function mouseHandler(localEventName) {\n    return handlers[localEventName];\n  }\n\n  function isIgnored(localEventName, event) {\n\n    var filter = ignoredFilters[localEventName] || Mouse/* isPrimaryButton */.Id;\n\n    // only react on left mouse button interactions\n    // except for interaction events that are enabled\n    // for secundary mouse button\n    return !filter(event);\n  }\n\n  var bindings = {\n    mouseover: 'element.hover',\n    mouseout: 'element.out',\n    click: 'element.click',\n    dblclick: 'element.dblclick',\n    mousedown: 'element.mousedown',\n    mousemove: 'element.mousemove',\n    mouseup: 'element.mouseup',\n    contextmenu: 'element.contextmenu'\n  };\n\n  var ignoredFilters = {\n    'element.contextmenu': allowAll\n  };\n\n\n  // manual event trigger\n\n  /**\n   * Trigger an interaction event (based on a native dom event)\n   * on the target shape or connection.\n   *\n   * @param {String} eventName the name of the triggered DOM event\n   * @param {MouseEvent} event\n   * @param {djs.model.Base} targetElement\n   */\n  function triggerMouseEvent(eventName, event, targetElement) {\n\n    // i.e. element.mousedown...\n    var localEventName = bindings[eventName];\n\n    if (!localEventName) {\n      throw new Error('unmapped DOM event name <' + eventName + '>');\n    }\n\n    return fire(localEventName, event, targetElement);\n  }\n\n\n  var elementSelector = 'svg, .djs-element';\n\n  // event registration\n\n  function registerEvent(node, event, localEvent, ignoredFilter) {\n\n    var handler = handlers[localEvent] = function(event) {\n      fire(localEvent, event);\n    };\n\n    if (ignoredFilter) {\n      ignoredFilters[localEvent] = ignoredFilter;\n    }\n\n    handler.$delegate = dist_index_esm/* delegate.bind */.cl.bind(node, elementSelector, event, handler);\n  }\n\n  function unregisterEvent(node, event, localEvent) {\n\n    var handler = mouseHandler(localEvent);\n\n    if (!handler) {\n      return;\n    }\n\n    dist_index_esm/* delegate.unbind */.cl.unbind(node, event, handler.$delegate);\n  }\n\n  function registerEvents(svg) {\n    (0,index_esm/* forEach */.Ed)(bindings, function(val, key) {\n      registerEvent(svg, key, val);\n    });\n  }\n\n  function unregisterEvents(svg) {\n    (0,index_esm/* forEach */.Ed)(bindings, function(val, key) {\n      unregisterEvent(svg, key, val);\n    });\n  }\n\n  eventBus.on('canvas.destroy', function(event) {\n    unregisterEvents(event.svg);\n  });\n\n  eventBus.on('canvas.init', function(event) {\n    registerEvents(event.svg);\n  });\n\n\n  eventBus.on([ 'shape.added', 'connection.added' ], function(event) {\n    var element = event.element,\n        gfx = event.gfx,\n        hit;\n\n    if (element.waypoints) {\n      hit = (0,RenderUtil/* createLine */.W5)(element.waypoints);\n    } else {\n      hit = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, {\n        x: 0,\n        y: 0,\n        width: element.width,\n        height: element.height\n      });\n    }\n\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, HIT_STYLE);\n\n    (0,tiny_svg_dist_index_esm/* append */.R3)(gfx, hit);\n  });\n\n  // Update djs-hit on change.\n  // A low priortity is necessary, because djs-hit of labels has to be updated\n  // after the label bounds have been updated in the renderer.\n  eventBus.on('shape.changed', LOW_PRIORITY, function(event) {\n\n    var element = event.element,\n        gfx = event.gfx,\n        hit = (0,dist_index_esm/* query */.IO)('.djs-hit', gfx);\n\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(hit, {\n      width: element.width,\n      height: element.height\n    });\n  });\n\n  eventBus.on('connection.changed', function(event) {\n\n    var element = event.element,\n        gfx = event.gfx,\n        hit = (0,dist_index_esm/* query */.IO)('.djs-hit', gfx);\n\n    (0,RenderUtil/* updateLine */.cq)(hit, element.waypoints);\n  });\n\n\n  // API\n\n  this.fire = fire;\n\n  this.triggerMouseEvent = triggerMouseEvent;\n\n  this.mouseHandler = mouseHandler;\n\n  this.registerEvent = registerEvent;\n  this.unregisterEvent = unregisterEvent;\n}\n\n\nInteractionEvents.$inject = [\n  'eventBus',\n  'elementRegistry',\n  'styles'\n];\n\n\n/**\n * An event indicating that the mouse hovered over an element\n *\n * @event element.hover\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has left an element\n *\n * @event element.out\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has clicked an element\n *\n * @event element.click\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has double clicked an element\n *\n * @event element.dblclick\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has gone down on an element.\n *\n * @event element.mousedown\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the mouse has gone up on an element.\n *\n * @event element.mouseup\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n\n/**\n * An event indicating that the context menu action is triggered\n * via mouse or touch controls.\n *\n * @event element.contextmenu\n *\n * @type {Object}\n * @property {djs.model.Base} element\n * @property {SVGElement} gfx\n * @property {Event} originalEvent\n */\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/index.js\n\n\n/* harmony default export */ const interaction_events = ({\n  __init__: [ 'interactionEvents' ],\n  interactionEvents: [ 'type', InteractionEvents ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard-move-selection/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ keyboard_move_selection)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/index.js + 1 modules\nvar keyboard = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard-move-selection/KeyboardMoveSelection.js\n\n\n\nvar DEFAULT_CONFIG = {\n  moveSpeed: 1,\n  moveSpeedAccelerated: 10\n};\n\nvar HIGHER_PRIORITY = 1500;\n\nvar LEFT = 'left';\nvar UP = 'up';\nvar RIGHT = 'right';\nvar DOWN = 'down';\n\nvar KEY_TO_DIRECTION = {\n  ArrowLeft: LEFT,\n  Left: LEFT,\n  ArrowUp: UP,\n  Up: UP,\n  ArrowRight: RIGHT,\n  Right: RIGHT,\n  ArrowDown: DOWN,\n  Down: DOWN\n};\n\nvar DIRECTIONS_DELTA = {\n  left: function(speed) {\n    return {\n      x: -speed,\n      y: 0\n    };\n  },\n  up: function(speed) {\n    return {\n      x: 0,\n      y: -speed\n    };\n  },\n  right: function(speed) {\n    return {\n      x: speed,\n      y: 0\n    };\n  },\n  down: function(speed) {\n    return {\n      x: 0,\n      y: speed\n    };\n  }\n};\n\n\n/**\n * Enables to move selection with keyboard arrows.\n * Use with Shift for modified speed (default=1, with Shift=10).\n * Pressed Cmd/Ctrl turns the feature off.\n *\n * @param {Object} config\n * @param {Number} [config.moveSpeed=1]\n * @param {Number} [config.moveSpeedAccelerated=10]\n * @param {Keyboard} keyboard\n * @param {Modeling} modeling\n * @param {Selection} selection\n */\nfunction KeyboardMoveSelection(\n    config, keyboard,\n    modeling, selection\n) {\n\n  var self = this;\n\n  this._config = (0,index_esm/* assign */.f0)({}, DEFAULT_CONFIG, config || {});\n\n  keyboard.addListener(HIGHER_PRIORITY, function(event) {\n\n    var keyEvent = event.keyEvent;\n\n    var direction = KEY_TO_DIRECTION[keyEvent.key];\n\n    if (!direction) {\n      return;\n    }\n\n    if (keyboard.isCmd(keyEvent)) {\n      return;\n    }\n\n    var accelerated = keyboard.isShift(keyEvent);\n\n    self.moveSelection(direction, accelerated);\n\n    return true;\n  });\n\n\n  /**\n   * Move selected elements in the given direction,\n   * optionally specifying accelerated movement.\n   *\n   * @param {String} direction\n   * @param {Boolean} [accelerated=false]\n   */\n  this.moveSelection = function(direction, accelerated) {\n\n    var selectedElements = selection.get();\n\n    if (!selectedElements.length) {\n      return;\n    }\n\n    var speed = this._config[\n      accelerated ?\n        'moveSpeedAccelerated' :\n        'moveSpeed'\n    ];\n\n    var delta = DIRECTIONS_DELTA[direction](speed);\n\n    modeling.moveElements(selectedElements, delta);\n  };\n\n}\n\nKeyboardMoveSelection.$inject = [\n  'config.keyboardMoveSelection',\n  'keyboard',\n  'modeling',\n  'selection'\n];\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard-move-selection/index.js\n\n\n\n\n\n/* harmony default export */ const keyboard_move_selection = ({\n  __depends__: [\n    keyboard/* default */.Z,\n    selection/* default */.Z\n  ],\n  __init__: [\n    'keyboardMoveSelection'\n  ],\n  keyboardMoveSelection: [ 'type', KeyboardMoveSelection ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard-move-selection/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ KeyboardBindings)\n/* harmony export */ });\n/* harmony import */ var _KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n\n\nvar LOW_PRIORITY = 500;\n\n\n/**\n * Adds default keyboard bindings.\n *\n * This does not pull in any features will bind only actions that\n * have previously been registered against the editorActions component.\n *\n * @param {EventBus} eventBus\n * @param {Keyboard} keyboard\n */\nfunction KeyboardBindings(eventBus, keyboard) {\n\n  var self = this;\n\n  eventBus.on('editorActions.init', LOW_PRIORITY, function(event) {\n\n    var editorActions = event.editorActions;\n\n    self.registerBindings(keyboard, editorActions);\n  });\n}\n\nKeyboardBindings.$inject = [\n  'eventBus',\n  'keyboard'\n];\n\n\n/**\n * Register available keyboard bindings.\n *\n * @param {Keyboard} keyboard\n * @param {EditorActions} editorActions\n */\nKeyboardBindings.prototype.registerBindings = function(keyboard, editorActions) {\n\n  /**\n   * Add keyboard binding if respective editor action\n   * is registered.\n   *\n   * @param {String} action name\n   * @param {Function} fn that implements the key binding\n   */\n  function addListener(action, fn) {\n\n    if (editorActions.isRegistered(action)) {\n      keyboard.addListener(fn);\n    }\n  }\n\n\n  // undo\n  // (CTRL|CMD) + Z\n  addListener('undo', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event) && !(0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isShift */ .cY)(event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)(['z', 'Z'], event)) {\n      editorActions.trigger('undo');\n\n      return true;\n    }\n  });\n\n  // redo\n  // CTRL + Y\n  // CMD + SHIFT + Z\n  addListener('redo', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event) && ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)(['y', 'Y'], event) || ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)(['z', 'Z'], event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isShift */ .cY)(event)))) {\n      editorActions.trigger('redo');\n\n      return true;\n    }\n  });\n\n  // copy\n  // CTRL/CMD + C\n  addListener('copy', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)(['c', 'C'], event)) {\n      editorActions.trigger('copy');\n\n      return true;\n    }\n  });\n\n  // paste\n  // CTRL/CMD + V\n  addListener('paste', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)(['v', 'V'], event)) {\n      editorActions.trigger('paste');\n\n      return true;\n    }\n  });\n\n  // zoom in one step\n  // CTRL/CMD + +\n  addListener('stepZoom', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)([ '+', 'Add' ], event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event)) {\n      editorActions.trigger('stepZoom', { value: 1 });\n\n      return true;\n    }\n  });\n\n  // zoom out one step\n  // CTRL + -\n  addListener('stepZoom', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)([ '-', 'Subtract' ], event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event)) {\n      editorActions.trigger('stepZoom', { value: -1 });\n\n      return true;\n    }\n  });\n\n  // zoom to the default level\n  // CTRL + 0\n  addListener('zoom', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)('0', event) && (0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event)) {\n      editorActions.trigger('zoom', { value: 1 });\n\n      return true;\n    }\n  });\n\n  // delete selected element\n  // DEL\n  addListener('removeSelection', function(context) {\n\n    var event = context.keyEvent;\n\n    if ((0,_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isKey */ .ot)([ 'Delete', 'Del' ], event)) {\n      editorActions.trigger('removeSelection');\n\n      return true;\n    }\n  });\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "JS": () => (/* binding */ isCmd),\n/* harmony export */   "aw": () => (/* binding */ hasModifier),\n/* harmony export */   "cY": () => (/* binding */ isShift),\n/* harmony export */   "ot": () => (/* binding */ isKey)\n/* harmony export */ });\nif ("cmmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/min-dash/dist/index.esm.js");\n}\n\r\n\r\n/**\r\n * Returns true if event was triggered with any modifier\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction hasModifier(event) {\r\n  return (event.ctrlKey || event.metaKey || event.shiftKey || event.altKey);\r\n}\r\n\r\n/**\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction isCmd(event) {\r\n\r\n  // ensure we don\'t react to AltGr\r\n  // (mapped to CTRL + ALT)\r\n  if (event.altKey) {\r\n    return false;\r\n  }\r\n\r\n  return event.ctrlKey || event.metaKey;\r\n}\r\n\r\n/**\r\n * Checks if key pressed is one of provided keys.\r\n *\r\n * @param {String|String[]} keys\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction isKey(keys, event) {\r\n  keys = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(keys) ? keys : [ keys ];\r\n\r\n  return keys.indexOf(event.key) > -1;\r\n}\r\n\r\n/**\r\n * @param {KeyboardEvent} event\r\n */\r\nfunction isShift(event) {\r\n  return event.shiftKey;\r\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ keyboard)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/Keyboard.js\n\n\n\n\n\n\nvar KEYDOWN_EVENT = 'keyboard.keydown',\n    KEYUP_EVENT = 'keyboard.keyup';\n\nvar DEFAULT_PRIORITY = 1000;\n\n\n/**\n * A keyboard abstraction that may be activated and\n * deactivated by users at will, consuming key events\n * and triggering diagram actions.\n *\n * For keys pressed down, keyboard fires `keyboard.keydown` event.\n * The event context contains one field which is `KeyboardEvent` event.\n *\n * The implementation fires the following key events that allow\n * other components to hook into key handling:\n *\n *  - keyboard.bind\n *  - keyboard.unbind\n *  - keyboard.init\n *  - keyboard.destroy\n *\n * All events contain one field which is node.\n *\n * A default binding for the keyboard may be specified via the\n * `keyboard.bindTo` configuration option.\n *\n * @param {Config} config\n * @param {EventBus} eventBus\n */\nfunction Keyboard(config, eventBus) {\n  var self = this;\n\n  this._config = config || {};\n  this._eventBus = eventBus;\n\n  this._keydownHandler = this._keydownHandler.bind(this);\n  this._keyupHandler = this._keyupHandler.bind(this);\n\n  // properly clean dom registrations\n  eventBus.on('diagram.destroy', function() {\n    self._fire('destroy');\n\n    self.unbind();\n  });\n\n  eventBus.on('diagram.init', function() {\n    self._fire('init');\n  });\n\n  eventBus.on('attach', function() {\n    if (config && config.bindTo) {\n      self.bind(config.bindTo);\n    }\n  });\n\n  eventBus.on('detach', function() {\n    self.unbind();\n  });\n}\n\nKeyboard.$inject = [\n  'config.keyboard',\n  'eventBus'\n];\n\nKeyboard.prototype._keydownHandler = function(event) {\n  this._keyHandler(event, KEYDOWN_EVENT);\n};\n\nKeyboard.prototype._keyupHandler = function(event) {\n  this._keyHandler(event, KEYUP_EVENT);\n};\n\nKeyboard.prototype._keyHandler = function(event, type) {\n  var target = event.target,\n      eventBusResult;\n\n  if (isInput(target)) {\n    return;\n  }\n\n  var context = {\n    keyEvent: event\n  };\n\n  eventBusResult = this._eventBus.fire(type || KEYDOWN_EVENT, context);\n\n  if (eventBusResult) {\n    event.preventDefault();\n  }\n};\n\nKeyboard.prototype.bind = function(node) {\n\n  // make sure that the keyboard is only bound once to the DOM\n  this.unbind();\n\n  this._node = node;\n\n  // bind key events\n  dist_index_esm/* event.bind */.B.bind(node, 'keydown', this._keydownHandler, true);\n  dist_index_esm/* event.bind */.B.bind(node, 'keyup', this._keyupHandler, true);\n\n  this._fire('bind');\n};\n\nKeyboard.prototype.getBinding = function() {\n  return this._node;\n};\n\nKeyboard.prototype.unbind = function() {\n  var node = this._node;\n\n  if (node) {\n    this._fire('unbind');\n\n    // unbind key events\n    dist_index_esm/* event.unbind */.B.unbind(node, 'keydown', this._keydownHandler, true);\n    dist_index_esm/* event.unbind */.B.unbind(node, 'keyup', this._keyupHandler, true);\n  }\n\n  this._node = null;\n};\n\nKeyboard.prototype._fire = function(event) {\n  this._eventBus.fire('keyboard.' + event, { node: this._node });\n};\n\n/**\n * Add a listener function that is notified with `KeyboardEvent` whenever\n * the keyboard is bound and the user presses a key. If no priority is\n * provided, the default value of 1000 is used.\n *\n * @param {Number} [priority]\n * @param {Function} listener\n * @param {string} type\n */\nKeyboard.prototype.addListener = function(priority, listener, type) {\n  if ((0,index_esm/* isFunction */.mf)(priority)) {\n    type = listener;\n    listener = priority;\n    priority = DEFAULT_PRIORITY;\n  }\n\n  this._eventBus.on(type || KEYDOWN_EVENT, priority, listener);\n};\n\nKeyboard.prototype.removeListener = function(listener, type) {\n  this._eventBus.off(type || KEYDOWN_EVENT, listener);\n};\n\nKeyboard.prototype.hasModifier = KeyboardUtil/* hasModifier */.aw;\nKeyboard.prototype.isCmd = KeyboardUtil/* isCmd */.JS;\nKeyboard.prototype.isShift = KeyboardUtil/* isShift */.cY;\nKeyboard.prototype.isKey = KeyboardUtil/* isKey */.ot;\n\n\n\n// helpers ///////\n\nfunction isInput(target) {\n  return target && ((0,dist_index_esm/* matches */.wB)(target, 'input, textarea') || target.contentEditable === 'true');\n}\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js\nvar KeyboardBindings = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/index.js\n\n\n\n/* harmony default export */ const keyboard = ({\n  __init__: [ 'keyboard', 'keyboardBindings' ],\n  keyboard: [ 'type', Keyboard ],\n  keyboardBindings: [ 'type', KeyboardBindings/* default */.Z ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/label-support/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ label_support)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/inherits/inherits_browser.js\nvar inherits_browser = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\nvar inherits_browser_default = /*#__PURE__*/__webpack_require__.n(inherits_browser);\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Removal.js\nvar Removal = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Removal.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/label-support/LabelSupport.js\n\n\n\n\nvar LOW_PRIORITY = 250,\n    HIGH_PRIORITY = 1400;\n\n\n\n\n\n\n\n\n/**\n * A handler that makes sure labels are properly moved with\n * their label targets.\n *\n * @param {didi.Injector} injector\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n */\nfunction LabelSupport(injector, eventBus, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  var movePreview = injector.get('movePreview', false);\n\n  // remove labels from the collection that are being\n  // moved with other elements anyway\n  eventBus.on('shape.move.start', HIGH_PRIORITY, function(e) {\n\n    var context = e.context,\n        shapes = context.shapes,\n        validatedShapes = context.validatedShapes;\n\n    context.shapes = removeLabels(shapes);\n    context.validatedShapes = removeLabels(validatedShapes);\n  });\n\n  // add labels to visual's group\n  movePreview && eventBus.on('shape.move.start', LOW_PRIORITY, function(e) {\n\n    var context = e.context,\n        shapes = context.shapes;\n\n    var labels = [];\n\n    (0,index_esm/* forEach */.Ed)(shapes, function(element) {\n\n      (0,index_esm/* forEach */.Ed)(element.labels, function(label) {\n\n        if (!label.hidden && context.shapes.indexOf(label) === -1) {\n          labels.push(label);\n        }\n\n        if (element.labelTarget) {\n          labels.push(element);\n        }\n      });\n    });\n\n    (0,index_esm/* forEach */.Ed)(labels, function(label) {\n      movePreview.makeDraggable(context, label, true);\n    });\n\n  });\n\n  // add all labels to move closure\n  this.preExecuted('elements.move', HIGH_PRIORITY, function(e) {\n    var context = e.context,\n        closure = context.closure,\n        enclosedElements = closure.enclosedElements;\n\n    var enclosedLabels = [];\n\n    // find labels that are not part of\n    // move closure yet and add them\n    (0,index_esm/* forEach */.Ed)(enclosedElements, function(element) {\n      (0,index_esm/* forEach */.Ed)(element.labels, function(label) {\n\n        if (!enclosedElements[label.id]) {\n          enclosedLabels.push(label);\n        }\n      });\n    });\n\n    closure.addAll(enclosedLabels);\n  });\n\n\n  this.preExecute([\n    'connection.delete',\n    'shape.delete'\n  ], function(e) {\n\n    var context = e.context,\n        element = context.connection || context.shape;\n\n    (0,Removal/* saveClear */.r)(element.labels, function(label) {\n      modeling.removeShape(label, { nested: true });\n    });\n  });\n\n\n  this.execute('shape.delete', function(e) {\n\n    var context = e.context,\n        shape = context.shape,\n        labelTarget = shape.labelTarget;\n\n    // unset labelTarget\n    if (labelTarget) {\n      context.labelTargetIndex = (0,Collections.indexOf)(labelTarget.labels, shape);\n      context.labelTarget = labelTarget;\n\n      shape.labelTarget = null;\n    }\n  });\n\n  this.revert('shape.delete', function(e) {\n\n    var context = e.context,\n        shape = context.shape,\n        labelTarget = context.labelTarget,\n        labelTargetIndex = context.labelTargetIndex;\n\n    // restore labelTarget\n    if (labelTarget) {\n      (0,Collections.add)(labelTarget.labels, shape, labelTargetIndex);\n\n      shape.labelTarget = labelTarget;\n    }\n  });\n\n}\n\ninherits_browser_default()(LabelSupport, CommandInterceptor/* default */.Z);\n\nLabelSupport.$inject = [\n  'injector',\n  'eventBus',\n  'modeling'\n];\n\n\n/**\n * Return a filtered list of elements that do not\n * contain attached elements with hosts being part\n * of the selection.\n *\n * @param  {Array<djs.model.Base>} elements\n *\n * @return {Array<djs.model.Base>} filtered\n */\nfunction removeLabels(elements) {\n\n  return (0,index_esm/* filter */.hX)(elements, function(element) {\n\n    // filter out labels that are move together\n    // with their label targets\n    return elements.indexOf(element.labelTarget) === -1;\n  });\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/label-support/index.js\n\n\n/* harmony default export */ const label_support = ({\n  __init__: [ 'labelSupport'],\n  labelSupport: [ 'type', LabelSupport ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/label-support/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/lasso-tool/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ lasso_tool)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js + 1 modules\nvar tool_manager = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js + 1 modules\nvar Mouse = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/lasso-tool/LassoTool.js\n\n\n\n\n\n\n\n\nvar LASSO_TOOL_CURSOR = 'crosshair';\n\n\nfunction LassoTool(\n    eventBus, canvas, dragging,\n    elementRegistry, selection, toolManager) {\n\n  this._selection = selection;\n  this._dragging = dragging;\n\n  var self = this;\n\n  // lasso visuals implementation\n\n  /**\n  * A helper that realizes the selection box visual\n  */\n  var visuals = {\n\n    create: function(context) {\n      var container = canvas.getDefaultLayer(),\n          frame;\n\n      frame = context.frame = (0,dist_index_esm/* create */.Ue)('rect');\n      (0,dist_index_esm/* attr */.Lj)(frame, {\n        class: 'djs-lasso-overlay',\n        width:  1,\n        height: 1,\n        x: 0,\n        y: 0\n      });\n\n      (0,dist_index_esm/* append */.R3)(container, frame);\n    },\n\n    update: function(context) {\n      var frame = context.frame,\n          bbox = context.bbox;\n\n      (0,dist_index_esm/* attr */.Lj)(frame, {\n        x: bbox.x,\n        y: bbox.y,\n        width: bbox.width,\n        height: bbox.height\n      });\n    },\n\n    remove: function(context) {\n\n      if (context.frame) {\n        (0,dist_index_esm/* remove */.Od)(context.frame);\n      }\n    }\n  };\n\n  toolManager.registerTool('lasso', {\n    tool: 'lasso.selection',\n    dragging: 'lasso'\n  });\n\n  eventBus.on('lasso.selection.end', function(event) {\n    var target = event.originalEvent.target;\n\n    // only reactive on diagram click\n    // on some occasions, event.hover is not set and we have to check if the target is an svg\n    if (!event.hover && !(target instanceof SVGElement)) {\n      return;\n    }\n\n    eventBus.once('lasso.selection.ended', function() {\n      self.activateLasso(event.originalEvent, true);\n    });\n  });\n\n  // lasso interaction implementation\n\n  eventBus.on('lasso.end', function(event) {\n\n    var bbox = toBBox(event);\n\n    var elements = elementRegistry.filter(function(element) {\n      return element;\n    });\n\n    self.select(elements, bbox);\n  });\n\n  eventBus.on('lasso.start', function(event) {\n\n    var context = event.context;\n\n    context.bbox = toBBox(event);\n    visuals.create(context);\n  });\n\n  eventBus.on('lasso.move', function(event) {\n\n    var context = event.context;\n\n    context.bbox = toBBox(event);\n    visuals.update(context);\n  });\n\n  eventBus.on('lasso.cleanup', function(event) {\n\n    var context = event.context;\n\n    visuals.remove(context);\n  });\n\n\n  // event integration\n\n  eventBus.on('element.mousedown', 1500, function(event) {\n\n    if ((0,Mouse/* hasSecondaryModifier */.Dw)(event)) {\n      self.activateLasso(event.originalEvent);\n\n      // we've handled the event\n      return true;\n    }\n  });\n}\n\nLassoTool.$inject = [\n  'eventBus',\n  'canvas',\n  'dragging',\n  'elementRegistry',\n  'selection',\n  'toolManager'\n];\n\n\nLassoTool.prototype.activateLasso = function(event, autoActivate) {\n\n  this._dragging.init(event, 'lasso', {\n    autoActivate: autoActivate,\n    cursor: LASSO_TOOL_CURSOR,\n    data: {\n      context: {}\n    }\n  });\n};\n\nLassoTool.prototype.activateSelection = function(event) {\n\n  this._dragging.init(event, 'lasso.selection', {\n    trapClick: false,\n    cursor: LASSO_TOOL_CURSOR,\n    data: {\n      context: {}\n    }\n  });\n};\n\nLassoTool.prototype.select = function(elements, bbox) {\n  var selectedElements = (0,Elements/* getEnclosedElements */.RH)(elements, bbox);\n\n  this._selection.select((0,index_esm/* values */.VO)(selectedElements));\n};\n\nLassoTool.prototype.toggle = function() {\n  if (this.isActive()) {\n    this._dragging.cancel();\n  } else {\n    this.activateSelection();\n  }\n};\n\nLassoTool.prototype.isActive = function() {\n  var context = this._dragging.context();\n\n  return context && /^lasso/.test(context.prefix);\n};\n\n\n\nfunction toBBox(event) {\n\n  var start = {\n\n    x: event.x - event.dx,\n    y: event.y - event.dy\n  };\n\n  var end = {\n    x: event.x,\n    y: event.y\n  };\n\n  var bbox;\n\n  if ((start.x <= end.x && start.y < end.y) ||\n      (start.x < end.x && start.y <= end.y)) {\n\n    bbox = {\n      x: start.x,\n      y: start.y,\n      width:  end.x - start.x,\n      height: end.y - start.y\n    };\n  } else if ((start.x >= end.x && start.y < end.y) ||\n             (start.x > end.x && start.y <= end.y)) {\n\n    bbox = {\n      x: end.x,\n      y: start.y,\n      width:  start.x - end.x,\n      height: end.y - start.y\n    };\n  } else if ((start.x <= end.x && start.y > end.y) ||\n             (start.x < end.x && start.y >= end.y)) {\n\n    bbox = {\n      x: start.x,\n      y: end.y,\n      width:  end.x - start.x,\n      height: start.y - end.y\n    };\n  } else if ((start.x >= end.x && start.y > end.y) ||\n             (start.x > end.x && start.y >= end.y)) {\n\n    bbox = {\n      x: end.x,\n      y: end.y,\n      width:  start.x - end.x,\n      height: start.y - end.y\n    };\n  } else {\n\n    bbox = {\n      x: end.x,\n      y: end.y,\n      width:  0,\n      height: 0\n    };\n  }\n  return bbox;\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/lasso-tool/index.js\n\n\n\n\n/* harmony default export */ const lasso_tool = ({\n  __depends__: [\n    tool_manager/* default */.Z\n  ],\n  __init__: [ 'lassoTool' ],\n  lassoTool: [ 'type', LassoTool ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/lasso-tool/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/Modeling.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ Modeling)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/model/index.js\nvar model = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/model/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/AppendShapeHandler.js\nvar AppendShapeHandler = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/AppendShapeHandler.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/CreateShapeHandler.js\n\n\nvar round = Math.round;\n\n\n/**\n * A handler that implements reversible addition of shapes.\n *\n * @param {canvas} Canvas\n */\nfunction CreateShapeHandler(canvas) {\n  this._canvas = canvas;\n}\n\nCreateShapeHandler.$inject = [ 'canvas' ];\n\n\n// api //////////////////////\n\n\n/**\n * Appends a shape to a target shape\n *\n * @param {Object} context\n * @param {djs.model.Base} context.parent the parent object\n * @param {Point} context.position position of the new element\n */\nCreateShapeHandler.prototype.execute = function(context) {\n\n  var shape = context.shape,\n      positionOrBounds = context.position,\n      parent = context.parent,\n      parentIndex = context.parentIndex;\n\n  if (!parent) {\n    throw new Error('parent required');\n  }\n\n  if (!positionOrBounds) {\n    throw new Error('position required');\n  }\n\n  // (1) add at event center position _or_ at given bounds\n  if (positionOrBounds.width !== undefined) {\n    (0,index_esm/* assign */.f0)(shape, positionOrBounds);\n  } else {\n    (0,index_esm/* assign */.f0)(shape, {\n      x: positionOrBounds.x - round(shape.width / 2),\n      y: positionOrBounds.y - round(shape.height / 2)\n    });\n  }\n\n  // (2) add to canvas\n  this._canvas.addShape(shape, parent, parentIndex);\n\n  return shape;\n};\n\n\n/**\n * Undo append by removing the shape\n */\nCreateShapeHandler.prototype.revert = function(context) {\n\n  // (3) remove form canvas\n  this._canvas.removeShape(context.shape);\n};\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Removal.js\nvar Removal = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Removal.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/DeleteShapeHandler.js\n\n\n\n\n\n/**\n * A handler that implements reversible deletion of shapes.\n *\n */\nfunction DeleteShapeHandler(canvas, modeling) {\n  this._canvas = canvas;\n  this._modeling = modeling;\n}\n\nDeleteShapeHandler.$inject = [ 'canvas', 'modeling' ];\n\n\n/**\n * - Remove connections\n * - Remove all direct children\n */\nDeleteShapeHandler.prototype.preExecute = function(context) {\n\n  var modeling = this._modeling;\n\n  var shape = context.shape;\n\n  // remove connections\n  (0,Removal/* saveClear */.r)(shape.incoming, function(connection) {\n    // To make sure that the connection isn't removed twice\n    // For example if a container is removed\n    modeling.removeConnection(connection, { nested: true });\n  });\n\n  (0,Removal/* saveClear */.r)(shape.outgoing, function(connection) {\n    modeling.removeConnection(connection, { nested: true });\n  });\n\n  // remove child shapes and connections\n  (0,Removal/* saveClear */.r)(shape.children, function(child) {\n    if (isConnection(child)) {\n      modeling.removeConnection(child, { nested: true });\n    } else {\n      modeling.removeShape(child, { nested: true });\n    }\n  });\n};\n\n/**\n * Remove shape and remember the parent\n */\nDeleteShapeHandler.prototype.execute = function(context) {\n  var canvas = this._canvas;\n\n  var shape = context.shape,\n      oldParent = shape.parent;\n\n  context.oldParent = oldParent;\n\n  // remove containment\n  context.oldParentIndex = (0,Collections.indexOf)(oldParent.children, shape);\n\n  // remove shape\n  canvas.removeShape(shape);\n\n  return shape;\n};\n\n\n/**\n * Command revert implementation\n */\nDeleteShapeHandler.prototype.revert = function(context) {\n\n  var canvas = this._canvas;\n\n  var shape = context.shape,\n      oldParent = context.oldParent,\n      oldParentIndex = context.oldParentIndex;\n\n  // restore containment\n  (0,Collections.add)(oldParent.children, shape, oldParentIndex);\n\n  canvas.addShape(shape, oldParent);\n\n  return shape;\n};\n\nfunction isConnection(element) {\n  return element.waypoints;\n}\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/AttachUtil.js\nvar AttachUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/AttachUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/helper/AnchorsHelper.js\n\n\n\nfunction getResizedSourceAnchor(connection, shape, oldBounds) {\n\n  var waypoints = safeGetWaypoints(connection),\n      oldAnchor = waypoints[0];\n\n  return (0,AttachUtil/* getNewAttachPoint */.r)(oldAnchor.original || oldAnchor, oldBounds, shape);\n}\n\n\nfunction getResizedTargetAnchor(connection, shape, oldBounds) {\n\n  var waypoints = safeGetWaypoints(connection),\n      oldAnchor = waypoints[waypoints.length - 1];\n\n  return (0,AttachUtil/* getNewAttachPoint */.r)(oldAnchor.original || oldAnchor, oldBounds, shape);\n}\n\n\nfunction getMovedSourceAnchor(connection, source, moveDelta) {\n  return getResizedSourceAnchor(connection, source, substractPosition(source, moveDelta));\n}\n\n\nfunction getMovedTargetAnchor(connection, target, moveDelta) {\n  return getResizedTargetAnchor(connection, target, substractPosition(target, moveDelta));\n}\n\n\n// helpers //////////////////////\n\nfunction substractPosition(bounds, delta) {\n  return {\n    x: bounds.x - delta.x,\n    y: bounds.y - delta.y,\n    width: bounds.width,\n    height: bounds.height\n  };\n}\n\n\n/**\n * Return waypoints of given connection; throw if non exists (should not happen!!).\n *\n * @param {Connection} connection\n *\n * @return {Array<Point>}\n */\nfunction safeGetWaypoints(connection) {\n\n  var waypoints = connection.waypoints;\n\n  if (!waypoints.length) {\n    throw new Error('connection#' + connection.id + ': no waypoints');\n  }\n\n  return waypoints;\n}\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/helper/MoveClosure.js\n\n\n\n\n\nfunction MoveClosure() {\n\n  this.allShapes = {};\n  this.allConnections = {};\n\n  this.enclosedElements = {};\n  this.enclosedConnections = {};\n\n  this.topLevel = {};\n}\n\n\nMoveClosure.prototype.add = function(element, isTopLevel) {\n  return this.addAll([ element ], isTopLevel);\n};\n\n\nMoveClosure.prototype.addAll = function(elements, isTopLevel) {\n\n  var newClosure = (0,Elements/* getClosure */.vA)(elements, !!isTopLevel, this);\n\n  (0,index_esm/* assign */.f0)(this, newClosure);\n\n  return this;\n};\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/helper/MoveHelper.js\n\n\n\n\n\n\n\n/**\n * A helper that is able to carry out serialized move\n * operations on multiple elements.\n *\n * @param {Modeling} modeling\n */\nfunction MoveHelper(modeling) {\n  this._modeling = modeling;\n}\n\n/**\n * Move the specified elements and all children by the given delta.\n *\n * This moves all enclosed connections, too and layouts all affected\n * external connections.\n *\n * @param  {Array<djs.model.Base>} elements\n * @param  {Point} delta\n * @param  {djs.model.Base} newParent applied to the first level of shapes\n *\n * @return {Array<djs.model.Base>} list of touched elements\n */\nMoveHelper.prototype.moveRecursive = function(elements, delta, newParent) {\n  if (!elements) {\n    return [];\n  } else {\n    return this.moveClosure(this.getClosure(elements), delta, newParent);\n  }\n};\n\n/**\n * Move the given closure of elmements.\n *\n * @param {Object} closure\n * @param {Point} delta\n * @param {djs.model.Base} [newParent]\n * @param {djs.model.Base} [newHost]\n */\nMoveHelper.prototype.moveClosure = function(closure, delta, newParent, newHost, primaryShape) {\n  var modeling = this._modeling;\n\n  var allShapes = closure.allShapes,\n      allConnections = closure.allConnections,\n      enclosedConnections = closure.enclosedConnections,\n      topLevel = closure.topLevel,\n      keepParent = false;\n\n  if (primaryShape && primaryShape.parent === newParent) {\n    keepParent = true;\n  }\n\n  // move all shapes\n  (0,index_esm/* forEach */.Ed)(allShapes, function(shape) {\n\n    // move the element according to the given delta\n    modeling.moveShape(shape, delta, topLevel[shape.id] && !keepParent && newParent, {\n      recurse: false,\n      layout: false\n    });\n  });\n\n  // move all child connections / layout external connections\n  (0,index_esm/* forEach */.Ed)(allConnections, function(c) {\n\n    var sourceMoved = !!allShapes[c.source.id],\n        targetMoved = !!allShapes[c.target.id];\n\n    if (enclosedConnections[c.id] && sourceMoved && targetMoved) {\n      modeling.moveConnection(c, delta, topLevel[c.id] && !keepParent && newParent);\n    } else {\n      modeling.layoutConnection(c, {\n        connectionStart: sourceMoved && getMovedSourceAnchor(c, c.source, delta),\n        connectionEnd: targetMoved && getMovedTargetAnchor(c, c.target, delta)\n      });\n    }\n  });\n};\n\n/**\n * Returns the closure for the selected elements\n *\n * @param  {Array<djs.model.Base>} elements\n * @return {MoveClosure} closure\n */\nMoveHelper.prototype.getClosure = function(elements) {\n  return new MoveClosure().addAll(elements, true);\n};\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/MoveShapeHandler.js\n\n\n\n\n\n\n\n\n\n/**\n * A handler that implements reversible moving of shapes.\n */\nfunction MoveShapeHandler(modeling) {\n  this._modeling = modeling;\n\n  this._helper = new MoveHelper(modeling);\n}\n\nMoveShapeHandler.$inject = [ 'modeling' ];\n\n\nMoveShapeHandler.prototype.execute = function(context) {\n\n  var shape = context.shape,\n      delta = context.delta,\n      newParent = context.newParent || shape.parent,\n      newParentIndex = context.newParentIndex,\n      oldParent = shape.parent;\n\n  context.oldBounds = (0,index_esm/* pick */.ei)(shape, [ 'x', 'y', 'width', 'height']);\n\n  // save old parent in context\n  context.oldParent = oldParent;\n  context.oldParentIndex = (0,Collections.remove)(oldParent.children, shape);\n\n  // add to new parent at position\n  (0,Collections.add)(newParent.children, shape, newParentIndex);\n\n  // update shape parent + position\n  (0,index_esm/* assign */.f0)(shape, {\n    parent: newParent,\n    x: shape.x + delta.x,\n    y: shape.y + delta.y\n  });\n\n  return shape;\n};\n\nMoveShapeHandler.prototype.postExecute = function(context) {\n\n  var shape = context.shape,\n      delta = context.delta,\n      hints = context.hints;\n\n  var modeling = this._modeling;\n\n  if (hints.layout !== false) {\n\n    (0,index_esm/* forEach */.Ed)(shape.incoming, function(c) {\n      modeling.layoutConnection(c, {\n        connectionEnd: getMovedTargetAnchor(c, shape, delta)\n      });\n    });\n\n    (0,index_esm/* forEach */.Ed)(shape.outgoing, function(c) {\n      modeling.layoutConnection(c, {\n        connectionStart: getMovedSourceAnchor(c, shape, delta)\n      });\n    });\n  }\n\n  if (hints.recurse !== false) {\n    this.moveChildren(context);\n  }\n};\n\nMoveShapeHandler.prototype.revert = function(context) {\n\n  var shape = context.shape,\n      oldParent = context.oldParent,\n      oldParentIndex = context.oldParentIndex,\n      delta = context.delta;\n\n  // restore previous location in old parent\n  (0,Collections.add)(oldParent.children, shape, oldParentIndex);\n\n  // revert to old position and parent\n  (0,index_esm/* assign */.f0)(shape, {\n    parent: oldParent,\n    x: shape.x - delta.x,\n    y: shape.y - delta.y\n  });\n\n  return shape;\n};\n\nMoveShapeHandler.prototype.moveChildren = function(context) {\n\n  var delta = context.delta,\n      shape = context.shape;\n\n  this._helper.moveRecursive(shape.children, delta, null);\n};\n\nMoveShapeHandler.prototype.getNewParent = function(context) {\n  return context.newParent || context.shape.parent;\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ResizeShapeHandler.js\n\n\n\n\n\n/**\n * A handler that implements reversible resizing of shapes.\n *\n * @param {Modeling} modeling\n */\nfunction ResizeShapeHandler(modeling) {\n  this._modeling = modeling;\n}\n\nResizeShapeHandler.$inject = [ 'modeling' ];\n\n/**\n * {\n *   shape: {....}\n *   newBounds: {\n *     width:  20,\n *     height: 40,\n *     x:       5,\n *     y:      10\n *   }\n *\n * }\n */\nResizeShapeHandler.prototype.execute = function(context) {\n  var shape = context.shape,\n      newBounds = context.newBounds,\n      minBounds = context.minBounds;\n\n  if (newBounds.x === undefined || newBounds.y === undefined ||\n      newBounds.width === undefined || newBounds.height === undefined) {\n    throw new Error('newBounds must have {x, y, width, height} properties');\n  }\n\n  if (minBounds && (newBounds.width < minBounds.width\n    || newBounds.height < minBounds.height)) {\n    throw new Error('width and height cannot be less than minimum height and width');\n  } else if (!minBounds\n    && newBounds.width < 10 || newBounds.height < 10) {\n    throw new Error('width and height cannot be less than 10px');\n  }\n\n  // save old bbox in context\n  context.oldBounds = {\n    width:  shape.width,\n    height: shape.height,\n    x:      shape.x,\n    y:      shape.y\n  };\n\n  // update shape\n  (0,index_esm/* assign */.f0)(shape, {\n    width:  newBounds.width,\n    height: newBounds.height,\n    x:      newBounds.x,\n    y:      newBounds.y\n  });\n\n  return shape;\n};\n\nResizeShapeHandler.prototype.postExecute = function(context) {\n\n  var shape = context.shape,\n      oldBounds = context.oldBounds;\n\n  var modeling = this._modeling;\n\n  (0,index_esm/* forEach */.Ed)(shape.incoming, function(c) {\n    modeling.layoutConnection(c, {\n      connectionEnd: getResizedTargetAnchor(c, shape, oldBounds)\n    });\n  });\n\n  (0,index_esm/* forEach */.Ed)(shape.outgoing, function(c) {\n    modeling.layoutConnection(c, {\n      connectionStart: getResizedSourceAnchor(c, shape, oldBounds)\n    });\n  });\n\n};\n\nResizeShapeHandler.prototype.revert = function(context) {\n\n  var shape = context.shape,\n      oldBounds = context.oldBounds;\n\n  // restore previous bbox\n  (0,index_esm/* assign */.f0)(shape, {\n    width:  oldBounds.width,\n    height: oldBounds.height,\n    x:      oldBounds.x,\n    y:      oldBounds.y\n  });\n\n  return shape;\n};\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReplaceShapeHandler.js\nvar ReplaceShapeHandler = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReplaceShapeHandler.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ToggleShapeCollapseHandler.js\n/**\n * A handler that toggles the collapsed state of an element\n * and the visibility of all its children.\n *\n * @param {Modeling} modeling\n */\nfunction ToggleShapeCollapseHandler(modeling) {\n  this._modeling = modeling;\n}\n\nToggleShapeCollapseHandler.$inject = [ 'modeling' ];\n\n\nToggleShapeCollapseHandler.prototype.execute = function(context) {\n\n  var shape = context.shape,\n      children = shape.children;\n\n  // remember previous visibility of children\n  context.oldChildrenVisibility = getElementsVisibility(children);\n\n  // toggle state\n  shape.collapsed = !shape.collapsed;\n\n  // hide/show children\n  setHidden(children, shape.collapsed);\n\n  return [shape].concat(children);\n};\n\n\nToggleShapeCollapseHandler.prototype.revert = function(context) {\n\n  var shape = context.shape,\n      oldChildrenVisibility = context.oldChildrenVisibility;\n\n  var children = shape.children;\n\n  // set old visability of children\n  restoreVisibility(children, oldChildrenVisibility);\n\n  // retoggle state\n  shape.collapsed = !shape.collapsed;\n\n  return [shape].concat(children);\n};\n\n\n// helpers //////////////////////\n\n/**\n * Return a map { elementId -> hiddenState}.\n *\n * @param {Array<djs.model.Shape>} elements\n *\n * @return {Object}\n */\nfunction getElementsVisibility(elements) {\n\n  var result = {};\n\n  elements.forEach(function(e) {\n    result[e.id] = e.hidden;\n  });\n\n  return result;\n}\n\n\nfunction setHidden(elements, newHidden) {\n  elements.forEach(function(element) {\n    element.hidden = newHidden;\n  });\n}\n\nfunction restoreVisibility(elements, lastState) {\n  elements.forEach(function(e) {\n    e.hidden = lastState[e.id];\n  });\n}\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js\nvar SpaceUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/SpaceToolHandler.js\n\n\n\n\n\n/**\n * A handler that implements reversible creating and removing of space.\n *\n * It executes in two phases:\n *\n *  (1) resize all affected resizeShapes\n *  (2) move all affected moveElements\n */\nfunction SpaceToolHandler(modeling) {\n  this._modeling = modeling;\n}\n\nSpaceToolHandler.$inject = [ 'modeling' ];\n\n\nSpaceToolHandler.prototype.preExecute = function(context) {\n\n  // resize\n  var modeling = this._modeling,\n      resizingShapes = context.resizingShapes,\n      delta = context.delta,\n      direction = context.direction;\n\n  (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n    var newBounds = (0,SpaceUtil/* resizeBounds */.z)(shape, direction, delta);\n\n    modeling.resizeShape(shape, newBounds);\n  });\n};\n\nSpaceToolHandler.prototype.postExecute = function(context) {\n  // move\n  var modeling = this._modeling,\n      movingShapes = context.movingShapes,\n      delta = context.delta;\n\n  modeling.moveElements(movingShapes, delta, undefined, { autoResize: false, attach: false });\n};\n\nSpaceToolHandler.prototype.execute = function(context) {};\nSpaceToolHandler.prototype.revert = function(context) {};\n\n// EXTERNAL MODULE: ./node_modules/inherits/inherits_browser.js\nvar inherits_browser = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\nvar inherits_browser_default = /*#__PURE__*/__webpack_require__.n(inherits_browser);\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/CreateLabelHandler.js\n\n\n\n\n\n/**\n * A handler that attaches a label to a given target shape.\n *\n * @param {Canvas} canvas\n */\nfunction CreateLabelHandler(canvas) {\n  CreateShapeHandler.call(this, canvas);\n}\n\ninherits_browser_default()(CreateLabelHandler, CreateShapeHandler);\n\nCreateLabelHandler.$inject = [ 'canvas' ];\n\n\n// api //////////////////////\n\n\nvar originalExecute = CreateShapeHandler.prototype.execute;\n\n/**\n * Appends a label to a target shape.\n *\n * @method CreateLabelHandler#execute\n *\n * @param {Object} context\n * @param {ElementDescriptor} context.target the element the label is attached to\n * @param {ElementDescriptor} context.parent the parent object\n * @param {Point} context.position position of the new element\n */\nCreateLabelHandler.prototype.execute = function(context) {\n\n  var label = context.shape;\n\n  ensureValidDimensions(label);\n\n  label.labelTarget = context.labelTarget;\n\n  return originalExecute.call(this, context);\n};\n\nvar originalRevert = CreateShapeHandler.prototype.revert;\n\n/**\n * Undo append by removing the shape\n */\nCreateLabelHandler.prototype.revert = function(context) {\n  context.shape.labelTarget = null;\n\n  return originalRevert.call(this, context);\n};\n\n\n// helpers //////////////////////\n\nfunction ensureValidDimensions(label) {\n  // make sure a label has valid { width, height } dimensions\n  [ 'width', 'height' ].forEach(function(prop) {\n    if (typeof label[prop] === 'undefined') {\n      label[prop] = 0;\n    }\n  });\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/CreateConnectionHandler.js\nfunction CreateConnectionHandler(canvas, layouter) {\n  this._canvas = canvas;\n  this._layouter = layouter;\n}\n\nCreateConnectionHandler.$inject = [ 'canvas', 'layouter' ];\n\n\n// api //////////////////////\n\n\n/**\n * Appends a shape to a target shape\n *\n * @param {Object} context\n * @param {djs.element.Base} context.source the source object\n * @param {djs.element.Base} context.target the parent object\n * @param {Point} context.position position of the new element\n */\nCreateConnectionHandler.prototype.execute = function(context) {\n\n  var connection = context.connection,\n      source = context.source,\n      target = context.target,\n      parent = context.parent,\n      parentIndex = context.parentIndex,\n      hints = context.hints;\n\n  if (!source || !target) {\n    throw new Error('source and target required');\n  }\n\n  if (!parent) {\n    throw new Error('parent required');\n  }\n\n  connection.source = source;\n  connection.target = target;\n\n  if (!connection.waypoints) {\n    connection.waypoints = this._layouter.layoutConnection(connection, hints);\n  }\n\n  // add connection\n  this._canvas.addConnection(connection, parent, parentIndex);\n\n  return connection;\n};\n\nCreateConnectionHandler.prototype.revert = function(context) {\n  var connection = context.connection;\n\n  this._canvas.removeConnection(connection);\n\n  connection.source = null;\n  connection.target = null;\n};\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/DeleteConnectionHandler.js\n\n\n\n/**\n * A handler that implements reversible deletion of Connections.\n */\nfunction DeleteConnectionHandler(canvas, modeling) {\n  this._canvas = canvas;\n  this._modeling = modeling;\n}\n\nDeleteConnectionHandler.$inject = [\n  'canvas',\n  'modeling'\n];\n\n\nDeleteConnectionHandler.prototype.execute = function(context) {\n\n  var connection = context.connection,\n      parent = connection.parent;\n\n  context.parent = parent;\n\n  // remember containment\n  context.parentIndex = (0,Collections.indexOf)(parent.children, connection);\n\n  context.source = connection.source;\n  context.target = connection.target;\n\n  this._canvas.removeConnection(connection);\n\n  connection.source = null;\n  connection.target = null;\n\n  return connection;\n};\n\n/**\n * Command revert implementation.\n */\nDeleteConnectionHandler.prototype.revert = function(context) {\n\n  var connection = context.connection,\n      parent = context.parent,\n      parentIndex = context.parentIndex;\n\n  connection.source = context.source;\n  connection.target = context.target;\n\n  // restore containment\n  (0,Collections.add)(parent.children, connection, parentIndex);\n\n  this._canvas.addConnection(connection, parent);\n\n  return connection;\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/MoveConnectionHandler.js\n\n\n\n\n\n\n/**\n * A handler that implements reversible moving of connections.\n *\n * The handler differs from the layout connection handler in a sense\n * that it preserves the connection layout.\n */\nfunction MoveConnectionHandler() { }\n\n\nMoveConnectionHandler.prototype.execute = function(context) {\n\n  var connection = context.connection,\n      delta = context.delta;\n\n  var newParent = context.newParent || connection.parent,\n      newParentIndex = context.newParentIndex,\n      oldParent = connection.parent;\n\n  // save old parent in context\n  context.oldParent = oldParent;\n  context.oldParentIndex = (0,Collections.remove)(oldParent.children, connection);\n\n  // add to new parent at position\n  (0,Collections.add)(newParent.children, connection, newParentIndex);\n\n  // update parent\n  connection.parent = newParent;\n\n  // update waypoint positions\n  (0,index_esm/* forEach */.Ed)(connection.waypoints, function(p) {\n    p.x += delta.x;\n    p.y += delta.y;\n\n    if (p.original) {\n      p.original.x += delta.x;\n      p.original.y += delta.y;\n    }\n  });\n\n  return connection;\n};\n\nMoveConnectionHandler.prototype.revert = function(context) {\n\n  var connection = context.connection,\n      newParent = connection.parent,\n      oldParent = context.oldParent,\n      oldParentIndex = context.oldParentIndex,\n      delta = context.delta;\n\n  // remove from newParent\n  (0,Collections.remove)(newParent.children, connection);\n\n  // restore previous location in old parent\n  (0,Collections.add)(oldParent.children, connection, oldParentIndex);\n\n  // restore parent\n  connection.parent = oldParent;\n\n  // revert to old waypoint positions\n  (0,index_esm/* forEach */.Ed)(connection.waypoints, function(p) {\n    p.x -= delta.x;\n    p.y -= delta.y;\n\n    if (p.original) {\n      p.original.x -= delta.x;\n      p.original.y -= delta.y;\n    }\n  });\n\n  return connection;\n};\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/LayoutConnectionHandler.js\n\n\n\n/**\n * A handler that implements reversible moving of shapes.\n */\nfunction LayoutConnectionHandler(layouter, canvas) {\n  this._layouter = layouter;\n  this._canvas = canvas;\n}\n\nLayoutConnectionHandler.$inject = [ 'layouter', 'canvas' ];\n\nLayoutConnectionHandler.prototype.execute = function(context) {\n\n  var connection = context.connection;\n\n  var oldWaypoints = connection.waypoints;\n\n  (0,index_esm/* assign */.f0)(context, {\n    oldWaypoints: oldWaypoints\n  });\n\n  connection.waypoints = this._layouter.layoutConnection(connection, context.hints);\n\n  return connection;\n};\n\nLayoutConnectionHandler.prototype.revert = function(context) {\n\n  var connection = context.connection;\n\n  connection.waypoints = context.oldWaypoints;\n\n  return connection;\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/UpdateWaypointsHandler.js\nfunction UpdateWaypointsHandler() { }\n\nUpdateWaypointsHandler.prototype.execute = function(context) {\n\n  var connection = context.connection,\n      newWaypoints = context.newWaypoints;\n\n  context.oldWaypoints = connection.waypoints;\n\n  connection.waypoints = newWaypoints;\n\n  return connection;\n};\n\nUpdateWaypointsHandler.prototype.revert = function(context) {\n\n  var connection = context.connection,\n      oldWaypoints = context.oldWaypoints;\n\n  connection.waypoints = oldWaypoints;\n\n  return connection;\n};\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReconnectConnectionHandler.js\nvar ReconnectConnectionHandler = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReconnectConnectionHandler.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/MoveElementsHandler.js\n\n\n\n/**\n * A handler that implements reversible moving of shapes.\n */\nfunction MoveElementsHandler(modeling) {\n  this._helper = new MoveHelper(modeling);\n}\n\nMoveElementsHandler.$inject = [ 'modeling' ];\n\nMoveElementsHandler.prototype.preExecute = function(context) {\n  context.closure = this._helper.getClosure(context.shapes);\n};\n\nMoveElementsHandler.prototype.postExecute = function(context) {\n\n  var hints = context.hints,\n      primaryShape;\n\n  if (hints && hints.primaryShape) {\n    primaryShape = hints.primaryShape;\n    hints.oldParent = primaryShape.parent;\n  }\n\n  this._helper.moveClosure(\n    context.closure,\n    context.delta,\n    context.newParent,\n    context.newHost,\n    primaryShape\n  );\n};\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/DeleteElementsHandler.js\n\n\n\nfunction DeleteElementsHandler(modeling, elementRegistry) {\n  this._modeling = modeling;\n  this._elementRegistry = elementRegistry;\n}\n\nDeleteElementsHandler.$inject = [\n  'modeling',\n  'elementRegistry'\n];\n\n\nDeleteElementsHandler.prototype.postExecute = function(context) {\n\n  var modeling = this._modeling,\n      elementRegistry = this._elementRegistry,\n      elements = context.elements;\n\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n\n    // element may have been removed with previous\n    // remove operations already (e.g. in case of nesting)\n    if (!elementRegistry.get(element.id)) {\n      return;\n    }\n\n    if (element.waypoints) {\n      modeling.removeConnection(element);\n    } else {\n      modeling.removeShape(element);\n    }\n  });\n};\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/DistributeElementsHandler.js\n\n\n\n/**\n * A handler that distributes elements evenly.\n */\nfunction DistributeElements(modeling) {\n  this._modeling = modeling;\n}\n\nDistributeElements.$inject = [ 'modeling' ];\n\nvar OFF_AXIS = {\n  x: 'y',\n  y: 'x'\n};\n\nDistributeElements.prototype.preExecute = function(context) {\n  var modeling = this._modeling;\n\n  var groups = context.groups,\n      axis = context.axis,\n      dimension = context.dimension;\n\n  function updateRange(group, element) {\n    group.range.min = Math.min(element[axis], group.range.min);\n    group.range.max = Math.max(element[axis] + element[dimension], group.range.max);\n  }\n\n  function center(element) {\n    return element[axis] + element[dimension] / 2;\n  }\n\n  function lastIdx(arr) {\n    return arr.length - 1;\n  }\n\n  function rangeDiff(range) {\n    return range.max - range.min;\n  }\n\n  function centerElement(refCenter, element) {\n    var delta = { y: 0 };\n\n    delta[axis] = refCenter - center(element);\n\n    if (delta[axis]) {\n\n      delta[OFF_AXIS[axis]] = 0;\n\n      modeling.moveElements([ element ], delta, element.parent);\n    }\n  }\n\n  var firstGroup = groups[0],\n      lastGroupIdx = lastIdx(groups),\n      lastGroup = groups[ lastGroupIdx ];\n\n  var margin,\n      spaceInBetween,\n      groupsSize = 0; // the size of each range\n\n  (0,index_esm/* forEach */.Ed)(groups, function(group, idx) {\n    var sortedElements,\n        refElem,\n        refCenter;\n\n    if (group.elements.length < 2) {\n      if (idx && idx !== groups.length - 1) {\n        updateRange(group, group.elements[0]);\n\n        groupsSize += rangeDiff(group.range);\n      }\n      return;\n    }\n\n    sortedElements = (0,index_esm/* sortBy */.MR)(group.elements, axis);\n\n    refElem = sortedElements[0];\n\n    if (idx === lastGroupIdx) {\n      refElem = sortedElements[lastIdx(sortedElements)];\n    }\n\n    refCenter = center(refElem);\n\n    // wanna update the ranges after the shapes have been centered\n    group.range = null;\n\n    (0,index_esm/* forEach */.Ed)(sortedElements, function(element) {\n\n      centerElement(refCenter, element);\n\n      if (group.range === null) {\n        group.range = {\n          min: element[axis],\n          max: element[axis] + element[dimension]\n        };\n\n        return;\n      }\n\n      // update group's range after centering the range elements\n      updateRange(group, element);\n    });\n\n    if (idx && idx !== groups.length - 1) {\n      groupsSize += rangeDiff(group.range);\n    }\n  });\n\n  spaceInBetween = Math.abs(lastGroup.range.min - firstGroup.range.max);\n\n  margin = Math.round((spaceInBetween - groupsSize) / (groups.length - 1));\n\n  if (margin < groups.length - 1) {\n    return;\n  }\n\n  (0,index_esm/* forEach */.Ed)(groups, function(group, groupIdx) {\n    var delta = {},\n        prevGroup;\n\n    if (group === firstGroup || group === lastGroup) {\n      return;\n    }\n\n    prevGroup = groups[groupIdx - 1];\n\n    group.range.max = 0;\n\n    (0,index_esm/* forEach */.Ed)(group.elements, function(element, idx) {\n      delta[OFF_AXIS[axis]] = 0;\n      delta[axis] = (prevGroup.range.max - element[axis]) + margin;\n\n      if (group.range.min !== element[axis]) {\n        delta[axis] += element[axis] - group.range.min;\n      }\n\n      if (delta[axis]) {\n        modeling.moveElements([ element ], delta, element.parent);\n      }\n\n      group.range.max = Math.max(element[axis] + element[dimension], idx ? group.range.max : 0);\n    });\n  });\n};\n\nDistributeElements.prototype.postExecute = function(context) {\n\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/AlignElementsHandler.js\n\n\n/**\n * A handler that align elements in a certain way.\n *\n */\nfunction AlignElements(modeling, canvas) {\n  this._modeling = modeling;\n  this._canvas = canvas;\n}\n\nAlignElements.$inject = [ 'modeling', 'canvas' ];\n\n\nAlignElements.prototype.preExecute = function(context) {\n  var modeling = this._modeling;\n\n  var elements = context.elements,\n      alignment = context.alignment;\n\n\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n    var delta = {\n      x: 0,\n      y: 0\n    };\n\n    if (alignment.left) {\n      delta.x = alignment.left - element.x;\n\n    } else if (alignment.right) {\n      delta.x = (alignment.right - element.width) - element.x;\n\n    } else if (alignment.center) {\n      delta.x = (alignment.center - Math.round(element.width / 2)) - element.x;\n\n    } else if (alignment.top) {\n      delta.y = alignment.top - element.y;\n\n    } else if (alignment.bottom) {\n      delta.y = (alignment.bottom - element.height) - element.y;\n\n    } else if (alignment.middle) {\n      delta.y = (alignment.middle - Math.round(element.height / 2)) - element.y;\n    }\n\n    modeling.moveElements([ element ], delta, element.parent);\n  });\n};\n\nAlignElements.prototype.postExecute = function(context) {\n\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/UpdateAttachmentHandler.js\n\n\n/**\n * A handler that implements reversible attaching/detaching of shapes.\n */\nfunction UpdateAttachmentHandler(modeling) {\n  this._modeling = modeling;\n}\n\nUpdateAttachmentHandler.$inject = [ 'modeling' ];\n\n\nUpdateAttachmentHandler.prototype.execute = function(context) {\n  var shape = context.shape,\n      newHost = context.newHost,\n      oldHost = shape.host;\n\n  // (0) detach from old host\n  context.oldHost = oldHost;\n  context.attacherIdx = removeAttacher(oldHost, shape);\n\n  // (1) attach to new host\n  addAttacher(newHost, shape);\n\n  // (2) update host\n  shape.host = newHost;\n\n  return shape;\n};\n\nUpdateAttachmentHandler.prototype.revert = function(context) {\n  var shape = context.shape,\n      newHost = context.newHost,\n      oldHost = context.oldHost,\n      attacherIdx = context.attacherIdx;\n\n  // (2) update host\n  shape.host = oldHost;\n\n  // (1) attach to new host\n  removeAttacher(newHost, shape);\n\n  // (0) detach from old host\n  addAttacher(oldHost, shape, attacherIdx);\n\n  return shape;\n};\n\n\nfunction removeAttacher(host, attacher) {\n  // remove attacher from host\n  return (0,Collections.remove)(host && host.attachers, attacher);\n}\n\nfunction addAttacher(host, attacher, idx) {\n\n  if (!host) {\n    return;\n  }\n\n  var attachers = host.attachers;\n\n  if (!attachers) {\n    host.attachers = attachers = [];\n  }\n\n  (0,Collections.add)(attachers, attacher, idx);\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/PasteHandler.js\n\n\nfunction removeProperties(element, properties) {\n  (0,index_esm/* forEach */.Ed)(properties, function(prop) {\n    if (element[prop]) {\n      delete element[prop];\n    }\n  });\n}\n\n/**\n * A handler that implements pasting of elements onto the diagram.\n *\n * @param {eventBus} EventBus\n * @param {canvas} Canvas\n * @param {selection} Selection\n * @param {elementFactory} ElementFactory\n * @param {modeling} Modeling\n * @param {rules} Rules\n */\nfunction PasteHandler(\n    eventBus, canvas, selection,\n    elementFactory, modeling, rules) {\n\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n  this._selection = selection;\n  this._elementFactory = elementFactory;\n  this._modeling = modeling;\n  this._rules = rules;\n}\n\n\nPasteHandler.$inject = [\n  'eventBus',\n  'canvas',\n  'selection',\n  'elementFactory',\n  'modeling',\n  'rules'\n];\n\n\n// api //////////////////////\n\n/**\n * Creates a new shape\n *\n * @param {Object} context\n * @param {Object} context.tree the new shape\n * @param {Element} context.topParent the paste target\n */\nPasteHandler.prototype.preExecute = function(context) {\n  var eventBus = this._eventBus,\n      self = this;\n\n  var tree = context.tree,\n      topParent = context.topParent,\n      position = context.position;\n\n  tree.createdElements = {};\n\n  tree.labels = [];\n\n  (0,index_esm/* forEach */.Ed)(tree, function(elements, depthStr) {\n    var depth = parseInt(depthStr, 10);\n\n    if (isNaN(depth)) {\n      return;\n    }\n\n    // set the parent on the top level elements\n    if (!depth) {\n      elements = (0,index_esm/* map */.UI)(elements, function(descriptor) {\n        descriptor.parent = topParent;\n\n        return descriptor;\n      });\n    }\n\n    // Order by priority for element creation\n    elements = (0,index_esm/* sortBy */.MR)(elements, 'priority');\n\n    (0,index_esm/* forEach */.Ed)(elements, function(descriptor) {\n      var id = descriptor.id,\n          parent = descriptor.parent,\n          hints = {},\n          newPosition;\n\n      var element = (0,index_esm/* assign */.f0)({}, descriptor);\n\n      if (depth) {\n        element.parent = self._getCreatedElement(parent, tree);\n      }\n\n      // this happens when shapes have not been created due to rules\n      if (!parent) {\n        return;\n      }\n\n      eventBus.fire('element.paste', {\n        createdElements: tree.createdElements,\n        descriptor: element\n      });\n\n      // in case the parent changed during 'element.paste'\n      parent = element.parent;\n\n      if (element.waypoints) {\n        element = self._createConnection(element, parent, position, tree);\n\n        if (element) {\n          tree.createdElements[id] = {\n            element: element,\n            descriptor: descriptor\n          };\n        }\n\n        return;\n      }\n\n\n      // supply not-root information as hint\n      if (element.parent !== topParent) {\n        hints.root = false;\n      }\n\n      // set host\n      if (element.host) {\n        hints.attach = true;\n\n        parent = self._getCreatedElement(element.host, tree);\n      }\n\n      // handle labels\n      if (element.labelTarget) {\n        return tree.labels.push(element);\n      }\n\n      newPosition = {\n        x: Math.round(position.x + element.delta.x + (element.width / 2)),\n        y: Math.round(position.y + element.delta.y + (element.height / 2))\n      };\n\n      removeProperties(element, [\n        'id',\n        'parent',\n        'delta',\n        'host',\n        'priority'\n      ]);\n\n      element = self._createShape(element, parent, newPosition, hints);\n\n      if (element) {\n        tree.createdElements[id] = {\n          element: element,\n          descriptor: descriptor\n        };\n      }\n    });\n  });\n};\n\n// move label's to their relative position\nPasteHandler.prototype.postExecute = function(context) {\n  var modeling = this._modeling,\n      selection = this._selection,\n      self = this;\n\n  var tree = context.tree,\n      labels = tree.labels,\n      topLevelElements = [];\n\n  (0,index_esm/* forEach */.Ed)(labels, function(labelDescriptor) {\n    var labelTarget = self._getCreatedElement(labelDescriptor.labelTarget, tree),\n        labels, labelTargetPos, newPosition;\n\n    if (!labelTarget) {\n      return;\n    }\n\n    labels = labelTarget.labels;\n\n    if (!labels || !labels.length) {\n      return;\n    }\n\n    labelTargetPos = {\n      x: labelTarget.x,\n      y: labelTarget.y\n    };\n\n    if (labelTarget.waypoints) {\n      labelTargetPos = labelTarget.waypoints[0];\n    }\n\n    (0,index_esm/* forEach */.Ed)(labels, function(label) {\n      newPosition = {\n        x: Math.round((labelTargetPos.x - label.x) + labelDescriptor.delta.x),\n        y: Math.round((labelTargetPos.y - label.y) + labelDescriptor.delta.y)\n      };\n\n      modeling.moveShape(label, newPosition, labelTarget.parent);\n    });\n  });\n\n  (0,index_esm/* forEach */.Ed)(tree[0], function(descriptor) {\n    var id = descriptor.id,\n        toplevel = tree.createdElements[id];\n\n    if (toplevel) {\n      topLevelElements.push(toplevel.element);\n    }\n  });\n\n  selection.select(topLevelElements);\n};\n\n\nPasteHandler.prototype._createConnection = function(element, parent, parentCenter, tree) {\n  var modeling = this._modeling,\n      rules = this._rules;\n\n  var connection, source, target, canPaste;\n\n  element.waypoints = (0,index_esm/* map */.UI)(element.waypoints, function(waypoint, idx) {\n    return {\n      x: Math.round(parentCenter.x + element.delta[idx].x),\n      y: Math.round(parentCenter.y + element.delta[idx].y)\n    };\n  });\n\n  source = this._getCreatedElement(element.source, tree);\n  target = this._getCreatedElement(element.target, tree);\n\n  if (!source || !target) {\n    return null;\n  }\n\n  canPaste = rules.allowed('element.paste', {\n    source: source,\n    target: target\n  });\n\n  if (!canPaste) {\n    return null;\n  }\n\n  removeProperties(element, [\n    'id',\n    'parent',\n    'delta',\n    'source',\n    'target',\n    'width',\n    'height',\n    'priority'\n  ]);\n\n  connection = modeling.createConnection(source, target, element, parent);\n\n  return connection;\n};\n\n\nPasteHandler.prototype._createShape = function(element, parent, position, isAttach, hints) {\n  var modeling = this._modeling,\n      elementFactory = this._elementFactory,\n      rules = this._rules;\n\n  var canPaste = rules.allowed('element.paste', {\n    element: element,\n    position: position,\n    parent: parent\n  });\n\n  if (!canPaste) {\n    return null;\n  }\n\n  var shape = elementFactory.createShape(element);\n\n  modeling.createShape(shape, position, parent, isAttach, hints);\n\n  return shape;\n};\n\n\nPasteHandler.prototype._getCreatedElement = function(id, tree) {\n  return tree.createdElements[id] && tree.createdElements[id].element;\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/Modeling.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * The basic modeling entry point.\n *\n * @param {EventBus} eventBus\n * @param {ElementFactory} elementFactory\n * @param {CommandStack} commandStack\n */\nfunction Modeling(eventBus, elementFactory, commandStack) {\n  this._eventBus = eventBus;\n  this._elementFactory = elementFactory;\n  this._commandStack = commandStack;\n\n  var self = this;\n\n  eventBus.on('diagram.init', function() {\n    // register modeling handlers\n    self.registerHandlers(commandStack);\n  });\n}\n\nModeling.$inject = [ 'eventBus', 'elementFactory', 'commandStack' ];\n\n\nModeling.prototype.getHandlers = function() {\n  return {\n    'shape.append': AppendShapeHandler/* default */.Z,\n    'shape.create': CreateShapeHandler,\n    'shape.delete': DeleteShapeHandler,\n    'shape.move': MoveShapeHandler,\n    'shape.resize': ResizeShapeHandler,\n    'shape.replace': ReplaceShapeHandler/* default */.Z,\n    'shape.toggleCollapse': ToggleShapeCollapseHandler,\n\n    'spaceTool': SpaceToolHandler,\n\n    'label.create': CreateLabelHandler,\n\n    'connection.create': CreateConnectionHandler,\n    'connection.delete': DeleteConnectionHandler,\n    'connection.move': MoveConnectionHandler,\n    'connection.layout': LayoutConnectionHandler,\n\n    'connection.updateWaypoints': UpdateWaypointsHandler,\n\n    'connection.reconnectStart': ReconnectConnectionHandler/* default */.Z,\n    'connection.reconnectEnd': ReconnectConnectionHandler/* default */.Z,\n\n    'elements.move': MoveElementsHandler,\n    'elements.delete': DeleteElementsHandler,\n\n    'elements.distribute': DistributeElements,\n    'elements.align': AlignElements,\n\n    'element.updateAttachment': UpdateAttachmentHandler,\n\n    'elements.paste': PasteHandler\n  };\n};\n\n/**\n * Register handlers with the command stack\n *\n * @param {CommandStack} commandStack\n */\nModeling.prototype.registerHandlers = function(commandStack) {\n  (0,index_esm/* forEach */.Ed)(this.getHandlers(), function(handler, id) {\n    commandStack.registerHandler(id, handler);\n  });\n};\n\n\n// modeling helpers //////////////////////\n\nModeling.prototype.moveShape = function(shape, delta, newParent, newParentIndex, hints) {\n\n  if (typeof newParentIndex === 'object') {\n    hints = newParentIndex;\n    newParentIndex = null;\n  }\n\n  var context = {\n    shape: shape,\n    delta:  delta,\n    newParent: newParent,\n    newParentIndex: newParentIndex,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('shape.move', context);\n};\n\n\n/**\n * Update the attachment of the given shape.\n *\n * @param {djs.mode.Base} shape\n * @param {djs.model.Base} [newHost]\n */\nModeling.prototype.updateAttachment = function(shape, newHost) {\n  var context = {\n    shape: shape,\n    newHost: newHost\n  };\n\n  this._commandStack.execute('element.updateAttachment', context);\n};\n\n\n/**\n * Move a number of shapes to a new target, either setting it as\n * the new parent or attaching it.\n *\n * @param {Array<djs.mode.Base>} shapes\n * @param {Point} delta\n * @param {djs.model.Base} [target]\n * @param {Object} [hints]\n * @param {Boolean} [hints.attach=false]\n */\nModeling.prototype.moveElements = function(shapes, delta, target, hints) {\n\n  hints = hints || {};\n\n  var attach = hints.attach;\n\n  var newParent = target,\n      newHost;\n\n  if (attach === true) {\n    newHost = target;\n    newParent = target.parent;\n  } else\n\n  if (attach === false) {\n    newHost = null;\n  }\n\n  var context = {\n    shapes: shapes,\n    delta: delta,\n    newParent: newParent,\n    newHost: newHost,\n    hints: hints\n  };\n\n  this._commandStack.execute('elements.move', context);\n};\n\n\nModeling.prototype.moveConnection = function(connection, delta, newParent, newParentIndex, hints) {\n\n  if (typeof newParentIndex === 'object') {\n    hints = newParentIndex;\n    newParentIndex = undefined;\n  }\n\n  var context = {\n    connection: connection,\n    delta: delta,\n    newParent: newParent,\n    newParentIndex: newParentIndex,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.move', context);\n};\n\n\nModeling.prototype.layoutConnection = function(connection, hints) {\n  var context = {\n    connection: connection,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.layout', context);\n};\n\n\n/**\n * Create connection.\n *\n * @param {djs.model.Base} source\n * @param {djs.model.Base} target\n * @param {Number} [targetIndex]\n * @param {Object|djs.model.Connection} connection\n * @param {djs.model.Base} parent\n * @param {Object} hints\n *\n * @return {djs.model.Connection} the created connection.\n */\nModeling.prototype.createConnection = function(source, target, parentIndex, connection, parent, hints) {\n\n  if (typeof parentIndex === 'object') {\n    hints = parent;\n    parent = connection;\n    connection = parentIndex;\n    parentIndex = undefined;\n  }\n\n  connection = this._create('connection', connection);\n\n  var context = {\n    source: source,\n    target: target,\n    parent: parent,\n    parentIndex: parentIndex,\n    connection: connection,\n    hints: hints\n  };\n\n  this._commandStack.execute('connection.create', context);\n\n  return context.connection;\n};\n\n\n/**\n * Create a shape at the specified position.\n *\n * @param {djs.model.Shape|Object} shape\n * @param {Point} position\n * @param {djs.model.Shape|djs.model.Root} target\n * @param {Number} [parentIndex] position in parents children list\n * @param {Object} [hints]\n * @param {Boolean} [hints.attach] whether to attach to target or become a child\n *\n * @return {djs.model.Shape} the created shape\n */\nModeling.prototype.createShape = function(shape, position, target, parentIndex, hints) {\n\n  if (typeof parentIndex !== 'number') {\n    hints = parentIndex;\n    parentIndex = undefined;\n  }\n\n  hints = hints || {};\n\n  var attach = hints.attach,\n      parent,\n      host;\n\n  shape = this._create('shape', shape);\n\n  if (attach) {\n    parent = target.parent;\n    host = target;\n  } else {\n    parent = target;\n  }\n\n  var context = {\n    position: position,\n    shape: shape,\n    parent: parent,\n    parentIndex: parentIndex,\n    host: host,\n    hints: hints\n  };\n\n  this._commandStack.execute('shape.create', context);\n\n  return context.shape;\n};\n\n\nModeling.prototype.createLabel = function(labelTarget, position, label, parent) {\n\n  label = this._create('label', label);\n\n  var context = {\n    labelTarget: labelTarget,\n    position: position,\n    parent: parent || labelTarget.parent,\n    shape: label\n  };\n\n  this._commandStack.execute('label.create', context);\n\n  return context.shape;\n};\n\n\n/**\n * Append shape to given source, drawing a connection\n * between source and the newly created shape.\n *\n * @param {djs.model.Shape} source\n * @param {djs.model.Shape|Object} shape\n * @param {Point} position\n * @param {djs.model.Shape} target\n * @param {Object} [hints]\n * @param {Boolean} [hints.attach]\n * @param {djs.model.Connection|Object} [hints.connection]\n * @param {djs.model.Base} [hints.connectionParent]\n *\n * @return {djs.model.Shape} the newly created shape\n */\nModeling.prototype.appendShape = function(source, shape, position, target, hints) {\n\n  hints = hints || {};\n\n  shape = this._create('shape', shape);\n\n  var context = {\n    source: source,\n    position: position,\n    target: target,\n    shape: shape,\n    connection: hints.connection,\n    connectionParent: hints.connectionParent,\n    attach: hints.attach\n  };\n\n  this._commandStack.execute('shape.append', context);\n\n  return context.shape;\n};\n\n\nModeling.prototype.removeElements = function(elements) {\n  var context = {\n    elements: elements\n  };\n\n  this._commandStack.execute('elements.delete', context);\n};\n\n\nModeling.prototype.distributeElements = function(groups, axis, dimension) {\n  var context = {\n    groups: groups,\n    axis: axis,\n    dimension: dimension\n  };\n\n  this._commandStack.execute('elements.distribute', context);\n};\n\n\nModeling.prototype.removeShape = function(shape, hints) {\n  var context = {\n    shape: shape,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('shape.delete', context);\n};\n\n\nModeling.prototype.removeConnection = function(connection, hints) {\n  var context = {\n    connection: connection,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.delete', context);\n};\n\nModeling.prototype.replaceShape = function(oldShape, newShape, hints) {\n  var context = {\n    oldShape: oldShape,\n    newData: newShape,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('shape.replace', context);\n\n  return context.newShape;\n};\n\nModeling.prototype.pasteElements = function(tree, topParent, position) {\n  var context = {\n    tree: tree,\n    topParent: topParent,\n    position: position\n  };\n\n  this._commandStack.execute('elements.paste', context);\n};\n\nModeling.prototype.alignElements = function(elements, alignment) {\n  var context = {\n    elements: elements,\n    alignment: alignment\n  };\n\n  this._commandStack.execute('elements.align', context);\n};\n\nModeling.prototype.resizeShape = function(shape, newBounds, minBounds, hints) {\n  var context = {\n    shape: shape,\n    newBounds: newBounds,\n    minBounds: minBounds,\n    hints: hints\n  };\n\n  this._commandStack.execute('shape.resize', context);\n};\n\nModeling.prototype.createSpace = function(movingShapes, resizingShapes, delta, direction) {\n  var context = {\n    movingShapes: movingShapes,\n    resizingShapes: resizingShapes,\n    delta: delta,\n    direction: direction\n  };\n\n  this._commandStack.execute('spaceTool', context);\n};\n\nModeling.prototype.updateWaypoints = function(connection, newWaypoints, hints) {\n  var context = {\n    connection: connection,\n    newWaypoints: newWaypoints,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.updateWaypoints', context);\n};\n\nModeling.prototype.reconnectStart = function(connection, newSource, dockingOrPoints, hints) {\n  var context = {\n    connection: connection,\n    newSource: newSource,\n    dockingOrPoints: dockingOrPoints,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.reconnectStart', context);\n};\n\nModeling.prototype.reconnectEnd = function(connection, newTarget, dockingOrPoints, hints) {\n  var context = {\n    connection: connection,\n    newTarget: newTarget,\n    dockingOrPoints: dockingOrPoints,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('connection.reconnectEnd', context);\n};\n\nModeling.prototype.connect = function(source, target, attrs, hints) {\n  return this.createConnection(source, target, attrs || {}, source.parent, hints);\n};\n\nModeling.prototype._create = function(type, attrs) {\n  if (attrs instanceof model.Base) {\n    return attrs;\n  } else {\n    return this._elementFactory.create(type, attrs);\n  }\n};\n\nModeling.prototype.toggleCollapse = function(shape, hints) {\n  var context = {\n    shape: shape,\n    hints: hints || {}\n  };\n\n  this._commandStack.execute('shape.toggleCollapse', context);\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/Modeling.js_+_21_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/AppendShapeHandler.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ AppendShapeHandler)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n\n\n\n/**\n * A handler that implements reversible appending of shapes\n * to a source shape.\n *\n * @param {canvas} Canvas\n * @param {elementFactory} ElementFactory\n * @param {modeling} Modeling\n */\nfunction AppendShapeHandler(modeling) {\n  this._modeling = modeling;\n}\n\nAppendShapeHandler.$inject = [ 'modeling' ];\n\n\n// api //////////////////////\n\n\n/**\n * Creates a new shape\n *\n * @param {Object} context\n * @param {ElementDescriptor} context.shape the new shape\n * @param {ElementDescriptor} context.source the source object\n * @param {ElementDescriptor} context.parent the parent object\n * @param {Point} context.position position of the new element\n */\nAppendShapeHandler.prototype.preExecute = function(context) {\n\n  var source = context.source;\n\n  if (!source) {\n    throw new Error('source required');\n  }\n\n  var target = context.target || source.parent,\n      shape = context.shape;\n\n  shape = context.shape =\n    this._modeling.createShape(\n      shape,\n      context.position,\n      target, { attach: context.attach });\n\n  context.shape = shape;\n};\n\nAppendShapeHandler.prototype.postExecute = function(context) {\n  var parent = context.connectionParent || context.shape.parent;\n\n  if (!existsConnection(context.source, context.shape)) {\n\n    // create connection\n    this._modeling.connect(context.source, context.shape, context.connection, parent);\n  }\n};\n\n\nfunction existsConnection(source, target) {\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .some */ .G)(source.outgoing, function(c) {\n    return c.target === target;\n  });\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/AppendShapeHandler.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReconnectConnectionHandler.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ ReconnectConnectionHandler)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n\n\n\n/**\n * Reconnect connection handler\n */\nfunction ReconnectConnectionHandler(modeling) {\n  this._modeling = modeling;\n}\n\nReconnectConnectionHandler.$inject = [ 'modeling' ];\n\nReconnectConnectionHandler.prototype.execute = function(context) {\n\n  var newSource = context.newSource,\n      newTarget = context.newTarget,\n      connection = context.connection,\n      dockingOrPoints = context.dockingOrPoints;\n\n  if (!newSource && !newTarget) {\n    throw new Error('newSource or newTarget are required');\n  }\n\n  if (newSource && newTarget) {\n    throw new Error('must specify either newSource or newTarget');\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(dockingOrPoints)) {\n    context.oldWaypoints = connection.waypoints;\n    connection.waypoints = dockingOrPoints;\n  }\n\n  if (newSource) {\n    context.oldSource = connection.source;\n    connection.source = newSource;\n  }\n\n  if (newTarget) {\n    context.oldTarget = connection.target;\n    connection.target = newTarget;\n  }\n\n  return connection;\n};\n\nReconnectConnectionHandler.prototype.postExecute = function(context) {\n  var connection = context.connection,\n      dockingOrPoints = context.dockingOrPoints,\n      newSource = context.newSource,\n      movedEnd = newSource ? 'connectionStart' : 'connectionEnd',\n      newWaypoint,\n      hints = context.hints,\n      layoutHints = {};\n\n  if (hints.layoutConnection === false) {\n    return;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(dockingOrPoints)) {\n    newWaypoint = newSource ? dockingOrPoints[0] : dockingOrPoints[dockingOrPoints.length - 1];\n  } else {\n    newWaypoint = dockingOrPoints;\n  }\n\n  layoutHints[movedEnd] = getDocking(newWaypoint);\n\n  this._modeling.layoutConnection(connection, layoutHints);\n};\n\nReconnectConnectionHandler.prototype.revert = function(context) {\n\n  var oldSource = context.oldSource,\n      oldTarget = context.oldTarget,\n      oldWaypoints = context.oldWaypoints,\n      connection = context.connection;\n\n  if (oldSource) {\n    connection.source = oldSource;\n  }\n\n  if (oldTarget) {\n    connection.target = oldTarget;\n  }\n\n  if (oldWaypoints) {\n    connection.waypoints = oldWaypoints;\n  }\n\n  return connection;\n};\n\n\n\n// helper ///////////////\n\nfunction getDocking(point) {\n  return point.original || point;\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReconnectConnectionHandler.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReplaceShapeHandler.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ ReplaceShapeHandler)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n\n\n\n/**\n * A handler that implements reversible replacing of shapes.\n * Internally the old shape will be removed and the new shape will be added.\n *\n *\n * @class\n * @constructor\n *\n * @param {canvas} Canvas\n */\nfunction ReplaceShapeHandler(modeling, rules) {\n  this._modeling = modeling;\n  this._rules = rules;\n}\n\nReplaceShapeHandler.$inject = [ 'modeling', 'rules' ];\n\n\n// api //////////////////////\n\n\n/**\n * Replaces a shape with an replacement Element.\n *\n * The newData object should contain type, x, y.\n *\n * If possible also the incoming/outgoing connection\n * will be restored.\n *\n * @param {Object} context\n */\nReplaceShapeHandler.prototype.preExecute = function(context) {\n\n  var self = this,\n      modeling = this._modeling,\n      rules = this._rules;\n\n  var oldShape = context.oldShape,\n      newData = context.newData,\n      hints = context.hints,\n      newShape;\n\n  function canReconnect(type, source, target, connection) {\n    return rules.allowed(type, {\n      source: source,\n      target: target,\n      connection: connection\n    });\n  }\n\n\n  // (1) place a new shape at the given position\n\n  var position = {\n    x: newData.x,\n    y: newData.y\n  };\n\n  newShape = context.newShape =\n    context.newShape ||\n    self.createShape(newData, position, oldShape.parent, hints);\n\n\n  // (2) update the host\n\n  if (oldShape.host) {\n    modeling.updateAttachment(newShape, oldShape.host);\n  }\n\n\n  // (3) adopt all children from the old shape\n\n  var children;\n\n  if (hints.moveChildren !== false) {\n    children = oldShape.children.slice();\n\n    modeling.moveElements(children, { x: 0, y: 0 }, newShape);\n  }\n\n  // (4) reconnect connections to the new shape (where allowed)\n\n  var incoming = oldShape.incoming.slice(),\n      outgoing = oldShape.outgoing.slice();\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(incoming, function(connection) {\n    var waypoints = connection.waypoints,\n        docking = waypoints[waypoints.length - 1],\n        source = connection.source,\n        allowed = canReconnect('connection.reconnectEnd', source, newShape, connection);\n\n    if (allowed) {\n      self.reconnectEnd(connection, newShape, docking, { layoutConnection: hints.layoutConnection });\n    }\n  });\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(outgoing, function(connection) {\n    var waypoints = connection.waypoints,\n        docking = waypoints[0],\n        target = connection.target,\n        allowed = canReconnect('connection.reconnectStart', newShape, target, connection);\n\n    if (allowed) {\n      self.reconnectStart(connection, newShape, docking, { layoutConnection: hints.layoutConnection });\n    }\n\n  });\n};\n\n\nReplaceShapeHandler.prototype.postExecute = function(context) {\n  var modeling = this._modeling;\n\n  var oldShape = context.oldShape,\n      newShape = context.newShape,\n      layoutConnection = context.hints.layoutConnection;\n\n  // do not layout if explicitly excluded\n  if (layoutConnection !== false) {\n    (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(newShape.incoming, function(c) {\n      modeling.layoutConnection(c, { endChanged: true });\n    });\n\n    (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(newShape.outgoing, function(c) {\n      modeling.layoutConnection(c, { startChanged: true });\n    });\n  }\n\n  modeling.removeShape(oldShape);\n};\n\n\nReplaceShapeHandler.prototype.execute = function(context) {};\n\nReplaceShapeHandler.prototype.revert = function(context) {};\n\n\nReplaceShapeHandler.prototype.createShape = function(shape, position, target, hints) {\n  return this._modeling.createShape(shape, position, target, hints);\n};\n\n\nReplaceShapeHandler.prototype.reconnectStart = function(connection, newSource, dockingPoint, hints) {\n  this._modeling.reconnectStart(connection, newSource, dockingPoint, hints);\n};\n\n\nReplaceShapeHandler.prototype.reconnectEnd = function(connection, newTarget, dockingPoint, hints) {\n  this._modeling.reconnectEnd(connection, newTarget, dockingPoint, hints);\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/modeling/cmd/ReplaceShapeHandler.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/move/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ move)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/index.js\nvar outline = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js + 2 modules\nvar dragging = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/index.js + 1 modules\nvar preview_support = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/move/Move.js\n\n\nvar LOW_PRIORITY = 500,\n    MEDIUM_PRIORITY = 1250,\n    HIGH_PRIORITY = 1500;\n\n\n\nvar round = Math.round;\n\nfunction mid(element) {\n  return {\n    x: element.x + round(element.width / 2),\n    y: element.y + round(element.height / 2)\n  };\n}\n\n/**\n * A plugin that makes shapes draggable / droppable.\n *\n * @param {EventBus} eventBus\n * @param {Dragging} dragging\n * @param {Modeling} modeling\n * @param {Selection} selection\n * @param {Rules} rules\n */\nfunction MoveEvents(\n    eventBus, dragging, modeling,\n    selection, rules) {\n\n  // rules\n\n  function canMove(shapes, delta, position, target) {\n\n    return rules.allowed('elements.move', {\n      shapes: shapes,\n      delta: delta,\n      position: position,\n      target: target\n    });\n  }\n\n\n  // move events\n\n  // assign a high priority to this handler to setup the environment\n  // others may hook up later, e.g. at default priority and modify\n  // the move environment.\n  //\n  // This sets up the context with\n  //\n  // * shape: the primary shape being moved\n  // * shapes: a list of shapes to be moved\n  // * validatedShapes: a list of shapes that are being checked\n  //                    against the rules before and during move\n  //\n  eventBus.on('shape.move.start', HIGH_PRIORITY, function(event) {\n\n    var context = event.context,\n        shape = event.shape,\n        shapes = selection.get().slice();\n\n    // move only single shape if the dragged element\n    // is not part of the current selection\n    if (shapes.indexOf(shape) === -1) {\n      shapes = [ shape ];\n    }\n\n    // ensure we remove nested elements in the collection\n    // and add attachers for a proper dragger\n    shapes = removeNested(shapes);\n\n    // attach shapes to drag context\n    (0,index_esm/* assign */.f0)(context, {\n      shapes: shapes,\n      validatedShapes: shapes,\n      shape: shape\n    });\n  });\n\n\n  // assign a high priority to this handler to setup the environment\n  // others may hook up later, e.g. at default priority and modify\n  // the move environment\n  //\n  eventBus.on('shape.move.start', MEDIUM_PRIORITY, function(event) {\n\n    var context = event.context,\n        validatedShapes = context.validatedShapes,\n        canExecute;\n\n    canExecute = context.canExecute = canMove(validatedShapes);\n\n    // check if we can move the elements\n    if (!canExecute) {\n      return false;\n    }\n  });\n\n  // assign a low priority to this handler\n  // to let others modify the move event before we update\n  // the context\n  //\n  eventBus.on('shape.move.move', LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        validatedShapes = context.validatedShapes,\n        hover = event.hover,\n        delta = { x: event.dx, y: event.dy },\n        position = { x: event.x, y: event.y },\n        canExecute;\n\n    // check if we can move the elements\n    canExecute = canMove(validatedShapes, delta, position, hover);\n\n    context.delta = delta;\n    context.canExecute = canExecute;\n\n    // simply ignore move over\n    if (canExecute === null) {\n      context.target = null;\n\n      return;\n    }\n\n    context.target = hover;\n  });\n\n  eventBus.on('shape.move.end', function(event) {\n\n    var context = event.context;\n\n    var delta = context.delta,\n        canExecute = context.canExecute,\n        isAttach = canExecute === 'attach',\n        shapes = context.shapes;\n\n    if (canExecute === false) {\n      return false;\n    }\n\n    // ensure we have actual pixel values deltas\n    // (important when zoom level was > 1 during move)\n    delta.x = round(delta.x);\n    delta.y = round(delta.y);\n\n    if (delta.x === 0 && delta.y === 0) {\n\n      // didn't move\n      return;\n    }\n\n    modeling.moveElements(shapes, delta, context.target, {\n      primaryShape: context.shape,\n      attach: isAttach\n    });\n  });\n\n\n  // move activation\n\n  eventBus.on('element.mousedown', function(event) {\n\n    var originalEvent = (0,Event/* getOriginal */.Ku)(event);\n\n    if (!originalEvent) {\n      throw new Error('must supply DOM mousedown event');\n    }\n\n    return start(originalEvent, event.element);\n  });\n\n  /**\n   * Start move.\n   *\n   * @param {MouseEvent} event\n   * @param {djs.model.Shape} shape\n   * @param {boolean} [activate]\n   * @param {Object} [context]\n   */\n  function start(event, element, activate, context) {\n    if ((0,index_esm/* isObject */.Kn)(activate)) {\n      context = activate;\n      activate = false;\n    }\n\n    // do not move connections or the root element\n    if (element.waypoints || !element.parent) {\n      return;\n    }\n\n    var referencePoint = mid(element);\n\n    dragging.init(event, referencePoint, 'shape.move', {\n      cursor: 'grabbing',\n      autoActivate: activate,\n      data: {\n        shape: element,\n        context: context || {}\n      }\n    });\n\n    // we've handled the event\n    return true;\n  }\n\n  // API\n\n  this.start = start;\n}\n\nMoveEvents.$inject = [\n  'eventBus',\n  'dragging',\n  'modeling',\n  'selection',\n  'rules'\n];\n\n\n/**\n * Return a filtered list of elements that do not contain\n * those nested into others.\n *\n * @param  {Array<djs.model.Base>} elements\n *\n * @return {Array<djs.model.Base>} filtered\n */\nfunction removeNested(elements) {\n\n  var ids = (0,index_esm/* groupBy */.vM)(elements, 'id');\n\n  return (0,index_esm/* filter */.hX)(elements, function(element) {\n    while ((element = element.parent)) {\n\n      // parent in selection\n      if (ids[element.id]) {\n        return false;\n      }\n    }\n\n    return true;\n  });\n}\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/move/MovePreview.js\n\n\n\n\n\n\n\n\nvar MovePreview_LOW_PRIORITY = 499;\n\nvar MARKER_DRAGGING = 'djs-dragging',\n    MARKER_OK = 'drop-ok',\n    MARKER_NOT_OK = 'drop-not-ok',\n    MARKER_NEW_PARENT = 'new-parent',\n    MARKER_ATTACH = 'attach-ok';\n\n\n/**\n * Provides previews for moving shapes when moving.\n *\n * @param {EventBus} eventBus\n * @param {ElementRegistry} elementRegistry\n * @param {Canvas} canvas\n * @param {Styles} styles\n */\nfunction MovePreview(\n    eventBus, canvas, styles, previewSupport) {\n\n  function getVisualDragShapes(shapes) {\n    var elements = getAllDraggedElements(shapes);\n\n    var filteredElements = removeEdges(elements);\n\n    return filteredElements;\n  }\n\n  function getAllDraggedElements(shapes) {\n    var allShapes = (0,Elements/* selfAndAllChildren */.PB)(shapes, true);\n\n    var allConnections = (0,index_esm/* map */.UI)(allShapes, function(shape) {\n      return (shape.incoming || []).concat(shape.outgoing || []);\n    });\n\n    return (0,index_esm/* flatten */.xH)(allShapes.concat(allConnections));\n  }\n\n  /**\n   * Sets drop marker on an element.\n   */\n  function setMarker(element, marker) {\n\n    [ MARKER_ATTACH, MARKER_OK, MARKER_NOT_OK, MARKER_NEW_PARENT ].forEach(function(m) {\n\n      if (m === marker) {\n        canvas.addMarker(element, m);\n      } else {\n        canvas.removeMarker(element, m);\n      }\n    });\n  }\n\n  /**\n   * Make an element draggable.\n   *\n   * @param {Object} context\n   * @param {djs.model.Base} element\n   * @param {Boolean} addMarker\n   */\n  function makeDraggable(context, element, addMarker) {\n\n    previewSupport.addDragger(element, context.dragGroup);\n\n    if (addMarker) {\n      canvas.addMarker(element, MARKER_DRAGGING);\n    }\n\n    if (context.allDraggedElements) {\n      context.allDraggedElements.push(element);\n    } else {\n      context.allDraggedElements = [ element ];\n    }\n  }\n\n  // assign a low priority to this handler\n  // to let others modify the move context before\n  // we draw things\n  eventBus.on('shape.move.start', MovePreview_LOW_PRIORITY, function(event) {\n    var context = event.context,\n        dragShapes = context.shapes,\n        allDraggedElements = context.allDraggedElements;\n\n    var visuallyDraggedShapes = getVisualDragShapes(dragShapes);\n\n    if (!context.dragGroup) {\n      var dragGroup = (0,dist_index_esm/* create */.Ue)('g');\n\n      (0,dist_index_esm/* attr */.Lj)(dragGroup, styles.cls('djs-drag-group', [ 'no-events' ]));\n\n      var defaultLayer = canvas.getDefaultLayer();\n\n      (0,dist_index_esm/* append */.R3)(defaultLayer, dragGroup);\n\n      context.dragGroup = dragGroup;\n    }\n\n    // add previews\n    visuallyDraggedShapes.forEach(function(shape) {\n      previewSupport.addDragger(shape, context.dragGroup);\n    });\n\n    // cache all dragged elements / gfx\n    // so that we can quickly undo their state changes later\n    if (!allDraggedElements) {\n      allDraggedElements = getAllDraggedElements(dragShapes);\n    } else {\n      allDraggedElements = (0,index_esm/* flatten */.xH)([\n        allDraggedElements,\n        getAllDraggedElements(dragShapes)\n      ]);\n    }\n\n    // add dragging marker\n    (0,index_esm/* forEach */.Ed)(allDraggedElements, function(e) {\n      canvas.addMarker(e, MARKER_DRAGGING);\n    });\n\n    context.allDraggedElements = allDraggedElements;\n\n    // determine, if any of the dragged elements have different parents\n    context.differentParents = haveDifferentParents(dragShapes);\n  });\n\n  // update previews\n  eventBus.on('shape.move.move', MovePreview_LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        dragGroup = context.dragGroup,\n        target = context.target,\n        parent = context.shape.parent,\n        canExecute = context.canExecute;\n\n    if (target) {\n      if (canExecute === 'attach') {\n        setMarker(target, MARKER_ATTACH);\n      } else if (context.canExecute && target && target.id !== parent.id) {\n        setMarker(target, MARKER_NEW_PARENT);\n      } else {\n        setMarker(target, context.canExecute ? MARKER_OK : MARKER_NOT_OK);\n      }\n    }\n\n    (0,SvgTransformUtil/* translate */.Iu)(dragGroup, event.dx, event.dy);\n  });\n\n  eventBus.on([ 'shape.move.out', 'shape.move.cleanup' ], function(event) {\n    var context = event.context,\n        target = context.target;\n\n    if (target) {\n      setMarker(target, null);\n    }\n  });\n\n  // remove previews\n  eventBus.on('shape.move.cleanup', function(event) {\n\n    var context = event.context,\n        allDraggedElements = context.allDraggedElements,\n        dragGroup = context.dragGroup;\n\n\n    // remove dragging marker\n    (0,index_esm/* forEach */.Ed)(allDraggedElements, function(e) {\n      canvas.removeMarker(e, MARKER_DRAGGING);\n    });\n\n    if (dragGroup) {\n      (0,dist_index_esm/* remove */.Od)(dragGroup);\n    }\n  });\n\n\n  // API //////////////////////\n\n  /**\n   * Make an element draggable.\n   *\n   * @param {Object} context\n   * @param {djs.model.Base} element\n   * @param {Boolean} addMarker\n   */\n  this.makeDraggable = makeDraggable;\n}\n\nMovePreview.$inject = [\n  'eventBus',\n  'canvas',\n  'styles',\n  'previewSupport'\n];\n\n\n// helpers //////////////////////\n\n/**\n * returns elements minus all connections\n * where source or target is not elements\n */\nfunction removeEdges(elements) {\n\n  var filteredElements = (0,index_esm/* filter */.hX)(elements, function(element) {\n\n    if (!isConnection(element)) {\n      return true;\n    } else {\n\n      return (\n        (0,index_esm/* find */.sE)(elements, (0,index_esm/* matchPattern */.KQ)({ id: element.source.id })) &&\n        (0,index_esm/* find */.sE)(elements, (0,index_esm/* matchPattern */.KQ)({ id: element.target.id }))\n      );\n    }\n  });\n\n  return filteredElements;\n}\n\nfunction haveDifferentParents(elements) {\n  return (0,index_esm/* size */.dp)((0,index_esm/* groupBy */.vM)(elements, function(e) { return e.parent && e.parent.id; })) !== 1;\n}\n\n/**\n * Checks if an element is a connection.\n */\nfunction isConnection(element) {\n  return element.waypoints;\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/move/index.js\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const move = ({\n  __depends__: [\n    interaction_events/* default */.Z,\n    selection/* default */.Z,\n    outline/* default */.Z,\n    rules/* default */.Z,\n    dragging/* default */.Z,\n    preview_support/* default */.Z\n  ],\n  __init__: [\n    'move',\n    'movePreview'\n  ],\n  move: [ 'type', MoveEvents ],\n  movePreview: [ 'type', MovePreview ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/move/index.js_+_2_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/ordering/OrderingProvider.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ OrderingProvider)\n/* harmony export */ });\n/* harmony import */ var inherits__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n/* harmony import */ var inherits__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(inherits__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js");\n\n\n\n\n\n/**\n * An abstract provider that allows modelers to implement a custom\n * ordering of diagram elements on the canvas.\n *\n * It makes sure that the order is always preserved during element\n * creation and move operations.\n *\n * In order to use this behavior, inherit from it and override\n * the method {@link OrderingProvider#getOrdering}.\n *\n * @example\n *\n * ```javascript\n * function CustomOrderingProvider(eventBus) {\n *   OrderingProvider.call(this, eventBus);\n *\n *   this.getOrdering = function(element, newParent) {\n *     // always insert elements at the front\n *     // when moving\n *     return {\n *       index: 0,\n *       parent: newParent\n *     };\n *   };\n * }\n * ```\n *\n * @param {EventBus} eventBus\n */\nfunction OrderingProvider(eventBus) {\n\n  _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_1__/* ["default"].call */ .Z.call(this, eventBus);\n\n\n  var self = this;\n\n  this.preExecute([ \'shape.create\', \'connection.create\' ], function(event) {\n\n    var context = event.context,\n        element = context.shape || context.connection,\n        parent = context.parent;\n\n    var ordering = self.getOrdering(element, parent);\n\n    if (ordering) {\n\n      if (ordering.parent !== undefined) {\n        context.parent = ordering.parent;\n      }\n\n      context.parentIndex = ordering.index;\n    }\n  });\n\n  this.preExecute([ \'shape.move\', \'connection.move\' ], function(event) {\n\n    var context = event.context,\n        element = context.shape || context.connection,\n        parent = context.newParent || element.parent;\n\n    var ordering = self.getOrdering(element, parent);\n\n    if (ordering) {\n\n      if (ordering.parent !== undefined) {\n        context.newParent = ordering.parent;\n      }\n\n      context.newParentIndex = ordering.index;\n    }\n  });\n}\n\n/**\n * Return a custom ordering of the element, both in terms\n * of parent element and index in the new parent.\n *\n * Implementors of this method must return an object with\n * `parent` _and_ `index` in it.\n *\n * @param {djs.model.Base} element\n * @param {djs.model.Shape} newParent\n *\n * @return {Object} ordering descriptor\n */\nOrderingProvider.prototype.getOrdering = function(element, newParent) {\n  return null;\n};\n\ninherits__WEBPACK_IMPORTED_MODULE_0___default()(OrderingProvider, _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z);\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/ordering/OrderingProvider.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/Outline.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ Outline)\n/* harmony export */ });\n/* harmony import */ var _util_Elements__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n/* harmony import */ var tiny_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n/* harmony import */ var min_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n\n\nvar LOW_PRIORITY = 500;\n\n\n\n\n\n\n\n\n/**\n * @class\n *\n * A plugin that adds an outline to shapes and connections that may be activated and styled\n * via CSS classes.\n *\n * @param {EventBus} eventBus\n * @param {Styles} styles\n * @param {ElementRegistry} elementRegistry\n */\nfunction Outline(eventBus, styles, elementRegistry) {\n\n  this.offset = 6;\n\n  var OUTLINE_STYLE = styles.cls('djs-outline', [ 'no-fill' ]);\n\n  var self = this;\n\n  function createOutline(gfx, bounds) {\n    var outline = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .create */ .Ue)('rect');\n\n    (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .Lj)(outline, (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .assign */ .f0)({\n      x: 10,\n      y: 10,\n      width: 100,\n      height: 100\n    }, OUTLINE_STYLE));\n\n    (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .append */ .R3)(gfx, outline);\n\n    return outline;\n  }\n\n  // A low priortity is necessary, because outlines of labels have to be updated\n  // after the label bounds have been updated in the renderer.\n  eventBus.on([ 'shape.added', 'shape.changed' ], LOW_PRIORITY, function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    var outline = (0,min_dom__WEBPACK_IMPORTED_MODULE_2__/* .query */ .IO)('.djs-outline', gfx);\n\n    if (!outline) {\n      outline = createOutline(gfx, element);\n    }\n\n    self.updateShapeOutline(outline, element);\n  });\n\n  eventBus.on([ 'connection.added', 'connection.changed' ], function(event) {\n    var element = event.element,\n        gfx = event.gfx;\n\n    var outline = (0,min_dom__WEBPACK_IMPORTED_MODULE_2__/* .query */ .IO)('.djs-outline', gfx);\n\n    if (!outline) {\n      outline = createOutline(gfx, element);\n    }\n\n    self.updateConnectionOutline(outline, element);\n  });\n}\n\n\n/**\n * Updates the outline of a shape respecting the dimension of the\n * element and an outline offset.\n *\n * @param  {SVGElement} outline\n * @param  {djs.model.Base} element\n */\nOutline.prototype.updateShapeOutline = function(outline, element) {\n\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .Lj)(outline, {\n    x: -this.offset,\n    y: -this.offset,\n    width: element.width + this.offset * 2,\n    height: element.height + this.offset * 2\n  });\n\n};\n\n\n/**\n * Updates the outline of a connection respecting the bounding box of\n * the connection and an outline offset.\n *\n * @param  {SVGElement} outline\n * @param  {djs.model.Base} element\n */\nOutline.prototype.updateConnectionOutline = function(outline, connection) {\n\n  var bbox = (0,_util_Elements__WEBPACK_IMPORTED_MODULE_3__/* .getBBox */ .jY)(connection);\n\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .Lj)(outline, {\n    x: bbox.x - this.offset,\n    y: bbox.y - this.offset,\n    width: bbox.width + this.offset * 2,\n    height: bbox.height + this.offset * 2\n  });\n\n};\n\n\nOutline.$inject = ['eventBus', 'styles', 'elementRegistry'];\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/Outline.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _Outline__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/Outline.js");\n\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  __init__: [ \'outline\' ],\n  outline: [ \'type\', _Outline__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/index.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/overlays/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ overlays)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/IdGenerator.js\n/**\n * Util that provides unique IDs.\n *\n * @class djs.util.IdGenerator\n * @constructor\n * @memberOf djs.util\n *\n * The ids can be customized via a given prefix and contain a random value to avoid collisions.\n *\n * @param {String} prefix a prefix to prepend to generated ids (for better readability)\n */\nfunction IdGenerator(prefix) {\n\n  this._counter = 0;\n  this._prefix = (prefix ? prefix + '-' : '') + Math.floor(Math.random() * 1000000000) + '-';\n}\n\n/**\n * Returns a next unique ID.\n *\n * @method djs.util.IdGenerator#next\n *\n * @returns {String} the id\n */\nIdGenerator.prototype.next = function() {\n  return this._prefix + (++this._counter);\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/overlays/Overlays.js\n\n\n\n\n\n\n\n\n// document wide unique overlay ids\nvar ids = new IdGenerator('ov');\n\nvar LOW_PRIORITY = 500;\n\n\n/**\n * A service that allows users to attach overlays to diagram elements.\n *\n * The overlay service will take care of overlay positioning during updates.\n *\n * @example\n *\n * // add a pink badge on the top left of the shape\n * overlays.add(someShape, {\n *   position: {\n *     top: -5,\n *     left: -5\n *   },\n *   html: '<div style=\"width: 10px; background: fuchsia; color: white;\">0</div>'\n * });\n *\n * // or add via shape id\n *\n * overlays.add('some-element-id', {\n *   position: {\n *     top: -5,\n *     left: -5\n *   }\n *   html: '<div style=\"width: 10px; background: fuchsia; color: white;\">0</div>'\n * });\n *\n * // or add with optional type\n *\n * overlays.add(someShape, 'badge', {\n *   position: {\n *     top: -5,\n *     left: -5\n *   }\n *   html: '<div style=\"width: 10px; background: fuchsia; color: white;\">0</div>'\n * });\n *\n *\n * // remove an overlay\n *\n * var id = overlays.add(...);\n * overlays.remove(id);\n *\n *\n * You may configure overlay defaults during tool by providing a `config` module\n * with `overlays.defaults` as an entry:\n *\n * {\n *   overlays: {\n *     defaults: {\n *       show: {\n *         minZoom: 0.7,\n *         maxZoom: 5.0\n *       },\n *       scale: {\n *         min: 1\n *       }\n *     }\n * }\n *\n * @param {Object} config\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {ElementRegistry} elementRegistry\n */\nfunction Overlays(config, eventBus, canvas, elementRegistry) {\n\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n  this._elementRegistry = elementRegistry;\n\n  this._ids = ids;\n\n  this._overlayDefaults = (0,index_esm/* assign */.f0)({\n    // no show constraints\n    show: null,\n\n    // always scale\n    scale: true\n  }, config && config.defaults);\n\n  /**\n   * Mapping overlayId -> overlay\n   */\n  this._overlays = {};\n\n  /**\n   * Mapping elementId -> overlay container\n   */\n  this._overlayContainers = [];\n\n  // root html element for all overlays\n  this._overlayRoot = createRoot(canvas.getContainer());\n\n  this._init();\n}\n\n\nOverlays.$inject = [\n  'config.overlays',\n  'eventBus',\n  'canvas',\n  'elementRegistry'\n];\n\n\n/**\n * Returns the overlay with the specified id or a list of overlays\n * for an element with a given type.\n *\n * @example\n *\n * // return the single overlay with the given id\n * overlays.get('some-id');\n *\n * // return all overlays for the shape\n * overlays.get({ element: someShape });\n *\n * // return all overlays on shape with type 'badge'\n * overlays.get({ element: someShape, type: 'badge' });\n *\n * // shape can also be specified as id\n * overlays.get({ element: 'element-id', type: 'badge' });\n *\n *\n * @param {Object} search\n * @param {String} [search.id]\n * @param {String|djs.model.Base} [search.element]\n * @param {String} [search.type]\n *\n * @return {Object|Array<Object>} the overlay(s)\n */\nOverlays.prototype.get = function(search) {\n\n  if ((0,index_esm/* isString */.HD)(search)) {\n    search = { id: search };\n  }\n\n  if ((0,index_esm/* isString */.HD)(search.element)) {\n    search.element = this._elementRegistry.get(search.element);\n  }\n\n  if (search.element) {\n    var container = this._getOverlayContainer(search.element, true);\n\n    // return a list of overlays when searching by element (+type)\n    if (container) {\n      return search.type ? (0,index_esm/* filter */.hX)(container.overlays, (0,index_esm/* matchPattern */.KQ)({ type: search.type })) : container.overlays.slice();\n    } else {\n      return [];\n    }\n  } else\n  if (search.type) {\n    return (0,index_esm/* filter */.hX)(this._overlays, (0,index_esm/* matchPattern */.KQ)({ type: search.type }));\n  } else {\n    // return single element when searching by id\n    return search.id ? this._overlays[search.id] : null;\n  }\n};\n\n/**\n * Adds a HTML overlay to an element.\n *\n * @param {String|djs.model.Base}   element   attach overlay to this shape\n * @param {String}                  [type]    optional type to assign to the overlay\n * @param {Object}                  overlay   the overlay configuration\n *\n * @param {String|DOMElement}       overlay.html                 html element to use as an overlay\n * @param {Object}                  [overlay.show]               show configuration\n * @param {Number}                  [overlay.show.minZoom]       minimal zoom level to show the overlay\n * @param {Number}                  [overlay.show.maxZoom]       maximum zoom level to show the overlay\n * @param {Object}                  overlay.position             where to attach the overlay\n * @param {Number}                  [overlay.position.left]      relative to element bbox left attachment\n * @param {Number}                  [overlay.position.top]       relative to element bbox top attachment\n * @param {Number}                  [overlay.position.bottom]    relative to element bbox bottom attachment\n * @param {Number}                  [overlay.position.right]     relative to element bbox right attachment\n * @param {Boolean|Object}          [overlay.scale=true]         false to preserve the same size regardless of\n *                                                               diagram zoom\n * @param {Number}                  [overlay.scale.min]\n * @param {Number}                  [overlay.scale.max]\n *\n * @return {String}                 id that may be used to reference the overlay for update or removal\n */\nOverlays.prototype.add = function(element, type, overlay) {\n\n  if ((0,index_esm/* isObject */.Kn)(type)) {\n    overlay = type;\n    type = null;\n  }\n\n  if (!element.id) {\n    element = this._elementRegistry.get(element);\n  }\n\n  if (!overlay.position) {\n    throw new Error('must specifiy overlay position');\n  }\n\n  if (!overlay.html) {\n    throw new Error('must specifiy overlay html');\n  }\n\n  if (!element) {\n    throw new Error('invalid element specified');\n  }\n\n  var id = this._ids.next();\n\n  overlay = (0,index_esm/* assign */.f0)({}, this._overlayDefaults, overlay, {\n    id: id,\n    type: type,\n    element: element,\n    html: overlay.html\n  });\n\n  this._addOverlay(overlay);\n\n  return id;\n};\n\n\n/**\n * Remove an overlay with the given id or all overlays matching the given filter.\n *\n * @see Overlays#get for filter options.\n *\n * @param {String} [id]\n * @param {Object} [filter]\n */\nOverlays.prototype.remove = function(filter) {\n\n  var overlays = this.get(filter) || [];\n\n  if (!(0,index_esm/* isArray */.kJ)(overlays)) {\n    overlays = [ overlays ];\n  }\n\n  var self = this;\n\n  (0,index_esm/* forEach */.Ed)(overlays, function(overlay) {\n\n    var container = self._getOverlayContainer(overlay.element, true);\n\n    if (overlay) {\n      (0,dist_index_esm/* remove */.Od)(overlay.html);\n      (0,dist_index_esm/* remove */.Od)(overlay.htmlContainer);\n\n      delete overlay.htmlContainer;\n      delete overlay.element;\n\n      delete self._overlays[overlay.id];\n    }\n\n    if (container) {\n      var idx = container.overlays.indexOf(overlay);\n      if (idx !== -1) {\n        container.overlays.splice(idx, 1);\n      }\n    }\n  });\n\n};\n\n\nOverlays.prototype.show = function() {\n  setVisible(this._overlayRoot);\n};\n\n\nOverlays.prototype.hide = function() {\n  setVisible(this._overlayRoot, false);\n};\n\nOverlays.prototype.clear = function() {\n  this._overlays = {};\n\n  this._overlayContainers = [];\n\n  (0,dist_index_esm/* clear */.ZH)(this._overlayRoot);\n};\n\nOverlays.prototype._updateOverlayContainer = function(container) {\n  var element = container.element,\n      html = container.html;\n\n  // update container left,top according to the elements x,y coordinates\n  // this ensures we can attach child elements relative to this container\n\n  var x = element.x,\n      y = element.y;\n\n  if (element.waypoints) {\n    var bbox = (0,Elements/* getBBox */.jY)(element);\n    x = bbox.x;\n    y = bbox.y;\n  }\n\n  setPosition(html, x, y);\n\n  (0,dist_index_esm/* attr */.Lj)(container.html, 'data-container-id', element.id);\n};\n\n\nOverlays.prototype._updateOverlay = function(overlay) {\n\n  var position = overlay.position,\n      htmlContainer = overlay.htmlContainer,\n      element = overlay.element;\n\n  // update overlay html relative to shape because\n  // it is already positioned on the element\n\n  // update relative\n  var left = position.left,\n      top = position.top;\n\n  if (position.right !== undefined) {\n\n    var width;\n\n    if (element.waypoints) {\n      width = (0,Elements/* getBBox */.jY)(element).width;\n    } else {\n      width = element.width;\n    }\n\n    left = position.right * -1 + width;\n  }\n\n  if (position.bottom !== undefined) {\n\n    var height;\n\n    if (element.waypoints) {\n      height = (0,Elements/* getBBox */.jY)(element).height;\n    } else {\n      height = element.height;\n    }\n\n    top = position.bottom * -1 + height;\n  }\n\n  setPosition(htmlContainer, left || 0, top || 0);\n};\n\n\nOverlays.prototype._createOverlayContainer = function(element) {\n  var html = (0,dist_index_esm/* domify */.H6)('<div class=\"djs-overlays\" style=\"position: absolute\" />');\n\n  this._overlayRoot.appendChild(html);\n\n  var container = {\n    html: html,\n    element: element,\n    overlays: []\n  };\n\n  this._updateOverlayContainer(container);\n\n  this._overlayContainers.push(container);\n\n  return container;\n};\n\n\nOverlays.prototype._updateRoot = function(viewbox) {\n  var scale = viewbox.scale || 1;\n\n  var matrix = 'matrix(' +\n  [\n    scale,\n    0,\n    0,\n    scale,\n    -1 * viewbox.x * scale,\n    -1 * viewbox.y * scale\n  ].join(',') +\n  ')';\n\n  setTransform(this._overlayRoot, matrix);\n};\n\n\nOverlays.prototype._getOverlayContainer = function(element, raw) {\n  var container = (0,index_esm/* find */.sE)(this._overlayContainers, function(c) {\n    return c.element === element;\n  });\n\n\n  if (!container && !raw) {\n    return this._createOverlayContainer(element);\n  }\n\n  return container;\n};\n\n\nOverlays.prototype._addOverlay = function(overlay) {\n\n  var id = overlay.id,\n      element = overlay.element,\n      html = overlay.html,\n      htmlContainer,\n      overlayContainer;\n\n  // unwrap jquery (for those who need it)\n  if (html.get && html.constructor.prototype.jquery) {\n    html = html.get(0);\n  }\n\n  // create proper html elements from\n  // overlay HTML strings\n  if ((0,index_esm/* isString */.HD)(html)) {\n    html = (0,dist_index_esm/* domify */.H6)(html);\n  }\n\n  overlayContainer = this._getOverlayContainer(element);\n\n  htmlContainer = (0,dist_index_esm/* domify */.H6)('<div class=\"djs-overlay\" data-overlay-id=\"' + id + '\" style=\"position: absolute\">');\n\n  htmlContainer.appendChild(html);\n\n  if (overlay.type) {\n    (0,dist_index_esm/* classes */.Sh)(htmlContainer).add('djs-overlay-' + overlay.type);\n  }\n\n  overlay.htmlContainer = htmlContainer;\n\n  overlayContainer.overlays.push(overlay);\n  overlayContainer.html.appendChild(htmlContainer);\n\n  this._overlays[id] = overlay;\n\n  this._updateOverlay(overlay);\n  this._updateOverlayVisibilty(overlay, this._canvas.viewbox());\n};\n\n\nOverlays.prototype._updateOverlayVisibilty = function(overlay, viewbox) {\n  var show = overlay.show,\n      minZoom = show && show.minZoom,\n      maxZoom = show && show.maxZoom,\n      htmlContainer = overlay.htmlContainer,\n      visible = true;\n\n  if (show) {\n    if (\n      ((0,index_esm/* isDefined */.$K)(minZoom) && minZoom > viewbox.scale) ||\n      ((0,index_esm/* isDefined */.$K)(maxZoom) && maxZoom < viewbox.scale)\n    ) {\n      visible = false;\n    }\n\n    setVisible(htmlContainer, visible);\n  }\n\n  this._updateOverlayScale(overlay, viewbox);\n};\n\n\nOverlays.prototype._updateOverlayScale = function(overlay, viewbox) {\n  var shouldScale = overlay.scale,\n      minScale,\n      maxScale,\n      htmlContainer = overlay.htmlContainer;\n\n  var scale, transform = '';\n\n  if (shouldScale !== true) {\n\n    if (shouldScale === false) {\n      minScale = 1;\n      maxScale = 1;\n    } else {\n      minScale = shouldScale.min;\n      maxScale = shouldScale.max;\n    }\n\n    if ((0,index_esm/* isDefined */.$K)(minScale) && viewbox.scale < minScale) {\n      scale = (1 / viewbox.scale || 1) * minScale;\n    }\n\n    if ((0,index_esm/* isDefined */.$K)(maxScale) && viewbox.scale > maxScale) {\n      scale = (1 / viewbox.scale || 1) * maxScale;\n    }\n  }\n\n  if ((0,index_esm/* isDefined */.$K)(scale)) {\n    transform = 'scale(' + scale + ',' + scale + ')';\n  }\n\n  setTransform(htmlContainer, transform);\n};\n\n\nOverlays.prototype._updateOverlaysVisibilty = function(viewbox) {\n\n  var self = this;\n\n  (0,index_esm/* forEach */.Ed)(this._overlays, function(overlay) {\n    self._updateOverlayVisibilty(overlay, viewbox);\n  });\n};\n\n\nOverlays.prototype._init = function() {\n\n  var eventBus = this._eventBus;\n\n  var self = this;\n\n\n  // scroll/zoom integration\n\n  function updateViewbox(viewbox) {\n    self._updateRoot(viewbox);\n    self._updateOverlaysVisibilty(viewbox);\n\n    self.show();\n  }\n\n  eventBus.on('canvas.viewbox.changing', function(event) {\n    self.hide();\n  });\n\n  eventBus.on('canvas.viewbox.changed', function(event) {\n    updateViewbox(event.viewbox);\n  });\n\n\n  // remove integration\n\n  eventBus.on([ 'shape.remove', 'connection.remove' ], function(e) {\n    var element = e.element;\n    var overlays = self.get({ element: element });\n\n    (0,index_esm/* forEach */.Ed)(overlays, function(o) {\n      self.remove(o.id);\n    });\n\n    var container = self._getOverlayContainer(element);\n\n    if (container) {\n      (0,dist_index_esm/* remove */.Od)(container.html);\n      var i = self._overlayContainers.indexOf(container);\n      if (i !== -1) {\n        self._overlayContainers.splice(i, 1);\n      }\n    }\n  });\n\n\n  // move integration\n\n  eventBus.on('element.changed', LOW_PRIORITY, function(e) {\n    var element = e.element;\n\n    var container = self._getOverlayContainer(element, true);\n\n    if (container) {\n      (0,index_esm/* forEach */.Ed)(container.overlays, function(overlay) {\n        self._updateOverlay(overlay);\n      });\n\n      self._updateOverlayContainer(container);\n    }\n  });\n\n\n  // marker integration, simply add them on the overlays as classes, too.\n\n  eventBus.on('element.marker.update', function(e) {\n    var container = self._getOverlayContainer(e.element, true);\n    if (container) {\n      (0,dist_index_esm/* classes */.Sh)(container.html)[e.add ? 'add' : 'remove'](e.marker);\n    }\n  });\n\n\n  // clear overlays with diagram\n\n  eventBus.on('diagram.clear', this.clear, this);\n};\n\n\n\n// helpers /////////////////////////////\n\nfunction createRoot(parentNode) {\n  var root = (0,dist_index_esm/* domify */.H6)(\n    '<div class=\"djs-overlay-container\" style=\"position: absolute; width: 0; height: 0;\" />'\n  );\n\n  parentNode.insertBefore(root, parentNode.firstChild);\n\n  return root;\n}\n\nfunction setPosition(el, x, y) {\n  (0,index_esm/* assign */.f0)(el.style, { left: x + 'px', top: y + 'px' });\n}\n\nfunction setVisible(el, visible) {\n  el.style.display = visible === false ? 'none' : '';\n}\n\nfunction setTransform(el, transform) {\n\n  el.style['transform-origin'] = 'top left';\n\n  [ '', '-ms-', '-webkit-' ].forEach(function(prefix) {\n    el.style[prefix + 'transform'] = transform;\n  });\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/overlays/index.js\n\n\n/* harmony default export */ const overlays = ({\n  __init__: [ 'overlays' ],\n  overlays: [ 'type', Overlays ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/overlays/index.js_+_2_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/palette/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ palette)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/palette/Palette.js\n\n\n\n\n\nvar TOGGLE_SELECTOR = '.djs-palette-toggle',\n    ENTRY_SELECTOR = '.entry',\n    ELEMENT_SELECTOR = TOGGLE_SELECTOR + ', ' + ENTRY_SELECTOR;\n\nvar PALETTE_OPEN_CLS = 'open',\n    PALETTE_TWO_COLUMN_CLS = 'two-column';\n\n\n/**\n * A palette containing modeling elements.\n */\nfunction Palette(eventBus, canvas) {\n\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n\n  this._providers = [];\n\n  var self = this;\n\n  eventBus.on('tool-manager.update', function(event) {\n    var tool = event.tool;\n\n    self.updateToolHighlight(tool);\n  });\n\n  eventBus.on('i18n.changed', function() {\n    self._update();\n  });\n\n  eventBus.on('diagram.init', function() {\n\n    self._diagramInitialized = true;\n\n    // initialize + update once diagram is ready\n    if (self._providers.length) {\n      self._init();\n\n      self._update();\n    }\n  });\n}\n\nPalette.$inject = [ 'eventBus', 'canvas' ];\n\n\n/**\n * Register a provider with the palette\n *\n * @param  {PaletteProvider} provider\n */\nPalette.prototype.registerProvider = function(provider) {\n  this._providers.push(provider);\n\n  // postpone init / update until diagram is initialized\n  if (!this._diagramInitialized) {\n    return;\n  }\n\n  if (!this._container) {\n    this._init();\n  }\n\n  this._update();\n};\n\n\n/**\n * Returns the palette entries for a given element\n *\n * @return {Array<PaletteEntryDescriptor>} list of entries\n */\nPalette.prototype.getEntries = function() {\n\n  var entries = {};\n\n  // loop through all providers and their entries.\n  // group entries by id so that overriding an entry is possible\n  (0,index_esm/* forEach */.Ed)(this._providers, function(provider) {\n    var e = provider.getPaletteEntries();\n\n    (0,index_esm/* forEach */.Ed)(e, function(entry, id) {\n      entries[id] = entry;\n    });\n  });\n\n  return entries;\n};\n\n\n/**\n * Initialize\n */\nPalette.prototype._init = function() {\n  var canvas = this._canvas,\n      eventBus = this._eventBus;\n\n  var parent = canvas.getContainer(),\n      container = this._container = (0,dist_index_esm/* domify */.H6)(Palette.HTML_MARKUP),\n      self = this;\n\n  parent.appendChild(container);\n\n  dist_index_esm/* delegate.bind */.cl.bind(container, ELEMENT_SELECTOR, 'click', function(event) {\n\n    var target = event.delegateTarget;\n\n    if ((0,dist_index_esm/* matches */.wB)(target, TOGGLE_SELECTOR)) {\n      return self.toggle();\n    }\n\n    self.trigger('click', event);\n  });\n\n  // prevent drag propagation\n  dist_index_esm/* event.bind */.B.bind(container, 'mousedown', function(event) {\n    event.stopPropagation();\n  });\n\n  // prevent drag propagation\n  dist_index_esm/* delegate.bind */.cl.bind(container, ENTRY_SELECTOR, 'dragstart', function(event) {\n    self.trigger('dragstart', event);\n  });\n\n  eventBus.on('canvas.resized', this._layoutChanged, this);\n\n  eventBus.fire('palette.create', {\n    container: container\n  });\n};\n\n/**\n * Update palette state.\n *\n * @param  {Object} [state] { open, twoColumn }\n */\nPalette.prototype._toggleState = function(state) {\n\n  state = state || {};\n\n  var parent = this._getParentContainer(),\n      container = this._container;\n\n  var eventBus = this._eventBus;\n\n  var twoColumn;\n\n  var cls = (0,dist_index_esm/* classes */.Sh)(container);\n\n  if ('twoColumn' in state) {\n    twoColumn = state.twoColumn;\n  } else {\n    twoColumn = this._needsCollapse(parent.clientHeight, this._entries || {});\n  }\n\n  // always update two column\n  cls.toggle(PALETTE_TWO_COLUMN_CLS, twoColumn);\n\n  if ('open' in state) {\n    cls.toggle(PALETTE_OPEN_CLS, state.open);\n  }\n\n  eventBus.fire('palette.changed', {\n    twoColumn: twoColumn,\n    open: this.isOpen()\n  });\n};\n\nPalette.prototype._update = function() {\n\n  var entriesContainer = (0,dist_index_esm/* query */.IO)('.djs-palette-entries', this._container),\n      entries = this._entries = this.getEntries();\n\n  (0,dist_index_esm/* clear */.ZH)(entriesContainer);\n\n  (0,index_esm/* forEach */.Ed)(entries, function(entry, id) {\n\n    var grouping = entry.group || 'default';\n\n    var container = (0,dist_index_esm/* query */.IO)('[data-group=' + grouping + ']', entriesContainer);\n    if (!container) {\n      container = (0,dist_index_esm/* domify */.H6)('<div class=\"group\" data-group=\"' + grouping + '\"></div>');\n      entriesContainer.appendChild(container);\n    }\n\n    var html = entry.html || (\n      entry.separator ?\n        '<hr class=\"separator\" />' :\n        '<div class=\"entry\" draggable=\"true\"></div>');\n\n\n    var control = (0,dist_index_esm/* domify */.H6)(html);\n    container.appendChild(control);\n\n    if (!entry.separator) {\n      (0,dist_index_esm/* attr */.Lj)(control, 'data-action', id);\n\n      if (entry.title) {\n        (0,dist_index_esm/* attr */.Lj)(control, 'title', entry.title);\n      }\n\n      if (entry.className) {\n        addClasses(control, entry.className);\n      }\n\n      if (entry.imageUrl) {\n        control.appendChild((0,dist_index_esm/* domify */.H6)('<img src=\"' + entry.imageUrl + '\">'));\n      }\n    }\n  });\n\n  // open after update\n  this.open();\n};\n\n\n/**\n * Trigger an action available on the palette\n *\n * @param  {String} action\n * @param  {Event} event\n */\nPalette.prototype.trigger = function(action, event, autoActivate) {\n  var entries = this._entries,\n      entry,\n      handler,\n      originalEvent,\n      button = event.delegateTarget || event.target;\n\n  if (!button) {\n    return event.preventDefault();\n  }\n\n  entry = entries[(0,dist_index_esm/* attr */.Lj)(button, 'data-action')];\n\n  // when user clicks on the palette and not on an action\n  if (!entry) {\n    return;\n  }\n\n  handler = entry.action;\n\n  originalEvent = event.originalEvent || event;\n\n  // simple action (via callback function)\n  if ((0,index_esm/* isFunction */.mf)(handler)) {\n    if (action === 'click') {\n      handler(originalEvent, autoActivate);\n    }\n  } else {\n    if (handler[action]) {\n      handler[action](originalEvent, autoActivate);\n    }\n  }\n\n  // silence other actions\n  event.preventDefault();\n};\n\nPalette.prototype._layoutChanged = function() {\n  this._toggleState({});\n};\n\n/**\n * Do we need to collapse to two columns?\n *\n * @param {Number} availableHeight\n * @param {Object} entries\n *\n * @return {Boolean}\n */\nPalette.prototype._needsCollapse = function(availableHeight, entries) {\n\n  // top margin + bottom toggle + bottom margin\n  // implementors must override this method if they\n  // change the palette styles\n  var margin = 20 + 10 + 20;\n\n  var entriesHeight = Object.keys(entries).length * 46;\n\n  return availableHeight < entriesHeight + margin;\n};\n\n/**\n * Close the palette\n */\nPalette.prototype.close = function() {\n\n  this._toggleState({\n    open: false,\n    twoColumn: false\n  });\n};\n\n\n/**\n * Open the palette\n */\nPalette.prototype.open = function() {\n  this._toggleState({ open: true });\n};\n\n\nPalette.prototype.toggle = function(open) {\n  if (this.isOpen()) {\n    this.close();\n  } else {\n    this.open();\n  }\n};\n\nPalette.prototype.isActiveTool = function(tool) {\n  return tool && this._activeTool === tool;\n};\n\nPalette.prototype.updateToolHighlight = function(name) {\n  var entriesContainer,\n      toolsContainer;\n\n  if (!this._toolsContainer) {\n    entriesContainer = (0,dist_index_esm/* query */.IO)('.djs-palette-entries', this._container);\n\n    this._toolsContainer = (0,dist_index_esm/* query */.IO)('[data-group=tools]', entriesContainer);\n  }\n\n  toolsContainer = this._toolsContainer;\n\n  (0,index_esm/* forEach */.Ed)(toolsContainer.children, function(tool) {\n    var actionName = tool.getAttribute('data-action');\n\n    if (!actionName) {\n      return;\n    }\n\n    var toolClasses = (0,dist_index_esm/* classes */.Sh)(tool);\n\n    actionName = actionName.replace('-tool', '');\n\n    if (toolClasses.contains('entry') && actionName === name) {\n      toolClasses.add('highlighted-entry');\n    } else {\n      toolClasses.remove('highlighted-entry');\n    }\n  });\n};\n\n\n/**\n * Return true if the palette is opened.\n *\n * @example\n *\n * palette.open();\n *\n * if (palette.isOpen()) {\n *   // yes, we are open\n * }\n *\n * @return {boolean} true if palette is opened\n */\nPalette.prototype.isOpen = function() {\n  return (0,dist_index_esm/* classes */.Sh)(this._container).has(PALETTE_OPEN_CLS);\n};\n\n/**\n * Get container the palette lives in.\n *\n * @return {Element}\n */\nPalette.prototype._getParentContainer = function() {\n  return this._canvas.getContainer();\n};\n\n\n/* markup definition */\n\nPalette.HTML_MARKUP =\n  '<div class=\"djs-palette\">' +\n    '<div class=\"djs-palette-entries\"></div>' +\n    '<div class=\"djs-palette-toggle\"></div>' +\n  '</div>';\n\n\n// helpers //////////////////////\n\nfunction addClasses(element, classNames) {\n\n  var classes = (0,dist_index_esm/* classes */.Sh)(element);\n\n  var actualClassNames = (0,index_esm/* isArray */.kJ)(classNames) ? classNames : classNames.split(/\\s+/g);\n  actualClassNames.forEach(function(cls) {\n    classes.add(cls);\n  });\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/palette/index.js\n\n\n/* harmony default export */ const palette = ({\n  __init__: [ 'palette' ],\n  palette: [ 'type', Palette ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/palette/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/popup-menu/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ popup_menu)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/popup-menu/PopupMenu.js\n\n\n\n\nvar DATA_REF = 'data-id';\n\n\n/**\n * A popup menu that can be used to display a list of actions anywhere in the canvas.\n *\n * @param {Object} config\n * @param {Boolean|Object} [config.scale={ min: 1.0, max: 1.5 }]\n * @param {Number} [config.scale.min]\n * @param {Number} [config.scale.max]\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n *\n * @class\n * @constructor\n */\nfunction PopupMenu(config, eventBus, canvas) {\n\n  var scale = (0,index_esm/* isDefined */.$K)(config && config.scale) ? config.scale : {\n    min: 1,\n    max: 1.5\n  };\n\n  this._config = {\n    scale: scale\n  };\n\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n  this._providers = {};\n  this._current = {};\n}\n\nPopupMenu.$inject = [\n  'config.popupMenu',\n  'eventBus',\n  'canvas'\n];\n\n/**\n * Registers a popup menu provider\n *\n * @param  {String} id\n * @param  {Object} provider\n *\n * @example\n *\n * popupMenu.registerProvider('myMenuID', {\n *   getEntries: function(element) {\n *     return [\n *       {\n *         id: 'entry-1',\n *         label: 'My Entry',\n *         action: 'alert(\"I have been clicked!\")'\n *       }\n *     ];\n *   }\n * });\n */\nPopupMenu.prototype.registerProvider = function(id, provider) {\n  this._providers[id] = provider;\n};\n\n\n/**\n * Determine if the popup menu has entries.\n *\n * @return {Boolean} true if empty\n */\nPopupMenu.prototype.isEmpty = function(element, providerId) {\n  if (!element) {\n    throw new Error('element parameter is missing');\n  }\n\n  if (!providerId) {\n    throw new Error('providerId parameter is missing');\n  }\n\n  var provider = this._providers[providerId];\n\n  var entries = provider.getEntries(element),\n      headerEntries = provider.getHeaderEntries && provider.getHeaderEntries(element);\n\n  var hasEntries = entries.length > 0,\n      hasHeaderEntries = headerEntries && headerEntries.length > 0;\n\n  return !hasEntries && !hasHeaderEntries;\n};\n\n\n/**\n * Create entries and open popup menu at given position\n *\n * @param  {Object} element\n * @param  {String} id provider id\n * @param  {Object} position\n *\n * @return {Object} popup menu instance\n */\nPopupMenu.prototype.open = function(element, id, position) {\n\n  var provider = this._providers[id];\n\n  if (!element) {\n    throw new Error('Element is missing');\n  }\n\n  if (!provider) {\n    throw new Error('Provider is not registered: ' + id);\n  }\n\n  if (!position) {\n    throw new Error('the position argument is missing');\n  }\n\n  if (this.isOpen()) {\n    this.close();\n  }\n\n  this._emit('open');\n\n  var current = this._current = {\n    provider: provider,\n    className: id,\n    element: element,\n    position: position\n  };\n\n  if (provider.getHeaderEntries) {\n    current.headerEntries = provider.getHeaderEntries(element);\n  }\n\n  current.entries = provider.getEntries(element);\n\n  current.container = this._createContainer();\n\n  var headerEntries = current.headerEntries || [],\n      entries = current.entries || [];\n\n  if (headerEntries.length) {\n    current.container.appendChild(\n      this._createEntries(current.headerEntries, 'djs-popup-header')\n    );\n  }\n\n  if (entries.length) {\n    current.container.appendChild(\n      this._createEntries(current.entries, 'djs-popup-body')\n    );\n  }\n\n  var canvas = this._canvas,\n      parent = canvas.getContainer();\n\n  this._attachContainer(current.container, parent, position.cursor);\n};\n\n\n/**\n * Removes the popup menu and unbinds the event handlers.\n */\nPopupMenu.prototype.close = function() {\n\n  if (!this.isOpen()) {\n    return;\n  }\n\n  this._emit('close');\n\n  this._unbindHandlers();\n  (0,dist_index_esm/* remove */.Od)(this._current.container);\n  this._current.container = null;\n};\n\n\n/**\n * Determine if an open popup menu exist.\n *\n * @return {Boolean} true if open\n */\nPopupMenu.prototype.isOpen = function() {\n  return !!this._current.container;\n};\n\n\n/**\n * Trigger an action associated with an entry.\n *\n * @param {Object} event\n *\n * @return the result of the action callback, if any\n */\nPopupMenu.prototype.trigger = function(event) {\n\n  // silence other actions\n  event.preventDefault();\n\n  var element = event.delegateTarget || event.target,\n      entryId = (0,dist_index_esm/* attr */.Lj)(element, DATA_REF);\n\n  var entry = this._getEntry(entryId);\n\n  if (entry.action) {\n    return entry.action.call(null, event, entry);\n  }\n};\n\n/**\n * Gets an entry instance (either entry or headerEntry) by id.\n *\n * @param  {String} entryId\n *\n * @return {Object} entry instance\n */\nPopupMenu.prototype._getEntry = function(entryId) {\n\n  var search = (0,index_esm/* matchPattern */.KQ)({ id: entryId });\n\n  var entry = (0,index_esm/* find */.sE)(this._current.entries, search) || (0,index_esm/* find */.sE)(this._current.headerEntries, search);\n\n  if (!entry) {\n    throw new Error('entry not found');\n  }\n\n  return entry;\n};\n\nPopupMenu.prototype._emit = function(eventName) {\n  this._eventBus.fire('popupMenu.' + eventName);\n};\n\n/**\n * Creates the popup menu container.\n *\n * @return {Object} a DOM container\n */\nPopupMenu.prototype._createContainer = function() {\n  var container = (0,dist_index_esm/* domify */.H6)('<div class=\"djs-popup\">'),\n      position = this._current.position,\n      className = this._current.className;\n\n  (0,index_esm/* assign */.f0)(container.style, {\n    position: 'absolute',\n    left: position.x + 'px',\n    top: position.y + 'px',\n    visibility: 'hidden'\n  });\n\n  (0,dist_index_esm/* classes */.Sh)(container).add(className);\n\n  return container;\n};\n\n\n/**\n * Attaches the container to the DOM and binds the event handlers.\n *\n * @param {Object} container\n * @param {Object} parent\n */\nPopupMenu.prototype._attachContainer = function(container, parent, cursor) {\n  var self = this;\n\n  // Event handler\n  dist_index_esm/* delegate.bind */.cl.bind(container, '.entry' ,'click', function(event) {\n    self.trigger(event);\n  });\n\n  this._updateScale(container);\n\n  // Attach to DOM\n  parent.appendChild(container);\n\n  if (cursor) {\n    this._assureIsInbounds(container, cursor);\n  }\n\n  // Add Handler\n  this._bindHandlers();\n};\n\n\n/**\n * Updates popup style.transform with respect to the config and zoom level.\n *\n * @method _updateScale\n *\n * @param {Object} container\n */\nPopupMenu.prototype._updateScale = function(container) {\n  var zoom = this._canvas.zoom();\n\n  var scaleConfig = this._config.scale,\n      minScale,\n      maxScale,\n      scale = zoom;\n\n  if (scaleConfig !== true) {\n\n    if (scaleConfig === false) {\n      minScale = 1;\n      maxScale = 1;\n    } else {\n      minScale = scaleConfig.min;\n      maxScale = scaleConfig.max;\n    }\n\n    if ((0,index_esm/* isDefined */.$K)(minScale) && zoom < minScale) {\n      scale = minScale;\n    }\n\n    if ((0,index_esm/* isDefined */.$K)(maxScale) && zoom > maxScale) {\n      scale = maxScale;\n    }\n\n  }\n\n  setTransform(container, 'scale(' + scale + ')');\n};\n\n\n/**\n * Make sure that the menu is always fully shown\n *\n * @method function\n *\n * @param  {Object} container\n * @param  {Position} cursor {x, y}\n */\nPopupMenu.prototype._assureIsInbounds = function(container, cursor) {\n  var canvas = this._canvas,\n      clientRect = canvas._container.getBoundingClientRect();\n\n  var containerX = container.offsetLeft,\n      containerY = container.offsetTop,\n      containerWidth = container.scrollWidth,\n      containerHeight = container.scrollHeight,\n      overAxis = {},\n      left, top;\n\n  var cursorPosition = {\n    x: cursor.x - clientRect.left,\n    y: cursor.y - clientRect.top\n  };\n\n  if (containerX + containerWidth > clientRect.width) {\n    overAxis.x = true;\n  }\n\n  if (containerY + containerHeight > clientRect.height) {\n    overAxis.y = true;\n  }\n\n  if (overAxis.x && overAxis.y) {\n    left = cursorPosition.x - containerWidth + 'px';\n    top = cursorPosition.y - containerHeight + 'px';\n  } else if (overAxis.x) {\n    left = cursorPosition.x - containerWidth + 'px';\n    top = cursorPosition.y + 'px';\n  } else if (overAxis.y && cursorPosition.y < containerHeight) {\n    left = cursorPosition.x + 'px';\n    top = 10 + 'px';\n  } else if (overAxis.y) {\n    left = cursorPosition.x + 'px';\n    top = cursorPosition.y - containerHeight + 'px';\n  }\n\n  (0,index_esm/* assign */.f0)(container.style, { left: left, top: top }, { visibility: 'visible', 'z-index': 1000 });\n};\n\n\n/**\n * Creates a list of entries and returns them as a DOM container.\n *\n * @param {Array<Object>} entries an array of entry objects\n * @param {String} className the class name of the entry container\n *\n * @return {Object} a DOM container\n */\nPopupMenu.prototype._createEntries = function(entries, className) {\n\n  var entriesContainer = (0,dist_index_esm/* domify */.H6)('<div>'),\n      self = this;\n\n  (0,dist_index_esm/* classes */.Sh)(entriesContainer).add(className);\n\n  (0,index_esm/* forEach */.Ed)(entries, function(entry) {\n    var entryContainer = self._createEntry(entry, entriesContainer);\n    entriesContainer.appendChild(entryContainer);\n  });\n\n  return entriesContainer;\n};\n\n\n/**\n * Creates a single entry and returns it as a DOM container.\n *\n * @param  {Object} entry\n *\n * @return {Object} a DOM container\n */\nPopupMenu.prototype._createEntry = function(entry) {\n\n  if (!entry.id) {\n    throw new Error ('every entry must have the id property set');\n  }\n\n  var entryContainer = (0,dist_index_esm/* domify */.H6)('<div>'),\n      entryClasses = (0,dist_index_esm/* classes */.Sh)(entryContainer);\n\n  entryClasses.add('entry');\n\n  if (entry.className) {\n    entry.className.split(' ').forEach(function(className) {\n      entryClasses.add(className);\n    });\n  }\n\n  (0,dist_index_esm/* attr */.Lj)(entryContainer, DATA_REF, entry.id);\n\n  if (entry.label) {\n    var label = (0,dist_index_esm/* domify */.H6)('<span>');\n    label.textContent = entry.label;\n    entryContainer.appendChild(label);\n  }\n\n  if (entry.imageUrl) {\n    entryContainer.appendChild((0,dist_index_esm/* domify */.H6)('<img src=\"' + entry.imageUrl + '\" />'));\n  }\n\n  if (entry.active === true) {\n    entryClasses.add('active');\n  }\n\n  if (entry.disabled === true) {\n    entryClasses.add('disabled');\n  }\n\n  if (entry.title) {\n    entryContainer.title = entry.title;\n  }\n\n  return entryContainer;\n};\n\n\n/**\n * Binds the `close` method to 'contextPad.close' & 'canvas.viewbox.changed'.\n */\nPopupMenu.prototype._bindHandlers = function() {\n\n  var eventBus = this._eventBus,\n      self = this;\n\n  function close() {\n    self.close();\n  }\n\n  eventBus.once('contextPad.close', close);\n  eventBus.once('canvas.viewbox.changing', close);\n  eventBus.once('commandStack.changed', close);\n};\n\n\n/**\n * Unbinds the `close` method to 'contextPad.close' & 'canvas.viewbox.changing'.\n */\nPopupMenu.prototype._unbindHandlers = function() {\n\n  var eventBus = this._eventBus,\n      self = this;\n\n  function close() {\n    self.close();\n  }\n\n  eventBus.off('contextPad.close', close);\n  eventBus.off('canvas.viewbox.changed', close);\n  eventBus.off('commandStack.changed', close);\n};\n\n\n\n// helpers /////////////////////////////\n\nfunction setTransform(element, transform) {\n  element.style['transform-origin'] = 'top left';\n\n  [ '', '-ms-', '-webkit-' ].forEach(function(prefix) {\n    element.style[prefix + 'transform'] = transform;\n  });\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/popup-menu/index.js\n\n\n/* harmony default export */ const popup_menu = ({\n  __init__: [ 'popupMenu' ],\n  popupMenu: [ 'type', PopupMenu ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/popup-menu/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ preview_support)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/GraphicsUtil.js\nvar GraphicsUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/GraphicsUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/PreviewSupport.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nvar MARKER_TYPES = [\r\n  'marker-start',\r\n  'marker-mid',\r\n  'marker-end'\r\n];\r\n\r\nvar NODES_CAN_HAVE_MARKER = [\r\n  'circle',\r\n  'ellipse',\r\n  'line',\r\n  'path',\r\n  'polygon',\r\n  'polyline',\r\n  'rect'\r\n];\r\n\r\n\r\n/**\r\n * Adds support for previews of moving/resizing elements.\r\n */\r\nfunction PreviewSupport(elementRegistry, eventBus, canvas, styles) {\r\n  this._elementRegistry = elementRegistry;\r\n  this._canvas = canvas;\r\n  this._styles = styles;\r\n\r\n  this._clonedMarkers = {};\r\n\r\n  var self = this;\r\n\r\n  eventBus.on('drag.cleanup', function() {\r\n    (0,index_esm/* forEach */.Ed)(self._clonedMarkers, function(clonedMarker) {\r\n      (0,dist_index_esm/* remove */.Od)(clonedMarker);\r\n    });\r\n\r\n    self._clonedMarkers = {};\r\n  });\r\n}\r\n\r\nPreviewSupport.$inject = [\r\n  'elementRegistry',\r\n  'eventBus',\r\n  'canvas',\r\n  'styles'\r\n];\r\n\r\n\r\n/**\r\n * Returns graphics of an element.\r\n *\r\n * @param {djs.model.Base} element\r\n *\r\n * @return {SVGElement}\r\n */\r\nPreviewSupport.prototype.getGfx = function(element) {\r\n  return this._elementRegistry.getGraphics(element);\r\n};\r\n\r\n/**\r\n * Adds a move preview of a given shape to a given svg group.\r\n *\r\n * @param {djs.model.Base} element\r\n * @param {SVGElement} group\r\n *\r\n * @return {SVGElement} dragger\r\n */\r\nPreviewSupport.prototype.addDragger = function(shape, group) {\r\n  var gfx = this.getGfx(shape);\r\n\r\n  var dragger = (0,dist_index_esm/* clone */.d9)(gfx);\r\n  var bbox = gfx.getBoundingClientRect();\r\n\r\n  this._cloneMarkers((0,GraphicsUtil/* getVisual */.s)(dragger));\r\n\r\n  (0,dist_index_esm/* attr */.Lj)(dragger, this._styles.cls('djs-dragger', [], {\r\n    x: bbox.top,\r\n    y: bbox.left\r\n  }));\r\n\r\n  (0,dist_index_esm/* append */.R3)(group, dragger);\r\n\r\n  return dragger;\r\n};\r\n\r\n/**\r\n * Adds a resize preview of a given shape to a given svg group.\r\n *\r\n * @param {djs.model.Base} element\r\n * @param {SVGElement} group\r\n *\r\n * @return {SVGElement} frame\r\n */\r\nPreviewSupport.prototype.addFrame = function(shape, group) {\r\n\r\n  var frame = (0,dist_index_esm/* create */.Ue)('rect', {\r\n    class: 'djs-resize-overlay',\r\n    width:  shape.width,\r\n    height: shape.height,\r\n    x: shape.x,\r\n    y: shape.y\r\n  });\r\n\r\n  (0,dist_index_esm/* append */.R3)(group, frame);\r\n\r\n  return frame;\r\n};\r\n\r\n/**\r\n * Clone all markers referenced by a node and its child nodes.\r\n *\r\n * @param {SVGElement} gfx\r\n */\r\nPreviewSupport.prototype._cloneMarkers = function(gfx) {\r\n  var self = this;\r\n\r\n  if (gfx.childNodes) {\r\n\r\n    // TODO: use forEach once we drop PhantomJS\r\n    for (var i = 0; i < gfx.childNodes.length; i++) {\r\n\r\n      // recursively clone markers of child nodes\r\n      self._cloneMarkers(gfx.childNodes[ i ]);\r\n    }\r\n  }\r\n\r\n  if (!canHaveMarker(gfx)) {\r\n    return;\r\n  }\r\n\r\n  MARKER_TYPES.forEach(function(markerType) {\r\n    if ((0,dist_index_esm/* attr */.Lj)(gfx, markerType)) {\r\n      var marker = getMarker(gfx, markerType, self._canvas.getContainer());\r\n\r\n      self._cloneMarker(gfx, marker, markerType);\r\n    }\r\n  });\r\n};\r\n\r\n/**\r\n * Clone marker referenced by an element.\r\n *\r\n * @param {SVGElement} gfx\r\n * @param {SVGElement} marker\r\n * @param {string} markerType\r\n */\r\nPreviewSupport.prototype._cloneMarker = function(gfx, marker, markerType) {\r\n  var markerId = marker.id;\r\n\r\n  var clonedMarker = this._clonedMarkers[ markerId ];\r\n\r\n  if (!clonedMarker) {\r\n    clonedMarker = (0,dist_index_esm/* clone */.d9)(marker);\r\n\r\n    var clonedMarkerId = markerId + '-clone';\r\n\r\n    clonedMarker.id = clonedMarkerId;\r\n\r\n    (0,dist_index_esm/* classes */.Sh)(clonedMarker)\r\n      .add('djs-dragger')\r\n      .add('djs-dragger-marker');\r\n\r\n    this._clonedMarkers[ markerId ] = clonedMarker;\r\n\r\n    var defs = (0,min_dom_dist_index_esm/* query */.IO)('defs', this._canvas._svg);\r\n\r\n    if (!defs) {\r\n      defs = (0,dist_index_esm/* create */.Ue)('defs');\r\n\r\n      (0,dist_index_esm/* append */.R3)(this._canvas._svg, defs);\r\n    }\r\n\r\n    (0,dist_index_esm/* append */.R3)(defs, clonedMarker);\r\n  }\r\n\r\n  var reference = idToReference(this._clonedMarkers[ markerId ].id);\r\n\r\n  (0,dist_index_esm/* attr */.Lj)(gfx, markerType, reference);\r\n};\r\n\r\n// helpers //////////\r\n\r\n/**\r\n * Get marker of given type referenced by node.\r\n *\r\n * @param {Node} node\r\n * @param {string} markerType\r\n * @param {Node} [parentNode]\r\n *\r\n * @param {Node}\r\n */\r\nfunction getMarker(node, markerType, parentNode) {\r\n  var id = referenceToId((0,dist_index_esm/* attr */.Lj)(node, markerType));\r\n\r\n  return (0,min_dom_dist_index_esm/* query */.IO)('marker#' + id, parentNode || document);\r\n}\r\n\r\n/**\r\n * Get ID of fragment within current document from its functional IRI reference.\r\n * References may use single or double quotes.\r\n *\r\n * @param {string} reference\r\n *\r\n * @returns {string}\r\n */\r\nfunction referenceToId(reference) {\r\n  return reference.match(/url\\(['\"]?#([^'\"]*)['\"]?\\)/)[1];\r\n}\r\n\r\n/**\r\n * Get functional IRI reference for given ID of fragment within current document.\r\n *\r\n * @param {string} id\r\n *\r\n * @returns {string}\r\n */\r\nfunction idToReference(id) {\r\n  return 'url(#' + id + ')';\r\n}\r\n\r\n/**\r\n * Check wether node type can have marker attributes.\r\n *\r\n * @param {Node} node\r\n *\r\n * @returns {boolean}\r\n */\r\nfunction canHaveMarker(node) {\r\n  return NODES_CAN_HAVE_MARKER.indexOf(node.nodeName) !== -1;\r\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/index.js\n\n\n/* harmony default export */ const preview_support = ({\n  __init__: [ 'previewSupport' ],\n  previewSupport: [ 'type', PreviewSupport ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/replace/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ replace)\n});\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/replace/Replace.js\nvar round = Math.round;\n\n/**\n * Service that allow replacing of elements.\n */\nfunction Replace(modeling) {\n\n  this._modeling = modeling;\n}\n\nReplace.$inject = [ 'modeling' ];\n\n/**\n * @param {Element} oldElement - Element to be replaced\n * @param {Object}  newElementData - Containing information about the new Element, for example height, width, type.\n * @param {Object}  options - Custom options that will be attached to the context. It can be used to inject data\n *                            that is needed in the command chain. For example it could be used in\n *                            eventbus.on('commandStack.shape.replace.postExecute') to change shape attributes after\n *                            shape creation.\n */\nReplace.prototype.replaceElement = function(oldElement, newElementData, options) {\n\n  var modeling = this._modeling;\n\n  var newElement = null;\n\n  if (oldElement.waypoints) {\n    // TODO\n    // modeling.replaceConnection\n  } else {\n    // set center of element for modeling API\n    // if no new width / height is given use old elements size\n    newElementData.x = round(oldElement.x + (newElementData.width || oldElement.width) / 2);\n    newElementData.y = round(oldElement.y + (newElementData.height || oldElement.height) / 2);\n\n    newElement = modeling.replaceShape(oldElement, newElementData, options);\n  }\n\n  return newElement;\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/replace/index.js\n\n\n/* harmony default export */ const replace = ({\n  __init__: [ 'replace' ],\n  replace: [ 'type', Replace ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/replace/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/ResizeUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "addPadding": () => (/* binding */ addPadding),\n/* harmony export */   "computeChildrenBBox": () => (/* binding */ computeChildrenBBox),\n/* harmony export */   "ensureConstraints": () => (/* binding */ ensureConstraints),\n/* harmony export */   "getMinResizeBounds": () => (/* binding */ getMinResizeBounds),\n/* harmony export */   "reattachPoint": () => (/* binding */ reattachPoint),\n/* harmony export */   "resizeBounds": () => (/* binding */ resizeBounds),\n/* harmony export */   "resizeTRBL": () => (/* binding */ resizeTRBL),\n/* harmony export */   "substractTRBL": () => (/* binding */ substractTRBL)\n/* harmony export */ });\nif ("cmmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/min-dash/dist/index.esm.js");\n}\nif ("cmmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _util_Elements__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js");\n}\nif ("cmmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js");\n}\n\n\nvar max = Math.max,\n    min = Math.min;\n\nvar DEFAULT_CHILD_BOX_PADDING = 20;\n\n\n\n\n\n\n/**\n * Substract a TRBL from another\n *\n * @param  {TRBL} trblA\n * @param  {TRBL} trblB\n *\n * @return {TRBL}\n */\nfunction substractTRBL(trblA, trblB) {\n  return {\n    top: trblA.top - trblB.top,\n    right: trblA.right - trblB.right,\n    bottom: trblA.bottom - trblB.bottom,\n    left: trblA.left - trblB.left\n  };\n}\n\n/**\n * Resize the given bounds by the specified delta from a given anchor point.\n *\n * @param {Bounds} bounds the bounding box that should be resized\n * @param {String} direction in which the element is resized (nw, ne, se, sw)\n * @param {Point} delta of the resize operation\n *\n * @return {Bounds} resized bounding box\n */\nfunction resizeBounds(bounds, direction, delta) {\n\n  var dx = delta.x,\n      dy = delta.y;\n\n  switch (direction) {\n\n  case \'nw\':\n    return {\n      x: bounds.x + dx,\n      y: bounds.y + dy,\n      width: bounds.width - dx,\n      height: bounds.height - dy\n    };\n\n  case \'sw\':\n    return {\n      x: bounds.x + dx,\n      y: bounds.y,\n      width: bounds.width - dx,\n      height: bounds.height + dy\n    };\n\n  case \'ne\':\n    return {\n      x: bounds.x,\n      y: bounds.y + dy,\n      width: bounds.width + dx,\n      height: bounds.height - dy\n    };\n\n  case \'se\':\n    return {\n      x: bounds.x,\n      y: bounds.y,\n      width: bounds.width + dx,\n      height: bounds.height + dy\n    };\n\n  default:\n    throw new Error(\'unrecognized direction: \' + direction);\n  }\n}\n\n\n/**\n * Resize the given bounds by applying the passed\n * { top, right, bottom, left } delta.\n *\n * @param {Bounds} bounds\n * @param {TRBL} trblResize\n *\n * @return {Bounds}\n */\nfunction resizeTRBL(bounds, resize) {\n  return {\n    x: bounds.x + (resize.left || 0),\n    y: bounds.y + (resize.top || 0),\n    width: bounds.width - (resize.left || 0) + (resize.right || 0),\n    height: bounds.height - (resize.top || 0) + (resize.bottom || 0)\n  };\n}\n\n\nfunction reattachPoint(bounds, newBounds, point) {\n\n  var sx = bounds.width / newBounds.width,\n      sy = bounds.height / newBounds.height;\n\n  return {\n    x: Math.round((newBounds.x + newBounds.width / 2)) - Math.floor(((bounds.x + bounds.width / 2) - point.x) / sx),\n    y: Math.round((newBounds.y + newBounds.height / 2)) - Math.floor(((bounds.y + bounds.height / 2) - point.y) / sy)\n  };\n}\n\n\nfunction applyConstraints(attr, trbl, resizeConstraints) {\n\n  var value = trbl[attr],\n      minValue = resizeConstraints.min && resizeConstraints.min[attr],\n      maxValue = resizeConstraints.max && resizeConstraints.max[attr];\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(minValue)) {\n    value = (/top|left/.test(attr) ? min : max)(value, minValue);\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(maxValue)) {\n    value = (/top|left/.test(attr) ? max : min)(value, maxValue);\n  }\n\n  return value;\n}\n\nfunction ensureConstraints(currentBounds, resizeConstraints) {\n\n  if (!resizeConstraints) {\n    return currentBounds;\n  }\n\n  var currentTrbl = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(currentBounds);\n\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asBounds */ .z_)({\n    top: applyConstraints(\'top\', currentTrbl, resizeConstraints),\n    right: applyConstraints(\'right\', currentTrbl, resizeConstraints),\n    bottom: applyConstraints(\'bottom\', currentTrbl, resizeConstraints),\n    left: applyConstraints(\'left\', currentTrbl, resizeConstraints)\n  });\n}\n\n\nfunction getMinResizeBounds(direction, currentBounds, minDimensions, childrenBounds) {\n\n  var currentBox = (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(currentBounds);\n\n  var minBox = {\n    top: /n/.test(direction) ? currentBox.bottom - minDimensions.height : currentBox.top,\n    left: /w/.test(direction) ? currentBox.right - minDimensions.width : currentBox.left,\n    bottom: /s/.test(direction) ? currentBox.top + minDimensions.height : currentBox.bottom,\n    right: /e/.test(direction) ? currentBox.left + minDimensions.width : currentBox.right\n  };\n\n  var childrenBox = childrenBounds ? (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asTRBL */ .JA)(childrenBounds) : minBox;\n\n  var combinedBox = {\n    top: min(minBox.top, childrenBox.top),\n    left: min(minBox.left, childrenBox.left),\n    bottom: max(minBox.bottom, childrenBox.bottom),\n    right: max(minBox.right, childrenBox.right)\n  };\n\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .asBounds */ .z_)(combinedBox);\n}\n\nfunction asPadding(mayBePadding, defaultValue) {\n  if (typeof mayBePadding !== \'undefined\') {\n    return mayBePadding;\n  } else {\n    return DEFAULT_CHILD_BOX_PADDING;\n  }\n}\n\nfunction addPadding(bbox, padding) {\n  var left, right, top, bottom;\n\n  if (typeof padding === \'object\') {\n    left = asPadding(padding.left);\n    right = asPadding(padding.right);\n    top = asPadding(padding.top);\n    bottom = asPadding(padding.bottom);\n  } else {\n    left = right = top = bottom = asPadding(padding);\n  }\n\n  return {\n    x: bbox.x - left,\n    y: bbox.y - top,\n    width: bbox.width + left + right,\n    height: bbox.height + top + bottom\n  };\n}\n\n\n/**\n * Is the given element part of the resize\n * targets min boundary box?\n *\n * This is the default implementation which excludes\n * connections and labels.\n *\n * @param {djs.model.Base} element\n */\nfunction isBBoxChild(element) {\n\n  // exclude connections\n  if (element.waypoints) {\n    return false;\n  }\n\n  // exclude labels\n  if (element.type === \'label\') {\n    return false;\n  }\n\n  return true;\n}\n\n/**\n * Return children bounding computed from a shapes children\n * or a list of prefiltered children.\n *\n * @param  {djs.model.Shape|Array<djs.model.Shape>} shapeOrChildren\n * @param  {Number|Object} padding\n *\n * @return {Bounds}\n */\nfunction computeChildrenBBox(shapeOrChildren, padding) {\n\n  var elements;\n\n  // compute based on shape\n  if (shapeOrChildren.length === undefined) {\n    // grab all the children that are part of the\n    // parents children box\n    elements = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .filter */ .hX)(shapeOrChildren.children, isBBoxChild);\n\n  } else {\n    elements = shapeOrChildren;\n  }\n\n  if (elements.length) {\n    return addPadding((0,_util_Elements__WEBPACK_IMPORTED_MODULE_2__/* .getBBox */ .jY)(elements), padding);\n  }\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/ResizeUtil.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ resize)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js + 2 modules\nvar dragging = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/index.js + 1 modules\nvar preview_support = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/ResizeUtil.js\nvar ResizeUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/ResizeUtil.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/Resize.js\n\n\n\n\n\n\nvar DEFAULT_MIN_WIDTH = 10;\n\n\n/**\n * A component that provides resizing of shapes on the canvas.\n *\n * The following components are part of shape resize:\n *\n *  * adding resize handles,\n *  * creating a visual during resize\n *  * checking resize rules\n *  * committing a change once finished\n *\n *\n * ## Customizing\n *\n * It's possible to customize the resizing behaviour by intercepting 'resize.start'\n * and providing the following parameters through the 'context':\n *\n *   * minDimensions ({ width, height }): minimum shape dimensions\n *\n *   * childrenBoxPadding ({ left, top, bottom, right } || number):\n *     gap between the minimum bounding box and the container\n *\n * f.ex:\n *\n * ```javascript\n * eventBus.on('resize.start', 1500, function(event) {\n *   var context = event.context,\n *\n *  context.minDimensions = { width: 140, height: 120 };\n *\n *  // Passing general padding\n *  context.childrenBoxPadding = 30;\n *\n *  // Passing padding to a specific side\n *  context.childrenBoxPadding.left = 20;\n * });\n * ```\n */\nfunction Resize(eventBus, rules, modeling, dragging) {\n\n  this._dragging = dragging;\n  this._rules = rules;\n\n  var self = this;\n\n\n  /**\n   * Handle resize move by specified delta.\n   *\n   * @param {Object} context\n   * @param {Point} delta\n   */\n  function handleMove(context, delta) {\n\n    var shape = context.shape,\n        direction = context.direction,\n        resizeConstraints = context.resizeConstraints,\n        newBounds;\n\n    context.delta = delta;\n\n    newBounds = (0,ResizeUtil.resizeBounds)(shape, direction, delta);\n\n    // ensure constraints during resize\n    context.newBounds = (0,ResizeUtil.ensureConstraints)(newBounds, resizeConstraints);\n\n    // update + cache executable state\n    context.canExecute = self.canResize(context);\n  }\n\n  /**\n   * Handle resize start.\n   *\n   * @param  {Object} context\n   */\n  function handleStart(context) {\n\n    var resizeConstraints = context.resizeConstraints,\n        // evaluate minBounds for backwards compatibility\n        minBounds = context.minBounds;\n\n    if (resizeConstraints !== undefined) {\n      return;\n    }\n\n    if (minBounds === undefined) {\n      minBounds = self.computeMinResizeBox(context);\n    }\n\n    context.resizeConstraints = {\n      min: (0,LayoutUtil/* asTRBL */.JA)(minBounds)\n    };\n  }\n\n  /**\n   * Handle resize end.\n   *\n   * @param  {Object} context\n   */\n  function handleEnd(context) {\n    var shape = context.shape,\n        canExecute = context.canExecute,\n        newBounds = context.newBounds;\n\n    if (canExecute) {\n\n      // ensure we have actual pixel values for new bounds\n      // (important when zoom level was > 1 during move)\n      newBounds = (0,LayoutUtil/* roundBounds */.aR)(newBounds);\n\n      if (!boundsChanged(shape, newBounds)) {\n\n        // no resize necessary\n        return;\n      }\n\n      // perform the actual resize\n      modeling.resizeShape(shape, newBounds);\n    }\n  }\n\n\n  eventBus.on('resize.start', function(event) {\n    handleStart(event.context);\n  });\n\n  eventBus.on('resize.move', function(event) {\n    var delta = {\n      x: event.dx,\n      y: event.dy\n    };\n\n    handleMove(event.context, delta);\n  });\n\n  eventBus.on('resize.end', function(event) {\n    handleEnd(event.context);\n  });\n\n}\n\n\nResize.prototype.canResize = function(context) {\n  var rules = this._rules;\n\n  var ctx = (0,index_esm/* pick */.ei)(context, [ 'newBounds', 'shape', 'delta', 'direction' ]);\n\n  return rules.allowed('shape.resize', ctx);\n};\n\n/**\n * Activate a resize operation.\n *\n * You may specify additional contextual information and must specify a\n * resize direction during activation of the resize event.\n *\n * @param {MouseEvent} event\n * @param {djs.model.Shape} shape\n * @param {Object|String} contextOrDirection\n */\nResize.prototype.activate = function(event, shape, contextOrDirection) {\n  var dragging = this._dragging,\n      context,\n      direction;\n\n  if (typeof contextOrDirection === 'string') {\n    contextOrDirection = {\n      direction: contextOrDirection\n    };\n  }\n\n  context = (0,index_esm/* assign */.f0)({ shape: shape }, contextOrDirection);\n\n  direction = context.direction;\n\n  if (!direction) {\n    throw new Error('must provide a direction (nw|se|ne|sw)');\n  }\n\n  var referencePoint = {\n    x: /w/.test(direction) ? shape.x : shape.x + shape.width,\n    y: /n/.test(direction) ? shape.y : shape.y + shape.height\n  };\n\n  dragging.init(event, referencePoint, 'resize', {\n    autoActivate: true,\n    cursor: 'resize-' + (/nw|se/.test(direction) ? 'nwse' : 'nesw'),\n    data: {\n      shape: shape,\n      context: context\n    }\n  });\n};\n\nResize.prototype.computeMinResizeBox = function(context) {\n  var shape = context.shape,\n      direction = context.direction,\n      minDimensions,\n      childrenBounds;\n\n  minDimensions = context.minDimensions || {\n    width: DEFAULT_MIN_WIDTH,\n    height: DEFAULT_MIN_WIDTH\n  };\n\n  // get children bounds\n  childrenBounds = (0,ResizeUtil.computeChildrenBBox)(shape, context.childrenBoxPadding);\n\n  // get correct minimum bounds from given resize direction\n  // basically ensures that the minBounds is max(childrenBounds, minDimensions)\n  return (0,ResizeUtil.getMinResizeBounds)(direction, shape, minDimensions, childrenBounds);\n};\n\n\nResize.$inject = [\n  'eventBus',\n  'rules',\n  'modeling',\n  'dragging'\n];\n\n// helpers //////////\n\nfunction boundsChanged(shape, newBounds) {\n  return shape.x !== newBounds.x ||\n    shape.y !== newBounds.y ||\n    shape.width !== newBounds.width ||\n    shape.height !== newBounds.height;\n}\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/ResizePreview.js\nvar MARKER_RESIZING = 'djs-resizing',\n    MARKER_RESIZE_NOT_OK = 'resize-not-ok';\n\nvar LOW_PRIORITY = 500;\n\n\n\n\n/**\n * Provides previews for resizing shapes when resizing.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {PreviewSupport} previewSupport\n */\nfunction ResizePreview(eventBus, canvas, previewSupport) {\n\n  /**\n   * Update resizer frame.\n   *\n   * @param {Object} context\n   */\n  function updateFrame(context) {\n\n    var shape = context.shape,\n        bounds = context.newBounds,\n        frame = context.frame;\n\n    if (!frame) {\n      frame = context.frame = previewSupport.addFrame(shape, canvas.getDefaultLayer());\n\n      canvas.addMarker(shape, MARKER_RESIZING);\n    }\n\n    if (bounds.width > 5) {\n      (0,dist_index_esm/* attr */.Lj)(frame, { x: bounds.x, width: bounds.width });\n    }\n\n    if (bounds.height > 5) {\n      (0,dist_index_esm/* attr */.Lj)(frame, { y: bounds.y, height: bounds.height });\n    }\n\n    if (context.canExecute) {\n      (0,dist_index_esm/* classes */.Sh)(frame).remove(MARKER_RESIZE_NOT_OK);\n    } else {\n      (0,dist_index_esm/* classes */.Sh)(frame).add(MARKER_RESIZE_NOT_OK);\n    }\n  }\n\n  /**\n   * Remove resizer frame.\n   *\n   * @param {Object} context\n   */\n  function removeFrame(context) {\n    var shape = context.shape,\n        frame = context.frame;\n\n    if (frame) {\n      (0,dist_index_esm/* remove */.Od)(context.frame);\n    }\n\n    canvas.removeMarker(shape, MARKER_RESIZING);\n  }\n\n  // add and update previews\n  eventBus.on('resize.move', LOW_PRIORITY, function(event) {\n    updateFrame(event.context);\n  });\n\n  // remove previews\n  eventBus.on('resize.cleanup', function(event) {\n    removeFrame(event.context);\n  });\n\n}\n\nResizePreview.$inject = [\n  'eventBus',\n  'canvas',\n  'previewSupport'\n];\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js + 1 modules\nvar Mouse = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/ResizeHandles.js\n\n\nvar HANDLE_OFFSET = -2,\n    HANDLE_SIZE = 5,\n    HANDLE_HIT_SIZE = 20;\n\nvar CLS_RESIZER = 'djs-resizer';\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * This component is responsible for adding resize handles.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {Selection} selection\n * @param {Resize} resize\n */\nfunction ResizeHandles(eventBus, canvas, selection, resize) {\n\n  this._resize = resize;\n  this._canvas = canvas;\n\n  var self = this;\n\n  eventBus.on('selection.changed', function(e) {\n    var newSelection = e.newSelection;\n\n    // remove old selection markers\n    self.removeResizers();\n\n    // add new selection markers ONLY if single selection\n    if (newSelection.length === 1) {\n      (0,index_esm/* forEach */.Ed)(newSelection, (0,index_esm/* bind */.ak)(self.addResizer, self));\n    }\n  });\n\n  eventBus.on('shape.changed', function(e) {\n    var shape = e.element;\n\n    if (selection.isSelected(shape)) {\n      self.removeResizers();\n\n      self.addResizer(shape);\n    }\n  });\n}\n\n\nResizeHandles.prototype.makeDraggable = function(element, gfx, direction) {\n  var resize = this._resize;\n\n  function startResize(event) {\n    // only trigger on left mouse button\n    if ((0,Mouse/* isPrimaryButton */.Id)(event)) {\n      resize.activate(event, element, direction);\n    }\n  }\n\n  min_dom_dist_index_esm/* event.bind */.B.bind(gfx, 'mousedown', startResize);\n  min_dom_dist_index_esm/* event.bind */.B.bind(gfx, 'touchstart', startResize);\n};\n\n\nResizeHandles.prototype._createResizer = function(element, x, y, rotation, direction) {\n  var resizersParent = this._getResizersParent();\n\n  var group = (0,dist_index_esm/* create */.Ue)('g');\n  (0,dist_index_esm/* classes */.Sh)(group).add(CLS_RESIZER);\n  (0,dist_index_esm/* classes */.Sh)(group).add(CLS_RESIZER + '-' + element.id);\n  (0,dist_index_esm/* classes */.Sh)(group).add(CLS_RESIZER + '-' + direction);\n\n  (0,dist_index_esm/* append */.R3)(resizersParent, group);\n\n  var origin = -HANDLE_SIZE + HANDLE_OFFSET;\n\n  // Create four drag indicators on the outline\n  var visual = (0,dist_index_esm/* create */.Ue)('rect');\n  (0,dist_index_esm/* attr */.Lj)(visual, {\n    x: origin,\n    y: origin,\n    width: HANDLE_SIZE,\n    height: HANDLE_SIZE\n  });\n  (0,dist_index_esm/* classes */.Sh)(visual).add(CLS_RESIZER + '-visual');\n\n  (0,dist_index_esm/* append */.R3)(group, visual);\n\n  var hit = (0,dist_index_esm/* create */.Ue)('rect');\n  (0,dist_index_esm/* attr */.Lj)(hit, {\n    x: origin,\n    y: origin,\n    width: HANDLE_HIT_SIZE,\n    height: HANDLE_HIT_SIZE\n  });\n  (0,dist_index_esm/* classes */.Sh)(hit).add(CLS_RESIZER + '-hit');\n\n  (0,dist_index_esm/* append */.R3)(group, hit);\n\n  (0,SvgTransformUtil/* transform */.vs)(group, x, y, rotation);\n\n  return group;\n};\n\nResizeHandles.prototype.createResizer = function(element, direction) {\n  var resizer;\n\n  var trbl = (0,LayoutUtil/* asTRBL */.JA)(element);\n\n  if (direction === 'nw') {\n    resizer = this._createResizer(element, trbl.left, trbl.top, 0, direction);\n  } else if (direction === 'ne') {\n    resizer = this._createResizer(element, trbl.right, trbl.top, 90, direction);\n  } else if (direction === 'se') {\n    resizer = this._createResizer(element, trbl.right, trbl.bottom, 180, direction);\n  } else {\n    resizer = this._createResizer(element, trbl.left, trbl.bottom, 270, direction);\n  }\n\n  this.makeDraggable(element, resizer, direction);\n};\n\n// resize handles implementation ///////////////////////////////\n\n/**\n * Add resizers for a given element.\n *\n * @param {djs.model.Shape} shape\n */\nResizeHandles.prototype.addResizer = function(shape) {\n  var resize = this._resize;\n\n  if (!resize.canResize({ shape: shape })) {\n    return;\n  }\n\n  this.createResizer(shape, 'nw');\n  this.createResizer(shape, 'ne');\n  this.createResizer(shape, 'se');\n  this.createResizer(shape, 'sw');\n};\n\n/**\n * Remove all resizers\n */\nResizeHandles.prototype.removeResizers = function() {\n  var resizersParent = this._getResizersParent();\n\n  (0,dist_index_esm/* clear */.ZH)(resizersParent);\n};\n\nResizeHandles.prototype._getResizersParent = function() {\n  return this._canvas.getLayer('resizers');\n};\n\nResizeHandles.$inject = [\n  'eventBus',\n  'canvas',\n  'selection',\n  'resize'\n];\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/index.js\n\n\n\n\n\n\n\n\n/* harmony default export */ const resize = ({\n  __depends__: [\n    rules/* default */.Z,\n    dragging/* default */.Z,\n    preview_support/* default */.Z\n  ],\n  __init__: [\n    'resize',\n    'resizePreview',\n    'resizeHandles'\n  ],\n  resize: [ 'type', Resize ],\n  resizePreview: [ 'type', ResizePreview ],\n  resizeHandles: [ 'type', ResizeHandles ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/resize/index.js_+_3_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/RuleProvider.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ RuleProvider)\n/* harmony export */ });\n/* harmony import */ var inherits__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/inherits/inherits_browser.js");\n/* harmony import */ var inherits__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(inherits__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/command/CommandInterceptor.js");\n\n\n\n\n/**\n * A basic provider that may be extended to implement modeling rules.\n *\n * Extensions should implement the init method to actually add their custom\n * modeling checks. Checks may be added via the #addRule(action, fn) method.\n *\n * @param {EventBus} eventBus\n */\nfunction RuleProvider(eventBus) {\n  _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_1__/* ["default"].call */ .Z.call(this, eventBus);\n\n  this.init();\n}\n\nRuleProvider.$inject = [ \'eventBus\' ];\n\ninherits__WEBPACK_IMPORTED_MODULE_0___default()(RuleProvider, _command_CommandInterceptor__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z);\n\n\n/**\n * Adds a modeling rule for the given action, implemented through\n * a callback function.\n *\n * The function will receive the modeling specific action context\n * to perform its check. It must return `false` to disallow the\n * action from happening or `true` to allow the action.\n *\n * A rule provider may pass over the evaluation to lower priority\n * rules by returning return nothing (or <code>undefined</code>).\n *\n * @example\n *\n * ResizableRules.prototype.init = function() {\n *\n *   \\/**\n *    * Return `true`, `false` or nothing to denote\n *    * _allowed_, _not allowed_ and _continue evaluating_.\n *    *\\/\n *   this.addRule(\'shape.resize\', function(context) {\n *\n *     var shape = context.shape;\n *\n *     if (!context.newBounds) {\n *       // check general resizability\n *       if (!shape.resizable) {\n *         return false;\n *       }\n *\n *       // not returning anything (read: undefined)\n *       // will continue the evaluation of other rules\n *       // (with lower priority)\n *       return;\n *     } else {\n *       // element must have minimum size of 10*10 points\n *       return context.newBounds.width > 10 && context.newBounds.height > 10;\n *     }\n *   });\n * };\n *\n * @param {String|Array<String>} actions the identifier for the modeling action to check\n * @param {Number} [priority] the priority at which this rule is being applied\n * @param {Function} fn the callback function that performs the actual check\n */\nRuleProvider.prototype.addRule = function(actions, priority, fn) {\n\n  var self = this;\n\n  if (typeof actions === \'string\') {\n    actions = [ actions ];\n  }\n\n  actions.forEach(function(action) {\n\n    self.canExecute(action, priority, function(context, action, event) {\n      return fn(context);\n    }, true);\n  });\n};\n\n/**\n * Implement this method to add new rules during provider initialization.\n */\nRuleProvider.prototype.init = function() {};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/RuleProvider.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ rules)\n});\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/Rules.js\n/**\n * A service that provides rules for certain diagram actions.\n *\n * The default implementation will hook into the {@link CommandStack}\n * to perform the actual rule evaluation. Make sure to provide the\n * `commandStack` service with this module if you plan to use it.\n *\n * Together with this implementation you may use the {@link RuleProvider}\n * to implement your own rule checkers.\n *\n * This module is ment to be easily replaced, thus the tiny foot print.\n *\n * @param {Injector} injector\n */\nfunction Rules(injector) {\n  this._commandStack = injector.get('commandStack', false);\n}\n\nRules.$inject = [ 'injector' ];\n\n\n/**\n * Returns whether or not a given modeling action can be executed\n * in the specified context.\n *\n * This implementation will respond with allow unless anyone\n * objects.\n *\n * @param {String} action the action to be checked\n * @param {Object} [context] the context to check the action in\n *\n * @return {Boolean} returns true, false or null depending on whether the\n *                   operation is allowed, not allowed or should be ignored.\n */\nRules.prototype.allowed = function(action, context) {\n  var allowed = true;\n\n  var commandStack = this._commandStack;\n\n  if (commandStack) {\n    allowed = commandStack.canExecute(action, context);\n  }\n\n  // map undefined to true, i.e. no rules\n  return allowed === undefined ? true : allowed;\n};\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js\n\n\n/* harmony default export */ const rules = ({\n  __init__: [ 'rules' ],\n  rules: [ 'type', Rules ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/search-pad/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ search_pad)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/overlays/index.js + 2 modules\nvar overlays = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/overlays/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/css.escape/css.escape.js\nvar css_escape = __webpack_require__(\"./node_modules/css.escape/css.escape.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/EscapeUtil.js\n\n\nvar HTML_ESCAPE_MAP = {\n  '&': '&amp;',\n  '<': '&lt;',\n  '>': '&gt;',\n  '\"': '&quot;',\n  '\\'': '&#39;'\n};\n\nfunction escapeHTML(str) {\n  str = '' + str;\n\n  return str && str.replace(/[&<>\"']/g, function(match) {\n    return HTML_ESCAPE_MAP[match];\n  });\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/search-pad/SearchPad.js\n\n\n\n\n\n\n/**\n * Provides searching infrastructure\n */\nfunction SearchPad(canvas, eventBus, overlays, selection) {\n  this._open = false;\n  this._results = [];\n  this._eventMaps = [];\n\n  this._canvas = canvas;\n  this._eventBus = eventBus;\n  this._overlays = overlays;\n  this._selection = selection;\n\n  // setup elements\n  this._container = (0,index_esm/* domify */.H6)(SearchPad.BOX_HTML);\n  this._searchInput = (0,index_esm/* query */.IO)(SearchPad.INPUT_SELECTOR, this._container);\n  this._resultsContainer = (0,index_esm/* query */.IO)(SearchPad.RESULTS_CONTAINER_SELECTOR, this._container);\n\n  // attach search pad\n  this._canvas.getContainer().appendChild(this._container);\n\n  // cleanup on destroy\n  eventBus.on([ 'canvas.destroy', 'diagram.destroy' ], this.close, this);\n}\n\n\nSearchPad.$inject = [\n  'canvas',\n  'eventBus',\n  'overlays',\n  'selection'\n];\n\n\n/**\n * Binds and keeps track of all event listereners\n */\nSearchPad.prototype._bindEvents = function() {\n  var self = this;\n\n  function listen(el, selector, type, fn) {\n    self._eventMaps.push({\n      el: el,\n      type: type,\n      listener: index_esm/* delegate.bind */.cl.bind(el, selector, type, fn)\n    });\n  }\n\n  // close search on clicking anywhere outside\n  listen(document, 'html', 'click', function(e) {\n    self.close();\n  }, true);\n\n  // stop event from propagating and closing search\n  // focus on input\n  listen(this._container, SearchPad.INPUT_SELECTOR, 'click', function(e) {\n    e.stopPropagation();\n    e.delegateTarget.focus();\n  });\n\n  // preselect result on hover\n  listen(this._container, SearchPad.RESULT_SELECTOR, 'mouseover', function(e) {\n    e.stopPropagation();\n    self._scrollToNode(e.delegateTarget);\n    self._preselect(e.delegateTarget);\n  });\n\n  // selects desired result on mouse click\n  listen(this._container, SearchPad.RESULT_SELECTOR, 'click', function(e) {\n    e.stopPropagation();\n    self._select(e.delegateTarget);\n  });\n\n  // prevent cursor in input from going left and right when using up/down to\n  // navigate results\n  listen(this._container, SearchPad.INPUT_SELECTOR, 'keydown', function(e) {\n    // up\n    if (e.keyCode === 38) {\n      e.preventDefault();\n    }\n\n    // down\n    if (e.keyCode === 40) {\n      e.preventDefault();\n    }\n  });\n\n  // handle keyboard input\n  listen(this._container, SearchPad.INPUT_SELECTOR, 'keyup', function(e) {\n    // escape\n    if (e.keyCode === 27) {\n      return self.close();\n    }\n\n    // enter\n    if (e.keyCode === 13) {\n      var selected = self._getCurrentResult();\n\n      return selected ? self._select(selected) : self.close();\n    }\n\n    // up\n    if (e.keyCode === 38) {\n      return self._scrollToDirection(true);\n    }\n\n    // down\n    if (e.keyCode === 40) {\n      return self._scrollToDirection();\n    }\n\n    // left && right\n    // do not search while navigating text input\n    if (e.keyCode === 37 || e.keyCode === 39) {\n      return;\n    }\n\n    // anything else\n    self._search(e.delegateTarget.value);\n  });\n};\n\n\n/**\n * Unbinds all previously established listeners\n */\nSearchPad.prototype._unbindEvents = function() {\n  this._eventMaps.forEach(function(m) {\n    index_esm/* delegate.unbind */.cl.unbind(m.el, m.type, m.listener);\n  });\n};\n\n\n/**\n * Performs a search for the given pattern.\n *\n * @param  {String} pattern\n */\nSearchPad.prototype._search = function(pattern) {\n  var self = this;\n\n  this._clearResults();\n\n  // do not search on empty query\n  if (!pattern || pattern === '') {\n    return;\n  }\n\n  var searchResults = this._searchProvider.find(pattern);\n\n  if (!searchResults.length) {\n    return;\n  }\n\n  // append new results\n  searchResults.forEach(function(result) {\n    var id = result.element.id;\n    var node = self._createResultNode(result, id);\n    self._results[id] = {\n      element: result.element,\n      node: node\n    };\n  });\n\n  // preselect first result\n  var node = (0,index_esm/* query */.IO)(SearchPad.RESULT_SELECTOR, this._resultsContainer);\n  this._scrollToNode(node);\n  this._preselect(node);\n};\n\n\n/**\n * Navigate to the previous/next result. Defaults to next result.\n * @param  {Boolean} previous\n */\nSearchPad.prototype._scrollToDirection = function(previous) {\n  var selected = this._getCurrentResult();\n  if (!selected) {\n    return;\n  }\n\n  var node = previous ? selected.previousElementSibling : selected.nextElementSibling;\n  if (node) {\n    this._scrollToNode(node);\n    this._preselect(node);\n  }\n};\n\n\n/**\n * Scroll to the node if it is not visible.\n *\n * @param  {Element} node\n */\nSearchPad.prototype._scrollToNode = function(node) {\n  if (!node || node === this._getCurrentResult()) {\n    return;\n  }\n\n  var nodeOffset = node.offsetTop;\n  var containerScroll = this._resultsContainer.scrollTop;\n\n  var bottomScroll = nodeOffset - this._resultsContainer.clientHeight + node.clientHeight;\n\n  if (nodeOffset < containerScroll) {\n    this._resultsContainer.scrollTop = nodeOffset;\n  } else if (containerScroll < bottomScroll) {\n    this._resultsContainer.scrollTop = bottomScroll;\n  }\n};\n\n\n/**\n * Clears all results data.\n */\nSearchPad.prototype._clearResults = function() {\n  (0,index_esm/* clear */.ZH)(this._resultsContainer);\n\n  this._results = [];\n\n  this._resetOverlay();\n\n  this._eventBus.fire('searchPad.cleared');\n};\n\n\n/**\n * Get currently selected result.\n *\n * @return {Element}\n */\nSearchPad.prototype._getCurrentResult = function() {\n  return (0,index_esm/* query */.IO)(SearchPad.RESULT_SELECTED_SELECTOR, this._resultsContainer);\n};\n\n\n/**\n * Create result DOM element within results container\n * that corresponds to a search result.\n *\n * 'result' : one of the elements returned by SearchProvider\n * 'id' : id attribute value to assign to the new DOM node\n * return : created DOM element\n *\n * @param  {SearchResult} result\n * @param  {String} id\n * @return {Element}\n */\nSearchPad.prototype._createResultNode = function(result, id) {\n  var node = (0,index_esm/* domify */.H6)(SearchPad.RESULT_HTML);\n\n  // create only if available\n  if (result.primaryTokens.length > 0) {\n    createInnerTextNode(node, result.primaryTokens, SearchPad.RESULT_PRIMARY_HTML);\n  }\n\n  // secondary tokens (represent element ID) are allways available\n  createInnerTextNode(node, result.secondaryTokens, SearchPad.RESULT_SECONDARY_HTML);\n\n  (0,index_esm/* attr */.Lj)(node, SearchPad.RESULT_ID_ATTRIBUTE, id);\n\n  this._resultsContainer.appendChild(node);\n\n  return node;\n};\n\n\n/**\n * Register search element provider.\n *\n * SearchProvider.find - provides search function over own elements\n *  (pattern) => [{ text: <String>, element: <Element>}, ...]\n *\n * @param  {SearchProvider} provider\n */\nSearchPad.prototype.registerProvider = function(provider) {\n  this._searchProvider = provider;\n};\n\n\n/**\n * Open search pad.\n */\nSearchPad.prototype.open = function() {\n  if (!this._searchProvider) {\n    throw new Error('no search provider registered');\n  }\n\n  if (this.isOpen()) {\n    return;\n  }\n\n  this._bindEvents();\n\n  this._open = true;\n\n  (0,index_esm/* classes */.Sh)(this._container).add('open');\n\n  this._searchInput.focus();\n\n  this._eventBus.fire('searchPad.opened');\n};\n\n\n/**\n * Close search pad.\n */\nSearchPad.prototype.close = function() {\n  if (!this.isOpen()) {\n    return;\n  }\n\n  this._unbindEvents();\n\n  this._open = false;\n\n  (0,index_esm/* classes */.Sh)(this._container).remove('open');\n\n  this._clearResults();\n\n  this._searchInput.value = '';\n  this._searchInput.blur();\n\n  this._resetOverlay();\n\n  this._eventBus.fire('searchPad.closed');\n};\n\n\n/**\n * Toggles search pad on/off.\n */\nSearchPad.prototype.toggle = function() {\n  this.isOpen() ? this.close() : this.open();\n};\n\n\n/**\n * Report state of search pad.\n */\nSearchPad.prototype.isOpen = function() {\n  return this._open;\n};\n\n\n/**\n * Preselect result entry.\n *\n * @param  {Element} element\n */\nSearchPad.prototype._preselect = function(node) {\n  var selectedNode = this._getCurrentResult();\n\n  // already selected\n  if (node === selectedNode) {\n    return;\n  }\n\n  // removing preselection from current node\n  if (selectedNode) {\n    (0,index_esm/* classes */.Sh)(selectedNode).remove(SearchPad.RESULT_SELECTED_CLASS);\n  }\n\n  var id = (0,index_esm/* attr */.Lj)(node, SearchPad.RESULT_ID_ATTRIBUTE);\n  var element = this._results[id].element;\n\n  (0,index_esm/* classes */.Sh)(node).add(SearchPad.RESULT_SELECTED_CLASS);\n\n  this._resetOverlay(element);\n\n  this._centerViewbox(element);\n\n  this._selection.select(element);\n\n  this._eventBus.fire('searchPad.preselected', element);\n};\n\n\n/**\n * Select result node.\n *\n * @param  {Element} element\n */\nSearchPad.prototype._select = function(node) {\n  var id = (0,index_esm/* attr */.Lj)(node, SearchPad.RESULT_ID_ATTRIBUTE);\n  var element = this._results[id].element;\n\n  this.close();\n\n  this._resetOverlay();\n\n  this._centerViewbox(element);\n\n  this._selection.select(element);\n\n  this._eventBus.fire('searchPad.selected', element);\n};\n\n\n/**\n * Center viewbox on the element middle point.\n *\n * @param  {Element} element\n */\nSearchPad.prototype._centerViewbox = function(element) {\n  var viewbox = this._canvas.viewbox();\n\n  var box = (0,Elements/* getBBox */.jY)(element);\n\n  var newViewbox = {\n    x: (box.x + box.width/2) - viewbox.outer.width/2,\n    y: (box.y + box.height/2) - viewbox.outer.height/2,\n    width: viewbox.outer.width,\n    height: viewbox.outer.height\n  };\n\n  this._canvas.viewbox(newViewbox);\n\n  this._canvas.zoom(viewbox.scale);\n};\n\n\n/**\n * Reset overlay removes and, optionally, set\n * overlay to a new element.\n *\n * @param  {Element} element\n */\nSearchPad.prototype._resetOverlay = function(element) {\n  if (this._overlayId) {\n    this._overlays.remove(this._overlayId);\n  }\n\n  if (element) {\n    var box = (0,Elements/* getBBox */.jY)(element);\n    var overlay = constructOverlay(box);\n    this._overlayId = this._overlays.add(element, overlay);\n  }\n};\n\n\n/**\n * Construct overlay object for the given bounding box.\n *\n * @param  {BoundingBox} box\n * @return {Object}\n */\nfunction constructOverlay(box) {\n\n  var offset = 6;\n  var w = box.width + offset * 2;\n  var h = box.height + offset * 2;\n\n  var styles = [\n    'width: '+ w +'px',\n    'height: '+ h + 'px'\n  ].join('; ');\n\n  return {\n    position: {\n      bottom: h - offset,\n      right: w - offset\n    },\n    show: true,\n    html: '<div style=\"' + styles + '\" class=\"' + SearchPad.OVERLAY_CLASS + '\"></div>'\n  };\n}\n\n\n/**\n * Creates and appends child node from result tokens and HTML template.\n *\n * @param  {Element} node\n * @param  {Array<Object>} tokens\n * @param  {String} template\n */\nfunction createInnerTextNode(parentNode, tokens, template) {\n  var text = createHtmlText(tokens);\n  var childNode = (0,index_esm/* domify */.H6)(template);\n  childNode.innerHTML = text;\n  parentNode.appendChild(childNode);\n}\n\n/**\n * Create internal HTML markup from result tokens.\n * Caters for highlighting pattern matched tokens.\n *\n * @param  {Array<Object>} tokens\n * @return {String}\n */\nfunction createHtmlText(tokens) {\n  var htmlText = '';\n\n  tokens.forEach(function(t) {\n    if (t.matched) {\n      htmlText += '<strong class=\"' + SearchPad.RESULT_HIGHLIGHT_CLASS + '\">' + escapeHTML(t.matched) + '</strong>';\n    } else {\n      htmlText += escapeHTML(t.normal);\n    }\n  });\n\n  return htmlText !== '' ? htmlText : null;\n}\n\n\n/**\n * CONSTANTS\n */\nSearchPad.CONTAINER_SELECTOR = '.djs-search-container';\nSearchPad.INPUT_SELECTOR = '.djs-search-input input';\nSearchPad.RESULTS_CONTAINER_SELECTOR = '.djs-search-results';\nSearchPad.RESULT_SELECTOR = '.djs-search-result';\nSearchPad.RESULT_SELECTED_CLASS = 'djs-search-result-selected';\nSearchPad.RESULT_SELECTED_SELECTOR = '.' + SearchPad.RESULT_SELECTED_CLASS;\nSearchPad.RESULT_ID_ATTRIBUTE = 'data-result-id';\nSearchPad.RESULT_HIGHLIGHT_CLASS = 'djs-search-highlight';\nSearchPad.OVERLAY_CLASS = 'djs-search-overlay';\n\nSearchPad.BOX_HTML =\n  '<div class=\"djs-search-container djs-draggable djs-scrollable\">' +\n    '<div class=\"djs-search-input\">' +\n      '<input type=\"text\"/>' +\n    '</div>' +\n    '<div class=\"djs-search-results\"></div>' +\n  '</div>';\n\nSearchPad.RESULT_HTML =\n  '<div class=\"djs-search-result\"></div>';\n\nSearchPad.RESULT_PRIMARY_HTML =\n  '<div class=\"djs-search-result-primary\"></div>';\n\nSearchPad.RESULT_SECONDARY_HTML =\n  '<p class=\"djs-search-result-secondary\"></p>';\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/search-pad/index.js\n\n\n\n\n\n/* harmony default export */ const search_pad = ({\n  __depends__: [\n    overlays/* default */.Z,\n    selection/* default */.Z\n  ],\n  searchPad: [ 'type', SearchPad ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/search-pad/index.js_+_2_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ selection)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/index.js\nvar outline = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/outline/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/Selection.js\n\n\n\n/**\n * A service that offers the current selection in a diagram.\n * Offers the api to control the selection, too.\n *\n * @class\n *\n * @param {EventBus} eventBus the event bus\n */\nfunction Selection(eventBus) {\n\n  this._eventBus = eventBus;\n\n  this._selectedElements = [];\n\n  var self = this;\n\n  eventBus.on([ 'shape.remove', 'connection.remove' ], function(e) {\n    var element = e.element;\n    self.deselect(element);\n  });\n\n  eventBus.on([ 'diagram.clear' ], function(e) {\n    self.select(null);\n  });\n}\n\nSelection.$inject = [ 'eventBus' ];\n\n\nSelection.prototype.deselect = function(element) {\n  var selectedElements = this._selectedElements;\n\n  var idx = selectedElements.indexOf(element);\n\n  if (idx !== -1) {\n    var oldSelection = selectedElements.slice();\n\n    selectedElements.splice(idx, 1);\n\n    this._eventBus.fire('selection.changed', { oldSelection: oldSelection, newSelection: selectedElements });\n  }\n};\n\n\nSelection.prototype.get = function() {\n  return this._selectedElements;\n};\n\nSelection.prototype.isSelected = function(element) {\n  return this._selectedElements.indexOf(element) !== -1;\n};\n\n\n/**\n * This method selects one or more elements on the diagram.\n *\n * By passing an additional add parameter you can decide whether or not the element(s)\n * should be added to the already existing selection or not.\n *\n * @method Selection#select\n *\n * @param  {Object|Object[]} elements element or array of elements to be selected\n * @param  {boolean} [add] whether the element(s) should be appended to the current selection, defaults to false\n */\nSelection.prototype.select = function(elements, add) {\n  var selectedElements = this._selectedElements,\n      oldSelection = selectedElements.slice();\n\n  if (!(0,index_esm/* isArray */.kJ)(elements)) {\n    elements = elements ? [ elements ] : [];\n  }\n\n  // selection may be cleared by passing an empty array or null\n  // to the method\n  if (add) {\n    (0,index_esm/* forEach */.Ed)(elements, function(element) {\n      if (selectedElements.indexOf(element) !== -1) {\n        // already selected\n        return;\n      } else {\n        selectedElements.push(element);\n      }\n    });\n  } else {\n    this._selectedElements = selectedElements = elements.slice();\n  }\n\n  this._eventBus.fire('selection.changed', { oldSelection: oldSelection, newSelection: selectedElements });\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/SelectionVisuals.js\n\n\nvar MARKER_HOVER = 'hover',\n    MARKER_SELECTED = 'selected';\n\n\n/**\n * A plugin that adds a visible selection UI to shapes and connections\n * by appending the <code>hover</code> and <code>selected</code> classes to them.\n *\n * @class\n *\n * Makes elements selectable, too.\n *\n * @param {EventBus} events\n * @param {SelectionService} selection\n * @param {Canvas} canvas\n */\nfunction SelectionVisuals(events, canvas, selection, styles) {\n\n  this._multiSelectionBox = null;\n\n  function addMarker(e, cls) {\n    canvas.addMarker(e, cls);\n  }\n\n  function removeMarker(e, cls) {\n    canvas.removeMarker(e, cls);\n  }\n\n  events.on('element.hover', function(event) {\n    addMarker(event.element, MARKER_HOVER);\n  });\n\n  events.on('element.out', function(event) {\n    removeMarker(event.element, MARKER_HOVER);\n  });\n\n  events.on('selection.changed', function(event) {\n\n    function deselect(s) {\n      removeMarker(s, MARKER_SELECTED);\n    }\n\n    function select(s) {\n      addMarker(s, MARKER_SELECTED);\n    }\n\n    var oldSelection = event.oldSelection,\n        newSelection = event.newSelection;\n\n    (0,index_esm/* forEach */.Ed)(oldSelection, function(e) {\n      if (newSelection.indexOf(e) === -1) {\n        deselect(e);\n      }\n    });\n\n    (0,index_esm/* forEach */.Ed)(newSelection, function(e) {\n      if (oldSelection.indexOf(e) === -1) {\n        select(e);\n      }\n    });\n  });\n}\n\nSelectionVisuals.$inject = [\n  'eventBus',\n  'canvas',\n  'selection',\n  'styles'\n];\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js + 1 modules\nvar Mouse = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/SelectionBehavior.js\n\n\n\n\n\nfunction SelectionBehavior(\n    eventBus, selection, canvas,\n    elementRegistry) {\n\n  eventBus.on('create.end', 500, function(e) {\n\n    // select the created shape after a\n    // successful create operation\n    if (e.context.canExecute) {\n      selection.select(e.context.shape);\n    }\n  });\n\n  eventBus.on('connect.end', 500, function(e) {\n\n    // select the connect end target\n    // after a connect operation\n    if (e.context.canExecute && e.context.target) {\n      selection.select(e.context.target);\n    }\n  });\n\n  eventBus.on('shape.move.end', 500, function(e) {\n    var previousSelection = e.previousSelection || [];\n\n    var shape = elementRegistry.get(e.context.shape.id);\n\n    // make sure at least the main moved element is being\n    // selected after a move operation\n    var inSelection = (0,index_esm/* find */.sE)(previousSelection, function(selectedShape) {\n      return shape.id === selectedShape.id;\n    });\n\n    if (!inSelection) {\n      selection.select(shape);\n    }\n  });\n\n  // Shift + click selection\n  eventBus.on('element.click', function(event) {\n\n    var element = event.element;\n\n    // do not select the root element\n    // or connections\n    if (element === canvas.getRootElement()) {\n      element = null;\n    }\n\n    var isSelected = selection.isSelected(element),\n        isMultiSelect = selection.get().length > 1;\n\n    // mouse-event: SELECTION_KEY\n    var add = (0,Mouse/* hasPrimaryModifier */.RJ)(event);\n\n    // select OR deselect element in multi selection\n    if (isSelected && isMultiSelect) {\n      if (add) {\n        return selection.deselect(element);\n      } else {\n        return selection.select(element);\n      }\n    } else\n    if (!isSelected) {\n      selection.select(element, add);\n    } else {\n      selection.deselect(element);\n    }\n  });\n}\n\nSelectionBehavior.$inject = [\n  'eventBus',\n  'selection',\n  'canvas',\n  'elementRegistry'\n];\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js\n\n\n\n\n\n\n\n\n/* harmony default export */ const selection = ({\n  __init__: [ 'selectionVisuals', 'selectionBehavior' ],\n  __depends__: [\n    interaction_events/* default */.Z,\n    outline/* default */.Z\n  ],\n  selection: [ 'type', Selection ],\n  selectionVisuals: [ 'type', SelectionVisuals ],\n  selectionBehavior: [ 'type', SelectionBehavior ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/selection/index.js_+_3_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ CreateMoveSnapping)\n/* harmony export */ });\n/* harmony import */ var _SnapContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapContext.js\");\n/* harmony import */ var _SnapUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n/* harmony import */ var _keyboard_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nvar HIGHER_PRIORITY = 1250;\r\n\r\n\r\n/**\r\n * Snap during create and move.\r\n *\r\n * @param {EventBus} eventBus\r\n * @param {Snapping} snapping\r\n */\r\nfunction CreateMoveSnapping(eventBus, snapping) {\r\n  var self = this;\r\n\r\n  eventBus.on([\r\n    'create.start',\r\n    'shape.move.start'\r\n  ], function(event) {\r\n    self.initSnap(event);\r\n  });\r\n\r\n  eventBus.on([\r\n    'create.move',\r\n    'create.end',\r\n    'shape.move.move',\r\n    'shape.move.end'\r\n  ], HIGHER_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        shape = context.shape,\r\n        snapContext = context.snapContext,\r\n        target = context.target;\r\n\r\n    if (event.originalEvent && (0,_keyboard_KeyboardUtil__WEBPACK_IMPORTED_MODULE_0__/* .isCmd */ .JS)(event.originalEvent)) {\r\n      return;\r\n    }\r\n\r\n    if ((0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__.isSnapped)(event) || !target) {\r\n      return;\r\n    }\r\n\r\n    var snapPoints = snapContext.pointsForTarget(target);\r\n\r\n    if (!snapPoints.initialized) {\r\n      snapPoints = self.addSnapTargetPoints(snapPoints, shape, target);\r\n\r\n      snapPoints.initialized = true;\r\n    }\r\n\r\n    snapping.snap(event, snapPoints);\r\n  });\r\n\r\n  eventBus.on([\r\n    'create.cleanup',\r\n    'shape.move.cleanup'\r\n  ], function() {\r\n    snapping.hide();\r\n  });\r\n}\r\n\r\nCreateMoveSnapping.$inject = [\r\n  'eventBus',\r\n  'snapping'\r\n];\r\n\r\nCreateMoveSnapping.prototype.initSnap = function(event) {\r\n  var context = event.context,\r\n      shape = context.shape,\r\n      snapContext = context.snapContext;\r\n\r\n  if (!snapContext) {\r\n    snapContext = context.snapContext = new _SnapContext__WEBPACK_IMPORTED_MODULE_2__/* [\"default\"] */ .Z();\r\n  }\r\n\r\n  var shapeMid = (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__.mid)(shape, event),\r\n      shapeTopLeft = {\r\n        x: shapeMid.x - shape.width / 2,\r\n        y: shapeMid.y - shape.height / 2\r\n      },\r\n      shapeBottomRight = {\r\n        x: shapeMid.x + shape.width / 2,\r\n        y: shapeMid.y + shape.height / 2\r\n      };\r\n\r\n  snapContext.setSnapOrigin('mid', {\r\n    x: shapeMid.x - event.x,\r\n    y: shapeMid.y - event.y\r\n  });\r\n\r\n  // snap labels to mid only\r\n  if (isLabel(shape)) {\r\n    return snapContext;\r\n  }\r\n\r\n  snapContext.setSnapOrigin('top-left', {\r\n    x: shapeTopLeft.x - event.x,\r\n    y: shapeTopLeft.y - event.y\r\n  });\r\n\r\n  snapContext.setSnapOrigin('bottom-right', {\r\n    x: shapeBottomRight.x - event.x,\r\n    y: shapeBottomRight.y - event.y\r\n  });\r\n\r\n  return snapContext;\r\n};\r\n\r\nCreateMoveSnapping.prototype.addSnapTargetPoints = function(snapPoints, shape, target) {\r\n  var snapTargets = this.getSnapTargets(shape, target);\r\n\r\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .forEach */ .Ed)(snapTargets, function(snapTarget) {\r\n\r\n    // handle labels\r\n    if (isLabel(snapTarget)) {\r\n\r\n      if (isLabel(shape)) {\r\n        snapPoints.add('mid', (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__.mid)(snapTarget));\r\n      }\r\n\r\n      return;\r\n    }\r\n\r\n    // handle connections\r\n    if (isConnection(snapTarget)) {\r\n\r\n      // ignore single segment connections\r\n      if (snapTarget.waypoints.length < 3) {\r\n        return;\r\n      }\r\n\r\n      // ignore first and last waypoint\r\n      var waypoints = snapTarget.waypoints.slice(1, -1);\r\n\r\n      (0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .forEach */ .Ed)(waypoints, function(waypoint) {\r\n        snapPoints.add('mid', waypoint);\r\n      });\r\n\r\n      return;\r\n    }\r\n\r\n    // handle shapes\r\n    snapPoints.add('mid', (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__.mid)(snapTarget));\r\n  });\r\n\r\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(shape.x) || !(0,min_dash__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .hj)(shape.y)) {\r\n    return snapPoints;\r\n  }\r\n\r\n  snapPoints.add('mid', (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__.mid)(shape));\r\n\r\n  return snapPoints;\r\n};\r\n\r\nCreateMoveSnapping.prototype.getSnapTargets = function(shape, target) {\r\n  return (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_1__.getChildren)(target).filter(function(child) {\r\n    return !isHidden(child);\r\n  });\r\n};\r\n\r\n// helpers //////////\r\n\r\nfunction isConnection(element) {\r\n  return !!element.waypoints;\r\n}\r\n\r\nfunction isHidden(element) {\r\n  return !!element.hidden;\r\n}\r\n\r\nfunction isLabel(element) {\r\n  return !!element.labelTarget;\r\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapContext.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ SnapContext)\n/* harmony export */ });\n/* unused harmony export SnapPoints */\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/min-dash/dist/index.esm.js");\n/* harmony import */ var _SnapUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js");\n\n\n\n\n\n/**\n * A snap context, containing the (possibly incomplete)\n * mappings of drop targets (to identify the snapping)\n * to computed snap points.\n */\nfunction SnapContext() {\n\n  /**\n   * Map<String, SnapPoints> mapping drop targets to\n   * a list of possible snappings.\n   *\n   * @type {Object}\n   */\n  this._targets = {};\n\n  /**\n   * Map<String, Point> initial positioning of element\n   * regarding various snap directions.\n   *\n   * @type {Object}\n   */\n  this._snapOrigins = {};\n\n  /**\n   * List of snap locations\n   *\n   * @type {Array<String>}\n   */\n  this._snapLocations = [];\n\n  /**\n   * Map<String, Array<Point>> of default snapping locations\n   *\n   * @type {Object}\n   */\n  this._defaultSnaps = {};\n}\n\n\nSnapContext.prototype.getSnapOrigin = function(snapLocation) {\n  return this._snapOrigins[snapLocation];\n};\n\n\nSnapContext.prototype.setSnapOrigin = function(snapLocation, initialValue) {\n  this._snapOrigins[snapLocation] = initialValue;\n\n  if (this._snapLocations.indexOf(snapLocation) === -1) {\n    this._snapLocations.push(snapLocation);\n  }\n};\n\n\nSnapContext.prototype.addDefaultSnap = function(type, point) {\n\n  var snapValues = this._defaultSnaps[type];\n\n  if (!snapValues) {\n    snapValues = this._defaultSnaps[type] = [];\n  }\n\n  snapValues.push(point);\n};\n\n/**\n * Return a number of initialized snaps, i.e. snap locations such as\n * top-left, mid, bottom-right and so forth.\n *\n * @return {Array<String>} snapLocations\n */\nSnapContext.prototype.getSnapLocations = function() {\n  return this._snapLocations;\n};\n\n/**\n * Set the snap locations for this context.\n *\n * The order of locations determines precedence.\n *\n * @param {Array<String>} snapLocations\n */\nSnapContext.prototype.setSnapLocations = function(snapLocations) {\n  this._snapLocations = snapLocations;\n};\n\n/**\n * Get snap points for a given target\n *\n * @param {Element|String} target\n */\nSnapContext.prototype.pointsForTarget = function(target) {\n\n  var targetId = target.id || target;\n\n  var snapPoints = this._targets[targetId];\n\n  if (!snapPoints) {\n    snapPoints = this._targets[targetId] = new SnapPoints();\n    snapPoints.initDefaults(this._defaultSnaps);\n  }\n\n  return snapPoints;\n};\n\n\n/**\n * Creates the snap points and initializes them with the\n * given default values.\n *\n * @param {Object<String, Array<Point>>} [defaultPoints]\n */\nfunction SnapPoints(defaultSnaps) {\n\n  /**\n   * Map<String, Map<(x|y), Array<Number>>> mapping snap locations,\n   * i.e. top-left, bottom-right, center to actual snap values.\n   *\n   * @type {Object}\n   */\n  this._snapValues = {};\n}\n\nSnapPoints.prototype.add = function(snapLocation, point) {\n\n  var snapValues = this._snapValues[snapLocation];\n\n  if (!snapValues) {\n    snapValues = this._snapValues[snapLocation] = { x: [], y: [] };\n  }\n\n  if (snapValues.x.indexOf(point.x) === -1) {\n    snapValues.x.push(point.x);\n  }\n\n  if (snapValues.y.indexOf(point.y) === -1) {\n    snapValues.y.push(point.y);\n  }\n};\n\n\nSnapPoints.prototype.snap = function(point, snapLocation, axis, tolerance) {\n  var snappingValues = this._snapValues[snapLocation];\n\n  return snappingValues && (0,_SnapUtil__WEBPACK_IMPORTED_MODULE_0__.snapTo)(point[axis], snappingValues[axis], tolerance);\n};\n\n/**\n * Initialize a number of default snapping points.\n *\n * @param  {Object} defaultSnaps\n */\nSnapPoints.prototype.initDefaults = function(defaultSnaps) {\n\n  var self = this;\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .forEach */ .Ed)(defaultSnaps || {}, function(snapPoints, snapLocation) {\n    (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .forEach */ .Ed)(snapPoints, function(point) {\n      self.add(snapLocation, point);\n    });\n  });\n};\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapContext.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "bottomLeft": () => (/* binding */ bottomLeft),\n/* harmony export */   "bottomRight": () => (/* binding */ bottomRight),\n/* harmony export */   "getChildren": () => (/* binding */ getChildren),\n/* harmony export */   "isSnapped": () => (/* binding */ isSnapped),\n/* harmony export */   "mid": () => (/* binding */ mid),\n/* harmony export */   "setSnapped": () => (/* binding */ setSnapped),\n/* harmony export */   "snapTo": () => (/* binding */ snapTo),\n/* harmony export */   "topLeft": () => (/* binding */ topLeft),\n/* harmony export */   "topRight": () => (/* binding */ topRight)\n/* harmony export */ });\nvar abs = Math.abs,\n    round = Math.round;\n\n\n/**\n * Snap value to a collection of reference values.\n *\n * @param  {Number} value\n * @param  {Array<Number>} values\n * @param  {Number} [tolerance=10]\n *\n * @return {Number} the value we snapped to or null, if none snapped\n */\nfunction snapTo(value, values, tolerance) {\n  tolerance = tolerance === undefined ? 10 : tolerance;\n\n  var idx, snapValue;\n\n  for (idx = 0; idx < values.length; idx++) {\n    snapValue = values[idx];\n\n    if (abs(snapValue - value) <= tolerance) {\n      return snapValue;\n    }\n  }\n}\n\n\nfunction topLeft(bounds) {\n  return {\n    x: bounds.x,\n    y: bounds.y\n  };\n}\n\nfunction topRight(bounds) {\n  return {\n    x: bounds.x + bounds.width,\n    y: bounds.y\n  };\n}\n\nfunction bottomLeft(bounds) {\n  return {\n    x: bounds.x,\n    y: bounds.y + bounds.height\n  };\n}\n\nfunction bottomRight(bounds) {\n  return {\n    x: bounds.x + bounds.width,\n    y: bounds.y + bounds.height\n  };\n}\n\nfunction mid(bounds, defaultValue) {\n\n  if (!bounds || isNaN(bounds.x) || isNaN(bounds.y)) {\n    return defaultValue;\n  }\n\n  return {\n    x: round(bounds.x + bounds.width / 2),\n    y: round(bounds.y + bounds.height / 2)\n  };\n}\n\n\n/**\n * Retrieve the snap state of the given event.\n *\n * @param  {Event} event\n * @param  {String} axis\n *\n * @return {Boolean} the snapped state\n *\n */\nfunction isSnapped(event, axis) {\n  var snapped = event.snapped;\n\n  if (!snapped) {\n    return false;\n  }\n\n  if (typeof axis === \'string\') {\n    return snapped[axis];\n  }\n\n  return snapped.x && snapped.y;\n}\n\n\n/**\n * Set the given event as snapped.\n *\n * This method may change the x and/or y position of the shape\n * from the given event!\n *\n * @param {Event} event\n * @param {String} axis\n * @param {Number|Boolean} value\n *\n * @return {Number} old value\n */\nfunction setSnapped(event, axis, value) {\n  if (typeof axis !== \'string\') {\n    throw new Error(\'axis must be in [x, y]\');\n  }\n\n  if (typeof value !== \'number\' && value !== false) {\n    throw new Error(\'value must be Number or false\');\n  }\n\n  var delta,\n      previousValue = event[axis];\n\n  var snapped = event.snapped = (event.snapped || {});\n\n\n  if (value === false) {\n    snapped[axis] = false;\n  } else {\n    snapped[axis] = true;\n\n    delta = value - previousValue;\n\n    event[axis] += delta;\n    event[\'d\' + axis] += delta;\n  }\n\n  return previousValue;\n}\n\n/**\n * Get children of a shape.\n *\n * @param {djs.model.Shape} parent\n *\n * @returns {Array<djs.model.Shape|djs.model.Connection>}\n */\nfunction getChildren(parent) {\n  return parent.children || [];\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ snapping)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js\nvar CreateMoveSnapping = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapContext.js\nvar SnapContext = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapContext.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js\nvar SnapUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/ResizeSnapping.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nvar HIGHER_PRIORITY = 1250;\r\n\r\n\r\n/**\r\n * Snap during resize.\r\n *\r\n * @param {EventBus} eventBus\r\n * @param {Snapping} snapping\r\n */\r\nfunction ResizeSnapping(eventBus, snapping) {\r\n  var self = this;\r\n\r\n  eventBus.on([ 'resize.start' ], function(event) {\r\n    self.initSnap(event);\r\n  });\r\n\r\n  eventBus.on([\r\n    'resize.move',\r\n    'resize.end',\r\n  ], HIGHER_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        shape = context.shape,\r\n        parent = shape.parent,\r\n        direction = context.direction,\r\n        snapContext = context.snapContext;\r\n\r\n    if (event.originalEvent && (0,KeyboardUtil/* isCmd */.JS)(event.originalEvent)) {\r\n      return;\r\n    }\r\n\r\n    if ((0,SnapUtil.isSnapped)(event)) {\r\n      return;\r\n    }\r\n\r\n    var snapPoints = snapContext.pointsForTarget(parent);\r\n\r\n    if (!snapPoints.initialized) {\r\n      snapPoints = self.addSnapTargetPoints(snapPoints, shape, parent, direction);\r\n\r\n      snapPoints.initialized = true;\r\n    }\r\n\r\n    snapping.snap(event, snapPoints);\r\n  });\r\n\r\n  eventBus.on([ 'resize.cleanup' ], function() {\r\n    snapping.hide();\r\n  });\r\n}\r\n\r\nResizeSnapping.prototype.initSnap = function(event) {\r\n  var context = event.context,\r\n      shape = context.shape,\r\n      direction = context.direction,\r\n      snapContext = context.snapContext;\r\n\r\n  if (!snapContext) {\r\n    snapContext = context.snapContext = new SnapContext/* default */.Z();\r\n  }\r\n\r\n  var snapCorner = getCorner(shape, direction);\r\n\r\n  snapContext.setSnapOrigin('corner', {\r\n    x: snapCorner.x - event.x,\r\n    y: snapCorner.y - event.y\r\n  });\r\n\r\n  return snapContext;\r\n};\r\n\r\nResizeSnapping.prototype.addSnapTargetPoints = function(snapPoints, shape, target, direction) {\r\n  var snapTargets = this.getSnapTargets(shape, target);\r\n\r\n  (0,index_esm/* forEach */.Ed)(snapTargets, function(snapTarget) {\r\n    snapPoints.add('corner', (0,SnapUtil.bottomRight)(snapTarget));\r\n    snapPoints.add('corner', (0,SnapUtil.topLeft)(snapTarget));\r\n  });\r\n\r\n  snapPoints.add('corner', getCorner(shape, direction));\r\n\r\n  return snapPoints;\r\n};\r\n\r\nResizeSnapping.$inject = [\r\n  'eventBus',\r\n  'snapping'\r\n];\r\n\r\nResizeSnapping.prototype.getSnapTargets = function(shape, target) {\r\n  return (0,SnapUtil.getChildren)(target).filter(function(child) {\r\n    return !isAttached(child, shape)\r\n      && !isConnection(child)\r\n      && !isHidden(child)\r\n      && !isLabel(child);\r\n  });\r\n};\r\n\r\n// helpers //////////\r\n\r\nfunction getCorner(shape, direction) {\r\n  if (direction === 'nw') {\r\n    return (0,SnapUtil.topLeft)(shape);\r\n  } else if (direction === 'ne') {\r\n    return (0,SnapUtil.topRight)(shape);\r\n  } else if (direction === 'sw') {\r\n    return (0,SnapUtil.bottomLeft)(shape);\r\n  } else {\r\n    return (0,SnapUtil.bottomRight)(shape);\r\n  }\r\n}\r\n\r\nfunction isAttached(element, host) {\r\n  return element.host === host;\r\n}\r\n\r\nfunction isConnection(element) {\r\n  return !!element.waypoints;\r\n}\r\n\r\nfunction isHidden(element) {\r\n  return !!element.hidden;\r\n}\r\n\r\nfunction isLabel(element) {\r\n  return !!element.labelTarget;\r\n}\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/Snapping.js\n\n\n\n\n\n\nvar SNAP_TOLERANCE = 7;\n\nvar SNAP_LINE_HIDE_DELAY = 1000;\n\n\n/**\n * Generic snapping feature.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction Snapping(canvas) {\n  this._canvas = canvas;\n\n  // delay hide by 1000 seconds since last snap\n  this._asyncHide = (0,index_esm/* debounce */.Ds)((0,index_esm/* bind */.ak)(this.hide, this), SNAP_LINE_HIDE_DELAY);\n}\n\nSnapping.$inject = [ 'canvas' ];\n\n/**\n * Snap an event to given snap points.\n *\n * @param {Event} event\n * @param {SnapPoints} snapPoints\n */\nSnapping.prototype.snap = function(event, snapPoints) {\n  var context = event.context,\n      snapContext = context.snapContext,\n      snapLocations = snapContext.getSnapLocations();\n\n  var snapping = {\n    x: (0,SnapUtil.isSnapped)(event, 'x'),\n    y: (0,SnapUtil.isSnapped)(event, 'y')\n  };\n\n  (0,index_esm/* forEach */.Ed)(snapLocations, function(location) {\n    var snapOrigin = snapContext.getSnapOrigin(location);\n\n    var snapCurrent = {\n      x: event.x + snapOrigin.x,\n      y: event.y + snapOrigin.y\n    };\n\n    // snap both axis if not snapped already\n    (0,index_esm/* forEach */.Ed)([ 'x', 'y' ], function(axis) {\n      var locationSnapping;\n\n      if (!snapping[axis]) {\n        locationSnapping = snapPoints.snap(snapCurrent, location, axis, SNAP_TOLERANCE);\n\n        if (locationSnapping !== undefined) {\n          snapping[axis] = {\n            value: locationSnapping,\n            originValue: locationSnapping - snapOrigin[axis]\n          };\n        }\n      }\n    });\n\n    // no need to continue snapping\n    if (snapping.x && snapping.y) {\n      return false;\n    }\n  });\n\n  // show snap lines\n  this.showSnapLine('vertical', snapping.x && snapping.x.value);\n  this.showSnapLine('horizontal', snapping.y && snapping.y.value);\n\n  // snap event\n  (0,index_esm/* forEach */.Ed)([ 'x', 'y' ], function(axis) {\n    var axisSnapping = snapping[axis];\n\n    if ((0,index_esm/* isObject */.Kn)(axisSnapping)) {\n      (0,SnapUtil.setSnapped)(event, axis, axisSnapping.originValue);\n    }\n  });\n};\n\nSnapping.prototype._createLine = function(orientation) {\n  var root = this._canvas.getLayer('snap');\n\n  var line = (0,dist_index_esm/* create */.Ue)('path');\n\n  (0,dist_index_esm/* attr */.Lj)(line, { d: 'M0,0 L0,0' });\n\n  (0,dist_index_esm/* classes */.Sh)(line).add('djs-snap-line');\n\n  (0,dist_index_esm/* append */.R3)(root, line);\n\n  return {\n    update: function(position) {\n\n      if (!(0,index_esm/* isNumber */.hj)(position)) {\n        (0,dist_index_esm/* attr */.Lj)(line, { display: 'none' });\n      } else {\n        if (orientation === 'horizontal') {\n          (0,dist_index_esm/* attr */.Lj)(line, {\n            d: 'M-100000,' + position + ' L+100000,' + position,\n            display: ''\n          });\n        } else {\n          (0,dist_index_esm/* attr */.Lj)(line, {\n            d: 'M ' + position + ',-100000 L ' + position + ', +100000',\n            display: ''\n          });\n        }\n      }\n    }\n  };\n};\n\nSnapping.prototype._createSnapLines = function() {\n  this._snapLines = {\n    horizontal: this._createLine('horizontal'),\n    vertical: this._createLine('vertical')\n  };\n};\n\nSnapping.prototype.showSnapLine = function(orientation, position) {\n\n  var line = this.getSnapLine(orientation);\n\n  if (line) {\n    line.update(position);\n  }\n\n  this._asyncHide();\n};\n\nSnapping.prototype.getSnapLine = function(orientation) {\n  if (!this._snapLines) {\n    this._createSnapLines();\n  }\n\n  return this._snapLines[orientation];\n};\n\nSnapping.prototype.hide = function() {\n  (0,index_esm/* forEach */.Ed)(this._snapLines, function(snapLine) {\n    snapLine.update();\n  });\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/index.js\n\n\n\n\n/* harmony default export */ const snapping = ({\n  __init__: [\n    'createMoveSnapping',\n    'resizeSnapping',\n    'snapping'\n  ],\n  createMoveSnapping: [ 'type', CreateMoveSnapping/* default */.Z ],\n  resizeSnapping: [ 'type', ResizeSnapping ],\n  snapping: [ 'type', Snapping ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/snapping/index.js_+_2_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"M\": () => (/* binding */ getDirection),\n/* harmony export */   \"z\": () => (/* binding */ resizeBounds)\n/* harmony export */ });\n/**\n * Get Resize direction given axis + offset\n *\n * @param {String} axis (x|y)\n * @param {Number} offset\n *\n * @return {String} (e|w|n|s)\n */\nfunction getDirection(axis, offset) {\n\n  if (axis === 'x') {\n    if (offset > 0) {\n      return 'e';\n    }\n\n    if (offset < 0) {\n      return 'w';\n    }\n  }\n\n  if (axis === 'y') {\n    if (offset > 0) {\n      return 's';\n    }\n\n    if (offset < 0) {\n      return 'n';\n    }\n  }\n\n  return null;\n}\n\n\n/**\n * Resize the given bounds by the specified delta from a given anchor point.\n *\n * @param {Bounds} bounds the bounding box that should be resized\n * @param {String} direction in which the element is resized (n, s, e, w)\n * @param {Point} delta of the resize operation\n *\n * @return {Bounds} resized bounding box\n */\nfunction resizeBounds(bounds, direction, delta) {\n\n  var dx = delta.x,\n      dy = delta.y;\n\n  switch (direction) {\n\n  case 'n':\n    return {\n      x: bounds.x,\n      y: bounds.y + dy,\n      width: bounds.width,\n      height: bounds.height - dy\n    };\n\n  case 's':\n    return {\n      x: bounds.x,\n      y: bounds.y,\n      width: bounds.width,\n      height: bounds.height + dy\n    };\n\n  case 'w':\n    return {\n      x: bounds.x + dx,\n      y: bounds.y,\n      width: bounds.width - dx,\n      height: bounds.height\n    };\n\n  case 'e':\n    return {\n      x: bounds.x,\n      y: bounds.y,\n      width: bounds.width + dx,\n      height: bounds.height\n    };\n\n  default:\n    throw new Error('unrecognized direction: ' + direction);\n  }\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ space_tool)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js + 2 modules\nvar dragging = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/rules/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js + 1 modules\nvar tool_manager = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/index.js + 1 modules\nvar preview_support = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/preview-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js\nvar SpaceUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/SpaceUtil.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Cursor.js\nvar Cursor = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Cursor.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js + 1 modules\nvar Mouse = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/SpaceTool.js\n\n\n\n\n\n\nvar abs = Math.abs,\n    round = Math.round;\n\nvar HIGH_PRIORITY = 1500,\n    SPACE_TOOL_CURSOR = 'crosshair';\n\nvar AXIS_TO_DIMENSION = { x: 'width', y: 'height' },\n    AXIS_INVERTED = { x: 'y', y: 'x' };\n\n\n\n\n\n\n/**\n * A tool that allows users to create and remove space in a diagram.\n *\n * The tool needs to be activated manually via {@link SpaceTool#activate(MouseEvent)}.\n */\nfunction SpaceTool(\n    eventBus, dragging, canvas,\n    modeling, rules, toolManager) {\n\n  this._canvas = canvas;\n  this._dragging = dragging;\n  this._modeling = modeling;\n  this._rules = rules;\n  this._toolManager = toolManager;\n\n  var self = this;\n\n  toolManager.registerTool('space', {\n    tool: 'spaceTool.selection',\n    dragging: 'spaceTool'\n  });\n\n  eventBus.on('spaceTool.selection.end', function(event) {\n    var target = event.originalEvent.target;\n\n    // only reactive on diagram click\n    // on some occasions, event.hover is not set and we have to check if the target is an svg\n    if (!event.hover && !(target instanceof SVGElement)) {\n      return;\n    }\n\n    eventBus.once('spaceTool.selection.ended', function() {\n      self.activateMakeSpace(event.originalEvent);\n    });\n  });\n\n\n  eventBus.on('spaceTool.move', HIGH_PRIORITY , function(event) {\n\n    var context = event.context;\n\n    if (!context.initialized) {\n      context.initialized = self.initializeMakeSpace(event, context);\n    }\n  });\n\n\n  eventBus.on('spaceTool.end', function(event) {\n\n    var context = event.context,\n        axis = context.axis,\n        direction = context.direction,\n        movingShapes = context.movingShapes,\n        resizingShapes = context.resizingShapes;\n\n    // skip if create space has not been initialized yet\n    if (!context.initialized) {\n      return;\n    }\n\n    var delta = { x: round(event.dx), y: round(event.dy) };\n    delta[ AXIS_INVERTED[ axis ] ] = 0;\n\n    var insideBounds = true;\n\n    // check if the space tool cursor is inside of bounds of\n    // any of the shapes that would be resized.\n    (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n\n      if ((direction === 'w' && event.x > shape.x + shape.width) ||\n          (direction === 'e' && event.x < shape.x) ||\n          (direction === 'n' && event.y > shape.y + shape.height) ||\n          (direction === 's' && event.y < shape.y)) {\n\n        insideBounds = false;\n        return;\n      }\n    });\n\n    if (insideBounds) {\n      // make space only if the cursor is inside bounds\n      self.makeSpace(movingShapes, resizingShapes, delta, direction);\n    }\n\n    eventBus.once('spaceTool.ended', function(event) {\n      // reactivate space tool after usage\n      self.activateSelection(event.originalEvent, true, true);\n    });\n\n  });\n}\n\nSpaceTool.$inject = [\n  'eventBus',\n  'dragging',\n  'canvas',\n  'modeling',\n  'rules',\n  'toolManager'\n];\n\n\n/**\n * Activate space tool selection\n *\n * @param  {MouseEvent} event\n * @param  {Boolean} autoActivate\n */\nSpaceTool.prototype.activateSelection = function(event, autoActivate, reactivate) {\n  this._dragging.init(event, 'spaceTool.selection', {\n    trapClick: false,\n    cursor: SPACE_TOOL_CURSOR,\n    autoActivate: autoActivate,\n    data: {\n      context: {\n        reactivate: reactivate\n      }\n    }\n  });\n};\n\n/**\n * Activate make space\n *\n * @param  {MouseEvent} event\n */\nSpaceTool.prototype.activateMakeSpace = function(event) {\n  this._dragging.init(event, 'spaceTool', {\n    autoActivate: true,\n    cursor: SPACE_TOOL_CURSOR,\n    data: {\n      context: {}\n    }\n  });\n};\n\n/**\n * Actually make space on the diagram\n *\n * @param  {Array<djs.model.Shape>} movingShapes\n * @param  {Array<djs.model.Shape>} resizingShapes\n * @param  {Point} delta\n * @param  {String} direction\n */\nSpaceTool.prototype.makeSpace = function(movingShapes, resizingShapes, delta, direction) {\n  return this._modeling.createSpace(movingShapes, resizingShapes, delta, direction);\n};\n\n/**\n * Initialize make space and return true if that was successful.\n *\n * @param {Event} event\n * @param {Object} context\n *\n * @return {Boolean} true, if successful\n */\nSpaceTool.prototype.initializeMakeSpace = function(event, context) {\n\n  var axis = abs(event.dx) > abs(event.dy) ? 'x' : 'y',\n      offset = event['d' + axis],\n      // start point of create space operation\n      spacePos = event[axis] - offset;\n\n  if (abs(offset) < 5) {\n    return false;\n  }\n\n  // invert the offset in order to remove space when moving left\n  if (offset < 0) {\n    offset *= -1;\n  }\n\n  // inverts the offset to choose the shapes\n  // on the opposite side of the resizer if\n  // a key modifier is pressed\n  if ((0,Mouse/* hasPrimaryModifier */.RJ)(event)) {\n    offset *= -1;\n  }\n\n  var rootShape = this._canvas.getRootElement();\n\n  var allShapes = (0,Elements/* selfAndAllChildren */.PB)(rootShape, true);\n\n  var adjustments = this.calculateAdjustments(allShapes, axis, offset, spacePos);\n\n  // store data in context\n  (0,index_esm/* assign */.f0)(context, adjustments, {\n    axis: axis,\n    direction: (0,SpaceUtil/* getDirection */.M)(axis, offset)\n  });\n\n  (0,Cursor/* set */.t8)('resize-' + (axis === 'x' ? 'ew' : 'ns'));\n\n  return true;\n};\n\n/**\n * Calculate adjustments needed when making space\n *\n * @param  {Array<djs.model.Shape>} elements\n * @param  {String} axis\n * @param  {Number} offset\n * @param  {Number} spacePos\n *\n * @return {Object}\n */\nSpaceTool.prototype.calculateAdjustments = function(elements, axis, offset, spacePos) {\n\n  var movingShapes = [],\n      resizingShapes = [];\n\n  var rules = this._rules;\n\n  // collect all elements that need to be moved _AND_\n  // resized given on the initial create space position\n  elements.forEach(function(shape) {\n\n    var shapeStart = shape[axis],\n        shapeEnd = shapeStart + shape[AXIS_TO_DIMENSION[axis]];\n\n    // checking if it's root\n    if (!shape.parent) {\n      return;\n    }\n\n    // checking if it's a shape\n    if (shape.waypoints) {\n      return;\n    }\n\n    // shape after spacePos\n    if (offset > 0 && shapeStart > spacePos) {\n      return movingShapes.push(shape);\n    }\n\n    // shape before spacePos\n    if (offset < 0 && shapeEnd < spacePos) {\n      return movingShapes.push(shape);\n    }\n\n    // shape on top of spacePos, resize only if allowed\n    if (shapeStart < spacePos &&\n        shapeEnd > spacePos &&\n        rules.allowed('shape.resize', { shape: shape })) {\n\n      return resizingShapes.push(shape);\n    }\n  });\n\n  return {\n    movingShapes: movingShapes,\n    resizingShapes: resizingShapes\n  };\n};\n\nSpaceTool.prototype.toggle = function() {\n  if (this.isActive()) {\n    this._dragging.cancel();\n  } else {\n    this.activateSelection();\n  }\n};\n\nSpaceTool.prototype.isActive = function() {\n  var context = this._dragging.context();\n\n  return context && /^spaceTool/.test(context.prefix);\n};\n\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/SpaceToolPreview.js\n\n\nvar MARKER_DRAGGING = 'djs-dragging',\n    MARKER_RESIZING = 'djs-resizing';\n\nvar LOW_PRIORITY = 250;\n\n\n\n\n\nvar max = Math.max;\n\n\n/**\n * Provides previews for selecting/moving/resizing shapes when creating/removing space.\n *\n * @param {EventBus} eventBus\n * @param {ElementRegistry} elementRegistry\n * @param {Canvas} canvas\n * @param {Styles} styles\n */\nfunction SpaceToolPreview(\n    eventBus, elementRegistry, canvas,\n    styles, previewSupport) {\n\n  function addPreviewGfx(collection, dragGroup) {\n    (0,index_esm/* forEach */.Ed)(collection, function(element) {\n      previewSupport.addDragger(element, dragGroup);\n\n      canvas.addMarker(element, MARKER_DRAGGING);\n    });\n  }\n\n  // add crosshair\n  eventBus.on('spaceTool.selection.start', function(event) {\n    var space = canvas.getLayer('space'),\n        context = event.context;\n\n    var orientation = {\n      x: 'M 0,-10000 L 0,10000',\n      y: 'M -10000,0 L 10000,0'\n    };\n\n    var crosshairGroup = (0,dist_index_esm/* create */.Ue)('g');\n    (0,dist_index_esm/* attr */.Lj)(crosshairGroup, styles.cls('djs-crosshair-group', [ 'no-events' ]));\n\n    (0,dist_index_esm/* append */.R3)(space, crosshairGroup);\n\n    // horizontal path\n    var pathX = (0,dist_index_esm/* create */.Ue)('path');\n    (0,dist_index_esm/* attr */.Lj)(pathX, 'd', orientation.x);\n    (0,dist_index_esm/* classes */.Sh)(pathX).add('djs-crosshair');\n\n    (0,dist_index_esm/* append */.R3)(crosshairGroup, pathX);\n\n    // vertical path\n    var pathY = (0,dist_index_esm/* create */.Ue)('path');\n    (0,dist_index_esm/* attr */.Lj)(pathY, 'd', orientation.y);\n    (0,dist_index_esm/* classes */.Sh)(pathY).add('djs-crosshair');\n\n    (0,dist_index_esm/* append */.R3)(crosshairGroup, pathY);\n\n    context.crosshairGroup = crosshairGroup;\n  });\n\n  // update crosshair\n  eventBus.on('spaceTool.selection.move', function(event) {\n    var crosshairGroup = event.context.crosshairGroup;\n\n    (0,SvgTransformUtil/* translate */.Iu)(crosshairGroup, event.x, event.y);\n  });\n\n  // remove crosshair\n  eventBus.on('spaceTool.selection.cleanup', function(event) {\n    var context = event.context,\n        crosshairGroup = context.crosshairGroup;\n\n    if (crosshairGroup) {\n      (0,dist_index_esm/* remove */.Od)(crosshairGroup);\n    }\n  });\n\n  // add and update move/resize previews\n  eventBus.on('spaceTool.move', LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        line = context.line,\n        axis = context.axis,\n        movingShapes = context.movingShapes,\n        resizingShapes = context.resizingShapes;\n\n    if (!context.initialized) {\n      return;\n    }\n\n    if (!context.dragGroup) {\n      var spaceLayer = canvas.getLayer('space');\n\n      line = (0,dist_index_esm/* create */.Ue)('path');\n      (0,dist_index_esm/* attr */.Lj)(line, 'd', 'M0,0 L0,0');\n      (0,dist_index_esm/* classes */.Sh)(line).add('djs-crosshair');\n\n      (0,dist_index_esm/* append */.R3)(spaceLayer, line);\n\n      context.line = line;\n\n      var dragGroup = (0,dist_index_esm/* create */.Ue)('g');\n      (0,dist_index_esm/* attr */.Lj)(dragGroup, styles.cls('djs-drag-group', [ 'no-events' ]));\n\n      (0,dist_index_esm/* append */.R3)(canvas.getDefaultLayer(), dragGroup);\n\n      // shapes\n      addPreviewGfx(movingShapes, dragGroup);\n\n      // connections\n      var movingConnections = context.movingConnections = elementRegistry.filter(function(element) {\n        var sourceIsMoving = false;\n\n        (0,index_esm/* forEach */.Ed)(movingShapes, function(shape) {\n          (0,index_esm/* forEach */.Ed)(shape.outgoing, function(connection) {\n            if (element === connection) {\n              sourceIsMoving = true;\n            }\n          });\n        });\n\n        var targetIsMoving = false;\n\n        (0,index_esm/* forEach */.Ed)(movingShapes, function(shape) {\n          (0,index_esm/* forEach */.Ed)(shape.incoming, function(connection) {\n            if (element === connection) {\n              targetIsMoving = true;\n            }\n          });\n        });\n\n        var sourceIsResizing = false;\n\n        (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n          (0,index_esm/* forEach */.Ed)(shape.outgoing, function(connection) {\n            if (element === connection) {\n              sourceIsResizing = true;\n            }\n          });\n        });\n\n        var targetIsResizing = false;\n\n        (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n          (0,index_esm/* forEach */.Ed)(shape.incoming, function(connection) {\n            if (element === connection) {\n              targetIsResizing = true;\n            }\n          });\n        });\n\n        return isConnection(element)\n          && (sourceIsMoving || sourceIsResizing)\n          && (targetIsMoving || targetIsResizing);\n      });\n\n\n      addPreviewGfx(movingConnections, dragGroup);\n\n      context.dragGroup = dragGroup;\n    }\n\n    if (!context.frameGroup) {\n      var frameGroup = (0,dist_index_esm/* create */.Ue)('g');\n      (0,dist_index_esm/* attr */.Lj)(frameGroup, styles.cls('djs-frame-group', [ 'no-events' ]));\n\n      (0,dist_index_esm/* append */.R3)(canvas.getDefaultLayer(), frameGroup);\n\n      var frames = [];\n\n      (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n        var frame = previewSupport.addFrame(shape, frameGroup);\n\n        var initialBounds = frame.getBBox();\n\n        frames.push({\n          element: frame,\n          initialBounds: initialBounds\n        });\n\n        canvas.addMarker(shape, MARKER_RESIZING);\n      });\n\n      context.frameGroup = frameGroup;\n      context.frames = frames;\n    }\n\n    var orientation = {\n      x: 'M' + event.x + ', -10000 L' + event.x + ', 10000',\n      y: 'M -10000, ' + event.y + ' L 10000, ' + event.y\n    };\n\n    (0,dist_index_esm/* attr */.Lj)(line, { path: orientation[ axis ], display: '' });\n\n    var opposite = { x: 'y', y: 'x' };\n    var delta = { x: event.dx, y: event.dy };\n    delta[ opposite[ context.axis ] ] = 0;\n\n    // update move previews\n    (0,SvgTransformUtil/* translate */.Iu)(context.dragGroup, delta.x, delta.y);\n\n    // update resize previews\n    (0,index_esm/* forEach */.Ed)(context.frames, function(frame) {\n      var element = frame.element,\n          initialBounds = frame.initialBounds,\n          width,\n          height;\n\n      if (context.direction === 'e') {\n        (0,dist_index_esm/* attr */.Lj)(element, {\n          width: max(initialBounds.width + delta.x, 5)\n        });\n      } else {\n        width = max(initialBounds.width - delta.x, 5);\n\n        (0,dist_index_esm/* attr */.Lj)(element, {\n          width: width,\n          x: initialBounds.x + initialBounds.width - width\n        });\n      }\n\n      if (context.direction === 's') {\n        (0,dist_index_esm/* attr */.Lj)(element, {\n          height: max(initialBounds.height + delta.y, 5)\n        });\n      } else {\n        height = max(initialBounds.height - delta.y, 5);\n\n        (0,dist_index_esm/* attr */.Lj)(element, {\n          height: height,\n          y: initialBounds.y + initialBounds.height - height\n        });\n      }\n    });\n\n  });\n\n  // remove move/resize previews\n  eventBus.on('spaceTool.cleanup', function(event) {\n\n    var context = event.context,\n        movingShapes = context.movingShapes,\n        movingConnections = context.movingConnections,\n        resizingShapes = context.resizingShapes,\n        line = context.line,\n        dragGroup = context.dragGroup,\n        frameGroup = context.frameGroup;\n\n    // moving shapes\n    (0,index_esm/* forEach */.Ed)(movingShapes, function(shape) {\n      canvas.removeMarker(shape, MARKER_DRAGGING);\n    });\n\n    // moving connections\n    (0,index_esm/* forEach */.Ed)(movingConnections, function(connection) {\n      canvas.removeMarker(connection, MARKER_DRAGGING);\n    });\n\n    if (dragGroup) {\n      (0,dist_index_esm/* remove */.Od)(line);\n      (0,dist_index_esm/* remove */.Od)(dragGroup);\n    }\n\n    (0,index_esm/* forEach */.Ed)(resizingShapes, function(shape) {\n      canvas.removeMarker(shape, MARKER_RESIZING);\n    });\n\n    if (frameGroup) {\n      (0,dist_index_esm/* remove */.Od)(frameGroup);\n    }\n  });\n}\n\nSpaceToolPreview.$inject = [\n  'eventBus',\n  'elementRegistry',\n  'canvas',\n  'styles',\n  'previewSupport'\n];\n\n\n// helpers //////////////////////\n\n/**\n * Checks if an element is a connection.\n */\nfunction isConnection(element) {\n  return element.waypoints;\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/index.js\n\n\n\n\n\n\n\n\n/* harmony default export */ const space_tool = ({\n  __init__: ['spaceToolPreview'],\n  __depends__: [\n    dragging/* default */.Z,\n    rules/* default */.Z,\n    tool_manager/* default */.Z,\n    preview_support/* default */.Z\n  ],\n  spaceTool: ['type', SpaceTool ],\n  spaceToolPreview: ['type', SpaceToolPreview ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/space-tool/index.js_+_2_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ tool_manager)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js + 2 modules\nvar dragging = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/dragging/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/ToolManager.js\n\n\n\n\nvar LOW_PRIORITY = 250;\n\n/**\n * The tool manager acts as middle-man between the available tool's and the Palette,\n * it takes care of making sure that the correct active state is set.\n *\n * @param  {Object}    eventBus\n * @param  {Object}    dragging\n */\nfunction ToolManager(eventBus, dragging) {\n  this._eventBus = eventBus;\n  this._dragging = dragging;\n\n  this._tools = [];\n  this._active = null;\n}\n\nToolManager.$inject = [ 'eventBus', 'dragging' ];\n\nToolManager.prototype.registerTool = function(name, events) {\n  var tools = this._tools;\n\n  if (!events) {\n    throw new Error('A tool has to be registered with it\\'s \"events\"');\n  }\n\n  tools.push(name);\n\n  this.bindEvents(name, events);\n};\n\nToolManager.prototype.isActive = function(tool) {\n  return tool && this._active === tool;\n};\n\nToolManager.prototype.length = function(tool) {\n  return this._tools.length;\n};\n\nToolManager.prototype.setActive = function(tool) {\n  var eventBus = this._eventBus;\n\n  if (this._active !== tool) {\n    this._active = tool;\n\n    eventBus.fire('tool-manager.update', { tool: tool });\n  }\n};\n\nToolManager.prototype.bindEvents = function(name, events) {\n  var eventBus = this._eventBus,\n      dragging = this._dragging;\n\n  var eventsToRegister = [];\n\n  eventBus.on(events.tool + '.init', function(event) {\n    var context = event.context;\n\n    // Active tools that want to reactivate themselves must do this explicitly\n    if (!context.reactivate && this.isActive(name)) {\n      this.setActive(null);\n\n      dragging.cancel();\n      return;\n    }\n\n    this.setActive(name);\n\n  }, this);\n\n  // Todo[ricardo]: add test cases\n  (0,index_esm/* forEach */.Ed)(events, function(event) {\n    eventsToRegister.push(event + '.ended');\n    eventsToRegister.push(event + '.canceled');\n  });\n\n  eventBus.on(eventsToRegister, LOW_PRIORITY, function(event) {\n    var originalEvent = event.originalEvent;\n\n    // We defer the de-activation of the tool to the .activate phase,\n    // so we're able to check if we want to toggle off the current\n    // active tool or switch to a new one\n    if (!this._active) {\n      return;\n    }\n\n    if (originalEvent && (0,dist_index_esm/* closest */.oq)(originalEvent.target, '.group[data-group=\"tools\"]')) {\n      return;\n    }\n\n    this.setActive(null);\n  }, this);\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js\n\n\n\n\n/* harmony default export */ const tool_manager = ({\n  __depends__: [\n    dragging/* default */.Z\n  ],\n  __init__: [ 'toolManager' ],\n  toolManager: [ 'type', ToolManager ]\n});\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/features/tool-manager/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/BaseLayouter.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ BaseLayouter)\n/* harmony export */ });\n/* harmony import */ var _LayoutUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js");\n\n\n\n/**\n * A base connection layouter implementation\n * that layouts the connection by directly connecting\n * mid(source) + mid(target).\n */\nfunction BaseLayouter() {}\n\n\n/**\n * Return the new layouted waypoints for the given connection.\n *\n * The connection passed is still unchanged; you may figure out about\n * the new connection start / end via the layout hints provided.\n *\n * @param {djs.model.Connection} connection\n * @param {Object} [hints]\n * @param {Point} [hints.connectionStart]\n * @param {Point} [hints.connectionEnd]\n * @param {Point} [hints.source]\n * @param {Point} [hints.target]\n *\n * @return {Array<Point>} the layouted connection waypoints\n */\nBaseLayouter.prototype.layoutConnection = function(connection, hints) {\n\n  hints = hints || {};\n\n  return [\n    hints.connectionStart || (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(hints.source || connection.source),\n    hints.connectionEnd || (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(hints.target || connection.target)\n  ];\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/BaseLayouter.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/CroppingConnectionDocking.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Z": () => (/* binding */ CroppingConnectionDocking)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/min-dash/dist/index.esm.js");\n/* harmony import */ var _LayoutUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js");\n\n\n\n\n\nfunction dockingToPoint(docking) {\n  // use the dockings actual point and\n  // retain the original docking\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({ original: docking.point.original || docking.point }, docking.actual);\n}\n\n\n/**\n * A {@link ConnectionDocking} that crops connection waypoints based on\n * the path(s) of the connection source and target.\n *\n * @param {djs.core.ElementRegistry} elementRegistry\n */\nfunction CroppingConnectionDocking(elementRegistry, graphicsFactory) {\n  this._elementRegistry = elementRegistry;\n  this._graphicsFactory = graphicsFactory;\n}\n\nCroppingConnectionDocking.$inject = [ \'elementRegistry\', \'graphicsFactory\' ];\n\n\n/**\n * @inheritDoc ConnectionDocking#getCroppedWaypoints\n */\nCroppingConnectionDocking.prototype.getCroppedWaypoints = function(connection, source, target) {\n\n  source = source || connection.source;\n  target = target || connection.target;\n\n  var sourceDocking = this.getDockingPoint(connection, source, true),\n      targetDocking = this.getDockingPoint(connection, target);\n\n  var croppedWaypoints = connection.waypoints.slice(sourceDocking.idx + 1, targetDocking.idx);\n\n  croppedWaypoints.unshift(dockingToPoint(sourceDocking));\n  croppedWaypoints.push(dockingToPoint(targetDocking));\n\n  return croppedWaypoints;\n};\n\n/**\n * Return the connection docking point on the specified shape\n *\n * @inheritDoc ConnectionDocking#getDockingPoint\n */\nCroppingConnectionDocking.prototype.getDockingPoint = function(connection, shape, dockStart) {\n\n  var waypoints = connection.waypoints,\n      dockingIdx,\n      dockingPoint,\n      croppedPoint;\n\n  dockingIdx = dockStart ? 0 : waypoints.length - 1;\n  dockingPoint = waypoints[dockingIdx];\n\n  croppedPoint = this._getIntersection(shape, connection, dockStart);\n\n  return {\n    point: dockingPoint,\n    actual: croppedPoint || dockingPoint,\n    idx: dockingIdx\n  };\n};\n\n\n// helpers //////////////////////\n\nCroppingConnectionDocking.prototype._getIntersection = function(shape, connection, takeFirst) {\n\n  var shapePath = this._getShapePath(shape),\n      connectionPath = this._getConnectionPath(connection);\n\n  return (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .getElementLineIntersection */ .Hz)(shapePath, connectionPath, takeFirst);\n};\n\nCroppingConnectionDocking.prototype._getConnectionPath = function(connection) {\n  return this._graphicsFactory.getConnectionPath(connection);\n};\n\nCroppingConnectionDocking.prototype._getShapePath = function(shape) {\n  return this._graphicsFactory.getShapePath(shape);\n};\n\nCroppingConnectionDocking.prototype._getGfx = function(element) {\n  return this._elementRegistry.getGraphics(element);\n};\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/CroppingConnectionDocking.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Hz": () => (/* binding */ getElementLineIntersection),\n/* harmony export */   "JA": () => (/* binding */ asTRBL),\n/* harmony export */   "Re": () => (/* binding */ filterRedundantWaypoints),\n/* harmony export */   "T8": () => (/* binding */ getOrientation),\n/* harmony export */   "aR": () => (/* binding */ roundBounds),\n/* harmony export */   "ex": () => (/* binding */ roundPoint),\n/* harmony export */   "wS": () => (/* binding */ getMid),\n/* harmony export */   "z_": () => (/* binding */ asBounds)\n/* harmony export */ });\n/* unused harmony export getIntersections */\nif ("cmmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/min-dash/dist/index.esm.js");\n}\nif ("cmmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _util_Geometry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Geometry.js");\n}\n/* harmony import */ var path_intersection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/path-intersection/intersect.js");\n/* harmony import */ var path_intersection__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path_intersection__WEBPACK_IMPORTED_MODULE_0__);\n\n\n\n\n\n\n\nfunction roundBounds(bounds) {\n  return {\n    x: Math.round(bounds.x),\n    y: Math.round(bounds.y),\n    width: Math.round(bounds.width),\n    height: Math.round(bounds.height)\n  };\n}\n\n\nfunction roundPoint(point) {\n\n  return {\n    x: Math.round(point.x),\n    y: Math.round(point.y)\n  };\n}\n\n\n/**\n * Convert the given bounds to a { top, left, bottom, right } descriptor.\n *\n * @param {Bounds|Point} bounds\n *\n * @return {Object}\n */\nfunction asTRBL(bounds) {\n  return {\n    top: bounds.y,\n    right: bounds.x + (bounds.width || 0),\n    bottom: bounds.y + (bounds.height || 0),\n    left: bounds.x\n  };\n}\n\n\n/**\n * Convert a { top, left, bottom, right } to an objects bounds.\n *\n * @param {Object} trbl\n *\n * @return {Bounds}\n */\nfunction asBounds(trbl) {\n  return {\n    x: trbl.left,\n    y: trbl.top,\n    width: trbl.right - trbl.left,\n    height: trbl.bottom - trbl.top\n  };\n}\n\n\n/**\n * Get the mid of the given bounds or point.\n *\n * @param {Bounds|Point} bounds\n *\n * @return {Point}\n */\nfunction getMid(bounds) {\n  return roundPoint({\n    x: bounds.x + (bounds.width || 0) / 2,\n    y: bounds.y + (bounds.height || 0) / 2\n  });\n}\n\n\n// orientation utils //////////////////////\n\n/**\n * Get orientation of the given rectangle with respect to\n * the reference rectangle.\n *\n * A padding (positive or negative) may be passed to influence\n * horizontal / vertical orientation and intersection.\n *\n * @param {Bounds} rect\n * @param {Bounds} reference\n * @param {Point|Number} padding\n *\n * @return {String} the orientation; one of top, top-left, left, ..., bottom, right or intersect.\n */\nfunction getOrientation(rect, reference, padding) {\n\n  padding = padding || 0;\n\n  // make sure we can use an object, too\n  // for individual { x, y } padding\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .isObject */ .Kn)(padding)) {\n    padding = { x: padding, y: padding };\n  }\n\n\n  var rectOrientation = asTRBL(rect),\n      referenceOrientation = asTRBL(reference);\n\n  var top = rectOrientation.bottom + padding.y <= referenceOrientation.top,\n      right = rectOrientation.left - padding.x >= referenceOrientation.right,\n      bottom = rectOrientation.top - padding.y >= referenceOrientation.bottom,\n      left = rectOrientation.right + padding.x <= referenceOrientation.left;\n\n  var vertical = top ? \'top\' : (bottom ? \'bottom\' : null),\n      horizontal = left ? \'left\' : (right ? \'right\' : null);\n\n  if (horizontal && vertical) {\n    return vertical + \'-\' + horizontal;\n  } else {\n    return horizontal || vertical || \'intersect\';\n  }\n}\n\n\n// intersection utils //////////////////////\n\n/**\n * Get intersection between an element and a line path.\n *\n * @param {PathDef} elementPath\n * @param {PathDef} linePath\n * @param {Boolean} cropStart crop from start or end\n *\n * @return {Point}\n */\nfunction getElementLineIntersection(elementPath, linePath, cropStart) {\n\n  var intersections = getIntersections(elementPath, linePath);\n\n  // recognize intersections\n  // only one -> choose\n  // two close together -> choose first\n  // two or more distinct -> pull out appropriate one\n  // none -> ok (fallback to point itself)\n  if (intersections.length === 1) {\n    return roundPoint(intersections[0]);\n  } else if (intersections.length === 2 && (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointDistance */ .tW)(intersections[0], intersections[1]) < 1) {\n    return roundPoint(intersections[0]);\n  } else if (intersections.length > 1) {\n\n    // sort by intersections based on connection segment +\n    // distance from start\n    intersections = (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .sortBy */ .MR)(intersections, function(i) {\n      var distance = Math.floor(i.t2 * 100) || 1;\n\n      distance = 100 - distance;\n\n      distance = (distance < 10 ? \'0\' : \'\') + distance;\n\n      // create a sort string that makes sure we sort\n      // line segment ASC + line segment position DESC (for cropStart)\n      // line segment ASC + line segment position ASC (for cropEnd)\n      return i.segment2 + \'#\' + distance;\n    });\n\n    return roundPoint(intersections[cropStart ? 0 : intersections.length - 1]);\n  }\n\n  return null;\n}\n\n\nfunction getIntersections(a, b) {\n  return path_intersection__WEBPACK_IMPORTED_MODULE_0___default()(a, b);\n}\n\n\nfunction filterRedundantWaypoints(waypoints) {\n\n  // alter copy of waypoints, not original\n  waypoints = waypoints.slice();\n\n  var idx = 0,\n      point,\n      previousPoint,\n      nextPoint;\n\n  while (waypoints[idx]) {\n    point = waypoints[idx];\n    previousPoint = waypoints[idx - 1];\n    nextPoint = waypoints[idx + 1];\n\n    if ((0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointDistance */ .tW)(point, nextPoint) === 0 ||\n        (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointsOnLine */ .ZS)(previousPoint, nextPoint, point)) {\n\n      // remove point, if overlapping with {nextPoint}\n      // or on line with {previousPoint} -> {point} -> {nextPoint}\n      waypoints.splice(idx, 1);\n    } else {\n      idx++;\n    }\n  }\n\n  return waypoints;\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/ManhattanLayout.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"connectPoints\": () => (/* binding */ connectPoints),\n/* harmony export */   \"connectRectangles\": () => (/* binding */ connectRectangles),\n/* harmony export */   \"repairConnection\": () => (/* binding */ repairConnection),\n/* harmony export */   \"tryLayoutStraight\": () => (/* binding */ tryLayoutStraight),\n/* harmony export */   \"withoutRedundantPoints\": () => (/* binding */ withoutRedundantPoints)\n/* harmony export */ });\nif (\"cmmnFreeEditor\" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n}\nif (\"cmmnFreeEditor\" == __webpack_require__.j) {\n\t/* harmony import */ var _LayoutUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n}\nif (\"cmmnFreeEditor\" == __webpack_require__.j) {\n\t/* harmony import */ var _util_Geometry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Geometry.js\");\n}\n\n\n\n\n\n\nvar MIN_SEGMENT_LENGTH = 20,\n    POINT_ORIENTATION_PADDING = 5;\n\nvar round = Math.round;\n\nvar INTERSECTION_THRESHOLD = 20,\n    ORIENTATION_THRESHOLD = {\n      'h:h': 20,\n      'v:v': 20,\n      'h:v': -10,\n      'v:h': -10\n    };\n\nfunction needsTurn(orientation, startDirection) {\n  return !{\n    t: /top/,\n    r: /right/,\n    b: /bottom/,\n    l: /left/,\n    h: /./,\n    v: /./\n  }[startDirection].test(orientation);\n}\n\nfunction canLayoutStraight(direction, targetOrientation) {\n  return {\n    t: /top/,\n    r: /right/,\n    b: /bottom/,\n    l: /left/,\n    h: /left|right/,\n    v: /top|bottom/\n  }[direction].test(targetOrientation);\n}\n\nfunction getSegmentBendpoints(a, b, directions) {\n  var orientation = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getOrientation */ .T8)(b, a, POINT_ORIENTATION_PADDING);\n\n  var startDirection = directions.split(':')[0];\n\n  var xmid = round((b.x - a.x) / 2 + a.x),\n      ymid = round((b.y - a.y) / 2 + a.y);\n\n  var segmentEnd, segmentDirections;\n\n  var layoutStraight = canLayoutStraight(startDirection, orientation),\n      layoutHorizontal = /h|r|l/.test(startDirection),\n      layoutTurn = false;\n\n  var turnNextDirections = false;\n\n  if (layoutStraight) {\n    segmentEnd = layoutHorizontal ? { x: xmid, y: a.y } : { x: a.x, y: ymid };\n\n    segmentDirections = layoutHorizontal ? 'h:h' : 'v:v';\n  } else {\n    layoutTurn = needsTurn(orientation, startDirection);\n\n    segmentDirections = layoutHorizontal ? 'h:v' : 'v:h';\n\n    if (layoutTurn) {\n\n      if (layoutHorizontal) {\n        turnNextDirections = ymid === a.y;\n\n        segmentEnd = {\n          x: a.x + MIN_SEGMENT_LENGTH * (/l/.test(startDirection) ? -1 : 1),\n          y: turnNextDirections ? ymid + MIN_SEGMENT_LENGTH : ymid\n        };\n      } else {\n        turnNextDirections = xmid === a.x;\n\n        segmentEnd = {\n          x: turnNextDirections ? xmid + MIN_SEGMENT_LENGTH : xmid,\n          y: a.y + MIN_SEGMENT_LENGTH * (/t/.test(startDirection) ? -1 : 1)\n        };\n      }\n\n    } else {\n      segmentEnd = {\n        x: xmid,\n        y: ymid\n      };\n    }\n  }\n\n  return {\n    waypoints: getBendpoints(a, segmentEnd, segmentDirections).concat(segmentEnd),\n    directions:  segmentDirections,\n    turnNextDirections: turnNextDirections\n  };\n}\n\nfunction getStartSegment(a, b, directions) {\n  return getSegmentBendpoints(a, b, directions);\n}\n\nfunction getEndSegment(a, b, directions) {\n  var invertedSegment = getSegmentBendpoints(b, a, invertDirections(directions));\n\n  return {\n    waypoints: invertedSegment.waypoints.slice().reverse(),\n    directions: invertDirections(invertedSegment.directions),\n    turnNextDirections: invertedSegment.turnNextDirections\n  };\n}\n\nfunction getMidSegment(startSegment, endSegment) {\n\n  var startDirection = startSegment.directions.split(':')[1],\n      endDirection = endSegment.directions.split(':')[0];\n\n  if (startSegment.turnNextDirections) {\n    startDirection = startDirection == 'h' ? 'v' : 'h';\n  }\n\n  if (endSegment.turnNextDirections) {\n    endDirection = endDirection == 'h' ? 'v' : 'h';\n  }\n\n  var directions = startDirection + ':' + endDirection;\n\n  var bendpoints = getBendpoints(\n    startSegment.waypoints[startSegment.waypoints.length - 1],\n    endSegment.waypoints[0],\n    directions\n  );\n\n  return {\n    waypoints: bendpoints,\n    directions: directions\n  };\n}\n\nfunction invertDirections(directions) {\n  return directions.split(':').reverse().join(':');\n}\n\n/**\n * Handle simple layouts with maximum two bendpoints.\n */\nfunction getSimpleBendpoints(a, b, directions) {\n\n  var xmid = round((b.x - a.x) / 2 + a.x),\n      ymid = round((b.y - a.y) / 2 + a.y);\n\n  // one point, right or left from a\n  if (directions === 'h:v') {\n    return [ { x: b.x, y: a.y } ];\n  }\n\n  // one point, above or below a\n  if (directions === 'v:h') {\n    return [ { x: a.x, y: b.y } ];\n  }\n\n  // vertical segment between a and b\n  if (directions === 'h:h') {\n    return [\n      { x: xmid, y: a.y },\n      { x: xmid, y: b.y }\n    ];\n  }\n\n  // horizontal segment between a and b\n  if (directions === 'v:v') {\n    return [\n      { x: a.x, y: ymid },\n      { x: b.x, y: ymid }\n    ];\n  }\n\n  throw new Error('invalid directions: can only handle varians of [hv]:[hv]');\n}\n\n\n/**\n * Returns the mid points for a manhattan connection between two points.\n *\n * @example h:h (horizontal:horizontal)\n *\n * [a]----[x]\n *         |\n *        [x]----[b]\n *\n * @example h:v (horizontal:vertical)\n *\n * [a]----[x]\n *         |\n *        [b]\n *\n * @example h:r (horizontal:right)\n *\n * [a]----[x]\n *         |\n *    [b]-[x]\n *\n * @param  {Point} a\n * @param  {Point} b\n * @param  {String} directions\n *\n * @return {Array<Point>}\n */\nfunction getBendpoints(a, b, directions) {\n  directions = directions || 'h:h';\n\n  if (!isValidDirections(directions)) {\n    throw new Error(\n      'unknown directions: <' + directions + '>: ' +\n      'must be specified as <start>:<end> ' +\n      'with start/end in { h,v,t,r,b,l }'\n    );\n  }\n\n  // compute explicit directions, involving trbl dockings\n  // using a three segmented layouting algorithm\n  if (isExplicitDirections(directions)) {\n    var startSegment = getStartSegment(a, b, directions),\n        endSegment = getEndSegment(a, b, directions),\n        midSegment = getMidSegment(startSegment, endSegment);\n\n    return [].concat(\n      startSegment.waypoints,\n      midSegment.waypoints,\n      endSegment.waypoints\n    );\n  }\n\n  // handle simple [hv]:[hv] cases that can be easily computed\n  return getSimpleBendpoints(a, b, directions);\n}\n\n/**\n * Create a connection between the two points according\n * to the manhattan layout (only horizontal and vertical) edges.\n *\n * @param {Point} a\n * @param {Point} b\n *\n * @param {String} [directions='h:h'] specifies manhattan directions for each point as {adirection}:{bdirection}.\n                   A directionfor a point is either `h` (horizontal) or `v` (vertical)\n *\n * @return {Array<Point>}\n */\nfunction connectPoints(a, b, directions) {\n\n  var points = getBendpoints(a, b, directions);\n\n  points.unshift(a);\n  points.push(b);\n\n  return withoutRedundantPoints(points);\n}\n\n\n/**\n * Connect two rectangles using a manhattan layouted connection.\n *\n * @param {Bounds} source source rectangle\n * @param {Bounds} target target rectangle\n * @param {Point} [start] source docking\n * @param {Point} [end] target docking\n *\n * @param {Object} [hints]\n * @param {String} [hints.preserveDocking=source] preserve docking on selected side\n * @param {Array<String>} [hints.preferredLayouts]\n * @param {Point|Boolean} [hints.connectionStart] whether the start changed\n * @param {Point|Boolean} [hints.connectionEnd] whether the end changed\n *\n * @return {Array<Point>} connection points\n */\nfunction connectRectangles(source, target, start, end, hints) {\n\n  var preferredLayouts = hints && hints.preferredLayouts || [];\n\n  var preferredLayout = (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .without */ .zu)(preferredLayouts, 'straight')[0] || 'h:h';\n\n  var threshold = ORIENTATION_THRESHOLD[preferredLayout] || 0;\n\n  var orientation = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getOrientation */ .T8)(source, target, threshold);\n\n  var directions = getDirections(orientation, preferredLayout);\n\n  start = start || (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(source);\n  end = end || (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(target);\n\n  var directionSplit = directions.split(':');\n\n  // compute actual docking points for start / end\n  // this ensures we properly layout only parts of the\n  // connection that lies in between the two rectangles\n  var startDocking = getDockingPoint(start, source, directionSplit[0], invertOrientation(orientation)),\n      endDocking = getDockingPoint(end, target, directionSplit[1], orientation);\n\n  return connectPoints(startDocking, endDocking, directions);\n}\n\n\n/**\n * Repair the connection between two rectangles, of which one has been updated.\n *\n * @param {Bounds} source\n * @param {Bounds} target\n * @param {Point} [start]\n * @param {Point} [end]\n * @param {Array<Point>} [waypoints]\n * @param {Object} [hints]\n * @param {Array<String>} [hints.preferredLayouts] list of preferred layouts\n * @param {Boolean} [hints.connectionStart]\n * @param {Boolean} [hints.connectionEnd]\n *\n * @return {Array<Point>} repaired waypoints\n */\nfunction repairConnection(source, target, start, end, waypoints, hints) {\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .kJ)(start)) {\n    waypoints = start;\n    hints = end;\n\n    start = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(source);\n    end = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getMid */ .wS)(target);\n  }\n\n  hints = (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .assign */ .f0)({ preferredLayouts: [] }, hints);\n  waypoints = waypoints || [];\n\n  var preferredLayouts = hints.preferredLayouts,\n      preferStraight = preferredLayouts.indexOf('straight') !== -1,\n      repairedWaypoints;\n\n  // just layout non-existing or simple connections\n  // attempt to render straight lines, if required\n\n  // attempt to layout a straight line\n  repairedWaypoints = preferStraight && tryLayoutStraight(source, target, start, end, hints);\n\n  if (repairedWaypoints) {\n    return repairedWaypoints;\n  }\n\n  // try to layout from end\n  repairedWaypoints = hints.connectionEnd && tryRepairConnectionEnd(target, source, end, waypoints);\n\n  if (repairedWaypoints) {\n    return repairedWaypoints;\n  }\n\n  // try to layout from start\n  repairedWaypoints = hints.connectionStart && tryRepairConnectionStart(source, target, start, waypoints);\n\n  if (repairedWaypoints) {\n    return repairedWaypoints;\n  }\n\n  // or whether nothing seems to have changed\n  if (!hints.connectionStart && !hints.connectionEnd && waypoints && waypoints.length) {\n    return waypoints;\n  }\n\n  // simply reconnect if nothing else worked\n  return connectRectangles(source, target, start, end, hints);\n}\n\n\nfunction inRange(a, start, end) {\n  return a >= start && a <= end;\n}\n\nfunction isInRange(axis, a, b) {\n  var size = {\n    x: 'width',\n    y: 'height'\n  };\n\n  return inRange(a[axis], b[axis], b[axis] + b[size[axis]]);\n}\n\n/**\n * Layout a straight connection\n *\n * @param {Bounds} source\n * @param {Bounds} target\n * @param {Point} start\n * @param {Point} end\n * @param {Object} [hints]\n *\n * @return {Array<Point>|null} waypoints if straight layout worked\n */\nfunction tryLayoutStraight(source, target, start, end, hints) {\n  var axis = {},\n      primaryAxis,\n      orientation;\n\n  orientation = (0,_LayoutUtil__WEBPACK_IMPORTED_MODULE_0__/* .getOrientation */ .T8)(source, target);\n\n  // only layout a straight connection if shapes are\n  // horizontally or vertically aligned\n  if (!/^(top|bottom|left|right)$/.test(orientation)) {\n    return null;\n  }\n\n  if (/top|bottom/.test(orientation)) {\n    primaryAxis = 'x';\n  }\n\n  if (/left|right/.test(orientation)) {\n    primaryAxis = 'y';\n  }\n\n  if (hints.preserveDocking === 'target') {\n\n    if (!isInRange(primaryAxis, end, source)) {\n      return null;\n    }\n\n    axis[primaryAxis] = end[primaryAxis];\n\n    return [\n      {\n        x: axis.x !== undefined ? axis.x : start.x,\n        y: axis.y !== undefined ? axis.y : start.y,\n        original: {\n          x: axis.x !== undefined ? axis.x : start.x,\n          y: axis.y !== undefined ? axis.y : start.y\n        }\n      },\n      {\n        x: end.x,\n        y: end.y\n      }\n    ];\n\n  } else {\n\n    if (!isInRange(primaryAxis, start, target)) {\n      return null;\n    }\n\n    axis[primaryAxis] = start[primaryAxis];\n\n    return [\n      {\n        x: start.x,\n        y: start.y\n      },\n      {\n        x: axis.x !== undefined ? axis.x : end.x,\n        y: axis.y !== undefined ? axis.y : end.y,\n        original: {\n          x: axis.x !== undefined ? axis.x : end.x,\n          y: axis.y !== undefined ? axis.y : end.y\n        }\n      }\n    ];\n  }\n\n}\n\n/**\n * Repair a connection from start.\n *\n * @param {Bounds} moved\n * @param {Bounds} other\n * @param {Point} newDocking\n * @param {Array<Point>} points originalPoints from moved to other\n *\n * @return {Array<Point>|null} the repaired points between the two rectangles\n */\nfunction tryRepairConnectionStart(moved, other, newDocking, points) {\n  return _tryRepairConnectionSide(moved, other, newDocking, points);\n}\n\n/**\n * Repair a connection from end.\n *\n * @param {Bounds} moved\n * @param {Bounds} other\n * @param {Point} newDocking\n * @param {Array<Point>} points originalPoints from moved to other\n *\n * @return {Array<Point>|null} the repaired points between the two rectangles\n */\nfunction tryRepairConnectionEnd(moved, other, newDocking, points) {\n  var waypoints = points.slice().reverse();\n\n  waypoints = _tryRepairConnectionSide(moved, other, newDocking, waypoints);\n\n  return waypoints ? waypoints.reverse() : null;\n}\n\n/**\n * Repair a connection from one side that moved.\n *\n * @param {Bounds} moved\n * @param {Bounds} other\n * @param {Point} newDocking\n * @param {Array<Point>} points originalPoints from moved to other\n *\n * @return {Array<Point>} the repaired points between the two rectangles\n */\nfunction _tryRepairConnectionSide(moved, other, newDocking, points) {\n\n  function needsRelayout(moved, other, points) {\n\n    if (points.length < 3) {\n      return true;\n    }\n\n    if (points.length > 4) {\n      return false;\n    }\n\n    // relayout if two points overlap\n    // this is most likely due to\n    return !!(0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .find */ .sE)(points, function(p, idx) {\n      var q = points[idx - 1];\n\n      return q && (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointDistance */ .tW)(p, q) < 3;\n    });\n  }\n\n  function repairBendpoint(candidate, oldPeer, newPeer) {\n\n    var alignment = (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointsAligned */ .Or)(oldPeer, candidate);\n\n    switch (alignment) {\n    case 'v':\n      // repair horizontal alignment\n      return { x: newPeer.x, y: candidate.y };\n    case 'h':\n      // repair vertical alignment\n      return { x: candidate.x, y: newPeer.y };\n    }\n\n    return { x: candidate.x, y: candidate. y };\n  }\n\n  function removeOverlapping(points, a, b) {\n    var i;\n\n    for (i = points.length - 2; i !== 0; i--) {\n\n      // intersects (?) break, remove all bendpoints up to this one and relayout\n      if ((0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointInRect */ .qr)(points[i], a, INTERSECTION_THRESHOLD) ||\n          (0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointInRect */ .qr)(points[i], b, INTERSECTION_THRESHOLD)) {\n\n        // return sliced old connection\n        return points.slice(i);\n      }\n    }\n\n    return points;\n  }\n\n\n  // (0) only repair what has layoutable bendpoints\n\n  // (1) if only one bendpoint and on shape moved onto other shapes axis\n  //     (horizontally / vertically), relayout\n\n  if (needsRelayout(moved, other, points)) {\n    return null;\n  }\n\n  var oldDocking = points[0],\n      newPoints = points.slice(),\n      slicedPoints;\n\n  // (2) repair only last line segment and only if it was layouted before\n\n  newPoints[0] = newDocking;\n  newPoints[1] = repairBendpoint(newPoints[1], oldDocking, newDocking);\n\n\n  // (3) if shape intersects with any bendpoint after repair,\n  //     remove all segments up to this bendpoint and repair from there\n\n  slicedPoints = removeOverlapping(newPoints, moved, other);\n\n  if (slicedPoints !== newPoints) {\n    return _tryRepairConnectionSide(moved, other, newDocking, slicedPoints);\n  }\n\n  return newPoints;\n}\n\n\n/**\n * Returns the manhattan directions connecting two rectangles\n * with the given orientation.\n *\n * Will always return the default layout, if it is specific\n * regarding sides already (trbl).\n *\n * @example\n *\n * getDirections('top'); // -> 'v:v'\n * getDirections('intersect'); // -> 't:t'\n *\n * getDirections('top-right', 'v:h'); // -> 'v:h'\n * getDirections('top-right', 'h:h'); // -> 'h:h'\n *\n *\n * @param {String} orientation\n * @param {String} defaultLayout\n *\n * @return {String}\n */\nfunction getDirections(orientation, defaultLayout) {\n\n  // don't override specific trbl directions\n  if (isExplicitDirections(defaultLayout)) {\n    return defaultLayout;\n  }\n\n  switch (orientation) {\n  case 'intersect':\n    return 't:t';\n\n  case 'top':\n  case 'bottom':\n    return 'v:v';\n\n  case 'left':\n  case 'right':\n    return 'h:h';\n\n  // 'top-left'\n  // 'top-right'\n  // 'bottom-left'\n  // 'bottom-right'\n  default:\n    return defaultLayout;\n  }\n}\n\nfunction isValidDirections(directions) {\n  return directions && /^h|v|t|r|b|l:h|v|t|r|b|l$/.test(directions);\n}\n\nfunction isExplicitDirections(directions) {\n  return directions && /t|r|b|l/.test(directions);\n}\n\nfunction invertOrientation(orientation) {\n  return {\n    'top': 'bottom',\n    'bottom': 'top',\n    'left': 'right',\n    'right': 'left',\n    'top-left': 'bottom-right',\n    'bottom-right': 'top-left',\n    'top-right': 'bottom-left',\n    'bottom-left': 'top-right',\n  }[orientation];\n}\n\nfunction getDockingPoint(point, rectangle, dockingDirection, targetOrientation) {\n\n  // ensure we end up with a specific docking direction\n  // based on the targetOrientation, if <h|v> is being passed\n\n  if (dockingDirection === 'h') {\n    dockingDirection = /left/.test(targetOrientation) ? 'l' : 'r';\n  }\n\n  if (dockingDirection === 'v') {\n    dockingDirection = /top/.test(targetOrientation) ? 't' : 'b';\n  }\n\n  if (dockingDirection === 't') {\n    return { original: point, x: point.x, y: rectangle.y };\n  }\n\n  if (dockingDirection === 'r') {\n    return { original: point, x: rectangle.x + rectangle.width, y: point.y };\n  }\n\n  if (dockingDirection === 'b') {\n    return { original: point, x: point.x, y: rectangle.y + rectangle.height };\n  }\n\n  if (dockingDirection === 'l') {\n    return { original: point, x: rectangle.x, y: point.y };\n  }\n\n  throw new Error('unexpected dockingDirection: <' + dockingDirection + '>');\n}\n\n\n/**\n * Return list of waypoints with redundant ones filtered out.\n *\n * @example\n *\n * Original points:\n *\n *   [x] ----- [x] ------ [x]\n *                         |\n *                        [x] ----- [x] - [x]\n *\n * Filtered:\n *\n *   [x] ---------------- [x]\n *                         |\n *                        [x] ----------- [x]\n *\n * @param  {Array<Point>} waypoints\n *\n * @return {Array<Point>}\n */\nfunction withoutRedundantPoints(waypoints) {\n  return waypoints.reduce(function(points, p, idx) {\n\n    var previous = points[points.length - 1],\n        next = waypoints[idx + 1];\n\n    if (!(0,_util_Geometry__WEBPACK_IMPORTED_MODULE_2__/* .pointsOnLine */ .ZS)(previous, next, p, 0)) {\n      points.push(p);\n    }\n\n    return points;\n  }, []);\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/ManhattanLayout.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/model/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Base\": () => (/* binding */ Base),\n/* harmony export */   \"Connection\": () => (/* binding */ Connection),\n/* harmony export */   \"Label\": () => (/* binding */ Label),\n/* harmony export */   \"Root\": () => (/* binding */ Root),\n/* harmony export */   \"Shape\": () => (/* binding */ Shape),\n/* harmony export */   \"create\": () => (/* binding */ create)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var inherits__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/inherits/inherits_browser.js\");\n/* harmony import */ var inherits__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(inherits__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var object_refs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/object-refs/index.js\");\n/* harmony import */ var object_refs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(object_refs__WEBPACK_IMPORTED_MODULE_1__);\n\n\n\n\n\nvar parentRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_1___default())({ name: 'children', enumerable: true, collection: true }, { name: 'parent' }),\n    labelRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_1___default())({ name: 'labels', enumerable: true, collection: true }, { name: 'labelTarget' }),\n    attacherRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_1___default())({ name: 'attachers', collection: true }, { name: 'host' }),\n    outgoingRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_1___default())({ name: 'outgoing', collection: true }, { name: 'source' }),\n    incomingRefs = new (object_refs__WEBPACK_IMPORTED_MODULE_1___default())({ name: 'incoming', collection: true }, { name: 'target' });\n\n/**\n * @namespace djs.model\n */\n\n/**\n * @memberOf djs.model\n */\n\n/**\n * The basic graphical representation\n *\n * @class\n *\n * @abstract\n */\nfunction Base() {\n\n  /**\n   * The object that backs up the shape\n   *\n   * @name Base#businessObject\n   * @type Object\n   */\n  Object.defineProperty(this, 'businessObject', {\n    writable: true\n  });\n\n\n  /**\n   * Single label support, will mapped to multi label array\n   *\n   * @name Base#label\n   * @type Object\n   */\n  Object.defineProperty(this, 'label', {\n    get: function() {\n      return this.labels[0];\n    },\n    set: function(newLabel) {\n\n      var label = this.label,\n          labels = this.labels;\n\n      if (!newLabel && label) {\n        labels.remove(label);\n      } else {\n        labels.add(newLabel, 0);\n      }\n    }\n  });\n\n  /**\n   * The parent shape\n   *\n   * @name Base#parent\n   * @type Shape\n   */\n  parentRefs.bind(this, 'parent');\n\n  /**\n   * The list of labels\n   *\n   * @name Base#labels\n   * @type Label\n   */\n  labelRefs.bind(this, 'labels');\n\n  /**\n   * The list of outgoing connections\n   *\n   * @name Base#outgoing\n   * @type Array<Connection>\n   */\n  outgoingRefs.bind(this, 'outgoing');\n\n  /**\n   * The list of incoming connections\n   *\n   * @name Base#incoming\n   * @type Array<Connection>\n   */\n  incomingRefs.bind(this, 'incoming');\n}\n\n\n/**\n * A graphical object\n *\n * @class\n * @constructor\n *\n * @extends Base\n */\nfunction Shape() {\n  Base.call(this);\n\n  /**\n   * Indicates frame shapes\n   *\n   * @name Shape#isFrame\n   * @type Boolean\n   */\n\n  /**\n   * The list of children\n   *\n   * @name Shape#children\n   * @type Array<Base>\n   */\n  parentRefs.bind(this, 'children');\n\n  /**\n   * @name Shape#host\n   * @type Shape\n   */\n  attacherRefs.bind(this, 'host');\n\n  /**\n   * @name Shape#attachers\n   * @type Shape\n   */\n  attacherRefs.bind(this, 'attachers');\n}\n\ninherits__WEBPACK_IMPORTED_MODULE_0___default()(Shape, Base);\n\n\n/**\n * A root graphical object\n *\n * @class\n * @constructor\n *\n * @extends Shape\n */\nfunction Root() {\n  Shape.call(this);\n}\n\ninherits__WEBPACK_IMPORTED_MODULE_0___default()(Root, Shape);\n\n\n/**\n * A label for an element\n *\n * @class\n * @constructor\n *\n * @extends Shape\n */\nfunction Label() {\n  Shape.call(this);\n\n  /**\n   * The labeled element\n   *\n   * @name Label#labelTarget\n   * @type Base\n   */\n  labelRefs.bind(this, 'labelTarget');\n}\n\ninherits__WEBPACK_IMPORTED_MODULE_0___default()(Label, Shape);\n\n\n/**\n * A connection between two elements\n *\n * @class\n * @constructor\n *\n * @extends Base\n */\nfunction Connection() {\n  Base.call(this);\n\n  /**\n   * The element this connection originates from\n   *\n   * @name Connection#source\n   * @type Base\n   */\n  outgoingRefs.bind(this, 'source');\n\n  /**\n   * The element this connection points to\n   *\n   * @name Connection#target\n   * @type Base\n   */\n  incomingRefs.bind(this, 'target');\n}\n\ninherits__WEBPACK_IMPORTED_MODULE_0___default()(Connection, Base);\n\n\nvar types = {\n  connection: Connection,\n  shape: Shape,\n  label: Label,\n  root: Root\n};\n\n/**\n * Creates a new model element of the specified type\n *\n * @method create\n *\n * @example\n *\n * var shape1 = Model.create('shape', { x: 10, y: 10, width: 100, height: 100 });\n * var shape2 = Model.create('shape', { x: 210, y: 210, width: 100, height: 100 });\n *\n * var connection = Model.create('connection', { waypoints: [ { x: 110, y: 55 }, {x: 210, y: 55 } ] });\n *\n * @param  {String} type lower-cased model name\n * @param  {Object} attrs attributes to initialize the new model instance with\n *\n * @return {Base} the new model instance\n */\nfunction create(type, attrs) {\n  var Type = types[type];\n  if (!Type) {\n    throw new Error('unknown type: <' + type + '>');\n  }\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_2__/* .assign */ .f0)(new Type(), attrs);\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/model/index.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/keyboard-move/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ keyboard_move)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/index.js + 1 modules\nvar keyboard = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/features/keyboard/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/keyboard-move/KeyboardMove.js\n\n\n\nvar DEFAULT_CONFIG = {\n  moveSpeed: 50,\n  moveSpeedAccelerated: 200\n};\n\n\n/**\n * A feature that allows users to move the canvas using the keyboard.\n *\n * @param {Object} config\n * @param {Number} [config.moveSpeed=50]\n * @param {Number} [config.moveSpeedAccelerated=200]\n * @param {Keyboard} keyboard\n * @param {Canvas} canvas\n */\nfunction KeyboardMove(\n    config,\n    keyboard,\n    canvas\n) {\n\n  var self = this;\n\n  this._config = (0,index_esm/* assign */.f0)({}, DEFAULT_CONFIG, config || {});\n\n  keyboard.addListener(arrowsListener);\n\n\n  function arrowsListener(context) {\n\n    var event = context.keyEvent,\n        config = self._config;\n\n    if (!keyboard.isCmd(event)) {\n      return;\n    }\n\n    if (keyboard.isKey([\n      'ArrowLeft', 'Left',\n      'ArrowUp', 'Up',\n      'ArrowDown', 'Down',\n      'ArrowRight', 'Right'\n    ], event)) {\n\n      var speed = (\n        keyboard.isShift(event) ?\n          config.moveSpeedAccelerated :\n          config.moveSpeed\n      );\n\n      var direction;\n\n      switch (event.key) {\n      case 'ArrowLeft':\n      case 'Left':\n        direction = 'left';\n        break;\n      case 'ArrowUp':\n      case 'Up':\n        direction = 'up';\n        break;\n      case 'ArrowRight':\n      case 'Right':\n        direction = 'right';\n        break;\n      case 'ArrowDown':\n      case 'Down':\n        direction = 'down';\n        break;\n      }\n\n      self.moveCanvas({\n        speed: speed,\n        direction: direction\n      });\n\n      return true;\n    }\n  }\n\n  this.moveCanvas = function(opts) {\n\n    var dx = 0,\n        dy = 0,\n        speed = opts.speed;\n\n    var actualSpeed = speed / Math.min(Math.sqrt(canvas.viewbox().scale), 1);\n\n    switch (opts.direction) {\n    case 'left': // Left\n      dx = actualSpeed;\n      break;\n    case 'up': // Up\n      dy = actualSpeed;\n      break;\n    case 'right': // Right\n      dx = -actualSpeed;\n      break;\n    case 'down': // Down\n      dy = -actualSpeed;\n      break;\n    }\n\n    canvas.scroll({\n      dx: dx,\n      dy: dy\n    });\n  };\n\n}\n\n\nKeyboardMove.$inject = [\n  'config.keyboardMove',\n  'keyboard',\n  'canvas'\n];\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/keyboard-move/index.js\n\n\n\n\n\n/* harmony default export */ const keyboard_move = ({\n  __depends__: [\n    keyboard/* default */.Z\n  ],\n  __init__: [ 'keyboardMove' ],\n  keyboardMove: [ 'type', KeyboardMove ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/keyboard-move/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/movecanvas/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ movecanvas)\n});\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Cursor.js\nvar Cursor = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Cursor.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/ClickTrap.js\nvar ClickTrap = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/ClickTrap.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/PositionUtil.js\nvar PositionUtil = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/PositionUtil.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/movecanvas/MoveCanvas.js\n\n\n\n\n\n\n\n\n\n\n\nvar THRESHOLD = 15;\n\n\n/**\n * Move the canvas via mouse.\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction MoveCanvas(eventBus, canvas) {\n\n  var context;\n\n\n  // listen for move on element mouse down;\n  // allow others to hook into the event before us though\n  // (dragging / element moving will do this)\n  eventBus.on('element.mousedown', 500, function(e) {\n    return handleStart(e.originalEvent);\n  });\n\n\n  function handleMove(event) {\n\n    var start = context.start,\n        position = (0,Event/* toPoint */.jt)(event),\n        delta = (0,PositionUtil/* delta */.p)(position, start);\n\n    if (!context.dragging && MoveCanvas_length(delta) > THRESHOLD) {\n      context.dragging = true;\n\n      (0,ClickTrap/* install */.N)(eventBus);\n\n      (0,Cursor/* set */.t8)('grab');\n    }\n\n    if (context.dragging) {\n\n      var lastPosition = context.last || context.start;\n\n      delta = (0,PositionUtil/* delta */.p)(position, lastPosition);\n\n      canvas.scroll({\n        dx: delta.x,\n        dy: delta.y\n      });\n\n      context.last = position;\n    }\n\n    // prevent select\n    event.preventDefault();\n  }\n\n\n  function handleEnd(event) {\n    index_esm/* event.unbind */.B.unbind(document, 'mousemove', handleMove);\n    index_esm/* event.unbind */.B.unbind(document, 'mouseup', handleEnd);\n\n    context = null;\n\n    (0,Cursor/* unset */.zN)();\n  }\n\n  function handleStart(event) {\n    // event is already handled by '.djs-draggable'\n    if ((0,index_esm/* closest */.oq)(event.target, '.djs-draggable')) {\n      return;\n    }\n\n\n    // reject non-left left mouse button or modifier key\n    if (event.button || event.ctrlKey || event.shiftKey || event.altKey) {\n      return;\n    }\n\n    context = {\n      start: (0,Event/* toPoint */.jt)(event)\n    };\n\n    index_esm/* event.bind */.B.bind(document, 'mousemove', handleMove);\n    index_esm/* event.bind */.B.bind(document, 'mouseup', handleEnd);\n\n    // we've handled the event\n    return true;\n  }\n}\n\n\nMoveCanvas.$inject = [\n  'eventBus',\n  'canvas'\n];\n\n\n\n// helpers ///////\n\nfunction MoveCanvas_length(point) {\n  return Math.sqrt(Math.pow(point.x, 2) + Math.pow(point.y, 2));\n}\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/movecanvas/index.js\n\n\n/* harmony default export */ const movecanvas = ({\n  __init__: [ 'moveCanvas' ],\n  moveCanvas: [ 'type', MoveCanvas ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/movecanvas/index.js_+_1_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/zoomscroll/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ zoomscroll)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Math.js\n/**\n * Get the logarithm of x with base 10\n * @param  {Integer} value\n */\nfunction log10(x) {\n  return Math.log(x) / Math.log(10);\n}\n\n\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/zoomscroll/ZoomUtil.js\n\n\n/**\n * Get step size for given range and number of steps.\n *\n * @param {Object} range\n * @param {number} range.min\n * @param {number} range.max\n */\nfunction getStepSize(range, steps) {\n\n  var minLinearRange = log10(range.min),\n      maxLinearRange = log10(range.max);\n\n  var absoluteLinearRange = Math.abs(minLinearRange) + Math.abs(maxLinearRange);\n\n  return absoluteLinearRange / steps;\n}\n\nfunction cap(range, scale) {\n  return Math.max(range.min, Math.min(range.max, scale));\n}\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/zoomscroll/ZoomScroll.js\n\n\n\n\n\n\n\n\nvar sign = Math.sign || function(n) {\n  return n >= 0 ? 1 : -1;\n};\n\nvar RANGE = { min: 0.2, max: 4 },\n    NUM_STEPS = 10;\n\nvar DELTA_THRESHOLD = 0.1;\n\nvar DEFAULT_SCALE = 0.75;\n\n/**\n * An implementation of zooming and scrolling within the\n * {@link Canvas} via the mouse wheel.\n *\n * Mouse wheel zooming / scrolling may be disabled using\n * the {@link toggle(enabled)} method.\n *\n * @param {Object} [config]\n * @param {Boolean} [config.enabled=true] default enabled state\n * @param {Number} [config.scale=.75] scroll sensivity\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n */\nfunction ZoomScroll(config, eventBus, canvas) {\n\n  config = config || {};\n\n  this._enabled = false;\n\n  this._canvas = canvas;\n  this._container = canvas._container;\n\n  this._handleWheel = (0,dist_index_esm/* bind */.ak)(this._handleWheel, this);\n\n  this._totalDelta = 0;\n  this._scale = config.scale || DEFAULT_SCALE;\n\n  var self = this;\n\n  eventBus.on('canvas.init', function(e) {\n    self._init(config.enabled !== false);\n  });\n}\n\nZoomScroll.$inject = [\n  'config.zoomScroll',\n  'eventBus',\n  'canvas'\n];\n\nZoomScroll.prototype.scroll = function scroll(delta) {\n  this._canvas.scroll(delta);\n};\n\n\nZoomScroll.prototype.reset = function reset() {\n  this._canvas.zoom('fit-viewport');\n};\n\n/**\n * Zoom depending on delta.\n *\n * @param {number} delta\n * @param {Object} position\n */\nZoomScroll.prototype.zoom = function zoom(delta, position) {\n\n  // zoom with half the step size of stepZoom\n  var stepSize = getStepSize(RANGE, NUM_STEPS * 2);\n\n  // add until threshold reached\n  this._totalDelta += delta;\n\n  if (Math.abs(this._totalDelta) > DELTA_THRESHOLD) {\n    this._zoom(delta, position, stepSize);\n\n    // reset\n    this._totalDelta = 0;\n  }\n};\n\n\nZoomScroll.prototype._handleWheel = function handleWheel(event) {\n  // event is already handled by '.djs-scrollable'\n  if ((0,index_esm/* closest */.oq)(event.target, '.djs-scrollable', true)) {\n    return;\n  }\n\n  var element = this._container;\n\n  event.preventDefault();\n\n  // pinch to zoom is mapped to wheel + ctrlKey = true\n  // in modern browsers (!)\n\n  var isZoom = event.ctrlKey;\n\n  var isHorizontalScroll = event.shiftKey;\n\n  var factor = -1 * this._scale,\n      delta;\n\n  if (isZoom) {\n    factor *= event.deltaMode === 0 ? 0.020 : 0.32;\n  } else {\n    factor *= event.deltaMode === 0 ? 1.0 : 16.0;\n  }\n\n  if (isZoom) {\n    var elementRect = element.getBoundingClientRect();\n\n    var offset = {\n      x: event.clientX - elementRect.left,\n      y: event.clientY - elementRect.top\n    };\n\n    delta = (\n      Math.sqrt(\n        Math.pow(event.deltaY, 2) +\n        Math.pow(event.deltaX, 2)\n      ) * sign(event.deltaY) * factor\n    );\n\n    // zoom in relative to diagram {x,y} coordinates\n    this.zoom(delta, offset);\n  } else {\n\n    if (isHorizontalScroll) {\n      delta = {\n        dx: factor * event.deltaY,\n        dy: 0\n      };\n    } else {\n      delta = {\n        dx: factor * event.deltaX,\n        dy: factor * event.deltaY\n      };\n    }\n\n    this.scroll(delta);\n  }\n};\n\n/**\n * Zoom with fixed step size.\n *\n * @param {number} delta - Zoom delta (1 for zooming in, -1 for out).\n * @param {Object} position\n */\nZoomScroll.prototype.stepZoom = function stepZoom(delta, position) {\n\n  var stepSize = getStepSize(RANGE, NUM_STEPS);\n\n  this._zoom(delta, position, stepSize);\n};\n\n\n/**\n * Zoom in/out given a step size.\n *\n * @param {number} delta\n * @param {Object} position\n * @param {number} stepSize\n */\nZoomScroll.prototype._zoom = function(delta, position, stepSize) {\n  var canvas = this._canvas;\n\n  var direction = delta > 0 ? 1 : -1;\n\n  var currentLinearZoomLevel = log10(canvas.zoom());\n\n  // snap to a proximate zoom step\n  var newLinearZoomLevel = Math.round(currentLinearZoomLevel / stepSize) * stepSize;\n\n  // increase or decrease one zoom step in the given direction\n  newLinearZoomLevel += stepSize * direction;\n\n  // calculate the absolute logarithmic zoom level based on the linear zoom level\n  // (e.g. 2 for an absolute x2 zoom)\n  var newLogZoomLevel = Math.pow(10, newLinearZoomLevel);\n\n  canvas.zoom(cap(RANGE, newLogZoomLevel), position);\n};\n\n\n/**\n * Toggle the zoom scroll ability via mouse wheel.\n *\n * @param  {Boolean} [newEnabled] new enabled state\n */\nZoomScroll.prototype.toggle = function toggle(newEnabled) {\n\n  var element = this._container;\n  var handleWheel = this._handleWheel;\n\n  var oldEnabled = this._enabled;\n\n  if (typeof newEnabled === 'undefined') {\n    newEnabled = !oldEnabled;\n  }\n\n  // only react on actual changes\n  if (oldEnabled !== newEnabled) {\n\n    // add or remove wheel listener based on\n    // changed enabled state\n    index_esm/* event */.B[newEnabled ? 'bind' : 'unbind'](element, 'wheel', handleWheel, false);\n  }\n\n  this._enabled = newEnabled;\n\n  return newEnabled;\n};\n\n\nZoomScroll.prototype._init = function(newEnabled) {\n  this.toggle(newEnabled);\n};\n\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/zoomscroll/index.js\n\n\n/* harmony default export */ const zoomscroll = ({\n  __init__: [ 'zoomScroll' ],\n  zoomScroll: [ 'type', ZoomScroll ]\n});\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/navigation/zoomscroll/index.js_+_3_modules?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/AttachUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "r": () => (/* binding */ getNewAttachPoint),\n/* harmony export */   "s": () => (/* binding */ getNewAttachShapeDelta)\n/* harmony export */ });\nif ("cmmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/layout/LayoutUtil.js");\n}\nif ("cmmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _PositionUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/util/PositionUtil.js");\n}\n\n\n\n\n\n/**\n * Calculates the absolute point relative to the new element\'s position\n *\n * @param {point} point [absolute]\n * @param {bounds} oldBounds\n * @param {bounds} newBounds\n *\n * @return {point} point [absolute]\n */\nfunction getNewAttachPoint(point, oldBounds, newBounds) {\n  var oldCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(oldBounds),\n      newCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(newBounds),\n      oldDelta = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .delta */ .p)(point, oldCenter);\n\n  var newDelta = {\n    x: oldDelta.x * (newBounds.width / oldBounds.width),\n    y: oldDelta.y * (newBounds.height / oldBounds.height)\n  };\n\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .roundPoint */ .ex)({\n    x: newCenter.x + newDelta.x,\n    y: newCenter.y + newDelta.y\n  });\n}\n\n\n/**\n * Calculates the shape\'s delta relative to a new position\n * of a certain element\'s bounds\n *\n * @param {djs.model.Shape} point [absolute]\n * @param {bounds} oldBounds\n * @param {bounds} newBounds\n *\n * @return {delta} delta\n */\nfunction getNewAttachShapeDelta(shape, oldBounds, newBounds) {\n  var shapeCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(shape),\n      oldCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(oldBounds),\n      newCenter = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .center */ .b)(newBounds),\n      shapeDelta = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .delta */ .p)(shape, shapeCenter),\n      oldCenterDelta = (0,_PositionUtil__WEBPACK_IMPORTED_MODULE_0__/* .delta */ .p)(shapeCenter, oldCenter);\n\n  var newCenterDelta = {\n    x: oldCenterDelta.x * (newBounds.width / oldBounds.width),\n    y: oldCenterDelta.y * (newBounds.height / oldBounds.height)\n  };\n\n  var newShapeCenter = {\n    x: newCenter.x + newCenterDelta.x,\n    y: newCenter.y + newCenterDelta.y\n  };\n\n  return (0,_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_1__/* .roundPoint */ .ex)({\n    x: newShapeCenter.x + shapeDelta.x - shape.x,\n    y: newShapeCenter.y + shapeDelta.y - shape.y\n  });\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/AttachUtil.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/ClickTrap.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"N\": () => (/* binding */ install)\n/* harmony export */ });\nvar TRAP_PRIORITY = 5000;\n\n/**\n * Installs a click trap that prevents a ghost click following a dragging operation.\n *\n * @return {Function} a function to immediately remove the installed trap.\n */\nfunction install(eventBus, eventName) {\n\n  eventName = eventName || 'element.click';\n\n  function trap() {\n    return false;\n  }\n\n  eventBus.once(eventName, TRAP_PRIORITY, trap);\n\n  return function() {\n    eventBus.off(eventName, trap);\n  };\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/ClickTrap.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "add": () => (/* binding */ add),\n/* harmony export */   "indexOf": () => (/* binding */ indexOf),\n/* harmony export */   "remove": () => (/* binding */ remove)\n/* harmony export */ });\n/**\n * Failsafe remove an element from a collection\n *\n * @param  {Array<Object>} [collection]\n * @param  {Object} [element]\n *\n * @return {Number} the previous index of the element\n */\nfunction remove(collection, element) {\n\n  if (!collection || !element) {\n    return -1;\n  }\n\n  var idx = collection.indexOf(element);\n\n  if (idx !== -1) {\n    collection.splice(idx, 1);\n  }\n\n  return idx;\n}\n\n/**\n * Fail save add an element to the given connection, ensuring\n * it does not yet exist.\n *\n * @param {Array<Object>} collection\n * @param {Object} element\n * @param {Number} idx\n */\nfunction add(collection, element, idx) {\n\n  if (!collection || !element) {\n    return;\n  }\n\n  if (typeof idx !== \'number\') {\n    idx = -1;\n  }\n\n  var currentIdx = collection.indexOf(element);\n\n  if (currentIdx !== -1) {\n\n    if (currentIdx === idx) {\n      // nothing to do, position has not changed\n      return;\n    } else {\n\n      if (idx !== -1) {\n        // remove from current position\n        collection.splice(currentIdx, 1);\n      } else {\n        // already exists in collection\n        return;\n      }\n    }\n  }\n\n  if (idx !== -1) {\n    // insert at specified position\n    collection.splice(idx, 0, element);\n  } else {\n    // push to end\n    collection.push(element);\n  }\n}\n\n\n/**\n * Fail save get the index of an element in a collection.\n *\n * @param {Array<Object>} collection\n * @param {Object} element\n *\n * @return {Number} the index or -1 if collection or element do\n *                  not exist or the element is not contained.\n */\nfunction indexOf(collection, element) {\n\n  if (!collection || !element) {\n    return -1;\n  }\n\n  return collection.indexOf(element);\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Collections.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Cursor.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "t8": () => (/* binding */ set),\n/* harmony export */   "zN": () => (/* binding */ unset)\n/* harmony export */ });\n/* unused harmony export has */\n/* harmony import */ var min_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/min-dom/dist/index.esm.js");\n\n\nvar CURSOR_CLS_PATTERN = /^djs-cursor-.*$/;\n\n\nfunction set(mode) {\n  var classes = (0,min_dom__WEBPACK_IMPORTED_MODULE_0__/* .classes */ .Sh)(document.body);\n\n  classes.removeMatching(CURSOR_CLS_PATTERN);\n\n  if (mode) {\n    classes.add(\'djs-cursor-\' + mode);\n  }\n}\n\nfunction unset() {\n  set(null);\n}\n\nfunction has(mode) {\n  var classes = domClasses(document.body);\n\n  return classes.has(\'djs-cursor-\' + mode);\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Cursor.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "He": () => (/* binding */ isFrameElement),\n/* harmony export */   "PB": () => (/* binding */ selfAndAllChildren),\n/* harmony export */   "RH": () => (/* binding */ getEnclosedElements),\n/* harmony export */   "jY": () => (/* binding */ getBBox),\n/* harmony export */   "oL": () => (/* binding */ getType),\n/* harmony export */   "om": () => (/* binding */ eachElement),\n/* harmony export */   "vA": () => (/* binding */ getClosure)\n/* harmony export */ });\n/* unused harmony exports add, selfAndChildren, selfAndDirectChildren */\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/min-dash/dist/index.esm.js");\n\n\n\n/**\n * Adds an element to a collection and returns true if the\n * element was added.\n *\n * @param {Array<Object>} elements\n * @param {Object} e\n * @param {Boolean} unique\n */\nfunction add(elements, e, unique) {\n  var canAdd = !unique || elements.indexOf(e) === -1;\n\n  if (canAdd) {\n    elements.push(e);\n  }\n\n  return canAdd;\n}\n\n\n/**\n * Iterate over each element in a collection, calling the iterator function `fn`\n * with (element, index, recursionDepth).\n *\n * Recurse into all elements that are returned by `fn`.\n *\n * @param  {Object|Array<Object>} elements\n * @param  {Function} fn iterator function called with (element, index, recursionDepth)\n * @param  {Number} [depth] maximum recursion depth\n */\nfunction eachElement(elements, fn, depth) {\n\n  depth = depth || 0;\n\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(elements)) {\n    elements = [ elements ];\n  }\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(elements, function(s, i) {\n    var filter = fn(s, i, depth);\n\n    if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(filter) && filter.length) {\n      eachElement(filter, fn, depth + 1);\n    }\n  });\n}\n\n\n/**\n * Collects self + child elements up to a given depth from a list of elements.\n *\n * @param  {djs.model.Base|Array<djs.model.Base>} elements the elements to select the children from\n * @param  {Boolean} unique whether to return a unique result set (no duplicates)\n * @param  {Number} maxDepth the depth to search through or -1 for infinite\n *\n * @return {Array<djs.model.Base>} found elements\n */\nfunction selfAndChildren(elements, unique, maxDepth) {\n  var result = [],\n      processedChildren = [];\n\n  eachElement(elements, function(element, i, depth) {\n    add(result, element, unique);\n\n    var children = element.children;\n\n    // max traversal depth not reached yet\n    if (maxDepth === -1 || depth < maxDepth) {\n\n      // children exist && children not yet processed\n      if (children && add(processedChildren, children, unique)) {\n        return children;\n      }\n    }\n  });\n\n  return result;\n}\n\n/**\n * Return self + direct children for a number of elements\n *\n * @param  {Array<djs.model.Base>} elements to query\n * @param  {Boolean} allowDuplicates to allow duplicates in the result set\n *\n * @return {Array<djs.model.Base>} the collected elements\n */\nfunction selfAndDirectChildren(elements, allowDuplicates) {\n  return selfAndChildren(elements, !allowDuplicates, 1);\n}\n\n\n/**\n * Return self + ALL children for a number of elements\n *\n * @param  {Array<djs.model.Base>} elements to query\n * @param  {Boolean} allowDuplicates to allow duplicates in the result set\n *\n * @return {Array<djs.model.Base>} the collected elements\n */\nfunction selfAndAllChildren(elements, allowDuplicates) {\n  return selfAndChildren(elements, !allowDuplicates, -1);\n}\n\n\n/**\n * Gets the the closure for all selected elements,\n * their enclosed children and connections.\n *\n * @param {Array<djs.model.Base>} elements\n * @param {Boolean} [isTopLevel=true]\n * @param {Object} [existingClosure]\n *\n * @return {Object} newClosure\n */\nfunction getClosure(elements, isTopLevel, closure) {\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isUndefined */ .o8)(isTopLevel)) {\n    isTopLevel = true;\n  }\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isObject */ .Kn)(isTopLevel)) {\n    closure = isTopLevel;\n    isTopLevel = true;\n  }\n\n\n  closure = closure || {};\n\n  var allShapes = copyObject(closure.allShapes),\n      allConnections = copyObject(closure.allConnections),\n      enclosedElements = copyObject(closure.enclosedElements),\n      enclosedConnections = copyObject(closure.enclosedConnections);\n\n  var topLevel = copyObject(\n    closure.topLevel,\n    isTopLevel && (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .groupBy */ .vM)(elements, function(e) { return e.id; })\n  );\n\n\n  function handleConnection(c) {\n    if (topLevel[c.source.id] && topLevel[c.target.id]) {\n      topLevel[c.id] = [ c ];\n    }\n\n    // not enclosed as a child, but maybe logically\n    // (connecting two moved elements?)\n    if (allShapes[c.source.id] && allShapes[c.target.id]) {\n      enclosedConnections[c.id] = enclosedElements[c.id] = c;\n    }\n\n    allConnections[c.id] = c;\n  }\n\n  function handleElement(element) {\n\n    enclosedElements[element.id] = element;\n\n    if (element.waypoints) {\n      // remember connection\n      enclosedConnections[element.id] = allConnections[element.id] = element;\n    } else {\n      // remember shape\n      allShapes[element.id] = element;\n\n      // remember all connections\n      (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(element.incoming, handleConnection);\n\n      (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(element.outgoing, handleConnection);\n\n      // recurse into children\n      return element.children;\n    }\n  }\n\n  eachElement(elements, handleElement);\n\n  return {\n    allShapes: allShapes,\n    allConnections: allConnections,\n    topLevel: topLevel,\n    enclosedConnections: enclosedConnections,\n    enclosedElements: enclosedElements\n  };\n}\n\n/**\n * Returns the surrounding bbox for all elements in\n * the array or the element primitive.\n *\n * @param {Array<djs.model.Shape>|djs.model.Shape} elements\n * @param {Boolean} stopRecursion\n */\nfunction getBBox(elements, stopRecursion) {\n\n  stopRecursion = !!stopRecursion;\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .kJ)(elements)) {\n    elements = [elements];\n  }\n\n  var minX,\n      minY,\n      maxX,\n      maxY;\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(elements, function(element) {\n\n    // If element is a connection the bbox must be computed first\n    var bbox = element;\n    if (element.waypoints && !stopRecursion) {\n      bbox = getBBox(element.waypoints, true);\n    }\n\n    var x = bbox.x,\n        y = bbox.y,\n        height = bbox.height || 0,\n        width = bbox.width || 0;\n\n    if (x < minX || minX === undefined) {\n      minX = x;\n    }\n    if (y < minY || minY === undefined) {\n      minY = y;\n    }\n\n    if ((x + width) > maxX || maxX === undefined) {\n      maxX = x + width;\n    }\n    if ((y + height) > maxY || maxY === undefined) {\n      maxY = y + height;\n    }\n  });\n\n  return {\n    x: minX,\n    y: minY,\n    height: maxY - minY,\n    width: maxX - minX\n  };\n}\n\n\n/**\n * Returns all elements that are enclosed from the bounding box.\n *\n *   * If bbox.(width|height) is not specified the method returns\n *     all elements with element.x/y > bbox.x/y\n *   * If only bbox.x or bbox.y is specified, method return all elements with\n *     e.x > bbox.x or e.y > bbox.y\n *\n * @param {Array<djs.model.Shape>} elements List of Elements to search through\n * @param {djs.model.Shape} bbox the enclosing bbox.\n *\n * @return {Array<djs.model.Shape>} enclosed elements\n */\nfunction getEnclosedElements(elements, bbox) {\n\n  var filteredElements = {};\n\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(elements, function(element) {\n\n    var e = element;\n\n    if (e.waypoints) {\n      e = getBBox(e);\n    }\n\n    if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.y) && (e.x > bbox.x)) {\n      filteredElements[element.id] = element;\n    }\n    if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.x) && (e.y > bbox.y)) {\n      filteredElements[element.id] = element;\n    }\n    if (e.x > bbox.x && e.y > bbox.y) {\n      if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.width) && (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.height) &&\n          e.width + e.x < bbox.width + bbox.x &&\n          e.height + e.y < bbox.height + bbox.y) {\n\n        filteredElements[element.id] = element;\n      } else if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.width) || !(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isNumber */ .hj)(bbox.height)) {\n        filteredElements[element.id] = element;\n      }\n    }\n  });\n\n  return filteredElements;\n}\n\n\nfunction getType(element) {\n\n  if (\'waypoints\' in element) {\n    return \'connection\';\n  }\n\n  if (\'x\' in element) {\n    return \'shape\';\n  }\n\n  return \'root\';\n}\n\nfunction isFrameElement(element) {\n\n  return !!(element && element.isFrame);\n}\n\n// helpers ///////////////////////////////\n\nfunction copyObject(src1, src2) {\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, src1 || {}, src2 || {});\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Elements.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Ku": () => (/* binding */ getOriginal),\n/* harmony export */   "UW": () => (/* binding */ stopPropagation),\n/* harmony export */   "jt": () => (/* binding */ toPoint)\n/* harmony export */ });\nfunction __stopPropagation(event) {\n  if (!event || typeof event.stopPropagation !== \'function\') {\n    return;\n  }\n\n  event.stopPropagation();\n}\n\n\nfunction getOriginal(event) {\n  return event.originalEvent || event.srcEvent;\n}\n\n\nfunction stopPropagation(event, immediate) {\n  __stopPropagation(event, immediate);\n  __stopPropagation(getOriginal(event), immediate);\n}\n\n\nfunction toPoint(event) {\n\n  if (event.pointers && event.pointers.length) {\n    event = event.pointers[0];\n  }\n\n  if (event.touches && event.touches.length) {\n    event = event.touches[0];\n  }\n\n  return event ? {\n    x: event.clientX,\n    y: event.clientY\n  } : null;\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Geometry.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Or": () => (/* binding */ pointsAligned),\n/* harmony export */   "SO": () => (/* binding */ getMidPoint),\n/* harmony export */   "ZS": () => (/* binding */ pointsOnLine),\n/* harmony export */   "qr": () => (/* binding */ pointInRect),\n/* harmony export */   "tW": () => (/* binding */ pointDistance)\n/* harmony export */ });\n/**\n * Computes the distance between two points\n *\n * @param  {Point}  p\n * @param  {Point}  q\n *\n * @return {Number}  distance\n */\nfunction pointDistance(a, b) {\n  if (!a || !b) {\n    return -1;\n  }\n\n  return Math.sqrt(\n    Math.pow(a.x - b.x, 2) +\n    Math.pow(a.y - b.y, 2)\n  );\n}\n\n\n/**\n * Returns true if the point r is on the line between p and q\n *\n * @param  {Point}  p\n * @param  {Point}  q\n * @param  {Point}  r\n * @param  {Number} [accuracy=5] accuracy for points on line check (lower is better)\n *\n * @return {Boolean}\n */\nfunction pointsOnLine(p, q, r, accuracy) {\n\n  if (typeof accuracy === \'undefined\') {\n    accuracy = 5;\n  }\n\n  if (!p || !q || !r) {\n    return false;\n  }\n\n  var val = (q.x - p.x) * (r.y - p.y) - (q.y - p.y) * (r.x - p.x),\n      dist = pointDistance(p, q);\n\n  // @see http://stackoverflow.com/a/907491/412190\n  return Math.abs(val / dist) <= accuracy;\n}\n\n\nvar ALIGNED_THRESHOLD = 2;\n\n/**\n * Returns whether two points are in a horizontal or vertical line.\n *\n * @param {Point} a\n * @param {Point} b\n *\n * @return {String|Boolean} returns false if the points are not\n *                          aligned or \'h|v\' if they are aligned\n *                          horizontally / vertically.\n */\nfunction pointsAligned(a, b) {\n  if (Math.abs(a.x - b.x) <= ALIGNED_THRESHOLD) {\n    return \'v\';\n  }\n\n  if (Math.abs(a.y - b.y) <= ALIGNED_THRESHOLD) {\n    return \'h\';\n  }\n\n  return false;\n}\n\n\n/**\n * Returns true if the point p is inside the rectangle rect\n *\n * @param  {Point}  p\n * @param  {Rect}   rect\n * @param  {Number} tolerance\n *\n * @return {Boolean}\n */\nfunction pointInRect(p, rect, tolerance) {\n  tolerance = tolerance || 0;\n\n  return p.x > rect.x - tolerance &&\n         p.y > rect.y - tolerance &&\n         p.x < rect.x + rect.width + tolerance &&\n         p.y < rect.y + rect.height + tolerance;\n}\n\n/**\n * Returns a point in the middle of points p and q\n *\n * @param  {Point}  p\n * @param  {Point}  q\n *\n * @return {Point} middle point\n */\nfunction getMidPoint(p, q) {\n  return {\n    x: Math.round(p.x + ((q.x - p.x) / 2.0)),\n    y: Math.round(p.y + ((q.y - p.y) / 2.0))\n  };\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Geometry.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/GraphicsUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "G": () => (/* binding */ getChildren),\n/* harmony export */   "s": () => (/* binding */ getVisual)\n/* harmony export */ });\n/* harmony import */ var min_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/min-dom/dist/index.esm.js");\n\n\n/**\n * SVGs for elements are generated by the {@link GraphicsFactory}.\n *\n * This utility gives quick access to the important semantic\n * parts of an element.\n */\n\n/**\n * Returns the visual part of a diagram element\n *\n * @param {Snap<SVGElement>} gfx\n *\n * @return {Snap<SVGElement>}\n */\nfunction getVisual(gfx) {\n  return (0,min_dom__WEBPACK_IMPORTED_MODULE_0__/* .query */ .IO)(\'.djs-visual\', gfx);\n}\n\n/**\n * Returns the children for a given diagram element.\n *\n * @param {Snap<SVGElement>} gfx\n * @return {Snap<SVGElement>}\n */\nfunction getChildren(gfx) {\n  return gfx.parentNode.childNodes[1];\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/GraphicsUtil.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/LineIntersection.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"t\": () => (/* binding */ getApproxIntersection)\n/* harmony export */ });\nif (\"cmmnFreeEditor\" == __webpack_require__.j) {\n\t/* harmony import */ var _Geometry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Geometry.js\");\n}\n/* harmony import */ var path_intersection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/path-intersection/intersect.js\");\n/* harmony import */ var path_intersection__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path_intersection__WEBPACK_IMPORTED_MODULE_0__);\n\n\n\n\nvar round = Math.round,\n    max = Math.max;\n\n\nfunction circlePath(center, r) {\n  var x = center.x,\n      y = center.y;\n\n  return [\n    ['M', x, y],\n    ['m', 0, -r],\n    ['a', r, r, 0, 1, 1, 0, 2 * r],\n    ['a', r, r, 0, 1, 1, 0, -2 * r],\n    ['z']\n  ];\n}\n\nfunction linePath(points) {\n  var segments = [];\n\n  points.forEach(function(p, idx) {\n    segments.push([ idx === 0 ? 'M' : 'L', p.x, p.y ]);\n  });\n\n  return segments;\n}\n\n\nvar INTERSECTION_THRESHOLD = 10;\n\nfunction getBendpointIntersection(waypoints, reference) {\n\n  var i, w;\n\n  for (i = 0; (w = waypoints[i]); i++) {\n\n    if ((0,_Geometry__WEBPACK_IMPORTED_MODULE_1__/* .pointDistance */ .tW)(w, reference) <= INTERSECTION_THRESHOLD) {\n      return {\n        point: waypoints[i],\n        bendpoint: true,\n        index: i\n      };\n    }\n  }\n\n  return null;\n}\n\nfunction getPathIntersection(waypoints, reference) {\n\n  var intersections = path_intersection__WEBPACK_IMPORTED_MODULE_0___default()(circlePath(reference, INTERSECTION_THRESHOLD), linePath(waypoints));\n\n  var a = intersections[0],\n      b = intersections[intersections.length - 1],\n      idx;\n\n  if (!a) {\n    // no intersection\n    return null;\n  }\n\n  if (a !== b) {\n\n    if (a.segment2 !== b.segment2) {\n      // we use the bendpoint in between both segments\n      // as the intersection point\n\n      idx = max(a.segment2, b.segment2) - 1;\n\n      return {\n        point: waypoints[idx],\n        bendpoint: true,\n        index: idx\n      };\n    }\n\n    return {\n      point: {\n        x: (round(a.x + b.x) / 2),\n        y: (round(a.y + b.y) / 2)\n      },\n      index: a.segment2\n    };\n  }\n\n  return {\n    point: {\n      x: round(a.x),\n      y: round(a.y)\n    },\n    index: a.segment2\n  };\n}\n\n/**\n * Returns the closest point on the connection towards a given reference point.\n *\n * @param  {Array<Point>} waypoints\n * @param  {Point} reference\n *\n * @return {Object} intersection data (segment, point)\n */\nfunction getApproxIntersection(waypoints, reference) {\n  return getBendpointIntersection(waypoints, reference) || getPathIntersection(waypoints, reference);\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/LineIntersection.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  "RJ": () => (/* binding */ hasPrimaryModifier),\n  "Dw": () => (/* binding */ hasSecondaryModifier),\n  "Id": () => (/* binding */ isPrimaryButton)\n});\n\n// UNUSED EXPORTS: isMac\n\n// EXTERNAL MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js\nvar Event = __webpack_require__("./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Event.js");\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Platform.js\nfunction isMac() {\n  return (/mac/i).test(navigator.platform);\n}\n;// CONCATENATED MODULE: ./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js\n\n\n\n\n\n\n\nfunction isPrimaryButton(event) {\n  // button === 0 -> left áka primary mouse button\n  return !((0,Event/* getOriginal */.Ku)(event) || event).button;\n}\n\nfunction hasPrimaryModifier(event) {\n  var originalEvent = (0,Event/* getOriginal */.Ku)(event) || event;\n\n  if (!isPrimaryButton(event)) {\n    return false;\n  }\n\n  // Use alt as primary modifier key for mac OS\n  if (isMac()) {\n    return originalEvent.metaKey;\n  } else {\n    return originalEvent.ctrlKey;\n  }\n}\n\n\nfunction hasSecondaryModifier(event) {\n  var originalEvent = (0,Event/* getOriginal */.Ku)(event) || event;\n\n  return isPrimaryButton(event) && originalEvent.shiftKey;\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Mouse.js_+_1_modules?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/PositionUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "b": () => (/* binding */ center),\n/* harmony export */   "p": () => (/* binding */ delta)\n/* harmony export */ });\nfunction center(bounds) {\n  return {\n    x: bounds.x + (bounds.width / 2),\n    y: bounds.y + (bounds.height / 2)\n  };\n}\n\n\nfunction delta(a, b) {\n  return {\n    x: a.x - b.x,\n    y: a.y - b.y\n  };\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/PositionUtil.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Removal.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"r\": () => (/* binding */ saveClear)\n/* harmony export */ });\n/**\n * Remove from the beginning of a collection until it is empty.\n *\n * This is a null-safe operation that ensures elements\n * are being removed from the given collection until the\n * collection is empty.\n *\n * The implementation deals with the fact that a remove operation\n * may touch, i.e. remove multiple elements in the collection\n * at a time.\n *\n * @param {Array<Object>} [collection]\n * @param {Function} removeFn\n *\n * @return {Array<Object>} the cleared collection\n */\nfunction saveClear(collection, removeFn) {\n\n  if (typeof removeFn !== 'function') {\n    throw new Error('removeFn iterator must be a function');\n  }\n\n  if (!collection) {\n    return;\n  }\n\n  var e;\n\n  while ((e = collection[0])) {\n    removeFn(e);\n  }\n\n  return collection;\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Removal.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/RenderUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"KO\": () => (/* binding */ componentsToPath),\n/* harmony export */   \"W5\": () => (/* binding */ createLine),\n/* harmony export */   \"cq\": () => (/* binding */ updateLine)\n/* harmony export */ });\n/* unused harmony export toSVGPoints */\n/* harmony import */ var tiny_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n\n\n\nfunction componentsToPath(elements) {\n  return elements.join(',').replace(/,?([A-z]),?/g, '$1');\n}\n\nfunction toSVGPoints(points) {\n  var result = '';\n\n  for (var i = 0, p; (p = points[i]); i++) {\n    result += p.x + ',' + p.y + ' ';\n  }\n\n  return result;\n}\n\nfunction createLine(points, attrs) {\n\n  var line = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .create */ .Ue)('polyline');\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .Lj)(line, { points: toSVGPoints(points) });\n\n  if (attrs) {\n    (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .Lj)(line, attrs);\n  }\n\n  return line;\n}\n\nfunction updateLine(gfx, points) {\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .Lj)(gfx, { points: toSVGPoints(points) });\n\n  return gfx;\n}\n\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/RenderUtil.js?")},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "Iu": () => (/* binding */ translate),\n/* harmony export */   "U1": () => (/* binding */ rotate),\n/* harmony export */   "vs": () => (/* binding */ transform)\n/* harmony export */ });\n/* unused harmony export scale */\n/* harmony import */ var tiny_svg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/tiny-svg/dist/index.esm.js");\n\r\n\r\n\r\n/**\r\n * @param {<SVGElement>} element\r\n * @param {Number} x\r\n * @param {Number} y\r\n * @param {Number} angle\r\n * @param {Number} amount\r\n */\r\nfunction transform(gfx, x, y, angle, amount) {\r\n  var translate = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  translate.setTranslate(x, y);\r\n\r\n  var rotate = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  rotate.setRotate(angle, 0, 0);\r\n\r\n  var scale = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  scale.setScale(amount || 1, amount || 1);\r\n\r\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .transform */ .vs)(gfx, [ translate, rotate, scale ]);\r\n}\r\n\r\n\r\n/**\r\n * @param {SVGElement} element\r\n * @param {Number} x\r\n * @param {Number} y\r\n */\r\nfunction translate(gfx, x, y) {\r\n  var translate = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  translate.setTranslate(x, y);\r\n\r\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .transform */ .vs)(gfx, translate);\r\n}\r\n\r\n\r\n/**\r\n * @param {SVGElement} element\r\n * @param {Number} angle\r\n */\r\nfunction rotate(gfx, angle) {\r\n  var rotate = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .createTransform */ .pH)();\r\n  rotate.setRotate(angle, 0, 0);\r\n\r\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_0__/* .transform */ .vs)(gfx, rotate);\r\n}\r\n\r\n\r\n/**\r\n * @param {SVGElement} element\r\n * @param {Number} amount\r\n */\r\nfunction scale(gfx, amount) {\r\n  var scale = createTransform();\r\n  scale.setScale(amount, amount);\r\n\r\n  svgTransform(gfx, scale);\r\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/SvgTransformUtil.js?')},"./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Text.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Z\": () => (/* binding */ Text)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var tiny_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n\n\n\n\nvar DEFAULT_BOX_PADDING = 0;\n\nvar DEFAULT_LABEL_SIZE = {\n  width: 150,\n  height: 50\n};\n\n\nfunction parseAlign(align) {\n\n  var parts = align.split('-');\n\n  return {\n    horizontal: parts[0] || 'center',\n    vertical: parts[1] || 'top'\n  };\n}\n\nfunction parsePadding(padding) {\n\n  if ((0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isObject */ .Kn)(padding)) {\n    return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({ top: 0, left: 0, right: 0, bottom: 0 }, padding);\n  } else {\n    return {\n      top: padding,\n      left: padding,\n      right: padding,\n      bottom: padding\n    };\n  }\n}\n\nfunction getTextBBox(text, fakeText) {\n\n  fakeText.textContent = text;\n\n  var textBBox;\n\n  try {\n    var bbox,\n        emptyLine = text === '';\n\n    // add dummy text, when line is empty to\n    // determine correct height\n    fakeText.textContent = emptyLine ? 'dummy' : text;\n\n    textBBox = fakeText.getBBox();\n\n    // take text rendering related horizontal\n    // padding into account\n    bbox = {\n      width: textBBox.width + textBBox.x * 2,\n      height: textBBox.height\n    };\n\n    if (emptyLine) {\n      // correct width\n      bbox.width = 0;\n    }\n\n    return bbox;\n  } catch (e) {\n    return { width: 0, height: 0 };\n  }\n}\n\n\n/**\n * Layout the next line and return the layouted element.\n *\n * Alters the lines passed.\n *\n * @param  {Array<String>} lines\n * @return {Object} the line descriptor, an object { width, height, text }\n */\nfunction layoutNext(lines, maxWidth, fakeText) {\n\n  var originalLine = lines.shift(),\n      fitLine = originalLine;\n\n  var textBBox;\n\n  for (;;) {\n    textBBox = getTextBBox(fitLine, fakeText);\n\n    textBBox.width = fitLine ? textBBox.width : 0;\n\n    // try to fit\n    if (fitLine === ' ' || fitLine === '' || textBBox.width < Math.round(maxWidth) || fitLine.length < 2) {\n      return fit(lines, fitLine, originalLine, textBBox);\n    }\n\n    fitLine = shortenLine(fitLine, textBBox.width, maxWidth);\n  }\n}\n\nfunction fit(lines, fitLine, originalLine, textBBox) {\n  if (fitLine.length < originalLine.length) {\n    var remainder = originalLine.slice(fitLine.length).trim();\n\n    lines.unshift(remainder);\n  }\n\n  return {\n    width: textBBox.width,\n    height: textBBox.height,\n    text: fitLine\n  };\n}\n\n\n/**\n * Shortens a line based on spacing and hyphens.\n * Returns the shortened result on success.\n *\n * @param  {String} line\n * @param  {Number} maxLength the maximum characters of the string\n * @return {String} the shortened string\n */\nfunction semanticShorten(line, maxLength) {\n  var parts = line.split(/(\\s|-)/g),\n      part,\n      shortenedParts = [],\n      length = 0;\n\n  // try to shorten via spaces + hyphens\n  if (parts.length > 1) {\n    while ((part = parts.shift())) {\n      if (part.length + length < maxLength) {\n        shortenedParts.push(part);\n        length += part.length;\n      } else {\n        // remove previous part, too if hyphen does not fit anymore\n        if (part === '-') {\n          shortenedParts.pop();\n        }\n\n        break;\n      }\n    }\n  }\n\n  return shortenedParts.join('');\n}\n\n\nfunction shortenLine(line, width, maxWidth) {\n  var length = Math.max(line.length * (maxWidth / width), 1);\n\n  // try to shorten semantically (i.e. based on spaces and hyphens)\n  var shortenedLine = semanticShorten(line, length);\n\n  if (!shortenedLine) {\n\n    // force shorten by cutting the long word\n    shortenedLine = line.slice(0, Math.max(Math.round(length - 1), 1));\n  }\n\n  return shortenedLine;\n}\n\n\nfunction getHelperSvg() {\n  var helperSvg = document.getElementById('helper-svg');\n\n  if (!helperSvg) {\n    helperSvg = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .create */ .Ue)('svg');\n\n    (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(helperSvg, {\n      id: 'helper-svg',\n      width: 0,\n      height: 0,\n      style: 'visibility: hidden; position: fixed'\n    });\n\n    document.body.appendChild(helperSvg);\n  }\n\n  return helperSvg;\n}\n\n\n/**\n * Creates a new label utility\n *\n * @param {Object} config\n * @param {Dimensions} config.size\n * @param {Number} config.padding\n * @param {Object} config.style\n * @param {String} config.align\n */\nfunction Text(config) {\n\n  this._config = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, {\n    size: DEFAULT_LABEL_SIZE,\n    padding: DEFAULT_BOX_PADDING,\n    style: {},\n    align: 'center-top'\n  }, config || {});\n}\n\n/**\n * Returns the layouted text as an SVG element.\n *\n * @param {String} text\n * @param {Object} options\n *\n * @return {SVGElement}\n */\nText.prototype.createText = function(text, options) {\n  return this.layoutText(text, options).element;\n};\n\n/**\n * Returns a labels layouted dimensions.\n *\n * @param {String} text to layout\n * @param {Object} options\n *\n * @return {Dimensions}\n */\nText.prototype.getDimensions = function(text, options) {\n  return this.layoutText(text, options).dimensions;\n};\n\n/**\n * Creates and returns a label and its bounding box.\n *\n * @method Text#createText\n *\n * @param {String} text the text to render on the label\n * @param {Object} options\n * @param {String} options.align how to align in the bounding box.\n *                               Any of { 'center-middle', 'center-top' },\n *                               defaults to 'center-top'.\n * @param {String} options.style style to be applied to the text\n * @param {boolean} options.fitBox indicates if box will be recalculated to\n *                                 fit text\n *\n * @return {Object} { element, dimensions }\n */\nText.prototype.layoutText = function(text, options) {\n  var box = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, this._config.size, options.box),\n      style = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .assign */ .f0)({}, this._config.style, options.style),\n      align = parseAlign(options.align || this._config.align),\n      padding = parsePadding(options.padding !== undefined ? options.padding : this._config.padding),\n      fitBox = options.fitBox || false;\n\n  var lineHeight = getLineHeight(style);\n\n  var lines = text.split(/\\r?\\n/g),\n      layouted = [];\n\n  var maxWidth = box.width - padding.left - padding.right;\n\n  // ensure correct rendering by attaching helper text node to invisible SVG\n  var helperText = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .create */ .Ue)('text');\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(helperText, { x: 0, y: 0 });\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(helperText, style);\n\n  var helperSvg = getHelperSvg();\n\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .append */ .R3)(helperSvg, helperText);\n\n  while (lines.length) {\n    layouted.push(layoutNext(lines, maxWidth, helperText));\n  }\n\n  if (align.vertical === 'middle') {\n    padding.top = padding.bottom = 0;\n  }\n\n  var totalHeight = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .reduce */ .u4)(layouted, function(sum, line, idx) {\n    return sum + (lineHeight || line.height);\n  }, 0) + padding.top + padding.bottom;\n\n  var maxLineWidth = (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .reduce */ .u4)(layouted, function(sum, line, idx) {\n    return line.width > sum ? line.width : sum;\n  }, 0);\n\n  // the y position of the next line\n  var y = padding.top;\n\n  if (align.vertical === 'middle') {\n    y += (box.height - totalHeight) / 2;\n  }\n\n  // magic number initial offset\n  y -= (lineHeight || layouted[0].height) / 4;\n\n\n  var textElement = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .create */ .Ue)('text');\n\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(textElement, style);\n\n  // layout each line taking into account that parent\n  // shape might resize to fit text size\n  (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .forEach */ .Ed)(layouted, function(line) {\n\n    var x;\n\n    y += (lineHeight || line.height);\n\n    switch (align.horizontal) {\n    case 'left':\n      x = padding.left;\n      break;\n\n    case 'right':\n      x = ((fitBox ? maxLineWidth : maxWidth)\n        - padding.right - line.width);\n      break;\n\n    default:\n      // aka center\n      x = Math.max((((fitBox ? maxLineWidth : maxWidth)\n        - line.width) / 2 + padding.left), 0);\n    }\n\n    var tspan = (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .create */ .Ue)('tspan');\n    (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .Lj)(tspan, { x: x, y: y });\n\n    tspan.textContent = line.text;\n\n    (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .append */ .R3)(textElement, tspan);\n  });\n\n  (0,tiny_svg__WEBPACK_IMPORTED_MODULE_1__/* .remove */ .Od)(helperText);\n\n  var dimensions = {\n    width: maxLineWidth,\n    height: totalHeight\n  };\n\n  return {\n    dimensions: dimensions,\n    element: textElement\n  };\n};\n\n\nfunction getLineHeight(style) {\n  if ('fontSize' in style && 'lineHeight' in style) {\n    return style.lineHeight * parseInt(style.fontSize, 10);\n  }\n}\n\n//# sourceURL=webpack://VCCPFREE/./node_modules/cmmn-js/node_modules/diagram-js/lib/util/Text.js?")}}]);