/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.cmmnplugin;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CmmnModelerMacro
implements Macro {
    private static final String DIAGRAM_NAME = "cmmnDiagramName";
    private static final String DIAGRAM_ID = "cmmnDiagramId";
    private static final String PAGE_ID = "pageId";
    private I18nResolver i18nResolver;

    public void setI18NResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        boolean isPreviewPossible;
        Map context = MacroUtils.defaultVelocityContext();
        String cmmnDiagramName = StringUtils.defaultString((String)parameters.get(DIAGRAM_NAME));
        String outputType = conversionContext.getOutputType();
        boolean bl = isPreviewPossible = "preview".equals(outputType) && cmmnDiagramName.length() > 0;
        if ("display".equals(outputType) || isPreviewPossible) {
            String cmmnDiagramId = cmmnDiagramName.replaceAll("\\s", "_");
            ContentEntityObject contentEntityObject = conversionContext.getEntity();
            if (contentEntityObject instanceof Comment) {
                return "<p>[<b>CMMN Modeler:</b> Diagrams in comments are not allowed in the CMMN plugin.]</p>";
            }
            String pageId = String.valueOf(conversionContext.getPageContext().getEntity().getId());
            context.put(DIAGRAM_NAME, cmmnDiagramName);
            context.put(DIAGRAM_ID, cmmnDiagramId);
            context.put(PAGE_ID, pageId);
            return VelocityUtils.getRenderedTemplate((String)"templates/cmmn-diagram-viewer.vm", (Map)context);
        }
        String text = this.i18nResolver.getText("de.viadee.confluence.cmmn-plugin.vccp-macro.printreplacement");
        return "<p>" + String.format(text, cmmnDiagramName) + "</p>";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

