(()=>{"use strict";var __webpack_modules__={"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\nexports["default"] = VxcpLogger;\n\n\n//# sourceURL=webpack://VBCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./viewer/viewerApp.ts":function(__unused_webpack_module,exports,__webpack_require__){eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.ViewerApp = void 0;\nconst utils = __importStar(__webpack_require__("./common/utils.ts"));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nconst enterpriseLicenseChecker = __importStar(__webpack_require__("./common/enterprise-license-checker.ts"));\nconst newDiagramXml = __importStar(__webpack_require__("./common/newDiagramXml.ts"));\nconst AttachmentManager = __importStar(__webpack_require__("./common/attachment-manager.ts"));\nconst bpmn_js_1 = __importDefault(__webpack_require__("./node_modules/bpmn-js/index.js"));\nconst NavigatedViewer_1 = __importDefault(__webpack_require__("./node_modules/bpmn-js/lib/NavigatedViewer.js"));\nconst diagram_js_origin_1 = __importDefault(__webpack_require__("./node_modules/diagram-js-origin/index.js"));\nconst notification_1 = __webpack_require__("./common/notification.ts");\nconst voting_service_1 = __webpack_require__("./common/voting-service.ts");\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\nconst dynamic_content_service_1 = __webpack_require__("./common/dynamic-content-service.ts");\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst rest_service_1 = __webpack_require__("./common/rest-service.ts");\nclass ViewerApp {\n    constructor() {\n        this.pageId = "";\n        this.diagramId = "";\n        this.macroId = "";\n        this.diagramName = "";\n        this.canvasId = "";\n        this.fullscreen = false;\n        this.enterpriseLicense = "INVALID";\n        this.lastNewsSeenDateTime = { date: "", hour: "" };\n        this.votingService = new voting_service_1.VotingService();\n        this.vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "ViewerApp");\n        this.dynamicContentService = new dynamic_content_service_1.DynamicContentService(this.lastNewsSeenDateTime);\n    }\n    init(pageId, diagramId, diagramName, lastNewsSeenDateTime = "", macroId, fullscreen) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.pageId = pageId;\n            this.diagramId = diagramId;\n            this.diagramName = diagramName;\n            this.fullscreen = fullscreen;\n            this.macroId = macroId;\n            try {\n                const decodedString = lastNewsSeenDateTime.replace(/&quot;/g, \'"\');\n                this.lastNewsSeenDateTime = JSON.parse(decodedString);\n            }\n            catch (e) {\n                this.lastNewsSeenDateTime = { date: "", hour: "" };\n            }\n            this.initJqueryIdentifiers();\n            yield this.votingService.init(this.$voteLink, this.$voteCounter);\n            this.viewer = fullscreen ? this.initFullscreenViewer() : this.initViewer();\n            if (!this.viewer) {\n                return;\n            }\n            enterpriseLicenseChecker.checkEnterprisePluginLicense().then((bpmnPluginEnterpriseActive) => {\n                this.enterpriseLicense = bpmnPluginEnterpriseActive;\n                if (bpmnPluginEnterpriseActive !== "INVALID") {\n                    (0, notification_1.showEnterpriseWithLicenseHint)(this.diagramId);\n                }\n            });\n            if (this.pageId === undefined) {\n                this.pageId = utils.getQueryParam("pageId").toString();\n            }\n            if (this.fullscreen) {\n                utils.initZoomButtons(this.viewer);\n                yield this.dynamicContentService.initNews(this.lastNewsSeenDateTime);\n            }\n            else {\n                utils.initViadeeLogo(this.diagramName);\n            }\n            const $expander = this.$viewer.closest(".expand-container");\n            $expander.children(".expand-control").on("click", (e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                const bpmnCanvas = this.viewer.get("canvas");\n                bpmnCanvas.resized();\n                bpmnCanvas.zoom("fit-viewport");\n            });\n            this.initButtonActions();\n            yield this.displayViewer();\n            yield this.loadDiagram();\n        });\n    }\n    initJqueryIdentifiers() {\n        this.$title = $("#vbcp-diagram-title-" + this.diagramId);\n        this.$editLink = this.$title.find("#vbcp-viewer-edit");\n        this.$fullscreenLink = this.$title.find("#vbcp-viewer-fullscreen");\n        this.$downloadPNGLink = this.$title.find("#vbcp-viewer-download-png");\n        this.$diagramVersion = this.$title.find("#vbcp-diagram-version");\n        this.$migrateToEnterpriseLink = this.$title.find("#vbcp-viewer-migrate-to-enterprise");\n        this.$closeFullscreenLink = this.$title.find("#vbcp-fullscreen-close");\n        this.$differLink = this.$title.find("#vbcp-fullscreen-differ");\n        this.$viewer = this.fullscreen ? $("#viewer") : $("#viewer-" + this.diagramId);\n        this.canvasId = this.fullscreen ? ".canvas-fullscreen-viewer" : ".canvas";\n        this.$canvas = this.$viewer.find(this.canvasId);\n        this.$loadingText = this.$viewer.find("#diagram-loading");\n        this.migratingText = this.$viewer.find("#diagram-migration");\n        this.$infoLink = this.$title.find("#vbcp-toolbar-js-info");\n        this.$voteLink = this.$title.find("#vbcp-toolbar-js-vote");\n        this.$newsLink = this.$title.find("#vbcp-toolbar-news");\n        this.$voteCounter = this.$title.find("#vbcp-toolbar-js-vote-counter");\n    }\n    initButtonActions() {\n        if (this.fullscreen) {\n            this.$newsLink.click((e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                const updatedLastSeenDate = yield this.dynamicContentService.showNewsMessageBox(this.lastNewsSeenDateTime);\n                yield this.updateLastNewsSeenDate(updatedLastSeenDate);\n            }));\n            this.$voteLink.click((e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                yield this.votingService.voteLinkClickAction();\n            }));\n            this.$infoLink.click((e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                $("#viadee-info-header").blur();\n                yield (0, notification_1.showInfoDialogForEnterpriseModeler)(this.votingService, this.enterpriseLicense, () => __awaiter(this, void 0, void 0, function* () {\n                    yield this.votingService.toggleVote();\n                }));\n            }));\n            this.$closeFullscreenLink.click((e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                window.open(Confluence.getContextPath() + "/pages/viewpage.action?pageId=" + this.pageId, "_self");\n            });\n            this.$differLink.click((e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                const featureName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.differ");\n                const imgName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.differ.image-src");\n                const imgSrc = (0, rest_service_1.buildPluginBaseUrl)() + "/download/resources/de.viadee.confluence.bpmn-plugin/images/" + imgName;\n                (0, utils_1.showDialog)(AJS, "#vbcp-enterprise-feature-dialog", Confluence.Templates.viadee.bpmnplugin.enterpriseFeatureDialog, () => {\n                    window.open("https://www.viadee.de/en/solutions/business-process-management/bpmn-modeler");\n                }, undefined, { featureName, imgSrc });\n            });\n        }\n        else {\n            this.$editLink.click((e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                $("body").append(utils.createIFrame(this.pageId, this.diagramId, this.diagramName, this.enterpriseLicense));\n            });\n            this.$fullscreenLink.click((e) => {\n                e.stopPropagation();\n                e.preventDefault();\n                window.open(Confluence.getContextPath() +\n                    "/plugins/bpmn-plugin/view-diagram.action?pageId=" +\n                    this.pageId +\n                    "&diagramId=" +\n                    this.diagramId +\n                    "&diagramName=" +\n                    this.diagramName +\n                    "&enterpriseLicense=" +\n                    this.enterpriseLicense, "_self");\n            });\n            this.$downloadPNGLink.click((e) => __awaiter(this, void 0, void 0, function* () {\n                e.stopPropagation();\n                e.preventDefault();\n                const featureName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.png-download");\n                const imgName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.png-download.image-src");\n                const imgSrc = (0, rest_service_1.buildPluginBaseUrl)() + "/download/resources/de.viadee.confluence.bpmn-plugin/images/" + imgName;\n                (0, utils_1.showDialog)(AJS, "#vbcp-enterprise-feature-dialog", Confluence.Templates.viadee.bpmnplugin.enterpriseFeatureDialog, () => {\n                    window.open("https://www.viadee.de/en/solutions/business-process-management/bpmn-modeler");\n                }, undefined, { featureName, imgSrc });\n            }));\n        }\n        this.$migrateToEnterpriseLink.click((e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            if (this.enterpriseLicense !== "INVALID") {\n                yield this.migrateToEnterpriseMacro();\n            }\n            else {\n                yield (0, notification_1.showInfoDialogForEnterpriseModeler)(this.votingService, this.enterpriseLicense, () => __awaiter(this, void 0, void 0, function* () {\n                    yield this.votingService.toggleVote();\n                }));\n            }\n        }));\n    }\n    updateLastNewsSeenDate(updatedLastSeenDate) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.lastNewsSeenDateTime.date === updatedLastSeenDate.date && this.lastNewsSeenDateTime.hour === updatedLastSeenDate.hour) {\n                return;\n            }\n            this.lastNewsSeenDateTime = updatedLastSeenDate;\n            yield this.dynamicContentService.updateLastNewsSeenDate(updatedLastSeenDate);\n        });\n    }\n    migrateToEnterpriseMacro() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.migratingText.css("display") !== "none") {\n                return;\n            }\n            yield this.migratingText.show();\n            $.ajax({\n                url: AJS.contextPath() + "/rest/bpmn-modeler/1.0/migration/migrateOneMacro/" + this.pageId + "/" + this.macroId + "/vbcp-macro-enterprise",\n                type: "GET",\n                success: () => {\n                    location.reload();\n                },\n                error: (err) => {\n                    this.vxcpLogger.logError("migrateToEnterpriseMacro", "An error occurred while migrating of BPMN diagrams to Enterprise macro.", err);\n                },\n            });\n        });\n    }\n    displayViewer() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.$viewer.show();\n            const hideFullscreenLinkCreate = /\\/(create|edit)page\\.action/i.test(window.location.href);\n            const hideFullscreenLinkDraftShare = /\\/.*draftShareId.*/i.test(window.location.href);\n            const hideFullscreenLink = hideFullscreenLinkCreate || hideFullscreenLinkDraftShare;\n            hideFullscreenLink ? this.$fullscreenLink.hide() : this.$fullscreenLink.show();\n        });\n    }\n    displayVersion(version) {\n        this.$diagramVersion.html("(v." + version + ")");\n    }\n    loadDiagram() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.$loadingText.show();\n            return AttachmentManager.loadAttachment(this.diagramName + ".bpmn", this.pageId)\n                .then((attachment) => __awaiter(this, void 0, void 0, function* () {\n                this.displayVersion(attachment.version || 0);\n                yield this.openDiagram(attachment.data);\n            }))\n                .catch((error) => __awaiter(this, void 0, void 0, function* () {\n                yield this.openDiagram(newDiagramXml.getNewDiagramXml());\n                yield this.displayViewer();\n            }));\n        });\n    }\n    openDiagram(xml) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const importedXML = yield this.viewer.importXML(xml);\n                utils.removeDjsHelperSvg($);\n                this.$loadingText.hide();\n                const warnings = importedXML.warnings;\n                if (warnings.length) {\n                    this.vxcpLogger.logWarning("openDiagram", "An error occurred while opening the BPMN diagram. The BPMN file, which you tried to open has no valid BPMN 2.0 format.", warnings);\n                }\n                if (this.fullscreen) {\n                    utils.moveDiagramToTopLeft(this.viewer, 180, 100);\n                }\n                const canvas = this.viewer.get("canvas");\n                canvas.zoom("fit-viewport");\n            }\n            catch (err) {\n                this.$loadingText.hide();\n                this.vxcpLogger.logError("openDiagram", "An error occurred while opening the BPMN diagram. The BPMN file, which you try to open is probably broken or has no valid BPMN 2.0 format.", err);\n            }\n            return;\n        });\n    }\n    initViewer() {\n        try {\n            const bpmnViewer = new bpmn_js_1.default({\n                container: this.$canvas,\n            });\n            return bpmnViewer;\n        }\n        catch (e) {\n            this.vxcpLogger.logError("initViewer", "An error occurred while initializing the viewer for a diagram.", e);\n            return;\n        }\n    }\n    initFullscreenViewer() {\n        return new NavigatedViewer_1.default({\n            container: this.$canvas,\n            additionalModules: [diagram_js_origin_1.default],\n        });\n    }\n}\nexports.ViewerApp = ViewerApp;\n\n\n//# sourceURL=webpack://VBCPFREE/./viewer/viewerApp.ts?')},"./node_modules/diagram-js-origin/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"default\": () => (/* binding */ diagram_js_origin)\n});\n\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/lib/configure-origin.js\n\n\nvar CROSS_COLOR = '#CCC',\n    BORDER_COLOR = 'rgba(0,0,0,0.1)';\n\n\n/**\n * A diagram-js extension that shows a (0, 0) origin indicator\n * on the canvas as well as (optionally) the canvas borders.\n *\n * @param {Object} [config]\n * @param {Canvas} canvas\n */\nfunction ConfigureOrigin(config, canvas) {\n\n  config = config || {};\n\n  var borderColor = config.borderColor || BORDER_COLOR,\n      crossColor = config.crossColor || CROSS_COLOR ;\n\n  var w = 30, h = 2,\n      w_half = w / 2,\n      s = -h / 2,\n      lineStart = w_half + 7;\n\n  var parent = canvas.getLayer('djs-origin', -1);\n\n  var g,\n      line,\n      cross,\n      label;\n\n  g = createEl('g', {\n    'pointer-events': 'none'\n  });\n\n  (0,index_esm/* append */.R3)(parent, g);\n\n  if (config.showBorder !== false) {\n\n    // the dashed lines, marking positive document coordinates\n    line = createEl('path', {\n      'class': cls('border'),\n      'd': path([\n        'M', -lineStart, s,\n        'H', -1000,\n        'M', lineStart, s,\n        'H', 6000,\n        'M', s, -lineStart,\n        'V', -1000,\n        'M', s, lineStart,\n        'V', 3000\n      ]),\n      'fill': 'none',\n      'stroke': borderColor,\n      'stroke-width': h + 'px',\n      'stroke-dasharray': '6, 6',\n      'shape-rendering': 'crispedges'\n    });\n\n    (0,index_esm/* append */.R3)(g, line);\n  }\n\n  // the cross that marks the diagram origin\n  cross = createEl('path', {\n    d: path([\n      'M', -w_half, s,\n      'H', w_half,\n      'M', s, -w_half,\n      'V', w_half\n    ]),\n    'class': cls('cross'),\n    'fill': 'none',\n    'stroke': crossColor,\n    'stroke-width': h + 'px',\n    'stroke-linecap': 'round'\n  });\n\n  (0,index_esm/* append */.R3)(g, cross);\n\n  label = createEl('text', {\n    x: -40,\n    y: -10,\n    fill: crossColor,\n    'class': cls('label'),\n  });\n\n  label.textContent = '(0, 0)';\n\n  (0,index_esm/* append */.R3)(g, label);\n}\n\nConfigureOrigin.$inject = [\n  'config.origin',\n  'canvas'\n];\n\n\n// helpers ///////////////////////////////////\n\nfunction path(parts) {\n  return parts.join(' ');\n}\n\nfunction cls(name) {\n  return 'djs-origin-' + name;\n}\n\nfunction createEl(type, attrs) {\n\n  var el = (0,index_esm/* create */.Ue)(type);\n\n  (0,index_esm/* attr */.Lj)(el, attrs);\n\n  return el;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/index.js\n\n\n/* harmony default export */ const diagram_js_origin = ({\n  __init__: [\n    ConfigureOrigin\n  ]\n});\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/diagram-js-origin/index.js_+_1_modules?")}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var i=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(i.exports,i,i.exports,__webpack_require__),i.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,i,t)=>{if(!n){var r=1/0;for(c=0;c<deferred.length;c++){for(var[n,i,t]=deferred[c],a=!0,o=0;o<n.length;o++)(!1&t||r>=t)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[o])))?n.splice(o--,1):(a=!1,t<r&&(r=t));if(a){deferred.splice(c--,1);var s=i();void 0!==s&&(e=s)}}return e}t=t||0;for(var c=deferred.length;c>0&&deferred[c-1][2]>t;c--)deferred[c]=deferred[c-1];deferred[c]=[n,i,t]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var i in n)__webpack_require__.o(n,i)&&!__webpack_require__.o(e,i)&&Object.defineProperty(e,i,{enumerable:!0,get:n[i]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.j="bpmnFreeViewer",(()=>{var e={bpmnFreeViewer:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,i)=>{var t,r,[a,o,s]=i,c=0;if(a.some((n=>0!==e[n]))){for(t in o)__webpack_require__.o(o,t)&&(__webpack_require__.m[t]=o[t]);if(s)var d=s(__webpack_require__)}for(n&&n(i);c<a.length;c++)r=a[c],__webpack_require__.o(e,r)&&e[r]&&e[r][0](),e[r]=0;return __webpack_require__.O(d)},i=self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[];i.forEach(n.bind(null,0)),i.push=n.bind(null,i.push.bind(i))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnFreeCommon","bpmnFreeDiagramJs","bpmnFreeBpmnJs","bpmnFreeVendors"],(()=>__webpack_require__("./viewer/viewerApp.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCPFREE=window.VBCPFREE||{}).bpmnFreeViewer=__webpack_exports__})();