(()=>{"use strict";var __webpack_modules__={"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\nexports["default"] = VxcpLogger;\n\n\n//# sourceURL=webpack://VBCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./dialogs/macro-dialog.ts":function(__unused_webpack_module,exports,__webpack_require__){eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nconst Validator = __importStar(__webpack_require__("./common/validator.ts"));\nconst enterpriseLicenseChecker = __importStar(__webpack_require__("./common/enterprise-license-checker.ts"));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nconst utils_2 = __webpack_require__("./common/utils.ts");\nAJS.bind("init.rte", () => __awaiter(void 0, void 0, void 0, function* () {\n    const macroName = "vbcp-macro";\n    const dialogId = "#vbcp-macro-dialog";\n    const customDialog = Confluence.Templates.viadee.bpmnplugin.macroDialog();\n    $("body").append(customDialog);\n    const $cancel = $(dialogId + "-close");\n    const $submit = $(dialogId + "-submit");\n    const $input = $(dialogId + "-name-input");\n    const $error = $(dialogId + "-error");\n    yield lazyLoadI18nTexts();\n    licenseHandling();\n    bindEditorEvents();\n    $cancel.off();\n    $cancel.click((e) => {\n        e.stopPropagation();\n        e.preventDefault();\n        AJS.dialog2(dialogId).hide();\n    });\n    $input.keydown((e) => {\n        if (e.which === 27) {\n            e.stopPropagation();\n            e.preventDefault();\n            $cancel.click();\n        }\n    });\n    $input.keypress((e) => {\n        if (e.which === 13) {\n            e.stopPropagation();\n            e.preventDefault();\n            $submit.click();\n        }\n    });\n    $submit.click((e) => {\n        e.stopPropagation();\n        e.preventDefault();\n        const value = $input.val();\n        const name = value ? value.trim() : "";\n        Validator.isValidMacroName(name).then((isValidMacroName) => {\n            if (name.length === 0) {\n                showErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.insert-dialog.minimumLengthWarning"));\n            }\n            else if (!Validator.isValidInput(name)) {\n                showErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.insert-dialog.notValidWarning"));\n            }\n            else if (name.length > 100) {\n                showErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.insert-dialog.nameLengthWarning"));\n            }\n            else if (!isValidMacroName) {\n                showErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.insert-dialog.sameNameWarning"));\n            }\n            else {\n                submitMacro(name);\n            }\n        });\n    });\n    function showErrorMessage(message) {\n        $error.text(message);\n    }\n    function clearFields() {\n        $input.val("");\n        $error.text("");\n    }\n    function submitMacro(name) {\n        const currentParams = {\n            diagramName: name,\n        };\n        const macro = {\n            name: macroName,\n            params: currentParams,\n            defaultParameterValue: "",\n            body: "",\n        };\n        tinymce.confluence.macrobrowser.macroBrowserComplete(macro);\n        AJS.dialog2(dialogId).hide();\n    }\n    function showWarningDialog(warningDialogId, template, callbackContinue, callbackAbort, params) {\n        const dialog = template(params);\n        $("body").append(dialog);\n        AJS.dialog2(warningDialogId).show();\n        AJS.dialog2(warningDialogId).on("hide", () => {\n            $(warningDialogId).remove();\n        });\n        $(warningDialogId + "-abort").click((e) => {\n            AJS.dialog2(warningDialogId).hide();\n            if (typeof callbackAbort === "function") {\n                callbackAbort();\n            }\n        });\n        $(warningDialogId + "-continue").click((e) => {\n            AJS.dialog2(warningDialogId).hide();\n            if (typeof callbackContinue === "function") {\n                callbackContinue();\n            }\n        });\n    }\n    function insertEditVBCPFree(macro) {\n        if ((0, utils_2.getParams)().contentType === "comment") {\n            showWarningDialog("#vbcp-no-diagrams-in-comments-dialog", Confluence.Templates.viadee.bpmnplugin.noDiagramsInCommentsDialog);\n            return;\n        }\n        if (macro.params) {\n            if ((0, utils_2.getParams)().newPage) {\n                showWarningDialog("#vbcp-save-first-dialog", Confluence.Templates.viadee.bpmnplugin.saveFirstDialog);\n                return;\n            }\n            const diagramName = macro.params.diagramName;\n            const diagramId = diagramName.replace(/\\s/g, "_");\n            let enterpriseLicense = "INVALID";\n            enterpriseLicenseChecker.checkEnterprisePluginLicense().then((bpmnPluginEnterpriseActive) => {\n                enterpriseLicense = bpmnPluginEnterpriseActive;\n            });\n            tinymce.confluence.macrobrowser.macroBrowserComplete({\n                name: macroName,\n                bodyHtml: undefined,\n                params: macro.params,\n            });\n            $("body").append((0, utils_1.createIFrame)((0, utils_2.getParams)().pageId, diagramId, diagramName, enterpriseLicense, false));\n        }\n        else {\n            clearFields();\n            AJS.dialog2(dialogId).show();\n            $input.focus();\n        }\n    }\n    function licenseHandling() {\n        enterpriseLicenseChecker.checkEnterprisePluginLicense().then((data) => {\n            const bpmnPluginEnterpriseActive = data;\n            if (bpmnPluginEnterpriseActive !== "INVALID") {\n                AJS.messages.info($(dialogId + "-license"), {\n                    title: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.vbcp-macro.macro-dialog.enterprise-active-title"),\n                    body: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.vbcp-macro.macro-dialog.enterprise-active-body"),\n                    isClosable: false,\n                });\n            }\n        });\n    }\n    function lazyLoadI18nTexts() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield new Promise((resolve) => {\n                AJS.I18n.get("de.viadee.confluence.bpmn-plugin", resolve);\n            });\n        });\n    }\n    function bindEditorEvents() {\n        AJS.Rte.getEditor().on("beforeSetContent", checkForDuplicateDiagrams.bind(null));\n    }\n    function checkForDuplicateDiagrams(event) {\n        const diagramNames = extractDiagramNameFromHtmlContent(event.content);\n        if (!diagramNames) {\n            return;\n        }\n        for (const diagramName of diagramNames) {\n            const macroNode = getMacroNodeFromEditorContentByDiagramName(diagramName);\n            if (macroNode) {\n                event.stopPropagation();\n                event.preventDefault();\n                showWarningDialog("#vbcp-diagram-already-exists-on-page-dialog", Confluence.Templates.viadee.bpmnplugin.diagramAlreadyExistsOnPageDialog);\n                return;\n            }\n        }\n    }\n    function extractDiagramNameFromHtmlContent(htmlContent) {\n        if (!(htmlContent === null || htmlContent === void 0 ? void 0 : htmlContent.includes("diagramName"))) {\n            return null;\n        }\n        const returnMatches = [];\n        const matchesWithBefore = htmlContent.match(/(?:diagramName=)(.*?)(?=["|])/g) || [];\n        for (const match of matchesWithBefore) {\n            returnMatches.push(match.replace("diagramName=", ""));\n        }\n        return returnMatches;\n    }\n    function getMacroNodeFromEditorContentByDiagramName(diagramName) {\n        const editorHtml = $("#wysiwygTextarea_ifr").contents().find("#tinymce").prop("outerHTML");\n        const parser = new DOMParser();\n        const doc = parser.parseFromString(editorHtml, "text/html");\n        const list = doc.querySelectorAll("img.editor-inline-macro");\n        const nodeListWithAllMacros = Array.prototype.slice.call(list);\n        for (const curMacro of nodeListWithAllMacros) {\n            const curMacroName = curMacro.getAttribute("data-macro-name");\n            const macroParams = curMacro.getAttribute("data-macro-parameters");\n            if (curMacroName.includes(macroName) && macroParams.indexOf(`diagramName=${diagramName}`) >= 0) {\n                return curMacro;\n            }\n        }\n        return null;\n    }\n    AJS.MacroBrowser.setMacroJsOverride(macroName, {\n        opener: insertEditVBCPFree,\n    });\n}));\n\n\n//# sourceURL=webpack://VBCPFREE/./dialogs/macro-dialog.ts?')}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var r=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(r.exports,r,r.exports,__webpack_require__),r.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,r,a)=>{if(!n){var o=1/0;for(s=0;s<deferred.length;s++){for(var[n,r,a]=deferred[s],t=!0,i=0;i<n.length;i++)(!1&a||o>=a)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[i])))?n.splice(i--,1):(t=!1,a<o&&(o=a));if(t){deferred.splice(s--,1);var c=r();void 0!==c&&(e=c)}}return e}a=a||0;for(var s=deferred.length;s>0&&deferred[s-1][2]>a;s--)deferred[s]=deferred[s-1];deferred[s]=[n,r,a]},__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),(()=>{var e={bpmnFreeMacroDialog:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,r)=>{var a,o,[t,i,c]=r,s=0;if(t.some((n=>0!==e[n]))){for(a in i)__webpack_require__.o(i,a)&&(__webpack_require__.m[a]=i[a]);if(c)var l=c(__webpack_require__)}for(n&&n(r);s<t.length;s++)o=t[s],__webpack_require__.o(e,o)&&e[o]&&e[o][0](),e[o]=0;return __webpack_require__.O(l)},r=self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[];r.forEach(n.bind(null,0)),r.push=n.bind(null,r.push.bind(r))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnFreeCommon"],(()=>__webpack_require__("./dialogs/macro-dialog.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCPFREE=window.VBCPFREE||{}).bpmnFreeMacroDialog=__webpack_exports__})();