(()=>{"use strict";var __webpack_modules__={"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\nexports["default"] = VxcpLogger;\n\n\n//# sourceURL=webpack://VBCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./editor/editorApp.ts":function(__unused_webpack_module,exports,__webpack_require__){eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.EditorApp = void 0;\nconst confUtils = __importStar(__webpack_require__("./common/utils.ts"));\nconst Modeler_1 = __importDefault(__webpack_require__("./node_modules/bpmn-js/lib/Modeler.js"));\nconst DiagramState = __importStar(__webpack_require__("./common/diagram-state.ts"));\nconst DiagramManager = __importStar(__webpack_require__("./common/diagram-manager.ts"));\nconst diagram_js_origin_1 = __importDefault(__webpack_require__("./node_modules/diagram-js-origin/index.js"));\nconst notification_1 = __webpack_require__("./common/notification.ts");\nconst voting_service_1 = __webpack_require__("./common/voting-service.ts");\nconst dynamic_content_service_1 = __webpack_require__("./common/dynamic-content-service.ts");\nconst file_saver_1 = __importDefault(__webpack_require__("./node_modules/file-saver/dist/FileSaver.min.js"));\nconst rest_service_1 = __webpack_require__("./common/rest-service.ts");\nclass EditorApp {\n    constructor() {\n        this.lastNewsSeenDateTime = { date: "", hour: "" };\n        this.pageId = "";\n        this.diagramName = "";\n        this.enterpriseLicense = "";\n        this.votingService = new voting_service_1.VotingService();\n        this.dynamicContentService = new dynamic_content_service_1.DynamicContentService(this.lastNewsSeenDateTime);\n    }\n    init(pageId, diagramId, diagramName, lastNewsSeenDateTime = "", enterpriseLicense) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.pageId = pageId;\n            this.diagramName = diagramName;\n            this.enterpriseLicense = enterpriseLicense;\n            try {\n                const decodedString = lastNewsSeenDateTime.replace(/&quot;/g, \'"\');\n                this.lastNewsSeenDateTime = JSON.parse(decodedString);\n            }\n            catch (e) {\n                this.lastNewsSeenDateTime = { date: "", hour: "" };\n            }\n            this.initJqueryIdentifiers();\n            this.modeler = this.initModeler();\n            this.initButtonActions();\n            this.initShortcuts();\n            this.initLeavePageAction();\n            this.initDragAndDrop();\n            this.initFileUpload();\n            yield this.votingService.init(this.$voteLink, this.$voteCounter);\n            confUtils.initZoomButtons(this.modeler);\n            yield DiagramManager.loadDiagram(this.modeler, diagramName, pageId, false);\n            yield this.dynamicContentService.initNews(this.lastNewsSeenDateTime);\n            this.modeler.on("commandStack.changed", () => {\n                this.onDiagramChange(this.modeler, diagramName, pageId);\n            });\n            if (this.$voteLink.is(":visible")) {\n                setTimeout(() => {\n                    (0, notification_1.showAdForEnterpriseEditor)(this.votingService, this.enterpriseLicense);\n                }, 120000);\n            }\n        });\n    }\n    initJqueryIdentifiers() {\n        this.$modeler = $("#modeler");\n        this.$title = $("#vbcp-diagram-title");\n        this.$toolbar = $(".toolbar");\n        this.$container = this.$modeler.find(".content");\n        this.$canvas = this.$modeler.find(".canvas-editor");\n        this.$downloadLinkBpmn = this.$toolbar.find("#vbcp-toolbar-js-download");\n        this.$downloadLinkSvg = this.$toolbar.find("#vbcp-toolbar-js-download-svg");\n        this.$saveLink = this.$toolbar.find("#vbcp-toolbar-js-save");\n        this.$resetLink = this.$toolbar.find("#vbcp-toolbar-js-reset");\n        this.$importLink = this.$toolbar.find("#vbcp-toolbar-js-import");\n        this.$importInput = this.$toolbar.find("#vbcp-diagram-import");\n        this.$diagramConfigLink = this.$toolbar.find("#vbcp-toolbar-diagram-config");\n        this.$exitLink = this.$title.find("#vbcp-toolbar-js-exit");\n        this.$infoLink = this.$title.find("#vbcp-toolbar-js-info");\n        this.$voteLink = this.$title.find("#vbcp-toolbar-js-vote");\n        this.$newsLink = this.$title.find("#vbcp-toolbar-news");\n        this.$voteCounter = this.$title.find("#vbcp-toolbar-js-vote-counter");\n        this.$diagramNameLabel = this.$title.find("#vbcp-diagram-name");\n    }\n    initModeler() {\n        return new Modeler_1.default({\n            container: this.$canvas,\n            additionalModules: [diagram_js_origin_1.default],\n            keyboard: { bindTo: document },\n        });\n    }\n    initFileUpload() {\n        const input = document.getElementById("vbcp-diagram-import");\n        const keyFile = "File";\n        const keyFileReader = "FileReader";\n        const keyFileList = "FileList";\n        if (!window[keyFile] || !window[keyFileReader] || !window[keyFileList] || !window.Blob) {\n            alert("The File APIs are not fully supported in this browser.");\n            return;\n        }\n        if (!input) {\n            alert("Could not find the file input element.");\n        }\n        else if (!input.files) {\n            alert("This browser does not seem to support the `files` property of file inputs.");\n        }\n        else {\n            input.addEventListener("change", () => {\n                const file = input.files[0];\n                if (file.name.match(/\\.(bpmn|xml)$/)) {\n                    const reader = new FileReader();\n                    reader.onload = () => __awaiter(this, void 0, void 0, function* () {\n                        yield DiagramManager.openDiagram(this.modeler, reader.result, this.diagramName, () => {\n                            this.onDiagramChange(this.modeler, this.diagramName, this.pageId);\n                        });\n                    });\n                    reader.readAsText(file);\n                }\n                else {\n                    confUtils.showDialog(AJS, "#vbcp-file-warning-dialog", Confluence.Templates.viadee.bpmnplugin.fileWarningDialog);\n                }\n            });\n            input.onclick = (e) => {\n                e.target.value = null;\n            };\n        }\n    }\n    initButtonActions() {\n        this.$newsLink.click((e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            const updatedLastSeenDate = yield this.dynamicContentService.showNewsMessageBox(this.lastNewsSeenDateTime);\n            yield this.updateLastNewsSeenDate(updatedLastSeenDate);\n        }));\n        this.$voteLink.click((e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            yield this.votingService.voteLinkClickAction();\n        }));\n        this.$exitLink.click((e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            if (!DiagramState.isDiagramSaved()) {\n                confUtils.showDialog(AJS, "#vbcp-exit-warning-dialog", Confluence.Templates.viadee.bpmnplugin.exitWarningDialog, this.exitModeler);\n            }\n            else {\n                this.exitModeler();\n            }\n        });\n        this.$diagramConfigLink.click((e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            const featureName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.diagram-configuration");\n            const imgName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.diagram-configuration.image-src");\n            const imgSrc = (0, rest_service_1.buildPluginBaseUrl)() + "/download/resources/de.viadee.confluence.bpmn-plugin/images/" + imgName;\n            confUtils.showDialog(AJS, "#vbcp-enterprise-feature-dialog", Confluence.Templates.viadee.bpmnplugin.enterpriseFeatureDialog, () => {\n                window.open("https://www.viadee.de/en/solutions/business-process-management/bpmn-modeler");\n            }, undefined, { featureName, imgSrc });\n        });\n        this.$infoLink.click((e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            $("#viadee-info-header").blur();\n            yield (0, notification_1.showInfoDialogForEnterpriseModeler)(this.votingService, this.enterpriseLicense, () => __awaiter(this, void 0, void 0, function* () {\n                yield this.votingService.toggleVote();\n            }));\n        }));\n        this.$importLink.click((e) => {\n            e.stopPropagation();\n            e.preventDefault();\n            if (!DiagramState.isDiagramSaved()) {\n                confUtils.showDialog(AJS, "#vbcp-import-warning-dialog", Confluence.Templates.viadee.bpmnplugin.importWarningDialog, () => {\n                    this.$importInput.click();\n                });\n            }\n            else {\n                this.$importInput.click();\n            }\n        });\n        $(".buttons a").click((e) => {\n            if (!$(e.target).is(".active")) {\n                e.preventDefault();\n                e.stopPropagation();\n            }\n        });\n        this.$downloadLinkBpmn.click((e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            const xml = yield DiagramManager.getDiagramXML(this.modeler);\n            const blobObject = new Blob([xml]);\n            this.downloadBlob(blobObject, this.diagramName, ".bpmn");\n        }));\n        this.$downloadLinkSvg.click((e) => __awaiter(this, void 0, void 0, function* () {\n            e.stopPropagation();\n            e.preventDefault();\n            const svg = yield DiagramManager.getDiagramSVG(this.modeler);\n            const svgBlob = new Blob([svg]);\n            this.downloadBlob(svgBlob, this.diagramName, ".svg");\n        }));\n    }\n    downloadBlob(fileBlob, fileName, fileType) {\n        if (!(fileBlob instanceof Blob)) {\n            fileBlob = new Blob([fileBlob]);\n        }\n        try {\n            file_saver_1.default.saveAs(fileBlob, fileName + fileType);\n        }\n        catch (e) {\n            alert("The file could not be downloaded. Please try a different browser.");\n        }\n    }\n    initShortcuts() {\n        window.addEventListener("keypress", (e) => {\n            e.stopImmediatePropagation();\n        }, true);\n        $(window).bind("keypress", (event) => {\n            this.checkKeyCodes(event);\n        });\n        $(window).bind("keydown", (event) => {\n            this.checkKeyCodes(event);\n        });\n    }\n    checkKeyCodes(event) {\n        if (event.ctrlKey || event.metaKey) {\n            switch (String.fromCharCode(event.which).toLowerCase()) {\n                case "s":\n                    event.preventDefault();\n                    this.$saveLink.click();\n                    break;\n            }\n        }\n    }\n    initLeavePageAction() {\n        window.onbeforeunload = () => {\n            if (DiagramState.isDiagramSaved()) {\n                return;\n            }\n            return AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.exit-warning-dialog.desc");\n        };\n    }\n    initDragAndDrop() {\n        function registerFileDrop($container, callback) {\n            function handleFileSelect(e) {\n                e.stopPropagation();\n                e.preventDefault();\n                const files = e.dataTransfer.files;\n                const file = files[0];\n                const reader = new FileReader();\n                reader.onload = (event) => {\n                    const currentElement = event.target;\n                    const xml = currentElement.result;\n                    callback(xml);\n                };\n                reader.readAsText(file);\n            }\n            function handleDragOver(e) {\n                e.stopPropagation();\n                e.preventDefault();\n                e.dataTransfer.dropEffect = "copy";\n            }\n            $container.get(0).addEventListener("dragover", handleDragOver, false);\n            $container.get(0).addEventListener("drop", handleFileSelect, false);\n        }\n        $(document).on("keypress", (e) => {\n            const body = e.target;\n            if (body && body.contentEditable && body.classList) {\n                e.stopImmediatePropagation();\n            }\n        });\n        const keyFileList = "FileList";\n        const keyFileReader = "FileReader";\n        if (!window[keyFileList] || !window[keyFileReader]) {\n            window.alert(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.editor.notification.diagramUpdated"));\n        }\n        else {\n            registerFileDrop(this.$container, (xml) => __awaiter(this, void 0, void 0, function* () {\n                if (!DiagramState.isDiagramSaved()) {\n                    confUtils.showDialog(AJS, "#vbcp-import-warning-dialog", Confluence.Templates.viadee.bpmnplugin.importWarningDialog, () => __awaiter(this, void 0, void 0, function* () {\n                        yield DiagramManager.openDiagram(this.modeler, xml, this.diagramName, () => {\n                            this.onDiagramChange(this.modeler, this.diagramName, this.pageId);\n                        });\n                    }));\n                }\n                else {\n                    yield DiagramManager.openDiagram(this.modeler, xml, this.diagramName, () => {\n                        this.onDiagramChange(this.modeler, this.diagramName, this.pageId);\n                    });\n                }\n            }));\n        }\n    }\n    onDiagramChange(modeler, diagramName, pageId) {\n        this.$saveLink.addClass("active");\n        this.$resetLink.addClass("active");\n        this.$diagramNameLabel.html(diagramName + "*").css("font-style", "italic");\n        DiagramState.saveDiagram(false);\n        activateButton(this.$saveLink, () => {\n            DiagramManager.saveDiagram(modeler, diagramName, pageId);\n        });\n        activateButton(this.$resetLink, () => __awaiter(this, void 0, void 0, function* () {\n            yield DiagramManager.loadDiagram(modeler, diagramName, pageId, true);\n        }));\n        function activateButton($link, action) {\n            $link.css({ cursor: "pointer" });\n            $link.off();\n            $link.click((e) => {\n                e.preventDefault();\n                e.stopPropagation();\n                action();\n            });\n        }\n    }\n    updateLastNewsSeenDate(updatedLastSeenDate) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.lastNewsSeenDateTime.date === updatedLastSeenDate.date && this.lastNewsSeenDateTime.hour === updatedLastSeenDate.hour) {\n                return;\n            }\n            this.lastNewsSeenDateTime = updatedLastSeenDate;\n            yield this.dynamicContentService.updateLastNewsSeenDate(updatedLastSeenDate);\n        });\n    }\n    exitModeler() {\n        DiagramState.saveDiagram(true);\n        const reloadPage = confUtils.getQueryParam("reloadPage");\n        if (reloadPage === "true") {\n            window.parent.location.reload();\n        }\n        else {\n            $("body", window.parent.document).css("overflow", "");\n            $("#bpmn-editor", window.parent.document).remove();\n        }\n    }\n}\nexports.EditorApp = EditorApp;\n\n\n//# sourceURL=webpack://VBCPFREE/./editor/editorApp.ts?')},"./node_modules/diagram-js-direct-editing/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ diagram_js_direct_editing)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-direct-editing/lib/TextBox.js\n\n\n\n\nvar min = Math.min,\n    max = Math.max;\n\nfunction preventDefault(e) {\n  e.preventDefault();\n}\n\nfunction stopPropagation(e) {\n  e.stopPropagation();\n}\n\nfunction isTextNode(node) {\n  return node.nodeType === Node.TEXT_NODE;\n}\n\nfunction toArray(nodeList) {\n  return [].slice.call(nodeList);\n}\n\n/**\n * Initializes a container for a content editable div.\n *\n * Structure:\n *\n * container\n *   parent\n *     content\n *     resize-handle\n *\n * @param {object} options\n * @param {DOMElement} options.container The DOM element to append the contentContainer to\n * @param {Function} options.keyHandler Handler for key events\n * @param {Function} options.resizeHandler Handler for resize events\n */\nfunction TextBox(options) {\n  this.container = options.container;\n\n  this.parent = (0,dist_index_esm/* domify */.H6)(\n    '<div class=\"djs-direct-editing-parent\">' +\n      '<div class=\"djs-direct-editing-content\" contenteditable=\"true\"></div>' +\n    '</div>'\n  );\n\n  this.content = (0,dist_index_esm/* query */.IO)('[contenteditable]', this.parent);\n\n  this.keyHandler = options.keyHandler || function() {};\n  this.resizeHandler = options.resizeHandler || function() {};\n\n  this.autoResize = (0,index_esm/* bind */.ak)(this.autoResize, this);\n  this.handlePaste = (0,index_esm/* bind */.ak)(this.handlePaste, this);\n}\n\n\n/**\n * Create a text box with the given position, size, style and text content\n *\n * @param {Object} bounds\n * @param {Number} bounds.x absolute x position\n * @param {Number} bounds.y absolute y position\n * @param {Number} [bounds.width] fixed width value\n * @param {Number} [bounds.height] fixed height value\n * @param {Number} [bounds.maxWidth] maximum width value\n * @param {Number} [bounds.maxHeight] maximum height value\n * @param {Number} [bounds.minWidth] minimum width value\n * @param {Number} [bounds.minHeight] minimum height value\n * @param {Object} [style]\n * @param {String} value text content\n *\n * @return {DOMElement} The created content DOM element\n */\nTextBox.prototype.create = function(bounds, style, value, options) {\n  var self = this;\n\n  var parent = this.parent,\n      content = this.content,\n      container = this.container;\n\n  options = this.options = options || {};\n\n  style = this.style = style || {};\n\n  var parentStyle = (0,index_esm/* pick */.ei)(style, [\n    'width',\n    'height',\n    'maxWidth',\n    'maxHeight',\n    'minWidth',\n    'minHeight',\n    'left',\n    'top',\n    'backgroundColor',\n    'position',\n    'overflow',\n    'border',\n    'wordWrap',\n    'textAlign',\n    'outline',\n    'transform'\n  ]);\n\n  (0,index_esm/* assign */.f0)(parent.style, {\n    width: bounds.width + 'px',\n    height: bounds.height + 'px',\n    maxWidth: bounds.maxWidth + 'px',\n    maxHeight: bounds.maxHeight + 'px',\n    minWidth: bounds.minWidth + 'px',\n    minHeight: bounds.minHeight + 'px',\n    left: bounds.x + 'px',\n    top: bounds.y + 'px',\n    backgroundColor: '#ffffff',\n    position: 'absolute',\n    overflow: 'visible',\n    border: '1px solid #ccc',\n    boxSizing: 'border-box',\n    wordWrap: 'normal',\n    textAlign: 'center',\n    outline: 'none'\n  }, parentStyle);\n\n  var contentStyle = (0,index_esm/* pick */.ei)(style, [\n    'fontFamily',\n    'fontSize',\n    'fontWeight',\n    'lineHeight',\n    'padding',\n    'paddingTop',\n    'paddingRight',\n    'paddingBottom',\n    'paddingLeft'\n  ]);\n\n  (0,index_esm/* assign */.f0)(content.style, {\n    boxSizing: 'border-box',\n    width: '100%',\n    outline: 'none',\n    wordWrap: 'break-word'\n  }, contentStyle);\n\n  if (options.centerVertically) {\n    (0,index_esm/* assign */.f0)(content.style, {\n      position: 'absolute',\n      top: '50%',\n      transform: 'translate(0, -50%)'\n    }, contentStyle);\n  }\n\n  content.innerText = value;\n\n  dist_index_esm/* event.bind */.B.bind(content, 'keydown', this.keyHandler);\n  dist_index_esm/* event.bind */.B.bind(content, 'mousedown', stopPropagation);\n  dist_index_esm/* event.bind */.B.bind(content, 'paste', self.handlePaste);\n\n  if (options.autoResize) {\n    dist_index_esm/* event.bind */.B.bind(content, 'input', this.autoResize);\n  }\n\n  if (options.resizable) {\n    this.resizable(style);\n  }\n\n  container.appendChild(parent);\n\n  // set selection to end of text\n  this.setSelection(content.lastChild, content.lastChild && content.lastChild.length);\n\n  return parent;\n};\n\n/**\n * Intercept paste events to remove formatting from pasted text.\n */\nTextBox.prototype.handlePaste = function(e) {\n  var options = this.options,\n      style = this.style;\n\n  e.preventDefault();\n\n  var text;\n\n  if (e.clipboardData) {\n\n    // Chrome, Firefox, Safari\n    text = e.clipboardData.getData('text/plain');\n  } else {\n\n    // Internet Explorer\n    text = window.clipboardData.getData('Text');\n  }\n\n  this.insertText(text);\n\n  if (options.autoResize) {\n    var hasResized = this.autoResize(style);\n\n    if (hasResized) {\n      this.resizeHandler(hasResized);\n    }\n  }\n};\n\nTextBox.prototype.insertText = function(text) {\n  text = normalizeEndOfLineSequences(text);\n\n  // insertText command not supported by Internet Explorer\n  var success = document.execCommand('insertText', false, text);\n\n  if (success) {\n    return;\n  }\n\n  this._insertTextIE(text);\n};\n\nTextBox.prototype._insertTextIE = function(text) {\n\n  // Internet Explorer\n  var range = this.getSelection(),\n      startContainer = range.startContainer,\n      endContainer = range.endContainer,\n      startOffset = range.startOffset,\n      endOffset = range.endOffset,\n      commonAncestorContainer = range.commonAncestorContainer;\n\n  var childNodesArray = toArray(commonAncestorContainer.childNodes);\n\n  var container,\n      offset;\n\n  if (isTextNode(commonAncestorContainer)) {\n    var containerTextContent = startContainer.textContent;\n\n    startContainer.textContent =\n      containerTextContent.substring(0, startOffset)\n      + text\n      + containerTextContent.substring(endOffset);\n\n    container = startContainer;\n    offset = startOffset + text.length;\n\n  } else if (startContainer === this.content && endContainer === this.content) {\n    var textNode = document.createTextNode(text);\n\n    this.content.insertBefore(textNode, childNodesArray[startOffset]);\n\n    container = textNode;\n    offset = textNode.textContent.length;\n  } else {\n    var startContainerChildIndex = childNodesArray.indexOf(startContainer),\n        endContainerChildIndex = childNodesArray.indexOf(endContainer);\n\n    childNodesArray.forEach(function(childNode, index) {\n\n      if (index === startContainerChildIndex) {\n        childNode.textContent =\n          startContainer.textContent.substring(0, startOffset) +\n          text +\n          endContainer.textContent.substring(endOffset);\n      } else if (index > startContainerChildIndex && index <= endContainerChildIndex) {\n        (0,dist_index_esm/* remove */.Od)(childNode);\n      }\n    });\n\n    container = startContainer;\n    offset = startOffset + text.length;\n  }\n\n  if (container && offset !== undefined) {\n\n    // is necessary in Internet Explorer\n    setTimeout(function() {\n      self.setSelection(container, offset);\n    });\n  }\n};\n\n/**\n * Automatically resize element vertically to fit its content.\n */\nTextBox.prototype.autoResize = function() {\n  var parent = this.parent,\n      content = this.content;\n\n  var fontSize = parseInt(this.style.fontSize) || 12;\n\n  if (content.scrollHeight > parent.offsetHeight ||\n      content.scrollHeight < parent.offsetHeight - fontSize) {\n    var bounds = parent.getBoundingClientRect();\n\n    var height = content.scrollHeight;\n    parent.style.height = height + 'px';\n\n    this.resizeHandler({\n      width: bounds.width,\n      height: bounds.height,\n      dx: 0,\n      dy: height - bounds.height\n    });\n  }\n};\n\n/**\n * Make an element resizable by adding a resize handle.\n */\nTextBox.prototype.resizable = function() {\n  var self = this;\n\n  var parent = this.parent,\n      resizeHandle = this.resizeHandle;\n\n  var minWidth = parseInt(this.style.minWidth) || 0,\n      minHeight = parseInt(this.style.minHeight) || 0,\n      maxWidth = parseInt(this.style.maxWidth) || Infinity,\n      maxHeight = parseInt(this.style.maxHeight) || Infinity;\n\n  if (!resizeHandle) {\n    resizeHandle = this.resizeHandle = (0,dist_index_esm/* domify */.H6)(\n      '<div class=\"djs-direct-editing-resize-handle\"></div>'\n    );\n\n    var startX, startY, startWidth, startHeight;\n\n    var onMouseDown = function(e) {\n      preventDefault(e);\n      stopPropagation(e);\n\n      startX = e.clientX;\n      startY = e.clientY;\n\n      var bounds = parent.getBoundingClientRect();\n\n      startWidth = bounds.width;\n      startHeight = bounds.height;\n\n      dist_index_esm/* event.bind */.B.bind(document, 'mousemove', onMouseMove);\n      dist_index_esm/* event.bind */.B.bind(document, 'mouseup', onMouseUp);\n    };\n\n    var onMouseMove = function(e) {\n      preventDefault(e);\n      stopPropagation(e);\n\n      var newWidth = min(max(startWidth + e.clientX - startX, minWidth), maxWidth);\n      var newHeight = min(max(startHeight + e.clientY - startY, minHeight), maxHeight);\n\n      parent.style.width = newWidth + 'px';\n      parent.style.height = newHeight + 'px';\n\n      self.resizeHandler({\n        width: startWidth,\n        height: startHeight,\n        dx: e.clientX - startX,\n        dy: e.clientY - startY\n      });\n    };\n\n    var onMouseUp = function(e) {\n      preventDefault(e);\n      stopPropagation(e);\n\n      dist_index_esm/* event.unbind */.B.unbind(document,'mousemove', onMouseMove, false);\n      dist_index_esm/* event.unbind */.B.unbind(document, 'mouseup', onMouseUp, false);\n    };\n\n    dist_index_esm/* event.bind */.B.bind(resizeHandle, 'mousedown', onMouseDown);\n  }\n\n  (0,index_esm/* assign */.f0)(resizeHandle.style, {\n    position: 'absolute',\n    bottom: '0px',\n    right: '0px',\n    cursor: 'nwse-resize',\n    width: '0',\n    height: '0',\n    borderTop: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent',\n    borderRight: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',\n    borderBottom: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',\n    borderLeft: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent'\n  });\n\n  parent.appendChild(resizeHandle);\n};\n\n\n/**\n * Clear content and style of the textbox, unbind listeners and\n * reset CSS style.\n */\nTextBox.prototype.destroy = function() {\n  var parent = this.parent,\n      content = this.content,\n      resizeHandle = this.resizeHandle;\n\n  // clear content\n  content.innerText = '';\n\n  // clear styles\n  parent.removeAttribute('style');\n  content.removeAttribute('style');\n\n  dist_index_esm/* event.unbind */.B.unbind(content, 'keydown', this.keyHandler);\n  dist_index_esm/* event.unbind */.B.unbind(content, 'mousedown', stopPropagation);\n  dist_index_esm/* event.unbind */.B.unbind(content, 'input', this.autoResize);\n  dist_index_esm/* event.unbind */.B.unbind(content, 'paste', this.handlePaste);\n\n  if (resizeHandle) {\n    resizeHandle.removeAttribute('style');\n\n    (0,dist_index_esm/* remove */.Od)(resizeHandle);\n  }\n\n  (0,dist_index_esm/* remove */.Od)(parent);\n};\n\n\nTextBox.prototype.getValue = function() {\n  return this.content.innerText.trim();\n};\n\n\nTextBox.prototype.getSelection = function() {\n  var selection = window.getSelection(),\n      range = selection.getRangeAt(0);\n\n  return range;\n};\n\n\nTextBox.prototype.setSelection = function(container, offset) {\n  var range = document.createRange();\n\n  if (container === null) {\n    range.selectNodeContents(this.content);\n  } else {\n    range.setStart(container, offset);\n    range.setEnd(container, offset);\n  }\n\n  var selection = window.getSelection();\n\n  selection.removeAllRanges();\n  selection.addRange(range);\n};\n\n// helpers //////////\n\nfunction normalizeEndOfLineSequences(string) {\n  return string.replace(/\\r\\n|\\r|\\n/g, '\\n');\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-direct-editing/lib/DirectEditing.js\n\n\n\n\n\n/**\n * A direct editing component that allows users\n * to edit an elements text directly in the diagram\n *\n * @param {EventBus} eventBus the event bus\n */\nfunction DirectEditing(eventBus, canvas) {\n\n  this._eventBus = eventBus;\n\n  this._providers = [];\n  this._textbox = new TextBox({\n    container: canvas.getContainer(),\n    keyHandler: (0,index_esm/* bind */.ak)(this._handleKey, this),\n    resizeHandler: (0,index_esm/* bind */.ak)(this._handleResize, this)\n  });\n}\n\nDirectEditing.$inject = [ 'eventBus', 'canvas' ];\n\n\n/**\n * Register a direct editing provider\n\n * @param {Object} provider the provider, must expose an #activate(element) method that returns\n *                          an activation context ({ bounds: {x, y, width, height }, text }) if\n *                          direct editing is available for the given element.\n *                          Additionally the provider must expose a #update(element, value) method\n *                          to receive direct editing updates.\n */\nDirectEditing.prototype.registerProvider = function(provider) {\n  this._providers.push(provider);\n};\n\n\n/**\n * Returns true if direct editing is currently active\n *\n * @param {djs.model.Base} [element]\n *\n * @return {boolean}\n */\nDirectEditing.prototype.isActive = function(element) {\n  return !!(this._active && (!element || this._active.element === element));\n};\n\n\n/**\n * Cancel direct editing, if it is currently active\n */\nDirectEditing.prototype.cancel = function() {\n  if (!this._active) {\n    return;\n  }\n\n  this._fire('cancel');\n  this.close();\n};\n\n\nDirectEditing.prototype._fire = function(event, context) {\n  this._eventBus.fire('directEditing.' + event, context || { active: this._active });\n};\n\nDirectEditing.prototype.close = function() {\n  this._textbox.destroy();\n\n  this._fire('deactivate');\n\n  this._active = null;\n\n  this.resizable = undefined;\n};\n\n\nDirectEditing.prototype.complete = function() {\n\n  var active = this._active;\n\n  if (!active) {\n    return;\n  }\n\n  var containerBounds,\n      previousBounds = active.context.bounds,\n      newBounds = this.$textbox.getBoundingClientRect(),\n      newText = this.getValue(),\n      previousText = active.context.text;\n\n  if (\n    newText !== previousText ||\n    newBounds.height !== previousBounds.height ||\n    newBounds.width !== previousBounds.width\n  ) {\n    containerBounds = this._textbox.container.getBoundingClientRect();\n\n    active.provider.update(active.element, newText, active.context.text, {\n      x: newBounds.left - containerBounds.left,\n      y: newBounds.top - containerBounds.top,\n      width: newBounds.width,\n      height: newBounds.height\n    });\n  }\n\n  this._fire('complete');\n\n  this.close();\n};\n\n\nDirectEditing.prototype.getValue = function() {\n  return this._textbox.getValue();\n};\n\n\nDirectEditing.prototype._handleKey = function(e) {\n\n  // stop bubble\n  e.stopPropagation();\n\n  var key = e.keyCode || e.charCode;\n\n  // ESC\n  if (key === 27) {\n    e.preventDefault();\n    return this.cancel();\n  }\n\n  // Enter\n  if (key === 13 && !e.shiftKey) {\n    e.preventDefault();\n    return this.complete();\n  }\n};\n\n\nDirectEditing.prototype._handleResize = function(event) {\n  this._fire('resize', event);\n};\n\n\n/**\n * Activate direct editing on the given element\n *\n * @param {Object} ElementDescriptor the descriptor for a shape or connection\n * @return {Boolean} true if the activation was possible\n */\nDirectEditing.prototype.activate = function(element) {\n  if (this.isActive()) {\n    this.cancel();\n  }\n\n  // the direct editing context\n  var context;\n\n  var provider = (0,index_esm/* find */.sE)(this._providers, function(p) {\n    return ((context = p.activate(element))) ? p : null;\n  });\n\n  // check if activation took place\n  if (context) {\n    this.$textbox = this._textbox.create(\n      context.bounds,\n      context.style,\n      context.text,\n      context.options\n    );\n\n    this._active = {\n      element: element,\n      context: context,\n      provider: provider\n    };\n\n    if (context.options && context.options.resizable) {\n      this.resizable = true;\n    }\n\n    this._fire('activate');\n  }\n\n  return !!context;\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js-direct-editing/index.js\n\n\n\n\n/* harmony default export */ const diagram_js_direct_editing = ({\n  __depends__: [\n    interaction_events/* default */.Z\n  ],\n  __init__: [ 'directEditing' ],\n  directEditing: [ 'type', DirectEditing ]\n});\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/diagram-js-direct-editing/index.js_+_2_modules?")},"./node_modules/diagram-js-origin/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"default\": () => (/* binding */ diagram_js_origin)\n});\n\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/lib/configure-origin.js\n\n\nvar CROSS_COLOR = '#CCC',\n    BORDER_COLOR = 'rgba(0,0,0,0.1)';\n\n\n/**\n * A diagram-js extension that shows a (0, 0) origin indicator\n * on the canvas as well as (optionally) the canvas borders.\n *\n * @param {Object} [config]\n * @param {Canvas} canvas\n */\nfunction ConfigureOrigin(config, canvas) {\n\n  config = config || {};\n\n  var borderColor = config.borderColor || BORDER_COLOR,\n      crossColor = config.crossColor || CROSS_COLOR ;\n\n  var w = 30, h = 2,\n      w_half = w / 2,\n      s = -h / 2,\n      lineStart = w_half + 7;\n\n  var parent = canvas.getLayer('djs-origin', -1);\n\n  var g,\n      line,\n      cross,\n      label;\n\n  g = createEl('g', {\n    'pointer-events': 'none'\n  });\n\n  (0,index_esm/* append */.R3)(parent, g);\n\n  if (config.showBorder !== false) {\n\n    // the dashed lines, marking positive document coordinates\n    line = createEl('path', {\n      'class': cls('border'),\n      'd': path([\n        'M', -lineStart, s,\n        'H', -1000,\n        'M', lineStart, s,\n        'H', 6000,\n        'M', s, -lineStart,\n        'V', -1000,\n        'M', s, lineStart,\n        'V', 3000\n      ]),\n      'fill': 'none',\n      'stroke': borderColor,\n      'stroke-width': h + 'px',\n      'stroke-dasharray': '6, 6',\n      'shape-rendering': 'crispedges'\n    });\n\n    (0,index_esm/* append */.R3)(g, line);\n  }\n\n  // the cross that marks the diagram origin\n  cross = createEl('path', {\n    d: path([\n      'M', -w_half, s,\n      'H', w_half,\n      'M', s, -w_half,\n      'V', w_half\n    ]),\n    'class': cls('cross'),\n    'fill': 'none',\n    'stroke': crossColor,\n    'stroke-width': h + 'px',\n    'stroke-linecap': 'round'\n  });\n\n  (0,index_esm/* append */.R3)(g, cross);\n\n  label = createEl('text', {\n    x: -40,\n    y: -10,\n    fill: crossColor,\n    'class': cls('label'),\n  });\n\n  label.textContent = '(0, 0)';\n\n  (0,index_esm/* append */.R3)(g, label);\n}\n\nConfigureOrigin.$inject = [\n  'config.origin',\n  'canvas'\n];\n\n\n// helpers ///////////////////////////////////\n\nfunction path(parts) {\n  return parts.join(' ');\n}\n\nfunction cls(name) {\n  return 'djs-origin-' + name;\n}\n\nfunction createEl(type, attrs) {\n\n  var el = (0,index_esm/* create */.Ue)(type);\n\n  (0,index_esm/* attr */.Lj)(el, attrs);\n\n  return el;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/index.js\n\n\n/* harmony default export */ const diagram_js_origin = ({\n  __init__: [\n    ConfigureOrigin\n  ]\n});\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/diagram-js-origin/index.js_+_1_modules?")}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(t.exports,t,t.exports,__webpack_require__),t.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,t,i)=>{if(!n){var o=1/0;for(d=0;d<deferred.length;d++){for(var[n,t,i]=deferred[d],r=!0,a=0;a<n.length;a++)(!1&i||o>=i)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[a])))?n.splice(a--,1):(r=!1,i<o&&(o=i));if(r){deferred.splice(d--,1);var s=t();void 0!==s&&(e=s)}}return e}i=i||0;for(var d=deferred.length;d>0&&deferred[d-1][2]>i;d--)deferred[d]=deferred[d-1];deferred[d]=[n,t,i]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.j="bpmnFreeEditor",(()=>{var e={bpmnFreeEditor:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,t)=>{var i,o,[r,a,s]=t,d=0;if(r.some((n=>0!==e[n]))){for(i in a)__webpack_require__.o(a,i)&&(__webpack_require__.m[i]=a[i]);if(s)var l=s(__webpack_require__)}for(n&&n(t);d<r.length;d++)o=r[d],__webpack_require__.o(e,o)&&e[o]&&e[o][0](),e[o]=0;return __webpack_require__.O(l)},t=self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[];t.forEach(n.bind(null,0)),t.push=n.bind(null,t.push.bind(t))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnFreeCommon","bpmnFreeDiagramJs","bpmnFreeBpmnJs","bpmnFreeVendors"],(()=>__webpack_require__("./editor/editorApp.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCPFREE=window.VBCPFREE||{}).bpmnFreeEditor=__webpack_exports__})();