(self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[]).push([["bpmnFreeCommon"],{"./common/resources/newDiagram.bpmn":module=>{eval('module.exports = "<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?>\\n<bpmn2:definitions xmlns:xsi=\\"http://www.w3.org/2001/XMLSchema-instance\\" xmlns:bpmn2=\\"http://www.omg.org/spec/BPMN/20100524/MODEL\\" xmlns:bpmndi=\\"http://www.omg.org/spec/BPMN/20100524/DI\\" xmlns:dc=\\"http://www.omg.org/spec/DD/20100524/DC\\" xmlns:di=\\"http://www.omg.org/spec/DD/20100524/DI\\" xsi:schemaLocation=\\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd\\" id=\\"sample-diagram\\" targetNamespace=\\"http://bpmn.io/schema/bpmn\\">\\n  <bpmn2:process id=\\"Process_1\\" isExecutable=\\"false\\">\\n    <bpmn2:startEvent id=\\"StartEvent_1\\"/>\\n  </bpmn2:process>\\n  <bpmndi:BPMNDiagram id=\\"BPMNDiagram_1\\">\\n    <bpmndi:BPMNPlane id=\\"BPMNPlane_1\\" bpmnElement=\\"Process_1\\">\\n      <bpmndi:BPMNShape id=\\"_BPMNShape_StartEvent_2\\" bpmnElement=\\"StartEvent_1\\">\\n        <dc:Bounds height=\\"36.0\\" width=\\"36.0\\" x=\\"173.0\\" y=\\"102.0\\"/>\\n      </bpmndi:BPMNShape>\\n    </bpmndi:BPMNPlane>\\n  </bpmndi:BPMNDiagram>\\n</bpmn2:definitions>";\n\n//# sourceURL=webpack://VBCPFREE/./common/resources/newDiagram.bpmn?')},"./common/attachment-manager.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getAttachmentVersion = exports.loadAttachment = exports.uploadAttachment = void 0;\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "AttachmentManager");\nfunction makeRequest(opts) {\n    return new Promise((resolve, reject) => {\n        const xhr = new XMLHttpRequest();\n        xhr.open(opts.method, opts.url, true);\n        const maxWaitTime = 10000;\n        const noResponseTimer = setTimeout(() => {\n            xhr.abort();\n            reject({\n                status: 503,\n                message: "Service unreachable",\n            });\n        }, maxWaitTime);\n        xhr.onload = () => {\n            clearTimeout(noResponseTimer);\n            if (xhr.status >= 200 && xhr.status < 300) {\n                resolve(xhr.response);\n            }\n            else {\n                reject(xhr);\n            }\n        };\n        xhr.onerror = () => {\n            clearTimeout(noResponseTimer);\n            reject(xhr);\n        };\n        if (opts.headers) {\n            Object.keys(opts.headers).forEach((key) => {\n                xhr.setRequestHeader(key, opts.headers[key]);\n            });\n        }\n        xhr.send(opts.formData);\n    });\n}\nfunction buildRestUrl(restCall, pageId) {\n    const baseUrl = window.location.protocol + "//" + window.location.host;\n    const contextPath = (0, utils_1.getParams)().contextPath;\n    const restPath = "/rest/api/content/";\n    return baseUrl + contextPath + restPath + pageId + restCall;\n}\nfunction getAttachmentListRequest(pageId) {\n    return makeRequest({\n        url: buildRestUrl("/child/attachment?start=0", pageId),\n        method: "GET",\n    });\n}\nfunction updateAttachmentRequest(attachmentId, file, fileName, pageId) {\n    const url = buildRestUrl("/child/attachment/" + attachmentId + "/data", pageId);\n    const formData = new FormData();\n    formData.append("file", file, fileName);\n    const headers = { "X-Atlassian-Token": "no-check" };\n    return makeRequest({\n        url,\n        method: "POST",\n        headers,\n        formData,\n    });\n}\nfunction uploadAttachmentRequest(file, fileName, pageId) {\n    const url = buildRestUrl("/child/attachment", pageId);\n    const formData = new FormData();\n    formData.append("file", file, fileName);\n    const headers = { "X-Atlassian-Token": "no-check" };\n    return makeRequest({\n        url,\n        method: "POST",\n        headers,\n        formData,\n    });\n}\nfunction getFileRequest(url) {\n    return makeRequest({\n        method: "GET",\n        url,\n    });\n}\nfunction getAttachmentData(attachmentList, name) {\n    return JSON.parse(attachmentList).results.filter((attachment) => {\n        return attachment.title === name;\n    });\n}\nfunction buildDownloadUrl(downloadPath) {\n    const baseUrl = window.location.protocol + "//" + window.location.host;\n    const contextPath = (0, utils_1.getParams)().contextPath;\n    return baseUrl + contextPath + downloadPath;\n}\nfunction getIdByName(attachmentList, name) {\n    const result = JSON.parse(attachmentList).results.filter((attachment) => {\n        return attachment.title === name;\n    });\n    return result.length > 0 ? result[0].id : undefined;\n}\nfunction getAttachmentHistoryRequest(attachmentId) {\n    return makeRequest({\n        url: buildRestUrl(attachmentId + "/history", ""),\n        method: "GET",\n    });\n}\nfunction uploadAttachment(file, fileName, pageId) {\n    return getAttachmentListRequest(pageId)\n        .then((attachmentList) => {\n        const attachmentId = getIdByName(attachmentList, fileName);\n        if (attachmentId) {\n            return updateAttachmentRequest(attachmentId, file, fileName, pageId);\n        }\n        else {\n            return uploadAttachmentRequest(file, fileName, pageId);\n        }\n    })\n        .catch((err) => {\n        return Promise.reject(err);\n    });\n}\nexports.uploadAttachment = uploadAttachment;\nfunction loadAttachment(name, pageId) {\n    return getAttachmentListRequest(pageId)\n        .then((attachmentList) => {\n        const attachmentData = getAttachmentData(attachmentList, name);\n        if (!attachmentData[0]) {\n            return Promise.reject({\n                status: 404,\n                responseText: "Attachment not Found",\n            });\n        }\n        else if (attachmentData.length !== 1) {\n            vxcpLogger.logWarning("loadAttachment", "Multiple corresponding attachments found, loading latest.");\n        }\n        const downloadLink = buildDownloadUrl(attachmentData[0]._links.download);\n        const attachmentId = attachmentData[0].id;\n        return getAttachmentHistoryRequest(attachmentId)\n            .then((history) => {\n            return JSON.parse(history).lastUpdated.number;\n        })\n            .then((version) => {\n            return getFileRequest(downloadLink).then((fileData) => {\n                return {\n                    data: fileData,\n                    id: attachmentId,\n                    version,\n                };\n            });\n        });\n    })\n        .catch((err) => {\n        return Promise.reject(err);\n    });\n}\nexports.loadAttachment = loadAttachment;\nfunction getAttachmentVersion(name, pageId) {\n    return getAttachmentListRequest(pageId).then((list) => {\n        const attachmentId = getIdByName(list, name);\n        if (attachmentId) {\n            return getAttachmentHistoryRequest(attachmentId).then((history) => {\n                return {\n                    id: attachmentId,\n                    version: JSON.parse(history).lastUpdated.number,\n                };\n            });\n        }\n        else {\n            return Promise.reject({\n                status: 404,\n                responseText: "Attachment not Found",\n            });\n        }\n    });\n}\nexports.getAttachmentVersion = getAttachmentVersion;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/attachment-manager.ts?')},"./common/diagram-manager.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.saveDiagram = exports.loadDiagram = exports.getDiagramSVG = exports.getDiagramXML = exports.showDiagram = exports.createNewDiagram = exports.openDiagram = void 0;\nconst AttachmentManager = __importStar(__webpack_require__("./common/attachment-manager.ts"));\nconst ConfUtils = __importStar(__webpack_require__("./common/utils.ts"));\nconst Notification = __importStar(__webpack_require__("./common/notification.ts"));\nconst newDiagramXml = __importStar(__webpack_require__("./common/newDiagramXml.ts"));\nconst DiagramState = __importStar(__webpack_require__("./common/diagram-state.ts"));\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "DiagramManager");\nfunction handleError(error, pageId) {\n    switch (error.status) {\n        case 403:\n            const confluenceLink = {\n                link: Confluence.getContextPath() + "/pages/viewpage.action?pageId=" + pageId,\n            };\n            ConfUtils.showDialog(AJS, "#vbcp-session-warning-dialog", Confluence.Templates.viadee.bpmnplugin.sessionWarningDialog, undefined, undefined, confluenceLink);\n            break;\n        case 0:\n            if (DiagramState.isDiagramSaved() === false) {\n                ConfUtils.showDialog(AJS, "#vbcp-connection-warning-dialog", Confluence.Templates.viadee.bpmnplugin.connectionWarningDialog);\n            }\n            break;\n        case 503:\n            ConfUtils.showDialog(AJS, "#vbcp-connection-warning-dialog", Confluence.Templates.viadee.bpmnplugin.connectionWarningDialog);\n            break;\n        default:\n            vxcpLogger.logError("handleError", "An error occurred while executing error handling function. This log is a default message if no one other warning dialogs are shown to user.", error);\n    }\n}\nfunction setVersion(version) {\n    DiagramState.setDiagramVersion(version);\n    DiagramState.saveDiagram(true);\n    const $diagramVersionLabel = AJS.$("#vbcp-diagram-version");\n    $diagramVersionLabel.html("(v." + DiagramState.getDiagramVersion() + ")");\n}\nfunction hideDiagramChange() {\n    const $saveLink = AJS.$("#content > div.toolbar > ul > li:nth-child(1) > a");\n    const $resetLink = AJS.$("#content > div.toolbar > ul > li:nth-child(2) > a");\n    const $diagramNameLabel = AJS.$("#vbcp-diagram-name");\n    $saveLink.removeClass("active");\n    $resetLink.removeClass("active");\n    $diagramNameLabel.text($diagramNameLabel.text().replace(/\\*/g, ""));\n    $diagramNameLabel.css("font-style", "");\n    DiagramState.saveDiagram(true);\n    deactivateButton($saveLink);\n    deactivateButton($resetLink);\n}\nfunction deactivateButton($link) {\n    $link.css({ cursor: "default" });\n    $link.off();\n    $link.click((e) => {\n        e.preventDefault();\n        e.stopPropagation();\n    });\n}\nfunction updateVersion(diagramName, pageId) {\n    AttachmentManager.getAttachmentVersion(diagramName + ".bpmn", pageId).then((attachment) => {\n        setVersion(attachment.version);\n    });\n}\nfunction uploadDiagramToConfluence(modeler, diagramName, pageId) {\n    return __awaiter(this, void 0, void 0, function* () {\n        const xml = yield getDiagramXML(modeler);\n        const attachment = new Blob([xml]);\n        AttachmentManager.uploadAttachment(attachment, `${diagramName}.bpmn`, pageId)\n            .then(() => {\n            updateVersion(diagramName, pageId);\n            hideDiagramChange();\n            Notification.setSuccessMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.editor.notification.saveDiagram.success.title"), AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.editor.notification.saveDiagram.success.body"), true, "#vbcp-modeler-messages");\n        })\n            .catch((err) => {\n            vxcpLogger.logError("uploadDiagramToConfluence", "An error occurred while uploading BPMN file to Confluence. The diagram could not be uploaded.", { err });\n        });\n    });\n}\nfunction openDiagram(modeler, xml, diagramName, callbackFn) {\n    return __awaiter(this, void 0, void 0, function* () {\n        const $loadingText = AJS.$("#diagram-loading");\n        try {\n            const importedXML = yield modeler.importXML(xml);\n            $loadingText.hide();\n            const warnings = importedXML.warnings;\n            if (warnings.length) {\n                vxcpLogger.logWarning("openDiagram", "An error occurred while opening BPMN diagram. The BPMN file, which you try to open, is probably broken or has an invalid format.", warnings);\n                const warningTitle = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.load-diagram-warnings-message.title");\n                const warningBody = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.load-diagram-warnings-message.body");\n                Notification.setWarningMessage(warningTitle, warningBody, true, "#vbcp-modeler-messages", true);\n            }\n            ConfUtils.moveDiagramToTopLeft(modeler, 180, 100);\n            if (typeof callbackFn === "function") {\n                callbackFn();\n            }\n        }\n        catch (err) {\n            $loadingText.hide();\n            vxcpLogger.logError("openDiagram", "An error occurred while opening BPMN diagram. The BPMN file, which you try to open, is probably broken or has an invalid format.", err);\n            ConfUtils.showDialog(AJS, "#vbcp-diagram-warning-dialog", Confluence.Templates.viadee.bpmnplugin.diagramWarningDialog);\n        }\n        return;\n    });\n}\nexports.openDiagram = openDiagram;\nfunction createNewDiagram(modeler) {\n    return __awaiter(this, void 0, void 0, function* () {\n        yield openDiagram(modeler, newDiagramXml.getNewDiagramXml());\n    });\n}\nexports.createNewDiagram = createNewDiagram;\nfunction showDiagram(modeler, attachment, diagramName, callbackFn) {\n    return __awaiter(this, void 0, void 0, function* () {\n        setVersion(attachment.version);\n        yield openDiagram(modeler, attachment.data, diagramName, callbackFn);\n    });\n}\nexports.showDiagram = showDiagram;\nfunction getDiagramXML(modeler) {\n    return __awaiter(this, void 0, void 0, function* () {\n        try {\n            const savedXmlData = yield modeler.saveXML({ format: true });\n            return savedXmlData.xml;\n        }\n        catch (xmlErr) {\n            vxcpLogger.logError("getDiagramXML", "An error occurred while saving the daigram as BPMN.", xmlErr);\n        }\n    });\n}\nexports.getDiagramXML = getDiagramXML;\nfunction getDiagramSVG(modeler) {\n    return __awaiter(this, void 0, void 0, function* () {\n        try {\n            const savedSvgData = yield modeler.saveSVG();\n            return savedSvgData.svg;\n        }\n        catch (svgErr) {\n            vxcpLogger.logError("getDiagramSVG", "An error occurred while saving the diagram as SVG.", svgErr);\n        }\n    });\n}\nexports.getDiagramSVG = getDiagramSVG;\nfunction loadDiagram(modeler, diagramName, pageId, reset) {\n    return __awaiter(this, void 0, void 0, function* () {\n        const $loadingText = AJS.$("#diagram-loading");\n        try {\n            const attachment = yield AttachmentManager.loadAttachment(diagramName + ".bpmn", pageId);\n            if (reset) {\n                if (attachment.version !== DiagramState.getDiagramVersion()) {\n                    $loadingText.hide();\n                    Notification.show(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.editor.notification.diagramUpdated"));\n                }\n                else {\n                    ConfUtils.showDialog(AJS, "#vbcp-reload-warning-dialog", Confluence.Templates.viadee.bpmnplugin.reloadWarningDialog, () => __awaiter(this, void 0, void 0, function* () {\n                        yield showDiagram(modeler, attachment, diagramName, hideDiagramChange);\n                    }), () => {\n                        $loadingText.hide();\n                    });\n                }\n            }\n            else {\n                yield showDiagram(modeler, attachment, diagramName, hideDiagramChange);\n            }\n        }\n        catch (err) {\n            if (err.status === 404) {\n                if (reset) {\n                    ConfUtils.showDialog(AJS, "#vbcp-reload-warning-dialog", Confluence.Templates.viadee.bpmnplugin.reloadWarningDialog, () => __awaiter(this, void 0, void 0, function* () {\n                        yield createNewDiagram(modeler);\n                        hideDiagramChange();\n                    }), () => {\n                        $loadingText.hide();\n                    });\n                }\n                else {\n                    yield createNewDiagram(modeler);\n                }\n            }\n            else {\n                handleError(err, pageId);\n            }\n        }\n    });\n}\nexports.loadDiagram = loadDiagram;\nfunction saveDiagram(modeler, diagramName, pageId) {\n    AttachmentManager.getAttachmentVersion(diagramName + ".bpmn", pageId)\n        .then((attachment) => __awaiter(this, void 0, void 0, function* () {\n        if (attachment.version !== DiagramState.getDiagramVersion()) {\n            ConfUtils.showDialog(AJS, "#vbcp-save-warning-dialog", Confluence.Templates.viadee.bpmnplugin.saveWarningDialog, () => __awaiter(this, void 0, void 0, function* () {\n                yield uploadDiagramToConfluence(modeler, diagramName, pageId);\n            }));\n        }\n        else {\n            yield uploadDiagramToConfluence(modeler, diagramName, pageId);\n        }\n    }))\n        .catch((err) => __awaiter(this, void 0, void 0, function* () {\n        if (err.status === 404) {\n            yield uploadDiagramToConfluence(modeler, diagramName, pageId);\n        }\n        else {\n            handleError(err, pageId);\n        }\n    }));\n}\nexports.saveDiagram = saveDiagram;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/diagram-manager.ts?')},"./common/diagram-state.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getDiagramVersion = exports.setDiagramVersion = exports.isDiagramSaved = exports.saveDiagram = void 0;\nlet diagramSaved = true;\nlet diagramVersion = "";\nfunction saveDiagram(predicate) {\n    diagramSaved = predicate;\n}\nexports.saveDiagram = saveDiagram;\nfunction isDiagramSaved() {\n    return diagramSaved;\n}\nexports.isDiagramSaved = isDiagramSaved;\nfunction setDiagramVersion(version) {\n    diagramVersion = version;\n}\nexports.setDiagramVersion = setDiagramVersion;\nfunction getDiagramVersion() {\n    return diagramVersion;\n}\nexports.getDiagramVersion = getDiagramVersion;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/diagram-state.ts?')},"./common/dynamic-content-service.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.DynamicContentService = void 0;\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "DynamicContentService");\nclass DynamicContentService {\n    constructor(lastNewsSeenDate) {\n        this.bucketUrl = "https://storage.googleapis.com/viadee-atlassian-plugins-prod-storage-bucket/bpmn-modeler-news-content.json";\n        this.toolbarNewsMarkerIdSelector = "#vbcp-toolbar-news-marker";\n        this.newsMessageContainerIdSelector = "#vbcp-message-news";\n        this.newsMessageBodyIdSelector = "#vbcp-messages-news-body";\n        this.newsMessageCloseBtnIdSelector = "#vbcp-modeler-message-news-close-btn";\n        this.newsMessageBackBtnIdSelector = "#vbcp-modeler-message-news-back-btn";\n        this.newsEntryDetailsClassSelector = ".vbcp-message-news-entry-details";\n        this.newsEntryDetailsWrapperClassSelector = "#vbcp-message-news-details-wrapper";\n        this.detailsBtnClassSelector = ".vbcp-message-news-entry-show-details-btn";\n        this.cssClassUnread = "vbcp-message-unread";\n        this.cssClassHidden = "vbcp-hidden";\n        this.cssClassSwipeIn = "vbcp-message-news-swipe-in";\n        this.cssClassSwipeOut = "vbcp-message-news-swipe-out";\n        this.loadingIdSelector = "#vbcp-news-loading";\n        this.useQABucket = false;\n        this.hasNews = false;\n        this.lastNewsSeenDateTime = lastNewsSeenDate;\n        this.bucketUrl = "https://storage.googleapis.com/viadee-atlassian-plugins-prod-storage-bucket/bpmn-modeler-news-content.json";\n        if (this.useQABucket) {\n            vxcpLogger.logInfo("constructor", "Using QA Bucket URL");\n            this.bucketUrl = "https://storage.googleapis.com/viadee-atlassian-plugins-qa-storage-bucket/bpmn-modeler-news-content.json";\n        }\n        else {\n            vxcpLogger.logInfo("constructor", "Using PROD Bucket URL");\n        }\n    }\n    updateLastNewsSeenDate(updatedLastSeenDate) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const restPath = "/rest/bpmn-modeler/1.0/settings/lastNewsSeenDate";\n            const url = AJS.contextPath() + restPath;\n            const headers = { "X-Atlassian-Token": "no-check" };\n            try {\n                yield $.ajax({\n                    url,\n                    type: "PUT",\n                    cache: false,\n                    data: JSON.stringify(updatedLastSeenDate),\n                    headers,\n                    processData: false,\n                    contentType: false,\n                });\n            }\n            catch (e) {\n                vxcpLogger.logError("updateLastNewsSeenDate", "Could not update value", { e });\n            }\n        });\n    }\n    getContent() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return new Promise((resolve, reject) => {\n                try {\n                    vxcpLogger.logInfo("getContent", "Retrieving content of Bucket...");\n                    resolve(this.buildS3RestCall());\n                }\n                catch (e) {\n                    vxcpLogger.logInfo("getContent", "No content found.");\n                    reject(false);\n                }\n            });\n        });\n    }\n    showNewsMessageBox(lastNewsSeenDate) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const isHidden = $(this.newsMessageContainerIdSelector).hasClass(this.cssClassHidden);\n            if (!isHidden) {\n                this.closeMessageBox();\n                return lastNewsSeenDate;\n            }\n            $(this.newsMessageContainerIdSelector).removeClass(this.cssClassHidden);\n            $(this.toolbarNewsMarkerIdSelector).addClass(this.cssClassHidden);\n            $(this.newsEntryDetailsWrapperClassSelector).addClass(this.cssClassHidden);\n            this.initCloseBtn();\n            this.initDetailsBtn();\n            this.initBackButton();\n            return this.lastNewsSeenDateTime;\n        });\n    }\n    initNewsMarker() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.hasNews) {\n                return;\n            }\n            $(this.toolbarNewsMarkerIdSelector).removeClass(this.cssClassHidden);\n        });\n    }\n    initNews(lastNewsSeenDate) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.lastNewsSeenDateTime = lastNewsSeenDate;\n            yield this.loadMessageBoxHtml();\n            const resultDataPromise = this.getContent();\n            resultDataPromise\n                .then((resultData) => __awaiter(this, void 0, void 0, function* () {\n                const data = yield this.parseNewsData(resultData);\n                this.newsMessagesToShow = data;\n                $(this.loadingIdSelector).hide();\n                this.setMessages();\n                yield this.initNewsMarker();\n            }))\n                .catch((e) => __awaiter(this, void 0, void 0, function* () {\n                vxcpLogger.logInfo("getContent", "No or malformed content found.", { e });\n                this.newsMessagesToShow = yield this.getNoNewsObject();\n                $(this.loadingIdSelector).hide();\n                this.setMessages();\n                yield this.initNewsMarker();\n            }));\n        });\n    }\n    loadMessageBoxHtml() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const alreadyShown = $(this.newsMessageContainerIdSelector).length > 0;\n            if (alreadyShown) {\n                $(this.newsMessageContainerIdSelector).remove();\n                return;\n            }\n            const template = Confluence.Templates.viadee.bpmnplugin.newsMessageBox;\n            const newsMessageBox = template();\n            $("body").append(newsMessageBox);\n            $(this.newsMessageContainerIdSelector).addClass(this.cssClassHidden);\n        });\n    }\n    setMessages() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const params = { newsList: this.newsMessagesToShow };\n            const template = Confluence.Templates.viadee.bpmnplugin.newsMessageEntries;\n            const newsMessageEntries = template(params);\n            $(this.newsMessageBodyIdSelector).append(newsMessageEntries);\n            this.newsMessagesToShow.forEach((entry, idx) => {\n                $(this.newsMessageBodyIdSelector).find(`#vbcp-ent-message-news-entry-details-desc-${idx}`).html(entry.body);\n            });\n        });\n    }\n    initDetailsBtn() {\n        $(this.detailsBtnClassSelector).on("click", (e) => {\n            const btnHref = $(e.target).attr("href");\n            if (!btnHref) {\n                return;\n            }\n            const entry = $(e.target).parent();\n            entry.removeClass(this.cssClassUnread);\n            this.swipeInOut(this.newsEntryDetailsWrapperClassSelector, true);\n            $(btnHref).removeClass(this.cssClassHidden);\n            $(this.newsMessageBackBtnIdSelector).removeClass(this.cssClassHidden);\n            $(this.newsMessageCloseBtnIdSelector).addClass(this.cssClassHidden);\n        });\n    }\n    dateMinusDaysToString(plainDate, days = 0) {\n        plainDate.setDate(plainDate.getDate() - days);\n        const year = plainDate.getFullYear().toString();\n        const month = (plainDate.getMonth() + 1).toString();\n        const day = plainDate.getDate().toString();\n        const formattedDate = `${year}-${month}-${day}`;\n        const hour = plainDate.getHours().toString();\n        return { date: formattedDate, hour };\n    }\n    initBackButton() {\n        $(this.newsMessageBackBtnIdSelector).on("click", (e) => {\n            this.swipeInOut(this.newsEntryDetailsWrapperClassSelector, false);\n            $(this.newsMessageCloseBtnIdSelector).removeClass(this.cssClassHidden);\n            $(this.newsMessageBackBtnIdSelector).addClass(this.cssClassHidden);\n            $(this.newsEntryDetailsClassSelector).addClass(this.cssClassHidden);\n        });\n    }\n    swipeInOut(selector, swipeIn) {\n        const element = $(selector);\n        if (swipeIn) {\n            element.removeClass(this.cssClassSwipeOut);\n            element.removeClass(this.cssClassHidden);\n            element.addClass(this.cssClassSwipeIn);\n        }\n        else {\n            element.removeClass(this.cssClassSwipeIn);\n            element.addClass(this.cssClassSwipeOut);\n        }\n    }\n    initCloseBtn() {\n        $(this.newsMessageCloseBtnIdSelector).on("click", (e) => {\n            this.closeMessageBox();\n        });\n    }\n    closeMessageBox() {\n        $(this.newsEntryDetailsWrapperClassSelector).removeClass(this.cssClassSwipeOut);\n        $(this.newsEntryDetailsWrapperClassSelector).removeClass(this.cssClassSwipeIn);\n        $(this.newsMessageContainerIdSelector).addClass(this.cssClassHidden);\n    }\n    getNoNewsObject() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const noNews = {\n                creationDate: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.message.new-messages.no-news.today"),\n                publishTime: "0",\n                title: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.message.new-messages.no-news.title"),\n                desc: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.message.new-messages.no-news.desc"),\n                body: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.message.new-messages.no-news.body"),\n                cssClass: "",\n            };\n            return [noNews];\n        });\n    }\n    parseNewsData(data) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.hasNews = false;\n            if (!data.result) {\n                return yield this.getNoNewsObject();\n            }\n            const appType = this.getAppType();\n            const locale = yield this.getLocale();\n            let msgCount = 0;\n            let latestPublishDate = this.lastNewsSeenDateTime;\n            const resultData = data.result;\n            const filteredArray = [];\n            resultData.forEach((entry) => {\n                if (entry.app.includes(appType)) {\n                    try {\n                        if (!entry.publishTime) {\n                            entry.publishTime = "12";\n                        }\n                        const filteredData = {\n                            publishTime: entry.publishTime,\n                            creationDate: entry.creationDate,\n                            title: entry.en.title,\n                            desc: entry.en.desc,\n                            body: entry.en.body,\n                            cssClass: "",\n                        };\n                        latestPublishDate = this.getLaterDate(latestPublishDate, {\n                            hour: entry.publishTime,\n                            date: entry.creationDate,\n                        });\n                        const isCreationDateAfterLastSeen = this.isCreationAfterLastSeen(entry.creationDate, entry.publishTime);\n                        if (isCreationDateAfterLastSeen) {\n                            this.hasNews = true;\n                            filteredData.cssClass = this.cssClassUnread;\n                        }\n                        if (locale === "de_DE") {\n                            filteredData.title = entry.de.title;\n                            filteredData.desc = entry.de.desc;\n                            filteredData.body = entry.de.body;\n                        }\n                        filteredArray.push(filteredData);\n                        msgCount = msgCount + 1;\n                    }\n                    catch (e) {\n                        vxcpLogger.logInfo("parseNewsData", "News Entry is malformed.", { entry });\n                    }\n                }\n            });\n            this.lastNewsSeenDateTime = latestPublishDate;\n            if (msgCount < 1) {\n                return yield this.getNoNewsObject();\n            }\n            return filteredArray;\n        });\n    }\n    getLocale() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return (0, utils_1.getParams)().userLocale;\n        });\n    }\n    getAppType() {\n        return "server-free";\n    }\n    getLaterDate(dateA, dateB) {\n        if (this.isDateTheSame(dateA.date, dateB.date)) {\n            if (this.isTimeAAfterTimeB(dateA.hour, dateB.hour)) {\n                return dateA;\n            }\n            return dateB;\n        }\n        if (this.isDateAAfterDateB(dateA.date, dateB.date)) {\n            return dateA;\n        }\n        return dateB;\n    }\n    isCreationAfterLastSeen(createDate, publishTime) {\n        if (!this.lastNewsSeenDateTime.date || !this.lastNewsSeenDateTime.hour) {\n            const lastNewsSeenDateString = this.dateMinusDaysToString(new Date(), 10);\n            this.lastNewsSeenDateTime = lastNewsSeenDateString;\n        }\n        const isCreationDateAfterLastSeen = this.isDateAAfterDateB(createDate, this.lastNewsSeenDateTime.date);\n        const isDateTheSame = this.isDateTheSame(createDate, this.lastNewsSeenDateTime.date);\n        const isPublishTimeAfterLastSeen = this.isTimeAAfterTimeB(publishTime, this.lastNewsSeenDateTime.hour);\n        const isNewEntry = isCreationDateAfterLastSeen ? true : isDateTheSame && isPublishTimeAfterLastSeen;\n        return isNewEntry;\n    }\n    isDateAAfterDateB(dateA, dateB) {\n        const dateAArray = dateA.split("-");\n        const dateBArray = dateB.split("-");\n        if (parseInt(dateAArray[0]) > parseInt(dateBArray[0])) {\n            return true;\n        }\n        if (parseInt(dateAArray[0]) < parseInt(dateBArray[0])) {\n            return false;\n        }\n        if (parseInt(dateAArray[1]) > parseInt(dateBArray[1])) {\n            return true;\n        }\n        if (parseInt(dateAArray[1]) < parseInt(dateBArray[1])) {\n            return false;\n        }\n        return parseInt(dateAArray[2]) > parseInt(dateBArray[2]);\n    }\n    isDateTheSame(dateA, dateB) {\n        const dateAArray = dateA.split("-");\n        const dateBArray = dateB.split("-");\n        if (parseInt(dateAArray[0]) === parseInt(dateBArray[0]) && parseInt(dateAArray[1]) === parseInt(dateBArray[1]) && parseInt(dateAArray[2]) === parseInt(dateBArray[2])) {\n            return true;\n        }\n        return false;\n    }\n    isTimeAAfterTimeB(timeA, timeB) {\n        return parseInt(timeA) > parseInt(timeB);\n    }\n    makeRequest(opts, contentType) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!opts) {\n                vxcpLogger.logError("makeRequest", "Not enough parameters");\n                return;\n            }\n            return yield new Promise((resolve, reject) => {\n                resolve($.ajax(opts));\n            });\n        });\n    }\n    buildS3RestCall() {\n        return this.makeRequest({\n            url: this.bucketUrl,\n            method: "GET",\n            timeout: 3000,\n        });\n    }\n}\nexports.DynamicContentService = DynamicContentService;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/dynamic-content-service.ts?')},"./common/enterprise-license-checker.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.checkEnterprisePluginLicense = exports.baseUrl = void 0;\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "EnterpriseLicenseChecker");\nexports.baseUrl = AJS.contextPath() + "/rest/bpmn-modeler-enterprise/1.0/license/";\nfunction checkEnterprisePluginLicense() {\n    return AJS.$.ajax({\n        cache: false,\n        url: exports.baseUrl + "licenseType",\n        type: "GET",\n        dataType: "json",\n        error: (err) => {\n            vxcpLogger.logInfo("checkEnterprisePluginLicense", "INFO @EnterpriseLicenseChecker.checkEnterprisePluginLicense: BPMN-Modeler Enterprise not installed.", err);\n            return Promise.resolve("INVALID");\n        },\n    });\n}\nexports.checkEnterprisePluginLicense = checkEnterprisePluginLicense;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/enterprise-license-checker.ts?')},"./common/newDiagramXml.ts":(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getNewDiagramXml = void 0;\nconst newDiagram = __webpack_require__("./common/resources/newDiagram.bpmn");\nconst getNewDiagramXml = () => newDiagram;\nexports.getNewDiagramXml = getNewDiagramXml;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/newDiagramXml.ts?')},"./common/notification.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.showEnterpriseWithLicenseHint = exports.setSuccessMessage = exports.showAdForEnterpriseEditor = exports.showInfoDialogForEnterpriseModeler = exports.setInfoMessage = exports.setErrorMessage = exports.setWarningMessage = exports.clearMessageBox = exports.show = void 0;\nconst utils = __importStar(__webpack_require__("./common/utils.ts"));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nfunction show(message) {\n    if (!("Notification" in window)) {\n        alert(message);\n    }\n    else if (Notification.permission === "granted") {\n        return new Notification(message);\n    }\n    else if (Notification.permission !== "denied") {\n        Notification.requestPermission((permission) => {\n            if (permission === "granted") {\n                return new Notification(message);\n            }\n        });\n    }\n}\nexports.show = show;\nfunction clearMessageBox() {\n    const $messageBox = $("#vbcp-modeler-messages");\n    $messageBox.empty();\n    const $auiMessageBox = $("#aui-message-bar");\n    $auiMessageBox.empty();\n}\nexports.clearMessageBox = clearMessageBox;\nfunction setWarningMessage(title, body, fadeout, identifier, closeable, delay = 5000) {\n    if (identifier) {\n        AJS.messages.warning(identifier, {\n            title,\n            body,\n            fadeout,\n            delay,\n        });\n    }\n    else {\n        clearMessageBox();\n        AJS.messages.warning({\n            title,\n            body,\n            fadeout,\n            delay,\n        });\n    }\n}\nexports.setWarningMessage = setWarningMessage;\nfunction setErrorMessage(title, body, fadeout, identifier, closeable, delay = 5000) {\n    if (identifier) {\n        AJS.messages.error(identifier, {\n            title,\n            body,\n            fadeout,\n            delay,\n        });\n    }\n    else {\n        clearMessageBox();\n        AJS.messages.error({\n            title,\n            body,\n            fadeout,\n            delay,\n        });\n    }\n}\nexports.setErrorMessage = setErrorMessage;\nfunction setInfoMessage(title, body, fadeout, identifier, closeable, delay = 5000) {\n    if (identifier) {\n        AJS.messages.info(identifier, {\n            title,\n            body,\n            fadeout,\n            delay,\n        });\n    }\n    else {\n        clearMessageBox();\n        AJS.messages.info({\n            title,\n            body,\n            fadeout,\n            delay,\n        });\n    }\n}\nexports.setInfoMessage = setInfoMessage;\nfunction showInfoDialogForEnterpriseModeler(votingService, enterpriseLicense, callbackAbort) {\n    return __awaiter(this, void 0, void 0, function* () {\n        $("#viadee-info-header").blur();\n        const dialogId = "#vbcp-info-dialog";\n        let language = "";\n        try {\n            language = (0, utils_1.getParams)().userLocale.toLowerCase().startsWith("de") ? "de" : "";\n        }\n        catch (err) {\n        }\n        utils.showDialog(AJS, dialogId, Confluence.Templates.viadee.bpmnplugin.infoDialog, () => {\n            const activeElement = document.activeElement;\n            if (activeElement) {\n                activeElement.blur();\n            }\n        }, callbackAbort, { de: language, enterpriseLicense: enterpriseLicense === "true" });\n        $(`${dialogId}-alt-continue`).on("click", () => {\n            window.open(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.info-link"), "_blank");\n        });\n        yield votingService.setVoteIconCss();\n        yield votingService.setVoteInfoDialogCss();\n        const youtube = document.getElementById("viadee-info-bpmnmodeler-video");\n        youtube.onclick = (event) => {\n            const iframe = document.createElement("iframe");\n            iframe.setAttribute("class", "viadee-info-bpmnmodeler-video");\n            iframe.setAttribute("src", "https://www.youtube-nocookie.com/embed/E7A3paeFUwM?vq=hd1080&showinfo=0&rel=0&amp&autoplay=1");\n            iframe.setAttribute("frameborder", "0");\n            iframe.setAttribute("allow", "accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture");\n            iframe.setAttribute("allowfullscreen", "");\n            const videoPlaceholder = event.target.parentNode;\n            videoPlaceholder.parentNode.replaceChild(iframe, videoPlaceholder);\n        };\n    });\n}\nexports.showInfoDialogForEnterpriseModeler = showInfoDialogForEnterpriseModeler;\nfunction showAdForEnterpriseEditor(votingService, enterpriseLicense) {\n    const identifier = "#vbcp-modeler-info-enterprise";\n    setErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.small-info-message.heading"), AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.small-info-message.body"), true, identifier, true, 180000);\n    const message = $(identifier);\n    const buttonHtml = `<ul class="aui-nav-actions-list">\n<li><button id="vbcp-modeler-info-enterprise-link" class="aui-button aui-button-link" >\n${AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.tell-me-more")}\n</button></li></ul>`;\n    if (message) {\n        const bodyElement = message.find(".aui-message");\n        const bodyHtml = bodyElement.html();\n        bodyElement.html(bodyHtml + buttonHtml);\n    }\n    const infoLink = document.getElementById("vbcp-modeler-info-enterprise-link");\n    infoLink.onclick = (e) => __awaiter(this, void 0, void 0, function* () {\n        e.preventDefault();\n        e.stopPropagation();\n        yield showInfoDialogForEnterpriseModeler(votingService, enterpriseLicense, () => __awaiter(this, void 0, void 0, function* () {\n            yield votingService.toggleVote();\n        }));\n    });\n}\nexports.showAdForEnterpriseEditor = showAdForEnterpriseEditor;\nfunction setSuccessMessage(title, body, fadeout, identifier, closeable) {\n    if (identifier) {\n        AJS.messages.success(identifier, {\n            title,\n            body,\n            fadeout,\n        });\n    }\n    else {\n        clearMessageBox();\n        AJS.messages.success({\n            title,\n            body,\n            fadeout,\n        });\n    }\n}\nexports.setSuccessMessage = setSuccessMessage;\nfunction showEnterpriseWithLicenseHint(diagramId) {\n    if ($("#vbcp-message-box").children().length < 1) {\n        setInfoMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.vbcp-macro.viewer.enterprise-active-title"), AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.vbcp-macro.viewer.enterprise-active-body"), false, "#vbcp-message-box-" + diagramId, true);\n    }\n}\nexports.showEnterpriseWithLicenseHint = showEnterpriseWithLicenseHint;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/notification.ts?')},"./common/plugin-name-service.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.pluginName = void 0;\nexports.pluginName = "BPMN-FREE-PLUGIN";\n\n\n//# sourceURL=webpack://VBCPFREE/./common/plugin-name-service.ts?')},"./common/rest-service.ts":(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.buildPluginBaseUrl = void 0;\nconst utils_1 = __webpack_require__("./common/utils.ts");\nconst buildPluginBaseUrl = () => {\n    const baseUrl = `${window.location.protocol}//${window.location.host}`;\n    const contextPath = (0, utils_1.getParams)().contextPath;\n    return baseUrl + contextPath;\n};\nexports.buildPluginBaseUrl = buildPluginBaseUrl;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/rest-service.ts?')},"./common/utils.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.getRemoteUserKey = exports.getCurrentUserFullName = exports.getConfluenceVersion = exports.getSpaceName = exports.getSpaceKey = exports.getBaseUrl = exports.isNewPage = exports.getContextPath = exports.getUserLocale = exports.getLatestPageId = exports.getContentType = exports.getPageId = exports.getAccessMode = exports.getContentId = exports.getParams = exports.initViadeeLogo = exports.moveDiagramToTopLeft = exports.initZoomButtons = exports.removeDjsHelperSvg = exports.showDialog = exports.getQueryParam = exports.createIFrame = void 0;\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "Utils");\nfunction createIFrame(pageId, diagramId, diagramName, enterpriseLicense, reloadPage = true) {\n    const iframe = document.createElement("iframe");\n    iframe.setAttribute("id", "bpmn-editor");\n    iframe.setAttribute("style", "position: fixed; width: 100%; height: 100%; top: 0px; left: 0px; border: 0px none; z-index: 3000;");\n    iframe.setAttribute("src", Confluence.getContextPath() +\n        "/plugins/bpmn-plugin/edit-diagram.action?pageId=" +\n        pageId +\n        "&diagramId=" +\n        diagramId +\n        "&diagramName=" +\n        diagramName +\n        "&reloadPage=" +\n        reloadPage +\n        "&enterpriseLicense=" +\n        enterpriseLicense);\n    iframe.onload = () => {\n        $("body").css("overflow", "hidden");\n    };\n    return iframe;\n}\nexports.createIFrame = createIFrame;\nfunction getQueryParam(param) {\n    const result = window.location.search.match(new RegExp("(\\\\?|&)" + param + "(\\\\[\\\\])?=([^&]*)"));\n    return result ? result[3] : 0;\n}\nexports.getQueryParam = getQueryParam;\nfunction showDialog(AJS, dialogId, template, callbackContinue, callbackAbort, params) {\n    removeDjsHelperSvg(AJS.$);\n    const dialog = template(params);\n    AJS.$("body").append(dialog);\n    AJS.dialog2(dialogId).show();\n    AJS.dialog2(dialogId).on("hide", () => {\n        AJS.$(dialogId).remove();\n    });\n    AJS.$(dialogId + "-abort").click(() => __awaiter(this, void 0, void 0, function* () {\n        AJS.dialog2(dialogId).hide();\n        if (typeof callbackAbort === "function") {\n            yield callbackAbort();\n        }\n    }));\n    AJS.$(dialogId + "-vote").click(() => __awaiter(this, void 0, void 0, function* () {\n        if (typeof callbackAbort === "function") {\n            yield callbackAbort();\n        }\n    }));\n    AJS.$(dialogId + "-continue").click(() => __awaiter(this, void 0, void 0, function* () {\n        AJS.dialog2(dialogId).hide();\n        if (typeof callbackContinue === "function") {\n            yield callbackContinue();\n        }\n    }));\n}\nexports.showDialog = showDialog;\nfunction removeDjsHelperSvg($) {\n    const svgHelpers = $("#helper-svg");\n    if (svgHelpers) {\n        svgHelpers.remove();\n    }\n}\nexports.removeDjsHelperSvg = removeDjsHelperSvg;\nfunction initZoomButtons(viewerModeler) {\n    const zoomResetId = "btn-zoom-reset";\n    const zoomResetIcon = "aui-iconfont-search";\n    const zoomResetName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.zoom.reset");\n    const zoomResetToViewPortId = "btn-zoom-reset-to-view-port";\n    const zoomResetToViewPortIcon = "aui-iconfont-table-bg";\n    const zoomResetToViewPortName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.zoom.fit.to.viewport");\n    const zoomInId = "btn-zoom-in";\n    const zoomInIcon = "";\n    const zoomInName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.zoom.in");\n    const zoomInContent = "+";\n    const zoomOutId = "btn-zoom-out";\n    const zoomOutIcon = "";\n    const zoomOutName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.zoom.out");\n    const zoomOutContent = "-";\n    const zoomResetToViewPortHtml = createBtnHtml(zoomResetToViewPortId, zoomResetToViewPortIcon, zoomResetToViewPortName, "219", "15");\n    const zoomResetHtml = createBtnHtml(zoomResetId, zoomResetIcon, zoomResetName, "170", "15");\n    const zoomInHtml = createBtnHtml(zoomInId, zoomInIcon, zoomInName, "121", "15", zoomInContent);\n    const zoomOutHtml = createBtnHtml(zoomOutId, zoomOutIcon, zoomOutName, "80", "15", zoomOutContent);\n    const zoomScroll = viewerModeler.get("zoomScroll");\n    appendAndAddClickListener(zoomResetToViewPortHtml, zoomResetToViewPortId, (event) => {\n        zoomDiagramFitToCanvas(viewerModeler, 30, 20, 110);\n        event.preventDefault();\n    });\n    appendAndAddClickListener(zoomResetHtml, zoomResetId, (event) => {\n        moveDiagramToTopLeft(viewerModeler, 180, 100);\n        event.preventDefault();\n    });\n    appendAndAddClickListener(zoomInHtml, zoomInId, (event) => {\n        zoomScroll.stepZoom(1);\n        event.preventDefault();\n    });\n    appendAndAddClickListener(zoomOutHtml, zoomOutId, (event) => {\n        zoomScroll.stepZoom(-1);\n        event.preventDefault();\n    });\n    function createBtnHtml(btnId, iconClass, titleName, positionBottom, positionRight, btnContent) {\n        const content = btnContent ? btnContent : "";\n        const icon = iconClass ? `<span class="aui-icon aui-icon-small ${iconClass}" title="${titleName}"></span>` : "";\n        const titleIfNoClass = iconClass ? "" : `title="${titleName}"`;\n        const htmlCode = `<a id="${btnId}" href="#"\n            class="bjs-powered-by btn-zoom"\n            style="bottom: ${positionBottom}px; right: ${positionRight}px;" ${titleIfNoClass}>\n            ${content}${icon}\n            </a>`;\n        return htmlCode;\n    }\n    function appendAndAddClickListener(btnHtml, btnId, clickFn) {\n        $(".bjs-container").append(btnHtml);\n        $("#" + btnId).on("click", clickFn);\n    }\n}\nexports.initZoomButtons = initZoomButtons;\nfunction moveDiagramToTopLeft(viewerModeler, paddingLeft, paddingTop) {\n    const canvas = viewerModeler.get("canvas");\n    const diagramSizes = canvas.getDefaultLayer().getBBox();\n    const outerBox = canvas.viewbox().outer;\n    canvas.viewbox({\n        x: diagramSizes.x - paddingLeft,\n        y: diagramSizes.y - paddingTop,\n        width: outerBox.width,\n        height: outerBox.height,\n    });\n}\nexports.moveDiagramToTopLeft = moveDiagramToTopLeft;\nfunction zoomDiagramFitToCanvas(viewerModeler, paddingWidth, paddingHeight, marginLeft, marginTop) {\n    const minPaddingWidthPx = paddingWidth || 0;\n    const minPaddingHeightPx = paddingHeight || 0;\n    const marginLeftPx = marginLeft || 0;\n    const marginTopPx = marginTop || 0;\n    const canvas = viewerModeler.get("canvas");\n    const oldViewbox = canvas.viewbox();\n    const diagramSizesDpp = canvas.getDefaultLayer().getBBox();\n    const outerBox = oldViewbox.outer;\n    let pxToDppFactor = 1;\n    let newWidthDpp;\n    let newHeightDpp;\n    let paddingHeightPx = minPaddingHeightPx;\n    let paddingWidthPx = minPaddingWidthPx;\n    const outerHeightPx = outerBox.height - 2 * minPaddingHeightPx - marginTopPx;\n    const outerWidthPx = outerBox.width - 2 * minPaddingWidthPx - marginLeftPx;\n    const outerBoxRatio = outerWidthPx / outerHeightPx;\n    const diagramRatio = diagramSizesDpp.width / diagramSizesDpp.height;\n    const landscapeMode = diagramRatio > outerBoxRatio;\n    if (landscapeMode) {\n        pxToDppFactor = diagramSizesDpp.width / outerWidthPx;\n        newWidthDpp = diagramSizesDpp.width + 2 * toDpp(paddingWidthPx);\n        newHeightDpp = newWidthDpp / outerBoxRatio;\n        paddingHeightPx = calcPaddingPx(diagramSizesDpp.height, newHeightDpp, minPaddingHeightPx);\n    }\n    else {\n        pxToDppFactor = diagramSizesDpp.height / outerHeightPx;\n        newHeightDpp = diagramSizesDpp.height + 2 * toDpp(paddingHeightPx);\n        newWidthDpp = newHeightDpp * outerBoxRatio;\n        paddingWidthPx = calcPaddingPx(diagramSizesDpp.width, newWidthDpp, minPaddingWidthPx);\n    }\n    canvas.viewbox({\n        x: diagramSizesDpp.x - toDpp(paddingWidthPx + marginLeftPx),\n        y: diagramSizesDpp.y - toDpp(paddingHeightPx + marginTopPx),\n        width: newWidthDpp + toDpp(marginLeftPx),\n        height: newHeightDpp + toDpp(marginTopPx),\n    });\n    function calcPaddingPx(actSizeDpp, newSizeDpp, minPaddingPx) {\n        if (!actSizeDpp || !newSizeDpp) {\n            vxcpLogger.logError("calcPaddingPx", "Error at calcPaddingPx: Missing parameter, check function calling.");\n            return;\n        }\n        const dppDiff = newSizeDpp - actSizeDpp;\n        const halfDppDiff = dppDiff / 2;\n        const paddingDpp = halfDppDiff < 0 ? halfDppDiff * -1 : halfDppDiff;\n        const paddingPx = toPx(paddingDpp);\n        return paddingPx < minPaddingPx ? minPaddingPx : paddingPx;\n    }\n    function toPx(dppValue) {\n        return dppValue / pxToDppFactor;\n    }\n    function toDpp(pxValue) {\n        return pxValue * pxToDppFactor;\n    }\n}\nfunction initViadeeLogo(diagramName) {\n    diagramName = diagramName.replace(" ", "_");\n    const viadeeLogoId = `viadee-logo-viewer-${diagramName}`;\n    const viadeeLogoName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.viadee.logo");\n    const modelerLink = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.info-link");\n    const viadeeLogo = createViadeeLogo(viadeeLogoId, viadeeLogoName, "22", "30");\n    $(`#viewer-${diagramName} .bjs-container`).append(viadeeLogo);\n    $(`#${viadeeLogoId}`).on("click", (event) => {\n        window.open(modelerLink, "_blank");\n        event.preventDefault();\n    });\n}\nexports.initViadeeLogo = initViadeeLogo;\nfunction createViadeeLogo(viadeeLogoId, titleName, positionBottom, positionLeft) {\n    const title = `title="${titleName}"`;\n    const htmlCode = `<div id="${viadeeLogoId}"\n            class="viadee-logo-viewer"\n            position="absolute"\n            style="bottom: ${positionBottom}px; left: ${positionLeft}px;" ${title}>\n            </div>`;\n    return htmlCode;\n}\nfunction getParams() {\n    return {\n        accessMode: getAccessMode(),\n        baseUrl: getBaseUrl(),\n        currentUserFullname: getCurrentUserFullName(),\n        versionNumber: getConfluenceVersion(),\n        newPage: isNewPage(),\n        spaceKey: getSpaceKey(),\n        spaceName: getSpaceName(),\n        pageId: getPageId(),\n        contentType: getContentType(),\n        latestPageId: getLatestPageId(),\n        userLocale: getUserLocale(),\n        contextPath: getContextPath(),\n        remoteUserKey: getRemoteUserKey(),\n        contentId: getContentId(),\n    };\n}\nexports.getParams = getParams;\nfunction getContentId() {\n    return Confluence.getContentId() ? Confluence.getContentId() : AJS.Meta.get("content-id");\n}\nexports.getContentId = getContentId;\nfunction getAccessMode() {\n    return AJS.Meta.get("access-mode");\n}\nexports.getAccessMode = getAccessMode;\nfunction getPageId() {\n    return AJS.Meta.get("page-id");\n}\nexports.getPageId = getPageId;\nfunction getContentType() {\n    return AJS.Meta.get("content-type");\n}\nexports.getContentType = getContentType;\nfunction getLatestPageId() {\n    return AJS.Meta.get("latest-page-id");\n}\nexports.getLatestPageId = getLatestPageId;\nfunction getUserLocale() {\n    return AJS.Meta.get("user-locale");\n}\nexports.getUserLocale = getUserLocale;\nfunction getContextPath() {\n    return AJS.Meta.get("context-path") || Confluence.getContextPath();\n}\nexports.getContextPath = getContextPath;\nfunction isNewPage() {\n    return AJS.Meta.get("new-page");\n}\nexports.isNewPage = isNewPage;\nfunction getBaseUrl() {\n    return AJS.Meta.get("base-url");\n}\nexports.getBaseUrl = getBaseUrl;\nfunction getSpaceKey() {\n    return AJS.Meta.get("space-key");\n}\nexports.getSpaceKey = getSpaceKey;\nfunction getSpaceName() {\n    return AJS.Meta.get("space-name");\n}\nexports.getSpaceName = getSpaceName;\nfunction getConfluenceVersion() {\n    return AJS.Meta.get("version-number");\n}\nexports.getConfluenceVersion = getConfluenceVersion;\nfunction getCurrentUserFullName() {\n    return AJS.Meta.get("current-user-fullname");\n}\nexports.getCurrentUserFullName = getCurrentUserFullName;\nfunction getRemoteUserKey() {\n    return AJS.Meta.get("remote-user-key");\n}\nexports.getRemoteUserKey = getRemoteUserKey;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/utils.ts?')},"./common/validator.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.isValidInput = exports.decodeFromHtmlEntities = exports.encodeToHtmlEntities = exports.getDiagramNameAsParamString = exports.isValidMacroName = void 0;\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "Validator");\nfunction isValidMacroName(name) {\n    const rteEditor = AJS.Rte.getEditor();\n    const editorHtml = rteEditor.getContent();\n    const regexFree = /<img class="editor-inline-macro".*?data-macro-name="vbcp-macro".*?diagramName=(.*?)["]/g;\n    const regexEnt = /<img class="editor-inline-macro".*?data-macro-name="vbcp-macro-enterprise".*?diagramName=(.*?)[|"]/g;\n    let regexArray = regexEnt.exec(editorHtml);\n    const results = [];\n    while (regexArray !== null) {\n        const txt = decodeFromHtmlEntities(regexArray[1].toLowerCase());\n        results.push(txt);\n        regexArray = regexEnt.exec(editorHtml);\n    }\n    regexArray = regexFree.exec(editorHtml);\n    while (regexArray !== null) {\n        const txt = decodeFromHtmlEntities(regexArray[1].toLowerCase());\n        results.push(txt);\n        regexArray = regexFree.exec(editorHtml);\n    }\n    const macroExistsOnPage = results.indexOf(name.toLowerCase()) !== -1;\n    if ((0, utils_1.getParams)().newPage) {\n        return new Promise((resolveGlobal) => {\n            resolveGlobal(!macroExistsOnPage);\n        });\n    }\n    const baseUrl = (0, utils_1.getParams)().baseUrl;\n    const pageId = (0, utils_1.getParams)().contentId;\n    const restCallChilds = baseUrl.concat("/rest/api/content/", pageId, "/child/comment?expand=body.storage");\n    const searchMacroInComments = new Promise((resolve, reject) => {\n        $.ajax({\n            type: "GET",\n            url: restCallChilds,\n            success: (commentData) => {\n                const commentsExist = commentData && commentData.results && commentData.results.length;\n                let macroExists = false;\n                if (commentsExist) {\n                    commentData.results.forEach((comment) => {\n                        const splitPageDataMacros = comment.body.storage.value.split("ac:structured-macro");\n                        splitPageDataMacros.find((elem) => {\n                            const replacedDiagramName = encodeToHtmlEntities(name);\n                            const diagramNameParam = getDiagramNameAsParamString(replacedDiagramName);\n                            if (elem.indexOf(`ac:name="vbcp-macro-enterprise"`) !== -1 && elem.indexOf(diagramNameParam) !== -1) {\n                                macroExists = true;\n                            }\n                        });\n                    });\n                }\n                resolve(macroExists);\n            },\n            error: (err) => {\n                vxcpLogger.logError("isValidMacroName", "An error occurred while checking whether the given name of macro is valid.", err);\n                resolve(false);\n            },\n        });\n    });\n    return new Promise((resolveGlobal) => {\n        searchMacroInComments.then((macroExistsInComments) => {\n            resolveGlobal(!macroExistsInComments && !macroExistsOnPage);\n        });\n    });\n}\nexports.isValidMacroName = isValidMacroName;\nfunction getDiagramNameAsParamString(diagramName) {\n    return `<ac:parameter ac:name="diagramName">${diagramName}</ac:parameter>`;\n}\nexports.getDiagramNameAsParamString = getDiagramNameAsParamString;\nfunction encodeToHtmlEntities(str) {\n    let replacedStr = str;\n    replacedStr = replacedStr.replace(/Ä/g, "&Auml;");\n    replacedStr = replacedStr.replace(/ä/g, "&auml;");\n    replacedStr = replacedStr.replace(/Ö/g, "&Ouml;");\n    replacedStr = replacedStr.replace(/ö/g, "&ouml;");\n    replacedStr = replacedStr.replace(/Ü/g, "&Uuml;");\n    replacedStr = replacedStr.replace(/ü/g, "&uuml;");\n    replacedStr = replacedStr.replace(/ß/g, "&szlig;");\n    return replacedStr;\n}\nexports.encodeToHtmlEntities = encodeToHtmlEntities;\nfunction decodeFromHtmlEntities(str) {\n    let replacedStr = str;\n    replacedStr = replacedStr.replace(/&Auml;/g, "Ä");\n    replacedStr = replacedStr.replace(/&auml;/g, "ä");\n    replacedStr = replacedStr.replace(/&Ouml;/g, "Ö");\n    replacedStr = replacedStr.replace(/&ouml;/g, "ö");\n    replacedStr = replacedStr.replace(/&Uuml;/g, "Ü");\n    replacedStr = replacedStr.replace(/&uuml;/g, "ü");\n    replacedStr = replacedStr.replace(/&szlig;/g, "ß");\n    return replacedStr;\n}\nexports.decodeFromHtmlEntities = decodeFromHtmlEntities;\nfunction isValidInput(input) {\n    if (!input) {\n        return false;\n    }\n    return /^[A-Za-z0-9 \\u00c4\\u00e4\\u00d6\\u00f6\\u00dc\\u00fc\\u00df\\-]+$/g.test(input);\n}\nexports.isValidInput = isValidInput;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/validator.ts?')},"./common/voting-service.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nexports.VotingService = void 0;\nconst rest_service_1 = __webpack_require__("./common/rest-service.ts");\nconst confUtils = __importStar(__webpack_require__("./common/utils.ts"));\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nclass VotingService {\n    constructor() {\n        this.vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "VotingService");\n    }\n    init($voteLink, $voteCounter) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.$voteCounter = $voteCounter;\n            this.$voteLink = $voteLink;\n            yield this.initVotingLogic();\n        });\n    }\n    voteLinkClickAction() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const votesConsistent = yield this.checkIfButtonAndVoteConsistent();\n            const userVoted = yield this.getUserHasVoted();\n            if (!votesConsistent || !userVoted) {\n                confUtils.showDialog(AJS, "#vbcp-vote-info-dialog", Confluence.Templates.viadee.bpmnplugin.voteInfoDialog, () => __awaiter(this, void 0, void 0, function* () {\n                    yield this.vote();\n                }), () => __awaiter(this, void 0, void 0, function* () {\n                    yield this.unvote();\n                }));\n                yield this.setVoteIconCss();\n                return;\n            }\n            if (userVoted) {\n                yield this.unvote();\n            }\n        });\n    }\n    setVoteIconCss() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const voted = yield this.getUserHasVoted();\n            yield this.toggleVoteIcon(voted);\n            yield this.setCurrentVoteCounterHtml();\n        });\n    }\n    setVoteInfoDialogCss() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const voteLink = $("#vbcp-info-dialog-vote");\n            const voted = yield this.getUserHasVoted();\n            voteLink.toggleClass("voted", voted);\n            const btnTitle = voted ? AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.voting-dialog.unvote") : AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.voting-dialog.vote");\n            voteLink.html(btnTitle);\n            voteLink.attr("title", btnTitle);\n        });\n    }\n    toggleVote() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const oldVoteBool = yield this.getUserHasVoted();\n            const newVoteBoolean = !oldVoteBool;\n            yield this.updateUserVoteContext(newVoteBoolean.toString());\n            yield this.updateCounterAndToggleToolbar(newVoteBoolean);\n            yield this.setVoteInfoDialogCss();\n        });\n    }\n    initVotingLogic() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const voted = yield this.getUserHasVoted();\n            yield this.toggleVoteIcon(voted);\n            yield this.setCurrentVoteCounterHtml();\n        });\n    }\n    vote() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const curVote = yield this.getUserHasVoted();\n            if (curVote) {\n                yield this.toggleVoteIcon(true);\n                yield this.setCurrentVoteCounterHtml();\n                return;\n            }\n            yield this.updateUserVoteContext("true");\n            yield this.updateCounterAndToggleToolbar(true);\n        });\n    }\n    unvote() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const curVote = yield this.getUserHasVoted();\n            if (!curVote) {\n                yield this.toggleVoteIcon(false);\n                yield this.updateCounterHtml(false);\n                yield this.setCurrentVoteCounterHtml();\n                return;\n            }\n            yield this.updateUserVoteContext("false");\n            yield this.updateCounterAndToggleToolbar(false);\n        });\n    }\n    checkIfButtonAndVoteConsistent() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const realVote = yield this.getUserHasVoted();\n            const iconVote = this.$voteLink.hasClass("voted");\n            return realVote === iconVote;\n        });\n    }\n    toggleVoteIcon(voted) {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.$voteLink.toggleClass("voted", voted);\n            this.$voteCounter.toggleClass("voted", voted);\n            const btnTitle = voted ? AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.voting-dialog.unvote") : AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.voting-dialog.vote");\n            this.$voteLink.attr("title", btnTitle);\n        });\n    }\n    updateVoteCounter(userHasVoted) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const counter = yield this.updateCounterHtml(userHasVoted);\n            yield this.updateVotesActiveObject(counter);\n        });\n    }\n    updateCounterAndToggleToolbar(userHasVoted) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.toggleVoteIcon(userHasVoted);\n            yield this.updateVoteCounter(userHasVoted);\n        });\n    }\n    getUserHasVoted() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const voteString = yield this.getUserVotedRest();\n            return voteString === "true";\n        });\n    }\n    setCurrentVoteCounterHtml() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const counter = yield this.getHowManyUserVoted();\n            this.$voteCounter.html(counter);\n            this.$voteCounter.prop("title", `${counter} ${AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.button.hover.vote-counter-text")}`);\n        });\n    }\n    updateCounterHtml(userHasVoted) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let counter = yield this.getHowManyUserVoted();\n            if (userHasVoted) {\n                counter = counter + 1;\n                if (counter < 0) {\n                    counter = 0;\n                }\n                this.$voteCounter.html(counter);\n                this.$voteCounter.prop("title", `${counter} ${AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.button.hover.vote-counter-text")}`);\n            }\n            else {\n                counter = counter - 1;\n                if (counter < 0) {\n                    counter = 0;\n                }\n                this.$voteCounter.html(counter);\n                this.$voteCounter.prop("title", `${counter} ${AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.button.hover.vote-counter-text")}`);\n            }\n            return counter;\n        });\n    }\n    getHowManyUserVoted() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const pluginBaseUrl = (0, rest_service_1.buildPluginBaseUrl)();\n            const restPath = `/rest/bpmn-modeler/1.0/votesForEnterprise/allVotes`;\n            const url = pluginBaseUrl + restPath;\n            let stringNumVotes = "0";\n            try {\n                stringNumVotes = yield $.ajax({\n                    url,\n                    type: "GET",\n                });\n            }\n            catch (err) {\n                this.vxcpLogger.logError("getHowManyUserVoted", " An error occurred while getting the number of voted users.", err);\n            }\n            return parseInt(stringNumVotes);\n        });\n    }\n    updateVotesActiveObject(counter) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const pluginBaseUrl = (0, rest_service_1.buildPluginBaseUrl)();\n            const restPath = `/rest/bpmn-modeler/1.0/votesForEnterprise/allVotes/${counter.toString()}`;\n            const url = pluginBaseUrl + restPath;\n            try {\n                yield $.ajax({\n                    url,\n                    type: "PUT",\n                });\n            }\n            catch (err) {\n                this.vxcpLogger.logError("updateVotesActiveObject", "An error occurred while updating the number of votes.", err);\n            }\n        });\n    }\n    getUserVotedRest() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const pluginBaseUrl = (0, rest_service_1.buildPluginBaseUrl)();\n            const restPath = `/rest/bpmn-modeler/1.0/votesForEnterprise/userVote`;\n            const url = pluginBaseUrl + restPath;\n            let hasVoted = "";\n            try {\n                hasVoted = yield $.ajax({\n                    url,\n                    type: "GET",\n                });\n            }\n            catch (err) {\n                this.vxcpLogger.logError("getUserVotedRest", "An error occurred while getting the cote context for active user.", err);\n            }\n            return hasVoted;\n        });\n    }\n    updateUserVoteContext(vote) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const pluginBaseUrl = (0, rest_service_1.buildPluginBaseUrl)();\n            const restPath = `/rest/bpmn-modeler/1.0/votesForEnterprise/userVote/${vote}`;\n            const url = pluginBaseUrl + restPath;\n            try {\n                yield $.ajax({\n                    url,\n                    type: "PUT",\n                });\n            }\n            catch (err) {\n                this.vxcpLogger.logError("updateUserVoteContext", "An error occurred while updating vote context for active user.", err);\n            }\n        });\n    }\n}\nexports.VotingService = VotingService;\n\n\n//# sourceURL=webpack://VBCPFREE/./common/voting-service.ts?')}}]);