"use strict";(self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[]).push([["bpmnFreeBpmnJs"],{"./node_modules/bpmn-js/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (/* reexport safe */ _lib_Viewer__WEBPACK_IMPORTED_MODULE_0__.Z)\n/* harmony export */ });\nif ("bpmnFreeViewer" == __webpack_require__.j) {\n\t/* harmony import */ var _lib_Viewer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/bpmn-js/lib/Viewer.js");\n}\n\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/index.js?')},"./node_modules/bpmn-js/lib/BaseViewer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ BaseViewer)\n});\n\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/Diagram.js + 8 modules\nvar Diagram = __webpack_require__(\"./node_modules/diagram-js/lib/Diagram.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-moddle/dist/index.esm.js + 3 modules\nvar bpmn_moddle_dist_index_esm = __webpack_require__(\"./node_modules/bpmn-moddle/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/import/Util.js\nvar Util = __webpack_require__(\"./node_modules/bpmn-js/lib/import/Util.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/CompatibilityUtil.js\nvar CompatibilityUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/CompatibilityUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/import/BpmnTreeWalker.js\n\n\n\n\n\n\n\n/**\n * Returns true if an element has the given meta-model type\n *\n * @param  {ModdleElement}  element\n * @param  {string}         type\n *\n * @return {boolean}\n */\nfunction is(element, type) {\n  return element.$instanceOf(type);\n}\n\n\n/**\n * Find a suitable display candidate for definitions where the DI does not\n * correctly specify one.\n */\nfunction findDisplayCandidate(definitions) {\n  return (0,index_esm/* find */.sE)(definitions.rootElements, function(e) {\n    return is(e, 'bpmn:Process') || is(e, 'bpmn:Collaboration');\n  });\n}\n\n\nfunction BpmnTreeWalker(handler, translate) {\n\n  // list of containers already walked\n  var handledElements = {};\n\n  // list of elements to handle deferred to ensure\n  // prerequisites are drawn\n  var deferred = [];\n\n  var diMap = {};\n\n  // Helpers //////////////////////\n\n  function contextual(fn, ctx) {\n    return function(e) {\n      fn(e, ctx);\n    };\n  }\n\n  function handled(element) {\n    handledElements[element.id] = element;\n  }\n\n  function isHandled(element) {\n    return handledElements[element.id];\n  }\n\n  function visit(element, ctx) {\n\n    var gfx = element.gfx;\n\n    // avoid multiple rendering of elements\n    if (gfx) {\n      throw new Error(\n        translate('already rendered {element}', { element: (0,Util/* elementToString */.x)(element) })\n      );\n    }\n\n    // call handler\n    return handler.element(element, diMap[element.id], ctx);\n  }\n\n  function visitRoot(element, diagram) {\n    return handler.root(element, diMap[element.id], diagram);\n  }\n\n  function visitIfDi(element, ctx) {\n\n    try {\n      var gfx = diMap[element.id] && visit(element, ctx);\n\n      handled(element);\n\n      return gfx;\n    } catch (e) {\n      logError(e.message, { element: element, error: e });\n\n      console.error(translate('failed to import {element}', { element: (0,Util/* elementToString */.x)(element) }));\n      console.error(e);\n    }\n  }\n\n  function logError(message, context) {\n    handler.error(message, context);\n  }\n\n  // DI handling //////////////////////\n\n  function registerDi(di) {\n    var bpmnElement = di.bpmnElement;\n\n    if (bpmnElement) {\n      if (diMap[bpmnElement.id]) {\n        logError(\n          translate('multiple DI elements defined for {element}', {\n            element: (0,Util/* elementToString */.x)(bpmnElement)\n          }),\n          { element: bpmnElement }\n        );\n      } else {\n        diMap[bpmnElement.id] = di;\n\n        (0,CompatibilityUtil/* ensureCompatDiRef */.S)(bpmnElement);\n      }\n    } else {\n      logError(\n        translate('no bpmnElement referenced in {element}', {\n          element: (0,Util/* elementToString */.x)(di)\n        }),\n        { element: di }\n      );\n    }\n  }\n\n  function handleDiagram(diagram) {\n    handlePlane(diagram.plane);\n  }\n\n  function handlePlane(plane) {\n    registerDi(plane);\n\n    (0,index_esm/* forEach */.Ed)(plane.planeElement, handlePlaneElement);\n  }\n\n  function handlePlaneElement(planeElement) {\n    registerDi(planeElement);\n  }\n\n\n  // Semantic handling //////////////////////\n\n  /**\n   * Handle definitions and return the rendered diagram (if any)\n   *\n   * @param {ModdleElement} definitions to walk and import\n   * @param {ModdleElement} [diagram] specific diagram to import and display\n   *\n   * @throws {Error} if no diagram to display could be found\n   */\n  function handleDefinitions(definitions, diagram) {\n\n    // make sure we walk the correct bpmnElement\n\n    var diagrams = definitions.diagrams;\n\n    if (diagram && diagrams.indexOf(diagram) === -1) {\n      throw new Error(translate('diagram not part of bpmn:Definitions'));\n    }\n\n    if (!diagram && diagrams && diagrams.length) {\n      diagram = diagrams[0];\n    }\n\n    // no diagram -> nothing to import\n    if (!diagram) {\n      throw new Error(translate('no diagram to display'));\n    }\n\n    // load DI from selected diagram only\n    diMap = {};\n    handleDiagram(diagram);\n\n\n    var plane = diagram.plane;\n\n    if (!plane) {\n      throw new Error(translate(\n        'no plane for {element}',\n        { element: (0,Util/* elementToString */.x)(diagram) }\n      ));\n    }\n\n    var rootElement = plane.bpmnElement;\n\n    // ensure we default to a suitable display candidate (process or collaboration),\n    // even if non is specified in DI\n    if (!rootElement) {\n      rootElement = findDisplayCandidate(definitions);\n\n      if (!rootElement) {\n        throw new Error(translate('no process or collaboration to display'));\n      } else {\n\n        logError(\n          translate('correcting missing bpmnElement on {plane} to {rootElement}', {\n            plane: (0,Util/* elementToString */.x)(plane),\n            rootElement: (0,Util/* elementToString */.x)(rootElement)\n          })\n        );\n\n        // correct DI on the fly\n        plane.bpmnElement = rootElement;\n        registerDi(plane);\n      }\n    }\n\n\n    var ctx = visitRoot(rootElement, plane);\n\n    if (is(rootElement, 'bpmn:Process') || is(rootElement, 'bpmn:SubProcess')) {\n      handleProcess(rootElement, ctx);\n    } else if (is(rootElement, 'bpmn:Collaboration')) {\n      handleCollaboration(rootElement, ctx);\n\n      // force drawing of everything not yet drawn that is part of the target DI\n      handleUnhandledProcesses(definitions.rootElements, ctx);\n    } else {\n      throw new Error(\n        translate('unsupported bpmnElement for {plane}: {rootElement}', {\n          plane: (0,Util/* elementToString */.x)(plane),\n          rootElement: (0,Util/* elementToString */.x)(rootElement)\n        })\n      );\n    }\n\n    // handle all deferred elements\n    handleDeferred(deferred);\n  }\n\n  function handleDeferred() {\n\n    var fn;\n\n    // drain deferred until empty\n    while (deferred.length) {\n      fn = deferred.shift();\n\n      fn();\n    }\n  }\n\n  function handleProcess(process, context) {\n    handleFlowElementsContainer(process, context);\n    handleIoSpecification(process.ioSpecification, context);\n\n    handleArtifacts(process.artifacts, context);\n\n    // log process handled\n    handled(process);\n  }\n\n  function handleUnhandledProcesses(rootElements, ctx) {\n\n    // walk through all processes that have not yet been drawn and draw them\n    // if they contain lanes with DI information.\n    // we do this to pass the free-floating lane test cases in the MIWG test suite\n    var processes = (0,index_esm/* filter */.hX)(rootElements, function(e) {\n      return !isHandled(e) && is(e, 'bpmn:Process') && e.laneSets;\n    });\n\n    processes.forEach(contextual(handleProcess, ctx));\n  }\n\n  function handleMessageFlow(messageFlow, context) {\n    visitIfDi(messageFlow, context);\n  }\n\n  function handleMessageFlows(messageFlows, context) {\n    (0,index_esm/* forEach */.Ed)(messageFlows, contextual(handleMessageFlow, context));\n  }\n\n  function handleDataAssociation(association, context) {\n    visitIfDi(association, context);\n  }\n\n  function handleDataInput(dataInput, context) {\n    visitIfDi(dataInput, context);\n  }\n\n  function handleDataOutput(dataOutput, context) {\n    visitIfDi(dataOutput, context);\n  }\n\n  function handleArtifact(artifact, context) {\n\n    // bpmn:TextAnnotation\n    // bpmn:Group\n    // bpmn:Association\n\n    visitIfDi(artifact, context);\n  }\n\n  function handleArtifacts(artifacts, context) {\n\n    (0,index_esm/* forEach */.Ed)(artifacts, function(e) {\n      if (is(e, 'bpmn:Association')) {\n        deferred.push(function() {\n          handleArtifact(e, context);\n        });\n      } else {\n        handleArtifact(e, context);\n      }\n    });\n  }\n\n  function handleIoSpecification(ioSpecification, context) {\n\n    if (!ioSpecification) {\n      return;\n    }\n\n    (0,index_esm/* forEach */.Ed)(ioSpecification.dataInputs, contextual(handleDataInput, context));\n    (0,index_esm/* forEach */.Ed)(ioSpecification.dataOutputs, contextual(handleDataOutput, context));\n  }\n\n  function handleSubProcess(subProcess, context) {\n    handleFlowElementsContainer(subProcess, context);\n    handleArtifacts(subProcess.artifacts, context);\n  }\n\n  function handleFlowNode(flowNode, context) {\n    var childCtx = visitIfDi(flowNode, context);\n\n    if (is(flowNode, 'bpmn:SubProcess')) {\n      handleSubProcess(flowNode, childCtx || context);\n    }\n\n    if (is(flowNode, 'bpmn:Activity')) {\n      handleIoSpecification(flowNode.ioSpecification, context);\n    }\n\n    // defer handling of associations\n    // affected types:\n    //\n    //   * bpmn:Activity\n    //   * bpmn:ThrowEvent\n    //   * bpmn:CatchEvent\n    //\n    deferred.push(function() {\n      (0,index_esm/* forEach */.Ed)(flowNode.dataInputAssociations, contextual(handleDataAssociation, context));\n      (0,index_esm/* forEach */.Ed)(flowNode.dataOutputAssociations, contextual(handleDataAssociation, context));\n    });\n  }\n\n  function handleSequenceFlow(sequenceFlow, context) {\n    visitIfDi(sequenceFlow, context);\n  }\n\n  function handleDataElement(dataObject, context) {\n    visitIfDi(dataObject, context);\n  }\n\n  function handleLane(lane, context) {\n\n    deferred.push(function() {\n\n      var newContext = visitIfDi(lane, context);\n\n      if (lane.childLaneSet) {\n        handleLaneSet(lane.childLaneSet, newContext || context);\n      }\n\n      wireFlowNodeRefs(lane);\n    });\n  }\n\n  function handleLaneSet(laneSet, context) {\n    (0,index_esm/* forEach */.Ed)(laneSet.lanes, contextual(handleLane, context));\n  }\n\n  function handleLaneSets(laneSets, context) {\n    (0,index_esm/* forEach */.Ed)(laneSets, contextual(handleLaneSet, context));\n  }\n\n  function handleFlowElementsContainer(container, context) {\n    handleFlowElements(container.flowElements, context);\n\n    if (container.laneSets) {\n      handleLaneSets(container.laneSets, context);\n    }\n  }\n\n  function handleFlowElements(flowElements, context) {\n    (0,index_esm/* forEach */.Ed)(flowElements, function(e) {\n      if (is(e, 'bpmn:SequenceFlow')) {\n        deferred.push(function() {\n          handleSequenceFlow(e, context);\n        });\n      } else if (is(e, 'bpmn:BoundaryEvent')) {\n        deferred.unshift(function() {\n          handleFlowNode(e, context);\n        });\n      } else if (is(e, 'bpmn:FlowNode')) {\n        handleFlowNode(e, context);\n      } else if (is(e, 'bpmn:DataObject')) {\n\n        // SKIP (assume correct referencing via DataObjectReference)\n      } else if (is(e, 'bpmn:DataStoreReference')) {\n        handleDataElement(e, context);\n      } else if (is(e, 'bpmn:DataObjectReference')) {\n        handleDataElement(e, context);\n      } else {\n        logError(\n          translate('unrecognized flowElement {element} in context {context}', {\n            element: (0,Util/* elementToString */.x)(e),\n            context: (context ? (0,Util/* elementToString */.x)(context.businessObject) : 'null')\n          }),\n          { element: e, context: context }\n        );\n      }\n    });\n  }\n\n  function handleParticipant(participant, context) {\n    var newCtx = visitIfDi(participant, context);\n\n    var process = participant.processRef;\n    if (process) {\n      handleProcess(process, newCtx || context);\n    }\n  }\n\n  function handleCollaboration(collaboration, context) {\n\n    (0,index_esm/* forEach */.Ed)(collaboration.participants, contextual(handleParticipant, context));\n\n    handleArtifacts(collaboration.artifacts, context);\n\n    // handle message flows latest in the process\n    deferred.push(function() {\n      handleMessageFlows(collaboration.messageFlows, context);\n    });\n  }\n\n\n  function wireFlowNodeRefs(lane) {\n\n    // wire the virtual flowNodeRefs <-> relationship\n    (0,index_esm/* forEach */.Ed)(lane.flowNodeRef, function(flowNode) {\n      var lanes = flowNode.get('lanes');\n\n      if (lanes) {\n        lanes.push(lane);\n      }\n    });\n  }\n\n  // API //////////////////////\n\n  return {\n    handleDeferred: handleDeferred,\n    handleDefinitions: handleDefinitions,\n    handleSubProcess: handleSubProcess,\n    registerDi: registerDi\n  };\n}\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/ModelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/import/Importer.js\n\n\n\n\n\n\n\n/**\n * The importBpmnDiagram result.\n *\n * @typedef {Object} ImportBPMNDiagramResult\n *\n * @property {Array<string>} warnings\n */\n\n/**\n* The importBpmnDiagram error.\n*\n* @typedef {Error} ImportBPMNDiagramError\n*\n* @property {Array<string>} warnings\n*/\n\n/**\n * Import the definitions into a diagram.\n *\n * Errors and warnings are reported through the specified callback.\n *\n * @param  {djs.Diagram} diagram\n * @param  {ModdleElement<Definitions>} definitions\n * @param  {ModdleElement<BPMNDiagram>} [bpmnDiagram] the diagram to be rendered\n * (if not provided, the first one will be rendered)\n *\n * Returns {Promise<ImportBPMNDiagramResult, ImportBPMNDiagramError>}\n */\nfunction importBpmnDiagram(diagram, definitions, bpmnDiagram) {\n\n  var importer,\n      eventBus,\n      translate,\n      canvas;\n\n  var error,\n      warnings = [];\n\n  /**\n   * Walk the diagram semantically, importing (=drawing)\n   * all elements you encounter.\n   *\n   * @param {ModdleElement<Definitions>} definitions\n   * @param {ModdleElement<BPMNDiagram>} bpmnDiagram\n   */\n  function render(definitions, bpmnDiagram) {\n\n    var visitor = {\n\n      root: function(element, di) {\n        return importer.add(element, di);\n      },\n\n      element: function(element, di, parentShape) {\n        return importer.add(element, di, parentShape);\n      },\n\n      error: function(message, context) {\n        warnings.push({ message: message, context: context });\n      }\n    };\n\n    var walker = new BpmnTreeWalker(visitor, translate);\n\n\n    bpmnDiagram = bpmnDiagram || (definitions.diagrams && definitions.diagrams[0]);\n\n    var diagramsToImport = getDiagramsToImport(definitions, bpmnDiagram);\n\n    if (!diagramsToImport) {\n      throw new Error(translate('no diagram to display'));\n    }\n\n    // traverse BPMN 2.0 document model,\n    // starting at definitions\n    (0,index_esm/* forEach */.Ed)(diagramsToImport, function(diagram) {\n      walker.handleDefinitions(definitions, diagram);\n    });\n\n    var rootId = bpmnDiagram.plane.bpmnElement.id;\n\n    // we do need to account for different ways we create root elements\n    // each nested imported <root> do have the `_plane` suffix, while\n    // the root <root> is found under the business object ID\n    canvas.setRootElement(\n      canvas.findRoot(rootId + '_plane') || canvas.findRoot(rootId)\n    );\n  }\n\n  return new Promise(function(resolve, reject) {\n    try {\n      importer = diagram.get('bpmnImporter');\n      eventBus = diagram.get('eventBus');\n      translate = diagram.get('translate');\n      canvas = diagram.get('canvas');\n\n      eventBus.fire('import.render.start', { definitions: definitions });\n\n      render(definitions, bpmnDiagram);\n\n      eventBus.fire('import.render.complete', {\n        error: error,\n        warnings: warnings\n      });\n\n      return resolve({ warnings: warnings });\n    } catch (e) {\n\n      e.warnings = warnings;\n      return reject(e);\n    }\n  });\n}\n\n/**\n * Returns all diagrams in the same hierarchy as the requested diagram.\n * Includes all parent and sub process diagrams.\n *\n * @param {Array} definitions\n * @param {Object} bpmnDiagram\n *\n * @returns {Array<Object>}\n */\nfunction getDiagramsToImport(definitions, bpmnDiagram) {\n  if (!bpmnDiagram) {\n    return;\n  }\n\n  var bpmnElement = bpmnDiagram.plane.bpmnElement,\n      rootElement = bpmnElement;\n\n  if (!(0,ModelUtil.is)(bpmnElement, 'bpmn:Process') && !(0,ModelUtil.is)(bpmnElement, 'bpmn:Collaboration')) {\n    rootElement = findRootProcess(bpmnElement);\n  }\n\n  // in case the process is part of a collaboration, the plane references the\n  // collaboration, not the process\n  var collaboration;\n\n  if ((0,ModelUtil.is)(rootElement, 'bpmn:Collaboration')) {\n    collaboration = rootElement;\n  } else {\n    collaboration = (0,index_esm/* find */.sE)(definitions.rootElements, function(element) {\n      if (!(0,ModelUtil.is)(element, 'bpmn:Collaboration')) {\n        return;\n      }\n\n      return (0,index_esm/* find */.sE)(element.participants, function(participant) {\n        return participant.processRef === rootElement;\n      });\n    });\n  }\n\n  var rootElements = [ rootElement ];\n\n  // all collaboration processes can contain sub-diagrams\n  if (collaboration) {\n    rootElements = (0,index_esm/* map */.UI)(collaboration.participants, function(participant) {\n      return participant.processRef;\n    });\n\n    rootElements.push(collaboration);\n  }\n\n  var allChildren = selfAndAllFlowElements(rootElements);\n\n  // if we have multiple diagrams referencing the same element, we\n  // use the first in the file\n  var diagramsToImport = [ bpmnDiagram ];\n  var handledElements = [ bpmnElement ];\n\n  (0,index_esm/* forEach */.Ed)(definitions.diagrams, function(diagram) {\n    var businessObject = diagram.plane.bpmnElement;\n\n    if (\n      allChildren.indexOf(businessObject) !== -1 &&\n      handledElements.indexOf(businessObject) === -1\n    ) {\n      diagramsToImport.push(diagram);\n      handledElements.push(businessObject);\n    }\n  });\n\n\n  return diagramsToImport;\n}\n\nfunction selfAndAllFlowElements(elements) {\n  var result = [];\n\n  (0,index_esm/* forEach */.Ed)(elements, function(element) {\n    if (!element) {\n      return;\n    }\n\n    result.push(element);\n\n    result = result.concat(selfAndAllFlowElements(element.flowElements));\n  });\n\n  return result;\n}\n\nfunction findRootProcess(element) {\n  var parent = element;\n\n  while (parent) {\n    if ((0,ModelUtil.is)(parent, 'bpmn:Process')) {\n      return parent;\n    }\n\n    parent = parent.$parent;\n  }\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/util/PoweredByUtil.js\n/**\n * This file must not be changed or exchanged.\n *\n * @see http://bpmn.io/license for more information.\n */\n\n\n\n\n// inlined ../../resources/logo.svg\nvar BPMNIO_LOGO_SVG = '<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 14.02 5.57\" width=\"53\" height=\"21\"><path fill=\"currentColor\" d=\"M1.88.92v.14c0 .41-.13.68-.4.8.33.14.46.44.46.86v.33c0 .61-.33.95-.95.95H0V0h.95c.65 0 .93.3.93.92zM.63.57v1.06h.24c.24 0 .38-.1.38-.43V.98c0-.28-.1-.4-.32-.4zm0 1.63v1.22h.36c.2 0 .32-.1.32-.39v-.35c0-.37-.12-.48-.4-.48H.63zM4.18.99v.52c0 .64-.31.98-.94.98h-.3V4h-.62V0h.92c.63 0 .94.35.94.99zM2.94.57v1.35h.3c.2 0 .3-.09.3-.37v-.6c0-.29-.1-.38-.3-.38h-.3zm2.89 2.27L6.25 0h.88v4h-.6V1.12L6.1 3.99h-.6l-.46-2.82v2.82h-.55V0h.87zM8.14 1.1V4h-.56V0h.79L9 2.4V0h.56v4h-.64zm2.49 2.29v.6h-.6v-.6zM12.12 1c0-.63.33-1 .95-1 .61 0 .95.37.95 1v2.04c0 .64-.34 1-.95 1-.62 0-.95-.37-.95-1zm.62 2.08c0 .28.13.39.33.39s.32-.1.32-.4V.98c0-.29-.12-.4-.32-.4s-.33.11-.33.4z\"/><path fill=\"currentColor\" d=\"M0 4.53h14.02v1.04H0zM11.08 0h.63v.62h-.63zm.63 4V1h-.63v2.98z\"/></svg>';\n\nvar BPMNIO_IMG = BPMNIO_LOGO_SVG;\n\nvar LOGO_STYLES = {\n  verticalAlign: 'middle'\n};\n\nvar LINK_STYLES = {\n  'color': '#404040'\n};\n\nvar LIGHTBOX_STYLES = {\n  'zIndex': '1001',\n  'position': 'fixed',\n  'top': '0',\n  'left': '0',\n  'right': '0',\n  'bottom': '0'\n};\n\nvar BACKDROP_STYLES = {\n  'width': '100%',\n  'height': '100%',\n  'background': 'rgba(40,40,40,0.2)'\n};\n\nvar NOTICE_STYLES = {\n  'position': 'absolute',\n  'left': '50%',\n  'top': '40%',\n  'transform': 'translate(-50%)',\n  'width': '260px',\n  'padding': '10px',\n  'background': 'white',\n  'boxShadow': '0 1px 4px rgba(0,0,0,0.3)',\n  'fontFamily': 'Helvetica, Arial, sans-serif',\n  'fontSize': '14px',\n  'display': 'flex',\n  'lineHeight': '1.3'\n};\n\nvar LIGHTBOX_MARKUP =\n  '<div class=\"bjs-powered-by-lightbox\">' +\n    '<div class=\"backdrop\"></div>' +\n    '<div class=\"notice\">' +\n      '<a href=\"https://bpmn.io\" target=\"_blank\" rel=\"noopener\" class=\"link\">' +\n        BPMNIO_IMG +\n      '</a>' +\n      '<span>' +\n        'Web-based tooling for BPMN, DMN and CMMN diagrams ' +\n        'powered by <a href=\"https://bpmn.io\" target=\"_blank\" rel=\"noopener\">bpmn.io</a>.' +\n      '</span>' +\n    '</div>' +\n  '</div>';\n\n\nvar lightbox;\n\nfunction createLightbox() {\n  lightbox = (0,dist_index_esm/* domify */.H6)(LIGHTBOX_MARKUP);\n\n  (0,dist_index_esm/* assignStyle */.i5)(lightbox, LIGHTBOX_STYLES);\n  (0,dist_index_esm/* assignStyle */.i5)((0,dist_index_esm/* query */.IO)('svg', lightbox), LOGO_STYLES);\n  (0,dist_index_esm/* assignStyle */.i5)((0,dist_index_esm/* query */.IO)('.backdrop', lightbox), BACKDROP_STYLES);\n  (0,dist_index_esm/* assignStyle */.i5)((0,dist_index_esm/* query */.IO)('.notice', lightbox), NOTICE_STYLES);\n  (0,dist_index_esm/* assignStyle */.i5)((0,dist_index_esm/* query */.IO)('.link', lightbox), LINK_STYLES, {\n    'margin': '15px 20px 15px 10px',\n    'alignSelf': 'center'\n  });\n}\n\nfunction PoweredByUtil_open() {\n\n  if (!lightbox) {\n    createLightbox();\n\n    dist_index_esm/* delegate.bind */.cl.bind(lightbox, '.backdrop', 'click', function(event) {\n      document.body.removeChild(lightbox);\n    });\n  }\n\n  document.body.appendChild(lightbox);\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/BaseViewer.js\n/**\n * The code in the <project-logo></project-logo> area\n * must not be changed.\n *\n * @see http://bpmn.io/license for more information.\n */\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A base viewer for BPMN 2.0 diagrams.\n *\n * Have a look at {@link Viewer}, {@link NavigatedViewer} or {@link Modeler} for\n * bundles that include actual features.\n *\n * @param {Object} [options] configuration options to pass to the viewer\n * @param {DOMElement} [options.container] the container to render the viewer in, defaults to body.\n * @param {string|number} [options.width] the width of the viewer\n * @param {string|number} [options.height] the height of the viewer\n * @param {Object} [options.moddleExtensions] extension packages to provide\n * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules\n * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules\n */\nfunction BaseViewer(options) {\n\n  options = (0,index_esm/* assign */.f0)({}, DEFAULT_OPTIONS, options);\n\n  this._moddle = this._createModdle(options);\n\n  this._container = this._createContainer(options);\n\n  /* <project-logo> */\n\n  addProjectLogo(this._container);\n\n  /* </project-logo> */\n\n  this._init(this._container, this._moddle, options);\n}\n\n(0,index_es/* default */.Z)(BaseViewer, Diagram/* default */.Z);\n\n/**\n* The importXML result.\n*\n* @typedef {Object} ImportXMLResult\n*\n* @property {Array<string>} warnings\n*/\n\n/**\n* The importXML error.\n*\n* @typedef {Error} ImportXMLError\n*\n* @property {Array<string>} warnings\n*/\n\n/**\n * Parse and render a BPMN 2.0 diagram.\n *\n * Once finished the viewer reports back the result to the\n * provided callback function with (err, warnings).\n *\n * ## Life-Cycle Events\n *\n * During import the viewer will fire life-cycle events:\n *\n *   * import.parse.start (about to read model from xml)\n *   * import.parse.complete (model read; may have worked or not)\n *   * import.render.start (graphical import start)\n *   * import.render.complete (graphical import finished)\n *   * import.done (everything done)\n *\n * You can use these events to hook into the life-cycle.\n *\n * @param {string} xml the BPMN 2.0 xml\n * @param {ModdleElement<BPMNDiagram>|string} [bpmnDiagram] BPMN diagram or id of diagram to render (if not provided, the first one will be rendered)\n *\n * Returns {Promise<ImportXMLResult, ImportXMLError>}\n */\nBaseViewer.prototype.importXML = (0,CompatibilityUtil/* wrapForCompatibility */.$)(async function importXML(xml, bpmnDiagram) {\n\n  const self = this;\n\n  function ParseCompleteEvent(data) {\n\n    const event = self.get('eventBus').createEvent(data);\n\n    // TODO(nikku): remove with future bpmn-js version\n    Object.defineProperty(event, 'context', {\n      enumerable: true,\n      get: function() {\n\n        console.warn(new Error(\n          'import.parse.complete <context> is deprecated ' +\n          'and will be removed in future library versions'\n        ));\n\n        return {\n          warnings: data.warnings,\n          references: data.references,\n          elementsById: data.elementsById\n        };\n      }\n    });\n\n    return event;\n  }\n\n  let aggregatedWarnings = [];\n  try {\n\n    // hook in pre-parse listeners +\n    // allow xml manipulation\n    xml = this._emit('import.parse.start', { xml: xml }) || xml;\n\n    let parseResult;\n    try {\n      parseResult = await this._moddle.fromXML(xml, 'bpmn:Definitions');\n    } catch (error) {\n      this._emit('import.parse.complete', {\n        error\n      });\n\n      throw error;\n    }\n\n    let definitions = parseResult.rootElement;\n    const references = parseResult.references;\n    const parseWarnings = parseResult.warnings;\n    const elementsById = parseResult.elementsById;\n\n    aggregatedWarnings = aggregatedWarnings.concat(parseWarnings);\n\n    // hook in post parse listeners +\n    // allow definitions manipulation\n    definitions = this._emit('import.parse.complete', ParseCompleteEvent({\n      error: null,\n      definitions: definitions,\n      elementsById: elementsById,\n      references: references,\n      warnings: aggregatedWarnings\n    })) || definitions;\n\n    const importResult = await this.importDefinitions(definitions, bpmnDiagram);\n\n    aggregatedWarnings = aggregatedWarnings.concat(importResult.warnings);\n\n    this._emit('import.done', { error: null, warnings: aggregatedWarnings });\n\n    return { warnings: aggregatedWarnings };\n  } catch (err) {\n    let error = err;\n    aggregatedWarnings = aggregatedWarnings.concat(error.warnings || []);\n    addWarningsToError(error, aggregatedWarnings);\n\n    error = checkValidationError(error);\n\n    this._emit('import.done', { error, warnings: error.warnings });\n\n    throw error;\n  }\n});\n\n/**\n* The importDefinitions result.\n*\n* @typedef {Object} ImportDefinitionsResult\n*\n* @property {Array<string>} warnings\n*/\n\n/**\n* The importDefinitions error.\n*\n* @typedef {Error} ImportDefinitionsError\n*\n* @property {Array<string>} warnings\n*/\n\n/**\n * Import parsed definitions and render a BPMN 2.0 diagram.\n *\n * Once finished the viewer reports back the result to the\n * provided callback function with (err, warnings).\n *\n * ## Life-Cycle Events\n *\n * During import the viewer will fire life-cycle events:\n *\n *   * import.render.start (graphical import start)\n *   * import.render.complete (graphical import finished)\n *\n * You can use these events to hook into the life-cycle.\n *\n * @param {ModdleElement<Definitions>} definitions parsed BPMN 2.0 definitions\n * @param {ModdleElement<BPMNDiagram>|string} [bpmnDiagram] BPMN diagram or id of diagram to render (if not provided, the first one will be rendered)\n *\n * Returns {Promise<ImportDefinitionsResult, ImportDefinitionsError>}\n */\nBaseViewer.prototype.importDefinitions = (0,CompatibilityUtil/* wrapForCompatibility */.$)(async function importDefinitions(definitions, bpmnDiagram) {\n  this._setDefinitions(definitions);\n  const result = await this.open(bpmnDiagram);\n\n  return { warnings: result.warnings };\n});\n\n/**\n * The open result.\n *\n * @typedef {Object} OpenResult\n *\n * @property {Array<string>} warnings\n */\n\n/**\n* The open error.\n*\n* @typedef {Error} OpenError\n*\n* @property {Array<string>} warnings\n*/\n\n/**\n * Open diagram of previously imported XML.\n *\n * Once finished the viewer reports back the result to the\n * provided callback function with (err, warnings).\n *\n * ## Life-Cycle Events\n *\n * During switch the viewer will fire life-cycle events:\n *\n *   * import.render.start (graphical import start)\n *   * import.render.complete (graphical import finished)\n *\n * You can use these events to hook into the life-cycle.\n *\n * @param {string|ModdleElement<BPMNDiagram>} [bpmnDiagramOrId] id or the diagram to open\n *\n * Returns {Promise<OpenResult, OpenError>}\n */\nBaseViewer.prototype.open = (0,CompatibilityUtil/* wrapForCompatibility */.$)(async function open(bpmnDiagramOrId) {\n\n  const definitions = this._definitions;\n  let bpmnDiagram = bpmnDiagramOrId;\n\n  if (!definitions) {\n    const error = new Error('no XML imported');\n    addWarningsToError(error, []);\n\n    throw error;\n  }\n\n  if (typeof bpmnDiagramOrId === 'string') {\n    bpmnDiagram = findBPMNDiagram(definitions, bpmnDiagramOrId);\n\n    if (!bpmnDiagram) {\n      const error = new Error('BPMNDiagram <' + bpmnDiagramOrId + '> not found');\n      addWarningsToError(error, []);\n\n      throw error;\n    }\n  }\n\n  // clear existing rendered diagram\n  // catch synchronous exceptions during #clear()\n  try {\n    this.clear();\n  } catch (error) {\n    addWarningsToError(error, []);\n\n    throw error;\n  }\n\n  // perform graphical import\n  const { warnings } = await importBpmnDiagram(this, definitions, bpmnDiagram);\n\n  return { warnings };\n});\n\n/**\n * The saveXML result.\n *\n * @typedef {Object} SaveXMLResult\n *\n * @property {string} xml\n */\n\n/**\n * Export the currently displayed BPMN 2.0 diagram as\n * a BPMN 2.0 XML document.\n *\n * ## Life-Cycle Events\n *\n * During XML saving the viewer will fire life-cycle events:\n *\n *   * saveXML.start (before serialization)\n *   * saveXML.serialized (after xml generation)\n *   * saveXML.done (everything done)\n *\n * You can use these events to hook into the life-cycle.\n *\n * @param {Object} [options] export options\n * @param {boolean} [options.format=false] output formatted XML\n * @param {boolean} [options.preamble=true] output preamble\n *\n * Returns {Promise<SaveXMLResult, Error>}\n */\nBaseViewer.prototype.saveXML = (0,CompatibilityUtil/* wrapForCompatibility */.$)(async function saveXML(options) {\n\n  options = options || {};\n\n  let definitions = this._definitions,\n      error, xml;\n\n  try {\n    if (!definitions) {\n      throw new Error('no definitions loaded');\n    }\n\n    // allow to fiddle around with definitions\n    definitions = this._emit('saveXML.start', {\n      definitions\n    }) || definitions;\n\n    const result = await this._moddle.toXML(definitions, options);\n    xml = result.xml;\n\n    xml = this._emit('saveXML.serialized', {\n      xml\n    }) || xml;\n  } catch (err) {\n    error = err;\n  }\n\n  const result = error ? { error } : { xml };\n\n  this._emit('saveXML.done', result);\n\n  if (error) {\n    throw error;\n  }\n\n  return result;\n});\n\n/**\n * The saveSVG result.\n *\n * @typedef {Object} SaveSVGResult\n *\n * @property {string} svg\n */\n\n/**\n * Export the currently displayed BPMN 2.0 diagram as\n * an SVG image.\n *\n * ## Life-Cycle Events\n *\n * During SVG saving the viewer will fire life-cycle events:\n *\n *   * saveSVG.start (before serialization)\n *   * saveSVG.done (everything done)\n *\n * You can use these events to hook into the life-cycle.\n *\n * @param {Object} [options]\n *\n * Returns {Promise<SaveSVGResult, Error>}\n */\nBaseViewer.prototype.saveSVG = (0,CompatibilityUtil/* wrapForCompatibility */.$)(async function saveSVG(options = {}) {\n  this._emit('saveSVG.start');\n\n  let svg, err;\n\n  try {\n    const canvas = this.get('canvas');\n\n    const contentNode = canvas.getActiveLayer(),\n          defsNode = (0,dist_index_esm/* query */.IO)('defs', canvas._svg);\n\n    const contents = (0,tiny_svg_dist_index_esm/* innerSVG */.db)(contentNode),\n          defs = defsNode ? '<defs>' + (0,tiny_svg_dist_index_esm/* innerSVG */.db)(defsNode) + '</defs>' : '';\n\n    const bbox = contentNode.getBBox();\n\n    svg =\n      '<?xml version=\"1.0\" encoding=\"utf-8\"?>\\n' +\n      '\x3c!-- created with bpmn-js / http://bpmn.io --\x3e\\n' +\n      '<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\\n' +\n      '<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ' +\n      'width=\"' + bbox.width + '\" height=\"' + bbox.height + '\" ' +\n      'viewBox=\"' + bbox.x + ' ' + bbox.y + ' ' + bbox.width + ' ' + bbox.height + '\" version=\"1.1\">' +\n      defs + contents +\n      '</svg>';\n  } catch (e) {\n    err = e;\n  }\n\n  this._emit('saveSVG.done', {\n    error: err,\n    svg: svg\n  });\n\n  if (err) {\n    throw err;\n  }\n\n  return { svg };\n});\n\n/**\n * Get a named diagram service.\n *\n * @example\n *\n * const elementRegistry = viewer.get('elementRegistry');\n * const startEventShape = elementRegistry.get('StartEvent_1');\n *\n * @param {string} name\n *\n * @return {Object} diagram service instance\n *\n * @method BaseViewer#get\n */\n\n/**\n * Invoke a function in the context of this viewer.\n *\n * @example\n *\n * viewer.invoke(function(elementRegistry) {\n *   const startEventShape = elementRegistry.get('StartEvent_1');\n * });\n *\n * @param {Function} fn to be invoked\n *\n * @return {Object} the functions return value\n *\n * @method BaseViewer#invoke\n */\n\n\nBaseViewer.prototype._setDefinitions = function(definitions) {\n  this._definitions = definitions;\n};\n\nBaseViewer.prototype.getModules = function() {\n  return this._modules;\n};\n\n/**\n * Remove all drawn elements from the viewer.\n *\n * After calling this method the viewer can still\n * be reused for opening another diagram.\n *\n * @method BaseViewer#clear\n */\nBaseViewer.prototype.clear = function() {\n  if (!this.getDefinitions()) {\n\n    // no diagram to clear\n    return;\n  }\n\n  // remove drawn elements\n  Diagram/* default.prototype.clear.call */.Z.prototype.clear.call(this);\n};\n\n/**\n * Destroy the viewer instance and remove all its\n * remainders from the document tree.\n */\nBaseViewer.prototype.destroy = function() {\n\n  // diagram destroy\n  Diagram/* default.prototype.destroy.call */.Z.prototype.destroy.call(this);\n\n  // dom detach\n  (0,dist_index_esm/* remove */.Od)(this._container);\n};\n\n/**\n * Register an event listener\n *\n * Remove a previously added listener via {@link #off(event, callback)}.\n *\n * @param {string} event\n * @param {number} [priority]\n * @param {Function} callback\n * @param {Object} [that]\n */\nBaseViewer.prototype.on = function(event, priority, callback, target) {\n  return this.get('eventBus').on(event, priority, callback, target);\n};\n\n/**\n * De-register an event listener\n *\n * @param {string} event\n * @param {Function} callback\n */\nBaseViewer.prototype.off = function(event, callback) {\n  this.get('eventBus').off(event, callback);\n};\n\nBaseViewer.prototype.attachTo = function(parentNode) {\n\n  if (!parentNode) {\n    throw new Error('parentNode required');\n  }\n\n  // ensure we detach from the\n  // previous, old parent\n  this.detach();\n\n  // unwrap jQuery if provided\n  if (parentNode.get && parentNode.constructor.prototype.jquery) {\n    parentNode = parentNode.get(0);\n  }\n\n  if (typeof parentNode === 'string') {\n    parentNode = (0,dist_index_esm/* query */.IO)(parentNode);\n  }\n\n  parentNode.appendChild(this._container);\n\n  this._emit('attach', {});\n\n  this.get('canvas').resized();\n};\n\nBaseViewer.prototype.getDefinitions = function() {\n  return this._definitions;\n};\n\nBaseViewer.prototype.detach = function() {\n\n  const container = this._container,\n        parentNode = container.parentNode;\n\n  if (!parentNode) {\n    return;\n  }\n\n  this._emit('detach', {});\n\n  parentNode.removeChild(container);\n};\n\nBaseViewer.prototype._init = function(container, moddle, options) {\n\n  const baseModules = options.modules || this.getModules(),\n        additionalModules = options.additionalModules || [],\n        staticModules = [\n          {\n            bpmnjs: [ 'value', this ],\n            moddle: [ 'value', moddle ]\n          }\n        ];\n\n  const diagramModules = [].concat(staticModules, baseModules, additionalModules);\n\n  const diagramOptions = (0,index_esm/* assign */.f0)((0,index_esm/* omit */.CE)(options, [ 'additionalModules' ]), {\n    canvas: (0,index_esm/* assign */.f0)({}, options.canvas, { container: container }),\n    modules: diagramModules\n  });\n\n  // invoke diagram constructor\n  Diagram/* default.call */.Z.call(this, diagramOptions);\n\n  if (options && options.container) {\n    this.attachTo(options.container);\n  }\n};\n\n/**\n * Emit an event on the underlying {@link EventBus}\n *\n * @param  {string} type\n * @param  {Object} event\n *\n * @return {Object} event processing result (if any)\n */\nBaseViewer.prototype._emit = function(type, event) {\n  return this.get('eventBus').fire(type, event);\n};\n\nBaseViewer.prototype._createContainer = function(options) {\n\n  const container = (0,dist_index_esm/* domify */.H6)('<div class=\"bjs-container\"></div>');\n\n  (0,dist_index_esm/* assignStyle */.i5)(container, {\n    width: ensureUnit(options.width),\n    height: ensureUnit(options.height),\n    position: options.position\n  });\n\n  return container;\n};\n\nBaseViewer.prototype._createModdle = function(options) {\n  const moddleOptions = (0,index_esm/* assign */.f0)({}, this._moddleExtensions, options.moddleExtensions);\n\n  return new bpmn_moddle_dist_index_esm/* default */.Z(moddleOptions);\n};\n\nBaseViewer.prototype._modules = [];\n\n// helpers ///////////////\n\nfunction addWarningsToError(err, warningsAry) {\n  err.warnings = warningsAry;\n  return err;\n}\n\nfunction checkValidationError(err) {\n\n  // check if we can help the user by indicating wrong BPMN 2.0 xml\n  // (in case he or the exporting tool did not get that right)\n\n  const pattern = /unparsable content <([^>]+)> detected([\\s\\S]*)$/;\n  const match = pattern.exec(err.message);\n\n  if (match) {\n    err.message =\n      'unparsable content <' + match[1] + '> detected; ' +\n      'this may indicate an invalid BPMN 2.0 diagram file' + match[2];\n  }\n\n  return err;\n}\n\nconst DEFAULT_OPTIONS = {\n  width: '100%',\n  height: '100%',\n  position: 'relative'\n};\n\n\n/**\n * Ensure the passed argument is a proper unit (defaulting to px)\n */\nfunction ensureUnit(val) {\n  return val + ((0,index_esm/* isNumber */.hj)(val) ? 'px' : '');\n}\n\n\n/**\n * Find BPMNDiagram in definitions by ID\n *\n * @param {ModdleElement<Definitions>} definitions\n * @param {string} diagramId\n *\n * @return {ModdleElement<BPMNDiagram>|null}\n */\nfunction findBPMNDiagram(definitions, diagramId) {\n  if (!diagramId) {\n    return null;\n  }\n\n  return (0,index_esm/* find */.sE)(definitions.diagrams, function(element) {\n    return element.id === diagramId;\n  }) || null;\n}\n\n\n/* <project-logo> */\n\n\n\n\n\n/**\n * Adds the project logo to the diagram container as\n * required by the bpmn.io license.\n *\n * @see http://bpmn.io/license\n *\n * @param {Element} container\n */\nfunction addProjectLogo(container) {\n  const img = BPMNIO_IMG;\n\n  const linkMarkup =\n    '<a href=\"http://bpmn.io\" ' +\n    'target=\"_blank\" ' +\n    'class=\"bjs-powered-by\" ' +\n    'title=\"Powered by bpmn.io\" ' +\n    '>' +\n    img +\n    '</a>';\n\n  const linkElement = (0,dist_index_esm/* domify */.H6)(linkMarkup);\n\n  (0,dist_index_esm/* assignStyle */.i5)((0,dist_index_esm/* query */.IO)('svg', linkElement), LOGO_STYLES);\n  (0,dist_index_esm/* assignStyle */.i5)(linkElement, LINK_STYLES, {\n    position: 'absolute',\n    bottom: '15px',\n    right: '15px',\n    zIndex: '100'\n  });\n\n  container.appendChild(linkElement);\n\n  dist_index_esm/* event.bind */.B.bind(linkElement, 'click', function(event) {\n    PoweredByUtil_open();\n\n    event.preventDefault();\n  });\n}\n\n/* </project-logo> */\n\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/BaseViewer.js_+_3_modules?")},"./node_modules/bpmn-js/lib/Modeler.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"default\": () => (/* binding */ Modeler)\n});\n\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/ids/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/ids/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/BaseViewer.js + 3 modules\nvar BaseViewer = __webpack_require__(\"./node_modules/bpmn-js/lib/BaseViewer.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/BaseModeler.js\n\n\n\n\n\n\n\n/**\n * A base modeler for BPMN 2.0 diagrams.\n *\n * Have a look at {@link Modeler} for a bundle that includes actual features.\n *\n * @param {Object} [options] configuration options to pass to the viewer\n * @param {DOMElement} [options.container] the container to render the viewer in, defaults to body.\n * @param {string|number} [options.width] the width of the viewer\n * @param {string|number} [options.height] the height of the viewer\n * @param {Object} [options.moddleExtensions] extension packages to provide\n * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules\n * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules\n */\nfunction BaseModeler(options) {\n  BaseViewer/* default.call */.Z.call(this, options);\n\n  // hook ID collection into the modeler\n  this.on('import.parse.complete', function(event) {\n    if (!event.error) {\n      this._collectIds(event.definitions, event.elementsById);\n    }\n  }, this);\n\n  this.on('diagram.destroy', function() {\n    this.get('moddle').ids.clear();\n  }, this);\n}\n\n(0,index_es/* default */.Z)(BaseModeler, BaseViewer/* default */.Z);\n\n\n/**\n * Create a moddle instance, attaching ids to it.\n *\n * @param {Object} options\n */\nBaseModeler.prototype._createModdle = function(options) {\n  var moddle = BaseViewer/* default.prototype._createModdle.call */.Z.prototype._createModdle.call(this, options);\n\n  // attach ids to moddle to be able to track\n  // and validated ids in the BPMN 2.0 XML document\n  // tree\n  moddle.ids = new index_esm/* default */.Z([ 32, 36, 1 ]);\n\n  return moddle;\n};\n\n/**\n * Collect ids processed during parsing of the\n * definitions object.\n *\n * @param {ModdleElement} definitions\n * @param {Context} context\n */\nBaseModeler.prototype._collectIds = function(definitions, elementsById) {\n\n  var moddle = definitions.$model,\n      ids = moddle.ids,\n      id;\n\n  // remove references from previous import\n  ids.clear();\n\n  for (id in elementsById) {\n    ids.claim(id, elementsById[id]);\n  }\n};\n\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/Viewer.js + 13 modules\nvar Viewer = __webpack_require__(\"./node_modules/bpmn-js/lib/Viewer.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/NavigatedViewer.js\nvar NavigatedViewer = __webpack_require__(\"./node_modules/bpmn-js/lib/NavigatedViewer.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/navigation/keyboard-move/index.js + 1 modules\nvar keyboard_move = __webpack_require__(\"./node_modules/diagram-js/lib/navigation/keyboard-move/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/navigation/movecanvas/index.js + 1 modules\nvar movecanvas = __webpack_require__(\"./node_modules/diagram-js/lib/navigation/movecanvas/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/navigation/touch/index.js + 3 modules\nvar touch = __webpack_require__(\"./node_modules/diagram-js/lib/navigation/touch/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/navigation/zoomscroll/index.js + 3 modules\nvar zoomscroll = __webpack_require__(\"./node_modules/diagram-js/lib/navigation/zoomscroll/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/align-elements/index.js + 1 modules\nvar align_elements = __webpack_require__(\"./node_modules/diagram-js/lib/features/align-elements/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/context-pad/index.js + 1 modules\nvar context_pad = __webpack_require__(\"./node_modules/diagram-js/lib/features/context-pad/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/popup-menu/index.js + 2 modules\nvar popup_menu = __webpack_require__(\"./node_modules/diagram-js/lib/features/popup-menu/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/align-elements/AlignElementsIcons.js\n/**\n * To change the icons, modify the SVGs in `./resources`, execute `npx svgo -f resources --datauri enc -o dist`,\n * and then replace respective icons with the optimized data URIs in `./dist`.\n */\nvar icons = {\n  align:  'data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%202000%202000%22%3E%3Cpath%20style%3D%22stroke%3AcurrentColor%3Bstroke-width%3A100%3Bstroke-linecap%3Around%22%20d%3D%22M200%20150v1700%22%2F%3E%3Crect%20x%3D%22500%22%20y%3D%22150%22%20width%3D%221300%22%20height%3D%22700%22%20rx%3D%221%22%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%22%2F%3E%3Crect%20x%3D%22500%22%20y%3D%221150%22%20width%3D%22700%22%20height%3D%22700%22%20rx%3D%221%22%20style%3D%22fill%3AcurrentColor%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bopacity%3A.5%22%2F%3E%3C%2Fsvg%3E',\n  bottom: 'data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%201800%201800%22%3E%3Cpath%20style%3D%22stroke%3AcurrentColor%3Bstroke-width%3A100%3Bstroke-linecap%3Around%22%20d%3D%22M150%201650h1500%22%2F%3E%3Crect%20x%3D%22150%22%20y%3D%22350%22%20width%3D%22600%22%20height%3D%221300%22%20rx%3D%221%22%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%22%2F%3E%3Crect%20x%3D%221050%22%20y%3D%22850%22%20width%3D%22600%22%20height%3D%22800%22%20rx%3D%221%22%20style%3D%22fill%3AcurrentColor%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bopacity%3A.5%22%2F%3E%3C%2Fsvg%3E',\n  center: 'data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%201800%201800%22%3E%3Cpath%20style%3D%22stroke%3AcurrentColor%3Bstroke-width%3A100%3Bstroke-linecap%3Around%22%20d%3D%22M900%20150v1500%22%2F%3E%3Crect%20x%3D%22250%22%20y%3D%22150%22%20width%3D%221300%22%20height%3D%22600%22%20rx%3D%221%22%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%22%2F%3E%3Crect%20x%3D%22500%22%20y%3D%221050%22%20width%3D%22800%22%20height%3D%22600%22%20rx%3D%221%22%20style%3D%22fill%3AcurrentColor%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bopacity%3A.5%22%2F%3E%3C%2Fsvg%3E',\n  left:   'data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%201800%201800%22%3E%3Cpath%20style%3D%22stroke%3AcurrentColor%3Bstroke-width%3A100%3Bstroke-linecap%3Around%22%20d%3D%22M100%20150v1500%22%2F%3E%3Crect%20x%3D%22100%22%20y%3D%22150%22%20width%3D%221300%22%20height%3D%22600%22%20rx%3D%221%22%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%22%2F%3E%3Crect%20x%3D%22100%22%20y%3D%221050%22%20width%3D%22800%22%20height%3D%22600%22%20rx%3D%221%22%20style%3D%22fill%3AcurrentColor%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bopacity%3A.5%22%2F%3E%3C%2Fsvg%3E',\n  right:  'data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%201800%201800%22%3E%3Cpath%20style%3D%22stroke%3AcurrentColor%3Bstroke-width%3A100%3Bstroke-linecap%3Around%22%20d%3D%22M1650%20150v1500%22%2F%3E%3Crect%20x%3D%22350%22%20y%3D%22150%22%20width%3D%221300%22%20height%3D%22600%22%20rx%3D%221%22%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%22%2F%3E%3Crect%20x%3D%22850%22%20y%3D%221050%22%20width%3D%22800%22%20height%3D%22600%22%20rx%3D%221%22%20style%3D%22fill%3AcurrentColor%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bopacity%3A.5%22%2F%3E%3C%2Fsvg%3E',\n  top:    'data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%201800%201800%22%3E%3Cpath%20style%3D%22stroke%3AcurrentColor%3Bstroke-width%3A100%3Bstroke-linecap%3Around%22%20d%3D%22M150%20150h1500%22%2F%3E%3Crect%20x%3D%22150%22%20y%3D%22150%22%20width%3D%22600%22%20height%3D%221300%22%20rx%3D%221%22%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%22%2F%3E%3Crect%20x%3D%221050%22%20y%3D%22150%22%20width%3D%22600%22%20height%3D%22800%22%20rx%3D%221%22%20style%3D%22fill%3AcurrentColor%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bopacity%3A.5%22%2F%3E%3C%2Fsvg%3E',\n  middle: 'data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%201800%201800%22%3E%3Cpath%20style%3D%22stroke%3AcurrentColor%3Bstroke-width%3A100%3Bstroke-linecap%3Around%22%20d%3D%22M150%20900h1500%22%2F%3E%3Crect%20x%3D%22150%22%20y%3D%22250%22%20width%3D%22600%22%20height%3D%221300%22%20rx%3D%221%22%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%22%2F%3E%3Crect%20x%3D%221050%22%20y%3D%22500%22%20width%3D%22600%22%20height%3D%22800%22%20rx%3D%221%22%20style%3D%22fill%3AcurrentColor%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bopacity%3A.5%22%2F%3E%3C%2Fsvg%3E'\n};\n\n/* harmony default export */ const AlignElementsIcons = (icons);\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/align-elements/AlignElementsContextPadProvider.js\n\n\n\n\nvar LOW_PRIORITY = 900;\n\n/**\n * A provider for align elements context pad button\n */\nfunction AlignElementsContextPadProvider(contextPad, popupMenu, translate, canvas) {\n\n  contextPad.registerProvider(LOW_PRIORITY, this);\n\n  this._contextPad = contextPad;\n  this._popupMenu = popupMenu;\n  this._translate = translate;\n  this._canvas = canvas;\n}\n\nAlignElementsContextPadProvider.$inject = [\n  'contextPad',\n  'popupMenu',\n  'translate',\n  'canvas'\n];\n\nAlignElementsContextPadProvider.prototype.getMultiElementContextPadEntries = function(elements) {\n  var actions = {};\n\n  if (this._isAllowed(elements)) {\n    (0,dist_index_esm/* assign */.f0)(actions, this._getEntries(elements));\n  }\n\n  return actions;\n};\n\nAlignElementsContextPadProvider.prototype._isAllowed = function(elements) {\n  return !this._popupMenu.isEmpty(elements, 'align-elements');\n};\n\nAlignElementsContextPadProvider.prototype._getEntries = function(elements) {\n  var self = this;\n\n  return {\n    'align-elements': {\n      group: 'align-elements',\n      title: self._translate('Align elements'),\n      imageUrl: AlignElementsIcons.align,\n      action: {\n        click: function(event, elements) {\n          var position = self._getMenuPosition(elements);\n\n          (0,dist_index_esm/* assign */.f0)(position, {\n            cursor: {\n              x: event.x,\n              y: event.y\n            }\n          });\n\n          self._popupMenu.open(elements, 'align-elements', position);\n        }\n      }\n    }\n  };\n};\n\nAlignElementsContextPadProvider.prototype._getMenuPosition = function(elements) {\n  var Y_OFFSET = 5;\n\n  var pad = this._contextPad.getPad(elements).html;\n\n  var padRect = pad.getBoundingClientRect();\n\n  var pos = {\n    x: padRect.left,\n    y: padRect.bottom + Y_OFFSET\n  };\n\n  return pos;\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/align-elements/AlignElementsMenuProvider.js\n\n\n\n\nvar ALIGNMENT_OPTIONS = [\n  'left',\n  'center',\n  'right',\n  'top',\n  'middle',\n  'bottom'\n];\n\n/**\n * A provider for align elements popup menu.\n */\nfunction AlignElementsMenuProvider(popupMenu, alignElements, translate, rules) {\n\n  this._alignElements = alignElements;\n  this._translate = translate;\n  this._popupMenu = popupMenu;\n  this._rules = rules;\n\n  popupMenu.registerProvider('align-elements', this);\n}\n\nAlignElementsMenuProvider.$inject = [\n  'popupMenu',\n  'alignElements',\n  'translate',\n  'rules'\n];\n\nAlignElementsMenuProvider.prototype.getPopupMenuEntries = function(elements) {\n  var entries = {};\n\n  if (this._isAllowed(elements)) {\n    (0,dist_index_esm/* assign */.f0)(entries, this._getEntries(elements));\n  }\n\n  return entries;\n};\n\nAlignElementsMenuProvider.prototype._isAllowed = function(elements) {\n  return this._rules.allowed('elements.align', { elements: elements });\n};\n\nAlignElementsMenuProvider.prototype._getEntries = function(elements) {\n  var alignElements = this._alignElements,\n      translate = this._translate,\n      popupMenu = this._popupMenu;\n\n  var entries = {};\n\n  (0,dist_index_esm/* forEach */.Ed)(ALIGNMENT_OPTIONS, function(alignment) {\n    entries[ 'align-elements-' + alignment ] = {\n      group: 'align',\n      title: translate('Align elements ' + alignment),\n      className: 'bjs-align-elements-menu-entry',\n      imageUrl: AlignElementsIcons[alignment],\n      action: function(event, entry) {\n        alignElements.trigger(elements, alignment);\n        popupMenu.close();\n      }\n    };\n  });\n\n  return entries;\n};\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/RuleProvider.js\nvar RuleProvider = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/RuleProvider.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Elements.js\nvar Elements = __webpack_require__(\"./node_modules/diagram-js/lib/util/Elements.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/align-elements/BpmnAlignElements.js\n\n\n\n\n\n\n\n/**\n * Rule provider for alignment of BPMN elements.\n */\nfunction BpmnAlignElements(eventBus) {\n  RuleProvider/* default.call */.Z.call(this, eventBus);\n}\n\nBpmnAlignElements.$inject = [ 'eventBus' ];\n\n(0,index_es/* default */.Z)(BpmnAlignElements, RuleProvider/* default */.Z);\n\nBpmnAlignElements.prototype.init = function() {\n  this.addRule('elements.align', function(context) {\n    var elements = context.elements;\n\n    // filter out elements which cannot be aligned\n    var filteredElements = (0,dist_index_esm/* filter */.hX)(elements, function(element) {\n      return !(element.waypoints || element.host || element.labelTarget);\n    });\n\n    // filter out elements which are children of any of the selected elements\n    filteredElements = (0,Elements/* getParents */.cd)(filteredElements);\n\n    if (filteredElements.length < 2) {\n      return false;\n    }\n\n    return filteredElements;\n  });\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/align-elements/index.js\n\n\n\n\n\n\n\n\n/* harmony default export */ const features_align_elements = ({\n  __depends__: [\n    align_elements/* default */.Z,\n    context_pad/* default */.Z,\n    popup_menu/* default */.Z\n  ],\n  __init__: [\n    'alignElementsContextPadProvider',\n    'alignElementsMenuProvider',\n    'bpmnAlignElements'\n  ],\n  alignElementsContextPadProvider: [ 'type', AlignElementsContextPadProvider ],\n  alignElementsMenuProvider: [ 'type', AlignElementsMenuProvider ],\n  bpmnAlignElements: [ 'type', BpmnAlignElements ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/auto-place/index.js + 2 modules\nvar auto_place = __webpack_require__(\"./node_modules/diagram-js/lib/features/auto-place/index.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/ModelUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/auto-place/AutoPlaceUtil.js\nvar AutoPlaceUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/auto-place/AutoPlaceUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/auto-place/BpmnAutoPlaceUtil.js\n\n\n\n\n\n\n\n\n/**\n * Find the new position for the target element to\n * connect to source.\n *\n * @param  {djs.model.Shape} source\n * @param  {djs.model.Shape} element\n *\n * @return {Point}\n */\nfunction getNewShapePosition(source, element) {\n\n  if ((0,ModelUtil.is)(element, 'bpmn:TextAnnotation')) {\n    return getTextAnnotationPosition(source, element);\n  }\n\n  if ((0,ModelUtil/* isAny */.JZ)(element, [ 'bpmn:DataObjectReference', 'bpmn:DataStoreReference' ])) {\n    return getDataElementPosition(source, element);\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:FlowNode')) {\n    return getFlowNodePosition(source, element);\n  }\n}\n\n/**\n * Always try to place element right of source;\n * compute actual distance from previous nodes in flow.\n */\nfunction getFlowNodePosition(source, element) {\n\n  var sourceTrbl = (0,LayoutUtil/* asTRBL */.JA)(source);\n  var sourceMid = (0,LayoutUtil/* getMid */.wS)(source);\n\n  var horizontalDistance = (0,AutoPlaceUtil/* getConnectedDistance */.KW)(source, {\n    filter: function(connection) {\n      return (0,ModelUtil.is)(connection, 'bpmn:SequenceFlow');\n    }\n  });\n\n  var margin = 30,\n      minDistance = 80,\n      orientation = 'left';\n\n  if ((0,ModelUtil.is)(source, 'bpmn:BoundaryEvent')) {\n    orientation = (0,LayoutUtil/* getOrientation */.T8)(source, source.host, -25);\n\n    if (orientation.indexOf('top') !== -1) {\n      margin *= -1;\n    }\n  }\n\n  var position = {\n    x: sourceTrbl.right + horizontalDistance + element.width / 2,\n    y: sourceMid.y + getVerticalDistance(orientation, minDistance)\n  };\n\n  var nextPositionDirection = {\n    y: {\n      margin: margin,\n      minDistance: minDistance\n    }\n  };\n\n  return (0,AutoPlaceUtil/* findFreePosition */.QA)(source, element, position, (0,AutoPlaceUtil/* generateGetNextPosition */.n5)(nextPositionDirection));\n}\n\n\nfunction getVerticalDistance(orientation, minDistance) {\n  if (orientation.indexOf('top') != -1) {\n    return -1 * minDistance;\n  } else if (orientation.indexOf('bottom') != -1) {\n    return minDistance;\n  } else {\n    return 0;\n  }\n}\n\n\n/**\n * Always try to place text annotations top right of source.\n */\nfunction getTextAnnotationPosition(source, element) {\n\n  var sourceTrbl = (0,LayoutUtil/* asTRBL */.JA)(source);\n\n  var position = {\n    x: sourceTrbl.right + element.width / 2,\n    y: sourceTrbl.top - 50 - element.height / 2\n  };\n\n  if (isConnection(source)) {\n    position = (0,LayoutUtil/* getMid */.wS)(source);\n    position.x += 100;\n    position.y -= 50;\n  }\n\n  var nextPositionDirection = {\n    y: {\n      margin: -30,\n      minDistance: 20\n    }\n  };\n\n  return (0,AutoPlaceUtil/* findFreePosition */.QA)(source, element, position, (0,AutoPlaceUtil/* generateGetNextPosition */.n5)(nextPositionDirection));\n}\n\n\n/**\n * Always put element bottom right of source.\n */\nfunction getDataElementPosition(source, element) {\n\n  var sourceTrbl = (0,LayoutUtil/* asTRBL */.JA)(source);\n\n  var position = {\n    x: sourceTrbl.right - 10 + element.width / 2,\n    y: sourceTrbl.bottom + 40 + element.width / 2\n  };\n\n  var nextPositionDirection = {\n    x: {\n      margin: 30,\n      minDistance: 30\n    }\n  };\n\n  return (0,AutoPlaceUtil/* findFreePosition */.QA)(source, element, position, (0,AutoPlaceUtil/* generateGetNextPosition */.n5)(nextPositionDirection));\n}\n\nfunction isConnection(element) {\n  return !!element.waypoints;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/auto-place/BpmnAutoPlace.js\n\n\n\n/**\n * BPMN auto-place behavior.\n *\n * @param {EventBus} eventBus\n */\nfunction AutoPlace(eventBus) {\n  eventBus.on('autoPlace', function(context) {\n    var shape = context.shape,\n        source = context.source;\n\n    return getNewShapePosition(source, shape);\n  });\n}\n\nAutoPlace.$inject = [ 'eventBus' ];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/auto-place/index.js\n\n\n\n\n/* harmony default export */ const features_auto_place = ({\n  __depends__: [ auto_place/* default */.Z ],\n  __init__: [ 'bpmnAutoPlace' ],\n  bpmnAutoPlace: [ 'type', AutoPlace ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/auto-resize/AutoResize.js\nvar AutoResize = __webpack_require__(\"./node_modules/diagram-js/lib/features/auto-resize/AutoResize.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/auto-resize/BpmnAutoResize.js\n\n\n\n\n\n\n\n/**\n * Sub class of the AutoResize module which implements a BPMN\n * specific resize function.\n */\nfunction BpmnAutoResize(injector) {\n\n  injector.invoke(AutoResize/* default */.Z, this);\n}\n\nBpmnAutoResize.$inject = [\n  'injector'\n];\n\n(0,index_es/* default */.Z)(BpmnAutoResize, AutoResize/* default */.Z);\n\n\n/**\n * Resize shapes and lanes.\n *\n * @param {djs.model.Shape} target\n * @param {Bounds} newBounds\n * @param {Object} hints\n */\nBpmnAutoResize.prototype.resize = function(target, newBounds, hints) {\n\n  if ((0,ModelUtil.is)(target, 'bpmn:Participant')) {\n    this._modeling.resizeLane(target, newBounds, null, hints);\n  } else {\n    this._modeling.resizeShape(target, newBounds, null, hints);\n  }\n};\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/auto-resize/AutoResizeProvider.js\nvar AutoResizeProvider = __webpack_require__(\"./node_modules/diagram-js/lib/features/auto-resize/AutoResizeProvider.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/auto-resize/BpmnAutoResizeProvider.js\n\n\n\n\n\n\n\n\n\n/**\n * This module is a provider for automatically resizing parent BPMN elements\n */\nfunction BpmnAutoResizeProvider(eventBus, modeling) {\n  AutoResizeProvider/* default.call */.Z.call(this, eventBus);\n\n  this._modeling = modeling;\n}\n\n(0,index_es/* default */.Z)(BpmnAutoResizeProvider, AutoResizeProvider/* default */.Z);\n\nBpmnAutoResizeProvider.$inject = [\n  'eventBus',\n  'modeling'\n];\n\n\n/**\n * Check if the given target can be expanded\n *\n * @param  {djs.model.Shape} target\n *\n * @return {boolean}\n */\nBpmnAutoResizeProvider.prototype.canResize = function(elements, target) {\n\n  // do not resize plane elements:\n  // root elements, collapsed sub-processes\n  if ((0,ModelUtil.is)(target.di, 'bpmndi:BPMNPlane')) {\n    return false;\n  }\n\n  if (!(0,ModelUtil.is)(target, 'bpmn:Participant') && !(0,ModelUtil.is)(target, 'bpmn:Lane') && !((0,ModelUtil.is)(target, 'bpmn:SubProcess'))) {\n    return false;\n  }\n\n  var canResize = true;\n\n  (0,dist_index_esm/* forEach */.Ed)(elements, function(element) {\n\n    if ((0,ModelUtil.is)(element, 'bpmn:Lane') || element.labelTarget) {\n      canResize = false;\n      return;\n    }\n  });\n\n  return canResize;\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/auto-resize/index.js\n\n\n\n\n/* harmony default export */ const auto_resize = ({\n  __init__: [\n    'bpmnAutoResize',\n    'bpmnAutoResizeProvider'\n  ],\n  bpmnAutoResize: [ 'type', BpmnAutoResize ],\n  bpmnAutoResizeProvider: [ 'type', BpmnAutoResizeProvider ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/auto-scroll/index.js + 1 modules\nvar auto_scroll = __webpack_require__(\"./node_modules/diagram-js/lib/features/auto-scroll/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/bendpoints/index.js + 6 modules\nvar bendpoints = __webpack_require__(\"./node_modules/diagram-js/lib/features/bendpoints/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/connect/index.js + 2 modules\nvar connect = __webpack_require__(\"./node_modules/diagram-js/lib/features/connect/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/connection-preview/index.js + 1 modules\nvar connection_preview = __webpack_require__(\"./node_modules/diagram-js/lib/features/connection-preview/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js-direct-editing/index.js + 2 modules\nvar diagram_js_direct_editing = __webpack_require__(\"./node_modules/diagram-js-direct-editing/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/create/index.js + 2 modules\nvar create = __webpack_require__(\"./node_modules/diagram-js/lib/features/create/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/copy-paste/index.js + 3 modules\nvar copy_paste = __webpack_require__(\"./node_modules/diagram-js/lib/features/copy-paste/index.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/copy-paste/BpmnCopyPaste.js\n\n\n\n\nfunction copyProperties(source, target, properties) {\n  if (!(0,dist_index_esm/* isArray */.kJ)(properties)) {\n    properties = [ properties ];\n  }\n\n  (0,dist_index_esm/* forEach */.Ed)(properties, function(property) {\n    if (!(0,dist_index_esm/* isUndefined */.o8)(source[property])) {\n      target[property] = source[property];\n    }\n  });\n}\n\nvar BpmnCopyPaste_LOW_PRIORITY = 750;\n\n\nfunction BpmnCopyPaste(bpmnFactory, eventBus, moddleCopy) {\n\n  function copy(bo, clone) {\n    var targetBo = bpmnFactory.create(bo.$type);\n\n    return moddleCopy.copyElement(bo, targetBo, null, clone);\n  }\n\n  eventBus.on('copyPaste.copyElement', BpmnCopyPaste_LOW_PRIORITY, function(context) {\n    var descriptor = context.descriptor,\n        element = context.element,\n        businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n    // do not copy business object + di for labels;\n    // will be pulled from the referenced label target\n    if (isLabel(element)) {\n      return descriptor;\n    }\n\n    var businessObjectCopy = descriptor.businessObject = copy(businessObject, true);\n    var diCopy = descriptor.di = copy((0,ModelUtil/* getDi */.DN)(element), true);\n    diCopy.bpmnElement = businessObjectCopy;\n\n    copyProperties(businessObjectCopy, descriptor, 'name');\n    copyProperties(diCopy, descriptor, 'isExpanded');\n\n    // default sequence flow\n    if (businessObject.default) {\n      descriptor.default = businessObject.default.id;\n    }\n  });\n\n  var referencesKey = '-bpmn-js-refs';\n\n  function getReferences(cache) {\n    return (cache[referencesKey] = cache[referencesKey] || {});\n  }\n\n  function setReferences(cache, references) {\n    cache[referencesKey] = references;\n  }\n\n  function resolveReferences(descriptor, cache, references) {\n    var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(descriptor);\n\n    // default sequence flows\n    if (descriptor.default) {\n\n      // relationship cannot be resolved immediately\n      references[ descriptor.default ] = {\n        element: businessObject,\n        property: 'default'\n      };\n    }\n\n    // boundary events\n    if (descriptor.host) {\n\n      // relationship can be resolved immediately\n      (0,ModelUtil/* getBusinessObject */.SS)(descriptor).attachedToRef = (0,ModelUtil/* getBusinessObject */.SS)(cache[ descriptor.host ]);\n    }\n\n    return (0,dist_index_esm/* omit */.CE)(references, (0,dist_index_esm/* reduce */.u4)(references, function(array, reference, key) {\n      var element = reference.element,\n          property = reference.property;\n\n      if (key === descriptor.id) {\n        element[ property ] = businessObject;\n\n        array.push(descriptor.id);\n      }\n\n      return array;\n    }, []));\n  }\n\n  eventBus.on('copyPaste.pasteElement', function(context) {\n    var cache = context.cache,\n        descriptor = context.descriptor,\n        businessObject = descriptor.businessObject,\n        di = descriptor.di;\n\n    // wire existing di + businessObject for external label\n    if (isLabel(descriptor)) {\n      descriptor.businessObject = (0,ModelUtil/* getBusinessObject */.SS)(cache[ descriptor.labelTarget ]);\n      descriptor.di = (0,ModelUtil/* getDi */.DN)(cache[ descriptor.labelTarget ]);\n\n      return;\n    }\n\n    businessObject = descriptor.businessObject = copy(businessObject);\n\n    di = descriptor.di = copy(di);\n    di.bpmnElement = businessObject;\n\n    copyProperties(descriptor, businessObject, [\n      'isExpanded',\n      'name'\n    ]);\n\n    descriptor.type = businessObject.$type;\n  });\n\n  // copy + paste processRef with participant\n\n  eventBus.on('copyPaste.copyElement', BpmnCopyPaste_LOW_PRIORITY, function(context) {\n    var descriptor = context.descriptor,\n        element = context.element;\n\n    if (!(0,ModelUtil.is)(element, 'bpmn:Participant')) {\n      return;\n    }\n\n    var participantBo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n    if (participantBo.processRef) {\n      descriptor.processRef = copy(participantBo.processRef, true);\n    }\n  });\n\n  eventBus.on('copyPaste.pasteElement', function(context) {\n    var descriptor = context.descriptor,\n        processRef = descriptor.processRef;\n\n    if (processRef) {\n      descriptor.processRef = copy(processRef);\n    }\n  });\n\n  // resolve references\n\n  eventBus.on('copyPaste.pasteElement', BpmnCopyPaste_LOW_PRIORITY, function(context) {\n    var cache = context.cache,\n        descriptor = context.descriptor;\n\n    // resolve references e.g. default sequence flow\n    setReferences(\n      cache,\n      resolveReferences(descriptor, cache, getReferences(cache))\n    );\n  });\n\n}\n\n\nBpmnCopyPaste.$inject = [\n  'bpmnFactory',\n  'eventBus',\n  'moddleCopy'\n];\n\n// helpers //////////\n\nfunction isLabel(element) {\n  return !!element.labelTarget;\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/copy-paste/ModdleCopy.js\n\n\nvar DISALLOWED_PROPERTIES = [\n  'artifacts',\n  'dataInputAssociations',\n  'dataOutputAssociations',\n  'default',\n  'flowElements',\n  'lanes',\n  'incoming',\n  'outgoing',\n  'categoryValue'\n];\n\n/**\n * @typedef {Function} <moddleCopy.canCopyProperties> listener\n *\n * @param {Object} context\n * @param {Array<string>} context.propertyNames\n * @param {ModdleElement} context.sourceElement\n * @param {ModdleElement} context.targetElement\n *\n * @returns {Array<string>|boolean} - Return properties to be copied or false to disallow\n * copying.\n */\n\n/**\n * @typedef {Function} <moddleCopy.canCopyProperty> listener\n *\n * @param {Object} context\n * @param {ModdleElement} context.parent\n * @param {*} context.property\n * @param {string} context.propertyName\n *\n * @returns {*|boolean} - Return copied property or false to disallow\n * copying.\n */\n\n/**\n * @typedef {Function} <moddleCopy.canSetCopiedProperty> listener\n *\n * @param {Object} context\n * @param {ModdleElement} context.parent\n * @param {*} context.property\n * @param {string} context.propertyName\n *\n * @returns {boolean} - Return false to disallow\n * setting copied property.\n */\n\n/**\n * Utility for copying model properties from source element to target element.\n *\n * @param {EventBus} eventBus\n * @param {BpmnFactory} bpmnFactory\n * @param {BpmnModdle} moddle\n */\nfunction ModdleCopy(eventBus, bpmnFactory, moddle) {\n  this._bpmnFactory = bpmnFactory;\n  this._eventBus = eventBus;\n  this._moddle = moddle;\n\n  // copy extension elements last\n  eventBus.on('moddleCopy.canCopyProperties', function(context) {\n    var propertyNames = context.propertyNames;\n\n    if (!propertyNames || !propertyNames.length) {\n      return;\n    }\n\n    return (0,dist_index_esm/* sortBy */.MR)(propertyNames, function(propertyName) {\n      return propertyName === 'extensionElements';\n    });\n  });\n\n  // default check whether property can be copied\n  eventBus.on('moddleCopy.canCopyProperty', function(context) {\n    var parent = context.parent,\n        parentDescriptor = (0,dist_index_esm/* isObject */.Kn)(parent) && parent.$descriptor,\n        propertyName = context.propertyName;\n\n    if (propertyName && DISALLOWED_PROPERTIES.indexOf(propertyName) !== -1) {\n\n      // disallow copying property\n      return false;\n    }\n\n    if (propertyName &&\n      parentDescriptor &&\n      !(0,dist_index_esm/* find */.sE)(parentDescriptor.properties, (0,dist_index_esm/* matchPattern */.KQ)({ name: propertyName }))) {\n\n      // disallow copying property\n      return false;\n    }\n  });\n\n  // do NOT allow to copy empty extension elements\n  eventBus.on('moddleCopy.canSetCopiedProperty', function(context) {\n    var property = context.property;\n\n    if (is(property, 'bpmn:ExtensionElements') && (!property.values || !property.values.length)) {\n\n      // disallow setting copied property\n      return false;\n    }\n  });\n}\n\nModdleCopy.$inject = [\n  'eventBus',\n  'bpmnFactory',\n  'moddle'\n];\n\n/**\n * Copy model properties of source element to target element.\n *\n * @param {ModdleElement} sourceElement\n * @param {ModdleElement} targetElement\n * @param {Array<string>} [propertyNames]\n * @param {boolean} clone\n *\n * @param {ModdleElement}\n */\nModdleCopy.prototype.copyElement = function(sourceElement, targetElement, propertyNames, clone) {\n  var self = this;\n\n  if (propertyNames && !(0,dist_index_esm/* isArray */.kJ)(propertyNames)) {\n    propertyNames = [ propertyNames ];\n  }\n\n  propertyNames = propertyNames || getPropertyNames(sourceElement.$descriptor);\n\n  var canCopyProperties = this._eventBus.fire('moddleCopy.canCopyProperties', {\n    propertyNames: propertyNames,\n    sourceElement: sourceElement,\n    targetElement: targetElement,\n    clone: clone\n  });\n\n  if (canCopyProperties === false) {\n    return targetElement;\n  }\n\n  if ((0,dist_index_esm/* isArray */.kJ)(canCopyProperties)) {\n    propertyNames = canCopyProperties;\n  }\n\n  // copy properties\n  (0,dist_index_esm/* forEach */.Ed)(propertyNames, function(propertyName) {\n    var sourceProperty;\n\n    if ((0,dist_index_esm/* has */.e$)(sourceElement, propertyName)) {\n      sourceProperty = sourceElement.get(propertyName);\n    }\n\n    var copiedProperty = self.copyProperty(sourceProperty, targetElement, propertyName, clone);\n\n    if (!(0,dist_index_esm/* isDefined */.$K)(copiedProperty)) {\n      return;\n    }\n\n    var canSetProperty = self._eventBus.fire('moddleCopy.canSetCopiedProperty', {\n      parent: targetElement,\n      property: copiedProperty,\n      propertyName: propertyName\n    });\n\n    if (canSetProperty === false) {\n      return;\n    }\n\n    // TODO(nikku): unclaim old IDs if ID property is copied over\n    // this._moddle.getPropertyDescriptor(parent, propertyName)\n    targetElement.set(propertyName, copiedProperty);\n  });\n\n  return targetElement;\n};\n\n/**\n * Copy model property.\n *\n * @param {*} property\n * @param {ModdleElement} parent\n * @param {string} propertyName\n * @param {boolean} clone\n *\n * @returns {*}\n */\nModdleCopy.prototype.copyProperty = function(property, parent, propertyName, clone) {\n  var self = this;\n\n  // allow others to copy property\n  var copiedProperty = this._eventBus.fire('moddleCopy.canCopyProperty', {\n    parent: parent,\n    property: property,\n    propertyName: propertyName,\n    clone: clone\n  });\n\n  // return if copying is NOT allowed\n  if (copiedProperty === false) {\n    return;\n  }\n\n  if (copiedProperty) {\n    if ((0,dist_index_esm/* isObject */.Kn)(copiedProperty) && copiedProperty.$type && !copiedProperty.$parent) {\n      copiedProperty.$parent = parent;\n    }\n\n    return copiedProperty;\n  }\n\n  var propertyDescriptor = this._moddle.getPropertyDescriptor(parent, propertyName);\n\n  // do NOT copy references\n  if (propertyDescriptor.isReference) {\n    return;\n  }\n\n  // copy id\n  if (propertyDescriptor.isId) {\n    return property && this._copyId(property, parent, clone);\n  }\n\n  // copy arrays\n  if ((0,dist_index_esm/* isArray */.kJ)(property)) {\n    return (0,dist_index_esm/* reduce */.u4)(property, function(childProperties, childProperty) {\n\n      // recursion\n      copiedProperty = self.copyProperty(childProperty, parent, propertyName, clone);\n\n      // copying might NOT be allowed\n      if (copiedProperty) {\n        return childProperties.concat(copiedProperty);\n      }\n\n      return childProperties;\n    }, []);\n  }\n\n  // copy model elements\n  if ((0,dist_index_esm/* isObject */.Kn)(property) && property.$type) {\n    if (this._moddle.getElementDescriptor(property).isGeneric) {\n      return;\n    }\n\n    copiedProperty = self._bpmnFactory.create(property.$type);\n\n    copiedProperty.$parent = parent;\n\n    // recursion\n    copiedProperty = self.copyElement(property, copiedProperty, null, clone);\n\n    return copiedProperty;\n  }\n\n  // copy primitive properties\n  return property;\n};\n\nModdleCopy.prototype._copyId = function(id, element, clone) {\n\n  if (clone) {\n    return id;\n  }\n\n  // disallow if already taken\n  if (this._moddle.ids.assigned(id)) {\n    return;\n  } else {\n\n    this._moddle.ids.claim(id, element);\n    return id;\n  }\n};\n\n// helpers //////////\n\nfunction getPropertyNames(descriptor, keepDefaultProperties) {\n  return (0,dist_index_esm/* reduce */.u4)(descriptor.properties, function(properties, property) {\n\n    if (keepDefaultProperties && property.default) {\n      return properties;\n    }\n\n    return properties.concat(property.name);\n  }, []);\n}\n\nfunction is(element, type) {\n  return element && (typeof element.$instanceOf === 'function') && element.$instanceOf(type);\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/copy-paste/index.js\n\n\n\n\n\n/* harmony default export */ const features_copy_paste = ({\n  __depends__: [\n    copy_paste/* default */.Z\n  ],\n  __init__: [ 'bpmnCopyPaste', 'moddleCopy' ],\n  bpmnCopyPaste: [ 'type', BpmnCopyPaste ],\n  moddleCopy: [ 'type', ModdleCopy ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/replace/index.js + 1 modules\nvar replace = __webpack_require__(\"./node_modules/diagram-js/lib/features/replace/index.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/DiUtil.js\nvar DiUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/DiUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/replace/BpmnReplace.js\n\n\n\n\n\n\n\n\n\n\nfunction BpmnReplace_copyProperties(source, target, properties) {\n  if (!(0,dist_index_esm/* isArray */.kJ)(properties)) {\n    properties = [ properties ];\n  }\n\n  (0,dist_index_esm/* forEach */.Ed)(properties, function(property) {\n    if (!(0,dist_index_esm/* isUndefined */.o8)(source[property])) {\n      target[property] = source[property];\n    }\n  });\n}\n\n\nvar CUSTOM_PROPERTIES = [\n  'cancelActivity',\n  'instantiate',\n  'eventGatewayType',\n  'triggeredByEvent',\n  'isInterrupting'\n];\n\n/**\n * Check if element should be collapsed or expanded.\n */\nfunction shouldToggleCollapsed(element, targetElement) {\n\n  var oldCollapsed = (\n    element && (0,dist_index_esm/* has */.e$)(element, 'collapsed') ? element.collapsed : !(0,DiUtil/* isExpanded */.ul)(element)\n  );\n\n  var targetCollapsed;\n\n  if (targetElement && ((0,dist_index_esm/* has */.e$)(targetElement, 'collapsed') || (0,dist_index_esm/* has */.e$)(targetElement, 'isExpanded'))) {\n\n    // property is explicitly set so use it\n    targetCollapsed = (\n      (0,dist_index_esm/* has */.e$)(targetElement, 'collapsed') ? targetElement.collapsed : !targetElement.isExpanded\n    );\n  } else {\n\n    // keep old state\n    targetCollapsed = oldCollapsed;\n  }\n\n  if (oldCollapsed !== targetCollapsed) {\n    return true;\n  }\n\n  return false;\n}\n\n\n/**\n * This module takes care of replacing BPMN elements\n */\nfunction BpmnReplace(\n    bpmnFactory,\n    elementFactory,\n    moddleCopy,\n    modeling,\n    replace,\n    rules,\n    selection\n) {\n\n  /**\n   * Prepares a new business object for the replacement element\n   * and triggers the replace operation.\n   *\n   * @param  {djs.model.Base} element\n   * @param  {Object} target\n   * @param  {Object} [hints]\n   *\n   * @return {djs.model.Base} the newly created element\n   */\n  function replaceElement(element, target, hints) {\n\n    hints = hints || {};\n\n    var type = target.type,\n        oldBusinessObject = element.businessObject;\n\n    if (isSubProcess(oldBusinessObject) && type === 'bpmn:SubProcess') {\n      if (shouldToggleCollapsed(element, target)) {\n\n        // expanding or collapsing process\n        modeling.toggleCollapse(element);\n\n        return element;\n      }\n    }\n\n    var newBusinessObject = bpmnFactory.create(type);\n\n    var newElement = {\n      type: type,\n      businessObject: newBusinessObject,\n    };\n\n    newElement.di = {};\n\n    // colors will be set to DI\n    BpmnReplace_copyProperties(element.di, newElement.di, [\n      'fill',\n      'stroke',\n      'background-color',\n      'border-color',\n      'color'\n    ]);\n\n    var elementProps = getPropertyNames(oldBusinessObject.$descriptor),\n        newElementProps = getPropertyNames(newBusinessObject.$descriptor, true),\n        copyProps = intersection(elementProps, newElementProps);\n\n    // initialize special properties defined in target definition\n    (0,dist_index_esm/* assign */.f0)(newBusinessObject, (0,dist_index_esm/* pick */.ei)(target, CUSTOM_PROPERTIES));\n\n    var properties = (0,dist_index_esm/* filter */.hX)(copyProps, function(propertyName) {\n\n      // copying event definitions, unless we replace\n      if (propertyName === 'eventDefinitions') {\n        return hasEventDefinition(element, target.eventDefinitionType);\n      }\n\n      // retain loop characteristics if the target element\n      // is not an event sub process\n      if (propertyName === 'loopCharacteristics') {\n        return !(0,DiUtil/* isEventSubProcess */.J5)(newBusinessObject);\n      }\n\n      // so the applied properties from 'target' don't get lost\n      if ((0,dist_index_esm/* has */.e$)(newBusinessObject, propertyName)) {\n        return false;\n      }\n\n      if (propertyName === 'processRef' && target.isExpanded === false) {\n        return false;\n      }\n\n      if (propertyName === 'triggeredByEvent') {\n        return false;\n      }\n\n      return true;\n    });\n\n    newBusinessObject = moddleCopy.copyElement(\n      oldBusinessObject,\n      newBusinessObject,\n      properties\n    );\n\n    // initialize custom BPMN extensions\n    if (target.eventDefinitionType) {\n\n      // only initialize with new eventDefinition\n      // if we did not set an event definition yet,\n      // i.e. because we copied it\n      if (!hasEventDefinition(newBusinessObject, target.eventDefinitionType)) {\n        newElement.eventDefinitionType = target.eventDefinitionType;\n        newElement.eventDefinitionAttrs = target.eventDefinitionAttrs;\n      }\n    }\n\n    if ((0,ModelUtil.is)(oldBusinessObject, 'bpmn:Activity')) {\n\n      if (isSubProcess(oldBusinessObject)) {\n\n        // no toggeling, so keep old state\n        newElement.isExpanded = (0,DiUtil/* isExpanded */.ul)(element);\n      }\n\n      // else if property is explicitly set, use it\n      else if (target && (0,dist_index_esm/* has */.e$)(target, 'isExpanded')) {\n        newElement.isExpanded = target.isExpanded;\n\n        // assign default size of new expanded element\n        var defaultSize = elementFactory.getDefaultSize(newBusinessObject, {\n          isExpanded: newElement.isExpanded\n        });\n\n        newElement.width = defaultSize.width;\n        newElement.height = defaultSize.height;\n\n        // keep element centered\n        newElement.x = element.x - (newElement.width - element.width) / 2;\n        newElement.y = element.y - (newElement.height - element.height) / 2;\n      }\n\n      // TODO: need also to respect min/max Size\n      // copy size, from an expanded subprocess to an expanded alternative subprocess\n      // except bpmn:Task, because Task is always expanded\n      if (((0,DiUtil/* isExpanded */.ul)(element) && !(0,ModelUtil.is)(oldBusinessObject, 'bpmn:Task')) && newElement.isExpanded) {\n        newElement.width = element.width;\n        newElement.height = element.height;\n      }\n    }\n\n    // remove children if not expanding sub process\n    if (isSubProcess(oldBusinessObject) && !isSubProcess(newBusinessObject)) {\n      hints.moveChildren = false;\n    }\n\n    // transform collapsed/expanded pools\n    if ((0,ModelUtil.is)(oldBusinessObject, 'bpmn:Participant')) {\n\n      // create expanded pool\n      if (target.isExpanded === true) {\n        newBusinessObject.processRef = bpmnFactory.create('bpmn:Process');\n      } else {\n\n        // remove children when transforming to collapsed pool\n        hints.moveChildren = false;\n      }\n\n      // apply same width and default height\n      newElement.width = element.width;\n      newElement.height = elementFactory.getDefaultSize(newElement).height;\n    }\n\n    if (!rules.allowed('shape.resize', { shape: newBusinessObject })) {\n      newElement.height = elementFactory.getDefaultSize(newElement).height;\n      newElement.width = elementFactory.getDefaultSize(newElement).width;\n    }\n\n    newBusinessObject.name = oldBusinessObject.name;\n\n    // retain default flow's reference between inclusive <-> exclusive gateways and activities\n    if (\n      (0,ModelUtil/* isAny */.JZ)(oldBusinessObject, [\n        'bpmn:ExclusiveGateway',\n        'bpmn:InclusiveGateway',\n        'bpmn:Activity'\n      ]) &&\n      (0,ModelUtil/* isAny */.JZ)(newBusinessObject, [\n        'bpmn:ExclusiveGateway',\n        'bpmn:InclusiveGateway',\n        'bpmn:Activity'\n      ])\n    ) {\n      newBusinessObject.default = oldBusinessObject.default;\n    }\n\n    if (\n      target.host &&\n      !(0,ModelUtil.is)(oldBusinessObject, 'bpmn:BoundaryEvent') &&\n      (0,ModelUtil.is)(newBusinessObject, 'bpmn:BoundaryEvent')\n    ) {\n      newElement.host = target.host;\n    }\n\n    // The DataStoreReference element is 14px wider than the DataObjectReference element\n    // This ensures that they stay centered on the x axis when replaced\n    if (\n      newElement.type === 'bpmn:DataStoreReference' ||\n      newElement.type === 'bpmn:DataObjectReference'\n    ) {\n      newElement.x = element.x + (element.width - newElement.width) / 2;\n    }\n\n\n    newElement = replace.replaceElement(element, newElement, hints);\n\n    if (hints.select !== false) {\n      selection.select(newElement);\n    }\n\n    return newElement;\n  }\n\n  this.replaceElement = replaceElement;\n}\n\nBpmnReplace.$inject = [\n  'bpmnFactory',\n  'elementFactory',\n  'moddleCopy',\n  'modeling',\n  'replace',\n  'rules',\n  'selection'\n];\n\n\nfunction isSubProcess(bo) {\n  return (0,ModelUtil.is)(bo, 'bpmn:SubProcess');\n}\n\nfunction hasEventDefinition(element, type) {\n\n  var bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n  return type && bo.get('eventDefinitions').some(function(definition) {\n    return (0,ModelUtil.is)(definition, type);\n  });\n}\n\n/**\n * Compute intersection between two arrays.\n */\nfunction intersection(a1, a2) {\n  return a1.filter(function(el) {\n    return a2.indexOf(el) !== -1;\n  });\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/replace/index.js\n\n\n\n\n\n\n/* harmony default export */ const features_replace = ({\n  __depends__: [\n    features_copy_paste,\n    replace/* default */.Z,\n    selection/* default */.Z\n  ],\n  bpmnReplace: [ 'type', BpmnReplace ]\n});\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/popup-menu/util/TypeUtil.js\n\n\n\n\n\n/**\n * Returns true, if an element is from a different type\n * than a target definition. Takes into account the type,\n * event definition type and triggeredByEvent property.\n *\n * @param {djs.model.Base} element\n *\n * @return {boolean}\n */\nfunction isDifferentType(element) {\n\n  return function(entry) {\n    var target = entry.target;\n\n    var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n        eventDefinition = businessObject.eventDefinitions && businessObject.eventDefinitions[0];\n\n    var isTypeEqual = businessObject.$type === target.type;\n\n    var isEventDefinitionEqual = (\n      (eventDefinition && eventDefinition.$type) === target.eventDefinitionType\n    );\n\n    var isTriggeredByEventEqual = (\n\n      // coherse to <false>\n      !!target.triggeredByEvent === !!businessObject.triggeredByEvent\n    );\n\n    var isExpandedEqual = (\n      target.isExpanded === undefined ||\n      target.isExpanded === (0,DiUtil/* isExpanded */.ul)(element)\n    );\n\n    return !isTypeEqual || !isEventDefinitionEqual || !isTriggeredByEventEqual || !isExpandedEqual;\n  };\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/replace/ReplaceOptions.js\nvar START_EVENT = [\n  {\n    label: 'Start Event',\n    actionName: 'replace-with-none-start',\n    className: 'bpmn-icon-start-event-none',\n    target: {\n      type: 'bpmn:StartEvent'\n    }\n  },\n  {\n    label: 'Intermediate Throw Event',\n    actionName: 'replace-with-none-intermediate-throwing',\n    className: 'bpmn-icon-intermediate-event-none',\n    target: {\n      type: 'bpmn:IntermediateThrowEvent'\n    }\n  },\n  {\n    label: 'End Event',\n    actionName: 'replace-with-none-end',\n    className: 'bpmn-icon-end-event-none',\n    target: {\n      type: 'bpmn:EndEvent'\n    }\n  },\n  {\n    label: 'Message Start Event',\n    actionName: 'replace-with-message-start',\n    className: 'bpmn-icon-start-event-message',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:MessageEventDefinition'\n    }\n  },\n  {\n    label: 'Timer Start Event',\n    actionName: 'replace-with-timer-start',\n    className: 'bpmn-icon-start-event-timer',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:TimerEventDefinition'\n    }\n  },\n  {\n    label: 'Conditional Start Event',\n    actionName: 'replace-with-conditional-start',\n    className: 'bpmn-icon-start-event-condition',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:ConditionalEventDefinition'\n    }\n  },\n  {\n    label: 'Signal Start Event',\n    actionName: 'replace-with-signal-start',\n    className: 'bpmn-icon-start-event-signal',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:SignalEventDefinition'\n    }\n  }\n];\n\nvar START_EVENT_SUB_PROCESS = [\n  {\n    label: 'Start Event',\n    actionName: 'replace-with-none-start',\n    className: 'bpmn-icon-start-event-none',\n    target: {\n      type: 'bpmn:StartEvent'\n    }\n  },\n  {\n    label: 'Intermediate Throw Event',\n    actionName: 'replace-with-none-intermediate-throwing',\n    className: 'bpmn-icon-intermediate-event-none',\n    target: {\n      type: 'bpmn:IntermediateThrowEvent'\n    }\n  },\n  {\n    label: 'End Event',\n    actionName: 'replace-with-none-end',\n    className: 'bpmn-icon-end-event-none',\n    target: {\n      type: 'bpmn:EndEvent'\n    }\n  }\n];\n\nvar INTERMEDIATE_EVENT = [\n  {\n    label: 'Start Event',\n    actionName: 'replace-with-none-start',\n    className: 'bpmn-icon-start-event-none',\n    target: {\n      type: 'bpmn:StartEvent'\n    }\n  },\n  {\n    label: 'Intermediate Throw Event',\n    actionName: 'replace-with-none-intermediate-throw',\n    className: 'bpmn-icon-intermediate-event-none',\n    target: {\n      type: 'bpmn:IntermediateThrowEvent'\n    }\n  },\n  {\n    label: 'End Event',\n    actionName: 'replace-with-none-end',\n    className: 'bpmn-icon-end-event-none',\n    target: {\n      type: 'bpmn:EndEvent'\n    }\n  },\n  {\n    label: 'Message Intermediate Catch Event',\n    actionName: 'replace-with-message-intermediate-catch',\n    className: 'bpmn-icon-intermediate-event-catch-message',\n    target: {\n      type: 'bpmn:IntermediateCatchEvent',\n      eventDefinitionType: 'bpmn:MessageEventDefinition'\n    }\n  },\n  {\n    label: 'Message Intermediate Throw Event',\n    actionName: 'replace-with-message-intermediate-throw',\n    className: 'bpmn-icon-intermediate-event-throw-message',\n    target: {\n      type: 'bpmn:IntermediateThrowEvent',\n      eventDefinitionType: 'bpmn:MessageEventDefinition'\n    }\n  },\n  {\n    label: 'Timer Intermediate Catch Event',\n    actionName: 'replace-with-timer-intermediate-catch',\n    className: 'bpmn-icon-intermediate-event-catch-timer',\n    target: {\n      type: 'bpmn:IntermediateCatchEvent',\n      eventDefinitionType: 'bpmn:TimerEventDefinition'\n    }\n  },\n  {\n    label: 'Escalation Intermediate Throw Event',\n    actionName: 'replace-with-escalation-intermediate-throw',\n    className: 'bpmn-icon-intermediate-event-throw-escalation',\n    target: {\n      type: 'bpmn:IntermediateThrowEvent',\n      eventDefinitionType: 'bpmn:EscalationEventDefinition'\n    }\n  },\n  {\n    label: 'Conditional Intermediate Catch Event',\n    actionName: 'replace-with-conditional-intermediate-catch',\n    className: 'bpmn-icon-intermediate-event-catch-condition',\n    target: {\n      type: 'bpmn:IntermediateCatchEvent',\n      eventDefinitionType: 'bpmn:ConditionalEventDefinition'\n    }\n  },\n  {\n    label: 'Link Intermediate Catch Event',\n    actionName: 'replace-with-link-intermediate-catch',\n    className: 'bpmn-icon-intermediate-event-catch-link',\n    target: {\n      type: 'bpmn:IntermediateCatchEvent',\n      eventDefinitionType: 'bpmn:LinkEventDefinition',\n      eventDefinitionAttrs: {\n        name: ''\n      }\n    }\n  },\n  {\n    label: 'Link Intermediate Throw Event',\n    actionName: 'replace-with-link-intermediate-throw',\n    className: 'bpmn-icon-intermediate-event-throw-link',\n    target: {\n      type: 'bpmn:IntermediateThrowEvent',\n      eventDefinitionType: 'bpmn:LinkEventDefinition',\n      eventDefinitionAttrs: {\n        name: ''\n      }\n    }\n  },\n  {\n    label: 'Compensation Intermediate Throw Event',\n    actionName: 'replace-with-compensation-intermediate-throw',\n    className: 'bpmn-icon-intermediate-event-throw-compensation',\n    target: {\n      type: 'bpmn:IntermediateThrowEvent',\n      eventDefinitionType: 'bpmn:CompensateEventDefinition'\n    }\n  },\n  {\n    label: 'Signal Intermediate Catch Event',\n    actionName: 'replace-with-signal-intermediate-catch',\n    className: 'bpmn-icon-intermediate-event-catch-signal',\n    target: {\n      type: 'bpmn:IntermediateCatchEvent',\n      eventDefinitionType: 'bpmn:SignalEventDefinition'\n    }\n  },\n  {\n    label: 'Signal Intermediate Throw Event',\n    actionName: 'replace-with-signal-intermediate-throw',\n    className: 'bpmn-icon-intermediate-event-throw-signal',\n    target: {\n      type: 'bpmn:IntermediateThrowEvent',\n      eventDefinitionType: 'bpmn:SignalEventDefinition'\n    }\n  }\n];\n\nvar END_EVENT = [\n  {\n    label: 'Start Event',\n    actionName: 'replace-with-none-start',\n    className: 'bpmn-icon-start-event-none',\n    target: {\n      type: 'bpmn:StartEvent'\n    }\n  },\n  {\n    label: 'Intermediate Throw Event',\n    actionName: 'replace-with-none-intermediate-throw',\n    className: 'bpmn-icon-intermediate-event-none',\n    target: {\n      type: 'bpmn:IntermediateThrowEvent'\n    }\n  },\n  {\n    label: 'End Event',\n    actionName: 'replace-with-none-end',\n    className: 'bpmn-icon-end-event-none',\n    target: {\n      type: 'bpmn:EndEvent'\n    }\n  },\n  {\n    label: 'Message End Event',\n    actionName: 'replace-with-message-end',\n    className: 'bpmn-icon-end-event-message',\n    target: {\n      type: 'bpmn:EndEvent',\n      eventDefinitionType: 'bpmn:MessageEventDefinition'\n    }\n  },\n  {\n    label: 'Escalation End Event',\n    actionName: 'replace-with-escalation-end',\n    className: 'bpmn-icon-end-event-escalation',\n    target: {\n      type: 'bpmn:EndEvent',\n      eventDefinitionType: 'bpmn:EscalationEventDefinition'\n    }\n  },\n  {\n    label: 'Error End Event',\n    actionName: 'replace-with-error-end',\n    className: 'bpmn-icon-end-event-error',\n    target: {\n      type: 'bpmn:EndEvent',\n      eventDefinitionType: 'bpmn:ErrorEventDefinition'\n    }\n  },\n  {\n    label: 'Cancel End Event',\n    actionName: 'replace-with-cancel-end',\n    className: 'bpmn-icon-end-event-cancel',\n    target: {\n      type: 'bpmn:EndEvent',\n      eventDefinitionType: 'bpmn:CancelEventDefinition'\n    }\n  },\n  {\n    label: 'Compensation End Event',\n    actionName: 'replace-with-compensation-end',\n    className: 'bpmn-icon-end-event-compensation',\n    target: {\n      type: 'bpmn:EndEvent',\n      eventDefinitionType: 'bpmn:CompensateEventDefinition'\n    }\n  },\n  {\n    label: 'Signal End Event',\n    actionName: 'replace-with-signal-end',\n    className: 'bpmn-icon-end-event-signal',\n    target: {\n      type: 'bpmn:EndEvent',\n      eventDefinitionType: 'bpmn:SignalEventDefinition'\n    }\n  },\n  {\n    label: 'Terminate End Event',\n    actionName: 'replace-with-terminate-end',\n    className: 'bpmn-icon-end-event-terminate',\n    target: {\n      type: 'bpmn:EndEvent',\n      eventDefinitionType: 'bpmn:TerminateEventDefinition'\n    }\n  }\n];\n\nvar GATEWAY = [\n  {\n    label: 'Exclusive Gateway',\n    actionName: 'replace-with-exclusive-gateway',\n    className: 'bpmn-icon-gateway-xor',\n    target: {\n      type: 'bpmn:ExclusiveGateway'\n    }\n  },\n  {\n    label: 'Parallel Gateway',\n    actionName: 'replace-with-parallel-gateway',\n    className: 'bpmn-icon-gateway-parallel',\n    target: {\n      type: 'bpmn:ParallelGateway'\n    }\n  },\n  {\n    label: 'Inclusive Gateway',\n    actionName: 'replace-with-inclusive-gateway',\n    className: 'bpmn-icon-gateway-or',\n    target: {\n      type: 'bpmn:InclusiveGateway'\n    }\n  },\n  {\n    label: 'Complex Gateway',\n    actionName: 'replace-with-complex-gateway',\n    className: 'bpmn-icon-gateway-complex',\n    target: {\n      type: 'bpmn:ComplexGateway'\n    }\n  },\n  {\n    label: 'Event based Gateway',\n    actionName: 'replace-with-event-based-gateway',\n    className: 'bpmn-icon-gateway-eventbased',\n    target: {\n      type: 'bpmn:EventBasedGateway',\n      instantiate: false,\n      eventGatewayType: 'Exclusive'\n    }\n  }\n\n  // Gateways deactivated until https://github.com/bpmn-io/bpmn-js/issues/194\n  // {\n  //   label: 'Event based instantiating Gateway',\n  //   actionName: 'replace-with-exclusive-event-based-gateway',\n  //   className: 'bpmn-icon-exclusive-event-based',\n  //   target: {\n  //     type: 'bpmn:EventBasedGateway'\n  //   },\n  //   options: {\n  //     businessObject: { instantiate: true, eventGatewayType: 'Exclusive' }\n  //   }\n  // },\n  // {\n  //   label: 'Parallel Event based instantiating Gateway',\n  //   actionName: 'replace-with-parallel-event-based-instantiate-gateway',\n  //   className: 'bpmn-icon-parallel-event-based-instantiate-gateway',\n  //   target: {\n  //     type: 'bpmn:EventBasedGateway'\n  //   },\n  //   options: {\n  //     businessObject: { instantiate: true, eventGatewayType: 'Parallel' }\n  //   }\n  // }\n];\n\nvar SUBPROCESS_EXPANDED = [\n  {\n    label: 'Transaction',\n    actionName: 'replace-with-transaction',\n    className: 'bpmn-icon-transaction',\n    target: {\n      type: 'bpmn:Transaction',\n      isExpanded: true\n    }\n  },\n  {\n    label: 'Event Sub Process',\n    actionName: 'replace-with-event-subprocess',\n    className: 'bpmn-icon-event-subprocess-expanded',\n    target: {\n      type: 'bpmn:SubProcess',\n      triggeredByEvent: true,\n      isExpanded: true\n    }\n  },\n  {\n    label: 'Sub Process (collapsed)',\n    actionName: 'replace-with-collapsed-subprocess',\n    className: 'bpmn-icon-subprocess-collapsed',\n    target: {\n      type: 'bpmn:SubProcess',\n      isExpanded: false\n    }\n  }\n];\n\nvar TRANSACTION = [\n  {\n    label: 'Transaction',\n    actionName: 'replace-with-transaction',\n    className: 'bpmn-icon-transaction',\n    target: {\n      type: 'bpmn:Transaction',\n      isExpanded: true\n    }\n  },\n  {\n    label: 'Sub Process',\n    actionName: 'replace-with-subprocess',\n    className: 'bpmn-icon-subprocess-expanded',\n    target: {\n      type: 'bpmn:SubProcess',\n      isExpanded: true\n    }\n  },\n  {\n    label: 'Event Sub Process',\n    actionName: 'replace-with-event-subprocess',\n    className: 'bpmn-icon-event-subprocess-expanded',\n    target: {\n      type: 'bpmn:SubProcess',\n      triggeredByEvent: true,\n      isExpanded: true\n    }\n  }\n];\n\nvar EVENT_SUB_PROCESS = TRANSACTION;\n\nvar TASK = [\n  {\n    label: 'Task',\n    actionName: 'replace-with-task',\n    className: 'bpmn-icon-task',\n    target: {\n      type: 'bpmn:Task'\n    }\n  },\n  {\n    label: 'Send Task',\n    actionName: 'replace-with-send-task',\n    className: 'bpmn-icon-send',\n    target: {\n      type: 'bpmn:SendTask'\n    }\n  },\n  {\n    label: 'Receive Task',\n    actionName: 'replace-with-receive-task',\n    className: 'bpmn-icon-receive',\n    target: {\n      type: 'bpmn:ReceiveTask'\n    }\n  },\n  {\n    label: 'User Task',\n    actionName: 'replace-with-user-task',\n    className: 'bpmn-icon-user',\n    target: {\n      type: 'bpmn:UserTask'\n    }\n  },\n  {\n    label: 'Manual Task',\n    actionName: 'replace-with-manual-task',\n    className: 'bpmn-icon-manual',\n    target: {\n      type: 'bpmn:ManualTask'\n    }\n  },\n  {\n    label: 'Business Rule Task',\n    actionName: 'replace-with-rule-task',\n    className: 'bpmn-icon-business-rule',\n    target: {\n      type: 'bpmn:BusinessRuleTask'\n    }\n  },\n  {\n    label: 'Service Task',\n    actionName: 'replace-with-service-task',\n    className: 'bpmn-icon-service',\n    target: {\n      type: 'bpmn:ServiceTask'\n    }\n  },\n  {\n    label: 'Script Task',\n    actionName: 'replace-with-script-task',\n    className: 'bpmn-icon-script',\n    target: {\n      type: 'bpmn:ScriptTask'\n    }\n  },\n  {\n    label: 'Call Activity',\n    actionName: 'replace-with-call-activity',\n    className: 'bpmn-icon-call-activity',\n    target: {\n      type: 'bpmn:CallActivity'\n    }\n  },\n  {\n    label: 'Sub Process (collapsed)',\n    actionName: 'replace-with-collapsed-subprocess',\n    className: 'bpmn-icon-subprocess-collapsed',\n    target: {\n      type: 'bpmn:SubProcess',\n      isExpanded: false\n    }\n  },\n  {\n    label: 'Sub Process (expanded)',\n    actionName: 'replace-with-expanded-subprocess',\n    className: 'bpmn-icon-subprocess-expanded',\n    target: {\n      type: 'bpmn:SubProcess',\n      isExpanded: true\n    }\n  }\n];\n\nvar DATA_OBJECT_REFERENCE = [\n  {\n    label: 'Data Store Reference',\n    actionName: 'replace-with-data-store-reference',\n    className: 'bpmn-icon-data-store',\n    target: {\n      type: 'bpmn:DataStoreReference'\n    }\n  }\n];\n\nvar DATA_STORE_REFERENCE = [\n  {\n    label: 'Data Object Reference',\n    actionName: 'replace-with-data-object-reference',\n    className: 'bpmn-icon-data-object',\n    target: {\n      type: 'bpmn:DataObjectReference'\n    }\n  }\n];\n\nvar BOUNDARY_EVENT = [\n  {\n    label: 'Message Boundary Event',\n    actionName: 'replace-with-message-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-message',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:MessageEventDefinition'\n    }\n  },\n  {\n    label: 'Timer Boundary Event',\n    actionName: 'replace-with-timer-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-timer',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:TimerEventDefinition'\n    }\n  },\n  {\n    label: 'Escalation Boundary Event',\n    actionName: 'replace-with-escalation-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-escalation',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:EscalationEventDefinition'\n    }\n  },\n  {\n    label: 'Conditional Boundary Event',\n    actionName: 'replace-with-conditional-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-condition',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:ConditionalEventDefinition'\n    }\n  },\n  {\n    label: 'Error Boundary Event',\n    actionName: 'replace-with-error-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-error',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:ErrorEventDefinition'\n    }\n  },\n  {\n    label: 'Cancel Boundary Event',\n    actionName: 'replace-with-cancel-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-cancel',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:CancelEventDefinition'\n    }\n  },\n  {\n    label: 'Signal Boundary Event',\n    actionName: 'replace-with-signal-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-signal',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:SignalEventDefinition'\n    }\n  },\n  {\n    label: 'Compensation Boundary Event',\n    actionName: 'replace-with-compensation-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-compensation',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:CompensateEventDefinition'\n    }\n  },\n  {\n    label: 'Message Boundary Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-message-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-non-interrupting-message',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:MessageEventDefinition',\n      cancelActivity: false\n    }\n  },\n  {\n    label: 'Timer Boundary Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-timer-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-non-interrupting-timer',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:TimerEventDefinition',\n      cancelActivity: false\n    }\n  },\n  {\n    label: 'Escalation Boundary Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-escalation-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-non-interrupting-escalation',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:EscalationEventDefinition',\n      cancelActivity: false\n    }\n  },\n  {\n    label: 'Conditional Boundary Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-conditional-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-non-interrupting-condition',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:ConditionalEventDefinition',\n      cancelActivity: false\n    }\n  },\n  {\n    label: 'Signal Boundary Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-signal-boundary',\n    className: 'bpmn-icon-intermediate-event-catch-non-interrupting-signal',\n    target: {\n      type: 'bpmn:BoundaryEvent',\n      eventDefinitionType: 'bpmn:SignalEventDefinition',\n      cancelActivity: false\n    }\n  }\n];\n\nvar EVENT_SUB_PROCESS_START_EVENT = [\n  {\n    label: 'Message Start Event',\n    actionName: 'replace-with-message-start',\n    className: 'bpmn-icon-start-event-message',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:MessageEventDefinition'\n    }\n  },\n  {\n    label: 'Timer Start Event',\n    actionName: 'replace-with-timer-start',\n    className: 'bpmn-icon-start-event-timer',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:TimerEventDefinition'\n    }\n  },\n  {\n    label: 'Conditional Start Event',\n    actionName: 'replace-with-conditional-start',\n    className: 'bpmn-icon-start-event-condition',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:ConditionalEventDefinition'\n    }\n  },\n  {\n    label: 'Signal Start Event',\n    actionName: 'replace-with-signal-start',\n    className: 'bpmn-icon-start-event-signal',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:SignalEventDefinition'\n    }\n  },\n  {\n    label: 'Error Start Event',\n    actionName: 'replace-with-error-start',\n    className: 'bpmn-icon-start-event-error',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:ErrorEventDefinition'\n    }\n  },\n  {\n    label: 'Escalation Start Event',\n    actionName: 'replace-with-escalation-start',\n    className: 'bpmn-icon-start-event-escalation',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:EscalationEventDefinition'\n    }\n  },\n  {\n    label: 'Compensation Start Event',\n    actionName: 'replace-with-compensation-start',\n    className: 'bpmn-icon-start-event-compensation',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:CompensateEventDefinition'\n    }\n  },\n  {\n    label: 'Message Start Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-message-start',\n    className: 'bpmn-icon-start-event-non-interrupting-message',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:MessageEventDefinition',\n      isInterrupting: false\n    }\n  },\n  {\n    label: 'Timer Start Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-timer-start',\n    className: 'bpmn-icon-start-event-non-interrupting-timer',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:TimerEventDefinition',\n      isInterrupting: false\n    }\n  },\n  {\n    label: 'Conditional Start Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-conditional-start',\n    className: 'bpmn-icon-start-event-non-interrupting-condition',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:ConditionalEventDefinition',\n      isInterrupting: false\n    }\n  },\n  {\n    label: 'Signal Start Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-signal-start',\n    className: 'bpmn-icon-start-event-non-interrupting-signal',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:SignalEventDefinition',\n      isInterrupting: false\n    }\n  },\n  {\n    label: 'Escalation Start Event (non-interrupting)',\n    actionName: 'replace-with-non-interrupting-escalation-start',\n    className: 'bpmn-icon-start-event-non-interrupting-escalation',\n    target: {\n      type: 'bpmn:StartEvent',\n      eventDefinitionType: 'bpmn:EscalationEventDefinition',\n      isInterrupting: false\n    }\n  }\n];\n\nvar SEQUENCE_FLOW = [\n  {\n    label: 'Sequence Flow',\n    actionName: 'replace-with-sequence-flow',\n    className: 'bpmn-icon-connection'\n  },\n  {\n    label: 'Default Flow',\n    actionName: 'replace-with-default-flow',\n    className: 'bpmn-icon-default-flow'\n  },\n  {\n    label: 'Conditional Flow',\n    actionName: 'replace-with-conditional-flow',\n    className: 'bpmn-icon-conditional-flow'\n  }\n];\n\nvar PARTICIPANT = [\n  {\n    label: 'Expanded Pool',\n    actionName: 'replace-with-expanded-pool',\n    className: 'bpmn-icon-participant',\n    target: {\n      type: 'bpmn:Participant',\n      isExpanded: true\n    }\n  },\n  {\n    label: function(element) {\n      var label = 'Empty Pool';\n\n      if (element.children && element.children.length) {\n        label += ' (removes content)';\n      }\n\n      return label;\n    },\n    actionName: 'replace-with-collapsed-pool',\n\n    // TODO(@janstuemmel): maybe design new icon\n    className: 'bpmn-icon-lane',\n    target: {\n      type: 'bpmn:Participant',\n      isExpanded: false\n    }\n  }\n];\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/popup-menu/ReplaceMenuProvider.js\n\n\n\n\n\n\n\n\n\n\n\n/**\n * This module is an element agnostic replace menu provider for the popup menu.\n */\nfunction ReplaceMenuProvider(\n    bpmnFactory, popupMenu, modeling, moddle,\n    bpmnReplace, rules, translate) {\n\n  this._bpmnFactory = bpmnFactory;\n  this._popupMenu = popupMenu;\n  this._modeling = modeling;\n  this._moddle = moddle;\n  this._bpmnReplace = bpmnReplace;\n  this._rules = rules;\n  this._translate = translate;\n\n  this.register();\n}\n\nReplaceMenuProvider.$inject = [\n  'bpmnFactory',\n  'popupMenu',\n  'modeling',\n  'moddle',\n  'bpmnReplace',\n  'rules',\n  'translate'\n];\n\n\n/**\n * Register replace menu provider in the popup menu\n */\nReplaceMenuProvider.prototype.register = function() {\n  this._popupMenu.registerProvider('bpmn-replace', this);\n};\n\n\n/**\n * Get all entries from replaceOptions for the given element and apply filters\n * on them. Get for example only elements, which are different from the current one.\n *\n * @param {djs.model.Base} element\n *\n * @return {Array<Object>} a list of menu entry items\n */\nReplaceMenuProvider.prototype.getEntries = function(element) {\n\n  var businessObject = element.businessObject;\n\n  var rules = this._rules;\n\n  var entries;\n\n  if (!rules.allowed('shape.replace', { element: element })) {\n    return [];\n  }\n\n  var differentType = isDifferentType(element);\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:DataObjectReference')) {\n    return this._createEntries(element, DATA_OBJECT_REFERENCE);\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:DataStoreReference') && !(0,ModelUtil.is)(element.parent, 'bpmn:Collaboration')) {\n    return this._createEntries(element, DATA_STORE_REFERENCE);\n  }\n\n  // start events outside sub processes\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:StartEvent') && !(0,ModelUtil.is)(businessObject.$parent, 'bpmn:SubProcess')) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(START_EVENT, differentType);\n\n    return this._createEntries(element, entries);\n  }\n\n  // expanded/collapsed pools\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Participant')) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(PARTICIPANT, function(entry) {\n      return (0,DiUtil/* isExpanded */.ul)(element) !== entry.target.isExpanded;\n    });\n\n    return this._createEntries(element, entries);\n  }\n\n  // start events inside event sub processes\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:StartEvent') && (0,DiUtil/* isEventSubProcess */.J5)(businessObject.$parent)) {\n    entries = (0,dist_index_esm/* filter */.hX)(EVENT_SUB_PROCESS_START_EVENT, function(entry) {\n\n      var target = entry.target;\n\n      var isInterrupting = target.isInterrupting !== false;\n\n      var isInterruptingEqual = (0,ModelUtil/* getBusinessObject */.SS)(element).isInterrupting === isInterrupting;\n\n      // filters elements which types and event definition are equal but have have different interrupting types\n      return differentType(entry) || !differentType(entry) && !isInterruptingEqual;\n\n    });\n\n    return this._createEntries(element, entries);\n  }\n\n  // start events inside sub processes\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:StartEvent') && !(0,DiUtil/* isEventSubProcess */.J5)(businessObject.$parent)\n      && (0,ModelUtil.is)(businessObject.$parent, 'bpmn:SubProcess')) {\n    entries = (0,dist_index_esm/* filter */.hX)(START_EVENT_SUB_PROCESS, differentType);\n\n    return this._createEntries(element, entries);\n  }\n\n  // end events\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:EndEvent')) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(END_EVENT, function(entry) {\n      var target = entry.target;\n\n      // hide cancel end events outside transactions\n      if (target.eventDefinitionType == 'bpmn:CancelEventDefinition' && !(0,ModelUtil.is)(businessObject.$parent, 'bpmn:Transaction')) {\n        return false;\n      }\n\n      return differentType(entry);\n    });\n\n    return this._createEntries(element, entries);\n  }\n\n  // boundary events\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:BoundaryEvent')) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(BOUNDARY_EVENT, function(entry) {\n\n      var target = entry.target;\n\n      if (target.eventDefinitionType == 'bpmn:CancelEventDefinition' &&\n         !(0,ModelUtil.is)(businessObject.attachedToRef, 'bpmn:Transaction')) {\n        return false;\n      }\n      var cancelActivity = target.cancelActivity !== false;\n\n      var isCancelActivityEqual = businessObject.cancelActivity == cancelActivity;\n\n      return differentType(entry) || !differentType(entry) && !isCancelActivityEqual;\n    });\n\n    return this._createEntries(element, entries);\n  }\n\n  // intermediate events\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:IntermediateCatchEvent') ||\n      (0,ModelUtil.is)(businessObject, 'bpmn:IntermediateThrowEvent')) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(INTERMEDIATE_EVENT, differentType);\n\n    return this._createEntries(element, entries);\n  }\n\n  // gateways\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Gateway')) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(GATEWAY, differentType);\n\n    return this._createEntries(element, entries);\n  }\n\n  // transactions\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Transaction')) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(TRANSACTION, differentType);\n\n    return this._createEntries(element, entries);\n  }\n\n  // expanded event sub processes\n  if ((0,DiUtil/* isEventSubProcess */.J5)(businessObject) && (0,DiUtil/* isExpanded */.ul)(element)) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(EVENT_SUB_PROCESS, differentType);\n\n    return this._createEntries(element, entries);\n  }\n\n  // expanded sub processes\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:SubProcess') && (0,DiUtil/* isExpanded */.ul)(element)) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(SUBPROCESS_EXPANDED, differentType);\n\n    return this._createEntries(element, entries);\n  }\n\n  // collapsed ad hoc sub processes\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:AdHocSubProcess') && !(0,DiUtil/* isExpanded */.ul)(element)) {\n\n    entries = (0,dist_index_esm/* filter */.hX)(TASK, function(entry) {\n\n      var target = entry.target;\n\n      var isTargetSubProcess = target.type === 'bpmn:SubProcess';\n\n      var isTargetExpanded = target.isExpanded === true;\n\n      return isDifferentType(element, target) && (!isTargetSubProcess || isTargetExpanded);\n    });\n\n    return this._createEntries(element, entries);\n  }\n\n  // sequence flows\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:SequenceFlow')) {\n    return this._createSequenceFlowEntries(element, SEQUENCE_FLOW);\n  }\n\n  // flow nodes\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:FlowNode')) {\n    entries = (0,dist_index_esm/* filter */.hX)(TASK, differentType);\n\n    // collapsed SubProcess can not be replaced with itself\n    if ((0,ModelUtil.is)(businessObject, 'bpmn:SubProcess') && !(0,DiUtil/* isExpanded */.ul)(element)) {\n      entries = (0,dist_index_esm/* filter */.hX)(entries, function(entry) {\n        return entry.label !== 'Sub Process (collapsed)';\n      });\n    }\n\n    return this._createEntries(element, entries);\n  }\n\n  return [];\n};\n\n\n/**\n * Get a list of header items for the given element. This includes buttons\n * for multi instance markers and for the ad hoc marker.\n *\n * @param {djs.model.Base} element\n *\n * @return {Array<Object>} a list of menu entry items\n */\nReplaceMenuProvider.prototype.getHeaderEntries = function(element) {\n\n  var headerEntries = [];\n\n  if ((0,ModelUtil.is)(element, 'bpmn:Activity') && !(0,DiUtil/* isEventSubProcess */.J5)(element)) {\n    headerEntries = headerEntries.concat(this._getLoopEntries(element));\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:DataObjectReference')) {\n    headerEntries = headerEntries.concat(this._getDataObjectIsCollection(element));\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:Participant')) {\n    headerEntries = headerEntries.concat(this._getParticipantMultiplicity(element));\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:SubProcess') &&\n      !(0,ModelUtil.is)(element, 'bpmn:Transaction') &&\n      !(0,DiUtil/* isEventSubProcess */.J5)(element)) {\n    headerEntries.push(this._getAdHocEntry(element));\n  }\n\n  return headerEntries;\n};\n\n\n/**\n * Creates an array of menu entry objects for a given element and filters the replaceOptions\n * according to a filter function.\n *\n * @param  {djs.model.Base} element\n * @param  {Object} replaceOptions\n *\n * @return {Array<Object>} a list of menu items\n */\nReplaceMenuProvider.prototype._createEntries = function(element, replaceOptions) {\n  var menuEntries = [];\n\n  var self = this;\n\n  (0,dist_index_esm/* forEach */.Ed)(replaceOptions, function(definition) {\n    var entry = self._createMenuEntry(definition, element);\n\n    menuEntries.push(entry);\n  });\n\n  return menuEntries;\n};\n\n/**\n * Creates an array of menu entry objects for a given sequence flow.\n *\n * @param  {djs.model.Base} element\n * @param  {Object} replaceOptions\n\n * @return {Array<Object>} a list of menu items\n */\nReplaceMenuProvider.prototype._createSequenceFlowEntries = function(element, replaceOptions) {\n\n  var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n  var menuEntries = [];\n\n  var modeling = this._modeling,\n      moddle = this._moddle;\n\n  var self = this;\n\n  (0,dist_index_esm/* forEach */.Ed)(replaceOptions, function(entry) {\n\n    switch (entry.actionName) {\n    case 'replace-with-default-flow':\n      if (businessObject.sourceRef.default !== businessObject &&\n            ((0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:ExclusiveGateway') ||\n             (0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:InclusiveGateway') ||\n             (0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:ComplexGateway') ||\n             (0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:Activity'))) {\n\n        menuEntries.push(self._createMenuEntry(entry, element, function() {\n          modeling.updateProperties(element.source, { default: businessObject });\n        }));\n      }\n      break;\n    case 'replace-with-conditional-flow':\n      if (!businessObject.conditionExpression && (0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:Activity')) {\n\n        menuEntries.push(self._createMenuEntry(entry, element, function() {\n          var conditionExpression = moddle.create('bpmn:FormalExpression', { body: '' });\n\n          modeling.updateProperties(element, { conditionExpression: conditionExpression });\n        }));\n      }\n      break;\n    default:\n\n      // default flows\n      if ((0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:Activity') && businessObject.conditionExpression) {\n        return menuEntries.push(self._createMenuEntry(entry, element, function() {\n          modeling.updateProperties(element, { conditionExpression: undefined });\n        }));\n      }\n\n      // conditional flows\n      if (((0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:ExclusiveGateway') ||\n           (0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:InclusiveGateway') ||\n           (0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:ComplexGateway') ||\n           (0,ModelUtil.is)(businessObject.sourceRef, 'bpmn:Activity')) &&\n           businessObject.sourceRef.default === businessObject) {\n\n        return menuEntries.push(self._createMenuEntry(entry, element, function() {\n          modeling.updateProperties(element.source, { default: undefined });\n        }));\n      }\n    }\n  });\n\n  return menuEntries;\n};\n\n\n/**\n * Creates and returns a single menu entry item.\n *\n * @param  {Object} definition a single replace options definition object\n * @param  {djs.model.Base} element\n * @param  {Function} [action] an action callback function which gets called when\n *                             the menu entry is being triggered.\n *\n * @return {Object} menu entry item\n */\nReplaceMenuProvider.prototype._createMenuEntry = function(definition, element, action) {\n  var translate = this._translate;\n  var replaceElement = this._bpmnReplace.replaceElement;\n\n  var replaceAction = function() {\n    return replaceElement(element, definition.target);\n  };\n\n  var label = definition.label;\n  if (label && typeof label === 'function') {\n    label = label(element);\n  }\n\n  action = action || replaceAction;\n\n  var menuEntry = {\n    label: translate(label),\n    className: definition.className,\n    id: definition.actionName,\n    action: action\n  };\n\n  return menuEntry;\n};\n\n/**\n * Get a list of menu items containing buttons for multi instance markers\n *\n * @param  {djs.model.Base} element\n *\n * @return {Array<Object>} a list of menu items\n */\nReplaceMenuProvider.prototype._getLoopEntries = function(element) {\n\n  var self = this;\n  var translate = this._translate;\n\n  function toggleLoopEntry(event, entry) {\n    var newLoopCharacteristics = (0,ModelUtil/* getBusinessObject */.SS)(element).loopCharacteristics;\n\n    if (entry.active) {\n      newLoopCharacteristics = undefined;\n    } else {\n      if ((0,dist_index_esm/* isUndefined */.o8)(entry.options.isSequential) || !newLoopCharacteristics\n      || !(0,ModelUtil.is)(newLoopCharacteristics, entry.options.loopCharacteristics)) {\n        newLoopCharacteristics = self._moddle.create(entry.options.loopCharacteristics);\n      }\n\n      newLoopCharacteristics.isSequential = entry.options.isSequential;\n    }\n    self._modeling.updateProperties(element, { loopCharacteristics: newLoopCharacteristics });\n  }\n\n  var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n      loopCharacteristics = businessObject.loopCharacteristics;\n\n  var isSequential,\n      isLoop,\n      isParallel;\n\n  if (loopCharacteristics) {\n    isSequential = loopCharacteristics.isSequential;\n    isLoop = loopCharacteristics.isSequential === undefined;\n    isParallel = loopCharacteristics.isSequential !== undefined && !loopCharacteristics.isSequential;\n  }\n\n\n  var loopEntries = [\n    {\n      id: 'toggle-parallel-mi',\n      className: 'bpmn-icon-parallel-mi-marker',\n      title: translate('Parallel Multi Instance'),\n      active: isParallel,\n      action: toggleLoopEntry,\n      options: {\n        loopCharacteristics: 'bpmn:MultiInstanceLoopCharacteristics',\n        isSequential: false\n      }\n    },\n    {\n      id: 'toggle-sequential-mi',\n      className: 'bpmn-icon-sequential-mi-marker',\n      title: translate('Sequential Multi Instance'),\n      active: isSequential,\n      action: toggleLoopEntry,\n      options: {\n        loopCharacteristics: 'bpmn:MultiInstanceLoopCharacteristics',\n        isSequential: true\n      }\n    },\n    {\n      id: 'toggle-loop',\n      className: 'bpmn-icon-loop-marker',\n      title: translate('Loop'),\n      active: isLoop,\n      action: toggleLoopEntry,\n      options: {\n        loopCharacteristics: 'bpmn:StandardLoopCharacteristics'\n      }\n    }\n  ];\n  return loopEntries;\n};\n\n/**\n * Get a list of menu items containing a button for the collection marker\n *\n * @param  {djs.model.Base} element\n *\n * @return {Array<Object>} a list of menu items\n */\nReplaceMenuProvider.prototype._getDataObjectIsCollection = function(element) {\n\n  var self = this;\n  var translate = this._translate;\n\n  function toggleIsCollection(event, entry) {\n    self._modeling.updateModdleProperties(\n      element,\n      dataObject,\n      { isCollection: !entry.active });\n  }\n\n  var dataObject = element.businessObject.dataObjectRef,\n      isCollection = dataObject.isCollection;\n\n  var dataObjectEntries = [\n    {\n      id: 'toggle-is-collection',\n      className: 'bpmn-icon-parallel-mi-marker',\n      title: translate('Collection'),\n      active: isCollection,\n      action: toggleIsCollection,\n    }\n  ];\n  return dataObjectEntries;\n};\n\n/**\n * Get a list of menu items containing a button for the participant multiplicity marker\n *\n * @param  {djs.model.Base} element\n *\n * @return {Array<Object>} a list of menu items\n */\nReplaceMenuProvider.prototype._getParticipantMultiplicity = function(element) {\n\n  var self = this;\n  var bpmnFactory = this._bpmnFactory;\n  var translate = this._translate;\n\n  function toggleParticipantMultiplicity(event, entry) {\n    var isActive = entry.active;\n    var participantMultiplicity;\n\n    if (!isActive) {\n      participantMultiplicity = bpmnFactory.create('bpmn:ParticipantMultiplicity');\n    }\n\n    self._modeling.updateProperties(\n      element,\n      { participantMultiplicity: participantMultiplicity });\n  }\n\n  var participantMultiplicity = element.businessObject.participantMultiplicity;\n\n  var participantEntries = [\n    {\n      id: 'toggle-participant-multiplicity',\n      className: 'bpmn-icon-parallel-mi-marker',\n      title: translate('Participant Multiplicity'),\n      active: !!participantMultiplicity,\n      action: toggleParticipantMultiplicity,\n    }\n  ];\n  return participantEntries;\n};\n\n\n/**\n * Get the menu items containing a button for the ad hoc marker\n *\n * @param  {djs.model.Base} element\n *\n * @return {Object} a menu item\n */\nReplaceMenuProvider.prototype._getAdHocEntry = function(element) {\n  var translate = this._translate;\n  var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n  var isAdHoc = (0,ModelUtil.is)(businessObject, 'bpmn:AdHocSubProcess');\n\n  var replaceElement = this._bpmnReplace.replaceElement;\n\n  var adHocEntry = {\n    id: 'toggle-adhoc',\n    className: 'bpmn-icon-ad-hoc-marker',\n    title: translate('Ad-hoc'),\n    active: isAdHoc,\n    action: function(event, entry) {\n      if (isAdHoc) {\n        return replaceElement(element, { type: 'bpmn:SubProcess' }, {\n          autoResize: false,\n          layoutConnection: false\n        });\n      } else {\n        return replaceElement(element, { type: 'bpmn:AdHocSubProcess' }, {\n          autoResize: false,\n          layoutConnection: false\n        });\n      }\n    }\n  };\n\n  return adHocEntry;\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/popup-menu/index.js\n\n\n\n\n\n\n/* harmony default export */ const features_popup_menu = ({\n  __depends__: [\n    popup_menu/* default */.Z,\n    features_replace\n  ],\n  __init__: [ 'replaceMenuProvider' ],\n  replaceMenuProvider: [ 'type', ReplaceMenuProvider ]\n});\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/features/modeling/util/ModelingUtil.js\nvar ModelingUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/features/modeling/util/ModelingUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/resize/ResizeUtil.js\nvar ResizeUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/resize/ResizeUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/util/LaneUtil.js\n\n\n\n\n\n\n\n\nvar abs = Math.abs;\n\n\nfunction getTRBLResize(oldBounds, newBounds) {\n  return (0,ResizeUtil/* substractTRBL */._P)((0,LayoutUtil/* asTRBL */.JA)(newBounds), (0,LayoutUtil/* asTRBL */.JA)(oldBounds));\n}\n\n\nvar LANE_PARENTS = [\n  'bpmn:Participant',\n  'bpmn:Process',\n  'bpmn:SubProcess'\n];\n\nvar LANE_INDENTATION = 30;\n\n\n/**\n * Collect all lane shapes in the given paren\n *\n * @param  {djs.model.Shape} shape\n * @param  {Array<djs.model.Base>} [collectedShapes]\n *\n * @return {Array<djs.model.Base>}\n */\nfunction collectLanes(shape, collectedShapes) {\n\n  collectedShapes = collectedShapes || [];\n\n  shape.children.filter(function(s) {\n    if ((0,ModelUtil.is)(s, 'bpmn:Lane')) {\n      collectLanes(s, collectedShapes);\n\n      collectedShapes.push(s);\n    }\n  });\n\n  return collectedShapes;\n}\n\n\n/**\n * Return the lane children of the given element.\n *\n * @param {djs.model.Shape} shape\n *\n * @return {Array<djs.model.Shape>}\n */\nfunction getChildLanes(shape) {\n  return shape.children.filter(function(c) {\n    return (0,ModelUtil.is)(c, 'bpmn:Lane');\n  });\n}\n\n\n/**\n * Return the root element containing the given lane shape\n *\n * @param {djs.model.Shape} shape\n *\n * @return {djs.model.Shape}\n */\nfunction getLanesRoot(shape) {\n  return (0,ModelingUtil/* getParent */.G)(shape, LANE_PARENTS) || shape;\n}\n\n\n/**\n * Compute the required resize operations for lanes\n * adjacent to the given shape, assuming it will be\n * resized to the given new bounds.\n *\n * @param {djs.model.Shape} shape\n * @param {Bounds} newBounds\n *\n * @return {Array<Object>}\n */\nfunction computeLanesResize(shape, newBounds) {\n\n  var rootElement = getLanesRoot(shape);\n\n  var initialShapes = (0,ModelUtil.is)(rootElement, 'bpmn:Process') ? [] : [ rootElement ];\n\n  var allLanes = collectLanes(rootElement, initialShapes),\n      shapeTrbl = (0,LayoutUtil/* asTRBL */.JA)(shape),\n      shapeNewTrbl = (0,LayoutUtil/* asTRBL */.JA)(newBounds),\n      trblResize = getTRBLResize(shape, newBounds),\n      resizeNeeded = [];\n\n  allLanes.forEach(function(other) {\n\n    if (other === shape) {\n      return;\n    }\n\n    var topResize = 0,\n        rightResize = trblResize.right,\n        bottomResize = 0,\n        leftResize = trblResize.left;\n\n    var otherTrbl = (0,LayoutUtil/* asTRBL */.JA)(other);\n\n    if (trblResize.top) {\n      if (abs(otherTrbl.bottom - shapeTrbl.top) < 10) {\n        bottomResize = shapeNewTrbl.top - otherTrbl.bottom;\n      }\n\n      if (abs(otherTrbl.top - shapeTrbl.top) < 5) {\n        topResize = shapeNewTrbl.top - otherTrbl.top;\n      }\n    }\n\n    if (trblResize.bottom) {\n      if (abs(otherTrbl.top - shapeTrbl.bottom) < 10) {\n        topResize = shapeNewTrbl.bottom - otherTrbl.top;\n      }\n\n      if (abs(otherTrbl.bottom - shapeTrbl.bottom) < 5) {\n        bottomResize = shapeNewTrbl.bottom - otherTrbl.bottom;\n      }\n    }\n\n    if (topResize || rightResize || bottomResize || leftResize) {\n\n      resizeNeeded.push({\n        shape: other,\n        newBounds: (0,ResizeUtil/* resizeTRBL */.dR)(other, {\n          top: topResize,\n          right: rightResize,\n          bottom: bottomResize,\n          left: leftResize\n        })\n      });\n    }\n\n  });\n\n  return resizeNeeded;\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Mouse.js + 1 modules\nvar Mouse = __webpack_require__(\"./node_modules/diagram-js/lib/util/Mouse.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/context-pad/ContextPadProvider.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A provider for BPMN 2.0 elements context pad\n */\nfunction ContextPadProvider(\n    config, injector, eventBus,\n    contextPad, modeling, elementFactory,\n    connect, create, popupMenu,\n    canvas, rules, translate) {\n\n  config = config || {};\n\n  contextPad.registerProvider(this);\n\n  this._contextPad = contextPad;\n\n  this._modeling = modeling;\n\n  this._elementFactory = elementFactory;\n  this._connect = connect;\n  this._create = create;\n  this._popupMenu = popupMenu;\n  this._canvas = canvas;\n  this._rules = rules;\n  this._translate = translate;\n\n  if (config.autoPlace !== false) {\n    this._autoPlace = injector.get('autoPlace', false);\n  }\n\n  eventBus.on('create.end', 250, function(event) {\n    var context = event.context,\n        shape = context.shape;\n\n    if (!(0,Mouse/* hasPrimaryModifier */.RJ)(event) || !contextPad.isOpen(shape)) {\n      return;\n    }\n\n    var entries = contextPad.getEntries(shape);\n\n    if (entries.replace) {\n      entries.replace.action.click(event, shape);\n    }\n  });\n}\n\nContextPadProvider.$inject = [\n  'config.contextPad',\n  'injector',\n  'eventBus',\n  'contextPad',\n  'modeling',\n  'elementFactory',\n  'connect',\n  'create',\n  'popupMenu',\n  'canvas',\n  'rules',\n  'translate'\n];\n\nContextPadProvider.prototype.getMultiElementContextPadEntries = function(elements) {\n  var modeling = this._modeling;\n\n  var actions = {};\n\n  if (this._isDeleteAllowed(elements)) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'delete': {\n        group: 'edit',\n        className: 'bpmn-icon-trash',\n        title: this._translate('Remove'),\n        action: {\n          click: function(event, elements) {\n            modeling.removeElements(elements.slice());\n          }\n        }\n      }\n    });\n  }\n\n  return actions;\n};\n\n/**\n * @param {djs.model.Base[]} elements\n * @return {boolean}\n */\nContextPadProvider.prototype._isDeleteAllowed = function(elements) {\n\n  var baseAllowed = this._rules.allowed('elements.delete', {\n    elements: elements\n  });\n\n  if ((0,dist_index_esm/* isArray */.kJ)(baseAllowed)) {\n    return (0,dist_index_esm/* every */.yW)(baseAllowed, function(element) {\n      return includes(baseAllowed, element);\n    });\n  }\n\n  return baseAllowed;\n};\n\nContextPadProvider.prototype.getContextPadEntries = function(element) {\n  var contextPad = this._contextPad,\n      modeling = this._modeling,\n\n      elementFactory = this._elementFactory,\n      connect = this._connect,\n      create = this._create,\n      popupMenu = this._popupMenu,\n      rules = this._rules,\n      autoPlace = this._autoPlace,\n      translate = this._translate;\n\n  var actions = {};\n\n  if (element.type === 'label') {\n    return actions;\n  }\n\n  var businessObject = element.businessObject;\n\n  function startConnect(event, element) {\n    connect.start(event, element);\n  }\n\n  function removeElement(e, element) {\n    modeling.removeElements([ element ]);\n  }\n\n  function getReplaceMenuPosition(element) {\n\n    var Y_OFFSET = 5;\n\n    var pad = contextPad.getPad(element).html;\n\n    var padRect = pad.getBoundingClientRect();\n\n    var pos = {\n      x: padRect.left,\n      y: padRect.bottom + Y_OFFSET\n    };\n\n    return pos;\n  }\n\n\n  /**\n   * Create an append action\n   *\n   * @param {string} type\n   * @param {string} className\n   * @param {string} [title]\n   * @param {Object} [options]\n   *\n   * @return {Object} descriptor\n   */\n  function appendAction(type, className, title, options) {\n\n    if (typeof title !== 'string') {\n      options = title;\n      title = translate('Append {type}', { type: type.replace(/^bpmn:/, '') });\n    }\n\n    function appendStart(event, element) {\n\n      var shape = elementFactory.createShape((0,dist_index_esm/* assign */.f0)({ type: type }, options));\n      create.start(event, shape, {\n        source: element\n      });\n    }\n\n\n    var append = autoPlace ? function(event, element) {\n      var shape = elementFactory.createShape((0,dist_index_esm/* assign */.f0)({ type: type }, options));\n\n      autoPlace.append(element, shape);\n    } : appendStart;\n\n\n    return {\n      group: 'model',\n      className: className,\n      title: title,\n      action: {\n        dragstart: appendStart,\n        click: append\n      }\n    };\n  }\n\n  function splitLaneHandler(count) {\n\n    return function(event, element) {\n\n      // actual split\n      modeling.splitLane(element, count);\n\n      // refresh context pad after split to\n      // get rid of split icons\n      contextPad.open(element, true);\n    };\n  }\n\n\n  if ((0,ModelUtil/* isAny */.JZ)(businessObject, [ 'bpmn:Lane', 'bpmn:Participant' ]) && (0,DiUtil/* isExpanded */.ul)(element)) {\n\n    var childLanes = getChildLanes(element);\n\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'lane-insert-above': {\n        group: 'lane-insert-above',\n        className: 'bpmn-icon-lane-insert-above',\n        title: translate('Add Lane above'),\n        action: {\n          click: function(event, element) {\n            modeling.addLane(element, 'top');\n          }\n        }\n      }\n    });\n\n    if (childLanes.length < 2) {\n\n      if (element.height >= 120) {\n        (0,dist_index_esm/* assign */.f0)(actions, {\n          'lane-divide-two': {\n            group: 'lane-divide',\n            className: 'bpmn-icon-lane-divide-two',\n            title: translate('Divide into two Lanes'),\n            action: {\n              click: splitLaneHandler(2)\n            }\n          }\n        });\n      }\n\n      if (element.height >= 180) {\n        (0,dist_index_esm/* assign */.f0)(actions, {\n          'lane-divide-three': {\n            group: 'lane-divide',\n            className: 'bpmn-icon-lane-divide-three',\n            title: translate('Divide into three Lanes'),\n            action: {\n              click: splitLaneHandler(3)\n            }\n          }\n        });\n      }\n    }\n\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'lane-insert-below': {\n        group: 'lane-insert-below',\n        className: 'bpmn-icon-lane-insert-below',\n        title: translate('Add Lane below'),\n        action: {\n          click: function(event, element) {\n            modeling.addLane(element, 'bottom');\n          }\n        }\n      }\n    });\n\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:FlowNode')) {\n\n    if ((0,ModelUtil.is)(businessObject, 'bpmn:EventBasedGateway')) {\n\n      (0,dist_index_esm/* assign */.f0)(actions, {\n        'append.receive-task': appendAction(\n          'bpmn:ReceiveTask',\n          'bpmn-icon-receive-task',\n          translate('Append ReceiveTask')\n        ),\n        'append.message-intermediate-event': appendAction(\n          'bpmn:IntermediateCatchEvent',\n          'bpmn-icon-intermediate-event-catch-message',\n          translate('Append MessageIntermediateCatchEvent'),\n          { eventDefinitionType: 'bpmn:MessageEventDefinition' }\n        ),\n        'append.timer-intermediate-event': appendAction(\n          'bpmn:IntermediateCatchEvent',\n          'bpmn-icon-intermediate-event-catch-timer',\n          translate('Append TimerIntermediateCatchEvent'),\n          { eventDefinitionType: 'bpmn:TimerEventDefinition' }\n        ),\n        'append.condition-intermediate-event': appendAction(\n          'bpmn:IntermediateCatchEvent',\n          'bpmn-icon-intermediate-event-catch-condition',\n          translate('Append ConditionIntermediateCatchEvent'),\n          { eventDefinitionType: 'bpmn:ConditionalEventDefinition' }\n        ),\n        'append.signal-intermediate-event': appendAction(\n          'bpmn:IntermediateCatchEvent',\n          'bpmn-icon-intermediate-event-catch-signal',\n          translate('Append SignalIntermediateCatchEvent'),\n          { eventDefinitionType: 'bpmn:SignalEventDefinition' }\n        )\n      });\n    } else\n\n    if (isEventType(businessObject, 'bpmn:BoundaryEvent', 'bpmn:CompensateEventDefinition')) {\n\n      (0,dist_index_esm/* assign */.f0)(actions, {\n        'append.compensation-activity':\n            appendAction(\n              'bpmn:Task',\n              'bpmn-icon-task',\n              translate('Append compensation activity'),\n              {\n                isForCompensation: true\n              }\n            )\n      });\n    } else\n\n    if (!(0,ModelUtil.is)(businessObject, 'bpmn:EndEvent') &&\n        !businessObject.isForCompensation &&\n        !isEventType(businessObject, 'bpmn:IntermediateThrowEvent', 'bpmn:LinkEventDefinition') &&\n        !(0,DiUtil/* isEventSubProcess */.J5)(businessObject)) {\n\n      (0,dist_index_esm/* assign */.f0)(actions, {\n        'append.end-event': appendAction(\n          'bpmn:EndEvent',\n          'bpmn-icon-end-event-none',\n          translate('Append EndEvent')\n        ),\n        'append.gateway': appendAction(\n          'bpmn:ExclusiveGateway',\n          'bpmn-icon-gateway-none',\n          translate('Append Gateway')\n        ),\n        'append.append-task': appendAction(\n          'bpmn:Task',\n          'bpmn-icon-task',\n          translate('Append Task')\n        ),\n        'append.intermediate-event': appendAction(\n          'bpmn:IntermediateThrowEvent',\n          'bpmn-icon-intermediate-event-none',\n          translate('Append Intermediate/Boundary Event')\n        )\n      });\n    }\n  }\n\n  if (!popupMenu.isEmpty(element, 'bpmn-replace')) {\n\n    // Replace menu entry\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'replace': {\n        group: 'edit',\n        className: 'bpmn-icon-screw-wrench',\n        title: translate('Change type'),\n        action: {\n          click: function(event, element) {\n\n            var position = (0,dist_index_esm/* assign */.f0)(getReplaceMenuPosition(element), {\n              cursor: { x: event.x, y: event.y }\n            });\n\n            popupMenu.open(element, 'bpmn-replace', position, {\n              title: translate('Change element'),\n              width: 300,\n              search: true\n            });\n          }\n        }\n      }\n    });\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:SequenceFlow')) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'append.text-annotation': appendAction(\n        'bpmn:TextAnnotation',\n        'bpmn-icon-text-annotation'\n      )\n    });\n  }\n\n  if (\n    (0,ModelUtil/* isAny */.JZ)(businessObject, [\n      'bpmn:FlowNode',\n      'bpmn:InteractionNode',\n      'bpmn:DataObjectReference',\n      'bpmn:DataStoreReference',\n    ])\n  ) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'append.text-annotation': appendAction(\n        'bpmn:TextAnnotation',\n        'bpmn-icon-text-annotation'\n      ),\n\n      'connect': {\n        group: 'connect',\n        className: 'bpmn-icon-connection-multi',\n        title: translate(\n          'Connect using ' +\n            (businessObject.isForCompensation\n              ? ''\n              : 'Sequence/MessageFlow or ') +\n            'Association'\n        ),\n        action: {\n          click: startConnect,\n          dragstart: startConnect,\n        },\n      },\n    });\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:TextAnnotation')) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'connect': {\n        group: 'connect',\n        className: 'bpmn-icon-connection-multi',\n        title: translate('Connect using Association'),\n        action: {\n          click: startConnect,\n          dragstart: startConnect,\n        },\n      },\n    });\n  }\n\n  if ((0,ModelUtil/* isAny */.JZ)(businessObject, [ 'bpmn:DataObjectReference', 'bpmn:DataStoreReference' ])) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'connect': {\n        group: 'connect',\n        className: 'bpmn-icon-connection-multi',\n        title: translate('Connect using DataInputAssociation'),\n        action: {\n          click: startConnect,\n          dragstart: startConnect\n        }\n      }\n    });\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Group')) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'append.text-annotation': appendAction('bpmn:TextAnnotation', 'bpmn-icon-text-annotation')\n    });\n  }\n\n  // delete element entry, only show if allowed by rules\n  var deleteAllowed = rules.allowed('elements.delete', { elements: [ element ] });\n\n  if ((0,dist_index_esm/* isArray */.kJ)(deleteAllowed)) {\n\n    // was the element returned as a deletion candidate?\n    deleteAllowed = deleteAllowed[0] === element;\n  }\n\n  if (deleteAllowed) {\n    (0,dist_index_esm/* assign */.f0)(actions, {\n      'delete': {\n        group: 'edit',\n        className: 'bpmn-icon-trash',\n        title: translate('Remove'),\n        action: {\n          click: removeElement\n        }\n      }\n    });\n  }\n\n  return actions;\n};\n\n\n// helpers /////////\n\nfunction isEventType(eventBo, type, definition) {\n\n  var isType = eventBo.$instanceOf(type);\n  var isDefinition = false;\n\n  var definitions = eventBo.eventDefinitions || [];\n  (0,dist_index_esm/* forEach */.Ed)(definitions, function(def) {\n    if (def.$type === definition) {\n      isDefinition = true;\n    }\n  });\n\n  return isType && isDefinition;\n}\n\nfunction includes(array, item) {\n  return array.indexOf(item) !== -1;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/context-pad/index.js\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const features_context_pad = ({\n  __depends__: [\n    diagram_js_direct_editing/* default */.Z,\n    context_pad/* default */.Z,\n    selection/* default */.Z,\n    connect/* default */.Z,\n    create/* default */.Z,\n    features_popup_menu\n  ],\n  __init__: [ 'contextPadProvider' ],\n  contextPadProvider: [ 'type', ContextPadProvider ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/distribute-elements/index.js + 1 modules\nvar distribute_elements = __webpack_require__(\"./node_modules/diagram-js/lib/features/distribute-elements/index.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/distribute-elements/BpmnDistributeElements.js\n\n\n\n\n\n\n\n\n\n\n/**\n * Registers element exclude filters for elements that\n * currently do not support distribution.\n */\nfunction BpmnDistributeElements(distributeElements, eventBus, rules) {\n  RuleProvider/* default.call */.Z.call(this, eventBus);\n}\n\nBpmnDistributeElements.$inject = [ 'distributeElements', 'eventBus', 'rules' ];\n\n(0,index_es/* default */.Z)(BpmnDistributeElements, RuleProvider/* default */.Z);\n\nBpmnDistributeElements.prototype.init = function() {\n  this.addRule('elements.distribute', function(context) {\n    var elements = context.elements;\n\n    elements = (0,dist_index_esm/* filter */.hX)(elements, function(element) {\n      var cannotDistribute = (0,ModelUtil/* isAny */.JZ)(element, [\n        'bpmn:Association',\n        'bpmn:BoundaryEvent',\n        'bpmn:DataInputAssociation',\n        'bpmn:DataOutputAssociation',\n        'bpmn:Lane',\n        'bpmn:MessageFlow',\n        'bpmn:SequenceFlow',\n        'bpmn:TextAnnotation'\n      ]);\n\n      return !(element.labelTarget || cannotDistribute);\n    });\n\n    // filter out elements which are children of any of the selected elements\n    elements = (0,Elements/* getParents */.cd)(elements);\n\n    if (elements.length < 3) {\n      return false;\n    }\n\n    return elements;\n  });\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/distribute-elements/DistributeElementsIcons.js\n/**\n * To change the icons, modify the SVGs in `./resources`, execute `npx svgo -f resources --datauri enc -o dist`,\n * and then replace respective icons with the optimized data URIs in `./dist`.\n */\nvar DistributeElementsIcons_icons = {\n  horizontal: 'data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%201800%201800%22%3E%3Cpath%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bstroke-linejoin%3Around%22%20d%3D%22M450%20400V150h900v250%22%2F%3E%3Crect%20x%3D%22150%22%20y%3D%22450%22%20width%3D%22600%22%20height%3D%221200%22%20rx%3D%221%22%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%22%2F%3E%3Crect%20x%3D%221050%22%20y%3D%22450%22%20width%3D%22600%22%20height%3D%22800%22%20rx%3D%221%22%20style%3D%22fill%3AcurrentColor%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bopacity%3A.5%22%2F%3E%3C%2Fsvg%3E',\n  vertical: 'data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%201800%201800%22%3E%3Cpath%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bstroke-linejoin%3Around%22%20d%3D%22M400%201350H150V450h250%22%2F%3E%3Crect%20x%3D%22450%22%20y%3D%22150%22%20width%3D%221200%22%20height%3D%22600%22%20rx%3D%221%22%20style%3D%22fill%3Anone%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%22%2F%3E%3Crect%20x%3D%22450%22%20y%3D%221050%22%20width%3D%22800%22%20height%3D%22600%22%20rx%3D%221%22%20style%3D%22fill%3AcurrentColor%3Bstroke%3AcurrentColor%3Bstroke-width%3A100%3Bopacity%3A.5%22%2F%3E%3C%2Fsvg%3E',\n};\n\n/* harmony default export */ const DistributeElementsIcons = (DistributeElementsIcons_icons);\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/distribute-elements/DistributeElementsMenuProvider.js\n\n\n\n\nvar DistributeElementsMenuProvider_LOW_PRIORITY = 900;\n\n/**\n * A provider for distribute elements popup menu.\n */\nfunction DistributeElementsMenuProvider(\n    popupMenu, distributeElements, translate, rules) {\n  this._distributeElements = distributeElements;\n  this._translate = translate;\n  this._popupMenu = popupMenu;\n  this._rules = rules;\n\n  popupMenu.registerProvider('align-elements', DistributeElementsMenuProvider_LOW_PRIORITY, this);\n}\n\nDistributeElementsMenuProvider.$inject = [\n  'popupMenu',\n  'distributeElements',\n  'translate',\n  'rules'\n];\n\nDistributeElementsMenuProvider.prototype.getPopupMenuEntries = function(elements) {\n  var entries = {};\n\n  if (this._isAllowed(elements)) {\n    (0,dist_index_esm/* assign */.f0)(entries, this._getEntries(elements));\n  }\n\n  return entries;\n};\n\nDistributeElementsMenuProvider.prototype._isAllowed = function(elements) {\n  return this._rules.allowed('elements.distribute', { elements: elements });\n};\n\nDistributeElementsMenuProvider.prototype._getEntries = function(elements) {\n  var distributeElements = this._distributeElements,\n      translate = this._translate,\n      popupMenu = this._popupMenu;\n\n  var entries = {\n    'distribute-elements-horizontal': {\n      group: 'distribute',\n      title: translate('Distribute elements horizontally'),\n      className: 'bjs-align-elements-menu-entry',\n      imageUrl: DistributeElementsIcons.horizontal,\n      action: function(event, entry) {\n        distributeElements.trigger(elements, 'horizontal');\n        popupMenu.close();\n      }\n    },\n    'distribute-elements-vertical': {\n      group: 'distribute',\n      title: translate('Distribute elements vertically'),\n      imageUrl: DistributeElementsIcons.vertical,\n      action: function(event, entry) {\n        distributeElements.trigger(elements, 'vertical');\n        popupMenu.close();\n      }\n    },\n  };\n\n  return entries;\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/distribute-elements/index.js\n\n\n\n\n\n\n\n/* harmony default export */ const features_distribute_elements = ({\n  __depends__: [\n    popup_menu/* default */.Z,\n    distribute_elements/* default */.Z\n  ],\n  __init__: [\n    'bpmnDistributeElements',\n    'distributeElementsMenuProvider'\n  ],\n  bpmnDistributeElements: [ 'type', BpmnDistributeElements ],\n  distributeElementsMenuProvider: [ 'type', DistributeElementsMenuProvider ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/editor-actions/index.js\nvar editor_actions = __webpack_require__(\"./node_modules/diagram-js/lib/features/editor-actions/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/editor-actions/EditorActions.js\nvar EditorActions = __webpack_require__(\"./node_modules/diagram-js/lib/features/editor-actions/EditorActions.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/editor-actions/BpmnEditorActions.js\n\n\n\n\n\n\n\n\n\n\n\n/**\n * Registers and executes BPMN specific editor actions.\n *\n * @param {Injector} injector\n */\nfunction BpmnEditorActions(injector) {\n  injector.invoke(EditorActions/* default */.Z, this);\n}\n\n(0,index_es/* default */.Z)(BpmnEditorActions, EditorActions/* default */.Z);\n\nBpmnEditorActions.$inject = [\n  'injector'\n];\n\n/**\n * Register default actions.\n *\n * @param {Injector} injector\n */\nBpmnEditorActions.prototype._registerDefaultActions = function(injector) {\n\n  // (0) invoke super method\n\n  EditorActions/* default.prototype._registerDefaultActions.call */.Z.prototype._registerDefaultActions.call(this, injector);\n\n  // (1) retrieve optional components to integrate with\n\n  var canvas = injector.get('canvas', false);\n  var elementRegistry = injector.get('elementRegistry', false);\n  var selection = injector.get('selection', false);\n  var spaceTool = injector.get('spaceTool', false);\n  var lassoTool = injector.get('lassoTool', false);\n  var handTool = injector.get('handTool', false);\n  var globalConnect = injector.get('globalConnect', false);\n  var distributeElements = injector.get('distributeElements', false);\n  var alignElements = injector.get('alignElements', false);\n  var directEditing = injector.get('directEditing', false);\n  var searchPad = injector.get('searchPad', false);\n  var modeling = injector.get('modeling', false);\n  var contextPad = injector.get('contextPad', false);\n\n  // (2) check components and register actions\n\n  if (canvas && elementRegistry && selection) {\n    this._registerAction('selectElements', function() {\n\n      // select all elements except for the invisible\n      // root element\n      var rootElement = canvas.getRootElement();\n\n      var elements = elementRegistry.filter(function(element) {\n        return element !== rootElement;\n      });\n\n      selection.select(elements);\n\n      return elements;\n    });\n  }\n\n  if (spaceTool) {\n    this._registerAction('spaceTool', function() {\n      spaceTool.toggle();\n    });\n  }\n\n  if (lassoTool) {\n    this._registerAction('lassoTool', function() {\n      lassoTool.toggle();\n    });\n  }\n\n  if (handTool) {\n    this._registerAction('handTool', function() {\n      handTool.toggle();\n    });\n  }\n\n  if (globalConnect) {\n    this._registerAction('globalConnectTool', function() {\n      globalConnect.toggle();\n    });\n  }\n\n  if (selection && distributeElements) {\n    this._registerAction('distributeElements', function(opts) {\n      var currentSelection = selection.get(),\n          type = opts.type;\n\n      if (currentSelection.length) {\n        distributeElements.trigger(currentSelection, type);\n      }\n    });\n  }\n\n  if (selection && alignElements) {\n    this._registerAction('alignElements', function(opts) {\n      var currentSelection = selection.get(),\n          aligneableElements = [],\n          type = opts.type;\n\n      if (currentSelection.length) {\n        aligneableElements = (0,dist_index_esm/* filter */.hX)(currentSelection, function(element) {\n          return !(0,ModelUtil.is)(element, 'bpmn:Lane');\n        });\n\n        alignElements.trigger(aligneableElements, type);\n      }\n    });\n  }\n\n  if (selection && modeling) {\n    this._registerAction('setColor', function(opts) {\n      var currentSelection = selection.get();\n\n      if (currentSelection.length) {\n        modeling.setColor(currentSelection, opts);\n      }\n    });\n  }\n\n  if (selection && directEditing) {\n    this._registerAction('directEditing', function() {\n      var currentSelection = selection.get();\n\n      if (currentSelection.length) {\n        directEditing.activate(currentSelection[0]);\n      }\n    });\n  }\n\n  if (searchPad) {\n    this._registerAction('find', function() {\n      searchPad.toggle();\n    });\n  }\n\n  if (canvas && modeling) {\n    this._registerAction('moveToOrigin', function() {\n      var rootElement = canvas.getRootElement(),\n          boundingBox,\n          elements;\n\n      if ((0,ModelUtil.is)(rootElement, 'bpmn:Collaboration')) {\n        elements = elementRegistry.filter(function(element) {\n          return (0,ModelUtil.is)(element.parent, 'bpmn:Collaboration');\n        });\n      } else {\n        elements = elementRegistry.filter(function(element) {\n          return element !== rootElement && !(0,ModelUtil.is)(element.parent, 'bpmn:SubProcess');\n        });\n      }\n\n      boundingBox = (0,Elements/* getBBox */.jY)(elements);\n\n      modeling.moveElements(\n        elements,\n        { x: -boundingBox.x, y: -boundingBox.y },\n        rootElement\n      );\n    });\n  }\n\n  if (selection && contextPad) {\n    this._registerAction('replaceElement', function(event) {\n      contextPad.triggerEntry('replace', 'click', event);\n    });\n  }\n\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/editor-actions/index.js\n\n\n\n\n/* harmony default export */ const features_editor_actions = ({\n  __depends__: [\n    editor_actions/* default */.Z\n  ],\n  editorActions: [ 'type', BpmnEditorActions ]\n});\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/grid-snapping/BpmnGridSnapping.js\n\r\n\r\nfunction BpmnGridSnapping(eventBus) {\r\n  eventBus.on([\r\n    'create.init',\r\n    'shape.move.init'\r\n  ], function(event) {\r\n    var context = event.context,\r\n        shape = event.shape;\r\n\r\n    if ((0,ModelUtil/* isAny */.JZ)(shape, [\r\n      'bpmn:Participant',\r\n      'bpmn:SubProcess',\r\n      'bpmn:TextAnnotation'\r\n    ])) {\r\n      if (!context.gridSnappingContext) {\r\n        context.gridSnappingContext = {};\r\n      }\r\n\r\n      context.gridSnappingContext.snapLocation = 'top-left';\r\n    }\r\n  });\r\n}\r\n\r\nBpmnGridSnapping.$inject = [ 'eventBus' ];\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/grid-snapping/index.js + 5 modules\nvar grid_snapping = __webpack_require__(\"./node_modules/diagram-js/lib/features/grid-snapping/index.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/grid-snapping/behavior/GridSnappingAutoPlaceBehavior.js\n\r\n\r\n\r\n\r\n\r\nvar HIGH_PRIORITY = 2000;\r\n\r\n\r\nfunction GridSnappingAutoPlaceBehavior(eventBus, gridSnapping) {\r\n  eventBus.on('autoPlace', HIGH_PRIORITY, function(context) {\r\n    var source = context.source,\r\n        sourceMid = (0,LayoutUtil/* getMid */.wS)(source),\r\n        shape = context.shape;\r\n\r\n    var position = getNewShapePosition(source, shape);\r\n\r\n    [ 'x', 'y' ].forEach(function(axis) {\r\n      var options = {};\r\n\r\n      // do not snap if x/y equal\r\n      if (position[ axis ] === sourceMid[ axis ]) {\r\n        return;\r\n      }\r\n\r\n      if (position[ axis ] > sourceMid[ axis ]) {\r\n        options.min = position[ axis ];\r\n      } else {\r\n        options.max = position[ axis ];\r\n      }\r\n\r\n      if ((0,ModelUtil.is)(shape, 'bpmn:TextAnnotation')) {\r\n\r\n        if (isHorizontal(axis)) {\r\n          options.offset = -shape.width / 2;\r\n        } else {\r\n          options.offset = -shape.height / 2;\r\n        }\r\n\r\n      }\r\n\r\n      position[ axis ] = gridSnapping.snapValue(position[ axis ], options);\r\n\r\n    });\r\n\r\n    // must be returned to be considered by auto place\r\n    return position;\r\n  });\r\n}\r\n\r\nGridSnappingAutoPlaceBehavior.$inject = [\r\n  'eventBus',\r\n  'gridSnapping'\r\n];\r\n\r\n// helpers //////////\r\n\r\nfunction isHorizontal(axis) {\r\n  return axis === 'x';\r\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/grid-snapping/behavior/GridSnappingParticipantBehavior.js\n\r\n\r\nvar HIGHER_PRIORITY = 1750;\r\n\r\n\r\nfunction GridSnappingParticipantBehavior(canvas, eventBus, gridSnapping) {\r\n  eventBus.on([\r\n    'create.start',\r\n    'shape.move.start'\r\n  ], HIGHER_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        shape = context.shape,\r\n        rootElement = canvas.getRootElement();\r\n\r\n    if (!(0,ModelUtil.is)(shape, 'bpmn:Participant') ||\r\n      !(0,ModelUtil.is)(rootElement, 'bpmn:Process') ||\r\n      !rootElement.children.length) {\r\n      return;\r\n    }\r\n\r\n    var createConstraints = context.createConstraints;\r\n\r\n    if (!createConstraints) {\r\n      return;\r\n    }\r\n\r\n    shape.width = gridSnapping.snapValue(shape.width, { min: shape.width });\r\n    shape.height = gridSnapping.snapValue(shape.height, { min: shape.height });\r\n  });\r\n}\r\n\r\nGridSnappingParticipantBehavior.$inject = [\r\n  'canvas',\r\n  'eventBus',\r\n  'gridSnapping'\r\n];\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Geometry.js\nvar Geometry = __webpack_require__(\"./node_modules/diagram-js/lib/util/Geometry.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/grid-snapping/behavior/GridSnappingLayoutConnectionBehavior.js\n\n\n\n\n\n\n\n\nvar GridSnappingLayoutConnectionBehavior_HIGH_PRIORITY = 3000;\n\n\n/**\n * Snaps connections with Manhattan layout.\n */\nfunction GridSnappingLayoutConnectionBehavior(eventBus, gridSnapping, modeling) {\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  this._gridSnapping = gridSnapping;\n\n  var self = this;\n\n  this.postExecuted([\n    'connection.create',\n    'connection.layout'\n  ], GridSnappingLayoutConnectionBehavior_HIGH_PRIORITY, function(event) {\n    var context = event.context,\n        connection = context.connection,\n        hints = context.hints || {},\n        waypoints = connection.waypoints;\n\n    if (hints.connectionStart || hints.connectionEnd || hints.createElementsBehavior === false) {\n      return;\n    }\n\n    if (!hasMiddleSegments(waypoints)) {\n      return;\n    }\n\n    modeling.updateWaypoints(connection, self.snapMiddleSegments(waypoints));\n  });\n}\n\nGridSnappingLayoutConnectionBehavior.$inject = [\n  'eventBus',\n  'gridSnapping',\n  'modeling'\n];\n\n(0,index_es/* default */.Z)(GridSnappingLayoutConnectionBehavior, CommandInterceptor/* default */.Z);\n\n/**\n * Snap middle segments of a given connection.\n *\n * @param {Array<Point>} waypoints\n *\n * @returns {Array<Point>}\n */\nGridSnappingLayoutConnectionBehavior.prototype.snapMiddleSegments = function(waypoints) {\n  var gridSnapping = this._gridSnapping,\n      snapped;\n\n  waypoints = waypoints.slice();\n\n  for (var i = 1; i < waypoints.length - 2; i++) {\n\n    snapped = snapSegment(gridSnapping, waypoints[i], waypoints[i + 1]);\n\n    waypoints[i] = snapped[0];\n    waypoints[i + 1] = snapped[1];\n  }\n\n  return waypoints;\n};\n\n\n// helpers //////////\n\n/**\n * Check whether a connection has a middle segments.\n *\n * @param {Array} waypoints\n *\n * @returns {boolean}\n */\nfunction hasMiddleSegments(waypoints) {\n  return waypoints.length > 3;\n}\n\n/**\n * Check whether an alignment is horizontal.\n *\n * @param {string} aligned\n *\n * @returns {boolean}\n */\nfunction horizontallyAligned(aligned) {\n  return aligned === 'h';\n}\n\n/**\n * Check whether an alignment is vertical.\n *\n * @param {string} aligned\n *\n * @returns {boolean}\n */\nfunction verticallyAligned(aligned) {\n  return aligned === 'v';\n}\n\n/**\n * Get middle segments from a given connection.\n *\n * @param {Array} waypoints\n *\n * @returns {Array}\n */\nfunction snapSegment(gridSnapping, segmentStart, segmentEnd) {\n\n  var aligned = (0,Geometry/* pointsAligned */.Or)(segmentStart, segmentEnd);\n\n  var snapped = {};\n\n  if (horizontallyAligned(aligned)) {\n\n    // snap horizontally\n    snapped.y = gridSnapping.snapValue(segmentStart.y);\n  }\n\n  if (verticallyAligned(aligned)) {\n\n    // snap vertically\n    snapped.x = gridSnapping.snapValue(segmentStart.x);\n  }\n\n  if ('x' in snapped || 'y' in snapped) {\n    segmentStart = (0,dist_index_esm/* assign */.f0)({}, segmentStart, snapped);\n    segmentEnd = (0,dist_index_esm/* assign */.f0)({}, segmentEnd, snapped);\n  }\n\n  return [ segmentStart, segmentEnd ];\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/grid-snapping/behavior/index.js\n\r\n\r\n\r\n\r\n/* harmony default export */ const behavior = ({\r\n  __init__: [\r\n    'gridSnappingAutoPlaceBehavior',\r\n    'gridSnappingParticipantBehavior',\r\n    'gridSnappingLayoutConnectionBehavior',\r\n  ],\r\n  gridSnappingAutoPlaceBehavior: [ 'type', GridSnappingAutoPlaceBehavior ],\r\n  gridSnappingParticipantBehavior: [ 'type', GridSnappingParticipantBehavior ],\r\n  gridSnappingLayoutConnectionBehavior: [ 'type', GridSnappingLayoutConnectionBehavior ]\r\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/grid-snapping/index.js\n\r\n\r\n\r\n\r\n\r\n/* harmony default export */ const features_grid_snapping = ({\r\n  __depends__: [\r\n    grid_snapping/* default */.Z,\r\n    behavior\r\n  ],\r\n  __init__: [ 'bpmnGridSnapping' ],\r\n  bpmnGridSnapping: [ 'type', BpmnGridSnapping ]\r\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/interaction-events/BpmnInteractionEvents.js\n\n\n\n\nvar LABEL_WIDTH = 30,\n    LABEL_HEIGHT = 30;\n\n\n/**\n * BPMN-specific hit zones and interaction fixes.\n *\n * @param {EventBus} eventBus\n * @param {InteractionEvents} interactionEvents\n */\nfunction BpmnInteractionEvents(eventBus, interactionEvents) {\n\n  this._interactionEvents = interactionEvents;\n\n  var self = this;\n\n  eventBus.on([\n    'interactionEvents.createHit',\n    'interactionEvents.updateHit'\n  ], function(context) {\n    var element = context.element,\n        gfx = context.gfx;\n\n    if ((0,ModelUtil.is)(element, 'bpmn:Lane')) {\n      return self.createParticipantHit(element, gfx);\n    } else\n\n    if ((0,ModelUtil.is)(element, 'bpmn:Participant')) {\n      if ((0,DiUtil/* isExpanded */.ul)(element)) {\n        return self.createParticipantHit(element, gfx);\n      } else {\n        return self.createDefaultHit(element, gfx);\n      }\n    } else\n\n    if ((0,ModelUtil.is)(element, 'bpmn:SubProcess')) {\n      if ((0,DiUtil/* isExpanded */.ul)(element)) {\n        return self.createSubProcessHit(element, gfx);\n      } else {\n        return self.createDefaultHit(element, gfx);\n      }\n    }\n  });\n\n}\n\nBpmnInteractionEvents.$inject = [\n  'eventBus',\n  'interactionEvents'\n];\n\n\nBpmnInteractionEvents.prototype.createDefaultHit = function(element, gfx) {\n  this._interactionEvents.removeHits(gfx);\n\n  this._interactionEvents.createDefaultHit(element, gfx);\n\n  // indicate that we created a hit\n  return true;\n};\n\nBpmnInteractionEvents.prototype.createParticipantHit = function(element, gfx) {\n\n  // remove existing hits\n  this._interactionEvents.removeHits(gfx);\n\n  // add body hit\n  this._interactionEvents.createBoxHit(gfx, 'no-move', {\n    width: element.width,\n    height: element.height\n  });\n\n  // add outline hit\n  this._interactionEvents.createBoxHit(gfx, 'click-stroke', {\n    width: element.width,\n    height: element.height\n  });\n\n  // add label hit\n  this._interactionEvents.createBoxHit(gfx, 'all', {\n    width: LABEL_WIDTH,\n    height: element.height\n  });\n\n  // indicate that we created a hit\n  return true;\n};\n\nBpmnInteractionEvents.prototype.createSubProcessHit = function(element, gfx) {\n\n  // remove existing hits\n  this._interactionEvents.removeHits(gfx);\n\n  // add body hit\n  this._interactionEvents.createBoxHit(gfx, 'no-move', {\n    width: element.width,\n    height: element.height\n  });\n\n  // add outline hit\n  this._interactionEvents.createBoxHit(gfx, 'click-stroke', {\n    width: element.width,\n    height: element.height\n  });\n\n  // add label hit\n  this._interactionEvents.createBoxHit(gfx, 'all', {\n    width: element.width,\n    height: LABEL_HEIGHT\n  });\n\n  // indicate that we created a hit\n  return true;\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/interaction-events/index.js\n\n\n/* harmony default export */ const interaction_events = ({\n  __init__: [ 'bpmnInteractionEvents' ],\n  bpmnInteractionEvents: [ 'type', BpmnInteractionEvents ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/index.js + 1 modules\nvar keyboard = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js\nvar KeyboardBindings = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardBindings.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/keyboard/BpmnKeyboardBindings.js\n\n\n\n\n\n/**\n * BPMN 2.0 specific keyboard bindings.\n *\n * @param {Injector} injector\n */\nfunction BpmnKeyboardBindings(injector) {\n  injector.invoke(KeyboardBindings/* default */.ZP, this);\n}\n\n(0,index_es/* default */.Z)(BpmnKeyboardBindings, KeyboardBindings/* default */.ZP);\n\nBpmnKeyboardBindings.$inject = [\n  'injector'\n];\n\n\n/**\n * Register available keyboard bindings.\n *\n * @param {Keyboard} keyboard\n * @param {EditorActions} editorActions\n */\nBpmnKeyboardBindings.prototype.registerBindings = function(keyboard, editorActions) {\n\n  // inherit default bindings\n  KeyboardBindings/* default.prototype.registerBindings.call */.ZP.prototype.registerBindings.call(this, keyboard, editorActions);\n\n  /**\n   * Add keyboard binding if respective editor action\n   * is registered.\n   *\n   * @param {string} action name\n   * @param {Function} fn that implements the key binding\n   */\n  function addListener(action, fn) {\n\n    if (editorActions.isRegistered(action)) {\n      keyboard.addListener(fn);\n    }\n  }\n\n  // select all elements\n  // CTRL + A\n  addListener('selectElements', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.isKey([ 'a', 'A' ], event) && keyboard.isCmd(event)) {\n      editorActions.trigger('selectElements');\n\n      return true;\n    }\n  });\n\n  // search labels\n  // CTRL + F\n  addListener('find', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.isKey([ 'f', 'F' ], event) && keyboard.isCmd(event)) {\n      editorActions.trigger('find');\n\n      return true;\n    }\n  });\n\n  // activate space tool\n  // S\n  addListener('spaceTool', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey([ 's', 'S' ], event)) {\n      editorActions.trigger('spaceTool');\n\n      return true;\n    }\n  });\n\n  // activate lasso tool\n  // L\n  addListener('lassoTool', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey([ 'l', 'L' ], event)) {\n      editorActions.trigger('lassoTool');\n\n      return true;\n    }\n  });\n\n  // activate hand tool\n  // H\n  addListener('handTool', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey([ 'h', 'H' ], event)) {\n      editorActions.trigger('handTool');\n\n      return true;\n    }\n  });\n\n  // activate global connect tool\n  // C\n  addListener('globalConnectTool', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey([ 'c', 'C' ], event)) {\n      editorActions.trigger('globalConnectTool');\n\n      return true;\n    }\n  });\n\n  // activate direct editing\n  // E\n  addListener('directEditing', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey([ 'e', 'E' ], event)) {\n      editorActions.trigger('directEditing');\n\n      return true;\n    }\n  });\n\n  // activate replace element\n  // R\n  addListener('replaceElement', function(context) {\n\n    var event = context.keyEvent;\n\n    if (keyboard.hasModifier(event)) {\n      return;\n    }\n\n    if (keyboard.isKey([ 'r', 'R' ], event)) {\n      editorActions.trigger('replaceElement', event);\n\n      return true;\n    }\n  });\n\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/keyboard/index.js\n\n\n\n\n/* harmony default export */ const features_keyboard = ({\n  __depends__: [\n    keyboard/* default */.Z\n  ],\n  __init__: [ 'keyboardBindings' ],\n  keyboardBindings: [ 'type', BpmnKeyboardBindings ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard-move-selection/index.js + 1 modules\nvar keyboard_move_selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard-move-selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/change-support/index.js + 1 modules\nvar change_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/change-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/resize/index.js + 3 modules\nvar resize = __webpack_require__(\"./node_modules/diagram-js/lib/features/resize/index.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/features/label-editing/LabelUtil.js\nvar LabelUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/features/label-editing/LabelUtil.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/LabelUtil.js\nvar util_LabelUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/LabelUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/label-editing/LabelEditingProvider.js\n\n\n\n\n\n\n\n\n\n\n\nvar LabelEditingProvider_HIGH_PRIORITY = 2000;\n\n\nfunction LabelEditingProvider(\n    eventBus, bpmnFactory, canvas, directEditing,\n    modeling, resizeHandles, textRenderer) {\n\n  this._bpmnFactory = bpmnFactory;\n  this._canvas = canvas;\n  this._modeling = modeling;\n  this._textRenderer = textRenderer;\n\n  directEditing.registerProvider(this);\n\n  // listen to dblclick on non-root elements\n  eventBus.on('element.dblclick', function(event) {\n    activateDirectEdit(event.element, true);\n  });\n\n  // complete on followup canvas operation\n  eventBus.on([\n    'autoPlace.start',\n    'canvas.viewbox.changing',\n    'drag.init',\n    'element.mousedown',\n    'popupMenu.open',\n    'root.set',\n    'selection.changed'\n  ], function(event) {\n\n    if (directEditing.isActive()) {\n      directEditing.complete();\n    }\n  });\n\n  eventBus.on([\n    'shape.remove',\n    'connection.remove'\n  ], LabelEditingProvider_HIGH_PRIORITY, function(event) {\n\n    if (directEditing.isActive(event.element)) {\n      directEditing.cancel();\n    }\n  });\n\n  // cancel on command stack changes\n  eventBus.on([ 'commandStack.changed' ], function(e) {\n    if (directEditing.isActive()) {\n      directEditing.cancel();\n    }\n  });\n\n\n  eventBus.on('directEditing.activate', function(event) {\n    resizeHandles.removeResizers();\n  });\n\n  eventBus.on('create.end', 500, function(event) {\n\n    var context = event.context,\n        element = context.shape,\n        canExecute = event.context.canExecute,\n        isTouch = event.isTouch;\n\n    // TODO(nikku): we need to find a way to support the\n    // direct editing on mobile devices; right now this will\n    // break for desworkflowediting on mobile devices\n    // as it breaks the user interaction workflow\n\n    // TODO(nre): we should temporarily focus the edited element\n    // here and release the focused viewport after the direct edit\n    // operation is finished\n    if (isTouch) {\n      return;\n    }\n\n    if (!canExecute) {\n      return;\n    }\n\n    if (context.hints && context.hints.createElementsBehavior === false) {\n      return;\n    }\n\n    activateDirectEdit(element);\n  });\n\n  eventBus.on('autoPlace.end', 500, function(event) {\n    activateDirectEdit(event.shape);\n  });\n\n\n  function activateDirectEdit(element, force) {\n    if (force ||\n        (0,ModelUtil/* isAny */.JZ)(element, [ 'bpmn:Task', 'bpmn:TextAnnotation' ]) ||\n        isCollapsedSubProcess(element)) {\n\n      directEditing.activate(element);\n    }\n  }\n\n}\n\nLabelEditingProvider.$inject = [\n  'eventBus',\n  'bpmnFactory',\n  'canvas',\n  'directEditing',\n  'modeling',\n  'resizeHandles',\n  'textRenderer'\n];\n\n\n/**\n * Activate direct editing for activities and text annotations.\n *\n * @param  {djs.model.Base} element\n *\n * @return {Object} an object with properties bounds (position and size), text and options\n */\nLabelEditingProvider.prototype.activate = function(element) {\n\n  // text\n  var text = (0,LabelUtil/* getLabel */.i)(element);\n\n  if (text === undefined) {\n    return;\n  }\n\n  var context = {\n    text: text\n  };\n\n  // bounds\n  var bounds = this.getEditingBBox(element);\n\n  (0,dist_index_esm/* assign */.f0)(context, bounds);\n\n  var options = {};\n\n  // tasks\n  if (\n    (0,ModelUtil/* isAny */.JZ)(element, [\n      'bpmn:Task',\n      'bpmn:Participant',\n      'bpmn:Lane',\n      'bpmn:CallActivity'\n    ]) ||\n    isCollapsedSubProcess(element)\n  ) {\n    (0,dist_index_esm/* assign */.f0)(options, {\n      centerVertically: true\n    });\n  }\n\n  // external labels\n  if ((0,util_LabelUtil/* isLabelExternal */.ly)(element)) {\n    (0,dist_index_esm/* assign */.f0)(options, {\n      autoResize: true\n    });\n  }\n\n  // text annotations\n  if ((0,ModelUtil.is)(element, 'bpmn:TextAnnotation')) {\n    (0,dist_index_esm/* assign */.f0)(options, {\n      resizable: true,\n      autoResize: true\n    });\n  }\n\n  (0,dist_index_esm/* assign */.f0)(context, {\n    options: options\n  });\n\n  return context;\n};\n\n\n/**\n * Get the editing bounding box based on the element's size and position\n *\n * @param  {djs.model.Base} element\n *\n * @return {Object} an object containing information about position\n *                  and size (fixed or minimum and/or maximum)\n */\nLabelEditingProvider.prototype.getEditingBBox = function(element) {\n  var canvas = this._canvas;\n\n  var target = element.label || element;\n\n  var bbox = canvas.getAbsoluteBBox(target);\n\n  var mid = {\n    x: bbox.x + bbox.width / 2,\n    y: bbox.y + bbox.height / 2\n  };\n\n  // default position\n  var bounds = { x: bbox.x, y: bbox.y };\n\n  var zoom = canvas.zoom();\n\n  var defaultStyle = this._textRenderer.getDefaultStyle(),\n      externalStyle = this._textRenderer.getExternalStyle();\n\n  // take zoom into account\n  var externalFontSize = externalStyle.fontSize * zoom,\n      externalLineHeight = externalStyle.lineHeight,\n      defaultFontSize = defaultStyle.fontSize * zoom,\n      defaultLineHeight = defaultStyle.lineHeight;\n\n  var style = {\n    fontFamily: this._textRenderer.getDefaultStyle().fontFamily,\n    fontWeight: this._textRenderer.getDefaultStyle().fontWeight\n  };\n\n  // adjust for expanded pools AND lanes\n  if ((0,ModelUtil.is)(element, 'bpmn:Lane') || isExpandedPool(element)) {\n\n    (0,dist_index_esm/* assign */.f0)(bounds, {\n      width: bbox.height,\n      height: 30 * zoom,\n      x: bbox.x - bbox.height / 2 + (15 * zoom),\n      y: mid.y - (30 * zoom) / 2\n    });\n\n    (0,dist_index_esm/* assign */.f0)(style, {\n      fontSize: defaultFontSize + 'px',\n      lineHeight: defaultLineHeight,\n      paddingTop: (7 * zoom) + 'px',\n      paddingBottom: (7 * zoom) + 'px',\n      paddingLeft: (5 * zoom) + 'px',\n      paddingRight: (5 * zoom) + 'px',\n      transform: 'rotate(-90deg)'\n    });\n  }\n\n\n  // internal labels for tasks and collapsed call activities,\n  // sub processes and participants\n  if ((0,ModelUtil/* isAny */.JZ)(element, [ 'bpmn:Task', 'bpmn:CallActivity' ]) ||\n      isCollapsedPool(element) ||\n      isCollapsedSubProcess(element)) {\n\n    (0,dist_index_esm/* assign */.f0)(bounds, {\n      width: bbox.width,\n      height: bbox.height\n    });\n\n    (0,dist_index_esm/* assign */.f0)(style, {\n      fontSize: defaultFontSize + 'px',\n      lineHeight: defaultLineHeight,\n      paddingTop: (7 * zoom) + 'px',\n      paddingBottom: (7 * zoom) + 'px',\n      paddingLeft: (5 * zoom) + 'px',\n      paddingRight: (5 * zoom) + 'px'\n    });\n  }\n\n\n  // internal labels for expanded sub processes\n  if (isExpandedSubProcess(element)) {\n    (0,dist_index_esm/* assign */.f0)(bounds, {\n      width: bbox.width,\n      x: bbox.x\n    });\n\n    (0,dist_index_esm/* assign */.f0)(style, {\n      fontSize: defaultFontSize + 'px',\n      lineHeight: defaultLineHeight,\n      paddingTop: (7 * zoom) + 'px',\n      paddingBottom: (7 * zoom) + 'px',\n      paddingLeft: (5 * zoom) + 'px',\n      paddingRight: (5 * zoom) + 'px'\n    });\n  }\n\n  var width = 90 * zoom,\n      paddingTop = 7 * zoom,\n      paddingBottom = 4 * zoom;\n\n  // external labels for events, data elements, gateways, groups and connections\n  if (target.labelTarget) {\n    (0,dist_index_esm/* assign */.f0)(bounds, {\n      width: width,\n      height: bbox.height + paddingTop + paddingBottom,\n      x: mid.x - width / 2,\n      y: bbox.y - paddingTop\n    });\n\n    (0,dist_index_esm/* assign */.f0)(style, {\n      fontSize: externalFontSize + 'px',\n      lineHeight: externalLineHeight,\n      paddingTop: paddingTop + 'px',\n      paddingBottom: paddingBottom + 'px'\n    });\n  }\n\n  // external label not yet created\n  if ((0,util_LabelUtil/* isLabelExternal */.ly)(target)\n      && !(0,util_LabelUtil/* hasExternalLabel */.fF)(target)\n      && !(0,util_LabelUtil/* isLabel */.j_)(target)) {\n\n    var externalLabelMid = (0,util_LabelUtil/* getExternalLabelMid */.qe)(element);\n\n    var absoluteBBox = canvas.getAbsoluteBBox({\n      x: externalLabelMid.x,\n      y: externalLabelMid.y,\n      width: 0,\n      height: 0\n    });\n\n    var height = externalFontSize + paddingTop + paddingBottom;\n\n    (0,dist_index_esm/* assign */.f0)(bounds, {\n      width: width,\n      height: height,\n      x: absoluteBBox.x - width / 2,\n      y: absoluteBBox.y - height / 2\n    });\n\n    (0,dist_index_esm/* assign */.f0)(style, {\n      fontSize: externalFontSize + 'px',\n      lineHeight: externalLineHeight,\n      paddingTop: paddingTop + 'px',\n      paddingBottom: paddingBottom + 'px'\n    });\n  }\n\n  // text annotations\n  if ((0,ModelUtil.is)(element, 'bpmn:TextAnnotation')) {\n    (0,dist_index_esm/* assign */.f0)(bounds, {\n      width: bbox.width,\n      height: bbox.height,\n      minWidth: 30 * zoom,\n      minHeight: 10 * zoom\n    });\n\n    (0,dist_index_esm/* assign */.f0)(style, {\n      textAlign: 'left',\n      paddingTop: (5 * zoom) + 'px',\n      paddingBottom: (7 * zoom) + 'px',\n      paddingLeft: (7 * zoom) + 'px',\n      paddingRight: (5 * zoom) + 'px',\n      fontSize: defaultFontSize + 'px',\n      lineHeight: defaultLineHeight\n    });\n  }\n\n  return { bounds: bounds, style: style };\n};\n\n\nLabelEditingProvider.prototype.update = function(\n    element, newLabel,\n    activeContextText, bounds) {\n\n  var newBounds,\n      bbox;\n\n  if ((0,ModelUtil.is)(element, 'bpmn:TextAnnotation')) {\n\n    bbox = this._canvas.getAbsoluteBBox(element);\n\n    newBounds = {\n      x: element.x,\n      y: element.y,\n      width: element.width / bbox.width * bounds.width,\n      height: element.height / bbox.height * bounds.height\n    };\n  }\n\n  if (isEmptyText(newLabel)) {\n    newLabel = null;\n  }\n\n  this._modeling.updateLabel(element, newLabel, newBounds);\n};\n\n\n\n// helpers //////////////////////\n\nfunction isCollapsedSubProcess(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:SubProcess') && !(0,DiUtil/* isExpanded */.ul)(element);\n}\n\nfunction isExpandedSubProcess(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:SubProcess') && (0,DiUtil/* isExpanded */.ul)(element);\n}\n\nfunction isCollapsedPool(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Participant') && !(0,DiUtil/* isExpanded */.ul)(element);\n}\n\nfunction isExpandedPool(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Participant') && (0,DiUtil/* isExpanded */.ul)(element);\n}\n\nfunction isEmptyText(label) {\n  return !label || !label.trim();\n}\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/label-editing/LabelEditingPreview.js\n\n\n\n\n\n\nvar MARKER_HIDDEN = 'djs-element-hidden',\n    MARKER_LABEL_HIDDEN = 'djs-label-hidden';\n\n\nfunction LabelEditingPreview(\n    eventBus, canvas, elementRegistry,\n    pathMap) {\n\n  var self = this;\n\n  var defaultLayer = canvas.getDefaultLayer();\n\n  var element, absoluteElementBBox, gfx;\n\n  eventBus.on('directEditing.activate', function(context) {\n    var activeProvider = context.active;\n\n    element = activeProvider.element.label || activeProvider.element;\n\n    // text annotation\n    if ((0,ModelUtil.is)(element, 'bpmn:TextAnnotation')) {\n      absoluteElementBBox = canvas.getAbsoluteBBox(element);\n\n      gfx = (0,tiny_svg_dist_index_esm/* create */.Ue)('g');\n\n      var textPathData = pathMap.getScaledPath('TEXT_ANNOTATION', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.0,\n          my: 0.0\n        }\n      });\n\n      var path = self.path = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(path, {\n        d: textPathData,\n        strokeWidth: 2,\n        stroke: getStrokeColor(element)\n      });\n\n      (0,tiny_svg_dist_index_esm/* append */.R3)(gfx, path);\n\n      (0,tiny_svg_dist_index_esm/* append */.R3)(defaultLayer, gfx);\n\n      (0,SvgTransformUtil/* translate */.Iu)(gfx, element.x, element.y);\n    }\n\n    if ((0,ModelUtil.is)(element, 'bpmn:TextAnnotation') ||\n        element.labelTarget) {\n      canvas.addMarker(element, MARKER_HIDDEN);\n    } else if ((0,ModelUtil.is)(element, 'bpmn:Task') ||\n               (0,ModelUtil.is)(element, 'bpmn:CallActivity') ||\n               (0,ModelUtil.is)(element, 'bpmn:SubProcess') ||\n               (0,ModelUtil.is)(element, 'bpmn:Participant')) {\n      canvas.addMarker(element, MARKER_LABEL_HIDDEN);\n    }\n  });\n\n  eventBus.on('directEditing.resize', function(context) {\n\n    // text annotation\n    if ((0,ModelUtil.is)(element, 'bpmn:TextAnnotation')) {\n      var height = context.height,\n          dy = context.dy;\n\n      var newElementHeight = Math.max(element.height / absoluteElementBBox.height * (height + dy), 0);\n\n      var textPathData = pathMap.getScaledPath('TEXT_ANNOTATION', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: newElementHeight,\n        position: {\n          mx: 0.0,\n          my: 0.0\n        }\n      });\n\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(self.path, {\n        d: textPathData\n      });\n    }\n  });\n\n  eventBus.on([ 'directEditing.complete', 'directEditing.cancel' ], function(context) {\n    var activeProvider = context.active;\n\n    if (activeProvider) {\n      canvas.removeMarker(activeProvider.element.label || activeProvider.element, MARKER_HIDDEN);\n      canvas.removeMarker(element, MARKER_LABEL_HIDDEN);\n    }\n\n    element = undefined;\n    absoluteElementBBox = undefined;\n\n    if (gfx) {\n      (0,tiny_svg_dist_index_esm/* remove */.Od)(gfx);\n\n      gfx = undefined;\n    }\n  });\n}\n\nLabelEditingPreview.$inject = [\n  'eventBus',\n  'canvas',\n  'elementRegistry',\n  'pathMap'\n];\n\n\n// helpers ///////////////////\n\nfunction getStrokeColor(element, defaultColor) {\n  var di = (0,ModelUtil/* getDi */.DN)(element);\n\n  return di.get('stroke') || defaultColor || 'black';\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/label-editing/index.js\n\n\n\n\n\n\n\n\n/* harmony default export */ const label_editing = ({\n  __depends__: [\n    change_support/* default */.Z,\n    resize/* default */.Z,\n    diagram_js_direct_editing/* default */.Z\n  ],\n  __init__: [\n    'labelEditingProvider',\n    'labelEditingPreview'\n  ],\n  labelEditingProvider: [ 'type', LabelEditingProvider ],\n  labelEditingPreview: [ 'type', LabelEditingPreview ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/PositionUtil.js\nvar PositionUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/PositionUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/AdaptiveLabelPositioningBehavior.js\n\n\n\n\n\n\n\n\n\n\nvar ALIGNMENTS = [\n  'top',\n  'bottom',\n  'left',\n  'right'\n];\n\nvar ELEMENT_LABEL_DISTANCE = 10;\n\n/**\n * A component that makes sure that external labels are added\n * together with respective elements and properly updated (DI wise)\n * during move.\n *\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n */\nfunction AdaptiveLabelPositioningBehavior(eventBus, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  this.postExecuted([\n    'connection.create',\n    'connection.layout',\n    'connection.updateWaypoints'\n  ], function(event) {\n    var context = event.context,\n        connection = context.connection,\n        source = connection.source,\n        target = connection.target,\n        hints = context.hints || {};\n\n    if (hints.createElementsBehavior !== false) {\n      checkLabelAdjustment(source);\n      checkLabelAdjustment(target);\n    }\n  });\n\n\n  this.postExecuted([\n    'label.create'\n  ], function(event) {\n    var context = event.context,\n        shape = context.shape,\n        hints = context.hints || {};\n\n    if (hints.createElementsBehavior !== false) {\n      checkLabelAdjustment(shape.labelTarget);\n    }\n  });\n\n\n  this.postExecuted([\n    'elements.create'\n  ], function(event) {\n    var context = event.context,\n        elements = context.elements,\n        hints = context.hints || {};\n\n    if (hints.createElementsBehavior !== false) {\n      elements.forEach(function(element) {\n        checkLabelAdjustment(element);\n      });\n    }\n  });\n\n  function checkLabelAdjustment(element) {\n\n    // skip non-existing labels\n    if (!(0,util_LabelUtil/* hasExternalLabel */.fF)(element)) {\n      return;\n    }\n\n    var optimalPosition = getOptimalPosition(element);\n\n    // no optimal position found\n    if (!optimalPosition) {\n      return;\n    }\n\n    adjustLabelPosition(element, optimalPosition);\n  }\n\n  function adjustLabelPosition(element, orientation) {\n\n    var elementMid = (0,LayoutUtil/* getMid */.wS)(element),\n        label = element.label,\n        labelMid = (0,LayoutUtil/* getMid */.wS)(label);\n\n    // ignore labels that are being created\n    if (!label.parent) {\n      return;\n    }\n\n    var elementTrbl = (0,LayoutUtil/* asTRBL */.JA)(element);\n\n    var newLabelMid;\n\n    switch (orientation) {\n    case 'top':\n      newLabelMid = {\n        x: elementMid.x,\n        y: elementTrbl.top - ELEMENT_LABEL_DISTANCE - label.height / 2\n      };\n\n      break;\n\n    case 'left':\n\n      newLabelMid = {\n        x: elementTrbl.left - ELEMENT_LABEL_DISTANCE - label.width / 2,\n        y: elementMid.y\n      };\n\n      break;\n\n    case 'bottom':\n\n      newLabelMid = {\n        x: elementMid.x,\n        y: elementTrbl.bottom + ELEMENT_LABEL_DISTANCE + label.height / 2\n      };\n\n      break;\n\n    case 'right':\n\n      newLabelMid = {\n        x: elementTrbl.right + ELEMENT_LABEL_DISTANCE + label.width / 2,\n        y: elementMid.y\n      };\n\n      break;\n    }\n\n    var delta = (0,PositionUtil/* delta */.p)(newLabelMid, labelMid);\n\n    modeling.moveShape(label, delta);\n  }\n\n}\n\n(0,index_es/* default */.Z)(AdaptiveLabelPositioningBehavior, CommandInterceptor/* default */.Z);\n\nAdaptiveLabelPositioningBehavior.$inject = [\n  'eventBus',\n  'modeling'\n];\n\n\n// helpers //////////////////////\n\n/**\n * Return alignments which are taken by a boundary's host element\n *\n * @param {Shape} element\n *\n * @return {Array<string>}\n */\nfunction getTakenHostAlignments(element) {\n\n  var hostElement = element.host,\n      elementMid = (0,LayoutUtil/* getMid */.wS)(element),\n      hostOrientation = (0,LayoutUtil/* getOrientation */.T8)(elementMid, hostElement);\n\n  var freeAlignments;\n\n  // check whether there is a multi-orientation, e.g. 'top-left'\n  if (hostOrientation.indexOf('-') >= 0) {\n    freeAlignments = hostOrientation.split('-');\n  } else {\n    freeAlignments = [ hostOrientation ];\n  }\n\n  var takenAlignments = ALIGNMENTS.filter(function(alignment) {\n\n    return freeAlignments.indexOf(alignment) === -1;\n  });\n\n  return takenAlignments;\n\n}\n\n/**\n * Return alignments which are taken by related connections\n *\n * @param {Shape} element\n *\n * @return {Array<string>}\n */\nfunction getTakenConnectionAlignments(element) {\n\n  var elementMid = (0,LayoutUtil/* getMid */.wS)(element);\n\n  var takenAlignments = [].concat(\n    element.incoming.map(function(c) {\n      return c.waypoints[c.waypoints.length - 2 ];\n    }),\n    element.outgoing.map(function(c) {\n      return c.waypoints[1];\n    })\n  ).map(function(point) {\n    return getApproximateOrientation(elementMid, point);\n  });\n\n  return takenAlignments;\n}\n\n/**\n * Return the optimal label position around an element\n * or _undefined_, if none was found.\n *\n * @param  {Shape} element\n *\n * @return {string} positioning identifier\n */\nfunction getOptimalPosition(element) {\n\n  var labelMid = (0,LayoutUtil/* getMid */.wS)(element.label);\n\n  var elementMid = (0,LayoutUtil/* getMid */.wS)(element);\n\n  var labelOrientation = getApproximateOrientation(elementMid, labelMid);\n\n  if (!isAligned(labelOrientation)) {\n    return;\n  }\n\n  var takenAlignments = getTakenConnectionAlignments(element);\n\n  if (element.host) {\n    var takenHostAlignments = getTakenHostAlignments(element);\n\n    takenAlignments = takenAlignments.concat(takenHostAlignments);\n  }\n\n  var freeAlignments = ALIGNMENTS.filter(function(alignment) {\n\n    return takenAlignments.indexOf(alignment) === -1;\n  });\n\n  // NOTHING TO DO; label already aligned a.O.K.\n  if (freeAlignments.indexOf(labelOrientation) !== -1) {\n    return;\n  }\n\n  return freeAlignments[0];\n}\n\nfunction getApproximateOrientation(p0, p1) {\n  return (0,LayoutUtil/* getOrientation */.T8)(p1, p0, 5);\n}\n\nfunction isAligned(orientation) {\n  return ALIGNMENTS.indexOf(orientation) !== -1;\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/AppendBehavior.js\n\n\n\n\n\n\n\nfunction AppendBehavior(eventBus, elementFactory, bpmnRules) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  // assign correct shape position unless already set\n\n  this.preExecute('shape.append', function(context) {\n\n    var source = context.source,\n        shape = context.shape;\n\n    if (!context.position) {\n\n      if ((0,ModelUtil.is)(shape, 'bpmn:TextAnnotation')) {\n        context.position = {\n          x: source.x + source.width / 2 + 75,\n          y: source.y - (50) - shape.height / 2\n        };\n      } else {\n        context.position = {\n          x: source.x + source.width + 80 + shape.width / 2,\n          y: source.y + source.height / 2\n        };\n      }\n    }\n  }, true);\n}\n\n(0,index_es/* default */.Z)(AppendBehavior, CommandInterceptor/* default */.Z);\n\nAppendBehavior.$inject = [\n  'eventBus',\n  'elementFactory',\n  'bpmnRules'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/AssociationBehavior.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nfunction AssociationBehavior(injector, modeling) {\r\n  injector.invoke(CommandInterceptor/* default */.Z, this);\r\n\r\n  this.postExecute('shape.move', function(context) {\r\n    var newParent = context.newParent,\r\n        shape = context.shape;\r\n\r\n    var associations = (0,dist_index_esm/* filter */.hX)(shape.incoming.concat(shape.outgoing), function(connection) {\r\n      return (0,ModelUtil.is)(connection, 'bpmn:Association');\r\n    });\r\n\r\n    (0,dist_index_esm/* forEach */.Ed)(associations, function(association) {\r\n      modeling.moveConnection(association, { x: 0, y: 0 }, newParent);\r\n    });\r\n  }, true);\r\n}\r\n\r\n(0,index_es/* default */.Z)(AssociationBehavior, CommandInterceptor/* default */.Z);\r\n\r\nAssociationBehavior.$inject = [\r\n  'injector',\r\n  'modeling'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/AttachEventBehavior.js\n\n\n\n\n\n\n\n\n\n\nvar AttachEventBehavior_LOW_PRIORITY = 500;\n\n\n/**\n * Replace intermediate event with boundary event when creating or moving results in attached event.\n */\nfunction AttachEventBehavior(bpmnReplace, injector) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n\n  this._bpmnReplace = bpmnReplace;\n\n  var self = this;\n\n  this.postExecuted('elements.create', AttachEventBehavior_LOW_PRIORITY, function(context) {\n    var elements = context.elements;\n\n    elements = elements.filter(function(shape) {\n      var host = shape.host;\n\n      return shouldReplace(shape, host);\n    });\n\n    if (elements.length !== 1) {\n      return;\n    }\n\n    elements.map(function(element) {\n      return elements.indexOf(element);\n    }).forEach(function(index) {\n      var host = elements[ index ];\n\n      context.elements[ index ] = self.replaceShape(elements[ index ], host);\n    });\n  }, true);\n\n\n  this.preExecute('elements.move', AttachEventBehavior_LOW_PRIORITY, function(context) {\n    var shapes = context.shapes,\n        host = context.newHost;\n\n    if (shapes.length !== 1) {\n      return;\n    }\n\n    var shape = shapes[0];\n\n    if (shouldReplace(shape, host)) {\n      context.shapes = [ self.replaceShape(shape, host) ];\n    }\n  }, true);\n}\n\nAttachEventBehavior.$inject = [\n  'bpmnReplace',\n  'injector'\n];\n\n(0,index_es/* default */.Z)(AttachEventBehavior, CommandInterceptor/* default */.Z);\n\nAttachEventBehavior.prototype.replaceShape = function(shape, host) {\n  var eventDefinition = getEventDefinition(shape);\n\n  var boundaryEvent = {\n    type: 'bpmn:BoundaryEvent',\n    host: host\n  };\n\n  if (eventDefinition) {\n    boundaryEvent.eventDefinitionType = eventDefinition.$type;\n  }\n\n  return this._bpmnReplace.replaceElement(shape, boundaryEvent, { layoutConnection: false });\n};\n\n\n// helpers //////////\n\nfunction getEventDefinition(element) {\n  var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n      eventDefinitions = businessObject.eventDefinitions;\n\n  return eventDefinitions && eventDefinitions[0];\n}\n\nfunction shouldReplace(shape, host) {\n  return !(0,util_LabelUtil/* isLabel */.j_)(shape) &&\n    (0,ModelUtil/* isAny */.JZ)(shape, [ 'bpmn:IntermediateThrowEvent', 'bpmn:IntermediateCatchEvent' ]) && !!host;\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/BoundaryEventBehavior.js\n\n\n\n\n\n\n\n\n\n/**\n * BPMN specific boundary event behavior\n */\nfunction BoundaryEventBehavior(eventBus, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  function getBoundaryEvents(element) {\n    return (0,dist_index_esm/* filter */.hX)(element.attachers, function(attacher) {\n      return (0,ModelUtil.is)(attacher, 'bpmn:BoundaryEvent');\n    });\n  }\n\n  // remove after connecting to event-based gateway\n  this.postExecute('connection.create', function(event) {\n    var source = event.context.source,\n        target = event.context.target,\n        boundaryEvents = getBoundaryEvents(target);\n\n    if (\n      (0,ModelUtil.is)(source, 'bpmn:EventBasedGateway') &&\n      (0,ModelUtil.is)(target, 'bpmn:ReceiveTask') &&\n      boundaryEvents.length > 0\n    ) {\n      modeling.removeElements(boundaryEvents);\n    }\n\n  });\n\n  // remove after replacing connected gateway with event-based gateway\n  this.postExecute('connection.reconnect', function(event) {\n    var oldSource = event.context.oldSource,\n        newSource = event.context.newSource;\n\n    if ((0,ModelUtil.is)(oldSource, 'bpmn:Gateway') &&\n        (0,ModelUtil.is)(newSource, 'bpmn:EventBasedGateway')) {\n      (0,dist_index_esm/* forEach */.Ed)(newSource.outgoing, function(connection) {\n        var target = connection.target,\n            attachedboundaryEvents = getBoundaryEvents(target);\n\n        if ((0,ModelUtil.is)(target, 'bpmn:ReceiveTask') &&\n            attachedboundaryEvents.length > 0) {\n          modeling.removeElements(attachedboundaryEvents);\n        }\n      });\n    }\n  });\n\n}\n\nBoundaryEventBehavior.$inject = [\n  'eventBus',\n  'modeling'\n];\n\n(0,index_es/* default */.Z)(BoundaryEventBehavior, CommandInterceptor/* default */.Z);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/CreateBehavior.js\n\n\n\n\n\n\n\n\n\nfunction CreateBehavior(injector) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n\n  this.preExecute('shape.create', 1500, function(event) {\n    var context = event.context,\n        parent = context.parent,\n        shape = context.shape;\n\n    if ((0,ModelUtil.is)(parent, 'bpmn:Lane') && !(0,ModelUtil.is)(shape, 'bpmn:Lane')) {\n      context.parent = (0,ModelingUtil/* getParent */.G)(parent, 'bpmn:Participant');\n    }\n  });\n\n}\n\n\nCreateBehavior.$inject = [ 'injector' ];\n\n(0,index_es/* default */.Z)(CreateBehavior, CommandInterceptor/* default */.Z);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/CreateDataObjectBehavior.js\n\n\n\n\n\n\n\n/**\n * BPMN specific create data object behavior\n */\nfunction CreateDataObjectBehavior(eventBus, bpmnFactory, moddle) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  this.preExecute('shape.create', function(event) {\n\n    var context = event.context,\n        shape = context.shape;\n\n    if ((0,ModelUtil.is)(shape, 'bpmn:DataObjectReference') && shape.type !== 'label') {\n\n      // create a DataObject every time a DataObjectReference is created\n      var dataObject = bpmnFactory.create('bpmn:DataObject');\n\n      // set the reference to the DataObject\n      shape.businessObject.dataObjectRef = dataObject;\n    }\n  });\n\n}\n\nCreateDataObjectBehavior.$inject = [\n  'eventBus',\n  'bpmnFactory',\n  'moddle'\n];\n\n(0,index_es/* default */.Z)(CreateDataObjectBehavior, CommandInterceptor/* default */.Z);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/CreateParticipantBehavior.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nvar HORIZONTAL_PARTICIPANT_PADDING = 20,\n    VERTICAL_PARTICIPANT_PADDING = 20;\n\nvar PARTICIPANT_BORDER_WIDTH = 30;\n\nvar CreateParticipantBehavior_HIGH_PRIORITY = 2000;\n\n\n/**\n * BPMN-specific behavior for creating participants.\n */\nfunction CreateParticipantBehavior(canvas, eventBus, modeling) {\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  // fit participant\n  eventBus.on([\n    'create.start',\n    'shape.move.start'\n  ], CreateParticipantBehavior_HIGH_PRIORITY, function(event) {\n    var context = event.context,\n        shape = context.shape,\n        rootElement = canvas.getRootElement();\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:Participant') ||\n      !(0,ModelUtil.is)(rootElement, 'bpmn:Process') ||\n      !rootElement.children.length) {\n      return;\n    }\n\n    // ignore connections, groups and labels\n    var children = rootElement.children.filter(function(element) {\n      return !(0,ModelUtil.is)(element, 'bpmn:Group') &&\n        !(0,util_LabelUtil/* isLabel */.j_)(element) &&\n        !CreateParticipantBehavior_isConnection(element);\n    });\n\n    // ensure for available children to calculate bounds\n    if (!children.length) {\n      return;\n    }\n\n    var childrenBBox = (0,Elements/* getBBox */.jY)(children);\n\n    var participantBounds = getParticipantBounds(shape, childrenBBox);\n\n    // assign width and height\n    (0,dist_index_esm/* assign */.f0)(shape, participantBounds);\n\n    // assign create constraints\n    context.createConstraints = getParticipantCreateConstraints(shape, childrenBBox);\n  });\n\n  // force hovering process when creating first participant\n  eventBus.on('create.start', CreateParticipantBehavior_HIGH_PRIORITY, function(event) {\n    var context = event.context,\n        shape = context.shape,\n        rootElement = canvas.getRootElement(),\n        rootElementGfx = canvas.getGraphics(rootElement);\n\n    function ensureHoveringProcess(event) {\n      event.element = rootElement;\n      event.gfx = rootElementGfx;\n    }\n\n    if ((0,ModelUtil.is)(shape, 'bpmn:Participant') && (0,ModelUtil.is)(rootElement, 'bpmn:Process')) {\n      eventBus.on('element.hover', CreateParticipantBehavior_HIGH_PRIORITY, ensureHoveringProcess);\n\n      eventBus.once('create.cleanup', function() {\n        eventBus.off('element.hover', ensureHoveringProcess);\n      });\n    }\n  });\n\n  // turn process into collaboration when creating first participant\n  function getOrCreateCollaboration() {\n    var rootElement = canvas.getRootElement();\n\n    if ((0,ModelUtil.is)(rootElement, 'bpmn:Collaboration')) {\n      return rootElement;\n    }\n\n    return modeling.makeCollaboration();\n  }\n\n  // when creating mutliple elements through `elements.create` parent must be set to collaboration\n  // and passed to `shape.create` as hint\n  this.preExecute('elements.create', CreateParticipantBehavior_HIGH_PRIORITY, function(context) {\n    var elements = context.elements,\n        parent = context.parent,\n        participant = findParticipant(elements),\n        hints;\n\n    if (participant && (0,ModelUtil.is)(parent, 'bpmn:Process')) {\n      context.parent = getOrCreateCollaboration();\n\n      hints = context.hints = context.hints || {};\n\n      hints.participant = participant;\n      hints.process = parent;\n      hints.processRef = (0,ModelUtil/* getBusinessObject */.SS)(participant).get('processRef');\n    }\n  }, true);\n\n  // when creating single shape through `shape.create` parent must be set to collaboration\n  // unless it was already set through `elements.create`\n  this.preExecute('shape.create', function(context) {\n    var parent = context.parent,\n        shape = context.shape;\n\n    if ((0,ModelUtil.is)(shape, 'bpmn:Participant') && (0,ModelUtil.is)(parent, 'bpmn:Process')) {\n      context.parent = getOrCreateCollaboration();\n\n      context.process = parent;\n      context.processRef = (0,ModelUtil/* getBusinessObject */.SS)(shape).get('processRef');\n    }\n  }, true);\n\n  // #execute necessary because #preExecute not called on CommandStack#redo\n  this.execute('shape.create', function(context) {\n    var hints = context.hints || {},\n        process = context.process || hints.process,\n        shape = context.shape,\n        participant = hints.participant;\n\n    // both shape.create and elements.create must be handled\n    if (process && (!participant || shape === participant)) {\n\n      // monkey-patch process ref\n      (0,ModelUtil/* getBusinessObject */.SS)(shape).set('processRef', (0,ModelUtil/* getBusinessObject */.SS)(process));\n    }\n  }, true);\n\n  this.revert('shape.create', function(context) {\n    var hints = context.hints || {},\n        process = context.process || hints.process,\n        processRef = context.processRef || hints.processRef,\n        shape = context.shape,\n        participant = hints.participant;\n\n    // both shape.create and elements.create must be handled\n    if (process && (!participant || shape === participant)) {\n\n      // monkey-patch process ref\n      (0,ModelUtil/* getBusinessObject */.SS)(shape).set('processRef', processRef);\n    }\n  }, true);\n\n  this.postExecute('shape.create', function(context) {\n    var hints = context.hints || {},\n        process = context.process || context.hints.process,\n        shape = context.shape,\n        participant = hints.participant;\n\n    if (process) {\n      var children = process.children.slice();\n\n      // both shape.create and elements.create must be handled\n      if (!participant) {\n        modeling.moveElements(children, { x: 0, y: 0 }, shape);\n      } else if (shape === participant) {\n        modeling.moveElements(children, { x: 0, y: 0 }, participant);\n      }\n    }\n  }, true);\n}\n\nCreateParticipantBehavior.$inject = [\n  'canvas',\n  'eventBus',\n  'modeling'\n];\n\n(0,index_es/* default */.Z)(CreateParticipantBehavior, CommandInterceptor/* default */.Z);\n\n// helpers //////////\n\nfunction getParticipantBounds(shape, childrenBBox) {\n  childrenBBox = {\n    width: childrenBBox.width + HORIZONTAL_PARTICIPANT_PADDING * 2 + PARTICIPANT_BORDER_WIDTH,\n    height: childrenBBox.height + VERTICAL_PARTICIPANT_PADDING * 2\n  };\n\n  var width = Math.max(shape.width, childrenBBox.width),\n      height = Math.max(shape.height, childrenBBox.height);\n\n  return {\n    x: -width / 2,\n    y: -height / 2,\n    width: width,\n    height: height\n  };\n}\n\nfunction getParticipantCreateConstraints(shape, childrenBBox) {\n  childrenBBox = (0,LayoutUtil/* asTRBL */.JA)(childrenBBox);\n\n  return {\n    bottom: childrenBBox.top + shape.height / 2 - VERTICAL_PARTICIPANT_PADDING,\n    left: childrenBBox.right - shape.width / 2 + HORIZONTAL_PARTICIPANT_PADDING,\n    top: childrenBBox.bottom - shape.height / 2 + VERTICAL_PARTICIPANT_PADDING,\n    right: childrenBBox.left + shape.width / 2 - HORIZONTAL_PARTICIPANT_PADDING - PARTICIPANT_BORDER_WIDTH\n  };\n}\n\nfunction CreateParticipantBehavior_isConnection(element) {\n  return !!element.waypoints;\n}\n\nfunction findParticipant(elements) {\n  return (0,dist_index_esm/* find */.sE)(elements, function(element) {\n    return (0,ModelUtil.is)(element, 'bpmn:Participant');\n  });\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Collections.js\nvar Collections = __webpack_require__(\"./node_modules/diagram-js/lib/util/Collections.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/DataInputAssociationBehavior.js\n\n\n\n\n\n\n\n\n\n\nvar TARGET_REF_PLACEHOLDER_NAME = '__targetRef_placeholder';\n\n\n/**\n * This behavior makes sure we always set a fake\n * DataInputAssociation#targetRef as demanded by the BPMN 2.0\n * XSD schema.\n *\n * The reference is set to a bpmn:Property{ name: '__targetRef_placeholder' }\n * which is created on the fly and cleaned up afterwards if not needed\n * anymore.\n *\n * @param {EventBus} eventBus\n * @param {BpmnFactory} bpmnFactory\n */\nfunction DataInputAssociationBehavior(eventBus, bpmnFactory) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n\n  this.executed([\n    'connection.create',\n    'connection.delete',\n    'connection.move',\n    'connection.reconnect'\n  ], ifDataInputAssociation(fixTargetRef));\n\n  this.reverted([\n    'connection.create',\n    'connection.delete',\n    'connection.move',\n    'connection.reconnect'\n  ], ifDataInputAssociation(fixTargetRef));\n\n\n  function usesTargetRef(element, targetRef, removedConnection) {\n\n    var inputAssociations = element.get('dataInputAssociations');\n\n    return (0,dist_index_esm/* find */.sE)(inputAssociations, function(association) {\n      return association !== removedConnection &&\n             association.targetRef === targetRef;\n    });\n  }\n\n  function getTargetRef(element, create) {\n\n    var properties = element.get('properties');\n\n    var targetRefProp = (0,dist_index_esm/* find */.sE)(properties, function(p) {\n      return p.name === TARGET_REF_PLACEHOLDER_NAME;\n    });\n\n    if (!targetRefProp && create) {\n      targetRefProp = bpmnFactory.create('bpmn:Property', {\n        name: TARGET_REF_PLACEHOLDER_NAME\n      });\n\n      (0,Collections/* add */.IH)(properties, targetRefProp);\n    }\n\n    return targetRefProp;\n  }\n\n  function cleanupTargetRef(element, connection) {\n\n    var targetRefProp = getTargetRef(element);\n\n    if (!targetRefProp) {\n      return;\n    }\n\n    if (!usesTargetRef(element, targetRefProp, connection)) {\n      (0,Collections/* remove */.Od)(element.get('properties'), targetRefProp);\n    }\n  }\n\n  /**\n   * Make sure targetRef is set to a valid property or\n   * `null` if the connection is detached.\n   *\n   * @param {Event} event\n   */\n  function fixTargetRef(event) {\n\n    var context = event.context,\n        connection = context.connection,\n        connectionBo = connection.businessObject,\n        target = connection.target,\n        targetBo = target && target.businessObject,\n        newTarget = context.newTarget,\n        newTargetBo = newTarget && newTarget.businessObject,\n        oldTarget = context.oldTarget || context.target,\n        oldTargetBo = oldTarget && oldTarget.businessObject;\n\n    var dataAssociation = connection.businessObject,\n        targetRefProp;\n\n    if (oldTargetBo && oldTargetBo !== targetBo) {\n      cleanupTargetRef(oldTargetBo, connectionBo);\n    }\n\n    if (newTargetBo && newTargetBo !== targetBo) {\n      cleanupTargetRef(newTargetBo, connectionBo);\n    }\n\n    if (targetBo) {\n      targetRefProp = getTargetRef(targetBo, true);\n      dataAssociation.targetRef = targetRefProp;\n    } else {\n      dataAssociation.targetRef = null;\n    }\n  }\n}\n\nDataInputAssociationBehavior.$inject = [\n  'eventBus',\n  'bpmnFactory'\n];\n\n(0,index_es/* default */.Z)(DataInputAssociationBehavior, CommandInterceptor/* default */.Z);\n\n\n/**\n * Only call the given function when the event\n * touches a bpmn:DataInputAssociation.\n *\n * @param {Function} fn\n * @return {Function}\n */\nfunction ifDataInputAssociation(fn) {\n\n  return function(event) {\n    var context = event.context,\n        connection = context.connection;\n\n    if ((0,ModelUtil.is)(connection, 'bpmn:DataInputAssociation')) {\n      return fn(event);\n    }\n  };\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/UpdateSemanticParentHandler.js\nfunction UpdateSemanticParentHandler(bpmnUpdater) {\r\n  this._bpmnUpdater = bpmnUpdater;\r\n}\r\n\r\nUpdateSemanticParentHandler.$inject = [ 'bpmnUpdater' ];\r\n\r\n\r\nUpdateSemanticParentHandler.prototype.execute = function(context) {\r\n  var dataStoreBo = context.dataStoreBo,\r\n      dataStoreDi = context.dataStoreDi,\r\n      newSemanticParent = context.newSemanticParent,\r\n      newDiParent = context.newDiParent;\r\n\r\n  context.oldSemanticParent = dataStoreBo.$parent;\r\n  context.oldDiParent = dataStoreDi.$parent;\r\n\r\n  // update semantic parent\r\n  this._bpmnUpdater.updateSemanticParent(dataStoreBo, newSemanticParent);\r\n\r\n  // update DI parent\r\n  this._bpmnUpdater.updateDiParent(dataStoreDi, newDiParent);\r\n};\r\n\r\nUpdateSemanticParentHandler.prototype.revert = function(context) {\r\n  var dataStoreBo = context.dataStoreBo,\r\n      dataStoreDi = context.dataStoreDi,\r\n      oldSemanticParent = context.oldSemanticParent,\r\n      oldDiParent = context.oldDiParent;\r\n\r\n  // update semantic parent\r\n  this._bpmnUpdater.updateSemanticParent(dataStoreBo, oldSemanticParent);\r\n\r\n  // update DI parent\r\n  this._bpmnUpdater.updateDiParent(dataStoreDi, oldDiParent);\r\n};\r\n\r\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/DataStoreBehavior.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * BPMN specific data store behavior\r\n */\r\nfunction DataStoreBehavior(\r\n    canvas, commandStack, elementRegistry,\r\n    eventBus) {\r\n\r\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\r\n\r\n  commandStack.registerHandler('dataStore.updateContainment', UpdateSemanticParentHandler);\r\n\r\n  function getFirstParticipantWithProcessRef() {\r\n    return elementRegistry.filter(function(element) {\r\n      return (0,ModelUtil.is)(element, 'bpmn:Participant') && (0,ModelUtil/* getBusinessObject */.SS)(element).processRef;\r\n    })[0];\r\n  }\r\n\r\n  function getDataStores(element) {\r\n    return element.children.filter(function(child) {\r\n      return (0,ModelUtil.is)(child, 'bpmn:DataStoreReference') && !child.labelTarget;\r\n    });\r\n  }\r\n\r\n  function updateDataStoreParent(dataStore, newDataStoreParent) {\r\n    var dataStoreBo = dataStore.businessObject || dataStore;\r\n\r\n    newDataStoreParent = newDataStoreParent || getFirstParticipantWithProcessRef();\r\n\r\n    if (newDataStoreParent) {\r\n      var newDataStoreParentBo = newDataStoreParent.businessObject || newDataStoreParent;\r\n\r\n      commandStack.execute('dataStore.updateContainment', {\r\n        dataStoreBo: dataStoreBo,\r\n        dataStoreDi: (0,ModelUtil/* getDi */.DN)(dataStore),\r\n        newSemanticParent: newDataStoreParentBo.processRef || newDataStoreParentBo,\r\n        newDiParent: (0,ModelUtil/* getDi */.DN)(newDataStoreParent)\r\n      });\r\n    }\r\n  }\r\n\r\n\r\n  // disable auto-resize for data stores\r\n  this.preExecute('shape.create', function(event) {\r\n\r\n    var context = event.context,\r\n        shape = context.shape;\r\n\r\n    if ((0,ModelUtil.is)(shape, 'bpmn:DataStoreReference') &&\r\n        shape.type !== 'label') {\r\n\r\n      if (!context.hints) {\r\n        context.hints = {};\r\n      }\r\n\r\n      // prevent auto resizing\r\n      context.hints.autoResize = false;\r\n    }\r\n  });\r\n\r\n\r\n  // disable auto-resize for data stores\r\n  this.preExecute('elements.move', function(event) {\r\n    var context = event.context,\r\n        shapes = context.shapes;\r\n\r\n    var dataStoreReferences = shapes.filter(function(shape) {\r\n      return (0,ModelUtil.is)(shape, 'bpmn:DataStoreReference');\r\n    });\r\n\r\n    if (dataStoreReferences.length) {\r\n      if (!context.hints) {\r\n        context.hints = {};\r\n      }\r\n\r\n      // prevent auto resizing for data store references\r\n      context.hints.autoResize = shapes.filter(function(shape) {\r\n        return !(0,ModelUtil.is)(shape, 'bpmn:DataStoreReference');\r\n      });\r\n    }\r\n  });\r\n\r\n\r\n  // update parent on data store created\r\n  this.postExecute('shape.create', function(event) {\r\n    var context = event.context,\r\n        shape = context.shape,\r\n        parent = shape.parent;\r\n\r\n\r\n    if ((0,ModelUtil.is)(shape, 'bpmn:DataStoreReference') &&\r\n        shape.type !== 'label' &&\r\n        (0,ModelUtil.is)(parent, 'bpmn:Collaboration')) {\r\n\r\n      updateDataStoreParent(shape);\r\n    }\r\n  });\r\n\r\n\r\n  // update parent on data store moved\r\n  this.postExecute('shape.move', function(event) {\r\n    var context = event.context,\r\n        shape = context.shape,\r\n        oldParent = context.oldParent,\r\n        parent = shape.parent;\r\n\r\n    if ((0,ModelUtil.is)(oldParent, 'bpmn:Collaboration')) {\r\n\r\n      // do nothing if not necessary\r\n      return;\r\n    }\r\n\r\n    if ((0,ModelUtil.is)(shape, 'bpmn:DataStoreReference') &&\r\n        shape.type !== 'label' &&\r\n        (0,ModelUtil.is)(parent, 'bpmn:Collaboration')) {\r\n\r\n      var participant = (0,ModelUtil.is)(oldParent, 'bpmn:Participant') ?\r\n        oldParent :\r\n        getAncestor(oldParent, 'bpmn:Participant');\r\n\r\n      updateDataStoreParent(shape, participant);\r\n    }\r\n  });\r\n\r\n\r\n  // update data store parents on participant or subprocess deleted\r\n  this.postExecute('shape.delete', function(event) {\r\n    var context = event.context,\r\n        shape = context.shape,\r\n        rootElement = canvas.getRootElement();\r\n\r\n    if ((0,ModelUtil/* isAny */.JZ)(shape, [ 'bpmn:Participant', 'bpmn:SubProcess' ])\r\n        && (0,ModelUtil.is)(rootElement, 'bpmn:Collaboration')) {\r\n      getDataStores(rootElement)\r\n        .filter(function(dataStore) {\r\n          return isDescendant(dataStore, shape);\r\n        })\r\n        .forEach(function(dataStore) {\r\n          updateDataStoreParent(dataStore);\r\n        });\r\n    }\r\n  });\r\n\r\n  // update data store parents on collaboration -> process\r\n  this.postExecute('canvas.updateRoot', function(event) {\r\n    var context = event.context,\r\n        oldRoot = context.oldRoot,\r\n        newRoot = context.newRoot;\r\n\r\n    var dataStores = getDataStores(oldRoot);\r\n\r\n    dataStores.forEach(function(dataStore) {\r\n\r\n      if ((0,ModelUtil.is)(newRoot, 'bpmn:Process')) {\r\n        updateDataStoreParent(dataStore, newRoot);\r\n      }\r\n\r\n    });\r\n  });\r\n}\r\n\r\nDataStoreBehavior.$inject = [\r\n  'canvas',\r\n  'commandStack',\r\n  'elementRegistry',\r\n  'eventBus',\r\n];\r\n\r\n(0,index_es/* default */.Z)(DataStoreBehavior, CommandInterceptor/* default */.Z);\r\n\r\n\r\n// helpers //////////\r\n\r\nfunction isDescendant(descendant, ancestor) {\r\n  var descendantBo = descendant.businessObject || descendant,\r\n      ancestorBo = ancestor.businessObject || ancestor;\r\n\r\n  while (descendantBo.$parent) {\r\n    if (descendantBo.$parent === ancestorBo.processRef || ancestorBo) {\r\n      return true;\r\n    }\r\n\r\n    descendantBo = descendantBo.$parent;\r\n  }\r\n\r\n  return false;\r\n}\r\n\r\nfunction getAncestor(element, type) {\r\n\r\n  while (element.parent) {\r\n    if ((0,ModelUtil.is)(element.parent, type)) {\r\n      return element.parent;\r\n    }\r\n\r\n    element = element.parent;\r\n  }\r\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/DeleteLaneBehavior.js\n\n\n\n\n\n\n\n\n\n\n\nvar DeleteLaneBehavior_LOW_PRIORITY = 500;\n\n\n/**\n * BPMN specific delete lane behavior\n */\nfunction DeleteLaneBehavior(eventBus, modeling, spaceTool) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n\n  function compensateLaneDelete(shape, oldParent) {\n\n    var siblings = getChildLanes(oldParent);\n\n    var topAffected = [];\n    var bottomAffected = [];\n\n    (0,Elements/* eachElement */.om)(siblings, function(element) {\n\n      if (element.y > shape.y) {\n        bottomAffected.push(element);\n      } else {\n        topAffected.push(element);\n      }\n\n      return element.children;\n    });\n\n    if (!siblings.length) {\n      return;\n    }\n\n    var offset;\n\n    if (bottomAffected.length && topAffected.length) {\n      offset = shape.height / 2;\n    } else {\n      offset = shape.height;\n    }\n\n    var topAdjustments,\n        bottomAdjustments;\n\n    if (topAffected.length) {\n      topAdjustments = spaceTool.calculateAdjustments(\n        topAffected, 'y', offset, shape.y - 10);\n\n      spaceTool.makeSpace(\n        topAdjustments.movingShapes,\n        topAdjustments.resizingShapes,\n        { x: 0, y: offset }, 's');\n    }\n\n    if (bottomAffected.length) {\n      bottomAdjustments = spaceTool.calculateAdjustments(\n        bottomAffected, 'y', -offset, shape.y + shape.height + 10);\n\n      spaceTool.makeSpace(\n        bottomAdjustments.movingShapes,\n        bottomAdjustments.resizingShapes,\n        { x: 0, y: -offset }, 'n');\n    }\n  }\n\n\n  /**\n   * Adjust sizes of other lanes after lane deletion\n   */\n  this.postExecuted('shape.delete', DeleteLaneBehavior_LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        hints = context.hints,\n        shape = context.shape,\n        oldParent = context.oldParent;\n\n    // only compensate lane deletes\n    if (!(0,ModelUtil.is)(shape, 'bpmn:Lane')) {\n      return;\n    }\n\n    // compensate root deletes only\n    if (hints && hints.nested) {\n      return;\n    }\n\n    compensateLaneDelete(shape, oldParent);\n  });\n}\n\nDeleteLaneBehavior.$inject = [\n  'eventBus',\n  'modeling',\n  'spaceTool'\n];\n\n(0,index_es/* default */.Z)(DeleteLaneBehavior, CommandInterceptor/* default */.Z);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/DetachEventBehavior.js\n\n\n\n\n\n\n\n\nvar DetachEventBehavior_LOW_PRIORITY = 500;\n\n\n/**\n * Replace boundary event with intermediate event when creating or moving results in detached event.\n */\nfunction DetachEventBehavior(bpmnReplace, injector) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n\n  this._bpmnReplace = bpmnReplace;\n\n  var self = this;\n\n  this.postExecuted('elements.create', DetachEventBehavior_LOW_PRIORITY, function(context) {\n    var elements = context.elements;\n\n    elements.filter(function(shape) {\n      var host = shape.host;\n\n      return DetachEventBehavior_shouldReplace(shape, host);\n    }).map(function(shape) {\n      return elements.indexOf(shape);\n    }).forEach(function(index) {\n      context.elements[ index ] = self.replaceShape(elements[ index ]);\n    });\n  }, true);\n\n  this.preExecute('elements.move', DetachEventBehavior_LOW_PRIORITY, function(context) {\n    var shapes = context.shapes,\n        newHost = context.newHost;\n\n    shapes.forEach(function(shape, index) {\n      var host = shape.host;\n\n      if (DetachEventBehavior_shouldReplace(shape, DetachEventBehavior_includes(shapes, host) ? host : newHost)) {\n        shapes[ index ] = self.replaceShape(shape);\n      }\n    });\n  }, true);\n}\n\nDetachEventBehavior.$inject = [\n  'bpmnReplace',\n  'injector'\n];\n\n(0,index_es/* default */.Z)(DetachEventBehavior, CommandInterceptor/* default */.Z);\n\nDetachEventBehavior.prototype.replaceShape = function(shape) {\n  var eventDefinition = DetachEventBehavior_getEventDefinition(shape),\n      intermediateEvent;\n\n  if (eventDefinition) {\n    intermediateEvent = {\n      type: 'bpmn:IntermediateCatchEvent',\n      eventDefinitionType: eventDefinition.$type\n    };\n  } else {\n    intermediateEvent = {\n      type: 'bpmn:IntermediateThrowEvent'\n    };\n  }\n\n  return this._bpmnReplace.replaceElement(shape, intermediateEvent, { layoutConnection: false });\n};\n\n\n// helpers //////////\n\nfunction DetachEventBehavior_getEventDefinition(element) {\n  var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n      eventDefinitions = businessObject.eventDefinitions;\n\n  return eventDefinitions && eventDefinitions[0];\n}\n\nfunction DetachEventBehavior_shouldReplace(shape, host) {\n  return !(0,util_LabelUtil/* isLabel */.j_)(shape) && (0,ModelUtil.is)(shape, 'bpmn:BoundaryEvent') && !host;\n}\n\nfunction DetachEventBehavior_includes(array, item) {\n  return array.indexOf(item) !== -1;\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/LineIntersection.js\nvar LineIntersection = __webpack_require__(\"./node_modules/diagram-js/lib/util/LineIntersection.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/DropOnFlowBehavior.js\n\n\n\n\n\n\n\n\n\n\n\nfunction DropOnFlowBehavior(eventBus, bpmnRules, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  /**\n   * Reconnect start / end of a connection after\n   * dropping an element on a flow.\n   */\n\n  function insertShape(shape, targetFlow, positionOrBounds) {\n    var waypoints = targetFlow.waypoints,\n        waypointsBefore,\n        waypointsAfter,\n        dockingPoint,\n        source,\n        target,\n        incomingConnection,\n        outgoingConnection,\n        oldOutgoing = shape.outgoing.slice(),\n        oldIncoming = shape.incoming.slice();\n\n    var mid;\n\n    if ((0,dist_index_esm/* isNumber */.hj)(positionOrBounds.width)) {\n      mid = (0,LayoutUtil/* getMid */.wS)(positionOrBounds);\n    } else {\n      mid = positionOrBounds;\n    }\n\n    var intersection = (0,LineIntersection/* getApproxIntersection */.t)(waypoints, mid);\n\n    if (intersection) {\n      waypointsBefore = waypoints.slice(0, intersection.index);\n      waypointsAfter = waypoints.slice(intersection.index + (intersection.bendpoint ? 1 : 0));\n\n      // due to inaccuracy intersection might have been found\n      if (!waypointsBefore.length || !waypointsAfter.length) {\n        return;\n      }\n\n      dockingPoint = intersection.bendpoint ? waypoints[intersection.index] : mid;\n\n      // if last waypointBefore is inside shape's bounds, ignore docking point\n      if (waypointsBefore.length === 1 || !isPointInsideBBox(shape, waypointsBefore[waypointsBefore.length - 1])) {\n        waypointsBefore.push(copy(dockingPoint));\n      }\n\n      // if first waypointAfter is inside shape's bounds, ignore docking point\n      if (waypointsAfter.length === 1 || !isPointInsideBBox(shape, waypointsAfter[0])) {\n        waypointsAfter.unshift(copy(dockingPoint));\n      }\n    }\n\n    source = targetFlow.source;\n    target = targetFlow.target;\n\n    if (bpmnRules.canConnect(source, shape, targetFlow)) {\n\n      // reconnect source -> inserted shape\n      modeling.reconnectEnd(targetFlow, shape, waypointsBefore || mid);\n\n      incomingConnection = targetFlow;\n    }\n\n    if (bpmnRules.canConnect(shape, target, targetFlow)) {\n\n      if (!incomingConnection) {\n\n        // reconnect inserted shape -> end\n        modeling.reconnectStart(targetFlow, shape, waypointsAfter || mid);\n\n        outgoingConnection = targetFlow;\n      } else {\n        outgoingConnection = modeling.connect(\n          shape, target, { type: targetFlow.type, waypoints: waypointsAfter }\n        );\n      }\n    }\n\n    var duplicateConnections = [].concat(\n\n      incomingConnection && (0,dist_index_esm/* filter */.hX)(oldIncoming, function(connection) {\n        return connection.source === incomingConnection.source;\n      }) || [],\n\n      outgoingConnection && (0,dist_index_esm/* filter */.hX)(oldOutgoing, function(connection) {\n        return connection.target === outgoingConnection.target;\n      }) || []\n    );\n\n    if (duplicateConnections.length) {\n      modeling.removeElements(duplicateConnections);\n    }\n  }\n\n  this.preExecute('elements.move', function(context) {\n\n    var newParent = context.newParent,\n        shapes = context.shapes,\n        delta = context.delta,\n        shape = shapes[0];\n\n    if (!shape || !newParent) {\n      return;\n    }\n\n    // if the new parent is a connection,\n    // change it to the new parent's parent\n    if (newParent && newParent.waypoints) {\n      context.newParent = newParent = newParent.parent;\n    }\n\n    var shapeMid = (0,LayoutUtil/* getMid */.wS)(shape);\n    var newShapeMid = {\n      x: shapeMid.x + delta.x,\n      y: shapeMid.y + delta.y\n    };\n\n    // find a connection which intersects with the\n    // element's mid point\n    var connection = (0,dist_index_esm/* find */.sE)(newParent.children, function(element) {\n      var canInsert = bpmnRules.canInsert(shapes, element);\n\n      return canInsert && (0,LineIntersection/* getApproxIntersection */.t)(element.waypoints, newShapeMid);\n    });\n\n    if (connection) {\n      context.targetFlow = connection;\n      context.position = newShapeMid;\n    }\n\n  }, true);\n\n  this.postExecuted('elements.move', function(context) {\n\n    var shapes = context.shapes,\n        targetFlow = context.targetFlow,\n        position = context.position;\n\n    if (targetFlow) {\n      insertShape(shapes[0], targetFlow, position);\n    }\n\n  }, true);\n\n  this.preExecute('shape.create', function(context) {\n\n    var parent = context.parent,\n        shape = context.shape;\n\n    if (bpmnRules.canInsert(shape, parent)) {\n      context.targetFlow = parent;\n      context.parent = parent.parent;\n    }\n  }, true);\n\n  this.postExecuted('shape.create', function(context) {\n\n    var shape = context.shape,\n        targetFlow = context.targetFlow,\n        positionOrBounds = context.position;\n\n    if (targetFlow) {\n      insertShape(shape, targetFlow, positionOrBounds);\n    }\n  }, true);\n}\n\n(0,index_es/* default */.Z)(DropOnFlowBehavior, CommandInterceptor/* default */.Z);\n\nDropOnFlowBehavior.$inject = [\n  'eventBus',\n  'bpmnRules',\n  'modeling'\n];\n\n\n// helpers /////////////////////\n\nfunction isPointInsideBBox(bbox, point) {\n  var x = point.x,\n      y = point.y;\n\n  return x >= bbox.x &&\n    x <= bbox.x + bbox.width &&\n    y >= bbox.y &&\n    y <= bbox.y + bbox.height;\n}\n\nfunction copy(obj) {\n  return (0,dist_index_esm/* assign */.f0)({}, obj);\n}\n\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/EventBasedGatewayBehavior.js\n\n\n\n\n\n\nfunction EventBasedGatewayBehavior(eventBus, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  /**\n   * Remove incoming sequence flows of event-based target when creating\n   * sequence flow.\n   *\n   * 1. If source is event-based gateway remove all incoming sequence flows\n   * 2. If source is not event-based gateway remove all incoming sequence flows\n   * whose source is event-based gateway\n   */\n  this.preExecuted('connection.create', function(event) {\n    var context = event.context,\n        connection = context.connection,\n        source = context.source,\n        target = context.target,\n        hints = context.hints;\n\n    if (hints && hints.createElementsBehavior === false) {\n      return;\n    }\n\n    if (!isSequenceFlow(connection)) {\n      return;\n    }\n\n    var sequenceFlows = [];\n\n    if ((0,ModelUtil.is)(source, 'bpmn:EventBasedGateway')) {\n      sequenceFlows = target.incoming.filter(isSequenceFlow);\n    } else {\n      sequenceFlows = target.incoming.filter(function(connection) {\n        return isSequenceFlow(connection)\n          && (0,ModelUtil.is)(connection.source, 'bpmn:EventBasedGateway');\n      });\n    }\n\n    sequenceFlows.forEach(function(sequenceFlow) {\n      modeling.removeConnection(sequenceFlow);\n    });\n  });\n\n  /**\n   * Remove incoming sequence flows of event-based targets when replacing source\n   * with event-based gateway.\n   */\n  this.preExecuted('shape.replace', function(event) {\n    var context = event.context,\n        newShape = context.newShape;\n\n    if (!(0,ModelUtil.is)(newShape, 'bpmn:EventBasedGateway')) {\n      return;\n    }\n\n    var targets = newShape.outgoing.filter(isSequenceFlow)\n      .reduce(function(targets, sequenceFlow) {\n        if (!targets.includes(sequenceFlow.target)) {\n          return targets.concat(sequenceFlow.target);\n        }\n\n        return targets;\n      }, []);\n\n    targets.forEach(function(target) {\n      target.incoming.filter(isSequenceFlow).forEach(function(sequenceFlow) {\n        const sequenceFlowsFromNewShape = target.incoming.filter(isSequenceFlow).filter(function(sequenceFlow) {\n          return sequenceFlow.source === newShape;\n        });\n\n        if (sequenceFlow.source !== newShape || sequenceFlowsFromNewShape.length > 1) {\n          modeling.removeConnection(sequenceFlow);\n        }\n      });\n    });\n  });\n}\n\nEventBasedGatewayBehavior.$inject = [\n  'eventBus',\n  'modeling'\n];\n\n(0,index_es/* default */.Z)(EventBasedGatewayBehavior, CommandInterceptor/* default */.Z);\n\n// helpers //////////\n\nfunction isSequenceFlow(connection) {\n  return (0,ModelUtil.is)(connection, 'bpmn:SequenceFlow');\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/FixHoverBehavior.js\n\r\n\r\n\r\n\r\n\r\n\r\nvar FixHoverBehavior_HIGH_PRIORITY = 1500;\r\nvar HIGHEST_PRIORITY = 2000;\r\n\r\n\r\n/**\r\n * Correct hover targets in certain situations to improve diagram interaction.\r\n *\r\n * @param {ElementRegistry} elementRegistry\r\n * @param {EventBus} eventBus\r\n * @param {Canvas} canvas\r\n */\r\nfunction FixHoverBehavior(elementRegistry, eventBus, canvas) {\r\n\r\n  eventBus.on([\r\n    'create.hover',\r\n    'create.move',\r\n    'create.out',\r\n    'create.end',\r\n    'shape.move.hover',\r\n    'shape.move.move',\r\n    'shape.move.out',\r\n    'shape.move.end'\r\n  ], FixHoverBehavior_HIGH_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        shape = context.shape || event.shape,\r\n        hover = event.hover;\r\n\r\n    // ensure elements are not dropped onto a bpmn:Lane but onto\r\n    // the underlying bpmn:Participant\r\n    if ((0,ModelUtil.is)(hover, 'bpmn:Lane') && !(0,ModelUtil/* isAny */.JZ)(shape, [ 'bpmn:Lane', 'bpmn:Participant' ])) {\r\n      event.hover = getLanesRoot(hover);\r\n      event.hoverGfx = elementRegistry.getGraphics(event.hover);\r\n    }\r\n\r\n    var rootElement = canvas.getRootElement();\r\n\r\n    // ensure bpmn:Group and label elements are dropped\r\n    // always onto the root\r\n    if (hover !== rootElement && (shape.labelTarget || (0,ModelUtil.is)(shape, 'bpmn:Group'))) {\r\n      event.hover = rootElement;\r\n      event.hoverGfx = elementRegistry.getGraphics(event.hover);\r\n    }\r\n  });\r\n\r\n  eventBus.on([\r\n    'connect.hover',\r\n    'connect.out',\r\n    'connect.end',\r\n    'connect.cleanup',\r\n    'global-connect.hover',\r\n    'global-connect.out',\r\n    'global-connect.end',\r\n    'global-connect.cleanup'\r\n  ], FixHoverBehavior_HIGH_PRIORITY, function(event) {\r\n    var hover = event.hover;\r\n\r\n    // ensure connections start/end on bpmn:Participant,\r\n    // not the underlying bpmn:Lane\r\n    if ((0,ModelUtil.is)(hover, 'bpmn:Lane')) {\r\n      event.hover = getLanesRoot(hover) || hover;\r\n      event.hoverGfx = elementRegistry.getGraphics(event.hover);\r\n    }\r\n  });\r\n\r\n\r\n  eventBus.on([\r\n    'bendpoint.move.hover'\r\n  ], FixHoverBehavior_HIGH_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        hover = event.hover,\r\n        type = context.type;\r\n\r\n    // ensure reconnect start/end on bpmn:Participant,\r\n    // not the underlying bpmn:Lane\r\n    if ((0,ModelUtil.is)(hover, 'bpmn:Lane') && /reconnect/.test(type)) {\r\n      event.hover = getLanesRoot(hover) || hover;\r\n      event.hoverGfx = elementRegistry.getGraphics(event.hover);\r\n    }\r\n  });\r\n\r\n\r\n  eventBus.on([\r\n    'connect.start'\r\n  ], FixHoverBehavior_HIGH_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        start = context.start;\r\n\r\n    // ensure connect start on bpmn:Participant,\r\n    // not the underlying bpmn:Lane\r\n    if ((0,ModelUtil.is)(start, 'bpmn:Lane')) {\r\n      context.start = getLanesRoot(start) || start;\r\n    }\r\n  });\r\n\r\n\r\n  // allow movement of participants from lanes\r\n  eventBus.on('shape.move.start', HIGHEST_PRIORITY, function(event) {\r\n    var shape = event.shape;\r\n\r\n    if ((0,ModelUtil.is)(shape, 'bpmn:Lane')) {\r\n      event.shape = getLanesRoot(shape) || shape;\r\n    }\r\n  });\r\n\r\n}\r\n\r\nFixHoverBehavior.$inject = [\r\n  'elementRegistry',\r\n  'eventBus',\r\n  'canvas'\r\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/util/CategoryUtil.js\n\n\n\n/**\n * Creates a new bpmn:CategoryValue inside a new bpmn:Category\n *\n * @param {BpmnFactory} bpmnFactory\n *\n * @return {ModdleElement} categoryValue.\n */\nfunction createCategory(bpmnFactory) {\n  return bpmnFactory.create('bpmn:Category');\n}\n\n/**\n * Creates a new bpmn:CategoryValue inside a new bpmn:Category\n *\n * @param {BpmnFactory} bpmnFactory\n *\n * @return {ModdleElement} categoryValue.\n */\nfunction createCategoryValue(bpmnFactory) {\n  return bpmnFactory.create('bpmn:CategoryValue');\n}\n\n/**\n * Adds category value to definitions\n *\n * @param {ModdleElement} categoryValue\n * @param {ModdleElement} category\n * @param {ModdleElement} definitions\n *\n * @return {ModdleElement} categoryValue\n */\nfunction linkCategoryValue(categoryValue, category, definitions) {\n  (0,Collections/* add */.IH)(category.get('categoryValue'), categoryValue);\n  categoryValue.$parent = category;\n\n  (0,Collections/* add */.IH)(definitions.get('rootElements'), category);\n  category.$parent = definitions;\n\n  return categoryValue;\n}\n\n/**\n * Unlink category value from parent\n *\n * @param {ModdleElement} categoryValue\n *\n * @return {ModdleElement} categoryValue\n */\nfunction unlinkCategoryValue(categoryValue) {\n  var category = categoryValue.$parent;\n\n  if (category) {\n    (0,Collections/* remove */.Od)(category.get('categoryValue'), categoryValue);\n    categoryValue.$parent = null;\n  }\n\n  return categoryValue;\n}\n\n/**\n * Unlink category from parent\n *\n * @param {ModdleElement} category\n * @param {ModdleElement} definitions\n *\n * @return {ModdleElement} categoryValue\n */\nfunction unlinkCategory(category) {\n  var definitions = category.$parent;\n\n  if (definitions) {\n    (0,Collections/* remove */.Od)(definitions.get('rootElements'), category);\n    category.$parent = null;\n  }\n\n  return category;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/GroupBehavior.js\n\n\n\n\n\n\n\n\n\nvar LOWER_PRIORITY = 770;\n\n\n/**\n * BPMN specific Group behavior\n */\nfunction GroupBehavior(\n    bpmnFactory,\n    bpmnjs,\n    elementRegistry,\n    eventBus,\n    injector,\n    moddleCopy\n) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n\n  /**\n   * Returns all group element in the current registry\n   *\n   * @return {Array<djs.model.shape>} a list of group shapes\n   */\n  function getGroupElements() {\n    return elementRegistry.filter(function(e) {\n      return (0,ModelUtil.is)(e, 'bpmn:Group');\n    });\n  }\n\n  /**\n   * Returns true if given category is referenced in one of the given elements\n   *\n   * @param { djs.model.Element[] } elements\n   * @param { ModdleElement } category\n   *\n   * @return { boolean }\n   */\n  function isReferencedCategory(elements, category) {\n    return elements.some(function(element) {\n      var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n      var _category = businessObject.categoryValueRef && businessObject.categoryValueRef.$parent;\n\n      return _category === category;\n    });\n  }\n\n  /**\n   * Returns true if given categoryValue is referenced in one of the given elements\n   *\n   * @param { djs.model.Element[] } elements\n   * @param { ModdleElement } categoryValue\n   *\n   * @return { boolean }\n   */\n  function isReferencedCategoryValue(elements, categoryValue) {\n    return elements.some(function(element) {\n      var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n      return businessObject.categoryValueRef === categoryValue;\n    });\n  }\n\n  /**\n   * Remove category value unless it is still referenced\n   *\n   * @param {ModdleElement} categoryValue\n   * @param {ModdleElement} category\n   * @param {ModdleElement} businessObject\n   */\n  function removeCategoryValue(categoryValue, category, businessObject) {\n\n    var groups = getGroupElements().filter(function(element) {\n      return element.businessObject !== businessObject;\n    });\n\n    if (category && !isReferencedCategory(groups, category)) {\n      unlinkCategory(category);\n    }\n\n    if (categoryValue && !isReferencedCategoryValue(groups, categoryValue)) {\n      unlinkCategoryValue(categoryValue);\n    }\n  }\n\n  /**\n   * Add category value\n   *\n   * @param {ModdleElement} categoryValue\n   * @param {ModdleElement} category\n   */\n  function addCategoryValue(categoryValue, category) {\n    return linkCategoryValue(categoryValue, category, bpmnjs.getDefinitions());\n  }\n\n  function setCategoryValue(element, context) {\n    var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\n        categoryValue = businessObject.categoryValueRef;\n\n    if (!categoryValue) {\n      categoryValue =\n      businessObject.categoryValueRef =\n      context.categoryValue = (\n        context.categoryValue || createCategoryValue(bpmnFactory)\n      );\n    }\n\n    var category = categoryValue.$parent;\n\n    if (!category) {\n      category =\n      categoryValue.$parent =\n      context.category = (\n        context.category || createCategory(bpmnFactory)\n      );\n    }\n\n    addCategoryValue(categoryValue, category, bpmnjs.getDefinitions());\n  }\n\n  function unsetCategoryValue(element, context) {\n    var category = context.category,\n        categoryValue = context.categoryValue,\n        businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n    if (categoryValue) {\n      businessObject.categoryValueRef = null;\n\n      removeCategoryValue(categoryValue, category, businessObject);\n    } else {\n      removeCategoryValue(null, businessObject.categoryValueRef.$parent, businessObject);\n    }\n  }\n\n\n  // ensure category + value exist before label editing\n\n  this.execute('label.create', function(event) {\n    var context = event.context,\n        labelTarget = context.labelTarget;\n\n    if (!(0,ModelUtil.is)(labelTarget, 'bpmn:Group')) {\n      return;\n    }\n\n    setCategoryValue(labelTarget, context);\n  });\n\n  this.revert('label.create', function(event) {\n    var context = event.context,\n        labelTarget = context.labelTarget;\n\n    if (!(0,ModelUtil.is)(labelTarget, 'bpmn:Group')) {\n      return;\n    }\n\n    unsetCategoryValue(labelTarget, context);\n  });\n\n\n  // remove referenced category + value when group was deleted\n\n  this.execute('shape.delete', function(event) {\n\n    var context = event.context,\n        shape = context.shape,\n        businessObject = (0,ModelUtil/* getBusinessObject */.SS)(shape);\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:Group') || shape.labelTarget) {\n      return;\n    }\n\n    var categoryValue = context.categoryValue = businessObject.categoryValueRef,\n        category;\n\n    if (categoryValue) {\n      category = context.category = categoryValue.$parent;\n\n      removeCategoryValue(categoryValue, category, businessObject);\n\n      businessObject.categoryValueRef = null;\n    }\n  });\n\n  this.reverted('shape.delete', function(event) {\n\n    var context = event.context,\n        shape = context.shape;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:Group') || shape.labelTarget) {\n      return;\n    }\n\n    var category = context.category,\n        categoryValue = context.categoryValue,\n        businessObject = (0,ModelUtil/* getBusinessObject */.SS)(shape);\n\n    if (categoryValue) {\n      businessObject.categoryValueRef = categoryValue;\n\n      addCategoryValue(categoryValue, category);\n    }\n  });\n\n\n  // create new category + value when group was created\n\n  this.execute('shape.create', function(event) {\n    var context = event.context,\n        shape = context.shape;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:Group') || shape.labelTarget) {\n      return;\n    }\n\n    if ((0,ModelUtil/* getBusinessObject */.SS)(shape).categoryValueRef) {\n      setCategoryValue(shape, context);\n    }\n  });\n\n  this.reverted('shape.create', function(event) {\n\n    var context = event.context,\n        shape = context.shape;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:Group') || shape.labelTarget) {\n      return;\n    }\n\n    if ((0,ModelUtil/* getBusinessObject */.SS)(shape).categoryValueRef) {\n      unsetCategoryValue(shape, context);\n    }\n  });\n\n\n  // copy + paste categoryValueRef with group\n\n  function copy(bo, clone) {\n    var targetBo = bpmnFactory.create(bo.$type);\n\n    return moddleCopy.copyElement(bo, targetBo, null, clone);\n  }\n\n  eventBus.on('copyPaste.copyElement', LOWER_PRIORITY, function(context) {\n    var descriptor = context.descriptor,\n        element = context.element;\n\n    if (!(0,ModelUtil.is)(element, 'bpmn:Group') || element.labelTarget) {\n      return;\n    }\n\n    var groupBo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n    if (groupBo.categoryValueRef) {\n\n      var categoryValue = groupBo.categoryValueRef;\n\n      descriptor.categoryValue = copy(categoryValue, true);\n\n      if (categoryValue.$parent) {\n        descriptor.category = copy(categoryValue.$parent, true);\n      }\n    }\n  });\n\n  eventBus.on('copyPaste.pasteElement', LOWER_PRIORITY, function(context) {\n    var descriptor = context.descriptor,\n        businessObject = descriptor.businessObject,\n        categoryValue = descriptor.categoryValue,\n        category = descriptor.category;\n\n    if (categoryValue) {\n      categoryValue = businessObject.categoryValueRef = copy(categoryValue);\n    }\n\n    if (category) {\n      categoryValue.$parent = copy(category);\n    }\n\n    delete descriptor.category;\n    delete descriptor.categoryValue;\n  });\n\n}\n\nGroupBehavior.$inject = [\n  'bpmnFactory',\n  'bpmnjs',\n  'elementRegistry',\n  'eventBus',\n  'injector',\n  'moddleCopy'\n];\n\n(0,index_es/* default */.Z)(GroupBehavior, CommandInterceptor/* default */.Z);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/util/LineIntersect.js\n/**\n * Returns the intersection between two line segments a and b.\n *\n * @param {Point} l1s\n * @param {Point} l1e\n * @param {Point} l2s\n * @param {Point} l2e\n *\n * @return {Point}\n */\nfunction lineIntersect(l1s, l1e, l2s, l2e) {\n\n  // if the lines intersect, the result contains the x and y of the\n  // intersection (treating the lines as infinite) and booleans for\n  // whether line segment 1 or line segment 2 contain the point\n  var denominator, a, b, c, numerator;\n\n  denominator = ((l2e.y - l2s.y) * (l1e.x - l1s.x)) - ((l2e.x - l2s.x) * (l1e.y - l1s.y));\n\n  if (denominator == 0) {\n    return null;\n  }\n\n  a = l1s.y - l2s.y;\n  b = l1s.x - l2s.x;\n  numerator = ((l2e.x - l2s.x) * a) - ((l2e.y - l2s.y) * b);\n\n  c = numerator / denominator;\n\n  // if we cast these lines infinitely in\n  // both directions, they intersect here\n  return {\n    x: Math.round(l1s.x + (c * (l1e.x - l1s.x))),\n    y: Math.round(l1s.y + (c * (l1e.y - l1s.y)))\n  };\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/ImportDockingFix.js\n\n\n\n\n\n/**\n * Fix broken dockings after DI imports.\n *\n * @param {EventBus} eventBus\n */\nfunction ImportDockingFix(eventBus) {\n\n  function adjustDocking(startPoint, nextPoint, elementMid) {\n\n    var elementTop = {\n      x: elementMid.x,\n      y: elementMid.y - 50\n    };\n\n    var elementLeft = {\n      x: elementMid.x - 50,\n      y: elementMid.y\n    };\n\n    var verticalIntersect = lineIntersect(startPoint, nextPoint, elementMid, elementTop),\n        horizontalIntersect = lineIntersect(startPoint, nextPoint, elementMid, elementLeft);\n\n    // original is horizontal or vertical center cross intersection\n    var centerIntersect;\n\n    if (verticalIntersect && horizontalIntersect) {\n      if (getDistance(verticalIntersect, elementMid) > getDistance(horizontalIntersect, elementMid)) {\n        centerIntersect = horizontalIntersect;\n      } else {\n        centerIntersect = verticalIntersect;\n      }\n    } else {\n      centerIntersect = verticalIntersect || horizontalIntersect;\n    }\n\n    startPoint.original = centerIntersect;\n  }\n\n  function fixDockings(connection) {\n    var waypoints = connection.waypoints;\n\n    adjustDocking(\n      waypoints[0],\n      waypoints[1],\n      (0,LayoutUtil/* getMid */.wS)(connection.source)\n    );\n\n    adjustDocking(\n      waypoints[waypoints.length - 1],\n      waypoints[waypoints.length - 2],\n      (0,LayoutUtil/* getMid */.wS)(connection.target)\n    );\n  }\n\n  eventBus.on('bpmnElement.added', function(e) {\n\n    var element = e.element;\n\n    if (element.waypoints) {\n      fixDockings(element);\n    }\n  });\n}\n\nImportDockingFix.$inject = [\n  'eventBus'\n];\n\n\n// helpers //////////////////////\n\nfunction getDistance(p1, p2) {\n  return Math.sqrt(Math.pow(p1.x - p2.x, 2) + Math.pow(p1.y - p2.y, 2));\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/IsHorizontalFix.js\n\n\n\n\n\n\n\n\n/**\n * A component that makes sure that each created or updated\n * Pool and Lane is assigned an isHorizontal property set to true.\n *\n * @param {EventBus} eventBus\n */\nfunction IsHorizontalFix(eventBus) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  var elementTypesToUpdate = [\n    'bpmn:Participant',\n    'bpmn:Lane'\n  ];\n\n  this.executed([ 'shape.move', 'shape.create', 'shape.resize' ], function(event) {\n    var shape = event.context.shape,\n        bo = (0,ModelUtil/* getBusinessObject */.SS)(shape),\n        di = (0,ModelUtil/* getDi */.DN)(shape);\n\n    if ((0,ModelUtil/* isAny */.JZ)(bo, elementTypesToUpdate) && !di.get('isHorizontal')) {\n\n      // set attribute directly to avoid modeling#updateProperty side effects\n      di.set('isHorizontal', true);\n    }\n  });\n\n}\n\nIsHorizontalFix.$inject = [ 'eventBus' ];\n\n(0,index_es/* default */.Z)(IsHorizontalFix, CommandInterceptor/* default */.Z);\n\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/util/LayoutUtil.js\nvar util_LayoutUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/features/modeling/behavior/util/LayoutUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/util/LabelLayoutUtil.js\n\n\nfunction findNewLabelLineStartIndex(oldWaypoints, newWaypoints, attachment, hints) {\n  return findNewLineStartIndex(oldWaypoints, newWaypoints, attachment, hints);\n}\n\n\n/**\n * Calculate the required adjustment (move delta) for the given label\n * after the connection waypoints got updated.\n *\n * @param {djs.model.Label} label\n * @param {Array<Point>} newWaypoints\n * @param {Array<Point>} oldWaypoints\n * @param {Object} hints\n *\n * @return {Point} delta\n */\nfunction getLabelAdjustment(label, newWaypoints, oldWaypoints, hints) {\n  var labelPosition = getLabelMid(label);\n\n  return (0,util_LayoutUtil/* getAnchorPointAdjustment */.K)(labelPosition, newWaypoints, oldWaypoints, hints).delta;\n}\n\n\n// HELPERS //////////////////////\n\nfunction getLabelMid(label) {\n  return {\n    x: label.x + label.width / 2,\n    y: label.y + label.height / 2\n  };\n}\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/AttachUtil.js\nvar AttachUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/AttachUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/bendpoints/GeometricUtil.js\nvar GeometricUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/bendpoints/GeometricUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/LabelBehavior.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nvar DEFAULT_LABEL_DIMENSIONS = {\n  width: 90,\n  height: 20\n};\n\nvar NAME_PROPERTY = 'name';\nvar TEXT_PROPERTY = 'text';\n\n/**\n * A component that makes sure that external labels are added\n * together with respective elements and properly updated (DI wise)\n * during move.\n *\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n * @param {BpmnFactory} bpmnFactory\n * @param {TextRenderer} textRenderer\n */\nfunction LabelBehavior(\n    eventBus, modeling, bpmnFactory,\n    textRenderer) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  // update label if name property was updated\n  this.postExecute('element.updateProperties', function(e) {\n    var context = e.context,\n        element = context.element,\n        properties = context.properties;\n\n    if (NAME_PROPERTY in properties) {\n      modeling.updateLabel(element, properties[NAME_PROPERTY]);\n    }\n\n    if (TEXT_PROPERTY in properties\n        && (0,ModelUtil.is)(element, 'bpmn:TextAnnotation')) {\n\n      var newBounds = textRenderer.getTextAnnotationBounds(\n        {\n          x: element.x,\n          y: element.y,\n          width: element.width,\n          height: element.height\n        },\n        properties[TEXT_PROPERTY] || ''\n      );\n\n      modeling.updateLabel(element, properties.text, newBounds);\n    }\n  });\n\n  // create label shape after shape/connection was created\n  this.postExecute([ 'shape.create', 'connection.create' ], function(e) {\n    var context = e.context,\n        hints = context.hints || {};\n\n    if (hints.createElementsBehavior === false) {\n      return;\n    }\n\n    var element = context.shape || context.connection,\n        businessObject = element.businessObject;\n\n    if ((0,util_LabelUtil/* isLabel */.j_)(element) || !(0,util_LabelUtil/* isLabelExternal */.ly)(element)) {\n      return;\n    }\n\n    // only create label if attribute available\n    if (!(0,LabelUtil/* getLabel */.i)(element)) {\n      return;\n    }\n\n    var labelCenter = (0,util_LabelUtil/* getExternalLabelMid */.qe)(element);\n\n    // we don't care about x and y\n    var labelDimensions = textRenderer.getExternalLabelBounds(\n      DEFAULT_LABEL_DIMENSIONS,\n      (0,LabelUtil/* getLabel */.i)(element)\n    );\n\n    modeling.createLabel(element, labelCenter, {\n      id: businessObject.id + '_label',\n      businessObject: businessObject,\n      width: labelDimensions.width,\n      height: labelDimensions.height\n    });\n  });\n\n  // update label after label shape was deleted\n  this.postExecute('shape.delete', function(event) {\n    var context = event.context,\n        labelTarget = context.labelTarget,\n        hints = context.hints || {};\n\n    // check if label\n    if (labelTarget && hints.unsetLabel !== false) {\n      modeling.updateLabel(labelTarget, null, null, { removeShape: false });\n    }\n  });\n\n  // update di information on label creation\n  this.postExecute([ 'label.create' ], function(event) {\n\n    var context = event.context,\n        element = context.shape,\n        labelTarget = context.labelTarget,\n        di;\n\n    // we want to trigger on real labels only\n    if (!labelTarget) {\n      return;\n    }\n\n    // we want to trigger on BPMN elements only\n    if (!(0,ModelUtil.is)(labelTarget, 'bpmn:BaseElement')) {\n      return;\n    }\n\n    di = (0,ModelUtil/* getDi */.DN)(labelTarget);\n\n    if (!di.label) {\n      di.label = bpmnFactory.create('bpmndi:BPMNLabel', {\n        bounds: bpmnFactory.create('dc:Bounds')\n      });\n\n      element.di = di;\n    }\n\n    (0,dist_index_esm/* assign */.f0)(di.label.bounds, {\n      x: element.x,\n      y: element.y,\n      width: element.width,\n      height: element.height\n    });\n  });\n\n  function getVisibleLabelAdjustment(event) {\n\n    var context = event.context,\n        connection = context.connection,\n        label = connection.label,\n        hints = (0,dist_index_esm/* assign */.f0)({}, context.hints),\n        newWaypoints = context.newWaypoints || connection.waypoints,\n        oldWaypoints = context.oldWaypoints;\n\n\n    if (typeof hints.startChanged === 'undefined') {\n      hints.startChanged = !!hints.connectionStart;\n    }\n\n    if (typeof hints.endChanged === 'undefined') {\n      hints.endChanged = !!hints.connectionEnd;\n    }\n\n    return getLabelAdjustment(label, newWaypoints, oldWaypoints, hints);\n  }\n\n  this.postExecute([\n    'connection.layout',\n    'connection.updateWaypoints'\n  ], function(event) {\n    var context = event.context,\n        hints = context.hints || {};\n\n    if (hints.labelBehavior === false) {\n      return;\n    }\n\n    var connection = context.connection,\n        label = connection.label,\n        labelAdjustment;\n\n    // handle missing label as well as the case\n    // that the label parent does not exist (yet),\n    // because it is being pasted / created via multi element create\n    //\n    // Cf. https://github.com/bpmn-io/bpmn-js/pull/1227\n    if (!label || !label.parent) {\n      return;\n    }\n\n    labelAdjustment = getVisibleLabelAdjustment(event);\n\n    modeling.moveShape(label, labelAdjustment);\n  });\n\n\n  // keep label position on shape replace\n  this.postExecute([ 'shape.replace' ], function(event) {\n    var context = event.context,\n        newShape = context.newShape,\n        oldShape = context.oldShape;\n\n    var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(newShape);\n\n    if (businessObject\n      && (0,util_LabelUtil/* isLabelExternal */.ly)(businessObject)\n      && oldShape.label\n      && newShape.label) {\n      newShape.label.x = oldShape.label.x;\n      newShape.label.y = oldShape.label.y;\n    }\n  });\n\n\n  // move external label after resizing\n  this.postExecute('shape.resize', function(event) {\n\n    var context = event.context,\n        shape = context.shape,\n        newBounds = context.newBounds,\n        oldBounds = context.oldBounds;\n\n    if ((0,util_LabelUtil/* hasExternalLabel */.fF)(shape)) {\n\n      var label = shape.label,\n          labelMid = (0,LayoutUtil/* getMid */.wS)(label),\n          edges = asEdges(oldBounds);\n\n      // get nearest border point to label as reference point\n      var referencePoint = getReferencePoint(labelMid, edges);\n\n      var delta = getReferencePointDelta(referencePoint, oldBounds, newBounds);\n\n      modeling.moveShape(label, delta);\n\n    }\n\n  });\n\n}\n\n(0,index_es/* default */.Z)(LabelBehavior, CommandInterceptor/* default */.Z);\n\nLabelBehavior.$inject = [\n  'eventBus',\n  'modeling',\n  'bpmnFactory',\n  'textRenderer'\n];\n\n// helpers //////////////////////\n\n/**\n * Calculates a reference point delta relative to a new position\n * of a certain element's bounds\n *\n * @param {Point} point\n * @param {Bounds} oldBounds\n * @param {Bounds} newBounds\n *\n * @return {Delta} delta\n */\nfunction getReferencePointDelta(referencePoint, oldBounds, newBounds) {\n\n  var newReferencePoint = (0,AttachUtil/* getNewAttachPoint */.r)(referencePoint, oldBounds, newBounds);\n\n  return (0,LayoutUtil/* roundPoint */.ex)((0,PositionUtil/* delta */.p)(newReferencePoint, referencePoint));\n}\n\n/**\n * Generates the nearest point (reference point) for a given point\n * onto given set of lines\n *\n * @param {Array<Point, Point>} lines\n * @param {Point} point\n *\n * @param {Point}\n */\nfunction getReferencePoint(point, lines) {\n\n  if (!lines.length) {\n    return;\n  }\n\n  var nearestLine = getNearestLine(point, lines);\n\n  return (0,GeometricUtil/* perpendicularFoot */.FY)(point, nearestLine);\n}\n\n/**\n * Convert the given bounds to a lines array containing all edges\n *\n * @param {Bounds|Point} bounds\n *\n * @return Array<Point>\n */\nfunction asEdges(bounds) {\n  return [\n    [ // top\n      {\n        x: bounds.x,\n        y: bounds.y\n      },\n      {\n        x: bounds.x + (bounds.width || 0),\n        y: bounds.y\n      }\n    ],\n    [ // right\n      {\n        x: bounds.x + (bounds.width || 0),\n        y: bounds.y\n      },\n      {\n        x: bounds.x + (bounds.width || 0),\n        y: bounds.y + (bounds.height || 0)\n      }\n    ],\n    [ // bottom\n      {\n        x: bounds.x,\n        y: bounds.y + (bounds.height || 0)\n      },\n      {\n        x: bounds.x + (bounds.width || 0),\n        y: bounds.y + (bounds.height || 0)\n      }\n    ],\n    [ // left\n      {\n        x: bounds.x,\n        y: bounds.y\n      },\n      {\n        x: bounds.x,\n        y: bounds.y + (bounds.height || 0)\n      }\n    ]\n  ];\n}\n\n/**\n * Returns the nearest line for a given point by distance\n * @param {Point} point\n * @param Array<Point> lines\n *\n * @return Array<Point>\n */\nfunction getNearestLine(point, lines) {\n\n  var distances = lines.map(function(l) {\n    return {\n      line: l,\n      distance: (0,GeometricUtil/* getDistancePointLine */.ON)(point, l)\n    };\n  });\n\n  var sorted = (0,dist_index_esm/* sortBy */.MR)(distances, 'distance');\n\n  return sorted[0].line;\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/util/ConnectionLayoutUtil.js\n\n\n/**\n * Calculate the new point after the connection waypoints got updated.\n *\n * @param {djs.model.Label} label\n * @param {Array<Point>} newWaypoints\n * @param {Array<Point>} oldWaypoints\n * @param {Object} hints\n *\n * @return {Point} point\n */\nfunction getConnectionAdjustment(position, newWaypoints, oldWaypoints, hints) {\n  return (0,util_LayoutUtil/* getAnchorPointAdjustment */.K)(position, newWaypoints, oldWaypoints, hints).point;\n}\n\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/LayoutConnectionBehavior.js\n\n\n\n\n\n\n\n\n/**\n * A component that makes sure that Associations connected to Connections\n * are updated together with the Connection.\n *\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n */\nfunction LayoutConnectionBehavior(\n    eventBus, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  function getnewAnchorPoint(event, point) {\n\n    var context = event.context,\n        connection = context.connection,\n        hints = (0,dist_index_esm/* assign */.f0)({}, context.hints),\n        newWaypoints = context.newWaypoints || connection.waypoints,\n        oldWaypoints = context.oldWaypoints;\n\n\n    if (typeof hints.startChanged === 'undefined') {\n      hints.startChanged = !!hints.connectionStart;\n    }\n\n    if (typeof hints.endChanged === 'undefined') {\n      hints.endChanged = !!hints.connectionEnd;\n    }\n\n    return getConnectionAdjustment(point, newWaypoints, oldWaypoints, hints);\n  }\n\n  this.postExecute([\n    'connection.layout',\n    'connection.updateWaypoints'\n  ], function(event) {\n    var context = event.context;\n\n    var connection = context.connection,\n        outgoing = connection.outgoing,\n        incoming = connection.incoming;\n\n    incoming.forEach(function(connection) {\n      var endPoint = connection.waypoints[connection.waypoints.length - 1];\n      var newEndpoint = getnewAnchorPoint(event, endPoint);\n\n      var newWaypoints = [].concat(connection.waypoints.slice(0, -1), [ newEndpoint ]);\n\n      modeling.updateWaypoints(connection, newWaypoints);\n    });\n\n    outgoing.forEach(function(connection) {\n      var startpoint = connection.waypoints[0];\n      var newStartpoint = getnewAnchorPoint(event, startpoint);\n\n      var newWaypoints = [].concat([ newStartpoint ], connection.waypoints.slice(1));\n\n      modeling.updateWaypoints(connection, newWaypoints);\n    });\n\n  });\n\n\n  this.postExecute([\n    'connection.move'\n  ], function(event) {\n    var context = event.context;\n\n    var connection = context.connection,\n        outgoing = connection.outgoing,\n        incoming = connection.incoming,\n        delta = context.delta;\n\n    incoming.forEach(function(connection) {\n      var endPoint = connection.waypoints[connection.waypoints.length - 1];\n      var newEndpoint = {\n        x: endPoint.x + delta.x,\n        y: endPoint.y + delta.y\n      };\n\n      var newWaypoints = [].concat(connection.waypoints.slice(0, -1), [ newEndpoint ]);\n\n      modeling.updateWaypoints(connection, newWaypoints);\n    });\n\n    outgoing.forEach(function(connection) {\n      var startpoint = connection.waypoints[0];\n      var newStartpoint = {\n        x: startpoint.x + delta.x,\n        y: startpoint.y + delta.y\n      };\n\n      var newWaypoints = [].concat([ newStartpoint ], connection.waypoints.slice(1));\n\n      modeling.updateWaypoints(connection, newWaypoints);\n    });\n\n  });\n\n}\n\n(0,index_es/* default */.Z)(LayoutConnectionBehavior, CommandInterceptor/* default */.Z);\n\nLayoutConnectionBehavior.$inject = [\n  'eventBus',\n  'modeling'\n];\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/modeling/cmd/helper/AnchorsHelper.js\nvar AnchorsHelper = __webpack_require__(\"./node_modules/diagram-js/lib/features/modeling/cmd/helper/AnchorsHelper.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/MessageFlowBehavior.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n/**\r\n * BPMN-specific message flow behavior.\r\n */\r\nfunction MessageFlowBehavior(eventBus, modeling) {\r\n\r\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\r\n\r\n  this.postExecute('shape.replace', function(context) {\r\n    var oldShape = context.oldShape,\r\n        newShape = context.newShape;\r\n\r\n    if (!isParticipantCollapse(oldShape, newShape)) {\r\n      return;\r\n    }\r\n\r\n    var messageFlows = getMessageFlows(oldShape);\r\n\r\n    messageFlows.incoming.forEach(function(incoming) {\r\n      var anchor = (0,AnchorsHelper/* getResizedTargetAnchor */.Qd)(incoming, newShape, oldShape);\r\n\r\n      modeling.reconnectEnd(incoming, newShape, anchor);\r\n    });\r\n\r\n    messageFlows.outgoing.forEach(function(outgoing) {\r\n      var anchor = (0,AnchorsHelper/* getResizedSourceAnchor */.SL)(outgoing, newShape, oldShape);\r\n\r\n      modeling.reconnectStart(outgoing, newShape, anchor);\r\n    });\r\n  }, true);\r\n\r\n}\r\n\r\nMessageFlowBehavior.$inject = [ 'eventBus', 'modeling' ];\r\n\r\n(0,index_es/* default */.Z)(MessageFlowBehavior, CommandInterceptor/* default */.Z);\r\n\r\n// helpers //////////\r\n\r\nfunction isParticipantCollapse(oldShape, newShape) {\r\n  return (0,ModelUtil.is)(oldShape, 'bpmn:Participant')\r\n    && (0,DiUtil/* isExpanded */.ul)(oldShape)\r\n    && (0,ModelUtil.is)(newShape, 'bpmn:Participant')\r\n    && !(0,DiUtil/* isExpanded */.ul)(newShape);\r\n}\r\n\r\nfunction getMessageFlows(parent) {\r\n  var elements = (0,Elements/* selfAndAllChildren */.PB)([ parent ], false);\r\n\r\n  var incoming = [],\r\n      outgoing = [];\r\n\r\n  elements.forEach(function(element) {\r\n    if (element === parent) {\r\n      return;\r\n    }\r\n\r\n    element.incoming.forEach(function(connection) {\r\n      if ((0,ModelUtil.is)(connection, 'bpmn:MessageFlow')) {\r\n        incoming.push(connection);\r\n      }\r\n    });\r\n\r\n    element.outgoing.forEach(function(connection) {\r\n      if ((0,ModelUtil.is)(connection, 'bpmn:MessageFlow')) {\r\n        outgoing.push(connection);\r\n      }\r\n    });\r\n  }, []);\r\n\r\n  return {\r\n    incoming: incoming,\r\n    outgoing: outgoing\r\n  };\r\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/ModelingFeedback.js\n\n\nvar COLLAB_ERR_MSG = 'flow elements must be children of pools/participants';\n\nfunction ModelingFeedback(eventBus, tooltips, translate) {\n\n  function showError(position, message, timeout) {\n    tooltips.add({\n      position: {\n        x: position.x + 5,\n        y: position.y + 5\n      },\n      type: 'error',\n      timeout: timeout || 2000,\n      html: '<div>' + message + '</div>'\n    });\n  }\n\n  eventBus.on([ 'shape.move.rejected', 'create.rejected' ], function(event) {\n    var context = event.context,\n        shape = context.shape,\n        target = context.target;\n\n    if ((0,ModelUtil.is)(target, 'bpmn:Collaboration') && (0,ModelUtil.is)(shape, 'bpmn:FlowNode')) {\n      showError(event, translate(COLLAB_ERR_MSG));\n    }\n  });\n\n}\n\nModelingFeedback.$inject = [\n  'eventBus',\n  'tooltips',\n  'translate'\n];\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/RemoveEmbeddedLabelBoundsBehavior.js\n\n\n\n\n\n\n/**\n * BPMN specific behavior ensuring that bpmndi:Label's dc:Bounds are removed\n * when shape is resized.\n */\nfunction RemoveEmbeddedLabelBoundsBehavior(eventBus, modeling) {\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  this.preExecute('shape.resize', function(context) {\n    var shape = context.shape;\n\n    var di = (0,ModelUtil/* getDi */.DN)(shape),\n        label = di && di.get('label'),\n        bounds = label && label.get('bounds');\n\n    if (bounds) {\n      modeling.updateModdleProperties(shape, label, {\n        bounds: undefined\n      });\n    }\n  }, true);\n}\n\n(0,index_es/* default */.Z)(RemoveEmbeddedLabelBoundsBehavior, CommandInterceptor/* default */.Z);\n\nRemoveEmbeddedLabelBoundsBehavior.$inject = [\n  'eventBus',\n  'modeling'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/RemoveElementBehavior.js\n\n\n\n\n\n\n\n\n\nfunction RemoveElementBehavior(eventBus, bpmnRules, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  /**\n   * Combine sequence flows when deleting an element\n   * if there is one incoming and one outgoing\n   * sequence flow\n   */\n  this.preExecute('shape.delete', function(e) {\n\n    var shape = e.context.shape;\n\n    // only handle [a] -> [shape] -> [b] patterns\n    if (shape.incoming.length !== 1 || shape.outgoing.length !== 1) {\n      return;\n    }\n\n    var inConnection = shape.incoming[0],\n        outConnection = shape.outgoing[0];\n\n    // only handle sequence flows\n    if (!(0,ModelUtil.is)(inConnection, 'bpmn:SequenceFlow') || !(0,ModelUtil.is)(outConnection, 'bpmn:SequenceFlow')) {\n      return;\n    }\n\n    if (bpmnRules.canConnect(inConnection.source, outConnection.target, inConnection)) {\n\n      // compute new, combined waypoints\n      var newWaypoints = getNewWaypoints(inConnection.waypoints, outConnection.waypoints);\n\n      modeling.reconnectEnd(inConnection, outConnection.target, newWaypoints);\n    }\n  });\n\n}\n\n(0,index_es/* default */.Z)(RemoveElementBehavior, CommandInterceptor/* default */.Z);\n\nRemoveElementBehavior.$inject = [\n  'eventBus',\n  'bpmnRules',\n  'modeling'\n];\n\n\n// helpers //////////////////////\n\nfunction getDocking(point) {\n  return point.original || point;\n}\n\n\nfunction getNewWaypoints(inWaypoints, outWaypoints) {\n\n  var intersection = lineIntersect(\n    getDocking(inWaypoints[inWaypoints.length - 2]),\n    getDocking(inWaypoints[inWaypoints.length - 1]),\n    getDocking(outWaypoints[1]),\n    getDocking(outWaypoints[0]));\n\n  if (intersection) {\n    return [].concat(\n      inWaypoints.slice(0, inWaypoints.length - 1),\n      [ intersection ],\n      outWaypoints.slice(1));\n  } else {\n    return [\n      getDocking(inWaypoints[0]),\n      getDocking(outWaypoints[outWaypoints.length - 1])\n    ];\n  }\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/RemoveParticipantBehavior.js\n\n\n\n\n\n\n\n/**\n * BPMN specific remove behavior\n */\nfunction RemoveParticipantBehavior(eventBus, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n\n  /**\n   * morph collaboration diagram into process diagram\n   * after the last participant has been removed\n   */\n\n  this.preExecute('shape.delete', function(context) {\n\n    var shape = context.shape,\n        parent = shape.parent;\n\n    // activate the behavior if the shape to be removed\n    // is a participant\n    if ((0,ModelUtil.is)(shape, 'bpmn:Participant')) {\n      context.collaborationRoot = parent;\n    }\n  }, true);\n\n  this.postExecute('shape.delete', function(context) {\n\n    var collaborationRoot = context.collaborationRoot;\n\n    if (collaborationRoot && !collaborationRoot.businessObject.participants.length) {\n\n      // replace empty collaboration with process diagram\n      modeling.makeProcess();\n    }\n  }, true);\n\n}\n\nRemoveParticipantBehavior.$inject = [ 'eventBus', 'modeling' ];\n\n(0,index_es/* default */.Z)(RemoveParticipantBehavior, CommandInterceptor/* default */.Z);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/ReplaceConnectionBehavior.js\n\n\n\n\n\n\n\n\n\nfunction ReplaceConnectionBehavior(eventBus, modeling, bpmnRules, injector) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  var dragging = injector.get('dragging', false);\n\n  function fixConnection(connection) {\n\n    var source = connection.source,\n        target = connection.target,\n        parent = connection.parent;\n\n    // do not do anything if connection\n    // is already deleted (may happen due to other\n    // behaviors plugged-in before)\n    if (!parent) {\n      return;\n    }\n\n    var replacementType,\n        remove;\n\n    /**\n     * Check if incoming or outgoing connections\n     * can stay or could be substituted with an\n     * appropriate replacement.\n     *\n     * This holds true for SequenceFlow <> MessageFlow.\n     */\n\n    if ((0,ModelUtil.is)(connection, 'bpmn:SequenceFlow')) {\n      if (!bpmnRules.canConnectSequenceFlow(source, target)) {\n        remove = true;\n      }\n\n      if (bpmnRules.canConnectMessageFlow(source, target)) {\n        replacementType = 'bpmn:MessageFlow';\n      }\n    }\n\n    // transform message flows into sequence flows, if possible\n\n    if ((0,ModelUtil.is)(connection, 'bpmn:MessageFlow')) {\n\n      if (!bpmnRules.canConnectMessageFlow(source, target)) {\n        remove = true;\n      }\n\n      if (bpmnRules.canConnectSequenceFlow(source, target)) {\n        replacementType = 'bpmn:SequenceFlow';\n      }\n    }\n\n    if ((0,ModelUtil.is)(connection, 'bpmn:Association') && !bpmnRules.canConnectAssociation(source, target)) {\n      remove = true;\n    }\n\n\n    // remove invalid connection,\n    // unless it has been removed already\n    if (remove) {\n      modeling.removeConnection(connection);\n    }\n\n    // replace SequenceFlow <> MessageFlow\n\n    if (replacementType) {\n      modeling.connect(source, target, {\n        type: replacementType,\n        waypoints: connection.waypoints.slice()\n      });\n    }\n  }\n\n  function replaceReconnectedConnection(event) {\n\n    var context = event.context,\n        connection = context.connection,\n        source = context.newSource || connection.source,\n        target = context.newTarget || connection.target,\n        allowed,\n        replacement;\n\n    allowed = bpmnRules.canConnect(source, target);\n\n    if (!allowed || allowed.type === connection.type) {\n      return;\n    }\n\n    replacement = modeling.connect(source, target, {\n      type: allowed.type,\n      waypoints: connection.waypoints.slice()\n    });\n\n    // remove old connection\n    modeling.removeConnection(connection);\n\n    // replace connection in context to reconnect end/start\n    context.connection = replacement;\n\n    if (dragging) {\n      cleanDraggingSelection(connection, replacement);\n    }\n  }\n\n  // monkey-patch selection saved in dragging in order to re-select it when operation is finished\n  function cleanDraggingSelection(oldConnection, newConnection) {\n    var context = dragging.context(),\n        previousSelection = context && context.payload.previousSelection,\n        index;\n\n    // do nothing if not dragging or no selection was present\n    if (!previousSelection || !previousSelection.length) {\n      return;\n    }\n\n    index = previousSelection.indexOf(oldConnection);\n\n    if (index === -1) {\n      return;\n    }\n\n    previousSelection.splice(index, 1, newConnection);\n  }\n\n  // lifecycle hooks\n\n  this.postExecuted('elements.move', function(context) {\n\n    var closure = context.closure,\n        allConnections = closure.allConnections;\n\n    (0,dist_index_esm/* forEach */.Ed)(allConnections, fixConnection);\n  }, true);\n\n  this.preExecute('connection.reconnect', replaceReconnectedConnection);\n\n  this.postExecuted('element.updateProperties', function(event) {\n    var context = event.context,\n        properties = context.properties,\n        element = context.element,\n        businessObject = element.businessObject,\n        connection;\n\n    // remove condition on change to default\n    if (properties.default) {\n      connection = (0,dist_index_esm/* find */.sE)(\n        element.outgoing,\n        (0,dist_index_esm/* matchPattern */.KQ)({ id: element.businessObject.default.id })\n      );\n\n      if (connection) {\n        modeling.updateProperties(connection, { conditionExpression: undefined });\n      }\n    }\n\n    // remove default from source on change to conditional\n    if (properties.conditionExpression && businessObject.sourceRef.default === businessObject) {\n      modeling.updateProperties(element.source, { default: undefined });\n    }\n  });\n}\n\n(0,index_es/* default */.Z)(ReplaceConnectionBehavior, CommandInterceptor/* default */.Z);\n\nReplaceConnectionBehavior.$inject = [\n  'eventBus',\n  'modeling',\n  'bpmnRules',\n  'injector'\n];\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/ReplaceElementBehaviour.js\n\n\n\n\n\n\n\n\n\n/**\n * BPMN-specific replace behavior.\n */\nfunction ReplaceElementBehaviour(\n    bpmnReplace,\n    bpmnRules,\n    elementRegistry,\n    injector,\n    modeling,\n    selection\n) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n\n  this._bpmnReplace = bpmnReplace;\n  this._elementRegistry = elementRegistry;\n  this._selection = selection;\n\n  // replace elements on create, e.g. during copy-paste\n  this.postExecuted([ 'elements.create' ], 500, function(event) {\n    var context = event.context,\n        target = context.parent,\n        elements = context.elements;\n\n    var elementReplacements = (0,dist_index_esm/* reduce */.u4)(elements, function(replacements, element) {\n      var canReplace = bpmnRules.canReplace([ element ], element.host || element.parent || target);\n\n      return canReplace ? replacements.concat(canReplace.replacements) : replacements;\n    }, []);\n\n    if (elementReplacements.length) {\n      this.replaceElements(elements, elementReplacements);\n    }\n  }, this);\n\n  // replace elements on move\n  this.postExecuted([ 'elements.move' ], 500, function(event) {\n    var context = event.context,\n        target = context.newParent,\n        newHost = context.newHost,\n        elements = [];\n\n    (0,dist_index_esm/* forEach */.Ed)(context.closure.topLevel, function(topLevelElements) {\n      if ((0,DiUtil/* isEventSubProcess */.J5)(topLevelElements)) {\n        elements = elements.concat(topLevelElements.children);\n      } else {\n        elements = elements.concat(topLevelElements);\n      }\n    });\n\n    // set target to host if attaching\n    if (elements.length === 1 && newHost) {\n      target = newHost;\n    }\n\n    var canReplace = bpmnRules.canReplace(elements, target);\n\n    if (canReplace) {\n      this.replaceElements(elements, canReplace.replacements, newHost);\n    }\n  }, this);\n\n  // update attachments on host replace\n  this.postExecute([ 'shape.replace' ], 1500, function(e) {\n    var context = e.context,\n        oldShape = context.oldShape,\n        newShape = context.newShape,\n        attachers = oldShape.attachers,\n        canReplace;\n\n    if (attachers && attachers.length) {\n      canReplace = bpmnRules.canReplace(attachers, newShape);\n\n      this.replaceElements(attachers, canReplace.replacements);\n    }\n\n  }, this);\n\n  // keep ID on shape replace\n  this.postExecuted([ 'shape.replace' ], 1500, function(e) {\n    var context = e.context,\n        oldShape = context.oldShape,\n        newShape = context.newShape;\n\n    modeling.unclaimId(oldShape.businessObject.id, oldShape.businessObject);\n    modeling.updateProperties(newShape, { id: oldShape.id });\n  });\n}\n\n(0,index_es/* default */.Z)(ReplaceElementBehaviour, CommandInterceptor/* default */.Z);\n\nReplaceElementBehaviour.prototype.replaceElements = function(elements, newElements) {\n  var elementRegistry = this._elementRegistry,\n      bpmnReplace = this._bpmnReplace,\n      selection = this._selection;\n\n  (0,dist_index_esm/* forEach */.Ed)(newElements, function(replacement) {\n    var newElement = {\n      type: replacement.newElementType\n    };\n\n    var oldElement = elementRegistry.get(replacement.oldElementId);\n\n    var idx = elements.indexOf(oldElement);\n\n    elements[idx] = bpmnReplace.replaceElement(oldElement, newElement, { select: false });\n  });\n\n  if (newElements) {\n    selection.select(elements);\n  }\n};\n\nReplaceElementBehaviour.$inject = [\n  'bpmnReplace',\n  'bpmnRules',\n  'elementRegistry',\n  'injector',\n  'modeling',\n  'selection'\n];\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/ResizeBehavior.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nvar ResizeBehavior_HIGH_PRIORITY = 1500;\r\n\r\nvar GROUP_MIN_DIMENSIONS = { width: 140, height: 120 };\r\n\r\nvar LANE_MIN_DIMENSIONS = { width: 300, height: 60 };\r\n\r\nvar PARTICIPANT_MIN_DIMENSIONS = { width: 300, height: 150 };\r\n\r\nvar SUB_PROCESS_MIN_DIMENSIONS = { width: 140, height: 120 };\r\n\r\nvar TEXT_ANNOTATION_MIN_DIMENSIONS = { width: 50, height: 30 };\r\n\r\n/**\r\n * Set minimum bounds/resize constraints on resize.\r\n *\r\n * @param {EventBus} eventBus\r\n */\r\nfunction ResizeBehavior(eventBus) {\r\n  eventBus.on('resize.start', ResizeBehavior_HIGH_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        shape = context.shape,\r\n        direction = context.direction,\r\n        balanced = context.balanced;\r\n\r\n    if ((0,ModelUtil.is)(shape, 'bpmn:Lane') || (0,ModelUtil.is)(shape, 'bpmn:Participant')) {\r\n      context.resizeConstraints = getParticipantResizeConstraints(shape, direction, balanced);\r\n    }\r\n\r\n    if ((0,ModelUtil.is)(shape, 'bpmn:Participant')) {\r\n      context.minDimensions = PARTICIPANT_MIN_DIMENSIONS;\r\n    }\r\n\r\n    if ((0,ModelUtil.is)(shape, 'bpmn:SubProcess') && (0,DiUtil/* isExpanded */.ul)(shape)) {\r\n      context.minDimensions = SUB_PROCESS_MIN_DIMENSIONS;\r\n    }\r\n\r\n    if ((0,ModelUtil.is)(shape, 'bpmn:TextAnnotation')) {\r\n      context.minDimensions = TEXT_ANNOTATION_MIN_DIMENSIONS;\r\n    }\r\n  });\r\n}\r\n\r\nResizeBehavior.$inject = [ 'eventBus' ];\r\n\r\n\r\nvar ResizeBehavior_abs = Math.abs,\r\n    min = Math.min,\r\n    max = Math.max;\r\n\r\n\r\nfunction addToTrbl(trbl, attr, value, choice) {\r\n  var current = trbl[attr];\r\n\r\n  // make sure to set the value if it does not exist\r\n  // or apply the correct value by comparing against\r\n  // choice(value, currentValue)\r\n  trbl[attr] = current === undefined ? value : choice(value, current);\r\n}\r\n\r\nfunction addMin(trbl, attr, value) {\r\n  return addToTrbl(trbl, attr, value, min);\r\n}\r\n\r\nfunction addMax(trbl, attr, value) {\r\n  return addToTrbl(trbl, attr, value, max);\r\n}\r\n\r\nvar LANE_RIGHT_PADDING = 20,\r\n    LANE_LEFT_PADDING = 50,\r\n    LANE_TOP_PADDING = 20,\r\n    LANE_BOTTOM_PADDING = 20;\r\n\r\nfunction getParticipantResizeConstraints(laneShape, resizeDirection, balanced) {\r\n  var lanesRoot = getLanesRoot(laneShape);\r\n\r\n  var isFirst = true,\r\n      isLast = true;\r\n\r\n  // max top/bottom size for lanes\r\n  var allLanes = collectLanes(lanesRoot, [ lanesRoot ]);\r\n\r\n  var laneTrbl = (0,LayoutUtil/* asTRBL */.JA)(laneShape);\r\n\r\n  var maxTrbl = {},\r\n      minTrbl = {};\r\n\r\n  if (/e/.test(resizeDirection)) {\r\n    minTrbl.right = laneTrbl.left + LANE_MIN_DIMENSIONS.width;\r\n  } else\r\n  if (/w/.test(resizeDirection)) {\r\n    minTrbl.left = laneTrbl.right - LANE_MIN_DIMENSIONS.width;\r\n  }\r\n\r\n  allLanes.forEach(function(other) {\r\n\r\n    var otherTrbl = (0,LayoutUtil/* asTRBL */.JA)(other);\r\n\r\n    if (/n/.test(resizeDirection)) {\r\n\r\n      if (otherTrbl.top < (laneTrbl.top - 10)) {\r\n        isFirst = false;\r\n      }\r\n\r\n      // max top size (based on next element)\r\n      if (balanced && ResizeBehavior_abs(laneTrbl.top - otherTrbl.bottom) < 10) {\r\n        addMax(maxTrbl, 'top', otherTrbl.top + LANE_MIN_DIMENSIONS.height);\r\n      }\r\n\r\n      // min top size (based on self or nested element)\r\n      if (ResizeBehavior_abs(laneTrbl.top - otherTrbl.top) < 5) {\r\n        addMin(minTrbl, 'top', otherTrbl.bottom - LANE_MIN_DIMENSIONS.height);\r\n      }\r\n    }\r\n\r\n    if (/s/.test(resizeDirection)) {\r\n\r\n      if (otherTrbl.bottom > (laneTrbl.bottom + 10)) {\r\n        isLast = false;\r\n      }\r\n\r\n      // max bottom size (based on previous element)\r\n      if (balanced && ResizeBehavior_abs(laneTrbl.bottom - otherTrbl.top) < 10) {\r\n        addMin(maxTrbl, 'bottom', otherTrbl.bottom - LANE_MIN_DIMENSIONS.height);\r\n      }\r\n\r\n      // min bottom size (based on self or nested element)\r\n      if (ResizeBehavior_abs(laneTrbl.bottom - otherTrbl.bottom) < 5) {\r\n        addMax(minTrbl, 'bottom', otherTrbl.top + LANE_MIN_DIMENSIONS.height);\r\n      }\r\n    }\r\n  });\r\n\r\n  // max top/bottom/left/right size based on flow nodes\r\n  var flowElements = lanesRoot.children.filter(function(s) {\r\n    return !s.hidden && !s.waypoints && ((0,ModelUtil.is)(s, 'bpmn:FlowElement') || (0,ModelUtil.is)(s, 'bpmn:Artifact'));\r\n  });\r\n\r\n  flowElements.forEach(function(flowElement) {\r\n\r\n    var flowElementTrbl = (0,LayoutUtil/* asTRBL */.JA)(flowElement);\r\n\r\n    if (isFirst && /n/.test(resizeDirection)) {\r\n      addMin(minTrbl, 'top', flowElementTrbl.top - LANE_TOP_PADDING);\r\n    }\r\n\r\n    if (/e/.test(resizeDirection)) {\r\n      addMax(minTrbl, 'right', flowElementTrbl.right + LANE_RIGHT_PADDING);\r\n    }\r\n\r\n    if (isLast && /s/.test(resizeDirection)) {\r\n      addMax(minTrbl, 'bottom', flowElementTrbl.bottom + LANE_BOTTOM_PADDING);\r\n    }\r\n\r\n    if (/w/.test(resizeDirection)) {\r\n      addMin(minTrbl, 'left', flowElementTrbl.left - LANE_LEFT_PADDING);\r\n    }\r\n  });\r\n\r\n  return {\r\n    min: minTrbl,\r\n    max: maxTrbl\r\n  };\r\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/ResizeLaneBehavior.js\n\n\n\n\n\n\nvar SLIGHTLY_HIGHER_PRIORITY = 1001;\n\n\n/**\n * Invoke {@link Modeling#resizeLane} instead of\n * {@link Modeling#resizeShape} when resizing a Lane\n * or Participant shape.\n */\nfunction ResizeLaneBehavior(eventBus, modeling) {\n\n  eventBus.on('resize.start', SLIGHTLY_HIGHER_PRIORITY + 500, function(event) {\n    var context = event.context,\n        shape = context.shape;\n\n    if ((0,ModelUtil.is)(shape, 'bpmn:Lane') || (0,ModelUtil.is)(shape, 'bpmn:Participant')) {\n\n      // should we resize the opposite lane(s) in\n      // order to compensate for the resize operation?\n      context.balanced = !(0,Mouse/* hasPrimaryModifier */.RJ)(event);\n    }\n  });\n\n  /**\n   * Intercept resize end and call resize lane function instead.\n   */\n  eventBus.on('resize.end', SLIGHTLY_HIGHER_PRIORITY, function(event) {\n    var context = event.context,\n        shape = context.shape,\n        canExecute = context.canExecute,\n        newBounds = context.newBounds;\n\n    if ((0,ModelUtil.is)(shape, 'bpmn:Lane') || (0,ModelUtil.is)(shape, 'bpmn:Participant')) {\n\n      if (canExecute) {\n\n        // ensure we have actual pixel values for new bounds\n        // (important when zoom level was > 1 during move)\n        newBounds = (0,LayoutUtil/* roundBounds */.aR)(newBounds);\n\n        // perform the actual resize\n        modeling.resizeLane(shape, newBounds, context.balanced);\n      }\n\n      // stop propagation\n      return false;\n    }\n  });\n}\n\nResizeLaneBehavior.$inject = [\n  'eventBus',\n  'modeling'\n];\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/RootElementReferenceBehavior.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nvar RootElementReferenceBehavior_LOW_PRIORITY = 500;\r\n\r\n\r\n/**\r\n * Add referenced root elements (error, escalation, message, signal) if they don't exist.\r\n * Copy referenced root elements on copy & paste.\r\n */\r\nfunction RootElementReferenceBehavior(\r\n    bpmnjs, eventBus, injector, moddleCopy, bpmnFactory\r\n) {\r\n  injector.invoke(CommandInterceptor/* default */.Z, this);\r\n\r\n  function canHaveRootElementReference(element) {\r\n    return (0,ModelUtil/* isAny */.JZ)(element, [ 'bpmn:ReceiveTask', 'bpmn:SendTask' ]) ||\r\n      hasAnyEventDefinition(element, [\r\n        'bpmn:ErrorEventDefinition',\r\n        'bpmn:EscalationEventDefinition',\r\n        'bpmn:MessageEventDefinition',\r\n        'bpmn:SignalEventDefinition'\r\n      ]);\r\n  }\r\n\r\n  function hasRootElement(rootElement) {\r\n    var definitions = bpmnjs.getDefinitions(),\r\n        rootElements = definitions.get('rootElements');\r\n\r\n    return !!(0,dist_index_esm/* find */.sE)(rootElements, (0,dist_index_esm/* matchPattern */.KQ)({ id: rootElement.id }));\r\n  }\r\n\r\n  function getRootElementReferencePropertyName(eventDefinition) {\r\n    if ((0,ModelUtil.is)(eventDefinition, 'bpmn:ErrorEventDefinition')) {\r\n      return 'errorRef';\r\n    } else if ((0,ModelUtil.is)(eventDefinition, 'bpmn:EscalationEventDefinition')) {\r\n      return 'escalationRef';\r\n    } else if ((0,ModelUtil.is)(eventDefinition, 'bpmn:MessageEventDefinition')) {\r\n      return 'messageRef';\r\n    } else if ((0,ModelUtil.is)(eventDefinition, 'bpmn:SignalEventDefinition')) {\r\n      return 'signalRef';\r\n    }\r\n  }\r\n\r\n  function getRootElement(businessObject) {\r\n    if ((0,ModelUtil/* isAny */.JZ)(businessObject, [ 'bpmn:ReceiveTask', 'bpmn:SendTask' ])) {\r\n      return businessObject.get('messageRef');\r\n    }\r\n\r\n    var eventDefinitions = businessObject.get('eventDefinitions'),\r\n        eventDefinition = eventDefinitions[ 0 ];\r\n\r\n    return eventDefinition.get(getRootElementReferencePropertyName(eventDefinition));\r\n  }\r\n\r\n  function setRootElement(businessObject, rootElement) {\r\n    if ((0,ModelUtil/* isAny */.JZ)(businessObject, [ 'bpmn:ReceiveTask', 'bpmn:SendTask' ])) {\r\n      return businessObject.set('messageRef', rootElement);\r\n    }\r\n\r\n    var eventDefinitions = businessObject.get('eventDefinitions'),\r\n        eventDefinition = eventDefinitions[ 0 ];\r\n\r\n    return eventDefinition.set(getRootElementReferencePropertyName(eventDefinition), rootElement);\r\n  }\r\n\r\n  // create shape\r\n  this.executed('shape.create', function(context) {\r\n    var shape = context.shape;\r\n\r\n    if (!canHaveRootElementReference(shape)) {\r\n      return;\r\n    }\r\n\r\n    var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(shape),\r\n        rootElement = getRootElement(businessObject),\r\n        rootElements;\r\n\r\n    if (rootElement && !hasRootElement(rootElement)) {\r\n      rootElements = bpmnjs.getDefinitions().get('rootElements');\r\n\r\n      // add root element\r\n      (0,Collections/* add */.IH)(rootElements, rootElement);\r\n\r\n      context.addedRootElement = rootElement;\r\n    }\r\n  }, true);\r\n\r\n  this.reverted('shape.create', function(context) {\r\n    var addedRootElement = context.addedRootElement;\r\n\r\n    if (!addedRootElement) {\r\n      return;\r\n    }\r\n\r\n    var rootElements = bpmnjs.getDefinitions().get('rootElements');\r\n\r\n    // remove root element\r\n    (0,Collections/* remove */.Od)(rootElements, addedRootElement);\r\n  }, true);\r\n\r\n  eventBus.on('copyPaste.copyElement', function(context) {\r\n    var descriptor = context.descriptor,\r\n        element = context.element;\r\n\r\n    if (element.labelTarget || !canHaveRootElementReference(element)) {\r\n      return;\r\n    }\r\n\r\n    var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(element),\r\n        rootElement = getRootElement(businessObject);\r\n\r\n    if (rootElement) {\r\n\r\n      // TODO(nikku): clone on copy\r\n      descriptor.referencedRootElement = rootElement;\r\n    }\r\n  });\r\n\r\n  eventBus.on('copyPaste.pasteElement', RootElementReferenceBehavior_LOW_PRIORITY, function(context) {\r\n    var descriptor = context.descriptor,\r\n        businessObject = descriptor.businessObject,\r\n        referencedRootElement = descriptor.referencedRootElement;\r\n\r\n    if (!referencedRootElement) {\r\n      return;\r\n    }\r\n\r\n    if (!hasRootElement(referencedRootElement)) {\r\n      referencedRootElement = moddleCopy.copyElement(\r\n        referencedRootElement,\r\n        bpmnFactory.create(referencedRootElement.$type)\r\n      );\r\n    }\r\n\r\n    setRootElement(businessObject, referencedRootElement);\r\n\r\n    delete descriptor.referencedRootElement;\r\n  });\r\n}\r\n\r\nRootElementReferenceBehavior.$inject = [\r\n  'bpmnjs',\r\n  'eventBus',\r\n  'injector',\r\n  'moddleCopy',\r\n  'bpmnFactory'\r\n];\r\n\r\n(0,index_es/* default */.Z)(RootElementReferenceBehavior, CommandInterceptor/* default */.Z);\r\n\r\n// helpers //////////\r\n\r\nfunction hasAnyEventDefinition(element, types) {\r\n  if (!(0,dist_index_esm/* isArray */.kJ)(types)) {\r\n    types = [ types ];\r\n  }\r\n\r\n  return (0,dist_index_esm/* some */.G)(types, function(type) {\r\n    return (0,DiUtil/* hasEventDefinition */.JG)(element, type);\r\n  });\r\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/SpaceToolBehavior.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nvar SpaceToolBehavior_max = Math.max;\r\n\r\n\r\nfunction SpaceToolBehavior(eventBus) {\r\n  eventBus.on('spaceTool.getMinDimensions', function(context) {\r\n    var shapes = context.shapes,\r\n        axis = context.axis,\r\n        start = context.start,\r\n        minDimensions = {};\r\n\r\n    (0,dist_index_esm/* forEach */.Ed)(shapes, function(shape) {\r\n      var id = shape.id;\r\n\r\n      if ((0,ModelUtil.is)(shape, 'bpmn:Participant')) {\r\n\r\n        if (SpaceToolBehavior_isHorizontal(axis)) {\r\n          minDimensions[ id ] = PARTICIPANT_MIN_DIMENSIONS;\r\n        } else {\r\n          minDimensions[ id ] = {\r\n            width: PARTICIPANT_MIN_DIMENSIONS.width,\r\n            height: getParticipantMinHeight(shape, start)\r\n          };\r\n        }\r\n\r\n      }\r\n\r\n      if ((0,ModelUtil.is)(shape, 'bpmn:SubProcess') && (0,DiUtil/* isExpanded */.ul)(shape)) {\r\n        minDimensions[ id ] = SUB_PROCESS_MIN_DIMENSIONS;\r\n      }\r\n\r\n      if ((0,ModelUtil.is)(shape, 'bpmn:TextAnnotation')) {\r\n        minDimensions[ id ] = TEXT_ANNOTATION_MIN_DIMENSIONS;\r\n      }\r\n\r\n      if ((0,ModelUtil.is)(shape, 'bpmn:Group')) {\r\n        minDimensions[ id ] = GROUP_MIN_DIMENSIONS;\r\n      }\r\n    });\r\n\r\n    return minDimensions;\r\n  });\r\n}\r\n\r\nSpaceToolBehavior.$inject = [ 'eventBus' ];\r\n\r\n\r\n// helpers //////////\r\nfunction SpaceToolBehavior_isHorizontal(axis) {\r\n  return axis === 'x';\r\n}\r\n\r\n/**\r\n * Get minimum height for participant taking lanes into account.\r\n *\r\n * @param {<djs.model.Shape>} participant\r\n * @param {number} start\r\n *\r\n * @returns {Object}\r\n */\r\nfunction getParticipantMinHeight(participant, start) {\r\n  var lanesMinHeight;\r\n\r\n  if (!hasChildLanes(participant)) {\r\n    return PARTICIPANT_MIN_DIMENSIONS.height;\r\n  }\r\n\r\n  lanesMinHeight = getLanesMinHeight(participant, start);\r\n\r\n  return SpaceToolBehavior_max(PARTICIPANT_MIN_DIMENSIONS.height, lanesMinHeight);\r\n}\r\n\r\nfunction hasChildLanes(element) {\r\n  return !!getChildLanes(element).length;\r\n}\r\n\r\nfunction getLanesMinHeight(participant, resizeStart) {\r\n  var lanes = getChildLanes(participant),\r\n      resizedLane;\r\n\r\n  // find the nested lane which is currently resized\r\n  resizedLane = findResizedLane(lanes, resizeStart);\r\n\r\n  // resized lane cannot shrink below the minimum height\r\n  // but remaining lanes' dimensions are kept intact\r\n  return participant.height - resizedLane.height + LANE_MIN_DIMENSIONS.height;\r\n}\r\n\r\n/**\r\n * Find nested lane which is currently resized.\r\n *\r\n * @param {Array<djs.model.Shape>} lanes\r\n * @param {number} resizeStart\r\n */\r\nfunction findResizedLane(lanes, resizeStart) {\r\n  var i, lane, childLanes;\r\n\r\n  for (i = 0; i < lanes.length; i++) {\r\n    lane = lanes[i];\r\n\r\n    // resizing current lane or a lane nested\r\n    if (resizeStart >= lane.y && resizeStart <= lane.y + lane.height) {\r\n      childLanes = getChildLanes(lane);\r\n\r\n      // a nested lane is resized\r\n      if (childLanes.length) {\r\n        return findResizedLane(childLanes, resizeStart);\r\n      }\r\n\r\n      // current lane is the resized one\r\n      return lane;\r\n    }\r\n  }\r\n}\r\n\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/DrilldownUtil.js\nvar DrilldownUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/DrilldownUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/SubProcessPlaneBehavior.js\n\n\n\n\n\n\n\n\n\n\n\n\nvar SubProcessPlaneBehavior_LOW_PRIORITY = 400;\nvar SubProcessPlaneBehavior_HIGH_PRIORITY = 600;\n\nvar DEFAULT_POSITION = {\n  x: 180,\n  y: 160\n};\n\n\n/**\n * Creates bpmndi:BPMNPlane elements and canvas planes when collapsed subprocesses are created.\n *\n *\n * @param {Canvas} canvas\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n * @param {ElementFactory} elementFactory\n * @param {BpmnFactory} bpmnFactory\n * @param {Bpmnjs} bpmnjs\n * @param {ElementRegistry} elementRegistry\n */\nfunction SubProcessPlaneBehavior(\n    canvas, eventBus, modeling,\n    elementFactory, bpmnFactory, bpmnjs, elementRegistry) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  this._canvas = canvas;\n  this._eventBus = eventBus;\n  this._modeling = modeling;\n  this._elementFactory = elementFactory;\n  this._bpmnFactory = bpmnFactory;\n  this._bpmnjs = bpmnjs;\n  this._elementRegistry = elementRegistry;\n\n  var self = this;\n\n  function isCollapsedSubProcess(element) {\n    return (0,ModelUtil.is)(element, 'bpmn:SubProcess') && !(0,DiUtil/* isExpanded */.ul)(element);\n  }\n\n  function createRoot(context) {\n    var shape = context.shape,\n        rootElement = context.newRootElement;\n\n    var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(shape);\n\n    rootElement = self._addDiagram(rootElement || businessObject);\n\n    context.newRootElement = canvas.addRootElement(rootElement);\n  }\n\n  function removeRoot(context) {\n    var shape = context.shape;\n\n    var businessObject = (0,ModelUtil/* getBusinessObject */.SS)(shape);\n    self._removeDiagram(businessObject);\n\n    var rootElement = context.newRootElement = elementRegistry.get((0,DrilldownUtil/* getPlaneIdFromShape */.sU)(businessObject));\n\n    canvas.removeRootElement(rootElement);\n  }\n\n  // add plane elements for newly created sub-processes\n  // this ensures we can actually drill down into the element\n  this.executed('shape.create', function(context) {\n    var shape = context.shape;\n    if (!isCollapsedSubProcess(shape)) {\n      return;\n    }\n\n    createRoot(context);\n  }, true);\n\n\n  this.postExecuted('shape.create', function(context) {\n    var shape = context.shape,\n        rootElement = context.newRootElement;\n\n    if (!rootElement || !shape.children) {\n      return;\n    }\n\n    self._showRecursively(shape.children);\n\n    self._moveChildrenToShape(shape, rootElement);\n  }, true);\n\n\n  this.reverted('shape.create', function(context) {\n    var shape = context.shape;\n    if (!isCollapsedSubProcess(shape)) {\n      return;\n    }\n\n    removeRoot(context);\n  }, true);\n\n\n  this.preExecuted('shape.delete', function(context) {\n    var shape = context.shape;\n    if (!isCollapsedSubProcess(shape)) {\n      return;\n    }\n\n    var attachedRoot = elementRegistry.get((0,DrilldownUtil/* getPlaneIdFromShape */.sU)(shape));\n\n    if (!attachedRoot) {\n      return;\n    }\n\n    modeling.removeElements(attachedRoot.children.slice());\n  }, true);\n\n\n  this.executed('shape.delete', function(context) {\n    var shape = context.shape;\n    if (!isCollapsedSubProcess(shape)) {\n      return;\n    }\n    removeRoot(context);\n  }, true);\n\n\n  this.reverted('shape.delete', function(context) {\n    var shape = context.shape;\n    if (!isCollapsedSubProcess(shape)) {\n      return;\n    }\n\n    createRoot(context);\n  }, true);\n\n\n  this.preExecuted('shape.replace', function(context) {\n    var oldShape = context.oldShape;\n    var newShape = context.newShape;\n\n    if (!isCollapsedSubProcess(oldShape) || !isCollapsedSubProcess(newShape)) {\n      return;\n    }\n\n    // old plane could have content,\n    // we remove it so it is not recursively deleted from 'shape.delete'\n    context.oldRoot = canvas.removeRootElement((0,DrilldownUtil/* getPlaneIdFromShape */.sU)(oldShape));\n  }, true);\n\n\n  this.postExecuted('shape.replace', function(context) {\n    var newShape = context.newShape,\n        source = context.oldRoot,\n        target = canvas.findRoot((0,DrilldownUtil/* getPlaneIdFromShape */.sU)(newShape));\n\n    if (!source || !target) {\n      return;\n    }\n    var elements = source.children;\n\n    modeling.moveElements(elements, { x: 0, y: 0 }, target);\n  }, true);\n\n\n  // rename primary elements when the secondary element changes\n  // this ensures rootElement.id = element.id + '_plane'\n  this.executed('element.updateProperties', function(context) {\n    var shape = context.element;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:SubProcess')) {\n      return;\n    }\n\n    var properties = context.properties;\n    var oldProperties = context.oldProperties;\n\n    var oldId = oldProperties.id,\n        newId = properties.id;\n\n    if (oldId === newId) {\n      return;\n    }\n\n    if ((0,DrilldownUtil/* isPlane */.k3)(shape)) {\n      elementRegistry.updateId(shape, (0,DrilldownUtil/* toPlaneId */.UK)(newId));\n      elementRegistry.updateId(oldId, newId);\n\n      return;\n    }\n\n    var planeElement = elementRegistry.get((0,DrilldownUtil/* toPlaneId */.UK)(oldId));\n\n    if (!planeElement) {\n      return;\n    }\n\n    elementRegistry.updateId((0,DrilldownUtil/* toPlaneId */.UK)(oldId), (0,DrilldownUtil/* toPlaneId */.UK)(newId));\n  }, true);\n\n\n  this.reverted('element.updateProperties', function(context) {\n    var shape = context.element;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:SubProcess')) {\n      return;\n    }\n\n    var properties = context.properties;\n    var oldProperties = context.oldProperties;\n\n    var oldId = oldProperties.id,\n        newId = properties.id;\n\n    if (oldId === newId) {\n      return;\n    }\n\n    if ((0,DrilldownUtil/* isPlane */.k3)(shape)) {\n      elementRegistry.updateId(shape, (0,DrilldownUtil/* toPlaneId */.UK)(oldId));\n      elementRegistry.updateId(newId, oldId);\n\n      return;\n    }\n\n    var planeElement = elementRegistry.get((0,DrilldownUtil/* toPlaneId */.UK)(newId));\n\n    if (!planeElement) {\n      return;\n    }\n\n    elementRegistry.updateId(planeElement, (0,DrilldownUtil/* toPlaneId */.UK)(oldId));\n  }, true);\n\n  // re-throw element.changed to re-render primary shape if associated plane has\n  // changed (e.g. bpmn:name property has changed)\n  eventBus.on('element.changed', function(context) {\n    var element = context.element;\n\n    if (!(0,DrilldownUtil/* isPlane */.k3)(element)) {\n      return;\n    }\n\n    var plane = element;\n\n    var primaryShape = elementRegistry.get((0,DrilldownUtil/* getShapeIdFromPlane */.Ln)(plane));\n\n    // do not re-throw if no associated primary shape (e.g. bpmn:Process)\n    if (!primaryShape || primaryShape === plane) {\n      return;\n    }\n\n    eventBus.fire('element.changed', { element: primaryShape });\n  });\n\n\n  // create/remove plane for the subprocess\n  this.executed('shape.toggleCollapse', SubProcessPlaneBehavior_LOW_PRIORITY, function(context) {\n    var shape = context.shape;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:SubProcess')) {\n      return;\n    }\n\n    if (!(0,DiUtil/* isExpanded */.ul)(shape)) {\n      createRoot(context);\n      self._showRecursively(shape.children);\n    } else {\n      removeRoot(context);\n    }\n\n  }, true);\n\n\n  // create/remove plane for the subprocess\n  this.reverted('shape.toggleCollapse', SubProcessPlaneBehavior_LOW_PRIORITY, function(context) {\n    var shape = context.shape;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:SubProcess')) {\n      return;\n    }\n\n    if (!(0,DiUtil/* isExpanded */.ul)(shape)) {\n      createRoot(context);\n      self._showRecursively(shape.children);\n    } else {\n      removeRoot(context);\n    }\n\n  }, true);\n\n  // move elements between planes\n  this.postExecuted('shape.toggleCollapse', SubProcessPlaneBehavior_HIGH_PRIORITY, function(context) {\n    var shape = context.shape;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:SubProcess')) {\n      return;\n    }\n\n    var rootElement = context.newRootElement;\n\n    if (!rootElement) {\n      return;\n    }\n\n    if (!(0,DiUtil/* isExpanded */.ul)(shape)) {\n\n      // collapsed\n      self._moveChildrenToShape(shape, rootElement);\n\n    } else {\n      self._moveChildrenToShape(rootElement, shape);\n    }\n  }, true);\n\n\n  // copy-paste ///////////\n\n  // add elements in plane to tree\n  eventBus.on('copyPaste.createTree', function(context) {\n    var element = context.element,\n        children = context.children;\n\n    if (!isCollapsedSubProcess(element)) {\n      return;\n    }\n\n    var id = (0,DrilldownUtil/* getPlaneIdFromShape */.sU)(element);\n    var parent = elementRegistry.get(id);\n\n    if (parent) {\n\n      // do not copy invisible root element\n      children.push.apply(children, parent.children);\n    }\n  });\n\n  // set plane children as direct children of collapsed shape\n  eventBus.on('copyPaste.copyElement', function(context) {\n    var descriptor = context.descriptor,\n        element = context.element,\n        elements = context.elements;\n\n    var parent = element.parent;\n\n    var isPlane = (0,ModelUtil.is)((0,ModelUtil/* getDi */.DN)(parent), 'bpmndi:BPMNPlane');\n    if (!isPlane) {\n      return;\n    }\n\n    var parentId = (0,DrilldownUtil/* getShapeIdFromPlane */.Ln)(parent);\n\n    var referencedShape = (0,dist_index_esm/* find */.sE)(elements, function(element) {\n      return element.id === parentId;\n    });\n\n    if (!referencedShape) {\n      return;\n    }\n\n    descriptor.parent = referencedShape.id;\n  });\n\n  // hide children during pasting\n  eventBus.on('copyPaste.pasteElement', function(context) {\n    var descriptor = context.descriptor;\n\n    if (!descriptor.parent) {\n      return;\n    }\n\n    if (isCollapsedSubProcess(descriptor.parent) || descriptor.parent.hidden) {\n      descriptor.hidden = true;\n    }\n  });\n\n}\n\n(0,index_es/* default */.Z)(SubProcessPlaneBehavior, CommandInterceptor/* default */.Z);\n\n/**\n * Moves the child elements from source to target.\n *\n * If the target is a plane, the children are moved to the top left corner.\n * Otherwise, the center of the target is used.\n *\n * @param {Object|djs.model.Base} source\n * @param {Object|djs.model.Base} target\n */\nSubProcessPlaneBehavior.prototype._moveChildrenToShape = function(source, target) {\n  var modeling = this._modeling;\n\n  var children = source.children;\n  var offset;\n\n  if (!children) {\n    return;\n  }\n\n  // add external labels that weren't children of sub process\n  children = children.concat(children.reduce(function(labels, child) {\n    if (child.label && child.label.parent !== source) {\n      return labels.concat(child.label);\n    }\n\n    return labels;\n  }, []));\n\n  // only change plane if there are no visible children, but don't move them\n  var visibleChildren = children.filter(function(child) {\n    return !child.hidden;\n  });\n\n  if (!visibleChildren.length) {\n    modeling.moveElements(children, { x: 0, y: 0 }, target, { autoResize: false });\n    return;\n  }\n\n  var childrenBounds = (0,Elements/* getBBox */.jY)(visibleChildren);\n\n  // target is a plane\n  if (!target.x) {\n    offset = {\n      x: DEFAULT_POSITION.x - childrenBounds.x,\n      y: DEFAULT_POSITION.y - childrenBounds.y\n    };\n  }\n\n  // source is a plane\n  else {\n\n    // move relative to the center of the shape\n    var targetMid = (0,LayoutUtil/* getMid */.wS)(target);\n    var childrenMid = (0,LayoutUtil/* getMid */.wS)(childrenBounds);\n\n    offset = {\n      x: targetMid.x - childrenMid.x,\n      y: targetMid.y - childrenMid.y\n    };\n  }\n\n  modeling.moveElements(children, offset, target, { autoResize: false });\n};\n\n/**\n * Sets `hidden` property on all children of the given shape.\n *\n * @param {Array} elements\n * @param {Boolean} [hidden]\n * @returns {Array} all child elements\n */\nSubProcessPlaneBehavior.prototype._showRecursively = function(elements, hidden) {\n  var self = this;\n\n  var result = [];\n  elements.forEach(function(element) {\n    element.hidden = !!hidden;\n\n    result = result.concat(element);\n\n    if (element.children) {\n      result = result.concat(\n        self._showRecursively(element.children, element.collapsed || hidden)\n      );\n    }\n  });\n\n  return result;\n};\n\n/**\n* Adds a given rootElement to the bpmnDi diagrams.\n*\n* @param {Object} rootElement\n* @returns {Object} planeElement\n*/\nSubProcessPlaneBehavior.prototype._addDiagram = function(planeElement) {\n  var bpmnjs = this._bpmnjs;\n  var diagrams = bpmnjs.getDefinitions().diagrams;\n\n  if (!planeElement.businessObject) {\n    planeElement = this._createNewDiagram(planeElement);\n  }\n\n  diagrams.push(planeElement.di.$parent);\n\n  return planeElement;\n};\n\n\n/**\n* Creates a new plane element for the given sub process.\n*\n* @param {Object} bpmnElement\n*\n* @return {Object} new diagram element\n*/\nSubProcessPlaneBehavior.prototype._createNewDiagram = function(bpmnElement) {\n  var bpmnFactory = this._bpmnFactory;\n  var elementFactory = this._elementFactory;\n\n  var diPlane = bpmnFactory.create('bpmndi:BPMNPlane', {\n    bpmnElement: bpmnElement\n  });\n  var diDiagram = bpmnFactory.create('bpmndi:BPMNDiagram', {\n    plane: diPlane\n  });\n  diPlane.$parent = diDiagram;\n\n  // add a virtual element (not being drawn),\n  // a copy cat of our BpmnImporter code\n  var planeElement = elementFactory.createRoot({\n    id: (0,DrilldownUtil/* getPlaneIdFromShape */.sU)(bpmnElement),\n    type: bpmnElement.$type,\n    di: diPlane,\n    businessObject: bpmnElement,\n    collapsed: true\n  });\n\n  return planeElement;\n};\n\n/**\n * Removes the diagram for a given root element\n *\n * @param {Object} rootElement\n * @returns {Object} removed bpmndi:BPMNDiagram\n */\nSubProcessPlaneBehavior.prototype._removeDiagram = function(rootElement) {\n  var bpmnjs = this._bpmnjs;\n\n  var diagrams = bpmnjs.getDefinitions().diagrams;\n\n  var removedDiagram = (0,dist_index_esm/* find */.sE)(diagrams, function(diagram) {\n    return diagram.plane.bpmnElement.id === rootElement.id;\n  });\n\n  diagrams.splice(diagrams.indexOf(removedDiagram), 1);\n\n  return removedDiagram;\n};\n\n\nSubProcessPlaneBehavior.$inject = [\n  'canvas',\n  'eventBus',\n  'modeling',\n  'elementFactory',\n  'bpmnFactory',\n  'bpmnjs',\n  'elementRegistry'\n];\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/SubProcessStartEventBehavior.js\n\n\n\n\n\n\n\n/**\n * Add start event replacing element with expanded sub process.\n *\n * @param {Injector} injector\n * @param {Modeling} modeling\n */\nfunction SubProcessStartEventBehavior(injector, modeling) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n\n  this.postExecuted('shape.replace', function(event) {\n    var oldShape = event.context.oldShape,\n        newShape = event.context.newShape;\n\n    if (\n      !(0,ModelUtil.is)(newShape, 'bpmn:SubProcess') ||\n      ! ((0,ModelUtil.is)(oldShape, 'bpmn:Task') || (0,ModelUtil.is)(oldShape, 'bpmn:CallActivity')) ||\n      !(0,DiUtil/* isExpanded */.ul)(newShape)\n    ) {\n      return;\n    }\n\n    var position = getStartEventPosition(newShape);\n\n    modeling.createShape({ type: 'bpmn:StartEvent' }, position, newShape);\n  });\n}\n\nSubProcessStartEventBehavior.$inject = [\n  'injector',\n  'modeling'\n];\n\n(0,index_es/* default */.Z)(SubProcessStartEventBehavior, CommandInterceptor/* default */.Z);\n\n// helpers //////////\n\nfunction getStartEventPosition(shape) {\n  return {\n    x: shape.x + shape.width / 6,\n    y: shape.y + shape.height / 2\n  };\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/ToggleCollapseConnectionBehaviour.js\n\n\n\n\n\n\n\n\n\n\n\n\n\nfunction ToggleCollapseConnectionBehaviour(\n    eventBus, modeling\n) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  this.postExecuted('shape.toggleCollapse', 1500, function(context) {\n\n    // var shape = context.shape;\n    var shape = context.shape;\n\n    // only change connections when collapsing\n    if ((0,DiUtil/* isExpanded */.ul)(shape)) {\n      return;\n    }\n\n    var allChildren = (0,Elements/* selfAndAllChildren */.PB)(shape);\n\n    allChildren.forEach(function(child) {\n\n      // Ensure that the connection array is not modified during iteration\n      var incomingConnections = child.incoming.slice(),\n          outgoingConnections = child.outgoing.slice();\n\n      (0,dist_index_esm/* forEach */.Ed)(incomingConnections, function(c) {\n        handleConnection(c, true);\n      });\n\n      (0,dist_index_esm/* forEach */.Ed)(outgoingConnections, function(c) {\n        handleConnection(c, false);\n      });\n    });\n\n\n    function handleConnection(c, incoming) {\n      if (allChildren.indexOf(c.source) !== -1 && allChildren.indexOf(c.target) !== -1) {\n        return;\n      }\n\n      if (incoming) {\n        modeling.reconnectEnd(c, shape, (0,LayoutUtil/* getMid */.wS)(shape));\n      } else {\n        modeling.reconnectStart(c, shape, (0,LayoutUtil/* getMid */.wS)(shape));\n      }\n\n    }\n\n  }, true);\n\n}\n\n(0,index_es/* default */.Z)(ToggleCollapseConnectionBehaviour, CommandInterceptor/* default */.Z);\n\nToggleCollapseConnectionBehaviour.$inject = [\n  'eventBus',\n  'modeling',\n];\n\n\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/ToggleElementCollapseBehaviour.js\n\n\n\n\n\n\n\n\n\nvar ToggleElementCollapseBehaviour_LOW_PRIORITY = 500;\n\n\nfunction ToggleElementCollapseBehaviour(\n    eventBus, elementFactory, modeling,\n    resize) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n\n  function hideEmptyLabels(children) {\n    if (children.length) {\n      children.forEach(function(child) {\n        if (child.type === 'label' && !child.businessObject.name) {\n          child.hidden = true;\n        }\n      });\n    }\n  }\n\n  function expandedBounds(shape, defaultSize) {\n    var children = shape.children,\n        newBounds = defaultSize,\n        visibleElements,\n        visibleBBox;\n\n    visibleElements = filterVisible(children).concat([ shape ]);\n\n    visibleBBox = (0,ResizeUtil/* computeChildrenBBox */.gE)(visibleElements);\n\n    if (visibleBBox) {\n\n      // center to visibleBBox with max(defaultSize, childrenBounds)\n      newBounds.width = Math.max(visibleBBox.width, newBounds.width);\n      newBounds.height = Math.max(visibleBBox.height, newBounds.height);\n\n      newBounds.x = visibleBBox.x + (visibleBBox.width - newBounds.width) / 2;\n      newBounds.y = visibleBBox.y + (visibleBBox.height - newBounds.height) / 2;\n    } else {\n\n      // center to collapsed shape with defaultSize\n      newBounds.x = shape.x + (shape.width - newBounds.width) / 2;\n      newBounds.y = shape.y + (shape.height - newBounds.height) / 2;\n    }\n\n    return newBounds;\n  }\n\n  function collapsedBounds(shape, defaultSize) {\n\n    return {\n      x: shape.x + (shape.width - defaultSize.width) / 2,\n      y: shape.y + (shape.height - defaultSize.height) / 2,\n      width: defaultSize.width,\n      height: defaultSize.height\n    };\n  }\n\n  this.executed([ 'shape.toggleCollapse' ], ToggleElementCollapseBehaviour_LOW_PRIORITY, function(e) {\n\n    var context = e.context,\n        shape = context.shape;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:SubProcess')) {\n      return;\n    }\n\n    if (!shape.collapsed) {\n\n      // all children got made visible through djs, hide empty labels\n      hideEmptyLabels(shape.children);\n\n      // remove collapsed marker\n      (0,ModelUtil/* getDi */.DN)(shape).isExpanded = true;\n    } else {\n\n      // place collapsed marker\n      (0,ModelUtil/* getDi */.DN)(shape).isExpanded = false;\n    }\n  });\n\n  this.reverted([ 'shape.toggleCollapse' ], ToggleElementCollapseBehaviour_LOW_PRIORITY, function(e) {\n\n    var context = e.context;\n    var shape = context.shape;\n\n\n    // revert removing/placing collapsed marker\n    if (!shape.collapsed) {\n      (0,ModelUtil/* getDi */.DN)(shape).isExpanded = true;\n\n    } else {\n      (0,ModelUtil/* getDi */.DN)(shape).isExpanded = false;\n    }\n  });\n\n  this.postExecuted([ 'shape.toggleCollapse' ], ToggleElementCollapseBehaviour_LOW_PRIORITY, function(e) {\n    var shape = e.context.shape,\n        defaultSize = elementFactory.getDefaultSize(shape),\n        newBounds;\n\n    if (shape.collapsed) {\n\n      // resize to default size of collapsed shapes\n      newBounds = collapsedBounds(shape, defaultSize);\n    } else {\n\n      // resize to bounds of max(visible children, defaultSize)\n      newBounds = expandedBounds(shape, defaultSize);\n    }\n\n    modeling.resizeShape(shape, newBounds, null, {\n      autoResize: shape.collapsed ? false : 'nwse'\n    });\n  });\n\n}\n\n\n(0,index_es/* default */.Z)(ToggleElementCollapseBehaviour, CommandInterceptor/* default */.Z);\n\nToggleElementCollapseBehaviour.$inject = [\n  'eventBus',\n  'elementFactory',\n  'modeling'\n];\n\n\n// helpers //////////////////////\n\nfunction filterVisible(elements) {\n  return elements.filter(function(e) {\n    return !e.hidden;\n  });\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/UnclaimIdBehavior.js\n\n\n\n\n\n\n\n\n\n/**\n * Unclaims model IDs on element deletion.\n *\n * @param {Canvas} canvas\n * @param {Injector} injector\n * @param {Moddle} moddle\n * @param {Modeling} modeling\n */\nfunction UnclaimIdBehavior(canvas, injector, moddle, modeling) {\n  injector.invoke(CommandInterceptor/* default */.Z, this);\n\n  this.preExecute('shape.delete', function(event) {\n    var context = event.context,\n        shape = context.shape,\n        shapeBo = shape.businessObject;\n\n    if ((0,util_LabelUtil/* isLabel */.j_)(shape)) {\n      return;\n    }\n\n    if ((0,ModelUtil.is)(shape, 'bpmn:Participant') && (0,DiUtil/* isExpanded */.ul)(shape)) {\n      moddle.ids.unclaim(shapeBo.processRef.id);\n    }\n\n    modeling.unclaimId(shapeBo.id, shapeBo);\n  });\n\n\n  this.preExecute('connection.delete', function(event) {\n    var context = event.context,\n        connection = context.connection,\n        connectionBo = connection.businessObject;\n\n    modeling.unclaimId(connectionBo.id, connectionBo);\n  });\n\n  this.preExecute('canvas.updateRoot', function() {\n    var rootElement = canvas.getRootElement(),\n        rootElementBo = rootElement.businessObject;\n\n    if ((0,ModelUtil.is)(rootElement, 'bpmn:Collaboration')) {\n      moddle.ids.unclaim(rootElementBo.id);\n    }\n  });\n}\n\n(0,index_es/* default */.Z)(UnclaimIdBehavior, CommandInterceptor/* default */.Z);\n\nUnclaimIdBehavior.$inject = [ 'canvas', 'injector', 'moddle', 'modeling' ];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/UnsetDefaultFlowBehavior.js\n\n\n\n\n\n\n\n/**\n * A behavior that unsets the Default property of\n * sequence flow source on element delete, if the\n * removed element is the Gateway or Task's default flow.\n *\n * @param {EventBus} eventBus\n * @param {Modeling} modeling\n */\nfunction DeleteSequenceFlowBehavior(eventBus, modeling) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n\n  this.preExecute('connection.delete', function(event) {\n    var context = event.context,\n        connection = context.connection,\n        source = connection.source;\n\n    if (isDefaultFlow(connection, source)) {\n      modeling.updateProperties(source, {\n        'default': null\n      });\n    }\n  });\n}\n\n(0,index_es/* default */.Z)(DeleteSequenceFlowBehavior, CommandInterceptor/* default */.Z);\n\nDeleteSequenceFlowBehavior.$inject = [\n  'eventBus',\n  'modeling'\n];\n\n\n// helpers //////////////////////\n\nfunction isDefaultFlow(connection, source) {\n\n  if (!(0,ModelUtil.is)(connection, 'bpmn:SequenceFlow')) {\n    return false;\n  }\n\n  var sourceBo = (0,ModelUtil/* getBusinessObject */.SS)(source),\n      sequenceFlow = (0,ModelUtil/* getBusinessObject */.SS)(connection);\n\n  return sourceBo.get('default') === sequenceFlow;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/UpdateFlowNodeRefsBehavior.js\n\n\n\n\n\n\nvar UpdateFlowNodeRefsBehavior_LOW_PRIORITY = 500,\n    UpdateFlowNodeRefsBehavior_HIGH_PRIORITY = 5000;\n\n\n/**\n * BPMN specific delete lane behavior\n */\nfunction UpdateFlowNodeRefsBehavior(eventBus, modeling, translate) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  /**\n   * Ok, this is it:\n   *\n   * We have to update the Lane#flowNodeRefs _and_\n   * FlowNode#lanes with every FlowNode move/resize and\n   * Lane move/resize.\n   *\n   * We want to group that stuff to recompute containments\n   * as efficient as possible.\n   *\n   * Yea!\n   */\n\n  // the update context\n  var context;\n\n\n  function initContext() {\n    context = context || new UpdateContext();\n    context.enter();\n\n    return context;\n  }\n\n  function getContext() {\n    if (!context) {\n      throw new Error(translate('out of bounds release'));\n    }\n\n    return context;\n  }\n\n  function releaseContext() {\n\n    if (!context) {\n      throw new Error(translate('out of bounds release'));\n    }\n\n    var triggerUpdate = context.leave();\n\n    if (triggerUpdate) {\n      modeling.updateLaneRefs(context.flowNodes, context.lanes);\n\n      context = null;\n    }\n\n    return triggerUpdate;\n  }\n\n\n  var laneRefUpdateEvents = [\n    'spaceTool',\n    'lane.add',\n    'lane.resize',\n    'lane.split',\n    'elements.create',\n    'elements.delete',\n    'elements.move',\n    'shape.create',\n    'shape.delete',\n    'shape.move',\n    'shape.resize'\n  ];\n\n\n  // listen to a lot of stuff to group lane updates\n\n  this.preExecute(laneRefUpdateEvents, UpdateFlowNodeRefsBehavior_HIGH_PRIORITY, function(event) {\n    initContext();\n  });\n\n  this.postExecuted(laneRefUpdateEvents, UpdateFlowNodeRefsBehavior_LOW_PRIORITY, function(event) {\n    releaseContext();\n  });\n\n\n  // Mark flow nodes + lanes that need an update\n\n  this.preExecute([\n    'shape.create',\n    'shape.move',\n    'shape.delete',\n    'shape.resize'\n  ], function(event) {\n\n    var context = event.context,\n        shape = context.shape;\n\n    var updateContext = getContext();\n\n    // no need to update labels\n    if (shape.labelTarget) {\n      return;\n    }\n\n    if ((0,ModelUtil.is)(shape, 'bpmn:Lane')) {\n      updateContext.addLane(shape);\n    }\n\n    if ((0,ModelUtil.is)(shape, 'bpmn:FlowNode')) {\n      updateContext.addFlowNode(shape);\n    }\n  });\n}\n\nUpdateFlowNodeRefsBehavior.$inject = [\n  'eventBus',\n  'modeling' ,\n  'translate'\n];\n\n(0,index_es/* default */.Z)(UpdateFlowNodeRefsBehavior, CommandInterceptor/* default */.Z);\n\n\nfunction UpdateContext() {\n\n  this.flowNodes = [];\n  this.lanes = [];\n\n  this.counter = 0;\n\n  this.addLane = function(lane) {\n    this.lanes.push(lane);\n  };\n\n  this.addFlowNode = function(flowNode) {\n    this.flowNodes.push(flowNode);\n  };\n\n  this.enter = function() {\n    this.counter++;\n  };\n\n  this.leave = function() {\n    this.counter--;\n\n    return !this.counter;\n  };\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/behavior/index.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const modeling_behavior = ({\n  __init__: [\n    'adaptiveLabelPositioningBehavior',\n    'appendBehavior',\n    'associationBehavior',\n    'attachEventBehavior',\n    'boundaryEventBehavior',\n    'createBehavior',\n    'createDataObjectBehavior',\n    'createParticipantBehavior',\n    'dataInputAssociationBehavior',\n    'dataStoreBehavior',\n    'deleteLaneBehavior',\n    'detachEventBehavior',\n    'dropOnFlowBehavior',\n    'eventBasedGatewayBehavior',\n    'fixHoverBehavior',\n    'groupBehavior',\n    'importDockingFix',\n    'isHorizontalFix',\n    'labelBehavior',\n    'layoutConnectionBehavior',\n    'messageFlowBehavior',\n    'modelingFeedback',\n    'removeElementBehavior',\n    'removeEmbeddedLabelBoundsBehavior',\n    'removeParticipantBehavior',\n    'replaceConnectionBehavior',\n    'replaceElementBehaviour',\n    'resizeBehavior',\n    'resizeLaneBehavior',\n    'rootElementReferenceBehavior',\n    'spaceToolBehavior',\n    'subProcessPlaneBehavior',\n    'subProcessStartEventBehavior',\n    'toggleCollapseConnectionBehaviour',\n    'toggleElementCollapseBehaviour',\n    'unclaimIdBehavior',\n    'updateFlowNodeRefsBehavior',\n    'unsetDefaultFlowBehavior'\n  ],\n  adaptiveLabelPositioningBehavior: [ 'type', AdaptiveLabelPositioningBehavior ],\n  appendBehavior: [ 'type', AppendBehavior ],\n  associationBehavior: [ 'type', AssociationBehavior ],\n  attachEventBehavior: [ 'type', AttachEventBehavior ],\n  boundaryEventBehavior: [ 'type', BoundaryEventBehavior ],\n  createBehavior: [ 'type', CreateBehavior ],\n  createDataObjectBehavior: [ 'type', CreateDataObjectBehavior ],\n  createParticipantBehavior: [ 'type', CreateParticipantBehavior ],\n  dataInputAssociationBehavior: [ 'type', DataInputAssociationBehavior ],\n  dataStoreBehavior: [ 'type', DataStoreBehavior ],\n  deleteLaneBehavior: [ 'type', DeleteLaneBehavior ],\n  detachEventBehavior: [ 'type', DetachEventBehavior ],\n  dropOnFlowBehavior: [ 'type', DropOnFlowBehavior ],\n  eventBasedGatewayBehavior: [ 'type', EventBasedGatewayBehavior ],\n  fixHoverBehavior: [ 'type', FixHoverBehavior ],\n  groupBehavior: [ 'type', GroupBehavior ],\n  importDockingFix: [ 'type', ImportDockingFix ],\n  isHorizontalFix: [ 'type', IsHorizontalFix ],\n  labelBehavior: [ 'type', LabelBehavior ],\n  layoutConnectionBehavior: [ 'type', LayoutConnectionBehavior ],\n  messageFlowBehavior: [ 'type', MessageFlowBehavior ],\n  modelingFeedback: [ 'type', ModelingFeedback ],\n  removeElementBehavior: [ 'type', RemoveElementBehavior ],\n  removeEmbeddedLabelBoundsBehavior: [ 'type', RemoveEmbeddedLabelBoundsBehavior ],\n  removeParticipantBehavior: [ 'type', RemoveParticipantBehavior ],\n  replaceConnectionBehavior: [ 'type', ReplaceConnectionBehavior ],\n  replaceElementBehaviour: [ 'type', ReplaceElementBehaviour ],\n  resizeBehavior: [ 'type', ResizeBehavior ],\n  resizeLaneBehavior: [ 'type', ResizeLaneBehavior ],\n  rootElementReferenceBehavior: [ 'type', RootElementReferenceBehavior ],\n  spaceToolBehavior: [ 'type', SpaceToolBehavior ],\n  subProcessPlaneBehavior: [ 'type', SubProcessPlaneBehavior ],\n  subProcessStartEventBehavior: [ 'type', SubProcessStartEventBehavior ],\n  toggleCollapseConnectionBehaviour: [ 'type', ToggleCollapseConnectionBehaviour ],\n  toggleElementCollapseBehaviour : [ 'type', ToggleElementCollapseBehaviour ],\n  unclaimIdBehavior: [ 'type', UnclaimIdBehavior ],\n  unsetDefaultFlowBehavior: [ 'type', DeleteSequenceFlowBehavior ],\n  updateFlowNodeRefsBehavior: [ 'type', UpdateFlowNodeRefsBehavior ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/rules/index.js + 1 modules\nvar rules = __webpack_require__(\"./node_modules/diagram-js/lib/features/rules/index.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/snapping/BpmnSnappingUtil.js\n\r\n\r\nfunction getBoundaryAttachment(position, targetBounds) {\r\n\r\n  var orientation = (0,LayoutUtil/* getOrientation */.T8)(position, targetBounds, -15);\r\n\r\n  if (orientation !== 'intersect') {\r\n    return orientation;\r\n  } else {\r\n    return null;\r\n  }\r\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/rules/BpmnRules.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * BPMN specific modeling rule\n */\nfunction BpmnRules(eventBus) {\n  RuleProvider/* default.call */.Z.call(this, eventBus);\n}\n\n(0,index_es/* default */.Z)(BpmnRules, RuleProvider/* default */.Z);\n\nBpmnRules.$inject = [ 'eventBus' ];\n\nBpmnRules.prototype.init = function() {\n\n  this.addRule('connection.start', function(context) {\n    var source = context.source;\n\n    return canStartConnection(source);\n  });\n\n  this.addRule('connection.create', function(context) {\n    var source = context.source,\n        target = context.target,\n        hints = context.hints || {},\n        targetParent = hints.targetParent,\n        targetAttach = hints.targetAttach;\n\n    // don't allow incoming connections on\n    // newly created boundary events\n    // to boundary events\n    if (targetAttach) {\n      return false;\n    }\n\n    // temporarily set target parent for scoping\n    // checks to work\n    if (targetParent) {\n      target.parent = targetParent;\n    }\n\n    try {\n      return canConnect(source, target);\n    } finally {\n\n      // unset temporary target parent\n      if (targetParent) {\n        target.parent = null;\n      }\n    }\n  });\n\n  this.addRule('connection.reconnect', function(context) {\n\n    var connection = context.connection,\n        source = context.source,\n        target = context.target;\n\n    return canConnect(source, target, connection);\n  });\n\n  this.addRule('connection.updateWaypoints', function(context) {\n    return {\n      type: context.connection.type\n    };\n  });\n\n  this.addRule('shape.resize', function(context) {\n\n    var shape = context.shape,\n        newBounds = context.newBounds;\n\n    return canResize(shape, newBounds);\n  });\n\n  this.addRule('elements.create', function(context) {\n    var elements = context.elements,\n        position = context.position,\n        target = context.target;\n\n    if (BpmnRules_isConnection(target) && !canInsert(elements, target, position)) {\n      return false;\n    }\n\n    return (0,dist_index_esm/* every */.yW)(elements, function(element) {\n      if (BpmnRules_isConnection(element)) {\n        return canConnect(element.source, element.target, element);\n      }\n\n      if (element.host) {\n        return canAttach(element, element.host, null, position);\n      }\n\n      return canCreate(element, target, null, position);\n    });\n  });\n\n  this.addRule('elements.move', function(context) {\n\n    var target = context.target,\n        shapes = context.shapes,\n        position = context.position;\n\n    return canAttach(shapes, target, null, position) ||\n           canReplace(shapes, target, position) ||\n           canMove(shapes, target, position) ||\n           canInsert(shapes, target, position);\n  });\n\n  this.addRule('shape.create', function(context) {\n    return canCreate(\n      context.shape,\n      context.target,\n      context.source,\n      context.position\n    );\n  });\n\n  this.addRule('shape.attach', function(context) {\n\n    return canAttach(\n      context.shape,\n      context.target,\n      null,\n      context.position\n    );\n  });\n\n  this.addRule('element.copy', function(context) {\n    var element = context.element,\n        elements = context.elements;\n\n    return canCopy(elements, element);\n  });\n};\n\nBpmnRules.prototype.canConnectMessageFlow = canConnectMessageFlow;\n\nBpmnRules.prototype.canConnectSequenceFlow = canConnectSequenceFlow;\n\nBpmnRules.prototype.canConnectDataAssociation = canConnectDataAssociation;\n\nBpmnRules.prototype.canConnectAssociation = canConnectAssociation;\n\nBpmnRules.prototype.canMove = canMove;\n\nBpmnRules.prototype.canAttach = canAttach;\n\nBpmnRules.prototype.canReplace = canReplace;\n\nBpmnRules.prototype.canDrop = canDrop;\n\nBpmnRules.prototype.canInsert = canInsert;\n\nBpmnRules.prototype.canCreate = canCreate;\n\nBpmnRules.prototype.canConnect = canConnect;\n\nBpmnRules.prototype.canResize = canResize;\n\nBpmnRules.prototype.canCopy = canCopy;\n\n/**\n * Utility functions for rule checking\n */\n\n/**\n * Checks if given element can be used for starting connection.\n *\n * @param  {Element} source\n * @return {boolean}\n */\nfunction canStartConnection(element) {\n  if (nonExistingOrLabel(element)) {\n    return null;\n  }\n\n  return (0,ModelUtil/* isAny */.JZ)(element, [\n    'bpmn:FlowNode',\n    'bpmn:InteractionNode',\n    'bpmn:DataObjectReference',\n    'bpmn:DataStoreReference',\n    'bpmn:Group',\n    'bpmn:TextAnnotation'\n  ]);\n}\n\nfunction nonExistingOrLabel(element) {\n  return !element || (0,util_LabelUtil/* isLabel */.j_)(element);\n}\n\nfunction isSame(a, b) {\n  return a === b;\n}\n\nfunction getOrganizationalParent(element) {\n\n  do {\n    if ((0,ModelUtil.is)(element, 'bpmn:Process')) {\n      return (0,ModelUtil/* getBusinessObject */.SS)(element);\n    }\n\n    if ((0,ModelUtil.is)(element, 'bpmn:Participant')) {\n      return (\n        (0,ModelUtil/* getBusinessObject */.SS)(element).processRef ||\n        (0,ModelUtil/* getBusinessObject */.SS)(element)\n      );\n    }\n  } while ((element = element.parent));\n\n}\n\nfunction isTextAnnotation(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:TextAnnotation');\n}\n\nfunction isGroup(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Group') && !element.labelTarget;\n}\n\nfunction isCompensationBoundary(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') &&\n         BpmnRules_hasEventDefinition(element, 'bpmn:CompensateEventDefinition');\n}\n\nfunction isForCompensation(e) {\n  return (0,ModelUtil/* getBusinessObject */.SS)(e).isForCompensation;\n}\n\nfunction isSameOrganization(a, b) {\n  var parentA = getOrganizationalParent(a),\n      parentB = getOrganizationalParent(b);\n\n  return parentA === parentB;\n}\n\nfunction isMessageFlowSource(element) {\n  return (\n    (0,ModelUtil.is)(element, 'bpmn:InteractionNode') &&\n    !(0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') && (\n      !(0,ModelUtil.is)(element, 'bpmn:Event') || (\n        (0,ModelUtil.is)(element, 'bpmn:ThrowEvent') &&\n        hasEventDefinitionOrNone(element, 'bpmn:MessageEventDefinition')\n      )\n    )\n  );\n}\n\nfunction isMessageFlowTarget(element) {\n  return (\n    (0,ModelUtil.is)(element, 'bpmn:InteractionNode') &&\n    !isForCompensation(element) && (\n      !(0,ModelUtil.is)(element, 'bpmn:Event') || (\n        (0,ModelUtil.is)(element, 'bpmn:CatchEvent') &&\n        hasEventDefinitionOrNone(element, 'bpmn:MessageEventDefinition')\n      )\n    ) && !(\n      (0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') &&\n      !BpmnRules_hasEventDefinition(element, 'bpmn:MessageEventDefinition')\n    )\n  );\n}\n\nfunction getScopeParent(element) {\n\n  var parent = element;\n\n  while ((parent = parent.parent)) {\n\n    if ((0,ModelUtil.is)(parent, 'bpmn:FlowElementsContainer')) {\n      return (0,ModelUtil/* getBusinessObject */.SS)(parent);\n    }\n\n    if ((0,ModelUtil.is)(parent, 'bpmn:Participant')) {\n      return (0,ModelUtil/* getBusinessObject */.SS)(parent).processRef;\n    }\n  }\n\n  return null;\n}\n\nfunction isSameScope(a, b) {\n  var scopeParentA = getScopeParent(a),\n      scopeParentB = getScopeParent(b);\n\n  return scopeParentA === scopeParentB;\n}\n\nfunction BpmnRules_hasEventDefinition(element, eventDefinition) {\n  var bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n  return !!(0,dist_index_esm/* find */.sE)(bo.eventDefinitions || [], function(definition) {\n    return (0,ModelUtil.is)(definition, eventDefinition);\n  });\n}\n\nfunction hasEventDefinitionOrNone(element, eventDefinition) {\n  var bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n  return (bo.eventDefinitions || []).every(function(definition) {\n    return (0,ModelUtil.is)(definition, eventDefinition);\n  });\n}\n\nfunction isSequenceFlowSource(element) {\n  return (\n    (0,ModelUtil.is)(element, 'bpmn:FlowNode') &&\n    !(0,ModelUtil.is)(element, 'bpmn:EndEvent') &&\n    !(0,DiUtil/* isEventSubProcess */.J5)(element) &&\n    !((0,ModelUtil.is)(element, 'bpmn:IntermediateThrowEvent') &&\n      BpmnRules_hasEventDefinition(element, 'bpmn:LinkEventDefinition')\n    ) &&\n    !isCompensationBoundary(element) &&\n    !isForCompensation(element)\n  );\n}\n\nfunction isSequenceFlowTarget(element) {\n  return (\n    (0,ModelUtil.is)(element, 'bpmn:FlowNode') &&\n    !(0,ModelUtil.is)(element, 'bpmn:StartEvent') &&\n    !(0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') &&\n    !(0,DiUtil/* isEventSubProcess */.J5)(element) &&\n    !((0,ModelUtil.is)(element, 'bpmn:IntermediateCatchEvent') &&\n      BpmnRules_hasEventDefinition(element, 'bpmn:LinkEventDefinition')\n    ) &&\n    !isForCompensation(element)\n  );\n}\n\nfunction isEventBasedTarget(element) {\n  return (\n    (0,ModelUtil.is)(element, 'bpmn:ReceiveTask') || (\n      (0,ModelUtil.is)(element, 'bpmn:IntermediateCatchEvent') && (\n        BpmnRules_hasEventDefinition(element, 'bpmn:MessageEventDefinition') ||\n        BpmnRules_hasEventDefinition(element, 'bpmn:TimerEventDefinition') ||\n        BpmnRules_hasEventDefinition(element, 'bpmn:ConditionalEventDefinition') ||\n        BpmnRules_hasEventDefinition(element, 'bpmn:SignalEventDefinition')\n      )\n    )\n  );\n}\n\nfunction BpmnRules_isConnection(element) {\n  return element.waypoints;\n}\n\nfunction getParents(element) {\n\n  var parents = [];\n\n  while (element) {\n    element = element.parent;\n\n    if (element) {\n      parents.push(element);\n    }\n  }\n\n  return parents;\n}\n\nfunction isParent(possibleParent, element) {\n  var allParents = getParents(element);\n  return allParents.indexOf(possibleParent) !== -1;\n}\n\nfunction canConnect(source, target, connection) {\n\n  if (nonExistingOrLabel(source) || nonExistingOrLabel(target)) {\n    return null;\n  }\n\n  if (!(0,ModelUtil.is)(connection, 'bpmn:DataAssociation')) {\n\n    if (canConnectMessageFlow(source, target)) {\n      return { type: 'bpmn:MessageFlow' };\n    }\n\n    if (canConnectSequenceFlow(source, target)) {\n      return { type: 'bpmn:SequenceFlow' };\n    }\n  }\n\n  var connectDataAssociation = canConnectDataAssociation(source, target);\n\n  if (connectDataAssociation) {\n    return connectDataAssociation;\n  }\n\n  if (isCompensationBoundary(source) && isForCompensation(target)) {\n    return {\n      type: 'bpmn:Association',\n      associationDirection: 'One'\n    };\n  }\n\n  if (canConnectAssociation(source, target)) {\n\n    return {\n      type: 'bpmn:Association'\n    };\n  }\n\n  return false;\n}\n\n/**\n * Can an element be dropped into the target element\n *\n * @return {boolean}\n */\nfunction canDrop(element, target, position) {\n\n  // can move labels and groups everywhere\n  if ((0,util_LabelUtil/* isLabel */.j_)(element) || isGroup(element)) {\n    return true;\n  }\n\n\n  // disallow to create elements on collapsed pools\n  if ((0,ModelUtil.is)(target, 'bpmn:Participant') && !(0,DiUtil/* isExpanded */.ul)(target)) {\n    return false;\n  }\n\n  // allow to create new participants on\n  // existing collaboration and process diagrams\n  if ((0,ModelUtil.is)(element, 'bpmn:Participant')) {\n    return (0,ModelUtil.is)(target, 'bpmn:Process') || (0,ModelUtil.is)(target, 'bpmn:Collaboration');\n  }\n\n  // allow moving DataInput / DataOutput within its original container only\n  if ((0,ModelUtil/* isAny */.JZ)(element, [ 'bpmn:DataInput', 'bpmn:DataOutput' ])) {\n\n    if (element.parent) {\n      return target === element.parent;\n    }\n  }\n\n  // allow creating lanes on participants and other lanes only\n  if ((0,ModelUtil.is)(element, 'bpmn:Lane')) {\n    return (0,ModelUtil.is)(target, 'bpmn:Participant') || (0,ModelUtil.is)(target, 'bpmn:Lane');\n  }\n\n  // disallow dropping boundary events which cannot replace with intermediate event\n  if ((0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') && !isDroppableBoundaryEvent(element)) {\n    return false;\n  }\n\n  // drop flow elements onto flow element containers\n  // and participants\n  if ((0,ModelUtil.is)(element, 'bpmn:FlowElement') && !(0,ModelUtil.is)(element, 'bpmn:DataStoreReference')) {\n    if ((0,ModelUtil.is)(target, 'bpmn:FlowElementsContainer')) {\n      return (0,DiUtil/* isExpanded */.ul)(target);\n    }\n\n    return (0,ModelUtil/* isAny */.JZ)(target, [ 'bpmn:Participant', 'bpmn:Lane' ]);\n  }\n\n  // disallow dropping data store reference if there is no process to append to\n  if ((0,ModelUtil.is)(element, 'bpmn:DataStoreReference') && (0,ModelUtil.is)(target, 'bpmn:Collaboration')) {\n    return (0,dist_index_esm/* some */.G)((0,ModelUtil/* getBusinessObject */.SS)(target).get('participants'), function(participant) {\n      return !!participant.get('processRef');\n    });\n  }\n\n  // account for the fact that data associations are always\n  // rendered and moved to top (Process or Collaboration level)\n  //\n  // artifacts may be placed wherever, too\n  if ((0,ModelUtil/* isAny */.JZ)(element, [ 'bpmn:Artifact', 'bpmn:DataAssociation', 'bpmn:DataStoreReference' ])) {\n    return (0,ModelUtil/* isAny */.JZ)(target, [\n      'bpmn:Collaboration',\n      'bpmn:Lane',\n      'bpmn:Participant',\n      'bpmn:Process',\n      'bpmn:SubProcess' ]);\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:MessageFlow')) {\n    return (0,ModelUtil.is)(target, 'bpmn:Collaboration')\n      || element.source.parent == target\n      || element.target.parent == target;\n  }\n\n  return false;\n}\n\nfunction isDroppableBoundaryEvent(event) {\n  return (0,ModelUtil/* getBusinessObject */.SS)(event).cancelActivity && (\n    hasNoEventDefinition(event) || hasCommonBoundaryIntermediateEventDefinition(event)\n  );\n}\n\nfunction isBoundaryEvent(element) {\n  return !(0,util_LabelUtil/* isLabel */.j_)(element) && (0,ModelUtil.is)(element, 'bpmn:BoundaryEvent');\n}\n\nfunction isLane(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:Lane');\n}\n\n/**\n * We treat IntermediateThrowEvents as boundary events during create,\n * this must be reflected in the rules.\n */\nfunction isBoundaryCandidate(element) {\n  if (isBoundaryEvent(element)) {\n    return true;\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:IntermediateThrowEvent') && hasNoEventDefinition(element)) {\n    return true;\n  }\n\n  return (\n    (0,ModelUtil.is)(element, 'bpmn:IntermediateCatchEvent') &&\n    hasCommonBoundaryIntermediateEventDefinition(element)\n  );\n}\n\nfunction hasNoEventDefinition(element) {\n  var bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n\n  return bo && !(bo.eventDefinitions && bo.eventDefinitions.length);\n}\n\nfunction hasCommonBoundaryIntermediateEventDefinition(element) {\n  return hasOneOfEventDefinitions(element, [\n    'bpmn:MessageEventDefinition',\n    'bpmn:TimerEventDefinition',\n    'bpmn:SignalEventDefinition',\n    'bpmn:ConditionalEventDefinition'\n  ]);\n}\n\nfunction hasOneOfEventDefinitions(element, eventDefinitions) {\n  return eventDefinitions.some(function(definition) {\n    return BpmnRules_hasEventDefinition(element, definition);\n  });\n}\n\nfunction isReceiveTaskAfterEventBasedGateway(element) {\n  return (\n    (0,ModelUtil.is)(element, 'bpmn:ReceiveTask') &&\n    (0,dist_index_esm/* find */.sE)(element.incoming, function(incoming) {\n      return (0,ModelUtil.is)(incoming.source, 'bpmn:EventBasedGateway');\n    })\n  );\n}\n\n\nfunction canAttach(elements, target, source, position) {\n\n  if (!Array.isArray(elements)) {\n    elements = [ elements ];\n  }\n\n  // only (re-)attach one element at a time\n  if (elements.length !== 1) {\n    return false;\n  }\n\n  var element = elements[0];\n\n  // do not attach labels\n  if ((0,util_LabelUtil/* isLabel */.j_)(element)) {\n    return false;\n  }\n\n  // only handle boundary events\n  if (!isBoundaryCandidate(element)) {\n    return false;\n  }\n\n  // disallow drop on event sub processes\n  if ((0,DiUtil/* isEventSubProcess */.J5)(target)) {\n    return false;\n  }\n\n  // only allow drop on non compensation activities\n  if (!(0,ModelUtil.is)(target, 'bpmn:Activity') || isForCompensation(target)) {\n    return false;\n  }\n\n  // only attach to subprocess border\n  if (position && !getBoundaryAttachment(position, target)) {\n    return false;\n  }\n\n  // do not attach on receive tasks after event based gateways\n  if (isReceiveTaskAfterEventBasedGateway(target)) {\n    return false;\n  }\n\n  return 'attach';\n}\n\n\n/**\n * Defines how to replace elements for a given target.\n *\n * Returns an array containing all elements which will be replaced.\n *\n * @example\n *\n *  [{ id: 'IntermediateEvent_2',\n *     type: 'bpmn:StartEvent'\n *   },\n *   { id: 'IntermediateEvent_5',\n *     type: 'bpmn:EndEvent'\n *   }]\n *\n * @param  {Array} elements\n * @param  {Object} target\n *\n * @return {Object} an object containing all elements which have to be replaced\n */\nfunction canReplace(elements, target, position) {\n\n  if (!target) {\n    return false;\n  }\n\n  var canExecute = {\n    replacements: []\n  };\n\n  (0,dist_index_esm/* forEach */.Ed)(elements, function(element) {\n\n    if (!(0,DiUtil/* isEventSubProcess */.J5)(target)) {\n\n      if ((0,ModelUtil.is)(element, 'bpmn:StartEvent') &&\n          element.type !== 'label' &&\n          canDrop(element, target)) {\n\n        // replace a non-interrupting start event by a blank interrupting start event\n        // when the target is not an event sub process\n        if (!(0,DiUtil/* isInterrupting */.yU)(element)) {\n          canExecute.replacements.push({\n            oldElementId: element.id,\n            newElementType: 'bpmn:StartEvent'\n          });\n        }\n\n        // replace an error/escalation/compensate start event by a blank interrupting start event\n        // when the target is not an event sub process\n        if ((0,DiUtil/* hasErrorEventDefinition */.sm)(element) ||\n            (0,DiUtil/* hasEscalationEventDefinition */.wQ)(element) ||\n            (0,DiUtil/* hasCompensateEventDefinition */._Z)(element)) {\n          canExecute.replacements.push({\n            oldElementId: element.id,\n            newElementType: 'bpmn:StartEvent'\n          });\n        }\n\n        // replace a typed start event by a blank interrupting start event\n        // when the target is a sub process but not an event sub process\n        if (hasOneOfEventDefinitions(element,\n          [\n            'bpmn:MessageEventDefinition',\n            'bpmn:TimerEventDefinition',\n            'bpmn:SignalEventDefinition',\n            'bpmn:ConditionalEventDefinition'\n          ]) &&\n            (0,ModelUtil.is)(target, 'bpmn:SubProcess')) {\n          canExecute.replacements.push({\n            oldElementId: element.id,\n            newElementType: 'bpmn:StartEvent'\n          });\n        }\n      }\n    }\n\n    if (!(0,ModelUtil.is)(target, 'bpmn:Transaction')) {\n      if (BpmnRules_hasEventDefinition(element, 'bpmn:CancelEventDefinition') &&\n          element.type !== 'label') {\n\n        if ((0,ModelUtil.is)(element, 'bpmn:EndEvent') && canDrop(element, target)) {\n          canExecute.replacements.push({\n            oldElementId: element.id,\n            newElementType: 'bpmn:EndEvent'\n          });\n        }\n\n        if ((0,ModelUtil.is)(element, 'bpmn:BoundaryEvent') && canAttach(element, target, null, position)) {\n          canExecute.replacements.push({\n            oldElementId: element.id,\n            newElementType: 'bpmn:BoundaryEvent'\n          });\n        }\n      }\n    }\n  });\n\n  return canExecute.replacements.length ? canExecute : false;\n}\n\nfunction canMove(elements, target) {\n\n  // do not move selection containing lanes\n  if ((0,dist_index_esm/* some */.G)(elements, isLane)) {\n    return false;\n  }\n\n  // allow default move check to start move operation\n  if (!target) {\n    return true;\n  }\n\n  return elements.every(function(element) {\n    return canDrop(element, target);\n  });\n}\n\nfunction canCreate(shape, target, source, position) {\n\n  if (!target) {\n    return false;\n  }\n\n  if ((0,util_LabelUtil/* isLabel */.j_)(shape) || isGroup(shape)) {\n    return true;\n  }\n\n  if (isSame(source, target)) {\n    return false;\n  }\n\n  // ensure we do not drop the element\n  // into source\n  if (source && isParent(source, target)) {\n    return false;\n  }\n\n  return canDrop(shape, target, position) || canInsert(shape, target, position);\n}\n\nfunction canResize(shape, newBounds) {\n  if ((0,ModelUtil.is)(shape, 'bpmn:SubProcess')) {\n    return (\n      (0,DiUtil/* isExpanded */.ul)(shape) && (\n        !newBounds || (newBounds.width >= 100 && newBounds.height >= 80)\n      )\n    );\n  }\n\n  if ((0,ModelUtil.is)(shape, 'bpmn:Lane')) {\n    return !newBounds || (newBounds.width >= 130 && newBounds.height >= 60);\n  }\n\n  if ((0,ModelUtil.is)(shape, 'bpmn:Participant')) {\n    return !newBounds || (newBounds.width >= 250 && newBounds.height >= 50);\n  }\n\n  if (isTextAnnotation(shape)) {\n    return true;\n  }\n\n  if (isGroup(shape)) {\n    return true;\n  }\n\n  return false;\n}\n\n/**\n * Check, whether one side of the relationship\n * is a text annotation.\n */\nfunction isOneTextAnnotation(source, target) {\n\n  var sourceTextAnnotation = isTextAnnotation(source),\n      targetTextAnnotation = isTextAnnotation(target);\n\n  return (\n    (sourceTextAnnotation || targetTextAnnotation) &&\n    (sourceTextAnnotation !== targetTextAnnotation)\n  );\n}\n\n\nfunction canConnectAssociation(source, target) {\n\n  // compensation boundary events are exception\n  if (isCompensationBoundary(source) && isForCompensation(target)) {\n    return true;\n  }\n\n  // don't connect parent <-> child\n  if (isParent(target, source) || isParent(source, target)) {\n    return false;\n  }\n\n  // allow connection of associations between <!TextAnnotation> and <TextAnnotation>\n  if (isOneTextAnnotation(source, target)) {\n    return true;\n  }\n\n  // can connect associations where we can connect\n  // data associations, too (!)\n  return !!canConnectDataAssociation(source, target);\n}\n\nfunction canConnectMessageFlow(source, target) {\n\n  // during connect user might move mouse out of canvas\n  // https://github.com/bpmn-io/bpmn-js/issues/1033\n  if (getRootElement(source) && !getRootElement(target)) {\n    return false;\n  }\n\n  return (\n    isMessageFlowSource(source) &&\n    isMessageFlowTarget(target) &&\n    !isSameOrganization(source, target)\n  );\n}\n\nfunction canConnectSequenceFlow(source, target) {\n  return isSequenceFlowSource(source) &&\n         isSequenceFlowTarget(target) &&\n         isSameScope(source, target) &&\n         !((0,ModelUtil.is)(source, 'bpmn:EventBasedGateway') && !isEventBasedTarget(target));\n}\n\n\nfunction canConnectDataAssociation(source, target) {\n\n  if ((0,ModelUtil/* isAny */.JZ)(source, [ 'bpmn:DataObjectReference', 'bpmn:DataStoreReference' ]) &&\n      (0,ModelUtil/* isAny */.JZ)(target, [ 'bpmn:Activity', 'bpmn:ThrowEvent' ])) {\n    return { type: 'bpmn:DataInputAssociation' };\n  }\n\n  if ((0,ModelUtil/* isAny */.JZ)(target, [ 'bpmn:DataObjectReference', 'bpmn:DataStoreReference' ]) &&\n      (0,ModelUtil/* isAny */.JZ)(source, [ 'bpmn:Activity', 'bpmn:CatchEvent' ])) {\n    return { type: 'bpmn:DataOutputAssociation' };\n  }\n\n  return false;\n}\n\nfunction canInsert(shape, flow, position) {\n\n  if (!flow) {\n    return false;\n  }\n\n  if (Array.isArray(shape)) {\n    if (shape.length !== 1) {\n      return false;\n    }\n\n    shape = shape[0];\n  }\n\n  if (flow.source === shape ||\n      flow.target === shape) {\n    return false;\n  }\n\n  // return true if we can drop on the\n  // underlying flow parent\n  //\n  // at this point we are not really able to talk\n  // about connection rules (yet)\n\n  return (\n    (0,ModelUtil/* isAny */.JZ)(flow, [ 'bpmn:SequenceFlow', 'bpmn:MessageFlow' ]) &&\n    !(0,util_LabelUtil/* isLabel */.j_)(flow) &&\n    (0,ModelUtil.is)(shape, 'bpmn:FlowNode') &&\n    !(0,ModelUtil.is)(shape, 'bpmn:BoundaryEvent') &&\n    canDrop(shape, flow.parent, position));\n}\n\nfunction BpmnRules_includes(elements, element) {\n  return (elements && element) && elements.indexOf(element) !== -1;\n}\n\nfunction canCopy(elements, element) {\n  if ((0,util_LabelUtil/* isLabel */.j_)(element)) {\n    return true;\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:Lane') && !BpmnRules_includes(elements, element.parent)) {\n    return false;\n  }\n\n  return true;\n}\n\nfunction getRootElement(element) {\n  return (0,ModelingUtil/* getParent */.G)(element, 'bpmn:Process') || (0,ModelingUtil/* getParent */.G)(element, 'bpmn:Collaboration');\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/rules/index.js\n\n\n\n\n/* harmony default export */ const features_rules = ({\n  __depends__: [\n    rules/* default */.Z\n  ],\n  __init__: [ 'bpmnRules' ],\n  bpmnRules: [ 'type', BpmnRules ]\n});\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/di-ordering/BpmnDiOrdering.js\n\n\n\n\n\n\n\nvar BpmnDiOrdering_HIGH_PRIORITY = 2000;\n\nfunction BpmnDiOrdering(eventBus, canvas) {\n\n  eventBus.on('saveXML.start', BpmnDiOrdering_HIGH_PRIORITY, orderDi);\n\n  function orderDi() {\n    var rootElements = canvas.getRootElements();\n\n    (0,dist_index_esm/* forEach */.Ed)(rootElements, function(root) {\n      var rootDi = (0,ModelUtil/* getDi */.DN)(root),\n          elements,\n          diElements;\n\n      elements = (0,Elements/* selfAndAllChildren */.PB)([ root ], false);\n\n      // only bpmndi:Shape and bpmndi:Edge can be direct children of bpmndi:Plane\n      elements = (0,dist_index_esm/* filter */.hX)(elements, function(element) {\n        return element !== root && !element.labelTarget;\n      });\n\n      diElements = (0,dist_index_esm/* map */.UI)(elements, ModelUtil/* getDi */.DN);\n\n      rootDi.set('planeElement', diElements);\n    });\n  }\n}\n\nBpmnDiOrdering.$inject = [ 'eventBus', 'canvas' ];\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/di-ordering/index.js\n\n\n/* harmony default export */ const di_ordering = ({\n  __init__: [\n    'bpmnDiOrdering'\n  ],\n  bpmnDiOrdering: [ 'type', BpmnDiOrdering ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/i18n/translate/index.js + 1 modules\nvar translate = __webpack_require__(\"./node_modules/diagram-js/lib/i18n/translate/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/ordering/OrderingProvider.js\nvar OrderingProvider = __webpack_require__(\"./node_modules/diagram-js/lib/features/ordering/OrderingProvider.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/ordering/BpmnOrderingProvider.js\n\n\n\n\n\n\n\n\n\n/**\n * a simple ordering provider that makes sure:\n *\n * (0) labels and groups are rendered always on top\n * (1) elements are ordered by a {level} property\n */\nfunction BpmnOrderingProvider(eventBus, canvas, translate) {\n\n  OrderingProvider/* default.call */.Z.call(this, eventBus);\n\n  var orders = [\n    { type: 'bpmn:SubProcess', order: { level: 6 } },\n\n    // handle SequenceFlow(s) like message flows and render them always on top\n    {\n      type: 'bpmn:SequenceFlow',\n      order: {\n        level: 9,\n        containers: [\n          'bpmn:Participant',\n          'bpmn:FlowElementsContainer'\n        ]\n      }\n    },\n\n    // handle DataAssociation(s) like message flows and render them always on top\n    {\n      type: 'bpmn:DataAssociation',\n      order: {\n        level: 9,\n        containers: [\n          'bpmn:Collaboration',\n          'bpmn:FlowElementsContainer'\n        ]\n      }\n    },\n    {\n      type: 'bpmn:MessageFlow', order: {\n        level: 9,\n        containers: [ 'bpmn:Collaboration' ]\n      }\n    },\n    {\n      type: 'bpmn:Association',\n      order: {\n        level: 6,\n        containers: [\n          'bpmn:Participant',\n          'bpmn:FlowElementsContainer',\n          'bpmn:Collaboration'\n        ]\n      }\n    },\n    { type: 'bpmn:BoundaryEvent', order: { level: 8 } },\n    {\n      type: 'bpmn:Group',\n      order: {\n        level: 10,\n        containers: [\n          'bpmn:Collaboration',\n          'bpmn:FlowElementsContainer'\n        ]\n      }\n    },\n    { type: 'bpmn:FlowElement', order: { level: 5 } },\n    { type: 'bpmn:Participant', order: { level: -2 } },\n    { type: 'bpmn:Lane', order: { level: -1 } }\n  ];\n\n  function computeOrder(element) {\n    if (element.labelTarget) {\n      return { level: 10 };\n    }\n\n    var entry = (0,dist_index_esm/* find */.sE)(orders, function(o) {\n      return (0,ModelUtil/* isAny */.JZ)(element, [ o.type ]);\n    });\n\n    return entry && entry.order || { level: 1 };\n  }\n\n  function getOrder(element) {\n\n    var order = element.order;\n\n    if (!order) {\n      element.order = order = computeOrder(element);\n    }\n\n    if (!order) {\n      throw new Error('no order for <' + element.id + '>');\n    }\n\n    return order;\n  }\n\n  function findActualParent(element, newParent, containers) {\n\n    var actualParent = newParent;\n\n    while (actualParent) {\n\n      if ((0,ModelUtil/* isAny */.JZ)(actualParent, containers)) {\n        break;\n      }\n\n      actualParent = actualParent.parent;\n    }\n\n    if (!actualParent) {\n      throw new Error('no parent for <' + element.id + '> in <' + (newParent && newParent.id) + '>');\n    }\n\n    return actualParent;\n  }\n\n  this.getOrdering = function(element, newParent) {\n\n    // render labels always on top\n    if (element.labelTarget) {\n      return {\n        parent: canvas.findRoot(newParent) || canvas.getRootElement(),\n        index: -1\n      };\n    }\n\n    var elementOrder = getOrder(element);\n\n    if (elementOrder.containers) {\n      newParent = findActualParent(element, newParent, elementOrder.containers);\n    }\n\n    var currentIndex = newParent.children.indexOf(element);\n\n    var insertIndex = (0,dist_index_esm/* findIndex */.cx)(newParent.children, function(child) {\n\n      // do not compare with labels, they are created\n      // in the wrong order (right after elements) during import and\n      // mess up the positioning.\n      if (!element.labelTarget && child.labelTarget) {\n        return false;\n      }\n\n      return elementOrder.level < getOrder(child).level;\n    });\n\n\n    // if the element is already in the child list at\n    // a smaller index, we need to adjust the insert index.\n    // this takes into account that the element is being removed\n    // before being re-inserted\n    if (insertIndex !== -1) {\n      if (currentIndex !== -1 && currentIndex < insertIndex) {\n        insertIndex -= 1;\n      }\n    }\n\n    return {\n      index: insertIndex,\n      parent: newParent\n    };\n  };\n}\n\nBpmnOrderingProvider.$inject = [ 'eventBus', 'canvas', 'translate' ];\n\n(0,index_es/* default */.Z)(BpmnOrderingProvider, OrderingProvider/* default */.Z);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/ordering/index.js\n\n\n\n\n/* harmony default export */ const ordering = ({\n  __depends__: [\n    translate/* default */.Z\n  ],\n  __init__: [ 'bpmnOrderingProvider' ],\n  bpmnOrderingProvider: [ 'type', BpmnOrderingProvider ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/space-tool/index.js + 1 modules\nvar space_tool = __webpack_require__(\"./node_modules/diagram-js/lib/features/space-tool/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/space-tool/SpaceTool.js\nvar SpaceTool = __webpack_require__(\"./node_modules/diagram-js/lib/features/space-tool/SpaceTool.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/space-tool/BpmnSpaceTool.js\n\n\n\n\n\n\n\nfunction BpmnSpaceTool(injector) {\n  injector.invoke(SpaceTool/* default */.Z, this);\n}\n\nBpmnSpaceTool.$inject = [\n  'injector'\n];\n\n(0,index_es/* default */.Z)(BpmnSpaceTool, SpaceTool/* default */.Z);\n\nBpmnSpaceTool.prototype.calculateAdjustments = function(elements, axis, delta, start) {\n  var adjustments = SpaceTool/* default.prototype.calculateAdjustments.call */.Z.prototype.calculateAdjustments.call(this, elements, axis, delta, start);\n\n  // do not resize text annotations\n  adjustments.resizingShapes = adjustments.resizingShapes.filter(function(shape) {\n    return !(0,ModelUtil.is)(shape, 'bpmn:TextAnnotation');\n  });\n\n  return adjustments;\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/space-tool/index.js\n\n\n\n\n/* harmony default export */ const features_space_tool = ({\n  __depends__: [ space_tool/* default */.Z ],\n  spaceTool: [ 'type', BpmnSpaceTool ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/index.js + 1 modules\nvar command = __webpack_require__(\"./node_modules/diagram-js/lib/command/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/tooltips/index.js + 1 modules\nvar tooltips = __webpack_require__(\"./node_modules/diagram-js/lib/features/tooltips/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/label-support/index.js + 1 modules\nvar label_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/label-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/attach-support/index.js + 1 modules\nvar attach_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/attach-support/index.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/BpmnFactory.js\n\n\n\n\n\n\n\nfunction BpmnFactory(moddle) {\n  this._model = moddle;\n}\n\nBpmnFactory.$inject = [ 'moddle' ];\n\n\nBpmnFactory.prototype._needsId = function(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, [\n    'bpmn:RootElement',\n    'bpmn:FlowElement',\n    'bpmn:MessageFlow',\n    'bpmn:DataAssociation',\n    'bpmn:Artifact',\n    'bpmn:Participant',\n    'bpmn:Lane',\n    'bpmn:LaneSet',\n    'bpmn:Process',\n    'bpmn:Collaboration',\n    'bpmndi:BPMNShape',\n    'bpmndi:BPMNEdge',\n    'bpmndi:BPMNDiagram',\n    'bpmndi:BPMNPlane',\n    'bpmn:Property',\n    'bpmn:CategoryValue'\n  ]);\n};\n\nBpmnFactory.prototype._ensureId = function(element) {\n  if (element.id) {\n    this._model.ids.claim(element.id, element);\n    return;\n  }\n\n  // generate semantic ids for elements\n  // bpmn:SequenceFlow -> SequenceFlow_ID\n  var prefix;\n\n  if ((0,ModelUtil.is)(element, 'bpmn:Activity')) {\n    prefix = 'Activity';\n  } else if ((0,ModelUtil.is)(element, 'bpmn:Event')) {\n    prefix = 'Event';\n  } else if ((0,ModelUtil.is)(element, 'bpmn:Gateway')) {\n    prefix = 'Gateway';\n  } else if ((0,ModelUtil/* isAny */.JZ)(element, [ 'bpmn:SequenceFlow', 'bpmn:MessageFlow' ])) {\n    prefix = 'Flow';\n  } else {\n    prefix = (element.$type || '').replace(/^[^:]*:/g, '');\n  }\n\n  prefix += '_';\n\n  if (!element.id && this._needsId(element)) {\n    element.id = this._model.ids.nextPrefixed(prefix, element);\n  }\n};\n\n\nBpmnFactory.prototype.create = function(type, attrs) {\n  var element = this._model.create(type, attrs || {});\n\n  this._ensureId(element);\n\n  return element;\n};\n\n\nBpmnFactory.prototype.createDiLabel = function() {\n  return this.create('bpmndi:BPMNLabel', {\n    bounds: this.createDiBounds()\n  });\n};\n\n\nBpmnFactory.prototype.createDiShape = function(semantic, attrs) {\n  return this.create('bpmndi:BPMNShape', (0,dist_index_esm/* assign */.f0)({\n    bpmnElement: semantic,\n    bounds: this.createDiBounds()\n  }, attrs));\n};\n\n\nBpmnFactory.prototype.createDiBounds = function(bounds) {\n  return this.create('dc:Bounds', bounds);\n};\n\n\nBpmnFactory.prototype.createDiWaypoints = function(waypoints) {\n  var self = this;\n\n  return (0,dist_index_esm/* map */.UI)(waypoints, function(pos) {\n    return self.createDiWaypoint(pos);\n  });\n};\n\nBpmnFactory.prototype.createDiWaypoint = function(point) {\n  return this.create('dc:Point', (0,dist_index_esm/* pick */.ei)(point, [ 'x', 'y' ]));\n};\n\n\nBpmnFactory.prototype.createDiEdge = function(semantic, attrs) {\n  return this.create('bpmndi:BPMNEdge', (0,dist_index_esm/* assign */.f0)({\n    bpmnElement: semantic,\n    waypoint: this.createDiWaypoints([])\n  }, attrs));\n};\n\nBpmnFactory.prototype.createDiPlane = function(semantic, attrs) {\n  return this.create('bpmndi:BPMNPlane', (0,dist_index_esm/* assign */.f0)({\n    bpmnElement: semantic\n  }, attrs));\n};\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/model/index.js\nvar model = __webpack_require__(\"./node_modules/diagram-js/lib/model/index.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/BpmnUpdater.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A handler responsible for updating the underlying BPMN 2.0 XML + DI\n * once changes on the diagram happen\n */\nfunction BpmnUpdater(\n    eventBus, bpmnFactory, connectionDocking,\n    translate) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  this._bpmnFactory = bpmnFactory;\n  this._translate = translate;\n\n  var self = this;\n\n\n\n  // connection cropping //////////////////////\n\n  // crop connection ends during create/update\n  function cropConnection(e) {\n    var context = e.context,\n        hints = context.hints || {},\n        connection;\n\n    if (!context.cropped && hints.createElementsBehavior !== false) {\n      connection = context.connection;\n      connection.waypoints = connectionDocking.getCroppedWaypoints(connection);\n      context.cropped = true;\n    }\n  }\n\n  this.executed([\n    'connection.layout',\n    'connection.create'\n  ], cropConnection);\n\n  this.reverted([ 'connection.layout' ], function(e) {\n    delete e.context.cropped;\n  });\n\n\n\n  // BPMN + DI update //////////////////////\n\n\n  // update parent\n  function updateParent(e) {\n    var context = e.context;\n\n    self.updateParent(context.shape || context.connection, context.oldParent);\n  }\n\n  function reverseUpdateParent(e) {\n    var context = e.context;\n\n    var element = context.shape || context.connection,\n\n        // oldParent is the (old) new parent, because we are undoing\n        oldParent = context.parent || context.newParent;\n\n    self.updateParent(element, oldParent);\n  }\n\n  this.executed([\n    'shape.move',\n    'shape.create',\n    'shape.delete',\n    'connection.create',\n    'connection.move',\n    'connection.delete'\n  ], ifBpmn(updateParent));\n\n  this.reverted([\n    'shape.move',\n    'shape.create',\n    'shape.delete',\n    'connection.create',\n    'connection.move',\n    'connection.delete'\n  ], ifBpmn(reverseUpdateParent));\n\n  /*\n   * ## Updating Parent\n   *\n   * When morphing a Process into a Collaboration or vice-versa,\n   * make sure that both the *semantic* and *di* parent of each element\n   * is updated.\n   *\n   */\n  function updateRoot(event) {\n    var context = event.context,\n        oldRoot = context.oldRoot,\n        children = oldRoot.children;\n\n    (0,dist_index_esm/* forEach */.Ed)(children, function(child) {\n      if ((0,ModelUtil.is)(child, 'bpmn:BaseElement')) {\n        self.updateParent(child);\n      }\n    });\n  }\n\n  this.executed([ 'canvas.updateRoot' ], updateRoot);\n  this.reverted([ 'canvas.updateRoot' ], updateRoot);\n\n\n  // update bounds\n  function updateBounds(e) {\n    var shape = e.context.shape;\n\n    if (!(0,ModelUtil.is)(shape, 'bpmn:BaseElement')) {\n      return;\n    }\n\n    self.updateBounds(shape);\n  }\n\n  this.executed([ 'shape.move', 'shape.create', 'shape.resize' ], ifBpmn(function(event) {\n\n    // exclude labels because they're handled separately during shape.changed\n    if (event.context.shape.type === 'label') {\n      return;\n    }\n\n    updateBounds(event);\n  }));\n\n  this.reverted([ 'shape.move', 'shape.create', 'shape.resize' ], ifBpmn(function(event) {\n\n    // exclude labels because they're handled separately during shape.changed\n    if (event.context.shape.type === 'label') {\n      return;\n    }\n\n    updateBounds(event);\n  }));\n\n  // Handle labels separately. This is necessary, because the label bounds have to be updated\n  // every time its shape changes, not only on move, create and resize.\n  eventBus.on('shape.changed', function(event) {\n    if (event.element.type === 'label') {\n      updateBounds({ context: { shape: event.element } });\n    }\n  });\n\n  // attach / detach connection\n  function updateConnection(e) {\n    self.updateConnection(e.context);\n  }\n\n  this.executed([\n    'connection.create',\n    'connection.move',\n    'connection.delete',\n    'connection.reconnect'\n  ], ifBpmn(updateConnection));\n\n  this.reverted([\n    'connection.create',\n    'connection.move',\n    'connection.delete',\n    'connection.reconnect'\n  ], ifBpmn(updateConnection));\n\n\n  // update waypoints\n  function updateConnectionWaypoints(e) {\n    self.updateConnectionWaypoints(e.context.connection);\n  }\n\n  this.executed([\n    'connection.layout',\n    'connection.move',\n    'connection.updateWaypoints',\n  ], ifBpmn(updateConnectionWaypoints));\n\n  this.reverted([\n    'connection.layout',\n    'connection.move',\n    'connection.updateWaypoints',\n  ], ifBpmn(updateConnectionWaypoints));\n\n  // update conditional/default flows\n  this.executed('connection.reconnect', ifBpmn(function(event) {\n    var context = event.context,\n        connection = context.connection,\n        oldSource = context.oldSource,\n        newSource = context.newSource,\n        connectionBo = (0,ModelUtil/* getBusinessObject */.SS)(connection),\n        oldSourceBo = (0,ModelUtil/* getBusinessObject */.SS)(oldSource),\n        newSourceBo = (0,ModelUtil/* getBusinessObject */.SS)(newSource);\n\n    // remove condition from connection on reconnect to new source\n    // if new source can NOT have condional sequence flow\n    if (connectionBo.conditionExpression && !(0,ModelUtil/* isAny */.JZ)(newSourceBo, [\n      'bpmn:Activity',\n      'bpmn:ExclusiveGateway',\n      'bpmn:InclusiveGateway'\n    ])) {\n      context.oldConditionExpression = connectionBo.conditionExpression;\n\n      delete connectionBo.conditionExpression;\n    }\n\n    // remove default from old source flow on reconnect to new source\n    // if source changed\n    if (oldSource !== newSource && oldSourceBo.default === connectionBo) {\n      context.oldDefault = oldSourceBo.default;\n\n      delete oldSourceBo.default;\n    }\n  }));\n\n  this.reverted('connection.reconnect', ifBpmn(function(event) {\n    var context = event.context,\n        connection = context.connection,\n        oldSource = context.oldSource,\n        newSource = context.newSource,\n        connectionBo = (0,ModelUtil/* getBusinessObject */.SS)(connection),\n        oldSourceBo = (0,ModelUtil/* getBusinessObject */.SS)(oldSource),\n        newSourceBo = (0,ModelUtil/* getBusinessObject */.SS)(newSource);\n\n    // add condition to connection on revert reconnect to new source\n    if (context.oldConditionExpression) {\n      connectionBo.conditionExpression = context.oldConditionExpression;\n    }\n\n    // add default to old source on revert reconnect to new source\n    if (context.oldDefault) {\n      oldSourceBo.default = context.oldDefault;\n\n      delete newSourceBo.default;\n    }\n  }));\n\n  // update attachments\n  function updateAttachment(e) {\n    self.updateAttachment(e.context);\n  }\n\n  this.executed([ 'element.updateAttachment' ], ifBpmn(updateAttachment));\n  this.reverted([ 'element.updateAttachment' ], ifBpmn(updateAttachment));\n}\n\n(0,index_es/* default */.Z)(BpmnUpdater, CommandInterceptor/* default */.Z);\n\nBpmnUpdater.$inject = [\n  'eventBus',\n  'bpmnFactory',\n  'connectionDocking',\n  'translate'\n];\n\n\n// implementation //////////////////////\n\nBpmnUpdater.prototype.updateAttachment = function(context) {\n\n  var shape = context.shape,\n      businessObject = shape.businessObject,\n      host = shape.host;\n\n  businessObject.attachedToRef = host && host.businessObject;\n};\n\nBpmnUpdater.prototype.updateParent = function(element, oldParent) {\n\n  // do not update BPMN 2.0 label parent\n  if (element instanceof model/* Label */.__) {\n    return;\n  }\n\n  // data stores in collaborations are handled separately by DataStoreBehavior\n  if ((0,ModelUtil.is)(element, 'bpmn:DataStoreReference') &&\n      element.parent &&\n      (0,ModelUtil.is)(element.parent, 'bpmn:Collaboration')) {\n    return;\n  }\n\n  var parentShape = element.parent;\n\n  var businessObject = element.businessObject,\n      di = (0,ModelUtil/* getDi */.DN)(element),\n      parentBusinessObject = parentShape && parentShape.businessObject,\n      parentDi = (0,ModelUtil/* getDi */.DN)(parentShape);\n\n  if ((0,ModelUtil.is)(element, 'bpmn:FlowNode')) {\n    this.updateFlowNodeRefs(businessObject, parentBusinessObject, oldParent && oldParent.businessObject);\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:DataOutputAssociation')) {\n    if (element.source) {\n      parentBusinessObject = element.source.businessObject;\n    } else {\n      parentBusinessObject = null;\n    }\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:DataInputAssociation')) {\n    if (element.target) {\n      parentBusinessObject = element.target.businessObject;\n    } else {\n      parentBusinessObject = null;\n    }\n  }\n\n  this.updateSemanticParent(businessObject, parentBusinessObject);\n\n  if ((0,ModelUtil.is)(element, 'bpmn:DataObjectReference') && businessObject.dataObjectRef) {\n    this.updateSemanticParent(businessObject.dataObjectRef, parentBusinessObject);\n  }\n\n  this.updateDiParent(di, parentDi);\n};\n\n\nBpmnUpdater.prototype.updateBounds = function(shape) {\n\n  var di = (0,ModelUtil/* getDi */.DN)(shape),\n      embeddedLabelBounds = getEmbeddedLabelBounds(shape);\n\n  // update embedded label bounds if possible\n  if (embeddedLabelBounds) {\n    var embeddedLabelBoundsDelta = (0,PositionUtil/* delta */.p)(embeddedLabelBounds, di.get('bounds'));\n\n    (0,dist_index_esm/* assign */.f0)(embeddedLabelBounds, {\n      x: shape.x + embeddedLabelBoundsDelta.x,\n      y: shape.y + embeddedLabelBoundsDelta.y\n    });\n  }\n\n  var target = (shape instanceof model/* Label */.__) ? this._getLabel(di) : di;\n\n  var bounds = target.bounds;\n\n  if (!bounds) {\n    bounds = this._bpmnFactory.createDiBounds();\n    target.set('bounds', bounds);\n  }\n\n  (0,dist_index_esm/* assign */.f0)(bounds, {\n    x: shape.x,\n    y: shape.y,\n    width: shape.width,\n    height: shape.height\n  });\n};\n\nBpmnUpdater.prototype.updateFlowNodeRefs = function(businessObject, newContainment, oldContainment) {\n\n  if (oldContainment === newContainment) {\n    return;\n  }\n\n  var oldRefs, newRefs;\n\n  if ((0,ModelUtil.is) (oldContainment, 'bpmn:Lane')) {\n    oldRefs = oldContainment.get('flowNodeRef');\n    (0,Collections/* remove */.Od)(oldRefs, businessObject);\n  }\n\n  if ((0,ModelUtil.is)(newContainment, 'bpmn:Lane')) {\n    newRefs = newContainment.get('flowNodeRef');\n    (0,Collections/* add */.IH)(newRefs, businessObject);\n  }\n};\n\n\n// update existing sourceElement and targetElement di information\nBpmnUpdater.prototype.updateDiConnection = function(connection, newSource, newTarget) {\n  var connectionDi = (0,ModelUtil/* getDi */.DN)(connection),\n      newSourceDi = (0,ModelUtil/* getDi */.DN)(newSource),\n      newTargetDi = (0,ModelUtil/* getDi */.DN)(newTarget);\n\n  if (connectionDi.sourceElement && connectionDi.sourceElement.bpmnElement !== (0,ModelUtil/* getBusinessObject */.SS)(newSource)) {\n    connectionDi.sourceElement = newSource && newSourceDi;\n  }\n\n  if (connectionDi.targetElement && connectionDi.targetElement.bpmnElement !== (0,ModelUtil/* getBusinessObject */.SS)(newTarget)) {\n    connectionDi.targetElement = newTarget && newTargetDi;\n  }\n\n};\n\n\nBpmnUpdater.prototype.updateDiParent = function(di, parentDi) {\n\n  if (parentDi && !(0,ModelUtil.is)(parentDi, 'bpmndi:BPMNPlane')) {\n    parentDi = parentDi.$parent;\n  }\n\n  if (di.$parent === parentDi) {\n    return;\n  }\n\n  var planeElements = (parentDi || di.$parent).get('planeElement');\n\n  if (parentDi) {\n    planeElements.push(di);\n    di.$parent = parentDi;\n  } else {\n    (0,Collections/* remove */.Od)(planeElements, di);\n    di.$parent = null;\n  }\n};\n\nfunction getDefinitions(element) {\n  while (element && !(0,ModelUtil.is)(element, 'bpmn:Definitions')) {\n    element = element.$parent;\n  }\n\n  return element;\n}\n\nBpmnUpdater.prototype.getLaneSet = function(container) {\n\n  var laneSet, laneSets;\n\n  // bpmn:Lane\n  if ((0,ModelUtil.is)(container, 'bpmn:Lane')) {\n    laneSet = container.childLaneSet;\n\n    if (!laneSet) {\n      laneSet = this._bpmnFactory.create('bpmn:LaneSet');\n      container.childLaneSet = laneSet;\n      laneSet.$parent = container;\n    }\n\n    return laneSet;\n  }\n\n  // bpmn:Participant\n  if ((0,ModelUtil.is)(container, 'bpmn:Participant')) {\n    container = container.processRef;\n  }\n\n  // bpmn:FlowElementsContainer\n  laneSets = container.get('laneSets');\n  laneSet = laneSets[0];\n\n  if (!laneSet) {\n    laneSet = this._bpmnFactory.create('bpmn:LaneSet');\n    laneSet.$parent = container;\n    laneSets.push(laneSet);\n  }\n\n  return laneSet;\n};\n\nBpmnUpdater.prototype.updateSemanticParent = function(businessObject, newParent, visualParent) {\n\n  var containment,\n      translate = this._translate;\n\n  if (businessObject.$parent === newParent) {\n    return;\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:DataInput') || (0,ModelUtil.is)(businessObject, 'bpmn:DataOutput')) {\n\n    if ((0,ModelUtil.is)(newParent, 'bpmn:Participant') && 'processRef' in newParent) {\n      newParent = newParent.processRef;\n    }\n\n    // already in correct ioSpecification\n    if ('ioSpecification' in newParent && newParent.ioSpecification === businessObject.$parent) {\n      return;\n    }\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Lane')) {\n\n    if (newParent) {\n      newParent = this.getLaneSet(newParent);\n    }\n\n    containment = 'lanes';\n  } else\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:FlowElement')) {\n\n    if (newParent) {\n\n      if ((0,ModelUtil.is)(newParent, 'bpmn:Participant')) {\n        newParent = newParent.processRef;\n      } else\n\n      if ((0,ModelUtil.is)(newParent, 'bpmn:Lane')) {\n        do {\n\n          // unwrap Lane -> LaneSet -> (Lane | FlowElementsContainer)\n          newParent = newParent.$parent.$parent;\n        } while ((0,ModelUtil.is)(newParent, 'bpmn:Lane'));\n\n      }\n    }\n\n    containment = 'flowElements';\n\n  } else\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Artifact')) {\n\n    while (newParent &&\n           !(0,ModelUtil.is)(newParent, 'bpmn:Process') &&\n           !(0,ModelUtil.is)(newParent, 'bpmn:SubProcess') &&\n           !(0,ModelUtil.is)(newParent, 'bpmn:Collaboration')) {\n\n      if ((0,ModelUtil.is)(newParent, 'bpmn:Participant')) {\n        newParent = newParent.processRef;\n        break;\n      } else {\n        newParent = newParent.$parent;\n      }\n    }\n\n    containment = 'artifacts';\n  } else\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:MessageFlow')) {\n    containment = 'messageFlows';\n\n  } else\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Participant')) {\n    containment = 'participants';\n\n    // make sure the participants process is properly attached / detached\n    // from the XML document\n\n    var process = businessObject.processRef,\n        definitions;\n\n    if (process) {\n      definitions = getDefinitions(businessObject.$parent || newParent);\n\n      if (businessObject.$parent) {\n        (0,Collections/* remove */.Od)(definitions.get('rootElements'), process);\n        process.$parent = null;\n      }\n\n      if (newParent) {\n        (0,Collections/* add */.IH)(definitions.get('rootElements'), process);\n        process.$parent = definitions;\n      }\n    }\n  } else\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:DataOutputAssociation')) {\n    containment = 'dataOutputAssociations';\n  } else\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:DataInputAssociation')) {\n    containment = 'dataInputAssociations';\n  }\n\n  if (!containment) {\n    throw new Error(translate(\n      'no parent for {element} in {parent}',\n      {\n        element: businessObject.id,\n        parent: newParent.id\n      }\n    ));\n  }\n\n  var children;\n\n  if (businessObject.$parent) {\n\n    // remove from old parent\n    children = businessObject.$parent.get(containment);\n    (0,Collections/* remove */.Od)(children, businessObject);\n  }\n\n  if (!newParent) {\n    businessObject.$parent = null;\n  } else {\n\n    // add to new parent\n    children = newParent.get(containment);\n    children.push(businessObject);\n    businessObject.$parent = newParent;\n  }\n\n  if (visualParent) {\n    var diChildren = visualParent.get(containment);\n\n    (0,Collections/* remove */.Od)(children, businessObject);\n\n    if (newParent) {\n\n      if (!diChildren) {\n        diChildren = [];\n        newParent.set(containment, diChildren);\n      }\n\n      diChildren.push(businessObject);\n    }\n  }\n};\n\n\nBpmnUpdater.prototype.updateConnectionWaypoints = function(connection) {\n  var di = (0,ModelUtil/* getDi */.DN)(connection);\n\n  di.set('waypoint', this._bpmnFactory.createDiWaypoints(connection.waypoints));\n};\n\n\nBpmnUpdater.prototype.updateConnection = function(context) {\n  var connection = context.connection,\n      businessObject = (0,ModelUtil/* getBusinessObject */.SS)(connection),\n      newSource = connection.source,\n      newSourceBo = (0,ModelUtil/* getBusinessObject */.SS)(newSource),\n      newTarget = connection.target,\n      newTargetBo = (0,ModelUtil/* getBusinessObject */.SS)(connection.target),\n      visualParent;\n\n  if (!(0,ModelUtil.is)(businessObject, 'bpmn:DataAssociation')) {\n\n    var inverseSet = (0,ModelUtil.is)(businessObject, 'bpmn:SequenceFlow');\n\n    if (businessObject.sourceRef !== newSourceBo) {\n      if (inverseSet) {\n        (0,Collections/* remove */.Od)(businessObject.sourceRef && businessObject.sourceRef.get('outgoing'), businessObject);\n\n        if (newSourceBo && newSourceBo.get('outgoing')) {\n          newSourceBo.get('outgoing').push(businessObject);\n        }\n      }\n\n      businessObject.sourceRef = newSourceBo;\n    }\n\n    if (businessObject.targetRef !== newTargetBo) {\n      if (inverseSet) {\n        (0,Collections/* remove */.Od)(businessObject.targetRef && businessObject.targetRef.get('incoming'), businessObject);\n\n        if (newTargetBo && newTargetBo.get('incoming')) {\n          newTargetBo.get('incoming').push(businessObject);\n        }\n      }\n\n      businessObject.targetRef = newTargetBo;\n    }\n  } else\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:DataInputAssociation')) {\n\n    // handle obnoxious isMsome sourceRef\n    businessObject.get('sourceRef')[0] = newSourceBo;\n\n    visualParent = context.parent || context.newParent || newTargetBo;\n\n    this.updateSemanticParent(businessObject, newTargetBo, visualParent);\n  } else\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:DataOutputAssociation')) {\n    visualParent = context.parent || context.newParent || newSourceBo;\n\n    this.updateSemanticParent(businessObject, newSourceBo, visualParent);\n\n    // targetRef = new target\n    businessObject.targetRef = newTargetBo;\n  }\n\n  this.updateConnectionWaypoints(connection);\n\n  this.updateDiConnection(connection, newSource, newTarget);\n};\n\n\n// helpers //////////////////////\n\nBpmnUpdater.prototype._getLabel = function(di) {\n  if (!di.label) {\n    di.label = this._bpmnFactory.createDiLabel();\n  }\n\n  return di.label;\n};\n\n\n/**\n * Make sure the event listener is only called\n * if the touched element is a BPMN element.\n *\n * @param  {Function} fn\n * @return {Function} guarded function\n */\nfunction ifBpmn(fn) {\n\n  return function(event) {\n\n    var context = event.context,\n        element = context.shape || context.connection;\n\n    if ((0,ModelUtil.is)(element, 'bpmn:BaseElement')) {\n      fn(event);\n    }\n  };\n}\n\n/**\n * Return dc:Bounds of bpmndi:BPMNLabel if exists.\n *\n * @param {djs.model.shape} shape\n *\n * @returns {Object|undefined}\n */\nfunction getEmbeddedLabelBounds(shape) {\n  if (!(0,ModelUtil.is)(shape, 'bpmn:Activity')) {\n    return;\n  }\n\n  var di = (0,ModelUtil/* getDi */.DN)(shape);\n\n  if (!di) {\n    return;\n  }\n\n  var label = di.get('label');\n\n  if (!label) {\n    return;\n  }\n\n  return label.get('bounds');\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/core/ElementFactory.js\nvar ElementFactory = __webpack_require__(\"./node_modules/diagram-js/lib/core/ElementFactory.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/CompatibilityUtil.js\nvar CompatibilityUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/CompatibilityUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/ElementFactory.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A bpmn-aware factory for diagram-js shapes\n */\nfunction ElementFactory_ElementFactory(bpmnFactory, moddle, translate) {\n  ElementFactory/* default.call */.Z.call(this);\n\n  this._bpmnFactory = bpmnFactory;\n  this._moddle = moddle;\n  this._translate = translate;\n}\n\n(0,index_es/* default */.Z)(ElementFactory_ElementFactory, ElementFactory/* default */.Z);\n\nElementFactory_ElementFactory.$inject = [\n  'bpmnFactory',\n  'moddle',\n  'translate'\n];\n\nElementFactory_ElementFactory.prototype.baseCreate = ElementFactory/* default.prototype.create */.Z.prototype.create;\n\nElementFactory_ElementFactory.prototype.create = function(elementType, attrs) {\n\n  // no special magic for labels,\n  // we assume their businessObjects have already been created\n  // and wired via attrs\n  if (elementType === 'label') {\n    var di = attrs.di || this._bpmnFactory.createDiLabel();\n    return this.baseCreate(elementType, (0,dist_index_esm/* assign */.f0)({ type: 'label', di: di }, util_LabelUtil/* DEFAULT_LABEL_SIZE */.DN, attrs));\n  }\n\n  return this.createBpmnElement(elementType, attrs);\n};\n\nElementFactory_ElementFactory.prototype.createBpmnElement = function(elementType, attrs) {\n  var size,\n      translate = this._translate;\n\n  attrs = (0,dist_index_esm/* assign */.f0)({}, attrs || {});\n\n  var businessObject = attrs.businessObject,\n      di = attrs.di;\n\n  if (!businessObject) {\n    if (!attrs.type) {\n      throw new Error(translate('no shape type specified'));\n    }\n\n    businessObject = this._bpmnFactory.create(attrs.type);\n\n    (0,CompatibilityUtil/* ensureCompatDiRef */.S)(businessObject);\n  }\n\n  if (!isModdleDi(di)) {\n    var diAttrs = (0,dist_index_esm/* assign */.f0)(\n      {},\n      di || {},\n      { id: businessObject.id + '_di' }\n    );\n\n    if (elementType === 'root') {\n      di = this._bpmnFactory.createDiPlane(businessObject, diAttrs);\n    } else\n    if (elementType === 'connection') {\n      di = this._bpmnFactory.createDiEdge(businessObject, diAttrs);\n    } else {\n      di = this._bpmnFactory.createDiShape(businessObject, diAttrs);\n    }\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:Group')) {\n    attrs = (0,dist_index_esm/* assign */.f0)({\n      isFrame: true\n    }, attrs);\n  }\n\n  attrs = applyAttributes(businessObject, attrs, [\n    'processRef',\n    'isInterrupting',\n    'associationDirection',\n    'isForCompensation'\n  ]);\n\n  if (attrs.isExpanded) {\n    attrs = applyAttribute(di, attrs, 'isExpanded');\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:SubProcess')) {\n    attrs.collapsed = !(0,DiUtil/* isExpanded */.ul)(businessObject, di);\n  }\n\n  if ((0,ModelUtil.is)(businessObject, 'bpmn:ExclusiveGateway')) {\n    di.isMarkerVisible = true;\n  }\n\n  var eventDefinitions,\n      newEventDefinition;\n\n  if (attrs.eventDefinitionType) {\n    eventDefinitions = businessObject.get('eventDefinitions') || [];\n    newEventDefinition = this._bpmnFactory.create(attrs.eventDefinitionType, attrs.eventDefinitionAttrs);\n\n    if (attrs.eventDefinitionType === 'bpmn:ConditionalEventDefinition') {\n      newEventDefinition.condition = this._bpmnFactory.create('bpmn:FormalExpression');\n    }\n\n    eventDefinitions.push(newEventDefinition);\n\n    newEventDefinition.$parent = businessObject;\n    businessObject.eventDefinitions = eventDefinitions;\n\n    delete attrs.eventDefinitionType;\n  }\n\n  size = this.getDefaultSize(businessObject, di);\n\n  attrs = (0,dist_index_esm/* assign */.f0)({\n    id: businessObject.id\n  }, size, attrs, {\n    businessObject: businessObject,\n    di: di\n  });\n\n  return this.baseCreate(elementType, attrs);\n};\n\n\nElementFactory_ElementFactory.prototype.getDefaultSize = function(element, di) {\n\n  var bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n  di = di || (0,ModelUtil/* getDi */.DN)(element);\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:SubProcess')) {\n    if ((0,DiUtil/* isExpanded */.ul)(bo, di)) {\n      return { width: 350, height: 200 };\n    } else {\n      return { width: 100, height: 80 };\n    }\n  }\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:Task')) {\n    return { width: 100, height: 80 };\n  }\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:Gateway')) {\n    return { width: 50, height: 50 };\n  }\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:Event')) {\n    return { width: 36, height: 36 };\n  }\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:Participant')) {\n    if ((0,DiUtil/* isExpanded */.ul)(bo, di)) {\n      return { width: 600, height: 250 };\n    } else {\n      return { width: 400, height: 60 };\n    }\n  }\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:Lane')) {\n    return { width: 400, height: 100 };\n  }\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:DataObjectReference')) {\n    return { width: 36, height: 50 };\n  }\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:DataStoreReference')) {\n    return { width: 50, height: 50 };\n  }\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:TextAnnotation')) {\n    return { width: 100, height: 30 };\n  }\n\n  if ((0,ModelUtil.is)(bo, 'bpmn:Group')) {\n    return { width: 300, height: 300 };\n  }\n\n  return { width: 100, height: 80 };\n};\n\n\n/**\n * Create participant.\n *\n * @param {boolean|Object} [attrs] attrs\n *\n * @returns {djs.model.Shape}\n */\nElementFactory_ElementFactory.prototype.createParticipantShape = function(attrs) {\n\n  if (!(0,dist_index_esm/* isObject */.Kn)(attrs)) {\n    attrs = { isExpanded: attrs };\n  }\n\n  attrs = (0,dist_index_esm/* assign */.f0)({ type: 'bpmn:Participant' }, attrs || {});\n\n  // participants are expanded by default\n  if (attrs.isExpanded !== false) {\n    attrs.processRef = this._bpmnFactory.create('bpmn:Process');\n  }\n\n  return this.createShape(attrs);\n};\n\n\n// helpers //////////////////////\n\n/**\n * Apply attributes from a map to the given element,\n * remove attribute from the map on application.\n *\n * @param {Base} element\n * @param {Object} attrs (in/out map of attributes)\n * @param {Array<string>} attributeNames name of attributes to apply\n *\n * @return {Object} changed attrs\n */\nfunction applyAttributes(element, attrs, attributeNames) {\n\n  (0,dist_index_esm/* forEach */.Ed)(attributeNames, function(property) {\n    attrs = applyAttribute(element, attrs, property);\n  });\n\n  return attrs;\n}\n\n/**\n * Apply named property to element and drain it from the attrs\n * collection.\n *\n * @param {Base} element\n * @param {Object} attrs (in/out map of attributes)\n * @param {string} attributeName to apply\n *\n * @return {Object} changed attrs\n */\nfunction applyAttribute(element, attrs, attributeName) {\n  if (attrs[attributeName] === undefined) {\n    return attrs;\n  }\n\n  element[attributeName] = attrs[attributeName];\n\n  return (0,dist_index_esm/* omit */.CE)(attrs, [ attributeName ]);\n}\n\n\nfunction isModdleDi(element) {\n  return (0,ModelUtil/* isAny */.JZ)(element, [\n    'bpmndi:BPMNShape',\n    'bpmndi:BPMNEdge',\n    'bpmndi:BPMNDiagram',\n    'bpmndi:BPMNPlane',\n  ]);\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/modeling/Modeling.js + 23 modules\nvar Modeling = __webpack_require__(\"./node_modules/diagram-js/lib/features/modeling/Modeling.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/UpdateModdlePropertiesHandler.js\n\n\n\n\nfunction UpdateModdlePropertiesHandler(elementRegistry) {\n  this._elementRegistry = elementRegistry;\n}\n\nUpdateModdlePropertiesHandler.$inject = [ 'elementRegistry' ];\n\nUpdateModdlePropertiesHandler.prototype.execute = function(context) {\n\n  var element = context.element,\n      moddleElement = context.moddleElement,\n      properties = context.properties;\n\n  if (!moddleElement) {\n    throw new Error('<moddleElement> required');\n  }\n\n  // TODO(nikku): we need to ensure that ID properties\n  // are properly registered / unregistered via\n  // this._moddle.ids.assigned(id)\n  var changed = context.changed || this.getVisualReferences(moddleElement).concat(element);\n  var oldProperties = context.oldProperties || getModdleProperties(moddleElement, (0,dist_index_esm/* keys */.XP)(properties));\n\n  setModdleProperties(moddleElement, properties);\n\n  context.oldProperties = oldProperties;\n  context.changed = changed;\n\n  return changed;\n};\n\nUpdateModdlePropertiesHandler.prototype.revert = function(context) {\n  var oldProperties = context.oldProperties,\n      moddleElement = context.moddleElement,\n      changed = context.changed;\n\n  setModdleProperties(moddleElement, oldProperties);\n\n  return changed;\n};\n\n/**\n * Return visual references of given moddle element within the diagram.\n *\n * @param {ModdleElement} moddleElement\n *\n * @return {Array<djs.model.Element>}\n */\nUpdateModdlePropertiesHandler.prototype.getVisualReferences = function(moddleElement) {\n\n  var elementRegistry = this._elementRegistry;\n\n  if ((0,ModelUtil.is)(moddleElement, 'bpmn:DataObject')) {\n    return getAllDataObjectReferences(moddleElement, elementRegistry);\n  }\n\n  return [];\n};\n\n\n// helpers /////////////////\n\nfunction getModdleProperties(moddleElement, propertyNames) {\n  return (0,dist_index_esm/* reduce */.u4)(propertyNames, function(result, key) {\n    result[key] = moddleElement.get(key);\n    return result;\n  }, {});\n}\n\nfunction setModdleProperties(moddleElement, properties) {\n  (0,dist_index_esm/* forEach */.Ed)(properties, function(value, key) {\n    moddleElement.set(key, value);\n  });\n}\n\nfunction getAllDataObjectReferences(dataObject, elementRegistry) {\n  return elementRegistry.filter(function(element) {\n    return (\n      (0,ModelUtil.is)(element, 'bpmn:DataObjectReference') &&\n          (0,ModelUtil/* getBusinessObject */.SS)(element).dataObjectRef === dataObject\n    );\n  });\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/UpdatePropertiesHandler.js\n\n\n\n\nvar DEFAULT_FLOW = 'default',\n    ID = 'id',\n    DI = 'di';\n\nvar NULL_DIMENSIONS = {\n  width: 0,\n  height: 0\n};\n\n/**\n * A handler that implements a BPMN 2.0 property update.\n *\n * This should be used to set simple properties on elements with\n * an underlying BPMN business object.\n *\n * Use respective diagram-js provided handlers if you would\n * like to perform automated modeling.\n */\nfunction UpdatePropertiesHandler(\n    elementRegistry, moddle, translate,\n    modeling, textRenderer) {\n\n  this._elementRegistry = elementRegistry;\n  this._moddle = moddle;\n  this._translate = translate;\n  this._modeling = modeling;\n  this._textRenderer = textRenderer;\n}\n\nUpdatePropertiesHandler.$inject = [\n  'elementRegistry',\n  'moddle',\n  'translate',\n  'modeling',\n  'textRenderer'\n];\n\n\n// api //////////////////////\n\n/**\n * Updates a BPMN element with a list of new properties\n *\n * @param {Object} context\n * @param {djs.model.Base} context.element the element to update\n * @param {Object} context.properties a list of properties to set on the element's\n *                                    businessObject (the BPMN model element)\n *\n * @return {Array<djs.model.Base>} the updated element\n */\nUpdatePropertiesHandler.prototype.execute = function(context) {\n\n  var element = context.element,\n      changed = [ element ],\n      translate = this._translate;\n\n  if (!element) {\n    throw new Error(translate('element required'));\n  }\n\n  var elementRegistry = this._elementRegistry,\n      ids = this._moddle.ids;\n\n  var businessObject = element.businessObject,\n      properties = unwrapBusinessObjects(context.properties),\n      oldProperties = context.oldProperties || getProperties(element, properties);\n\n  if (isIdChange(properties, businessObject)) {\n    ids.unclaim(businessObject[ID]);\n\n    elementRegistry.updateId(element, properties[ID]);\n\n    ids.claim(properties[ID], businessObject);\n  }\n\n  // correctly indicate visual changes on default flow updates\n  if (DEFAULT_FLOW in properties) {\n\n    if (properties[DEFAULT_FLOW]) {\n      changed.push(elementRegistry.get(properties[DEFAULT_FLOW].id));\n    }\n\n    if (businessObject[DEFAULT_FLOW]) {\n      changed.push(elementRegistry.get(businessObject[DEFAULT_FLOW].id));\n    }\n  }\n\n  // update properties\n  setProperties(element, properties);\n\n  // store old values\n  context.oldProperties = oldProperties;\n  context.changed = changed;\n\n  // indicate changed on objects affected by the update\n  return changed;\n};\n\n\nUpdatePropertiesHandler.prototype.postExecute = function(context) {\n  var element = context.element,\n      label = element.label;\n\n  var text = label && (0,ModelUtil/* getBusinessObject */.SS)(label).name;\n\n  if (!text) {\n    return;\n  }\n\n  // get layouted text bounds and resize external\n  // external label accordingly\n  var newLabelBounds = this._textRenderer.getExternalLabelBounds(label, text);\n\n  this._modeling.resizeShape(label, newLabelBounds, NULL_DIMENSIONS);\n};\n\n/**\n * Reverts the update on a BPMN elements properties.\n *\n * @param  {Object} context\n *\n * @return {djs.model.Base} the updated element\n */\nUpdatePropertiesHandler.prototype.revert = function(context) {\n\n  var element = context.element,\n      properties = context.properties,\n      oldProperties = context.oldProperties,\n      businessObject = element.businessObject,\n      elementRegistry = this._elementRegistry,\n      ids = this._moddle.ids;\n\n  // update properties\n  setProperties(element, oldProperties);\n\n  if (isIdChange(properties, businessObject)) {\n    ids.unclaim(properties[ID]);\n\n    elementRegistry.updateId(element, oldProperties[ID]);\n\n    ids.claim(oldProperties[ID], businessObject);\n  }\n\n  return context.changed;\n};\n\n\nfunction isIdChange(properties, businessObject) {\n  return ID in properties && properties[ID] !== businessObject[ID];\n}\n\n\nfunction getProperties(element, properties) {\n  var propertyNames = (0,dist_index_esm/* keys */.XP)(properties),\n      businessObject = element.businessObject,\n      di = (0,ModelUtil/* getDi */.DN)(element);\n\n  return (0,dist_index_esm/* reduce */.u4)(propertyNames, function(result, key) {\n\n    // handle DI separately\n    if (key !== DI) {\n      result[key] = businessObject.get(key);\n\n    } else {\n      result[key] = getDiProperties(di, (0,dist_index_esm/* keys */.XP)(properties.di));\n    }\n\n    return result;\n  }, {});\n}\n\n\nfunction getDiProperties(di, propertyNames) {\n  return (0,dist_index_esm/* reduce */.u4)(propertyNames, function(result, key) {\n    result[key] = di && di.get(key);\n\n    return result;\n  }, {});\n}\n\n\nfunction setProperties(element, properties) {\n  var businessObject = element.businessObject,\n      di = (0,ModelUtil/* getDi */.DN)(element);\n\n  (0,dist_index_esm/* forEach */.Ed)(properties, function(value, key) {\n\n    if (key !== DI) {\n      businessObject.set(key, value);\n    } else {\n\n      // only update, if di exists\n      if (di) {\n        setDiProperties(di, value);\n      }\n    }\n  });\n}\n\n\nfunction setDiProperties(di, properties) {\n  (0,dist_index_esm/* forEach */.Ed)(properties, function(value, key) {\n    di.set(key, value);\n  });\n}\n\n\nvar referencePropertyNames = [ 'default' ];\n\n/**\n * Make sure we unwrap the actual business object\n * behind diagram element that may have been\n * passed as arguments.\n *\n * @param  {Object} properties\n *\n * @return {Object} unwrappedProps\n */\nfunction unwrapBusinessObjects(properties) {\n\n  var unwrappedProps = (0,dist_index_esm/* assign */.f0)({}, properties);\n\n  referencePropertyNames.forEach(function(name) {\n    if (name in properties) {\n      unwrappedProps[name] = (0,ModelUtil/* getBusinessObject */.SS)(unwrappedProps[name]);\n    }\n  });\n\n  return unwrappedProps;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/UpdateCanvasRootHandler.js\n\n\n\n\n\nfunction UpdateCanvasRootHandler(canvas, modeling) {\n  this._canvas = canvas;\n  this._modeling = modeling;\n}\n\nUpdateCanvasRootHandler.$inject = [\n  'canvas',\n  'modeling'\n];\n\n\nUpdateCanvasRootHandler.prototype.execute = function(context) {\n\n  var canvas = this._canvas;\n\n  var newRoot = context.newRoot,\n      newRootBusinessObject = newRoot.businessObject,\n      oldRoot = canvas.getRootElement(),\n      oldRootBusinessObject = oldRoot.businessObject,\n      bpmnDefinitions = oldRootBusinessObject.$parent,\n      diPlane = (0,ModelUtil/* getDi */.DN)(oldRoot);\n\n  // (1) replace process old <> new root\n  canvas.setRootElement(newRoot);\n  canvas.removeRootElement(oldRoot);\n\n  // (2) update root elements\n  (0,Collections/* add */.IH)(bpmnDefinitions.rootElements, newRootBusinessObject);\n  newRootBusinessObject.$parent = bpmnDefinitions;\n\n  (0,Collections/* remove */.Od)(bpmnDefinitions.rootElements, oldRootBusinessObject);\n  oldRootBusinessObject.$parent = null;\n\n  // (3) wire di\n  oldRoot.di = null;\n\n  diPlane.bpmnElement = newRootBusinessObject;\n  newRoot.di = diPlane;\n\n  context.oldRoot = oldRoot;\n\n  // TODO(nikku): return changed elements?\n  // return [ newRoot, oldRoot ];\n};\n\n\nUpdateCanvasRootHandler.prototype.revert = function(context) {\n\n  var canvas = this._canvas;\n\n  var newRoot = context.newRoot,\n      newRootBusinessObject = newRoot.businessObject,\n      oldRoot = context.oldRoot,\n      oldRootBusinessObject = oldRoot.businessObject,\n      bpmnDefinitions = newRootBusinessObject.$parent,\n      diPlane = (0,ModelUtil/* getDi */.DN)(newRoot);\n\n  // (1) replace process old <> new root\n  canvas.setRootElement(oldRoot);\n  canvas.removeRootElement(newRoot);\n\n  // (2) update root elements\n  (0,Collections/* remove */.Od)(bpmnDefinitions.rootElements, newRootBusinessObject);\n  newRootBusinessObject.$parent = null;\n\n  (0,Collections/* add */.IH)(bpmnDefinitions.rootElements, oldRootBusinessObject);\n  oldRootBusinessObject.$parent = bpmnDefinitions;\n\n  // (3) wire di\n  newRoot.di = null;\n\n  diPlane.bpmnElement = oldRootBusinessObject;\n  oldRoot.di = diPlane;\n\n  // TODO(nikku): return changed elements?\n  // return [ newRoot, oldRoot ];\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/AddLaneHandler.js\n\n\n\n\n\n\n\n/**\n * A handler that allows us to add a new lane\n * above or below an existing one.\n *\n * @param {Modeling} modeling\n * @param {SpaceTool} spaceTool\n */\nfunction AddLaneHandler(modeling, spaceTool) {\n  this._modeling = modeling;\n  this._spaceTool = spaceTool;\n}\n\nAddLaneHandler.$inject = [\n  'modeling',\n  'spaceTool'\n];\n\n\nAddLaneHandler.prototype.preExecute = function(context) {\n\n  var spaceTool = this._spaceTool,\n      modeling = this._modeling;\n\n  var shape = context.shape,\n      location = context.location;\n\n  var lanesRoot = getLanesRoot(shape);\n\n  var isRoot = lanesRoot === shape,\n      laneParent = isRoot ? shape : shape.parent;\n\n  var existingChildLanes = getChildLanes(laneParent);\n\n  // (0) add a lane if we currently got none and are adding to root\n  if (!existingChildLanes.length) {\n    modeling.createShape({ type: 'bpmn:Lane' }, {\n      x: shape.x + LANE_INDENTATION,\n      y: shape.y,\n      width: shape.width - LANE_INDENTATION,\n      height: shape.height\n    }, laneParent);\n  }\n\n  // (1) collect affected elements to create necessary space\n  var allAffected = [];\n\n  (0,Elements/* eachElement */.om)(lanesRoot, function(element) {\n    allAffected.push(element);\n\n    // handle element labels in the diagram root\n    if (element.label) {\n      allAffected.push(element.label);\n    }\n\n    if (element === shape) {\n      return [];\n    }\n\n    return (0,dist_index_esm/* filter */.hX)(element.children, function(c) {\n      return c !== shape;\n    });\n  });\n\n  var offset = location === 'top' ? -120 : 120,\n      lanePosition = location === 'top' ? shape.y : shape.y + shape.height,\n      spacePos = lanePosition + (location === 'top' ? 10 : -10),\n      direction = location === 'top' ? 'n' : 's';\n\n  var adjustments = spaceTool.calculateAdjustments(allAffected, 'y', offset, spacePos);\n\n  spaceTool.makeSpace(\n    adjustments.movingShapes,\n    adjustments.resizingShapes,\n    { x: 0, y: offset },\n    direction,\n    spacePos\n  );\n\n  // (2) create new lane at open space\n  context.newLane = modeling.createShape({ type: 'bpmn:Lane' }, {\n    x: shape.x + (isRoot ? LANE_INDENTATION : 0),\n    y: lanePosition - (location === 'top' ? 120 : 0),\n    width: shape.width - (isRoot ? LANE_INDENTATION : 0),\n    height: 120\n  }, laneParent);\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/SplitLaneHandler.js\n\n\n\n/**\n * A handler that splits a lane into a number of sub-lanes,\n * creating new sub lanes, if necessary.\n *\n * @param {Modeling} modeling\n */\nfunction SplitLaneHandler(modeling, translate) {\n  this._modeling = modeling;\n  this._translate = translate;\n}\n\nSplitLaneHandler.$inject = [\n  'modeling',\n  'translate'\n];\n\n\nSplitLaneHandler.prototype.preExecute = function(context) {\n\n  var modeling = this._modeling,\n      translate = this._translate;\n\n  var shape = context.shape,\n      newLanesCount = context.count;\n\n  var childLanes = getChildLanes(shape),\n      existingLanesCount = childLanes.length;\n\n  if (existingLanesCount > newLanesCount) {\n    throw new Error(translate('more than {count} child lanes', { count: newLanesCount }));\n  }\n\n  var newLanesHeight = Math.round(shape.height / newLanesCount);\n\n  // Iterate from top to bottom in child lane order,\n  // resizing existing lanes and creating new ones\n  // so that they split the parent proportionally.\n  //\n  // Due to rounding related errors, the bottom lane\n  // needs to take up all the remaining space.\n  var laneY,\n      laneHeight,\n      laneBounds,\n      newLaneAttrs,\n      idx;\n\n  for (idx = 0; idx < newLanesCount; idx++) {\n\n    laneY = shape.y + idx * newLanesHeight;\n\n    // if bottom lane\n    if (idx === newLanesCount - 1) {\n      laneHeight = shape.height - (newLanesHeight * idx);\n    } else {\n      laneHeight = newLanesHeight;\n    }\n\n    laneBounds = {\n      x: shape.x + LANE_INDENTATION,\n      y: laneY,\n      width: shape.width - LANE_INDENTATION,\n      height: laneHeight\n    };\n\n    if (idx < existingLanesCount) {\n\n      // resize existing lane\n      modeling.resizeShape(childLanes[idx], laneBounds);\n    } else {\n\n      // create a new lane at position\n      newLaneAttrs = {\n        type: 'bpmn:Lane'\n      };\n\n      modeling.createShape(newLaneAttrs, laneBounds, shape);\n    }\n  }\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/ResizeLaneHandler.js\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A handler that resizes a lane.\n *\n * @param {Modeling} modeling\n */\nfunction ResizeLaneHandler(modeling, spaceTool) {\n  this._modeling = modeling;\n  this._spaceTool = spaceTool;\n}\n\nResizeLaneHandler.$inject = [\n  'modeling',\n  'spaceTool'\n];\n\n\nResizeLaneHandler.prototype.preExecute = function(context) {\n\n  var shape = context.shape,\n      newBounds = context.newBounds,\n      balanced = context.balanced;\n\n  if (balanced !== false) {\n    this.resizeBalanced(shape, newBounds);\n  } else {\n    this.resizeSpace(shape, newBounds);\n  }\n};\n\n\n/**\n * Resize balanced, adjusting next / previous lane sizes.\n *\n * @param {djs.model.Shape} shape\n * @param {Bounds} newBounds\n */\nResizeLaneHandler.prototype.resizeBalanced = function(shape, newBounds) {\n\n  var modeling = this._modeling;\n\n  var resizeNeeded = computeLanesResize(shape, newBounds);\n\n  // resize the lane\n  modeling.resizeShape(shape, newBounds);\n\n  // resize other lanes as needed\n  resizeNeeded.forEach(function(r) {\n    modeling.resizeShape(r.shape, r.newBounds);\n  });\n};\n\n\n/**\n * Resize, making actual space and moving below / above elements.\n *\n * @param {djs.model.Shape} shape\n * @param {Bounds} newBounds\n */\nResizeLaneHandler.prototype.resizeSpace = function(shape, newBounds) {\n  var spaceTool = this._spaceTool;\n\n  var shapeTrbl = (0,LayoutUtil/* asTRBL */.JA)(shape),\n      newTrbl = (0,LayoutUtil/* asTRBL */.JA)(newBounds);\n\n  var trblDiff = (0,ResizeUtil/* substractTRBL */._P)(newTrbl, shapeTrbl);\n\n  var lanesRoot = getLanesRoot(shape);\n\n  var allAffected = [],\n      allLanes = [];\n\n  (0,Elements/* eachElement */.om)(lanesRoot, function(element) {\n    allAffected.push(element);\n\n    if ((0,ModelUtil.is)(element, 'bpmn:Lane') || (0,ModelUtil.is)(element, 'bpmn:Participant')) {\n      allLanes.push(element);\n    }\n\n    return element.children;\n  });\n\n  var change,\n      spacePos,\n      direction,\n      offset,\n      adjustments;\n\n  if (trblDiff.bottom || trblDiff.top) {\n\n    change = trblDiff.bottom || trblDiff.top;\n    spacePos = shape.y + (trblDiff.bottom ? shape.height : 0) + (trblDiff.bottom ? -10 : 10);\n    direction = trblDiff.bottom ? 's' : 'n';\n\n    offset = trblDiff.top > 0 || trblDiff.bottom < 0 ? -change : change;\n\n    adjustments = spaceTool.calculateAdjustments(allAffected, 'y', offset, spacePos);\n\n    spaceTool.makeSpace(adjustments.movingShapes, adjustments.resizingShapes, { x: 0, y: change }, direction);\n  }\n\n\n  if (trblDiff.left || trblDiff.right) {\n\n    change = trblDiff.right || trblDiff.left;\n    spacePos = shape.x + (trblDiff.right ? shape.width : 0) + (trblDiff.right ? -10 : 100);\n    direction = trblDiff.right ? 'e' : 'w';\n\n    offset = trblDiff.left > 0 || trblDiff.right < 0 ? -change : change;\n\n    adjustments = spaceTool.calculateAdjustments(allLanes, 'x', offset, spacePos);\n\n    spaceTool.makeSpace(adjustments.movingShapes, adjustments.resizingShapes, { x: change, y: 0 }, direction);\n  }\n};\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/UpdateFlowNodeRefsHandler.js\n\n\n\n\n\n\n\n\nvar FLOW_NODE_REFS_ATTR = 'flowNodeRef',\n    LANES_ATTR = 'lanes';\n\n\n/**\n * A handler that updates lane refs on changed elements\n */\nfunction UpdateFlowNodeRefsHandler(elementRegistry) {\n  this._elementRegistry = elementRegistry;\n}\n\nUpdateFlowNodeRefsHandler.$inject = [\n  'elementRegistry'\n];\n\n\nUpdateFlowNodeRefsHandler.prototype.computeUpdates = function(flowNodeShapes, laneShapes) {\n\n  var handledNodes = [];\n\n  var updates = [];\n\n  var participantCache = {};\n\n  var allFlowNodeShapes = [];\n\n  function isInLaneShape(element, laneShape) {\n\n    var laneTrbl = (0,LayoutUtil/* asTRBL */.JA)(laneShape);\n\n    var elementMid = {\n      x: element.x + element.width / 2,\n      y: element.y + element.height / 2\n    };\n\n    return elementMid.x > laneTrbl.left &&\n           elementMid.x < laneTrbl.right &&\n           elementMid.y > laneTrbl.top &&\n           elementMid.y < laneTrbl.bottom;\n  }\n\n  function addFlowNodeShape(flowNodeShape) {\n    if (handledNodes.indexOf(flowNodeShape) === -1) {\n      allFlowNodeShapes.push(flowNodeShape);\n      handledNodes.push(flowNodeShape);\n    }\n  }\n\n  function getAllLaneShapes(flowNodeShape) {\n\n    var root = getLanesRoot(flowNodeShape);\n\n    if (!participantCache[root.id]) {\n      participantCache[root.id] = collectLanes(root);\n    }\n\n    return participantCache[root.id];\n  }\n\n  function getNewLanes(flowNodeShape) {\n    if (!flowNodeShape.parent) {\n      return [];\n    }\n\n    var allLaneShapes = getAllLaneShapes(flowNodeShape);\n\n    return allLaneShapes.filter(function(l) {\n      return isInLaneShape(flowNodeShape, l);\n    }).map(function(shape) {\n      return shape.businessObject;\n    });\n  }\n\n  laneShapes.forEach(function(laneShape) {\n    var root = getLanesRoot(laneShape);\n\n    if (!root || handledNodes.indexOf(root) !== -1) {\n      return;\n    }\n\n    var children = root.children.filter(function(c) {\n      return (0,ModelUtil.is)(c, 'bpmn:FlowNode');\n    });\n\n    children.forEach(addFlowNodeShape);\n\n    handledNodes.push(root);\n  });\n\n  flowNodeShapes.forEach(addFlowNodeShape);\n\n\n  allFlowNodeShapes.forEach(function(flowNodeShape) {\n\n    var flowNode = flowNodeShape.businessObject;\n\n    var lanes = flowNode.get(LANES_ATTR),\n        remove = lanes.slice(),\n        add = getNewLanes(flowNodeShape);\n\n    updates.push({ flowNode: flowNode, remove: remove, add: add });\n  });\n\n  laneShapes.forEach(function(laneShape) {\n\n    var lane = laneShape.businessObject;\n\n    // lane got removed XX-)\n    if (!laneShape.parent) {\n      lane.get(FLOW_NODE_REFS_ATTR).forEach(function(flowNode) {\n        updates.push({ flowNode: flowNode, remove: [ lane ], add: [] });\n      });\n    }\n  });\n\n  return updates;\n};\n\nUpdateFlowNodeRefsHandler.prototype.execute = function(context) {\n\n  var updates = context.updates;\n\n  if (!updates) {\n    updates = context.updates = this.computeUpdates(context.flowNodeShapes, context.laneShapes);\n  }\n\n\n  updates.forEach(function(update) {\n\n    var flowNode = update.flowNode,\n        lanes = flowNode.get(LANES_ATTR);\n\n    // unwire old\n    update.remove.forEach(function(oldLane) {\n      (0,Collections/* remove */.Od)(lanes, oldLane);\n      (0,Collections/* remove */.Od)(oldLane.get(FLOW_NODE_REFS_ATTR), flowNode);\n    });\n\n    // wire new\n    update.add.forEach(function(newLane) {\n      (0,Collections/* add */.IH)(lanes, newLane);\n      (0,Collections/* add */.IH)(newLane.get(FLOW_NODE_REFS_ATTR), flowNode);\n    });\n  });\n\n  // TODO(nikku): return changed elements\n  // return [ ... ];\n};\n\n\nUpdateFlowNodeRefsHandler.prototype.revert = function(context) {\n\n  var updates = context.updates;\n\n  updates.forEach(function(update) {\n\n    var flowNode = update.flowNode,\n        lanes = flowNode.get(LANES_ATTR);\n\n    // unwire new\n    update.add.forEach(function(newLane) {\n      (0,Collections/* remove */.Od)(lanes, newLane);\n      (0,Collections/* remove */.Od)(newLane.get(FLOW_NODE_REFS_ATTR), flowNode);\n    });\n\n    // wire old\n    update.remove.forEach(function(oldLane) {\n      (0,Collections/* add */.IH)(lanes, oldLane);\n      (0,Collections/* add */.IH)(oldLane.get(FLOW_NODE_REFS_ATTR), flowNode);\n    });\n  });\n\n  // TODO(nikku): return changed elements\n  // return [ ... ];\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/IdClaimHandler.js\nfunction IdClaimHandler(moddle) {\n  this._moddle = moddle;\n}\n\nIdClaimHandler.$inject = [ 'moddle' ];\n\n\nIdClaimHandler.prototype.execute = function(context) {\n  var ids = this._moddle.ids,\n      id = context.id,\n      element = context.element,\n      claiming = context.claiming;\n\n  if (claiming) {\n    ids.claim(id, element);\n  } else {\n    ids.unclaim(id);\n  }\n};\n\n/**\n * Command revert implementation.\n */\nIdClaimHandler.prototype.revert = function(context) {\n  var ids = this._moddle.ids,\n      id = context.id,\n      element = context.element,\n      claiming = context.claiming;\n\n  if (claiming) {\n    ids.unclaim(id);\n  } else {\n    ids.claim(id, element);\n  }\n};\n\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/cmd/SetColorHandler.js\n\r\n\r\n\r\n\r\n\r\n\r\nvar DEFAULT_COLORS = {\r\n  fill: undefined,\r\n  stroke: undefined\r\n};\r\n\r\n\r\nfunction SetColorHandler(commandStack) {\r\n  this._commandStack = commandStack;\r\n\r\n  this._normalizeColor = function(color) {\r\n\r\n    // Remove color for falsy values.\r\n    if (!color) {\r\n      return undefined;\r\n    }\r\n\r\n    if ((0,dist_index_esm/* isString */.HD)(color)) {\r\n      var hexColor = colorToHex(color);\r\n\r\n      if (hexColor) {\r\n        return hexColor;\r\n      }\r\n    }\r\n\r\n    throw new Error('invalid color value: ' + color);\r\n  };\r\n}\r\n\r\nSetColorHandler.$inject = [\r\n  'commandStack'\r\n];\r\n\r\n\r\nSetColorHandler.prototype.postExecute = function(context) {\r\n  var elements = context.elements,\r\n      colors = context.colors || DEFAULT_COLORS;\r\n\r\n  var self = this;\r\n\r\n  var di = {};\r\n\r\n  if ('fill' in colors) {\r\n    (0,dist_index_esm/* assign */.f0)(di, {\r\n      'background-color': this._normalizeColor(colors.fill) });\r\n  }\r\n\r\n  if ('stroke' in colors) {\r\n    (0,dist_index_esm/* assign */.f0)(di, {\r\n      'border-color': this._normalizeColor(colors.stroke) });\r\n  }\r\n\r\n  (0,dist_index_esm/* forEach */.Ed)(elements, function(element) {\r\n    var assignedDi = SetColorHandler_isConnection(element) ? (0,dist_index_esm/* pick */.ei)(di, [ 'border-color' ]) : di,\r\n        elementDi = (0,ModelUtil/* getDi */.DN)(element);\r\n\r\n    // TODO @barmac: remove once we drop bpmn.io properties\r\n    ensureLegacySupport(assignedDi);\r\n\r\n    if ((0,util_LabelUtil/* isLabel */.j_)(element)) {\r\n\r\n      // set label colors as bpmndi:BPMNLabel#color\r\n      self._commandStack.execute('element.updateModdleProperties', {\r\n        element: element,\r\n        moddleElement: elementDi.label,\r\n        properties: {\r\n          color: di['border-color']\r\n        }\r\n      });\r\n    } else {\r\n\r\n      // ignore non-compliant di\r\n      if (!(0,ModelUtil/* isAny */.JZ)(elementDi, [ 'bpmndi:BPMNEdge', 'bpmndi:BPMNShape' ])) {\r\n        return;\r\n      }\r\n\r\n      // set colors bpmndi:BPMNEdge or bpmndi:BPMNShape\r\n      self._commandStack.execute('element.updateProperties', {\r\n        element: element,\r\n        properties: {\r\n          di: assignedDi\r\n        }\r\n      });\r\n    }\r\n  });\r\n\r\n};\r\n\r\n/**\r\n * Convert color from rgb(a)/hsl to hex. Returns `null` for unknown color names and for colors\r\n * with alpha less than 1.0. This depends on `<canvas>` serialization of the `context.fillStyle`.\r\n * Cf. https://html.spec.whatwg.org/multipage/canvas.html#dom-context-2d-fillstyle\r\n *\r\n * @example\r\n * ```js\r\n * var color = 'fuchsia';\r\n * console.log(colorToHex(color));\r\n * // \"#ff00ff\"\r\n * color = 'rgba(1,2,3,0.4)';\r\n * console.log(colorToHex(color));\r\n * // null\r\n * ```\r\n *\r\n * @param {string} color\r\n * @returns {string|null}\r\n */\r\nfunction colorToHex(color) {\r\n  var context = document.createElement('canvas').getContext('2d');\r\n\r\n  // (0) Start with transparent to account for browser default values.\r\n  context.fillStyle = 'transparent';\r\n\r\n  // (1) Assign color so that it's serialized.\r\n  context.fillStyle = color;\r\n\r\n  // (2) Return null for non-hex serialization result.\r\n  return /^#[0-9a-fA-F]{6}$/.test(context.fillStyle) ? context.fillStyle : null;\r\n}\r\n\r\nfunction SetColorHandler_isConnection(element) {\r\n  return !!element.waypoints;\r\n}\r\n\r\n/**\r\n * Add legacy properties if required.\r\n * @param {{ 'border-color': string?, 'background-color': string? }} di\r\n */\r\nfunction ensureLegacySupport(di) {\r\n  if ('border-color' in di) {\r\n    di.stroke = di['border-color'];\r\n  }\r\n\r\n  if ('background-color' in di) {\r\n    di.fill = di['background-color'];\r\n  }\r\n}\r\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/label-editing/cmd/UpdateLabelHandler.js\n\n\n\n\n\n\nvar UpdateLabelHandler_NULL_DIMENSIONS = {\n  width: 0,\n  height: 0\n};\n\n\n/**\n * A handler that updates the text of a BPMN element.\n */\nfunction UpdateLabelHandler(modeling, textRenderer, bpmnFactory) {\n\n  /**\n   * Creates an empty `diLabel` attribute for embedded labels.\n   *\n   * @param {djs.model.Base} element\n   * @param {string} text\n   */\n  function ensureInternalLabelDi(element, text) {\n    if ((0,util_LabelUtil/* isLabelExternal */.ly)(element)) {\n      return;\n    }\n\n    var di = (0,ModelUtil/* getDi */.DN)(element);\n\n    if (text && !di.label) {\n      di.label = bpmnFactory.create('bpmndi:BPMNLabel');\n    }\n\n    if (!text && di.label) {\n      delete di.label;\n    }\n  }\n\n\n  /**\n   * Set the label and return the changed elements.\n   *\n   * Element parameter can be label itself or connection (i.e. sequence flow).\n   *\n   * @param {djs.model.Base} element\n   * @param {string} text\n   */\n  function setText(element, text) {\n\n    // external label if present\n    var label = element.label || element;\n\n    var labelTarget = element.labelTarget || element;\n\n    (0,LabelUtil/* setLabel */.l)(label, text, labelTarget !== label);\n\n    ensureInternalLabelDi(element, text);\n\n    return [ label, labelTarget ];\n  }\n\n  function preExecute(ctx) {\n    var element = ctx.element,\n        businessObject = element.businessObject,\n        newLabel = ctx.newLabel;\n\n    if (!(0,util_LabelUtil/* isLabel */.j_)(element)\n        && (0,util_LabelUtil/* isLabelExternal */.ly)(element)\n        && !(0,util_LabelUtil/* hasExternalLabel */.fF)(element)\n        && !UpdateLabelHandler_isEmptyText(newLabel)) {\n\n      // create label\n      var paddingTop = 7;\n\n      var labelCenter = (0,util_LabelUtil/* getExternalLabelMid */.qe)(element);\n\n      labelCenter = {\n        x: labelCenter.x,\n        y: labelCenter.y + paddingTop\n      };\n\n      modeling.createLabel(element, labelCenter, {\n        id: businessObject.id + '_label',\n        businessObject: businessObject,\n        di: element.di\n      });\n    }\n  }\n\n  function execute(ctx) {\n    ctx.oldLabel = (0,LabelUtil/* getLabel */.i)(ctx.element);\n    return setText(ctx.element, ctx.newLabel);\n  }\n\n  function revert(ctx) {\n    return setText(ctx.element, ctx.oldLabel);\n  }\n\n  function postExecute(ctx) {\n    var element = ctx.element,\n        label = element.label || element,\n        newLabel = ctx.newLabel,\n        newBounds = ctx.newBounds,\n        hints = ctx.hints || {};\n\n    // ignore internal labels for elements except text annotations\n    if (!(0,util_LabelUtil/* isLabel */.j_)(label) && !(0,ModelUtil.is)(label, 'bpmn:TextAnnotation')) {\n      return;\n    }\n\n    if ((0,util_LabelUtil/* isLabel */.j_)(label) && UpdateLabelHandler_isEmptyText(newLabel)) {\n\n      if (hints.removeShape !== false) {\n        modeling.removeShape(label, { unsetLabel: false });\n      }\n\n      return;\n    }\n\n    var text = (0,LabelUtil/* getLabel */.i)(label);\n\n    // resize element based on label _or_ pre-defined bounds\n    if (typeof newBounds === 'undefined') {\n      newBounds = textRenderer.getExternalLabelBounds(label, text);\n    }\n\n    // setting newBounds to false or _null_ will\n    // disable the postExecute resize operation\n    if (newBounds) {\n      modeling.resizeShape(label, newBounds, UpdateLabelHandler_NULL_DIMENSIONS);\n    }\n  }\n\n  // API\n\n  this.preExecute = preExecute;\n  this.execute = execute;\n  this.revert = revert;\n  this.postExecute = postExecute;\n}\n\nUpdateLabelHandler.$inject = [\n  'modeling',\n  'textRenderer',\n  'bpmnFactory'\n];\n\n\n// helpers ///////////////////////\n\nfunction UpdateLabelHandler_isEmptyText(label) {\n  return !label || !label.trim();\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/Modeling.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * BPMN 2.0 modeling features activator\n *\n * @param {EventBus} eventBus\n * @param {ElementFactory} elementFactory\n * @param {CommandStack} commandStack\n * @param {BpmnRules} bpmnRules\n */\nfunction Modeling_Modeling(\n    eventBus, elementFactory, commandStack,\n    bpmnRules) {\n\n  Modeling/* default.call */.Z.call(this, eventBus, elementFactory, commandStack);\n\n  this._bpmnRules = bpmnRules;\n}\n\n(0,index_es/* default */.Z)(Modeling_Modeling, Modeling/* default */.Z);\n\nModeling_Modeling.$inject = [\n  'eventBus',\n  'elementFactory',\n  'commandStack',\n  'bpmnRules'\n];\n\n\nModeling_Modeling.prototype.getHandlers = function() {\n  var handlers = Modeling/* default.prototype.getHandlers.call */.Z.prototype.getHandlers.call(this);\n\n  handlers['element.updateModdleProperties'] = UpdateModdlePropertiesHandler;\n  handlers['element.updateProperties'] = UpdatePropertiesHandler;\n  handlers['canvas.updateRoot'] = UpdateCanvasRootHandler;\n  handlers['lane.add'] = AddLaneHandler;\n  handlers['lane.resize'] = ResizeLaneHandler;\n  handlers['lane.split'] = SplitLaneHandler;\n  handlers['lane.updateRefs'] = UpdateFlowNodeRefsHandler;\n  handlers['id.updateClaim'] = IdClaimHandler;\n  handlers['element.setColor'] = SetColorHandler;\n  handlers['element.updateLabel'] = UpdateLabelHandler;\n\n  return handlers;\n};\n\n\nModeling_Modeling.prototype.updateLabel = function(element, newLabel, newBounds, hints) {\n  this._commandStack.execute('element.updateLabel', {\n    element: element,\n    newLabel: newLabel,\n    newBounds: newBounds,\n    hints: hints || {}\n  });\n};\n\n\nModeling_Modeling.prototype.connect = function(source, target, attrs, hints) {\n\n  var bpmnRules = this._bpmnRules;\n\n  if (!attrs) {\n    attrs = bpmnRules.canConnect(source, target);\n  }\n\n  if (!attrs) {\n    return;\n  }\n\n  return this.createConnection(source, target, attrs, source.parent, hints);\n};\n\n\nModeling_Modeling.prototype.updateModdleProperties = function(element, moddleElement, properties) {\n  this._commandStack.execute('element.updateModdleProperties', {\n    element: element,\n    moddleElement: moddleElement,\n    properties: properties\n  });\n};\n\nModeling_Modeling.prototype.updateProperties = function(element, properties) {\n  this._commandStack.execute('element.updateProperties', {\n    element: element,\n    properties: properties\n  });\n};\n\nModeling_Modeling.prototype.resizeLane = function(laneShape, newBounds, balanced) {\n  this._commandStack.execute('lane.resize', {\n    shape: laneShape,\n    newBounds: newBounds,\n    balanced: balanced\n  });\n};\n\nModeling_Modeling.prototype.addLane = function(targetLaneShape, location) {\n  var context = {\n    shape: targetLaneShape,\n    location: location\n  };\n\n  this._commandStack.execute('lane.add', context);\n\n  return context.newLane;\n};\n\nModeling_Modeling.prototype.splitLane = function(targetLane, count) {\n  this._commandStack.execute('lane.split', {\n    shape: targetLane,\n    count: count\n  });\n};\n\n/**\n * Transform the current diagram into a collaboration.\n *\n * @return {djs.model.Root} the new root element\n */\nModeling_Modeling.prototype.makeCollaboration = function() {\n\n  var collaborationElement = this._create('root', {\n    type: 'bpmn:Collaboration'\n  });\n\n  var context = {\n    newRoot: collaborationElement\n  };\n\n  this._commandStack.execute('canvas.updateRoot', context);\n\n  return collaborationElement;\n};\n\nModeling_Modeling.prototype.updateLaneRefs = function(flowNodeShapes, laneShapes) {\n\n  this._commandStack.execute('lane.updateRefs', {\n    flowNodeShapes: flowNodeShapes,\n    laneShapes: laneShapes\n  });\n};\n\n/**\n * Transform the current diagram into a process.\n *\n * @return {djs.model.Root} the new root element\n */\nModeling_Modeling.prototype.makeProcess = function() {\n\n  var processElement = this._create('root', {\n    type: 'bpmn:Process'\n  });\n\n  var context = {\n    newRoot: processElement\n  };\n\n  this._commandStack.execute('canvas.updateRoot', context);\n};\n\n\nModeling_Modeling.prototype.claimId = function(id, moddleElement) {\n  this._commandStack.execute('id.updateClaim', {\n    id: id,\n    element: moddleElement,\n    claiming: true\n  });\n};\n\n\nModeling_Modeling.prototype.unclaimId = function(id, moddleElement) {\n  this._commandStack.execute('id.updateClaim', {\n    id: id,\n    element: moddleElement\n  });\n};\n\nModeling_Modeling.prototype.setColor = function(elements, colors) {\n  if (!elements.length) {\n    elements = [ elements ];\n  }\n\n  this._commandStack.execute('element.setColor', {\n    elements: elements,\n    colors: colors\n  });\n};\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/BaseLayouter.js\nvar BaseLayouter = __webpack_require__(\"./node_modules/diagram-js/lib/layout/BaseLayouter.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/ManhattanLayout.js\nvar ManhattanLayout = __webpack_require__(\"./node_modules/diagram-js/lib/layout/ManhattanLayout.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/BpmnLayouter.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nvar ATTACH_ORIENTATION_PADDING = -10,\n    BOUNDARY_TO_HOST_THRESHOLD = 40;\n\nvar oppositeOrientationMapping = {\n  'top': 'bottom',\n  'top-right': 'bottom-left',\n  'top-left': 'bottom-right',\n  'right': 'left',\n  'bottom': 'top',\n  'bottom-right': 'top-left',\n  'bottom-left': 'top-right',\n  'left': 'right'\n};\n\nvar orientationDirectionMapping = {\n  top: 't',\n  right: 'r',\n  bottom: 'b',\n  left: 'l'\n};\n\n\nfunction BpmnLayouter() {}\n\n(0,index_es/* default */.Z)(BpmnLayouter, BaseLayouter/* default */.Z);\n\n\nBpmnLayouter.prototype.layoutConnection = function(connection, hints) {\n  if (!hints) {\n    hints = {};\n  }\n\n  var source = hints.source || connection.source,\n      target = hints.target || connection.target,\n      waypoints = hints.waypoints || connection.waypoints,\n      connectionStart = hints.connectionStart,\n      connectionEnd = hints.connectionEnd;\n\n  var manhattanOptions,\n      updatedWaypoints;\n\n  if (!connectionStart) {\n    connectionStart = getConnectionDocking(waypoints && waypoints[ 0 ], source);\n  }\n\n  if (!connectionEnd) {\n    connectionEnd = getConnectionDocking(waypoints && waypoints[ waypoints.length - 1 ], target);\n  }\n\n  // TODO(nikku): support vertical modeling\n  // and invert preferredLayouts accordingly\n\n  if ((0,ModelUtil.is)(connection, 'bpmn:Association') ||\n      (0,ModelUtil.is)(connection, 'bpmn:DataAssociation')) {\n\n    if (waypoints && !isCompensationAssociation(source, target)) {\n      return [].concat([ connectionStart ], waypoints.slice(1, -1), [ connectionEnd ]);\n    }\n  }\n\n  if ((0,ModelUtil.is)(connection, 'bpmn:MessageFlow')) {\n    manhattanOptions = getMessageFlowManhattanOptions(source, target);\n  } else if ((0,ModelUtil.is)(connection, 'bpmn:SequenceFlow') || isCompensationAssociation(source, target)) {\n\n    // layout all connection between flow elements h:h, except for\n    // (1) outgoing of boundary events -> layout based on attach orientation and target orientation\n    // (2) incoming/outgoing of gateways -> v:h for outgoing, h:v for incoming\n    // (3) loops\n    if (source === target) {\n      manhattanOptions = {\n        preferredLayouts: getLoopPreferredLayout(source, connection)\n      };\n    } else if ((0,ModelUtil.is)(source, 'bpmn:BoundaryEvent')) {\n      manhattanOptions = {\n        preferredLayouts: getBoundaryEventPreferredLayouts(source, target, connectionEnd)\n      };\n    } else if (BpmnLayouter_isExpandedSubProcess(source) || BpmnLayouter_isExpandedSubProcess(target)) {\n      manhattanOptions = getSubProcessManhattanOptions(source);\n    } else if ((0,ModelUtil.is)(source, 'bpmn:Gateway')) {\n      manhattanOptions = {\n        preferredLayouts: [ 'v:h' ]\n      };\n    } else if ((0,ModelUtil.is)(target, 'bpmn:Gateway')) {\n      manhattanOptions = {\n        preferredLayouts: [ 'h:v' ]\n      };\n    } else {\n      manhattanOptions = {\n        preferredLayouts: [ 'h:h' ]\n      };\n    }\n  }\n\n  if (manhattanOptions) {\n    manhattanOptions = (0,dist_index_esm/* assign */.f0)(manhattanOptions, hints);\n\n    updatedWaypoints = (0,ManhattanLayout/* withoutRedundantPoints */.Fb)((0,ManhattanLayout/* repairConnection */.ju)(\n      source,\n      target,\n      connectionStart,\n      connectionEnd,\n      waypoints,\n      manhattanOptions\n    ));\n  }\n\n  return updatedWaypoints || [ connectionStart, connectionEnd ];\n};\n\n\n// helpers //////////\n\nfunction getAttachOrientation(attachedElement) {\n  var hostElement = attachedElement.host;\n\n  return (0,LayoutUtil/* getOrientation */.T8)((0,LayoutUtil/* getMid */.wS)(attachedElement), hostElement, ATTACH_ORIENTATION_PADDING);\n}\n\nfunction getMessageFlowManhattanOptions(source, target) {\n  return {\n    preferredLayouts: [ 'straight', 'v:v' ],\n    preserveDocking: getMessageFlowPreserveDocking(source, target)\n  };\n}\n\nfunction getMessageFlowPreserveDocking(source, target) {\n\n  // (1) docking element connected to participant has precedence\n  if ((0,ModelUtil.is)(target, 'bpmn:Participant')) {\n    return 'source';\n  }\n\n  if ((0,ModelUtil.is)(source, 'bpmn:Participant')) {\n    return 'target';\n  }\n\n  // (2) docking element connected to expanded sub-process has precedence\n  if (BpmnLayouter_isExpandedSubProcess(target)) {\n    return 'source';\n  }\n\n  if (BpmnLayouter_isExpandedSubProcess(source)) {\n    return 'target';\n  }\n\n  // (3) docking event has precedence\n  if ((0,ModelUtil.is)(target, 'bpmn:Event')) {\n    return 'target';\n  }\n\n  if ((0,ModelUtil.is)(source, 'bpmn:Event')) {\n    return 'source';\n  }\n\n  return null;\n}\n\nfunction getSubProcessManhattanOptions(source) {\n  return {\n    preferredLayouts: [ 'straight', 'h:h' ],\n    preserveDocking: getSubProcessPreserveDocking(source)\n  };\n}\n\nfunction getSubProcessPreserveDocking(source) {\n  return BpmnLayouter_isExpandedSubProcess(source) ? 'target' : 'source';\n}\n\nfunction getConnectionDocking(point, shape) {\n  return point ? (point.original || point) : (0,LayoutUtil/* getMid */.wS)(shape);\n}\n\nfunction isCompensationAssociation(source, target) {\n  return (0,ModelUtil.is)(target, 'bpmn:Activity') &&\n    (0,ModelUtil.is)(source, 'bpmn:BoundaryEvent') &&\n    target.businessObject.isForCompensation;\n}\n\nfunction BpmnLayouter_isExpandedSubProcess(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:SubProcess') && (0,DiUtil/* isExpanded */.ul)(element);\n}\n\nfunction BpmnLayouter_isSame(a, b) {\n  return a === b;\n}\n\nfunction isAnyOrientation(orientation, orientations) {\n  return orientations.indexOf(orientation) !== -1;\n}\n\nfunction getHorizontalOrientation(orientation) {\n  var matches = /right|left/.exec(orientation);\n\n  return matches && matches[0];\n}\n\nfunction getVerticalOrientation(orientation) {\n  var matches = /top|bottom/.exec(orientation);\n\n  return matches && matches[0];\n}\n\nfunction isOppositeOrientation(a, b) {\n  return oppositeOrientationMapping[a] === b;\n}\n\nfunction isOppositeHorizontalOrientation(a, b) {\n  var horizontalOrientation = getHorizontalOrientation(a);\n\n  var oppositeHorizontalOrientation = oppositeOrientationMapping[horizontalOrientation];\n\n  return b.indexOf(oppositeHorizontalOrientation) !== -1;\n}\n\nfunction isOppositeVerticalOrientation(a, b) {\n  var verticalOrientation = getVerticalOrientation(a);\n\n  var oppositeVerticalOrientation = oppositeOrientationMapping[verticalOrientation];\n\n  return b.indexOf(oppositeVerticalOrientation) !== -1;\n}\n\nfunction isHorizontalOrientation(orientation) {\n  return orientation === 'right' || orientation === 'left';\n}\n\nfunction getLoopPreferredLayout(source, connection) {\n  var waypoints = connection.waypoints;\n\n  var orientation = waypoints && waypoints.length && (0,LayoutUtil/* getOrientation */.T8)(waypoints[0], source);\n\n  if (orientation === 'top') {\n    return [ 't:r' ];\n  } else if (orientation === 'right') {\n    return [ 'r:b' ];\n  } else if (orientation === 'left') {\n    return [ 'l:t' ];\n  }\n\n  return [ 'b:l' ];\n}\n\nfunction getBoundaryEventPreferredLayouts(source, target, end) {\n  var sourceMid = (0,LayoutUtil/* getMid */.wS)(source),\n      targetMid = (0,LayoutUtil/* getMid */.wS)(target),\n      attachOrientation = getAttachOrientation(source),\n      sourceLayout,\n      targetLayout;\n\n  var isLoop = BpmnLayouter_isSame(source.host, target);\n\n  var attachedToSide = isAnyOrientation(attachOrientation, [ 'top', 'right', 'bottom', 'left' ]);\n\n  var targetOrientation = (0,LayoutUtil/* getOrientation */.T8)(targetMid, sourceMid, {\n    x: source.width / 2 + target.width / 2,\n    y: source.height / 2 + target.height / 2\n  });\n\n  if (isLoop) {\n    return getBoundaryEventLoopLayout(attachOrientation, attachedToSide, source, target, end);\n  }\n\n  // source layout\n  sourceLayout = getBoundaryEventSourceLayout(attachOrientation, targetOrientation, attachedToSide);\n\n  // target layout\n  targetLayout = getBoundaryEventTargetLayout(attachOrientation, targetOrientation, attachedToSide);\n\n  return [ sourceLayout + ':' + targetLayout ];\n}\n\nfunction getBoundaryEventLoopLayout(attachOrientation, attachedToSide, source, target, end) {\n  var orientation = attachedToSide ? attachOrientation : getVerticalOrientation(attachOrientation),\n      sourceLayout = orientationDirectionMapping[ orientation ],\n      targetLayout;\n\n  if (attachedToSide) {\n    if (isHorizontalOrientation(attachOrientation)) {\n      targetLayout = shouldConnectToSameSide('y', source, target, end) ? 'h' : 'b';\n    } else {\n      targetLayout = shouldConnectToSameSide('x', source, target, end) ? 'v' : 'l';\n    }\n  } else {\n    targetLayout = 'v';\n  }\n\n  return [ sourceLayout + ':' + targetLayout ];\n}\n\nfunction shouldConnectToSameSide(axis, source, target, end) {\n  var threshold = BOUNDARY_TO_HOST_THRESHOLD;\n\n  return !(\n    areCloseOnAxis(axis, end, target, threshold) ||\n    areCloseOnAxis(axis, end, {\n      x: target.x + target.width,\n      y: target.y + target.height\n    }, threshold) ||\n    areCloseOnAxis(axis, end, (0,LayoutUtil/* getMid */.wS)(source), threshold)\n  );\n}\n\nfunction areCloseOnAxis(axis, a, b, threshold) {\n  return Math.abs(a[ axis ] - b[ axis ]) < threshold;\n}\n\nfunction getBoundaryEventSourceLayout(attachOrientation, targetOrientation, attachedToSide) {\n\n  // attached to either top, right, bottom or left side\n  if (attachedToSide) {\n    return orientationDirectionMapping[ attachOrientation ];\n  }\n\n  // attached to either top-right, top-left, bottom-right or bottom-left corner\n\n  // same vertical or opposite horizontal orientation\n  if (BpmnLayouter_isSame(\n    getVerticalOrientation(attachOrientation), getVerticalOrientation(targetOrientation)\n  ) || isOppositeOrientation(\n    getHorizontalOrientation(attachOrientation), getHorizontalOrientation(targetOrientation)\n  )) {\n    return orientationDirectionMapping[ getVerticalOrientation(attachOrientation) ];\n  }\n\n  // fallback\n  return orientationDirectionMapping[ getHorizontalOrientation(attachOrientation) ];\n}\n\nfunction getBoundaryEventTargetLayout(attachOrientation, targetOrientation, attachedToSide) {\n\n  // attached to either top, right, bottom or left side\n  if (attachedToSide) {\n    if (isHorizontalOrientation(attachOrientation)) {\n\n      // orientation is right or left\n\n      // opposite horizontal orientation or same orientation\n      if (\n        isOppositeHorizontalOrientation(attachOrientation, targetOrientation) ||\n        BpmnLayouter_isSame(attachOrientation, targetOrientation)\n      ) {\n        return 'h';\n      }\n\n      // fallback\n      return 'v';\n    } else {\n\n      // orientation is top or bottom\n\n      // opposite vertical orientation or same orientation\n      if (\n        isOppositeVerticalOrientation(attachOrientation, targetOrientation) ||\n        BpmnLayouter_isSame(attachOrientation, targetOrientation)\n      ) {\n        return 'v';\n      }\n\n      // fallback\n      return 'h';\n    }\n  }\n\n  // attached to either top-right, top-left, bottom-right or bottom-left corner\n\n  // orientation is right, left\n  // or same vertical orientation but also right or left\n  if (isHorizontalOrientation(targetOrientation) ||\n    (BpmnLayouter_isSame(getVerticalOrientation(attachOrientation), getVerticalOrientation(targetOrientation)) &&\n      getHorizontalOrientation(targetOrientation))) {\n    return 'h';\n  } else {\n    return 'v';\n  }\n}\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/CroppingConnectionDocking.js\nvar CroppingConnectionDocking = __webpack_require__(\"./node_modules/diagram-js/lib/layout/CroppingConnectionDocking.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/modeling/index.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const modeling = ({\n  __init__: [\n    'modeling',\n    'bpmnUpdater'\n  ],\n  __depends__: [\n    modeling_behavior,\n    features_rules,\n    di_ordering,\n    ordering,\n    features_replace,\n    command/* default */.Z,\n    tooltips/* default */.Z,\n    label_support/* default */.Z,\n    attach_support/* default */.Z,\n    selection/* default */.Z,\n    change_support/* default */.Z,\n    features_space_tool\n  ],\n  bpmnFactory: [ 'type', BpmnFactory ],\n  bpmnUpdater: [ 'type', BpmnUpdater ],\n  elementFactory: [ 'type', ElementFactory_ElementFactory ],\n  modeling: [ 'type', Modeling_Modeling ],\n  layouter: [ 'type', BpmnLayouter ],\n  connectionDocking: [ 'type', CroppingConnectionDocking/* default */.Z ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/move/index.js + 2 modules\nvar move = __webpack_require__(\"./node_modules/diagram-js/lib/features/move/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/palette/index.js + 1 modules\nvar palette = __webpack_require__(\"./node_modules/diagram-js/lib/features/palette/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/lasso-tool/index.js + 1 modules\nvar lasso_tool = __webpack_require__(\"./node_modules/diagram-js/lib/features/lasso-tool/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/hand-tool/index.js + 1 modules\nvar hand_tool = __webpack_require__(\"./node_modules/diagram-js/lib/features/hand-tool/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/global-connect/index.js + 1 modules\nvar global_connect = __webpack_require__(\"./node_modules/diagram-js/lib/features/global-connect/index.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/palette/PaletteProvider.js\n\n\n\n\n/**\n * A palette provider for BPMN 2.0 elements.\n */\nfunction PaletteProvider(\n    palette, create, elementFactory,\n    spaceTool, lassoTool, handTool,\n    globalConnect, translate) {\n\n  this._palette = palette;\n  this._create = create;\n  this._elementFactory = elementFactory;\n  this._spaceTool = spaceTool;\n  this._lassoTool = lassoTool;\n  this._handTool = handTool;\n  this._globalConnect = globalConnect;\n  this._translate = translate;\n\n  palette.registerProvider(this);\n}\n\nPaletteProvider.$inject = [\n  'palette',\n  'create',\n  'elementFactory',\n  'spaceTool',\n  'lassoTool',\n  'handTool',\n  'globalConnect',\n  'translate'\n];\n\n\nPaletteProvider.prototype.getPaletteEntries = function(element) {\n\n  var actions = {},\n      create = this._create,\n      elementFactory = this._elementFactory,\n      spaceTool = this._spaceTool,\n      lassoTool = this._lassoTool,\n      handTool = this._handTool,\n      globalConnect = this._globalConnect,\n      translate = this._translate;\n\n  function createAction(type, group, className, title, options) {\n\n    function createListener(event) {\n      var shape = elementFactory.createShape((0,dist_index_esm/* assign */.f0)({ type: type }, options));\n\n      if (options) {\n        var di = (0,ModelUtil/* getDi */.DN)(shape);\n        di.isExpanded = options.isExpanded;\n      }\n\n      create.start(event, shape);\n    }\n\n    var shortType = type.replace(/^bpmn:/, '');\n\n    return {\n      group: group,\n      className: className,\n      title: title || translate('Create {type}', { type: shortType }),\n      action: {\n        dragstart: createListener,\n        click: createListener\n      }\n    };\n  }\n\n  function createSubprocess(event) {\n    var subProcess = elementFactory.createShape({\n      type: 'bpmn:SubProcess',\n      x: 0,\n      y: 0,\n      isExpanded: true\n    });\n\n    var startEvent = elementFactory.createShape({\n      type: 'bpmn:StartEvent',\n      x: 40,\n      y: 82,\n      parent: subProcess\n    });\n\n    create.start(event, [ subProcess, startEvent ], {\n      hints: {\n        autoSelect: [ subProcess ]\n      }\n    });\n  }\n\n  function createParticipant(event) {\n    create.start(event, elementFactory.createParticipantShape());\n  }\n\n  (0,dist_index_esm/* assign */.f0)(actions, {\n    'hand-tool': {\n      group: 'tools',\n      className: 'bpmn-icon-hand-tool',\n      title: translate('Activate the hand tool'),\n      action: {\n        click: function(event) {\n          handTool.activateHand(event);\n        }\n      }\n    },\n    'lasso-tool': {\n      group: 'tools',\n      className: 'bpmn-icon-lasso-tool',\n      title: translate('Activate the lasso tool'),\n      action: {\n        click: function(event) {\n          lassoTool.activateSelection(event);\n        }\n      }\n    },\n    'space-tool': {\n      group: 'tools',\n      className: 'bpmn-icon-space-tool',\n      title: translate('Activate the create/remove space tool'),\n      action: {\n        click: function(event) {\n          spaceTool.activateSelection(event);\n        }\n      }\n    },\n    'global-connect-tool': {\n      group: 'tools',\n      className: 'bpmn-icon-connection-multi',\n      title: translate('Activate the global connect tool'),\n      action: {\n        click: function(event) {\n          globalConnect.start(event);\n        }\n      }\n    },\n    'tool-separator': {\n      group: 'tools',\n      separator: true\n    },\n    'create.start-event': createAction(\n      'bpmn:StartEvent', 'event', 'bpmn-icon-start-event-none',\n      translate('Create StartEvent')\n    ),\n    'create.intermediate-event': createAction(\n      'bpmn:IntermediateThrowEvent', 'event', 'bpmn-icon-intermediate-event-none',\n      translate('Create Intermediate/Boundary Event')\n    ),\n    'create.end-event': createAction(\n      'bpmn:EndEvent', 'event', 'bpmn-icon-end-event-none',\n      translate('Create EndEvent')\n    ),\n    'create.exclusive-gateway': createAction(\n      'bpmn:ExclusiveGateway', 'gateway', 'bpmn-icon-gateway-none',\n      translate('Create Gateway')\n    ),\n    'create.task': createAction(\n      'bpmn:Task', 'activity', 'bpmn-icon-task',\n      translate('Create Task')\n    ),\n    'create.data-object': createAction(\n      'bpmn:DataObjectReference', 'data-object', 'bpmn-icon-data-object',\n      translate('Create DataObjectReference')\n    ),\n    'create.data-store': createAction(\n      'bpmn:DataStoreReference', 'data-store', 'bpmn-icon-data-store',\n      translate('Create DataStoreReference')\n    ),\n    'create.subprocess-expanded': {\n      group: 'activity',\n      className: 'bpmn-icon-subprocess-expanded',\n      title: translate('Create expanded SubProcess'),\n      action: {\n        dragstart: createSubprocess,\n        click: createSubprocess\n      }\n    },\n    'create.participant-expanded': {\n      group: 'collaboration',\n      className: 'bpmn-icon-participant',\n      title: translate('Create Pool/Participant'),\n      action: {\n        dragstart: createParticipant,\n        click: createParticipant\n      }\n    },\n    'create.group': createAction(\n      'bpmn:Group', 'artifact', 'bpmn-icon-group',\n      translate('Create Group')\n    ),\n  });\n\n  return actions;\n};\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/palette/index.js\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const features_palette = ({\n  __depends__: [\n    palette/* default */.Z,\n    create/* default */.Z,\n    features_space_tool,\n    lasso_tool/* default */.Z,\n    hand_tool/* default */.Z,\n    global_connect/* default */.Z,\n    translate/* default */.Z\n  ],\n  __init__: [ 'paletteProvider' ],\n  paletteProvider: [ 'type', PaletteProvider ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/preview-support/index.js + 1 modules\nvar preview_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/preview-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/css.escape/css.escape.js\nvar css_escape = __webpack_require__(\"./node_modules/css.escape/css.escape.js\");\nvar css_escape_default = /*#__PURE__*/__webpack_require__.n(css_escape);\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar min_dom_dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/replace-preview/BpmnReplacePreview.js\n\n\n\n\n\n\n\n\n\n\n\n\nvar BpmnReplacePreview_LOW_PRIORITY = 250;\n\n\nfunction BpmnReplacePreview(\n    eventBus, elementRegistry, elementFactory,\n    canvas, previewSupport) {\n\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  /**\n   * Replace the visuals of all elements in the context which can be replaced\n   *\n   * @param  {Object} context\n   */\n  function replaceVisual(context) {\n\n    var replacements = context.canExecute.replacements;\n\n    (0,dist_index_esm/* forEach */.Ed)(replacements, function(replacement) {\n\n      var id = replacement.oldElementId;\n\n      var newElement = {\n        type: replacement.newElementType\n      };\n\n      // if the visual of the element is already replaced\n      if (context.visualReplacements[id]) {\n        return;\n      }\n\n      var element = elementRegistry.get(id);\n\n      (0,dist_index_esm/* assign */.f0)(newElement, { x: element.x, y: element.y });\n\n      // create a temporary shape\n      var tempShape = elementFactory.createShape(newElement);\n\n      canvas.addShape(tempShape, element.parent);\n\n      // select the original SVG element related to the element and hide it\n      var gfx = (0,min_dom_dist_index_esm/* query */.IO)('[data-element-id=\"' + css_escape_default()(element.id) + '\"]', context.dragGroup);\n\n      if (gfx) {\n        (0,tiny_svg_dist_index_esm/* attr */.Lj)(gfx, { display: 'none' });\n      }\n\n      // clone the gfx of the temporary shape and add it to the drag group\n      var dragger = previewSupport.addDragger(tempShape, context.dragGroup);\n\n      context.visualReplacements[id] = dragger;\n\n      canvas.removeShape(tempShape);\n    });\n  }\n\n  /**\n   * Restore the original visuals of the previously replaced elements\n   *\n   * @param  {Object} context\n   */\n  function restoreVisual(context) {\n\n    var visualReplacements = context.visualReplacements;\n\n    (0,dist_index_esm/* forEach */.Ed)(visualReplacements, function(dragger, id) {\n\n      var originalGfx = (0,min_dom_dist_index_esm/* query */.IO)('[data-element-id=\"' + css_escape_default()(id) + '\"]', context.dragGroup);\n\n      if (originalGfx) {\n        (0,tiny_svg_dist_index_esm/* attr */.Lj)(originalGfx, { display: 'inline' });\n      }\n\n      dragger.remove();\n\n      if (visualReplacements[id]) {\n        delete visualReplacements[id];\n      }\n    });\n  }\n\n  eventBus.on('shape.move.move', BpmnReplacePreview_LOW_PRIORITY, function(event) {\n\n    var context = event.context,\n        canExecute = context.canExecute;\n\n    if (!context.visualReplacements) {\n      context.visualReplacements = {};\n    }\n\n    if (canExecute && canExecute.replacements) {\n      replaceVisual(context);\n    } else {\n      restoreVisual(context);\n    }\n  });\n}\n\nBpmnReplacePreview.$inject = [\n  'eventBus',\n  'elementRegistry',\n  'elementFactory',\n  'canvas',\n  'previewSupport'\n];\n\n(0,index_es/* default */.Z)(BpmnReplacePreview, CommandInterceptor/* default */.Z);\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/replace-preview/index.js\n\n\n\n\n/* harmony default export */ const replace_preview = ({\n  __depends__: [\n    preview_support/* default */.Z\n  ],\n  __init__: [ 'bpmnReplacePreview' ],\n  bpmnReplacePreview: [ 'type', BpmnReplacePreview ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\nvar SnapUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/SnapUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\nvar KeyboardUtil = __webpack_require__(\"./node_modules/diagram-js/lib/features/keyboard/KeyboardUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/snapping/BpmnConnectSnapping.js\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nvar BpmnConnectSnapping_HIGHER_PRIORITY = 1250;\r\n\r\nvar BpmnConnectSnapping_BOUNDARY_TO_HOST_THRESHOLD = 40;\r\n\r\nvar TARGET_BOUNDS_PADDING = 20,\r\n    TASK_BOUNDS_PADDING = 10;\r\n\r\nvar TARGET_CENTER_PADDING = 20;\r\n\r\nvar AXES = [ 'x', 'y' ];\r\n\r\nvar BpmnConnectSnapping_abs = Math.abs;\r\n\r\n/**\r\n * Snap during connect.\r\n *\r\n * @param {EventBus} eventBus\r\n */\r\nfunction BpmnConnectSnapping(eventBus) {\r\n  eventBus.on([\r\n    'connect.hover',\r\n    'connect.move',\r\n    'connect.end',\r\n  ], BpmnConnectSnapping_HIGHER_PRIORITY, function(event) {\r\n    var context = event.context,\r\n        canExecute = context.canExecute,\r\n        start = context.start,\r\n        hover = context.hover,\r\n        source = context.source,\r\n        target = context.target;\r\n\r\n    // do NOT snap on CMD\r\n    if (event.originalEvent && (0,KeyboardUtil/* isCmd */.JS)(event.originalEvent)) {\r\n      return;\r\n    }\r\n\r\n    if (!context.initialConnectionStart) {\r\n      context.initialConnectionStart = context.connectionStart;\r\n    }\r\n\r\n    // snap hover\r\n    if (canExecute && hover) {\r\n      snapToShape(event, hover, getTargetBoundsPadding(hover));\r\n    }\r\n\r\n    if (hover && isAnyType(canExecute, [\r\n      'bpmn:Association',\r\n      'bpmn:DataInputAssociation',\r\n      'bpmn:DataOutputAssociation',\r\n      'bpmn:SequenceFlow'\r\n    ])) {\r\n      context.connectionStart = (0,SnapUtil/* mid */.Pi)(start);\r\n\r\n      // snap hover\r\n      if ((0,ModelUtil/* isAny */.JZ)(hover, [ 'bpmn:Event', 'bpmn:Gateway' ])) {\r\n        snapToPosition(event, (0,SnapUtil/* mid */.Pi)(hover));\r\n      }\r\n\r\n      // snap hover\r\n      if ((0,ModelUtil/* isAny */.JZ)(hover, [ 'bpmn:Task', 'bpmn:SubProcess' ])) {\r\n        snapToTargetMid(event, hover);\r\n      }\r\n\r\n      // snap source and target\r\n      if ((0,ModelUtil.is)(source, 'bpmn:BoundaryEvent') && target === source.host) {\r\n        snapBoundaryEventLoop(event);\r\n      }\r\n\r\n    } else if (isType(canExecute, 'bpmn:MessageFlow')) {\r\n\r\n      if ((0,ModelUtil.is)(start, 'bpmn:Event')) {\r\n\r\n        // snap start\r\n        context.connectionStart = (0,SnapUtil/* mid */.Pi)(start);\r\n      }\r\n\r\n      if ((0,ModelUtil.is)(hover, 'bpmn:Event')) {\r\n\r\n        // snap hover\r\n        snapToPosition(event, (0,SnapUtil/* mid */.Pi)(hover));\r\n      }\r\n\r\n    } else {\r\n\r\n      // un-snap source\r\n      context.connectionStart = context.initialConnectionStart;\r\n    }\r\n  });\r\n}\r\n\r\nBpmnConnectSnapping.$inject = [ 'eventBus' ];\r\n\r\n\r\n// helpers //////////\r\n\r\n// snap to target if event in target\r\nfunction snapToShape(event, target, padding) {\r\n  AXES.forEach(function(axis) {\r\n    var dimensionForAxis = getDimensionForAxis(axis, target);\r\n\r\n    if (event[ axis ] < target[ axis ] + padding) {\r\n      (0,SnapUtil/* setSnapped */.U)(event, axis, target[ axis ] + padding);\r\n    } else if (event[ axis ] > target[ axis ] + dimensionForAxis - padding) {\r\n      (0,SnapUtil/* setSnapped */.U)(event, axis, target[ axis ] + dimensionForAxis - padding);\r\n    }\r\n  });\r\n}\r\n\r\n// snap to target mid if event in target mid\r\nfunction snapToTargetMid(event, target) {\r\n  var targetMid = (0,SnapUtil/* mid */.Pi)(target);\r\n\r\n  AXES.forEach(function(axis) {\r\n    if (isMid(event, target, axis)) {\r\n      (0,SnapUtil/* setSnapped */.U)(event, axis, targetMid[ axis ]);\r\n    }\r\n  });\r\n}\r\n\r\n// snap to prevent loop overlapping boundary event\r\nfunction snapBoundaryEventLoop(event) {\r\n  var context = event.context,\r\n      source = context.source,\r\n      target = context.target;\r\n\r\n  if (isReverse(context)) {\r\n    return;\r\n  }\r\n\r\n  var sourceMid = (0,SnapUtil/* mid */.Pi)(source),\r\n      orientation = (0,LayoutUtil/* getOrientation */.T8)(sourceMid, target, -10),\r\n      axes = [];\r\n\r\n  if (/top|bottom/.test(orientation)) {\r\n    axes.push('x');\r\n  }\r\n\r\n  if (/left|right/.test(orientation)) {\r\n    axes.push('y');\r\n  }\r\n\r\n  axes.forEach(function(axis) {\r\n    var coordinate = event[ axis ], newCoordinate;\r\n\r\n    if (BpmnConnectSnapping_abs(coordinate - sourceMid[ axis ]) < BpmnConnectSnapping_BOUNDARY_TO_HOST_THRESHOLD) {\r\n      if (coordinate > sourceMid[ axis ]) {\r\n        newCoordinate = sourceMid[ axis ] + BpmnConnectSnapping_BOUNDARY_TO_HOST_THRESHOLD;\r\n      }\r\n      else {\r\n        newCoordinate = sourceMid[ axis ] - BpmnConnectSnapping_BOUNDARY_TO_HOST_THRESHOLD;\r\n      }\r\n\r\n      (0,SnapUtil/* setSnapped */.U)(event, axis, newCoordinate);\r\n    }\r\n  });\r\n}\r\n\r\nfunction snapToPosition(event, position) {\r\n  (0,SnapUtil/* setSnapped */.U)(event, 'x', position.x);\r\n  (0,SnapUtil/* setSnapped */.U)(event, 'y', position.y);\r\n}\r\n\r\nfunction isType(attrs, type) {\r\n  return attrs && attrs.type === type;\r\n}\r\n\r\nfunction isAnyType(attrs, types) {\r\n  return (0,dist_index_esm/* some */.G)(types, function(type) {\r\n    return isType(attrs, type);\r\n  });\r\n}\r\n\r\nfunction getDimensionForAxis(axis, element) {\r\n  return axis === 'x' ? element.width : element.height;\r\n}\r\n\r\nfunction getTargetBoundsPadding(target) {\r\n  if ((0,ModelUtil.is)(target, 'bpmn:Task')) {\r\n    return TASK_BOUNDS_PADDING;\r\n  } else {\r\n    return TARGET_BOUNDS_PADDING;\r\n  }\r\n}\r\n\r\nfunction isMid(event, target, axis) {\r\n  return event[ axis ] > target[ axis ] + TARGET_CENTER_PADDING\r\n    && event[ axis ] < target[ axis ] + getDimensionForAxis(axis, target) - TARGET_CENTER_PADDING;\r\n}\r\n\r\nfunction isReverse(context) {\r\n  var hover = context.hover,\r\n      source = context.source;\r\n\r\n  return hover && source && hover === source;\r\n}\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js\nvar CreateMoveSnapping = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/CreateMoveSnapping.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/snapping/BpmnCreateMoveSnapping.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nvar BpmnCreateMoveSnapping_HIGH_PRIORITY = 1500;\n\n\n/**\n * Snap during create and move.\n *\n * @param {EventBus} eventBus\n * @param {Injector} injector\n */\nfunction BpmnCreateMoveSnapping(eventBus, injector) {\n  injector.invoke(CreateMoveSnapping/* default */.Z, this);\n\n  // creating first participant\n  eventBus.on([ 'create.move', 'create.end' ], BpmnCreateMoveSnapping_HIGH_PRIORITY, setSnappedIfConstrained);\n\n  // snap boundary events\n  eventBus.on([\n    'create.move',\n    'create.end',\n    'shape.move.move',\n    'shape.move.end'\n  ], BpmnCreateMoveSnapping_HIGH_PRIORITY, function(event) {\n    var context = event.context,\n        canExecute = context.canExecute,\n        target = context.target;\n\n    var canAttach = canExecute && (canExecute === 'attach' || canExecute.attach);\n\n    if (canAttach && !(0,SnapUtil/* isSnapped */.Wn)(event)) {\n      snapBoundaryEvent(event, target);\n    }\n  });\n}\n\n(0,index_es/* default */.Z)(BpmnCreateMoveSnapping, CreateMoveSnapping/* default */.Z);\n\nBpmnCreateMoveSnapping.$inject = [\n  'eventBus',\n  'injector'\n];\n\nBpmnCreateMoveSnapping.prototype.initSnap = function(event) {\n  var snapContext = CreateMoveSnapping/* default.prototype.initSnap.call */.Z.prototype.initSnap.call(this, event);\n\n  var shape = event.shape;\n\n  var isMove = !!this._elementRegistry.get(shape.id);\n\n  // snap to docking points\n  (0,dist_index_esm/* forEach */.Ed)(shape.outgoing, function(connection) {\n    var docking = connection.waypoints[0];\n\n    docking = docking.original || docking;\n\n    snapContext.setSnapOrigin(connection.id + '-docking', getDockingSnapOrigin(docking, isMove, event));\n  });\n\n  (0,dist_index_esm/* forEach */.Ed)(shape.incoming, function(connection) {\n    var docking = connection.waypoints[connection.waypoints.length - 1];\n\n    docking = docking.original || docking;\n\n    snapContext.setSnapOrigin(connection.id + '-docking', getDockingSnapOrigin(docking, isMove, event));\n  });\n\n  if ((0,ModelUtil.is)(shape, 'bpmn:Participant')) {\n\n    // snap to borders with higher priority\n    snapContext.setSnapLocations([ 'top-left', 'bottom-right', 'mid' ]);\n  }\n\n  return snapContext;\n};\n\nBpmnCreateMoveSnapping.prototype.addSnapTargetPoints = function(snapPoints, shape, target) {\n  CreateMoveSnapping/* default.prototype.addSnapTargetPoints.call */.Z.prototype.addSnapTargetPoints.call(this, snapPoints, shape, target);\n\n  var snapTargets = this.getSnapTargets(shape, target);\n\n  (0,dist_index_esm/* forEach */.Ed)(snapTargets, function(snapTarget) {\n\n    // handle TRBL alignment\n    //\n    // * with container elements\n    // * with text annotations\n    if (isContainer(snapTarget) || areAll([ shape, snapTarget ], 'bpmn:TextAnnotation')) {\n      snapPoints.add('top-left', (0,SnapUtil/* topLeft */.w3)(snapTarget));\n      snapPoints.add('bottom-right', (0,SnapUtil/* bottomRight */.hT)(snapTarget));\n    }\n  });\n\n  var elementRegistry = this._elementRegistry;\n\n  // snap to docking points if not create mode\n  (0,dist_index_esm/* forEach */.Ed)(shape.incoming, function(connection) {\n    if (elementRegistry.get(shape.id)) {\n\n      if (!BpmnCreateMoveSnapping_includes(snapTargets, connection.source)) {\n        snapPoints.add('mid', (0,LayoutUtil/* getMid */.wS)(connection.source));\n      }\n\n      var docking = connection.waypoints[0];\n      snapPoints.add(connection.id + '-docking', docking.original || docking);\n    }\n  });\n\n  (0,dist_index_esm/* forEach */.Ed)(shape.outgoing, function(connection) {\n    if (elementRegistry.get(shape.id)) {\n\n      if (!BpmnCreateMoveSnapping_includes(snapTargets, connection.target)) {\n        snapPoints.add('mid', (0,LayoutUtil/* getMid */.wS)(connection.target));\n      }\n\n      var docking = connection.waypoints[ connection.waypoints.length - 1 ];\n\n      snapPoints.add(connection.id + '-docking', docking.original || docking);\n    }\n  });\n\n  // add sequence flow parents as snap targets\n  if ((0,ModelUtil.is)(target, 'bpmn:SequenceFlow')) {\n    snapPoints = this.addSnapTargetPoints(snapPoints, shape, target.parent);\n  }\n\n  return snapPoints;\n};\n\nBpmnCreateMoveSnapping.prototype.getSnapTargets = function(shape, target) {\n  return CreateMoveSnapping/* default.prototype.getSnapTargets.call */.Z.prototype.getSnapTargets.call(this, shape, target)\n    .filter(function(snapTarget) {\n\n      // do not snap to lanes\n      return !(0,ModelUtil.is)(snapTarget, 'bpmn:Lane');\n    });\n};\n\n// helpers //////////\n\nfunction snapBoundaryEvent(event, target) {\n  var targetTRBL = (0,LayoutUtil/* asTRBL */.JA)(target);\n\n  var direction = getBoundaryAttachment(event, target);\n\n  var context = event.context,\n      shape = context.shape;\n\n  var offset;\n\n  if (shape.parent) {\n    offset = { x: 0, y: 0 };\n  } else {\n    offset = (0,LayoutUtil/* getMid */.wS)(shape);\n  }\n\n  if (/top/.test(direction)) {\n    (0,SnapUtil/* setSnapped */.U)(event, 'y', targetTRBL.top - offset.y);\n  } else if (/bottom/.test(direction)) {\n    (0,SnapUtil/* setSnapped */.U)(event, 'y', targetTRBL.bottom - offset.y);\n  }\n\n  if (/left/.test(direction)) {\n    (0,SnapUtil/* setSnapped */.U)(event, 'x', targetTRBL.left - offset.x);\n  } else if (/right/.test(direction)) {\n    (0,SnapUtil/* setSnapped */.U)(event, 'x', targetTRBL.right - offset.x);\n  }\n}\n\nfunction areAll(elements, type) {\n  return elements.every(function(el) {\n    return (0,ModelUtil.is)(el, type);\n  });\n}\n\nfunction isContainer(element) {\n  if ((0,ModelUtil.is)(element, 'bpmn:SubProcess') && (0,DiUtil/* isExpanded */.ul)(element)) {\n    return true;\n  }\n\n  return (0,ModelUtil.is)(element, 'bpmn:Participant');\n}\n\n\nfunction setSnappedIfConstrained(event) {\n  var context = event.context,\n      createConstraints = context.createConstraints;\n\n  if (!createConstraints) {\n    return;\n  }\n\n  var top = createConstraints.top,\n      right = createConstraints.right,\n      bottom = createConstraints.bottom,\n      left = createConstraints.left;\n\n  if ((left && left >= event.x) || (right && right <= event.x)) {\n    (0,SnapUtil/* setSnapped */.U)(event, 'x', event.x);\n  }\n\n  if ((top && top >= event.y) || (bottom && bottom <= event.y)) {\n    (0,SnapUtil/* setSnapped */.U)(event, 'y', event.y);\n  }\n}\n\nfunction BpmnCreateMoveSnapping_includes(array, value) {\n  return array.indexOf(value) !== -1;\n}\n\nfunction getDockingSnapOrigin(docking, isMove, event) {\n  return isMove ? (\n    {\n      x: docking.x - event.x,\n      y: docking.y - event.y\n    }\n  ) : {\n    x: docking.x,\n    y: docking.y\n  };\n}\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/snapping/index.js + 2 modules\nvar snapping = __webpack_require__(\"./node_modules/diagram-js/lib/features/snapping/index.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/snapping/index.js\n\n\n\n\n/* harmony default export */ const features_snapping = ({\n  __depends__: [ snapping/* default */.Z ],\n  __init__: [\n    'connectSnapping',\n    'createMoveSnapping'\n  ],\n  connectSnapping: [ 'type', BpmnConnectSnapping ],\n  createMoveSnapping: [ 'type', BpmnCreateMoveSnapping ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/search-pad/index.js + 1 modules\nvar search_pad = __webpack_require__(\"./node_modules/diagram-js/lib/features/search-pad/index.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/search/BpmnSearchProvider.js\n\n\n\n\n\n/**\n * Provides ability to search through BPMN elements\n */\nfunction BpmnSearchProvider(elementRegistry, searchPad, canvas) {\n\n  this._elementRegistry = elementRegistry;\n  this._canvas = canvas;\n\n  searchPad.registerProvider(this);\n}\n\nBpmnSearchProvider.$inject = [\n  'elementRegistry',\n  'searchPad',\n  'canvas'\n];\n\n\n/**\n * Finds all elements that match given pattern\n *\n * <Result> :\n *  {\n *    primaryTokens: <Array<Token>>,\n *    secondaryTokens: <Array<Token>>,\n *    element: <Element>\n *  }\n *\n * <Token> :\n *  {\n *    normal|matched: <string>\n *  }\n *\n * @param  {string} pattern\n * @return {Array<Result>}\n */\nBpmnSearchProvider.prototype.find = function(pattern) {\n  var rootElement = this._canvas.getRootElement();\n\n  var elements = this._elementRegistry.filter(function(element) {\n    if (element.labelTarget) {\n      return false;\n    }\n    return true;\n  });\n\n  // do not include root element\n  elements = (0,dist_index_esm/* filter */.hX)(elements, function(element) {\n    return element !== rootElement;\n  });\n\n  elements = (0,dist_index_esm/* map */.UI)(elements, function(element) {\n    return {\n      primaryTokens: matchAndSplit((0,LabelUtil/* getLabel */.i)(element), pattern),\n      secondaryTokens: matchAndSplit(element.id, pattern),\n      element: element\n    };\n  });\n\n  // exclude non-matched elements\n  elements = (0,dist_index_esm/* filter */.hX)(elements, function(element) {\n    return hasMatched(element.primaryTokens) || hasMatched(element.secondaryTokens);\n  });\n\n  elements = (0,dist_index_esm/* sortBy */.MR)(elements, function(element) {\n    return (0,LabelUtil/* getLabel */.i)(element.element) + element.element.id;\n  });\n\n  return elements;\n};\n\n\nfunction hasMatched(tokens) {\n  var matched = (0,dist_index_esm/* filter */.hX)(tokens, function(t) {\n    return !!t.matched;\n  });\n\n  return matched.length > 0;\n}\n\n\nfunction matchAndSplit(text, pattern) {\n  var tokens = [],\n      originalText = text;\n\n  if (!text) {\n    return tokens;\n  }\n\n  text = text.toLowerCase();\n  pattern = pattern.toLowerCase();\n\n  var i = text.indexOf(pattern);\n\n  if (i > -1) {\n    if (i !== 0) {\n      tokens.push({\n        normal: originalText.substr(0, i)\n      });\n    }\n\n    tokens.push({\n      matched: originalText.substr(i, pattern.length)\n    });\n\n    if (pattern.length + i < text.length) {\n      tokens.push({\n        normal: originalText.substr(pattern.length + i, text.length)\n      });\n    }\n  } else {\n    tokens.push({\n      normal: originalText\n    });\n  }\n\n  return tokens;\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/search/index.js\n\n\n\n\n\n/* harmony default export */ const search = ({\n  __depends__: [\n    search_pad/* default */.Z\n  ],\n  __init__: [ 'bpmnSearch' ],\n  bpmnSearch: [ 'type', BpmnSearchProvider ]\n});\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/Modeler.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nvar initialDiagram =\n  '<?xml version=\"1.0\" encoding=\"UTF-8\"?>' +\n  '<bpmn:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ' +\n                    'xmlns:bpmn=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" ' +\n                    'xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" ' +\n                    'xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" ' +\n                    'targetNamespace=\"http://bpmn.io/schema/bpmn\" ' +\n                    'id=\"Definitions_1\">' +\n    '<bpmn:process id=\"Process_1\" isExecutable=\"false\">' +\n      '<bpmn:startEvent id=\"StartEvent_1\"/>' +\n    '</bpmn:process>' +\n    '<bpmndi:BPMNDiagram id=\"BPMNDiagram_1\">' +\n      '<bpmndi:BPMNPlane id=\"BPMNPlane_1\" bpmnElement=\"Process_1\">' +\n        '<bpmndi:BPMNShape id=\"_BPMNShape_StartEvent_2\" bpmnElement=\"StartEvent_1\">' +\n          '<dc:Bounds height=\"36.0\" width=\"36.0\" x=\"173.0\" y=\"102.0\"/>' +\n        '</bpmndi:BPMNShape>' +\n      '</bpmndi:BPMNPlane>' +\n    '</bpmndi:BPMNDiagram>' +\n  '</bpmn:definitions>';\n\n\n/**\n * A modeler for BPMN 2.0 diagrams.\n *\n *\n * ## Extending the Modeler\n *\n * In order to extend the viewer pass extension modules to bootstrap via the\n * `additionalModules` option. An extension module is an object that exposes\n * named services.\n *\n * The following example depicts the integration of a simple\n * logging component that integrates with interaction events:\n *\n *\n * ```javascript\n *\n * // logging component\n * function InteractionLogger(eventBus) {\n *   eventBus.on('element.hover', function(event) {\n *     console.log()\n *   })\n * }\n *\n * InteractionLogger.$inject = [ 'eventBus' ]; // minification save\n *\n * // extension module\n * var extensionModule = {\n *   __init__: [ 'interactionLogger' ],\n *   interactionLogger: [ 'type', InteractionLogger ]\n * };\n *\n * // extend the viewer\n * var bpmnModeler = new Modeler({ additionalModules: [ extensionModule ] });\n * bpmnModeler.importXML(...);\n * ```\n *\n *\n * ## Customizing / Replacing Components\n *\n * You can replace individual diagram components by redefining them in override modules.\n * This works for all components, including those defined in the core.\n *\n * Pass in override modules via the `options.additionalModules` flag like this:\n *\n * ```javascript\n * function CustomContextPadProvider(contextPad) {\n *\n *   contextPad.registerProvider(this);\n *\n *   this.getContextPadEntries = function(element) {\n *     // no entries, effectively disable the context pad\n *     return {};\n *   };\n * }\n *\n * CustomContextPadProvider.$inject = [ 'contextPad' ];\n *\n * var overrideModule = {\n *   contextPadProvider: [ 'type', CustomContextPadProvider ]\n * };\n *\n * var bpmnModeler = new Modeler({ additionalModules: [ overrideModule ]});\n * ```\n *\n * @param {Object} [options] configuration options to pass to the viewer\n * @param {DOMElement} [options.container] the container to render the viewer in, defaults to body.\n * @param {string|number} [options.width] the width of the viewer\n * @param {string|number} [options.height] the height of the viewer\n * @param {Object} [options.moddleExtensions] extension packages to provide\n * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules\n * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules\n */\nfunction Modeler(options) {\n  BaseModeler.call(this, options);\n}\n\n(0,index_es/* default */.Z)(Modeler, BaseModeler);\n\n\nModeler.Viewer = Viewer/* default */.Z;\nModeler.NavigatedViewer = NavigatedViewer[\"default\"];\n\n/**\n* The createDiagram result.\n*\n* @typedef {Object} CreateDiagramResult\n*\n* @property {Array<string>} warnings\n*/\n\n/**\n* The createDiagram error.\n*\n* @typedef {Error} CreateDiagramError\n*\n* @property {Array<string>} warnings\n*/\n\n/**\n * Create a new diagram to start modeling.\n *\n * Returns {Promise<CreateDiagramResult, CreateDiagramError>}\n */\nModeler.prototype.createDiagram = (0,CompatibilityUtil/* wrapForCompatibility */.$)(function createDiagram() {\n  return this.importXML(initialDiagram);\n});\n\n\nModeler.prototype._interactionModules = [\n\n  // non-modeling components\n  keyboard_move/* default */.Z,\n  movecanvas/* default */.Z,\n  touch/* default */.Z,\n  zoomscroll/* default */.Z\n];\n\nModeler.prototype._modelingModules = [\n\n  // modeling components\n  features_align_elements,\n  features_auto_place,\n  auto_scroll/* default */.Z,\n  auto_resize,\n  bendpoints/* default */.Z,\n  connect/* default */.Z,\n  connection_preview/* default */.Z,\n  features_context_pad,\n  features_copy_paste,\n  create/* default */.Z,\n  features_distribute_elements,\n  features_editor_actions,\n  features_grid_snapping,\n  interaction_events,\n  features_keyboard,\n  keyboard_move_selection/* default */.Z,\n  label_editing,\n  modeling,\n  move/* default */.Z,\n  features_palette,\n  replace_preview,\n  resize/* default */.Z,\n  features_snapping,\n  search\n];\n\n\n// modules the modeler is composed of\n//\n// - viewer modules\n// - interaction modules\n// - modeling modules\n\nModeler.prototype._modules = [].concat(\n  Viewer/* default.prototype._modules */.Z.prototype._modules,\n  Modeler.prototype._interactionModules,\n  Modeler.prototype._modelingModules\n);\n\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/Modeler.js_+_121_modules?")},"./node_modules/bpmn-js/lib/NavigatedViewer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (/* binding */ NavigatedViewer)\n/* harmony export */ });\n/* harmony import */ var inherits_browser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/inherits-browser/dist/index.es.js");\n/* harmony import */ var _Viewer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/bpmn-js/lib/Viewer.js");\n/* harmony import */ var diagram_js_lib_navigation_keyboard_move__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./node_modules/diagram-js/lib/navigation/keyboard-move/index.js");\n/* harmony import */ var diagram_js_lib_navigation_movecanvas__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("./node_modules/diagram-js/lib/navigation/movecanvas/index.js");\n/* harmony import */ var diagram_js_lib_navigation_zoomscroll__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("./node_modules/diagram-js/lib/navigation/zoomscroll/index.js");\n\n\n\n\n\n\n\n\n\n/**\n * A viewer that includes mouse navigation facilities\n *\n * @param {Object} options\n */\nfunction NavigatedViewer(options) {\n  _Viewer__WEBPACK_IMPORTED_MODULE_0__/* ["default"].call */ .Z.call(this, options);\n}\n\n(0,inherits_browser__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(NavigatedViewer, _Viewer__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z);\n\n\nNavigatedViewer.prototype._navigationModules = [\n  diagram_js_lib_navigation_keyboard_move__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z,\n  diagram_js_lib_navigation_movecanvas__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z,\n  diagram_js_lib_navigation_zoomscroll__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z\n];\n\nNavigatedViewer.prototype._modules = [].concat(\n  _Viewer__WEBPACK_IMPORTED_MODULE_0__/* ["default"].prototype._modules */ .Z.prototype._modules,\n  NavigatedViewer.prototype._navigationModules\n);\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/NavigatedViewer.js?')},"./node_modules/bpmn-js/lib/Viewer.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ Viewer)\n});\n\n// EXTERNAL MODULE: ./node_modules/inherits-browser/dist/index.es.js\nvar index_es = __webpack_require__(\"./node_modules/inherits-browser/dist/index.es.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/draw/BaseRenderer.js\nvar BaseRenderer = __webpack_require__(\"./node_modules/diagram-js/lib/draw/BaseRenderer.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/DiUtil.js\nvar DiUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/DiUtil.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/features/label-editing/LabelUtil.js\nvar LabelUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/features/label-editing/LabelUtil.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/ModelUtil.js\nvar ModelUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/ModelUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/RenderUtil.js\nvar RenderUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/RenderUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/draw/BpmnRenderUtil.js\n\n\n\n\n\n\n// re-export getDi for compatibility\n\n\nvar black = 'hsl(225, 10%, 15%)';\n\n// element utils //////////////////////\n\n/**\n * Checks if eventDefinition of the given element matches with semantic type.\n *\n * @return {boolean} true if element is of the given semantic type\n */\nfunction isTypedEvent(event, eventDefinitionType, filter) {\n\n  function matches(definition, filter) {\n    return (0,index_esm/* every */.yW)(filter, function(val, key) {\n\n      // we want a == conversion here, to be able to catch\n      // undefined == false and friends\n      /* jshint -W116 */\n      return definition[key] == val;\n    });\n  }\n\n  return (0,index_esm/* some */.G)(event.eventDefinitions, function(definition) {\n    return definition.$type === eventDefinitionType && matches(event, filter);\n  });\n}\n\nfunction isThrowEvent(event) {\n  return (event.$type === 'bpmn:IntermediateThrowEvent') || (event.$type === 'bpmn:EndEvent');\n}\n\nfunction isCollection(element) {\n  var dataObject = element.dataObjectRef;\n\n  return element.isCollection || (dataObject && dataObject.isCollection);\n}\n\nfunction getSemantic(element) {\n  return element.businessObject;\n}\n\n\n// color access //////////////////////\n\nfunction getFillColor(element, defaultColor) {\n  var di = (0,ModelUtil/* getDi */.DN)(element);\n\n  return di.get('color:background-color') || di.get('bioc:fill') || defaultColor || 'white';\n}\n\nfunction getStrokeColor(element, defaultColor) {\n  var di = (0,ModelUtil/* getDi */.DN)(element);\n\n  return di.get('color:border-color') || di.get('bioc:stroke') || defaultColor || black;\n}\n\nfunction getLabelColor(element, defaultColor, defaultStrokeColor) {\n  var di = (0,ModelUtil/* getDi */.DN)(element),\n      label = di.get('label');\n\n  return label && label.get('color:color') || defaultColor ||\n    getStrokeColor(element, defaultStrokeColor);\n}\n\n// cropping path customizations //////////////////////\n\nfunction getCirclePath(shape) {\n\n  var cx = shape.x + shape.width / 2,\n      cy = shape.y + shape.height / 2,\n      radius = shape.width / 2;\n\n  var circlePath = [\n    [ 'M', cx, cy ],\n    [ 'm', 0, -radius ],\n    [ 'a', radius, radius, 0, 1, 1, 0, 2 * radius ],\n    [ 'a', radius, radius, 0, 1, 1, 0, -2 * radius ],\n    [ 'z' ]\n  ];\n\n  return (0,RenderUtil/* componentsToPath */.KO)(circlePath);\n}\n\nfunction getRoundRectPath(shape, borderRadius) {\n\n  var x = shape.x,\n      y = shape.y,\n      width = shape.width,\n      height = shape.height;\n\n  var roundRectPath = [\n    [ 'M', x + borderRadius, y ],\n    [ 'l', width - borderRadius * 2, 0 ],\n    [ 'a', borderRadius, borderRadius, 0, 0, 1, borderRadius, borderRadius ],\n    [ 'l', 0, height - borderRadius * 2 ],\n    [ 'a', borderRadius, borderRadius, 0, 0, 1, -borderRadius, borderRadius ],\n    [ 'l', borderRadius * 2 - width, 0 ],\n    [ 'a', borderRadius, borderRadius, 0, 0, 1, -borderRadius, -borderRadius ],\n    [ 'l', 0, borderRadius * 2 - height ],\n    [ 'a', borderRadius, borderRadius, 0, 0, 1, borderRadius, -borderRadius ],\n    [ 'z' ]\n  ];\n\n  return (0,RenderUtil/* componentsToPath */.KO)(roundRectPath);\n}\n\nfunction getDiamondPath(shape) {\n\n  var width = shape.width,\n      height = shape.height,\n      x = shape.x,\n      y = shape.y,\n      halfWidth = width / 2,\n      halfHeight = height / 2;\n\n  var diamondPath = [\n    [ 'M', x + halfWidth, y ],\n    [ 'l', halfWidth, halfHeight ],\n    [ 'l', -halfWidth, halfHeight ],\n    [ 'l', -halfWidth, -halfHeight ],\n    [ 'z' ]\n  ];\n\n  return (0,RenderUtil/* componentsToPath */.KO)(diamondPath);\n}\n\nfunction getRectPath(shape) {\n  var x = shape.x,\n      y = shape.y,\n      width = shape.width,\n      height = shape.height;\n\n  var rectPath = [\n    [ 'M', x, y ],\n    [ 'l', width, 0 ],\n    [ 'l', 0, height ],\n    [ 'l', -width, 0 ],\n    [ 'z' ]\n  ];\n\n  return (0,RenderUtil/* componentsToPath */.KO)(rectPath);\n}\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar tiny_svg_dist_index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/SvgTransformUtil.js\nvar SvgTransformUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/SvgTransformUtil.js\");\n// EXTERNAL MODULE: ./node_modules/ids/dist/index.esm.js\nvar ids_dist_index_esm = __webpack_require__(\"./node_modules/ids/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/draw/BpmnRenderer.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nvar RENDERER_IDS = new ids_dist_index_esm/* default */.Z();\n\nvar TASK_BORDER_RADIUS = 10;\nvar INNER_OUTER_DIST = 3;\n\nvar DEFAULT_FILL_OPACITY = .95,\n    HIGH_FILL_OPACITY = .35;\n\nvar ELEMENT_LABEL_DISTANCE = 10;\n\nfunction BpmnRenderer(\n    config, eventBus, styles, pathMap,\n    canvas, textRenderer, priority) {\n\n  BaseRenderer/* default.call */.Z.call(this, eventBus, priority);\n\n  var defaultFillColor = config && config.defaultFillColor,\n      defaultStrokeColor = config && config.defaultStrokeColor,\n      defaultLabelColor = config && config.defaultLabelColor;\n\n  var rendererId = RENDERER_IDS.next();\n\n  var markers = {};\n\n  var computeStyle = styles.computeStyle;\n\n  function addMarker(id, options) {\n    var attrs = (0,index_esm/* assign */.f0)({\n      fill: black,\n      strokeWidth: 1,\n      strokeLinecap: 'round',\n      strokeDasharray: 'none'\n    }, options.attrs);\n\n    var ref = options.ref || { x: 0, y: 0 };\n\n    var scale = options.scale || 1;\n\n    // fix for safari / chrome / firefox bug not correctly\n    // resetting stroke dash array\n    if (attrs.strokeDasharray === 'none') {\n      attrs.strokeDasharray = [ 10000, 1 ];\n    }\n\n    var marker = (0,tiny_svg_dist_index_esm/* create */.Ue)('marker');\n\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(options.element, attrs);\n\n    (0,tiny_svg_dist_index_esm/* append */.R3)(marker, options.element);\n\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(marker, {\n      id: id,\n      viewBox: '0 0 20 20',\n      refX: ref.x,\n      refY: ref.y,\n      markerWidth: 20 * scale,\n      markerHeight: 20 * scale,\n      orient: 'auto'\n    });\n\n    var defs = (0,dist_index_esm/* query */.IO)('defs', canvas._svg);\n\n    if (!defs) {\n      defs = (0,tiny_svg_dist_index_esm/* create */.Ue)('defs');\n\n      (0,tiny_svg_dist_index_esm/* append */.R3)(canvas._svg, defs);\n    }\n\n    (0,tiny_svg_dist_index_esm/* append */.R3)(defs, marker);\n\n    markers[id] = marker;\n  }\n\n  function colorEscape(str) {\n\n    // only allow characters and numbers\n    return str.replace(/[^0-9a-zA-z]+/g, '_');\n  }\n\n  function marker(type, fill, stroke) {\n    var id = type + '-' + colorEscape(fill) + '-' + colorEscape(stroke) + '-' + rendererId;\n\n    if (!markers[id]) {\n      createMarker(id, type, fill, stroke);\n    }\n\n    return 'url(#' + id + ')';\n  }\n\n  function createMarker(id, type, fill, stroke) {\n\n    if (type === 'sequenceflow-end') {\n      var sequenceflowEnd = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(sequenceflowEnd, { d: 'M 1 5 L 11 10 L 1 15 Z' });\n\n      addMarker(id, {\n        element: sequenceflowEnd,\n        ref: { x: 11, y: 10 },\n        scale: 0.5,\n        attrs: {\n          fill: stroke,\n          stroke: stroke\n        }\n      });\n    }\n\n    if (type === 'messageflow-start') {\n      var messageflowStart = (0,tiny_svg_dist_index_esm/* create */.Ue)('circle');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(messageflowStart, { cx: 6, cy: 6, r: 3.5 });\n\n      addMarker(id, {\n        element: messageflowStart,\n        attrs: {\n          fill: fill,\n          stroke: stroke\n        },\n        ref: { x: 6, y: 6 }\n      });\n    }\n\n    if (type === 'messageflow-end') {\n      var messageflowEnd = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(messageflowEnd, { d: 'm 1 5 l 0 -3 l 7 3 l -7 3 z' });\n\n      addMarker(id, {\n        element: messageflowEnd,\n        attrs: {\n          fill: fill,\n          stroke: stroke,\n          strokeLinecap: 'butt'\n        },\n        ref: { x: 8.5, y: 5 }\n      });\n    }\n\n    if (type === 'association-start') {\n      var associationStart = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(associationStart, { d: 'M 11 5 L 1 10 L 11 15' });\n\n      addMarker(id, {\n        element: associationStart,\n        attrs: {\n          fill: 'none',\n          stroke: stroke,\n          strokeWidth: 1.5\n        },\n        ref: { x: 1, y: 10 },\n        scale: 0.5\n      });\n    }\n\n    if (type === 'association-end') {\n      var associationEnd = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(associationEnd, { d: 'M 1 5 L 11 10 L 1 15' });\n\n      addMarker(id, {\n        element: associationEnd,\n        attrs: {\n          fill: 'none',\n          stroke: stroke,\n          strokeWidth: 1.5\n        },\n        ref: { x: 12, y: 10 },\n        scale: 0.5\n      });\n    }\n\n    if (type === 'conditional-flow-marker') {\n      var conditionalflowMarker = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(conditionalflowMarker, { d: 'M 0 10 L 8 6 L 16 10 L 8 14 Z' });\n\n      addMarker(id, {\n        element: conditionalflowMarker,\n        attrs: {\n          fill: fill,\n          stroke: stroke\n        },\n        ref: { x: -1, y: 10 },\n        scale: 0.5\n      });\n    }\n\n    if (type === 'conditional-default-flow-marker') {\n      var conditionaldefaultflowMarker = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(conditionaldefaultflowMarker, { d: 'M 6 4 L 10 16' });\n\n      addMarker(id, {\n        element: conditionaldefaultflowMarker,\n        attrs: {\n          stroke: stroke\n        },\n        ref: { x: 0, y: 10 },\n        scale: 0.5\n      });\n    }\n  }\n\n  function drawCircle(parentGfx, width, height, offset, attrs) {\n\n    if ((0,index_esm/* isObject */.Kn)(offset)) {\n      attrs = offset;\n      offset = 0;\n    }\n\n    offset = offset || 0;\n\n    attrs = computeStyle(attrs, {\n      stroke: black,\n      strokeWidth: 2,\n      fill: 'white'\n    });\n\n    if (attrs.fill === 'none') {\n      delete attrs.fillOpacity;\n    }\n\n    var cx = width / 2,\n        cy = height / 2;\n\n    var circle = (0,tiny_svg_dist_index_esm/* create */.Ue)('circle');\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(circle, {\n      cx: cx,\n      cy: cy,\n      r: Math.round((width + height) / 4 - offset)\n    });\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(circle, attrs);\n\n    (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, circle);\n\n    return circle;\n  }\n\n  function drawRect(parentGfx, width, height, r, offset, attrs) {\n\n    if ((0,index_esm/* isObject */.Kn)(offset)) {\n      attrs = offset;\n      offset = 0;\n    }\n\n    offset = offset || 0;\n\n    attrs = computeStyle(attrs, {\n      stroke: black,\n      strokeWidth: 2,\n      fill: 'white'\n    });\n\n    var rect = (0,tiny_svg_dist_index_esm/* create */.Ue)('rect');\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(rect, {\n      x: offset,\n      y: offset,\n      width: width - offset * 2,\n      height: height - offset * 2,\n      rx: r,\n      ry: r\n    });\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(rect, attrs);\n\n    (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, rect);\n\n    return rect;\n  }\n\n  function drawDiamond(parentGfx, width, height, attrs) {\n\n    var x_2 = width / 2;\n    var y_2 = height / 2;\n\n    var points = [ { x: x_2, y: 0 }, { x: width, y: y_2 }, { x: x_2, y: height }, { x: 0, y: y_2 } ];\n\n    var pointsString = points.map(function(point) {\n      return point.x + ',' + point.y;\n    }).join(' ');\n\n    attrs = computeStyle(attrs, {\n      stroke: black,\n      strokeWidth: 2,\n      fill: 'white'\n    });\n\n    var polygon = (0,tiny_svg_dist_index_esm/* create */.Ue)('polygon');\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(polygon, {\n      points: pointsString\n    });\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(polygon, attrs);\n\n    (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, polygon);\n\n    return polygon;\n  }\n\n  function drawLine(parentGfx, waypoints, attrs) {\n    attrs = computeStyle(attrs, [ 'no-fill' ], {\n      stroke: black,\n      strokeWidth: 2,\n      fill: 'none'\n    });\n\n    var line = (0,RenderUtil/* createLine */.W5)(waypoints, attrs);\n\n    (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, line);\n\n    return line;\n  }\n\n  function drawPath(parentGfx, d, attrs) {\n\n    attrs = computeStyle(attrs, [ 'no-fill' ], {\n      strokeWidth: 2,\n      stroke: black\n    });\n\n    var path = (0,tiny_svg_dist_index_esm/* create */.Ue)('path');\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(path, { d: d });\n    (0,tiny_svg_dist_index_esm/* attr */.Lj)(path, attrs);\n\n    (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, path);\n\n    return path;\n  }\n\n  function drawMarker(type, parentGfx, path, attrs) {\n    return drawPath(parentGfx, path, (0,index_esm/* assign */.f0)({ 'data-marker': type }, attrs));\n  }\n\n  function renderer(type) {\n    return handlers[type];\n  }\n\n  function as(type) {\n    return function(parentGfx, element) {\n      return renderer(type)(parentGfx, element);\n    };\n  }\n\n  function renderEventContent(element, parentGfx) {\n\n    var event = getSemantic(element);\n    var isThrowing = isThrowEvent(event);\n\n    if (event.eventDefinitions && event.eventDefinitions.length > 1) {\n      if (event.parallelMultiple) {\n        return renderer('bpmn:ParallelMultipleEventDefinition')(parentGfx, element, isThrowing);\n      }\n      else {\n        return renderer('bpmn:MultipleEventDefinition')(parentGfx, element, isThrowing);\n      }\n    }\n\n    if (isTypedEvent(event, 'bpmn:MessageEventDefinition')) {\n      return renderer('bpmn:MessageEventDefinition')(parentGfx, element, isThrowing);\n    }\n\n    if (isTypedEvent(event, 'bpmn:TimerEventDefinition')) {\n      return renderer('bpmn:TimerEventDefinition')(parentGfx, element, isThrowing);\n    }\n\n    if (isTypedEvent(event, 'bpmn:ConditionalEventDefinition')) {\n      return renderer('bpmn:ConditionalEventDefinition')(parentGfx, element);\n    }\n\n    if (isTypedEvent(event, 'bpmn:SignalEventDefinition')) {\n      return renderer('bpmn:SignalEventDefinition')(parentGfx, element, isThrowing);\n    }\n\n    if (isTypedEvent(event, 'bpmn:EscalationEventDefinition')) {\n      return renderer('bpmn:EscalationEventDefinition')(parentGfx, element, isThrowing);\n    }\n\n    if (isTypedEvent(event, 'bpmn:LinkEventDefinition')) {\n      return renderer('bpmn:LinkEventDefinition')(parentGfx, element, isThrowing);\n    }\n\n    if (isTypedEvent(event, 'bpmn:ErrorEventDefinition')) {\n      return renderer('bpmn:ErrorEventDefinition')(parentGfx, element, isThrowing);\n    }\n\n    if (isTypedEvent(event, 'bpmn:CancelEventDefinition')) {\n      return renderer('bpmn:CancelEventDefinition')(parentGfx, element, isThrowing);\n    }\n\n    if (isTypedEvent(event, 'bpmn:CompensateEventDefinition')) {\n      return renderer('bpmn:CompensateEventDefinition')(parentGfx, element, isThrowing);\n    }\n\n    if (isTypedEvent(event, 'bpmn:TerminateEventDefinition')) {\n      return renderer('bpmn:TerminateEventDefinition')(parentGfx, element, isThrowing);\n    }\n\n    return null;\n  }\n\n  function renderLabel(parentGfx, label, options) {\n\n    options = (0,index_esm/* assign */.f0)({\n      size: {\n        width: 100\n      }\n    }, options);\n\n    var text = textRenderer.createText(label || '', options);\n\n    (0,tiny_svg_dist_index_esm/* classes */.Sh)(text).add('djs-label');\n\n    (0,tiny_svg_dist_index_esm/* append */.R3)(parentGfx, text);\n\n    return text;\n  }\n\n  function renderEmbeddedLabel(parentGfx, element, align) {\n    var semantic = getSemantic(element);\n\n    return renderLabel(parentGfx, semantic.name, {\n      box: element,\n      align: align,\n      padding: 5,\n      style: {\n        fill: getLabelColor(element, defaultLabelColor, defaultStrokeColor)\n      }\n    });\n  }\n\n  function renderExternalLabel(parentGfx, element) {\n\n    var box = {\n      width: 90,\n      height: 30,\n      x: element.width / 2 + element.x,\n      y: element.height / 2 + element.y\n    };\n\n    return renderLabel(parentGfx, (0,LabelUtil/* getLabel */.i)(element), {\n      box: box,\n      fitBox: true,\n      style: (0,index_esm/* assign */.f0)(\n        {},\n        textRenderer.getExternalStyle(),\n        {\n          fill: getLabelColor(element, defaultLabelColor, defaultStrokeColor)\n        }\n      )\n    });\n  }\n\n  function renderLaneLabel(parentGfx, text, element) {\n    var textBox = renderLabel(parentGfx, text, {\n      box: {\n        height: 30,\n        width: element.height\n      },\n      align: 'center-middle',\n      style: {\n        fill: getLabelColor(element, defaultLabelColor, defaultStrokeColor)\n      }\n    });\n\n    var top = -1 * element.height;\n\n    (0,SvgTransformUtil/* transform */.vs)(textBox, 0, -top, 270);\n  }\n\n  function createPathFromConnection(connection) {\n    var waypoints = connection.waypoints;\n\n    var pathData = 'm  ' + waypoints[0].x + ',' + waypoints[0].y;\n    for (var i = 1; i < waypoints.length; i++) {\n      pathData += 'L' + waypoints[i].x + ',' + waypoints[i].y + ' ';\n    }\n    return pathData;\n  }\n\n  var handlers = this.handlers = {\n    'bpmn:Event': function(parentGfx, element, attrs) {\n\n      if (!('fillOpacity' in attrs)) {\n        attrs.fillOpacity = DEFAULT_FILL_OPACITY;\n      }\n\n      return drawCircle(parentGfx, element.width, element.height, attrs);\n    },\n    'bpmn:StartEvent': function(parentGfx, element) {\n      var attrs = {\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      };\n\n      var semantic = getSemantic(element);\n\n      if (!semantic.isInterrupting) {\n        attrs = {\n          strokeDasharray: '6',\n          strokeLinecap: 'round',\n          fill: getFillColor(element, defaultFillColor),\n          stroke: getStrokeColor(element, defaultStrokeColor)\n        };\n      }\n\n      var circle = renderer('bpmn:Event')(parentGfx, element, attrs);\n\n      renderEventContent(element, parentGfx);\n\n      return circle;\n    },\n    'bpmn:MessageEventDefinition': function(parentGfx, element, isThrowing) {\n      var pathData = pathMap.getScaledPath('EVENT_MESSAGE', {\n        xScaleFactor: 0.9,\n        yScaleFactor: 0.9,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.235,\n          my: 0.315\n        }\n      });\n\n      var fill = isThrowing ? getStrokeColor(element, defaultStrokeColor) : getFillColor(element, defaultFillColor);\n      var stroke = isThrowing ? getFillColor(element, defaultFillColor) : getStrokeColor(element, defaultStrokeColor);\n\n      var messagePath = drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: fill,\n        stroke: stroke\n      });\n\n      return messagePath;\n    },\n    'bpmn:TimerEventDefinition': function(parentGfx, element) {\n      var circle = drawCircle(parentGfx, element.width, element.height, 0.2 * element.height, {\n        strokeWidth: 2,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      var pathData = pathMap.getScaledPath('EVENT_TIMER_WH', {\n        xScaleFactor: 0.75,\n        yScaleFactor: 0.75,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.5,\n          my: 0.5\n        }\n      });\n\n      drawPath(parentGfx, pathData, {\n        strokeWidth: 2,\n        strokeLinecap: 'square',\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      for (var i = 0;i < 12; i++) {\n\n        var linePathData = pathMap.getScaledPath('EVENT_TIMER_LINE', {\n          xScaleFactor: 0.75,\n          yScaleFactor: 0.75,\n          containerWidth: element.width,\n          containerHeight: element.height,\n          position: {\n            mx: 0.5,\n            my: 0.5\n          }\n        });\n\n        var width = element.width / 2;\n        var height = element.height / 2;\n\n        drawPath(parentGfx, linePathData, {\n          strokeWidth: 1,\n          strokeLinecap: 'square',\n          transform: 'rotate(' + (i * 30) + ',' + height + ',' + width + ')',\n          stroke: getStrokeColor(element, defaultStrokeColor)\n        });\n      }\n\n      return circle;\n    },\n    'bpmn:EscalationEventDefinition': function(parentGfx, event, isThrowing) {\n      var pathData = pathMap.getScaledPath('EVENT_ESCALATION', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: event.width,\n        containerHeight: event.height,\n        position: {\n          mx: 0.5,\n          my: 0.2\n        }\n      });\n\n      var fill = isThrowing ? getStrokeColor(event, defaultStrokeColor) : 'none';\n\n      return drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: fill,\n        stroke: getStrokeColor(event, defaultStrokeColor)\n      });\n    },\n    'bpmn:ConditionalEventDefinition': function(parentGfx, event) {\n      var pathData = pathMap.getScaledPath('EVENT_CONDITIONAL', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: event.width,\n        containerHeight: event.height,\n        position: {\n          mx: 0.5,\n          my: 0.222\n        }\n      });\n\n      return drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        stroke: getStrokeColor(event, defaultStrokeColor)\n      });\n    },\n    'bpmn:LinkEventDefinition': function(parentGfx, event, isThrowing) {\n      var pathData = pathMap.getScaledPath('EVENT_LINK', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: event.width,\n        containerHeight: event.height,\n        position: {\n          mx: 0.57,\n          my: 0.263\n        }\n      });\n\n      var fill = isThrowing ? getStrokeColor(event, defaultStrokeColor) : 'none';\n\n      return drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: fill,\n        stroke: getStrokeColor(event, defaultStrokeColor)\n      });\n    },\n    'bpmn:ErrorEventDefinition': function(parentGfx, event, isThrowing) {\n      var pathData = pathMap.getScaledPath('EVENT_ERROR', {\n        xScaleFactor: 1.1,\n        yScaleFactor: 1.1,\n        containerWidth: event.width,\n        containerHeight: event.height,\n        position: {\n          mx: 0.2,\n          my: 0.722\n        }\n      });\n\n      var fill = isThrowing ? getStrokeColor(event, defaultStrokeColor) : 'none';\n\n      return drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: fill,\n        stroke: getStrokeColor(event, defaultStrokeColor)\n      });\n    },\n    'bpmn:CancelEventDefinition': function(parentGfx, event, isThrowing) {\n      var pathData = pathMap.getScaledPath('EVENT_CANCEL_45', {\n        xScaleFactor: 1.0,\n        yScaleFactor: 1.0,\n        containerWidth: event.width,\n        containerHeight: event.height,\n        position: {\n          mx: 0.638,\n          my: -0.055\n        }\n      });\n\n      var fill = isThrowing ? getStrokeColor(event, defaultStrokeColor) : 'none';\n\n      var path = drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: fill,\n        stroke: getStrokeColor(event, defaultStrokeColor)\n      });\n\n      (0,SvgTransformUtil/* rotate */.U1)(path, 45);\n\n      return path;\n    },\n    'bpmn:CompensateEventDefinition': function(parentGfx, event, isThrowing) {\n      var pathData = pathMap.getScaledPath('EVENT_COMPENSATION', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: event.width,\n        containerHeight: event.height,\n        position: {\n          mx: 0.22,\n          my: 0.5\n        }\n      });\n\n      var fill = isThrowing ? getStrokeColor(event, defaultStrokeColor) : 'none';\n\n      return drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: fill,\n        stroke: getStrokeColor(event, defaultStrokeColor)\n      });\n    },\n    'bpmn:SignalEventDefinition': function(parentGfx, event, isThrowing) {\n      var pathData = pathMap.getScaledPath('EVENT_SIGNAL', {\n        xScaleFactor: 0.9,\n        yScaleFactor: 0.9,\n        containerWidth: event.width,\n        containerHeight: event.height,\n        position: {\n          mx: 0.5,\n          my: 0.2\n        }\n      });\n\n      var fill = isThrowing ? getStrokeColor(event, defaultStrokeColor) : 'none';\n\n      return drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: fill,\n        stroke: getStrokeColor(event, defaultStrokeColor)\n      });\n    },\n    'bpmn:MultipleEventDefinition': function(parentGfx, event, isThrowing) {\n      var pathData = pathMap.getScaledPath('EVENT_MULTIPLE', {\n        xScaleFactor: 1.1,\n        yScaleFactor: 1.1,\n        containerWidth: event.width,\n        containerHeight: event.height,\n        position: {\n          mx: 0.222,\n          my: 0.36\n        }\n      });\n\n      var fill = isThrowing ? getStrokeColor(event, defaultStrokeColor) : 'none';\n\n      return drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: fill\n      });\n    },\n    'bpmn:ParallelMultipleEventDefinition': function(parentGfx, event) {\n      var pathData = pathMap.getScaledPath('EVENT_PARALLEL_MULTIPLE', {\n        xScaleFactor: 1.2,\n        yScaleFactor: 1.2,\n        containerWidth: event.width,\n        containerHeight: event.height,\n        position: {\n          mx: 0.458,\n          my: 0.194\n        }\n      });\n\n      return drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: getStrokeColor(event, defaultStrokeColor),\n        stroke: getStrokeColor(event, defaultStrokeColor)\n      });\n    },\n    'bpmn:EndEvent': function(parentGfx, element) {\n      var circle = renderer('bpmn:Event')(parentGfx, element, {\n        strokeWidth: 4,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      renderEventContent(element, parentGfx, true);\n\n      return circle;\n    },\n    'bpmn:TerminateEventDefinition': function(parentGfx, element) {\n      var circle = drawCircle(parentGfx, element.width, element.height, 8, {\n        strokeWidth: 4,\n        fill: getStrokeColor(element, defaultStrokeColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return circle;\n    },\n    'bpmn:IntermediateEvent': function(parentGfx, element) {\n      var outer = renderer('bpmn:Event')(parentGfx, element, {\n        strokeWidth: 1,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      /* inner */\n      drawCircle(parentGfx, element.width, element.height, INNER_OUTER_DIST, {\n        strokeWidth: 1,\n        fill: getFillColor(element, 'none'),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      renderEventContent(element, parentGfx);\n\n      return outer;\n    },\n    'bpmn:IntermediateCatchEvent': as('bpmn:IntermediateEvent'),\n    'bpmn:IntermediateThrowEvent': as('bpmn:IntermediateEvent'),\n\n    'bpmn:Activity': function(parentGfx, element, attrs) {\n\n      attrs = attrs || {};\n\n      if (!('fillOpacity' in attrs)) {\n        attrs.fillOpacity = DEFAULT_FILL_OPACITY;\n      }\n\n      return drawRect(parentGfx, element.width, element.height, TASK_BORDER_RADIUS, attrs);\n    },\n\n    'bpmn:Task': function(parentGfx, element) {\n      var attrs = {\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      };\n\n      var rect = renderer('bpmn:Activity')(parentGfx, element, attrs);\n\n      renderEmbeddedLabel(parentGfx, element, 'center-middle');\n      attachTaskMarkers(parentGfx, element);\n\n      return rect;\n    },\n    'bpmn:ServiceTask': function(parentGfx, element) {\n      var task = renderer('bpmn:Task')(parentGfx, element);\n\n      var pathDataBG = pathMap.getScaledPath('TASK_TYPE_SERVICE', {\n        abspos: {\n          x: 12,\n          y: 18\n        }\n      });\n\n      /* service bg */ drawPath(parentGfx, pathDataBG, {\n        strokeWidth: 1,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      var fillPathData = pathMap.getScaledPath('TASK_TYPE_SERVICE_FILL', {\n        abspos: {\n          x: 17.2,\n          y: 18\n        }\n      });\n\n      /* service fill */ drawPath(parentGfx, fillPathData, {\n        strokeWidth: 0,\n        fill: getFillColor(element, defaultFillColor)\n      });\n\n      var pathData = pathMap.getScaledPath('TASK_TYPE_SERVICE', {\n        abspos: {\n          x: 17,\n          y: 22\n        }\n      });\n\n      /* service */ drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return task;\n    },\n    'bpmn:UserTask': function(parentGfx, element) {\n      var task = renderer('bpmn:Task')(parentGfx, element);\n\n      var x = 15;\n      var y = 12;\n\n      var pathData = pathMap.getScaledPath('TASK_TYPE_USER_1', {\n        abspos: {\n          x: x,\n          y: y\n        }\n      });\n\n      /* user path */ drawPath(parentGfx, pathData, {\n        strokeWidth: 0.5,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      var pathData2 = pathMap.getScaledPath('TASK_TYPE_USER_2', {\n        abspos: {\n          x: x,\n          y: y\n        }\n      });\n\n      /* user2 path */ drawPath(parentGfx, pathData2, {\n        strokeWidth: 0.5,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      var pathData3 = pathMap.getScaledPath('TASK_TYPE_USER_3', {\n        abspos: {\n          x: x,\n          y: y\n        }\n      });\n\n      /* user3 path */ drawPath(parentGfx, pathData3, {\n        strokeWidth: 0.5,\n        fill: getStrokeColor(element, defaultStrokeColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return task;\n    },\n    'bpmn:ManualTask': function(parentGfx, element) {\n      var task = renderer('bpmn:Task')(parentGfx, element);\n\n      var pathData = pathMap.getScaledPath('TASK_TYPE_MANUAL', {\n        abspos: {\n          x: 17,\n          y: 15\n        }\n      });\n\n      /* manual path */ drawPath(parentGfx, pathData, {\n        strokeWidth: 0.5, // 0.25,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return task;\n    },\n    'bpmn:SendTask': function(parentGfx, element) {\n      var task = renderer('bpmn:Task')(parentGfx, element);\n\n      var pathData = pathMap.getScaledPath('TASK_TYPE_SEND', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: 21,\n        containerHeight: 14,\n        position: {\n          mx: 0.285,\n          my: 0.357\n        }\n      });\n\n      /* send path */ drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: getStrokeColor(element, defaultStrokeColor),\n        stroke: getFillColor(element, defaultFillColor)\n      });\n\n      return task;\n    },\n    'bpmn:ReceiveTask' : function(parentGfx, element) {\n      var semantic = getSemantic(element);\n\n      var task = renderer('bpmn:Task')(parentGfx, element);\n      var pathData;\n\n      if (semantic.instantiate) {\n        drawCircle(parentGfx, 28, 28, 20 * 0.22, { strokeWidth: 1 });\n\n        pathData = pathMap.getScaledPath('TASK_TYPE_INSTANTIATING_SEND', {\n          abspos: {\n            x: 7.77,\n            y: 9.52\n          }\n        });\n      } else {\n\n        pathData = pathMap.getScaledPath('TASK_TYPE_SEND', {\n          xScaleFactor: 0.9,\n          yScaleFactor: 0.9,\n          containerWidth: 21,\n          containerHeight: 14,\n          position: {\n            mx: 0.3,\n            my: 0.4\n          }\n        });\n      }\n\n      /* receive path */ drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return task;\n    },\n    'bpmn:ScriptTask': function(parentGfx, element) {\n      var task = renderer('bpmn:Task')(parentGfx, element);\n\n      var pathData = pathMap.getScaledPath('TASK_TYPE_SCRIPT', {\n        abspos: {\n          x: 15,\n          y: 20\n        }\n      });\n\n      /* script path */ drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return task;\n    },\n    'bpmn:BusinessRuleTask': function(parentGfx, element) {\n      var task = renderer('bpmn:Task')(parentGfx, element);\n\n      var headerPathData = pathMap.getScaledPath('TASK_TYPE_BUSINESS_RULE_HEADER', {\n        abspos: {\n          x: 8,\n          y: 8\n        }\n      });\n\n      var businessHeaderPath = drawPath(parentGfx, headerPathData);\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(businessHeaderPath, {\n        strokeWidth: 1,\n        fill: getFillColor(element, '#aaaaaa'),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      var headerData = pathMap.getScaledPath('TASK_TYPE_BUSINESS_RULE_MAIN', {\n        abspos: {\n          x: 8,\n          y: 8\n        }\n      });\n\n      var businessPath = drawPath(parentGfx, headerData);\n      (0,tiny_svg_dist_index_esm/* attr */.Lj)(businessPath, {\n        strokeWidth: 1,\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return task;\n    },\n    'bpmn:SubProcess': function(parentGfx, element, attrs) {\n      attrs = (0,index_esm/* assign */.f0)({\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      }, attrs);\n\n      var rect = renderer('bpmn:Activity')(parentGfx, element, attrs);\n\n      var expanded = (0,DiUtil/* isExpanded */.ul)(element);\n\n      if ((0,DiUtil/* isEventSubProcess */.J5)(element)) {\n        (0,tiny_svg_dist_index_esm/* attr */.Lj)(rect, {\n          strokeDasharray: '1,2'\n        });\n      }\n\n      renderEmbeddedLabel(parentGfx, element, expanded ? 'center-top' : 'center-middle');\n\n      if (expanded) {\n        attachTaskMarkers(parentGfx, element);\n      } else {\n        attachTaskMarkers(parentGfx, element, [ 'SubProcessMarker' ]);\n      }\n\n      return rect;\n    },\n    'bpmn:AdHocSubProcess': function(parentGfx, element) {\n      return renderer('bpmn:SubProcess')(parentGfx, element);\n    },\n    'bpmn:Transaction': function(parentGfx, element) {\n      var outer = renderer('bpmn:SubProcess')(parentGfx, element);\n\n      var innerAttrs = styles.style([ 'no-fill', 'no-events' ], {\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      /* inner path */ drawRect(parentGfx, element.width, element.height, TASK_BORDER_RADIUS - 2, INNER_OUTER_DIST, innerAttrs);\n\n      return outer;\n    },\n    'bpmn:CallActivity': function(parentGfx, element) {\n      return renderer('bpmn:SubProcess')(parentGfx, element, {\n        strokeWidth: 5\n      });\n    },\n    'bpmn:Participant': function(parentGfx, element) {\n\n      var attrs = {\n        fillOpacity: DEFAULT_FILL_OPACITY,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      };\n\n      var lane = renderer('bpmn:Lane')(parentGfx, element, attrs);\n\n      var expandedPool = (0,DiUtil/* isExpanded */.ul)(element);\n\n      if (expandedPool) {\n        drawLine(parentGfx, [\n          { x: 30, y: 0 },\n          { x: 30, y: element.height }\n        ], {\n          stroke: getStrokeColor(element, defaultStrokeColor)\n        });\n        var text = getSemantic(element).name;\n        renderLaneLabel(parentGfx, text, element);\n      } else {\n\n        // Collapsed pool draw text inline\n        var text2 = getSemantic(element).name;\n        renderLabel(parentGfx, text2, {\n          box: element, align: 'center-middle',\n          style: {\n            fill: getLabelColor(element, defaultLabelColor, defaultStrokeColor)\n          }\n        });\n      }\n\n      var participantMultiplicity = !!(getSemantic(element).participantMultiplicity);\n\n      if (participantMultiplicity) {\n        renderer('ParticipantMultiplicityMarker')(parentGfx, element);\n      }\n\n      return lane;\n    },\n    'bpmn:Lane': function(parentGfx, element, attrs) {\n      var rect = drawRect(parentGfx, element.width, element.height, 0, (0,index_esm/* assign */.f0)({\n        fill: getFillColor(element, defaultFillColor),\n        fillOpacity: HIGH_FILL_OPACITY,\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      }, attrs));\n\n      var semantic = getSemantic(element);\n\n      if (semantic.$type === 'bpmn:Lane') {\n        var text = semantic.name;\n        renderLaneLabel(parentGfx, text, element);\n      }\n\n      return rect;\n    },\n    'bpmn:InclusiveGateway': function(parentGfx, element) {\n      var diamond = renderer('bpmn:Gateway')(parentGfx, element);\n\n      /* circle path */\n      drawCircle(parentGfx, element.width, element.height, element.height * 0.24, {\n        strokeWidth: 2.5,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return diamond;\n    },\n    'bpmn:ExclusiveGateway': function(parentGfx, element) {\n      var diamond = renderer('bpmn:Gateway')(parentGfx, element);\n\n      var pathData = pathMap.getScaledPath('GATEWAY_EXCLUSIVE', {\n        xScaleFactor: 0.4,\n        yScaleFactor: 0.4,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.32,\n          my: 0.3\n        }\n      });\n\n      if (((0,ModelUtil/* getDi */.DN)(element).isMarkerVisible)) {\n        drawPath(parentGfx, pathData, {\n          strokeWidth: 1,\n          fill: getStrokeColor(element, defaultStrokeColor),\n          stroke: getStrokeColor(element, defaultStrokeColor)\n        });\n      }\n\n      return diamond;\n    },\n    'bpmn:ComplexGateway': function(parentGfx, element) {\n      var diamond = renderer('bpmn:Gateway')(parentGfx, element);\n\n      var pathData = pathMap.getScaledPath('GATEWAY_COMPLEX', {\n        xScaleFactor: 0.5,\n        yScaleFactor:0.5,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.46,\n          my: 0.26\n        }\n      });\n\n      /* complex path */ drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: getStrokeColor(element, defaultStrokeColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return diamond;\n    },\n    'bpmn:ParallelGateway': function(parentGfx, element) {\n      var diamond = renderer('bpmn:Gateway')(parentGfx, element);\n\n      var pathData = pathMap.getScaledPath('GATEWAY_PARALLEL', {\n        xScaleFactor: 0.6,\n        yScaleFactor:0.6,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.46,\n          my: 0.2\n        }\n      });\n\n      /* parallel path */ drawPath(parentGfx, pathData, {\n        strokeWidth: 1,\n        fill: getStrokeColor(element, defaultStrokeColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return diamond;\n    },\n    'bpmn:EventBasedGateway': function(parentGfx, element) {\n\n      var semantic = getSemantic(element);\n\n      var diamond = renderer('bpmn:Gateway')(parentGfx, element);\n\n      /* outer circle path */ drawCircle(parentGfx, element.width, element.height, element.height * 0.20, {\n        strokeWidth: 1,\n        fill: 'none',\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      var type = semantic.eventGatewayType;\n      var instantiate = !!semantic.instantiate;\n\n      function drawEvent() {\n\n        var pathData = pathMap.getScaledPath('GATEWAY_EVENT_BASED', {\n          xScaleFactor: 0.18,\n          yScaleFactor: 0.18,\n          containerWidth: element.width,\n          containerHeight: element.height,\n          position: {\n            mx: 0.36,\n            my: 0.44\n          }\n        });\n\n        var attrs = {\n          strokeWidth: 2,\n          fill: getFillColor(element, 'none'),\n          stroke: getStrokeColor(element, defaultStrokeColor)\n        };\n\n        /* event path */ drawPath(parentGfx, pathData, attrs);\n      }\n\n      if (type === 'Parallel') {\n\n        var pathData = pathMap.getScaledPath('GATEWAY_PARALLEL', {\n          xScaleFactor: 0.4,\n          yScaleFactor:0.4,\n          containerWidth: element.width,\n          containerHeight: element.height,\n          position: {\n            mx: 0.474,\n            my: 0.296\n          }\n        });\n\n        var parallelPath = drawPath(parentGfx, pathData);\n        (0,tiny_svg_dist_index_esm/* attr */.Lj)(parallelPath, {\n          strokeWidth: 1,\n          fill: 'none'\n        });\n      } else if (type === 'Exclusive') {\n\n        if (!instantiate) {\n          var innerCircle = drawCircle(parentGfx, element.width, element.height, element.height * 0.26);\n          (0,tiny_svg_dist_index_esm/* attr */.Lj)(innerCircle, {\n            strokeWidth: 1,\n            fill: 'none',\n            stroke: getStrokeColor(element, defaultStrokeColor)\n          });\n        }\n\n        drawEvent();\n      }\n\n\n      return diamond;\n    },\n    'bpmn:Gateway': function(parentGfx, element) {\n      var attrs = {\n        fill: getFillColor(element, defaultFillColor),\n        fillOpacity: DEFAULT_FILL_OPACITY,\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      };\n\n      return drawDiamond(parentGfx, element.width, element.height, attrs);\n    },\n    'bpmn:SequenceFlow': function(parentGfx, element) {\n      var pathData = createPathFromConnection(element);\n\n      var fill = getFillColor(element, defaultFillColor),\n          stroke = getStrokeColor(element, defaultStrokeColor);\n\n      var attrs = {\n        strokeLinejoin: 'round',\n        markerEnd: marker('sequenceflow-end', fill, stroke),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      };\n\n      var path = drawPath(parentGfx, pathData, attrs);\n\n      var sequenceFlow = getSemantic(element);\n\n      var source;\n\n      if (element.source) {\n        source = element.source.businessObject;\n\n        // conditional flow marker\n        if (sequenceFlow.conditionExpression && source.$instanceOf('bpmn:Activity')) {\n          (0,tiny_svg_dist_index_esm/* attr */.Lj)(path, {\n            markerStart: marker('conditional-flow-marker', fill, stroke)\n          });\n        }\n\n        // default marker\n        if (source.default && (source.$instanceOf('bpmn:Gateway') || source.$instanceOf('bpmn:Activity')) &&\n            source.default === sequenceFlow) {\n          (0,tiny_svg_dist_index_esm/* attr */.Lj)(path, {\n            markerStart: marker('conditional-default-flow-marker', fill, stroke)\n          });\n        }\n      }\n\n      return path;\n    },\n    'bpmn:Association': function(parentGfx, element, attrs) {\n\n      var semantic = getSemantic(element);\n\n      var fill = getFillColor(element, defaultFillColor),\n          stroke = getStrokeColor(element, defaultStrokeColor);\n\n      attrs = (0,index_esm/* assign */.f0)({\n        strokeDasharray: '0.5, 5',\n        strokeLinecap: 'round',\n        strokeLinejoin: 'round',\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      }, attrs || {});\n\n      if (semantic.associationDirection === 'One' ||\n          semantic.associationDirection === 'Both') {\n        attrs.markerEnd = marker('association-end', fill, stroke);\n      }\n\n      if (semantic.associationDirection === 'Both') {\n        attrs.markerStart = marker('association-start', fill, stroke);\n      }\n\n      return drawLine(parentGfx, element.waypoints, attrs);\n    },\n    'bpmn:DataInputAssociation': function(parentGfx, element) {\n      var fill = getFillColor(element, defaultFillColor),\n          stroke = getStrokeColor(element, defaultStrokeColor);\n\n      return renderer('bpmn:Association')(parentGfx, element, {\n        markerEnd: marker('association-end', fill, stroke)\n      });\n    },\n    'bpmn:DataOutputAssociation': function(parentGfx, element) {\n      var fill = getFillColor(element, defaultFillColor),\n          stroke = getStrokeColor(element, defaultStrokeColor);\n\n      return renderer('bpmn:Association')(parentGfx, element, {\n        markerEnd: marker('association-end', fill, stroke)\n      });\n    },\n    'bpmn:MessageFlow': function(parentGfx, element) {\n\n      var semantic = getSemantic(element),\n          di = (0,ModelUtil/* getDi */.DN)(element);\n\n      var fill = getFillColor(element, defaultFillColor),\n          stroke = getStrokeColor(element, defaultStrokeColor);\n\n      var pathData = createPathFromConnection(element);\n\n      var attrs = {\n        markerEnd: marker('messageflow-end', fill, stroke),\n        markerStart: marker('messageflow-start', fill, stroke),\n        strokeDasharray: '10, 12',\n        strokeLinecap: 'round',\n        strokeLinejoin: 'round',\n        strokeWidth: '1.5px',\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      };\n\n      var path = drawPath(parentGfx, pathData, attrs);\n\n      if (semantic.messageRef) {\n        var midPoint = path.getPointAtLength(path.getTotalLength() / 2);\n\n        var markerPathData = pathMap.getScaledPath('MESSAGE_FLOW_MARKER', {\n          abspos: {\n            x: midPoint.x,\n            y: midPoint.y\n          }\n        });\n\n        var messageAttrs = { strokeWidth: 1 };\n\n        if (di.messageVisibleKind === 'initiating') {\n          messageAttrs.fill = 'white';\n          messageAttrs.stroke = black;\n        } else {\n          messageAttrs.fill = '#888';\n          messageAttrs.stroke = 'white';\n        }\n\n        var message = drawPath(parentGfx, markerPathData, messageAttrs);\n\n        var labelText = semantic.messageRef.name;\n        var label = renderLabel(parentGfx, labelText, {\n          align: 'center-top',\n          fitBox: true,\n          style: {\n            fill: getStrokeColor(element, defaultLabelColor, defaultStrokeColor)\n          }\n        });\n\n        var messageBounds = message.getBBox(),\n            labelBounds = label.getBBox();\n\n        var translateX = midPoint.x - labelBounds.width / 2,\n            translateY = midPoint.y + messageBounds.height / 2 + ELEMENT_LABEL_DISTANCE;\n\n        (0,SvgTransformUtil/* transform */.vs)(label, translateX, translateY, 0);\n\n      }\n\n      return path;\n    },\n    'bpmn:DataObject': function(parentGfx, element) {\n      var pathData = pathMap.getScaledPath('DATA_OBJECT_PATH', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.474,\n          my: 0.296\n        }\n      });\n\n      var elementObject = drawPath(parentGfx, pathData, {\n        fill: getFillColor(element, defaultFillColor),\n        fillOpacity: DEFAULT_FILL_OPACITY,\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      var semantic = getSemantic(element);\n\n      if (isCollection(semantic)) {\n        renderDataItemCollection(parentGfx, element);\n      }\n\n      return elementObject;\n    },\n    'bpmn:DataObjectReference': as('bpmn:DataObject'),\n    'bpmn:DataInput': function(parentGfx, element) {\n\n      var arrowPathData = pathMap.getRawPath('DATA_ARROW');\n\n      // page\n      var elementObject = renderer('bpmn:DataObject')(parentGfx, element);\n\n      /* input arrow path */ drawPath(parentGfx, arrowPathData, { strokeWidth: 1 });\n\n      return elementObject;\n    },\n    'bpmn:DataOutput': function(parentGfx, element) {\n      var arrowPathData = pathMap.getRawPath('DATA_ARROW');\n\n      // page\n      var elementObject = renderer('bpmn:DataObject')(parentGfx, element);\n\n      /* output arrow path */ drawPath(parentGfx, arrowPathData, {\n        strokeWidth: 1,\n        fill: black\n      });\n\n      return elementObject;\n    },\n    'bpmn:DataStoreReference': function(parentGfx, element) {\n      var DATA_STORE_PATH = pathMap.getScaledPath('DATA_STORE', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0,\n          my: 0.133\n        }\n      });\n\n      var elementStore = drawPath(parentGfx, DATA_STORE_PATH, {\n        strokeWidth: 2,\n        fill: getFillColor(element, defaultFillColor),\n        fillOpacity: DEFAULT_FILL_OPACITY,\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      return elementStore;\n    },\n    'bpmn:BoundaryEvent': function(parentGfx, element) {\n\n      var semantic = getSemantic(element),\n          cancel = semantic.cancelActivity;\n\n      var attrs = {\n        strokeWidth: 1,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      };\n\n      if (!cancel) {\n        attrs.strokeDasharray = '6';\n        attrs.strokeLinecap = 'round';\n      }\n\n      // apply fillOpacity\n      var outerAttrs = (0,index_esm/* assign */.f0)({}, attrs, {\n        fillOpacity: 1\n      });\n\n      // apply no-fill\n      var innerAttrs = (0,index_esm/* assign */.f0)({}, attrs, {\n        fill: 'none'\n      });\n\n      var outer = renderer('bpmn:Event')(parentGfx, element, outerAttrs);\n\n      /* inner path */ drawCircle(parentGfx, element.width, element.height, INNER_OUTER_DIST, innerAttrs);\n\n      renderEventContent(element, parentGfx);\n\n      return outer;\n    },\n    'bpmn:Group': function(parentGfx, element) {\n\n      var group = drawRect(parentGfx, element.width, element.height, TASK_BORDER_RADIUS, {\n        stroke: getStrokeColor(element, defaultStrokeColor),\n        strokeWidth: 1,\n        strokeDasharray: '8,3,1,3',\n        fill: 'none',\n        pointerEvents: 'none'\n      });\n\n      return group;\n    },\n    'label': function(parentGfx, element) {\n      return renderExternalLabel(parentGfx, element);\n    },\n    'bpmn:TextAnnotation': function(parentGfx, element) {\n      var style = {\n        'fill': 'none',\n        'stroke': 'none'\n      };\n\n      var textElement = drawRect(parentGfx, element.width, element.height, 0, 0, style);\n\n      var textPathData = pathMap.getScaledPath('TEXT_ANNOTATION', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: 0.0,\n          my: 0.0\n        }\n      });\n\n      drawPath(parentGfx, textPathData, {\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      var text = getSemantic(element).text || '';\n      renderLabel(parentGfx, text, {\n        box: element,\n        align: 'left-top',\n        padding: 5,\n        style: {\n          fill: getLabelColor(element, defaultLabelColor, defaultStrokeColor)\n        }\n      });\n\n      return textElement;\n    },\n    'ParticipantMultiplicityMarker': function(parentGfx, element) {\n      var markerPath = pathMap.getScaledPath('MARKER_PARALLEL', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: ((element.width / 2) / element.width),\n          my: (element.height - 15) / element.height\n        }\n      });\n\n      drawMarker('participant-multiplicity', parentGfx, markerPath, {\n        strokeWidth: 2,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n    },\n    'SubProcessMarker': function(parentGfx, element) {\n      var markerRect = drawRect(parentGfx, 14, 14, 0, {\n        strokeWidth: 1,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n\n      // Process marker is placed in the middle of the box\n      // therefore fixed values can be used here\n      (0,SvgTransformUtil/* translate */.Iu)(markerRect, element.width / 2 - 7.5, element.height - 20);\n\n      var markerPath = pathMap.getScaledPath('MARKER_SUB_PROCESS', {\n        xScaleFactor: 1.5,\n        yScaleFactor: 1.5,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: (element.width / 2 - 7.5) / element.width,\n          my: (element.height - 20) / element.height\n        }\n      });\n\n      drawMarker('sub-process', parentGfx, markerPath, {\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n    },\n    'ParallelMarker': function(parentGfx, element, position) {\n      var markerPath = pathMap.getScaledPath('MARKER_PARALLEL', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: ((element.width / 2 + position.parallel) / element.width),\n          my: (element.height - 20) / element.height\n        }\n      });\n\n      drawMarker('parallel', parentGfx, markerPath, {\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n    },\n    'SequentialMarker': function(parentGfx, element, position) {\n      var markerPath = pathMap.getScaledPath('MARKER_SEQUENTIAL', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: ((element.width / 2 + position.seq) / element.width),\n          my: (element.height - 19) / element.height\n        }\n      });\n\n      drawMarker('sequential', parentGfx, markerPath, {\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n    },\n    'CompensationMarker': function(parentGfx, element, position) {\n      var markerMath = pathMap.getScaledPath('MARKER_COMPENSATION', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: ((element.width / 2 + position.compensation) / element.width),\n          my: (element.height - 13) / element.height\n        }\n      });\n\n      drawMarker('compensation', parentGfx, markerMath, {\n        strokeWidth: 1,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n    },\n    'LoopMarker': function(parentGfx, element, position) {\n      var markerPath = pathMap.getScaledPath('MARKER_LOOP', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: ((element.width / 2 + position.loop) / element.width),\n          my: (element.height - 7) / element.height\n        }\n      });\n\n      drawMarker('loop', parentGfx, markerPath, {\n        strokeWidth: 1,\n        fill: getFillColor(element, defaultFillColor),\n        stroke: getStrokeColor(element, defaultStrokeColor),\n        strokeLinecap: 'round',\n        strokeMiterlimit: 0.5\n      });\n    },\n    'AdhocMarker': function(parentGfx, element, position) {\n      var markerPath = pathMap.getScaledPath('MARKER_ADHOC', {\n        xScaleFactor: 1,\n        yScaleFactor: 1,\n        containerWidth: element.width,\n        containerHeight: element.height,\n        position: {\n          mx: ((element.width / 2 + position.adhoc) / element.width),\n          my: (element.height - 15) / element.height\n        }\n      });\n\n      drawMarker('adhoc', parentGfx, markerPath, {\n        strokeWidth: 1,\n        fill: getStrokeColor(element, defaultStrokeColor),\n        stroke: getStrokeColor(element, defaultStrokeColor)\n      });\n    }\n  };\n\n  function attachTaskMarkers(parentGfx, element, taskMarkers) {\n    var obj = getSemantic(element);\n\n    var subprocess = taskMarkers && taskMarkers.indexOf('SubProcessMarker') !== -1;\n    var position;\n\n    if (subprocess) {\n      position = {\n        seq: -21,\n        parallel: -22,\n        compensation: -42,\n        loop: -18,\n        adhoc: 10\n      };\n    } else {\n      position = {\n        seq: -3,\n        parallel: -6,\n        compensation: -27,\n        loop: 0,\n        adhoc: 10\n      };\n    }\n\n    (0,index_esm/* forEach */.Ed)(taskMarkers, function(marker) {\n      renderer(marker)(parentGfx, element, position);\n    });\n\n    if (obj.isForCompensation) {\n      renderer('CompensationMarker')(parentGfx, element, position);\n    }\n\n    if (obj.$type === 'bpmn:AdHocSubProcess') {\n      renderer('AdhocMarker')(parentGfx, element, position);\n    }\n\n    var loopCharacteristics = obj.loopCharacteristics,\n        isSequential = loopCharacteristics && loopCharacteristics.isSequential;\n\n    if (loopCharacteristics) {\n\n      if (isSequential === undefined) {\n        renderer('LoopMarker')(parentGfx, element, position);\n      }\n\n      if (isSequential === false) {\n        renderer('ParallelMarker')(parentGfx, element, position);\n      }\n\n      if (isSequential === true) {\n        renderer('SequentialMarker')(parentGfx, element, position);\n      }\n    }\n  }\n\n  function renderDataItemCollection(parentGfx, element) {\n\n    var yPosition = (element.height - 18) / element.height;\n\n    var pathData = pathMap.getScaledPath('DATA_OBJECT_COLLECTION_PATH', {\n      xScaleFactor: 1,\n      yScaleFactor: 1,\n      containerWidth: element.width,\n      containerHeight: element.height,\n      position: {\n        mx: 0.33,\n        my: yPosition\n      }\n    });\n\n    /* collection path */ drawPath(parentGfx, pathData, {\n      strokeWidth: 2\n    });\n  }\n\n\n  // extension API, use at your own risk\n  this._drawPath = drawPath;\n\n  this._renderer = renderer;\n}\n\n\n(0,index_es/* default */.Z)(BpmnRenderer, BaseRenderer/* default */.Z);\n\nBpmnRenderer.$inject = [\n  'config.bpmnRenderer',\n  'eventBus',\n  'styles',\n  'pathMap',\n  'canvas',\n  'textRenderer'\n];\n\n\nBpmnRenderer.prototype.canRender = function(element) {\n  return (0,ModelUtil.is)(element, 'bpmn:BaseElement');\n};\n\nBpmnRenderer.prototype.drawShape = function(parentGfx, element) {\n  var type = element.type;\n  var h = this._renderer(type);\n\n  /* jshint -W040 */\n  return h(parentGfx, element);\n};\n\nBpmnRenderer.prototype.drawConnection = function(parentGfx, element) {\n  var type = element.type;\n  var h = this._renderer(type);\n\n  /* jshint -W040 */\n  return h(parentGfx, element);\n};\n\nBpmnRenderer.prototype.getShapePath = function(element) {\n\n  if ((0,ModelUtil.is)(element, 'bpmn:Event')) {\n    return getCirclePath(element);\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:Activity')) {\n    return getRoundRectPath(element, TASK_BORDER_RADIUS);\n  }\n\n  if ((0,ModelUtil.is)(element, 'bpmn:Gateway')) {\n    return getDiamondPath(element);\n  }\n\n  return getRectPath(element);\n};\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/Text.js\nvar Text = __webpack_require__(\"./node_modules/diagram-js/lib/util/Text.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/draw/TextRenderer.js\n\n\n\n\nvar DEFAULT_FONT_SIZE = 12;\nvar LINE_HEIGHT_RATIO = 1.2;\n\nvar MIN_TEXT_ANNOTATION_HEIGHT = 30;\n\n\nfunction TextRenderer(config) {\n\n  var defaultStyle = (0,index_esm/* assign */.f0)({\n    fontFamily: 'Arial, sans-serif',\n    fontSize: DEFAULT_FONT_SIZE,\n    fontWeight: 'normal',\n    lineHeight: LINE_HEIGHT_RATIO\n  }, config && config.defaultStyle || {});\n\n  var fontSize = parseInt(defaultStyle.fontSize, 10) - 1;\n\n  var externalStyle = (0,index_esm/* assign */.f0)({}, defaultStyle, {\n    fontSize: fontSize\n  }, config && config.externalStyle || {});\n\n  var textUtil = new Text/* default */.Z({\n    style: defaultStyle\n  });\n\n  /**\n   * Get the new bounds of an externally rendered,\n   * layouted label.\n   *\n   * @param  {Bounds} bounds\n   * @param  {string} text\n   *\n   * @return {Bounds}\n   */\n  this.getExternalLabelBounds = function(bounds, text) {\n\n    var layoutedDimensions = textUtil.getDimensions(text, {\n      box: {\n        width: 90,\n        height: 30,\n        x: bounds.width / 2 + bounds.x,\n        y: bounds.height / 2 + bounds.y\n      },\n      style: externalStyle\n    });\n\n    // resize label shape to fit label text\n    return {\n      x: Math.round(bounds.x + bounds.width / 2 - layoutedDimensions.width / 2),\n      y: Math.round(bounds.y),\n      width: Math.ceil(layoutedDimensions.width),\n      height: Math.ceil(layoutedDimensions.height)\n    };\n\n  };\n\n  /**\n   * Get the new bounds of text annotation.\n   *\n   * @param  {Bounds} bounds\n   * @param  {string} text\n   *\n   * @return {Bounds}\n   */\n  this.getTextAnnotationBounds = function(bounds, text) {\n\n    var layoutedDimensions = textUtil.getDimensions(text, {\n      box: bounds,\n      style: defaultStyle,\n      align: 'left-top',\n      padding: 5\n    });\n\n    return {\n      x: bounds.x,\n      y: bounds.y,\n      width: bounds.width,\n      height: Math.max(MIN_TEXT_ANNOTATION_HEIGHT, Math.round(layoutedDimensions.height))\n    };\n  };\n\n  /**\n   * Create a layouted text element.\n   *\n   * @param {string} text\n   * @param {Object} [options]\n   *\n   * @return {SVGElement} rendered text\n   */\n  this.createText = function(text, options) {\n    return textUtil.createText(text, options || {});\n  };\n\n  /**\n   * Get default text style.\n   */\n  this.getDefaultStyle = function() {\n    return defaultStyle;\n  };\n\n  /**\n   * Get the external text style.\n   */\n  this.getExternalStyle = function() {\n    return externalStyle;\n  };\n\n}\n\nTextRenderer.$inject = [\n  'config.textRenderer'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/draw/PathMap.js\n/**\n * Map containing SVG paths needed by BpmnRenderer.\n */\n\nfunction PathMap() {\n\n  /**\n   * Contains a map of path elements\n   *\n   * <h1>Path definition</h1>\n   * A parameterized path is defined like this:\n   * <pre>\n   * 'GATEWAY_PARALLEL': {\n   *   d: 'm {mx},{my} {e.x0},0 0,{e.x1} {e.x1},0 0,{e.y0} -{e.x1},0 0,{e.y1} ' +\n          '-{e.x0},0 0,-{e.y1} -{e.x1},0 0,-{e.y0} {e.x1},0 z',\n   *   height: 17.5,\n   *   width:  17.5,\n   *   heightElements: [2.5, 7.5],\n   *   widthElements: [2.5, 7.5]\n   * }\n   * </pre>\n   * <p>It's important to specify a correct <b>height and width</b> for the path as the scaling\n   * is based on the ratio between the specified height and width in this object and the\n   * height and width that is set as scale target (Note x,y coordinates will be scaled with\n   * individual ratios).</p>\n   * <p>The '<b>heightElements</b>' and '<b>widthElements</b>' array must contain the values that will be scaled.\n   * The scaling is based on the computed ratios.\n   * Coordinates on the y axis should be in the <b>heightElement</b>'s array, they will be scaled using\n   * the computed ratio coefficient.\n   * In the parameterized path the scaled values can be accessed through the 'e' object in {} brackets.\n   *   <ul>\n   *    <li>The values for the y axis can be accessed in the path string using {e.y0}, {e.y1}, ....</li>\n   *    <li>The values for the x axis can be accessed in the path string using {e.x0}, {e.x1}, ....</li>\n   *   </ul>\n   *   The numbers x0, x1 respectively y0, y1, ... map to the corresponding array index.\n   * </p>\n   */\n  this.pathMap = {\n    'EVENT_MESSAGE': {\n      d: 'm {mx},{my} l 0,{e.y1} l {e.x1},0 l 0,-{e.y1} z l {e.x0},{e.y0} l {e.x0},-{e.y0}',\n      height: 36,\n      width:  36,\n      heightElements: [ 6, 14 ],\n      widthElements: [ 10.5, 21 ]\n    },\n    'EVENT_SIGNAL': {\n      d: 'M {mx},{my} l {e.x0},{e.y0} l -{e.x1},0 Z',\n      height: 36,\n      width: 36,\n      heightElements: [ 18 ],\n      widthElements: [ 10, 20 ]\n    },\n    'EVENT_ESCALATION': {\n      d: 'M {mx},{my} l {e.x0},{e.y0} l -{e.x0},-{e.y1} l -{e.x0},{e.y1} Z',\n      height: 36,\n      width: 36,\n      heightElements: [ 20, 7 ],\n      widthElements: [ 8 ]\n    },\n    'EVENT_CONDITIONAL': {\n      d: 'M {e.x0},{e.y0} l {e.x1},0 l 0,{e.y2} l -{e.x1},0 Z ' +\n         'M {e.x2},{e.y3} l {e.x0},0 ' +\n         'M {e.x2},{e.y4} l {e.x0},0 ' +\n         'M {e.x2},{e.y5} l {e.x0},0 ' +\n         'M {e.x2},{e.y6} l {e.x0},0 ' +\n         'M {e.x2},{e.y7} l {e.x0},0 ' +\n         'M {e.x2},{e.y8} l {e.x0},0 ',\n      height: 36,\n      width:  36,\n      heightElements: [ 8.5, 14.5, 18, 11.5, 14.5, 17.5, 20.5, 23.5, 26.5 ],\n      widthElements:  [ 10.5, 14.5, 12.5 ]\n    },\n    'EVENT_LINK': {\n      d: 'm {mx},{my} 0,{e.y0} -{e.x1},0 0,{e.y1} {e.x1},0 0,{e.y0} {e.x0},-{e.y2} -{e.x0},-{e.y2} z',\n      height: 36,\n      width: 36,\n      heightElements: [ 4.4375, 6.75, 7.8125 ],\n      widthElements: [ 9.84375, 13.5 ]\n    },\n    'EVENT_ERROR': {\n      d: 'm {mx},{my} {e.x0},-{e.y0} {e.x1},-{e.y1} {e.x2},{e.y2} {e.x3},-{e.y3} -{e.x4},{e.y4} -{e.x5},-{e.y5} z',\n      height: 36,\n      width: 36,\n      heightElements: [ 0.023, 8.737, 8.151, 16.564, 10.591, 8.714 ],\n      widthElements: [ 0.085, 6.672, 6.97, 4.273, 5.337, 6.636 ]\n    },\n    'EVENT_CANCEL_45': {\n      d: 'm {mx},{my} -{e.x1},0 0,{e.x0} {e.x1},0 0,{e.y1} {e.x0},0 ' +\n        '0,-{e.y1} {e.x1},0 0,-{e.y0} -{e.x1},0 0,-{e.y1} -{e.x0},0 z',\n      height: 36,\n      width: 36,\n      heightElements: [ 4.75, 8.5 ],\n      widthElements: [ 4.75, 8.5 ]\n    },\n    'EVENT_COMPENSATION': {\n      d: 'm {mx},{my} {e.x0},-{e.y0} 0,{e.y1} z m {e.x1},-{e.y2} {e.x2},-{e.y3} 0,{e.y1} -{e.x2},-{e.y3} z',\n      height: 36,\n      width: 36,\n      heightElements: [ 6.5, 13, 0.4, 6.1 ],\n      widthElements: [ 9, 9.3, 8.7 ]\n    },\n    'EVENT_TIMER_WH': {\n      d: 'M {mx},{my} l {e.x0},-{e.y0} m -{e.x0},{e.y0} l {e.x1},{e.y1} ',\n      height: 36,\n      width:  36,\n      heightElements: [ 10, 2 ],\n      widthElements: [ 3, 7 ]\n    },\n    'EVENT_TIMER_LINE': {\n      d:  'M {mx},{my} ' +\n          'm {e.x0},{e.y0} l -{e.x1},{e.y1} ',\n      height: 36,\n      width:  36,\n      heightElements: [ 10, 3 ],\n      widthElements: [ 0, 0 ]\n    },\n    'EVENT_MULTIPLE': {\n      d:'m {mx},{my} {e.x1},-{e.y0} {e.x1},{e.y0} -{e.x0},{e.y1} -{e.x2},0 z',\n      height: 36,\n      width:  36,\n      heightElements: [ 6.28099, 12.56199 ],\n      widthElements: [ 3.1405, 9.42149, 12.56198 ]\n    },\n    'EVENT_PARALLEL_MULTIPLE': {\n      d:'m {mx},{my} {e.x0},0 0,{e.y1} {e.x1},0 0,{e.y0} -{e.x1},0 0,{e.y1} ' +\n        '-{e.x0},0 0,-{e.y1} -{e.x1},0 0,-{e.y0} {e.x1},0 z',\n      height: 36,\n      width:  36,\n      heightElements: [ 2.56228, 7.68683 ],\n      widthElements: [ 2.56228, 7.68683 ]\n    },\n    'GATEWAY_EXCLUSIVE': {\n      d:'m {mx},{my} {e.x0},{e.y0} {e.x1},{e.y0} {e.x2},0 {e.x4},{e.y2} ' +\n                    '{e.x4},{e.y1} {e.x2},0 {e.x1},{e.y3} {e.x0},{e.y3} ' +\n                    '{e.x3},0 {e.x5},{e.y1} {e.x5},{e.y2} {e.x3},0 z',\n      height: 17.5,\n      width:  17.5,\n      heightElements: [ 8.5, 6.5312, -6.5312, -8.5 ],\n      widthElements:  [ 6.5, -6.5, 3, -3, 5, -5 ]\n    },\n    'GATEWAY_PARALLEL': {\n      d:'m {mx},{my} 0,{e.y1} -{e.x1},0 0,{e.y0} {e.x1},0 0,{e.y1} {e.x0},0 ' +\n        '0,-{e.y1} {e.x1},0 0,-{e.y0} -{e.x1},0 0,-{e.y1} -{e.x0},0 z',\n      height: 30,\n      width:  30,\n      heightElements: [ 5, 12.5 ],\n      widthElements: [ 5, 12.5 ]\n    },\n    'GATEWAY_EVENT_BASED': {\n      d:'m {mx},{my} {e.x0},{e.y0} {e.x0},{e.y1} {e.x1},{e.y2} {e.x2},0 z',\n      height: 11,\n      width:  11,\n      heightElements: [ -6, 6, 12, -12 ],\n      widthElements: [ 9, -3, -12 ]\n    },\n    'GATEWAY_COMPLEX': {\n      d:'m {mx},{my} 0,{e.y0} -{e.x0},-{e.y1} -{e.x1},{e.y2} {e.x0},{e.y1} -{e.x2},0 0,{e.y3} ' +\n        '{e.x2},0  -{e.x0},{e.y1} l {e.x1},{e.y2} {e.x0},-{e.y1} 0,{e.y0} {e.x3},0 0,-{e.y0} {e.x0},{e.y1} ' +\n        '{e.x1},-{e.y2} -{e.x0},-{e.y1} {e.x2},0 0,-{e.y3} -{e.x2},0 {e.x0},-{e.y1} -{e.x1},-{e.y2} ' +\n        '-{e.x0},{e.y1} 0,-{e.y0} -{e.x3},0 z',\n      height: 17.125,\n      width:  17.125,\n      heightElements: [ 4.875, 3.4375, 2.125, 3 ],\n      widthElements: [ 3.4375, 2.125, 4.875, 3 ]\n    },\n    'DATA_OBJECT_PATH': {\n      d:'m 0,0 {e.x1},0 {e.x0},{e.y0} 0,{e.y1} -{e.x2},0 0,-{e.y2} {e.x1},0 0,{e.y0} {e.x0},0',\n      height: 61,\n      width:  51,\n      heightElements: [ 10, 50, 60 ],\n      widthElements: [ 10, 40, 50, 60 ]\n    },\n    'DATA_OBJECT_COLLECTION_PATH': {\n      d: 'm{mx},{my} m 3,2 l 0,10 m 3,-10 l 0,10 m 3,-10 l 0,10',\n      height: 10,\n      width: 10,\n      heightElements: [],\n      widthElements: []\n    },\n    'DATA_ARROW': {\n      d:'m 5,9 9,0 0,-3 5,5 -5,5 0,-3 -9,0 z',\n      height: 61,\n      width:  51,\n      heightElements: [],\n      widthElements: []\n    },\n    'DATA_STORE': {\n      d:'m  {mx},{my} ' +\n        'l  0,{e.y2} ' +\n        'c  {e.x0},{e.y1} {e.x1},{e.y1}  {e.x2},0 ' +\n        'l  0,-{e.y2} ' +\n        'c -{e.x0},-{e.y1} -{e.x1},-{e.y1} -{e.x2},0' +\n        'c  {e.x0},{e.y1} {e.x1},{e.y1}  {e.x2},0 ' +\n        'm  -{e.x2},{e.y0}' +\n        'c  {e.x0},{e.y1} {e.x1},{e.y1} {e.x2},0' +\n        'm  -{e.x2},{e.y0}' +\n        'c  {e.x0},{e.y1} {e.x1},{e.y1}  {e.x2},0',\n      height: 61,\n      width:  61,\n      heightElements: [ 7, 10, 45 ],\n      widthElements:  [ 2, 58, 60 ]\n    },\n    'TEXT_ANNOTATION': {\n      d: 'm {mx}, {my} m 10,0 l -10,0 l 0,{e.y0} l 10,0',\n      height: 30,\n      width: 10,\n      heightElements: [ 30 ],\n      widthElements: [ 10 ]\n    },\n    'MARKER_SUB_PROCESS': {\n      d: 'm{mx},{my} m 7,2 l 0,10 m -5,-5 l 10,0',\n      height: 10,\n      width: 10,\n      heightElements: [],\n      widthElements: []\n    },\n    'MARKER_PARALLEL': {\n      d: 'm{mx},{my} m 3,2 l 0,10 m 3,-10 l 0,10 m 3,-10 l 0,10',\n      height: 10,\n      width: 10,\n      heightElements: [],\n      widthElements: []\n    },\n    'MARKER_SEQUENTIAL': {\n      d: 'm{mx},{my} m 0,3 l 10,0 m -10,3 l 10,0 m -10,3 l 10,0',\n      height: 10,\n      width: 10,\n      heightElements: [],\n      widthElements: []\n    },\n    'MARKER_COMPENSATION': {\n      d: 'm {mx},{my} 7,-5 0,10 z m 7.1,-0.3 6.9,-4.7 0,10 -6.9,-4.7 z',\n      height: 10,\n      width: 21,\n      heightElements: [],\n      widthElements: []\n    },\n    'MARKER_LOOP': {\n      d: 'm {mx},{my} c 3.526979,0 6.386161,-2.829858 6.386161,-6.320661 0,-3.490806 -2.859182,-6.320661 ' +\n        '-6.386161,-6.320661 -3.526978,0 -6.38616,2.829855 -6.38616,6.320661 0,1.745402 ' +\n        '0.714797,3.325567 1.870463,4.469381 0.577834,0.571908 1.265885,1.034728 2.029916,1.35457 ' +\n        'l -0.718163,-3.909793 m 0.718163,3.909793 -3.885211,0.802902',\n      height: 13.9,\n      width: 13.7,\n      heightElements: [],\n      widthElements: []\n    },\n    'MARKER_ADHOC': {\n      d: 'm {mx},{my} m 0.84461,2.64411 c 1.05533,-1.23780996 2.64337,-2.07882 4.29653,-1.97997996 2.05163,0.0805 ' +\n        '3.85579,1.15803 5.76082,1.79107 1.06385,0.34139996 2.24454,0.1438 3.18759,-0.43767 0.61743,-0.33642 ' +\n        '1.2775,-0.64078 1.7542,-1.17511 0,0.56023 0,1.12046 0,1.6807 -0.98706,0.96237996 -2.29792,1.62393996 ' +\n        '-3.6918,1.66181996 -1.24459,0.0927 -2.46671,-0.2491 -3.59505,-0.74812 -1.35789,-0.55965 ' +\n        '-2.75133,-1.33436996 -4.27027,-1.18121996 -1.37741,0.14601 -2.41842,1.13685996 -3.44288,1.96782996 z',\n      height: 4,\n      width: 15,\n      heightElements: [],\n      widthElements: []\n    },\n    'TASK_TYPE_SEND': {\n      d: 'm {mx},{my} l 0,{e.y1} l {e.x1},0 l 0,-{e.y1} z l {e.x0},{e.y0} l {e.x0},-{e.y0}',\n      height: 14,\n      width:  21,\n      heightElements: [ 6, 14 ],\n      widthElements: [ 10.5, 21 ]\n    },\n    'TASK_TYPE_SCRIPT': {\n      d: 'm {mx},{my} c 9.966553,-6.27276 -8.000926,-7.91932 2.968968,-14.938 l -8.802728,0 ' +\n        'c -10.969894,7.01868 6.997585,8.66524 -2.968967,14.938 z ' +\n        'm -7,-12 l 5,0 ' +\n        'm -4.5,3 l 4.5,0 ' +\n        'm -3,3 l 5,0' +\n        'm -4,3 l 5,0',\n      height: 15,\n      width:  12.6,\n      heightElements: [ 6, 14 ],\n      widthElements: [ 10.5, 21 ]\n    },\n    'TASK_TYPE_USER_1': {\n      d: 'm {mx},{my} c 0.909,-0.845 1.594,-2.049 1.594,-3.385 0,-2.554 -1.805,-4.62199999 ' +\n        '-4.357,-4.62199999 -2.55199998,0 -4.28799998,2.06799999 -4.28799998,4.62199999 0,1.348 ' +\n        '0.974,2.562 1.89599998,3.405 -0.52899998,0.187 -5.669,2.097 -5.794,4.7560005 v 6.718 ' +\n        'h 17 v -6.718 c 0,-2.2980005 -5.5279996,-4.5950005 -6.0509996,-4.7760005 z' +\n        'm -8,6 l 0,5.5 m 11,0 l 0,-5'\n    },\n    'TASK_TYPE_USER_2': {\n      d: 'm {mx},{my} m 2.162,1.009 c 0,2.4470005 -2.158,4.4310005 -4.821,4.4310005 ' +\n        '-2.66499998,0 -4.822,-1.981 -4.822,-4.4310005 '\n    },\n    'TASK_TYPE_USER_3': {\n      d: 'm {mx},{my} m -6.9,-3.80 c 0,0 2.25099998,-2.358 4.27399998,-1.177 2.024,1.181 4.221,1.537 ' +\n        '4.124,0.965 -0.098,-0.57 -0.117,-3.79099999 -4.191,-4.13599999 -3.57499998,0.001 ' +\n        '-4.20799998,3.36699999 -4.20699998,4.34799999 z'\n    },\n    'TASK_TYPE_MANUAL': {\n      d: 'm {mx},{my} c 0.234,-0.01 5.604,0.008 8.029,0.004 0.808,0 1.271,-0.172 1.417,-0.752 0.227,-0.898 ' +\n        '-0.334,-1.314 -1.338,-1.316 -2.467,-0.01 -7.886,-0.004 -8.108,-0.004 -0.014,-0.079 0.016,-0.533 0,-0.61 ' +\n        '0.195,-0.042 8.507,0.006 9.616,0.002 0.877,-0.007 1.35,-0.438 1.353,-1.208 0.003,-0.768 -0.479,-1.09 ' +\n        '-1.35,-1.091 -2.968,-0.002 -9.619,-0.013 -9.619,-0.013 v -0.591 c 0,0 5.052,-0.016 7.225,-0.016 ' +\n        '0.888,-0.002 1.354,-0.416 1.351,-1.193 -0.006,-0.761 -0.492,-1.196 -1.361,-1.196 -3.473,-0.005 ' +\n        '-10.86,-0.003 -11.0829995,-0.003 -0.022,-0.047 -0.045,-0.094 -0.069,-0.139 0.3939995,-0.319 ' +\n        '2.0409995,-1.626 2.4149995,-2.017 0.469,-0.4870005 0.519,-1.1650005 0.162,-1.6040005 -0.414,-0.511 ' +\n        '-0.973,-0.5 -1.48,-0.236 -1.4609995,0.764 -6.5999995,3.6430005 -7.7329995,4.2710005 -0.9,0.499 ' +\n        '-1.516,1.253 -1.882,2.19 -0.37000002,0.95 -0.17,2.01 -0.166,2.979 0.004,0.718 -0.27300002,1.345 ' +\n        '-0.055,2.063 0.629,2.087 2.425,3.312 4.859,3.318 4.6179995,0.014 9.2379995,-0.139 13.8569995,-0.158 ' +\n        '0.755,-0.004 1.171,-0.301 1.182,-1.033 0.012,-0.754 -0.423,-0.969 -1.183,-0.973 -1.778,-0.01 ' +\n        '-5.824,-0.004 -6.04,-0.004 10e-4,-0.084 0.003,-0.586 10e-4,-0.67 z'\n    },\n    'TASK_TYPE_INSTANTIATING_SEND': {\n      d: 'm {mx},{my} l 0,8.4 l 12.6,0 l 0,-8.4 z l 6.3,3.6 l 6.3,-3.6'\n    },\n    'TASK_TYPE_SERVICE': {\n      d: 'm {mx},{my} v -1.71335 c 0.352326,-0.0705 0.703932,-0.17838 1.047628,-0.32133 ' +\n        '0.344416,-0.14465 0.665822,-0.32133 0.966377,-0.52145 l 1.19431,1.18005 1.567487,-1.57688 ' +\n        '-1.195028,-1.18014 c 0.403376,-0.61394 0.683079,-1.29908 0.825447,-2.01824 l 1.622133,-0.01 ' +\n        'v -2.2196 l -1.636514,0.01 c -0.07333,-0.35153 -0.178319,-0.70024 -0.323564,-1.04372 ' +\n        '-0.145244,-0.34406 -0.321407,-0.6644 -0.522735,-0.96217 l 1.131035,-1.13631 -1.583305,-1.56293 ' +\n        '-1.129598,1.13589 c -0.614052,-0.40108 -1.302883,-0.68093 -2.022633,-0.82247 l 0.0093,-1.61852 ' +\n        'h -2.241173 l 0.0042,1.63124 c -0.353763,0.0736 -0.705369,0.17977 -1.049785,0.32371 -0.344415,0.14437 ' +\n        '-0.665102,0.32092 -0.9635006,0.52046 l -1.1698628,-1.15823 -1.5667691,1.5792 1.1684265,1.15669 ' +\n        'c -0.4026573,0.61283 -0.68308,1.29797 -0.8247287,2.01713 l -1.6588041,0.003 v 2.22174 ' +\n        'l 1.6724648,-0.006 c 0.073327,0.35077 0.1797598,0.70243 0.3242851,1.04472 0.1452428,0.34448 ' +\n        '0.3214064,0.6644 0.5227339,0.96066 l -1.1993431,1.19723 1.5840256,1.56011 1.1964668,-1.19348 ' +\n        'c 0.6140517,0.40346 1.3028827,0.68232 2.0233517,0.82331 l 7.19e-4,1.69892 h 2.226848 z ' +\n        'm 0.221462,-3.9957 c -1.788948,0.7502 -3.8576,-0.0928 -4.6097055,-1.87438 -0.7521065,-1.78321 ' +\n        '0.090598,-3.84627 1.8802645,-4.59604 1.78823,-0.74936 3.856881,0.0929 4.608987,1.87437 ' +\n        '0.752106,1.78165 -0.0906,3.84612 -1.879546,4.59605 z'\n    },\n    'TASK_TYPE_SERVICE_FILL': {\n      d: 'm {mx},{my} c -1.788948,0.7502 -3.8576,-0.0928 -4.6097055,-1.87438 -0.7521065,-1.78321 ' +\n        '0.090598,-3.84627 1.8802645,-4.59604 1.78823,-0.74936 3.856881,0.0929 4.608987,1.87437 ' +\n        '0.752106,1.78165 -0.0906,3.84612 -1.879546,4.59605 z'\n    },\n    'TASK_TYPE_BUSINESS_RULE_HEADER': {\n      d: 'm {mx},{my} 0,4 20,0 0,-4 z'\n    },\n    'TASK_TYPE_BUSINESS_RULE_MAIN': {\n      d: 'm {mx},{my} 0,12 20,0 0,-12 z' +\n        'm 0,8 l 20,0 ' +\n        'm -13,-4 l 0,8'\n    },\n    'MESSAGE_FLOW_MARKER': {\n      d: 'm {mx},{my} m -10.5 ,-7 l 0,14 l 21,0 l 0,-14 z l 10.5,6 l 10.5,-6'\n    }\n  };\n\n  this.getRawPath = function getRawPath(pathId) {\n    return this.pathMap[pathId].d;\n  };\n\n  /**\n   * Scales the path to the given height and width.\n   * <h1>Use case</h1>\n   * <p>Use case is to scale the content of elements (event, gateways) based\n   * on the element bounding box's size.\n   * </p>\n   * <h1>Why not transform</h1>\n   * <p>Scaling a path with transform() will also scale the stroke and IE does not support\n   * the option 'non-scaling-stroke' to prevent this.\n   * Also there are use cases where only some parts of a path should be\n   * scaled.</p>\n   *\n   * @param {string} pathId The ID of the path.\n   * @param {Object} param <p>\n   *   Example param object scales the path to 60% size of the container (data.width, data.height).\n   *   <pre>\n   *   {\n   *     xScaleFactor: 0.6,\n   *     yScaleFactor:0.6,\n   *     containerWidth: data.width,\n   *     containerHeight: data.height,\n   *     position: {\n   *       mx: 0.46,\n   *       my: 0.2,\n   *     }\n   *   }\n   *   </pre>\n   *   <ul>\n   *    <li>targetpathwidth = xScaleFactor * containerWidth</li>\n   *    <li>targetpathheight = yScaleFactor * containerHeight</li>\n   *    <li>Position is used to set the starting coordinate of the path. M is computed:\n    *    <ul>\n    *      <li>position.x * containerWidth</li>\n    *      <li>position.y * containerHeight</li>\n    *    </ul>\n    *    Center of the container <pre> position: {\n   *       mx: 0.5,\n   *       my: 0.5,\n   *     }</pre>\n   *     Upper left corner of the container\n   *     <pre> position: {\n   *       mx: 0.0,\n   *       my: 0.0,\n   *     }</pre>\n   *    </li>\n   *   </ul>\n   * </p>\n   *\n   */\n  this.getScaledPath = function getScaledPath(pathId, param) {\n    var rawPath = this.pathMap[pathId];\n\n    // positioning\n    // compute the start point of the path\n    var mx, my;\n\n    if (param.abspos) {\n      mx = param.abspos.x;\n      my = param.abspos.y;\n    } else {\n      mx = param.containerWidth * param.position.mx;\n      my = param.containerHeight * param.position.my;\n    }\n\n    var coordinates = {}; // map for the scaled coordinates\n    if (param.position) {\n\n      // path\n      var heightRatio = (param.containerHeight / rawPath.height) * param.yScaleFactor;\n      var widthRatio = (param.containerWidth / rawPath.width) * param.xScaleFactor;\n\n\n      // Apply height ratio\n      for (var heightIndex = 0; heightIndex < rawPath.heightElements.length; heightIndex++) {\n        coordinates['y' + heightIndex] = rawPath.heightElements[heightIndex] * heightRatio;\n      }\n\n      // Apply width ratio\n      for (var widthIndex = 0; widthIndex < rawPath.widthElements.length; widthIndex++) {\n        coordinates['x' + widthIndex] = rawPath.widthElements[widthIndex] * widthRatio;\n      }\n    }\n\n    // Apply value to raw path\n    var path = format(\n      rawPath.d, {\n        mx: mx,\n        my: my,\n        e: coordinates\n      }\n    );\n    return path;\n  };\n}\n\n// helpers //////////////////////\n\n// copied and adjusted from https://github.com/adobe-webplatform/Snap.svg/blob/master/src/svg.js\nvar tokenRegex = /\\{([^{}]+)\\}/g,\n    objNotationRegex = /(?:(?:^|\\.)(.+?)(?=\\[|\\.|$|\\()|\\[('|\")(.+?)\\2\\])(\\(\\))?/g; // matches .xxxxx or [\"xxxxx\"] to run over object properties\n\nfunction replacer(all, key, obj) {\n  var res = obj;\n  key.replace(objNotationRegex, function(all, name, quote, quotedName, isFunc) {\n    name = name || quotedName;\n    if (res) {\n      if (name in res) {\n        res = res[name];\n      }\n      typeof res == 'function' && isFunc && (res = res());\n    }\n  });\n  res = (res == null || res == obj ? all : res) + '';\n\n  return res;\n}\n\nfunction format(str, obj) {\n  return String(str).replace(tokenRegex, function(all, key) {\n    return replacer(all, key, obj);\n  });\n}\n\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/draw/index.js\n\n\n\n\n\n/* harmony default export */ const draw = ({\n  __init__: [ 'bpmnRenderer' ],\n  bpmnRenderer: [ 'type', BpmnRenderer ],\n  textRenderer: [ 'type', TextRenderer ],\n  pathMap: [ 'type', PathMap ]\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/i18n/translate/index.js + 1 modules\nvar translate = __webpack_require__(\"./node_modules/diagram-js/lib/i18n/translate/index.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/LabelUtil.js\nvar util_LabelUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/LabelUtil.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/layout/LayoutUtil.js\nvar LayoutUtil = __webpack_require__(\"./node_modules/diagram-js/lib/layout/LayoutUtil.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/import/Util.js\nvar Util = __webpack_require__(\"./node_modules/bpmn-js/lib/import/Util.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/import/BpmnImporter.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @param {ModdleElement} semantic\n * @param {ModdleElement} di\n * @param {Object} [attrs=null]\n *\n * @return {Object}\n */\nfunction elementData(semantic, di, attrs) {\n  return (0,index_esm/* assign */.f0)({\n    id: semantic.id,\n    type: semantic.$type,\n    businessObject: semantic,\n    di: di\n  }, attrs);\n}\n\nfunction getWaypoints(di, source, target) {\n\n  var waypoints = di.waypoint;\n\n  if (!waypoints || waypoints.length < 2) {\n    return [ (0,LayoutUtil/* getMid */.wS)(source), (0,LayoutUtil/* getMid */.wS)(target) ];\n  }\n\n  return waypoints.map(function(p) {\n    return { x: p.x, y: p.y };\n  });\n}\n\nfunction notYetDrawn(translate, semantic, refSemantic, property) {\n  return new Error(translate('element {element} referenced by {referenced}#{property} not yet drawn', {\n    element: (0,Util/* elementToString */.x)(refSemantic),\n    referenced: (0,Util/* elementToString */.x)(semantic),\n    property: property\n  }));\n}\n\n\n/**\n * An importer that adds bpmn elements to the canvas\n *\n * @param {EventBus} eventBus\n * @param {Canvas} canvas\n * @param {ElementFactory} elementFactory\n * @param {ElementRegistry} elementRegistry\n * @param {Function} translate\n * @param {TextRenderer} textRenderer\n */\nfunction BpmnImporter(\n    eventBus, canvas, elementFactory,\n    elementRegistry, translate, textRenderer) {\n\n  this._eventBus = eventBus;\n  this._canvas = canvas;\n  this._elementFactory = elementFactory;\n  this._elementRegistry = elementRegistry;\n  this._translate = translate;\n  this._textRenderer = textRenderer;\n}\n\nBpmnImporter.$inject = [\n  'eventBus',\n  'canvas',\n  'elementFactory',\n  'elementRegistry',\n  'translate',\n  'textRenderer'\n];\n\n\n/**\n * Add bpmn element (semantic) to the canvas onto the\n * specified parent shape.\n */\nBpmnImporter.prototype.add = function(semantic, di, parentElement) {\n  var element,\n      translate = this._translate,\n      hidden;\n\n  var parentIndex;\n\n  // ROOT ELEMENT\n  // handle the special case that we deal with a\n  // invisible root element (process, subprocess or collaboration)\n  if ((0,ModelUtil.is)(di, 'bpmndi:BPMNPlane')) {\n\n    var attrs = (0,ModelUtil.is)(semantic, 'bpmn:SubProcess')\n      ? { id: semantic.id + '_plane' }\n      : {};\n\n    // add a virtual element (not being drawn)\n    element = this._elementFactory.createRoot(elementData(semantic, di, attrs));\n\n    this._canvas.addRootElement(element);\n  }\n\n  // SHAPE\n  else if ((0,ModelUtil.is)(di, 'bpmndi:BPMNShape')) {\n\n    var collapsed = !(0,DiUtil/* isExpanded */.ul)(semantic, di),\n        isFrame = isFrameElement(semantic);\n\n    hidden = parentElement && (parentElement.hidden || parentElement.collapsed);\n\n    var bounds = di.bounds;\n\n    element = this._elementFactory.createShape(elementData(semantic, di, {\n      collapsed: collapsed,\n      hidden: hidden,\n      x: Math.round(bounds.x),\n      y: Math.round(bounds.y),\n      width: Math.round(bounds.width),\n      height: Math.round(bounds.height),\n      isFrame: isFrame\n    }));\n\n    if ((0,ModelUtil.is)(semantic, 'bpmn:BoundaryEvent')) {\n      this._attachBoundary(semantic, element);\n    }\n\n    // insert lanes behind other flow nodes (cf. #727)\n    if ((0,ModelUtil.is)(semantic, 'bpmn:Lane')) {\n      parentIndex = 0;\n    }\n\n    if ((0,ModelUtil.is)(semantic, 'bpmn:DataStoreReference')) {\n\n      // check whether data store is inside our outside of its semantic parent\n      if (!isPointInsideBBox(parentElement, (0,LayoutUtil/* getMid */.wS)(bounds))) {\n        parentElement = this._canvas.findRoot(parentElement);\n      }\n    }\n\n    this._canvas.addShape(element, parentElement, parentIndex);\n  }\n\n  // CONNECTION\n  else if ((0,ModelUtil.is)(di, 'bpmndi:BPMNEdge')) {\n\n    var source = this._getSource(semantic),\n        target = this._getTarget(semantic);\n\n    hidden = parentElement && (parentElement.hidden || parentElement.collapsed);\n\n    element = this._elementFactory.createConnection(elementData(semantic, di, {\n      hidden: hidden,\n      source: source,\n      target: target,\n      waypoints: getWaypoints(di, source, target)\n    }));\n\n    if ((0,ModelUtil.is)(semantic, 'bpmn:DataAssociation')) {\n\n      // render always on top; this ensures DataAssociations\n      // are rendered correctly across different \"hacks\" people\n      // love to model such as cross participant / sub process\n      // associations\n      parentElement = this._canvas.findRoot(parentElement);\n    }\n\n    this._canvas.addConnection(element, parentElement, parentIndex);\n  } else {\n    throw new Error(translate('unknown di {di} for element {semantic}', {\n      di: (0,Util/* elementToString */.x)(di),\n      semantic: (0,Util/* elementToString */.x)(semantic)\n    }));\n  }\n\n  // (optional) LABEL\n  if ((0,util_LabelUtil/* isLabelExternal */.ly)(semantic) && (0,LabelUtil/* getLabel */.i)(element)) {\n    this.addLabel(semantic, di, element);\n  }\n\n\n  this._eventBus.fire('bpmnElement.added', { element: element });\n\n  return element;\n};\n\n\n/**\n * Attach the boundary element to the given host\n *\n * @param {ModdleElement} boundarySemantic\n * @param {djs.model.Base} boundaryElement\n */\nBpmnImporter.prototype._attachBoundary = function(boundarySemantic, boundaryElement) {\n  var translate = this._translate;\n  var hostSemantic = boundarySemantic.attachedToRef;\n\n  if (!hostSemantic) {\n    throw new Error(translate('missing {semantic}#attachedToRef', {\n      semantic: (0,Util/* elementToString */.x)(boundarySemantic)\n    }));\n  }\n\n  var host = this._elementRegistry.get(hostSemantic.id),\n      attachers = host && host.attachers;\n\n  if (!host) {\n    throw notYetDrawn(translate, boundarySemantic, hostSemantic, 'attachedToRef');\n  }\n\n  // wire element.host <> host.attachers\n  boundaryElement.host = host;\n\n  if (!attachers) {\n    host.attachers = attachers = [];\n  }\n\n  if (attachers.indexOf(boundaryElement) === -1) {\n    attachers.push(boundaryElement);\n  }\n};\n\n\n/**\n * add label for an element\n */\nBpmnImporter.prototype.addLabel = function(semantic, di, element) {\n  var bounds,\n      text,\n      label;\n\n  bounds = (0,util_LabelUtil/* getExternalLabelBounds */.lq)(di, element);\n\n  text = (0,LabelUtil/* getLabel */.i)(element);\n\n  if (text) {\n\n    // get corrected bounds from actual layouted text\n    bounds = this._textRenderer.getExternalLabelBounds(bounds, text);\n  }\n\n  label = this._elementFactory.createLabel(elementData(semantic, di, {\n    id: semantic.id + '_label',\n    labelTarget: element,\n    type: 'label',\n    hidden: element.hidden || !(0,LabelUtil/* getLabel */.i)(element),\n    x: Math.round(bounds.x),\n    y: Math.round(bounds.y),\n    width: Math.round(bounds.width),\n    height: Math.round(bounds.height)\n  }));\n\n  return this._canvas.addShape(label, element.parent);\n};\n\n/**\n * Return the drawn connection end based on the given side.\n *\n * @throws {Error} if the end is not yet drawn\n */\nBpmnImporter.prototype._getEnd = function(semantic, side) {\n\n  var element,\n      refSemantic,\n      type = semantic.$type,\n      translate = this._translate;\n\n  refSemantic = semantic[side + 'Ref'];\n\n  // handle mysterious isMany DataAssociation#sourceRef\n  if (side === 'source' && type === 'bpmn:DataInputAssociation') {\n    refSemantic = refSemantic && refSemantic[0];\n  }\n\n  // fix source / target for DataInputAssociation / DataOutputAssociation\n  if (side === 'source' && type === 'bpmn:DataOutputAssociation' ||\n      side === 'target' && type === 'bpmn:DataInputAssociation') {\n\n    refSemantic = semantic.$parent;\n  }\n\n  element = refSemantic && this._getElement(refSemantic);\n\n  if (element) {\n    return element;\n  }\n\n  if (refSemantic) {\n    throw notYetDrawn(translate, semantic, refSemantic, side + 'Ref');\n  } else {\n    throw new Error(translate('{semantic}#{side} Ref not specified', {\n      semantic: (0,Util/* elementToString */.x)(semantic),\n      side: side\n    }));\n  }\n};\n\nBpmnImporter.prototype._getSource = function(semantic) {\n  return this._getEnd(semantic, 'source');\n};\n\nBpmnImporter.prototype._getTarget = function(semantic) {\n  return this._getEnd(semantic, 'target');\n};\n\n\nBpmnImporter.prototype._getElement = function(semantic) {\n  return this._elementRegistry.get(semantic.id);\n};\n\n\n// helpers ////////////////////\n\nfunction isPointInsideBBox(bbox, point) {\n  var x = point.x,\n      y = point.y;\n\n  return x >= bbox.x &&\n    x <= bbox.x + bbox.width &&\n    y >= bbox.y &&\n    y <= bbox.y + bbox.height;\n}\n\nfunction isFrameElement(semantic) {\n  return (0,ModelUtil.is)(semantic, 'bpmn:Group');\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/import/index.js\n\n\n\n\n/* harmony default export */ const lib_import = ({\n  __depends__: [\n    translate/* default */.Z\n  ],\n  bpmnImporter: [ 'type', BpmnImporter ]\n});\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/core/index.js\n\n\n\n/* harmony default export */ const core = ({\n  __depends__: [\n    draw,\n    lib_import\n  ]\n});\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/selection/index.js + 3 modules\nvar selection = __webpack_require__(\"./node_modules/diagram-js/lib/features/selection/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/overlays/index.js + 1 modules\nvar overlays = __webpack_require__(\"./node_modules/diagram-js/lib/features/overlays/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/change-support/index.js + 1 modules\nvar change_support = __webpack_require__(\"./node_modules/diagram-js/lib/features/change-support/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/root-elements/index.js + 1 modules\nvar root_elements = __webpack_require__(\"./node_modules/diagram-js/lib/features/root-elements/index.js\");\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/util/EscapeUtil.js\nvar EscapeUtil = __webpack_require__(\"./node_modules/diagram-js/lib/util/EscapeUtil.js\");\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/util/DrilldownUtil.js\nvar DrilldownUtil = __webpack_require__(\"./node_modules/bpmn-js/lib/util/DrilldownUtil.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/drilldown/DrilldownBreadcrumbs.js\n\n\n\n\n\n\n\nvar OPEN_CLASS = 'bjs-breadcrumbs-shown';\n\n\n/**\n * Adds overlays that allow switching planes on collapsed subprocesses.\n *\n * @param {eventBus} eventBus\n * @param {elementRegistry} elementRegistry\n * @param {overlays} overlays\n * @param {canvas} canvas\n */\nfunction DrilldownBreadcrumbs(eventBus, elementRegistry, overlays, canvas) {\n  var breadcrumbs = (0,dist_index_esm/* domify */.H6)('<ul class=\"bjs-breadcrumbs\"></ul>');\n  var container = canvas.getContainer();\n  var containerClasses = (0,dist_index_esm/* classes */.Sh)(container);\n  container.appendChild(breadcrumbs);\n\n  var boParents = [];\n\n  // update breadcrumbs if name or ID of the primary shape changes\n  eventBus.on('element.changed', function(e) {\n    var shape = e.element,\n        bo = (0,ModelUtil/* getBusinessObject */.SS)(shape);\n\n    var isPresent = (0,index_esm/* find */.sE)(boParents, function(el) {\n      return el === bo;\n    });\n\n    if (!isPresent) {\n      return;\n    }\n\n    updateBreadcrumbs();\n  });\n\n  /**\n   * Updates the displayed breadcrumbs. If no element is provided, only the\n   * labels are updated.\n   *\n   * @param {djs.model.Base} [element]\n   */\n  function updateBreadcrumbs(element) {\n    if (element) {\n      boParents = getBoParentChain(element);\n    }\n\n    var path = boParents.map(function(parent) {\n      var title = (0,EscapeUtil/* escapeHTML */.r)(parent.name || parent.id);\n      var link = (0,dist_index_esm/* domify */.H6)('<li><span class=\"bjs-crumb\"><a title=\"' + title + '\">' + title + '</a></span></li>');\n\n      var parentPlane = canvas.findRoot((0,DrilldownUtil/* getPlaneIdFromShape */.sU)(parent)) || canvas.findRoot(parent.id);\n\n      // when the root is a collaboration, the process does not have a corresponding\n      // element in the elementRegisty. Instead, we search for the corresponding participant\n      if (!parentPlane && (0,ModelUtil.is)(parent, 'bpmn:Process')) {\n        var participant = elementRegistry.find(function(element) {\n          var bo = (0,ModelUtil/* getBusinessObject */.SS)(element);\n          return bo && bo.processRef && bo.processRef === parent;\n        });\n\n        parentPlane = canvas.findRoot(participant.id);\n      }\n\n      link.addEventListener('click', function() {\n        canvas.setRootElement(parentPlane);\n      });\n\n      return link;\n    });\n\n    breadcrumbs.innerHTML = '';\n\n    // show breadcrumbs and expose state to .djs-container\n    var visible = path.length > 1;\n    containerClasses.toggle(OPEN_CLASS, visible);\n\n    path.forEach(function(el) {\n      breadcrumbs.appendChild(el);\n    });\n  }\n\n  eventBus.on('root.set', function(event) {\n    updateBreadcrumbs(event.element);\n  });\n\n}\n\nDrilldownBreadcrumbs.$inject = [ 'eventBus', 'elementRegistry', 'overlays', 'canvas' ];\n\n\n// helpers //////////\n\n/**\n * Returns the parents for the element using the business object chain,\n * starting with the root element.\n *\n * @param {djs.model.Shape} child\n *\n * @returns {Array<djs.model.Shape>} parents\n */\nfunction getBoParentChain(child) {\n  var bo = (0,ModelUtil/* getBusinessObject */.SS)(child);\n\n  var parents = [];\n\n  for (var element = bo; element; element = element.$parent) {\n    if ((0,ModelUtil.is)(element, 'bpmn:SubProcess') || (0,ModelUtil.is)(element, 'bpmn:Process')) {\n      parents.push(element);\n    }\n  }\n\n  return parents.reverse();\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/drilldown/DrilldownCentering.js\n\n\n/**\n * Move collapsed subprocesses into view when drilling down.\n *\n * Zoom and scroll are saved in a session.\n *\n * @param {eventBus} eventBus\n * @param {canvas} canvas\n */\nfunction DrilldownCentering(eventBus, canvas) {\n\n  var currentRoot = null;\n  var positionMap = new Map();\n\n  eventBus.on('root.set', function(event) {\n    var newRoot = event.element;\n    var currentViewbox = canvas.viewbox();\n    var storedViewbox = positionMap.get(newRoot);\n\n    positionMap.set(currentRoot, {\n      x: currentViewbox.x,\n      y: currentViewbox.y,\n      zoom: currentViewbox.scale\n    });\n\n    currentRoot = newRoot;\n\n    // current root was replaced with a collaboration, we don't update the viewbox\n    if ((0,ModelUtil.is)(newRoot, 'bpmn:Collaboration') && !storedViewbox) {\n      return;\n    }\n\n    storedViewbox = storedViewbox || { x: 0, y: 0, zoom: 1 };\n\n    var dx = (currentViewbox.x - storedViewbox.x) * currentViewbox.scale,\n        dy = (currentViewbox.y - storedViewbox.y) * currentViewbox.scale;\n\n    if (dx !== 0 || dy !== 0) {\n      canvas.scroll({\n        dx: dx,\n        dy: dy\n      });\n    }\n\n    if (storedViewbox.zoom !== currentViewbox.scale) {\n      canvas.zoom(storedViewbox.zoom, { x: 0, y: 0 });\n    }\n  });\n\n  eventBus.on('diagram.clear', function() {\n    positionMap.clear();\n    currentRoot = null;\n  });\n\n}\n\nDrilldownCentering.$inject = [ 'eventBus', 'canvas' ];\n\n\n/**\n * ES5 Map implementation. Works.\n */\nfunction Map() {\n\n  this._entries = [];\n\n  this.set = function(key, value) {\n\n    var found = false;\n\n    for (var k in this._entries) {\n      if (this._entries[k][0] === key) {\n        this._entries[k][1] = value;\n\n        found = true;\n\n        break;\n      }\n    }\n\n    if (!found) {\n      this._entries.push([ key, value ]);\n    }\n  };\n\n  this.get = function(key) {\n\n    for (var k in this._entries) {\n      if (this._entries[k][0] === key) {\n        return this._entries[k][1];\n      }\n    }\n\n    return null;\n  };\n\n  this.clear = function() {\n    this._entries.length = 0;\n  };\n\n  this.remove = function(key) {\n\n    var idx = -1;\n\n    for (var k in this._entries) {\n      if (this._entries[k][0] === key) {\n        idx = k;\n\n        break;\n      }\n    }\n\n    if (idx !== -1) {\n      this._entries.splice(idx, 1);\n    }\n  };\n}\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/drilldown/SubprocessCompatibility.js\n\n\n\n\nvar DEFAULT_POSITION = {\n  x: 180,\n  y: 160\n};\n\n/**\n * Hook into `import.render.start` and create new planes for diagrams with\n * collapsed subprocesses and all dis on the same plane.\n *\n * @param {eventBus} eventBus\n * @param {moddle} moddle\n */\nfunction SubprocessCompatibility(eventBus, moddle) {\n  this._eventBus = eventBus;\n  this._moddle = moddle;\n\n  var self = this;\n\n  eventBus.on('import.render.start', 1500, function(e, context) {\n    self.handleImport(context.definitions);\n  });\n}\n\nSubprocessCompatibility.prototype.handleImport = function(definitions) {\n  if (!definitions.diagrams) {\n    return;\n  }\n\n  var self = this;\n  this._definitions = definitions;\n  this._processToDiagramMap = {};\n\n  definitions.diagrams.forEach(function(diagram) {\n    if (!diagram.plane || !diagram.plane.bpmnElement) {\n      return;\n    }\n\n    self._processToDiagramMap[diagram.plane.bpmnElement.id] = diagram;\n  });\n\n  var newDiagrams = [];\n  definitions.diagrams.forEach(function(diagram) {\n    var createdDiagrams = self.createNewDiagrams(diagram.plane);\n    Array.prototype.push.apply(newDiagrams, createdDiagrams);\n  });\n\n  newDiagrams.forEach(function(diagram) {\n    self.movePlaneElementsToOrigin(diagram.plane);\n  });\n};\n\n\n/**\n * Moves all DI elements from collapsed subprocesses to a new plane.\n *\n * @param {Object} plane\n * @return {Array} new diagrams created for the collapsed subprocesses\n */\nSubprocessCompatibility.prototype.createNewDiagrams = function(plane) {\n  var self = this;\n\n  var collapsedElements = [];\n  var elementsToMove = [];\n\n  plane.get('planeElement').forEach(function(diElement) {\n    var bo = diElement.bpmnElement;\n\n    if (!bo) {\n      return;\n    }\n\n    var parent = bo.$parent;\n\n    if ((0,ModelUtil.is)(bo, 'bpmn:SubProcess') && !diElement.isExpanded) {\n      collapsedElements.push(bo);\n    }\n\n    if (shouldMoveToPlane(bo, plane)) {\n\n      // don't change the array while we iterate over it\n      elementsToMove.push({ diElement: diElement, parent: parent });\n    }\n  });\n\n  var newDiagrams = [];\n\n  // create new planes for all collapsed subprocesses, even when they are empty\n  collapsedElements.forEach(function(element) {\n    if (!self._processToDiagramMap[element.id]) {\n      var diagram = self.createDiagram(element);\n      self._processToDiagramMap[element.id] = diagram;\n      newDiagrams.push(diagram);\n    }\n  });\n\n  elementsToMove.forEach(function(element) {\n    var diElement = element.diElement;\n    var parent = element.parent;\n\n    // parent is expanded, get nearest collapsed parent\n    while (parent && collapsedElements.indexOf(parent) === -1) {\n      parent = parent.$parent;\n    }\n\n    // false positive, all parents are expanded\n    if (!parent) {\n      return;\n    }\n\n    var diagram = self._processToDiagramMap[parent.id];\n    self.moveToDiPlane(diElement, diagram.plane);\n  });\n\n  return newDiagrams;\n};\n\nSubprocessCompatibility.prototype.movePlaneElementsToOrigin = function(plane) {\n  var elements = plane.get('planeElement');\n\n  // get bounding box of all elements\n  var planeBounds = getPlaneBounds(plane);\n\n  var offset = {\n    x: planeBounds.x - DEFAULT_POSITION.x,\n    y: planeBounds.y - DEFAULT_POSITION.y\n  };\n\n  elements.forEach(function(diElement) {\n    if (diElement.waypoint) {\n      diElement.waypoint.forEach(function(waypoint) {\n        waypoint.x = waypoint.x - offset.x;\n        waypoint.y = waypoint.y - offset.y;\n      });\n    } else if (diElement.bounds) {\n      diElement.bounds.x = diElement.bounds.x - offset.x;\n      diElement.bounds.y = diElement.bounds.y - offset.y;\n    }\n  });\n};\n\n\nSubprocessCompatibility.prototype.moveToDiPlane = function(diElement, newPlane) {\n  var containingDiagram = findRootDiagram(diElement);\n\n  // remove DI from old Plane and add it to the new one\n  var parentPlaneElement = containingDiagram.plane.get('planeElement');\n  parentPlaneElement.splice(parentPlaneElement.indexOf(diElement), 1);\n  newPlane.get('planeElement').push(diElement);\n};\n\n\nSubprocessCompatibility.prototype.createDiagram = function(bo) {\n  var plane = this._moddle.create('bpmndi:BPMNPlane', { bpmnElement: bo });\n  var diagram = this._moddle.create('bpmndi:BPMNDiagram', {\n    plane: plane\n  });\n  plane.$parent = diagram;\n  plane.bpmnElement = bo;\n  diagram.$parent = this._definitions;\n  this._definitions.diagrams.push(diagram);\n  return diagram;\n};\n\nSubprocessCompatibility.$inject = [ 'eventBus', 'moddle' ];\n\n\n// helpers //////////////////////////\n\nfunction findRootDiagram(element) {\n  if ((0,ModelUtil.is)(element, 'bpmndi:BPMNDiagram')) {\n    return element;\n  } else {\n    return findRootDiagram(element.$parent);\n  }\n}\n\nfunction getPlaneBounds(plane) {\n  var planeTrbl = {\n    top: Infinity,\n    right: -Infinity,\n    bottom: -Infinity,\n    left: Infinity\n  };\n\n  plane.planeElement.forEach(function(element) {\n    if (!element.bounds) {\n      return;\n    }\n\n    var trbl = (0,LayoutUtil/* asTRBL */.JA)(element.bounds);\n\n    planeTrbl.top = Math.min(trbl.top, planeTrbl.top);\n    planeTrbl.left = Math.min(trbl.left, planeTrbl.left);\n  });\n\n  return (0,LayoutUtil/* asBounds */.z_)(planeTrbl);\n}\n\nfunction shouldMoveToPlane(bo, plane) {\n  var parent = bo.$parent;\n\n  // don't move elements that are already on the plane\n  if (!(0,ModelUtil.is)(parent, 'bpmn:SubProcess') || parent === plane.bpmnElement) {\n    return false;\n  }\n\n  // dataAssociations are children of the subprocess but rendered on process level\n  // cf. https://github.com/bpmn-io/bpmn-js/issues/1619\n  if ((0,ModelUtil/* isAny */.JZ)(bo, [ 'bpmn:DataInputAssociation', 'bpmn:DataOutputAssociation' ])) {\n    return false;\n  }\n\n  return true;\n}\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/command/CommandInterceptor.js\nvar CommandInterceptor = __webpack_require__(\"./node_modules/diagram-js/lib/command/CommandInterceptor.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/drilldown/DrilldownOverlayBehavior.js\n\n\n\n\n\n\n\nvar LOW_PRIORITY = 250;\nvar ARROW_DOWN_SVG = '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"20\" height=\"20\" viewBox=\"0 0 16 16\"><path fill-rule=\"evenodd\" d=\"M4.81801948,3.50735931 L10.4996894,9.1896894 L10.5,4 L12,4 L12,12 L4,12 L4,10.5 L9.6896894,10.4996894 L3.75735931,4.56801948 C3.46446609,4.27512627 3.46446609,3.80025253 3.75735931,3.50735931 C4.05025253,3.21446609 4.52512627,3.21446609 4.81801948,3.50735931 Z\"/></svg>';\n\nvar EMPTY_MARKER = 'bjs-drilldown-empty';\n\nfunction DrilldownOverlayBehavior(\n    canvas, eventBus, elementRegistry, overlays\n) {\n  CommandInterceptor/* default.call */.Z.call(this, eventBus);\n\n  this._canvas = canvas;\n  this._eventBus = eventBus;\n  this._elementRegistry = elementRegistry;\n  this._overlays = overlays;\n\n  var self = this;\n\n  this.executed('shape.toggleCollapse', LOW_PRIORITY, function(context) {\n    var shape = context.shape;\n\n    // Add overlay to the collapsed shape\n    if (self.canDrillDown(shape)) {\n      self.addOverlay(shape);\n    } else {\n      self.removeOverlay(shape);\n    }\n  }, true);\n\n\n  this.reverted('shape.toggleCollapse', LOW_PRIORITY, function(context) {\n    var shape = context.shape;\n\n    // Add overlay to the collapsed shape\n    if (self.canDrillDown(shape)) {\n      self.addOverlay(shape);\n    } else {\n      self.removeOverlay(shape);\n    }\n  }, true);\n\n\n  this.executed([ 'shape.create', 'shape.move', 'shape.delete' ], LOW_PRIORITY,\n    function(context) {\n      var oldParent = context.oldParent,\n          newParent = context.newParent || context.parent,\n          shape = context.shape;\n\n      // Add overlay to the collapsed shape\n      if (self.canDrillDown(shape)) {\n        self.addOverlay(shape);\n      }\n\n      self.updateDrilldownOverlay(oldParent);\n      self.updateDrilldownOverlay(newParent);\n      self.updateDrilldownOverlay(shape);\n    }, true);\n\n\n  this.reverted([ 'shape.create', 'shape.move', 'shape.delete' ], LOW_PRIORITY,\n    function(context) {\n      var oldParent = context.oldParent,\n          newParent = context.newParent || context.parent,\n          shape = context.shape;\n\n      // Add overlay to the collapsed shape\n      if (self.canDrillDown(shape)) {\n        self.addOverlay(shape);\n      }\n\n      self.updateDrilldownOverlay(oldParent);\n      self.updateDrilldownOverlay(newParent);\n      self.updateDrilldownOverlay(shape);\n    }, true);\n\n\n  eventBus.on('import.render.complete', function() {\n    elementRegistry.filter(function(e) {\n      return self.canDrillDown(e);\n    }).map(function(el) {\n      self.addOverlay(el);\n    });\n  });\n\n}\n\n(0,index_es/* default */.Z)(DrilldownOverlayBehavior, CommandInterceptor/* default */.Z);\n\nDrilldownOverlayBehavior.prototype.updateDrilldownOverlay = function(shape) {\n  var canvas = this._canvas;\n\n  if (!shape) {\n    return;\n  }\n\n  var root = canvas.findRoot(shape);\n  if (root) {\n    this.updateOverlayVisibility(root);\n  }\n};\n\n\nDrilldownOverlayBehavior.prototype.canDrillDown = function(element) {\n  var canvas = this._canvas;\n  return (0,ModelUtil.is)(element, 'bpmn:SubProcess') && canvas.findRoot((0,DrilldownUtil/* getPlaneIdFromShape */.sU)(element));\n};\n\n/**\n * Updates visibility of the drilldown overlay. If the plane has no elements,\n * the drilldown will be only shown when the element is selected.\n *\n * @param {djs.model.Shape|djs.model.Root} element collapsed shape or root element\n */\nDrilldownOverlayBehavior.prototype.updateOverlayVisibility = function(element) {\n  var overlays = this._overlays;\n\n  var bo = element.businessObject;\n\n  var overlay = overlays.get({ element: bo.id, type: 'drilldown' })[0];\n\n  if (!overlay) {\n    return;\n  }\n\n  var hasContent = bo && bo.flowElements && bo.flowElements.length;\n  (0,dist_index_esm/* classes */.Sh)(overlay.html).toggle(EMPTY_MARKER, !hasContent);\n};\n\n/**\n * Attaches a drilldown button to the given element. We assume that the plane has\n * the same id as the element.\n *\n * @param {djs.model.Shape} element collapsed shape\n */\nDrilldownOverlayBehavior.prototype.addOverlay = function(element) {\n  var canvas = this._canvas;\n  var overlays = this._overlays;\n\n  var existingOverlays = overlays.get({ element: element, type: 'drilldown' });\n  if (existingOverlays.length) {\n    this.removeOverlay(element);\n  }\n\n  var button = (0,dist_index_esm/* domify */.H6)('<button class=\"bjs-drilldown\">' + ARROW_DOWN_SVG + '</button>');\n\n  button.addEventListener('click', function() {\n    canvas.setRootElement(canvas.findRoot((0,DrilldownUtil/* getPlaneIdFromShape */.sU)(element)));\n  });\n\n  overlays.add(element, 'drilldown', {\n    position: {\n      bottom: -7,\n      right: -8\n    },\n    html: button\n  });\n\n  this.updateOverlayVisibility(element);\n};\n\nDrilldownOverlayBehavior.prototype.removeOverlay = function(element) {\n  var overlays = this._overlays;\n\n  overlays.remove({\n    element: element,\n    type: 'drilldown'\n  });\n};\n\nDrilldownOverlayBehavior.$inject = [\n  'canvas',\n  'eventBus',\n  'elementRegistry',\n  'overlays'\n];\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/features/drilldown/index.js\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const drilldown = ({\n  __depends__: [ overlays/* default */.Z, change_support/* default */.Z, root_elements/* default */.Z ],\n  __init__: [ 'drilldownBreadcrumbs', 'drilldownOverlayBehavior', 'drilldownCentering', 'subprocessCompatibility' ],\n  drilldownBreadcrumbs: [ 'type', DrilldownBreadcrumbs ],\n  drilldownCentering: [ 'type', DrilldownCentering ],\n  drilldownOverlayBehavior: [ 'type', DrilldownOverlayBehavior ],\n  subprocessCompatibility: [ 'type', SubprocessCompatibility ]\n});\n// EXTERNAL MODULE: ./node_modules/bpmn-js/lib/BaseViewer.js + 3 modules\nvar BaseViewer = __webpack_require__(\"./node_modules/bpmn-js/lib/BaseViewer.js\");\n;// CONCATENATED MODULE: ./node_modules/bpmn-js/lib/Viewer.js\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A viewer for BPMN 2.0 diagrams.\n *\n * Have a look at {@link NavigatedViewer} or {@link Modeler} for bundles that include\n * additional features.\n *\n *\n * ## Extending the Viewer\n *\n * In order to extend the viewer pass extension modules to bootstrap via the\n * `additionalModules` option. An extension module is an object that exposes\n * named services.\n *\n * The following example depicts the integration of a simple\n * logging component that integrates with interaction events:\n *\n *\n * ```javascript\n *\n * // logging component\n * function InteractionLogger(eventBus) {\n *   eventBus.on('element.hover', function(event) {\n *     console.log()\n *   })\n * }\n *\n * InteractionLogger.$inject = [ 'eventBus' ]; // minification save\n *\n * // extension module\n * var extensionModule = {\n *   __init__: [ 'interactionLogger' ],\n *   interactionLogger: [ 'type', InteractionLogger ]\n * };\n *\n * // extend the viewer\n * var bpmnViewer = new Viewer({ additionalModules: [ extensionModule ] });\n * bpmnViewer.importXML(...);\n * ```\n *\n * @param {Object} [options] configuration options to pass to the viewer\n * @param {DOMElement} [options.container] the container to render the viewer in, defaults to body.\n * @param {string|number} [options.width] the width of the viewer\n * @param {string|number} [options.height] the height of the viewer\n * @param {Object} [options.moddleExtensions] extension packages to provide\n * @param {Array<didi.Module>} [options.modules] a list of modules to override the default modules\n * @param {Array<didi.Module>} [options.additionalModules] a list of modules to use with the default modules\n */\nfunction Viewer(options) {\n  BaseViewer/* default.call */.Z.call(this, options);\n}\n\n(0,index_es/* default */.Z)(Viewer, BaseViewer/* default */.Z);\n\n// modules the viewer is composed of\nViewer.prototype._modules = [\n  core,\n  translate/* default */.Z,\n  selection/* default */.Z,\n  overlays/* default */.Z,\n  drilldown\n];\n\n// default moddle extensions the viewer is composed of\nViewer.prototype._moddleExtensions = {};\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/Viewer.js_+_13_modules?")},"./node_modules/bpmn-js/lib/features/label-editing/LabelUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"i\": () => (/* binding */ getLabel),\n/* harmony export */   \"l\": () => (/* binding */ setLabel)\n/* harmony export */ });\n/* harmony import */ var _util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/bpmn-js/lib/util/ModelUtil.js\");\n\n\nfunction getLabelAttr(semantic) {\n  if (\n    (0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:FlowElement') ||\n    (0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:Participant') ||\n    (0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:Lane') ||\n    (0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:SequenceFlow') ||\n    (0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:MessageFlow') ||\n    (0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:DataInput') ||\n    (0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:DataOutput')\n  ) {\n    return 'name';\n  }\n\n  if ((0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:TextAnnotation')) {\n    return 'text';\n  }\n\n  if ((0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:Group')) {\n    return 'categoryValueRef';\n  }\n}\n\nfunction getCategoryValue(semantic) {\n  var categoryValueRef = semantic['categoryValueRef'];\n\n  if (!categoryValueRef) {\n    return '';\n  }\n\n\n  return categoryValueRef.value || '';\n}\n\nfunction getLabel(element) {\n  var semantic = element.businessObject,\n      attr = getLabelAttr(semantic);\n\n  if (attr) {\n\n    if (attr === 'categoryValueRef') {\n\n      return getCategoryValue(semantic);\n    }\n\n    return semantic[attr] || '';\n  }\n}\n\n\nfunction setLabel(element, text, isExternal) {\n  var semantic = element.businessObject,\n      attr = getLabelAttr(semantic);\n\n  if (attr) {\n\n    if (attr === 'categoryValueRef') {\n      semantic['categoryValueRef'].value = text;\n    } else {\n      semantic[attr] = text;\n    }\n\n  }\n\n  return element;\n}\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/features/label-editing/LabelUtil.js?")},"./node_modules/bpmn-js/lib/features/modeling/behavior/util/LayoutUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "K": () => (/* binding */ getAnchorPointAdjustment)\n/* harmony export */ });\n/* unused harmony export findNewLineStartIndex */\nif ("bpmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _GeometricUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/diagram-js/lib/features/bendpoints/GeometricUtil.js");\n}\nif ("bpmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _LineAttachmentUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/bpmn-js/lib/features/modeling/behavior/util/LineAttachmentUtil.js");\n}\nif ("bpmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var diagram_js_lib_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("./node_modules/diagram-js/lib/layout/LayoutUtil.js");\n}\n\n\n\n\n\n\n\nfunction findNewLineStartIndex(oldWaypoints, newWaypoints, attachment, hints) {\n\n  var index = attachment.segmentIndex;\n\n  var offset = newWaypoints.length - oldWaypoints.length;\n\n  // segmentMove happened\n  if (hints.segmentMove) {\n\n    var oldSegmentStartIndex = hints.segmentMove.segmentStartIndex,\n        newSegmentStartIndex = hints.segmentMove.newSegmentStartIndex;\n\n    // if point was on moved segment return new segment index\n    if (index === oldSegmentStartIndex) {\n      return newSegmentStartIndex;\n    }\n\n    // point is after new segment index\n    if (index >= newSegmentStartIndex) {\n      return (index + offset < newSegmentStartIndex) ? newSegmentStartIndex : index + offset;\n    }\n\n    // if point is before new segment index\n    return index;\n  }\n\n  // bendpointMove happened\n  if (hints.bendpointMove) {\n\n    var insert = hints.bendpointMove.insert,\n        bendpointIndex = hints.bendpointMove.bendpointIndex,\n        newIndex;\n\n    // waypoints length didnt change\n    if (offset === 0) {\n      return index;\n    }\n\n    // point behind new/removed bendpoint\n    if (index >= bendpointIndex) {\n      newIndex = insert ? index + 1 : index - 1;\n    }\n\n    // point before new/removed bendpoint\n    if (index < bendpointIndex) {\n\n      newIndex = index;\n\n      // decide point should take right or left segment\n      if (insert && attachment.type !== \'bendpoint\' && bendpointIndex - 1 === index) {\n\n        var rel = relativePositionMidWaypoint(newWaypoints, bendpointIndex);\n\n        if (rel < attachment.relativeLocation) {\n          newIndex++;\n        }\n      }\n    }\n\n    return newIndex;\n  }\n\n  // start/end changed\n  if (offset === 0) {\n    return index;\n  }\n\n  if (hints.connectionStart && index === 0) {\n    return 0;\n  }\n\n  if (hints.connectionEnd && index === oldWaypoints.length - 2) {\n    return newWaypoints.length - 2;\n  }\n\n  // if nothing fits, take the middle segment\n  return Math.floor((newWaypoints.length - 2) / 2);\n}\n\n\n/**\n * Calculate the required adjustment (move delta) for the given point\n * after the connection waypoints got updated.\n *\n * @param {Point} position\n * @param {Array<Point>} newWaypoints\n * @param {Array<Point>} oldWaypoints\n * @param {Object} hints\n *\n * @return {Object} result\n * @return {Point} result.point\n * @return {Point} result.delta\n */\nfunction getAnchorPointAdjustment(position, newWaypoints, oldWaypoints, hints) {\n\n  var dx = 0,\n      dy = 0;\n\n  var oldPosition = {\n    point: position,\n    delta: { x: 0, y: 0 }\n  };\n\n  // get closest attachment\n  var attachment = (0,_LineAttachmentUtil__WEBPACK_IMPORTED_MODULE_0__/* .getAttachment */ .F)(position, oldWaypoints),\n      oldLabelLineIndex = attachment.segmentIndex,\n      newLabelLineIndex = findNewLineStartIndex(oldWaypoints, newWaypoints, attachment, hints);\n\n\n  // should never happen\n  // TODO(@janstuemmel): throw an error here when connectionSegmentMove is refactored\n  if (newLabelLineIndex < 0 ||\n      newLabelLineIndex > newWaypoints.length - 2 ||\n      newLabelLineIndex === null) {\n    return oldPosition;\n  }\n\n  var oldLabelLine = getLine(oldWaypoints, oldLabelLineIndex),\n      newLabelLine = getLine(newWaypoints, newLabelLineIndex),\n      oldFoot = attachment.position;\n\n  var relativeFootPosition = getRelativeFootPosition(oldLabelLine, oldFoot),\n      angleDelta = getAngleDelta(oldLabelLine, newLabelLine);\n\n  // special rule if label on bendpoint\n  if (attachment.type === \'bendpoint\') {\n\n    var offset = newWaypoints.length - oldWaypoints.length,\n        oldBendpointIndex = attachment.bendpointIndex,\n        oldBendpoint = oldWaypoints[oldBendpointIndex];\n\n    // bendpoint position hasn\'t changed, return same position\n    if (newWaypoints.indexOf(oldBendpoint) !== -1) {\n      return oldPosition;\n    }\n\n    // new bendpoint and old bendpoint have same index, then just return the offset\n    if (offset === 0) {\n      var newBendpoint = newWaypoints[oldBendpointIndex];\n\n      dx = newBendpoint.x - attachment.position.x,\n      dy = newBendpoint.y - attachment.position.y;\n\n      return {\n        delta: {\n          x: dx,\n          y: dy\n        },\n        point: {\n          x: position.x + dx,\n          y: position.y + dy\n        }\n      };\n    }\n\n    // if bendpoints get removed\n    if (offset < 0 && oldBendpointIndex !== 0 && oldBendpointIndex < oldWaypoints.length - 1) {\n      relativeFootPosition = relativePositionMidWaypoint(oldWaypoints, oldBendpointIndex);\n    }\n  }\n\n  var newFoot = {\n    x: (newLabelLine[1].x - newLabelLine[0].x) * relativeFootPosition + newLabelLine[0].x,\n    y: (newLabelLine[1].y - newLabelLine[0].y) * relativeFootPosition + newLabelLine[0].y\n  };\n\n  // the rotated vector to label\n  var newLabelVector = (0,_GeometricUtil__WEBPACK_IMPORTED_MODULE_1__/* .rotateVector */ .cG)({\n    x: position.x - oldFoot.x,\n    y: position.y - oldFoot.y\n  }, angleDelta);\n\n  // the new relative position\n  dx = newFoot.x + newLabelVector.x - position.x;\n  dy = newFoot.y + newLabelVector.y - position.y;\n\n  return {\n    point: (0,diagram_js_lib_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_2__/* .roundPoint */ .ex)(newFoot),\n    delta: (0,diagram_js_lib_layout_LayoutUtil__WEBPACK_IMPORTED_MODULE_2__/* .roundPoint */ .ex)({\n      x: dx,\n      y: dy\n    })\n  };\n}\n\n\n// HELPERS //////////////////////\n\nfunction relativePositionMidWaypoint(waypoints, idx) {\n\n  var distanceSegment1 = (0,_GeometricUtil__WEBPACK_IMPORTED_MODULE_1__/* .getDistancePointPoint */ .IA)(waypoints[idx - 1], waypoints[idx]),\n      distanceSegment2 = (0,_GeometricUtil__WEBPACK_IMPORTED_MODULE_1__/* .getDistancePointPoint */ .IA)(waypoints[idx], waypoints[idx + 1]);\n\n  var relativePosition = distanceSegment1 / (distanceSegment1 + distanceSegment2);\n\n  return relativePosition;\n}\n\nfunction getAngleDelta(l1, l2) {\n  var a1 = (0,_GeometricUtil__WEBPACK_IMPORTED_MODULE_1__/* .getAngle */ ._O)(l1),\n      a2 = (0,_GeometricUtil__WEBPACK_IMPORTED_MODULE_1__/* .getAngle */ ._O)(l2);\n  return a2 - a1;\n}\n\nfunction getLine(waypoints, idx) {\n  return [ waypoints[idx], waypoints[idx + 1] ];\n}\n\nfunction getRelativeFootPosition(line, foot) {\n\n  var length = (0,_GeometricUtil__WEBPACK_IMPORTED_MODULE_1__/* .getDistancePointPoint */ .IA)(line[0], line[1]),\n      lengthToFoot = (0,_GeometricUtil__WEBPACK_IMPORTED_MODULE_1__/* .getDistancePointPoint */ .IA)(line[0], foot);\n\n  return length === 0 ? 0 : lengthToFoot / length;\n}\n\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/features/modeling/behavior/util/LayoutUtil.js?')},"./node_modules/bpmn-js/lib/features/modeling/behavior/util/LineAttachmentUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"F\": () => (/* binding */ getAttachment)\n/* harmony export */ });\nvar sqrt = Math.sqrt,\n    min = Math.min,\n    max = Math.max,\n    abs = Math.abs;\n\n/**\n * Calculate the square (power to two) of a number.\n *\n * @param {number} n\n *\n * @return {number}\n */\nfunction sq(n) {\n  return Math.pow(n, 2);\n}\n\n/**\n * Get distance between two points.\n *\n * @param {Point} p1\n * @param {Point} p2\n *\n * @return {number}\n */\nfunction getDistance(p1, p2) {\n  return sqrt(sq(p1.x - p2.x) + sq(p1.y - p2.y));\n}\n\n/**\n * Return the attachment of the given point on the specified line.\n *\n * The attachment is either a bendpoint (attached to the given point)\n * or segment (attached to a location on a line segment) attachment:\n *\n * ```javascript\n * var pointAttachment = {\n *   type: 'bendpoint',\n *   bendpointIndex: 3,\n *   position: { x: 10, y: 10 } // the attach point on the line\n * };\n *\n * var segmentAttachment = {\n *   type: 'segment',\n *   segmentIndex: 2,\n *   relativeLocation: 0.31, // attach point location between 0 (at start) and 1 (at end)\n *   position: { x: 10, y: 10 } // the attach point on the line\n * };\n * ```\n *\n * @param {Point} point\n * @param {Array<Point>} line\n *\n * @return {Object} attachment\n */\nfunction getAttachment(point, line) {\n\n  var idx = 0,\n      segmentStart,\n      segmentEnd,\n      segmentStartDistance,\n      segmentEndDistance,\n      attachmentPosition,\n      minDistance,\n      intersections,\n      attachment,\n      attachmentDistance,\n      closestAttachmentDistance,\n      closestAttachment;\n\n  for (idx = 0; idx < line.length - 1; idx++) {\n\n    segmentStart = line[idx];\n    segmentEnd = line[idx + 1];\n\n    if (pointsEqual(segmentStart, segmentEnd)) {\n      intersections = [ segmentStart ];\n    } else {\n      segmentStartDistance = getDistance(point, segmentStart);\n      segmentEndDistance = getDistance(point, segmentEnd);\n\n      minDistance = min(segmentStartDistance, segmentEndDistance);\n\n      intersections = getCircleSegmentIntersections(segmentStart, segmentEnd, point, minDistance);\n    }\n\n    if (intersections.length < 1) {\n      throw new Error('expected between [1, 2] circle -> line intersections');\n    }\n\n    // one intersection -> bendpoint attachment\n    if (intersections.length === 1) {\n      attachment = {\n        type: 'bendpoint',\n        position: intersections[0],\n        segmentIndex: idx,\n        bendpointIndex: pointsEqual(segmentStart, intersections[0]) ? idx : idx + 1\n      };\n    }\n\n    // two intersections -> segment attachment\n    if (intersections.length === 2) {\n\n      attachmentPosition = mid(intersections[0], intersections[1]);\n\n      attachment = {\n        type: 'segment',\n        position: attachmentPosition,\n        segmentIndex: idx,\n        relativeLocation: getDistance(segmentStart, attachmentPosition) / getDistance(segmentStart, segmentEnd)\n      };\n    }\n\n    attachmentDistance = getDistance(attachment.position, point);\n\n    if (!closestAttachment || closestAttachmentDistance > attachmentDistance) {\n      closestAttachment = attachment;\n      closestAttachmentDistance = attachmentDistance;\n    }\n  }\n\n  return closestAttachment;\n}\n\n/**\n * Gets the intersection between a circle and a line segment.\n *\n * @param {Point} s1 segment start\n * @param {Point} s2 segment end\n * @param {Point} cc circle center\n * @param {number} cr circle radius\n *\n * @return {Array<Point>} intersections\n */\nfunction getCircleSegmentIntersections(s1, s2, cc, cr) {\n\n  var baX = s2.x - s1.x;\n  var baY = s2.y - s1.y;\n  var caX = cc.x - s1.x;\n  var caY = cc.y - s1.y;\n\n  var a = baX * baX + baY * baY;\n  var bBy2 = baX * caX + baY * caY;\n  var c = caX * caX + caY * caY - cr * cr;\n\n  var pBy2 = bBy2 / a;\n  var q = c / a;\n\n  var disc = pBy2 * pBy2 - q;\n\n  // check against negative value to work around\n  // negative, very close to zero results (-4e-15)\n  // being produced in some environments\n  if (disc < 0 && disc > -0.000001) {\n    disc = 0;\n  }\n\n  if (disc < 0) {\n    return [];\n  }\n\n  // if disc == 0 ... dealt with later\n  var tmpSqrt = sqrt(disc);\n  var abScalingFactor1 = -pBy2 + tmpSqrt;\n  var abScalingFactor2 = -pBy2 - tmpSqrt;\n\n  var i1 = {\n    x: s1.x - baX * abScalingFactor1,\n    y: s1.y - baY * abScalingFactor1\n  };\n\n  if (disc === 0) { // abScalingFactor1 == abScalingFactor2\n    return [ i1 ];\n  }\n\n  var i2 = {\n    x: s1.x - baX * abScalingFactor2,\n    y: s1.y - baY * abScalingFactor2\n  };\n\n  // return only points on line segment\n  return [ i1, i2 ].filter(function(p) {\n    return isPointInSegment(p, s1, s2);\n  });\n}\n\n\nfunction isPointInSegment(p, segmentStart, segmentEnd) {\n  return (\n    fenced(p.x, segmentStart.x, segmentEnd.x) &&\n    fenced(p.y, segmentStart.y, segmentEnd.y)\n  );\n}\n\nfunction fenced(n, rangeStart, rangeEnd) {\n\n  // use matching threshold to work around\n  // precision errors in intersection computation\n\n  return (\n    n >= min(rangeStart, rangeEnd) - EQUAL_THRESHOLD &&\n    n <= max(rangeStart, rangeEnd) + EQUAL_THRESHOLD\n  );\n}\n\n/**\n * Calculate mid of two points.\n *\n * @param {Point} p1\n * @param {Point} p2\n *\n * @return {Point}\n */\nfunction mid(p1, p2) {\n\n  return {\n    x: (p1.x + p2.x) / 2,\n    y: (p1.y + p2.y) / 2\n  };\n}\n\nvar EQUAL_THRESHOLD = 0.1;\n\nfunction pointsEqual(p1, p2) {\n\n  return (\n    abs(p1.x - p2.x) <= EQUAL_THRESHOLD &&\n    abs(p1.y - p2.y) <= EQUAL_THRESHOLD\n  );\n}\n\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/features/modeling/behavior/util/LineAttachmentUtil.js?")},"./node_modules/bpmn-js/lib/features/modeling/util/ModelingUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "G": () => (/* binding */ getParent)\n/* harmony export */ });\nif ("bpmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var _util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/bpmn-js/lib/util/ModelUtil.js");\n}\n\n\n\n\n/**\n * Return the parent of the element with any of the given types.\n *\n * @param {djs.model.Base} element\n * @param {string|Array<string>} anyType\n *\n * @return {djs.model.Base}\n */\nfunction getParent(element, anyType) {\n\n  if (typeof anyType === \'string\') {\n    anyType = [ anyType ];\n  }\n\n  while ((element = element.parent)) {\n    if ((0,_util_ModelUtil__WEBPACK_IMPORTED_MODULE_0__/* .isAny */ .JZ)(element, anyType)) {\n      return element;\n    }\n  }\n\n  return null;\n}\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/features/modeling/util/ModelingUtil.js?')},"./node_modules/bpmn-js/lib/import/Util.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"x\": () => (/* binding */ elementToString)\n/* harmony export */ });\nfunction elementToString(e) {\n  if (!e) {\n    return '<null>';\n  }\n\n  return '<' + e.$type + (e.id ? ' id=\"' + e.id : '') + '\" />';\n}\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/import/Util.js?")},"./node_modules/bpmn-js/lib/util/CompatibilityUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"$\": () => (/* binding */ wrapForCompatibility),\n/* harmony export */   \"S\": () => (/* binding */ ensureCompatDiRef)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n\n\n// TODO(nikku): remove with future bpmn-js version\n\n/**\n * Wraps APIs to check:\n *\n * 1) If a callback is passed -> Warn users about callback deprecation.\n * 2) If Promise class is implemented in current environment.\n *\n * @private\n */\nfunction wrapForCompatibility(api) {\n\n  return function() {\n\n    if (!window.Promise) {\n      throw new Error('Promises is not supported in this environment. Please polyfill Promise.');\n    }\n\n    var argLen = arguments.length;\n    if (argLen >= 1 && (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .mf)(arguments[argLen - 1])) {\n\n      var callback = arguments[argLen - 1];\n\n      console.warn(new Error(\n        'Passing callbacks to ' + api.name + ' is deprecated and will be removed in a future major release. ' +\n        'Please switch to promises: https://bpmn.io/l/moving-to-promises.html'\n      ));\n\n      var argsWithoutCallback = Array.prototype.slice.call(arguments, 0, -1);\n\n      api.apply(this, argsWithoutCallback).then(function(result) {\n\n        var firstKey = Object.keys(result)[0];\n\n        // The APIs we are wrapping all resolve a single item depending on the API.\n        // For instance, importXML resolves { warnings } and saveXML returns { xml }.\n        // That's why we can call the callback with the first item of result.\n        return callback(null, result[firstKey]);\n\n        // Passing a second paramter instead of catch because we don't want to\n        // catch errors thrown by callback().\n      }, function(err) {\n\n        return callback(err, err.warnings);\n      });\n    } else {\n\n      return api.apply(this, arguments);\n    }\n  };\n}\n\n\n// TODO(nikku): remove with future bpmn-js version\n\nvar DI_ERROR_MESSAGE = 'Tried to access di from the businessObject. The di is available through the diagram element only. For more information, see https://github.com/bpmn-io/bpmn-js/issues/1472';\n\nfunction ensureCompatDiRef(businessObject) {\n\n  // bpmnElement can have multiple independent DIs\n  if (!(0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .has */ .e$)(businessObject, 'di')) {\n    Object.defineProperty(businessObject, 'di', {\n      enumerable: false,\n      get: function() {\n        throw new Error(DI_ERROR_MESSAGE);\n      }\n    });\n  }\n}\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/util/CompatibilityUtil.js?")},"./node_modules/bpmn-js/lib/util/DiUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "J5": () => (/* binding */ isEventSubProcess),\n/* harmony export */   "JG": () => (/* binding */ hasEventDefinition),\n/* harmony export */   "_Z": () => (/* binding */ hasCompensateEventDefinition),\n/* harmony export */   "sm": () => (/* binding */ hasErrorEventDefinition),\n/* harmony export */   "ul": () => (/* binding */ isExpanded),\n/* harmony export */   "wQ": () => (/* binding */ hasEscalationEventDefinition),\n/* harmony export */   "yU": () => (/* binding */ isInterrupting)\n/* harmony export */ });\n/* harmony import */ var _ModelUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/bpmn-js/lib/util/ModelUtil.js");\nif ("bpmnFreeEditor" == __webpack_require__.j) {\n\t/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("./node_modules/min-dash/dist/index.esm.js");\n}\n\n\n\n\n\nfunction isExpanded(element, di) {\n\n  if ((0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(element, \'bpmn:CallActivity\')) {\n    return false;\n  }\n\n  if ((0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(element, \'bpmn:SubProcess\')) {\n    di = di || (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__/* .getDi */ .DN)(element);\n\n    if (di && (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(di, \'bpmndi:BPMNPlane\')) {\n      return true;\n    }\n\n    return di && !!di.isExpanded;\n  }\n\n  if ((0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(element, \'bpmn:Participant\')) {\n    return !!(0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__/* .getBusinessObject */ .SS)(element).processRef;\n  }\n\n  return true;\n}\n\nfunction isInterrupting(element) {\n  return element && (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__/* .getBusinessObject */ .SS)(element).isInterrupting !== false;\n}\n\nfunction isEventSubProcess(element) {\n  return element && !!(0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__/* .getBusinessObject */ .SS)(element).triggeredByEvent;\n}\n\nfunction hasEventDefinition(element, eventType) {\n  var bo = (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__/* .getBusinessObject */ .SS)(element),\n      hasEventDefinition = false;\n\n  if (bo.eventDefinitions) {\n    (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .forEach */ .Ed)(bo.eventDefinitions, function(event) {\n      if ((0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(event, eventType)) {\n        hasEventDefinition = true;\n      }\n    });\n  }\n\n  return hasEventDefinition;\n}\n\nfunction hasErrorEventDefinition(element) {\n  return hasEventDefinition(element, \'bpmn:ErrorEventDefinition\');\n}\n\nfunction hasEscalationEventDefinition(element) {\n  return hasEventDefinition(element, \'bpmn:EscalationEventDefinition\');\n}\n\nfunction hasCompensateEventDefinition(element) {\n  return hasEventDefinition(element, \'bpmn:CompensateEventDefinition\');\n}\n\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/util/DiUtil.js?')},"./node_modules/bpmn-js/lib/util/DrilldownUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Ln\": () => (/* binding */ getShapeIdFromPlane),\n/* harmony export */   \"UK\": () => (/* binding */ toPlaneId),\n/* harmony export */   \"k3\": () => (/* binding */ isPlane),\n/* harmony export */   \"sU\": () => (/* binding */ getPlaneIdFromShape)\n/* harmony export */ });\n/* unused harmony export planeSuffix */\n/* harmony import */ var _ModelUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/bpmn-js/lib/util/ModelUtil.js\");\n\n\n\nvar planeSuffix = '_plane';\n\n/**\n * Get primary shape ID for a plane.\n *\n * @param  {djs.model.Base|ModdleElement} element\n *\n * @returns {String}\n */\nfunction getShapeIdFromPlane(element) {\n  var id = element.id;\n\n  return removePlaneSuffix(id);\n}\n\n/**\n * Get plane ID for a primary shape.\n *\n * @param  {djs.model.Base|ModdleElement} element\n *\n * @returns {String}\n */\nfunction getPlaneIdFromShape(element) {\n  var id = element.id;\n\n  if ((0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(element, 'bpmn:SubProcess')) {\n    return addPlaneSuffix(id);\n  }\n\n  return id;\n}\n\n/**\n * Get plane ID for primary shape ID.\n *\n * @param {String} id\n *\n * @returns {String}\n */\nfunction toPlaneId(id) {\n  return addPlaneSuffix(id);\n}\n\n/**\n * Check wether element is plane.\n *\n * @param  {djs.model.Base|ModdleElement} element\n *\n * @returns {Boolean}\n */\nfunction isPlane(element) {\n  var di = (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__/* .getDi */ .DN)(element);\n\n  return (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(di, 'bpmndi:BPMNPlane');\n}\n\nfunction addPlaneSuffix(id) {\n  return id + planeSuffix;\n}\n\nfunction removePlaneSuffix(id) {\n  return id.replace(new RegExp(planeSuffix + '$'), '');\n}\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/util/DrilldownUtil.js?")},"./node_modules/bpmn-js/lib/util/LabelUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DN\": () => (/* binding */ DEFAULT_LABEL_SIZE),\n/* harmony export */   \"fF\": () => (/* binding */ hasExternalLabel),\n/* harmony export */   \"j_\": () => (/* binding */ isLabel),\n/* harmony export */   \"lq\": () => (/* binding */ getExternalLabelBounds),\n/* harmony export */   \"ly\": () => (/* binding */ isLabelExternal),\n/* harmony export */   \"qe\": () => (/* binding */ getExternalLabelMid)\n/* harmony export */ });\n/* unused harmony exports FLOW_LABEL_INDENT, getFlowLabelPosition, getWaypointsMid */\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n/* harmony import */ var _ModelUtil__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(\"./node_modules/bpmn-js/lib/util/ModelUtil.js\");\n\n\n\n\n\nvar DEFAULT_LABEL_SIZE = {\n  width: 90,\n  height: 20\n};\n\nvar FLOW_LABEL_INDENT = 15;\n\n\n/**\n * Returns true if the given semantic has an external label\n *\n * @param {BpmnElement} semantic\n * @return {boolean} true if has label\n */\nfunction isLabelExternal(semantic) {\n  return (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:Event') ||\n         (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:Gateway') ||\n         (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:DataStoreReference') ||\n         (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:DataObjectReference') ||\n         (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:DataInput') ||\n         (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:DataOutput') ||\n         (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:SequenceFlow') ||\n         (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:MessageFlow') ||\n         (0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(semantic, 'bpmn:Group');\n}\n\n/**\n * Returns true if the given element has an external label\n *\n * @param {djs.model.shape} element\n * @return {boolean} true if has label\n */\nfunction hasExternalLabel(element) {\n  return isLabel(element.label);\n}\n\n/**\n * Get the position for sequence flow labels\n *\n * @param  {Array<Point>} waypoints\n * @return {Point} the label position\n */\nfunction getFlowLabelPosition(waypoints) {\n\n  // get the waypoints mid\n  var mid = waypoints.length / 2 - 1;\n\n  var first = waypoints[Math.floor(mid)];\n  var second = waypoints[Math.ceil(mid + 0.01)];\n\n  // get position\n  var position = getWaypointsMid(waypoints);\n\n  // calculate angle\n  var angle = Math.atan((second.y - first.y) / (second.x - first.x));\n\n  var x = position.x,\n      y = position.y;\n\n  if (Math.abs(angle) < Math.PI / 2) {\n    y -= FLOW_LABEL_INDENT;\n  } else {\n    x += FLOW_LABEL_INDENT;\n  }\n\n  return { x: x, y: y };\n}\n\n\n/**\n * Get the middle of a number of waypoints\n *\n * @param  {Array<Point>} waypoints\n * @return {Point} the mid point\n */\nfunction getWaypointsMid(waypoints) {\n\n  var mid = waypoints.length / 2 - 1;\n\n  var first = waypoints[Math.floor(mid)];\n  var second = waypoints[Math.ceil(mid + 0.01)];\n\n  return {\n    x: first.x + (second.x - first.x) / 2,\n    y: first.y + (second.y - first.y) / 2\n  };\n}\n\n\nfunction getExternalLabelMid(element) {\n\n  if (element.waypoints) {\n    return getFlowLabelPosition(element.waypoints);\n  } else if ((0,_ModelUtil__WEBPACK_IMPORTED_MODULE_0__.is)(element, 'bpmn:Group')) {\n    return {\n      x: element.x + element.width / 2,\n      y: element.y + DEFAULT_LABEL_SIZE.height / 2\n    };\n  } else {\n    return {\n      x: element.x + element.width / 2,\n      y: element.y + element.height + DEFAULT_LABEL_SIZE.height / 2\n    };\n  }\n}\n\n\n/**\n * Returns the bounds of an elements label, parsed from the elements DI or\n * generated from its bounds.\n *\n * @param {BpmndDi} di\n * @param {djs.model.Base} element\n */\nfunction getExternalLabelBounds(di, element) {\n\n  var mid,\n      size,\n      bounds,\n      label = di.label;\n\n  if (label && label.bounds) {\n    bounds = label.bounds;\n\n    size = {\n      width: Math.max(DEFAULT_LABEL_SIZE.width, bounds.width),\n      height: bounds.height\n    };\n\n    mid = {\n      x: bounds.x + bounds.width / 2,\n      y: bounds.y + bounds.height / 2\n    };\n  } else {\n\n    mid = getExternalLabelMid(element);\n\n    size = DEFAULT_LABEL_SIZE;\n  }\n\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_1__/* .assign */ .f0)({\n    x: mid.x - size.width / 2,\n    y: mid.y - size.height / 2\n  }, size);\n}\n\nfunction isLabel(element) {\n  return element && !!element.labelTarget;\n}\n\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/util/LabelUtil.js?")},"./node_modules/bpmn-js/lib/util/ModelUtil.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval('/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "DN": () => (/* binding */ getDi),\n/* harmony export */   "JZ": () => (/* binding */ isAny),\n/* harmony export */   "SS": () => (/* binding */ getBusinessObject),\n/* harmony export */   "is": () => (/* binding */ is)\n/* harmony export */ });\n/* harmony import */ var min_dash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("./node_modules/min-dash/dist/index.esm.js");\n\n\n\n/**\n * Is an element of the given BPMN type?\n *\n * @param  {djs.model.Base|ModdleElement} element\n * @param  {string} type\n *\n * @return {boolean}\n */\nfunction is(element, type) {\n  var bo = getBusinessObject(element);\n\n  return bo && (typeof bo.$instanceOf === \'function\') && bo.$instanceOf(type);\n}\n\n\n/**\n * Return true if element has any of the given types.\n *\n * @param {djs.model.Base} element\n * @param {Array<string>} types\n *\n * @return {boolean}\n */\nfunction isAny(element, types) {\n  return (0,min_dash__WEBPACK_IMPORTED_MODULE_0__/* .some */ .G)(types, function(t) {\n    return is(element, t);\n  });\n}\n\n/**\n * Return the business object for a given element.\n *\n * @param  {djs.model.Base|ModdleElement} element\n *\n * @return {ModdleElement}\n */\nfunction getBusinessObject(element) {\n  return (element && element.businessObject) || element;\n}\n\n/**\n * Return the di object for a given element.\n *\n * @param  {djs.model.Base} element\n *\n * @return {ModdleElement}\n */\nfunction getDi(element) {\n  return element && element.di;\n}\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/bpmn-js/lib/util/ModelUtil.js?')}}]);