(()=>{"use strict";var __webpack_modules__={"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{eval('\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nclass VxcpLogger {\n    constructor(pluginName, serviceName, isEnabled = true) {\n        this.pluginName = pluginName;\n        this.serviceName = serviceName;\n        this.isEnabled = isEnabled;\n    }\n    logFatal(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`FATAL@${logHeader}: ${description}`);\n        }\n    }\n    logError(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.error(`ERROR@${logHeader}: ${description}`);\n        }\n    }\n    logWarning(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.warn(`WARNING@${logHeader}: ${description}`);\n        }\n    }\n    logInfo(methodName, description, variablesToLog) {\n        if (!this.isEnabled) {\n            return;\n        }\n        const logHeader = this.getLogHeader(methodName);\n        if (variablesToLog) {\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\n        }\n        else {\n            console.info(`INFO@${logHeader}: ${description}`);\n        }\n    }\n    enableLogging(isEnabled = true) {\n        this.isEnabled = isEnabled;\n    }\n    getLogHeader(methodName) {\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\n    }\n}\nexports["default"] = VxcpLogger;\n\n\n//# sourceURL=webpack://VBCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./configuration/configurationApp.ts":function(__unused_webpack_module,exports,__webpack_require__){eval('\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    var desc = Object.getOwnPropertyDescriptor(m, k);\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\n      desc = { enumerable: true, get: function() { return m[k]; } };\n    }\n    Object.defineProperty(o, k2, desc);\n}) : (function(o, m, k, k2) {\n    if (k2 === undefined) k2 = k;\n    o[k2] = m[k];\n}));\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\n}) : function(o, v) {\n    o["default"] = v;\n});\nvar __importStar = (this && this.__importStar) || function (mod) {\n    if (mod && mod.__esModule) return mod;\n    var result = {};\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\n    __setModuleDefault(result, mod);\n    return result;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { "default": mod };\n};\nObject.defineProperty(exports, "__esModule", ({ value: true }));\nconst utils_1 = __webpack_require__("./common/utils.ts");\nconst notification_1 = __webpack_require__("./common/notification.ts");\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "ConfigurationApp");\nAJS.toInit(($) => __awaiter(void 0, void 0, void 0, function* () {\n    yield lazyLoadI18nTexts();\n    const $startMigrationBtn = $("#vbcp-mar-migration-input-start");\n    const $migrationLoading = $("#vbcp-mar-migration-loading");\n    const $migrationLoadingOverlay = $("#vbcp-mar-migration-loading-overlay");\n    function lazyLoadI18nTexts() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield new Promise((resolve) => {\n                AJS.I18n.get("de.viadee.confluence.bpmn-plugin", resolve);\n            });\n        });\n    }\n    function setMigrationRequest(migrationType) {\n        const xhr = new XMLHttpRequest();\n        xhr.open("GET", AJS.contextPath() + "/rest/bpmn-modeler/1.0/migration/" + migrationType + "/vbcp-macro", true);\n        xhr.onload = () => {\n            if (xhr.status >= 200 && xhr.status < 300) {\n                const heading = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.success");\n                const body = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.success.desc");\n                (0, notification_1.setSuccessMessage)(heading, body, true);\n                $startMigrationBtn.removeClass("loading");\n                $migrationLoading[0].style.visibility = "hidden";\n                $migrationLoadingOverlay[0].style.visibility = "hidden";\n            }\n            else {\n                vxcpLogger.logError("setMigrationRequest", "An error occurred while downgrading of BPMN diagrams. This could be due to diagrams embedded into page drafts.", xhr);\n                const heading2 = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.error");\n                const body2 = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.error.desc");\n                (0, notification_1.setErrorMessage)(heading2, body2, true);\n                $startMigrationBtn.removeClass("loading");\n                $migrationLoading[0].style.visibility = "hidden";\n                $migrationLoadingOverlay[0].style.visibility = "hidden";\n            }\n        };\n        xhr.onerror = () => {\n            vxcpLogger.logError("setMigrationRequest", "An error occurred while downgrading of BPMN diagrams. This could be due to diagrams embedded into page drafts.", xhr);\n            const heading = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.error");\n            const body = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.error.desc");\n            (0, notification_1.setErrorMessage)(heading, body, true);\n            $startMigrationBtn.removeClass("loading");\n            $migrationLoading[0].style.visibility = "hidden";\n            $migrationLoadingOverlay[0].style.visibility = "hidden";\n        };\n        xhr.send();\n    }\n    $startMigrationBtn.click((e) => {\n        e.stopPropagation();\n        e.preventDefault();\n        if ($startMigrationBtn.hasClass("loading")) {\n            return;\n        }\n        $startMigrationBtn.addClass("loading");\n        const migrationWarningDialog = Confluence.Templates.viadee.bpmnplugin.migrationWarningDialog;\n        (0, utils_1.showDialog)(AJS, "#vbcp-ent-dialog-migration-warning", migrationWarningDialog, () => {\n            $migrationLoading[0].style.visibility = "visible";\n            $migrationLoadingOverlay[0].style.visibility = "visible";\n            setMigrationRequest("migrateAllMacros");\n        }, () => {\n            $startMigrationBtn.removeClass("loading");\n        });\n    });\n}));\n\n\n//# sourceURL=webpack://VBCPFREE/./configuration/configurationApp.ts?')}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var r=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(r.exports,r,r.exports,__webpack_require__),r.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,r,i)=>{if(!n){var o=1/0;for(d=0;d<deferred.length;d++){for(var[n,r,i]=deferred[d],t=!0,a=0;a<n.length;a++)(!1&i||o>=i)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[a])))?n.splice(a--,1):(t=!1,i<o&&(o=i));if(t){deferred.splice(d--,1);var s=r();void 0!==s&&(e=s)}}return e}i=i||0;for(var d=deferred.length;d>0&&deferred[d-1][2]>i;d--)deferred[d]=deferred[d-1];deferred[d]=[n,r,i]},__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),(()=>{var e={bpmnFreeAdmin:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,r)=>{var i,o,[t,a,s]=r,d=0;if(t.some((n=>0!==e[n]))){for(i in a)__webpack_require__.o(a,i)&&(__webpack_require__.m[i]=a[i]);if(s)var l=s(__webpack_require__)}for(n&&n(r);d<t.length;d++)o=t[d],__webpack_require__.o(e,o)&&e[o]&&e[o][0](),e[o]=0;return __webpack_require__.O(l)},r=self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[];r.forEach(n.bind(null,0)),r.push=n.bind(null,r.push.bind(r))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnFreeCommon"],(()=>__webpack_require__("./configuration/configurationApp.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCPFREE=window.VBCPFREE||{}).bpmnFreeAdmin=__webpack_exports__})();