/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.service;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import de.viadee.confluence.service.MigrationService;

public class MigrationServiceImpl
implements MigrationService {
    private PageManager pageManager;
    private XhtmlContent xhtmlContent;
    private CQLSearchService searchService;

    public MigrationServiceImpl(XhtmlContent xhtmlContent, PageManager pageManager) {
        this.xhtmlContent = xhtmlContent;
        this.pageManager = pageManager;
    }

    @Override
    public String migrateMacro(String string, final String string2, final String string3) {
        if (string == null || string3 == null) {
            return "Error@migrateMacrosOnPage: Missing parameters.";
        }
        String string4 = this.getFromMacro(string3);
        Long l = Long.parseLong(string);
        AbstractPage abstractPage = this.pageManager.getAbstractPage(l.longValue());
        if (abstractPage == null) {
            return "Error@migrateMacrosOnPage: Page not found.";
        }
        try {
            final String string5 = string4;
            PageContext pageContext = new PageContext((ContentEntityObject)abstractPage);
            DefaultConversionContext defaultConversionContext = new DefaultConversionContext((RenderContext)pageContext);
            ContentEntityObject contentEntityObject = pageContext.getEntity();
            String string6 = this.xhtmlContent.updateMacroDefinitions(contentEntityObject.getBodyAsString(), (ConversionContext)defaultConversionContext, new MacroDefinitionUpdater(){

                public MacroDefinition update(MacroDefinition macroDefinition) {
                    if (macroDefinition.getName().equals(string5) && ((MacroId)macroDefinition.getMacroId().get()).getId().equals(string2)) {
                        macroDefinition.setName(string3);
                    }
                    return macroDefinition;
                }
            });
            contentEntityObject.setBodyAsString(string6);
            SaveContext saveContext = DefaultSaveContext.SUPPRESS_NOTIFICATIONS;
            this.pageManager.saveContentEntity(contentEntityObject, saveContext);
        }
        catch (XhtmlException xhtmlException) {
            return xhtmlException.getMessage();
        }
        return null;
    }

    @Override
    public String migrateMacrosOnPage(String string, final String string2) {
        if (string == null || string2 == null) {
            return "Error@migrateMacrosOnPage: Missing parameters.";
        }
        String string3 = this.getFromMacro(string2);
        Long l = Long.parseLong(string);
        AbstractPage abstractPage = this.pageManager.getAbstractPage(l.longValue());
        if (abstractPage == null) {
            return "Error@migrateMacrosOnPage: Page not found.";
        }
        try {
            final String string4 = string3;
            PageContext pageContext = new PageContext((ContentEntityObject)abstractPage);
            DefaultConversionContext defaultConversionContext = new DefaultConversionContext((RenderContext)pageContext);
            ContentEntityObject contentEntityObject = pageContext.getEntity();
            String string5 = this.xhtmlContent.updateMacroDefinitions(contentEntityObject.getBodyAsString(), (ConversionContext)defaultConversionContext, new MacroDefinitionUpdater(){

                public MacroDefinition update(MacroDefinition macroDefinition) {
                    if (macroDefinition.getName().equals(string4)) {
                        macroDefinition.setName(string2);
                    }
                    return macroDefinition;
                }
            });
            contentEntityObject.setBodyAsString(string5);
            SaveContext saveContext = DefaultSaveContext.SUPPRESS_NOTIFICATIONS;
            this.pageManager.saveContentEntity(contentEntityObject, saveContext);
        }
        catch (XhtmlException xhtmlException) {
            return xhtmlException.getMessage();
        }
        return null;
    }

    @Override
    public String migrateAllMacros(String string) {
        if (string == null) {
            return "Error@migrateAllMacros: Missing parameters.";
        }
        try {
            this.migrateAllMacrosOrSpace(null, string);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        return null;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setXhtmlContent(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    public void setSearchService(CQLSearchService cQLSearchService) {
        this.searchService = cQLSearchService;
    }

    private CQLSearchService getSearchService() {
        if (this.searchService == null) {
            OsgiContainerManager osgiContainerManager = (OsgiContainerManager)ContainerManager.getComponent((String)"osgiContainerManager");
            this.setSearchService((CQLSearchService)osgiContainerManager.getServiceTracker(CQLSearchService.class.getName()).getService());
        }
        return this.searchService;
    }

    private String getFromMacro(String string) {
        String string2 = "";
        switch (string) {
            case "vbcp-macro": {
                string2 = "vbcp-macro-enterprise";
                break;
            }
            case "vbcp-macro-enterprise": {
                string2 = "vbcp-macro";
                break;
            }
            default: {
                return "Error@migrateMacrosOnPage: Wrong macro name given.";
            }
        }
        return string2;
    }

    private PageResponse<Content> getPagesWithMacro(String string, String string2, int n, int n2) {
        SimplePageRequest simplePageRequest = new SimplePageRequest(n, n2);
        String string3 = "macro =  \"".concat(string).concat("\" ");
        if (string2 != null) {
            string3 = string3.concat("and space = ").concat(string2);
        }
        PageResponse pageResponse = this.getSearchService().searchContent(string3, (PageRequest)simplePageRequest, new Expansion[0]);
        return pageResponse;
    }

    private void migrateAllMacrosOrSpace(String string, String string2) {
        boolean bl = true;
        int n = 0;
        int n2 = 500;
        int n3 = n + n2;
        while (bl) {
            PageResponse<Content> pageResponse = this.getPagesWithMacro(this.getFromMacro(string2), string, n, n3);
            if (pageResponse.getResults().size() < n2) {
                bl = false;
            }
            for (Content content : pageResponse.getResults()) {
                String string3 = content.getId().toString();
                String string4 = string3.replaceAll("[^0-9]", "");
                this.migrateMacrosOnPage(string4, string2);
            }
        }
    }
}

