/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.rest;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.user.User;
import de.viadee.confluence.ao.VotesForEnterprise;
import de.viadee.confluence.service.VotesForEnterpriseService;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/votesForEnterprise")
public class VotesForEnterpriseRestService {
    private final PersonalInformationManager personalInformationManager;
    private final ContentPropertyManager contentPropertyManager;
    private final VotesForEnterpriseService votesForEnterpriseService;

    public VotesForEnterpriseRestService(PersonalInformationManager personalInformationManager, ContentPropertyManager contentPropertyManager, VotesForEnterpriseService votesForEnterpriseService) {
        this.personalInformationManager = personalInformationManager;
        this.contentPropertyManager = contentPropertyManager;
        this.votesForEnterpriseService = votesForEnterpriseService;
    }

    @PUT
    @Path(value="/userVote/{userHasVoted}")
    public Response updateVotedForEnterprise(@PathParam(value="userHasVoted") String string) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        if (string != null) {
            this.contentPropertyManager.setStringProperty((ContentEntityObject)personalInformation, "key.userHasVoted", string);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/userVote")
    public Response getUserVotedForEnterprise() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"false").build();
        }
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        String string = this.contentPropertyManager.getStringProperty((ContentEntityObject)personalInformation, "key.userHasVoted");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)string).build();
    }

    @PUT
    @Path(value="/allVotes/{counter}")
    public Response updateAllVotesCounter(@PathParam(value="counter") String string) {
        String string2 = this.votesForEnterpriseService.getKey();
        String string3 = this.getNumberOfVotes();
        this.votesForEnterpriseService.update(string2, string, string3);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/allVotes")
    public Response getAllVotesCounter() {
        String string = this.getNumberOfVotes();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)string).build();
    }

    private String getNumberOfVotes() {
        String string = this.votesForEnterpriseService.getKey();
        try {
            VotesForEnterprise votesForEnterprise = this.votesForEnterpriseService.get(string);
            String string2 = votesForEnterprise.getVoteCount();
            if (Integer.parseInt(string2) < 0) {
                string2 = "0";
            }
            return string2;
        }
        catch (Exception exception) {
            this.votesForEnterpriseService.add(string, "0");
            return "0";
        }
    }
}

