/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.rest;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.user.User;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/settings")
public class Settings {
    private final PersonalInformationManager personalInformationManager;
    private final ContentPropertyManager contentPropertyManager;

    public Settings(PersonalInformationManager personalInformationManager, ContentPropertyManager contentPropertyManager) {
        this.personalInformationManager = personalInformationManager;
        this.contentPropertyManager = contentPropertyManager;
    }

    @PUT
    @Path(value="/lastNewsSeenDate")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public Response updateLastSeenDate(String string) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        if (string != null) {
            this.contentPropertyManager.setStringProperty((ContentEntityObject)personalInformation, "key.last-news-seen-date", string);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

