(()=>{"use strict";var __webpack_modules__={"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{eval('\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nclass VxcpLogger {\r\n    constructor(pluginName, serviceName, isEnabled = true) {\r\n        this.pluginName = pluginName;\r\n        this.serviceName = serviceName;\r\n        this.isEnabled = isEnabled;\r\n    }\r\n    logFatal(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.error(`FATAL@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logError(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.error(`ERROR@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logWarning(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.warn(`WARNING@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logInfo(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.info(`INFO@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    enableLogging(isEnabled = true) {\r\n        this.isEnabled = isEnabled;\r\n    }\r\n    getLogHeader(methodName) {\r\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\r\n    }\r\n}\r\nexports["default"] = VxcpLogger;\r\n\n\n//# sourceURL=webpack://VBCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./viewer/viewerApp.ts":function(__unused_webpack_module,exports,__webpack_require__){eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.ViewerApp = void 0;\r\nconst utils = __importStar(__webpack_require__("./common/utils.ts"));\r\nconst utils_1 = __webpack_require__("./common/utils.ts");\r\nconst enterpriseLicenseChecker = __importStar(__webpack_require__("./common/enterprise-license-checker.ts"));\r\nconst newDiagramXml = __importStar(__webpack_require__("./common/newDiagramXml.ts"));\r\nconst AttachmentManager = __importStar(__webpack_require__("./common/attachment-manager.ts"));\r\nconst bpmn_js_1 = __importDefault(__webpack_require__("./node_modules/bpmn-js/index.js"));\r\nconst NavigatedViewer_1 = __importDefault(__webpack_require__("./node_modules/bpmn-js/lib/NavigatedViewer.js"));\r\nconst diagram_js_origin_1 = __importDefault(__webpack_require__("./node_modules/diagram-js-origin/index.js"));\r\nconst notification_1 = __webpack_require__("./common/notification.ts");\r\nconst voting_service_1 = __webpack_require__("./common/voting-service.ts");\r\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\r\nconst dynamic_content_service_1 = __webpack_require__("./common/dynamic-content-service.ts");\r\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\r\nconst rest_service_1 = __webpack_require__("./common/rest-service.ts");\r\nclass ViewerApp {\r\n    constructor() {\r\n        this.pageId = "";\r\n        this.diagramId = "";\r\n        this.macroId = "";\r\n        this.diagramName = "";\r\n        this.canvasId = "";\r\n        this.fullscreen = false;\r\n        this.enterpriseLicense = "INVALID";\r\n        this.lastNewsSeenDateTime = { date: "", hour: "" };\r\n        this.votingService = new voting_service_1.VotingService();\r\n        this.vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "ViewerApp");\r\n        this.dynamicContentService = new dynamic_content_service_1.DynamicContentService(this.lastNewsSeenDateTime);\r\n    }\r\n    init(pageId, diagramId, diagramName, macroId, fullscreen, lastNewsSeenDateTime = "") {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            this.pageId = pageId;\r\n            this.diagramId = diagramId;\r\n            this.diagramName = diagramName;\r\n            this.fullscreen = fullscreen;\r\n            this.macroId = macroId;\r\n            try {\r\n                const decodedString = lastNewsSeenDateTime.replace(/&quot;/g, \'"\');\r\n                this.lastNewsSeenDateTime = JSON.parse(decodedString);\r\n            }\r\n            catch (e) {\r\n                this.lastNewsSeenDateTime = { date: "", hour: "" };\r\n            }\r\n            this.initJqueryIdentifiers();\r\n            yield this.votingService.init(this.$voteLink, this.$voteCounter);\r\n            this.viewer = fullscreen ? this.initFullscreenViewer() : this.initViewer();\r\n            if (!this.viewer) {\r\n                return;\r\n            }\r\n            (0, notification_1.showEndOfSupportMessage)(this.diagramId);\r\n            enterpriseLicenseChecker.checkEnterprisePluginLicense().then((bpmnPluginEnterpriseActive) => {\r\n                this.enterpriseLicense = bpmnPluginEnterpriseActive;\r\n                if (bpmnPluginEnterpriseActive !== "INVALID") {\r\n                    (0, notification_1.showEnterpriseWithLicenseHint)(this.diagramId);\r\n                }\r\n            });\r\n            if (this.pageId === undefined) {\r\n                this.pageId = utils.getQueryParam("pageId").toString();\r\n            }\r\n            if (this.fullscreen) {\r\n                utils.initZoomButtons(this.viewer);\r\n                yield this.dynamicContentService.initNews(this.lastNewsSeenDateTime);\r\n            }\r\n            else {\r\n                utils.initViadeeLogo(this.diagramName);\r\n            }\r\n            const $expander = this.$viewer.closest(".expand-container");\r\n            $expander.children(".expand-control").on("click", (e) => {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                const bpmnCanvas = this.viewer.get("canvas");\r\n                bpmnCanvas.resized();\r\n                bpmnCanvas.zoom("fit-viewport");\r\n            });\r\n            this.initButtonActions();\r\n            yield this.displayViewer();\r\n            yield this.loadDiagram();\r\n        });\r\n    }\r\n    initJqueryIdentifiers() {\r\n        this.$title = $("#vbcp-diagram-title-" + this.diagramId);\r\n        this.$editLink = this.$title.find("#vbcp-viewer-edit");\r\n        this.$fullscreenLink = this.$title.find("#vbcp-viewer-fullscreen");\r\n        this.$downloadPNGLink = this.$title.find("#vbcp-viewer-download-png");\r\n        this.$diagramVersion = this.$title.find("#vbcp-diagram-version");\r\n        this.$migrateToEnterpriseLink = this.$title.find("#vbcp-viewer-migrate-to-enterprise");\r\n        this.$closeFullscreenLink = this.$title.find("#vbcp-fullscreen-close");\r\n        this.$differLink = this.$title.find("#vbcp-fullscreen-differ");\r\n        this.$viewer = this.fullscreen ? $("#viewer") : $("#viewer-" + this.diagramId);\r\n        this.canvasId = this.fullscreen ? ".canvas-fullscreen-viewer" : ".canvas";\r\n        this.$canvas = this.$viewer.find(this.canvasId);\r\n        this.$loadingText = this.$viewer.find("#diagram-loading");\r\n        this.migratingText = this.$viewer.find("#diagram-migration");\r\n        this.$infoLink = this.$title.find("#vbcp-toolbar-js-info");\r\n        this.$voteLink = this.$title.find("#vbcp-toolbar-js-vote");\r\n        this.$newsLink = this.$title.find("#vbcp-toolbar-news");\r\n        this.$voteCounter = this.$title.find("#vbcp-toolbar-js-vote-counter");\r\n    }\r\n    initButtonActions() {\r\n        if (this.fullscreen) {\r\n            this.$newsLink.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                const updatedLastSeenDate = yield this.dynamicContentService.showNewsMessageBox(this.lastNewsSeenDateTime);\r\n                yield this.updateLastNewsSeenDate(updatedLastSeenDate);\r\n            }));\r\n            this.$voteLink.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                yield this.votingService.voteLinkClickAction();\r\n            }));\r\n            this.$infoLink.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                yield (0, notification_1.showInfoDialogForEnterpriseModeler)(this.votingService, this.enterpriseLicense, () => __awaiter(this, void 0, void 0, function* () {\r\n                    yield this.votingService.toggleVote();\r\n                }));\r\n            }));\r\n            this.$closeFullscreenLink.click((e) => {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                window.open(Confluence.getContextPath() + "/pages/viewpage.action?pageId=" + this.pageId, "_self");\r\n            });\r\n            this.$differLink.click((e) => {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                const featureName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.differ");\r\n                const imgName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.differ.image-src");\r\n                const imgSrc = (0, rest_service_1.buildPluginBaseUrl)() + "/download/resources/de.viadee.confluence.bpmn-plugin/images/" + imgName;\r\n                (0, utils_1.showDialog)(AJS, "#vbcp-enterprise-feature-dialog", Confluence.Templates.viadee.bpmnplugin.enterpriseFeatureDialog, () => {\r\n                    window.open("https://www.viadee.de/en/solutions/business-process-management/bpmn-modeler");\r\n                }, undefined, { featureName, imgSrc });\r\n            });\r\n        }\r\n        else {\r\n            this.$editLink.click((e) => {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                $("body").append(utils.createIFrame(this.pageId, this.diagramId, this.diagramName, this.enterpriseLicense));\r\n            });\r\n            this.$fullscreenLink.click((e) => {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                window.open(Confluence.getContextPath() +\r\n                    "/plugins/bpmn-plugin/view-diagram.action?pageId=" +\r\n                    this.pageId +\r\n                    "&diagramId=" +\r\n                    this.diagramId +\r\n                    "&diagramName=" +\r\n                    this.diagramName +\r\n                    "&enterpriseLicense=" +\r\n                    this.enterpriseLicense, "_self");\r\n            });\r\n            this.$downloadPNGLink.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                const featureName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.png-download");\r\n                const imgName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.png-download.image-src");\r\n                const imgSrc = (0, rest_service_1.buildPluginBaseUrl)() + "/download/resources/de.viadee.confluence.bpmn-plugin/images/" + imgName;\r\n                (0, utils_1.showDialog)(AJS, "#vbcp-enterprise-feature-dialog", Confluence.Templates.viadee.bpmnplugin.enterpriseFeatureDialog, () => {\r\n                    window.open("https://www.viadee.de/en/solutions/business-process-management/bpmn-modeler");\r\n                }, undefined, { featureName, imgSrc });\r\n            }));\r\n        }\r\n        this.$migrateToEnterpriseLink.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            if (this.enterpriseLicense !== "INVALID") {\r\n                yield this.migrateToEnterpriseMacro();\r\n            }\r\n            else {\r\n                yield (0, notification_1.showInfoDialogForEnterpriseModeler)(this.votingService, this.enterpriseLicense, () => __awaiter(this, void 0, void 0, function* () {\r\n                    yield this.votingService.toggleVote();\r\n                }));\r\n            }\r\n        }));\r\n    }\r\n    updateLastNewsSeenDate(updatedLastSeenDate) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            if (this.lastNewsSeenDateTime.date === updatedLastSeenDate.date && this.lastNewsSeenDateTime.hour === updatedLastSeenDate.hour) {\r\n                return;\r\n            }\r\n            this.lastNewsSeenDateTime = updatedLastSeenDate;\r\n            yield this.dynamicContentService.updateLastNewsSeenDate(updatedLastSeenDate);\r\n        });\r\n    }\r\n    migrateToEnterpriseMacro() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            if (this.migratingText.css("display") !== "none") {\r\n                return;\r\n            }\r\n            yield this.migratingText.show();\r\n            $.ajax({\r\n                url: AJS.contextPath() + "/rest/bpmn-modeler/1.0/migration/migrateOneMacro/" + this.pageId + "/" + this.macroId + "/vbcp-macro-enterprise",\r\n                type: "GET",\r\n                success: () => {\r\n                    location.reload();\r\n                },\r\n                error: (err) => {\r\n                    this.vxcpLogger.logError("migrateToEnterpriseMacro", "An error occurred while migrating of BPMN diagrams to Enterprise macro.", err);\r\n                },\r\n            });\r\n        });\r\n    }\r\n    displayViewer() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            yield this.$viewer.show();\r\n            const hideFullscreenLinkCreate = /\\/(create|edit)page\\.action/i.test(window.location.href);\r\n            const hideFullscreenLinkDraftShare = /\\/.*draftShareId.*/i.test(window.location.href);\r\n            const hideFullscreenLink = hideFullscreenLinkCreate || hideFullscreenLinkDraftShare;\r\n            hideFullscreenLink ? this.$fullscreenLink.hide() : this.$fullscreenLink.show();\r\n        });\r\n    }\r\n    displayVersion(version) {\r\n        this.$diagramVersion.html("(v." + version + ")");\r\n    }\r\n    loadDiagram() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            yield this.$loadingText.show();\r\n            return AttachmentManager.loadAttachment(this.diagramName + ".bpmn", this.pageId)\r\n                .then((attachment) => __awaiter(this, void 0, void 0, function* () {\r\n                this.displayVersion(attachment.version || 0);\r\n                yield this.openDiagram(attachment.data);\r\n            }))\r\n                .catch((error) => __awaiter(this, void 0, void 0, function* () {\r\n                yield this.openDiagram(newDiagramXml.getNewDiagramXml());\r\n                yield this.displayViewer();\r\n            }));\r\n        });\r\n    }\r\n    openDiagram(xml) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            try {\r\n                const importedXML = yield this.viewer.importXML(xml);\r\n                utils.removeDjsHelperSvg($);\r\n                this.$loadingText.hide();\r\n                const warnings = importedXML.warnings;\r\n                if (warnings.length) {\r\n                    this.vxcpLogger.logWarning("openDiagram", "An error occurred while opening the BPMN diagram. The BPMN file, which you tried to open has no valid BPMN 2.0 format.", warnings);\r\n                }\r\n                if (this.fullscreen) {\r\n                    utils.moveDiagramToTopLeft(this.viewer, 180, 100);\r\n                }\r\n                const canvas = this.viewer.get("canvas");\r\n                canvas.zoom("fit-viewport");\r\n            }\r\n            catch (err) {\r\n                this.$loadingText.hide();\r\n                this.vxcpLogger.logError("openDiagram", "An error occurred while opening the BPMN diagram. The BPMN file, which you try to open is probably broken or has no valid BPMN 2.0 format.", err);\r\n            }\r\n        });\r\n    }\r\n    initViewer() {\r\n        try {\r\n            const bpmnViewer = new bpmn_js_1.default({\r\n                container: this.$canvas,\r\n            });\r\n            return bpmnViewer;\r\n        }\r\n        catch (e) {\r\n            this.vxcpLogger.logError("initViewer", "An error occurred while initializing the viewer for a diagram.", e);\r\n            return;\r\n        }\r\n    }\r\n    initFullscreenViewer() {\r\n        return new NavigatedViewer_1.default({\r\n            container: this.$canvas,\r\n            additionalModules: [diagram_js_origin_1.default],\r\n        });\r\n    }\r\n}\r\nexports.ViewerApp = ViewerApp;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./viewer/viewerApp.ts?')},"./node_modules/diagram-js-origin/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"default\": () => (/* binding */ diagram_js_origin)\n});\n\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/lib/configure-origin.js\n\n\nvar CROSS_COLOR = '#CCC',\n    BORDER_COLOR = 'rgba(0,0,0,0.1)';\n\n\n/**\n * A diagram-js extension that shows a (0, 0) origin indicator\n * on the canvas as well as (optionally) the canvas borders.\n *\n * @param {Object} [config]\n * @param {Canvas} canvas\n */\nfunction ConfigureOrigin(config, canvas) {\n\n  config = config || {};\n\n  var borderColor = config.borderColor || BORDER_COLOR,\n      crossColor = config.crossColor || CROSS_COLOR ;\n\n  var w = 30, h = 2,\n      w_half = w / 2,\n      s = -h / 2,\n      lineStart = w_half + 7;\n\n  var parent = canvas.getLayer('djs-origin', -1);\n\n  var g,\n      line,\n      cross,\n      label;\n\n  g = createEl('g', {\n    'pointer-events': 'none'\n  });\n\n  (0,index_esm/* append */.R3)(parent, g);\n\n  if (config.showBorder !== false) {\n\n    // the dashed lines, marking positive document coordinates\n    line = createEl('path', {\n      'class': cls('border'),\n      'd': path([\n        'M', -lineStart, s,\n        'H', -1000,\n        'M', lineStart, s,\n        'H', 6000,\n        'M', s, -lineStart,\n        'V', -1000,\n        'M', s, lineStart,\n        'V', 3000\n      ]),\n      'fill': 'none',\n      'stroke': borderColor,\n      'stroke-width': h + 'px',\n      'stroke-dasharray': '6, 6',\n      'shape-rendering': 'crispedges'\n    });\n\n    (0,index_esm/* append */.R3)(g, line);\n  }\n\n  // the cross that marks the diagram origin\n  cross = createEl('path', {\n    d: path([\n      'M', -w_half, s,\n      'H', w_half,\n      'M', s, -w_half,\n      'V', w_half\n    ]),\n    'class': cls('cross'),\n    'fill': 'none',\n    'stroke': crossColor,\n    'stroke-width': h + 'px',\n    'stroke-linecap': 'round'\n  });\n\n  (0,index_esm/* append */.R3)(g, cross);\n\n  label = createEl('text', {\n    x: -40,\n    y: -10,\n    fill: crossColor,\n    'class': cls('label'),\n  });\n\n  label.textContent = '(0, 0)';\n\n  (0,index_esm/* append */.R3)(g, label);\n}\n\nConfigureOrigin.$inject = [\n  'config.origin',\n  'canvas'\n];\n\n\n// helpers ///////////////////////////////////\n\nfunction path(parts) {\n  return parts.join(' ');\n}\n\nfunction cls(name) {\n  return 'djs-origin-' + name;\n}\n\nfunction createEl(type, attrs) {\n\n  var el = (0,index_esm/* create */.Ue)(type);\n\n  (0,index_esm/* attr */.Lj)(el, attrs);\n\n  return el;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/index.js\n\n\n/* harmony default export */ const diagram_js_origin = ({\n  __init__: [\n    ConfigureOrigin\n  ]\n});\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/diagram-js-origin/index.js_+_1_modules?")}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var r=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(r.exports,r,r.exports,__webpack_require__),r.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,r,i)=>{if(!n){var t=1/0;for(c=0;c<deferred.length;c++){for(var[n,r,i]=deferred[c],a=!0,o=0;o<n.length;o++)(!1&i||t>=i)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[o])))?n.splice(o--,1):(a=!1,i<t&&(t=i));if(a){deferred.splice(c--,1);var s=r();void 0!==s&&(e=s)}}return e}i=i||0;for(var c=deferred.length;c>0&&deferred[c-1][2]>i;c--)deferred[c]=deferred[c-1];deferred[c]=[n,r,i]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var r in n)__webpack_require__.o(n,r)&&!__webpack_require__.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:n[r]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.j="bpmnFreeViewer",(()=>{var e={bpmnFreeViewer:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,r)=>{var i,t,[a,o,s]=r,c=0;if(a.some((n=>0!==e[n]))){for(i in o)__webpack_require__.o(o,i)&&(__webpack_require__.m[i]=o[i]);if(s)var d=s(__webpack_require__)}for(n&&n(r);c<a.length;c++)t=a[c],__webpack_require__.o(e,t)&&e[t]&&e[t][0](),e[t]=0;return __webpack_require__.O(d)},r=self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[];r.forEach(n.bind(null,0)),r.push=n.bind(null,r.push.bind(r))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnFreeCommon","bpmnFreeDiagramJs","bpmnFreeBpmnJs","bpmnFreeVendors"],(()=>__webpack_require__("./viewer/viewerApp.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCPFREE=window.VBCPFREE||{}).bpmnFreeViewer=__webpack_exports__})();