(()=>{"use strict";var __webpack_modules__={"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{eval('\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nclass VxcpLogger {\r\n    constructor(pluginName, serviceName, isEnabled = true) {\r\n        this.pluginName = pluginName;\r\n        this.serviceName = serviceName;\r\n        this.isEnabled = isEnabled;\r\n    }\r\n    logFatal(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.error(`FATAL@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logError(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.error(`ERROR@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logWarning(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.warn(`WARNING@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logInfo(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.info(`INFO@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    enableLogging(isEnabled = true) {\r\n        this.isEnabled = isEnabled;\r\n    }\r\n    getLogHeader(methodName) {\r\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\r\n    }\r\n}\r\nexports["default"] = VxcpLogger;\r\n\n\n//# sourceURL=webpack://VBCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./dialogs/macro-dialog.ts":function(__unused_webpack_module,exports,__webpack_require__){eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nconst Validator = __importStar(__webpack_require__("./common/validator.ts"));\r\nconst enterpriseLicenseChecker = __importStar(__webpack_require__("./common/enterprise-license-checker.ts"));\r\nconst utils_1 = __webpack_require__("./common/utils.ts");\r\nAJS.bind("init.rte", () => __awaiter(void 0, void 0, void 0, function* () {\r\n    const macroName = "vbcp-macro";\r\n    const dialogId = "#vbcp-macro-dialog";\r\n    const customDialog = Confluence.Templates.viadee.bpmnplugin.macroDialog();\r\n    $("body").append(customDialog);\r\n    const $cancel = $(dialogId + "-close");\r\n    const $submit = $(dialogId + "-submit");\r\n    const $input = $(dialogId + "-name-input");\r\n    const $error = $(dialogId + "-error");\r\n    yield lazyLoadI18nTexts();\r\n    licenseHandling();\r\n    bindEditorEvents();\r\n    $cancel.off();\r\n    $cancel.click((e) => {\r\n        e.stopPropagation();\r\n        e.preventDefault();\r\n        AJS.dialog2(dialogId).hide();\r\n    });\r\n    $input.keydown((e) => {\r\n        if (e.which === 27) {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            $cancel.click();\r\n        }\r\n    });\r\n    $input.keypress((e) => {\r\n        if (e.which === 13) {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            $submit.click();\r\n        }\r\n    });\r\n    $submit.click((e) => {\r\n        e.stopPropagation();\r\n        e.preventDefault();\r\n        const value = $input.val();\r\n        const name = value ? value.trim() : "";\r\n        Validator.isValidMacroName(name).then((isValidMacroName) => {\r\n            if (name.length === 0) {\r\n                showErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.insert-dialog.minimumLengthWarning"));\r\n            }\r\n            else if (!Validator.isValidInput(name)) {\r\n                showErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.insert-dialog.notValidWarning"));\r\n            }\r\n            else if (name.length > 100) {\r\n                showErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.insert-dialog.nameLengthWarning"));\r\n            }\r\n            else if (!isValidMacroName) {\r\n                showErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.insert-dialog.sameNameWarning"));\r\n            }\r\n            else {\r\n                submitMacro(name);\r\n            }\r\n        });\r\n    });\r\n    function showErrorMessage(message) {\r\n        $error.text(message);\r\n    }\r\n    function clearFields() {\r\n        $input.val("");\r\n        $error.text("");\r\n    }\r\n    function submitMacro(name) {\r\n        const currentParams = {\r\n            diagramName: name,\r\n        };\r\n        const macro = {\r\n            name: macroName,\r\n            params: currentParams,\r\n            defaultParameterValue: "",\r\n            body: "",\r\n        };\r\n        tinymce.confluence.macrobrowser.macroBrowserComplete(macro);\r\n        AJS.dialog2(dialogId).hide();\r\n    }\r\n    function showWarningDialog(warningDialogId, template, callbackContinue, callbackAbort, params) {\r\n        const dialog = template(params);\r\n        $("body").append(dialog);\r\n        AJS.dialog2(warningDialogId).show();\r\n        AJS.dialog2(warningDialogId).on("hide", () => {\r\n            $(warningDialogId).remove();\r\n        });\r\n        $(warningDialogId + "-abort").click((e) => {\r\n            AJS.dialog2(warningDialogId).hide();\r\n            if (typeof callbackAbort === "function") {\r\n                callbackAbort();\r\n            }\r\n        });\r\n        $(warningDialogId + "-continue").click((e) => {\r\n            AJS.dialog2(warningDialogId).hide();\r\n            if (typeof callbackContinue === "function") {\r\n                callbackContinue();\r\n            }\r\n        });\r\n    }\r\n    function insertEditVBCPFree(macro) {\r\n        if ((0, utils_1.getParams)().contentType === "comment") {\r\n            showWarningDialog("#vbcp-no-diagrams-in-comments-dialog", Confluence.Templates.viadee.bpmnplugin.noDiagramsInCommentsDialog);\r\n            return;\r\n        }\r\n        if (macro.params) {\r\n            if ((0, utils_1.getParams)().newPage) {\r\n                showWarningDialog("#vbcp-save-first-dialog", Confluence.Templates.viadee.bpmnplugin.saveFirstDialog);\r\n                return;\r\n            }\r\n            const diagramName = macro.params.diagramName;\r\n            const diagramId = diagramName.replace(/\\s/g, "_");\r\n            let enterpriseLicense = "INVALID";\r\n            enterpriseLicenseChecker.checkEnterprisePluginLicense().then((bpmnPluginEnterpriseActive) => {\r\n                enterpriseLicense = bpmnPluginEnterpriseActive;\r\n            });\r\n            tinymce.confluence.macrobrowser.macroBrowserComplete({\r\n                name: macroName,\r\n                bodyHtml: undefined,\r\n                params: macro.params,\r\n            });\r\n            $("body").append((0, utils_1.createIFrame)((0, utils_1.getParams)().pageId, diagramId, diagramName, enterpriseLicense, false));\r\n        }\r\n        else {\r\n            clearFields();\r\n            AJS.dialog2(dialogId).show();\r\n            $input.focus();\r\n        }\r\n    }\r\n    function licenseHandling() {\r\n        enterpriseLicenseChecker.checkEnterprisePluginLicense().then((data) => {\r\n            const bpmnPluginEnterpriseActive = data;\r\n            if (bpmnPluginEnterpriseActive !== "INVALID") {\r\n                AJS.messages.info($(dialogId + "-license"), {\r\n                    title: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.vbcp-macro.macro-dialog.enterprise-active-title"),\r\n                    body: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.vbcp-macro.macro-dialog.enterprise-active-body"),\r\n                    isClosable: false,\r\n                });\r\n            }\r\n        });\r\n    }\r\n    function lazyLoadI18nTexts() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            yield new Promise((resolve) => {\r\n                AJS.I18n.get("de.viadee.confluence.bpmn-plugin", resolve);\r\n            });\r\n        });\r\n    }\r\n    function bindEditorEvents() {\r\n        AJS.Rte.getEditor().on("beforeSetContent", checkForDuplicateDiagrams.bind(null));\r\n    }\r\n    function checkForDuplicateDiagrams(event) {\r\n        const diagramNames = extractDiagramNameFromHtmlContent(event.content);\r\n        if (!diagramNames) {\r\n            return;\r\n        }\r\n        for (const diagramName of diagramNames) {\r\n            const macroNode = getMacroNodeFromEditorContentByDiagramName(diagramName);\r\n            if (macroNode) {\r\n                event.stopPropagation();\r\n                event.preventDefault();\r\n                showWarningDialog("#vbcp-diagram-already-exists-on-page-dialog", Confluence.Templates.viadee.bpmnplugin.diagramAlreadyExistsOnPageDialog);\r\n                return;\r\n            }\r\n        }\r\n    }\r\n    function extractDiagramNameFromHtmlContent(htmlContent) {\r\n        if (!(htmlContent === null || htmlContent === void 0 ? void 0 : htmlContent.includes("diagramName"))) {\r\n            return null;\r\n        }\r\n        const returnMatches = [];\r\n        const matchesWithBefore = htmlContent.match(/(?:diagramName=)(.*?)(?=["|])/g) || [];\r\n        for (const match of matchesWithBefore) {\r\n            returnMatches.push(match.replace("diagramName=", ""));\r\n        }\r\n        return returnMatches;\r\n    }\r\n    function getMacroNodeFromEditorContentByDiagramName(diagramName) {\r\n        const editorHtml = $("#wysiwygTextarea_ifr").contents().find("#tinymce").prop("outerHTML");\r\n        const parser = new DOMParser();\r\n        const doc = parser.parseFromString(editorHtml, "text/html");\r\n        const list = doc.querySelectorAll("img.editor-inline-macro");\r\n        const nodeListWithAllMacros = Array.prototype.slice.call(list);\r\n        for (const curMacro of nodeListWithAllMacros) {\r\n            const curMacroName = curMacro.getAttribute("data-macro-name");\r\n            const macroParams = curMacro.getAttribute("data-macro-parameters");\r\n            if (curMacroName.includes(macroName) && macroParams.indexOf(`diagramName=${diagramName}`) >= 0) {\r\n                return curMacro;\r\n            }\r\n        }\r\n        return null;\r\n    }\r\n    AJS.MacroBrowser.setMacroJsOverride(macroName, {\r\n        opener: insertEditVBCPFree,\r\n    });\r\n}));\r\n\n\n//# sourceURL=webpack://VBCPFREE/./dialogs/macro-dialog.ts?')}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var r=__webpack_module_cache__[e];if(void 0!==r)return r.exports;var n=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(n.exports,n,n.exports,__webpack_require__),n.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,r,n,a)=>{if(!r){var o=1/0;for(s=0;s<deferred.length;s++){for(var[r,n,a]=deferred[s],t=!0,i=0;i<r.length;i++)(!1&a||o>=a)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](r[i])))?r.splice(i--,1):(t=!1,a<o&&(o=a));if(t){deferred.splice(s--,1);var c=n();void 0!==c&&(e=c)}}return e}a=a||0;for(var s=deferred.length;s>0&&deferred[s-1][2]>a;s--)deferred[s]=deferred[s-1];deferred[s]=[r,n,a]},__webpack_require__.o=(e,r)=>Object.prototype.hasOwnProperty.call(e,r),(()=>{var e={bpmnFreeMacroDialog:0};__webpack_require__.O.j=r=>0===e[r];var r=(r,n)=>{var a,o,[t,i,c]=n,s=0;if(t.some((r=>0!==e[r]))){for(a in i)__webpack_require__.o(i,a)&&(__webpack_require__.m[a]=i[a]);if(c)var l=c(__webpack_require__)}for(r&&r(n);s<t.length;s++)o=t[s],__webpack_require__.o(e,o)&&e[o]&&e[o][0](),e[o]=0;return __webpack_require__.O(l)},n=self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[];n.forEach(r.bind(null,0)),n.push=r.bind(null,n.push.bind(n))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnFreeCommon"],(()=>__webpack_require__("./dialogs/macro-dialog.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCPFREE=window.VBCPFREE||{}).bpmnFreeMacroDialog=__webpack_exports__})();