(()=>{"use strict";var __webpack_modules__={"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{eval('\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nclass VxcpLogger {\r\n    constructor(pluginName, serviceName, isEnabled = true) {\r\n        this.pluginName = pluginName;\r\n        this.serviceName = serviceName;\r\n        this.isEnabled = isEnabled;\r\n    }\r\n    logFatal(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.error(`FATAL@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logError(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.error(`ERROR@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logWarning(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.warn(`WARNING@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logInfo(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.info(`INFO@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    enableLogging(isEnabled = true) {\r\n        this.isEnabled = isEnabled;\r\n    }\r\n    getLogHeader(methodName) {\r\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\r\n    }\r\n}\r\nexports["default"] = VxcpLogger;\r\n\n\n//# sourceURL=webpack://VBCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./editor/editorApp.ts":function(__unused_webpack_module,exports,__webpack_require__){eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.EditorApp = void 0;\r\nconst confUtils = __importStar(__webpack_require__("./common/utils.ts"));\r\nconst Modeler_1 = __importDefault(__webpack_require__("./node_modules/bpmn-js/lib/Modeler.js"));\r\nconst DiagramState = __importStar(__webpack_require__("./common/diagram-state.ts"));\r\nconst DiagramManager = __importStar(__webpack_require__("./common/diagram-manager.ts"));\r\nconst diagram_js_origin_1 = __importDefault(__webpack_require__("./node_modules/diagram-js-origin/index.js"));\r\nconst notification_1 = __webpack_require__("./common/notification.ts");\r\nconst voting_service_1 = __webpack_require__("./common/voting-service.ts");\r\nconst dynamic_content_service_1 = __webpack_require__("./common/dynamic-content-service.ts");\r\nconst file_saver_1 = __importDefault(__webpack_require__("./node_modules/file-saver/dist/FileSaver.min.js"));\r\nconst rest_service_1 = __webpack_require__("./common/rest-service.ts");\r\nclass EditorApp {\r\n    constructor() {\r\n        this.lastNewsSeenDateTime = { date: "", hour: "" };\r\n        this.pageId = "";\r\n        this.diagramName = "";\r\n        this.enterpriseLicense = "";\r\n        this.votingService = new voting_service_1.VotingService();\r\n        this.dynamicContentService = new dynamic_content_service_1.DynamicContentService(this.lastNewsSeenDateTime);\r\n    }\r\n    init(pageId, diagramId, diagramName, enterpriseLicense, lastNewsSeenDateTime = "") {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            this.pageId = pageId;\r\n            this.diagramName = diagramName;\r\n            this.enterpriseLicense = enterpriseLicense;\r\n            try {\r\n                const decodedString = lastNewsSeenDateTime.replace(/&quot;/g, \'"\');\r\n                this.lastNewsSeenDateTime = JSON.parse(decodedString);\r\n            }\r\n            catch (e) {\r\n                this.lastNewsSeenDateTime = { date: "", hour: "" };\r\n            }\r\n            this.initJqueryIdentifiers();\r\n            this.modeler = this.initModeler();\r\n            this.initButtonActions();\r\n            this.initShortcuts();\r\n            this.initLeavePageAction();\r\n            this.initDragAndDrop();\r\n            this.initFileUpload();\r\n            yield this.votingService.init(this.$voteLink, this.$voteCounter);\r\n            confUtils.initZoomButtons(this.modeler);\r\n            yield DiagramManager.loadDiagram(this.modeler, diagramName, pageId, false);\r\n            yield this.dynamicContentService.initNews(this.lastNewsSeenDateTime);\r\n            this.modeler.on("commandStack.changed", () => {\r\n                this.onDiagramChange(this.modeler, diagramName, pageId);\r\n            });\r\n            if (this.$voteLink.is(":visible")) {\r\n                setTimeout(() => {\r\n                    (0, notification_1.showAdForEnterpriseEditor)(this.votingService, this.enterpriseLicense);\r\n                }, 120000);\r\n            }\r\n        });\r\n    }\r\n    initJqueryIdentifiers() {\r\n        this.$modeler = $("#modeler");\r\n        this.$title = $("#vbcp-diagram-title");\r\n        this.$toolbar = $(".toolbar");\r\n        this.$container = this.$modeler.find(".content");\r\n        this.$canvas = this.$modeler.find(".canvas-editor");\r\n        this.$downloadLinkBpmn = this.$toolbar.find("#vbcp-toolbar-js-download");\r\n        this.$downloadLinkSvg = this.$toolbar.find("#vbcp-toolbar-js-download-svg");\r\n        this.$saveLink = this.$toolbar.find("#vbcp-toolbar-js-save");\r\n        this.$resetLink = this.$toolbar.find("#vbcp-toolbar-js-reset");\r\n        this.$importLink = this.$toolbar.find("#vbcp-toolbar-js-import");\r\n        this.$importInput = this.$toolbar.find("#vbcp-diagram-import");\r\n        this.$diagramConfigLink = this.$toolbar.find("#vbcp-toolbar-diagram-config");\r\n        this.$exitLink = this.$title.find("#vbcp-toolbar-js-exit");\r\n        this.$infoLink = this.$title.find("#vbcp-toolbar-js-info");\r\n        this.$voteLink = this.$title.find("#vbcp-toolbar-js-vote");\r\n        this.$newsLink = this.$title.find("#vbcp-toolbar-news");\r\n        this.$voteCounter = this.$title.find("#vbcp-toolbar-js-vote-counter");\r\n        this.$diagramNameLabel = this.$title.find("#vbcp-diagram-name");\r\n    }\r\n    initModeler() {\r\n        return new Modeler_1.default({\r\n            container: this.$canvas,\r\n            additionalModules: [diagram_js_origin_1.default],\r\n            keyboard: { bindTo: document },\r\n        });\r\n    }\r\n    initFileUpload() {\r\n        const input = document.getElementById("vbcp-diagram-import");\r\n        const keyFile = "File";\r\n        const keyFileReader = "FileReader";\r\n        const keyFileList = "FileList";\r\n        if (!window[keyFile] || !window[keyFileReader] || !window[keyFileList] || !window.Blob) {\r\n            alert("The File APIs are not fully supported in this browser.");\r\n            return;\r\n        }\r\n        if (!input) {\r\n            alert("Could not find the file input element.");\r\n        }\r\n        else if (!input.files) {\r\n            alert("This browser does not seem to support the `files` property of file inputs.");\r\n        }\r\n        else {\r\n            input.addEventListener("change", () => {\r\n                const file = input.files[0];\r\n                if (file.name.match(/\\.(bpmn|xml)$/)) {\r\n                    const reader = new FileReader();\r\n                    reader.onload = () => __awaiter(this, void 0, void 0, function* () {\r\n                        yield DiagramManager.openDiagram(this.modeler, reader.result, this.diagramName, () => {\r\n                            this.onDiagramChange(this.modeler, this.diagramName, this.pageId);\r\n                        });\r\n                    });\r\n                    reader.readAsText(file);\r\n                }\r\n                else {\r\n                    confUtils.showDialog(AJS, "#vbcp-file-warning-dialog", Confluence.Templates.viadee.bpmnplugin.fileWarningDialog);\r\n                }\r\n            });\r\n            input.onclick = (e) => {\r\n                e.target.value = null;\r\n            };\r\n        }\r\n    }\r\n    initButtonActions() {\r\n        this.$newsLink.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            const updatedLastSeenDate = yield this.dynamicContentService.showNewsMessageBox(this.lastNewsSeenDateTime);\r\n            yield this.updateLastNewsSeenDate(updatedLastSeenDate);\r\n        }));\r\n        this.$voteLink.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            yield this.votingService.voteLinkClickAction();\r\n        }));\r\n        this.$exitLink.click((e) => {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            if (!DiagramState.isDiagramSaved()) {\r\n                confUtils.showDialog(AJS, "#vbcp-exit-warning-dialog", Confluence.Templates.viadee.bpmnplugin.exitWarningDialog, this.exitModeler);\r\n            }\r\n            else {\r\n                this.exitModeler();\r\n            }\r\n        });\r\n        this.$diagramConfigLink.click((e) => {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            const featureName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.diagram-configuration");\r\n            const imgName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.enterprise-feature-dialog.diagram-configuration.image-src");\r\n            const imgSrc = (0, rest_service_1.buildPluginBaseUrl)() + "/download/resources/de.viadee.confluence.bpmn-plugin/images/" + imgName;\r\n            confUtils.showDialog(AJS, "#vbcp-enterprise-feature-dialog", Confluence.Templates.viadee.bpmnplugin.enterpriseFeatureDialog, () => {\r\n                window.open("https://www.viadee.de/en/solutions/business-process-management/bpmn-modeler");\r\n            }, undefined, { featureName, imgSrc });\r\n        });\r\n        this.$infoLink.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            yield (0, notification_1.showInfoDialogForEnterpriseModeler)(this.votingService, this.enterpriseLicense, () => __awaiter(this, void 0, void 0, function* () {\r\n                yield this.votingService.toggleVote();\r\n            }));\r\n        }));\r\n        this.$importLink.click((e) => {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            if (!DiagramState.isDiagramSaved()) {\r\n                confUtils.showDialog(AJS, "#vbcp-import-warning-dialog", Confluence.Templates.viadee.bpmnplugin.importWarningDialog, () => {\r\n                    this.$importInput.click();\r\n                });\r\n            }\r\n            else {\r\n                this.$importInput.click();\r\n            }\r\n        });\r\n        $(".buttons a").click((e) => {\r\n            if (!$(e.target).is(".active")) {\r\n                e.preventDefault();\r\n                e.stopPropagation();\r\n            }\r\n        });\r\n        this.$downloadLinkBpmn.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            const xml = yield DiagramManager.getDiagramXML(this.modeler);\r\n            const blobObject = new Blob([xml]);\r\n            this.downloadBlob(blobObject, this.diagramName, ".bpmn");\r\n        }));\r\n        this.$downloadLinkSvg.click((e) => __awaiter(this, void 0, void 0, function* () {\r\n            e.stopPropagation();\r\n            e.preventDefault();\r\n            const svg = yield DiagramManager.getDiagramSVG(this.modeler);\r\n            const svgBlob = new Blob([svg]);\r\n            this.downloadBlob(svgBlob, this.diagramName, ".svg");\r\n        }));\r\n    }\r\n    downloadBlob(fileBlob, fileName, fileType) {\r\n        if (!(fileBlob instanceof Blob)) {\r\n            fileBlob = new Blob([fileBlob]);\r\n        }\r\n        try {\r\n            file_saver_1.default.saveAs(fileBlob, fileName + fileType);\r\n        }\r\n        catch (e) {\r\n            alert("The file could not be downloaded. Please try a different browser.");\r\n        }\r\n    }\r\n    initShortcuts() {\r\n        window.addEventListener("keypress", (e) => {\r\n            e.stopImmediatePropagation();\r\n        }, true);\r\n        $(window).bind("keypress", (event) => {\r\n            this.checkKeyCodes(event);\r\n        });\r\n        $(window).bind("keydown", (event) => {\r\n            this.checkKeyCodes(event);\r\n        });\r\n    }\r\n    checkKeyCodes(event) {\r\n        if ((event.ctrlKey || event.metaKey) && String.fromCharCode(event.which).toLowerCase() === "s") {\r\n            event.preventDefault();\r\n            this.$saveLink.click();\r\n        }\r\n    }\r\n    initLeavePageAction() {\r\n        window.onbeforeunload = () => {\r\n            if (DiagramState.isDiagramSaved()) {\r\n                return;\r\n            }\r\n            return AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.exit-warning-dialog.desc");\r\n        };\r\n    }\r\n    initDragAndDrop() {\r\n        function registerFileDrop($container, callback) {\r\n            function handleFileSelect(e) {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                const files = e.dataTransfer.files;\r\n                const file = files[0];\r\n                const reader = new FileReader();\r\n                reader.onload = (event) => {\r\n                    const currentElement = event.target;\r\n                    const xml = currentElement.result;\r\n                    callback(xml);\r\n                };\r\n                reader.readAsText(file);\r\n            }\r\n            function handleDragOver(e) {\r\n                e.stopPropagation();\r\n                e.preventDefault();\r\n                e.dataTransfer.dropEffect = "copy";\r\n            }\r\n            $container.get(0).addEventListener("dragover", handleDragOver, false);\r\n            $container.get(0).addEventListener("drop", handleFileSelect, false);\r\n        }\r\n        $(document).on("keypress", (e) => {\r\n            const body = e.target;\r\n            if (body && body.contentEditable && body.classList) {\r\n                e.stopImmediatePropagation();\r\n            }\r\n        });\r\n        const keyFileList = "FileList";\r\n        const keyFileReader = "FileReader";\r\n        if (!window[keyFileList] || !window[keyFileReader]) {\r\n            window.alert(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.editor.notification.diagramUpdated"));\r\n        }\r\n        else {\r\n            registerFileDrop(this.$container, (xml) => __awaiter(this, void 0, void 0, function* () {\r\n                if (!DiagramState.isDiagramSaved()) {\r\n                    confUtils.showDialog(AJS, "#vbcp-import-warning-dialog", Confluence.Templates.viadee.bpmnplugin.importWarningDialog, () => __awaiter(this, void 0, void 0, function* () {\r\n                        yield DiagramManager.openDiagram(this.modeler, xml, this.diagramName, () => {\r\n                            this.onDiagramChange(this.modeler, this.diagramName, this.pageId);\r\n                        });\r\n                    }));\r\n                }\r\n                else {\r\n                    yield DiagramManager.openDiagram(this.modeler, xml, this.diagramName, () => {\r\n                        this.onDiagramChange(this.modeler, this.diagramName, this.pageId);\r\n                    });\r\n                }\r\n            }));\r\n        }\r\n    }\r\n    onDiagramChange(modeler, diagramName, pageId) {\r\n        this.$saveLink.addClass("active");\r\n        this.$resetLink.addClass("active");\r\n        this.$diagramNameLabel.html(diagramName + "*").css("font-style", "italic");\r\n        DiagramState.saveDiagram(false);\r\n        activateButton(this.$saveLink, () => {\r\n            DiagramManager.saveDiagram(modeler, diagramName, pageId);\r\n        });\r\n        activateButton(this.$resetLink, () => __awaiter(this, void 0, void 0, function* () {\r\n            yield DiagramManager.loadDiagram(modeler, diagramName, pageId, true);\r\n        }));\r\n        function activateButton($link, action) {\r\n            $link.css({ cursor: "pointer" });\r\n            $link.off();\r\n            $link.click((e) => {\r\n                e.preventDefault();\r\n                e.stopPropagation();\r\n                action();\r\n            });\r\n        }\r\n    }\r\n    updateLastNewsSeenDate(updatedLastSeenDate) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            if (this.lastNewsSeenDateTime.date === updatedLastSeenDate.date && this.lastNewsSeenDateTime.hour === updatedLastSeenDate.hour) {\r\n                return;\r\n            }\r\n            this.lastNewsSeenDateTime = updatedLastSeenDate;\r\n            yield this.dynamicContentService.updateLastNewsSeenDate(updatedLastSeenDate);\r\n        });\r\n    }\r\n    exitModeler() {\r\n        DiagramState.saveDiagram(true);\r\n        const reloadPage = confUtils.getQueryParam("reloadPage");\r\n        if (reloadPage === "true") {\r\n            window.parent.location.reload();\r\n        }\r\n        else {\r\n            $("body", window.parent.document).css("overflow", "");\r\n            $("#bpmn-editor", window.parent.document).remove();\r\n        }\r\n    }\r\n}\r\nexports.EditorApp = EditorApp;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./editor/editorApp.ts?')},"./node_modules/diagram-js-direct-editing/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"Z\": () => (/* binding */ diagram_js_direct_editing)\n});\n\n// EXTERNAL MODULE: ./node_modules/diagram-js/lib/features/interaction-events/index.js + 1 modules\nvar interaction_events = __webpack_require__(\"./node_modules/diagram-js/lib/features/interaction-events/index.js\");\n// EXTERNAL MODULE: ./node_modules/min-dash/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/min-dash/dist/index.esm.js\");\n// EXTERNAL MODULE: ./node_modules/min-dom/dist/index.esm.js\nvar dist_index_esm = __webpack_require__(\"./node_modules/min-dom/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-direct-editing/lib/TextBox.js\n\n\n\n\nvar min = Math.min,\n    max = Math.max;\n\nfunction preventDefault(e) {\n  e.preventDefault();\n}\n\nfunction stopPropagation(e) {\n  e.stopPropagation();\n}\n\nfunction isTextNode(node) {\n  return node.nodeType === Node.TEXT_NODE;\n}\n\nfunction toArray(nodeList) {\n  return [].slice.call(nodeList);\n}\n\n/**\n * Initializes a container for a content editable div.\n *\n * Structure:\n *\n * container\n *   parent\n *     content\n *     resize-handle\n *\n * @param {object} options\n * @param {DOMElement} options.container The DOM element to append the contentContainer to\n * @param {Function} options.keyHandler Handler for key events\n * @param {Function} options.resizeHandler Handler for resize events\n */\nfunction TextBox(options) {\n  this.container = options.container;\n\n  this.parent = (0,dist_index_esm/* domify */.H6)(\n    '<div class=\"djs-direct-editing-parent\">' +\n      '<div class=\"djs-direct-editing-content\" contenteditable=\"true\"></div>' +\n    '</div>'\n  );\n\n  this.content = (0,dist_index_esm/* query */.IO)('[contenteditable]', this.parent);\n\n  this.keyHandler = options.keyHandler || function() {};\n  this.resizeHandler = options.resizeHandler || function() {};\n\n  this.autoResize = (0,index_esm/* bind */.ak)(this.autoResize, this);\n  this.handlePaste = (0,index_esm/* bind */.ak)(this.handlePaste, this);\n}\n\n\n/**\n * Create a text box with the given position, size, style and text content\n *\n * @param {Object} bounds\n * @param {Number} bounds.x absolute x position\n * @param {Number} bounds.y absolute y position\n * @param {Number} [bounds.width] fixed width value\n * @param {Number} [bounds.height] fixed height value\n * @param {Number} [bounds.maxWidth] maximum width value\n * @param {Number} [bounds.maxHeight] maximum height value\n * @param {Number} [bounds.minWidth] minimum width value\n * @param {Number} [bounds.minHeight] minimum height value\n * @param {Object} [style]\n * @param {String} value text content\n *\n * @return {DOMElement} The created content DOM element\n */\nTextBox.prototype.create = function(bounds, style, value, options) {\n  var self = this;\n\n  var parent = this.parent,\n      content = this.content,\n      container = this.container;\n\n  options = this.options = options || {};\n\n  style = this.style = style || {};\n\n  var parentStyle = (0,index_esm/* pick */.ei)(style, [\n    'width',\n    'height',\n    'maxWidth',\n    'maxHeight',\n    'minWidth',\n    'minHeight',\n    'left',\n    'top',\n    'backgroundColor',\n    'position',\n    'overflow',\n    'border',\n    'wordWrap',\n    'textAlign',\n    'outline',\n    'transform'\n  ]);\n\n  (0,index_esm/* assign */.f0)(parent.style, {\n    width: bounds.width + 'px',\n    height: bounds.height + 'px',\n    maxWidth: bounds.maxWidth + 'px',\n    maxHeight: bounds.maxHeight + 'px',\n    minWidth: bounds.minWidth + 'px',\n    minHeight: bounds.minHeight + 'px',\n    left: bounds.x + 'px',\n    top: bounds.y + 'px',\n    backgroundColor: '#ffffff',\n    position: 'absolute',\n    overflow: 'visible',\n    border: '1px solid #ccc',\n    boxSizing: 'border-box',\n    wordWrap: 'normal',\n    textAlign: 'center',\n    outline: 'none'\n  }, parentStyle);\n\n  var contentStyle = (0,index_esm/* pick */.ei)(style, [\n    'fontFamily',\n    'fontSize',\n    'fontWeight',\n    'lineHeight',\n    'padding',\n    'paddingTop',\n    'paddingRight',\n    'paddingBottom',\n    'paddingLeft'\n  ]);\n\n  (0,index_esm/* assign */.f0)(content.style, {\n    boxSizing: 'border-box',\n    width: '100%',\n    outline: 'none',\n    wordWrap: 'break-word'\n  }, contentStyle);\n\n  if (options.centerVertically) {\n    (0,index_esm/* assign */.f0)(content.style, {\n      position: 'absolute',\n      top: '50%',\n      transform: 'translate(0, -50%)'\n    }, contentStyle);\n  }\n\n  content.innerText = value;\n\n  dist_index_esm/* event.bind */.B.bind(content, 'keydown', this.keyHandler);\n  dist_index_esm/* event.bind */.B.bind(content, 'mousedown', stopPropagation);\n  dist_index_esm/* event.bind */.B.bind(content, 'paste', self.handlePaste);\n\n  if (options.autoResize) {\n    dist_index_esm/* event.bind */.B.bind(content, 'input', this.autoResize);\n  }\n\n  if (options.resizable) {\n    this.resizable(style);\n  }\n\n  container.appendChild(parent);\n\n  // set selection to end of text\n  this.setSelection(content.lastChild, content.lastChild && content.lastChild.length);\n\n  return parent;\n};\n\n/**\n * Intercept paste events to remove formatting from pasted text.\n */\nTextBox.prototype.handlePaste = function(e) {\n  var options = this.options,\n      style = this.style;\n\n  e.preventDefault();\n\n  var text;\n\n  if (e.clipboardData) {\n\n    // Chrome, Firefox, Safari\n    text = e.clipboardData.getData('text/plain');\n  } else {\n\n    // Internet Explorer\n    text = window.clipboardData.getData('Text');\n  }\n\n  this.insertText(text);\n\n  if (options.autoResize) {\n    var hasResized = this.autoResize(style);\n\n    if (hasResized) {\n      this.resizeHandler(hasResized);\n    }\n  }\n};\n\nTextBox.prototype.insertText = function(text) {\n  text = normalizeEndOfLineSequences(text);\n\n  // insertText command not supported by Internet Explorer\n  var success = document.execCommand('insertText', false, text);\n\n  if (success) {\n    return;\n  }\n\n  this._insertTextIE(text);\n};\n\nTextBox.prototype._insertTextIE = function(text) {\n\n  // Internet Explorer\n  var range = this.getSelection(),\n      startContainer = range.startContainer,\n      endContainer = range.endContainer,\n      startOffset = range.startOffset,\n      endOffset = range.endOffset,\n      commonAncestorContainer = range.commonAncestorContainer;\n\n  var childNodesArray = toArray(commonAncestorContainer.childNodes);\n\n  var container,\n      offset;\n\n  if (isTextNode(commonAncestorContainer)) {\n    var containerTextContent = startContainer.textContent;\n\n    startContainer.textContent =\n      containerTextContent.substring(0, startOffset)\n      + text\n      + containerTextContent.substring(endOffset);\n\n    container = startContainer;\n    offset = startOffset + text.length;\n\n  } else if (startContainer === this.content && endContainer === this.content) {\n    var textNode = document.createTextNode(text);\n\n    this.content.insertBefore(textNode, childNodesArray[startOffset]);\n\n    container = textNode;\n    offset = textNode.textContent.length;\n  } else {\n    var startContainerChildIndex = childNodesArray.indexOf(startContainer),\n        endContainerChildIndex = childNodesArray.indexOf(endContainer);\n\n    childNodesArray.forEach(function(childNode, index) {\n\n      if (index === startContainerChildIndex) {\n        childNode.textContent =\n          startContainer.textContent.substring(0, startOffset) +\n          text +\n          endContainer.textContent.substring(endOffset);\n      } else if (index > startContainerChildIndex && index <= endContainerChildIndex) {\n        (0,dist_index_esm/* remove */.Od)(childNode);\n      }\n    });\n\n    container = startContainer;\n    offset = startOffset + text.length;\n  }\n\n  if (container && offset !== undefined) {\n\n    // is necessary in Internet Explorer\n    setTimeout(function() {\n      self.setSelection(container, offset);\n    });\n  }\n};\n\n/**\n * Automatically resize element vertically to fit its content.\n */\nTextBox.prototype.autoResize = function() {\n  var parent = this.parent,\n      content = this.content;\n\n  var fontSize = parseInt(this.style.fontSize) || 12;\n\n  if (content.scrollHeight > parent.offsetHeight ||\n      content.scrollHeight < parent.offsetHeight - fontSize) {\n    var bounds = parent.getBoundingClientRect();\n\n    var height = content.scrollHeight;\n    parent.style.height = height + 'px';\n\n    this.resizeHandler({\n      width: bounds.width,\n      height: bounds.height,\n      dx: 0,\n      dy: height - bounds.height\n    });\n  }\n};\n\n/**\n * Make an element resizable by adding a resize handle.\n */\nTextBox.prototype.resizable = function() {\n  var self = this;\n\n  var parent = this.parent,\n      resizeHandle = this.resizeHandle;\n\n  var minWidth = parseInt(this.style.minWidth) || 0,\n      minHeight = parseInt(this.style.minHeight) || 0,\n      maxWidth = parseInt(this.style.maxWidth) || Infinity,\n      maxHeight = parseInt(this.style.maxHeight) || Infinity;\n\n  if (!resizeHandle) {\n    resizeHandle = this.resizeHandle = (0,dist_index_esm/* domify */.H6)(\n      '<div class=\"djs-direct-editing-resize-handle\"></div>'\n    );\n\n    var startX, startY, startWidth, startHeight;\n\n    var onMouseDown = function(e) {\n      preventDefault(e);\n      stopPropagation(e);\n\n      startX = e.clientX;\n      startY = e.clientY;\n\n      var bounds = parent.getBoundingClientRect();\n\n      startWidth = bounds.width;\n      startHeight = bounds.height;\n\n      dist_index_esm/* event.bind */.B.bind(document, 'mousemove', onMouseMove);\n      dist_index_esm/* event.bind */.B.bind(document, 'mouseup', onMouseUp);\n    };\n\n    var onMouseMove = function(e) {\n      preventDefault(e);\n      stopPropagation(e);\n\n      var newWidth = min(max(startWidth + e.clientX - startX, minWidth), maxWidth);\n      var newHeight = min(max(startHeight + e.clientY - startY, minHeight), maxHeight);\n\n      parent.style.width = newWidth + 'px';\n      parent.style.height = newHeight + 'px';\n\n      self.resizeHandler({\n        width: startWidth,\n        height: startHeight,\n        dx: e.clientX - startX,\n        dy: e.clientY - startY\n      });\n    };\n\n    var onMouseUp = function(e) {\n      preventDefault(e);\n      stopPropagation(e);\n\n      dist_index_esm/* event.unbind */.B.unbind(document,'mousemove', onMouseMove, false);\n      dist_index_esm/* event.unbind */.B.unbind(document, 'mouseup', onMouseUp, false);\n    };\n\n    dist_index_esm/* event.bind */.B.bind(resizeHandle, 'mousedown', onMouseDown);\n  }\n\n  (0,index_esm/* assign */.f0)(resizeHandle.style, {\n    position: 'absolute',\n    bottom: '0px',\n    right: '0px',\n    cursor: 'nwse-resize',\n    width: '0',\n    height: '0',\n    borderTop: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent',\n    borderRight: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',\n    borderBottom: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid #ccc',\n    borderLeft: (parseInt(this.style.fontSize) / 4 || 3) + 'px solid transparent'\n  });\n\n  parent.appendChild(resizeHandle);\n};\n\n\n/**\n * Clear content and style of the textbox, unbind listeners and\n * reset CSS style.\n */\nTextBox.prototype.destroy = function() {\n  var parent = this.parent,\n      content = this.content,\n      resizeHandle = this.resizeHandle;\n\n  // clear content\n  content.innerText = '';\n\n  // clear styles\n  parent.removeAttribute('style');\n  content.removeAttribute('style');\n\n  dist_index_esm/* event.unbind */.B.unbind(content, 'keydown', this.keyHandler);\n  dist_index_esm/* event.unbind */.B.unbind(content, 'mousedown', stopPropagation);\n  dist_index_esm/* event.unbind */.B.unbind(content, 'input', this.autoResize);\n  dist_index_esm/* event.unbind */.B.unbind(content, 'paste', this.handlePaste);\n\n  if (resizeHandle) {\n    resizeHandle.removeAttribute('style');\n\n    (0,dist_index_esm/* remove */.Od)(resizeHandle);\n  }\n\n  (0,dist_index_esm/* remove */.Od)(parent);\n};\n\n\nTextBox.prototype.getValue = function() {\n  return this.content.innerText.trim();\n};\n\n\nTextBox.prototype.getSelection = function() {\n  var selection = window.getSelection(),\n      range = selection.getRangeAt(0);\n\n  return range;\n};\n\n\nTextBox.prototype.setSelection = function(container, offset) {\n  var range = document.createRange();\n\n  if (container === null) {\n    range.selectNodeContents(this.content);\n  } else {\n    range.setStart(container, offset);\n    range.setEnd(container, offset);\n  }\n\n  var selection = window.getSelection();\n\n  selection.removeAllRanges();\n  selection.addRange(range);\n};\n\n// helpers //////////\n\nfunction normalizeEndOfLineSequences(string) {\n  return string.replace(/\\r\\n|\\r|\\n/g, '\\n');\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-direct-editing/lib/DirectEditing.js\n\n\n\n\n\n/**\n * A direct editing component that allows users\n * to edit an elements text directly in the diagram\n *\n * @param {EventBus} eventBus the event bus\n */\nfunction DirectEditing(eventBus, canvas) {\n\n  this._eventBus = eventBus;\n\n  this._providers = [];\n  this._textbox = new TextBox({\n    container: canvas.getContainer(),\n    keyHandler: (0,index_esm/* bind */.ak)(this._handleKey, this),\n    resizeHandler: (0,index_esm/* bind */.ak)(this._handleResize, this)\n  });\n}\n\nDirectEditing.$inject = [ 'eventBus', 'canvas' ];\n\n\n/**\n * Register a direct editing provider\n\n * @param {Object} provider the provider, must expose an #activate(element) method that returns\n *                          an activation context ({ bounds: {x, y, width, height }, text }) if\n *                          direct editing is available for the given element.\n *                          Additionally the provider must expose a #update(element, value) method\n *                          to receive direct editing updates.\n */\nDirectEditing.prototype.registerProvider = function(provider) {\n  this._providers.push(provider);\n};\n\n\n/**\n * Returns true if direct editing is currently active\n *\n * @param {djs.model.Base} [element]\n *\n * @return {boolean}\n */\nDirectEditing.prototype.isActive = function(element) {\n  return !!(this._active && (!element || this._active.element === element));\n};\n\n\n/**\n * Cancel direct editing, if it is currently active\n */\nDirectEditing.prototype.cancel = function() {\n  if (!this._active) {\n    return;\n  }\n\n  this._fire('cancel');\n  this.close();\n};\n\n\nDirectEditing.prototype._fire = function(event, context) {\n  this._eventBus.fire('directEditing.' + event, context || { active: this._active });\n};\n\nDirectEditing.prototype.close = function() {\n  this._textbox.destroy();\n\n  this._fire('deactivate');\n\n  this._active = null;\n\n  this.resizable = undefined;\n};\n\n\nDirectEditing.prototype.complete = function() {\n\n  var active = this._active;\n\n  if (!active) {\n    return;\n  }\n\n  var containerBounds,\n      previousBounds = active.context.bounds,\n      newBounds = this.$textbox.getBoundingClientRect(),\n      newText = this.getValue(),\n      previousText = active.context.text;\n\n  if (\n    newText !== previousText ||\n    newBounds.height !== previousBounds.height ||\n    newBounds.width !== previousBounds.width\n  ) {\n    containerBounds = this._textbox.container.getBoundingClientRect();\n\n    active.provider.update(active.element, newText, active.context.text, {\n      x: newBounds.left - containerBounds.left,\n      y: newBounds.top - containerBounds.top,\n      width: newBounds.width,\n      height: newBounds.height\n    });\n  }\n\n  this._fire('complete');\n\n  this.close();\n};\n\n\nDirectEditing.prototype.getValue = function() {\n  return this._textbox.getValue();\n};\n\n\nDirectEditing.prototype._handleKey = function(e) {\n\n  // stop bubble\n  e.stopPropagation();\n\n  var key = e.keyCode || e.charCode;\n\n  // ESC\n  if (key === 27) {\n    e.preventDefault();\n    return this.cancel();\n  }\n\n  // Enter\n  if (key === 13 && !e.shiftKey) {\n    e.preventDefault();\n    return this.complete();\n  }\n};\n\n\nDirectEditing.prototype._handleResize = function(event) {\n  this._fire('resize', event);\n};\n\n\n/**\n * Activate direct editing on the given element\n *\n * @param {Object} ElementDescriptor the descriptor for a shape or connection\n * @return {Boolean} true if the activation was possible\n */\nDirectEditing.prototype.activate = function(element) {\n  if (this.isActive()) {\n    this.cancel();\n  }\n\n  // the direct editing context\n  var context;\n\n  var provider = (0,index_esm/* find */.sE)(this._providers, function(p) {\n    return ((context = p.activate(element))) ? p : null;\n  });\n\n  // check if activation took place\n  if (context) {\n    this.$textbox = this._textbox.create(\n      context.bounds,\n      context.style,\n      context.text,\n      context.options\n    );\n\n    this._active = {\n      element: element,\n      context: context,\n      provider: provider\n    };\n\n    if (context.options && context.options.resizable) {\n      this.resizable = true;\n    }\n\n    this._fire('activate');\n  }\n\n  return !!context;\n};\n\n;// CONCATENATED MODULE: ./node_modules/diagram-js-direct-editing/index.js\n\n\n\n\n/* harmony default export */ const diagram_js_direct_editing = ({\n  __depends__: [\n    interaction_events/* default */.Z\n  ],\n  __init__: [ 'directEditing' ],\n  directEditing: [ 'type', DirectEditing ]\n});\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/diagram-js-direct-editing/index.js_+_2_modules?")},"./node_modules/diagram-js-origin/index.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// EXPORTS\n__webpack_require__.d(__webpack_exports__, {\n  \"default\": () => (/* binding */ diagram_js_origin)\n});\n\n// EXTERNAL MODULE: ./node_modules/tiny-svg/dist/index.esm.js\nvar index_esm = __webpack_require__(\"./node_modules/tiny-svg/dist/index.esm.js\");\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/lib/configure-origin.js\n\n\nvar CROSS_COLOR = '#CCC',\n    BORDER_COLOR = 'rgba(0,0,0,0.1)';\n\n\n/**\n * A diagram-js extension that shows a (0, 0) origin indicator\n * on the canvas as well as (optionally) the canvas borders.\n *\n * @param {Object} [config]\n * @param {Canvas} canvas\n */\nfunction ConfigureOrigin(config, canvas) {\n\n  config = config || {};\n\n  var borderColor = config.borderColor || BORDER_COLOR,\n      crossColor = config.crossColor || CROSS_COLOR ;\n\n  var w = 30, h = 2,\n      w_half = w / 2,\n      s = -h / 2,\n      lineStart = w_half + 7;\n\n  var parent = canvas.getLayer('djs-origin', -1);\n\n  var g,\n      line,\n      cross,\n      label;\n\n  g = createEl('g', {\n    'pointer-events': 'none'\n  });\n\n  (0,index_esm/* append */.R3)(parent, g);\n\n  if (config.showBorder !== false) {\n\n    // the dashed lines, marking positive document coordinates\n    line = createEl('path', {\n      'class': cls('border'),\n      'd': path([\n        'M', -lineStart, s,\n        'H', -1000,\n        'M', lineStart, s,\n        'H', 6000,\n        'M', s, -lineStart,\n        'V', -1000,\n        'M', s, lineStart,\n        'V', 3000\n      ]),\n      'fill': 'none',\n      'stroke': borderColor,\n      'stroke-width': h + 'px',\n      'stroke-dasharray': '6, 6',\n      'shape-rendering': 'crispedges'\n    });\n\n    (0,index_esm/* append */.R3)(g, line);\n  }\n\n  // the cross that marks the diagram origin\n  cross = createEl('path', {\n    d: path([\n      'M', -w_half, s,\n      'H', w_half,\n      'M', s, -w_half,\n      'V', w_half\n    ]),\n    'class': cls('cross'),\n    'fill': 'none',\n    'stroke': crossColor,\n    'stroke-width': h + 'px',\n    'stroke-linecap': 'round'\n  });\n\n  (0,index_esm/* append */.R3)(g, cross);\n\n  label = createEl('text', {\n    x: -40,\n    y: -10,\n    fill: crossColor,\n    'class': cls('label'),\n  });\n\n  label.textContent = '(0, 0)';\n\n  (0,index_esm/* append */.R3)(g, label);\n}\n\nConfigureOrigin.$inject = [\n  'config.origin',\n  'canvas'\n];\n\n\n// helpers ///////////////////////////////////\n\nfunction path(parts) {\n  return parts.join(' ');\n}\n\nfunction cls(name) {\n  return 'djs-origin-' + name;\n}\n\nfunction createEl(type, attrs) {\n\n  var el = (0,index_esm/* create */.Ue)(type);\n\n  (0,index_esm/* attr */.Lj)(el, attrs);\n\n  return el;\n}\n;// CONCATENATED MODULE: ./node_modules/diagram-js-origin/index.js\n\n\n/* harmony default export */ const diagram_js_origin = ({\n  __init__: [\n    ConfigureOrigin\n  ]\n});\n\n//# sourceURL=webpack://VBCPFREE/./node_modules/diagram-js-origin/index.js_+_1_modules?")}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(t.exports,t,t.exports,__webpack_require__),t.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,n,t,i)=>{if(!n){var r=1/0;for(d=0;d<deferred.length;d++){for(var[n,t,i]=deferred[d],o=!0,a=0;a<n.length;a++)(!1&i||r>=i)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](n[a])))?n.splice(a--,1):(o=!1,i<r&&(r=i));if(o){deferred.splice(d--,1);var s=t();void 0!==s&&(e=s)}}return e}i=i||0;for(var d=deferred.length;d>0&&deferred[d-1][2]>i;d--)deferred[d]=deferred[d-1];deferred[d]=[n,t,i]},__webpack_require__.n=e=>{var n=e&&e.__esModule?()=>e.default:()=>e;return __webpack_require__.d(n,{a:n}),n},__webpack_require__.d=(e,n)=>{for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=(e,n)=>Object.prototype.hasOwnProperty.call(e,n),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.j="bpmnFreeEditor",(()=>{var e={bpmnFreeEditor:0};__webpack_require__.O.j=n=>0===e[n];var n=(n,t)=>{var i,r,[o,a,s]=t,d=0;if(o.some((n=>0!==e[n]))){for(i in a)__webpack_require__.o(a,i)&&(__webpack_require__.m[i]=a[i]);if(s)var l=s(__webpack_require__)}for(n&&n(t);d<o.length;d++)r=o[d],__webpack_require__.o(e,r)&&e[r]&&e[r][0](),e[r]=0;return __webpack_require__.O(l)},t=self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[];t.forEach(n.bind(null,0)),t.push=n.bind(null,t.push.bind(t))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnFreeCommon","bpmnFreeDiagramJs","bpmnFreeBpmnJs","bpmnFreeVendors"],(()=>__webpack_require__("./editor/editorApp.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCPFREE=window.VBCPFREE||{}).bpmnFreeEditor=__webpack_exports__})();