(self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[]).push([["bpmnFreeCommon"],{"./common/resources/newDiagram.bpmn":module=>{eval('module.exports = "<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?>\\n<bpmn2:definitions xmlns:xsi=\\"http://www.w3.org/2001/XMLSchema-instance\\" xmlns:bpmn2=\\"http://www.omg.org/spec/BPMN/20100524/MODEL\\" xmlns:bpmndi=\\"http://www.omg.org/spec/BPMN/20100524/DI\\" xmlns:dc=\\"http://www.omg.org/spec/DD/20100524/DC\\" xmlns:di=\\"http://www.omg.org/spec/DD/20100524/DI\\" xsi:schemaLocation=\\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd\\" id=\\"sample-diagram\\" targetNamespace=\\"http://bpmn.io/schema/bpmn\\">\\n  <bpmn2:process id=\\"Process_1\\" isExecutable=\\"false\\">\\n    <bpmn2:startEvent id=\\"StartEvent_1\\"/>\\n  </bpmn2:process>\\n  <bpmndi:BPMNDiagram id=\\"BPMNDiagram_1\\">\\n    <bpmndi:BPMNPlane id=\\"BPMNPlane_1\\" bpmnElement=\\"Process_1\\">\\n      <bpmndi:BPMNShape id=\\"_BPMNShape_StartEvent_2\\" bpmnElement=\\"StartEvent_1\\">\\n        <dc:Bounds height=\\"36.0\\" width=\\"36.0\\" x=\\"173.0\\" y=\\"102.0\\"/>\\n      </bpmndi:BPMNShape>\\n    </bpmndi:BPMNPlane>\\n  </bpmndi:BPMNDiagram>\\n</bpmn2:definitions>";\n\n//# sourceURL=webpack://VBCPFREE/./common/resources/newDiagram.bpmn?')},"./common/attachment-manager.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.getAttachmentVersion = exports.loadAttachment = exports.uploadAttachment = void 0;\r\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\r\nconst utils_1 = __webpack_require__("./common/utils.ts");\r\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\r\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "AttachmentManager");\r\nfunction makeRequest(opts) {\r\n    return new Promise((resolve, reject) => {\r\n        const xhr = new XMLHttpRequest();\r\n        xhr.open(opts.method, opts.url, true);\r\n        const maxWaitTime = 10000;\r\n        const noResponseTimer = setTimeout(() => {\r\n            xhr.abort();\r\n            reject({\r\n                status: 503,\r\n                message: "Service unreachable",\r\n            });\r\n        }, maxWaitTime);\r\n        xhr.onload = () => {\r\n            clearTimeout(noResponseTimer);\r\n            if (xhr.status >= 200 && xhr.status < 300) {\r\n                resolve(xhr.response);\r\n            }\r\n            else {\r\n                reject(xhr);\r\n            }\r\n        };\r\n        xhr.onerror = () => {\r\n            clearTimeout(noResponseTimer);\r\n            reject(xhr);\r\n        };\r\n        if (opts.headers) {\r\n            Object.keys(opts.headers).forEach((key) => {\r\n                xhr.setRequestHeader(key, opts.headers[key]);\r\n            });\r\n        }\r\n        xhr.send(opts.formData);\r\n    });\r\n}\r\nfunction buildRestUrl(restCall, pageId) {\r\n    const baseUrl = window.location.protocol + "//" + window.location.host;\r\n    const contextPath = (0, utils_1.getParams)().contextPath;\r\n    const restPath = "/rest/api/content/";\r\n    return baseUrl + contextPath + restPath + pageId + restCall;\r\n}\r\nfunction getAttachmentListRequest(pageId) {\r\n    return makeRequest({\r\n        url: buildRestUrl("/child/attachment?start=0", pageId),\r\n        method: "GET",\r\n    });\r\n}\r\nfunction updateAttachmentRequest(attachmentId, file, fileName, pageId) {\r\n    const url = buildRestUrl("/child/attachment/" + attachmentId + "/data", pageId);\r\n    const formData = new FormData();\r\n    formData.append("file", file, fileName);\r\n    const headers = { "X-Atlassian-Token": "no-check" };\r\n    return makeRequest({\r\n        url,\r\n        method: "POST",\r\n        headers,\r\n        formData,\r\n    });\r\n}\r\nfunction uploadAttachmentRequest(file, fileName, pageId) {\r\n    const url = buildRestUrl("/child/attachment", pageId);\r\n    const formData = new FormData();\r\n    formData.append("file", file, fileName);\r\n    const headers = { "X-Atlassian-Token": "no-check" };\r\n    return makeRequest({\r\n        url,\r\n        method: "POST",\r\n        headers,\r\n        formData,\r\n    });\r\n}\r\nfunction getFileRequest(url) {\r\n    return makeRequest({\r\n        method: "GET",\r\n        url,\r\n    });\r\n}\r\nfunction getAttachmentData(attachmentList, name) {\r\n    return JSON.parse(attachmentList).results.filter((attachment) => {\r\n        return attachment.title === name;\r\n    });\r\n}\r\nfunction buildDownloadUrl(downloadPath) {\r\n    const baseUrl = window.location.protocol + "//" + window.location.host;\r\n    const contextPath = (0, utils_1.getParams)().contextPath;\r\n    return baseUrl + contextPath + downloadPath;\r\n}\r\nfunction getIdByName(attachmentList, name) {\r\n    const result = JSON.parse(attachmentList).results.filter((attachment) => {\r\n        return attachment.title === name;\r\n    });\r\n    return result.length > 0 ? result[0].id : undefined;\r\n}\r\nfunction getAttachmentHistoryRequest(attachmentId) {\r\n    return makeRequest({\r\n        url: buildRestUrl(attachmentId + "/history", ""),\r\n        method: "GET",\r\n    });\r\n}\r\nfunction uploadAttachment(file, fileName, pageId) {\r\n    return getAttachmentListRequest(pageId)\r\n        .then((attachmentList) => {\r\n        const attachmentId = getIdByName(attachmentList, fileName);\r\n        if (attachmentId) {\r\n            return updateAttachmentRequest(attachmentId, file, fileName, pageId);\r\n        }\r\n        else {\r\n            return uploadAttachmentRequest(file, fileName, pageId);\r\n        }\r\n    })\r\n        .catch((err) => {\r\n        return Promise.reject(err);\r\n    });\r\n}\r\nexports.uploadAttachment = uploadAttachment;\r\nfunction loadAttachment(name, pageId) {\r\n    return getAttachmentListRequest(pageId)\r\n        .then((attachmentList) => {\r\n        const attachmentData = getAttachmentData(attachmentList, name);\r\n        if (!attachmentData[0]) {\r\n            return Promise.reject({\r\n                status: 404,\r\n                responseText: "Attachment not Found",\r\n            });\r\n        }\r\n        else if (attachmentData.length !== 1) {\r\n            vxcpLogger.logWarning("loadAttachment", "Multiple corresponding attachments found, loading latest.");\r\n        }\r\n        const downloadLink = buildDownloadUrl(attachmentData[0]._links.download);\r\n        const attachmentId = attachmentData[0].id;\r\n        return getAttachmentHistoryRequest(attachmentId)\r\n            .then((history) => {\r\n            return JSON.parse(history).lastUpdated.number;\r\n        })\r\n            .then((version) => {\r\n            return getFileRequest(downloadLink).then((fileData) => {\r\n                return {\r\n                    data: fileData,\r\n                    id: attachmentId,\r\n                    version,\r\n                };\r\n            });\r\n        });\r\n    })\r\n        .catch((err) => {\r\n        return Promise.reject(err);\r\n    });\r\n}\r\nexports.loadAttachment = loadAttachment;\r\nfunction getAttachmentVersion(name, pageId) {\r\n    return getAttachmentListRequest(pageId).then((list) => {\r\n        const attachmentId = getIdByName(list, name);\r\n        if (attachmentId) {\r\n            return getAttachmentHistoryRequest(attachmentId).then((history) => {\r\n                return {\r\n                    id: attachmentId,\r\n                    version: JSON.parse(history).lastUpdated.number,\r\n                };\r\n            });\r\n        }\r\n        else {\r\n            return Promise.reject({\r\n                status: 404,\r\n                responseText: "Attachment not Found",\r\n            });\r\n        }\r\n    });\r\n}\r\nexports.getAttachmentVersion = getAttachmentVersion;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/attachment-manager.ts?')},"./common/diagram-manager.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.saveDiagram = exports.loadDiagram = exports.getDiagramSVG = exports.getDiagramXML = exports.showDiagram = exports.createNewDiagram = exports.openDiagram = void 0;\r\nconst AttachmentManager = __importStar(__webpack_require__("./common/attachment-manager.ts"));\r\nconst ConfUtils = __importStar(__webpack_require__("./common/utils.ts"));\r\nconst Notification = __importStar(__webpack_require__("./common/notification.ts"));\r\nconst newDiagramXml = __importStar(__webpack_require__("./common/newDiagramXml.ts"));\r\nconst DiagramState = __importStar(__webpack_require__("./common/diagram-state.ts"));\r\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\r\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\r\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "DiagramManager");\r\nfunction handleError(error, pageId) {\r\n    switch (error.status) {\r\n        case 403:\r\n            const confluenceLink = {\r\n                link: Confluence.getContextPath() + "/pages/viewpage.action?pageId=" + pageId,\r\n            };\r\n            ConfUtils.showDialog(AJS, "#vbcp-session-warning-dialog", Confluence.Templates.viadee.bpmnplugin.sessionWarningDialog, undefined, undefined, confluenceLink);\r\n            break;\r\n        case 0:\r\n            if (DiagramState.isDiagramSaved() === false) {\r\n                ConfUtils.showDialog(AJS, "#vbcp-connection-warning-dialog", Confluence.Templates.viadee.bpmnplugin.connectionWarningDialog);\r\n            }\r\n            break;\r\n        case 503:\r\n            ConfUtils.showDialog(AJS, "#vbcp-connection-warning-dialog", Confluence.Templates.viadee.bpmnplugin.connectionWarningDialog);\r\n            break;\r\n        default:\r\n            vxcpLogger.logError("handleError", "An error occurred while executing error handling function. This log is a default message if no one other warning dialogs are shown to user.", error);\r\n    }\r\n}\r\nfunction setVersion(version) {\r\n    DiagramState.setDiagramVersion(version);\r\n    DiagramState.saveDiagram(true);\r\n    const $diagramVersionLabel = AJS.$("#vbcp-diagram-version");\r\n    $diagramVersionLabel.html("(v." + DiagramState.getDiagramVersion() + ")");\r\n}\r\nfunction hideDiagramChange() {\r\n    const $saveLink = AJS.$("#content > div.toolbar > ul > li:nth-child(1) > a");\r\n    const $resetLink = AJS.$("#content > div.toolbar > ul > li:nth-child(2) > a");\r\n    const $diagramNameLabel = AJS.$("#vbcp-diagram-name");\r\n    $saveLink.removeClass("active");\r\n    $resetLink.removeClass("active");\r\n    $diagramNameLabel.text($diagramNameLabel.text().replace(/\\*/g, ""));\r\n    $diagramNameLabel.css("font-style", "");\r\n    DiagramState.saveDiagram(true);\r\n    deactivateButton($saveLink);\r\n    deactivateButton($resetLink);\r\n}\r\nfunction deactivateButton($link) {\r\n    $link.css({ cursor: "default" });\r\n    $link.off();\r\n    $link.click((e) => {\r\n        e.preventDefault();\r\n        e.stopPropagation();\r\n    });\r\n}\r\nfunction updateVersion(diagramName, pageId) {\r\n    AttachmentManager.getAttachmentVersion(diagramName + ".bpmn", pageId).then((attachment) => {\r\n        setVersion(attachment.version);\r\n    });\r\n}\r\nfunction uploadDiagramToConfluence(modeler, diagramName, pageId) {\r\n    return __awaiter(this, void 0, void 0, function* () {\r\n        const xml = yield getDiagramXML(modeler);\r\n        const attachment = new Blob([xml]);\r\n        AttachmentManager.uploadAttachment(attachment, `${diagramName}.bpmn`, pageId)\r\n            .then(() => {\r\n            updateVersion(diagramName, pageId);\r\n            hideDiagramChange();\r\n            Notification.setSuccessMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.editor.notification.saveDiagram.success.title"), AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.editor.notification.saveDiagram.success.body"), true, "#vbcp-modeler-messages");\r\n        })\r\n            .catch((err) => {\r\n            vxcpLogger.logError("uploadDiagramToConfluence", "An error occurred while uploading BPMN file to Confluence. The diagram could not be uploaded.", { err });\r\n        });\r\n    });\r\n}\r\nfunction openDiagram(modeler, xml, diagramName, callbackFn) {\r\n    return __awaiter(this, void 0, void 0, function* () {\r\n        const $loadingText = AJS.$("#diagram-loading");\r\n        try {\r\n            const importedXML = yield modeler.importXML(xml);\r\n            $loadingText.hide();\r\n            const warnings = importedXML.warnings;\r\n            if (warnings.length) {\r\n                vxcpLogger.logWarning("openDiagram", "An error occurred while opening BPMN diagram. The BPMN file, which you try to open, is probably broken or has an invalid format.", warnings);\r\n                const warningTitle = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.load-diagram-warnings-message.title");\r\n                const warningBody = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.load-diagram-warnings-message.body");\r\n                Notification.setWarningMessage(warningTitle, warningBody, true, "#vbcp-modeler-messages", true);\r\n            }\r\n            ConfUtils.moveDiagramToTopLeft(modeler, 180, 100);\r\n            if (typeof callbackFn === "function") {\r\n                callbackFn();\r\n            }\r\n        }\r\n        catch (err) {\r\n            $loadingText.hide();\r\n            vxcpLogger.logError("openDiagram", "An error occurred while opening BPMN diagram. The BPMN file, which you try to open, is probably broken or has an invalid format.", err);\r\n            ConfUtils.showDialog(AJS, "#vbcp-diagram-warning-dialog", Confluence.Templates.viadee.bpmnplugin.diagramWarningDialog);\r\n        }\r\n    });\r\n}\r\nexports.openDiagram = openDiagram;\r\nfunction createNewDiagram(modeler) {\r\n    return __awaiter(this, void 0, void 0, function* () {\r\n        yield openDiagram(modeler, newDiagramXml.getNewDiagramXml());\r\n    });\r\n}\r\nexports.createNewDiagram = createNewDiagram;\r\nfunction showDiagram(modeler, attachment, diagramName, callbackFn) {\r\n    return __awaiter(this, void 0, void 0, function* () {\r\n        setVersion(attachment.version);\r\n        yield openDiagram(modeler, attachment.data, diagramName, callbackFn);\r\n    });\r\n}\r\nexports.showDiagram = showDiagram;\r\nfunction getDiagramXML(modeler) {\r\n    return __awaiter(this, void 0, void 0, function* () {\r\n        try {\r\n            const savedXmlData = yield modeler.saveXML({ format: true });\r\n            return savedXmlData.xml;\r\n        }\r\n        catch (xmlErr) {\r\n            vxcpLogger.logError("getDiagramXML", "An error occurred while saving the daigram as BPMN.", xmlErr);\r\n        }\r\n    });\r\n}\r\nexports.getDiagramXML = getDiagramXML;\r\nfunction getDiagramSVG(modeler) {\r\n    return __awaiter(this, void 0, void 0, function* () {\r\n        try {\r\n            const savedSvgData = yield modeler.saveSVG();\r\n            return savedSvgData.svg;\r\n        }\r\n        catch (svgErr) {\r\n            vxcpLogger.logError("getDiagramSVG", "An error occurred while saving the diagram as SVG.", svgErr);\r\n        }\r\n    });\r\n}\r\nexports.getDiagramSVG = getDiagramSVG;\r\nfunction loadDiagram(modeler, diagramName, pageId, reset) {\r\n    return __awaiter(this, void 0, void 0, function* () {\r\n        const $loadingText = AJS.$("#diagram-loading");\r\n        try {\r\n            const attachment = yield AttachmentManager.loadAttachment(diagramName + ".bpmn", pageId);\r\n            if (reset) {\r\n                if (attachment.version !== DiagramState.getDiagramVersion()) {\r\n                    $loadingText.hide();\r\n                    Notification.show(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.editor.notification.diagramUpdated"));\r\n                }\r\n                else {\r\n                    ConfUtils.showDialog(AJS, "#vbcp-reload-warning-dialog", Confluence.Templates.viadee.bpmnplugin.reloadWarningDialog, () => __awaiter(this, void 0, void 0, function* () {\r\n                        yield showDiagram(modeler, attachment, diagramName, hideDiagramChange);\r\n                    }), () => {\r\n                        $loadingText.hide();\r\n                    });\r\n                }\r\n            }\r\n            else {\r\n                yield showDiagram(modeler, attachment, diagramName, hideDiagramChange);\r\n            }\r\n        }\r\n        catch (err) {\r\n            if (err.status === 404) {\r\n                if (reset) {\r\n                    ConfUtils.showDialog(AJS, "#vbcp-reload-warning-dialog", Confluence.Templates.viadee.bpmnplugin.reloadWarningDialog, () => __awaiter(this, void 0, void 0, function* () {\r\n                        yield createNewDiagram(modeler);\r\n                        hideDiagramChange();\r\n                    }), () => {\r\n                        $loadingText.hide();\r\n                    });\r\n                }\r\n                else {\r\n                    yield createNewDiagram(modeler);\r\n                }\r\n            }\r\n            else {\r\n                handleError(err, pageId);\r\n            }\r\n        }\r\n    });\r\n}\r\nexports.loadDiagram = loadDiagram;\r\nfunction saveDiagram(modeler, diagramName, pageId) {\r\n    AttachmentManager.getAttachmentVersion(diagramName + ".bpmn", pageId)\r\n        .then((attachment) => __awaiter(this, void 0, void 0, function* () {\r\n        if (attachment.version !== DiagramState.getDiagramVersion()) {\r\n            ConfUtils.showDialog(AJS, "#vbcp-save-warning-dialog", Confluence.Templates.viadee.bpmnplugin.saveWarningDialog, () => __awaiter(this, void 0, void 0, function* () {\r\n                yield uploadDiagramToConfluence(modeler, diagramName, pageId);\r\n            }));\r\n        }\r\n        else {\r\n            yield uploadDiagramToConfluence(modeler, diagramName, pageId);\r\n        }\r\n    }))\r\n        .catch((err) => __awaiter(this, void 0, void 0, function* () {\r\n        if (err.status === 404) {\r\n            yield uploadDiagramToConfluence(modeler, diagramName, pageId);\r\n        }\r\n        else {\r\n            handleError(err, pageId);\r\n        }\r\n    }));\r\n}\r\nexports.saveDiagram = saveDiagram;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/diagram-manager.ts?')},"./common/diagram-state.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.getDiagramVersion = exports.setDiagramVersion = exports.isDiagramSaved = exports.saveDiagram = void 0;\r\nlet diagramSaved = true;\r\nlet diagramVersion = "";\r\nfunction saveDiagram(predicate) {\r\n    diagramSaved = predicate;\r\n}\r\nexports.saveDiagram = saveDiagram;\r\nfunction isDiagramSaved() {\r\n    return diagramSaved;\r\n}\r\nexports.isDiagramSaved = isDiagramSaved;\r\nfunction setDiagramVersion(version) {\r\n    diagramVersion = version;\r\n}\r\nexports.setDiagramVersion = setDiagramVersion;\r\nfunction getDiagramVersion() {\r\n    return diagramVersion;\r\n}\r\nexports.getDiagramVersion = getDiagramVersion;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/diagram-state.ts?')},"./common/dynamic-content-service.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.DynamicContentService = void 0;\r\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\r\nconst utils_1 = __webpack_require__("./common/utils.ts");\r\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\r\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "DynamicContentService");\r\nclass DynamicContentService {\r\n    constructor(lastNewsSeenDate) {\r\n        this.bucketUrl = "https://storage.googleapis.com/viadee-atlassian-plugins-prod-storage-bucket/bpmn-modeler-news-content.json";\r\n        this.toolbarNewsMarkerIdSelector = "#vbcp-toolbar-news-marker";\r\n        this.newsMessageContainerIdSelector = "#vbcp-message-news";\r\n        this.newsMessageBodyIdSelector = "#vbcp-messages-news-body";\r\n        this.newsMessageCloseBtnIdSelector = "#vbcp-modeler-message-news-close-btn";\r\n        this.newsMessageBackBtnIdSelector = "#vbcp-modeler-message-news-back-btn";\r\n        this.newsEntryDetailsClassSelector = ".vbcp-message-news-entry-details";\r\n        this.newsEntryDetailsWrapperClassSelector = "#vbcp-message-news-details-wrapper";\r\n        this.detailsBtnClassSelector = ".vbcp-message-news-entry-show-details-btn";\r\n        this.cssClassUnread = "vbcp-message-unread";\r\n        this.cssClassHidden = "vbcp-hidden";\r\n        this.cssClassSwipeIn = "vbcp-message-news-swipe-in";\r\n        this.cssClassSwipeOut = "vbcp-message-news-swipe-out";\r\n        this.loadingIdSelector = "#vbcp-news-loading";\r\n        this.useQABucket = false;\r\n        this.hasNews = false;\r\n        this.lastNewsSeenDateTime = lastNewsSeenDate;\r\n        this.bucketUrl = "https://storage.googleapis.com/viadee-atlassian-plugins-prod-storage-bucket/bpmn-modeler-news-content.json";\r\n        if (this.useQABucket) {\r\n            vxcpLogger.logInfo("constructor", "Using QA Bucket URL");\r\n            this.bucketUrl = "https://storage.googleapis.com/viadee-atlassian-plugins-qa-storage-bucket/bpmn-modeler-news-content.json";\r\n        }\r\n        else {\r\n            vxcpLogger.logInfo("constructor", "Using PROD Bucket URL");\r\n        }\r\n    }\r\n    updateLastNewsSeenDate(updatedLastSeenDate) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const restPath = "/rest/bpmn-modeler/1.0/settings/lastNewsSeenDate";\r\n            const url = AJS.contextPath() + restPath;\r\n            const headers = { "X-Atlassian-Token": "no-check" };\r\n            try {\r\n                yield $.ajax({\r\n                    url,\r\n                    type: "PUT",\r\n                    cache: false,\r\n                    data: JSON.stringify(updatedLastSeenDate),\r\n                    headers,\r\n                    processData: false,\r\n                    contentType: false,\r\n                });\r\n            }\r\n            catch (e) {\r\n                vxcpLogger.logError("updateLastNewsSeenDate", "Could not update value", { e });\r\n            }\r\n        });\r\n    }\r\n    getContent() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            return new Promise((resolve, reject) => {\r\n                try {\r\n                    vxcpLogger.logInfo("getContent", "Retrieving content of Bucket...");\r\n                    resolve(this.buildS3RestCall());\r\n                }\r\n                catch (e) {\r\n                    vxcpLogger.logInfo("getContent", "No content found.");\r\n                    reject(false);\r\n                }\r\n            });\r\n        });\r\n    }\r\n    showNewsMessageBox(lastNewsSeenDate) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const isHidden = $(this.newsMessageContainerIdSelector).hasClass(this.cssClassHidden);\r\n            if (!isHidden) {\r\n                this.closeMessageBox();\r\n                return lastNewsSeenDate;\r\n            }\r\n            $(this.newsMessageContainerIdSelector).removeClass(this.cssClassHidden);\r\n            $(this.toolbarNewsMarkerIdSelector).addClass(this.cssClassHidden);\r\n            $(this.newsEntryDetailsWrapperClassSelector).addClass(this.cssClassHidden);\r\n            this.initCloseBtn();\r\n            this.initDetailsBtn();\r\n            this.initBackButton();\r\n            return this.lastNewsSeenDateTime;\r\n        });\r\n    }\r\n    initNewsMarker() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            if (!this.hasNews) {\r\n                return;\r\n            }\r\n            $(this.toolbarNewsMarkerIdSelector).removeClass(this.cssClassHidden);\r\n        });\r\n    }\r\n    initNews(lastNewsSeenDate) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            this.lastNewsSeenDateTime = lastNewsSeenDate;\r\n            yield this.loadMessageBoxHtml();\r\n            const resultDataPromise = this.getContent();\r\n            resultDataPromise\r\n                .then((resultData) => __awaiter(this, void 0, void 0, function* () {\r\n                const data = yield this.parseNewsData(resultData);\r\n                this.newsMessagesToShow = data;\r\n                $(this.loadingIdSelector).hide();\r\n                this.setMessages();\r\n                yield this.initNewsMarker();\r\n            }))\r\n                .catch((e) => __awaiter(this, void 0, void 0, function* () {\r\n                vxcpLogger.logInfo("getContent", "No or malformed content found.", { e });\r\n                this.newsMessagesToShow = yield this.getNoNewsObject();\r\n                $(this.loadingIdSelector).hide();\r\n                this.setMessages();\r\n                yield this.initNewsMarker();\r\n            }));\r\n        });\r\n    }\r\n    loadMessageBoxHtml() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const alreadyShown = $(this.newsMessageContainerIdSelector).length > 0;\r\n            if (alreadyShown) {\r\n                $(this.newsMessageContainerIdSelector).remove();\r\n                return;\r\n            }\r\n            const template = Confluence.Templates.viadee.bpmnplugin.newsMessageBox;\r\n            const newsMessageBox = template();\r\n            $("body").append(newsMessageBox);\r\n            $(this.newsMessageContainerIdSelector).addClass(this.cssClassHidden);\r\n        });\r\n    }\r\n    setMessages() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const params = { newsList: this.newsMessagesToShow };\r\n            const template = Confluence.Templates.viadee.bpmnplugin.newsMessageEntries;\r\n            const newsMessageEntries = template(params);\r\n            $(this.newsMessageBodyIdSelector).append(newsMessageEntries);\r\n            this.newsMessagesToShow.forEach((entry, idx) => {\r\n                $(this.newsMessageBodyIdSelector).find(`#vbcp-ent-message-news-entry-details-desc-${idx}`).html(entry.body);\r\n            });\r\n        });\r\n    }\r\n    initDetailsBtn() {\r\n        $(this.detailsBtnClassSelector).on("click", (e) => {\r\n            const btnHref = $(e.target).attr("href");\r\n            if (!btnHref) {\r\n                return;\r\n            }\r\n            const entry = $(e.target).parent();\r\n            entry.removeClass(this.cssClassUnread);\r\n            this.swipeInOut(this.newsEntryDetailsWrapperClassSelector, true);\r\n            $(btnHref).removeClass(this.cssClassHidden);\r\n            $(this.newsMessageBackBtnIdSelector).removeClass(this.cssClassHidden);\r\n            $(this.newsMessageCloseBtnIdSelector).addClass(this.cssClassHidden);\r\n        });\r\n    }\r\n    dateMinusDaysToString(plainDate, days = 0) {\r\n        plainDate.setDate(plainDate.getDate() - days);\r\n        const year = plainDate.getFullYear().toString();\r\n        const month = (plainDate.getMonth() + 1).toString();\r\n        const day = plainDate.getDate().toString();\r\n        const formattedDate = `${year}-${month}-${day}`;\r\n        const hour = plainDate.getHours().toString();\r\n        return { date: formattedDate, hour };\r\n    }\r\n    initBackButton() {\r\n        $(this.newsMessageBackBtnIdSelector).on("click", (e) => {\r\n            this.swipeInOut(this.newsEntryDetailsWrapperClassSelector, false);\r\n            $(this.newsMessageCloseBtnIdSelector).removeClass(this.cssClassHidden);\r\n            $(this.newsMessageBackBtnIdSelector).addClass(this.cssClassHidden);\r\n            $(this.newsEntryDetailsClassSelector).addClass(this.cssClassHidden);\r\n        });\r\n    }\r\n    swipeInOut(selector, swipeIn) {\r\n        const element = $(selector);\r\n        if (swipeIn) {\r\n            element.removeClass(this.cssClassSwipeOut);\r\n            element.removeClass(this.cssClassHidden);\r\n            element.addClass(this.cssClassSwipeIn);\r\n        }\r\n        else {\r\n            element.removeClass(this.cssClassSwipeIn);\r\n            element.addClass(this.cssClassSwipeOut);\r\n        }\r\n    }\r\n    initCloseBtn() {\r\n        $(this.newsMessageCloseBtnIdSelector).on("click", (e) => {\r\n            this.closeMessageBox();\r\n        });\r\n    }\r\n    closeMessageBox() {\r\n        $(this.newsEntryDetailsWrapperClassSelector).removeClass(this.cssClassSwipeOut);\r\n        $(this.newsEntryDetailsWrapperClassSelector).removeClass(this.cssClassSwipeIn);\r\n        $(this.newsMessageContainerIdSelector).addClass(this.cssClassHidden);\r\n    }\r\n    getNoNewsObject() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const noNews = {\r\n                creationDate: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.message.new-messages.no-news.today"),\r\n                publishTime: "0",\r\n                title: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.message.new-messages.no-news.title"),\r\n                desc: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.message.new-messages.no-news.desc"),\r\n                body: AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.message.new-messages.no-news.body"),\r\n                cssClass: "",\r\n            };\r\n            return [noNews];\r\n        });\r\n    }\r\n    parseNewsData(data) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            this.hasNews = false;\r\n            if (!data.result) {\r\n                return yield this.getNoNewsObject();\r\n            }\r\n            const appType = this.getAppType();\r\n            const locale = yield this.getLocale();\r\n            const latestPublishDate = this.lastNewsSeenDateTime;\r\n            const resultData = data.result;\r\n            const filteredArray = yield this.filterArray(resultData, appType, latestPublishDate, locale);\r\n            if (filteredArray.length < 1) {\r\n                return yield this.getNoNewsObject();\r\n            }\r\n            return filteredArray;\r\n        });\r\n    }\r\n    getLocale() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            return (0, utils_1.getParams)().userLocale;\r\n        });\r\n    }\r\n    getAppType() {\r\n        return "server-free";\r\n    }\r\n    getLaterDate(dateA, dateB) {\r\n        if (this.isDateTheSame(dateA.date, dateB.date)) {\r\n            if (this.isTimeAAfterTimeB(dateA.hour, dateB.hour)) {\r\n                return dateA;\r\n            }\r\n            return dateB;\r\n        }\r\n        if (this.isDateAAfterDateB(dateA.date, dateB.date)) {\r\n            return dateA;\r\n        }\r\n        return dateB;\r\n    }\r\n    isCreationAfterLastSeen(createDate, publishTime) {\r\n        if (!this.lastNewsSeenDateTime.date || !this.lastNewsSeenDateTime.hour) {\r\n            const lastNewsSeenDateString = this.dateMinusDaysToString(new Date(), 10);\r\n            this.lastNewsSeenDateTime = lastNewsSeenDateString;\r\n        }\r\n        const isCreationDateAfterLastSeen = this.isDateAAfterDateB(createDate, this.lastNewsSeenDateTime.date);\r\n        const isDateTheSame = this.isDateTheSame(createDate, this.lastNewsSeenDateTime.date);\r\n        const isPublishTimeAfterLastSeen = this.isTimeAAfterTimeB(publishTime, this.lastNewsSeenDateTime.hour);\r\n        const isNewEntry = isCreationDateAfterLastSeen ? true : isDateTheSame && isPublishTimeAfterLastSeen;\r\n        return isNewEntry;\r\n    }\r\n    isDateAAfterDateB(dateA, dateB) {\r\n        const dateAArray = dateA.split("-");\r\n        const dateBArray = dateB.split("-");\r\n        if (parseInt(dateAArray[0]) > parseInt(dateBArray[0])) {\r\n            return true;\r\n        }\r\n        if (parseInt(dateAArray[0]) < parseInt(dateBArray[0])) {\r\n            return false;\r\n        }\r\n        if (parseInt(dateAArray[1]) > parseInt(dateBArray[1])) {\r\n            return true;\r\n        }\r\n        if (parseInt(dateAArray[1]) < parseInt(dateBArray[1])) {\r\n            return false;\r\n        }\r\n        return parseInt(dateAArray[2]) > parseInt(dateBArray[2]);\r\n    }\r\n    isDateTheSame(dateA, dateB) {\r\n        const dateAArray = dateA.split("-");\r\n        const dateBArray = dateB.split("-");\r\n        if (parseInt(dateAArray[0]) === parseInt(dateBArray[0]) && parseInt(dateAArray[1]) === parseInt(dateBArray[1]) && parseInt(dateAArray[2]) === parseInt(dateBArray[2])) {\r\n            return true;\r\n        }\r\n        return false;\r\n    }\r\n    isTimeAAfterTimeB(timeA, timeB) {\r\n        return parseInt(timeA) > parseInt(timeB);\r\n    }\r\n    makeRequest(opts, contentType) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            if (!opts) {\r\n                vxcpLogger.logError("makeRequest", "Not enough parameters");\r\n                return;\r\n            }\r\n            return $.ajax(opts);\r\n        });\r\n    }\r\n    buildS3RestCall() {\r\n        return this.makeRequest({\r\n            url: this.bucketUrl,\r\n            method: "GET",\r\n            timeout: 3000,\r\n        });\r\n    }\r\n    filterArray(resultData, appType, latestPublishDate, locale) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const filteredArray = [];\r\n            resultData.forEach((entry) => {\r\n                if (entry.app.includes(appType)) {\r\n                    try {\r\n                        if (!entry.publishTime) {\r\n                            entry.publishTime = "12";\r\n                        }\r\n                        const filteredData = {\r\n                            publishTime: entry.publishTime,\r\n                            creationDate: entry.creationDate,\r\n                            title: entry.en.title,\r\n                            desc: entry.en.desc,\r\n                            body: entry.en.body,\r\n                            cssClass: "",\r\n                        };\r\n                        latestPublishDate = this.getLaterDate(latestPublishDate, {\r\n                            hour: entry.publishTime,\r\n                            date: entry.creationDate,\r\n                        });\r\n                        const isCreationDateAfterLastSeen = this.isCreationAfterLastSeen(entry.creationDate, entry.publishTime);\r\n                        if (isCreationDateAfterLastSeen) {\r\n                            this.hasNews = true;\r\n                            filteredData.cssClass = this.cssClassUnread;\r\n                        }\r\n                        if (locale === "de_DE") {\r\n                            filteredData.title = entry.de.title;\r\n                            filteredData.desc = entry.de.desc;\r\n                            filteredData.body = entry.de.body;\r\n                        }\r\n                        filteredArray.push(filteredData);\r\n                    }\r\n                    catch (e) {\r\n                        vxcpLogger.logInfo("filterArray", "News Entry is malformed.", { entry });\r\n                    }\r\n                }\r\n            });\r\n            this.lastNewsSeenDateTime = latestPublishDate;\r\n            return filteredArray;\r\n        });\r\n    }\r\n}\r\nexports.DynamicContentService = DynamicContentService;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/dynamic-content-service.ts?')},"./common/enterprise-license-checker.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.checkEnterprisePluginLicense = exports.baseUrl = void 0;\r\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\r\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\r\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "EnterpriseLicenseChecker");\r\nexports.baseUrl = AJS.contextPath() + "/rest/bpmn-modeler-enterprise/1.0/license/";\r\nfunction checkEnterprisePluginLicense() {\r\n    return AJS.$.ajax({\r\n        cache: false,\r\n        url: exports.baseUrl + "licenseType",\r\n        type: "GET",\r\n        dataType: "json",\r\n        error: (err) => {\r\n            vxcpLogger.logInfo("checkEnterprisePluginLicense", "INFO @EnterpriseLicenseChecker.checkEnterprisePluginLicense: BPMN-Modeler Enterprise not installed.", err);\r\n            return Promise.resolve("INVALID");\r\n        },\r\n    });\r\n}\r\nexports.checkEnterprisePluginLicense = checkEnterprisePluginLicense;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/enterprise-license-checker.ts?')},"./common/newDiagramXml.ts":(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.getNewDiagramXml = void 0;\r\nconst newDiagram = __webpack_require__("./common/resources/newDiagram.bpmn");\r\nconst getNewDiagramXml = () => newDiagram;\r\nexports.getNewDiagramXml = getNewDiagramXml;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/newDiagramXml.ts?')},"./common/notification.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.showEndOfSupportMessage = exports.showEnterpriseWithLicenseHint = exports.setSuccessMessage = exports.showAdForEnterpriseEditor = exports.showInfoDialogForEnterpriseModeler = exports.setInfoMessage = exports.setErrorMessage = exports.setWarningMessage = exports.clearMessageBox = exports.show = void 0;\r\nconst utils = __importStar(__webpack_require__("./common/utils.ts"));\r\nconst utils_1 = __webpack_require__("./common/utils.ts");\r\nfunction show(message) {\r\n    if (!("Notification" in window)) {\r\n        alert(message);\r\n    }\r\n    else if (Notification.permission === "granted") {\r\n        return new Notification(message);\r\n    }\r\n    else if (Notification.permission !== "denied") {\r\n        Notification.requestPermission((permission) => {\r\n            if (permission === "granted") {\r\n                return new Notification(message);\r\n            }\r\n        });\r\n    }\r\n}\r\nexports.show = show;\r\nfunction clearMessageBox() {\r\n    const $messageBox = $("#vbcp-modeler-messages");\r\n    $messageBox.empty();\r\n    const $auiMessageBox = $("#aui-message-bar");\r\n    $auiMessageBox.empty();\r\n}\r\nexports.clearMessageBox = clearMessageBox;\r\nfunction setWarningMessage(title, body, fadeout, identifier, closeable, delay = 5000) {\r\n    if (identifier) {\r\n        AJS.messages.warning(identifier, {\r\n            title,\r\n            body,\r\n            fadeout,\r\n            delay,\r\n        });\r\n    }\r\n    else {\r\n        clearMessageBox();\r\n        AJS.messages.warning({\r\n            title,\r\n            body,\r\n            fadeout,\r\n            delay,\r\n        });\r\n    }\r\n}\r\nexports.setWarningMessage = setWarningMessage;\r\nfunction setErrorMessage(title, body, fadeout, identifier, closeable, delay = 5000) {\r\n    if (identifier) {\r\n        AJS.messages.error(identifier, {\r\n            title,\r\n            body,\r\n            fadeout,\r\n            delay,\r\n        });\r\n    }\r\n    else {\r\n        clearMessageBox();\r\n        AJS.messages.error({\r\n            title,\r\n            body,\r\n            fadeout,\r\n            delay,\r\n        });\r\n    }\r\n}\r\nexports.setErrorMessage = setErrorMessage;\r\nfunction setInfoMessage(title, body, fadeout, identifier, closeable, delay = 5000) {\r\n    if (identifier) {\r\n        AJS.messages.info(identifier, {\r\n            title,\r\n            body,\r\n            fadeout,\r\n            delay,\r\n        });\r\n    }\r\n    else {\r\n        clearMessageBox();\r\n        AJS.messages.info({\r\n            title,\r\n            body,\r\n            fadeout,\r\n            delay,\r\n        });\r\n    }\r\n}\r\nexports.setInfoMessage = setInfoMessage;\r\nfunction showInfoDialogForEnterpriseModeler(votingService, enterpriseLicense, callbackAbort) {\r\n    return __awaiter(this, void 0, void 0, function* () {\r\n        $("#viadee-info-header").blur();\r\n        const dialogId = "#vbcp-info-dialog";\r\n        let language = "";\r\n        try {\r\n            language = (0, utils_1.getParams)().userLocale.toLowerCase().startsWith("de") ? "de" : "";\r\n        }\r\n        catch (err) {\r\n        }\r\n        utils.showDialog(AJS, dialogId, Confluence.Templates.viadee.bpmnplugin.infoDialog, () => {\r\n            const activeElement = document.activeElement;\r\n            if (activeElement) {\r\n                activeElement.blur();\r\n            }\r\n        }, callbackAbort, { de: language, enterpriseLicense: enterpriseLicense === "true" });\r\n        $(`${dialogId}-alt-continue`).on("click", () => {\r\n            window.open(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.info-link"), "_blank");\r\n        });\r\n        yield votingService.setVoteIconCss();\r\n        yield votingService.setVoteInfoDialogCss();\r\n        const youtube = document.getElementById("viadee-info-bpmnmodeler-video");\r\n        youtube.onclick = (event) => {\r\n            const iframe = document.createElement("iframe");\r\n            iframe.setAttribute("class", "viadee-info-bpmnmodeler-video");\r\n            iframe.setAttribute("src", "https://www.youtube-nocookie.com/embed/E7A3paeFUwM?vq=hd1080&showinfo=0&rel=0&amp&autoplay=1");\r\n            iframe.setAttribute("frameborder", "0");\r\n            iframe.setAttribute("allow", "accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture");\r\n            iframe.setAttribute("allowfullscreen", "");\r\n            const videoPlaceholder = event.target.parentNode;\r\n            videoPlaceholder.parentNode.replaceChild(iframe, videoPlaceholder);\r\n        };\r\n    });\r\n}\r\nexports.showInfoDialogForEnterpriseModeler = showInfoDialogForEnterpriseModeler;\r\nfunction showAdForEnterpriseEditor(votingService, enterpriseLicense) {\r\n    const identifier = "#vbcp-modeler-info-enterprise";\r\n    setErrorMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.small-info-message.heading"), AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.small-info-message.body"), true, identifier, true, 180000);\r\n    const message = $(identifier);\r\n    const buttonHtml = `<ul class="aui-nav-actions-list">\n<li><button id="vbcp-modeler-info-enterprise-link" class="aui-button aui-button-link" >\n${AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.tell-me-more")}\n</button></li></ul>`;\r\n    if (message) {\r\n        const bodyElement = message.find(".aui-message");\r\n        const bodyHtml = bodyElement.html();\r\n        bodyElement.html(bodyHtml + buttonHtml);\r\n    }\r\n    const infoLink = document.getElementById("vbcp-modeler-info-enterprise-link");\r\n    infoLink.onclick = (e) => __awaiter(this, void 0, void 0, function* () {\r\n        e.preventDefault();\r\n        e.stopPropagation();\r\n        yield showInfoDialogForEnterpriseModeler(votingService, enterpriseLicense, () => __awaiter(this, void 0, void 0, function* () {\r\n            yield votingService.toggleVote();\r\n        }));\r\n    });\r\n}\r\nexports.showAdForEnterpriseEditor = showAdForEnterpriseEditor;\r\nfunction setSuccessMessage(title, body, fadeout, identifier, closeable) {\r\n    if (identifier) {\r\n        AJS.messages.success(identifier, {\r\n            title,\r\n            body,\r\n            fadeout,\r\n        });\r\n    }\r\n    else {\r\n        clearMessageBox();\r\n        AJS.messages.success({\r\n            title,\r\n            body,\r\n            fadeout,\r\n        });\r\n    }\r\n}\r\nexports.setSuccessMessage = setSuccessMessage;\r\nfunction showEnterpriseWithLicenseHint(diagramId) {\r\n    if ($("#vbcp-message-box").children().length < 1) {\r\n        setInfoMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.vbcp-macro.viewer.enterprise-active-title"), AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.vbcp-macro.viewer.enterprise-active-body"), false, "#vbcp-message-box-" + diagramId, true);\r\n    }\r\n}\r\nexports.showEnterpriseWithLicenseHint = showEnterpriseWithLicenseHint;\r\nfunction showEndOfSupportMessage(diagramId) {\r\n    setInfoMessage(AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.eos-message.header"), AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.eos-message.message") + " ❤️</p>", false, "#vbcp-message-box-" + diagramId, true);\r\n}\r\nexports.showEndOfSupportMessage = showEndOfSupportMessage;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/notification.ts?')},"./common/plugin-name-service.ts":(__unused_webpack_module,exports)=>{"use strict";eval('\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.pluginName = void 0;\r\nexports.pluginName = "BPMN-FREE-PLUGIN";\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/plugin-name-service.ts?')},"./common/rest-service.ts":(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval('\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.buildPluginBaseUrl = void 0;\r\nconst utils_1 = __webpack_require__("./common/utils.ts");\r\nconst buildPluginBaseUrl = () => {\r\n    const baseUrl = `${window.location.protocol}//${window.location.host}`;\r\n    const contextPath = (0, utils_1.getParams)().contextPath;\r\n    return baseUrl + contextPath;\r\n};\r\nexports.buildPluginBaseUrl = buildPluginBaseUrl;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/rest-service.ts?')},"./common/utils.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.getRemoteUserKey = exports.getCurrentUserFullName = exports.getConfluenceVersion = exports.getSpaceName = exports.getSpaceKey = exports.getBaseUrl = exports.isNewPage = exports.getContextPath = exports.getUserLocale = exports.getLatestPageId = exports.getContentType = exports.getPageId = exports.getAccessMode = exports.getContentId = exports.getParams = exports.initViadeeLogo = exports.moveDiagramToTopLeft = exports.initZoomButtons = exports.removeDjsHelperSvg = exports.showDialog = exports.getQueryParam = exports.createIFrame = void 0;\r\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\r\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\r\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "Utils");\r\nfunction createIFrame(pageId, diagramId, diagramName, enterpriseLicense, reloadPage = true) {\r\n    const iframe = document.createElement("iframe");\r\n    iframe.setAttribute("id", "bpmn-editor");\r\n    iframe.setAttribute("style", "position: fixed; width: 100%; height: 100%; top: 0px; left: 0px; border: 0px none; z-index: 3000;");\r\n    iframe.setAttribute("src", Confluence.getContextPath() +\r\n        "/plugins/bpmn-plugin/edit-diagram.action?pageId=" +\r\n        pageId +\r\n        "&diagramId=" +\r\n        diagramId +\r\n        "&diagramName=" +\r\n        diagramName +\r\n        "&reloadPage=" +\r\n        reloadPage +\r\n        "&enterpriseLicense=" +\r\n        enterpriseLicense);\r\n    iframe.onload = () => {\r\n        $("body").css("overflow", "hidden");\r\n    };\r\n    return iframe;\r\n}\r\nexports.createIFrame = createIFrame;\r\nfunction getQueryParam(param) {\r\n    const result = window.location.search.match(new RegExp("(\\\\?|&)" + param + "(\\\\[\\\\])?=([^&]*)"));\r\n    return result ? result[3] : 0;\r\n}\r\nexports.getQueryParam = getQueryParam;\r\nfunction showDialog(AJS, dialogId, template, callbackContinue, callbackAbort, params) {\r\n    removeDjsHelperSvg(AJS.$);\r\n    const dialog = template(params);\r\n    AJS.$("body").append(dialog);\r\n    AJS.dialog2(dialogId).show();\r\n    AJS.dialog2(dialogId).on("hide", () => {\r\n        AJS.$(dialogId).remove();\r\n    });\r\n    AJS.$(dialogId + "-abort").click(() => __awaiter(this, void 0, void 0, function* () {\r\n        AJS.dialog2(dialogId).hide();\r\n        if (typeof callbackAbort === "function") {\r\n            yield callbackAbort();\r\n        }\r\n    }));\r\n    AJS.$(dialogId + "-vote").click(() => __awaiter(this, void 0, void 0, function* () {\r\n        if (typeof callbackAbort === "function") {\r\n            yield callbackAbort();\r\n        }\r\n    }));\r\n    AJS.$(dialogId + "-continue").click(() => __awaiter(this, void 0, void 0, function* () {\r\n        AJS.dialog2(dialogId).hide();\r\n        if (typeof callbackContinue === "function") {\r\n            yield callbackContinue();\r\n        }\r\n    }));\r\n}\r\nexports.showDialog = showDialog;\r\nfunction removeDjsHelperSvg($) {\r\n    const svgHelpers = $("#helper-svg");\r\n    if (svgHelpers) {\r\n        svgHelpers.remove();\r\n    }\r\n}\r\nexports.removeDjsHelperSvg = removeDjsHelperSvg;\r\nfunction initZoomButtons(viewerModeler) {\r\n    const zoomResetId = "btn-zoom-reset";\r\n    const zoomResetIcon = "aui-iconfont-search";\r\n    const zoomResetName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.zoom.reset");\r\n    const zoomResetToViewPortId = "btn-zoom-reset-to-view-port";\r\n    const zoomResetToViewPortIcon = "aui-iconfont-table-bg";\r\n    const zoomResetToViewPortName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.zoom.fit.to.viewport");\r\n    const zoomInId = "btn-zoom-in";\r\n    const zoomInIcon = "";\r\n    const zoomInName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.zoom.in");\r\n    const zoomInContent = "+";\r\n    const zoomOutId = "btn-zoom-out";\r\n    const zoomOutIcon = "";\r\n    const zoomOutName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.zoom.out");\r\n    const zoomOutContent = "-";\r\n    const zoomResetToViewPortHtml = createBtnHtml(zoomResetToViewPortId, zoomResetToViewPortIcon, zoomResetToViewPortName, "219", "15");\r\n    const zoomResetHtml = createBtnHtml(zoomResetId, zoomResetIcon, zoomResetName, "170", "15");\r\n    const zoomInHtml = createBtnHtml(zoomInId, zoomInIcon, zoomInName, "121", "15", zoomInContent);\r\n    const zoomOutHtml = createBtnHtml(zoomOutId, zoomOutIcon, zoomOutName, "80", "15", zoomOutContent);\r\n    const zoomScroll = viewerModeler.get("zoomScroll");\r\n    appendAndAddClickListener(zoomResetToViewPortHtml, zoomResetToViewPortId, (event) => {\r\n        zoomDiagramFitToCanvas(viewerModeler, 30, 20, 110);\r\n        event.preventDefault();\r\n    });\r\n    appendAndAddClickListener(zoomResetHtml, zoomResetId, (event) => {\r\n        moveDiagramToTopLeft(viewerModeler, 180, 100);\r\n        event.preventDefault();\r\n    });\r\n    appendAndAddClickListener(zoomInHtml, zoomInId, (event) => {\r\n        zoomScroll.stepZoom(1);\r\n        event.preventDefault();\r\n    });\r\n    appendAndAddClickListener(zoomOutHtml, zoomOutId, (event) => {\r\n        zoomScroll.stepZoom(-1);\r\n        event.preventDefault();\r\n    });\r\n    function createBtnHtml(btnId, iconClass, titleName, positionBottom, positionRight, btnContent) {\r\n        const content = btnContent ? btnContent : "";\r\n        const icon = iconClass ? `<span class="aui-icon aui-icon-small ${iconClass}" title="${titleName}"></span>` : "";\r\n        const titleIfNoClass = iconClass ? "" : `title="${titleName}"`;\r\n        const htmlCode = `<a id="${btnId}"\n            class="bjs-powered-by btn-zoom"\n            style="bottom: ${positionBottom}px; right: ${positionRight}px;" ${titleIfNoClass}>\n            ${content}${icon}\n            </a>`;\r\n        return htmlCode;\r\n    }\r\n    function appendAndAddClickListener(btnHtml, btnId, clickFn) {\r\n        $(".bjs-container").append(btnHtml);\r\n        $("#" + btnId).on("click", clickFn);\r\n    }\r\n}\r\nexports.initZoomButtons = initZoomButtons;\r\nfunction moveDiagramToTopLeft(viewerModeler, paddingLeft, paddingTop) {\r\n    const canvas = viewerModeler.get("canvas");\r\n    const diagramSizes = canvas.getDefaultLayer().getBBox();\r\n    const outerBox = canvas.viewbox().outer;\r\n    canvas.viewbox({\r\n        x: diagramSizes.x - paddingLeft,\r\n        y: diagramSizes.y - paddingTop,\r\n        width: outerBox.width,\r\n        height: outerBox.height,\r\n    });\r\n}\r\nexports.moveDiagramToTopLeft = moveDiagramToTopLeft;\r\nfunction zoomDiagramFitToCanvas(viewerModeler, paddingWidth, paddingHeight, marginLeft, marginTop) {\r\n    const minPaddingWidthPx = paddingWidth || 0;\r\n    const minPaddingHeightPx = paddingHeight || 0;\r\n    const marginLeftPx = marginLeft || 0;\r\n    const marginTopPx = marginTop || 0;\r\n    const canvas = viewerModeler.get("canvas");\r\n    const oldViewbox = canvas.viewbox();\r\n    const diagramSizesDpp = canvas.getDefaultLayer().getBBox();\r\n    const outerBox = oldViewbox.outer;\r\n    let pxToDppFactor = 1;\r\n    let newWidthDpp;\r\n    let newHeightDpp;\r\n    let paddingHeightPx = minPaddingHeightPx;\r\n    let paddingWidthPx = minPaddingWidthPx;\r\n    const outerHeightPx = outerBox.height - 2 * minPaddingHeightPx - marginTopPx;\r\n    const outerWidthPx = outerBox.width - 2 * minPaddingWidthPx - marginLeftPx;\r\n    const outerBoxRatio = outerWidthPx / outerHeightPx;\r\n    const diagramRatio = diagramSizesDpp.width / diagramSizesDpp.height;\r\n    const landscapeMode = diagramRatio > outerBoxRatio;\r\n    if (landscapeMode) {\r\n        pxToDppFactor = diagramSizesDpp.width / outerWidthPx;\r\n        newWidthDpp = diagramSizesDpp.width + 2 * toDpp(paddingWidthPx);\r\n        newHeightDpp = newWidthDpp / outerBoxRatio;\r\n        paddingHeightPx = calcPaddingPx(diagramSizesDpp.height, newHeightDpp, minPaddingHeightPx);\r\n    }\r\n    else {\r\n        pxToDppFactor = diagramSizesDpp.height / outerHeightPx;\r\n        newHeightDpp = diagramSizesDpp.height + 2 * toDpp(paddingHeightPx);\r\n        newWidthDpp = newHeightDpp * outerBoxRatio;\r\n        paddingWidthPx = calcPaddingPx(diagramSizesDpp.width, newWidthDpp, minPaddingWidthPx);\r\n    }\r\n    canvas.viewbox({\r\n        x: diagramSizesDpp.x - toDpp(paddingWidthPx + marginLeftPx),\r\n        y: diagramSizesDpp.y - toDpp(paddingHeightPx + marginTopPx),\r\n        width: newWidthDpp + toDpp(marginLeftPx),\r\n        height: newHeightDpp + toDpp(marginTopPx),\r\n    });\r\n    function calcPaddingPx(actSizeDpp, newSizeDpp, minPaddingPx) {\r\n        if (!actSizeDpp || !newSizeDpp) {\r\n            vxcpLogger.logError("calcPaddingPx", "Error at calcPaddingPx: Missing parameter, check function calling.");\r\n            return;\r\n        }\r\n        const dppDiff = newSizeDpp - actSizeDpp;\r\n        const halfDppDiff = dppDiff / 2;\r\n        const paddingDpp = halfDppDiff < 0 ? halfDppDiff * -1 : halfDppDiff;\r\n        const paddingPx = toPx(paddingDpp);\r\n        return paddingPx < minPaddingPx ? minPaddingPx : paddingPx;\r\n    }\r\n    function toPx(dppValue) {\r\n        return dppValue / pxToDppFactor;\r\n    }\r\n    function toDpp(pxValue) {\r\n        return pxValue * pxToDppFactor;\r\n    }\r\n}\r\nfunction initViadeeLogo(diagramName) {\r\n    diagramName = diagramName.replace(" ", "_");\r\n    const viadeeLogoId = `viadee-logo-viewer-${diagramName}`;\r\n    const viadeeLogoName = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.icon.title.name.viadee.logo");\r\n    const modelerLink = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.info-link");\r\n    const viadeeLogo = createViadeeLogo(viadeeLogoId, viadeeLogoName, "22", "30");\r\n    $(`#viewer-${diagramName} .bjs-container`).append(viadeeLogo);\r\n    $(`#${viadeeLogoId}`).on("click", (event) => {\r\n        window.open(modelerLink, "_blank");\r\n        event.preventDefault();\r\n    });\r\n}\r\nexports.initViadeeLogo = initViadeeLogo;\r\nfunction createViadeeLogo(viadeeLogoId, titleName, positionBottom, positionLeft) {\r\n    const title = `title="${titleName}"`;\r\n    const htmlCode = `<div id="${viadeeLogoId}"\n            class="viadee-logo-viewer"\n            position="absolute"\n            style="bottom: ${positionBottom}px; left: ${positionLeft}px;" ${title}>\n            </div>`;\r\n    return htmlCode;\r\n}\r\nfunction getParams() {\r\n    return {\r\n        accessMode: getAccessMode(),\r\n        baseUrl: getBaseUrl(),\r\n        currentUserFullname: getCurrentUserFullName(),\r\n        versionNumber: getConfluenceVersion(),\r\n        newPage: isNewPage(),\r\n        spaceKey: getSpaceKey(),\r\n        spaceName: getSpaceName(),\r\n        pageId: getPageId(),\r\n        contentType: getContentType(),\r\n        latestPageId: getLatestPageId(),\r\n        userLocale: getUserLocale(),\r\n        contextPath: getContextPath(),\r\n        remoteUserKey: getRemoteUserKey(),\r\n        contentId: getContentId(),\r\n    };\r\n}\r\nexports.getParams = getParams;\r\nfunction getContentId() {\r\n    return Confluence.getContentId() ? Confluence.getContentId() : AJS.Meta.get("content-id");\r\n}\r\nexports.getContentId = getContentId;\r\nfunction getAccessMode() {\r\n    return AJS.Meta.get("access-mode");\r\n}\r\nexports.getAccessMode = getAccessMode;\r\nfunction getPageId() {\r\n    return AJS.Meta.get("page-id");\r\n}\r\nexports.getPageId = getPageId;\r\nfunction getContentType() {\r\n    return AJS.Meta.get("content-type");\r\n}\r\nexports.getContentType = getContentType;\r\nfunction getLatestPageId() {\r\n    return AJS.Meta.get("latest-page-id");\r\n}\r\nexports.getLatestPageId = getLatestPageId;\r\nfunction getUserLocale() {\r\n    return AJS.Meta.get("user-locale");\r\n}\r\nexports.getUserLocale = getUserLocale;\r\nfunction getContextPath() {\r\n    return AJS.Meta.get("context-path") || Confluence.getContextPath();\r\n}\r\nexports.getContextPath = getContextPath;\r\nfunction isNewPage() {\r\n    return AJS.Meta.get("new-page");\r\n}\r\nexports.isNewPage = isNewPage;\r\nfunction getBaseUrl() {\r\n    return AJS.Meta.get("base-url");\r\n}\r\nexports.getBaseUrl = getBaseUrl;\r\nfunction getSpaceKey() {\r\n    return AJS.Meta.get("space-key");\r\n}\r\nexports.getSpaceKey = getSpaceKey;\r\nfunction getSpaceName() {\r\n    return AJS.Meta.get("space-name");\r\n}\r\nexports.getSpaceName = getSpaceName;\r\nfunction getConfluenceVersion() {\r\n    return AJS.Meta.get("version-number");\r\n}\r\nexports.getConfluenceVersion = getConfluenceVersion;\r\nfunction getCurrentUserFullName() {\r\n    return AJS.Meta.get("current-user-fullname");\r\n}\r\nexports.getCurrentUserFullName = getCurrentUserFullName;\r\nfunction getRemoteUserKey() {\r\n    return AJS.Meta.get("remote-user-key");\r\n}\r\nexports.getRemoteUserKey = getRemoteUserKey;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/utils.ts?')},"./common/validator.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.isValidInput = exports.decodeFromHtmlEntities = exports.encodeToHtmlEntities = exports.getDiagramNameAsParamString = exports.isValidMacroName = void 0;\r\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\r\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\r\nconst utils_1 = __webpack_require__("./common/utils.ts");\r\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "Validator");\r\nfunction isValidMacroName(name) {\r\n    const rteEditor = AJS.Rte.getEditor();\r\n    const editorHtml = rteEditor.getContent();\r\n    const regexFree = /<img class="editor-inline-macro".*?data-macro-name="vbcp-macro".*?diagramName=(.*?)"/g;\r\n    const regexEnt = /<img class="editor-inline-macro".*?data-macro-name="vbcp-macro-enterprise".*?diagramName=(.*?)[|"]/g;\r\n    let regexArray = regexEnt.exec(editorHtml);\r\n    const results = [];\r\n    while (regexArray !== null) {\r\n        const txt = decodeFromHtmlEntities(regexArray[1].toLowerCase());\r\n        results.push(txt);\r\n        regexArray = regexEnt.exec(editorHtml);\r\n    }\r\n    regexArray = regexFree.exec(editorHtml);\r\n    while (regexArray !== null) {\r\n        const txt = decodeFromHtmlEntities(regexArray[1].toLowerCase());\r\n        results.push(txt);\r\n        regexArray = regexFree.exec(editorHtml);\r\n    }\r\n    const macroExistsOnPage = results.indexOf(name.toLowerCase()) !== -1;\r\n    if ((0, utils_1.getParams)().newPage) {\r\n        return Promise.resolve(!macroExistsOnPage);\r\n    }\r\n    const baseUrl = (0, utils_1.getParams)().baseUrl;\r\n    const pageId = (0, utils_1.getParams)().contentId;\r\n    const restCallChilds = baseUrl.concat("/rest/api/content/", pageId, "/child/comment?expand=body.storage");\r\n    const searchMacroInComments = new Promise((resolve, reject) => {\r\n        $.ajax({\r\n            type: "GET",\r\n            url: restCallChilds,\r\n            success: (commentData) => {\r\n                const commentsExist = commentData && commentData.results && commentData.results.length;\r\n                let macroExists = false;\r\n                if (commentsExist) {\r\n                    commentData.results.forEach((comment) => {\r\n                        const splitPageDataMacros = comment.body.storage.value.split("ac:structured-macro");\r\n                        splitPageDataMacros.find((elem) => {\r\n                            const replacedDiagramName = encodeToHtmlEntities(name);\r\n                            const diagramNameParam = getDiagramNameAsParamString(replacedDiagramName);\r\n                            if (elem.indexOf(`ac:name="vbcp-macro-enterprise"`) !== -1 && elem.indexOf(diagramNameParam) !== -1) {\r\n                                macroExists = true;\r\n                            }\r\n                        });\r\n                    });\r\n                }\r\n                resolve(macroExists);\r\n            },\r\n            error: (err) => {\r\n                vxcpLogger.logError("isValidMacroName", "An error occurred while checking whether the given name of macro is valid.", err);\r\n                resolve(false);\r\n            },\r\n        });\r\n    });\r\n    return new Promise((resolveGlobal) => {\r\n        searchMacroInComments.then((macroExistsInComments) => {\r\n            resolveGlobal(!macroExistsInComments && !macroExistsOnPage);\r\n        });\r\n    });\r\n}\r\nexports.isValidMacroName = isValidMacroName;\r\nfunction getDiagramNameAsParamString(diagramName) {\r\n    return `<ac:parameter ac:name="diagramName">${diagramName}</ac:parameter>`;\r\n}\r\nexports.getDiagramNameAsParamString = getDiagramNameAsParamString;\r\nfunction encodeToHtmlEntities(str) {\r\n    let replacedStr = str;\r\n    replacedStr = replacedStr.replace(/Ä/g, "&Auml;");\r\n    replacedStr = replacedStr.replace(/ä/g, "&auml;");\r\n    replacedStr = replacedStr.replace(/Ö/g, "&Ouml;");\r\n    replacedStr = replacedStr.replace(/ö/g, "&ouml;");\r\n    replacedStr = replacedStr.replace(/Ü/g, "&Uuml;");\r\n    replacedStr = replacedStr.replace(/ü/g, "&uuml;");\r\n    replacedStr = replacedStr.replace(/ß/g, "&szlig;");\r\n    return replacedStr;\r\n}\r\nexports.encodeToHtmlEntities = encodeToHtmlEntities;\r\nfunction decodeFromHtmlEntities(str) {\r\n    let replacedStr = str;\r\n    replacedStr = replacedStr.replace(/&Auml;/g, "Ä");\r\n    replacedStr = replacedStr.replace(/&auml;/g, "ä");\r\n    replacedStr = replacedStr.replace(/&Ouml;/g, "Ö");\r\n    replacedStr = replacedStr.replace(/&ouml;/g, "ö");\r\n    replacedStr = replacedStr.replace(/&Uuml;/g, "Ü");\r\n    replacedStr = replacedStr.replace(/&uuml;/g, "ü");\r\n    replacedStr = replacedStr.replace(/&szlig;/g, "ß");\r\n    return replacedStr;\r\n}\r\nexports.decodeFromHtmlEntities = decodeFromHtmlEntities;\r\nfunction isValidInput(input) {\r\n    if (!input) {\r\n        return false;\r\n    }\r\n    return /^[A-Za-z0-9 \\u00c4\\u00e4\\u00d6\\u00f6\\u00dc\\u00fc\\u00df\\-]+$/g.test(input);\r\n}\r\nexports.isValidInput = isValidInput;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/validator.ts?')},"./common/voting-service.ts":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nexports.VotingService = void 0;\r\nconst rest_service_1 = __webpack_require__("./common/rest-service.ts");\r\nconst confUtils = __importStar(__webpack_require__("./common/utils.ts"));\r\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\r\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\r\nclass VotingService {\r\n    constructor() {\r\n        this.vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "VotingService");\r\n    }\r\n    init($voteLink, $voteCounter) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            this.$voteCounter = $voteCounter;\r\n            this.$voteLink = $voteLink;\r\n            yield this.initVotingLogic();\r\n        });\r\n    }\r\n    voteLinkClickAction() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const votesConsistent = yield this.checkIfButtonAndVoteConsistent();\r\n            const userVoted = yield this.getUserHasVoted();\r\n            if (!votesConsistent || !userVoted) {\r\n                confUtils.showDialog(AJS, "#vbcp-vote-info-dialog", Confluence.Templates.viadee.bpmnplugin.voteInfoDialog, () => __awaiter(this, void 0, void 0, function* () {\r\n                    yield this.vote();\r\n                }), () => __awaiter(this, void 0, void 0, function* () {\r\n                    yield this.unvote();\r\n                }));\r\n                yield this.setVoteIconCss();\r\n                return;\r\n            }\r\n            if (userVoted) {\r\n                yield this.unvote();\r\n            }\r\n        });\r\n    }\r\n    setVoteIconCss() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const voted = yield this.getUserHasVoted();\r\n            yield this.toggleVoteIcon(voted);\r\n            yield this.setCurrentVoteCounterHtml();\r\n        });\r\n    }\r\n    setVoteInfoDialogCss() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const voteLink = $("#vbcp-info-dialog-vote");\r\n            const voted = yield this.getUserHasVoted();\r\n            voteLink.toggleClass("voted", voted);\r\n            const btnTitle = voted ? AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.voting-dialog.unvote") : AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.voting-dialog.vote");\r\n            voteLink.html(btnTitle);\r\n            voteLink.attr("title", btnTitle);\r\n        });\r\n    }\r\n    toggleVote() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const oldVoteBool = yield this.getUserHasVoted();\r\n            const newVoteBoolean = !oldVoteBool;\r\n            yield this.updateUserVoteContext(newVoteBoolean.toString());\r\n            yield this.updateCounterAndToggleToolbar(newVoteBoolean);\r\n            yield this.setVoteInfoDialogCss();\r\n        });\r\n    }\r\n    initVotingLogic() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const voted = yield this.getUserHasVoted();\r\n            yield this.toggleVoteIcon(voted);\r\n            yield this.setCurrentVoteCounterHtml();\r\n        });\r\n    }\r\n    vote() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const curVote = yield this.getUserHasVoted();\r\n            if (curVote) {\r\n                yield this.toggleVoteIcon(true);\r\n                yield this.setCurrentVoteCounterHtml();\r\n                return;\r\n            }\r\n            yield this.updateUserVoteContext("true");\r\n            yield this.updateCounterAndToggleToolbar(true);\r\n        });\r\n    }\r\n    unvote() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const curVote = yield this.getUserHasVoted();\r\n            if (!curVote) {\r\n                yield this.toggleVoteIcon(false);\r\n                yield this.updateCounterHtml(false);\r\n                yield this.setCurrentVoteCounterHtml();\r\n                return;\r\n            }\r\n            yield this.updateUserVoteContext("false");\r\n            yield this.updateCounterAndToggleToolbar(false);\r\n        });\r\n    }\r\n    checkIfButtonAndVoteConsistent() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const realVote = yield this.getUserHasVoted();\r\n            const iconVote = this.$voteLink.hasClass("voted");\r\n            return realVote === iconVote;\r\n        });\r\n    }\r\n    toggleVoteIcon(voted) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            this.$voteLink.toggleClass("voted", voted);\r\n            this.$voteCounter.toggleClass("voted", voted);\r\n            const btnTitle = voted ? AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.voting-dialog.unvote") : AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.voting-dialog.vote");\r\n            this.$voteLink.attr("title", btnTitle);\r\n        });\r\n    }\r\n    updateVoteCounter(userHasVoted) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const counter = yield this.updateCounterHtml(userHasVoted);\r\n            yield this.updateVotesActiveObject(counter);\r\n        });\r\n    }\r\n    updateCounterAndToggleToolbar(userHasVoted) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            yield this.toggleVoteIcon(userHasVoted);\r\n            yield this.updateVoteCounter(userHasVoted);\r\n        });\r\n    }\r\n    getUserHasVoted() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const voteString = yield this.getUserVotedRest();\r\n            return voteString === "true";\r\n        });\r\n    }\r\n    setCurrentVoteCounterHtml() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const counter = yield this.getHowManyUserVoted();\r\n            this.$voteCounter.html(counter);\r\n            this.$voteCounter.prop("title", `${counter} ${AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.button.hover.vote-counter-text")}`);\r\n        });\r\n    }\r\n    updateCounterHtml(userHasVoted) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            let counter = yield this.getHowManyUserVoted();\r\n            if (userHasVoted) {\r\n                counter = counter + 1;\r\n                if (counter < 0) {\r\n                    counter = 0;\r\n                }\r\n                this.$voteCounter.html(counter);\r\n                this.$voteCounter.prop("title", `${counter} ${AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.button.hover.vote-counter-text")}`);\r\n            }\r\n            else {\r\n                counter = counter - 1;\r\n                if (counter < 0) {\r\n                    counter = 0;\r\n                }\r\n                this.$voteCounter.html(counter);\r\n                this.$voteCounter.prop("title", `${counter} ${AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.button.hover.vote-counter-text")}`);\r\n            }\r\n            return counter;\r\n        });\r\n    }\r\n    getHowManyUserVoted() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const pluginBaseUrl = (0, rest_service_1.buildPluginBaseUrl)();\r\n            const restPath = `/rest/bpmn-modeler/1.0/votesForEnterprise/allVotes`;\r\n            const url = pluginBaseUrl + restPath;\r\n            let stringNumVotes = "0";\r\n            try {\r\n                stringNumVotes = yield $.ajax({\r\n                    url,\r\n                    type: "GET",\r\n                });\r\n            }\r\n            catch (err) {\r\n                this.vxcpLogger.logError("getHowManyUserVoted", " An error occurred while getting the number of voted users.", err);\r\n            }\r\n            return parseInt(stringNumVotes);\r\n        });\r\n    }\r\n    updateVotesActiveObject(counter) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const pluginBaseUrl = (0, rest_service_1.buildPluginBaseUrl)();\r\n            const restPath = `/rest/bpmn-modeler/1.0/votesForEnterprise/allVotes/${counter.toString()}`;\r\n            const url = pluginBaseUrl + restPath;\r\n            try {\r\n                yield $.ajax({\r\n                    url,\r\n                    type: "PUT",\r\n                });\r\n            }\r\n            catch (err) {\r\n                this.vxcpLogger.logError("updateVotesActiveObject", "An error occurred while updating the number of votes.", err);\r\n            }\r\n        });\r\n    }\r\n    getUserVotedRest() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const pluginBaseUrl = (0, rest_service_1.buildPluginBaseUrl)();\r\n            const restPath = `/rest/bpmn-modeler/1.0/votesForEnterprise/userVote`;\r\n            const url = pluginBaseUrl + restPath;\r\n            let hasVoted = "";\r\n            try {\r\n                hasVoted = yield $.ajax({\r\n                    url,\r\n                    type: "GET",\r\n                });\r\n            }\r\n            catch (err) {\r\n                this.vxcpLogger.logError("getUserVotedRest", "An error occurred while getting the cote context for active user.", err);\r\n            }\r\n            return hasVoted;\r\n        });\r\n    }\r\n    updateUserVoteContext(vote) {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            const pluginBaseUrl = (0, rest_service_1.buildPluginBaseUrl)();\r\n            const restPath = `/rest/bpmn-modeler/1.0/votesForEnterprise/userVote/${vote}`;\r\n            const url = pluginBaseUrl + restPath;\r\n            try {\r\n                yield $.ajax({\r\n                    url,\r\n                    type: "PUT",\r\n                });\r\n            }\r\n            catch (err) {\r\n                this.vxcpLogger.logError("updateUserVoteContext", "An error occurred while updating vote context for active user.", err);\r\n            }\r\n        });\r\n    }\r\n}\r\nexports.VotingService = VotingService;\r\n\n\n//# sourceURL=webpack://VBCPFREE/./common/voting-service.ts?')}}]);