(()=>{"use strict";var __webpack_modules__={"../../../../../core/vxcp-logger/src/vxcp-logger.ts":(__unused_webpack_module,exports)=>{eval('\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nclass VxcpLogger {\r\n    constructor(pluginName, serviceName, isEnabled = true) {\r\n        this.pluginName = pluginName;\r\n        this.serviceName = serviceName;\r\n        this.isEnabled = isEnabled;\r\n    }\r\n    logFatal(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.error(`FATAL@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.error(`FATAL@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logError(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.error(`ERROR@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.error(`ERROR@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logWarning(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.warn(`WARNING@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.warn(`WARNING@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    logInfo(methodName, description, variablesToLog) {\r\n        if (!this.isEnabled) {\r\n            return;\r\n        }\r\n        const logHeader = this.getLogHeader(methodName);\r\n        if (variablesToLog) {\r\n            console.info(`INFO@${logHeader}: ${description}`, variablesToLog);\r\n        }\r\n        else {\r\n            console.info(`INFO@${logHeader}: ${description}`);\r\n        }\r\n    }\r\n    enableLogging(isEnabled = true) {\r\n        this.isEnabled = isEnabled;\r\n    }\r\n    getLogHeader(methodName) {\r\n        return `${this.pluginName}.${this.serviceName}.${methodName}`;\r\n    }\r\n}\r\nexports["default"] = VxcpLogger;\r\n\n\n//# sourceURL=webpack://VBCPFREE/../../../../../core/vxcp-logger/src/vxcp-logger.ts?')},"./configuration/configurationApp.ts":function(__unused_webpack_module,exports,__webpack_require__){eval('\r\nvar __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    var desc = Object.getOwnPropertyDescriptor(m, k);\r\n    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {\r\n      desc = { enumerable: true, get: function() { return m[k]; } };\r\n    }\r\n    Object.defineProperty(o, k2, desc);\r\n}) : (function(o, m, k, k2) {\r\n    if (k2 === undefined) k2 = k;\r\n    o[k2] = m[k];\r\n}));\r\nvar __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {\r\n    Object.defineProperty(o, "default", { enumerable: true, value: v });\r\n}) : function(o, v) {\r\n    o["default"] = v;\r\n});\r\nvar __importStar = (this && this.__importStar) || function (mod) {\r\n    if (mod && mod.__esModule) return mod;\r\n    var result = {};\r\n    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);\r\n    __setModuleDefault(result, mod);\r\n    return result;\r\n};\r\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\r\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\r\n    return new (P || (P = Promise))(function (resolve, reject) {\r\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\r\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\r\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\r\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\r\n    });\r\n};\r\nvar __importDefault = (this && this.__importDefault) || function (mod) {\r\n    return (mod && mod.__esModule) ? mod : { "default": mod };\r\n};\r\nObject.defineProperty(exports, "__esModule", ({ value: true }));\r\nconst utils_1 = __webpack_require__("./common/utils.ts");\r\nconst notification_1 = __webpack_require__("./common/notification.ts");\r\nconst PluginNameService = __importStar(__webpack_require__("./common/plugin-name-service.ts"));\r\nconst vxcp_logger_1 = __importDefault(__webpack_require__("../../../../../core/vxcp-logger/src/vxcp-logger.ts"));\r\nconst vxcpLogger = new vxcp_logger_1.default(PluginNameService.pluginName, "ConfigurationApp");\r\nAJS.toInit(($) => __awaiter(void 0, void 0, void 0, function* () {\r\n    yield lazyLoadI18nTexts();\r\n    const $startMigrationBtn = $("#vbcp-mar-migration-input-start");\r\n    const $migrationLoading = $("#vbcp-mar-migration-loading");\r\n    const $migrationLoadingOverlay = $("#vbcp-mar-migration-loading-overlay");\r\n    function lazyLoadI18nTexts() {\r\n        return __awaiter(this, void 0, void 0, function* () {\r\n            yield new Promise((resolve) => {\r\n                AJS.I18n.get("de.viadee.confluence.bpmn-plugin", resolve);\r\n            });\r\n        });\r\n    }\r\n    function setMigrationRequest(migrationType) {\r\n        const xhr = new XMLHttpRequest();\r\n        xhr.open("GET", AJS.contextPath() + "/rest/bpmn-modeler/1.0/migration/" + migrationType + "/vbcp-macro", true);\r\n        xhr.onload = () => {\r\n            if (xhr.status >= 200 && xhr.status < 300) {\r\n                const heading = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.success");\r\n                const body = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.success.desc");\r\n                (0, notification_1.setSuccessMessage)(heading, body, true);\r\n                $startMigrationBtn.removeClass("loading");\r\n                $migrationLoading[0].style.visibility = "hidden";\r\n                $migrationLoadingOverlay[0].style.visibility = "hidden";\r\n            }\r\n            else {\r\n                vxcpLogger.logError("setMigrationRequest", "An error occurred while downgrading of BPMN diagrams. This could be due to diagrams embedded into page drafts.", xhr);\r\n                const heading2 = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.error");\r\n                const body2 = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.error.desc");\r\n                (0, notification_1.setErrorMessage)(heading2, body2, true);\r\n                $startMigrationBtn.removeClass("loading");\r\n                $migrationLoading[0].style.visibility = "hidden";\r\n                $migrationLoadingOverlay[0].style.visibility = "hidden";\r\n            }\r\n        };\r\n        xhr.onerror = () => {\r\n            vxcpLogger.logError("setMigrationRequest", "An error occurred while downgrading of BPMN diagrams. This could be due to diagrams embedded into page drafts.", xhr);\r\n            const heading = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.error");\r\n            const body = AJS.I18n.getText("de.viadee.confluence.bpmn-plugin.settings.configuration.migration.message.error.desc");\r\n            (0, notification_1.setErrorMessage)(heading, body, true);\r\n            $startMigrationBtn.removeClass("loading");\r\n            $migrationLoading[0].style.visibility = "hidden";\r\n            $migrationLoadingOverlay[0].style.visibility = "hidden";\r\n        };\r\n        xhr.send();\r\n    }\r\n    $startMigrationBtn.click((e) => {\r\n        e.stopPropagation();\r\n        e.preventDefault();\r\n        if ($startMigrationBtn.hasClass("loading")) {\r\n            return;\r\n        }\r\n        $startMigrationBtn.addClass("loading");\r\n        const migrationWarningDialog = Confluence.Templates.viadee.bpmnplugin.migrationWarningDialog;\r\n        (0, utils_1.showDialog)(AJS, "#vbcp-ent-dialog-migration-warning", migrationWarningDialog, () => {\r\n            $migrationLoading[0].style.visibility = "visible";\r\n            $migrationLoadingOverlay[0].style.visibility = "visible";\r\n            setMigrationRequest("migrateAllMacros");\r\n        }, () => {\r\n            $startMigrationBtn.removeClass("loading");\r\n        });\r\n    });\r\n}));\r\n\n\n//# sourceURL=webpack://VBCPFREE/./configuration/configurationApp.ts?')}},__webpack_module_cache__={},deferred;function __webpack_require__(e){var r=__webpack_module_cache__[e];if(void 0!==r)return r.exports;var n=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(n.exports,n,n.exports,__webpack_require__),n.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(e,r,n,i)=>{if(!r){var o=1/0;for(d=0;d<deferred.length;d++){for(var[r,n,i]=deferred[d],t=!0,a=0;a<r.length;a++)(!1&i||o>=i)&&Object.keys(__webpack_require__.O).every((e=>__webpack_require__.O[e](r[a])))?r.splice(a--,1):(t=!1,i<o&&(o=i));if(t){deferred.splice(d--,1);var s=n();void 0!==s&&(e=s)}}return e}i=i||0;for(var d=deferred.length;d>0&&deferred[d-1][2]>i;d--)deferred[d]=deferred[d-1];deferred[d]=[r,n,i]},__webpack_require__.o=(e,r)=>Object.prototype.hasOwnProperty.call(e,r),(()=>{var e={bpmnFreeAdmin:0};__webpack_require__.O.j=r=>0===e[r];var r=(r,n)=>{var i,o,[t,a,s]=n,d=0;if(t.some((r=>0!==e[r]))){for(i in a)__webpack_require__.o(a,i)&&(__webpack_require__.m[i]=a[i]);if(s)var l=s(__webpack_require__)}for(r&&r(n);d<t.length;d++)o=t[d],__webpack_require__.o(e,o)&&e[o]&&e[o][0](),e[o]=0;return __webpack_require__.O(l)},n=self.webpackChunkVBCPFREE=self.webpackChunkVBCPFREE||[];n.forEach(r.bind(null,0)),n.push=r.bind(null,n.push.bind(n))})();var __webpack_exports__=__webpack_require__.O(void 0,["bpmnFreeCommon"],(()=>__webpack_require__("./configuration/configurationApp.ts")));__webpack_exports__=__webpack_require__.O(__webpack_exports__),(window.VBCPFREE=window.VBCPFREE||{}).bpmnFreeAdmin=__webpack_exports__})();