/*
 * Decompiled with CFR 0.152.
 */
package de.viadee.confluence.bpmnplugin;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.user.User;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public final class DiagramEditorAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = -6639126960241769083L;
    private static final String FALSE = "false";
    private String pageId;
    private String diagramId;
    private String diagramName;
    private String lastNewsSeenDate;
    private boolean enterpriseLicense = false;
    private String userHasVoted = "false";
    private transient PersonalInformationManager personalInformationManager;
    private transient ContentPropertyManager contentPropertyManager;
    private transient PluginAccessor actionPluginAccessor;

    public DiagramEditorAction(PersonalInformationManager personalInformationManager, ContentPropertyManager contentPropertyManager, PluginAccessor pluginAccessor) {
        this.actionPluginAccessor = pluginAccessor;
        this.contentPropertyManager = contentPropertyManager;
        this.personalInformationManager = personalInformationManager;
    }

    public String execute() {
        ConfluenceUser confluenceUser;
        HttpServletRequest httpServletRequest = this.getCurrentRequest();
        if (httpServletRequest == null) {
            return "error";
        }
        this.pageId = httpServletRequest.getParameter("pageId");
        this.diagramId = httpServletRequest.getParameter("diagramId");
        this.diagramName = httpServletRequest.getParameter("diagramName");
        String string = httpServletRequest.getParameter("enterpriseLicense");
        if (StringUtils.isEmpty((CharSequence)this.pageId) || StringUtils.isEmpty((CharSequence)this.diagramId) || StringUtils.isEmpty((CharSequence)this.diagramName)) {
            return "error";
        }
        if (string.equals("VALID")) {
            this.enterpriseLicense = true;
        }
        if ((confluenceUser = AuthenticatedUserThreadLocal.get()) == null) {
            this.userHasVoted = FALSE;
            this.lastNewsSeenDate = "";
        } else {
            PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
            this.userHasVoted = this.contentPropertyManager.getStringProperty((ContentEntityObject)personalInformation, "key.userHasVoted");
            this.lastNewsSeenDate = this.contentPropertyManager.getStringProperty((ContentEntityObject)personalInformation, "key.last-news-seen-date");
            if (this.userHasVoted == null) {
                this.userHasVoted = FALSE;
                this.contentPropertyManager.setStringProperty((ContentEntityObject)personalInformation, "key.userHasVoted", this.userHasVoted);
            }
            if (this.lastNewsSeenDate == null) {
                this.lastNewsSeenDate = "";
            }
        }
        return "success";
    }

    public String getPageId() {
        return this.pageId;
    }

    public boolean getEnterpriseLicense() {
        return this.enterpriseLicense;
    }

    public String getDiagramId() {
        return this.diagramId;
    }

    public String getDiagramName() {
        return this.diagramName;
    }

    public String getUserHasVoted() {
        return this.userHasVoted;
    }

    public String getLastNewsSeenDate() {
        return this.lastNewsSeenDate;
    }

    public void setLastNewsSeenDate(String string) {
        this.lastNewsSeenDate = string;
    }

    public void setUserHasVotedDiagramName(String string) {
        this.userHasVoted = string;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.actionPluginAccessor = pluginAccessor;
    }

    public PluginAccessor getActionPluginAccessor() {
        return this.actionPluginAccessor;
    }

    public PersonalInformationManager getPersonalInformationManager() {
        return this.personalInformationManager;
    }

    public ContentPropertyManager getContentPropertyManager() {
        return this.contentPropertyManager;
    }

    public String getVendorName() {
        PluginInformation pluginInformation = this.getPluginInfo();
        if (pluginInformation == null) {
            return "";
        }
        return StringUtils.defaultString((String)pluginInformation.getVendorName());
    }

    public String getVendorUrl() {
        PluginInformation pluginInformation = this.getPluginInfo();
        if (pluginInformation == null) {
            return "";
        }
        return StringUtils.defaultString((String)pluginInformation.getVendorUrl());
    }

    public String getPluginVersion() {
        PluginInformation pluginInformation = this.getPluginInfo();
        if (pluginInformation == null) {
            return "";
        }
        return StringUtils.defaultString((String)pluginInformation.getVersion());
    }

    private PluginInformation getPluginInfo() {
        if (this.actionPluginAccessor == null) {
            return null;
        }
        Plugin plugin = this.actionPluginAccessor.getPlugin("de.viadee.confluence.bpmn-plugin");
        if (plugin == null) {
            return null;
        }
        return plugin.getPluginInformation();
    }
}

